// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCommentInput struct {
	_ struct{} `type:"structure"`

	// The unique, system-generated ID of the comment. To get this ID, use GetCommentsForComparedCommit
	// or GetCommentsForPullRequest.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCommentInput"}

	if s.CommentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCommentOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the comment.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s GetCommentOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetComment = "GetComment"

// GetCommentRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Returns the content of a comment made on a change, file, or commit in a repository.
//
// Reaction counts might include numbers from user identities who were deleted
// after the reaction was made. For a count of reactions from active identities,
// use GetCommentReactions.
//
//    // Example sending a request using GetCommentRequest.
//    req := client.GetCommentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment
func (c *Client) GetCommentRequest(input *GetCommentInput) GetCommentRequest {
	op := &aws.Operation{
		Name:       opGetComment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommentInput{}
	}

	req := c.newRequest(op, input, &GetCommentOutput{})

	return GetCommentRequest{Request: req, Input: input, Copy: c.GetCommentRequest}
}

// GetCommentRequest is the request type for the
// GetComment API operation.
type GetCommentRequest struct {
	*aws.Request
	Input *GetCommentInput
	Copy  func(*GetCommentInput) GetCommentRequest
}

// Send marshals and sends the GetComment API request.
func (r GetCommentRequest) Send(ctx context.Context) (*GetCommentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCommentResponse{
		GetCommentOutput: r.Request.Data.(*GetCommentOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCommentResponse is the response type for the
// GetComment API operation.
type GetCommentResponse struct {
	*GetCommentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetComment request.
func (r *GetCommentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
