// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EvaluatePullRequestApprovalRulesInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request you want to evaluate.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The system-generated ID for the pull request revision. To retrieve the most
	// recent revision ID for a pull request, use GetPullRequest.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s EvaluatePullRequestApprovalRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluatePullRequestApprovalRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EvaluatePullRequestApprovalRulesInput"}

	if s.PullRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PullRequestId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EvaluatePullRequestApprovalRulesOutput struct {
	_ struct{} `type:"structure"`

	// The result of the evaluation, including the names of the rules whose conditions
	// have been met (if any), the names of the rules whose conditions have not
	// been met (if any), whether the pull request is in the approved state, and
	// whether the pull request approval rule has been set aside by an override.
	//
	// Evaluation is a required field
	Evaluation *Evaluation `locationName:"evaluation" type:"structure" required:"true"`
}

// String returns the string representation
func (s EvaluatePullRequestApprovalRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opEvaluatePullRequestApprovalRules = "EvaluatePullRequestApprovalRules"

// EvaluatePullRequestApprovalRulesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Evaluates whether a pull request has met all the conditions specified in
// its associated approval rules.
//
//    // Example sending a request using EvaluatePullRequestApprovalRulesRequest.
//    req := client.EvaluatePullRequestApprovalRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/EvaluatePullRequestApprovalRules
func (c *Client) EvaluatePullRequestApprovalRulesRequest(input *EvaluatePullRequestApprovalRulesInput) EvaluatePullRequestApprovalRulesRequest {
	op := &aws.Operation{
		Name:       opEvaluatePullRequestApprovalRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EvaluatePullRequestApprovalRulesInput{}
	}

	req := c.newRequest(op, input, &EvaluatePullRequestApprovalRulesOutput{})

	return EvaluatePullRequestApprovalRulesRequest{Request: req, Input: input, Copy: c.EvaluatePullRequestApprovalRulesRequest}
}

// EvaluatePullRequestApprovalRulesRequest is the request type for the
// EvaluatePullRequestApprovalRules API operation.
type EvaluatePullRequestApprovalRulesRequest struct {
	*aws.Request
	Input *EvaluatePullRequestApprovalRulesInput
	Copy  func(*EvaluatePullRequestApprovalRulesInput) EvaluatePullRequestApprovalRulesRequest
}

// Send marshals and sends the EvaluatePullRequestApprovalRules API request.
func (r EvaluatePullRequestApprovalRulesRequest) Send(ctx context.Context) (*EvaluatePullRequestApprovalRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EvaluatePullRequestApprovalRulesResponse{
		EvaluatePullRequestApprovalRulesOutput: r.Request.Data.(*EvaluatePullRequestApprovalRulesOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EvaluatePullRequestApprovalRulesResponse is the response type for the
// EvaluatePullRequestApprovalRules API operation.
type EvaluatePullRequestApprovalRulesResponse struct {
	*EvaluatePullRequestApprovalRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EvaluatePullRequestApprovalRules request.
func (r *EvaluatePullRequestApprovalRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
