// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted resource policy. For more information, see Sharing a Project
	// (https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share)
	// and Sharing a Report Group (https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share)
	// in the AWS CodeBuild User Guide.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`

	// The ARN of the Project or ReportGroup resource you want to associate with
	// a resource policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutResourcePolicyInput"}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Project or ReportGroup resource that is associated with a
	// resource policy.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`
}

// String returns the string representation
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Stores a resource policy for the ARN of a Project or ReportGroup object.
//
//    // Example sending a request using PutResourcePolicyRequest.
//    req := client.PutResourcePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PutResourcePolicy
func (c *Client) PutResourcePolicyRequest(input *PutResourcePolicyInput) PutResourcePolicyRequest {
	op := &aws.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	req := c.newRequest(op, input, &PutResourcePolicyOutput{})

	return PutResourcePolicyRequest{Request: req, Input: input, Copy: c.PutResourcePolicyRequest}
}

// PutResourcePolicyRequest is the request type for the
// PutResourcePolicy API operation.
type PutResourcePolicyRequest struct {
	*aws.Request
	Input *PutResourcePolicyInput
	Copy  func(*PutResourcePolicyInput) PutResourcePolicyRequest
}

// Send marshals and sends the PutResourcePolicy API request.
func (r PutResourcePolicyRequest) Send(ctx context.Context) (*PutResourcePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutResourcePolicyResponse{
		PutResourcePolicyOutput: r.Request.Data.(*PutResourcePolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutResourcePolicyResponse is the response type for the
// PutResourcePolicy API operation.
type PutResourcePolicyResponse struct {
	*PutResourcePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutResourcePolicy request.
func (r *PutResourcePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
