// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPackageVersionAssetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository associated with the package
	// version assets.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package that contains the returned package version assets.
	// The valid package types are:
	//
	//    * npm: A Node Package Manager (npm) package.
	//
	//    * pypi: A Python Package Index (PyPI) package.
	//
	//    * maven: A Maven package that contains compiled code in a distributable
	//    format, such as a JAR file.
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the package that contains the returned package version assets.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package that contains the returned
	// package version assets.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPackageVersionAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionAssetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPackageVersionAssetsInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.PackageVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageVersion", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionAssetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageVersion != nil {
		v := *s.PackageVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListPackageVersionAssetsOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of AssetSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html)
	// objects.
	Assets []AssetSummary `locationName:"assets" type:"list"`

	// The format of the package that contains the returned package version assets.
	Format PackageFormat `locationName:"format" type:"string" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package that contains the returned package version assets.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The version of the package associated with the returned assets.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation
func (s ListPackageVersionAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionAssetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Assets != nil {
		v := s.Assets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionRevision != nil {
		v := *s.VersionRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionRevision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListPackageVersionAssets = "ListPackageVersionAssets"

// ListPackageVersionAssetsRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns a list of AssetSummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html)
// objects for assets in a package version.
//
//    // Example sending a request using ListPackageVersionAssetsRequest.
//    req := client.ListPackageVersionAssetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets
func (c *Client) ListPackageVersionAssetsRequest(input *ListPackageVersionAssetsInput) ListPackageVersionAssetsRequest {
	op := &aws.Operation{
		Name:       opListPackageVersionAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/version/assets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackageVersionAssetsInput{}
	}

	req := c.newRequest(op, input, &ListPackageVersionAssetsOutput{})

	return ListPackageVersionAssetsRequest{Request: req, Input: input, Copy: c.ListPackageVersionAssetsRequest}
}

// ListPackageVersionAssetsRequest is the request type for the
// ListPackageVersionAssets API operation.
type ListPackageVersionAssetsRequest struct {
	*aws.Request
	Input *ListPackageVersionAssetsInput
	Copy  func(*ListPackageVersionAssetsInput) ListPackageVersionAssetsRequest
}

// Send marshals and sends the ListPackageVersionAssets API request.
func (r ListPackageVersionAssetsRequest) Send(ctx context.Context) (*ListPackageVersionAssetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPackageVersionAssetsResponse{
		ListPackageVersionAssetsOutput: r.Request.Data.(*ListPackageVersionAssetsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPackageVersionAssetsRequestPaginator returns a paginator for ListPackageVersionAssets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPackageVersionAssetsRequest(input)
//   p := codeartifact.NewListPackageVersionAssetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPackageVersionAssetsPaginator(req ListPackageVersionAssetsRequest) ListPackageVersionAssetsPaginator {
	return ListPackageVersionAssetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPackageVersionAssetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPackageVersionAssetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPackageVersionAssetsPaginator struct {
	aws.Pager
}

func (p *ListPackageVersionAssetsPaginator) CurrentPage() *ListPackageVersionAssetsOutput {
	return p.Pager.CurrentPage().(*ListPackageVersionAssetsOutput)
}

// ListPackageVersionAssetsResponse is the response type for the
// ListPackageVersionAssets API operation.
type ListPackageVersionAssetsResponse struct {
	*ListPackageVersionAssetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPackageVersionAssets request.
func (r *ListPackageVersionAssetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
