// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAuthorizationTokenInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that is in scope for the generated authorization token.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The time, in seconds, that the generated authorization token is valid.
	DurationSeconds *int64 `location:"querystring" locationName:"duration" type:"long"`
}

// String returns the string representation
func (s GetAuthorizationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizationTokenInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAuthorizationTokenInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAuthorizationTokenInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DurationSeconds != nil {
		v := *s.DurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "duration", protocol.Int64Value(v), metadata)
	}
	return nil
}

type GetAuthorizationTokenOutput struct {
	_ struct{} `type:"structure"`

	// The returned authentication token.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// A timestamp that specifies the date and time the authorization token expires.
	Expiration *time.Time `locationName:"expiration" type:"timestamp"`
}

// String returns the string representation
func (s GetAuthorizationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAuthorizationTokenOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizationToken != nil {
		v := *s.AuthorizationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expiration != nil {
		v := *s.Expiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expiration",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opGetAuthorizationToken = "GetAuthorizationToken"

// GetAuthorizationTokenRequest returns a request value for making API operation for
// CodeArtifact.
//
// Generates a temporary authentication token for accessing repositories in
// the domain. This API requires the codeartifact:GetAuthorizationToken and
// sts:GetServiceBearerToken permissions.
//
// CodeArtifact authorization tokens are valid for a period of 12 hours when
// created with the login command. You can call login periodically to refresh
// the token. When you create an authorization token with the GetAuthorizationToken
// API, you can set a custom authorization period, up to a maximum of 12 hours,
// with the durationSeconds parameter.
//
// The authorization period begins after login or GetAuthorizationToken is called.
// If login or GetAuthorizationToken is called while assuming a role, the token
// lifetime is independent of the maximum session duration of the role. For
// example, if you call sts assume-role and specify a session duration of 15
// minutes, then generate a CodeArtifact authorization token, the token will
// be valid for the full authorization period even though this is longer than
// the 15-minute session duration.
//
// See Using IAM Roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
// for more information on controlling session duration.
//
//    // Example sending a request using GetAuthorizationTokenRequest.
//    req := client.GetAuthorizationTokenRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetAuthorizationToken
func (c *Client) GetAuthorizationTokenRequest(input *GetAuthorizationTokenInput) GetAuthorizationTokenRequest {
	op := &aws.Operation{
		Name:       opGetAuthorizationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/authorization-token",
	}

	if input == nil {
		input = &GetAuthorizationTokenInput{}
	}

	req := c.newRequest(op, input, &GetAuthorizationTokenOutput{})

	return GetAuthorizationTokenRequest{Request: req, Input: input, Copy: c.GetAuthorizationTokenRequest}
}

// GetAuthorizationTokenRequest is the request type for the
// GetAuthorizationToken API operation.
type GetAuthorizationTokenRequest struct {
	*aws.Request
	Input *GetAuthorizationTokenInput
	Copy  func(*GetAuthorizationTokenInput) GetAuthorizationTokenRequest
}

// Send marshals and sends the GetAuthorizationToken API request.
func (r GetAuthorizationTokenRequest) Send(ctx context.Context) (*GetAuthorizationTokenResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAuthorizationTokenResponse{
		GetAuthorizationTokenOutput: r.Request.Data.(*GetAuthorizationTokenOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAuthorizationTokenResponse is the response type for the
// GetAuthorizationToken API operation.
type GetAuthorizationTokenResponse struct {
	*GetAuthorizationTokenOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAuthorizationToken request.
func (r *GetAuthorizationTokenResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
