// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeDomainEndpointOptions operation.
// Specify the name of the domain you want to describe. To show the active configuration
// and exclude any pending changes, set the Deployed option to true.
type DescribeDomainEndpointOptionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to retrieve the latest configuration (which might be in a Processing
	// state) or the current, active configuration. Defaults to false.
	Deployed *bool `type:"boolean"`

	// A string that represents the name of a domain.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainEndpointOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainEndpointOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDomainEndpointOptionsInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeDomainEndpointOptions request. Contains the status
// and configuration of a search domain's endpoint options.
type DescribeDomainEndpointOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of a search domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeDomainEndpointOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDomainEndpointOptions = "DescribeDomainEndpointOptions"

// DescribeDomainEndpointOptionsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Returns the domain's endpoint options, specifically whether all requests
// to the domain must arrive over HTTPS. For more information, see Configuring
// Domain Endpoint Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeDomainEndpointOptionsRequest.
//    req := client.DescribeDomainEndpointOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeDomainEndpointOptionsRequest(input *DescribeDomainEndpointOptionsInput) DescribeDomainEndpointOptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeDomainEndpointOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainEndpointOptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeDomainEndpointOptionsOutput{})

	return DescribeDomainEndpointOptionsRequest{Request: req, Input: input, Copy: c.DescribeDomainEndpointOptionsRequest}
}

// DescribeDomainEndpointOptionsRequest is the request type for the
// DescribeDomainEndpointOptions API operation.
type DescribeDomainEndpointOptionsRequest struct {
	*aws.Request
	Input *DescribeDomainEndpointOptionsInput
	Copy  func(*DescribeDomainEndpointOptionsInput) DescribeDomainEndpointOptionsRequest
}

// Send marshals and sends the DescribeDomainEndpointOptions API request.
func (r DescribeDomainEndpointOptionsRequest) Send(ctx context.Context) (*DescribeDomainEndpointOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDomainEndpointOptionsResponse{
		DescribeDomainEndpointOptionsOutput: r.Request.Data.(*DescribeDomainEndpointOptionsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDomainEndpointOptionsResponse is the response type for the
// DescribeDomainEndpointOptions API operation.
type DescribeDomainEndpointOptionsResponse struct {
	*DescribeDomainEndpointOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDomainEndpointOptions request.
func (r *DescribeDomainEndpointOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
