// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the CreateDomain operation. Specifies a name
// for the new search domain.
type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// A name for the domain you are creating. Allowed characters are a-z (lower-case
	// letters), 0-9, and hyphen (-). Domain names must start with a letter or number
	// and be at least 3 and no more than 28 characters long.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a CreateDomainRequest. Contains the status of a newly created
// domain.
type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Creates a new search domain. For more information, see Creating a Search
// Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using CreateDomainRequest.
//    req := client.CreateDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateDomainRequest(input *CreateDomainInput) CreateDomainRequest {
	op := &aws.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	req := c.newRequest(op, input, &CreateDomainOutput{})

	return CreateDomainRequest{Request: req, Input: input, Copy: c.CreateDomainRequest}
}

// CreateDomainRequest is the request type for the
// CreateDomain API operation.
type CreateDomainRequest struct {
	*aws.Request
	Input *CreateDomainInput
	Copy  func(*CreateDomainInput) CreateDomainRequest
}

// Send marshals and sends the CreateDomain API request.
func (r CreateDomainRequest) Send(ctx context.Context) (*CreateDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDomainResponse{
		CreateDomainOutput: r.Request.Data.(*CreateDomainOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDomainResponse is the response type for the
// CreateDomain API operation.
type CreateDomainResponse struct {
	*CreateDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDomain request.
func (r *CreateDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
