// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudhsmv2iface provides an interface to enable mocking the AWS CloudHSM V2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudhsmv2iface

import (
	"github.com/aws/aws-sdk-go-v2/service/cloudhsmv2"
)

// ClientAPI provides an interface to enable mocking the
// cloudhsmv2.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CloudHSM V2.
//    func myFunc(svc cloudhsmv2iface.ClientAPI) bool {
//        // Make svc.CopyBackupToRegion request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cloudhsmv2.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cloudhsmv2iface.ClientPI
//    }
//    func (m *mockClientClient) CopyBackupToRegion(input *cloudhsmv2.CopyBackupToRegionInput) (*cloudhsmv2.CopyBackupToRegionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CopyBackupToRegionRequest(*cloudhsmv2.CopyBackupToRegionInput) cloudhsmv2.CopyBackupToRegionRequest

	CreateClusterRequest(*cloudhsmv2.CreateClusterInput) cloudhsmv2.CreateClusterRequest

	CreateHsmRequest(*cloudhsmv2.CreateHsmInput) cloudhsmv2.CreateHsmRequest

	DeleteBackupRequest(*cloudhsmv2.DeleteBackupInput) cloudhsmv2.DeleteBackupRequest

	DeleteClusterRequest(*cloudhsmv2.DeleteClusterInput) cloudhsmv2.DeleteClusterRequest

	DeleteHsmRequest(*cloudhsmv2.DeleteHsmInput) cloudhsmv2.DeleteHsmRequest

	DescribeBackupsRequest(*cloudhsmv2.DescribeBackupsInput) cloudhsmv2.DescribeBackupsRequest

	DescribeClustersRequest(*cloudhsmv2.DescribeClustersInput) cloudhsmv2.DescribeClustersRequest

	InitializeClusterRequest(*cloudhsmv2.InitializeClusterInput) cloudhsmv2.InitializeClusterRequest

	ListTagsRequest(*cloudhsmv2.ListTagsInput) cloudhsmv2.ListTagsRequest

	RestoreBackupRequest(*cloudhsmv2.RestoreBackupInput) cloudhsmv2.RestoreBackupRequest

	TagResourceRequest(*cloudhsmv2.TagResourceInput) cloudhsmv2.TagResourceRequest

	UntagResourceRequest(*cloudhsmv2.UntagResourceInput) cloudhsmv2.UntagResourceRequest
}

var _ ClientAPI = (*cloudhsmv2.Client)(nil)
