// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information about a backup of an AWS CloudHSM cluster. All backup
// objects contain the BackupId, BackupState, ClusterId, and CreateTimestamp
// parameters. Backups that were copied into a destination region additionally
// contain the CopyTimestamp, SourceBackup, SourceCluster, and SourceRegion
// paramters. A backup that is pending deletion will include the DeleteTimestamp
// parameter.
type Backup struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the backup.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`

	// The state of the backup.
	BackupState BackupState `type:"string" enum:"true"`

	// The identifier (ID) of the cluster that was backed up.
	ClusterId *string `type:"string"`

	// The date and time when the backup was copied from a source backup.
	CopyTimestamp *time.Time `type:"timestamp"`

	// The date and time when the backup was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The date and time when the backup will be permanently deleted.
	DeleteTimestamp *time.Time `type:"timestamp"`

	// The identifier (ID) of the source backup from which the new backup was copied.
	SourceBackup *string `type:"string"`

	// The identifier (ID) of the cluster containing the source backup from which
	// the new backup was copied.
	SourceCluster *string `type:"string"`

	// The AWS Region that contains the source backup from which the new backup
	// was copied.
	SourceRegion *string `type:"string"`

	// The list of tags for the backup.
	TagList []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// Contains one or more certificates or a certificate signing request (CSR).
type Certificates struct {
	_ struct{} `type:"structure"`

	// The HSM hardware certificate issued (signed) by AWS CloudHSM.
	AwsHardwareCertificate *string `type:"string"`

	// The cluster certificate issued (signed) by the issuing certificate authority
	// (CA) of the cluster's owner.
	ClusterCertificate *string `type:"string"`

	// The cluster's certificate signing request (CSR). The CSR exists only when
	// the cluster's state is UNINITIALIZED.
	ClusterCsr *string `type:"string"`

	// The HSM certificate issued (signed) by the HSM hardware.
	HsmCertificate *string `type:"string"`

	// The HSM hardware certificate issued (signed) by the hardware manufacturer.
	ManufacturerHardwareCertificate *string `type:"string"`
}

// String returns the string representation
func (s Certificates) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an AWS CloudHSM cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The cluster's backup policy.
	BackupPolicy BackupPolicy `type:"string" enum:"true"`

	// Contains one or more certificates or a certificate signing request (CSR).
	Certificates *Certificates `type:"structure"`

	// The cluster's identifier (ID).
	ClusterId *string `type:"string"`

	// The date and time when the cluster was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The type of HSM that the cluster contains.
	HsmType *string `type:"string"`

	// Contains information about the HSMs in the cluster.
	Hsms []Hsm `type:"list"`

	// The default password for the cluster's Pre-Crypto Officer (PRECO) user.
	PreCoPassword *string `min:"7" type:"string"`

	// The identifier (ID) of the cluster's security group.
	SecurityGroup *string `type:"string"`

	// The identifier (ID) of the backup used to create the cluster. This value
	// exists only when the cluster was created from a backup.
	SourceBackupId *string `type:"string"`

	// The cluster's state.
	State ClusterState `type:"string" enum:"true"`

	// A description of the cluster's state.
	StateMessage *string `type:"string"`

	// A map from availability zone to the cluster’s subnet in that availability
	// zone.
	SubnetMapping map[string]string `type:"map"`

	// The list of tags for the cluster.
	TagList []Tag `min:"1" type:"list"`

	// The identifier (ID) of the virtual private cloud (VPC) that contains the
	// cluster.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the backup that will be copied and created by
// the CopyBackupToRegion operation.
type DestinationBackup struct {
	_ struct{} `type:"structure"`

	// The date and time when both the source backup was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The identifier (ID) of the source backup from which the new backup was copied.
	SourceBackup *string `type:"string"`

	// The identifier (ID) of the cluster containing the source backup from which
	// the new backup was copied.
	SourceCluster *string `type:"string"`

	// The AWS region that contains the source backup from which the new backup
	// was copied.
	SourceRegion *string `type:"string"`
}

// String returns the string representation
func (s DestinationBackup) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a hardware security module (HSM) in an AWS CloudHSM
// cluster.
type Hsm struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that contains the HSM.
	AvailabilityZone *string `type:"string"`

	// The identifier (ID) of the cluster that contains the HSM.
	ClusterId *string `type:"string"`

	// The identifier (ID) of the HSM's elastic network interface (ENI).
	EniId *string `type:"string"`

	// The IP address of the HSM's elastic network interface (ENI).
	EniIp *string `type:"string"`

	// The HSM's identifier (ID).
	//
	// HsmId is a required field
	HsmId *string `type:"string" required:"true"`

	// The HSM's state.
	State HsmState `type:"string" enum:"true"`

	// A description of the HSM's state.
	StateMessage *string `type:"string"`

	// The subnet that contains the HSM's elastic network interface (ENI).
	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s Hsm) String() string {
	return awsutil.Prettify(s)
}

// Contains a tag. A tag is a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
