// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateOriginRequestPolicyInput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicyConfig"`

	// The unique identifier for the origin request policy that you are updating.
	// The identifier is returned in a cache behavior’s OriginRequestPolicyId
	// field in the response to GetDistributionConfig.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the origin request policy that you are updating. The version
	// is returned in the origin request policy’s ETag field in the response to
	// GetOriginRequestPolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// An origin request policy configuration.
	//
	// OriginRequestPolicyConfig is a required field
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `locationName:"OriginRequestPolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UpdateOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOriginRequestPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateOriginRequestPolicyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.OriginRequestPolicyConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OriginRequestPolicyConfig"))
	}
	if s.OriginRequestPolicyConfig != nil {
		if err := s.OriginRequestPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("OriginRequestPolicyConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateOriginRequestPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.OriginRequestPolicyConfig != nil {
		v := s.OriginRequestPolicyConfig

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2020-05-31/"}
		e.SetFields(protocol.PayloadTarget, "OriginRequestPolicyConfig", v, metadata)
	}
	return nil
}

type UpdateOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicy"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// An origin request policy.
	OriginRequestPolicy *OriginRequestPolicy `type:"structure"`
}

// String returns the string representation
func (s UpdateOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateOriginRequestPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.OriginRequestPolicy != nil {
		v := s.OriginRequestPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "OriginRequestPolicy", v, metadata)
	}
	return nil
}

const opUpdateOriginRequestPolicy = "UpdateOriginRequestPolicy2020_05_31"

// UpdateOriginRequestPolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Updates an origin request policy configuration.
//
// When you update an origin request policy configuration, all the fields are
// updated with the values provided in the request. You cannot update some fields
// independent of others. To update an origin request policy configuration:
//
// Use GetOriginRequestPolicyConfig to get the current configuration.
//
// Locally modify the fields in the origin request policy configuration that
// you want to update.
//
// Call UpdateOriginRequestPolicy by providing the entire origin request policy
// configuration, including the fields that you modified and those that you
// didn’t.
//
//    // Example sending a request using UpdateOriginRequestPolicyRequest.
//    req := client.UpdateOriginRequestPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy
func (c *Client) UpdateOriginRequestPolicyRequest(input *UpdateOriginRequestPolicyInput) UpdateOriginRequestPolicyRequest {
	op := &aws.Operation{
		Name:       opUpdateOriginRequestPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &UpdateOriginRequestPolicyInput{}
	}

	req := c.newRequest(op, input, &UpdateOriginRequestPolicyOutput{})

	return UpdateOriginRequestPolicyRequest{Request: req, Input: input, Copy: c.UpdateOriginRequestPolicyRequest}
}

// UpdateOriginRequestPolicyRequest is the request type for the
// UpdateOriginRequestPolicy API operation.
type UpdateOriginRequestPolicyRequest struct {
	*aws.Request
	Input *UpdateOriginRequestPolicyInput
	Copy  func(*UpdateOriginRequestPolicyInput) UpdateOriginRequestPolicyRequest
}

// Send marshals and sends the UpdateOriginRequestPolicy API request.
func (r UpdateOriginRequestPolicyRequest) Send(ctx context.Context) (*UpdateOriginRequestPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateOriginRequestPolicyResponse{
		UpdateOriginRequestPolicyOutput: r.Request.Data.(*UpdateOriginRequestPolicyOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateOriginRequestPolicyResponse is the response type for the
// UpdateOriginRequestPolicy API operation.
type UpdateOriginRequestPolicyResponse struct {
	*UpdateOriginRequestPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateOriginRequestPolicy request.
func (r *UpdateOriginRequestPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
