// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListOriginRequestPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of origin request policies. The response includes origin request policies
	// in the list that occur after the marker. To get the next page of the list,
	// set this field’s value to the value of NextMarker from the current page’s
	// response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of origin request policies that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// A filter to return only the specified kinds of origin request policies. Valid
	// values are:
	//
	//    * managed – Returns only the managed policies created by AWS.
	//
	//    * custom – Returns only the custom policies created in your AWS account.
	Type OriginRequestPolicyType `location:"querystring" locationName:"Type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListOriginRequestPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOriginRequestPoliciesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Type", v, metadata)
	}
	return nil
}

type ListOriginRequestPoliciesOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicyList"`

	// A list of origin request policies.
	OriginRequestPolicyList *OriginRequestPolicyList `type:"structure"`
}

// String returns the string representation
func (s ListOriginRequestPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOriginRequestPoliciesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.OriginRequestPolicyList != nil {
		v := s.OriginRequestPolicyList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "OriginRequestPolicyList", v, metadata)
	}
	return nil
}

const opListOriginRequestPolicies = "ListOriginRequestPolicies2020_05_31"

// ListOriginRequestPoliciesRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets a list of origin request policies.
//
// You can optionally apply a filter to return only the managed policies created
// by AWS, or only the custom policies created in your AWS account.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
//    // Example sending a request using ListOriginRequestPoliciesRequest.
//    req := client.ListOriginRequestPoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies
func (c *Client) ListOriginRequestPoliciesRequest(input *ListOriginRequestPoliciesInput) ListOriginRequestPoliciesRequest {
	op := &aws.Operation{
		Name:       opListOriginRequestPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy",
	}

	if input == nil {
		input = &ListOriginRequestPoliciesInput{}
	}

	req := c.newRequest(op, input, &ListOriginRequestPoliciesOutput{})

	return ListOriginRequestPoliciesRequest{Request: req, Input: input, Copy: c.ListOriginRequestPoliciesRequest}
}

// ListOriginRequestPoliciesRequest is the request type for the
// ListOriginRequestPolicies API operation.
type ListOriginRequestPoliciesRequest struct {
	*aws.Request
	Input *ListOriginRequestPoliciesInput
	Copy  func(*ListOriginRequestPoliciesInput) ListOriginRequestPoliciesRequest
}

// Send marshals and sends the ListOriginRequestPolicies API request.
func (r ListOriginRequestPoliciesRequest) Send(ctx context.Context) (*ListOriginRequestPoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOriginRequestPoliciesResponse{
		ListOriginRequestPoliciesOutput: r.Request.Data.(*ListOriginRequestPoliciesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListOriginRequestPoliciesResponse is the response type for the
// ListOriginRequestPolicies API operation.
type ListOriginRequestPoliciesResponse struct {
	*ListOriginRequestPoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOriginRequestPolicies request.
func (r *ListOriginRequestPoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
