// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListCachePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of cache policies. The response includes cache policies in the list
	// that occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of cache policies that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// A filter to return only the specified kinds of cache policies. Valid values
	// are:
	//
	//    * managed – Returns only the managed policies created by AWS.
	//
	//    * custom – Returns only the custom policies created in your AWS account.
	Type CachePolicyType `location:"querystring" locationName:"Type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListCachePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCachePoliciesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Type", v, metadata)
	}
	return nil
}

type ListCachePoliciesOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicyList"`

	// A list of cache policies.
	CachePolicyList *CachePolicyList `type:"structure"`
}

// String returns the string representation
func (s ListCachePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCachePoliciesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CachePolicyList != nil {
		v := s.CachePolicyList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CachePolicyList", v, metadata)
	}
	return nil
}

const opListCachePolicies = "ListCachePolicies2020_05_31"

// ListCachePoliciesRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets a list of cache policies.
//
// You can optionally apply a filter to return only the managed policies created
// by AWS, or only the custom policies created in your AWS account.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
//    // Example sending a request using ListCachePoliciesRequest.
//    req := client.ListCachePoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies
func (c *Client) ListCachePoliciesRequest(input *ListCachePoliciesInput) ListCachePoliciesRequest {
	op := &aws.Operation{
		Name:       opListCachePolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy",
	}

	if input == nil {
		input = &ListCachePoliciesInput{}
	}

	req := c.newRequest(op, input, &ListCachePoliciesOutput{})

	return ListCachePoliciesRequest{Request: req, Input: input, Copy: c.ListCachePoliciesRequest}
}

// ListCachePoliciesRequest is the request type for the
// ListCachePolicies API operation.
type ListCachePoliciesRequest struct {
	*aws.Request
	Input *ListCachePoliciesInput
	Copy  func(*ListCachePoliciesInput) ListCachePoliciesRequest
}

// Send marshals and sends the ListCachePolicies API request.
func (r ListCachePoliciesRequest) Send(ctx context.Context) (*ListCachePoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCachePoliciesResponse{
		ListCachePoliciesOutput: r.Request.Data.(*ListCachePoliciesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListCachePoliciesResponse is the response type for the
// ListCachePolicies API operation.
type ListCachePoliciesResponse struct {
	*ListCachePoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCachePolicies request.
func (r *ListCachePoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
