// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListObjectParentPathsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to which the parent path applies.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose parent paths are listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListObjectParentPathsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectParentPathsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListObjectParentPathsInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectParentPathsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListObjectParentPathsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns the path to the ObjectIdentifiers that are associated with the directory.
	PathToObjectIdentifiersList []PathToObjectIdentifiers `type:"list"`
}

// String returns the string representation
func (s ListObjectParentPathsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListObjectParentPathsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PathToObjectIdentifiersList != nil {
		v := s.PathToObjectIdentifiersList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PathToObjectIdentifiersList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListObjectParentPaths = "ListObjectParentPaths"

// ListObjectParentPathsRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Retrieves all available parent paths for any object type such as node, leaf
// node, policy node, and index node objects. For more information about objects,
// see Directory Structure (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
//
// Use this API to evaluate all parents for an object. The call returns all
// objects from the root of the directory up to the requested object. The API
// returns the number of paths based on user-defined MaxResults, in case there
// are multiple paths to the parent. The order of the paths and nodes returned
// is consistent among multiple API calls unless the objects are deleted or
// moved. Paths not leading to the directory root are ignored from the target
// object.
//
//    // Example sending a request using ListObjectParentPathsRequest.
//    req := client.ListObjectParentPathsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths
func (c *Client) ListObjectParentPathsRequest(input *ListObjectParentPathsInput) ListObjectParentPathsRequest {
	op := &aws.Operation{
		Name:       opListObjectParentPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/parentpaths",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectParentPathsInput{}
	}

	req := c.newRequest(op, input, &ListObjectParentPathsOutput{})

	return ListObjectParentPathsRequest{Request: req, Input: input, Copy: c.ListObjectParentPathsRequest}
}

// ListObjectParentPathsRequest is the request type for the
// ListObjectParentPaths API operation.
type ListObjectParentPathsRequest struct {
	*aws.Request
	Input *ListObjectParentPathsInput
	Copy  func(*ListObjectParentPathsInput) ListObjectParentPathsRequest
}

// Send marshals and sends the ListObjectParentPaths API request.
func (r ListObjectParentPathsRequest) Send(ctx context.Context) (*ListObjectParentPathsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListObjectParentPathsResponse{
		ListObjectParentPathsOutput: r.Request.Data.(*ListObjectParentPathsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListObjectParentPathsRequestPaginator returns a paginator for ListObjectParentPaths.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListObjectParentPathsRequest(input)
//   p := clouddirectory.NewListObjectParentPathsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListObjectParentPathsPaginator(req ListObjectParentPathsRequest) ListObjectParentPathsPaginator {
	return ListObjectParentPathsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListObjectParentPathsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListObjectParentPathsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListObjectParentPathsPaginator struct {
	aws.Pager
}

func (p *ListObjectParentPathsPaginator) CurrentPage() *ListObjectParentPathsOutput {
	return p.Pager.CurrentPage().(*ListObjectParentPathsOutput)
}

// ListObjectParentPathsResponse is the response type for the
// ListObjectParentPaths API operation.
type ListObjectParentPathsResponse struct {
	*ListObjectParentPathsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListObjectParentPaths request.
func (r *ListObjectParentPathsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
