// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type EnableDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to enable.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableDirectoryInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableDirectoryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type EnableDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the enabled directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableDirectoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opEnableDirectory = "EnableDirectory"

// EnableDirectoryRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Enables the specified directory. Only disabled directories can be enabled.
// Once enabled, the directory can then be read and written to.
//
//    // Example sending a request using EnableDirectoryRequest.
//    req := client.EnableDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/EnableDirectory
func (c *Client) EnableDirectoryRequest(input *EnableDirectoryInput) EnableDirectoryRequest {
	op := &aws.Operation{
		Name:       opEnableDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/enable",
	}

	if input == nil {
		input = &EnableDirectoryInput{}
	}

	req := c.newRequest(op, input, &EnableDirectoryOutput{})

	return EnableDirectoryRequest{Request: req, Input: input, Copy: c.EnableDirectoryRequest}
}

// EnableDirectoryRequest is the request type for the
// EnableDirectory API operation.
type EnableDirectoryRequest struct {
	*aws.Request
	Input *EnableDirectoryInput
	Copy  func(*EnableDirectoryInput) EnableDirectoryRequest
}

// Send marshals and sends the EnableDirectory API request.
func (r EnableDirectoryRequest) Send(ctx context.Context) (*EnableDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableDirectoryResponse{
		EnableDirectoryOutput: r.Request.Data.(*EnableDirectoryOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableDirectoryResponse is the response type for the
// EnableDirectory API operation.
type EnableDirectoryResponse struct {
	*EnableDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableDirectory request.
func (r *EnableDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
