// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociatePhoneNumbersWithVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	//
	// E164PhoneNumbers is a required field
	E164PhoneNumbers []string `type:"list" required:"true"`

	// If true, associates the provided phone numbers with the provided Amazon Chime
	// Voice Connector Group and removes any previously existing associations. If
	// false, does not associate any phone numbers that have previously existing
	// associations.
	ForceAssociate *bool `type:"boolean"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorGroupInput"}

	if s.E164PhoneNumbers == nil {
		invalidParams.Add(aws.NewErrParamRequired("E164PhoneNumbers"))
	}

	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.E164PhoneNumbers != nil {
		v := s.E164PhoneNumbers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "E164PhoneNumbers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ForceAssociate != nil {
		v := *s.ForceAssociate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ForceAssociate", protocol.BoolValue(v), metadata)
	}
	if s.VoiceConnectorGroupId != nil {
		v := *s.VoiceConnectorGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssociatePhoneNumbersWithVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PhoneNumberErrors != nil {
		v := s.PhoneNumberErrors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PhoneNumberErrors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opAssociatePhoneNumbersWithVoiceConnectorGroup = "AssociatePhoneNumbersWithVoiceConnectorGroup"

// AssociatePhoneNumbersWithVoiceConnectorGroupRequest returns a request value for making API operation for
// Amazon Chime.
//
// Associates phone numbers with the specified Amazon Chime Voice Connector
// group.
//
//    // Example sending a request using AssociatePhoneNumbersWithVoiceConnectorGroupRequest.
//    req := client.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup
func (c *Client) AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
	op := &aws.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorGroupInput{}
	}

	req := c.newRequest(op, input, &AssociatePhoneNumbersWithVoiceConnectorGroupOutput{})

	return AssociatePhoneNumbersWithVoiceConnectorGroupRequest{Request: req, Input: input, Copy: c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest}
}

// AssociatePhoneNumbersWithVoiceConnectorGroupRequest is the request type for the
// AssociatePhoneNumbersWithVoiceConnectorGroup API operation.
type AssociatePhoneNumbersWithVoiceConnectorGroupRequest struct {
	*aws.Request
	Input *AssociatePhoneNumbersWithVoiceConnectorGroupInput
	Copy  func(*AssociatePhoneNumbersWithVoiceConnectorGroupInput) AssociatePhoneNumbersWithVoiceConnectorGroupRequest
}

// Send marshals and sends the AssociatePhoneNumbersWithVoiceConnectorGroup API request.
func (r AssociatePhoneNumbersWithVoiceConnectorGroupRequest) Send(ctx context.Context) (*AssociatePhoneNumbersWithVoiceConnectorGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociatePhoneNumbersWithVoiceConnectorGroupResponse{
		AssociatePhoneNumbersWithVoiceConnectorGroupOutput: r.Request.Data.(*AssociatePhoneNumbersWithVoiceConnectorGroupOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociatePhoneNumbersWithVoiceConnectorGroupResponse is the response type for the
// AssociatePhoneNumbersWithVoiceConnectorGroup API operation.
type AssociatePhoneNumbersWithVoiceConnectorGroupResponse struct {
	*AssociatePhoneNumbersWithVoiceConnectorGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociatePhoneNumbersWithVoiceConnectorGroup request.
func (r *AssociatePhoneNumbersWithVoiceConnectorGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
