// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeCopyJobInput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a copy job.
	//
	// CopyJobId is a required field
	CopyJobId *string `location:"uri" locationName:"copyJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCopyJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCopyJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCopyJobInput"}

	if s.CopyJobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CopyJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCopyJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CopyJobId != nil {
		v := *s.CopyJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "copyJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeCopyJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains detailed information about a copy job.
	CopyJob *CopyJob `type:"structure"`
}

// String returns the string representation
func (s DescribeCopyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCopyJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopyJob != nil {
		v := s.CopyJob

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CopyJob", v, metadata)
	}
	return nil
}

const opDescribeCopyJob = "DescribeCopyJob"

// DescribeCopyJobRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns metadata associated with creating a copy of a resource.
//
//    // Example sending a request using DescribeCopyJobRequest.
//    req := client.DescribeCopyJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob
func (c *Client) DescribeCopyJobRequest(input *DescribeCopyJobInput) DescribeCopyJobRequest {
	op := &aws.Operation{
		Name:       opDescribeCopyJob,
		HTTPMethod: "GET",
		HTTPPath:   "/copy-jobs/{copyJobId}",
	}

	if input == nil {
		input = &DescribeCopyJobInput{}
	}

	req := c.newRequest(op, input, &DescribeCopyJobOutput{})

	return DescribeCopyJobRequest{Request: req, Input: input, Copy: c.DescribeCopyJobRequest}
}

// DescribeCopyJobRequest is the request type for the
// DescribeCopyJob API operation.
type DescribeCopyJobRequest struct {
	*aws.Request
	Input *DescribeCopyJobInput
	Copy  func(*DescribeCopyJobInput) DescribeCopyJobRequest
}

// Send marshals and sends the DescribeCopyJob API request.
func (r DescribeCopyJobRequest) Send(ctx context.Context) (*DescribeCopyJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCopyJobResponse{
		DescribeCopyJobOutput: r.Request.Data.(*DescribeCopyJobOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCopyJobResponse is the response type for the
// DescribeCopyJob API operation.
type DescribeCopyJobResponse struct {
	*DescribeCopyJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCopyJob request.
func (r *DescribeCopyJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
