// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type SuspendProcessesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following processes:
	//
	//    * Launch
	//
	//    * Terminate
	//
	//    * AddToLoadBalancer
	//
	//    * AlarmNotification
	//
	//    * AZRebalance
	//
	//    * HealthCheck
	//
	//    * InstanceRefresh
	//
	//    * ReplaceUnhealthy
	//
	//    * ScheduledActions
	//
	// If you omit this parameter, all processes are specified.
	ScalingProcesses []string `type:"list"`
}

// String returns the string representation
func (s SuspendProcessesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuspendProcessesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SuspendProcessesInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SuspendProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SuspendProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSuspendProcesses = "SuspendProcesses"

// SuspendProcessesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Suspends the specified automatic scaling processes, or all processes, for
// the specified Auto Scaling group.
//
// If you suspend either the Launch or Terminate process types, it can prevent
// other process types from functioning properly. For more information, see
// Suspending and Resuming Scaling Processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// To resume processes that have been suspended, call the ResumeProcesses API.
//
//    // Example sending a request using SuspendProcessesRequest.
//    req := client.SuspendProcessesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses
func (c *Client) SuspendProcessesRequest(input *SuspendProcessesInput) SuspendProcessesRequest {
	op := &aws.Operation{
		Name:       opSuspendProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SuspendProcessesInput{}
	}

	req := c.newRequest(op, input, &SuspendProcessesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SuspendProcessesRequest{Request: req, Input: input, Copy: c.SuspendProcessesRequest}
}

// SuspendProcessesRequest is the request type for the
// SuspendProcesses API operation.
type SuspendProcessesRequest struct {
	*aws.Request
	Input *SuspendProcessesInput
	Copy  func(*SuspendProcessesInput) SuspendProcessesRequest
}

// Send marshals and sends the SuspendProcesses API request.
func (r SuspendProcessesRequest) Send(ctx context.Context) (*SuspendProcessesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SuspendProcessesResponse{
		SuspendProcessesOutput: r.Request.Data.(*SuspendProcessesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SuspendProcessesResponse is the response type for the
// SuspendProcesses API operation.
type SuspendProcessesResponse struct {
	*SuspendProcessesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SuspendProcesses request.
func (r *SuspendProcessesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
