// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLifecycleHookTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeLifecycleHookTypesOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hook types.
	LifecycleHookTypes []string `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLifecycleHookTypes = "DescribeLifecycleHookTypes"

// DescribeLifecycleHookTypesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes the available types of lifecycle hooks.
//
// The following hook types are supported:
//
//    * autoscaling:EC2_INSTANCE_LAUNCHING
//
//    * autoscaling:EC2_INSTANCE_TERMINATING
//
//    // Example sending a request using DescribeLifecycleHookTypesRequest.
//    req := client.DescribeLifecycleHookTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes
func (c *Client) DescribeLifecycleHookTypesRequest(input *DescribeLifecycleHookTypesInput) DescribeLifecycleHookTypesRequest {
	op := &aws.Operation{
		Name:       opDescribeLifecycleHookTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHookTypesInput{}
	}

	req := c.newRequest(op, input, &DescribeLifecycleHookTypesOutput{})

	return DescribeLifecycleHookTypesRequest{Request: req, Input: input, Copy: c.DescribeLifecycleHookTypesRequest}
}

// DescribeLifecycleHookTypesRequest is the request type for the
// DescribeLifecycleHookTypes API operation.
type DescribeLifecycleHookTypesRequest struct {
	*aws.Request
	Input *DescribeLifecycleHookTypesInput
	Copy  func(*DescribeLifecycleHookTypesInput) DescribeLifecycleHookTypesRequest
}

// Send marshals and sends the DescribeLifecycleHookTypes API request.
func (r DescribeLifecycleHookTypesRequest) Send(ctx context.Context) (*DescribeLifecycleHookTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLifecycleHookTypesResponse{
		DescribeLifecycleHookTypesOutput: r.Request.Data.(*DescribeLifecycleHookTypesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLifecycleHookTypesResponse is the response type for the
// DescribeLifecycleHookTypes API operation.
type DescribeLifecycleHookTypesResponse struct {
	*DescribeLifecycleHookTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLifecycleHookTypes request.
func (r *DescribeLifecycleHookTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
