// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// New or modified text that describes the data catalog.
	Description *string `min:"1" type:"string"`

	// The name of the data catalog to update. The catalog name must be unique for
	// the AWS account and can use a maximum of 128 alphanumeric, underscore, at
	// sign, or hyphen characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the Lambda function or functions to use for updating the data catalog.
	// This is a mapping whose values depend on the catalog type.
	//
	//    * For the HIVE data catalog type, use the following syntax. The metadata-function
	//    parameter is required. The sdk-version parameter is optional and defaults
	//    to the currently supported version. metadata-function=lambda_arn, sdk-version=version_number
	//
	//    * For the LAMBDA data catalog type, use one of the following sets of required
	//    parameters, but not both. If you have one Lambda function that processes
	//    metadata and another for reading the actual data, use the following syntax.
	//    Both parameters are required. metadata-function=lambda_arn, record-function=lambda_arn
	//    If you have a composite Lambda function that processes both metadata and
	//    data, use the following syntax to specify your Lambda function. function=lambda_arn
	//
	//    * The GLUE type has no parameters.
	Parameters map[string]string `type:"map"`

	// Specifies the type of data catalog to update. Specify LAMBDA for a federated
	// catalog, GLUE for AWS Glue Catalog, or HIVE for an external hive metastore.
	//
	// Type is a required field
	Type DataCatalogType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataCatalogInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDataCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDataCatalog = "UpdateDataCatalog"

// UpdateDataCatalogRequest returns a request value for making API operation for
// Amazon Athena.
//
// Updates the data catalog that has the specified name.
//
//    // Example sending a request using UpdateDataCatalogRequest.
//    req := client.UpdateDataCatalogRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog
func (c *Client) UpdateDataCatalogRequest(input *UpdateDataCatalogInput) UpdateDataCatalogRequest {
	op := &aws.Operation{
		Name:       opUpdateDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataCatalogInput{}
	}

	req := c.newRequest(op, input, &UpdateDataCatalogOutput{})

	return UpdateDataCatalogRequest{Request: req, Input: input, Copy: c.UpdateDataCatalogRequest}
}

// UpdateDataCatalogRequest is the request type for the
// UpdateDataCatalog API operation.
type UpdateDataCatalogRequest struct {
	*aws.Request
	Input *UpdateDataCatalogInput
	Copy  func(*UpdateDataCatalogInput) UpdateDataCatalogRequest
}

// Send marshals and sends the UpdateDataCatalog API request.
func (r UpdateDataCatalogRequest) Send(ctx context.Context) (*UpdateDataCatalogResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDataCatalogResponse{
		UpdateDataCatalogOutput: r.Request.Data.(*UpdateDataCatalogOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDataCatalogResponse is the response type for the
// UpdateDataCatalog API operation.
type UpdateDataCatalogResponse struct {
	*UpdateDataCatalogOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDataCatalog request.
func (r *UpdateDataCatalogResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
