// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDataCatalogsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of data catalogs to return.
	MaxResults *int64 `min:"2" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataCatalogsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataCatalogsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDataCatalogsInput"}
	if s.MaxResults != nil && *s.MaxResults < 2 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 2))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDataCatalogsOutput struct {
	_ struct{} `type:"structure"`

	// A summary list of data catalogs.
	DataCatalogsSummary []DataCatalogSummary `type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataCatalogsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDataCatalogs = "ListDataCatalogs"

// ListDataCatalogsRequest returns a request value for making API operation for
// Amazon Athena.
//
// Lists the data catalogs in the current AWS account.
//
//    // Example sending a request using ListDataCatalogsRequest.
//    req := client.ListDataCatalogsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs
func (c *Client) ListDataCatalogsRequest(input *ListDataCatalogsInput) ListDataCatalogsRequest {
	op := &aws.Operation{
		Name:       opListDataCatalogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataCatalogsInput{}
	}

	req := c.newRequest(op, input, &ListDataCatalogsOutput{})

	return ListDataCatalogsRequest{Request: req, Input: input, Copy: c.ListDataCatalogsRequest}
}

// ListDataCatalogsRequest is the request type for the
// ListDataCatalogs API operation.
type ListDataCatalogsRequest struct {
	*aws.Request
	Input *ListDataCatalogsInput
	Copy  func(*ListDataCatalogsInput) ListDataCatalogsRequest
}

// Send marshals and sends the ListDataCatalogs API request.
func (r ListDataCatalogsRequest) Send(ctx context.Context) (*ListDataCatalogsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDataCatalogsResponse{
		ListDataCatalogsOutput: r.Request.Data.(*ListDataCatalogsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDataCatalogsRequestPaginator returns a paginator for ListDataCatalogs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDataCatalogsRequest(input)
//   p := athena.NewListDataCatalogsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDataCatalogsPaginator(req ListDataCatalogsRequest) ListDataCatalogsPaginator {
	return ListDataCatalogsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDataCatalogsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDataCatalogsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDataCatalogsPaginator struct {
	aws.Pager
}

func (p *ListDataCatalogsPaginator) CurrentPage() *ListDataCatalogsOutput {
	return p.Pager.CurrentPage().(*ListDataCatalogsOutput)
}

// ListDataCatalogsResponse is the response type for the
// ListDataCatalogs API operation.
type ListDataCatalogsResponse struct {
	*ListDataCatalogsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDataCatalogs request.
func (r *ListDataCatalogsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
