// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataCatalogInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDataCatalogInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDataCatalog = "DeleteDataCatalog"

// DeleteDataCatalogRequest returns a request value for making API operation for
// Amazon Athena.
//
// Deletes a data catalog.
//
//    // Example sending a request using DeleteDataCatalogRequest.
//    req := client.DeleteDataCatalogRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog
func (c *Client) DeleteDataCatalogRequest(input *DeleteDataCatalogInput) DeleteDataCatalogRequest {
	op := &aws.Operation{
		Name:       opDeleteDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataCatalogInput{}
	}

	req := c.newRequest(op, input, &DeleteDataCatalogOutput{})

	return DeleteDataCatalogRequest{Request: req, Input: input, Copy: c.DeleteDataCatalogRequest}
}

// DeleteDataCatalogRequest is the request type for the
// DeleteDataCatalog API operation.
type DeleteDataCatalogRequest struct {
	*aws.Request
	Input *DeleteDataCatalogInput
	Copy  func(*DeleteDataCatalogInput) DeleteDataCatalogRequest
}

// Send marshals and sends the DeleteDataCatalog API request.
func (r DeleteDataCatalogRequest) Send(ctx context.Context) (*DeleteDataCatalogResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDataCatalogResponse{
		DeleteDataCatalogOutput: r.Request.Data.(*DeleteDataCatalogOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDataCatalogResponse is the response type for the
// DeleteDataCatalog API operation.
type DeleteDataCatalogResponse struct {
	*DeleteDataCatalogOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDataCatalog request.
func (r *DeleteDataCatalogResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
