// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTypeInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTypeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTypeOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteType = "DeleteType"

// DeleteTypeRequest returns a request value for making API operation for
// AWS AppSync.
//
// Deletes a Type object.
//
//    // Example sending a request using DeleteTypeRequest.
//    req := client.DeleteTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType
func (c *Client) DeleteTypeRequest(input *DeleteTypeInput) DeleteTypeRequest {
	op := &aws.Operation{
		Name:       opDeleteType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}",
	}

	if input == nil {
		input = &DeleteTypeInput{}
	}

	req := c.newRequest(op, input, &DeleteTypeOutput{})

	return DeleteTypeRequest{Request: req, Input: input, Copy: c.DeleteTypeRequest}
}

// DeleteTypeRequest is the request type for the
// DeleteType API operation.
type DeleteTypeRequest struct {
	*aws.Request
	Input *DeleteTypeInput
	Copy  func(*DeleteTypeInput) DeleteTypeRequest
}

// Send marshals and sends the DeleteType API request.
func (r DeleteTypeRequest) Send(ctx context.Context) (*DeleteTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTypeResponse{
		DeleteTypeOutput: r.Request.Data.(*DeleteTypeOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTypeResponse is the response type for the
// DeleteType API operation.
type DeleteTypeResponse struct {
	*DeleteTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteType request.
func (r *DeleteTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
