// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStackInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Deletes the specified stack. After the stack is deleted, the application
// streaming environment provided by the stack is no longer available to users.
// Also, any reservations made for application streaming sessions for the stack
// are released.
//
//    // Example sending a request using DeleteStackRequest.
//    req := client.DeleteStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *Client) DeleteStackRequest(input *DeleteStackInput) DeleteStackRequest {
	op := &aws.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	req := c.newRequest(op, input, &DeleteStackOutput{})

	return DeleteStackRequest{Request: req, Input: input, Copy: c.DeleteStackRequest}
}

// DeleteStackRequest is the request type for the
// DeleteStack API operation.
type DeleteStackRequest struct {
	*aws.Request
	Input *DeleteStackInput
	Copy  func(*DeleteStackInput) DeleteStackRequest
}

// Send marshals and sends the DeleteStack API request.
func (r DeleteStackRequest) Send(ctx context.Context) (*DeleteStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStackResponse{
		DeleteStackOutput: r.Request.Data.(*DeleteStackOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStackResponse is the response type for the
// DeleteStack API operation.
type DeleteStackResponse struct {
	*DeleteStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStack request.
func (r *DeleteStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
