// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFleetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateFleetInput"}

	if s.FleetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetName", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateFleet = "AssociateFleet"

// AssociateFleetRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Associates the specified fleet with the specified stack.
//
//    // Example sending a request using AssociateFleetRequest.
//    req := client.AssociateFleetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *Client) AssociateFleetRequest(input *AssociateFleetInput) AssociateFleetRequest {
	op := &aws.Operation{
		Name:       opAssociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFleetInput{}
	}

	req := c.newRequest(op, input, &AssociateFleetOutput{})

	return AssociateFleetRequest{Request: req, Input: input, Copy: c.AssociateFleetRequest}
}

// AssociateFleetRequest is the request type for the
// AssociateFleet API operation.
type AssociateFleetRequest struct {
	*aws.Request
	Input *AssociateFleetInput
	Copy  func(*AssociateFleetInput) AssociateFleetRequest
}

// Send marshals and sends the AssociateFleet API request.
func (r AssociateFleetRequest) Send(ctx context.Context) (*AssociateFleetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateFleetResponse{
		AssociateFleetOutput: r.Request.Data.(*AssociateFleetOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateFleetResponse is the response type for the
// AssociateFleet API operation.
type AssociateFleetResponse struct {
	*AssociateFleetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateFleet request.
func (r *AssociateFleetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
