// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeVirtualGatewayInput struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeVirtualGatewayInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVirtualGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// An object that represents a virtual gateway returned by a describe operation.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVirtualGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualGateway != nil {
		v := s.VirtualGateway

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "virtualGateway", v, metadata)
	}
	return nil
}

const opDescribeVirtualGateway = "DescribeVirtualGateway"

// DescribeVirtualGatewayRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Describes an existing virtual gateway.
//
//    // Example sending a request using DescribeVirtualGatewayRequest.
//    req := client.DescribeVirtualGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualGateway
func (c *Client) DescribeVirtualGatewayRequest(input *DescribeVirtualGatewayInput) DescribeVirtualGatewayRequest {
	op := &aws.Operation{
		Name:       opDescribeVirtualGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
	}

	if input == nil {
		input = &DescribeVirtualGatewayInput{}
	}

	req := c.newRequest(op, input, &DescribeVirtualGatewayOutput{})

	return DescribeVirtualGatewayRequest{Request: req, Input: input, Copy: c.DescribeVirtualGatewayRequest}
}

// DescribeVirtualGatewayRequest is the request type for the
// DescribeVirtualGateway API operation.
type DescribeVirtualGatewayRequest struct {
	*aws.Request
	Input *DescribeVirtualGatewayInput
	Copy  func(*DescribeVirtualGatewayInput) DescribeVirtualGatewayRequest
}

// Send marshals and sends the DescribeVirtualGateway API request.
func (r DescribeVirtualGatewayRequest) Send(ctx context.Context) (*DescribeVirtualGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVirtualGatewayResponse{
		DescribeVirtualGatewayOutput: r.Request.Data.(*DescribeVirtualGatewayOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVirtualGatewayResponse is the response type for the
// DescribeVirtualGateway API operation.
type DescribeVirtualGatewayResponse struct {
	*DescribeVirtualGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVirtualGateway request.
func (r *DescribeVirtualGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
