// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SendInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user to whom to send an invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s SendInvitationInput) String() string {
	return awsutil.Prettify(s)
}

type SendInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendInvitation = "SendInvitation"

// SendInvitationRequest returns a request value for making API operation for
// Alexa For Business.
//
// Sends an enrollment invitation email with a URL to a user. The URL is valid
// for 30 days or until you call this operation again, whichever comes first.
//
//    // Example sending a request using SendInvitationRequest.
//    req := client.SendInvitationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation
func (c *Client) SendInvitationRequest(input *SendInvitationInput) SendInvitationRequest {
	op := &aws.Operation{
		Name:       opSendInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendInvitationInput{}
	}

	req := c.newRequest(op, input, &SendInvitationOutput{})

	return SendInvitationRequest{Request: req, Input: input, Copy: c.SendInvitationRequest}
}

// SendInvitationRequest is the request type for the
// SendInvitation API operation.
type SendInvitationRequest struct {
	*aws.Request
	Input *SendInvitationInput
	Copy  func(*SendInvitationInput) SendInvitationRequest
}

// Send marshals and sends the SendInvitation API request.
func (r SendInvitationRequest) Send(ctx context.Context) (*SendInvitationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendInvitationResponse{
		SendInvitationOutput: r.Request.Data.(*SendInvitationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendInvitationResponse is the response type for the
// SendInvitation API operation.
type SendInvitationResponse struct {
	*SendInvitationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendInvitation request.
func (r *SendInvitationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
