// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RevokeCertificateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the private CA that issued the certificate
	// to be revoked. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Serial number of the certificate to be revoked. This must be in hexadecimal
	// format. You can retrieve the serial number by calling GetCertificate with
	// the Amazon Resource Name (ARN) of the certificate you want and the ARN of
	// your private CA. The GetCertificate action retrieves the certificate in the
	// PEM format. You can use the following OpenSSL command to list the certificate
	// in text format and copy the hexadecimal serial number.
	//
	// openssl x509 -in file_path -text -noout
	//
	// You can also copy the serial number from the console or use the DescribeCertificate
	// (https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
	// action in the AWS Certificate Manager API Reference.
	//
	// CertificateSerial is a required field
	CertificateSerial *string `type:"string" required:"true"`

	// Specifies why you revoked the certificate.
	//
	// RevocationReason is a required field
	RevocationReason RevocationReason `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RevokeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeCertificateInput"}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if s.CertificateSerial == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateSerial"))
	}
	if len(s.RevocationReason) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RevocationReason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RevokeCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeCertificate = "RevokeCertificate"

// RevokeCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Revokes a certificate that was issued inside ACM Private CA. If you enable
// a certificate revocation list (CRL) when you create or update your private
// CA, information about the revoked certificates will be included in the CRL.
// ACM Private CA writes the CRL to an S3 bucket that you specify. For more
// information about revocation, see the CrlConfiguration structure. ACM Private
// CA also writes revocation information to the audit report. For more information,
// see CreateCertificateAuthorityAuditReport.
//
// You cannot revoke a root CA self-signed certificate.
//
//    // Example sending a request using RevokeCertificateRequest.
//    req := client.RevokeCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate
func (c *Client) RevokeCertificateRequest(input *RevokeCertificateInput) RevokeCertificateRequest {
	op := &aws.Operation{
		Name:       opRevokeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeCertificateInput{}
	}

	req := c.newRequest(op, input, &RevokeCertificateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RevokeCertificateRequest{Request: req, Input: input, Copy: c.RevokeCertificateRequest}
}

// RevokeCertificateRequest is the request type for the
// RevokeCertificate API operation.
type RevokeCertificateRequest struct {
	*aws.Request
	Input *RevokeCertificateInput
	Copy  func(*RevokeCertificateInput) RevokeCertificateRequest
}

// Send marshals and sends the RevokeCertificate API request.
func (r RevokeCertificateRequest) Send(ctx context.Context) (*RevokeCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeCertificateResponse{
		RevokeCertificateOutput: r.Request.Data.(*RevokeCertificateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeCertificateResponse is the response type for the
// RevokeCertificate API operation.
type RevokeCertificateResponse struct {
	*RevokeCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeCertificate request.
func (r *RevokeCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
