// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains details about the analyzed resource.
type AnalyzedResource struct {
	_ struct{} `type:"structure"`

	// The actions that an external principal is granted permission to use by the
	// policy that generated the finding.
	Actions []string `locationName:"actions" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error message.
	Error *string `locationName:"error" type:"string"`

	// Indicates whether the policy that generated the finding grants public access
	// to the resource.
	//
	// IsPublic is a required field
	IsPublic *bool `locationName:"isPublic" type:"boolean" required:"true"`

	// The ARN of the resource that was analyzed.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`

	// Indicates how the access that generated the finding is granted. This is populated
	// for Amazon S3 bucket findings.
	SharedVia []string `locationName:"sharedVia" type:"list"`

	// The current status of the finding generated from the analyzed resource.
	Status FindingStatus `locationName:"status" type:"string" enum:"true"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s AnalyzedResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyzedResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AnalyzedAt != nil {
		v := *s.AnalyzedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "analyzedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Error != nil {
		v := *s.Error

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "error", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isPublic", protocol.BoolValue(v), metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceOwnerAccount != nil {
		v := *s.ResourceOwnerAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceOwnerAccount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SharedVia != nil {
		v := s.SharedVia

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sharedVia", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Contains the ARN of the analyzed resource.
type AnalyzedResourceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzed resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AnalyzedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyzedResourceSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceOwnerAccount != nil {
		v := *s.ResourceOwnerAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceOwnerAccount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about the analyzer.
type AnalyzerSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A timestamp for the time at which the analyzer was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The resource that was most recently analyzed by the analyzer.
	LastResourceAnalyzed *string `locationName:"lastResourceAnalyzed" type:"string"`

	// The time at which the most recently analyzed resource was analyzed.
	LastResourceAnalyzedAt *time.Time `locationName:"lastResourceAnalyzedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the analyzer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the analyzer. An Active analyzer successfully monitors supported
	// resources and generates new findings. The analyzer is Disabled when a user
	// action, such as removing trusted access for IAM Access Analyzer from AWS
	// Organizations, causes the analyzer to stop generating new findings. The status
	// is Creating when the analyzer creation is in progress and Failed when the
	// analyzer creation has failed.
	//
	// Status is a required field
	Status AnalyzerStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The statusReason provides more details about the current status of the analyzer.
	// For example, if the creation for the analyzer fails, a Failed status is displayed.
	// For an analyzer with organization as the type, this failure can be due to
	// an issue with creating the service-linked roles required in the member accounts
	// of the AWS organization.
	StatusReason *StatusReason `locationName:"statusReason" type:"structure"`

	// The tags added to the analyzer.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The type of analyzer, which corresponds to the zone of trust chosen for the
	// analyzer.
	//
	// Type is a required field
	Type Type `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AnalyzerSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyzerSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LastResourceAnalyzed != nil {
		v := *s.LastResourceAnalyzed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastResourceAnalyzed", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastResourceAnalyzedAt != nil {
		v := *s.LastResourceAnalyzedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastResourceAnalyzedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := s.StatusReason

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "statusReason", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about an archive rule.
type ArchiveRuleSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the archive rule was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A filter used to define the archive rule.
	//
	// Filter is a required field
	Filter map[string]Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the archive rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The time at which the archive rule was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ArchiveRuleSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArchiveRuleSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "filter", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The criteria to use in the filter that defines the archive rule.
type Criterion struct {
	_ struct{} `type:"structure"`

	// A "contains" operator to match for the filter used to create the rule.
	Contains []string `locationName:"contains" min:"1" type:"list"`

	// An "equals" operator to match for the filter used to create the rule.
	Eq []string `locationName:"eq" min:"1" type:"list"`

	// An "exists" operator to match for the filter used to create the rule.
	Exists *bool `locationName:"exists" type:"boolean"`

	// A "not equals" operator to match for the filter used to create the rule.
	Neq []string `locationName:"neq" min:"1" type:"list"`
}

// String returns the string representation
func (s Criterion) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Criterion) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Criterion"}
	if s.Contains != nil && len(s.Contains) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Contains", 1))
	}
	if s.Eq != nil && len(s.Eq) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Eq", 1))
	}
	if s.Neq != nil && len(s.Neq) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Neq", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Criterion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Contains != nil {
		v := s.Contains

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "contains", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Eq != nil {
		v := s.Eq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Exists != nil {
		v := *s.Exists

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exists", protocol.BoolValue(v), metadata)
	}
	if s.Neq != nil {
		v := s.Neq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "neq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Contains information about a finding.
type Finding struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string `locationName:"action" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the policy that generated the finding allows public access
	// to the resource.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that access to a resource within the zone of trust.
	Principal map[string]string `locationName:"principal" type:"map"`

	// The resource that an external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource reported in the finding.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource `locationName:"sources" type:"list"`

	// The current status of the finding.
	//
	// Status is a required field
	Status FindingStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Finding) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "action", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AnalyzedAt != nil {
		v := *s.AnalyzedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "analyzedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "condition", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Error != nil {
		v := *s.Error

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "error", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isPublic", protocol.BoolValue(v), metadata)
	}
	if s.Principal != nil {
		v := s.Principal

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "principal", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Resource != nil {
		v := *s.Resource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resource", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceOwnerAccount != nil {
		v := *s.ResourceOwnerAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceOwnerAccount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The source of the finding. This indicates how the access that generated the
// finding is granted. It is populated for Amazon S3 bucket findings.
type FindingSource struct {
	_ struct{} `type:"structure"`

	// Includes details about how the access that generated the finding is granted.
	// This is populated for Amazon S3 bucket findings.
	Detail *FindingSourceDetail `locationName:"detail" type:"structure"`

	// Indicates the type of access that generated the finding.
	//
	// Type is a required field
	Type FindingSourceType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FindingSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Detail != nil {
		v := s.Detail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "detail", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Includes details about how the access that generated the finding is granted.
// This is populated for Amazon S3 bucket findings.
type FindingSourceDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point that generated the finding.
	AccessPointArn *string `locationName:"accessPointArn" type:"string"`
}

// String returns the string representation
func (s FindingSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingSourceDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPointArn != nil {
		v := *s.AccessPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a finding.
type FindingSummary struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string `locationName:"action" type:"list"`

	// The time at which the resource-based policy that generated the finding was
	// analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The error that resulted in an Error finding.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the finding reports a resource that has a policy that allows
	// public access.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string `locationName:"principal" type:"map"`

	// The resource that the external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that the external principal has access to.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource `locationName:"sources" type:"list"`

	// The status of the finding.
	//
	// Status is a required field
	Status FindingStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The time at which the finding was most recently updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s FindingSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "action", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AnalyzedAt != nil {
		v := *s.AnalyzedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "analyzedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "condition", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Error != nil {
		v := *s.Error

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "error", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isPublic", protocol.BoolValue(v), metadata)
	}
	if s.Principal != nil {
		v := s.Principal

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "principal", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Resource != nil {
		v := *s.Resource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resource", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceOwnerAccount != nil {
		v := *s.ResourceOwnerAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceOwnerAccount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// An criterion statement in an archive rule. Each archive rule may have multiple
// criteria.
type InlineArchiveRule struct {
	_ struct{} `type:"structure"`

	// The condition and values for a criterion.
	//
	// Filter is a required field
	Filter map[string]Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InlineArchiveRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InlineArchiveRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InlineArchiveRule"}

	if s.Filter == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InlineArchiveRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "filter", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The criteria used to sort.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to sort on.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The sort order, ascending or descending.
	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides more details about the current status of the analyzer. For example,
// if the creation for the analyzer fails, a Failed status is displayed. For
// an analyzer with organization as the type, this failure can be due to an
// issue with creating the service-linked roles required in the member accounts
// of the AWS organization.
type StatusReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the current status of the analyzer.
	//
	// Code is a required field
	Code ReasonCode `locationName:"code" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StatusReason) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StatusReason) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidationExceptionField) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
