// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves an analyzer.
type GetAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer retrieved.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAnalyzerInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAnalyzerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response to the request.
type GetAnalyzerOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyzerSummary object that contains information about the analyzer.
	//
	// Analyzer is a required field
	Analyzer *AnalyzerSummary `locationName:"analyzer" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAnalyzerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Analyzer != nil {
		v := s.Analyzer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "analyzer", v, metadata)
	}
	return nil
}

const opGetAnalyzer = "GetAnalyzer"

// GetAnalyzerRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves information about the specified analyzer.
//
//    // Example sending a request using GetAnalyzerRequest.
//    req := client.GetAnalyzerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer
func (c *Client) GetAnalyzerRequest(input *GetAnalyzerInput) GetAnalyzerRequest {
	op := &aws.Operation{
		Name:       opGetAnalyzer,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &GetAnalyzerInput{}
	}

	req := c.newRequest(op, input, &GetAnalyzerOutput{})

	return GetAnalyzerRequest{Request: req, Input: input, Copy: c.GetAnalyzerRequest}
}

// GetAnalyzerRequest is the request type for the
// GetAnalyzer API operation.
type GetAnalyzerRequest struct {
	*aws.Request
	Input *GetAnalyzerInput
	Copy  func(*GetAnalyzerInput) GetAnalyzerRequest
}

// Send marshals and sends the GetAnalyzer API request.
func (r GetAnalyzerRequest) Send(ctx context.Context) (*GetAnalyzerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAnalyzerResponse{
		GetAnalyzerOutput: r.Request.Data.(*GetAnalyzerOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAnalyzerResponse is the response type for the
// GetAnalyzer API operation.
type GetAnalyzerResponse struct {
	*GetAnalyzerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAnalyzer request.
func (r *GetAnalyzerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
