// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhubstrategyrecommendations

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opGetApplicationComponentDetails = "GetApplicationComponentDetails"

// GetApplicationComponentDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationComponentDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationComponentDetails for more information on using the GetApplicationComponentDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationComponentDetailsRequest method.
//	req, resp := client.GetApplicationComponentDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentDetailsRequest(input *GetApplicationComponentDetailsInput) (req *request.Request, output *GetApplicationComponentDetailsOutput) {
	op := &request.Operation{
		Name:       opGetApplicationComponentDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/get-applicationcomponent-details/{applicationComponentId}",
	}

	if input == nil {
		input = &GetApplicationComponentDetailsInput{}
	}

	output = &GetApplicationComponentDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationComponentDetails API operation for Migration Hub Strategy Recommendations.
//
// Retrieves details about an application component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetApplicationComponentDetails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentDetails(input *GetApplicationComponentDetailsInput) (*GetApplicationComponentDetailsOutput, error) {
	req, out := c.GetApplicationComponentDetailsRequest(input)
	return out, req.Send()
}

// GetApplicationComponentDetailsWithContext is the same as GetApplicationComponentDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationComponentDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentDetailsWithContext(ctx aws.Context, input *GetApplicationComponentDetailsInput, opts ...request.Option) (*GetApplicationComponentDetailsOutput, error) {
	req, out := c.GetApplicationComponentDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationComponentStrategies = "GetApplicationComponentStrategies"

// GetApplicationComponentStrategiesRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationComponentStrategies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationComponentStrategies for more information on using the GetApplicationComponentStrategies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationComponentStrategiesRequest method.
//	req, resp := client.GetApplicationComponentStrategiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentStrategiesRequest(input *GetApplicationComponentStrategiesInput) (req *request.Request, output *GetApplicationComponentStrategiesOutput) {
	op := &request.Operation{
		Name:       opGetApplicationComponentStrategies,
		HTTPMethod: "GET",
		HTTPPath:   "/get-applicationcomponent-strategies/{applicationComponentId}",
	}

	if input == nil {
		input = &GetApplicationComponentStrategiesInput{}
	}

	output = &GetApplicationComponentStrategiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationComponentStrategies API operation for Migration Hub Strategy Recommendations.
//
// Retrieves a list of all the recommended strategies and tools for an application
// component running on a server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetApplicationComponentStrategies for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentStrategies(input *GetApplicationComponentStrategiesInput) (*GetApplicationComponentStrategiesOutput, error) {
	req, out := c.GetApplicationComponentStrategiesRequest(input)
	return out, req.Send()
}

// GetApplicationComponentStrategiesWithContext is the same as GetApplicationComponentStrategies with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationComponentStrategies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetApplicationComponentStrategiesWithContext(ctx aws.Context, input *GetApplicationComponentStrategiesInput, opts ...request.Option) (*GetApplicationComponentStrategiesOutput, error) {
	req, out := c.GetApplicationComponentStrategiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssessment = "GetAssessment"

// GetAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the GetAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssessment for more information on using the GetAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAssessmentRequest method.
//	req, resp := client.GetAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment
func (c *MigrationHubStrategyRecommendations) GetAssessmentRequest(input *GetAssessmentInput) (req *request.Request, output *GetAssessmentOutput) {
	op := &request.Operation{
		Name:       opGetAssessment,
		HTTPMethod: "GET",
		HTTPPath:   "/get-assessment/{id}",
	}

	if input == nil {
		input = &GetAssessmentInput{}
	}

	output = &GetAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssessment API operation for Migration Hub Strategy Recommendations.
//
// Retrieves the status of an on-going assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetAssessment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment
func (c *MigrationHubStrategyRecommendations) GetAssessment(input *GetAssessmentInput) (*GetAssessmentOutput, error) {
	req, out := c.GetAssessmentRequest(input)
	return out, req.Send()
}

// GetAssessmentWithContext is the same as GetAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetAssessmentWithContext(ctx aws.Context, input *GetAssessmentInput, opts ...request.Option) (*GetAssessmentOutput, error) {
	req, out := c.GetAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportFileTask = "GetImportFileTask"

// GetImportFileTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetImportFileTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportFileTask for more information on using the GetImportFileTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImportFileTaskRequest method.
//	req, resp := client.GetImportFileTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask
func (c *MigrationHubStrategyRecommendations) GetImportFileTaskRequest(input *GetImportFileTaskInput) (req *request.Request, output *GetImportFileTaskOutput) {
	op := &request.Operation{
		Name:       opGetImportFileTask,
		HTTPMethod: "GET",
		HTTPPath:   "/get-import-file-task/{id}",
	}

	if input == nil {
		input = &GetImportFileTaskInput{}
	}

	output = &GetImportFileTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportFileTask API operation for Migration Hub Strategy Recommendations.
//
// Retrieves the details about a specific import task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetImportFileTask for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask
func (c *MigrationHubStrategyRecommendations) GetImportFileTask(input *GetImportFileTaskInput) (*GetImportFileTaskOutput, error) {
	req, out := c.GetImportFileTaskRequest(input)
	return out, req.Send()
}

// GetImportFileTaskWithContext is the same as GetImportFileTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportFileTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetImportFileTaskWithContext(ctx aws.Context, input *GetImportFileTaskInput, opts ...request.Option) (*GetImportFileTaskOutput, error) {
	req, out := c.GetImportFileTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLatestAssessmentId = "GetLatestAssessmentId"

// GetLatestAssessmentIdRequest generates a "aws/request.Request" representing the
// client's request for the GetLatestAssessmentId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLatestAssessmentId for more information on using the GetLatestAssessmentId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLatestAssessmentIdRequest method.
//	req, resp := client.GetLatestAssessmentIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId
func (c *MigrationHubStrategyRecommendations) GetLatestAssessmentIdRequest(input *GetLatestAssessmentIdInput) (req *request.Request, output *GetLatestAssessmentIdOutput) {
	op := &request.Operation{
		Name:       opGetLatestAssessmentId,
		HTTPMethod: "GET",
		HTTPPath:   "/get-latest-assessment-id",
	}

	if input == nil {
		input = &GetLatestAssessmentIdInput{}
	}

	output = &GetLatestAssessmentIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLatestAssessmentId API operation for Migration Hub Strategy Recommendations.
//
// Retrieve the latest ID of a specific assessment task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetLatestAssessmentId for usage and error information.
//
// Returned Error Types:
//
//   - DependencyException
//     Dependency encountered an error.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId
func (c *MigrationHubStrategyRecommendations) GetLatestAssessmentId(input *GetLatestAssessmentIdInput) (*GetLatestAssessmentIdOutput, error) {
	req, out := c.GetLatestAssessmentIdRequest(input)
	return out, req.Send()
}

// GetLatestAssessmentIdWithContext is the same as GetLatestAssessmentId with the addition of
// the ability to pass a context and additional request options.
//
// See GetLatestAssessmentId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetLatestAssessmentIdWithContext(ctx aws.Context, input *GetLatestAssessmentIdInput, opts ...request.Option) (*GetLatestAssessmentIdOutput, error) {
	req, out := c.GetLatestAssessmentIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPortfolioPreferences = "GetPortfolioPreferences"

// GetPortfolioPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetPortfolioPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPortfolioPreferences for more information on using the GetPortfolioPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPortfolioPreferencesRequest method.
//	req, resp := client.GetPortfolioPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences
func (c *MigrationHubStrategyRecommendations) GetPortfolioPreferencesRequest(input *GetPortfolioPreferencesInput) (req *request.Request, output *GetPortfolioPreferencesOutput) {
	op := &request.Operation{
		Name:       opGetPortfolioPreferences,
		HTTPMethod: "GET",
		HTTPPath:   "/get-portfolio-preferences",
	}

	if input == nil {
		input = &GetPortfolioPreferencesInput{}
	}

	output = &GetPortfolioPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPortfolioPreferences API operation for Migration Hub Strategy Recommendations.
//
// Retrieves your migration and modernization preferences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetPortfolioPreferences for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences
func (c *MigrationHubStrategyRecommendations) GetPortfolioPreferences(input *GetPortfolioPreferencesInput) (*GetPortfolioPreferencesOutput, error) {
	req, out := c.GetPortfolioPreferencesRequest(input)
	return out, req.Send()
}

// GetPortfolioPreferencesWithContext is the same as GetPortfolioPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetPortfolioPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetPortfolioPreferencesWithContext(ctx aws.Context, input *GetPortfolioPreferencesInput, opts ...request.Option) (*GetPortfolioPreferencesOutput, error) {
	req, out := c.GetPortfolioPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPortfolioSummary = "GetPortfolioSummary"

// GetPortfolioSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetPortfolioSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPortfolioSummary for more information on using the GetPortfolioSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPortfolioSummaryRequest method.
//	req, resp := client.GetPortfolioSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary
func (c *MigrationHubStrategyRecommendations) GetPortfolioSummaryRequest(input *GetPortfolioSummaryInput) (req *request.Request, output *GetPortfolioSummaryOutput) {
	op := &request.Operation{
		Name:       opGetPortfolioSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/get-portfolio-summary",
	}

	if input == nil {
		input = &GetPortfolioSummaryInput{}
	}

	output = &GetPortfolioSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPortfolioSummary API operation for Migration Hub Strategy Recommendations.
//
// Retrieves overall summary including the number of servers to rehost and the
// overall number of anti-patterns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetPortfolioSummary for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary
func (c *MigrationHubStrategyRecommendations) GetPortfolioSummary(input *GetPortfolioSummaryInput) (*GetPortfolioSummaryOutput, error) {
	req, out := c.GetPortfolioSummaryRequest(input)
	return out, req.Send()
}

// GetPortfolioSummaryWithContext is the same as GetPortfolioSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetPortfolioSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetPortfolioSummaryWithContext(ctx aws.Context, input *GetPortfolioSummaryInput, opts ...request.Option) (*GetPortfolioSummaryOutput, error) {
	req, out := c.GetPortfolioSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendationReportDetails = "GetRecommendationReportDetails"

// GetRecommendationReportDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendationReportDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendationReportDetails for more information on using the GetRecommendationReportDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecommendationReportDetailsRequest method.
//	req, resp := client.GetRecommendationReportDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails
func (c *MigrationHubStrategyRecommendations) GetRecommendationReportDetailsRequest(input *GetRecommendationReportDetailsInput) (req *request.Request, output *GetRecommendationReportDetailsOutput) {
	op := &request.Operation{
		Name:       opGetRecommendationReportDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/get-recommendation-report-details/{id}",
	}

	if input == nil {
		input = &GetRecommendationReportDetailsInput{}
	}

	output = &GetRecommendationReportDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendationReportDetails API operation for Migration Hub Strategy Recommendations.
//
// Retrieves detailed information about the specified recommendation report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetRecommendationReportDetails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails
func (c *MigrationHubStrategyRecommendations) GetRecommendationReportDetails(input *GetRecommendationReportDetailsInput) (*GetRecommendationReportDetailsOutput, error) {
	req, out := c.GetRecommendationReportDetailsRequest(input)
	return out, req.Send()
}

// GetRecommendationReportDetailsWithContext is the same as GetRecommendationReportDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendationReportDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetRecommendationReportDetailsWithContext(ctx aws.Context, input *GetRecommendationReportDetailsInput, opts ...request.Option) (*GetRecommendationReportDetailsOutput, error) {
	req, out := c.GetRecommendationReportDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServerDetails = "GetServerDetails"

// GetServerDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetServerDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServerDetails for more information on using the GetServerDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServerDetailsRequest method.
//	req, resp := client.GetServerDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails
func (c *MigrationHubStrategyRecommendations) GetServerDetailsRequest(input *GetServerDetailsInput) (req *request.Request, output *GetServerDetailsOutput) {
	op := &request.Operation{
		Name:       opGetServerDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/get-server-details/{serverId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetServerDetailsInput{}
	}

	output = &GetServerDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServerDetails API operation for Migration Hub Strategy Recommendations.
//
// Retrieves detailed information about a specified server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetServerDetails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails
func (c *MigrationHubStrategyRecommendations) GetServerDetails(input *GetServerDetailsInput) (*GetServerDetailsOutput, error) {
	req, out := c.GetServerDetailsRequest(input)
	return out, req.Send()
}

// GetServerDetailsWithContext is the same as GetServerDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetServerDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetServerDetailsWithContext(ctx aws.Context, input *GetServerDetailsInput, opts ...request.Option) (*GetServerDetailsOutput, error) {
	req, out := c.GetServerDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetServerDetailsPages iterates over the pages of a GetServerDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetServerDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetServerDetails operation.
//	pageNum := 0
//	err := client.GetServerDetailsPages(params,
//	    func(page *migrationhubstrategyrecommendations.GetServerDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubStrategyRecommendations) GetServerDetailsPages(input *GetServerDetailsInput, fn func(*GetServerDetailsOutput, bool) bool) error {
	return c.GetServerDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetServerDetailsPagesWithContext same as GetServerDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetServerDetailsPagesWithContext(ctx aws.Context, input *GetServerDetailsInput, fn func(*GetServerDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetServerDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServerDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetServerDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetServerStrategies = "GetServerStrategies"

// GetServerStrategiesRequest generates a "aws/request.Request" representing the
// client's request for the GetServerStrategies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServerStrategies for more information on using the GetServerStrategies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServerStrategiesRequest method.
//	req, resp := client.GetServerStrategiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies
func (c *MigrationHubStrategyRecommendations) GetServerStrategiesRequest(input *GetServerStrategiesInput) (req *request.Request, output *GetServerStrategiesOutput) {
	op := &request.Operation{
		Name:       opGetServerStrategies,
		HTTPMethod: "GET",
		HTTPPath:   "/get-server-strategies/{serverId}",
	}

	if input == nil {
		input = &GetServerStrategiesInput{}
	}

	output = &GetServerStrategiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServerStrategies API operation for Migration Hub Strategy Recommendations.
//
// Retrieves recommended strategies and tools for the specified server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation GetServerStrategies for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies
func (c *MigrationHubStrategyRecommendations) GetServerStrategies(input *GetServerStrategiesInput) (*GetServerStrategiesOutput, error) {
	req, out := c.GetServerStrategiesRequest(input)
	return out, req.Send()
}

// GetServerStrategiesWithContext is the same as GetServerStrategies with the addition of
// the ability to pass a context and additional request options.
//
// See GetServerStrategies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) GetServerStrategiesWithContext(ctx aws.Context, input *GetServerStrategiesInput, opts ...request.Option) (*GetServerStrategiesOutput, error) {
	req, out := c.GetServerStrategiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationComponents = "ListApplicationComponents"

// ListApplicationComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationComponents for more information on using the ListApplicationComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationComponentsRequest method.
//	req, resp := client.ListApplicationComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents
func (c *MigrationHubStrategyRecommendations) ListApplicationComponentsRequest(input *ListApplicationComponentsInput) (req *request.Request, output *ListApplicationComponentsOutput) {
	op := &request.Operation{
		Name:       opListApplicationComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/list-applicationcomponents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationComponentsInput{}
	}

	output = &ListApplicationComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationComponents API operation for Migration Hub Strategy Recommendations.
//
// Retrieves a list of all the application components (processes).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation ListApplicationComponents for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ServiceLinkedRoleLockClientException
//     Exception to indicate that the service-linked role (SLR) is locked.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents
func (c *MigrationHubStrategyRecommendations) ListApplicationComponents(input *ListApplicationComponentsInput) (*ListApplicationComponentsOutput, error) {
	req, out := c.ListApplicationComponentsRequest(input)
	return out, req.Send()
}

// ListApplicationComponentsWithContext is the same as ListApplicationComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListApplicationComponentsWithContext(ctx aws.Context, input *ListApplicationComponentsInput, opts ...request.Option) (*ListApplicationComponentsOutput, error) {
	req, out := c.ListApplicationComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationComponentsPages iterates over the pages of a ListApplicationComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationComponents operation.
//	pageNum := 0
//	err := client.ListApplicationComponentsPages(params,
//	    func(page *migrationhubstrategyrecommendations.ListApplicationComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubStrategyRecommendations) ListApplicationComponentsPages(input *ListApplicationComponentsInput, fn func(*ListApplicationComponentsOutput, bool) bool) error {
	return c.ListApplicationComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationComponentsPagesWithContext same as ListApplicationComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListApplicationComponentsPagesWithContext(ctx aws.Context, input *ListApplicationComponentsInput, fn func(*ListApplicationComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollectors = "ListCollectors"

// ListCollectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollectors for more information on using the ListCollectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollectorsRequest method.
//	req, resp := client.ListCollectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors
func (c *MigrationHubStrategyRecommendations) ListCollectorsRequest(input *ListCollectorsInput) (req *request.Request, output *ListCollectorsOutput) {
	op := &request.Operation{
		Name:       opListCollectors,
		HTTPMethod: "GET",
		HTTPPath:   "/list-collectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollectorsInput{}
	}

	output = &ListCollectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollectors API operation for Migration Hub Strategy Recommendations.
//
// Retrieves a list of all the installed collectors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation ListCollectors for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors
func (c *MigrationHubStrategyRecommendations) ListCollectors(input *ListCollectorsInput) (*ListCollectorsOutput, error) {
	req, out := c.ListCollectorsRequest(input)
	return out, req.Send()
}

// ListCollectorsWithContext is the same as ListCollectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListCollectorsWithContext(ctx aws.Context, input *ListCollectorsInput, opts ...request.Option) (*ListCollectorsOutput, error) {
	req, out := c.ListCollectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollectorsPages iterates over the pages of a ListCollectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollectors operation.
//	pageNum := 0
//	err := client.ListCollectorsPages(params,
//	    func(page *migrationhubstrategyrecommendations.ListCollectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubStrategyRecommendations) ListCollectorsPages(input *ListCollectorsInput, fn func(*ListCollectorsOutput, bool) bool) error {
	return c.ListCollectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollectorsPagesWithContext same as ListCollectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListCollectorsPagesWithContext(ctx aws.Context, input *ListCollectorsInput, fn func(*ListCollectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImportFileTask = "ListImportFileTask"

// ListImportFileTaskRequest generates a "aws/request.Request" representing the
// client's request for the ListImportFileTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImportFileTask for more information on using the ListImportFileTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImportFileTaskRequest method.
//	req, resp := client.ListImportFileTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask
func (c *MigrationHubStrategyRecommendations) ListImportFileTaskRequest(input *ListImportFileTaskInput) (req *request.Request, output *ListImportFileTaskOutput) {
	op := &request.Operation{
		Name:       opListImportFileTask,
		HTTPMethod: "GET",
		HTTPPath:   "/list-import-file-task",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportFileTaskInput{}
	}

	output = &ListImportFileTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImportFileTask API operation for Migration Hub Strategy Recommendations.
//
// Retrieves a list of all the imports performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation ListImportFileTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask
func (c *MigrationHubStrategyRecommendations) ListImportFileTask(input *ListImportFileTaskInput) (*ListImportFileTaskOutput, error) {
	req, out := c.ListImportFileTaskRequest(input)
	return out, req.Send()
}

// ListImportFileTaskWithContext is the same as ListImportFileTask with the addition of
// the ability to pass a context and additional request options.
//
// See ListImportFileTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListImportFileTaskWithContext(ctx aws.Context, input *ListImportFileTaskInput, opts ...request.Option) (*ListImportFileTaskOutput, error) {
	req, out := c.ListImportFileTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportFileTaskPages iterates over the pages of a ListImportFileTask operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImportFileTask method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImportFileTask operation.
//	pageNum := 0
//	err := client.ListImportFileTaskPages(params,
//	    func(page *migrationhubstrategyrecommendations.ListImportFileTaskOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubStrategyRecommendations) ListImportFileTaskPages(input *ListImportFileTaskInput, fn func(*ListImportFileTaskOutput, bool) bool) error {
	return c.ListImportFileTaskPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportFileTaskPagesWithContext same as ListImportFileTaskPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListImportFileTaskPagesWithContext(ctx aws.Context, input *ListImportFileTaskInput, fn func(*ListImportFileTaskOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportFileTaskInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportFileTaskRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImportFileTaskOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServers = "ListServers"

// ListServersRequest generates a "aws/request.Request" representing the
// client's request for the ListServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServers for more information on using the ListServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServersRequest method.
//	req, resp := client.ListServersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers
func (c *MigrationHubStrategyRecommendations) ListServersRequest(input *ListServersInput) (req *request.Request, output *ListServersOutput) {
	op := &request.Operation{
		Name:       opListServers,
		HTTPMethod: "POST",
		HTTPPath:   "/list-servers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServersInput{}
	}

	output = &ListServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServers API operation for Migration Hub Strategy Recommendations.
//
// Returns a list of all the servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation ListServers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers
func (c *MigrationHubStrategyRecommendations) ListServers(input *ListServersInput) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	return out, req.Send()
}

// ListServersWithContext is the same as ListServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListServersWithContext(ctx aws.Context, input *ListServersInput, opts ...request.Option) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServersPages iterates over the pages of a ListServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServers operation.
//	pageNum := 0
//	err := client.ListServersPages(params,
//	    func(page *migrationhubstrategyrecommendations.ListServersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubStrategyRecommendations) ListServersPages(input *ListServersInput, fn func(*ListServersOutput, bool) bool) error {
	return c.ListServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServersPagesWithContext same as ListServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) ListServersPagesWithContext(ctx aws.Context, input *ListServersInput, fn func(*ListServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutPortfolioPreferences = "PutPortfolioPreferences"

// PutPortfolioPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the PutPortfolioPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPortfolioPreferences for more information on using the PutPortfolioPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPortfolioPreferencesRequest method.
//	req, resp := client.PutPortfolioPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences
func (c *MigrationHubStrategyRecommendations) PutPortfolioPreferencesRequest(input *PutPortfolioPreferencesInput) (req *request.Request, output *PutPortfolioPreferencesOutput) {
	op := &request.Operation{
		Name:       opPutPortfolioPreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/put-portfolio-preferences",
	}

	if input == nil {
		input = &PutPortfolioPreferencesInput{}
	}

	output = &PutPortfolioPreferencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPortfolioPreferences API operation for Migration Hub Strategy Recommendations.
//
// Saves the specified migration and modernization preferences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation PutPortfolioPreferences for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - ConflictException
//     Exception to indicate that there is an ongoing task when a new task is created.
//     Return when once the existing tasks are complete.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences
func (c *MigrationHubStrategyRecommendations) PutPortfolioPreferences(input *PutPortfolioPreferencesInput) (*PutPortfolioPreferencesOutput, error) {
	req, out := c.PutPortfolioPreferencesRequest(input)
	return out, req.Send()
}

// PutPortfolioPreferencesWithContext is the same as PutPortfolioPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See PutPortfolioPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) PutPortfolioPreferencesWithContext(ctx aws.Context, input *PutPortfolioPreferencesInput, opts ...request.Option) (*PutPortfolioPreferencesOutput, error) {
	req, out := c.PutPortfolioPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAssessment = "StartAssessment"

// StartAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssessment for more information on using the StartAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAssessmentRequest method.
//	req, resp := client.StartAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment
func (c *MigrationHubStrategyRecommendations) StartAssessmentRequest(input *StartAssessmentInput) (req *request.Request, output *StartAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/start-assessment",
	}

	if input == nil {
		input = &StartAssessmentInput{}
	}

	output = &StartAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAssessment API operation for Migration Hub Strategy Recommendations.
//
// Starts the assessment of an on-premises environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation StartAssessment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The AWS account has reached its quota of imports. Contact AWS Support to
//     increase the quota for this account.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment
func (c *MigrationHubStrategyRecommendations) StartAssessment(input *StartAssessmentInput) (*StartAssessmentOutput, error) {
	req, out := c.StartAssessmentRequest(input)
	return out, req.Send()
}

// StartAssessmentWithContext is the same as StartAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) StartAssessmentWithContext(ctx aws.Context, input *StartAssessmentInput, opts ...request.Option) (*StartAssessmentOutput, error) {
	req, out := c.StartAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImportFileTask = "StartImportFileTask"

// StartImportFileTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartImportFileTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImportFileTask for more information on using the StartImportFileTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartImportFileTaskRequest method.
//	req, resp := client.StartImportFileTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask
func (c *MigrationHubStrategyRecommendations) StartImportFileTaskRequest(input *StartImportFileTaskInput) (req *request.Request, output *StartImportFileTaskOutput) {
	op := &request.Operation{
		Name:       opStartImportFileTask,
		HTTPMethod: "POST",
		HTTPPath:   "/start-import-file-task",
	}

	if input == nil {
		input = &StartImportFileTaskInput{}
	}

	output = &StartImportFileTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImportFileTask API operation for Migration Hub Strategy Recommendations.
//
// Starts a file import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation StartImportFileTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The AWS account has reached its quota of imports. Contact AWS Support to
//     increase the quota for this account.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask
func (c *MigrationHubStrategyRecommendations) StartImportFileTask(input *StartImportFileTaskInput) (*StartImportFileTaskOutput, error) {
	req, out := c.StartImportFileTaskRequest(input)
	return out, req.Send()
}

// StartImportFileTaskWithContext is the same as StartImportFileTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartImportFileTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) StartImportFileTaskWithContext(ctx aws.Context, input *StartImportFileTaskInput, opts ...request.Option) (*StartImportFileTaskOutput, error) {
	req, out := c.StartImportFileTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRecommendationReportGeneration = "StartRecommendationReportGeneration"

// StartRecommendationReportGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartRecommendationReportGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRecommendationReportGeneration for more information on using the StartRecommendationReportGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRecommendationReportGenerationRequest method.
//	req, resp := client.StartRecommendationReportGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration
func (c *MigrationHubStrategyRecommendations) StartRecommendationReportGenerationRequest(input *StartRecommendationReportGenerationInput) (req *request.Request, output *StartRecommendationReportGenerationOutput) {
	op := &request.Operation{
		Name:       opStartRecommendationReportGeneration,
		HTTPMethod: "POST",
		HTTPPath:   "/start-recommendation-report-generation",
	}

	if input == nil {
		input = &StartRecommendationReportGenerationInput{}
	}

	output = &StartRecommendationReportGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRecommendationReportGeneration API operation for Migration Hub Strategy Recommendations.
//
// Starts generating a recommendation report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation StartRecommendationReportGeneration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - ConflictException
//     Exception to indicate that there is an ongoing task when a new task is created.
//     Return when once the existing tasks are complete.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration
func (c *MigrationHubStrategyRecommendations) StartRecommendationReportGeneration(input *StartRecommendationReportGenerationInput) (*StartRecommendationReportGenerationOutput, error) {
	req, out := c.StartRecommendationReportGenerationRequest(input)
	return out, req.Send()
}

// StartRecommendationReportGenerationWithContext is the same as StartRecommendationReportGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartRecommendationReportGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) StartRecommendationReportGenerationWithContext(ctx aws.Context, input *StartRecommendationReportGenerationInput, opts ...request.Option) (*StartRecommendationReportGenerationOutput, error) {
	req, out := c.StartRecommendationReportGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAssessment = "StopAssessment"

// StopAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StopAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAssessment for more information on using the StopAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopAssessmentRequest method.
//	req, resp := client.StopAssessmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment
func (c *MigrationHubStrategyRecommendations) StopAssessmentRequest(input *StopAssessmentInput) (req *request.Request, output *StopAssessmentOutput) {
	op := &request.Operation{
		Name:       opStopAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/stop-assessment",
	}

	if input == nil {
		input = &StopAssessmentInput{}
	}

	output = &StopAssessmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAssessment API operation for Migration Hub Strategy Recommendations.
//
// Stops the assessment of an on-premises environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation StopAssessment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The AWS user account does not have permission to perform the action. Check
//     the AWS Identity and Access Management (IAM) policy associated with this
//     account.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment
func (c *MigrationHubStrategyRecommendations) StopAssessment(input *StopAssessmentInput) (*StopAssessmentOutput, error) {
	req, out := c.StopAssessmentRequest(input)
	return out, req.Send()
}

// StopAssessmentWithContext is the same as StopAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StopAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) StopAssessmentWithContext(ctx aws.Context, input *StopAssessmentInput, opts ...request.Option) (*StopAssessmentOutput, error) {
	req, out := c.StopAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationComponentConfig = "UpdateApplicationComponentConfig"

// UpdateApplicationComponentConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationComponentConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationComponentConfig for more information on using the UpdateApplicationComponentConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationComponentConfigRequest method.
//	req, resp := client.UpdateApplicationComponentConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig
func (c *MigrationHubStrategyRecommendations) UpdateApplicationComponentConfigRequest(input *UpdateApplicationComponentConfigInput) (req *request.Request, output *UpdateApplicationComponentConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationComponentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/update-applicationcomponent-config/",
	}

	if input == nil {
		input = &UpdateApplicationComponentConfigInput{}
	}

	output = &UpdateApplicationComponentConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplicationComponentConfig API operation for Migration Hub Strategy Recommendations.
//
// Updates the configuration of an application component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation UpdateApplicationComponentConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig
func (c *MigrationHubStrategyRecommendations) UpdateApplicationComponentConfig(input *UpdateApplicationComponentConfigInput) (*UpdateApplicationComponentConfigOutput, error) {
	req, out := c.UpdateApplicationComponentConfigRequest(input)
	return out, req.Send()
}

// UpdateApplicationComponentConfigWithContext is the same as UpdateApplicationComponentConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationComponentConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) UpdateApplicationComponentConfigWithContext(ctx aws.Context, input *UpdateApplicationComponentConfigInput, opts ...request.Option) (*UpdateApplicationComponentConfigOutput, error) {
	req, out := c.UpdateApplicationComponentConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServerConfig = "UpdateServerConfig"

// UpdateServerConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServerConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServerConfig for more information on using the UpdateServerConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServerConfigRequest method.
//	req, resp := client.UpdateServerConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig
func (c *MigrationHubStrategyRecommendations) UpdateServerConfigRequest(input *UpdateServerConfigInput) (req *request.Request, output *UpdateServerConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateServerConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/update-server-config/",
	}

	if input == nil {
		input = &UpdateServerConfigInput{}
	}

	output = &UpdateServerConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServerConfig API operation for Migration Hub Strategy Recommendations.
//
// Updates the configuration of the specified server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Migration Hub Strategy Recommendations's
// API operation UpdateServerConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified ID in the request is not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The request body isn't valid.
//
//   - InternalServerException
//     The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig
func (c *MigrationHubStrategyRecommendations) UpdateServerConfig(input *UpdateServerConfigInput) (*UpdateServerConfigOutput, error) {
	req, out := c.UpdateServerConfigRequest(input)
	return out, req.Send()
}

// UpdateServerConfigWithContext is the same as UpdateServerConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServerConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubStrategyRecommendations) UpdateServerConfigWithContext(ctx aws.Context, input *UpdateServerConfigInput, opts ...request.Option) (*UpdateServerConfigOutput, error) {
	req, out := c.UpdateServerConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The AWS user account does not have permission to perform the action. Check
// the AWS Identity and Access Management (IAM) policy associated with this
// account.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the summary of anti-patterns and their severity.
type AntipatternSeveritySummary struct {
	_ struct{} `type:"structure"`

	// Contains the count of anti-patterns.
	Count *int64 `locationName:"count" type:"integer"`

	// Contains the severity of anti-patterns.
	Severity *string `locationName:"severity" type:"string" enum:"Severity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AntipatternSeveritySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AntipatternSeveritySummary) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *AntipatternSeveritySummary) SetCount(v int64) *AntipatternSeveritySummary {
	s.Count = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AntipatternSeveritySummary) SetSeverity(v string) *AntipatternSeveritySummary {
	s.Severity = &v
	return s
}

// Error in the analysis of the application unit.
type AppUnitError struct {
	_ struct{} `type:"structure"`

	// The category of the error.
	AppUnitErrorCategory *string `locationName:"appUnitErrorCategory" type:"string" enum:"AppUnitErrorCategory"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppUnitError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppUnitError) GoString() string {
	return s.String()
}

// SetAppUnitErrorCategory sets the AppUnitErrorCategory field's value.
func (s *AppUnitError) SetAppUnitErrorCategory(v string) *AppUnitError {
	s.AppUnitErrorCategory = &v
	return s
}

// Contains detailed information about an application component.
type ApplicationComponentDetail struct {
	_ struct{} `type:"structure"`

	// The status of analysis, if the application component has source code or an
	// associated database.
	AnalysisStatus *string `locationName:"analysisStatus" type:"string" enum:"SrcCodeOrDbAnalysisStatus"`

	// The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
	AntipatternReportS3Object *S3Object `locationName:"antipatternReportS3Object" type:"structure"`

	// The status of the anti-pattern report generation.
	AntipatternReportStatus *string `locationName:"antipatternReportStatus" type:"string" enum:"AntipatternReportStatus"`

	// The status message for the anti-pattern.
	AntipatternReportStatusMessage *string `locationName:"antipatternReportStatusMessage" type:"string"`

	// The type of application component.
	AppType *string `locationName:"appType" type:"string" enum:"AppType"`

	// The error in the analysis of the source code or database.
	AppUnitError *AppUnitError `locationName:"appUnitError" type:"structure"`

	// The ID of the server that the application component is running on.
	AssociatedServerId *string `locationName:"associatedServerId" min:"1" type:"string"`

	// Configuration details for the database associated with the application component.
	DatabaseConfigDetail *DatabaseConfigDetail `locationName:"databaseConfigDetail" type:"structure"`

	// The ID of the application component.
	Id *string `locationName:"id" type:"string"`

	// Indicates whether the application component has been included for server
	// recommendation or not.
	InclusionStatus *string `locationName:"inclusionStatus" type:"string" enum:"InclusionStatus"`

	// The timestamp of when the application component was assessed.
	LastAnalyzedTimestamp *time.Time `locationName:"lastAnalyzedTimestamp" type:"timestamp"`

	// A list of anti-pattern severity summaries.
	ListAntipatternSeveritySummary []*AntipatternSeveritySummary `locationName:"listAntipatternSeveritySummary" type:"list"`

	// Set to true if the application component is running on multiple servers.
	MoreServerAssociationExists *bool `locationName:"moreServerAssociationExists" type:"boolean"`

	// The name of application component.
	Name *string `locationName:"name" type:"string"`

	// OS driver.
	OsDriver *string `locationName:"osDriver" type:"string"`

	// OS version.
	OsVersion *string `locationName:"osVersion" type:"string"`

	// The top recommendation set for the application component.
	RecommendationSet *RecommendationSet `locationName:"recommendationSet" type:"structure"`

	// The application component subtype.
	ResourceSubType *string `locationName:"resourceSubType" type:"string" enum:"ResourceSubType"`

	// The status of the application unit.
	RuntimeStatus *string `locationName:"runtimeStatus" type:"string" enum:"RuntimeAnalysisStatus"`

	// The status message for the application unit.
	RuntimeStatusMessage *string `locationName:"runtimeStatusMessage" type:"string"`

	// Details about the source code repository associated with the application
	// component.
	SourceCodeRepositories []*SourceCodeRepository `locationName:"sourceCodeRepositories" type:"list"`

	// A detailed description of the analysis status and any failure message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentDetail) GoString() string {
	return s.String()
}

// SetAnalysisStatus sets the AnalysisStatus field's value.
func (s *ApplicationComponentDetail) SetAnalysisStatus(v string) *ApplicationComponentDetail {
	s.AnalysisStatus = &v
	return s
}

// SetAntipatternReportS3Object sets the AntipatternReportS3Object field's value.
func (s *ApplicationComponentDetail) SetAntipatternReportS3Object(v *S3Object) *ApplicationComponentDetail {
	s.AntipatternReportS3Object = v
	return s
}

// SetAntipatternReportStatus sets the AntipatternReportStatus field's value.
func (s *ApplicationComponentDetail) SetAntipatternReportStatus(v string) *ApplicationComponentDetail {
	s.AntipatternReportStatus = &v
	return s
}

// SetAntipatternReportStatusMessage sets the AntipatternReportStatusMessage field's value.
func (s *ApplicationComponentDetail) SetAntipatternReportStatusMessage(v string) *ApplicationComponentDetail {
	s.AntipatternReportStatusMessage = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *ApplicationComponentDetail) SetAppType(v string) *ApplicationComponentDetail {
	s.AppType = &v
	return s
}

// SetAppUnitError sets the AppUnitError field's value.
func (s *ApplicationComponentDetail) SetAppUnitError(v *AppUnitError) *ApplicationComponentDetail {
	s.AppUnitError = v
	return s
}

// SetAssociatedServerId sets the AssociatedServerId field's value.
func (s *ApplicationComponentDetail) SetAssociatedServerId(v string) *ApplicationComponentDetail {
	s.AssociatedServerId = &v
	return s
}

// SetDatabaseConfigDetail sets the DatabaseConfigDetail field's value.
func (s *ApplicationComponentDetail) SetDatabaseConfigDetail(v *DatabaseConfigDetail) *ApplicationComponentDetail {
	s.DatabaseConfigDetail = v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationComponentDetail) SetId(v string) *ApplicationComponentDetail {
	s.Id = &v
	return s
}

// SetInclusionStatus sets the InclusionStatus field's value.
func (s *ApplicationComponentDetail) SetInclusionStatus(v string) *ApplicationComponentDetail {
	s.InclusionStatus = &v
	return s
}

// SetLastAnalyzedTimestamp sets the LastAnalyzedTimestamp field's value.
func (s *ApplicationComponentDetail) SetLastAnalyzedTimestamp(v time.Time) *ApplicationComponentDetail {
	s.LastAnalyzedTimestamp = &v
	return s
}

// SetListAntipatternSeveritySummary sets the ListAntipatternSeveritySummary field's value.
func (s *ApplicationComponentDetail) SetListAntipatternSeveritySummary(v []*AntipatternSeveritySummary) *ApplicationComponentDetail {
	s.ListAntipatternSeveritySummary = v
	return s
}

// SetMoreServerAssociationExists sets the MoreServerAssociationExists field's value.
func (s *ApplicationComponentDetail) SetMoreServerAssociationExists(v bool) *ApplicationComponentDetail {
	s.MoreServerAssociationExists = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationComponentDetail) SetName(v string) *ApplicationComponentDetail {
	s.Name = &v
	return s
}

// SetOsDriver sets the OsDriver field's value.
func (s *ApplicationComponentDetail) SetOsDriver(v string) *ApplicationComponentDetail {
	s.OsDriver = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *ApplicationComponentDetail) SetOsVersion(v string) *ApplicationComponentDetail {
	s.OsVersion = &v
	return s
}

// SetRecommendationSet sets the RecommendationSet field's value.
func (s *ApplicationComponentDetail) SetRecommendationSet(v *RecommendationSet) *ApplicationComponentDetail {
	s.RecommendationSet = v
	return s
}

// SetResourceSubType sets the ResourceSubType field's value.
func (s *ApplicationComponentDetail) SetResourceSubType(v string) *ApplicationComponentDetail {
	s.ResourceSubType = &v
	return s
}

// SetRuntimeStatus sets the RuntimeStatus field's value.
func (s *ApplicationComponentDetail) SetRuntimeStatus(v string) *ApplicationComponentDetail {
	s.RuntimeStatus = &v
	return s
}

// SetRuntimeStatusMessage sets the RuntimeStatusMessage field's value.
func (s *ApplicationComponentDetail) SetRuntimeStatusMessage(v string) *ApplicationComponentDetail {
	s.RuntimeStatusMessage = &v
	return s
}

// SetSourceCodeRepositories sets the SourceCodeRepositories field's value.
func (s *ApplicationComponentDetail) SetSourceCodeRepositories(v []*SourceCodeRepository) *ApplicationComponentDetail {
	s.SourceCodeRepositories = v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ApplicationComponentDetail) SetStatusMessage(v string) *ApplicationComponentDetail {
	s.StatusMessage = &v
	return s
}

// Summary of the analysis status of the application component.
type ApplicationComponentStatusSummary struct {
	_ struct{} `type:"structure"`

	// The number of application components successfully analyzed, partially successful
	// or failed analysis.
	Count *int64 `locationName:"count" type:"integer"`

	// The status of database analysis.
	SrcCodeOrDbAnalysisStatus *string `locationName:"srcCodeOrDbAnalysisStatus" type:"string" enum:"SrcCodeOrDbAnalysisStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentStatusSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentStatusSummary) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ApplicationComponentStatusSummary) SetCount(v int64) *ApplicationComponentStatusSummary {
	s.Count = &v
	return s
}

// SetSrcCodeOrDbAnalysisStatus sets the SrcCodeOrDbAnalysisStatus field's value.
func (s *ApplicationComponentStatusSummary) SetSrcCodeOrDbAnalysisStatus(v string) *ApplicationComponentStatusSummary {
	s.SrcCodeOrDbAnalysisStatus = &v
	return s
}

// Contains information about a strategy recommendation for an application component.
type ApplicationComponentStrategy struct {
	_ struct{} `type:"structure"`

	// Set to true if the recommendation is set as preferred.
	IsPreferred *bool `locationName:"isPreferred" type:"boolean"`

	// Strategy recommendation for the application component.
	Recommendation *RecommendationSet `locationName:"recommendation" type:"structure"`

	// The recommendation status of a strategy for an application component.
	Status *string `locationName:"status" type:"string" enum:"StrategyRecommendation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentStrategy) GoString() string {
	return s.String()
}

// SetIsPreferred sets the IsPreferred field's value.
func (s *ApplicationComponentStrategy) SetIsPreferred(v bool) *ApplicationComponentStrategy {
	s.IsPreferred = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *ApplicationComponentStrategy) SetRecommendation(v *RecommendationSet) *ApplicationComponentStrategy {
	s.Recommendation = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationComponentStrategy) SetStatus(v string) *ApplicationComponentStrategy {
	s.Status = &v
	return s
}

// Contains the summary of application components.
type ApplicationComponentSummary struct {
	_ struct{} `type:"structure"`

	// Contains the name of application types.
	AppType *string `locationName:"appType" type:"string" enum:"AppType"`

	// Contains the count of application type.
	Count *int64 `locationName:"count" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationComponentSummary) GoString() string {
	return s.String()
}

// SetAppType sets the AppType field's value.
func (s *ApplicationComponentSummary) SetAppType(v string) *ApplicationComponentSummary {
	s.AppType = &v
	return s
}

// SetCount sets the Count field's value.
func (s *ApplicationComponentSummary) SetCount(v int64) *ApplicationComponentSummary {
	s.Count = &v
	return s
}

// Application preferences that you specify.
type ApplicationPreferences struct {
	_ struct{} `type:"structure"`

	// Application preferences that you specify to prefer managed environment.
	ManagementPreference *ManagementPreference `locationName:"managementPreference" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationPreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationPreferences"}
	if s.ManagementPreference != nil {
		if err := s.ManagementPreference.Validate(); err != nil {
			invalidParams.AddNested("ManagementPreference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagementPreference sets the ManagementPreference field's value.
func (s *ApplicationPreferences) SetManagementPreference(v *ManagementPreference) *ApplicationPreferences {
	s.ManagementPreference = v
	return s
}

// Contains the summary of the assessment results.
type AssessmentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 object containing the anti-pattern report.
	AntipatternReportS3Object *S3Object `locationName:"antipatternReportS3Object" type:"structure"`

	// The status of the anti-pattern report.
	AntipatternReportStatus *string `locationName:"antipatternReportStatus" type:"string" enum:"AntipatternReportStatus"`

	// The status message of the anti-pattern report.
	AntipatternReportStatusMessage *string `locationName:"antipatternReportStatusMessage" type:"string"`

	// The time the assessment was performed.
	LastAnalyzedTimestamp *time.Time `locationName:"lastAnalyzedTimestamp" type:"timestamp"`

	// List of AntipatternSeveritySummary.
	ListAntipatternSeveritySummary []*AntipatternSeveritySummary `locationName:"listAntipatternSeveritySummary" type:"list"`

	// List of status summaries of the analyzed application components.
	ListApplicationComponentStatusSummary []*ApplicationComponentStatusSummary `locationName:"listApplicationComponentStatusSummary" type:"list"`

	// List of ApplicationComponentStrategySummary.
	ListApplicationComponentStrategySummary []*StrategySummary `locationName:"listApplicationComponentStrategySummary" type:"list"`

	// List of ApplicationComponentSummary.
	ListApplicationComponentSummary []*ApplicationComponentSummary `locationName:"listApplicationComponentSummary" type:"list"`

	// List of status summaries of the analyzed servers.
	ListServerStatusSummary []*ServerStatusSummary `locationName:"listServerStatusSummary" type:"list"`

	// List of ServerStrategySummary.
	ListServerStrategySummary []*StrategySummary `locationName:"listServerStrategySummary" type:"list"`

	// List of ServerSummary.
	ListServerSummary []*ServerSummary `locationName:"listServerSummary" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssessmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssessmentSummary) GoString() string {
	return s.String()
}

// SetAntipatternReportS3Object sets the AntipatternReportS3Object field's value.
func (s *AssessmentSummary) SetAntipatternReportS3Object(v *S3Object) *AssessmentSummary {
	s.AntipatternReportS3Object = v
	return s
}

// SetAntipatternReportStatus sets the AntipatternReportStatus field's value.
func (s *AssessmentSummary) SetAntipatternReportStatus(v string) *AssessmentSummary {
	s.AntipatternReportStatus = &v
	return s
}

// SetAntipatternReportStatusMessage sets the AntipatternReportStatusMessage field's value.
func (s *AssessmentSummary) SetAntipatternReportStatusMessage(v string) *AssessmentSummary {
	s.AntipatternReportStatusMessage = &v
	return s
}

// SetLastAnalyzedTimestamp sets the LastAnalyzedTimestamp field's value.
func (s *AssessmentSummary) SetLastAnalyzedTimestamp(v time.Time) *AssessmentSummary {
	s.LastAnalyzedTimestamp = &v
	return s
}

// SetListAntipatternSeveritySummary sets the ListAntipatternSeveritySummary field's value.
func (s *AssessmentSummary) SetListAntipatternSeveritySummary(v []*AntipatternSeveritySummary) *AssessmentSummary {
	s.ListAntipatternSeveritySummary = v
	return s
}

// SetListApplicationComponentStatusSummary sets the ListApplicationComponentStatusSummary field's value.
func (s *AssessmentSummary) SetListApplicationComponentStatusSummary(v []*ApplicationComponentStatusSummary) *AssessmentSummary {
	s.ListApplicationComponentStatusSummary = v
	return s
}

// SetListApplicationComponentStrategySummary sets the ListApplicationComponentStrategySummary field's value.
func (s *AssessmentSummary) SetListApplicationComponentStrategySummary(v []*StrategySummary) *AssessmentSummary {
	s.ListApplicationComponentStrategySummary = v
	return s
}

// SetListApplicationComponentSummary sets the ListApplicationComponentSummary field's value.
func (s *AssessmentSummary) SetListApplicationComponentSummary(v []*ApplicationComponentSummary) *AssessmentSummary {
	s.ListApplicationComponentSummary = v
	return s
}

// SetListServerStatusSummary sets the ListServerStatusSummary field's value.
func (s *AssessmentSummary) SetListServerStatusSummary(v []*ServerStatusSummary) *AssessmentSummary {
	s.ListServerStatusSummary = v
	return s
}

// SetListServerStrategySummary sets the ListServerStrategySummary field's value.
func (s *AssessmentSummary) SetListServerStrategySummary(v []*StrategySummary) *AssessmentSummary {
	s.ListServerStrategySummary = v
	return s
}

// SetListServerSummary sets the ListServerSummary field's value.
func (s *AssessmentSummary) SetListServerSummary(v []*ServerSummary) *AssessmentSummary {
	s.ListServerSummary = v
	return s
}

// Defines the criteria of assessment.
type AssessmentTarget struct {
	_ struct{} `type:"structure"`

	// Condition of an assessment.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true" enum:"Condition"`

	// Name of an assessment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Values of an assessment.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssessmentTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssessmentTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssessmentTarget"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *AssessmentTarget) SetCondition(v string) *AssessmentTarget {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentTarget) SetName(v string) *AssessmentTarget {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AssessmentTarget) SetValues(v []*string) *AssessmentTarget {
	s.Values = v
	return s
}

// Object containing details about applications as defined in Application Discovery
// Service.
type AssociatedApplication struct {
	_ struct{} `type:"structure"`

	// ID of the application as defined in Application Discovery Service.
	Id *string `locationName:"id" type:"string"`

	// Name of the application as defined in Application Discovery Service.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedApplication) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AssociatedApplication) SetId(v string) *AssociatedApplication {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociatedApplication) SetName(v string) *AssociatedApplication {
	s.Name = &v
	return s
}

// Object containing the choice of application destination that you specify.
type AwsManagedResources struct {
	_ struct{} `type:"structure"`

	// The choice of application destination that you specify.
	//
	// TargetDestination is a required field
	TargetDestination []*string `locationName:"targetDestination" min:"1" type:"list" required:"true" enum:"AwsManagedTargetDestination"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsManagedResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsManagedResources) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsManagedResources) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsManagedResources"}
	if s.TargetDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDestination"))
	}
	if s.TargetDestination != nil && len(s.TargetDestination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetDestination", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *AwsManagedResources) SetTargetDestination(v []*string) *AwsManagedResources {
	s.TargetDestination = v
	return s
}

// Business goals that you specify.
type BusinessGoals struct {
	_ struct{} `type:"structure"`

	// Business goal to reduce license costs.
	LicenseCostReduction *int64 `locationName:"licenseCostReduction" min:"1" type:"integer"`

	// Business goal to modernize infrastructure by moving to cloud native technologies.
	ModernizeInfrastructureWithCloudNativeTechnologies *int64 `locationName:"modernizeInfrastructureWithCloudNativeTechnologies" min:"1" type:"integer"`

	// Business goal to reduce the operational overhead on the team by moving into
	// managed services.
	ReduceOperationalOverheadWithManagedServices *int64 `locationName:"reduceOperationalOverheadWithManagedServices" min:"1" type:"integer"`

	// Business goal to achieve migration at a fast pace.
	SpeedOfMigration *int64 `locationName:"speedOfMigration" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessGoals) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessGoals) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BusinessGoals) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BusinessGoals"}
	if s.LicenseCostReduction != nil && *s.LicenseCostReduction < 1 {
		invalidParams.Add(request.NewErrParamMinValue("LicenseCostReduction", 1))
	}
	if s.ModernizeInfrastructureWithCloudNativeTechnologies != nil && *s.ModernizeInfrastructureWithCloudNativeTechnologies < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ModernizeInfrastructureWithCloudNativeTechnologies", 1))
	}
	if s.ReduceOperationalOverheadWithManagedServices != nil && *s.ReduceOperationalOverheadWithManagedServices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReduceOperationalOverheadWithManagedServices", 1))
	}
	if s.SpeedOfMigration != nil && *s.SpeedOfMigration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SpeedOfMigration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseCostReduction sets the LicenseCostReduction field's value.
func (s *BusinessGoals) SetLicenseCostReduction(v int64) *BusinessGoals {
	s.LicenseCostReduction = &v
	return s
}

// SetModernizeInfrastructureWithCloudNativeTechnologies sets the ModernizeInfrastructureWithCloudNativeTechnologies field's value.
func (s *BusinessGoals) SetModernizeInfrastructureWithCloudNativeTechnologies(v int64) *BusinessGoals {
	s.ModernizeInfrastructureWithCloudNativeTechnologies = &v
	return s
}

// SetReduceOperationalOverheadWithManagedServices sets the ReduceOperationalOverheadWithManagedServices field's value.
func (s *BusinessGoals) SetReduceOperationalOverheadWithManagedServices(v int64) *BusinessGoals {
	s.ReduceOperationalOverheadWithManagedServices = &v
	return s
}

// SetSpeedOfMigration sets the SpeedOfMigration field's value.
func (s *BusinessGoals) SetSpeedOfMigration(v int64) *BusinessGoals {
	s.SpeedOfMigration = &v
	return s
}

// Process data collector that runs in the environment that you specify.
type Collector struct {
	_ struct{} `type:"structure"`

	// Indicates the health of a collector.
	CollectorHealth *string `locationName:"collectorHealth" type:"string" enum:"CollectorHealth"`

	// The ID of the collector.
	CollectorId *string `locationName:"collectorId" type:"string"`

	// Current version of the collector that is running in the environment that
	// you specify.
	CollectorVersion *string `locationName:"collectorVersion" type:"string"`

	// Summary of the collector configuration.
	ConfigurationSummary *ConfigurationSummary `locationName:"configurationSummary" type:"structure"`

	// Hostname of the server that is hosting the collector.
	HostName *string `locationName:"hostName" type:"string"`

	// IP address of the server that is hosting the collector.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// Time when the collector last pinged the service.
	LastActivityTimeStamp *string `locationName:"lastActivityTimeStamp" type:"string"`

	// Time when the collector registered with the service.
	RegisteredTimeStamp *string `locationName:"registeredTimeStamp" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Collector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Collector) GoString() string {
	return s.String()
}

// SetCollectorHealth sets the CollectorHealth field's value.
func (s *Collector) SetCollectorHealth(v string) *Collector {
	s.CollectorHealth = &v
	return s
}

// SetCollectorId sets the CollectorId field's value.
func (s *Collector) SetCollectorId(v string) *Collector {
	s.CollectorId = &v
	return s
}

// SetCollectorVersion sets the CollectorVersion field's value.
func (s *Collector) SetCollectorVersion(v string) *Collector {
	s.CollectorVersion = &v
	return s
}

// SetConfigurationSummary sets the ConfigurationSummary field's value.
func (s *Collector) SetConfigurationSummary(v *ConfigurationSummary) *Collector {
	s.ConfigurationSummary = v
	return s
}

// SetHostName sets the HostName field's value.
func (s *Collector) SetHostName(v string) *Collector {
	s.HostName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Collector) SetIpAddress(v string) *Collector {
	s.IpAddress = &v
	return s
}

// SetLastActivityTimeStamp sets the LastActivityTimeStamp field's value.
func (s *Collector) SetLastActivityTimeStamp(v string) *Collector {
	s.LastActivityTimeStamp = &v
	return s
}

// SetRegisteredTimeStamp sets the RegisteredTimeStamp field's value.
func (s *Collector) SetRegisteredTimeStamp(v string) *Collector {
	s.RegisteredTimeStamp = &v
	return s
}

// Summary of the collector configuration.
type ConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// IP address based configurations.
	IpAddressBasedRemoteInfoList []*IPAddressBasedRemoteInfo `locationName:"ipAddressBasedRemoteInfoList" type:"list"`

	// The list of pipeline info configurations.
	PipelineInfoList []*PipelineInfo `locationName:"pipelineInfoList" type:"list"`

	// Info about the remote server source code configuration.
	RemoteSourceCodeAnalysisServerInfo *RemoteSourceCodeAnalysisServerInfo `locationName:"remoteSourceCodeAnalysisServerInfo" type:"structure"`

	// The list of vCenter configurations.
	VcenterBasedRemoteInfoList []*VcenterBasedRemoteInfo `locationName:"vcenterBasedRemoteInfoList" type:"list"`

	// The list of the version control configurations.
	VersionControlInfoList []*VersionControlInfo `locationName:"versionControlInfoList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSummary) GoString() string {
	return s.String()
}

// SetIpAddressBasedRemoteInfoList sets the IpAddressBasedRemoteInfoList field's value.
func (s *ConfigurationSummary) SetIpAddressBasedRemoteInfoList(v []*IPAddressBasedRemoteInfo) *ConfigurationSummary {
	s.IpAddressBasedRemoteInfoList = v
	return s
}

// SetPipelineInfoList sets the PipelineInfoList field's value.
func (s *ConfigurationSummary) SetPipelineInfoList(v []*PipelineInfo) *ConfigurationSummary {
	s.PipelineInfoList = v
	return s
}

// SetRemoteSourceCodeAnalysisServerInfo sets the RemoteSourceCodeAnalysisServerInfo field's value.
func (s *ConfigurationSummary) SetRemoteSourceCodeAnalysisServerInfo(v *RemoteSourceCodeAnalysisServerInfo) *ConfigurationSummary {
	s.RemoteSourceCodeAnalysisServerInfo = v
	return s
}

// SetVcenterBasedRemoteInfoList sets the VcenterBasedRemoteInfoList field's value.
func (s *ConfigurationSummary) SetVcenterBasedRemoteInfoList(v []*VcenterBasedRemoteInfo) *ConfigurationSummary {
	s.VcenterBasedRemoteInfoList = v
	return s
}

// SetVersionControlInfoList sets the VersionControlInfoList field's value.
func (s *ConfigurationSummary) SetVersionControlInfoList(v []*VersionControlInfo) *ConfigurationSummary {
	s.VersionControlInfoList = v
	return s
}

// Exception to indicate that there is an ongoing task when a new task is created.
// Return when once the existing tasks are complete.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detailed information about an assessment.
type DataCollectionDetails struct {
	_ struct{} `type:"structure"`

	// The time the assessment completes.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp"`

	// The number of failed servers in the assessment.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of servers with the assessment status IN_PROGESS.
	InProgress *int64 `locationName:"inProgress" type:"integer"`

	// The total number of servers in the assessment.
	Servers *int64 `locationName:"servers" type:"integer"`

	// The start time of assessment.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the assessment.
	Status *string `locationName:"status" type:"string" enum:"AssessmentStatus"`

	// The status message of the assessment.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The number of successful servers in the assessment.
	Success *int64 `locationName:"success" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCollectionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCollectionDetails) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *DataCollectionDetails) SetCompletionTime(v time.Time) *DataCollectionDetails {
	s.CompletionTime = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *DataCollectionDetails) SetFailed(v int64) *DataCollectionDetails {
	s.Failed = &v
	return s
}

// SetInProgress sets the InProgress field's value.
func (s *DataCollectionDetails) SetInProgress(v int64) *DataCollectionDetails {
	s.InProgress = &v
	return s
}

// SetServers sets the Servers field's value.
func (s *DataCollectionDetails) SetServers(v int64) *DataCollectionDetails {
	s.Servers = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DataCollectionDetails) SetStartTime(v time.Time) *DataCollectionDetails {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataCollectionDetails) SetStatus(v string) *DataCollectionDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DataCollectionDetails) SetStatusMessage(v string) *DataCollectionDetails {
	s.StatusMessage = &v
	return s
}

// SetSuccess sets the Success field's value.
func (s *DataCollectionDetails) SetSuccess(v int64) *DataCollectionDetails {
	s.Success = &v
	return s
}

// Configuration information used for assessing databases.
type DatabaseConfigDetail struct {
	_ struct{} `type:"structure"`

	// AWS Secrets Manager key that holds the credentials that you use to connect
	// to a database.
	SecretName *string `locationName:"secretName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConfigDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConfigDetail) GoString() string {
	return s.String()
}

// SetSecretName sets the SecretName field's value.
func (s *DatabaseConfigDetail) SetSecretName(v string) *DatabaseConfigDetail {
	s.SecretName = &v
	return s
}

// Preferences for migrating a database to AWS.
type DatabaseMigrationPreference struct {
	_ struct{} `type:"structure"`

	// Indicates whether you are interested in moving from one type of database
	// to another. For example, from SQL Server to Amazon Aurora MySQL-Compatible
	// Edition.
	Heterogeneous *Heterogeneous `locationName:"heterogeneous" type:"structure"`

	// Indicates whether you are interested in moving to the same type of database
	// into AWS. For example, from SQL Server in your environment to SQL Server
	// on AWS.
	Homogeneous *Homogeneous `locationName:"homogeneous" type:"structure"`

	// Indicated that you do not prefer heterogeneous or homogeneous.
	NoPreference *NoDatabaseMigrationPreference `locationName:"noPreference" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseMigrationPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseMigrationPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseMigrationPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseMigrationPreference"}
	if s.Heterogeneous != nil {
		if err := s.Heterogeneous.Validate(); err != nil {
			invalidParams.AddNested("Heterogeneous", err.(request.ErrInvalidParams))
		}
	}
	if s.NoPreference != nil {
		if err := s.NoPreference.Validate(); err != nil {
			invalidParams.AddNested("NoPreference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeterogeneous sets the Heterogeneous field's value.
func (s *DatabaseMigrationPreference) SetHeterogeneous(v *Heterogeneous) *DatabaseMigrationPreference {
	s.Heterogeneous = v
	return s
}

// SetHomogeneous sets the Homogeneous field's value.
func (s *DatabaseMigrationPreference) SetHomogeneous(v *Homogeneous) *DatabaseMigrationPreference {
	s.Homogeneous = v
	return s
}

// SetNoPreference sets the NoPreference field's value.
func (s *DatabaseMigrationPreference) SetNoPreference(v *NoDatabaseMigrationPreference) *DatabaseMigrationPreference {
	s.NoPreference = v
	return s
}

// Preferences on managing your databases on AWS.
type DatabasePreferences struct {
	_ struct{} `type:"structure"`

	// Specifies whether you're interested in self-managed databases or databases
	// managed by AWS.
	DatabaseManagementPreference *string `locationName:"databaseManagementPreference" type:"string" enum:"DatabaseManagementPreference"`

	// Specifies your preferred migration path.
	DatabaseMigrationPreference *DatabaseMigrationPreference `locationName:"databaseMigrationPreference" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabasePreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabasePreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabasePreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabasePreferences"}
	if s.DatabaseMigrationPreference != nil {
		if err := s.DatabaseMigrationPreference.Validate(); err != nil {
			invalidParams.AddNested("DatabaseMigrationPreference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseManagementPreference sets the DatabaseManagementPreference field's value.
func (s *DatabasePreferences) SetDatabaseManagementPreference(v string) *DatabasePreferences {
	s.DatabaseManagementPreference = &v
	return s
}

// SetDatabaseMigrationPreference sets the DatabaseMigrationPreference field's value.
func (s *DatabasePreferences) SetDatabaseMigrationPreference(v *DatabaseMigrationPreference) *DatabasePreferences {
	s.DatabaseMigrationPreference = v
	return s
}

// Dependency encountered an error.
type DependencyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyException) GoString() string {
	return s.String()
}

func newErrorDependencyException(v protocol.ResponseMetadata) error {
	return &DependencyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyException) Code() string {
	return "DependencyException"
}

// Message returns the exception's message.
func (s *DependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyException) OrigErr() error {
	return nil
}

func (s *DependencyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetApplicationComponentDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application component. The ID is unique within an AWS account.
	//
	// ApplicationComponentId is a required field
	ApplicationComponentId *string `location:"uri" locationName:"applicationComponentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationComponentDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationComponentDetailsInput"}
	if s.ApplicationComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationComponentId"))
	}
	if s.ApplicationComponentId != nil && len(*s.ApplicationComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationComponentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationComponentId sets the ApplicationComponentId field's value.
func (s *GetApplicationComponentDetailsInput) SetApplicationComponentId(v string) *GetApplicationComponentDetailsInput {
	s.ApplicationComponentId = &v
	return s
}

type GetApplicationComponentDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an application component.
	ApplicationComponentDetail *ApplicationComponentDetail `locationName:"applicationComponentDetail" type:"structure"`

	// The associated application group as defined in AWS Application Discovery
	// Service.
	AssociatedApplications []*AssociatedApplication `locationName:"associatedApplications" type:"list"`

	// A list of the IDs of the servers on which the application component is running.
	AssociatedServerIds []*string `locationName:"associatedServerIds" type:"list"`

	// Set to true if the application component belongs to more than one application
	// group.
	MoreApplicationResource *bool `locationName:"moreApplicationResource" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentDetailsOutput) GoString() string {
	return s.String()
}

// SetApplicationComponentDetail sets the ApplicationComponentDetail field's value.
func (s *GetApplicationComponentDetailsOutput) SetApplicationComponentDetail(v *ApplicationComponentDetail) *GetApplicationComponentDetailsOutput {
	s.ApplicationComponentDetail = v
	return s
}

// SetAssociatedApplications sets the AssociatedApplications field's value.
func (s *GetApplicationComponentDetailsOutput) SetAssociatedApplications(v []*AssociatedApplication) *GetApplicationComponentDetailsOutput {
	s.AssociatedApplications = v
	return s
}

// SetAssociatedServerIds sets the AssociatedServerIds field's value.
func (s *GetApplicationComponentDetailsOutput) SetAssociatedServerIds(v []*string) *GetApplicationComponentDetailsOutput {
	s.AssociatedServerIds = v
	return s
}

// SetMoreApplicationResource sets the MoreApplicationResource field's value.
func (s *GetApplicationComponentDetailsOutput) SetMoreApplicationResource(v bool) *GetApplicationComponentDetailsOutput {
	s.MoreApplicationResource = &v
	return s
}

type GetApplicationComponentStrategiesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application component. The ID is unique within an AWS account.
	//
	// ApplicationComponentId is a required field
	ApplicationComponentId *string `location:"uri" locationName:"applicationComponentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentStrategiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentStrategiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationComponentStrategiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationComponentStrategiesInput"}
	if s.ApplicationComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationComponentId"))
	}
	if s.ApplicationComponentId != nil && len(*s.ApplicationComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationComponentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationComponentId sets the ApplicationComponentId field's value.
func (s *GetApplicationComponentStrategiesInput) SetApplicationComponentId(v string) *GetApplicationComponentStrategiesInput {
	s.ApplicationComponentId = &v
	return s
}

type GetApplicationComponentStrategiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of application component strategy recommendations.
	ApplicationComponentStrategies []*ApplicationComponentStrategy `locationName:"applicationComponentStrategies" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentStrategiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationComponentStrategiesOutput) GoString() string {
	return s.String()
}

// SetApplicationComponentStrategies sets the ApplicationComponentStrategies field's value.
func (s *GetApplicationComponentStrategiesOutput) SetApplicationComponentStrategies(v []*ApplicationComponentStrategy) *GetApplicationComponentStrategiesOutput {
	s.ApplicationComponentStrategies = v
	return s
}

type GetAssessmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The assessmentid returned by StartAssessment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssessmentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetAssessmentInput) SetId(v string) *GetAssessmentInput {
	s.Id = &v
	return s
}

type GetAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// List of criteria for assessment.
	AssessmentTargets []*AssessmentTarget `locationName:"assessmentTargets" type:"list"`

	// Detailed information about the assessment.
	DataCollectionDetails *DataCollectionDetails `locationName:"dataCollectionDetails" type:"structure"`

	// The ID for the specific assessment task.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessmentTargets sets the AssessmentTargets field's value.
func (s *GetAssessmentOutput) SetAssessmentTargets(v []*AssessmentTarget) *GetAssessmentOutput {
	s.AssessmentTargets = v
	return s
}

// SetDataCollectionDetails sets the DataCollectionDetails field's value.
func (s *GetAssessmentOutput) SetDataCollectionDetails(v *DataCollectionDetails) *GetAssessmentOutput {
	s.DataCollectionDetails = v
	return s
}

// SetId sets the Id field's value.
func (s *GetAssessmentOutput) SetId(v string) *GetAssessmentOutput {
	s.Id = &v
	return s
}

type GetImportFileTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the import file task. This ID is returned in the response of StartImportFileTask.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImportFileTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImportFileTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportFileTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportFileTaskInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetImportFileTaskInput) SetId(v string) *GetImportFileTaskInput {
	s.Id = &v
	return s
}

type GetImportFileTaskOutput struct {
	_ struct{} `type:"structure"`

	// The time that the import task completed.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp"`

	// The import file task id returned in the response of StartImportFileTask.
	Id *string `locationName:"id" type:"string"`

	// The name of the import task given in StartImportFileTask.
	ImportName *string `locationName:"importName" type:"string"`

	// The S3 bucket where import file is located.
	InputS3Bucket *string `locationName:"inputS3Bucket" type:"string"`

	// The Amazon S3 key name of the import file.
	InputS3Key *string `locationName:"inputS3Key" type:"string"`

	// The number of records that failed to be imported.
	NumberOfRecordsFailed *int64 `locationName:"numberOfRecordsFailed" type:"integer"`

	// The number of records successfully imported.
	NumberOfRecordsSuccess *int64 `locationName:"numberOfRecordsSuccess" type:"integer"`

	// Start time of the import task.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Status of import file task.
	Status *string `locationName:"status" type:"string" enum:"ImportFileTaskStatus"`

	// The S3 bucket name for status report of import task.
	StatusReportS3Bucket *string `locationName:"statusReportS3Bucket" type:"string"`

	// The Amazon S3 key name for status report of import task. The report contains
	// details about whether each record imported successfully or why it did not.
	StatusReportS3Key *string `locationName:"statusReportS3Key" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImportFileTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImportFileTaskOutput) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *GetImportFileTaskOutput) SetCompletionTime(v time.Time) *GetImportFileTaskOutput {
	s.CompletionTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetImportFileTaskOutput) SetId(v string) *GetImportFileTaskOutput {
	s.Id = &v
	return s
}

// SetImportName sets the ImportName field's value.
func (s *GetImportFileTaskOutput) SetImportName(v string) *GetImportFileTaskOutput {
	s.ImportName = &v
	return s
}

// SetInputS3Bucket sets the InputS3Bucket field's value.
func (s *GetImportFileTaskOutput) SetInputS3Bucket(v string) *GetImportFileTaskOutput {
	s.InputS3Bucket = &v
	return s
}

// SetInputS3Key sets the InputS3Key field's value.
func (s *GetImportFileTaskOutput) SetInputS3Key(v string) *GetImportFileTaskOutput {
	s.InputS3Key = &v
	return s
}

// SetNumberOfRecordsFailed sets the NumberOfRecordsFailed field's value.
func (s *GetImportFileTaskOutput) SetNumberOfRecordsFailed(v int64) *GetImportFileTaskOutput {
	s.NumberOfRecordsFailed = &v
	return s
}

// SetNumberOfRecordsSuccess sets the NumberOfRecordsSuccess field's value.
func (s *GetImportFileTaskOutput) SetNumberOfRecordsSuccess(v int64) *GetImportFileTaskOutput {
	s.NumberOfRecordsSuccess = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetImportFileTaskOutput) SetStartTime(v time.Time) *GetImportFileTaskOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetImportFileTaskOutput) SetStatus(v string) *GetImportFileTaskOutput {
	s.Status = &v
	return s
}

// SetStatusReportS3Bucket sets the StatusReportS3Bucket field's value.
func (s *GetImportFileTaskOutput) SetStatusReportS3Bucket(v string) *GetImportFileTaskOutput {
	s.StatusReportS3Bucket = &v
	return s
}

// SetStatusReportS3Key sets the StatusReportS3Key field's value.
func (s *GetImportFileTaskOutput) SetStatusReportS3Key(v string) *GetImportFileTaskOutput {
	s.StatusReportS3Key = &v
	return s
}

type GetLatestAssessmentIdInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLatestAssessmentIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLatestAssessmentIdInput) GoString() string {
	return s.String()
}

type GetLatestAssessmentIdOutput struct {
	_ struct{} `type:"structure"`

	// The latest ID for the specific assessment task.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLatestAssessmentIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLatestAssessmentIdOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *GetLatestAssessmentIdOutput) SetId(v string) *GetLatestAssessmentIdOutput {
	s.Id = &v
	return s
}

type GetPortfolioPreferencesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioPreferencesInput) GoString() string {
	return s.String()
}

type GetPortfolioPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// The classification for application component types.
	ApplicationMode *string `locationName:"applicationMode" type:"string" enum:"ApplicationMode"`

	// The transformation preferences for non-database applications.
	ApplicationPreferences *ApplicationPreferences `locationName:"applicationPreferences" type:"structure"`

	// The transformation preferences for database applications.
	DatabasePreferences *DatabasePreferences `locationName:"databasePreferences" type:"structure"`

	// The rank of business goals based on priority.
	PrioritizeBusinessGoals *PrioritizeBusinessGoals `locationName:"prioritizeBusinessGoals" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioPreferencesOutput) GoString() string {
	return s.String()
}

// SetApplicationMode sets the ApplicationMode field's value.
func (s *GetPortfolioPreferencesOutput) SetApplicationMode(v string) *GetPortfolioPreferencesOutput {
	s.ApplicationMode = &v
	return s
}

// SetApplicationPreferences sets the ApplicationPreferences field's value.
func (s *GetPortfolioPreferencesOutput) SetApplicationPreferences(v *ApplicationPreferences) *GetPortfolioPreferencesOutput {
	s.ApplicationPreferences = v
	return s
}

// SetDatabasePreferences sets the DatabasePreferences field's value.
func (s *GetPortfolioPreferencesOutput) SetDatabasePreferences(v *DatabasePreferences) *GetPortfolioPreferencesOutput {
	s.DatabasePreferences = v
	return s
}

// SetPrioritizeBusinessGoals sets the PrioritizeBusinessGoals field's value.
func (s *GetPortfolioPreferencesOutput) SetPrioritizeBusinessGoals(v *PrioritizeBusinessGoals) *GetPortfolioPreferencesOutput {
	s.PrioritizeBusinessGoals = v
	return s
}

type GetPortfolioSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioSummaryInput) GoString() string {
	return s.String()
}

type GetPortfolioSummaryOutput struct {
	_ struct{} `type:"structure"`

	// An assessment summary for the portfolio including the number of servers to
	// rehost and the overall number of anti-patterns.
	AssessmentSummary *AssessmentSummary `locationName:"assessmentSummary" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortfolioSummaryOutput) GoString() string {
	return s.String()
}

// SetAssessmentSummary sets the AssessmentSummary field's value.
func (s *GetPortfolioSummaryOutput) SetAssessmentSummary(v *AssessmentSummary) *GetPortfolioSummaryOutput {
	s.AssessmentSummary = v
	return s
}

type GetRecommendationReportDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The recommendation report generation task id returned by StartRecommendationReportGeneration.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationReportDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationReportDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationReportDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommendationReportDetailsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetRecommendationReportDetailsInput) SetId(v string) *GetRecommendationReportDetailsInput {
	s.Id = &v
	return s
}

type GetRecommendationReportDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the recommendation report generation task. See the response of
	// StartRecommendationReportGeneration.
	Id *string `locationName:"id" type:"string"`

	// Detailed information about the recommendation report.
	RecommendationReportDetails *RecommendationReportDetails `locationName:"recommendationReportDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationReportDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationReportDetailsOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *GetRecommendationReportDetailsOutput) SetId(v string) *GetRecommendationReportDetailsOutput {
	s.Id = &v
	return s
}

// SetRecommendationReportDetails sets the RecommendationReportDetails field's value.
func (s *GetRecommendationReportDetailsOutput) SetRecommendationReportDetails(v *RecommendationReportDetails) *GetRecommendationReportDetailsOutput {
	s.RecommendationReportDetails = v
	return s
}

type GetServerDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to include in the response. The maximum value
	// is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The token from a previous call that you use to retrieve the next set of results.
	// For example, if a previous call to this action returned 100 items, but you
	// set maxResults to 10. You'll receive a set of 10 results along with a token.
	// You then use the returned token to retrieve the next set of 10.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the server.
	//
	// ServerId is a required field
	ServerId *string `location:"uri" locationName:"serverId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServerDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServerDetailsInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetServerDetailsInput) SetMaxResults(v int64) *GetServerDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServerDetailsInput) SetNextToken(v string) *GetServerDetailsInput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *GetServerDetailsInput) SetServerId(v string) *GetServerDetailsInput {
	s.ServerId = &v
	return s
}

type GetServerDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The associated application group the server belongs to, as defined in AWS
	// Application Discovery Service.
	AssociatedApplications []*AssociatedApplication `locationName:"associatedApplications" type:"list"`

	// The token you use to retrieve the next set of results, or null if there are
	// no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Detailed information about the server.
	ServerDetail *ServerDetail `locationName:"serverDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerDetailsOutput) GoString() string {
	return s.String()
}

// SetAssociatedApplications sets the AssociatedApplications field's value.
func (s *GetServerDetailsOutput) SetAssociatedApplications(v []*AssociatedApplication) *GetServerDetailsOutput {
	s.AssociatedApplications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServerDetailsOutput) SetNextToken(v string) *GetServerDetailsOutput {
	s.NextToken = &v
	return s
}

// SetServerDetail sets the ServerDetail field's value.
func (s *GetServerDetailsOutput) SetServerDetail(v *ServerDetail) *GetServerDetailsOutput {
	s.ServerDetail = v
	return s
}

type GetServerStrategiesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the server.
	//
	// ServerId is a required field
	ServerId *string `location:"uri" locationName:"serverId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerStrategiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerStrategiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServerStrategiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServerStrategiesInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *GetServerStrategiesInput) SetServerId(v string) *GetServerStrategiesInput {
	s.ServerId = &v
	return s
}

type GetServerStrategiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of strategy recommendations for the server.
	ServerStrategies []*ServerStrategy `locationName:"serverStrategies" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerStrategiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServerStrategiesOutput) GoString() string {
	return s.String()
}

// SetServerStrategies sets the ServerStrategies field's value.
func (s *GetServerStrategiesOutput) SetServerStrategies(v []*ServerStrategy) *GetServerStrategiesOutput {
	s.ServerStrategies = v
	return s
}

// The object containing information about distinct imports or groups for Strategy
// Recommendations.
type Group struct {
	_ struct{} `type:"structure"`

	// The key of the specific import group.
	Name *string `locationName:"name" type:"string" enum:"GroupName"`

	// The value of the specific import group.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Group) SetName(v string) *Group {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Group) SetValue(v string) *Group {
	s.Value = &v
	return s
}

// The object containing details about heterogeneous database preferences.
type Heterogeneous struct {
	_ struct{} `type:"structure"`

	// The target database engine for heterogeneous database migration preference.
	//
	// TargetDatabaseEngine is a required field
	TargetDatabaseEngine []*string `locationName:"targetDatabaseEngine" min:"1" type:"list" required:"true" enum:"HeterogeneousTargetDatabaseEngine"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Heterogeneous) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Heterogeneous) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Heterogeneous) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Heterogeneous"}
	if s.TargetDatabaseEngine == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDatabaseEngine"))
	}
	if s.TargetDatabaseEngine != nil && len(s.TargetDatabaseEngine) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetDatabaseEngine", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetDatabaseEngine sets the TargetDatabaseEngine field's value.
func (s *Heterogeneous) SetTargetDatabaseEngine(v []*string) *Heterogeneous {
	s.TargetDatabaseEngine = v
	return s
}

// The object containing details about homogeneous database preferences.
type Homogeneous struct {
	_ struct{} `type:"structure"`

	// The target database engine for homogeneous database migration preferences.
	TargetDatabaseEngine []*string `locationName:"targetDatabaseEngine" type:"list" enum:"HomogeneousTargetDatabaseEngine"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Homogeneous) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Homogeneous) GoString() string {
	return s.String()
}

// SetTargetDatabaseEngine sets the TargetDatabaseEngine field's value.
func (s *Homogeneous) SetTargetDatabaseEngine(v []*string) *Homogeneous {
	s.TargetDatabaseEngine = v
	return s
}

// IP address based configurations.
type IPAddressBasedRemoteInfo struct {
	_ struct{} `type:"structure"`

	// The type of authorization.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The time stamp of the configuration.
	IpAddressConfigurationTimeStamp *string `locationName:"ipAddressConfigurationTimeStamp" type:"string"`

	// The type of the operating system.
	OsType *string `locationName:"osType" type:"string" enum:"OSType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPAddressBasedRemoteInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPAddressBasedRemoteInfo) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *IPAddressBasedRemoteInfo) SetAuthType(v string) *IPAddressBasedRemoteInfo {
	s.AuthType = &v
	return s
}

// SetIpAddressConfigurationTimeStamp sets the IpAddressConfigurationTimeStamp field's value.
func (s *IPAddressBasedRemoteInfo) SetIpAddressConfigurationTimeStamp(v string) *IPAddressBasedRemoteInfo {
	s.IpAddressConfigurationTimeStamp = &v
	return s
}

// SetOsType sets the OsType field's value.
func (s *IPAddressBasedRemoteInfo) SetOsType(v string) *IPAddressBasedRemoteInfo {
	s.OsType = &v
	return s
}

// Information about the import file tasks you request.
type ImportFileTaskInformation struct {
	_ struct{} `type:"structure"`

	// The time that the import task completes.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp"`

	// The ID of the import file task.
	Id *string `locationName:"id" type:"string"`

	// The name of the import task given in StartImportFileTask.
	ImportName *string `locationName:"importName" type:"string"`

	// The S3 bucket where the import file is located.
	InputS3Bucket *string `locationName:"inputS3Bucket" type:"string"`

	// The Amazon S3 key name of the import file.
	InputS3Key *string `locationName:"inputS3Key" type:"string"`

	// The number of records that failed to be imported.
	NumberOfRecordsFailed *int64 `locationName:"numberOfRecordsFailed" type:"integer"`

	// The number of records successfully imported.
	NumberOfRecordsSuccess *int64 `locationName:"numberOfRecordsSuccess" type:"integer"`

	// Start time of the import task.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Status of import file task.
	Status *string `locationName:"status" type:"string" enum:"ImportFileTaskStatus"`

	// The S3 bucket name for status report of import task.
	StatusReportS3Bucket *string `locationName:"statusReportS3Bucket" type:"string"`

	// The Amazon S3 key name for status report of import task. The report contains
	// details about whether each record imported successfully or why it did not.
	StatusReportS3Key *string `locationName:"statusReportS3Key" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFileTaskInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFileTaskInformation) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ImportFileTaskInformation) SetCompletionTime(v time.Time) *ImportFileTaskInformation {
	s.CompletionTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportFileTaskInformation) SetId(v string) *ImportFileTaskInformation {
	s.Id = &v
	return s
}

// SetImportName sets the ImportName field's value.
func (s *ImportFileTaskInformation) SetImportName(v string) *ImportFileTaskInformation {
	s.ImportName = &v
	return s
}

// SetInputS3Bucket sets the InputS3Bucket field's value.
func (s *ImportFileTaskInformation) SetInputS3Bucket(v string) *ImportFileTaskInformation {
	s.InputS3Bucket = &v
	return s
}

// SetInputS3Key sets the InputS3Key field's value.
func (s *ImportFileTaskInformation) SetInputS3Key(v string) *ImportFileTaskInformation {
	s.InputS3Key = &v
	return s
}

// SetNumberOfRecordsFailed sets the NumberOfRecordsFailed field's value.
func (s *ImportFileTaskInformation) SetNumberOfRecordsFailed(v int64) *ImportFileTaskInformation {
	s.NumberOfRecordsFailed = &v
	return s
}

// SetNumberOfRecordsSuccess sets the NumberOfRecordsSuccess field's value.
func (s *ImportFileTaskInformation) SetNumberOfRecordsSuccess(v int64) *ImportFileTaskInformation {
	s.NumberOfRecordsSuccess = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ImportFileTaskInformation) SetStartTime(v time.Time) *ImportFileTaskInformation {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportFileTaskInformation) SetStatus(v string) *ImportFileTaskInformation {
	s.Status = &v
	return s
}

// SetStatusReportS3Bucket sets the StatusReportS3Bucket field's value.
func (s *ImportFileTaskInformation) SetStatusReportS3Bucket(v string) *ImportFileTaskInformation {
	s.StatusReportS3Bucket = &v
	return s
}

// SetStatusReportS3Key sets the StatusReportS3Key field's value.
func (s *ImportFileTaskInformation) SetStatusReportS3Key(v string) *ImportFileTaskInformation {
	s.StatusReportS3Key = &v
	return s
}

// The server experienced an internal error. Try again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationComponentsInput struct {
	_ struct{} `type:"structure"`

	// Criteria for filtering the list of application components.
	ApplicationComponentCriteria *string `locationName:"applicationComponentCriteria" type:"string" enum:"ApplicationComponentCriteria"`

	// Specify the value based on the application component criteria type. For example,
	// if applicationComponentCriteria is set to SERVER_ID and filterValue is set
	// to server1, then ListApplicationComponents returns all the application components
	// running on server1.
	FilterValue *string `locationName:"filterValue" type:"string"`

	// The group ID specified in to filter on.
	GroupIdFilter []*Group `locationName:"groupIdFilter" type:"list"`

	// The maximum number of items to include in the response. The maximum value
	// is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token from a previous call that you use to retrieve the next set of results.
	// For example, if a previous call to this action returned 100 items, but you
	// set maxResults to 10. You'll receive a set of 10 results along with a token.
	// You then use the returned token to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies whether to sort by ascending (ASC) or descending (DESC) order.
	Sort *string `locationName:"sort" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationComponentsInput) GoString() string {
	return s.String()
}

// SetApplicationComponentCriteria sets the ApplicationComponentCriteria field's value.
func (s *ListApplicationComponentsInput) SetApplicationComponentCriteria(v string) *ListApplicationComponentsInput {
	s.ApplicationComponentCriteria = &v
	return s
}

// SetFilterValue sets the FilterValue field's value.
func (s *ListApplicationComponentsInput) SetFilterValue(v string) *ListApplicationComponentsInput {
	s.FilterValue = &v
	return s
}

// SetGroupIdFilter sets the GroupIdFilter field's value.
func (s *ListApplicationComponentsInput) SetGroupIdFilter(v []*Group) *ListApplicationComponentsInput {
	s.GroupIdFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationComponentsInput) SetMaxResults(v int64) *ListApplicationComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationComponentsInput) SetNextToken(v string) *ListApplicationComponentsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListApplicationComponentsInput) SetSort(v string) *ListApplicationComponentsInput {
	s.Sort = &v
	return s
}

type ListApplicationComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of application components with detailed information about each component.
	ApplicationComponentInfos []*ApplicationComponentDetail `locationName:"applicationComponentInfos" type:"list"`

	// The token you use to retrieve the next set of results, or null if there are
	// no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationComponentsOutput) GoString() string {
	return s.String()
}

// SetApplicationComponentInfos sets the ApplicationComponentInfos field's value.
func (s *ListApplicationComponentsOutput) SetApplicationComponentInfos(v []*ApplicationComponentDetail) *ListApplicationComponentsOutput {
	s.ApplicationComponentInfos = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationComponentsOutput) SetNextToken(v string) *ListApplicationComponentsOutput {
	s.NextToken = &v
	return s
}

type ListCollectorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to include in the response. The maximum value
	// is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The token from a previous call that you use to retrieve the next set of results.
	// For example, if a previous call to this action returned 100 items, but you
	// set maxResults to 10. You'll receive a set of 10 results along with a token.
	// You then use the returned token to retrieve the next set of 10.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollectorsInput) SetMaxResults(v int64) *ListCollectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectorsInput) SetNextToken(v string) *ListCollectorsInput {
	s.NextToken = &v
	return s
}

type ListCollectorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of all the installed collectors.
	Collectors []*Collector `type:"list"`

	// The token you use to retrieve the next set of results, or null if there are
	// no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectorsOutput) GoString() string {
	return s.String()
}

// SetCollectors sets the Collectors field's value.
func (s *ListCollectorsOutput) SetCollectors(v []*Collector) *ListCollectorsOutput {
	s.Collectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectorsOutput) SetNextToken(v string) *ListCollectorsOutput {
	s.NextToken = &v
	return s
}

type ListImportFileTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The total number of items to return. The maximum value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The token from a previous call that you use to retrieve the next set of results.
	// For example, if a previous call to this action returned 100 items, but you
	// set maxResults to 10. You'll receive a set of 10 results along with a token.
	// You then use the returned token to retrieve the next set of 10.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportFileTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportFileTaskInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImportFileTaskInput) SetMaxResults(v int64) *ListImportFileTaskInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportFileTaskInput) SetNextToken(v string) *ListImportFileTaskInput {
	s.NextToken = &v
	return s
}

type ListImportFileTaskOutput struct {
	_ struct{} `type:"structure"`

	// The token you use to retrieve the next set of results, or null if there are
	// no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists information about the files you import.
	TaskInfos []*ImportFileTaskInformation `locationName:"taskInfos" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportFileTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportFileTaskOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportFileTaskOutput) SetNextToken(v string) *ListImportFileTaskOutput {
	s.NextToken = &v
	return s
}

// SetTaskInfos sets the TaskInfos field's value.
func (s *ListImportFileTaskOutput) SetTaskInfos(v []*ImportFileTaskInformation) *ListImportFileTaskOutput {
	s.TaskInfos = v
	return s
}

type ListServersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the filter value, which is based on the type of server criteria.
	// For example, if serverCriteria is OS_NAME, and the filterValue is equal to
	// WindowsServer, then ListServers returns all of the servers matching the OS
	// name WindowsServer.
	FilterValue *string `locationName:"filterValue" type:"string"`

	// Specifies the group ID to filter on.
	GroupIdFilter []*Group `locationName:"groupIdFilter" type:"list"`

	// The maximum number of items to include in the response. The maximum value
	// is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token from a previous call that you use to retrieve the next set of results.
	// For example, if a previous call to this action returned 100 items, but you
	// set maxResults to 10. You'll receive a set of 10 results along with a token.
	// You then use the returned token to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Criteria for filtering servers.
	ServerCriteria *string `locationName:"serverCriteria" type:"string" enum:"ServerCriteria"`

	// Specifies whether to sort by ascending (ASC) or descending (DESC) order.
	Sort *string `locationName:"sort" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersInput) GoString() string {
	return s.String()
}

// SetFilterValue sets the FilterValue field's value.
func (s *ListServersInput) SetFilterValue(v string) *ListServersInput {
	s.FilterValue = &v
	return s
}

// SetGroupIdFilter sets the GroupIdFilter field's value.
func (s *ListServersInput) SetGroupIdFilter(v []*Group) *ListServersInput {
	s.GroupIdFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServersInput) SetMaxResults(v int64) *ListServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersInput) SetNextToken(v string) *ListServersInput {
	s.NextToken = &v
	return s
}

// SetServerCriteria sets the ServerCriteria field's value.
func (s *ListServersInput) SetServerCriteria(v string) *ListServersInput {
	s.ServerCriteria = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListServersInput) SetSort(v string) *ListServersInput {
	s.Sort = &v
	return s
}

type ListServersOutput struct {
	_ struct{} `type:"structure"`

	// The token you use to retrieve the next set of results, or null if there are
	// no more results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of servers with detailed information about each server.
	ServerInfos []*ServerDetail `locationName:"serverInfos" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersOutput) SetNextToken(v string) *ListServersOutput {
	s.NextToken = &v
	return s
}

// SetServerInfos sets the ServerInfos field's value.
func (s *ListServersOutput) SetServerInfos(v []*ServerDetail) *ListServersOutput {
	s.ServerInfos = v
	return s
}

// Preferences for migrating an application to AWS.
type ManagementPreference struct {
	_ struct{} `type:"structure"`

	// Indicates interest in solutions that are managed by AWS.
	AwsManagedResources *AwsManagedResources `locationName:"awsManagedResources" type:"structure"`

	// No specific preference.
	NoPreference *NoManagementPreference `locationName:"noPreference" type:"structure"`

	// Indicates interest in managing your own resources on AWS.
	SelfManageResources *SelfManageResources `locationName:"selfManageResources" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagementPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagementPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagementPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagementPreference"}
	if s.AwsManagedResources != nil {
		if err := s.AwsManagedResources.Validate(); err != nil {
			invalidParams.AddNested("AwsManagedResources", err.(request.ErrInvalidParams))
		}
	}
	if s.NoPreference != nil {
		if err := s.NoPreference.Validate(); err != nil {
			invalidParams.AddNested("NoPreference", err.(request.ErrInvalidParams))
		}
	}
	if s.SelfManageResources != nil {
		if err := s.SelfManageResources.Validate(); err != nil {
			invalidParams.AddNested("SelfManageResources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsManagedResources sets the AwsManagedResources field's value.
func (s *ManagementPreference) SetAwsManagedResources(v *AwsManagedResources) *ManagementPreference {
	s.AwsManagedResources = v
	return s
}

// SetNoPreference sets the NoPreference field's value.
func (s *ManagementPreference) SetNoPreference(v *NoManagementPreference) *ManagementPreference {
	s.NoPreference = v
	return s
}

// SetSelfManageResources sets the SelfManageResources field's value.
func (s *ManagementPreference) SetSelfManageResources(v *SelfManageResources) *ManagementPreference {
	s.SelfManageResources = v
	return s
}

// Information about the server's network for which the assessment was run.
type NetworkInfo struct {
	_ struct{} `type:"structure"`

	// Information about the name of the interface of the server for which the assessment
	// was run.
	//
	// InterfaceName is a required field
	InterfaceName *string `locationName:"interfaceName" type:"string" required:"true"`

	// Information about the IP address of the server for which the assessment was
	// run.
	//
	// IpAddress is a required field
	IpAddress *string `locationName:"ipAddress" type:"string" required:"true"`

	// Information about the MAC address of the server for which the assessment
	// was run.
	//
	// MacAddress is a required field
	MacAddress *string `locationName:"macAddress" type:"string" required:"true"`

	// Information about the subnet mask of the server for which the assessment
	// was run.
	//
	// NetMask is a required field
	NetMask *string `locationName:"netMask" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInfo) GoString() string {
	return s.String()
}

// SetInterfaceName sets the InterfaceName field's value.
func (s *NetworkInfo) SetInterfaceName(v string) *NetworkInfo {
	s.InterfaceName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *NetworkInfo) SetIpAddress(v string) *NetworkInfo {
	s.IpAddress = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *NetworkInfo) SetMacAddress(v string) *NetworkInfo {
	s.MacAddress = &v
	return s
}

// SetNetMask sets the NetMask field's value.
func (s *NetworkInfo) SetNetMask(v string) *NetworkInfo {
	s.NetMask = &v
	return s
}

// The object containing details about database migration preferences, when
// you have no particular preference.
type NoDatabaseMigrationPreference struct {
	_ struct{} `type:"structure"`

	// The target database engine for database migration preference that you specify.
	//
	// TargetDatabaseEngine is a required field
	TargetDatabaseEngine []*string `locationName:"targetDatabaseEngine" min:"1" type:"list" required:"true" enum:"TargetDatabaseEngine"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoDatabaseMigrationPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoDatabaseMigrationPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoDatabaseMigrationPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NoDatabaseMigrationPreference"}
	if s.TargetDatabaseEngine == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDatabaseEngine"))
	}
	if s.TargetDatabaseEngine != nil && len(s.TargetDatabaseEngine) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetDatabaseEngine", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetDatabaseEngine sets the TargetDatabaseEngine field's value.
func (s *NoDatabaseMigrationPreference) SetTargetDatabaseEngine(v []*string) *NoDatabaseMigrationPreference {
	s.TargetDatabaseEngine = v
	return s
}

// Object containing the choice of application destination that you specify.
type NoManagementPreference struct {
	_ struct{} `type:"structure"`

	// The choice of application destination that you specify.
	//
	// TargetDestination is a required field
	TargetDestination []*string `locationName:"targetDestination" min:"1" type:"list" required:"true" enum:"NoPreferenceTargetDestination"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoManagementPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoManagementPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoManagementPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NoManagementPreference"}
	if s.TargetDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDestination"))
	}
	if s.TargetDestination != nil && len(s.TargetDestination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetDestination", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *NoManagementPreference) SetTargetDestination(v []*string) *NoManagementPreference {
	s.TargetDestination = v
	return s
}

// Information about the operating system.
type OSInfo struct {
	_ struct{} `type:"structure"`

	// Information about the type of operating system.
	Type *string `locationName:"type" type:"string" enum:"OSType"`

	// Information about the version of operating system.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OSInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OSInfo) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *OSInfo) SetType(v string) *OSInfo {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *OSInfo) SetVersion(v string) *OSInfo {
	s.Version = &v
	return s
}

// Detailed information of the pipeline.
type PipelineInfo struct {
	_ struct{} `type:"structure"`

	// The time when the pipeline info was configured.
	PipelineConfigurationTimeStamp *string `locationName:"pipelineConfigurationTimeStamp" type:"string"`

	// The type of pipeline.
	PipelineType *string `locationName:"pipelineType" type:"string" enum:"PipelineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineInfo) GoString() string {
	return s.String()
}

// SetPipelineConfigurationTimeStamp sets the PipelineConfigurationTimeStamp field's value.
func (s *PipelineInfo) SetPipelineConfigurationTimeStamp(v string) *PipelineInfo {
	s.PipelineConfigurationTimeStamp = &v
	return s
}

// SetPipelineType sets the PipelineType field's value.
func (s *PipelineInfo) SetPipelineType(v string) *PipelineInfo {
	s.PipelineType = &v
	return s
}

// Rank of business goals based on priority.
type PrioritizeBusinessGoals struct {
	_ struct{} `type:"structure"`

	// Rank of business goals based on priority.
	BusinessGoals *BusinessGoals `locationName:"businessGoals" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrioritizeBusinessGoals) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrioritizeBusinessGoals) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrioritizeBusinessGoals) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrioritizeBusinessGoals"}
	if s.BusinessGoals != nil {
		if err := s.BusinessGoals.Validate(); err != nil {
			invalidParams.AddNested("BusinessGoals", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBusinessGoals sets the BusinessGoals field's value.
func (s *PrioritizeBusinessGoals) SetBusinessGoals(v *BusinessGoals) *PrioritizeBusinessGoals {
	s.BusinessGoals = v
	return s
}

type PutPortfolioPreferencesInput struct {
	_ struct{} `type:"structure"`

	// The classification for application component types.
	ApplicationMode *string `locationName:"applicationMode" type:"string" enum:"ApplicationMode"`

	// The transformation preferences for non-database applications.
	ApplicationPreferences *ApplicationPreferences `locationName:"applicationPreferences" type:"structure"`

	// The transformation preferences for database applications.
	DatabasePreferences *DatabasePreferences `locationName:"databasePreferences" type:"structure"`

	// The rank of the business goals based on priority.
	PrioritizeBusinessGoals *PrioritizeBusinessGoals `locationName:"prioritizeBusinessGoals" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPortfolioPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPortfolioPreferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPortfolioPreferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPortfolioPreferencesInput"}
	if s.ApplicationPreferences != nil {
		if err := s.ApplicationPreferences.Validate(); err != nil {
			invalidParams.AddNested("ApplicationPreferences", err.(request.ErrInvalidParams))
		}
	}
	if s.DatabasePreferences != nil {
		if err := s.DatabasePreferences.Validate(); err != nil {
			invalidParams.AddNested("DatabasePreferences", err.(request.ErrInvalidParams))
		}
	}
	if s.PrioritizeBusinessGoals != nil {
		if err := s.PrioritizeBusinessGoals.Validate(); err != nil {
			invalidParams.AddNested("PrioritizeBusinessGoals", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationMode sets the ApplicationMode field's value.
func (s *PutPortfolioPreferencesInput) SetApplicationMode(v string) *PutPortfolioPreferencesInput {
	s.ApplicationMode = &v
	return s
}

// SetApplicationPreferences sets the ApplicationPreferences field's value.
func (s *PutPortfolioPreferencesInput) SetApplicationPreferences(v *ApplicationPreferences) *PutPortfolioPreferencesInput {
	s.ApplicationPreferences = v
	return s
}

// SetDatabasePreferences sets the DatabasePreferences field's value.
func (s *PutPortfolioPreferencesInput) SetDatabasePreferences(v *DatabasePreferences) *PutPortfolioPreferencesInput {
	s.DatabasePreferences = v
	return s
}

// SetPrioritizeBusinessGoals sets the PrioritizeBusinessGoals field's value.
func (s *PutPortfolioPreferencesInput) SetPrioritizeBusinessGoals(v *PrioritizeBusinessGoals) *PutPortfolioPreferencesInput {
	s.PrioritizeBusinessGoals = v
	return s
}

type PutPortfolioPreferencesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPortfolioPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPortfolioPreferencesOutput) GoString() string {
	return s.String()
}

// Contains detailed information about a recommendation report.
type RecommendationReportDetails struct {
	_ struct{} `type:"structure"`

	// The time that the recommendation report generation task completes.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp"`

	// The S3 bucket where the report file is located.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The Amazon S3 key name of the report file.
	S3Keys []*string `locationName:"s3Keys" type:"list"`

	// The time that the recommendation report generation task starts.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the recommendation report generation task.
	Status *string `locationName:"status" type:"string" enum:"RecommendationReportStatus"`

	// The status message for recommendation report generation.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationReportDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationReportDetails) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *RecommendationReportDetails) SetCompletionTime(v time.Time) *RecommendationReportDetails {
	s.CompletionTime = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *RecommendationReportDetails) SetS3Bucket(v string) *RecommendationReportDetails {
	s.S3Bucket = &v
	return s
}

// SetS3Keys sets the S3Keys field's value.
func (s *RecommendationReportDetails) SetS3Keys(v []*string) *RecommendationReportDetails {
	s.S3Keys = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RecommendationReportDetails) SetStartTime(v time.Time) *RecommendationReportDetails {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommendationReportDetails) SetStatus(v string) *RecommendationReportDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RecommendationReportDetails) SetStatusMessage(v string) *RecommendationReportDetails {
	s.StatusMessage = &v
	return s
}

// Contains a recommendation set.
type RecommendationSet struct {
	_ struct{} `type:"structure"`

	// The recommended strategy.
	Strategy *string `locationName:"strategy" type:"string" enum:"Strategy"`

	// The recommended target destination.
	TargetDestination *string `locationName:"targetDestination" type:"string" enum:"TargetDestination"`

	// The target destination for the recommendation set.
	TransformationTool *TransformationTool `locationName:"transformationTool" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSet) GoString() string {
	return s.String()
}

// SetStrategy sets the Strategy field's value.
func (s *RecommendationSet) SetStrategy(v string) *RecommendationSet {
	s.Strategy = &v
	return s
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *RecommendationSet) SetTargetDestination(v string) *RecommendationSet {
	s.TargetDestination = &v
	return s
}

// SetTransformationTool sets the TransformationTool field's value.
func (s *RecommendationSet) SetTransformationTool(v *TransformationTool) *RecommendationSet {
	s.TransformationTool = v
	return s
}

// Information about the server configured for source code analysis.
type RemoteSourceCodeAnalysisServerInfo struct {
	_ struct{} `type:"structure"`

	// The time when the remote source code server was configured.
	RemoteSourceCodeAnalysisServerConfigurationTimestamp *string `locationName:"remoteSourceCodeAnalysisServerConfigurationTimestamp" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteSourceCodeAnalysisServerInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteSourceCodeAnalysisServerInfo) GoString() string {
	return s.String()
}

// SetRemoteSourceCodeAnalysisServerConfigurationTimestamp sets the RemoteSourceCodeAnalysisServerConfigurationTimestamp field's value.
func (s *RemoteSourceCodeAnalysisServerInfo) SetRemoteSourceCodeAnalysisServerConfigurationTimestamp(v string) *RemoteSourceCodeAnalysisServerInfo {
	s.RemoteSourceCodeAnalysisServerConfigurationTimestamp = &v
	return s
}

// The specified ID in the request is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the S3 bucket name and the Amazon S3 key name.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The S3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// The Amazon S3 key name.
	S3key *string `locationName:"s3key" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *S3Object) SetS3Bucket(v string) *S3Object {
	s.S3Bucket = &v
	return s
}

// SetS3key sets the S3key field's value.
func (s *S3Object) SetS3key(v string) *S3Object {
	s.S3key = &v
	return s
}

// Self-managed resources.
type SelfManageResources struct {
	_ struct{} `type:"structure"`

	// Self-managed resources target destination.
	//
	// TargetDestination is a required field
	TargetDestination []*string `locationName:"targetDestination" min:"1" type:"list" required:"true" enum:"SelfManageTargetDestination"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManageResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManageResources) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManageResources) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelfManageResources"}
	if s.TargetDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDestination"))
	}
	if s.TargetDestination != nil && len(s.TargetDestination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetDestination", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *SelfManageResources) SetTargetDestination(v []*string) *SelfManageResources {
	s.TargetDestination = v
	return s
}

// Detailed information about a server.
type ServerDetail struct {
	_ struct{} `type:"structure"`

	// The S3 bucket name and Amazon S3 key name for anti-pattern report.
	AntipatternReportS3Object *S3Object `locationName:"antipatternReportS3Object" type:"structure"`

	// The status of the anti-pattern report generation.
	AntipatternReportStatus *string `locationName:"antipatternReportStatus" type:"string" enum:"AntipatternReportStatus"`

	// A message about the status of the anti-pattern report generation.
	AntipatternReportStatusMessage *string `locationName:"antipatternReportStatusMessage" type:"string"`

	// A list of strategy summaries.
	ApplicationComponentStrategySummary []*StrategySummary `locationName:"applicationComponentStrategySummary" type:"list"`

	// The status of assessment for the server.
	DataCollectionStatus *string `locationName:"dataCollectionStatus" type:"string" enum:"RunTimeAssessmentStatus"`

	// The server ID.
	Id *string `locationName:"id" type:"string"`

	// The timestamp of when the server was assessed.
	LastAnalyzedTimestamp *time.Time `locationName:"lastAnalyzedTimestamp" type:"timestamp"`

	// A list of anti-pattern severity summaries.
	ListAntipatternSeveritySummary []*AntipatternSeveritySummary `locationName:"listAntipatternSeveritySummary" type:"list"`

	// The name of the server.
	Name *string `locationName:"name" type:"string"`

	// A set of recommendations.
	RecommendationSet *RecommendationSet `locationName:"recommendationSet" type:"structure"`

	// The error in server analysis.
	ServerError *ServerError `locationName:"serverError" type:"structure"`

	// The type of server.
	ServerType *string `locationName:"serverType" type:"string"`

	// A message about the status of data collection, which contains detailed descriptions
	// of any error messages.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// System information about the server.
	SystemInfo *SystemInfo `locationName:"systemInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerDetail) GoString() string {
	return s.String()
}

// SetAntipatternReportS3Object sets the AntipatternReportS3Object field's value.
func (s *ServerDetail) SetAntipatternReportS3Object(v *S3Object) *ServerDetail {
	s.AntipatternReportS3Object = v
	return s
}

// SetAntipatternReportStatus sets the AntipatternReportStatus field's value.
func (s *ServerDetail) SetAntipatternReportStatus(v string) *ServerDetail {
	s.AntipatternReportStatus = &v
	return s
}

// SetAntipatternReportStatusMessage sets the AntipatternReportStatusMessage field's value.
func (s *ServerDetail) SetAntipatternReportStatusMessage(v string) *ServerDetail {
	s.AntipatternReportStatusMessage = &v
	return s
}

// SetApplicationComponentStrategySummary sets the ApplicationComponentStrategySummary field's value.
func (s *ServerDetail) SetApplicationComponentStrategySummary(v []*StrategySummary) *ServerDetail {
	s.ApplicationComponentStrategySummary = v
	return s
}

// SetDataCollectionStatus sets the DataCollectionStatus field's value.
func (s *ServerDetail) SetDataCollectionStatus(v string) *ServerDetail {
	s.DataCollectionStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServerDetail) SetId(v string) *ServerDetail {
	s.Id = &v
	return s
}

// SetLastAnalyzedTimestamp sets the LastAnalyzedTimestamp field's value.
func (s *ServerDetail) SetLastAnalyzedTimestamp(v time.Time) *ServerDetail {
	s.LastAnalyzedTimestamp = &v
	return s
}

// SetListAntipatternSeveritySummary sets the ListAntipatternSeveritySummary field's value.
func (s *ServerDetail) SetListAntipatternSeveritySummary(v []*AntipatternSeveritySummary) *ServerDetail {
	s.ListAntipatternSeveritySummary = v
	return s
}

// SetName sets the Name field's value.
func (s *ServerDetail) SetName(v string) *ServerDetail {
	s.Name = &v
	return s
}

// SetRecommendationSet sets the RecommendationSet field's value.
func (s *ServerDetail) SetRecommendationSet(v *RecommendationSet) *ServerDetail {
	s.RecommendationSet = v
	return s
}

// SetServerError sets the ServerError field's value.
func (s *ServerDetail) SetServerError(v *ServerError) *ServerDetail {
	s.ServerError = v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *ServerDetail) SetServerType(v string) *ServerDetail {
	s.ServerType = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ServerDetail) SetStatusMessage(v string) *ServerDetail {
	s.StatusMessage = &v
	return s
}

// SetSystemInfo sets the SystemInfo field's value.
func (s *ServerDetail) SetSystemInfo(v *SystemInfo) *ServerDetail {
	s.SystemInfo = v
	return s
}

// The error in server analysis.
type ServerError struct {
	_ struct{} `type:"structure"`

	// The error category of server analysis.
	ServerErrorCategory *string `locationName:"serverErrorCategory" type:"string" enum:"ServerErrorCategory"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerError) GoString() string {
	return s.String()
}

// SetServerErrorCategory sets the ServerErrorCategory field's value.
func (s *ServerError) SetServerErrorCategory(v string) *ServerError {
	s.ServerErrorCategory = &v
	return s
}

// The status summary of the server analysis.
type ServerStatusSummary struct {
	_ struct{} `type:"structure"`

	// The number of servers successfully analyzed, partially successful or failed
	// analysis.
	Count *int64 `locationName:"count" type:"integer"`

	// The status of the run time.
	RunTimeAssessmentStatus *string `locationName:"runTimeAssessmentStatus" type:"string" enum:"RunTimeAssessmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerStatusSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerStatusSummary) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ServerStatusSummary) SetCount(v int64) *ServerStatusSummary {
	s.Count = &v
	return s
}

// SetRunTimeAssessmentStatus sets the RunTimeAssessmentStatus field's value.
func (s *ServerStatusSummary) SetRunTimeAssessmentStatus(v string) *ServerStatusSummary {
	s.RunTimeAssessmentStatus = &v
	return s
}

// Contains information about a strategy recommendation for a server.
type ServerStrategy struct {
	_ struct{} `type:"structure"`

	// Set to true if the recommendation is set as preferred.
	IsPreferred *bool `locationName:"isPreferred" type:"boolean"`

	// The number of application components with this strategy recommendation running
	// on the server.
	NumberOfApplicationComponents *int64 `locationName:"numberOfApplicationComponents" type:"integer"`

	// Strategy recommendation for the server.
	Recommendation *RecommendationSet `locationName:"recommendation" type:"structure"`

	// The recommendation status of the strategy for the server.
	Status *string `locationName:"status" type:"string" enum:"StrategyRecommendation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerStrategy) GoString() string {
	return s.String()
}

// SetIsPreferred sets the IsPreferred field's value.
func (s *ServerStrategy) SetIsPreferred(v bool) *ServerStrategy {
	s.IsPreferred = &v
	return s
}

// SetNumberOfApplicationComponents sets the NumberOfApplicationComponents field's value.
func (s *ServerStrategy) SetNumberOfApplicationComponents(v int64) *ServerStrategy {
	s.NumberOfApplicationComponents = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *ServerStrategy) SetRecommendation(v *RecommendationSet) *ServerStrategy {
	s.Recommendation = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServerStrategy) SetStatus(v string) *ServerStrategy {
	s.Status = &v
	return s
}

// Object containing details about the servers imported by Application Discovery
// Service
type ServerSummary struct {
	_ struct{} `type:"structure"`

	// Number of servers.
	Count *int64 `locationName:"count" type:"integer"`

	// Type of operating system for the servers.
	ServerOsType *string `type:"string" enum:"ServerOsType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSummary) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ServerSummary) SetCount(v int64) *ServerSummary {
	s.Count = &v
	return s
}

// SetServerOsType sets the ServerOsType field's value.
func (s *ServerSummary) SetServerOsType(v string) *ServerSummary {
	s.ServerOsType = &v
	return s
}

// Exception to indicate that the service-linked role (SLR) is locked.
type ServiceLinkedRoleLockClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLinkedRoleLockClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLinkedRoleLockClientException) GoString() string {
	return s.String()
}

func newErrorServiceLinkedRoleLockClientException(v protocol.ResponseMetadata) error {
	return &ServiceLinkedRoleLockClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLinkedRoleLockClientException) Code() string {
	return "ServiceLinkedRoleLockClientException"
}

// Message returns the exception's message.
func (s *ServiceLinkedRoleLockClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLinkedRoleLockClientException) OrigErr() error {
	return nil
}

func (s *ServiceLinkedRoleLockClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLinkedRoleLockClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLinkedRoleLockClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The AWS account has reached its quota of imports. Contact AWS Support to
// increase the quota for this account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object containing source code information that is linked to an application
// component.
type SourceCode struct {
	_ struct{} `type:"structure"`

	// The repository name for the source code.
	Location *string `locationName:"location" min:"1" type:"string"`

	// The name of the project.
	ProjectName *string `locationName:"projectName" min:"1" type:"string"`

	// The branch of the source code.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`

	// The type of repository to use for the source code.
	VersionControl *string `locationName:"versionControl" type:"string" enum:"VersionControl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceCode"}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.SourceVersion != nil && len(*s.SourceVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *SourceCode) SetLocation(v string) *SourceCode {
	s.Location = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SourceCode) SetProjectName(v string) *SourceCode {
	s.ProjectName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *SourceCode) SetSourceVersion(v string) *SourceCode {
	s.SourceVersion = &v
	return s
}

// SetVersionControl sets the VersionControl field's value.
func (s *SourceCode) SetVersionControl(v string) *SourceCode {
	s.VersionControl = &v
	return s
}

// Object containing source code information that is linked to an application
// component.
type SourceCodeRepository struct {
	_ struct{} `type:"structure"`

	// The branch of the source code.
	Branch *string `locationName:"branch" type:"string"`

	// The name of the project.
	ProjectName *string `locationName:"projectName" type:"string"`

	// The repository name for the source code.
	Repository *string `locationName:"repository" type:"string"`

	// The type of repository to use for the source code.
	VersionControlType *string `locationName:"versionControlType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCodeRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCodeRepository) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *SourceCodeRepository) SetBranch(v string) *SourceCodeRepository {
	s.Branch = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SourceCodeRepository) SetProjectName(v string) *SourceCodeRepository {
	s.ProjectName = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *SourceCodeRepository) SetRepository(v string) *SourceCodeRepository {
	s.Repository = &v
	return s
}

// SetVersionControlType sets the VersionControlType field's value.
func (s *SourceCodeRepository) SetVersionControlType(v string) *SourceCodeRepository {
	s.VersionControlType = &v
	return s
}

type StartAssessmentInput struct {
	_ struct{} `type:"structure"`

	// List of criteria for assessment.
	AssessmentTargets []*AssessmentTarget `locationName:"assessmentTargets" type:"list"`

	// The S3 bucket used by the collectors to send analysis data to the service.
	// The bucket name must begin with migrationhub-strategy-.
	S3bucketForAnalysisData *string `locationName:"s3bucketForAnalysisData" type:"string"`

	// The S3 bucket where all the reports generated by the service are stored.
	// The bucket name must begin with migrationhub-strategy-.
	S3bucketForReportData *string `locationName:"s3bucketForReportData" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAssessmentInput"}
	if s.AssessmentTargets != nil {
		for i, v := range s.AssessmentTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssessmentTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentTargets sets the AssessmentTargets field's value.
func (s *StartAssessmentInput) SetAssessmentTargets(v []*AssessmentTarget) *StartAssessmentInput {
	s.AssessmentTargets = v
	return s
}

// SetS3bucketForAnalysisData sets the S3bucketForAnalysisData field's value.
func (s *StartAssessmentInput) SetS3bucketForAnalysisData(v string) *StartAssessmentInput {
	s.S3bucketForAnalysisData = &v
	return s
}

// SetS3bucketForReportData sets the S3bucketForReportData field's value.
func (s *StartAssessmentInput) SetS3bucketForReportData(v string) *StartAssessmentInput {
	s.S3bucketForReportData = &v
	return s
}

type StartAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the assessment.
	AssessmentId *string `locationName:"assessmentId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *StartAssessmentOutput) SetAssessmentId(v string) *StartAssessmentOutput {
	s.AssessmentId = &v
	return s
}

type StartImportFileTaskInput struct {
	_ struct{} `type:"structure"`

	// Specifies the source that the servers are coming from. By default, Strategy
	// Recommendations assumes that the servers specified in the import file are
	// available in AWS Application Discovery Service.
	DataSourceType *string `locationName:"dataSourceType" type:"string" enum:"DataSourceType"`

	// Groups the resources in the import file together with a unique name. This
	// ID can be as filter in ListApplicationComponents and ListServers.
	GroupId []*Group `locationName:"groupId" type:"list"`

	// A descriptive name for the request.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The S3 bucket where the import file is located. The bucket name is required
	// to begin with migrationhub-strategy-.
	//
	// S3Bucket is a required field
	S3Bucket *string `type:"string" required:"true"`

	// The S3 bucket where Strategy Recommendations uploads import results. The
	// bucket name is required to begin with migrationhub-strategy-.
	S3bucketForReportData *string `locationName:"s3bucketForReportData" type:"string"`

	// The Amazon S3 key name of the import file.
	//
	// S3key is a required field
	S3key *string `locationName:"s3key" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImportFileTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImportFileTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportFileTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImportFileTaskInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3key == nil {
		invalidParams.Add(request.NewErrParamRequired("S3key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceType sets the DataSourceType field's value.
func (s *StartImportFileTaskInput) SetDataSourceType(v string) *StartImportFileTaskInput {
	s.DataSourceType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *StartImportFileTaskInput) SetGroupId(v []*Group) *StartImportFileTaskInput {
	s.GroupId = v
	return s
}

// SetName sets the Name field's value.
func (s *StartImportFileTaskInput) SetName(v string) *StartImportFileTaskInput {
	s.Name = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *StartImportFileTaskInput) SetS3Bucket(v string) *StartImportFileTaskInput {
	s.S3Bucket = &v
	return s
}

// SetS3bucketForReportData sets the S3bucketForReportData field's value.
func (s *StartImportFileTaskInput) SetS3bucketForReportData(v string) *StartImportFileTaskInput {
	s.S3bucketForReportData = &v
	return s
}

// SetS3key sets the S3key field's value.
func (s *StartImportFileTaskInput) SetS3key(v string) *StartImportFileTaskInput {
	s.S3key = &v
	return s
}

type StartImportFileTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID for a specific import task. The ID is unique within an AWS account.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImportFileTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImportFileTaskOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *StartImportFileTaskOutput) SetId(v string) *StartImportFileTaskOutput {
	s.Id = &v
	return s
}

type StartRecommendationReportGenerationInput struct {
	_ struct{} `type:"structure"`

	// Groups the resources in the recommendation report with a unique name.
	GroupIdFilter []*Group `locationName:"groupIdFilter" type:"list"`

	// The output format for the recommendation report file. The default format
	// is Microsoft Excel.
	OutputFormat *string `locationName:"outputFormat" type:"string" enum:"OutputFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommendationReportGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommendationReportGenerationInput) GoString() string {
	return s.String()
}

// SetGroupIdFilter sets the GroupIdFilter field's value.
func (s *StartRecommendationReportGenerationInput) SetGroupIdFilter(v []*Group) *StartRecommendationReportGenerationInput {
	s.GroupIdFilter = v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *StartRecommendationReportGenerationInput) SetOutputFormat(v string) *StartRecommendationReportGenerationInput {
	s.OutputFormat = &v
	return s
}

type StartRecommendationReportGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the recommendation report generation task.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommendationReportGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommendationReportGenerationOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *StartRecommendationReportGenerationOutput) SetId(v string) *StartRecommendationReportGenerationOutput {
	s.Id = &v
	return s
}

type StopAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The assessmentId returned by StartAssessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `locationName:"assessmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *StopAssessmentInput) SetAssessmentId(v string) *StopAssessmentInput {
	s.AssessmentId = &v
	return s
}

type StopAssessmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAssessmentOutput) GoString() string {
	return s.String()
}

// Information about all the available strategy options for migrating and modernizing
// an application component.
type StrategyOption struct {
	_ struct{} `type:"structure"`

	// Indicates if a specific strategy is preferred for the application component.
	IsPreferred *bool `locationName:"isPreferred" type:"boolean"`

	// Type of transformation. For example, Rehost, Replatform, and so on.
	Strategy *string `locationName:"strategy" type:"string" enum:"Strategy"`

	// Destination information about where the application component can migrate
	// to. For example, EC2, ECS, and so on.
	TargetDestination *string `locationName:"targetDestination" type:"string" enum:"TargetDestination"`

	// The name of the tool that can be used to transform an application component
	// using this strategy.
	ToolName *string `locationName:"toolName" type:"string" enum:"TransformationToolName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StrategyOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StrategyOption) GoString() string {
	return s.String()
}

// SetIsPreferred sets the IsPreferred field's value.
func (s *StrategyOption) SetIsPreferred(v bool) *StrategyOption {
	s.IsPreferred = &v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *StrategyOption) SetStrategy(v string) *StrategyOption {
	s.Strategy = &v
	return s
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *StrategyOption) SetTargetDestination(v string) *StrategyOption {
	s.TargetDestination = &v
	return s
}

// SetToolName sets the ToolName field's value.
func (s *StrategyOption) SetToolName(v string) *StrategyOption {
	s.ToolName = &v
	return s
}

// Object containing the summary of the strategy recommendations.
type StrategySummary struct {
	_ struct{} `type:"structure"`

	// The count of recommendations per strategy.
	Count *int64 `locationName:"count" type:"integer"`

	// The name of recommended strategy.
	Strategy *string `locationName:"strategy" type:"string" enum:"Strategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StrategySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StrategySummary) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *StrategySummary) SetCount(v int64) *StrategySummary {
	s.Count = &v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *StrategySummary) SetStrategy(v string) *StrategySummary {
	s.Strategy = &v
	return s
}

// Information about the server that hosts application components.
type SystemInfo struct {
	_ struct{} `type:"structure"`

	// CPU architecture type for the server.
	CpuArchitecture *string `locationName:"cpuArchitecture" type:"string"`

	// File system type for the server.
	FileSystemType *string `locationName:"fileSystemType" type:"string"`

	// Networking information related to a server.
	NetworkInfoList []*NetworkInfo `locationName:"networkInfoList" type:"list"`

	// Operating system corresponding to a server.
	OsInfo *OSInfo `locationName:"osInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemInfo) GoString() string {
	return s.String()
}

// SetCpuArchitecture sets the CpuArchitecture field's value.
func (s *SystemInfo) SetCpuArchitecture(v string) *SystemInfo {
	s.CpuArchitecture = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *SystemInfo) SetFileSystemType(v string) *SystemInfo {
	s.FileSystemType = &v
	return s
}

// SetNetworkInfoList sets the NetworkInfoList field's value.
func (s *SystemInfo) SetNetworkInfoList(v []*NetworkInfo) *SystemInfo {
	s.NetworkInfoList = v
	return s
}

// SetOsInfo sets the OsInfo field's value.
func (s *SystemInfo) SetOsInfo(v *OSInfo) *SystemInfo {
	s.OsInfo = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information of the transformation tool that can be used to migrate and modernize
// the application.
type TransformationTool struct {
	_ struct{} `type:"structure"`

	// Description of the tool.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Name of the tool.
	Name *string `locationName:"name" type:"string" enum:"TransformationToolName"`

	// URL for installing the tool.
	TranformationToolInstallationLink *string `locationName:"tranformationToolInstallationLink" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationTool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationTool) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *TransformationTool) SetDescription(v string) *TransformationTool {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *TransformationTool) SetName(v string) *TransformationTool {
	s.Name = &v
	return s
}

// SetTranformationToolInstallationLink sets the TranformationToolInstallationLink field's value.
func (s *TransformationTool) SetTranformationToolInstallationLink(v string) *TransformationTool {
	s.TranformationToolInstallationLink = &v
	return s
}

type UpdateApplicationComponentConfigInput struct {
	_ struct{} `type:"structure"`

	// The type of known component.
	AppType *string `locationName:"appType" type:"string" enum:"AppType"`

	// The ID of the application component. The ID is unique within an AWS account.
	//
	// ApplicationComponentId is a required field
	ApplicationComponentId *string `locationName:"applicationComponentId" type:"string" required:"true"`

	// Update the configuration request of an application component. If it is set
	// to true, the source code and/or database credentials are updated. If it is
	// set to false, the source code and/or database credentials are updated and
	// an analysis is initiated.
	ConfigureOnly *bool `locationName:"configureOnly" type:"boolean"`

	// Indicates whether the application component has been included for server
	// recommendation or not.
	InclusionStatus *string `locationName:"inclusionStatus" type:"string" enum:"InclusionStatus"`

	// Database credentials.
	//
	// SecretsManagerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateApplicationComponentConfigInput's
	// String and GoString methods.
	SecretsManagerKey *string `locationName:"secretsManagerKey" min:"1" type:"string" sensitive:"true"`

	// The list of source code configurations to update for the application component.
	SourceCodeList []*SourceCode `locationName:"sourceCodeList" type:"list"`

	// The preferred strategy options for the application component. Use values
	// from the GetApplicationComponentStrategies response.
	StrategyOption *StrategyOption `locationName:"strategyOption" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationComponentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationComponentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationComponentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationComponentConfigInput"}
	if s.ApplicationComponentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationComponentId"))
	}
	if s.SecretsManagerKey != nil && len(*s.SecretsManagerKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretsManagerKey", 1))
	}
	if s.SourceCodeList != nil {
		for i, v := range s.SourceCodeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceCodeList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppType sets the AppType field's value.
func (s *UpdateApplicationComponentConfigInput) SetAppType(v string) *UpdateApplicationComponentConfigInput {
	s.AppType = &v
	return s
}

// SetApplicationComponentId sets the ApplicationComponentId field's value.
func (s *UpdateApplicationComponentConfigInput) SetApplicationComponentId(v string) *UpdateApplicationComponentConfigInput {
	s.ApplicationComponentId = &v
	return s
}

// SetConfigureOnly sets the ConfigureOnly field's value.
func (s *UpdateApplicationComponentConfigInput) SetConfigureOnly(v bool) *UpdateApplicationComponentConfigInput {
	s.ConfigureOnly = &v
	return s
}

// SetInclusionStatus sets the InclusionStatus field's value.
func (s *UpdateApplicationComponentConfigInput) SetInclusionStatus(v string) *UpdateApplicationComponentConfigInput {
	s.InclusionStatus = &v
	return s
}

// SetSecretsManagerKey sets the SecretsManagerKey field's value.
func (s *UpdateApplicationComponentConfigInput) SetSecretsManagerKey(v string) *UpdateApplicationComponentConfigInput {
	s.SecretsManagerKey = &v
	return s
}

// SetSourceCodeList sets the SourceCodeList field's value.
func (s *UpdateApplicationComponentConfigInput) SetSourceCodeList(v []*SourceCode) *UpdateApplicationComponentConfigInput {
	s.SourceCodeList = v
	return s
}

// SetStrategyOption sets the StrategyOption field's value.
func (s *UpdateApplicationComponentConfigInput) SetStrategyOption(v *StrategyOption) *UpdateApplicationComponentConfigInput {
	s.StrategyOption = v
	return s
}

type UpdateApplicationComponentConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationComponentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationComponentConfigOutput) GoString() string {
	return s.String()
}

type UpdateServerConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the server.
	//
	// ServerId is a required field
	ServerId *string `locationName:"serverId" min:"1" type:"string" required:"true"`

	// The preferred strategy options for the application component. See the response
	// from GetServerStrategies.
	StrategyOption *StrategyOption `locationName:"strategyOption" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerConfigInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerConfigInput) SetServerId(v string) *UpdateServerConfigInput {
	s.ServerId = &v
	return s
}

// SetStrategyOption sets the StrategyOption field's value.
func (s *UpdateServerConfigInput) SetStrategyOption(v *StrategyOption) *UpdateServerConfigInput {
	s.StrategyOption = v
	return s
}

type UpdateServerConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerConfigOutput) GoString() string {
	return s.String()
}

// The request body isn't valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the server in vCenter.
type VcenterBasedRemoteInfo struct {
	_ struct{} `type:"structure"`

	// The type of the operating system.
	OsType *string `locationName:"osType" type:"string" enum:"OSType"`

	// The time when the remote server based on vCenter was last configured.
	VcenterConfigurationTimeStamp *string `locationName:"vcenterConfigurationTimeStamp" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcenterBasedRemoteInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcenterBasedRemoteInfo) GoString() string {
	return s.String()
}

// SetOsType sets the OsType field's value.
func (s *VcenterBasedRemoteInfo) SetOsType(v string) *VcenterBasedRemoteInfo {
	s.OsType = &v
	return s
}

// SetVcenterConfigurationTimeStamp sets the VcenterConfigurationTimeStamp field's value.
func (s *VcenterBasedRemoteInfo) SetVcenterConfigurationTimeStamp(v string) *VcenterBasedRemoteInfo {
	s.VcenterConfigurationTimeStamp = &v
	return s
}

// Details about the version control configuration.
type VersionControlInfo struct {
	_ struct{} `type:"structure"`

	// The time when the version control system was last configured.
	VersionControlConfigurationTimeStamp *string `locationName:"versionControlConfigurationTimeStamp" type:"string"`

	// The type of version control.
	VersionControlType *string `locationName:"versionControlType" type:"string" enum:"VersionControlType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionControlInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionControlInfo) GoString() string {
	return s.String()
}

// SetVersionControlConfigurationTimeStamp sets the VersionControlConfigurationTimeStamp field's value.
func (s *VersionControlInfo) SetVersionControlConfigurationTimeStamp(v string) *VersionControlInfo {
	s.VersionControlConfigurationTimeStamp = &v
	return s
}

// SetVersionControlType sets the VersionControlType field's value.
func (s *VersionControlInfo) SetVersionControlType(v string) *VersionControlInfo {
	s.VersionControlType = &v
	return s
}

const (
	// AntipatternReportStatusFailed is a AntipatternReportStatus enum value
	AntipatternReportStatusFailed = "FAILED"

	// AntipatternReportStatusInProgress is a AntipatternReportStatus enum value
	AntipatternReportStatusInProgress = "IN_PROGRESS"

	// AntipatternReportStatusSuccess is a AntipatternReportStatus enum value
	AntipatternReportStatusSuccess = "SUCCESS"
)

// AntipatternReportStatus_Values returns all elements of the AntipatternReportStatus enum
func AntipatternReportStatus_Values() []string {
	return []string{
		AntipatternReportStatusFailed,
		AntipatternReportStatusInProgress,
		AntipatternReportStatusSuccess,
	}
}

const (
	// AppTypeDotNetFramework is a AppType enum value
	AppTypeDotNetFramework = "DotNetFramework"

	// AppTypeJava is a AppType enum value
	AppTypeJava = "Java"

	// AppTypeSqlserver is a AppType enum value
	AppTypeSqlserver = "SQLServer"

	// AppTypeIis is a AppType enum value
	AppTypeIis = "IIS"

	// AppTypeOracle is a AppType enum value
	AppTypeOracle = "Oracle"

	// AppTypeOther is a AppType enum value
	AppTypeOther = "Other"

	// AppTypeTomcat is a AppType enum value
	AppTypeTomcat = "Tomcat"

	// AppTypeJboss is a AppType enum value
	AppTypeJboss = "JBoss"

	// AppTypeSpring is a AppType enum value
	AppTypeSpring = "Spring"

	// AppTypeMongoDb is a AppType enum value
	AppTypeMongoDb = "Mongo DB"

	// AppTypeDb2 is a AppType enum value
	AppTypeDb2 = "DB2"

	// AppTypeMariaDb is a AppType enum value
	AppTypeMariaDb = "Maria DB"

	// AppTypeMySql is a AppType enum value
	AppTypeMySql = "MySQL"

	// AppTypeSybase is a AppType enum value
	AppTypeSybase = "Sybase"

	// AppTypePostgreSqlserver is a AppType enum value
	AppTypePostgreSqlserver = "PostgreSQLServer"

	// AppTypeCassandra is a AppType enum value
	AppTypeCassandra = "Cassandra"

	// AppTypeIbmwebSphere is a AppType enum value
	AppTypeIbmwebSphere = "IBM WebSphere"

	// AppTypeOracleWebLogic is a AppType enum value
	AppTypeOracleWebLogic = "Oracle WebLogic"

	// AppTypeVisualBasic is a AppType enum value
	AppTypeVisualBasic = "Visual Basic"

	// AppTypeUnknown is a AppType enum value
	AppTypeUnknown = "Unknown"

	// AppTypeDotnetCore is a AppType enum value
	AppTypeDotnetCore = "DotnetCore"

	// AppTypeDotnet is a AppType enum value
	AppTypeDotnet = "Dotnet"
)

// AppType_Values returns all elements of the AppType enum
func AppType_Values() []string {
	return []string{
		AppTypeDotNetFramework,
		AppTypeJava,
		AppTypeSqlserver,
		AppTypeIis,
		AppTypeOracle,
		AppTypeOther,
		AppTypeTomcat,
		AppTypeJboss,
		AppTypeSpring,
		AppTypeMongoDb,
		AppTypeDb2,
		AppTypeMariaDb,
		AppTypeMySql,
		AppTypeSybase,
		AppTypePostgreSqlserver,
		AppTypeCassandra,
		AppTypeIbmwebSphere,
		AppTypeOracleWebLogic,
		AppTypeVisualBasic,
		AppTypeUnknown,
		AppTypeDotnetCore,
		AppTypeDotnet,
	}
}

const (
	// AppUnitErrorCategoryCredentialError is a AppUnitErrorCategory enum value
	AppUnitErrorCategoryCredentialError = "CREDENTIAL_ERROR"

	// AppUnitErrorCategoryConnectivityError is a AppUnitErrorCategory enum value
	AppUnitErrorCategoryConnectivityError = "CONNECTIVITY_ERROR"

	// AppUnitErrorCategoryPermissionError is a AppUnitErrorCategory enum value
	AppUnitErrorCategoryPermissionError = "PERMISSION_ERROR"

	// AppUnitErrorCategoryUnsupportedError is a AppUnitErrorCategory enum value
	AppUnitErrorCategoryUnsupportedError = "UNSUPPORTED_ERROR"

	// AppUnitErrorCategoryOtherError is a AppUnitErrorCategory enum value
	AppUnitErrorCategoryOtherError = "OTHER_ERROR"
)

// AppUnitErrorCategory_Values returns all elements of the AppUnitErrorCategory enum
func AppUnitErrorCategory_Values() []string {
	return []string{
		AppUnitErrorCategoryCredentialError,
		AppUnitErrorCategoryConnectivityError,
		AppUnitErrorCategoryPermissionError,
		AppUnitErrorCategoryUnsupportedError,
		AppUnitErrorCategoryOtherError,
	}
}

const (
	// ApplicationComponentCriteriaNotDefined is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaNotDefined = "NOT_DEFINED"

	// ApplicationComponentCriteriaAppName is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaAppName = "APP_NAME"

	// ApplicationComponentCriteriaServerId is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaServerId = "SERVER_ID"

	// ApplicationComponentCriteriaAppType is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaAppType = "APP_TYPE"

	// ApplicationComponentCriteriaStrategy is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaStrategy = "STRATEGY"

	// ApplicationComponentCriteriaDestination is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaDestination = "DESTINATION"

	// ApplicationComponentCriteriaAnalysisStatus is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaAnalysisStatus = "ANALYSIS_STATUS"

	// ApplicationComponentCriteriaErrorCategory is a ApplicationComponentCriteria enum value
	ApplicationComponentCriteriaErrorCategory = "ERROR_CATEGORY"
)

// ApplicationComponentCriteria_Values returns all elements of the ApplicationComponentCriteria enum
func ApplicationComponentCriteria_Values() []string {
	return []string{
		ApplicationComponentCriteriaNotDefined,
		ApplicationComponentCriteriaAppName,
		ApplicationComponentCriteriaServerId,
		ApplicationComponentCriteriaAppType,
		ApplicationComponentCriteriaStrategy,
		ApplicationComponentCriteriaDestination,
		ApplicationComponentCriteriaAnalysisStatus,
		ApplicationComponentCriteriaErrorCategory,
	}
}

const (
	// ApplicationModeAll is a ApplicationMode enum value
	ApplicationModeAll = "ALL"

	// ApplicationModeKnown is a ApplicationMode enum value
	ApplicationModeKnown = "KNOWN"

	// ApplicationModeUnknown is a ApplicationMode enum value
	ApplicationModeUnknown = "UNKNOWN"
)

// ApplicationMode_Values returns all elements of the ApplicationMode enum
func ApplicationMode_Values() []string {
	return []string{
		ApplicationModeAll,
		ApplicationModeKnown,
		ApplicationModeUnknown,
	}
}

const (
	// AssessmentStatusInProgress is a AssessmentStatus enum value
	AssessmentStatusInProgress = "IN_PROGRESS"

	// AssessmentStatusComplete is a AssessmentStatus enum value
	AssessmentStatusComplete = "COMPLETE"

	// AssessmentStatusFailed is a AssessmentStatus enum value
	AssessmentStatusFailed = "FAILED"

	// AssessmentStatusStopped is a AssessmentStatus enum value
	AssessmentStatusStopped = "STOPPED"
)

// AssessmentStatus_Values returns all elements of the AssessmentStatus enum
func AssessmentStatus_Values() []string {
	return []string{
		AssessmentStatusInProgress,
		AssessmentStatusComplete,
		AssessmentStatusFailed,
		AssessmentStatusStopped,
	}
}

const (
	// AuthTypeNtlm is a AuthType enum value
	AuthTypeNtlm = "NTLM"

	// AuthTypeSsh is a AuthType enum value
	AuthTypeSsh = "SSH"

	// AuthTypeCert is a AuthType enum value
	AuthTypeCert = "CERT"
)

// AuthType_Values returns all elements of the AuthType enum
func AuthType_Values() []string {
	return []string{
		AuthTypeNtlm,
		AuthTypeSsh,
		AuthTypeCert,
	}
}

const (
	// AwsManagedTargetDestinationNonespecified is a AwsManagedTargetDestination enum value
	AwsManagedTargetDestinationNonespecified = "None specified"

	// AwsManagedTargetDestinationAwselasticBeanStalk is a AwsManagedTargetDestination enum value
	AwsManagedTargetDestinationAwselasticBeanStalk = "AWS Elastic BeanStalk"

	// AwsManagedTargetDestinationAwsfargate is a AwsManagedTargetDestination enum value
	AwsManagedTargetDestinationAwsfargate = "AWS Fargate"
)

// AwsManagedTargetDestination_Values returns all elements of the AwsManagedTargetDestination enum
func AwsManagedTargetDestination_Values() []string {
	return []string{
		AwsManagedTargetDestinationNonespecified,
		AwsManagedTargetDestinationAwselasticBeanStalk,
		AwsManagedTargetDestinationAwsfargate,
	}
}

const (
	// CollectorHealthCollectorHealthy is a CollectorHealth enum value
	CollectorHealthCollectorHealthy = "COLLECTOR_HEALTHY"

	// CollectorHealthCollectorUnhealthy is a CollectorHealth enum value
	CollectorHealthCollectorUnhealthy = "COLLECTOR_UNHEALTHY"
)

// CollectorHealth_Values returns all elements of the CollectorHealth enum
func CollectorHealth_Values() []string {
	return []string{
		CollectorHealthCollectorHealthy,
		CollectorHealthCollectorUnhealthy,
	}
}

const (
	// ConditionEquals is a Condition enum value
	ConditionEquals = "EQUALS"

	// ConditionNotEquals is a Condition enum value
	ConditionNotEquals = "NOT_EQUALS"

	// ConditionContains is a Condition enum value
	ConditionContains = "CONTAINS"

	// ConditionNotContains is a Condition enum value
	ConditionNotContains = "NOT_CONTAINS"
)

// Condition_Values returns all elements of the Condition enum
func Condition_Values() []string {
	return []string{
		ConditionEquals,
		ConditionNotEquals,
		ConditionContains,
		ConditionNotContains,
	}
}

const (
	// DataSourceTypeApplicationDiscoveryService is a DataSourceType enum value
	DataSourceTypeApplicationDiscoveryService = "ApplicationDiscoveryService"

	// DataSourceTypeMpa is a DataSourceType enum value
	DataSourceTypeMpa = "MPA"
)

// DataSourceType_Values returns all elements of the DataSourceType enum
func DataSourceType_Values() []string {
	return []string{
		DataSourceTypeApplicationDiscoveryService,
		DataSourceTypeMpa,
	}
}

const (
	// DatabaseManagementPreferenceAwsManaged is a DatabaseManagementPreference enum value
	DatabaseManagementPreferenceAwsManaged = "AWS-managed"

	// DatabaseManagementPreferenceSelfManage is a DatabaseManagementPreference enum value
	DatabaseManagementPreferenceSelfManage = "Self-manage"

	// DatabaseManagementPreferenceNopreference is a DatabaseManagementPreference enum value
	DatabaseManagementPreferenceNopreference = "No preference"
)

// DatabaseManagementPreference_Values returns all elements of the DatabaseManagementPreference enum
func DatabaseManagementPreference_Values() []string {
	return []string{
		DatabaseManagementPreferenceAwsManaged,
		DatabaseManagementPreferenceSelfManage,
		DatabaseManagementPreferenceNopreference,
	}
}

const (
	// GroupNameExternalId is a GroupName enum value
	GroupNameExternalId = "ExternalId"
)

// GroupName_Values returns all elements of the GroupName enum
func GroupName_Values() []string {
	return []string{
		GroupNameExternalId,
	}
}

const (
	// HeterogeneousTargetDatabaseEngineNonespecified is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineNonespecified = "None specified"

	// HeterogeneousTargetDatabaseEngineAmazonAurora is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineAmazonAurora = "Amazon Aurora"

	// HeterogeneousTargetDatabaseEngineAwspostgreSql is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineAwspostgreSql = "AWS PostgreSQL"

	// HeterogeneousTargetDatabaseEngineMySql is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineMySql = "MySQL"

	// HeterogeneousTargetDatabaseEngineMicrosoftSqlserver is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineMicrosoftSqlserver = "Microsoft SQL Server"

	// HeterogeneousTargetDatabaseEngineOracleDatabase is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineOracleDatabase = "Oracle Database"

	// HeterogeneousTargetDatabaseEngineMariaDb is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineMariaDb = "MariaDB"

	// HeterogeneousTargetDatabaseEngineSap is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineSap = "SAP"

	// HeterogeneousTargetDatabaseEngineDb2luw is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineDb2luw = "Db2 LUW"

	// HeterogeneousTargetDatabaseEngineMongoDb is a HeterogeneousTargetDatabaseEngine enum value
	HeterogeneousTargetDatabaseEngineMongoDb = "MongoDB"
)

// HeterogeneousTargetDatabaseEngine_Values returns all elements of the HeterogeneousTargetDatabaseEngine enum
func HeterogeneousTargetDatabaseEngine_Values() []string {
	return []string{
		HeterogeneousTargetDatabaseEngineNonespecified,
		HeterogeneousTargetDatabaseEngineAmazonAurora,
		HeterogeneousTargetDatabaseEngineAwspostgreSql,
		HeterogeneousTargetDatabaseEngineMySql,
		HeterogeneousTargetDatabaseEngineMicrosoftSqlserver,
		HeterogeneousTargetDatabaseEngineOracleDatabase,
		HeterogeneousTargetDatabaseEngineMariaDb,
		HeterogeneousTargetDatabaseEngineSap,
		HeterogeneousTargetDatabaseEngineDb2luw,
		HeterogeneousTargetDatabaseEngineMongoDb,
	}
}

const (
	// HomogeneousTargetDatabaseEngineNonespecified is a HomogeneousTargetDatabaseEngine enum value
	HomogeneousTargetDatabaseEngineNonespecified = "None specified"
)

// HomogeneousTargetDatabaseEngine_Values returns all elements of the HomogeneousTargetDatabaseEngine enum
func HomogeneousTargetDatabaseEngine_Values() []string {
	return []string{
		HomogeneousTargetDatabaseEngineNonespecified,
	}
}

const (
	// ImportFileTaskStatusImportInProgress is a ImportFileTaskStatus enum value
	ImportFileTaskStatusImportInProgress = "ImportInProgress"

	// ImportFileTaskStatusImportFailed is a ImportFileTaskStatus enum value
	ImportFileTaskStatusImportFailed = "ImportFailed"

	// ImportFileTaskStatusImportPartialSuccess is a ImportFileTaskStatus enum value
	ImportFileTaskStatusImportPartialSuccess = "ImportPartialSuccess"

	// ImportFileTaskStatusImportSuccess is a ImportFileTaskStatus enum value
	ImportFileTaskStatusImportSuccess = "ImportSuccess"

	// ImportFileTaskStatusDeleteInProgress is a ImportFileTaskStatus enum value
	ImportFileTaskStatusDeleteInProgress = "DeleteInProgress"

	// ImportFileTaskStatusDeleteFailed is a ImportFileTaskStatus enum value
	ImportFileTaskStatusDeleteFailed = "DeleteFailed"

	// ImportFileTaskStatusDeletePartialSuccess is a ImportFileTaskStatus enum value
	ImportFileTaskStatusDeletePartialSuccess = "DeletePartialSuccess"

	// ImportFileTaskStatusDeleteSuccess is a ImportFileTaskStatus enum value
	ImportFileTaskStatusDeleteSuccess = "DeleteSuccess"
)

// ImportFileTaskStatus_Values returns all elements of the ImportFileTaskStatus enum
func ImportFileTaskStatus_Values() []string {
	return []string{
		ImportFileTaskStatusImportInProgress,
		ImportFileTaskStatusImportFailed,
		ImportFileTaskStatusImportPartialSuccess,
		ImportFileTaskStatusImportSuccess,
		ImportFileTaskStatusDeleteInProgress,
		ImportFileTaskStatusDeleteFailed,
		ImportFileTaskStatusDeletePartialSuccess,
		ImportFileTaskStatusDeleteSuccess,
	}
}

const (
	// InclusionStatusExcludeFromAssessment is a InclusionStatus enum value
	InclusionStatusExcludeFromAssessment = "excludeFromAssessment"

	// InclusionStatusIncludeInAssessment is a InclusionStatus enum value
	InclusionStatusIncludeInAssessment = "includeInAssessment"
)

// InclusionStatus_Values returns all elements of the InclusionStatus enum
func InclusionStatus_Values() []string {
	return []string{
		InclusionStatusExcludeFromAssessment,
		InclusionStatusIncludeInAssessment,
	}
}

const (
	// NoPreferenceTargetDestinationNonespecified is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationNonespecified = "None specified"

	// NoPreferenceTargetDestinationAwselasticBeanStalk is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationAwselasticBeanStalk = "AWS Elastic BeanStalk"

	// NoPreferenceTargetDestinationAwsfargate is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationAwsfargate = "AWS Fargate"

	// NoPreferenceTargetDestinationAmazonElasticCloudComputeEc2 is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationAmazonElasticCloudComputeEc2 = "Amazon Elastic Cloud Compute (EC2)"

	// NoPreferenceTargetDestinationAmazonElasticContainerServiceEcs is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationAmazonElasticContainerServiceEcs = "Amazon Elastic Container Service (ECS)"

	// NoPreferenceTargetDestinationAmazonElasticKubernetesServiceEks is a NoPreferenceTargetDestination enum value
	NoPreferenceTargetDestinationAmazonElasticKubernetesServiceEks = "Amazon Elastic Kubernetes Service (EKS)"
)

// NoPreferenceTargetDestination_Values returns all elements of the NoPreferenceTargetDestination enum
func NoPreferenceTargetDestination_Values() []string {
	return []string{
		NoPreferenceTargetDestinationNonespecified,
		NoPreferenceTargetDestinationAwselasticBeanStalk,
		NoPreferenceTargetDestinationAwsfargate,
		NoPreferenceTargetDestinationAmazonElasticCloudComputeEc2,
		NoPreferenceTargetDestinationAmazonElasticContainerServiceEcs,
		NoPreferenceTargetDestinationAmazonElasticKubernetesServiceEks,
	}
}

const (
	// OSTypeLinux is a OSType enum value
	OSTypeLinux = "LINUX"

	// OSTypeWindows is a OSType enum value
	OSTypeWindows = "WINDOWS"
)

// OSType_Values returns all elements of the OSType enum
func OSType_Values() []string {
	return []string{
		OSTypeLinux,
		OSTypeWindows,
	}
}

const (
	// OutputFormatExcel is a OutputFormat enum value
	OutputFormatExcel = "Excel"

	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "Json"
)

// OutputFormat_Values returns all elements of the OutputFormat enum
func OutputFormat_Values() []string {
	return []string{
		OutputFormatExcel,
		OutputFormatJson,
	}
}

const (
	// PipelineTypeAzureDevops is a PipelineType enum value
	PipelineTypeAzureDevops = "AZURE_DEVOPS"
)

// PipelineType_Values returns all elements of the PipelineType enum
func PipelineType_Values() []string {
	return []string{
		PipelineTypeAzureDevops,
	}
}

const (
	// RecommendationReportStatusFailed is a RecommendationReportStatus enum value
	RecommendationReportStatusFailed = "FAILED"

	// RecommendationReportStatusInProgress is a RecommendationReportStatus enum value
	RecommendationReportStatusInProgress = "IN_PROGRESS"

	// RecommendationReportStatusSuccess is a RecommendationReportStatus enum value
	RecommendationReportStatusSuccess = "SUCCESS"
)

// RecommendationReportStatus_Values returns all elements of the RecommendationReportStatus enum
func RecommendationReportStatus_Values() []string {
	return []string{
		RecommendationReportStatusFailed,
		RecommendationReportStatusInProgress,
		RecommendationReportStatusSuccess,
	}
}

const (
	// ResourceSubTypeDatabase is a ResourceSubType enum value
	ResourceSubTypeDatabase = "Database"

	// ResourceSubTypeProcess is a ResourceSubType enum value
	ResourceSubTypeProcess = "Process"

	// ResourceSubTypeDatabaseProcess is a ResourceSubType enum value
	ResourceSubTypeDatabaseProcess = "DatabaseProcess"
)

// ResourceSubType_Values returns all elements of the ResourceSubType enum
func ResourceSubType_Values() []string {
	return []string{
		ResourceSubTypeDatabase,
		ResourceSubTypeProcess,
		ResourceSubTypeDatabaseProcess,
	}
}

const (
	// RunTimeAssessmentStatusDataCollectionTaskToBeScheduled is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskToBeScheduled = "dataCollectionTaskToBeScheduled"

	// RunTimeAssessmentStatusDataCollectionTaskScheduled is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskScheduled = "dataCollectionTaskScheduled"

	// RunTimeAssessmentStatusDataCollectionTaskStarted is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskStarted = "dataCollectionTaskStarted"

	// RunTimeAssessmentStatusDataCollectionTaskStopped is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskStopped = "dataCollectionTaskStopped"

	// RunTimeAssessmentStatusDataCollectionTaskSuccess is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskSuccess = "dataCollectionTaskSuccess"

	// RunTimeAssessmentStatusDataCollectionTaskFailed is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskFailed = "dataCollectionTaskFailed"

	// RunTimeAssessmentStatusDataCollectionTaskPartialSuccess is a RunTimeAssessmentStatus enum value
	RunTimeAssessmentStatusDataCollectionTaskPartialSuccess = "dataCollectionTaskPartialSuccess"
)

// RunTimeAssessmentStatus_Values returns all elements of the RunTimeAssessmentStatus enum
func RunTimeAssessmentStatus_Values() []string {
	return []string{
		RunTimeAssessmentStatusDataCollectionTaskToBeScheduled,
		RunTimeAssessmentStatusDataCollectionTaskScheduled,
		RunTimeAssessmentStatusDataCollectionTaskStarted,
		RunTimeAssessmentStatusDataCollectionTaskStopped,
		RunTimeAssessmentStatusDataCollectionTaskSuccess,
		RunTimeAssessmentStatusDataCollectionTaskFailed,
		RunTimeAssessmentStatusDataCollectionTaskPartialSuccess,
	}
}

const (
	// RuntimeAnalysisStatusAnalysisToBeScheduled is a RuntimeAnalysisStatus enum value
	RuntimeAnalysisStatusAnalysisToBeScheduled = "ANALYSIS_TO_BE_SCHEDULED"

	// RuntimeAnalysisStatusAnalysisStarted is a RuntimeAnalysisStatus enum value
	RuntimeAnalysisStatusAnalysisStarted = "ANALYSIS_STARTED"

	// RuntimeAnalysisStatusAnalysisSuccess is a RuntimeAnalysisStatus enum value
	RuntimeAnalysisStatusAnalysisSuccess = "ANALYSIS_SUCCESS"

	// RuntimeAnalysisStatusAnalysisFailed is a RuntimeAnalysisStatus enum value
	RuntimeAnalysisStatusAnalysisFailed = "ANALYSIS_FAILED"
)

// RuntimeAnalysisStatus_Values returns all elements of the RuntimeAnalysisStatus enum
func RuntimeAnalysisStatus_Values() []string {
	return []string{
		RuntimeAnalysisStatusAnalysisToBeScheduled,
		RuntimeAnalysisStatusAnalysisStarted,
		RuntimeAnalysisStatusAnalysisSuccess,
		RuntimeAnalysisStatusAnalysisFailed,
	}
}

const (
	// SelfManageTargetDestinationNonespecified is a SelfManageTargetDestination enum value
	SelfManageTargetDestinationNonespecified = "None specified"

	// SelfManageTargetDestinationAmazonElasticCloudComputeEc2 is a SelfManageTargetDestination enum value
	SelfManageTargetDestinationAmazonElasticCloudComputeEc2 = "Amazon Elastic Cloud Compute (EC2)"

	// SelfManageTargetDestinationAmazonElasticContainerServiceEcs is a SelfManageTargetDestination enum value
	SelfManageTargetDestinationAmazonElasticContainerServiceEcs = "Amazon Elastic Container Service (ECS)"

	// SelfManageTargetDestinationAmazonElasticKubernetesServiceEks is a SelfManageTargetDestination enum value
	SelfManageTargetDestinationAmazonElasticKubernetesServiceEks = "Amazon Elastic Kubernetes Service (EKS)"
)

// SelfManageTargetDestination_Values returns all elements of the SelfManageTargetDestination enum
func SelfManageTargetDestination_Values() []string {
	return []string{
		SelfManageTargetDestinationNonespecified,
		SelfManageTargetDestinationAmazonElasticCloudComputeEc2,
		SelfManageTargetDestinationAmazonElasticContainerServiceEcs,
		SelfManageTargetDestinationAmazonElasticKubernetesServiceEks,
	}
}

const (
	// ServerCriteriaNotDefined is a ServerCriteria enum value
	ServerCriteriaNotDefined = "NOT_DEFINED"

	// ServerCriteriaOsName is a ServerCriteria enum value
	ServerCriteriaOsName = "OS_NAME"

	// ServerCriteriaStrategy is a ServerCriteria enum value
	ServerCriteriaStrategy = "STRATEGY"

	// ServerCriteriaDestination is a ServerCriteria enum value
	ServerCriteriaDestination = "DESTINATION"

	// ServerCriteriaServerId is a ServerCriteria enum value
	ServerCriteriaServerId = "SERVER_ID"

	// ServerCriteriaAnalysisStatus is a ServerCriteria enum value
	ServerCriteriaAnalysisStatus = "ANALYSIS_STATUS"

	// ServerCriteriaErrorCategory is a ServerCriteria enum value
	ServerCriteriaErrorCategory = "ERROR_CATEGORY"
)

// ServerCriteria_Values returns all elements of the ServerCriteria enum
func ServerCriteria_Values() []string {
	return []string{
		ServerCriteriaNotDefined,
		ServerCriteriaOsName,
		ServerCriteriaStrategy,
		ServerCriteriaDestination,
		ServerCriteriaServerId,
		ServerCriteriaAnalysisStatus,
		ServerCriteriaErrorCategory,
	}
}

const (
	// ServerErrorCategoryConnectivityError is a ServerErrorCategory enum value
	ServerErrorCategoryConnectivityError = "CONNECTIVITY_ERROR"

	// ServerErrorCategoryCredentialError is a ServerErrorCategory enum value
	ServerErrorCategoryCredentialError = "CREDENTIAL_ERROR"

	// ServerErrorCategoryPermissionError is a ServerErrorCategory enum value
	ServerErrorCategoryPermissionError = "PERMISSION_ERROR"

	// ServerErrorCategoryArchitectureError is a ServerErrorCategory enum value
	ServerErrorCategoryArchitectureError = "ARCHITECTURE_ERROR"

	// ServerErrorCategoryOtherError is a ServerErrorCategory enum value
	ServerErrorCategoryOtherError = "OTHER_ERROR"
)

// ServerErrorCategory_Values returns all elements of the ServerErrorCategory enum
func ServerErrorCategory_Values() []string {
	return []string{
		ServerErrorCategoryConnectivityError,
		ServerErrorCategoryCredentialError,
		ServerErrorCategoryPermissionError,
		ServerErrorCategoryArchitectureError,
		ServerErrorCategoryOtherError,
	}
}

const (
	// ServerOsTypeWindowsServer is a ServerOsType enum value
	ServerOsTypeWindowsServer = "WindowsServer"

	// ServerOsTypeAmazonLinux is a ServerOsType enum value
	ServerOsTypeAmazonLinux = "AmazonLinux"

	// ServerOsTypeEndOfSupportWindowsServer is a ServerOsType enum value
	ServerOsTypeEndOfSupportWindowsServer = "EndOfSupportWindowsServer"

	// ServerOsTypeRedhat is a ServerOsType enum value
	ServerOsTypeRedhat = "Redhat"

	// ServerOsTypeOther is a ServerOsType enum value
	ServerOsTypeOther = "Other"
)

// ServerOsType_Values returns all elements of the ServerOsType enum
func ServerOsType_Values() []string {
	return []string{
		ServerOsTypeWindowsServer,
		ServerOsTypeAmazonLinux,
		ServerOsTypeEndOfSupportWindowsServer,
		ServerOsTypeRedhat,
		ServerOsTypeOther,
	}
}

const (
	// SeverityHigh is a Severity enum value
	SeverityHigh = "HIGH"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "MEDIUM"

	// SeverityLow is a Severity enum value
	SeverityLow = "LOW"
)

// Severity_Values returns all elements of the Severity enum
func Severity_Values() []string {
	return []string{
		SeverityHigh,
		SeverityMedium,
		SeverityLow,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// SrcCodeOrDbAnalysisStatusAnalysisToBeScheduled is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusAnalysisToBeScheduled = "ANALYSIS_TO_BE_SCHEDULED"

	// SrcCodeOrDbAnalysisStatusAnalysisStarted is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusAnalysisStarted = "ANALYSIS_STARTED"

	// SrcCodeOrDbAnalysisStatusAnalysisSuccess is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusAnalysisSuccess = "ANALYSIS_SUCCESS"

	// SrcCodeOrDbAnalysisStatusAnalysisFailed is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusAnalysisFailed = "ANALYSIS_FAILED"

	// SrcCodeOrDbAnalysisStatusAnalysisPartialSuccess is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusAnalysisPartialSuccess = "ANALYSIS_PARTIAL_SUCCESS"

	// SrcCodeOrDbAnalysisStatusUnconfigured is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusUnconfigured = "UNCONFIGURED"

	// SrcCodeOrDbAnalysisStatusConfigured is a SrcCodeOrDbAnalysisStatus enum value
	SrcCodeOrDbAnalysisStatusConfigured = "CONFIGURED"
)

// SrcCodeOrDbAnalysisStatus_Values returns all elements of the SrcCodeOrDbAnalysisStatus enum
func SrcCodeOrDbAnalysisStatus_Values() []string {
	return []string{
		SrcCodeOrDbAnalysisStatusAnalysisToBeScheduled,
		SrcCodeOrDbAnalysisStatusAnalysisStarted,
		SrcCodeOrDbAnalysisStatusAnalysisSuccess,
		SrcCodeOrDbAnalysisStatusAnalysisFailed,
		SrcCodeOrDbAnalysisStatusAnalysisPartialSuccess,
		SrcCodeOrDbAnalysisStatusUnconfigured,
		SrcCodeOrDbAnalysisStatusConfigured,
	}
}

const (
	// StrategyRehost is a Strategy enum value
	StrategyRehost = "Rehost"

	// StrategyRetirement is a Strategy enum value
	StrategyRetirement = "Retirement"

	// StrategyRefactor is a Strategy enum value
	StrategyRefactor = "Refactor"

	// StrategyReplatform is a Strategy enum value
	StrategyReplatform = "Replatform"

	// StrategyRetain is a Strategy enum value
	StrategyRetain = "Retain"

	// StrategyRelocate is a Strategy enum value
	StrategyRelocate = "Relocate"

	// StrategyRepurchase is a Strategy enum value
	StrategyRepurchase = "Repurchase"
)

// Strategy_Values returns all elements of the Strategy enum
func Strategy_Values() []string {
	return []string{
		StrategyRehost,
		StrategyRetirement,
		StrategyRefactor,
		StrategyReplatform,
		StrategyRetain,
		StrategyRelocate,
		StrategyRepurchase,
	}
}

const (
	// StrategyRecommendationRecommended is a StrategyRecommendation enum value
	StrategyRecommendationRecommended = "recommended"

	// StrategyRecommendationViableOption is a StrategyRecommendation enum value
	StrategyRecommendationViableOption = "viableOption"

	// StrategyRecommendationNotRecommended is a StrategyRecommendation enum value
	StrategyRecommendationNotRecommended = "notRecommended"

	// StrategyRecommendationPotential is a StrategyRecommendation enum value
	StrategyRecommendationPotential = "potential"
)

// StrategyRecommendation_Values returns all elements of the StrategyRecommendation enum
func StrategyRecommendation_Values() []string {
	return []string{
		StrategyRecommendationRecommended,
		StrategyRecommendationViableOption,
		StrategyRecommendationNotRecommended,
		StrategyRecommendationPotential,
	}
}

const (
	// TargetDatabaseEngineNonespecified is a TargetDatabaseEngine enum value
	TargetDatabaseEngineNonespecified = "None specified"

	// TargetDatabaseEngineAmazonAurora is a TargetDatabaseEngine enum value
	TargetDatabaseEngineAmazonAurora = "Amazon Aurora"

	// TargetDatabaseEngineAwspostgreSql is a TargetDatabaseEngine enum value
	TargetDatabaseEngineAwspostgreSql = "AWS PostgreSQL"

	// TargetDatabaseEngineMySql is a TargetDatabaseEngine enum value
	TargetDatabaseEngineMySql = "MySQL"

	// TargetDatabaseEngineMicrosoftSqlserver is a TargetDatabaseEngine enum value
	TargetDatabaseEngineMicrosoftSqlserver = "Microsoft SQL Server"

	// TargetDatabaseEngineOracleDatabase is a TargetDatabaseEngine enum value
	TargetDatabaseEngineOracleDatabase = "Oracle Database"

	// TargetDatabaseEngineMariaDb is a TargetDatabaseEngine enum value
	TargetDatabaseEngineMariaDb = "MariaDB"

	// TargetDatabaseEngineSap is a TargetDatabaseEngine enum value
	TargetDatabaseEngineSap = "SAP"

	// TargetDatabaseEngineDb2luw is a TargetDatabaseEngine enum value
	TargetDatabaseEngineDb2luw = "Db2 LUW"

	// TargetDatabaseEngineMongoDb is a TargetDatabaseEngine enum value
	TargetDatabaseEngineMongoDb = "MongoDB"
)

// TargetDatabaseEngine_Values returns all elements of the TargetDatabaseEngine enum
func TargetDatabaseEngine_Values() []string {
	return []string{
		TargetDatabaseEngineNonespecified,
		TargetDatabaseEngineAmazonAurora,
		TargetDatabaseEngineAwspostgreSql,
		TargetDatabaseEngineMySql,
		TargetDatabaseEngineMicrosoftSqlserver,
		TargetDatabaseEngineOracleDatabase,
		TargetDatabaseEngineMariaDb,
		TargetDatabaseEngineSap,
		TargetDatabaseEngineDb2luw,
		TargetDatabaseEngineMongoDb,
	}
}

const (
	// TargetDestinationNonespecified is a TargetDestination enum value
	TargetDestinationNonespecified = "None specified"

	// TargetDestinationAwselasticBeanStalk is a TargetDestination enum value
	TargetDestinationAwselasticBeanStalk = "AWS Elastic BeanStalk"

	// TargetDestinationAwsfargate is a TargetDestination enum value
	TargetDestinationAwsfargate = "AWS Fargate"

	// TargetDestinationAmazonElasticCloudComputeEc2 is a TargetDestination enum value
	TargetDestinationAmazonElasticCloudComputeEc2 = "Amazon Elastic Cloud Compute (EC2)"

	// TargetDestinationAmazonElasticContainerServiceEcs is a TargetDestination enum value
	TargetDestinationAmazonElasticContainerServiceEcs = "Amazon Elastic Container Service (ECS)"

	// TargetDestinationAmazonElasticKubernetesServiceEks is a TargetDestination enum value
	TargetDestinationAmazonElasticKubernetesServiceEks = "Amazon Elastic Kubernetes Service (EKS)"

	// TargetDestinationAuroraMySql is a TargetDestination enum value
	TargetDestinationAuroraMySql = "Aurora MySQL"

	// TargetDestinationAuroraPostgreSql is a TargetDestination enum value
	TargetDestinationAuroraPostgreSql = "Aurora PostgreSQL"

	// TargetDestinationAmazonRelationalDatabaseServiceonMySql is a TargetDestination enum value
	TargetDestinationAmazonRelationalDatabaseServiceonMySql = "Amazon Relational Database Service on MySQL"

	// TargetDestinationAmazonRelationalDatabaseServiceonPostgreSql is a TargetDestination enum value
	TargetDestinationAmazonRelationalDatabaseServiceonPostgreSql = "Amazon Relational Database Service on PostgreSQL"

	// TargetDestinationAmazonDocumentDb is a TargetDestination enum value
	TargetDestinationAmazonDocumentDb = "Amazon DocumentDB"

	// TargetDestinationAmazonDynamoDb is a TargetDestination enum value
	TargetDestinationAmazonDynamoDb = "Amazon DynamoDB"

	// TargetDestinationAmazonRelationalDatabaseService is a TargetDestination enum value
	TargetDestinationAmazonRelationalDatabaseService = "Amazon Relational Database Service"

	// TargetDestinationBabelfishforAuroraPostgreSql is a TargetDestination enum value
	TargetDestinationBabelfishforAuroraPostgreSql = "Babelfish for Aurora PostgreSQL"
)

// TargetDestination_Values returns all elements of the TargetDestination enum
func TargetDestination_Values() []string {
	return []string{
		TargetDestinationNonespecified,
		TargetDestinationAwselasticBeanStalk,
		TargetDestinationAwsfargate,
		TargetDestinationAmazonElasticCloudComputeEc2,
		TargetDestinationAmazonElasticContainerServiceEcs,
		TargetDestinationAmazonElasticKubernetesServiceEks,
		TargetDestinationAuroraMySql,
		TargetDestinationAuroraPostgreSql,
		TargetDestinationAmazonRelationalDatabaseServiceonMySql,
		TargetDestinationAmazonRelationalDatabaseServiceonPostgreSql,
		TargetDestinationAmazonDocumentDb,
		TargetDestinationAmazonDynamoDb,
		TargetDestinationAmazonRelationalDatabaseService,
		TargetDestinationBabelfishforAuroraPostgreSql,
	}
}

const (
	// TransformationToolNameApp2container is a TransformationToolName enum value
	TransformationToolNameApp2container = "App2Container"

	// TransformationToolNamePortingAssistantForNet is a TransformationToolName enum value
	TransformationToolNamePortingAssistantForNet = "Porting Assistant For .NET"

	// TransformationToolNameEndofSupportMigration is a TransformationToolName enum value
	TransformationToolNameEndofSupportMigration = "End of Support Migration"

	// TransformationToolNameWindowsWebApplicationMigrationAssistant is a TransformationToolName enum value
	TransformationToolNameWindowsWebApplicationMigrationAssistant = "Windows Web Application Migration Assistant"

	// TransformationToolNameApplicationMigrationService is a TransformationToolName enum value
	TransformationToolNameApplicationMigrationService = "Application Migration Service"

	// TransformationToolNameStrategyRecommendationSupport is a TransformationToolName enum value
	TransformationToolNameStrategyRecommendationSupport = "Strategy Recommendation Support"

	// TransformationToolNameInPlaceOperatingSystemUpgrade is a TransformationToolName enum value
	TransformationToolNameInPlaceOperatingSystemUpgrade = "In Place Operating System Upgrade"

	// TransformationToolNameSchemaConversionTool is a TransformationToolName enum value
	TransformationToolNameSchemaConversionTool = "Schema Conversion Tool"

	// TransformationToolNameDatabaseMigrationService is a TransformationToolName enum value
	TransformationToolNameDatabaseMigrationService = "Database Migration Service"

	// TransformationToolNameNativeSqlserverBackupRestore is a TransformationToolName enum value
	TransformationToolNameNativeSqlserverBackupRestore = "Native SQL Server Backup/Restore"
)

// TransformationToolName_Values returns all elements of the TransformationToolName enum
func TransformationToolName_Values() []string {
	return []string{
		TransformationToolNameApp2container,
		TransformationToolNamePortingAssistantForNet,
		TransformationToolNameEndofSupportMigration,
		TransformationToolNameWindowsWebApplicationMigrationAssistant,
		TransformationToolNameApplicationMigrationService,
		TransformationToolNameStrategyRecommendationSupport,
		TransformationToolNameInPlaceOperatingSystemUpgrade,
		TransformationToolNameSchemaConversionTool,
		TransformationToolNameDatabaseMigrationService,
		TransformationToolNameNativeSqlserverBackupRestore,
	}
}

const (
	// VersionControlGithub is a VersionControl enum value
	VersionControlGithub = "GITHUB"

	// VersionControlGithubEnterprise is a VersionControl enum value
	VersionControlGithubEnterprise = "GITHUB_ENTERPRISE"

	// VersionControlAzureDevopsGit is a VersionControl enum value
	VersionControlAzureDevopsGit = "AZURE_DEVOPS_GIT"
)

// VersionControl_Values returns all elements of the VersionControl enum
func VersionControl_Values() []string {
	return []string{
		VersionControlGithub,
		VersionControlGithubEnterprise,
		VersionControlAzureDevopsGit,
	}
}

const (
	// VersionControlTypeGithub is a VersionControlType enum value
	VersionControlTypeGithub = "GITHUB"

	// VersionControlTypeGithubEnterprise is a VersionControlType enum value
	VersionControlTypeGithubEnterprise = "GITHUB_ENTERPRISE"

	// VersionControlTypeAzureDevopsGit is a VersionControlType enum value
	VersionControlTypeAzureDevopsGit = "AZURE_DEVOPS_GIT"
)

// VersionControlType_Values returns all elements of the VersionControlType enum
func VersionControlType_Values() []string {
	return []string{
		VersionControlTypeGithub,
		VersionControlTypeGithubEnterprise,
		VersionControlTypeAzureDevopsGit,
	}
}
