// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAnomalyMonitor = "CreateAnomalyMonitor"

// CreateAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnomalyMonitor for more information on using the CreateAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnomalyMonitorRequest method.
//    req, resp := client.CreateAnomalyMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor
func (c *CostExplorer) CreateAnomalyMonitorRequest(input *CreateAnomalyMonitorInput) (req *request.Request, output *CreateAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAnomalyMonitorInput{}
	}

	output = &CreateAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Creates a new cost anomaly detection monitor with the requested type and
// monitor specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor
func (c *CostExplorer) CreateAnomalyMonitor(input *CreateAnomalyMonitorInput) (*CreateAnomalyMonitorOutput, error) {
	req, out := c.CreateAnomalyMonitorRequest(input)
	return out, req.Send()
}

// CreateAnomalyMonitorWithContext is the same as CreateAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateAnomalyMonitorWithContext(ctx aws.Context, input *CreateAnomalyMonitorInput, opts ...request.Option) (*CreateAnomalyMonitorOutput, error) {
	req, out := c.CreateAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnomalySubscription = "CreateAnomalySubscription"

// CreateAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnomalySubscription for more information on using the CreateAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnomalySubscriptionRequest method.
//    req, resp := client.CreateAnomalySubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription
func (c *CostExplorer) CreateAnomalySubscriptionRequest(input *CreateAnomalySubscriptionInput) (req *request.Request, output *CreateAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAnomalySubscriptionInput{}
	}

	output = &CreateAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Adds a subscription to a cost anomaly detection monitor. You can use each
// subscription to define subscribers with email or SNS notifications. Email
// subscribers can set a dollar threshold and a time frequency for receiving
// notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateAnomalySubscription for usage and error information.
//
// Returned Error Types:
//   * UnknownMonitorException
//   The cost anomaly monitor does not exist for the account.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription
func (c *CostExplorer) CreateAnomalySubscription(input *CreateAnomalySubscriptionInput) (*CreateAnomalySubscriptionOutput, error) {
	req, out := c.CreateAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// CreateAnomalySubscriptionWithContext is the same as CreateAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateAnomalySubscriptionWithContext(ctx aws.Context, input *CreateAnomalySubscriptionInput, opts ...request.Option) (*CreateAnomalySubscriptionOutput, error) {
	req, out := c.CreateAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCostCategoryDefinition = "CreateCostCategoryDefinition"

// CreateCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCostCategoryDefinition for more information on using the CreateCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCostCategoryDefinitionRequest method.
//    req, resp := client.CreateCostCategoryDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition
func (c *CostExplorer) CreateCostCategoryDefinitionRequest(input *CreateCostCategoryDefinitionInput) (req *request.Request, output *CreateCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCostCategoryDefinitionInput{}
	}

	output = &CreateCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Creates a new Cost Category with the requested name and rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation CreateCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   You've reached the limit on the number of resources you can create, or exceeded
//   the size of an individual resource.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition
func (c *CostExplorer) CreateCostCategoryDefinition(input *CreateCostCategoryDefinitionInput) (*CreateCostCategoryDefinitionOutput, error) {
	req, out := c.CreateCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// CreateCostCategoryDefinitionWithContext is the same as CreateCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) CreateCostCategoryDefinitionWithContext(ctx aws.Context, input *CreateCostCategoryDefinitionInput, opts ...request.Option) (*CreateCostCategoryDefinitionOutput, error) {
	req, out := c.CreateCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalyMonitor = "DeleteAnomalyMonitor"

// DeleteAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalyMonitor for more information on using the DeleteAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnomalyMonitorRequest method.
//    req, resp := client.DeleteAnomalyMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor
func (c *CostExplorer) DeleteAnomalyMonitorRequest(input *DeleteAnomalyMonitorInput) (req *request.Request, output *DeleteAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalyMonitorInput{}
	}

	output = &DeleteAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Deletes a cost anomaly monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownMonitorException
//   The cost anomaly monitor does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor
func (c *CostExplorer) DeleteAnomalyMonitor(input *DeleteAnomalyMonitorInput) (*DeleteAnomalyMonitorOutput, error) {
	req, out := c.DeleteAnomalyMonitorRequest(input)
	return out, req.Send()
}

// DeleteAnomalyMonitorWithContext is the same as DeleteAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteAnomalyMonitorWithContext(ctx aws.Context, input *DeleteAnomalyMonitorInput, opts ...request.Option) (*DeleteAnomalyMonitorOutput, error) {
	req, out := c.DeleteAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalySubscription = "DeleteAnomalySubscription"

// DeleteAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalySubscription for more information on using the DeleteAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnomalySubscriptionRequest method.
//    req, resp := client.DeleteAnomalySubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription
func (c *CostExplorer) DeleteAnomalySubscriptionRequest(input *DeleteAnomalySubscriptionInput) (req *request.Request, output *DeleteAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalySubscriptionInput{}
	}

	output = &DeleteAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Deletes a cost anomaly subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteAnomalySubscription for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownSubscriptionException
//   The cost anomaly subscription does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription
func (c *CostExplorer) DeleteAnomalySubscription(input *DeleteAnomalySubscriptionInput) (*DeleteAnomalySubscriptionOutput, error) {
	req, out := c.DeleteAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAnomalySubscriptionWithContext is the same as DeleteAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteAnomalySubscriptionWithContext(ctx aws.Context, input *DeleteAnomalySubscriptionInput, opts ...request.Option) (*DeleteAnomalySubscriptionOutput, error) {
	req, out := c.DeleteAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCostCategoryDefinition = "DeleteCostCategoryDefinition"

// DeleteCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCostCategoryDefinition for more information on using the DeleteCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCostCategoryDefinitionRequest method.
//    req, resp := client.DeleteCostCategoryDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition
func (c *CostExplorer) DeleteCostCategoryDefinitionRequest(input *DeleteCostCategoryDefinitionInput) (req *request.Request, output *DeleteCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCostCategoryDefinitionInput{}
	}

	output = &DeleteCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Deletes a Cost Category. Expenses from this month going forward will no longer
// be categorized with this Cost Category.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DeleteCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified ARN in the request doesn't exist.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition
func (c *CostExplorer) DeleteCostCategoryDefinition(input *DeleteCostCategoryDefinitionInput) (*DeleteCostCategoryDefinitionOutput, error) {
	req, out := c.DeleteCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// DeleteCostCategoryDefinitionWithContext is the same as DeleteCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DeleteCostCategoryDefinitionWithContext(ctx aws.Context, input *DeleteCostCategoryDefinitionInput, opts ...request.Option) (*DeleteCostCategoryDefinitionOutput, error) {
	req, out := c.DeleteCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCostCategoryDefinition = "DescribeCostCategoryDefinition"

// DescribeCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCostCategoryDefinition for more information on using the DescribeCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCostCategoryDefinitionRequest method.
//    req, resp := client.DescribeCostCategoryDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition
func (c *CostExplorer) DescribeCostCategoryDefinitionRequest(input *DescribeCostCategoryDefinitionInput) (req *request.Request, output *DescribeCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCostCategoryDefinitionInput{}
	}

	output = &DescribeCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Returns the name, ARN, rules, definition, and effective dates of a Cost Category
// that's defined in the account.
//
// You have the option to use EffectiveOn to return a Cost Category that is
// active on a specific date. If there is no EffectiveOn specified, you’ll
// see a Cost Category that is effective on the current date. If Cost Category
// is still effective, EffectiveEnd is omitted in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation DescribeCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified ARN in the request doesn't exist.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition
func (c *CostExplorer) DescribeCostCategoryDefinition(input *DescribeCostCategoryDefinitionInput) (*DescribeCostCategoryDefinitionOutput, error) {
	req, out := c.DescribeCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// DescribeCostCategoryDefinitionWithContext is the same as DescribeCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) DescribeCostCategoryDefinitionWithContext(ctx aws.Context, input *DescribeCostCategoryDefinitionInput, opts ...request.Option) (*DescribeCostCategoryDefinitionOutput, error) {
	req, out := c.DescribeCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalies = "GetAnomalies"

// GetAnomaliesRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalies for more information on using the GetAnomalies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnomaliesRequest method.
//    req, resp := client.GetAnomaliesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies
func (c *CostExplorer) GetAnomaliesRequest(input *GetAnomaliesInput) (req *request.Request, output *GetAnomaliesOutput) {
	op := &request.Operation{
		Name:       opGetAnomalies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomaliesInput{}
	}

	output = &GetAnomaliesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalies API operation for AWS Cost Explorer Service.
//
// Retrieves all of the cost anomalies detected on your account, during the
// time period specified by the DateInterval object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalies for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies
func (c *CostExplorer) GetAnomalies(input *GetAnomaliesInput) (*GetAnomaliesOutput, error) {
	req, out := c.GetAnomaliesRequest(input)
	return out, req.Send()
}

// GetAnomaliesWithContext is the same as GetAnomalies with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomaliesWithContext(ctx aws.Context, input *GetAnomaliesInput, opts ...request.Option) (*GetAnomaliesOutput, error) {
	req, out := c.GetAnomaliesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalyMonitors = "GetAnomalyMonitors"

// GetAnomalyMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalyMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalyMonitors for more information on using the GetAnomalyMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnomalyMonitorsRequest method.
//    req, resp := client.GetAnomalyMonitorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors
func (c *CostExplorer) GetAnomalyMonitorsRequest(input *GetAnomalyMonitorsInput) (req *request.Request, output *GetAnomalyMonitorsOutput) {
	op := &request.Operation{
		Name:       opGetAnomalyMonitors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomalyMonitorsInput{}
	}

	output = &GetAnomalyMonitorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalyMonitors API operation for AWS Cost Explorer Service.
//
// Retrieves the cost anomaly monitor definitions for your account. You can
// filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalyMonitors for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownMonitorException
//   The cost anomaly monitor does not exist for the account.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors
func (c *CostExplorer) GetAnomalyMonitors(input *GetAnomalyMonitorsInput) (*GetAnomalyMonitorsOutput, error) {
	req, out := c.GetAnomalyMonitorsRequest(input)
	return out, req.Send()
}

// GetAnomalyMonitorsWithContext is the same as GetAnomalyMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalyMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomalyMonitorsWithContext(ctx aws.Context, input *GetAnomalyMonitorsInput, opts ...request.Option) (*GetAnomalyMonitorsOutput, error) {
	req, out := c.GetAnomalyMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnomalySubscriptions = "GetAnomalySubscriptions"

// GetAnomalySubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetAnomalySubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnomalySubscriptions for more information on using the GetAnomalySubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnomalySubscriptionsRequest method.
//    req, resp := client.GetAnomalySubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions
func (c *CostExplorer) GetAnomalySubscriptionsRequest(input *GetAnomalySubscriptionsInput) (req *request.Request, output *GetAnomalySubscriptionsOutput) {
	op := &request.Operation{
		Name:       opGetAnomalySubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAnomalySubscriptionsInput{}
	}

	output = &GetAnomalySubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnomalySubscriptions API operation for AWS Cost Explorer Service.
//
// Retrieves the cost anomaly subscription objects for your account. You can
// filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetAnomalySubscriptions for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownSubscriptionException
//   The cost anomaly subscription does not exist for the account.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions
func (c *CostExplorer) GetAnomalySubscriptions(input *GetAnomalySubscriptionsInput) (*GetAnomalySubscriptionsOutput, error) {
	req, out := c.GetAnomalySubscriptionsRequest(input)
	return out, req.Send()
}

// GetAnomalySubscriptionsWithContext is the same as GetAnomalySubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnomalySubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetAnomalySubscriptionsWithContext(ctx aws.Context, input *GetAnomalySubscriptionsInput, opts ...request.Option) (*GetAnomalySubscriptionsOutput, error) {
	req, out := c.GetAnomalySubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostAndUsage = "GetCostAndUsage"

// GetCostAndUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsage for more information on using the GetCostAndUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCostAndUsageRequest method.
//    req, resp := client.GetCostAndUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsageRequest(input *GetCostAndUsageInput) (req *request.Request, output *GetCostAndUsageOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageInput{}
	}

	output = &GetCostAndUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsage API operation for AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics for your account. You can specify which
// cost and usage-related metric, such as BlendedCosts or UsageQuantity, that
// you want the request to return. You can also filter and group your data by
// various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Management account in an organization in AWS Organizations have
// access to all member accounts.
//
// For information about filter limitations, see Quotas and restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsage for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * BillExpirationException
//   The requested report expired. Update the date interval and try again.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
//   * RequestChangedException
//   Your request parameters changed between pages. Try again with the old parameters
//   or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsage(input *GetCostAndUsageInput) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithContext is the same as GetCostAndUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithContext(ctx aws.Context, input *GetCostAndUsageInput, opts ...request.Option) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostAndUsageWithResources = "GetCostAndUsageWithResources"

// GetCostAndUsageWithResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsageWithResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsageWithResources for more information on using the GetCostAndUsageWithResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCostAndUsageWithResourcesRequest method.
//    req, resp := client.GetCostAndUsageWithResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources
func (c *CostExplorer) GetCostAndUsageWithResourcesRequest(input *GetCostAndUsageWithResourcesInput) (req *request.Request, output *GetCostAndUsageWithResourcesOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsageWithResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageWithResourcesInput{}
	}

	output = &GetCostAndUsageWithResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsageWithResources API operation for AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics with resources for your account. You can
// specify which cost and usage-related metric, such as BlendedCosts or UsageQuantity,
// that you want the request to return. You can also filter and group your data
// by various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Management account in an organization in AWS Organizations have
// access to all member accounts. This API is currently available for the Amazon
// Elastic Compute Cloud – Compute service only.
//
// This is an opt-in only feature. You can enable this feature from the Cost
// Explorer Settings page. For information on how to access the Settings page,
// see Controlling Access for Cost Explorer (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsageWithResources for usage and error information.
//
// Returned Error Types:
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * BillExpirationException
//   The requested report expired. Update the date interval and try again.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
//   * RequestChangedException
//   Your request parameters changed between pages. Try again with the old parameters
//   or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources
func (c *CostExplorer) GetCostAndUsageWithResources(input *GetCostAndUsageWithResourcesInput) (*GetCostAndUsageWithResourcesOutput, error) {
	req, out := c.GetCostAndUsageWithResourcesRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithResourcesWithContext is the same as GetCostAndUsageWithResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsageWithResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithResourcesWithContext(ctx aws.Context, input *GetCostAndUsageWithResourcesInput, opts ...request.Option) (*GetCostAndUsageWithResourcesOutput, error) {
	req, out := c.GetCostAndUsageWithResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCostForecast = "GetCostForecast"

// GetCostForecastRequest generates a "aws/request.Request" representing the
// client's request for the GetCostForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostForecast for more information on using the GetCostForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCostForecastRequest method.
//    req, resp := client.GetCostForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast
func (c *CostExplorer) GetCostForecastRequest(input *GetCostForecastInput) (req *request.Request, output *GetCostForecastOutput) {
	op := &request.Operation{
		Name:       opGetCostForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostForecastInput{}
	}

	output = &GetCostForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostForecast API operation for AWS Cost Explorer Service.
//
// Retrieves a forecast for how much Amazon Web Services predicts that you will
// spend over the forecast time period that you select, based on your past costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostForecast for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast
func (c *CostExplorer) GetCostForecast(input *GetCostForecastInput) (*GetCostForecastOutput, error) {
	req, out := c.GetCostForecastRequest(input)
	return out, req.Send()
}

// GetCostForecastWithContext is the same as GetCostForecast with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostForecastWithContext(ctx aws.Context, input *GetCostForecastInput, opts ...request.Option) (*GetCostForecastOutput, error) {
	req, out := c.GetCostForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDimensionValues = "GetDimensionValues"

// GetDimensionValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionValues for more information on using the GetDimensionValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDimensionValuesRequest method.
//    req, resp := client.GetDimensionValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValuesRequest(input *GetDimensionValuesInput) (req *request.Request, output *GetDimensionValuesOutput) {
	op := &request.Operation{
		Name:       opGetDimensionValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionValuesInput{}
	}

	output = &GetDimensionValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionValues API operation for AWS Cost Explorer Service.
//
// Retrieves all available filter values for a specified filter over a period
// of time. You can search the dimension values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetDimensionValues for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * BillExpirationException
//   The requested report expired. Update the date interval and try again.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
//   * RequestChangedException
//   Your request parameters changed between pages. Try again with the old parameters
//   or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValues(input *GetDimensionValuesInput) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	return out, req.Send()
}

// GetDimensionValuesWithContext is the same as GetDimensionValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetDimensionValuesWithContext(ctx aws.Context, input *GetDimensionValuesInput, opts ...request.Option) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationCoverage = "GetReservationCoverage"

// GetReservationCoverageRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationCoverage for more information on using the GetReservationCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationCoverageRequest method.
//    req, resp := client.GetReservationCoverageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverageRequest(input *GetReservationCoverageInput) (req *request.Request, output *GetReservationCoverageOutput) {
	op := &request.Operation{
		Name:       opGetReservationCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationCoverageInput{}
	}

	output = &GetReservationCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationCoverage API operation for AWS Cost Explorer Service.
//
// Retrieves the reservation coverage for your account. This enables you to
// see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon
// Relational Database Service, or Amazon Redshift usage is covered by a reservation.
// An organization's management account can see the coverage of the associated
// member accounts. This supports dimensions, Cost Categories, and nested expressions.
// For any time period, you can filter data about reservation usage by the following
// dimensions:
//
//    * AZ
//
//    * CACHE_ENGINE
//
//    * DATABASE_ENGINE
//
//    * DEPLOYMENT_OPTION
//
//    * INSTANCE_TYPE
//
//    * LINKED_ACCOUNT
//
//    * OPERATING_SYSTEM
//
//    * PLATFORM
//
//    * REGION
//
//    * SERVICE
//
//    * TAG
//
//    * TENANCY
//
// To determine valid values for a dimension, use the GetDimensionValues operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationCoverage for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage
func (c *CostExplorer) GetReservationCoverage(input *GetReservationCoverageInput) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	return out, req.Send()
}

// GetReservationCoverageWithContext is the same as GetReservationCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationCoverageWithContext(ctx aws.Context, input *GetReservationCoverageInput, opts ...request.Option) (*GetReservationCoverageOutput, error) {
	req, out := c.GetReservationCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationPurchaseRecommendation = "GetReservationPurchaseRecommendation"

// GetReservationPurchaseRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationPurchaseRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationPurchaseRecommendation for more information on using the GetReservationPurchaseRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationPurchaseRecommendationRequest method.
//    req, resp := client.GetReservationPurchaseRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendationRequest(input *GetReservationPurchaseRecommendationInput) (req *request.Request, output *GetReservationPurchaseRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetReservationPurchaseRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationPurchaseRecommendationInput{}
	}

	output = &GetReservationPurchaseRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationPurchaseRecommendation API operation for AWS Cost Explorer Service.
//
// Gets recommendations for which reservations to purchase. These recommendations
// could help you reduce your costs. Reservations provide a discounted hourly
// rate (up to 75%) compared to On-Demand pricing.
//
// AWS generates your recommendations by identifying your On-Demand usage during
// a specific time period and collecting your usage into categories that are
// eligible for a reservation. After AWS has these categories, it simulates
// every combination of reservations in each category of usage to identify the
// best number of each type of RI to purchase to maximize your estimated savings.
//
// For example, AWS automatically aggregates your Amazon EC2 Linux, shared tenancy,
// and c4 family usage in the US West (Oregon) Region and recommends that you
// buy size-flexible regional reservations to apply to the c4 family usage.
// AWS recommends the smallest size instance in an instance family. This makes
// it easier to purchase a size-flexible RI. AWS also shows the equal number
// of normalized units so that you can purchase any instance size that you want.
// For this example, your RI recommendation would be for c4.large because that
// is the smallest size instance in the c4 instance family.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationPurchaseRecommendation for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation
func (c *CostExplorer) GetReservationPurchaseRecommendation(input *GetReservationPurchaseRecommendationInput) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	return out, req.Send()
}

// GetReservationPurchaseRecommendationWithContext is the same as GetReservationPurchaseRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationPurchaseRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationPurchaseRecommendationWithContext(ctx aws.Context, input *GetReservationPurchaseRecommendationInput, opts ...request.Option) (*GetReservationPurchaseRecommendationOutput, error) {
	req, out := c.GetReservationPurchaseRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationUtilization = "GetReservationUtilization"

// GetReservationUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationUtilization for more information on using the GetReservationUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationUtilizationRequest method.
//    req, resp := client.GetReservationUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilizationRequest(input *GetReservationUtilizationInput) (req *request.Request, output *GetReservationUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetReservationUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationUtilizationInput{}
	}

	output = &GetReservationUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationUtilization API operation for AWS Cost Explorer Service.
//
// Retrieves the reservation utilization for your account. Management account
// in an organization have access to member accounts. You can filter data by
// dimensions in a time period. You can use GetDimensionValues to determine
// the possible dimension values. Currently, you can group only by SUBSCRIPTION_ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationUtilization for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilization(input *GetReservationUtilizationInput) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	return out, req.Send()
}

// GetReservationUtilizationWithContext is the same as GetReservationUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationUtilizationWithContext(ctx aws.Context, input *GetReservationUtilizationInput, opts ...request.Option) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRightsizingRecommendation = "GetRightsizingRecommendation"

// GetRightsizingRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetRightsizingRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRightsizingRecommendation for more information on using the GetRightsizingRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRightsizingRecommendationRequest method.
//    req, resp := client.GetRightsizingRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation
func (c *CostExplorer) GetRightsizingRecommendationRequest(input *GetRightsizingRecommendationInput) (req *request.Request, output *GetRightsizingRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetRightsizingRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRightsizingRecommendationInput{}
	}

	output = &GetRightsizingRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRightsizingRecommendation API operation for AWS Cost Explorer Service.
//
// Creates recommendations that help you save cost by identifying idle and underutilized
// Amazon EC2 instances.
//
// Recommendations are generated to either downsize or terminate instances,
// along with providing savings detail and metrics. For details on calculation
// and function, see Optimizing Your Cost with Rightsizing Recommendations (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetRightsizingRecommendation for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation
func (c *CostExplorer) GetRightsizingRecommendation(input *GetRightsizingRecommendationInput) (*GetRightsizingRecommendationOutput, error) {
	req, out := c.GetRightsizingRecommendationRequest(input)
	return out, req.Send()
}

// GetRightsizingRecommendationWithContext is the same as GetRightsizingRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetRightsizingRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetRightsizingRecommendationWithContext(ctx aws.Context, input *GetRightsizingRecommendationInput, opts ...request.Option) (*GetRightsizingRecommendationOutput, error) {
	req, out := c.GetRightsizingRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansCoverage = "GetSavingsPlansCoverage"

// GetSavingsPlansCoverageRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansCoverage for more information on using the GetSavingsPlansCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSavingsPlansCoverageRequest method.
//    req, resp := client.GetSavingsPlansCoverageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage
func (c *CostExplorer) GetSavingsPlansCoverageRequest(input *GetSavingsPlansCoverageInput) (req *request.Request, output *GetSavingsPlansCoverageOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSavingsPlansCoverageInput{}
	}

	output = &GetSavingsPlansCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansCoverage API operation for AWS Cost Explorer Service.
//
// Retrieves the Savings Plans covered for your account. This enables you to
// see how much of your cost is covered by a Savings Plan. An organization’s
// management account can see the coverage of the associated member accounts.
// This supports dimensions, Cost Categories, and nested expressions. For any
// time period, you can filter data for Savings Plans usage with the following
// dimensions:
//
//    * LINKED_ACCOUNT
//
//    * REGION
//
//    * SERVICE
//
//    * INSTANCE_FAMILY
//
// To determine valid values for a dimension, use the GetDimensionValues operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansCoverage for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage
func (c *CostExplorer) GetSavingsPlansCoverage(input *GetSavingsPlansCoverageInput) (*GetSavingsPlansCoverageOutput, error) {
	req, out := c.GetSavingsPlansCoverageRequest(input)
	return out, req.Send()
}

// GetSavingsPlansCoverageWithContext is the same as GetSavingsPlansCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansCoverageWithContext(ctx aws.Context, input *GetSavingsPlansCoverageInput, opts ...request.Option) (*GetSavingsPlansCoverageOutput, error) {
	req, out := c.GetSavingsPlansCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSavingsPlansCoveragePages iterates over the pages of a GetSavingsPlansCoverage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSavingsPlansCoverage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSavingsPlansCoverage operation.
//    pageNum := 0
//    err := client.GetSavingsPlansCoveragePages(params,
//        func(page *costexplorer.GetSavingsPlansCoverageOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CostExplorer) GetSavingsPlansCoveragePages(input *GetSavingsPlansCoverageInput, fn func(*GetSavingsPlansCoverageOutput, bool) bool) error {
	return c.GetSavingsPlansCoveragePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSavingsPlansCoveragePagesWithContext same as GetSavingsPlansCoveragePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansCoveragePagesWithContext(ctx aws.Context, input *GetSavingsPlansCoverageInput, fn func(*GetSavingsPlansCoverageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSavingsPlansCoverageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSavingsPlansCoverageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSavingsPlansCoverageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSavingsPlansPurchaseRecommendation = "GetSavingsPlansPurchaseRecommendation"

// GetSavingsPlansPurchaseRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansPurchaseRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansPurchaseRecommendation for more information on using the GetSavingsPlansPurchaseRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSavingsPlansPurchaseRecommendationRequest method.
//    req, resp := client.GetSavingsPlansPurchaseRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendationRequest(input *GetSavingsPlansPurchaseRecommendationInput) (req *request.Request, output *GetSavingsPlansPurchaseRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansPurchaseRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSavingsPlansPurchaseRecommendationInput{}
	}

	output = &GetSavingsPlansPurchaseRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansPurchaseRecommendation API operation for AWS Cost Explorer Service.
//
// Retrieves your request parameters, Savings Plan Recommendations Summary and
// Details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansPurchaseRecommendation for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendation(input *GetSavingsPlansPurchaseRecommendationInput) (*GetSavingsPlansPurchaseRecommendationOutput, error) {
	req, out := c.GetSavingsPlansPurchaseRecommendationRequest(input)
	return out, req.Send()
}

// GetSavingsPlansPurchaseRecommendationWithContext is the same as GetSavingsPlansPurchaseRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansPurchaseRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansPurchaseRecommendationWithContext(ctx aws.Context, input *GetSavingsPlansPurchaseRecommendationInput, opts ...request.Option) (*GetSavingsPlansPurchaseRecommendationOutput, error) {
	req, out := c.GetSavingsPlansPurchaseRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansUtilization = "GetSavingsPlansUtilization"

// GetSavingsPlansUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansUtilization for more information on using the GetSavingsPlansUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSavingsPlansUtilizationRequest method.
//    req, resp := client.GetSavingsPlansUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization
func (c *CostExplorer) GetSavingsPlansUtilizationRequest(input *GetSavingsPlansUtilizationInput) (req *request.Request, output *GetSavingsPlansUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSavingsPlansUtilizationInput{}
	}

	output = &GetSavingsPlansUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansUtilization API operation for AWS Cost Explorer Service.
//
// Retrieves the Savings Plans utilization for your account across date ranges
// with daily or monthly granularity. Management account in an organization
// have access to member accounts. You can use GetDimensionValues in SAVINGS_PLANS
// to determine the possible dimension values.
//
// You cannot group by any dimension values for GetSavingsPlansUtilization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansUtilization for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization
func (c *CostExplorer) GetSavingsPlansUtilization(input *GetSavingsPlansUtilizationInput) (*GetSavingsPlansUtilizationOutput, error) {
	req, out := c.GetSavingsPlansUtilizationRequest(input)
	return out, req.Send()
}

// GetSavingsPlansUtilizationWithContext is the same as GetSavingsPlansUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationInput, opts ...request.Option) (*GetSavingsPlansUtilizationOutput, error) {
	req, out := c.GetSavingsPlansUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSavingsPlansUtilizationDetails = "GetSavingsPlansUtilizationDetails"

// GetSavingsPlansUtilizationDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetSavingsPlansUtilizationDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSavingsPlansUtilizationDetails for more information on using the GetSavingsPlansUtilizationDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSavingsPlansUtilizationDetailsRequest method.
//    req, resp := client.GetSavingsPlansUtilizationDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsRequest(input *GetSavingsPlansUtilizationDetailsInput) (req *request.Request, output *GetSavingsPlansUtilizationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetSavingsPlansUtilizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSavingsPlansUtilizationDetailsInput{}
	}

	output = &GetSavingsPlansUtilizationDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSavingsPlansUtilizationDetails API operation for AWS Cost Explorer Service.
//
// Retrieves attribute data along with aggregate utilization and savings data
// for a given time period. This doesn't support granular or grouped data (daily/monthly)
// in response. You can't retrieve data by dates in a single response similar
// to GetSavingsPlanUtilization, but you have the option to make multiple calls
// to GetSavingsPlanUtilizationDetails by providing individual dates. You can
// use GetDimensionValues in SAVINGS_PLANS to determine the possible dimension
// values.
//
// GetSavingsPlanUtilizationDetails internally groups data by SavingsPlansArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetSavingsPlansUtilizationDetails for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails
func (c *CostExplorer) GetSavingsPlansUtilizationDetails(input *GetSavingsPlansUtilizationDetailsInput) (*GetSavingsPlansUtilizationDetailsOutput, error) {
	req, out := c.GetSavingsPlansUtilizationDetailsRequest(input)
	return out, req.Send()
}

// GetSavingsPlansUtilizationDetailsWithContext is the same as GetSavingsPlansUtilizationDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetSavingsPlansUtilizationDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationDetailsInput, opts ...request.Option) (*GetSavingsPlansUtilizationDetailsOutput, error) {
	req, out := c.GetSavingsPlansUtilizationDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSavingsPlansUtilizationDetailsPages iterates over the pages of a GetSavingsPlansUtilizationDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSavingsPlansUtilizationDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSavingsPlansUtilizationDetails operation.
//    pageNum := 0
//    err := client.GetSavingsPlansUtilizationDetailsPages(params,
//        func(page *costexplorer.GetSavingsPlansUtilizationDetailsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsPages(input *GetSavingsPlansUtilizationDetailsInput, fn func(*GetSavingsPlansUtilizationDetailsOutput, bool) bool) error {
	return c.GetSavingsPlansUtilizationDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSavingsPlansUtilizationDetailsPagesWithContext same as GetSavingsPlansUtilizationDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetSavingsPlansUtilizationDetailsPagesWithContext(ctx aws.Context, input *GetSavingsPlansUtilizationDetailsInput, fn func(*GetSavingsPlansUtilizationDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSavingsPlansUtilizationDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSavingsPlansUtilizationDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSavingsPlansUtilizationDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Cost Explorer Service.
//
// Queries for available tag keys and tag values for a specified period. You
// can search the tag values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * BillExpirationException
//   The requested report expired. Update the date interval and try again.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * InvalidNextTokenException
//   The pagination token is invalid. Try again without a pagination token.
//
//   * RequestChangedException
//   Your request parameters changed between pages. Try again with the old parameters
//   or without a pagination token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsageForecast = "GetUsageForecast"

// GetUsageForecastRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageForecast for more information on using the GetUsageForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsageForecastRequest method.
//    req, resp := client.GetUsageForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast
func (c *CostExplorer) GetUsageForecastRequest(input *GetUsageForecastInput) (req *request.Request, output *GetUsageForecastOutput) {
	op := &request.Operation{
		Name:       opGetUsageForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUsageForecastInput{}
	}

	output = &GetUsageForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageForecast API operation for AWS Cost Explorer Service.
//
// Retrieves a forecast for how much Amazon Web Services predicts that you will
// use over the forecast time period that you select, based on your past usage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetUsageForecast for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * DataUnavailableException
//   The requested data is unavailable.
//
//   * UnresolvableUsageUnitException
//   Cost Explorer was unable to identify the usage unit. Provide UsageType/UsageTypeGroup
//   filter selections that contain matching units, for example: hours.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast
func (c *CostExplorer) GetUsageForecast(input *GetUsageForecastInput) (*GetUsageForecastOutput, error) {
	req, out := c.GetUsageForecastRequest(input)
	return out, req.Send()
}

// GetUsageForecastWithContext is the same as GetUsageForecast with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetUsageForecastWithContext(ctx aws.Context, input *GetUsageForecastInput, opts ...request.Option) (*GetUsageForecastOutput, error) {
	req, out := c.GetUsageForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCostCategoryDefinitions = "ListCostCategoryDefinitions"

// ListCostCategoryDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCostCategoryDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCostCategoryDefinitions for more information on using the ListCostCategoryDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCostCategoryDefinitionsRequest method.
//    req, resp := client.ListCostCategoryDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions
func (c *CostExplorer) ListCostCategoryDefinitionsRequest(input *ListCostCategoryDefinitionsInput) (req *request.Request, output *ListCostCategoryDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListCostCategoryDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCostCategoryDefinitionsInput{}
	}

	output = &ListCostCategoryDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCostCategoryDefinitions API operation for AWS Cost Explorer Service.
//
// Returns the name, ARN, NumberOfRules and effective dates of all Cost Categories
// defined in the account. You have the option to use EffectiveOn to return
// a list of Cost Categories that were active on a specific date. If there is
// no EffectiveOn specified, you’ll see Cost Categories that are effective
// on the current date. If Cost Category is still effective, EffectiveEnd is
// omitted in the response. ListCostCategoryDefinitions supports pagination.
// The request can have a MaxResults range up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ListCostCategoryDefinitions for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions
func (c *CostExplorer) ListCostCategoryDefinitions(input *ListCostCategoryDefinitionsInput) (*ListCostCategoryDefinitionsOutput, error) {
	req, out := c.ListCostCategoryDefinitionsRequest(input)
	return out, req.Send()
}

// ListCostCategoryDefinitionsWithContext is the same as ListCostCategoryDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCostCategoryDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostCategoryDefinitionsWithContext(ctx aws.Context, input *ListCostCategoryDefinitionsInput, opts ...request.Option) (*ListCostCategoryDefinitionsOutput, error) {
	req, out := c.ListCostCategoryDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCostCategoryDefinitionsPages iterates over the pages of a ListCostCategoryDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCostCategoryDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCostCategoryDefinitions operation.
//    pageNum := 0
//    err := client.ListCostCategoryDefinitionsPages(params,
//        func(page *costexplorer.ListCostCategoryDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CostExplorer) ListCostCategoryDefinitionsPages(input *ListCostCategoryDefinitionsInput, fn func(*ListCostCategoryDefinitionsOutput, bool) bool) error {
	return c.ListCostCategoryDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCostCategoryDefinitionsPagesWithContext same as ListCostCategoryDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ListCostCategoryDefinitionsPagesWithContext(ctx aws.Context, input *ListCostCategoryDefinitionsInput, fn func(*ListCostCategoryDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCostCategoryDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCostCategoryDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCostCategoryDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opProvideAnomalyFeedback = "ProvideAnomalyFeedback"

// ProvideAnomalyFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the ProvideAnomalyFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvideAnomalyFeedback for more information on using the ProvideAnomalyFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ProvideAnomalyFeedbackRequest method.
//    req, resp := client.ProvideAnomalyFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback
func (c *CostExplorer) ProvideAnomalyFeedbackRequest(input *ProvideAnomalyFeedbackInput) (req *request.Request, output *ProvideAnomalyFeedbackOutput) {
	op := &request.Operation{
		Name:       opProvideAnomalyFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvideAnomalyFeedbackInput{}
	}

	output = &ProvideAnomalyFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvideAnomalyFeedback API operation for AWS Cost Explorer Service.
//
// Modifies the feedback property of a given cost anomaly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation ProvideAnomalyFeedback for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback
func (c *CostExplorer) ProvideAnomalyFeedback(input *ProvideAnomalyFeedbackInput) (*ProvideAnomalyFeedbackOutput, error) {
	req, out := c.ProvideAnomalyFeedbackRequest(input)
	return out, req.Send()
}

// ProvideAnomalyFeedbackWithContext is the same as ProvideAnomalyFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See ProvideAnomalyFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) ProvideAnomalyFeedbackWithContext(ctx aws.Context, input *ProvideAnomalyFeedbackInput, opts ...request.Option) (*ProvideAnomalyFeedbackOutput, error) {
	req, out := c.ProvideAnomalyFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnomalyMonitor = "UpdateAnomalyMonitor"

// UpdateAnomalyMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnomalyMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnomalyMonitor for more information on using the UpdateAnomalyMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnomalyMonitorRequest method.
//    req, resp := client.UpdateAnomalyMonitorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor
func (c *CostExplorer) UpdateAnomalyMonitorRequest(input *UpdateAnomalyMonitorInput) (req *request.Request, output *UpdateAnomalyMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateAnomalyMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAnomalyMonitorInput{}
	}

	output = &UpdateAnomalyMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnomalyMonitor API operation for AWS Cost Explorer Service.
//
// Updates an existing cost anomaly monitor. The changes made are applied going
// forward, and does not change anomalies detected in the past.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateAnomalyMonitor for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownMonitorException
//   The cost anomaly monitor does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor
func (c *CostExplorer) UpdateAnomalyMonitor(input *UpdateAnomalyMonitorInput) (*UpdateAnomalyMonitorOutput, error) {
	req, out := c.UpdateAnomalyMonitorRequest(input)
	return out, req.Send()
}

// UpdateAnomalyMonitorWithContext is the same as UpdateAnomalyMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnomalyMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateAnomalyMonitorWithContext(ctx aws.Context, input *UpdateAnomalyMonitorInput, opts ...request.Option) (*UpdateAnomalyMonitorOutput, error) {
	req, out := c.UpdateAnomalyMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnomalySubscription = "UpdateAnomalySubscription"

// UpdateAnomalySubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnomalySubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnomalySubscription for more information on using the UpdateAnomalySubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnomalySubscriptionRequest method.
//    req, resp := client.UpdateAnomalySubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription
func (c *CostExplorer) UpdateAnomalySubscriptionRequest(input *UpdateAnomalySubscriptionInput) (req *request.Request, output *UpdateAnomalySubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateAnomalySubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAnomalySubscriptionInput{}
	}

	output = &UpdateAnomalySubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnomalySubscription API operation for AWS Cost Explorer Service.
//
// Updates an existing cost anomaly monitor subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateAnomalySubscription for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
//   * UnknownMonitorException
//   The cost anomaly monitor does not exist for the account.
//
//   * UnknownSubscriptionException
//   The cost anomaly subscription does not exist for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription
func (c *CostExplorer) UpdateAnomalySubscription(input *UpdateAnomalySubscriptionInput) (*UpdateAnomalySubscriptionOutput, error) {
	req, out := c.UpdateAnomalySubscriptionRequest(input)
	return out, req.Send()
}

// UpdateAnomalySubscriptionWithContext is the same as UpdateAnomalySubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnomalySubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateAnomalySubscriptionWithContext(ctx aws.Context, input *UpdateAnomalySubscriptionInput, opts ...request.Option) (*UpdateAnomalySubscriptionOutput, error) {
	req, out := c.UpdateAnomalySubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCostCategoryDefinition = "UpdateCostCategoryDefinition"

// UpdateCostCategoryDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCostCategoryDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCostCategoryDefinition for more information on using the UpdateCostCategoryDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCostCategoryDefinitionRequest method.
//    req, resp := client.UpdateCostCategoryDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition
func (c *CostExplorer) UpdateCostCategoryDefinitionRequest(input *UpdateCostCategoryDefinitionInput) (req *request.Request, output *UpdateCostCategoryDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCostCategoryDefinitionInput{}
	}

	output = &UpdateCostCategoryDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCostCategoryDefinition API operation for AWS Cost Explorer Service.
//
// Updates an existing Cost Category. Changes made to the Cost Category rules
// will be used to categorize the current month’s expenses and future expenses.
// This won’t change categorization for the previous months.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation UpdateCostCategoryDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified ARN in the request doesn't exist.
//
//   * ServiceQuotaExceededException
//   You've reached the limit on the number of resources you can create, or exceeded
//   the size of an individual resource.
//
//   * LimitExceededException
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition
func (c *CostExplorer) UpdateCostCategoryDefinition(input *UpdateCostCategoryDefinitionInput) (*UpdateCostCategoryDefinitionOutput, error) {
	req, out := c.UpdateCostCategoryDefinitionRequest(input)
	return out, req.Send()
}

// UpdateCostCategoryDefinitionWithContext is the same as UpdateCostCategoryDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCostCategoryDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) UpdateCostCategoryDefinitionWithContext(ctx aws.Context, input *UpdateCostCategoryDefinitionInput, opts ...request.Option) (*UpdateCostCategoryDefinitionOutput, error) {
	req, out := c.UpdateCostCategoryDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An unusual cost pattern. This consists of the detailed metadata and the current
// status of the anomaly object.
type Anomaly struct {
	_ struct{} `type:"structure"`

	// The last day the anomaly is detected.
	AnomalyEndDate *string `type:"string"`

	// The unique identifier for the anomaly.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`

	// The latest and maximum score for the anomaly.
	//
	// AnomalyScore is a required field
	AnomalyScore *AnomalyScore `type:"structure" required:"true"`

	// The first day the anomaly is detected.
	AnomalyStartDate *string `type:"string"`

	// The dimension for the anomaly. For example, an AWS service in a service monitor.
	DimensionValue *string `type:"string"`

	// The feedback value.
	Feedback *string `type:"string" enum:"AnomalyFeedbackType"`

	// The dollar impact for the anomaly.
	//
	// Impact is a required field
	Impact *Impact `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`

	// The list of identified root causes for the anomaly.
	RootCauses []*RootCause `type:"list"`
}

// String returns the string representation
func (s Anomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Anomaly) GoString() string {
	return s.String()
}

// SetAnomalyEndDate sets the AnomalyEndDate field's value.
func (s *Anomaly) SetAnomalyEndDate(v string) *Anomaly {
	s.AnomalyEndDate = &v
	return s
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *Anomaly) SetAnomalyId(v string) *Anomaly {
	s.AnomalyId = &v
	return s
}

// SetAnomalyScore sets the AnomalyScore field's value.
func (s *Anomaly) SetAnomalyScore(v *AnomalyScore) *Anomaly {
	s.AnomalyScore = v
	return s
}

// SetAnomalyStartDate sets the AnomalyStartDate field's value.
func (s *Anomaly) SetAnomalyStartDate(v string) *Anomaly {
	s.AnomalyStartDate = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *Anomaly) SetDimensionValue(v string) *Anomaly {
	s.DimensionValue = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *Anomaly) SetFeedback(v string) *Anomaly {
	s.Feedback = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *Anomaly) SetImpact(v *Impact) *Anomaly {
	s.Impact = v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *Anomaly) SetMonitorArn(v string) *Anomaly {
	s.MonitorArn = &v
	return s
}

// SetRootCauses sets the RootCauses field's value.
func (s *Anomaly) SetRootCauses(v []*RootCause) *Anomaly {
	s.RootCauses = v
	return s
}

// The time period for an anomaly.
type AnomalyDateInterval struct {
	_ struct{} `type:"structure"`

	// The last date an anomaly was observed.
	EndDate *string `type:"string"`

	// The first date an anomaly was observed.
	//
	// StartDate is a required field
	StartDate *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AnomalyDateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalyDateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyDateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyDateInterval"}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *AnomalyDateInterval) SetEndDate(v string) *AnomalyDateInterval {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *AnomalyDateInterval) SetStartDate(v string) *AnomalyDateInterval {
	s.StartDate = &v
	return s
}

// This object continuously inspects your account's cost data for anomalies,
// based on MonitorType and MonitorSpecification. The content consists of detailed
// metadata and the current status of the monitor object.
type AnomalyMonitor struct {
	_ struct{} `type:"structure"`

	// The date when the monitor was created.
	CreationDate *string `type:"string"`

	// The value for evaluated dimensions.
	DimensionalValueCount *int64 `type:"integer"`

	// The date when the monitor last evaluated for anomalies.
	LastEvaluatedDate *string `type:"string"`

	// The date when the monitor was last updated.
	LastUpdatedDate *string `type:"string"`

	// The Amazon Resource Name (ARN) value.
	MonitorArn *string `type:"string"`

	// The dimensions to evaluate.
	MonitorDimension *string `type:"string" enum:"MonitorDimension"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `type:"string" required:"true"`

	// Use Expression to filter by cost or by usage. There are two patterns:
	//
	//    * Simple dimension values - You can set the dimension name and values
	//    for the filters that you plan to use. For example, you can filter for
	//    REGION==us-east-1 OR REGION==us-west-1. For GetRightsizingRecommendation,
	//    the Region is a full name (for example, REGION==US East (N. Virginia).
	//    The Expression example looks like: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", “us-west-1” ] } } The list of dimension values
	//    are OR'd together to retrieve cost or usage data. You can create Expression
	//    and DimensionValues objects using either with* methods or set* methods
	//    in multiple lines.
	//
	//    * Compound dimension values with logical operations - You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. This allows you to filter on more advanced
	//    options. For example, you can filter on ((REGION == us-east-1 OR REGION
	//    == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The Expression for that looks like this: { "And": [ {"Or": [ {"Dimensions":
	//    { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags":
	//    { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } Because each
	//    Expression can have only one operator, the service returns an error if
	//    more than one is specified. The following example shows an Expression
	//    object that creates an error. { "And": [ ... ], "DimensionValues": { "Dimension":
	//    "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
	//
	// For GetRightsizingRecommendation action, a combination of OR and NOT is not
	// supported. OR is not supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	MonitorSpecification *Expression `type:"structure"`

	// The possible type values.
	//
	// MonitorType is a required field
	MonitorType *string `type:"string" required:"true" enum:"MonitorType"`
}

// String returns the string representation
func (s AnomalyMonitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalyMonitor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyMonitor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyMonitor"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorType == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorType"))
	}
	if s.MonitorSpecification != nil {
		if err := s.MonitorSpecification.Validate(); err != nil {
			invalidParams.AddNested("MonitorSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationDate sets the CreationDate field's value.
func (s *AnomalyMonitor) SetCreationDate(v string) *AnomalyMonitor {
	s.CreationDate = &v
	return s
}

// SetDimensionalValueCount sets the DimensionalValueCount field's value.
func (s *AnomalyMonitor) SetDimensionalValueCount(v int64) *AnomalyMonitor {
	s.DimensionalValueCount = &v
	return s
}

// SetLastEvaluatedDate sets the LastEvaluatedDate field's value.
func (s *AnomalyMonitor) SetLastEvaluatedDate(v string) *AnomalyMonitor {
	s.LastEvaluatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AnomalyMonitor) SetLastUpdatedDate(v string) *AnomalyMonitor {
	s.LastUpdatedDate = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *AnomalyMonitor) SetMonitorArn(v string) *AnomalyMonitor {
	s.MonitorArn = &v
	return s
}

// SetMonitorDimension sets the MonitorDimension field's value.
func (s *AnomalyMonitor) SetMonitorDimension(v string) *AnomalyMonitor {
	s.MonitorDimension = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *AnomalyMonitor) SetMonitorName(v string) *AnomalyMonitor {
	s.MonitorName = &v
	return s
}

// SetMonitorSpecification sets the MonitorSpecification field's value.
func (s *AnomalyMonitor) SetMonitorSpecification(v *Expression) *AnomalyMonitor {
	s.MonitorSpecification = v
	return s
}

// SetMonitorType sets the MonitorType field's value.
func (s *AnomalyMonitor) SetMonitorType(v string) *AnomalyMonitor {
	s.MonitorType = &v
	return s
}

// Quantifies the anomaly. The higher score means that it is more anomalous.
type AnomalyScore struct {
	_ struct{} `type:"structure"`

	// The last observed score.
	//
	// CurrentScore is a required field
	CurrentScore *float64 `type:"double" required:"true"`

	// The maximum score observed during the AnomalyDateInterval.
	//
	// MaxScore is a required field
	MaxScore *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AnomalyScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalyScore) GoString() string {
	return s.String()
}

// SetCurrentScore sets the CurrentScore field's value.
func (s *AnomalyScore) SetCurrentScore(v float64) *AnomalyScore {
	s.CurrentScore = &v
	return s
}

// SetMaxScore sets the MaxScore field's value.
func (s *AnomalyScore) SetMaxScore(v float64) *AnomalyScore {
	s.MaxScore = &v
	return s
}

// The association between a monitor, threshold, and list of subscribers used
// to deliver notifications about anomalies detected by a monitor that exceeds
// a threshold. The content consists of the detailed metadata and the current
// status of the AnomalySubscription object.
type AnomalySubscription struct {
	_ struct{} `type:"structure"`

	// Your unique account identifier.
	AccountId *string `type:"string"`

	// The frequency at which anomaly reports are sent over email.
	//
	// Frequency is a required field
	Frequency *string `type:"string" required:"true" enum:"AnomalySubscriptionFrequency"`

	// A list of cost anomaly monitors.
	//
	// MonitorArnList is a required field
	MonitorArnList []*string `type:"list" required:"true"`

	// A list of subscribers to notify.
	//
	// Subscribers is a required field
	Subscribers []*Subscriber `type:"list" required:"true"`

	// The AnomalySubscription Amazon Resource Name (ARN).
	SubscriptionArn *string `type:"string"`

	// The name for the subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// The dollar value that triggers a notification if the threshold is exceeded.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AnomalySubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalySubscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalySubscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalySubscription"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}
	if s.MonitorArnList == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArnList"))
	}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AnomalySubscription) SetAccountId(v string) *AnomalySubscription {
	s.AccountId = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *AnomalySubscription) SetFrequency(v string) *AnomalySubscription {
	s.Frequency = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *AnomalySubscription) SetMonitorArnList(v []*string) *AnomalySubscription {
	s.MonitorArnList = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *AnomalySubscription) SetSubscribers(v []*Subscriber) *AnomalySubscription {
	s.Subscribers = v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *AnomalySubscription) SetSubscriptionArn(v string) *AnomalySubscription {
	s.SubscriptionArn = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *AnomalySubscription) SetSubscriptionName(v string) *AnomalySubscription {
	s.SubscriptionName = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *AnomalySubscription) SetThreshold(v float64) *AnomalySubscription {
	s.Threshold = &v
	return s
}

// The requested report expired. Update the date interval and try again.
type BillExpirationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BillExpirationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillExpirationException) GoString() string {
	return s.String()
}

func newErrorBillExpirationException(v protocol.ResponseMetadata) error {
	return &BillExpirationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BillExpirationException) Code() string {
	return "BillExpirationException"
}

// Message returns the exception's message.
func (s *BillExpirationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BillExpirationException) OrigErr() error {
	return nil
}

func (s *BillExpirationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BillExpirationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BillExpirationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure of Cost Categories. This includes detailed metadata and the
// set of rules for the CostCategory object.
type CostCategory struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The Cost Category's effective end date.
	EffectiveEnd *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	//
	// EffectiveStart is a required field
	EffectiveStart *string `min:"20" type:"string" required:"true"`

	// The unique name of the Cost Category.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The list of processing statuses for Cost Management products for a specific
	// cost category.
	ProcessingStatus []*CostCategoryProcessingStatus `type:"list"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// Rules are processed in order. If there are multiple rules that match the
	// line item, then the first rule to match is used to determine that Cost Category
	// value.
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CostCategory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostCategory) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CostCategory) SetCostCategoryArn(v string) *CostCategory {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *CostCategory) SetEffectiveEnd(v string) *CostCategory {
	s.EffectiveEnd = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CostCategory) SetEffectiveStart(v string) *CostCategory {
	s.EffectiveStart = &v
	return s
}

// SetName sets the Name field's value.
func (s *CostCategory) SetName(v string) *CostCategory {
	s.Name = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *CostCategory) SetProcessingStatus(v []*CostCategoryProcessingStatus) *CostCategory {
	s.ProcessingStatus = v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *CostCategory) SetRuleVersion(v string) *CostCategory {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CostCategory) SetRules(v []*CostCategoryRule) *CostCategory {
	s.Rules = v
	return s
}

// The list of processing statuses for Cost Management products for a specific
// cost category.
type CostCategoryProcessingStatus struct {
	_ struct{} `type:"structure"`

	// The Cost Management product name of the applied status.
	Component *string `type:"string" enum:"CostCategoryStatusComponent"`

	// The process status for a specific cost category.
	Status *string `type:"string" enum:"CostCategoryStatus"`
}

// String returns the string representation
func (s CostCategoryProcessingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostCategoryProcessingStatus) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *CostCategoryProcessingStatus) SetComponent(v string) *CostCategoryProcessingStatus {
	s.Component = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CostCategoryProcessingStatus) SetStatus(v string) *CostCategoryProcessingStatus {
	s.Status = &v
	return s
}

// A reference to a Cost Category containing only enough information to identify
// the Cost Category.
//
// You can use this information to retrieve the full Cost Category information
// using DescribeCostCategory.
type CostCategoryReference struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective end date.
	EffectiveEnd *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	EffectiveStart *string `min:"20" type:"string"`

	// The unique name of the Cost Category.
	Name *string `min:"1" type:"string"`

	// The number of rules associated with a specific Cost Category.
	NumberOfRules *int64 `type:"integer"`

	// The list of processing statuses for Cost Management products for a specific
	// cost category.
	ProcessingStatus []*CostCategoryProcessingStatus `type:"list"`

	// A list of unique cost category values in a specific cost category.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s CostCategoryReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostCategoryReference) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CostCategoryReference) SetCostCategoryArn(v string) *CostCategoryReference {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *CostCategoryReference) SetEffectiveEnd(v string) *CostCategoryReference {
	s.EffectiveEnd = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CostCategoryReference) SetEffectiveStart(v string) *CostCategoryReference {
	s.EffectiveStart = &v
	return s
}

// SetName sets the Name field's value.
func (s *CostCategoryReference) SetName(v string) *CostCategoryReference {
	s.Name = &v
	return s
}

// SetNumberOfRules sets the NumberOfRules field's value.
func (s *CostCategoryReference) SetNumberOfRules(v int64) *CostCategoryReference {
	s.NumberOfRules = &v
	return s
}

// SetProcessingStatus sets the ProcessingStatus field's value.
func (s *CostCategoryReference) SetProcessingStatus(v []*CostCategoryProcessingStatus) *CostCategoryReference {
	s.ProcessingStatus = v
	return s
}

// SetValues sets the Values field's value.
func (s *CostCategoryReference) SetValues(v []*string) *CostCategoryReference {
	s.Values = v
	return s
}

// Rules are processed in order. If there are multiple rules that match the
// line item, then the first rule to match is used to determine that Cost Category
// value.
type CostCategoryRule struct {
	_ struct{} `type:"structure"`

	// An Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to categorize costs. This supports dimensions, tags, and nested
	// expressions. Currently the only dimensions supported are LINKED_ACCOUNT,
	// SERVICE_CODE, RECORD_TYPE, and LINKED_ACCOUNT_NAME.
	//
	// Root level OR is not supported. We recommend that you create a separate rule
	// instead.
	//
	// RECORD_TYPE is a dimension used for Cost Explorer APIs, and is also supported
	// for Cost Category expressions. This dimension uses different terms, depending
	// on whether you're using the console or API/JSON editor. For a detailed comparison,
	// see Term Comparisons (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms)
	// in the AWS Billing and Cost Management User Guide.
	//
	// Rule is a required field
	Rule *Expression `type:"structure" required:"true"`

	// The value a line item will be categorized as, if it matches the rule.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CostCategoryRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostCategoryRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategoryRule"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *CostCategoryRule) SetRule(v *Expression) *CostCategoryRule {
	s.Rule = v
	return s
}

// SetValue sets the Value field's value.
func (s *CostCategoryRule) SetValue(v string) *CostCategoryRule {
	s.Value = &v
	return s
}

// The Cost Categories values used for filtering the costs.
type CostCategoryValues struct {
	_ struct{} `type:"structure"`

	// The unique name of the Cost Category.
	Key *string `min:"1" type:"string"`

	// The match options that you can use to filter your results. MatchOptions is
	// only applicable for only applicable for actions related to cost category.
	// The default values for MatchOptions is EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list"`

	// The specific value of the Cost Category.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s CostCategoryValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CostCategoryValues) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryValues) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CostCategoryValues"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *CostCategoryValues) SetKey(v string) *CostCategoryValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *CostCategoryValues) SetMatchOptions(v []*string) *CostCategoryValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *CostCategoryValues) SetValues(v []*string) *CostCategoryValues {
	s.Values = v
	return s
}

// The amount of instance usage that a reservation covered.
type Coverage struct {
	_ struct{} `type:"structure"`

	// The amount of cost that the reservation covered.
	CoverageCost *CoverageCost `type:"structure"`

	// The amount of instance usage that the reservation covered, in hours.
	CoverageHours *CoverageHours `type:"structure"`

	// The amount of instance usage that the reservation covered, in normalized
	// units.
	CoverageNormalizedUnits *CoverageNormalizedUnits `type:"structure"`
}

// String returns the string representation
func (s Coverage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Coverage) GoString() string {
	return s.String()
}

// SetCoverageCost sets the CoverageCost field's value.
func (s *Coverage) SetCoverageCost(v *CoverageCost) *Coverage {
	s.CoverageCost = v
	return s
}

// SetCoverageHours sets the CoverageHours field's value.
func (s *Coverage) SetCoverageHours(v *CoverageHours) *Coverage {
	s.CoverageHours = v
	return s
}

// SetCoverageNormalizedUnits sets the CoverageNormalizedUnits field's value.
func (s *Coverage) SetCoverageNormalizedUnits(v *CoverageNormalizedUnits) *Coverage {
	s.CoverageNormalizedUnits = v
	return s
}

// Reservation coverage for a specified period, in hours.
type CoverageByTime struct {
	_ struct{} `type:"structure"`

	// The groups of instances that the reservation covered.
	Groups []*ReservationCoverageGroup `type:"list"`

	// The period that this coverage was used over.
	TimePeriod *DateInterval `type:"structure"`

	// The total reservation coverage, in hours.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s CoverageByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *CoverageByTime) SetGroups(v []*ReservationCoverageGroup) *CoverageByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *CoverageByTime) SetTimePeriod(v *DateInterval) *CoverageByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *CoverageByTime) SetTotal(v *Coverage) *CoverageByTime {
	s.Total = v
	return s
}

// How much it costs to run an instance.
type CoverageCost struct {
	_ struct{} `type:"structure"`

	// How much an On-Demand Instance costs.
	OnDemandCost *string `type:"string"`
}

// String returns the string representation
func (s CoverageCost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageCost) GoString() string {
	return s.String()
}

// SetOnDemandCost sets the OnDemandCost field's value.
func (s *CoverageCost) SetOnDemandCost(v string) *CoverageCost {
	s.OnDemandCost = &v
	return s
}

// How long a running instance either used a reservation or was On-Demand.
type CoverageHours struct {
	_ struct{} `type:"structure"`

	// The percentage of instance hours that a reservation covered.
	CoverageHoursPercentage *string `type:"string"`

	// The number of instance running hours that On-Demand Instances covered.
	OnDemandHours *string `type:"string"`

	// The number of instance running hours that reservations covered.
	ReservedHours *string `type:"string"`

	// The total instance usage, in hours.
	TotalRunningHours *string `type:"string"`
}

// String returns the string representation
func (s CoverageHours) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageHours) GoString() string {
	return s.String()
}

// SetCoverageHoursPercentage sets the CoverageHoursPercentage field's value.
func (s *CoverageHours) SetCoverageHoursPercentage(v string) *CoverageHours {
	s.CoverageHoursPercentage = &v
	return s
}

// SetOnDemandHours sets the OnDemandHours field's value.
func (s *CoverageHours) SetOnDemandHours(v string) *CoverageHours {
	s.OnDemandHours = &v
	return s
}

// SetReservedHours sets the ReservedHours field's value.
func (s *CoverageHours) SetReservedHours(v string) *CoverageHours {
	s.ReservedHours = &v
	return s
}

// SetTotalRunningHours sets the TotalRunningHours field's value.
func (s *CoverageHours) SetTotalRunningHours(v string) *CoverageHours {
	s.TotalRunningHours = &v
	return s
}

// The amount of instance usage, in normalized units. Normalized units enable
// you to see your EC2 usage for multiple sizes of instances in a uniform way.
// For example, suppose you run an xlarge instance and a 2xlarge instance. If
// you run both instances for the same amount of time, the 2xlarge instance
// uses twice as much of your reservation as the xlarge instance, even though
// both instances show only one instance-hour. Using normalized units instead
// of instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge
// instance used 16 normalized units.
//
// For more information, see Modifying Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
type CoverageNormalizedUnits struct {
	_ struct{} `type:"structure"`

	// The percentage of your used instance normalized units that a reservation
	// covers.
	CoverageNormalizedUnitsPercentage *string `type:"string"`

	// The number of normalized units that are covered by On-Demand Instances instead
	// of a reservation.
	OnDemandNormalizedUnits *string `type:"string"`

	// The number of normalized units that a reservation covers.
	ReservedNormalizedUnits *string `type:"string"`

	// The total number of normalized units that you used.
	TotalRunningNormalizedUnits *string `type:"string"`
}

// String returns the string representation
func (s CoverageNormalizedUnits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoverageNormalizedUnits) GoString() string {
	return s.String()
}

// SetCoverageNormalizedUnitsPercentage sets the CoverageNormalizedUnitsPercentage field's value.
func (s *CoverageNormalizedUnits) SetCoverageNormalizedUnitsPercentage(v string) *CoverageNormalizedUnits {
	s.CoverageNormalizedUnitsPercentage = &v
	return s
}

// SetOnDemandNormalizedUnits sets the OnDemandNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetOnDemandNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.OnDemandNormalizedUnits = &v
	return s
}

// SetReservedNormalizedUnits sets the ReservedNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetReservedNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.ReservedNormalizedUnits = &v
	return s
}

// SetTotalRunningNormalizedUnits sets the TotalRunningNormalizedUnits field's value.
func (s *CoverageNormalizedUnits) SetTotalRunningNormalizedUnits(v string) *CoverageNormalizedUnits {
	s.TotalRunningNormalizedUnits = &v
	return s
}

type CreateAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// The cost anomaly detection monitor object that you want to create.
	//
	// AnomalyMonitor is a required field
	AnomalyMonitor *AnomalyMonitor `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnomalyMonitorInput"}
	if s.AnomalyMonitor == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyMonitor"))
	}
	if s.AnomalyMonitor != nil {
		if err := s.AnomalyMonitor.Validate(); err != nil {
			invalidParams.AddNested("AnomalyMonitor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyMonitor sets the AnomalyMonitor field's value.
func (s *CreateAnomalyMonitorInput) SetAnomalyMonitor(v *AnomalyMonitor) *CreateAnomalyMonitorInput {
	s.AnomalyMonitor = v
	return s
}

type CreateAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of your newly created cost anomaly detection monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnomalyMonitorOutput) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *CreateAnomalyMonitorOutput) SetMonitorArn(v string) *CreateAnomalyMonitorOutput {
	s.MonitorArn = &v
	return s
}

type CreateAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The cost anomaly subscription object that you want to create.
	//
	// AnomalySubscription is a required field
	AnomalySubscription *AnomalySubscription `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnomalySubscriptionInput"}
	if s.AnomalySubscription == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalySubscription"))
	}
	if s.AnomalySubscription != nil {
		if err := s.AnomalySubscription.Validate(); err != nil {
			invalidParams.AddNested("AnomalySubscription", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalySubscription sets the AnomalySubscription field's value.
func (s *CreateAnomalySubscriptionInput) SetAnomalySubscription(v *AnomalySubscription) *CreateAnomalySubscriptionInput {
	s.AnomalySubscription = v
	return s
}

type CreateAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of your newly created cost anomaly subscription.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *CreateAnomalySubscriptionOutput) SetSubscriptionArn(v string) *CreateAnomalySubscriptionOutput {
	s.SubscriptionArn = &v
	return s
}

type CreateCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the Cost Category.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// The Cost Category rules used to categorize costs. For more information, see
	// CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCostCategoryDefinitionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateCostCategoryDefinitionInput) SetName(v string) *CreateCostCategoryDefinitionInput {
	s.Name = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *CreateCostCategoryDefinitionInput) SetRuleVersion(v string) *CreateCostCategoryDefinitionInput {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateCostCategoryDefinitionInput) SetRules(v []*CostCategoryRule) *CreateCostCategoryDefinitionInput {
	s.Rules = v
	return s
}

type CreateCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your newly created Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	EffectiveStart *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *CreateCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *CreateCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *CreateCostCategoryDefinitionOutput) SetEffectiveStart(v string) *CreateCostCategoryDefinitionOutput {
	s.EffectiveStart = &v
	return s
}

// Context about the current instance.
type CurrentInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// The name you've given an instance. This field will show as blank if you haven't
	// given the instance a name.
	InstanceName *string `type:"string"`

	// Current On-Demand cost of operating this instance on a monthly basis.
	MonthlyCost *string `type:"string"`

	// Number of hours during the lookback period billed at On-Demand rates.
	OnDemandHoursInLookbackPeriod *string `type:"string"`

	// Number of hours during the lookback period covered by reservations.
	ReservationCoveredHoursInLookbackPeriod *string `type:"string"`

	// Details about the resource and utilization.
	ResourceDetails *ResourceDetails `type:"structure"`

	// Resource ID of the current instance.
	ResourceId *string `type:"string"`

	// Utilization information of the current instance during the lookback period.
	ResourceUtilization *ResourceUtilization `type:"structure"`

	// Number of hours during the lookback period covered by Savings Plans.
	SavingsPlansCoveredHoursInLookbackPeriod *string `type:"string"`

	// Cost allocation resource tags applied to the instance.
	Tags []*TagValues `type:"list"`

	// The total number of hours the instance ran during the lookback period.
	TotalRunningHoursInLookbackPeriod *string `type:"string"`
}

// String returns the string representation
func (s CurrentInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *CurrentInstance) SetCurrencyCode(v string) *CurrentInstance {
	s.CurrencyCode = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CurrentInstance) SetInstanceName(v string) *CurrentInstance {
	s.InstanceName = &v
	return s
}

// SetMonthlyCost sets the MonthlyCost field's value.
func (s *CurrentInstance) SetMonthlyCost(v string) *CurrentInstance {
	s.MonthlyCost = &v
	return s
}

// SetOnDemandHoursInLookbackPeriod sets the OnDemandHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetOnDemandHoursInLookbackPeriod(v string) *CurrentInstance {
	s.OnDemandHoursInLookbackPeriod = &v
	return s
}

// SetReservationCoveredHoursInLookbackPeriod sets the ReservationCoveredHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetReservationCoveredHoursInLookbackPeriod(v string) *CurrentInstance {
	s.ReservationCoveredHoursInLookbackPeriod = &v
	return s
}

// SetResourceDetails sets the ResourceDetails field's value.
func (s *CurrentInstance) SetResourceDetails(v *ResourceDetails) *CurrentInstance {
	s.ResourceDetails = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CurrentInstance) SetResourceId(v string) *CurrentInstance {
	s.ResourceId = &v
	return s
}

// SetResourceUtilization sets the ResourceUtilization field's value.
func (s *CurrentInstance) SetResourceUtilization(v *ResourceUtilization) *CurrentInstance {
	s.ResourceUtilization = v
	return s
}

// SetSavingsPlansCoveredHoursInLookbackPeriod sets the SavingsPlansCoveredHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetSavingsPlansCoveredHoursInLookbackPeriod(v string) *CurrentInstance {
	s.SavingsPlansCoveredHoursInLookbackPeriod = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CurrentInstance) SetTags(v []*TagValues) *CurrentInstance {
	s.Tags = v
	return s
}

// SetTotalRunningHoursInLookbackPeriod sets the TotalRunningHoursInLookbackPeriod field's value.
func (s *CurrentInstance) SetTotalRunningHoursInLookbackPeriod(v string) *CurrentInstance {
	s.TotalRunningHoursInLookbackPeriod = &v
	return s
}

// The requested data is unavailable.
type DataUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DataUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataUnavailableException) GoString() string {
	return s.String()
}

func newErrorDataUnavailableException(v protocol.ResponseMetadata) error {
	return &DataUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataUnavailableException) Code() string {
	return "DataUnavailableException"
}

// Message returns the exception's message.
func (s *DataUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataUnavailableException) OrigErr() error {
	return nil
}

func (s *DataUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The time period that you want the usage and costs for.
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period that you want the usage and costs for. The end
	// date is exclusive. For example, if end is 2017-05-01, AWS retrieves cost
	// and usage data from the start date up to, but not including, 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period that you want the usage and costs for. The
	// start date is inclusive. For example, if start is 2017-01-01, AWS retrieves
	// cost and usage data starting at 2017-01-01 up to the end date.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateInterval"}
	if s.End == nil {
		invalidParams.Add(request.NewErrParamRequired("End"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *DateInterval) SetEnd(v string) *DateInterval {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateInterval) SetStart(v string) *DateInterval {
	s.Start = &v
	return s
}

type DeleteAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cost anomaly monitor that you want to delete.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalyMonitorInput"}
	if s.MonitorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *DeleteAnomalyMonitorInput) SetMonitorArn(v string) *DeleteAnomalyMonitorInput {
	s.MonitorArn = &v
	return s
}

type DeleteAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnomalyMonitorOutput) GoString() string {
	return s.String()
}

type DeleteAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cost anomaly subscription that you want to delete.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalySubscriptionInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *DeleteAnomalySubscriptionInput) SetSubscriptionArn(v string) *DeleteAnomalySubscriptionInput {
	s.SubscriptionArn = &v
	return s
}

type DeleteAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DeleteCostCategoryDefinitionInput) SetCostCategoryArn(v string) *DeleteCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

type DeleteCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The effective end date of the Cost Category as a result of deleting it. No
	// costs after this date will be categorized by the deleted Cost Category.
	EffectiveEnd *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DeleteCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DeleteCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *DeleteCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveEnd sets the EffectiveEnd field's value.
func (s *DeleteCostCategoryDefinitionOutput) SetEffectiveEnd(v string) *DeleteCostCategoryDefinitionOutput {
	s.EffectiveEnd = &v
	return s
}

type DescribeCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The date when the Cost Category was effective.
	EffectiveOn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}
	if s.EffectiveOn != nil && len(*s.EffectiveOn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveOn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *DescribeCostCategoryDefinitionInput) SetCostCategoryArn(v string) *DescribeCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *DescribeCostCategoryDefinitionInput) SetEffectiveOn(v string) *DescribeCostCategoryDefinitionInput {
	s.EffectiveOn = &v
	return s
}

type DescribeCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The structure of Cost Categories. This includes detailed metadata and the
	// set of rules for the CostCategory object.
	CostCategory *CostCategory `type:"structure"`
}

// String returns the string representation
func (s DescribeCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategory sets the CostCategory field's value.
func (s *DescribeCostCategoryDefinitionOutput) SetCostCategory(v *CostCategory) *DescribeCostCategoryDefinitionOutput {
	s.CostCategory = v
	return s
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	Key *string `type:"string" enum:"Dimension"`

	// The match options that you can use to filter your results. MatchOptions is
	// only applicable for actions related to Cost Category. The default values
	// for MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DimensionValues) SetKey(v string) *DimensionValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *DimensionValues) SetMatchOptions(v []*string) *DimensionValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *DimensionValues) SetValues(v []*string) *DimensionValues {
	s.Values = v
	return s
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValuesWithAttributes) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DimensionValuesWithAttributes) SetAttributes(v map[string]*string) *DimensionValuesWithAttributes {
	s.Attributes = v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionValuesWithAttributes) SetValue(v string) *DimensionValuesWithAttributes {
	s.Value = &v
	return s
}

// The EBS field that contains a list of EBS metrics associated with the current
// instance.
type EBSResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The maximum size of read operations per second
	EbsReadBytesPerSecond *string `type:"string"`

	// The maximum number of read operations per second.
	EbsReadOpsPerSecond *string `type:"string"`

	// The maximum size of write operations per second.
	EbsWriteBytesPerSecond *string `type:"string"`

	// The maximum number of write operations per second.
	EbsWriteOpsPerSecond *string `type:"string"`
}

// String returns the string representation
func (s EBSResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSResourceUtilization) GoString() string {
	return s.String()
}

// SetEbsReadBytesPerSecond sets the EbsReadBytesPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsReadBytesPerSecond(v string) *EBSResourceUtilization {
	s.EbsReadBytesPerSecond = &v
	return s
}

// SetEbsReadOpsPerSecond sets the EbsReadOpsPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsReadOpsPerSecond(v string) *EBSResourceUtilization {
	s.EbsReadOpsPerSecond = &v
	return s
}

// SetEbsWriteBytesPerSecond sets the EbsWriteBytesPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsWriteBytesPerSecond(v string) *EBSResourceUtilization {
	s.EbsWriteBytesPerSecond = &v
	return s
}

// SetEbsWriteOpsPerSecond sets the EbsWriteOpsPerSecond field's value.
func (s *EBSResourceUtilization) SetEbsWriteOpsPerSecond(v string) *EBSResourceUtilization {
	s.EbsWriteOpsPerSecond = &v
	return s
}

// Details about the Amazon EC2 instances that AWS recommends that you purchase.
type EC2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string `type:"string"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`

	// Whether the recommended reservation is dedicated or shared.
	Tenancy *string `type:"string"`
}

// String returns the string representation
func (s EC2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *EC2InstanceDetails) SetAvailabilityZone(v string) *EC2InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *EC2InstanceDetails) SetCurrentGeneration(v bool) *EC2InstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *EC2InstanceDetails) SetFamily(v string) *EC2InstanceDetails {
	s.Family = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EC2InstanceDetails) SetInstanceType(v string) *EC2InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EC2InstanceDetails) SetPlatform(v string) *EC2InstanceDetails {
	s.Platform = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EC2InstanceDetails) SetRegion(v string) *EC2InstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *EC2InstanceDetails) SetSizeFlexEligible(v bool) *EC2InstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *EC2InstanceDetails) SetTenancy(v string) *EC2InstanceDetails {
	s.Tenancy = &v
	return s
}

// Details on the Amazon EC2 Resource.
type EC2ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Hourly public On-Demand rate for the instance type.
	HourlyOnDemandRate *string `type:"string"`

	// The type of AWS instance.
	InstanceType *string `type:"string"`

	// Memory capacity of the AWS instance.
	Memory *string `type:"string"`

	// Network performance capacity of the AWS instance.
	NetworkPerformance *string `type:"string"`

	// The platform of the AWS instance. The platform is the specific combination
	// of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The AWS Region of the instance.
	Region *string `type:"string"`

	// The SKU of the product.
	Sku *string `type:"string"`

	// The disk storage of the AWS instance (not EBS storage).
	Storage *string `type:"string"`

	// Number of VCPU cores in the AWS instance type.
	Vcpu *string `type:"string"`
}

// String returns the string representation
func (s EC2ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2ResourceDetails) GoString() string {
	return s.String()
}

// SetHourlyOnDemandRate sets the HourlyOnDemandRate field's value.
func (s *EC2ResourceDetails) SetHourlyOnDemandRate(v string) *EC2ResourceDetails {
	s.HourlyOnDemandRate = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EC2ResourceDetails) SetInstanceType(v string) *EC2ResourceDetails {
	s.InstanceType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *EC2ResourceDetails) SetMemory(v string) *EC2ResourceDetails {
	s.Memory = &v
	return s
}

// SetNetworkPerformance sets the NetworkPerformance field's value.
func (s *EC2ResourceDetails) SetNetworkPerformance(v string) *EC2ResourceDetails {
	s.NetworkPerformance = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EC2ResourceDetails) SetPlatform(v string) *EC2ResourceDetails {
	s.Platform = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EC2ResourceDetails) SetRegion(v string) *EC2ResourceDetails {
	s.Region = &v
	return s
}

// SetSku sets the Sku field's value.
func (s *EC2ResourceDetails) SetSku(v string) *EC2ResourceDetails {
	s.Sku = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *EC2ResourceDetails) SetStorage(v string) *EC2ResourceDetails {
	s.Storage = &v
	return s
}

// SetVcpu sets the Vcpu field's value.
func (s *EC2ResourceDetails) SetVcpu(v string) *EC2ResourceDetails {
	s.Vcpu = &v
	return s
}

// Utilization metrics of the instance.
type EC2ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The EBS field that contains a list of EBS metrics associated with the current
	// instance.
	EBSResourceUtilization *EBSResourceUtilization `type:"structure"`

	// Maximum observed or expected CPU utilization of the instance.
	MaxCpuUtilizationPercentage *string `type:"string"`

	// Maximum observed or expected memory utilization of the instance.
	MaxMemoryUtilizationPercentage *string `type:"string"`

	// Maximum observed or expected storage utilization of the instance (does not
	// measure EBS storage).
	MaxStorageUtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s EC2ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2ResourceUtilization) GoString() string {
	return s.String()
}

// SetEBSResourceUtilization sets the EBSResourceUtilization field's value.
func (s *EC2ResourceUtilization) SetEBSResourceUtilization(v *EBSResourceUtilization) *EC2ResourceUtilization {
	s.EBSResourceUtilization = v
	return s
}

// SetMaxCpuUtilizationPercentage sets the MaxCpuUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxCpuUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxCpuUtilizationPercentage = &v
	return s
}

// SetMaxMemoryUtilizationPercentage sets the MaxMemoryUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxMemoryUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxMemoryUtilizationPercentage = &v
	return s
}

// SetMaxStorageUtilizationPercentage sets the MaxStorageUtilizationPercentage field's value.
func (s *EC2ResourceUtilization) SetMaxStorageUtilizationPercentage(v string) *EC2ResourceUtilization {
	s.MaxStorageUtilizationPercentage = &v
	return s
}

// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
// for.
type EC2Specification struct {
	_ struct{} `type:"structure"`

	// Whether you want a recommendation for standard or convertible reservations.
	OfferingClass *string `type:"string" enum:"OfferingClass"`
}

// String returns the string representation
func (s EC2Specification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2Specification) GoString() string {
	return s.String()
}

// SetOfferingClass sets the OfferingClass field's value.
func (s *EC2Specification) SetOfferingClass(v string) *EC2Specification {
	s.OfferingClass = &v
	return s
}

// Details about the Amazon ES instances that AWS recommends that you purchase.
type ESInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The class of instance that AWS recommends.
	InstanceClass *string `type:"string"`

	// The size of instance that AWS recommends.
	InstanceSize *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ESInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ESInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *ESInstanceDetails) SetCurrentGeneration(v bool) *ESInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetInstanceClass sets the InstanceClass field's value.
func (s *ESInstanceDetails) SetInstanceClass(v string) *ESInstanceDetails {
	s.InstanceClass = &v
	return s
}

// SetInstanceSize sets the InstanceSize field's value.
func (s *ESInstanceDetails) SetInstanceSize(v string) *ESInstanceDetails {
	s.InstanceSize = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ESInstanceDetails) SetRegion(v string) *ESInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *ESInstanceDetails) SetSizeFlexEligible(v bool) *ESInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Details about the Amazon ElastiCache instances that AWS recommends that you
// purchase.
type ElastiCacheInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The description of the recommended reservation.
	ProductDescription *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ElastiCacheInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElastiCacheInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *ElastiCacheInstanceDetails) SetCurrentGeneration(v bool) *ElastiCacheInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *ElastiCacheInstanceDetails) SetFamily(v string) *ElastiCacheInstanceDetails {
	s.Family = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ElastiCacheInstanceDetails) SetNodeType(v string) *ElastiCacheInstanceDetails {
	s.NodeType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ElastiCacheInstanceDetails) SetProductDescription(v string) *ElastiCacheInstanceDetails {
	s.ProductDescription = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ElastiCacheInstanceDetails) SetRegion(v string) *ElastiCacheInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *ElastiCacheInstanceDetails) SetSizeFlexEligible(v bool) *ElastiCacheInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
//    * Simple dimension values - You can set the dimension name and values
//    for the filters that you plan to use. For example, you can filter for
//    REGION==us-east-1 OR REGION==us-west-1. For GetRightsizingRecommendation,
//    the Region is a full name (for example, REGION==US East (N. Virginia).
//    The Expression example looks like: { "Dimensions": { "Key": "REGION",
//    "Values": [ "us-east-1", “us-west-1” ] } } The list of dimension values
//    are OR'd together to retrieve cost or usage data. You can create Expression
//    and DimensionValues objects using either with* methods or set* methods
//    in multiple lines.
//
//    * Compound dimension values with logical operations - You can use multiple
//    Expression types and the logical operators AND/OR/NOT to create a list
//    of one or more Expression objects. This allows you to filter on more advanced
//    options. For example, you can filter on ((REGION == us-east-1 OR REGION
//    == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
//    The Expression for that looks like this: { "And": [ {"Or": [ {"Dimensions":
//    { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags":
//    { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions":
//    { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } Because each
//    Expression can have only one operator, the service returns an error if
//    more than one is specified. The following example shows an Expression
//    object that creates an error. { "And": [ ... ], "DimensionValues": { "Dimension":
//    "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
//
// For GetRightsizingRecommendation action, a combination of OR and NOT is not
// supported. OR is not supported between different dimensions, or dimensions
// and tags. NOT operators aren't supported. Dimensions are also limited to
// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []*Expression `type:"list"`

	// The filter based on CostCategory values.
	CostCategories *CostCategoryValues `type:"structure"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match a Dimension object.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension object.
	Or []*Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Expression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Expression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Expression"}
	if s.CostCategories != nil {
		if err := s.CostCategories.Validate(); err != nil {
			invalidParams.AddNested("CostCategories", err.(request.ErrInvalidParams))
		}
	}
	if s.Not != nil {
		if err := s.Not.Validate(); err != nil {
			invalidParams.AddNested("Not", err.(request.ErrInvalidParams))
		}
	}
	if s.Or != nil {
		for i, v := range s.Or {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Or", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *Expression) SetAnd(v []*Expression) *Expression {
	s.And = v
	return s
}

// SetCostCategories sets the CostCategories field's value.
func (s *Expression) SetCostCategories(v *CostCategoryValues) *Expression {
	s.CostCategories = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *Expression) SetDimensions(v *DimensionValues) *Expression {
	s.Dimensions = v
	return s
}

// SetNot sets the Not field's value.
func (s *Expression) SetNot(v *Expression) *Expression {
	s.Not = v
	return s
}

// SetOr sets the Or field's value.
func (s *Expression) SetOr(v []*Expression) *Expression {
	s.Or = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Expression) SetTags(v *TagValues) *Expression {
	s.Tags = v
	return s
}

// The forecast created for your query.
type ForecastResult struct {
	_ struct{} `type:"structure"`

	// The mean value of the forecast.
	MeanValue *string `type:"string"`

	// The lower limit for the prediction interval.
	PredictionIntervalLowerBound *string `type:"string"`

	// The upper limit for the prediction interval.
	PredictionIntervalUpperBound *string `type:"string"`

	// The period of time that the forecast covers.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s ForecastResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForecastResult) GoString() string {
	return s.String()
}

// SetMeanValue sets the MeanValue field's value.
func (s *ForecastResult) SetMeanValue(v string) *ForecastResult {
	s.MeanValue = &v
	return s
}

// SetPredictionIntervalLowerBound sets the PredictionIntervalLowerBound field's value.
func (s *ForecastResult) SetPredictionIntervalLowerBound(v string) *ForecastResult {
	s.PredictionIntervalLowerBound = &v
	return s
}

// SetPredictionIntervalUpperBound sets the PredictionIntervalUpperBound field's value.
func (s *ForecastResult) SetPredictionIntervalUpperBound(v string) *ForecastResult {
	s.PredictionIntervalUpperBound = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ForecastResult) SetTimePeriod(v *DateInterval) *ForecastResult {
	s.TimePeriod = v
	return s
}

type GetAnomaliesInput struct {
	_ struct{} `type:"structure"`

	// Assigns the start and end dates for retrieving cost anomalies. The returned
	// anomaly object will have an AnomalyEndDate in the specified time range.
	//
	// DateInterval is a required field
	DateInterval *AnomalyDateInterval `type:"structure" required:"true"`

	// Filters anomaly results by the feedback field on the anomaly object.
	Feedback *string `type:"string" enum:"AnomalyFeedbackType"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// Retrieves all of the cost anomalies detected for a specific cost anomaly
	// monitor Amazon Resource Name (ARN).
	MonitorArn *string `type:"string"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Filters anomaly results by the total impact field on the anomaly object.
	// For example, you can filter anomalies GREATER_THAN 200.00 to retrieve anomalies,
	// with an estimated dollar impact greater than 200.
	TotalImpact *TotalImpactFilter `type:"structure"`
}

// String returns the string representation
func (s GetAnomaliesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomaliesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnomaliesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnomaliesInput"}
	if s.DateInterval == nil {
		invalidParams.Add(request.NewErrParamRequired("DateInterval"))
	}
	if s.DateInterval != nil {
		if err := s.DateInterval.Validate(); err != nil {
			invalidParams.AddNested("DateInterval", err.(request.ErrInvalidParams))
		}
	}
	if s.TotalImpact != nil {
		if err := s.TotalImpact.Validate(); err != nil {
			invalidParams.AddNested("TotalImpact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateInterval sets the DateInterval field's value.
func (s *GetAnomaliesInput) SetDateInterval(v *AnomalyDateInterval) *GetAnomaliesInput {
	s.DateInterval = v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *GetAnomaliesInput) SetFeedback(v string) *GetAnomaliesInput {
	s.Feedback = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomaliesInput) SetMaxResults(v int64) *GetAnomaliesInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetAnomaliesInput) SetMonitorArn(v string) *GetAnomaliesInput {
	s.MonitorArn = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomaliesInput) SetNextPageToken(v string) *GetAnomaliesInput {
	s.NextPageToken = &v
	return s
}

// SetTotalImpact sets the TotalImpact field's value.
func (s *GetAnomaliesInput) SetTotalImpact(v *TotalImpactFilter) *GetAnomaliesInput {
	s.TotalImpact = v
	return s
}

type GetAnomaliesOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomalies.
	//
	// Anomalies is a required field
	Anomalies []*Anomaly `type:"list" required:"true"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s GetAnomaliesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomaliesOutput) GoString() string {
	return s.String()
}

// SetAnomalies sets the Anomalies field's value.
func (s *GetAnomaliesOutput) SetAnomalies(v []*Anomaly) *GetAnomaliesOutput {
	s.Anomalies = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomaliesOutput) SetNextPageToken(v string) *GetAnomaliesOutput {
	s.NextPageToken = &v
	return s
}

type GetAnomalyMonitorsInput struct {
	_ struct{} `type:"structure"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []*string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s GetAnomalyMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomalyMonitorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomalyMonitorsInput) SetMaxResults(v int64) *GetAnomalyMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *GetAnomalyMonitorsInput) SetMonitorArnList(v []*string) *GetAnomalyMonitorsInput {
	s.MonitorArnList = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalyMonitorsInput) SetNextPageToken(v string) *GetAnomalyMonitorsInput {
	s.NextPageToken = &v
	return s
}

type GetAnomalyMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomaly monitors that includes the detailed metadata for each
	// monitor.
	//
	// AnomalyMonitors is a required field
	AnomalyMonitors []*AnomalyMonitor `type:"list" required:"true"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s GetAnomalyMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomalyMonitorsOutput) GoString() string {
	return s.String()
}

// SetAnomalyMonitors sets the AnomalyMonitors field's value.
func (s *GetAnomalyMonitorsOutput) SetAnomalyMonitors(v []*AnomalyMonitor) *GetAnomalyMonitorsOutput {
	s.AnomalyMonitors = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalyMonitorsOutput) SetNextPageToken(v string) *GetAnomalyMonitorsOutput {
	s.NextPageToken = &v
	return s
}

type GetAnomalySubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `type:"integer"`

	// Cost anomaly monitor ARNs.
	MonitorArn *string `type:"string"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// A list of cost anomaly subscription ARNs.
	SubscriptionArnList []*string `type:"list"`
}

// String returns the string representation
func (s GetAnomalySubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomalySubscriptionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAnomalySubscriptionsInput) SetMaxResults(v int64) *GetAnomalySubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetAnomalySubscriptionsInput) SetMonitorArn(v string) *GetAnomalySubscriptionsInput {
	s.MonitorArn = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalySubscriptionsInput) SetNextPageToken(v string) *GetAnomalySubscriptionsInput {
	s.NextPageToken = &v
	return s
}

// SetSubscriptionArnList sets the SubscriptionArnList field's value.
func (s *GetAnomalySubscriptionsInput) SetSubscriptionArnList(v []*string) *GetAnomalySubscriptionsInput {
	s.SubscriptionArnList = v
	return s
}

type GetAnomalySubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cost anomaly subscriptions that includes the detailed metadata
	// for each one.
	//
	// AnomalySubscriptions is a required field
	AnomalySubscriptions []*AnomalySubscription `type:"list" required:"true"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s GetAnomalySubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnomalySubscriptionsOutput) GoString() string {
	return s.String()
}

// SetAnomalySubscriptions sets the AnomalySubscriptions field's value.
func (s *GetAnomalySubscriptionsOutput) SetAnomalySubscriptions(v []*AnomalySubscription) *GetAnomalySubscriptionsOutput {
	s.AnomalySubscriptions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAnomalySubscriptionsOutput) SetNextPageToken(v string) *GetAnomalySubscriptionsOutput {
	s.NextPageToken = &v
	return s
}

type GetCostAndUsageInput struct {
	_ struct{} `type:"structure"`

	// Filters AWS costs by different dimensions. For example, you can specify SERVICE
	// and LINKED_ACCOUNT and get the costs that are associated with that account's
	// usage of that service. You can nest Expression objects to define any combination
	// of dimension filters. For more information, see Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY or DAILY, or HOURLY. If Granularity
	// isn't set, the response object doesn't include the Granularity, either MONTHLY
	// or DAILY, or HOURLY.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group AWS costs using up to two different groups, either dimensions,
	// tag keys, cost categories, or any two group by types.
	//
	// When you group by tag key, you get all tag values, including empty strings.
	//
	// Valid values are AZ, INSTANCE_TYPE, LEGAL_ENTITY_NAME, LINKED_ACCOUNT, OPERATION,
	// PLATFORM, PURCHASE_TYPE, SERVICE, TAGS, TENANCY, RECORD_TYPE, and USAGE_TYPE.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking into account the units. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hours vs. GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsage requests.
	//
	// Metrics is a required field
	Metrics []*string `type:"list" required:"true"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving AWS costs. The start date is
	// inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCostAndUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageInput"}
	if s.Metrics == nil {
		invalidParams.Add(request.NewErrParamRequired("Metrics"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageInput) SetFilter(v *Expression) *GetCostAndUsageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageInput) SetGranularity(v string) *GetCostAndUsageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageInput) SetMetrics(v []*string) *GetCostAndUsageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageInput) SetNextPageToken(v string) *GetCostAndUsageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageOutput struct {
	_ struct{} `type:"structure"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period that is covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageOutput) GoString() string {
	return s.String()
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageOutput) SetNextPageToken(v string) *GetCostAndUsageOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageOutput {
	s.ResultsByTime = v
	return s
}

type GetCostAndUsageWithResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters Amazon Web Services costs by different dimensions. For example, you
	// can specify SERVICE and LINKED_ACCOUNT and get the costs that are associated
	// with that account's usage of that service. You can nest Expression objects
	// to define any combination of dimension filters. For more information, see
	// Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	//
	// The GetCostAndUsageWithResources operation requires that you either group
	// by or filter by a ResourceId. It requires the Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// "SERVICE = Amazon Elastic Compute Cloud - Compute" in the filter.
	//
	// Filter is a required field
	Filter *Expression `type:"structure" required:"true"`

	// Sets the AWS cost granularity to MONTHLY, DAILY, or HOURLY. If Granularity
	// isn't set, the response object doesn't include the Granularity, MONTHLY,
	// DAILY, or HOURLY.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group Amazon Web Services costs using up to two different groups:
	// DIMENSION, TAG, COST_CATEGORY.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking the units into account. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hours vs. GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsageWithResources requests.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving Amazon Web Services costs. The
	// range must be within the last 14 days (the start date cannot be earlier than
	// 14 days ago). The start date is inclusive, but the end date is exclusive.
	// For example, if start is 2017-01-01 and end is 2017-05-01, then the cost
	// and usage data is retrieved from 2017-01-01 up to and including 2017-04-30
	// but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCostAndUsageWithResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageWithResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageWithResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageWithResourcesInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageWithResourcesInput) SetFilter(v *Expression) *GetCostAndUsageWithResourcesInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageWithResourcesInput) SetGranularity(v string) *GetCostAndUsageWithResourcesInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageWithResourcesInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageWithResourcesInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageWithResourcesInput) SetMetrics(v []*string) *GetCostAndUsageWithResourcesInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageWithResourcesInput) SetNextPageToken(v string) *GetCostAndUsageWithResourcesInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageWithResourcesInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageWithResourcesInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageWithResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period that is covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageWithResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageWithResourcesOutput) GoString() string {
	return s.String()
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageWithResourcesOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetNextPageToken(v string) *GetCostAndUsageWithResourcesOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageWithResourcesOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageWithResourcesOutput {
	s.ResultsByTime = v
	return s
}

type GetCostForecastInput struct {
	_ struct{} `type:"structure"`

	// The filters that you want to use to filter your forecast. Cost Explorer API
	// supports all of the Cost Explorer filters.
	Filter *Expression `type:"structure"`

	// How granular you want the forecast to be. You can get 3 months of DAILY forecasts
	// or 12 months of MONTHLY forecasts.
	//
	// The GetCostForecast operation supports only DAILY and MONTHLY granularities.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// Which metric Cost Explorer uses to create your forecast. For more information
	// about blended and unblended rates, see Why does the "blended" annotation
	// appear on some line items in my bill? (http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values for a GetCostForecast call are the following:
	//
	//    * AMORTIZED_COST
	//
	//    * BLENDED_COST
	//
	//    * NET_AMORTIZED_COST
	//
	//    * NET_UNBLENDED_COST
	//
	//    * UNBLENDED_COST
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true" enum:"Metric"`

	// Cost Explorer always returns the mean forecast as a single point. You can
	// request a prediction interval around the mean by specifying a confidence
	// level. The higher the confidence level, the more confident Cost Explorer
	// is about the actual value falling in the prediction interval. Higher confidence
	// levels result in wider prediction intervals.
	PredictionIntervalLevel *int64 `min:"51" type:"integer"`

	// The period of time that you want the forecast to cover. The start date must
	// be equal to or no later than the current date to avoid a validation error.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCostForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostForecastInput"}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.PredictionIntervalLevel != nil && *s.PredictionIntervalLevel < 51 {
		invalidParams.Add(request.NewErrParamMinValue("PredictionIntervalLevel", 51))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostForecastInput) SetFilter(v *Expression) *GetCostForecastInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostForecastInput) SetGranularity(v string) *GetCostForecastInput {
	s.Granularity = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *GetCostForecastInput) SetMetric(v string) *GetCostForecastInput {
	s.Metric = &v
	return s
}

// SetPredictionIntervalLevel sets the PredictionIntervalLevel field's value.
func (s *GetCostForecastInput) SetPredictionIntervalLevel(v int64) *GetCostForecastInput {
	s.PredictionIntervalLevel = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostForecastInput) SetTimePeriod(v *DateInterval) *GetCostForecastInput {
	s.TimePeriod = v
	return s
}

type GetCostForecastOutput struct {
	_ struct{} `type:"structure"`

	// The forecasts for your query, in order. For DAILY forecasts, this is a list
	// of days. For MONTHLY forecasts, this is a list of months.
	ForecastResultsByTime []*ForecastResult `type:"list"`

	// How much you are forecasted to spend over the forecast period, in USD.
	Total *MetricValue `type:"structure"`
}

// String returns the string representation
func (s GetCostForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostForecastOutput) GoString() string {
	return s.String()
}

// SetForecastResultsByTime sets the ForecastResultsByTime field's value.
func (s *GetCostForecastOutput) SetForecastResultsByTime(v []*ForecastResult) *GetCostForecastOutput {
	s.ForecastResultsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetCostForecastOutput) SetTotal(v *MetricValue) *GetCostForecastOutput {
	s.Total = v
	return s
}

type GetDimensionValuesInput struct {
	_ struct{} `type:"structure"`

	// The context for the call to GetDimensionValues. This can be RESERVATIONS
	// or COST_AND_USAGE. The default value is COST_AND_USAGE. If the context is
	// set to RESERVATIONS, the resulting dimension values can be used in the GetReservationUtilization
	// operation. If the context is set to COST_AND_USAGE, the resulting dimension
	// values can be used in the GetCostAndUsage operation.
	//
	// If you set the context to COST_AND_USAGE, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples
	//    are Aurora or MySQL.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS
	//    services, such as Amazon Web Services.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase to which this usage
	//    is related. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * SERVICE - The AWS service such as Amazon DynamoDB.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute.
	//    Examples include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    Amazon EC2: CloudWatch – Alarms. The response for this operation includes
	//    a unit attribute.
	//
	//    * REGION - The AWS Region.
	//
	//    * RECORD_TYPE - The different types of charges such as RI fees, usage
	//    costs, tax refunds, and credits.
	//
	//    * RESOURCE_ID - The unique identifier of the resource. ResourceId is an
	//    opt-in feature only available for last 14 days for EC2-Compute Service.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
	//    Windows or Linux.
	//
	//    * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
	//    deployments. Valid values are SingleAZ and MultiAZ.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * REGION - The AWS Region.
	//
	//    * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values
	//    are regional or a single Availability Zone.
	//
	//    * TAG (Coverage only) - The tags that are associated with a Reserved Instance
	//    (RI).
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	// If you set the context to SAVINGS_PLANS, you can use the following dimensions
	// for searching:
	//
	//    * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
	//
	//    * PAYMENT_OPTION - Payment option for the given Savings Plans (for example,
	//    All Upfront)
	//
	//    * REGION - The AWS Region.
	//
	//    * INSTANCE_TYPE_FAMILY - The family of instances (For example, m5)
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
	Context *string `type:"string" enum:"Context"`

	// The name of the dimension. Each Dimension is available for a different Context.
	// For more information, see Context.
	//
	// Dimension is a required field
	Dimension *string `type:"string" required:"true" enum:"Dimension"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search the filter values for.
	SearchString *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionValuesInput"}
	if s.Dimension == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimension"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContext sets the Context field's value.
func (s *GetDimensionValuesInput) SetContext(v string) *GetDimensionValuesInput {
	s.Context = &v
	return s
}

// SetDimension sets the Dimension field's value.
func (s *GetDimensionValuesInput) SetDimension(v string) *GetDimensionValuesInput {
	s.Dimension = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesInput) SetNextPageToken(v string) *GetDimensionValuesInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetDimensionValuesInput) SetSearchString(v string) *GetDimensionValuesInput {
	s.SearchString = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetDimensionValuesInput) SetTimePeriod(v *DateInterval) *GetDimensionValuesInput {
	s.TimePeriod = v
	return s
}

type GetDimensionValuesOutput struct {
	_ struct{} `type:"structure"`

	// The filters that you used to filter your request. Some dimensions are available
	// only for a specific context.
	//
	// If you set the context to COST_AND_USAGE, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples
	//    are Aurora or MySQL.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS
	//    services, such as Amazon Web Services.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
	//
	//    * OPERATION - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * PURCHASE_TYPE - The reservation type of the purchase to which this usage
	//    is related. Examples include On-Demand Instances and Standard Reserved
	//    Instances.
	//
	//    * SERVICE - The AWS service such as Amazon DynamoDB.
	//
	//    * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
	//    The response for the GetDimensionValues operation includes a unit attribute.
	//    Examples include GB and Hrs.
	//
	//    * USAGE_TYPE_GROUP - The grouping of common usage types. An example is
	//    Amazon EC2: CloudWatch – Alarms. The response for this operation includes
	//    a unit attribute.
	//
	//    * RECORD_TYPE - The different types of charges such as RI fees, usage
	//    costs, tax refunds, and credits.
	//
	//    * RESOURCE_ID - The unique identifier of the resource. ResourceId is an
	//    opt-in feature only available for last 14 days for EC2-Compute Service.
	//
	// If you set the context to RESERVATIONS, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
	//    Windows or Linux.
	//
	//    * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
	//    deployments. Valid values are SingleAZ and MultiAZ.
	//
	//    * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is m4.xlarge.
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * PLATFORM - The Amazon EC2 operating system. Examples are Windows or
	//    Linux.
	//
	//    * REGION - The AWS Region.
	//
	//    * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values
	//    are regional or a single Availability Zone.
	//
	//    * TAG (Coverage only) - The tags that are associated with a Reserved Instance
	//    (RI).
	//
	//    * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
	//
	// If you set the context to SAVINGS_PLANS, you can use the following dimensions
	// for searching:
	//
	//    * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
	//
	//    * PAYMENT_OPTION - Payment option for the given Savings Plans (for example,
	//    All Upfront)
	//
	//    * REGION - The AWS Region.
	//
	//    * INSTANCE_TYPE_FAMILY - The family of instances (For example, m5)
	//
	//    * LINKED_ACCOUNT - The description in the attribute map that includes
	//    the full name of the member account. The value field contains the AWS
	//    ID of the member account.
	//
	//    * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
	//
	// DimensionValues is a required field
	DimensionValues []*DimensionValuesWithAttributes `type:"list" required:"true"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of results that AWS returned at one time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The total number of search results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesOutput) GoString() string {
	return s.String()
}

// SetDimensionValues sets the DimensionValues field's value.
func (s *GetDimensionValuesOutput) SetDimensionValues(v []*DimensionValuesWithAttributes) *GetDimensionValuesOutput {
	s.DimensionValues = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesOutput) SetNextPageToken(v string) *GetDimensionValuesOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetDimensionValuesOutput) SetReturnSize(v int64) *GetDimensionValuesOutput {
	s.ReturnSize = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetDimensionValuesOutput) SetTotalSize(v int64) *GetDimensionValuesOutput {
	s.TotalSize = &v
	return s
}

// You can use the following request parameters to query for how much of your
// instance usage a reservation covered.
type GetReservationCoverageInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by dimensions. You can filter by the following dimensions:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DATABASE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * TAG
	//
	//    * TENANCY
	//
	// GetReservationCoverage uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	// You can nest only one level deep. If there are multiple values for a dimension,
	// they are OR'd together.
	//
	// If you don't provide a SERVICE filter, Cost Explorer defaults to EC2.
	//
	// Cost category is also supported.
	Filter *Expression `type:"structure"`

	// The granularity of the AWS cost data for the reservation. Valid values are
	// MONTHLY and DAILY.
	//
	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include Granularity, either MONTHLY or DAILY.
	//
	// The GetReservationCoverage operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group the data by the following attributes:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DATABASE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * TENANCY
	GroupBy []*GroupDefinition `type:"list"`

	// The measurement that you want your reservation coverage reported in.
	//
	// Valid values are Hour, Unit, and Cost. You can use multiple values in a request.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The start and end dates of the period that you want to retrieve data about
	// reservation coverage for. You can retrieve data for a maximum of 13 months:
	// the last 12 months and the current month. The start date is inclusive, but
	// the end date is exclusive. For example, if start is 2017-01-01 and end is
	// 2017-05-01, then the cost and usage data is retrieved from 2017-01-01 up
	// to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReservationCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationCoverageInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationCoverageInput) SetFilter(v *Expression) *GetReservationCoverageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationCoverageInput) SetGranularity(v string) *GetReservationCoverageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationCoverageInput) SetGroupBy(v []*GroupDefinition) *GetReservationCoverageInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetReservationCoverageInput) SetMetrics(v []*string) *GetReservationCoverageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageInput) SetNextPageToken(v string) *GetReservationCoverageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationCoverageInput) SetTimePeriod(v *DateInterval) *GetReservationCoverageInput {
	s.TimePeriod = v
	return s
}

type GetReservationCoverageOutput struct {
	_ struct{} `type:"structure"`

	// The amount of time that your reservations covered.
	//
	// CoveragesByTime is a required field
	CoveragesByTime []*CoverageByTime `type:"list" required:"true"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The total amount of instance usage that a reservation covered.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s GetReservationCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationCoverageOutput) GoString() string {
	return s.String()
}

// SetCoveragesByTime sets the CoveragesByTime field's value.
func (s *GetReservationCoverageOutput) SetCoveragesByTime(v []*CoverageByTime) *GetReservationCoverageOutput {
	s.CoveragesByTime = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationCoverageOutput) SetNextPageToken(v string) *GetReservationCoverageOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationCoverageOutput) SetTotal(v *Coverage) *GetReservationCoverageOutput {
	s.Total = v
	return s
}

type GetReservationPurchaseRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The account ID that is associated with the recommendation.
	AccountId *string `type:"string"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// The number of previous days that you want AWS to consider when it calculates
	// your recommendations.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The reservation purchase option that you want recommendations for.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// The specific service that you want recommendations for.
	//
	// Service is a required field
	Service *string `type:"string" required:"true"`

	// The hardware specifications for the service instances that you want recommendations
	// for, such as standard or convertible Amazon EC2 instances.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The reservation term that you want recommendations for.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation
func (s GetReservationPurchaseRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationPurchaseRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationPurchaseRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationPurchaseRecommendationInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountId(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountId = &v
	return s
}

// SetAccountScope sets the AccountScope field's value.
func (s *GetReservationPurchaseRecommendationInput) SetAccountScope(v string) *GetReservationPurchaseRecommendationInput {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *GetReservationPurchaseRecommendationInput) SetLookbackPeriodInDays(v string) *GetReservationPurchaseRecommendationInput {
	s.LookbackPeriodInDays = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationInput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPageSize(v int64) *GetReservationPurchaseRecommendationInput {
	s.PageSize = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *GetReservationPurchaseRecommendationInput) SetPaymentOption(v string) *GetReservationPurchaseRecommendationInput {
	s.PaymentOption = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetReservationPurchaseRecommendationInput) SetService(v string) *GetReservationPurchaseRecommendationInput {
	s.Service = &v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *GetReservationPurchaseRecommendationInput) SetServiceSpecification(v *ServiceSpecification) *GetReservationPurchaseRecommendationInput {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *GetReservationPurchaseRecommendationInput) SetTermInYears(v string) *GetReservationPurchaseRecommendationInput {
	s.TermInYears = &v
	return s
}

type GetReservationPurchaseRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Information about this specific recommendation call, such as the time stamp
	// for when Cost Explorer generated this recommendation.
	Metadata *ReservationPurchaseRecommendationMetadata `type:"structure"`

	// The pagination token for the next set of retrievable results.
	NextPageToken *string `type:"string"`

	// Recommendations for reservations to purchase.
	Recommendations []*ReservationPurchaseRecommendation `type:"list"`
}

// String returns the string representation
func (s GetReservationPurchaseRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationPurchaseRecommendationOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetMetadata(v *ReservationPurchaseRecommendationMetadata) *GetReservationPurchaseRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetNextPageToken(v string) *GetReservationPurchaseRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *GetReservationPurchaseRecommendationOutput) SetRecommendations(v []*ReservationPurchaseRecommendation) *GetReservationPurchaseRecommendationOutput {
	s.Recommendations = v
	return s
}

type GetReservationUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by dimensions. You can filter by the following dimensions:
	//
	//    * AZ
	//
	//    * CACHE_ENGINE
	//
	//    * DEPLOYMENT_OPTION
	//
	//    * INSTANCE_TYPE
	//
	//    * LINKED_ACCOUNT
	//
	//    * OPERATING_SYSTEM
	//
	//    * PLATFORM
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * SCOPE
	//
	//    * TENANCY
	//
	// GetReservationUtilization uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension,
	// and nesting is supported up to only one level deep. If there are multiple
	// values for a dimension, they are OR'd together.
	Filter *Expression `type:"structure"`

	// If GroupBy is set, Granularity can't be set. If Granularity isn't set, the
	// response object doesn't include Granularity, either MONTHLY or DAILY. If
	// both GroupBy and Granularity aren't set, GetReservationUtilization defaults
	// to DAILY.
	//
	// The GetReservationUtilization operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// Groups only by SUBSCRIPTION_ID. Metadata is included.
	GroupBy []*GroupDefinition `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving RI utilization. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationUtilizationInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationUtilizationInput) SetFilter(v *Expression) *GetReservationUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationUtilizationInput) SetGranularity(v string) *GetReservationUtilizationInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationUtilizationInput) SetGroupBy(v []*GroupDefinition) *GetReservationUtilizationInput {
	s.GroupBy = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationInput) SetNextPageToken(v string) *GetReservationUtilizationInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationUtilizationInput) SetTimePeriod(v *DateInterval) *GetReservationUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetReservationUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The total amount of time that you used your RIs.
	Total *ReservationAggregates `type:"structure"`

	// The amount of time that you used your RIs.
	//
	// UtilizationsByTime is a required field
	UtilizationsByTime []*UtilizationByTime `type:"list" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationOutput) SetNextPageToken(v string) *GetReservationUtilizationOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationUtilizationOutput) SetTotal(v *ReservationAggregates) *GetReservationUtilizationOutput {
	s.Total = v
	return s
}

// SetUtilizationsByTime sets the UtilizationsByTime field's value.
func (s *GetReservationUtilizationOutput) SetUtilizationsByTime(v []*UtilizationByTime) *GetReservationUtilizationOutput {
	s.UtilizationsByTime = v
	return s
}

type GetRightsizingRecommendationInput struct {
	_ struct{} `type:"structure"`

	// Enables you to customize recommendations across two attributes. You can choose
	// to view recommendations for instances within the same instance families or
	// across different instance families. You can also choose to view your estimated
	// savings associated with recommendations with consideration of existing Savings
	// Plans or RI benefits, or neither.
	Configuration *RightsizingRecommendationConfiguration `type:"structure"`

	// Use Expression to filter by cost or by usage. There are two patterns:
	//
	//    * Simple dimension values - You can set the dimension name and values
	//    for the filters that you plan to use. For example, you can filter for
	//    REGION==us-east-1 OR REGION==us-west-1. For GetRightsizingRecommendation,
	//    the Region is a full name (for example, REGION==US East (N. Virginia).
	//    The Expression example looks like: { "Dimensions": { "Key": "REGION",
	//    "Values": [ "us-east-1", “us-west-1” ] } } The list of dimension values
	//    are OR'd together to retrieve cost or usage data. You can create Expression
	//    and DimensionValues objects using either with* methods or set* methods
	//    in multiple lines.
	//
	//    * Compound dimension values with logical operations - You can use multiple
	//    Expression types and the logical operators AND/OR/NOT to create a list
	//    of one or more Expression objects. This allows you to filter on more advanced
	//    options. For example, you can filter on ((REGION == us-east-1 OR REGION
	//    == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
	//    The Expression for that looks like this: { "And": [ {"Or": [ {"Dimensions":
	//    { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags":
	//    { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions":
	//    { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } Because each
	//    Expression can have only one operator, the service returns an error if
	//    more than one is specified. The following example shows an Expression
	//    object that creates an error. { "And": [ ... ], "DimensionValues": { "Dimension":
	//    "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
	//
	// For GetRightsizingRecommendation action, a combination of OR and NOT is not
	// supported. OR is not supported between different dimensions, or dimensions
	// and tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
	Filter *Expression `type:"structure"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The specific service that you want recommendations for. The only valid value
	// for GetRightsizingRecommendation is "AmazonEC2".
	//
	// Service is a required field
	Service *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetRightsizingRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRightsizingRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRightsizingRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRightsizingRecommendationInput"}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *GetRightsizingRecommendationInput) SetConfiguration(v *RightsizingRecommendationConfiguration) *GetRightsizingRecommendationInput {
	s.Configuration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetRightsizingRecommendationInput) SetFilter(v *Expression) *GetRightsizingRecommendationInput {
	s.Filter = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRightsizingRecommendationInput) SetNextPageToken(v string) *GetRightsizingRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetRightsizingRecommendationInput) SetPageSize(v int64) *GetRightsizingRecommendationInput {
	s.PageSize = &v
	return s
}

// SetService sets the Service field's value.
func (s *GetRightsizingRecommendationInput) SetService(v string) *GetRightsizingRecommendationInput {
	s.Service = &v
	return s
}

type GetRightsizingRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Enables you to customize recommendations across two attributes. You can choose
	// to view recommendations for instances within the same instance families or
	// across different instance families. You can also choose to view your estimated
	// savings associated with recommendations with consideration of existing Savings
	// Plans or RI benefits, or neither.
	Configuration *RightsizingRecommendationConfiguration `type:"structure"`

	// Information regarding this specific recommendation set.
	Metadata *RightsizingRecommendationMetadata `type:"structure"`

	// The token to retrieve the next set of results.
	NextPageToken *string `type:"string"`

	// Recommendations to rightsize resources.
	RightsizingRecommendations []*RightsizingRecommendation `type:"list"`

	// Summary of this recommendation set.
	Summary *RightsizingRecommendationSummary `type:"structure"`
}

// String returns the string representation
func (s GetRightsizingRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRightsizingRecommendationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GetRightsizingRecommendationOutput) SetConfiguration(v *RightsizingRecommendationConfiguration) *GetRightsizingRecommendationOutput {
	s.Configuration = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetRightsizingRecommendationOutput) SetMetadata(v *RightsizingRecommendationMetadata) *GetRightsizingRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRightsizingRecommendationOutput) SetNextPageToken(v string) *GetRightsizingRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetRightsizingRecommendations sets the RightsizingRecommendations field's value.
func (s *GetRightsizingRecommendationOutput) SetRightsizingRecommendations(v []*RightsizingRecommendation) *GetRightsizingRecommendationOutput {
	s.RightsizingRecommendations = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *GetRightsizingRecommendationOutput) SetSummary(v *RightsizingRecommendationSummary) *GetRightsizingRecommendationOutput {
	s.Summary = v
	return s
}

type GetSavingsPlansCoverageInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans coverage data by dimensions. You can filter data for
	// Savings Plans usage with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * REGION
	//
	//    * SERVICE
	//
	//    * INSTANCE_FAMILY
	//
	// GetSavingsPlansCoverage uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	// If there are multiple values for a dimension, they are OR'd together.
	//
	// Cost category is also supported.
	Filter *Expression `type:"structure"`

	// The granularity of the Amazon Web Services cost data for your Savings Plans.
	// Granularity can't be set if GroupBy is set.
	//
	// The GetSavingsPlansCoverage operation supports only DAILY and MONTHLY granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group the data using the attributes INSTANCE_FAMILY, REGION, or SERVICE.
	GroupBy []*GroupDefinition `type:"list"`

	// The number of items to be returned in a response. The default is 20, with
	// a minimum value of 1.
	MaxResults *int64 `min:"1" type:"integer"`

	// The measurement that you want your Savings Plans coverage reported in. The
	// only valid value is SpendCoveredBySavingsPlans.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansCoverageInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansCoverageInput) SetFilter(v *Expression) *GetSavingsPlansCoverageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetSavingsPlansCoverageInput) SetGranularity(v string) *GetSavingsPlansCoverageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetSavingsPlansCoverageInput) SetGroupBy(v []*GroupDefinition) *GetSavingsPlansCoverageInput {
	s.GroupBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSavingsPlansCoverageInput) SetMaxResults(v int64) *GetSavingsPlansCoverageInput {
	s.MaxResults = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetSavingsPlansCoverageInput) SetMetrics(v []*string) *GetSavingsPlansCoverageInput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansCoverageInput) SetNextToken(v string) *GetSavingsPlansCoverageInput {
	s.NextToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansCoverageInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansCoverageInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansCoverageOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The amount of spend that your Savings Plans covered.
	//
	// SavingsPlansCoverages is a required field
	SavingsPlansCoverages []*SavingsPlansCoverage `type:"list" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansCoverageOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansCoverageOutput) SetNextToken(v string) *GetSavingsPlansCoverageOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlansCoverages sets the SavingsPlansCoverages field's value.
func (s *GetSavingsPlansCoverageOutput) SetSavingsPlansCoverages(v []*SavingsPlansCoverage) *GetSavingsPlansCoverageOutput {
	s.SavingsPlansCoverages = v
	return s
}

type GetSavingsPlansPurchaseRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// You can filter your recommendations by Account ID with the LINKED_ACCOUNT
	// dimension. To filter your recommendations by Account ID, specify Key as LINKED_ACCOUNT
	// and Value as the comma-separated Acount ID(s) for which you want to see Savings
	// Plans purchase recommendations.
	//
	// For GetSavingsPlansPurchaseRecommendation, the Filter does not include CostCategories
	// or Tags. It only includes Dimensions. With Dimensions, Key must be LINKED_ACCOUNT
	// and Value can be a single Account ID or multiple comma-separated Account
	// IDs for which you want to see Savings Plans Purchase Recommendations. AND
	// and OR operators are not supported.
	Filter *Expression `type:"structure"`

	// The lookback period used to generate the recommendation.
	//
	// LookbackPeriodInDays is a required field
	LookbackPeriodInDays *string `type:"string" required:"true" enum:"LookbackPeriodInDays"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextPageToken *string `type:"string"`

	// The number of recommendations that you want returned in a single response
	// object.
	PageSize *int64 `type:"integer"`

	// The payment option used to generate these recommendations.
	//
	// PaymentOption is a required field
	PaymentOption *string `type:"string" required:"true" enum:"PaymentOption"`

	// The Savings Plans recommendation type requested.
	//
	// SavingsPlansType is a required field
	SavingsPlansType *string `type:"string" required:"true" enum:"SupportedSavingsPlansType"`

	// The savings plan recommendation term used to generate these recommendations.
	//
	// TermInYears is a required field
	TermInYears *string `type:"string" required:"true" enum:"TermInYears"`
}

// String returns the string representation
func (s GetSavingsPlansPurchaseRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansPurchaseRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansPurchaseRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansPurchaseRecommendationInput"}
	if s.LookbackPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("LookbackPeriodInDays"))
	}
	if s.PaymentOption == nil {
		invalidParams.Add(request.NewErrParamRequired("PaymentOption"))
	}
	if s.SavingsPlansType == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlansType"))
	}
	if s.TermInYears == nil {
		invalidParams.Add(request.NewErrParamRequired("TermInYears"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountScope sets the AccountScope field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetAccountScope(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.AccountScope = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetFilter(v *Expression) *GetSavingsPlansPurchaseRecommendationInput {
	s.Filter = v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetLookbackPeriodInDays(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.LookbackPeriodInDays = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetNextPageToken(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.NextPageToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetPageSize(v int64) *GetSavingsPlansPurchaseRecommendationInput {
	s.PageSize = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetPaymentOption(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.PaymentOption = &v
	return s
}

// SetSavingsPlansType sets the SavingsPlansType field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetSavingsPlansType(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.SavingsPlansType = &v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *GetSavingsPlansPurchaseRecommendationInput) SetTermInYears(v string) *GetSavingsPlansPurchaseRecommendationInput {
	s.TermInYears = &v
	return s
}

type GetSavingsPlansPurchaseRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// Information regarding this specific recommendation set.
	Metadata *SavingsPlansPurchaseRecommendationMetadata `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// Contains your request parameters, Savings Plan Recommendations Summary, and
	// Details.
	SavingsPlansPurchaseRecommendation *SavingsPlansPurchaseRecommendation `type:"structure"`
}

// String returns the string representation
func (s GetSavingsPlansPurchaseRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansPurchaseRecommendationOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetMetadata(v *SavingsPlansPurchaseRecommendationMetadata) *GetSavingsPlansPurchaseRecommendationOutput {
	s.Metadata = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetNextPageToken(v string) *GetSavingsPlansPurchaseRecommendationOutput {
	s.NextPageToken = &v
	return s
}

// SetSavingsPlansPurchaseRecommendation sets the SavingsPlansPurchaseRecommendation field's value.
func (s *GetSavingsPlansPurchaseRecommendationOutput) SetSavingsPlansPurchaseRecommendation(v *SavingsPlansPurchaseRecommendation) *GetSavingsPlansPurchaseRecommendationOutput {
	s.SavingsPlansPurchaseRecommendation = v
	return s
}

type GetSavingsPlansUtilizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans utilization coverage data for active Savings Plans
	// dimensions. You can filter data with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * SAVINGS_PLAN_ARN
	//
	//    * REGION
	//
	//    * PAYMENT_OPTION
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	// GetSavingsPlansUtilizationDetails uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	Filter *Expression `type:"structure"`

	// The number of items to be returned in a response. The default is 20, with
	// a minimum value of 1.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansUtilizationDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansUtilizationDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansUtilizationDetailsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetFilter(v *Expression) *GetSavingsPlansUtilizationDetailsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetMaxResults(v int64) *GetSavingsPlansUtilizationDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetNextToken(v string) *GetSavingsPlansUtilizationDetailsInput {
	s.NextToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationDetailsInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationDetailsInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansUtilizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// Retrieves a single daily or monthly Savings Plans utilization rate and details
	// for your account.
	//
	// SavingsPlansUtilizationDetails is a required field
	SavingsPlansUtilizationDetails []*SavingsPlansUtilizationDetail `type:"list" required:"true"`

	// The time period that you want the usage and costs for.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// The total Savings Plans utilization, regardless of time period.
	Total *SavingsPlansUtilizationAggregates `type:"structure"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansUtilizationDetailsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetNextToken(v string) *GetSavingsPlansUtilizationDetailsOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlansUtilizationDetails sets the SavingsPlansUtilizationDetails field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetSavingsPlansUtilizationDetails(v []*SavingsPlansUtilizationDetail) *GetSavingsPlansUtilizationDetailsOutput {
	s.SavingsPlansUtilizationDetails = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationDetailsOutput {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetSavingsPlansUtilizationDetailsOutput) SetTotal(v *SavingsPlansUtilizationAggregates) *GetSavingsPlansUtilizationDetailsOutput {
	s.Total = v
	return s
}

type GetSavingsPlansUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans utilization coverage data for active Savings Plans
	// dimensions. You can filter data with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * SAVINGS_PLAN_ARN
	//
	//    * SAVINGS_PLANS_TYPE
	//
	//    * REGION
	//
	//    * PAYMENT_OPTION
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	// GetSavingsPlansUtilization uses the same Expression (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	Filter *Expression `type:"structure"`

	// The granularity of the Amazon Web Services utillization data for your Savings
	// Plans.
	//
	// The GetSavingsPlansUtilization operation supports only DAILY and MONTHLY
	// granularities.
	Granularity *string `type:"string" enum:"Granularity"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSavingsPlansUtilizationInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetSavingsPlansUtilizationInput) SetFilter(v *Expression) *GetSavingsPlansUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetSavingsPlansUtilizationInput) SetGranularity(v string) *GetSavingsPlansUtilizationInput {
	s.Granularity = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetSavingsPlansUtilizationInput) SetTimePeriod(v *DateInterval) *GetSavingsPlansUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetSavingsPlansUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The amount of cost/commitment you used your Savings Plans. This allows you
	// to specify date ranges.
	SavingsPlansUtilizationsByTime []*SavingsPlansUtilizationByTime `type:"list"`

	// The total amount of cost/commitment that you used your Savings Plans, regardless
	// of date ranges.
	//
	// Total is a required field
	Total *SavingsPlansUtilizationAggregates `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSavingsPlansUtilizationOutput) GoString() string {
	return s.String()
}

// SetSavingsPlansUtilizationsByTime sets the SavingsPlansUtilizationsByTime field's value.
func (s *GetSavingsPlansUtilizationOutput) SetSavingsPlansUtilizationsByTime(v []*SavingsPlansUtilizationByTime) *GetSavingsPlansUtilizationOutput {
	s.SavingsPlansUtilizationsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetSavingsPlansUtilizationOutput) SetTotal(v *SavingsPlansUtilizationAggregates) *GetSavingsPlansUtilizationOutput {
	s.Total = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search for.
	SearchString *string `type:"string"`

	// The key of the tag that you want to return values for.
	TagKey *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsInput) SetNextPageToken(v string) *GetTagsInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetTagsInput) SetSearchString(v string) *GetTagsInput {
	s.SearchString = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetTagsInput) SetTagKey(v string) *GetTagsInput {
	s.TagKey = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetTagsInput) SetTimePeriod(v *DateInterval) *GetTagsInput {
	s.TimePeriod = v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of query results that AWS returns at a time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The tags that match your request.
	//
	// Tags is a required field
	Tags []*string `type:"list" required:"true"`

	// The total number of query results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsOutput) SetNextPageToken(v string) *GetTagsOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetTagsOutput) SetReturnSize(v int64) *GetTagsOutput {
	s.ReturnSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v []*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetTagsOutput) SetTotalSize(v int64) *GetTagsOutput {
	s.TotalSize = &v
	return s
}

type GetUsageForecastInput struct {
	_ struct{} `type:"structure"`

	// The filters that you want to use to filter your forecast. Cost Explorer API
	// supports all of the Cost Explorer filters.
	Filter *Expression `type:"structure"`

	// How granular you want the forecast to be. You can get 3 months of DAILY forecasts
	// or 12 months of MONTHLY forecasts.
	//
	// The GetUsageForecast operation supports only DAILY and MONTHLY granularities.
	//
	// Granularity is a required field
	Granularity *string `type:"string" required:"true" enum:"Granularity"`

	// Which metric Cost Explorer uses to create your forecast.
	//
	// Valid values for a GetUsageForecast call are the following:
	//
	//    * USAGE_QUANTITY
	//
	//    * NORMALIZED_USAGE_AMOUNT
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true" enum:"Metric"`

	// Cost Explorer always returns the mean forecast as a single point. You can
	// request a prediction interval around the mean by specifying a confidence
	// level. The higher the confidence level, the more confident Cost Explorer
	// is about the actual value falling in the prediction interval. Higher confidence
	// levels result in wider prediction intervals.
	PredictionIntervalLevel *int64 `min:"51" type:"integer"`

	// The start and end dates of the period that you want to retrieve usage forecast
	// for. The start date is inclusive, but the end date is exclusive. For example,
	// if start is 2017-01-01 and end is 2017-05-01, then the cost and usage data
	// is retrieved from 2017-01-01 up to and including 2017-04-30 but not including
	// 2017-05-01. The start date must be equal to or later than the current date
	// to avoid a validation error.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUsageForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsageForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsageForecastInput"}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.PredictionIntervalLevel != nil && *s.PredictionIntervalLevel < 51 {
		invalidParams.Add(request.NewErrParamMinValue("PredictionIntervalLevel", 51))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetUsageForecastInput) SetFilter(v *Expression) *GetUsageForecastInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetUsageForecastInput) SetGranularity(v string) *GetUsageForecastInput {
	s.Granularity = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *GetUsageForecastInput) SetMetric(v string) *GetUsageForecastInput {
	s.Metric = &v
	return s
}

// SetPredictionIntervalLevel sets the PredictionIntervalLevel field's value.
func (s *GetUsageForecastInput) SetPredictionIntervalLevel(v int64) *GetUsageForecastInput {
	s.PredictionIntervalLevel = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetUsageForecastInput) SetTimePeriod(v *DateInterval) *GetUsageForecastInput {
	s.TimePeriod = v
	return s
}

type GetUsageForecastOutput struct {
	_ struct{} `type:"structure"`

	// The forecasts for your query, in order. For DAILY forecasts, this is a list
	// of days. For MONTHLY forecasts, this is a list of months.
	ForecastResultsByTime []*ForecastResult `type:"list"`

	// How much you're forecasted to use over the forecast period.
	Total *MetricValue `type:"structure"`
}

// String returns the string representation
func (s GetUsageForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageForecastOutput) GoString() string {
	return s.String()
}

// SetForecastResultsByTime sets the ForecastResultsByTime field's value.
func (s *GetUsageForecastOutput) SetForecastResultsByTime(v []*ForecastResult) *GetUsageForecastOutput {
	s.ForecastResultsByTime = v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetUsageForecastOutput) SetTotal(v *MetricValue) *GetUsageForecastOutput {
	s.Total = v
	return s
}

// One level of grouped data in the results.
type Group struct {
	_ struct{} `type:"structure"`

	// The keys that are included in this group.
	Keys []*string `type:"list"`

	// The metrics that are included in this group.
	Metrics map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *Group) SetKeys(v []*string) *Group {
	s.Keys = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Group) SetMetrics(v map[string]*MetricValue) *Group {
	s.Metrics = v
	return s
}

// Represents a group when you specify a group by criteria or in the response
// to a query with a specific grouping.
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type *string `type:"string" enum:"GroupDefinitionType"`
}

// String returns the string representation
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupDefinition) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *GroupDefinition) SetKey(v string) *GroupDefinition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *GroupDefinition) SetType(v string) *GroupDefinition {
	s.Type = &v
	return s
}

// The anomaly's dollar value.
type Impact struct {
	_ struct{} `type:"structure"`

	// The maximum dollar value observed for an anomaly.
	//
	// MaxImpact is a required field
	MaxImpact *float64 `type:"double" required:"true"`

	// The cumulative dollar value observed for an anomaly.
	TotalImpact *float64 `type:"double"`
}

// String returns the string representation
func (s Impact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Impact) GoString() string {
	return s.String()
}

// SetMaxImpact sets the MaxImpact field's value.
func (s *Impact) SetMaxImpact(v float64) *Impact {
	s.MaxImpact = &v
	return s
}

// SetTotalImpact sets the TotalImpact field's value.
func (s *Impact) SetTotalImpact(v float64) *Impact {
	s.TotalImpact = &v
	return s
}

// Details about the instances that AWS recommends that you purchase.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 instances that AWS recommends that you purchase.
	EC2InstanceDetails *EC2InstanceDetails `type:"structure"`

	// The Amazon ES instances that AWS recommends that you purchase.
	ESInstanceDetails *ESInstanceDetails `type:"structure"`

	// The ElastiCache instances that AWS recommends that you purchase.
	ElastiCacheInstanceDetails *ElastiCacheInstanceDetails `type:"structure"`

	// The Amazon RDS instances that AWS recommends that you purchase.
	RDSInstanceDetails *RDSInstanceDetails `type:"structure"`

	// The Amazon Redshift instances that AWS recommends that you purchase.
	RedshiftInstanceDetails *RedshiftInstanceDetails `type:"structure"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetEC2InstanceDetails sets the EC2InstanceDetails field's value.
func (s *InstanceDetails) SetEC2InstanceDetails(v *EC2InstanceDetails) *InstanceDetails {
	s.EC2InstanceDetails = v
	return s
}

// SetESInstanceDetails sets the ESInstanceDetails field's value.
func (s *InstanceDetails) SetESInstanceDetails(v *ESInstanceDetails) *InstanceDetails {
	s.ESInstanceDetails = v
	return s
}

// SetElastiCacheInstanceDetails sets the ElastiCacheInstanceDetails field's value.
func (s *InstanceDetails) SetElastiCacheInstanceDetails(v *ElastiCacheInstanceDetails) *InstanceDetails {
	s.ElastiCacheInstanceDetails = v
	return s
}

// SetRDSInstanceDetails sets the RDSInstanceDetails field's value.
func (s *InstanceDetails) SetRDSInstanceDetails(v *RDSInstanceDetails) *InstanceDetails {
	s.RDSInstanceDetails = v
	return s
}

// SetRedshiftInstanceDetails sets the RedshiftInstanceDetails field's value.
func (s *InstanceDetails) SetRedshiftInstanceDetails(v *RedshiftInstanceDetails) *InstanceDetails {
	s.RedshiftInstanceDetails = v
	return s
}

// The pagination token is invalid. Try again without a pagination token.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You made too many calls in a short period of time. Try again later.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCostCategoryDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The date when the Cost Category was effective.
	EffectiveOn *string `min:"20" type:"string"`

	// The number of entries a paginated response contains.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCostCategoryDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCostCategoryDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCostCategoryDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCostCategoryDefinitionsInput"}
	if s.EffectiveOn != nil && len(*s.EffectiveOn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveOn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *ListCostCategoryDefinitionsInput) SetEffectiveOn(v string) *ListCostCategoryDefinitionsInput {
	s.EffectiveOn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCostCategoryDefinitionsInput) SetMaxResults(v int64) *ListCostCategoryDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostCategoryDefinitionsInput) SetNextToken(v string) *ListCostCategoryDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListCostCategoryDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A reference to a Cost Category containing enough information to identify
	// the Cost Category.
	CostCategoryReferences []*CostCategoryReference `type:"list"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCostCategoryDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCostCategoryDefinitionsOutput) GoString() string {
	return s.String()
}

// SetCostCategoryReferences sets the CostCategoryReferences field's value.
func (s *ListCostCategoryDefinitionsOutput) SetCostCategoryReferences(v []*CostCategoryReference) *ListCostCategoryDefinitionsOutput {
	s.CostCategoryReferences = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCostCategoryDefinitionsOutput) SetNextToken(v string) *ListCostCategoryDefinitionsOutput {
	s.NextToken = &v
	return s
}

// The aggregated value for a metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricValue) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MetricValue) SetAmount(v string) *MetricValue {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricValue) SetUnit(v string) *MetricValue {
	s.Unit = &v
	return s
}

// Details on the modification recommendation.
type ModifyRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// Identifies whether this instance type is the AWS default recommendation.
	TargetInstances []*TargetInstance `type:"list"`
}

// String returns the string representation
func (s ModifyRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyRecommendationDetail) GoString() string {
	return s.String()
}

// SetTargetInstances sets the TargetInstances field's value.
func (s *ModifyRecommendationDetail) SetTargetInstances(v []*TargetInstance) *ModifyRecommendationDetail {
	s.TargetInstances = v
	return s
}

type ProvideAnomalyFeedbackInput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly ID.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`

	// Describes whether the cost anomaly was a planned activity or you considered
	// it an anomaly.
	//
	// Feedback is a required field
	Feedback *string `type:"string" required:"true" enum:"AnomalyFeedbackType"`
}

// String returns the string representation
func (s ProvideAnomalyFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvideAnomalyFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvideAnomalyFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvideAnomalyFeedbackInput"}
	if s.AnomalyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnomalyId"))
	}
	if s.Feedback == nil {
		invalidParams.Add(request.NewErrParamRequired("Feedback"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *ProvideAnomalyFeedbackInput) SetAnomalyId(v string) *ProvideAnomalyFeedbackInput {
	s.AnomalyId = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *ProvideAnomalyFeedbackInput) SetFeedback(v string) *ProvideAnomalyFeedbackInput {
	s.Feedback = &v
	return s
}

type ProvideAnomalyFeedbackOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the modified cost anomaly.
	//
	// AnomalyId is a required field
	AnomalyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProvideAnomalyFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvideAnomalyFeedbackOutput) GoString() string {
	return s.String()
}

// SetAnomalyId sets the AnomalyId field's value.
func (s *ProvideAnomalyFeedbackOutput) SetAnomalyId(v string) *ProvideAnomalyFeedbackOutput {
	s.AnomalyId = &v
	return s
}

// Details about the Amazon RDS instances that AWS recommends that you purchase.
type RDSInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string `type:"string"`

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string `type:"string"`

	// Whether the recommendation is for a reservation in a single Availability
	// Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string `type:"string"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The license model that the recommended reservation supports.
	LicenseModel *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RDSInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RDSInstanceDetails) SetCurrentGeneration(v bool) *RDSInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetDatabaseEdition sets the DatabaseEdition field's value.
func (s *RDSInstanceDetails) SetDatabaseEdition(v string) *RDSInstanceDetails {
	s.DatabaseEdition = &v
	return s
}

// SetDatabaseEngine sets the DatabaseEngine field's value.
func (s *RDSInstanceDetails) SetDatabaseEngine(v string) *RDSInstanceDetails {
	s.DatabaseEngine = &v
	return s
}

// SetDeploymentOption sets the DeploymentOption field's value.
func (s *RDSInstanceDetails) SetDeploymentOption(v string) *RDSInstanceDetails {
	s.DeploymentOption = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *RDSInstanceDetails) SetFamily(v string) *RDSInstanceDetails {
	s.Family = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RDSInstanceDetails) SetInstanceType(v string) *RDSInstanceDetails {
	s.InstanceType = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *RDSInstanceDetails) SetLicenseModel(v string) *RDSInstanceDetails {
	s.LicenseModel = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RDSInstanceDetails) SetRegion(v string) *RDSInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RDSInstanceDetails) SetSizeFlexEligible(v bool) *RDSInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Details about the Amazon Redshift instances that AWS recommends that you
// purchase.
type RedshiftInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RedshiftInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftInstanceDetails) GoString() string {
	return s.String()
}

// SetCurrentGeneration sets the CurrentGeneration field's value.
func (s *RedshiftInstanceDetails) SetCurrentGeneration(v bool) *RedshiftInstanceDetails {
	s.CurrentGeneration = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *RedshiftInstanceDetails) SetFamily(v string) *RedshiftInstanceDetails {
	s.Family = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *RedshiftInstanceDetails) SetNodeType(v string) *RedshiftInstanceDetails {
	s.NodeType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RedshiftInstanceDetails) SetRegion(v string) *RedshiftInstanceDetails {
	s.Region = &v
	return s
}

// SetSizeFlexEligible sets the SizeFlexEligible field's value.
func (s *RedshiftInstanceDetails) SetSizeFlexEligible(v bool) *RedshiftInstanceDetails {
	s.SizeFlexEligible = &v
	return s
}

// Your request parameters changed between pages. Try again with the old parameters
// or without a pagination token.
type RequestChangedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RequestChangedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestChangedException) GoString() string {
	return s.String()
}

func newErrorRequestChangedException(v protocol.ResponseMetadata) error {
	return &RequestChangedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestChangedException) Code() string {
	return "RequestChangedException"
}

// Message returns the exception's message.
func (s *RequestChangedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestChangedException) OrigErr() error {
	return nil
}

func (s *RequestChangedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestChangedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestChangedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The aggregated numbers for your reservation usage.
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// The monthly cost of your reservation, amortized over the reservation period.
	AmortizedRecurringFee *string `type:"string"`

	// The upfront cost of your reservation, amortized over the reservation period.
	AmortizedUpfrontFee *string `type:"string"`

	// How much you saved due to purchasing and utilizing reservation. AWS calculates
	// this by subtracting TotalAmortizedFee from OnDemandCostOfRIHoursUsed.
	NetRISavings *string `type:"string"`

	// How much your reservation would cost if charged On-Demand rates.
	OnDemandCostOfRIHoursUsed *string `type:"string"`

	// How many reservation hours that you purchased.
	PurchasedHours *string `type:"string"`

	// How many Amazon EC2 reservation hours that you purchased, converted to normalized
	// units. Normalized units are available only for Amazon EC2 usage after November
	// 11, 2017.
	PurchasedUnits *string `type:"string"`

	// The total number of reservation hours that you used.
	TotalActualHours *string `type:"string"`

	// The total number of Amazon EC2 reservation hours that you used, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	TotalActualUnits *string `type:"string"`

	// The total cost of your reservation, amortized over the reservation period.
	TotalAmortizedFee *string `type:"string"`

	// How much you could save if you use your entire reservation.
	TotalPotentialRISavings *string `type:"string"`

	// The number of reservation hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The number of Amazon EC2 reservation hours that you didn't use, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UnusedUnits *string `type:"string"`

	// The percentage of reservation time that you used.
	UtilizationPercentage *string `type:"string"`

	// The percentage of Amazon EC2 reservation time that you used, converted to
	// normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UtilizationPercentageInUnits *string `type:"string"`
}

// String returns the string representation
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationAggregates) GoString() string {
	return s.String()
}

// SetAmortizedRecurringFee sets the AmortizedRecurringFee field's value.
func (s *ReservationAggregates) SetAmortizedRecurringFee(v string) *ReservationAggregates {
	s.AmortizedRecurringFee = &v
	return s
}

// SetAmortizedUpfrontFee sets the AmortizedUpfrontFee field's value.
func (s *ReservationAggregates) SetAmortizedUpfrontFee(v string) *ReservationAggregates {
	s.AmortizedUpfrontFee = &v
	return s
}

// SetNetRISavings sets the NetRISavings field's value.
func (s *ReservationAggregates) SetNetRISavings(v string) *ReservationAggregates {
	s.NetRISavings = &v
	return s
}

// SetOnDemandCostOfRIHoursUsed sets the OnDemandCostOfRIHoursUsed field's value.
func (s *ReservationAggregates) SetOnDemandCostOfRIHoursUsed(v string) *ReservationAggregates {
	s.OnDemandCostOfRIHoursUsed = &v
	return s
}

// SetPurchasedHours sets the PurchasedHours field's value.
func (s *ReservationAggregates) SetPurchasedHours(v string) *ReservationAggregates {
	s.PurchasedHours = &v
	return s
}

// SetPurchasedUnits sets the PurchasedUnits field's value.
func (s *ReservationAggregates) SetPurchasedUnits(v string) *ReservationAggregates {
	s.PurchasedUnits = &v
	return s
}

// SetTotalActualHours sets the TotalActualHours field's value.
func (s *ReservationAggregates) SetTotalActualHours(v string) *ReservationAggregates {
	s.TotalActualHours = &v
	return s
}

// SetTotalActualUnits sets the TotalActualUnits field's value.
func (s *ReservationAggregates) SetTotalActualUnits(v string) *ReservationAggregates {
	s.TotalActualUnits = &v
	return s
}

// SetTotalAmortizedFee sets the TotalAmortizedFee field's value.
func (s *ReservationAggregates) SetTotalAmortizedFee(v string) *ReservationAggregates {
	s.TotalAmortizedFee = &v
	return s
}

// SetTotalPotentialRISavings sets the TotalPotentialRISavings field's value.
func (s *ReservationAggregates) SetTotalPotentialRISavings(v string) *ReservationAggregates {
	s.TotalPotentialRISavings = &v
	return s
}

// SetUnusedHours sets the UnusedHours field's value.
func (s *ReservationAggregates) SetUnusedHours(v string) *ReservationAggregates {
	s.UnusedHours = &v
	return s
}

// SetUnusedUnits sets the UnusedUnits field's value.
func (s *ReservationAggregates) SetUnusedUnits(v string) *ReservationAggregates {
	s.UnusedUnits = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *ReservationAggregates) SetUtilizationPercentage(v string) *ReservationAggregates {
	s.UtilizationPercentage = &v
	return s
}

// SetUtilizationPercentageInUnits sets the UtilizationPercentageInUnits field's value.
func (s *ReservationAggregates) SetUtilizationPercentageInUnits(v string) *ReservationAggregates {
	s.UtilizationPercentageInUnits = &v
	return s
}

// A group of reservations that share a set of attributes.
type ReservationCoverageGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]*string `type:"map"`

	// How much instance usage this group of reservations covered.
	Coverage *Coverage `type:"structure"`
}

// String returns the string representation
func (s ReservationCoverageGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationCoverageGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationCoverageGroup) SetAttributes(v map[string]*string) *ReservationCoverageGroup {
	s.Attributes = v
	return s
}

// SetCoverage sets the Coverage field's value.
func (s *ReservationCoverageGroup) SetCoverage(v *Coverage) *ReservationCoverageGroup {
	s.Coverage = v
	return s
}

// A specific reservation that AWS recommends for purchase.
type ReservationPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that AWS recommends that you purchase this instance for.
	// For example, you can purchase this reservation for an entire organization
	// in AWS Organizations.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// How many days of previous usage that AWS considers when making this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The payment option for the reservation. For example, AllUpfront or NoUpfront.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// Details about the recommended purchases.
	RecommendationDetails []*ReservationPurchaseRecommendationDetail `type:"list"`

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary `type:"structure"`

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The term of the reservation that you want recommendations for, in years.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendation) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *ReservationPurchaseRecommendation) SetAccountScope(v string) *ReservationPurchaseRecommendation {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *ReservationPurchaseRecommendation) SetLookbackPeriodInDays(v string) *ReservationPurchaseRecommendation {
	s.LookbackPeriodInDays = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservationPurchaseRecommendation) SetPaymentOption(v string) *ReservationPurchaseRecommendation {
	s.PaymentOption = &v
	return s
}

// SetRecommendationDetails sets the RecommendationDetails field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationDetails(v []*ReservationPurchaseRecommendationDetail) *ReservationPurchaseRecommendation {
	s.RecommendationDetails = v
	return s
}

// SetRecommendationSummary sets the RecommendationSummary field's value.
func (s *ReservationPurchaseRecommendation) SetRecommendationSummary(v *ReservationPurchaseRecommendationSummary) *ReservationPurchaseRecommendation {
	s.RecommendationSummary = v
	return s
}

// SetServiceSpecification sets the ServiceSpecification field's value.
func (s *ReservationPurchaseRecommendation) SetServiceSpecification(v *ServiceSpecification) *ReservationPurchaseRecommendation {
	s.ServiceSpecification = v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *ReservationPurchaseRecommendation) SetTermInYears(v string) *ReservationPurchaseRecommendation {
	s.TermInYears = &v
	return s
}

// Details about your recommended reservation purchase.
type ReservationPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The account that this RI recommendation is for.
	AccountId *string `type:"string"`

	// The average number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	AverageNormalizedUnitsUsedPerHour *string `type:"string"`

	// The average number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	AverageNumberOfInstancesUsedPerHour *string `type:"string"`

	// The average utilization of your instances. AWS uses this to calculate your
	// recommended reservation purchases.
	AverageUtilization *string `type:"string"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// How long AWS estimates that it takes for this instance to start saving you
	// money, in months.
	EstimatedBreakEvenInMonths *string `type:"string"`

	// How much AWS estimates that you spend on On-Demand Instances in a month.
	EstimatedMonthlyOnDemandCost *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string `type:"string"`

	// How much AWS estimates that you would have spent for all usage during the
	// specified historical period if you had a reservation.
	EstimatedReservationCostForLookbackPeriod *string `type:"string"`

	// Details about the instances that AWS recommends that you purchase.
	InstanceDetails *InstanceDetails `type:"structure"`

	// The maximum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MaximumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The maximum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MaximumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The minimum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MinimumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The minimum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MinimumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The number of normalized units that AWS recommends that you purchase.
	RecommendedNormalizedUnitsToPurchase *string `type:"string"`

	// The number of instances that AWS recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string `type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string `type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAccountId(v string) *ReservationPurchaseRecommendationDetail {
	s.AccountId = &v
	return s
}

// SetAverageNormalizedUnitsUsedPerHour sets the AverageNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNormalizedUnitsUsedPerHour = &v
	return s
}

// SetAverageNumberOfInstancesUsedPerHour sets the AverageNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageNumberOfInstancesUsedPerHour = &v
	return s
}

// SetAverageUtilization sets the AverageUtilization field's value.
func (s *ReservationPurchaseRecommendationDetail) SetAverageUtilization(v string) *ReservationPurchaseRecommendationDetail {
	s.AverageUtilization = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationDetail) SetCurrencyCode(v string) *ReservationPurchaseRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedBreakEvenInMonths sets the EstimatedBreakEvenInMonths field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedBreakEvenInMonths(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedBreakEvenInMonths = &v
	return s
}

// SetEstimatedMonthlyOnDemandCost sets the EstimatedMonthlyOnDemandCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlyOnDemandCost(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlyOnDemandCost = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedMonthlySavingsPercentage sets the EstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsPercentage = &v
	return s
}

// SetEstimatedReservationCostForLookbackPeriod sets the EstimatedReservationCostForLookbackPeriod field's value.
func (s *ReservationPurchaseRecommendationDetail) SetEstimatedReservationCostForLookbackPeriod(v string) *ReservationPurchaseRecommendationDetail {
	s.EstimatedReservationCostForLookbackPeriod = &v
	return s
}

// SetInstanceDetails sets the InstanceDetails field's value.
func (s *ReservationPurchaseRecommendationDetail) SetInstanceDetails(v *InstanceDetails) *ReservationPurchaseRecommendationDetail {
	s.InstanceDetails = v
	return s
}

// SetMaximumNormalizedUnitsUsedPerHour sets the MaximumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMaximumNumberOfInstancesUsedPerHour sets the MaximumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMaximumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MaximumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetMinimumNormalizedUnitsUsedPerHour sets the MinimumNormalizedUnitsUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNormalizedUnitsUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNormalizedUnitsUsedPerHour = &v
	return s
}

// SetMinimumNumberOfInstancesUsedPerHour sets the MinimumNumberOfInstancesUsedPerHour field's value.
func (s *ReservationPurchaseRecommendationDetail) SetMinimumNumberOfInstancesUsedPerHour(v string) *ReservationPurchaseRecommendationDetail {
	s.MinimumNumberOfInstancesUsedPerHour = &v
	return s
}

// SetRecommendedNormalizedUnitsToPurchase sets the RecommendedNormalizedUnitsToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNormalizedUnitsToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNormalizedUnitsToPurchase = &v
	return s
}

// SetRecommendedNumberOfInstancesToPurchase sets the RecommendedNumberOfInstancesToPurchase field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecommendedNumberOfInstancesToPurchase(v string) *ReservationPurchaseRecommendationDetail {
	s.RecommendedNumberOfInstancesToPurchase = &v
	return s
}

// SetRecurringStandardMonthlyCost sets the RecurringStandardMonthlyCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetRecurringStandardMonthlyCost(v string) *ReservationPurchaseRecommendationDetail {
	s.RecurringStandardMonthlyCost = &v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *ReservationPurchaseRecommendationDetail) SetUpfrontCost(v string) *ReservationPurchaseRecommendationDetail {
	s.UpfrontCost = &v
	return s
}

// Information about this specific recommendation, such as the timestamp for
// when AWS made a specific recommendation.
type ReservationPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The timestamp for when AWS made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationMetadata) GoString() string {
	return s.String()
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetGenerationTimestamp(v string) *ReservationPurchaseRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *ReservationPurchaseRecommendationMetadata) SetRecommendationId(v string) *ReservationPurchaseRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// A summary about this recommendation, such as the currency code, the amount
// that AWS estimates that you could save, and the total amount of reservation
// to purchase.
type ReservationPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code used for this recommendation.
	CurrencyCode *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month.
	TotalEstimatedMonthlySavingsAmount *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationPurchaseRecommendationSummary) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservationPurchaseRecommendationSummary) SetCurrencyCode(v string) *ReservationPurchaseRecommendationSummary {
	s.CurrencyCode = &v
	return s
}

// SetTotalEstimatedMonthlySavingsAmount sets the TotalEstimatedMonthlySavingsAmount field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsAmount(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsAmount = &v
	return s
}

// SetTotalEstimatedMonthlySavingsPercentage sets the TotalEstimatedMonthlySavingsPercentage field's value.
func (s *ReservationPurchaseRecommendationSummary) SetTotalEstimatedMonthlySavingsPercentage(v string) *ReservationPurchaseRecommendationSummary {
	s.TotalEstimatedMonthlySavingsPercentage = &v
	return s
}

// A group of reservations that share a set of attributes.
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]*string `type:"map"`

	// The key for a specific reservation attribute.
	Key *string `type:"string"`

	// How much you used this group of reservations.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific reservation attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationUtilizationGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationUtilizationGroup) SetAttributes(v map[string]*string) *ReservationUtilizationGroup {
	s.Attributes = v
	return s
}

// SetKey sets the Key field's value.
func (s *ReservationUtilizationGroup) SetKey(v string) *ReservationUtilizationGroup {
	s.Key = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *ReservationUtilizationGroup) SetUtilization(v *ReservationAggregates) *ReservationUtilizationGroup {
	s.Utilization = v
	return s
}

// SetValue sets the Value field's value.
func (s *ReservationUtilizationGroup) SetValue(v string) *ReservationUtilizationGroup {
	s.Value = &v
	return s
}

// Details on the resource.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Details on the Amazon EC2 resource.
	EC2ResourceDetails *EC2ResourceDetails `type:"structure"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetEC2ResourceDetails sets the EC2ResourceDetails field's value.
func (s *ResourceDetails) SetEC2ResourceDetails(v *EC2ResourceDetails) *ResourceDetails {
	s.EC2ResourceDetails = v
	return s
}

// The specified ARN in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Resource utilization of current resource.
type ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// Utilization of current Amazon EC2 instance.
	EC2ResourceUtilization *EC2ResourceUtilization `type:"structure"`
}

// String returns the string representation
func (s ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUtilization) GoString() string {
	return s.String()
}

// SetEC2ResourceUtilization sets the EC2ResourceUtilization field's value.
func (s *ResourceUtilization) SetEC2ResourceUtilization(v *EC2ResourceUtilization) *ResourceUtilization {
	s.EC2ResourceUtilization = v
	return s
}

// The result that is associated with a time period.
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Whether the result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that this time period includes.
	Groups []*Group `type:"list"`

	// The time period that the result covers.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultByTime) GoString() string {
	return s.String()
}

// SetEstimated sets the Estimated field's value.
func (s *ResultByTime) SetEstimated(v bool) *ResultByTime {
	s.Estimated = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ResultByTime) SetGroups(v []*Group) *ResultByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ResultByTime) SetTimePeriod(v *DateInterval) *ResultByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ResultByTime) SetTotal(v map[string]*MetricValue) *ResultByTime {
	s.Total = v
	return s
}

// Recommendations to rightsize resources.
type RightsizingRecommendation struct {
	_ struct{} `type:"structure"`

	// The account that this recommendation is for.
	AccountId *string `type:"string"`

	// Context regarding the current instance.
	CurrentInstance *CurrentInstance `type:"structure"`

	// Details for modification recommendations.
	ModifyRecommendationDetail *ModifyRecommendationDetail `type:"structure"`

	// Recommendation to either terminate or modify the resource.
	RightsizingType *string `type:"string" enum:"RightsizingType"`

	// Details for termination recommendations.
	TerminateRecommendationDetail *TerminateRecommendationDetail `type:"structure"`
}

// String returns the string representation
func (s RightsizingRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RightsizingRecommendation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RightsizingRecommendation) SetAccountId(v string) *RightsizingRecommendation {
	s.AccountId = &v
	return s
}

// SetCurrentInstance sets the CurrentInstance field's value.
func (s *RightsizingRecommendation) SetCurrentInstance(v *CurrentInstance) *RightsizingRecommendation {
	s.CurrentInstance = v
	return s
}

// SetModifyRecommendationDetail sets the ModifyRecommendationDetail field's value.
func (s *RightsizingRecommendation) SetModifyRecommendationDetail(v *ModifyRecommendationDetail) *RightsizingRecommendation {
	s.ModifyRecommendationDetail = v
	return s
}

// SetRightsizingType sets the RightsizingType field's value.
func (s *RightsizingRecommendation) SetRightsizingType(v string) *RightsizingRecommendation {
	s.RightsizingType = &v
	return s
}

// SetTerminateRecommendationDetail sets the TerminateRecommendationDetail field's value.
func (s *RightsizingRecommendation) SetTerminateRecommendationDetail(v *TerminateRecommendationDetail) *RightsizingRecommendation {
	s.TerminateRecommendationDetail = v
	return s
}

// Enables you to customize recommendations across two attributes. You can choose
// to view recommendations for instances within the same instance families or
// across different instance families. You can also choose to view your estimated
// savings associated with recommendations with consideration of existing Savings
// Plans or RI benefits, or neither.
type RightsizingRecommendationConfiguration struct {
	_ struct{} `type:"structure"`

	// The option to consider RI or Savings Plans discount benefits in your savings
	// calculation. The default value is TRUE.
	//
	// BenefitsConsidered is a required field
	BenefitsConsidered *bool `type:"boolean" required:"true"`

	// The option to see recommendations within the same instance family, or recommendations
	// for instances across other families. The default value is SAME_INSTANCE_FAMILY.
	//
	// RecommendationTarget is a required field
	RecommendationTarget *string `type:"string" required:"true" enum:"RecommendationTarget"`
}

// String returns the string representation
func (s RightsizingRecommendationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RightsizingRecommendationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RightsizingRecommendationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RightsizingRecommendationConfiguration"}
	if s.BenefitsConsidered == nil {
		invalidParams.Add(request.NewErrParamRequired("BenefitsConsidered"))
	}
	if s.RecommendationTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationTarget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBenefitsConsidered sets the BenefitsConsidered field's value.
func (s *RightsizingRecommendationConfiguration) SetBenefitsConsidered(v bool) *RightsizingRecommendationConfiguration {
	s.BenefitsConsidered = &v
	return s
}

// SetRecommendationTarget sets the RecommendationTarget field's value.
func (s *RightsizingRecommendationConfiguration) SetRecommendationTarget(v string) *RightsizingRecommendationConfiguration {
	s.RecommendationTarget = &v
	return s
}

// Metadata for this recommendation set.
type RightsizingRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// Additional metadata that may be applicable to the recommendation.
	AdditionalMetadata *string `type:"string"`

	// The timestamp for when AWS made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// How many days of previous usage that AWS considers when making this recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s RightsizingRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RightsizingRecommendationMetadata) GoString() string {
	return s.String()
}

// SetAdditionalMetadata sets the AdditionalMetadata field's value.
func (s *RightsizingRecommendationMetadata) SetAdditionalMetadata(v string) *RightsizingRecommendationMetadata {
	s.AdditionalMetadata = &v
	return s
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *RightsizingRecommendationMetadata) SetGenerationTimestamp(v string) *RightsizingRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *RightsizingRecommendationMetadata) SetLookbackPeriodInDays(v string) *RightsizingRecommendationMetadata {
	s.LookbackPeriodInDays = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RightsizingRecommendationMetadata) SetRecommendationId(v string) *RightsizingRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// Summary of rightsizing recommendations
type RightsizingRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// Estimated total savings resulting from modifications, on a monthly basis.
	EstimatedTotalMonthlySavingsAmount *string `type:"string"`

	// The currency code that AWS used to calculate the savings.
	SavingsCurrencyCode *string `type:"string"`

	// Savings percentage based on the recommended modifications, relative to the
	// total On-Demand costs associated with these instances.
	SavingsPercentage *string `type:"string"`

	// Total number of instance recommendations.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation
func (s RightsizingRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RightsizingRecommendationSummary) GoString() string {
	return s.String()
}

// SetEstimatedTotalMonthlySavingsAmount sets the EstimatedTotalMonthlySavingsAmount field's value.
func (s *RightsizingRecommendationSummary) SetEstimatedTotalMonthlySavingsAmount(v string) *RightsizingRecommendationSummary {
	s.EstimatedTotalMonthlySavingsAmount = &v
	return s
}

// SetSavingsCurrencyCode sets the SavingsCurrencyCode field's value.
func (s *RightsizingRecommendationSummary) SetSavingsCurrencyCode(v string) *RightsizingRecommendationSummary {
	s.SavingsCurrencyCode = &v
	return s
}

// SetSavingsPercentage sets the SavingsPercentage field's value.
func (s *RightsizingRecommendationSummary) SetSavingsPercentage(v string) *RightsizingRecommendationSummary {
	s.SavingsPercentage = &v
	return s
}

// SetTotalRecommendationCount sets the TotalRecommendationCount field's value.
func (s *RightsizingRecommendationSummary) SetTotalRecommendationCount(v string) *RightsizingRecommendationSummary {
	s.TotalRecommendationCount = &v
	return s
}

// The combination of AWS service, linked account, Region, and usage type where
// a cost anomaly is observed.
type RootCause struct {
	_ struct{} `type:"structure"`

	// The linked account value associated with the cost anomaly.
	LinkedAccount *string `type:"string"`

	// The AWS Region associated with the cost anomaly.
	Region *string `type:"string"`

	// The AWS service name associated with the cost anomaly.
	Service *string `type:"string"`

	// The UsageType value associated with the cost anomaly.
	UsageType *string `type:"string"`
}

// String returns the string representation
func (s RootCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RootCause) GoString() string {
	return s.String()
}

// SetLinkedAccount sets the LinkedAccount field's value.
func (s *RootCause) SetLinkedAccount(v string) *RootCause {
	s.LinkedAccount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RootCause) SetRegion(v string) *RootCause {
	s.Region = &v
	return s
}

// SetService sets the Service field's value.
func (s *RootCause) SetService(v string) *RootCause {
	s.Service = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *RootCause) SetUsageType(v string) *RootCause {
	s.UsageType = &v
	return s
}

// The amortized amount of Savings Plans purchased in a specific account during
// a specific time interval.
type SavingsPlansAmortizedCommitment struct {
	_ struct{} `type:"structure"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with either a Partial or a NoUpfront.
	AmortizedRecurringCommitment *string `type:"string"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with an Upfront or PartialUpfront Savings Plans.
	AmortizedUpfrontCommitment *string `type:"string"`

	// The total amortized amount of your Savings Plans commitment, regardless of
	// your Savings Plans purchase method.
	TotalAmortizedCommitment *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansAmortizedCommitment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansAmortizedCommitment) GoString() string {
	return s.String()
}

// SetAmortizedRecurringCommitment sets the AmortizedRecurringCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetAmortizedRecurringCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.AmortizedRecurringCommitment = &v
	return s
}

// SetAmortizedUpfrontCommitment sets the AmortizedUpfrontCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetAmortizedUpfrontCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.AmortizedUpfrontCommitment = &v
	return s
}

// SetTotalAmortizedCommitment sets the TotalAmortizedCommitment field's value.
func (s *SavingsPlansAmortizedCommitment) SetTotalAmortizedCommitment(v string) *SavingsPlansAmortizedCommitment {
	s.TotalAmortizedCommitment = &v
	return s
}

// The amount of Savings Plans eligible usage that is covered by Savings Plans.
// All calculations consider the On-Demand equivalent of your Savings Plans
// usage.
type SavingsPlansCoverage struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The amount of Savings Plans eligible usage that the Savings Plans covered.
	Coverage *SavingsPlansCoverageData `type:"structure"`

	// The time period that you want the usage and costs for.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s SavingsPlansCoverage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansCoverage) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SavingsPlansCoverage) SetAttributes(v map[string]*string) *SavingsPlansCoverage {
	s.Attributes = v
	return s
}

// SetCoverage sets the Coverage field's value.
func (s *SavingsPlansCoverage) SetCoverage(v *SavingsPlansCoverageData) *SavingsPlansCoverage {
	s.Coverage = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *SavingsPlansCoverage) SetTimePeriod(v *DateInterval) *SavingsPlansCoverage {
	s.TimePeriod = v
	return s
}

// Specific coverage percentage, On-Demand costs, and spend covered by Savings
// Plans, and total Savings Plans costs for an account.
type SavingsPlansCoverageData struct {
	_ struct{} `type:"structure"`

	// The percentage of your existing Savings Plans covered usage, divided by all
	// of your eligible Savings Plans usage in an account(or set of accounts).
	CoveragePercentage *string `type:"string"`

	// The cost of your AWS usage at the public On-Demand rate.
	OnDemandCost *string `type:"string"`

	// The amount of your AWS usage that is covered by a Savings Plans.
	SpendCoveredBySavingsPlans *string `type:"string"`

	// The total cost of your AWS usage, regardless of your purchase option.
	TotalCost *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansCoverageData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansCoverageData) GoString() string {
	return s.String()
}

// SetCoveragePercentage sets the CoveragePercentage field's value.
func (s *SavingsPlansCoverageData) SetCoveragePercentage(v string) *SavingsPlansCoverageData {
	s.CoveragePercentage = &v
	return s
}

// SetOnDemandCost sets the OnDemandCost field's value.
func (s *SavingsPlansCoverageData) SetOnDemandCost(v string) *SavingsPlansCoverageData {
	s.OnDemandCost = &v
	return s
}

// SetSpendCoveredBySavingsPlans sets the SpendCoveredBySavingsPlans field's value.
func (s *SavingsPlansCoverageData) SetSpendCoveredBySavingsPlans(v string) *SavingsPlansCoverageData {
	s.SpendCoveredBySavingsPlans = &v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *SavingsPlansCoverageData) SetTotalCost(v string) *SavingsPlansCoverageData {
	s.TotalCost = &v
	return s
}

// Attribute details on a specific Savings Plan.
type SavingsPlansDetails struct {
	_ struct{} `type:"structure"`

	// A group of instance types that Savings Plans applies to.
	InstanceFamily *string `type:"string"`

	// The unique ID used to distinguish Savings Plans from one another.
	OfferingId *string `type:"string"`

	// A collection of AWS resources in a geographic area. Each AWS Region is isolated
	// and independent of the other Regions.
	Region *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansDetails) GoString() string {
	return s.String()
}

// SetInstanceFamily sets the InstanceFamily field's value.
func (s *SavingsPlansDetails) SetInstanceFamily(v string) *SavingsPlansDetails {
	s.InstanceFamily = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *SavingsPlansDetails) SetOfferingId(v string) *SavingsPlansDetails {
	s.OfferingId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SavingsPlansDetails) SetRegion(v string) *SavingsPlansDetails {
	s.Region = &v
	return s
}

// Contains your request parameters, Savings Plan Recommendations Summary, and
// Details.
type SavingsPlansPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER. If the value is LINKED, recommendations are
	// calculated for individual member accounts only.
	AccountScope *string `type:"string" enum:"AccountScope"`

	// The lookback period in days, used to generate the recommendation.
	LookbackPeriodInDays *string `type:"string" enum:"LookbackPeriodInDays"`

	// The payment option used to generate the recommendation.
	PaymentOption *string `type:"string" enum:"PaymentOption"`

	// Details for the Savings Plans we recommend that you purchase to cover existing
	// Savings Plans eligible workloads.
	SavingsPlansPurchaseRecommendationDetails []*SavingsPlansPurchaseRecommendationDetail `type:"list"`

	// Summary metrics for your Savings Plans Recommendations.
	SavingsPlansPurchaseRecommendationSummary *SavingsPlansPurchaseRecommendationSummary `type:"structure"`

	// The requested Savings Plans recommendation type.
	SavingsPlansType *string `type:"string" enum:"SupportedSavingsPlansType"`

	// The Savings Plans recommendation term in years, used to generate the recommendation.
	TermInYears *string `type:"string" enum:"TermInYears"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansPurchaseRecommendation) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *SavingsPlansPurchaseRecommendation) SetAccountScope(v string) *SavingsPlansPurchaseRecommendation {
	s.AccountScope = &v
	return s
}

// SetLookbackPeriodInDays sets the LookbackPeriodInDays field's value.
func (s *SavingsPlansPurchaseRecommendation) SetLookbackPeriodInDays(v string) *SavingsPlansPurchaseRecommendation {
	s.LookbackPeriodInDays = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *SavingsPlansPurchaseRecommendation) SetPaymentOption(v string) *SavingsPlansPurchaseRecommendation {
	s.PaymentOption = &v
	return s
}

// SetSavingsPlansPurchaseRecommendationDetails sets the SavingsPlansPurchaseRecommendationDetails field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansPurchaseRecommendationDetails(v []*SavingsPlansPurchaseRecommendationDetail) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansPurchaseRecommendationDetails = v
	return s
}

// SetSavingsPlansPurchaseRecommendationSummary sets the SavingsPlansPurchaseRecommendationSummary field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansPurchaseRecommendationSummary(v *SavingsPlansPurchaseRecommendationSummary) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansPurchaseRecommendationSummary = v
	return s
}

// SetSavingsPlansType sets the SavingsPlansType field's value.
func (s *SavingsPlansPurchaseRecommendation) SetSavingsPlansType(v string) *SavingsPlansPurchaseRecommendation {
	s.SavingsPlansType = &v
	return s
}

// SetTermInYears sets the TermInYears field's value.
func (s *SavingsPlansPurchaseRecommendation) SetTermInYears(v string) *SavingsPlansPurchaseRecommendation {
	s.TermInYears = &v
	return s
}

// Details for your recommended Savings Plans.
type SavingsPlansPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The AccountID the recommendation is generated for.
	AccountId *string `type:"string"`

	// The currency code AWS used to generate the recommendations and present potential
	// savings.
	CurrencyCode *string `type:"string"`

	// The average value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentAverageHourlyOnDemandSpend *string `type:"string"`

	// The highest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMaximumHourlyOnDemandSpend *string `type:"string"`

	// The lowest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMinimumHourlyOnDemandSpend *string `type:"string"`

	// The estimated utilization of the recommended Savings Plans.
	EstimatedAverageUtilization *string `type:"string"`

	// The estimated monthly savings amount, based on the recommended Savings Plans.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plans, over the length of the lookback period.
	EstimatedOnDemandCost *string `type:"string"`

	// The estimated On-Demand costs you would expect with no additional commitment,
	// based on your usage of the selected time period and the Savings Plans you
	// own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment based on the recommended Savings Plans
	// purchased. This is calculated as estimatedSavingsAmount/ estimatedSPCost*100.
	EstimatedROI *string `type:"string"`

	// The cost of the recommended Savings Plans over the length of the lookback
	// period.
	EstimatedSPCost *string `type:"string"`

	// The estimated savings amount based on the recommended Savings Plans over
	// the length of the lookback period.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings percentage relative to the total cost of applicable
	// On-Demand usage over the lookback period.
	EstimatedSavingsPercentage *string `type:"string"`

	// The recommended hourly commitment level for the Savings Plans type, and configuration
	// based on the usage during the lookback period.
	HourlyCommitmentToPurchase *string `type:"string"`

	// Details for your recommended Savings Plans.
	SavingsPlansDetails *SavingsPlansDetails `type:"structure"`

	// The upfront cost of the recommended Savings Plans, based on the selected
	// payment option.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansPurchaseRecommendationDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetAccountId(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.AccountId = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrencyCode(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetCurrentAverageHourlyOnDemandSpend sets the CurrentAverageHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentAverageHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentAverageHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMaximumHourlyOnDemandSpend sets the CurrentMaximumHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentMaximumHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentMaximumHourlyOnDemandSpend = &v
	return s
}

// SetCurrentMinimumHourlyOnDemandSpend sets the CurrentMinimumHourlyOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetCurrentMinimumHourlyOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.CurrentMinimumHourlyOnDemandSpend = &v
	return s
}

// SetEstimatedAverageUtilization sets the EstimatedAverageUtilization field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedAverageUtilization(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedAverageUtilization = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedMonthlySavingsAmount(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedOnDemandCost sets the EstimatedOnDemandCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedOnDemandCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedOnDemandCost = &v
	return s
}

// SetEstimatedOnDemandCostWithCurrentCommitment sets the EstimatedOnDemandCostWithCurrentCommitment field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedOnDemandCostWithCurrentCommitment(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedOnDemandCostWithCurrentCommitment = &v
	return s
}

// SetEstimatedROI sets the EstimatedROI field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedROI(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedROI = &v
	return s
}

// SetEstimatedSPCost sets the EstimatedSPCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSPCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSPCost = &v
	return s
}

// SetEstimatedSavingsAmount sets the EstimatedSavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSavingsAmount(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSavingsAmount = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetEstimatedSavingsPercentage(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetHourlyCommitmentToPurchase sets the HourlyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetHourlyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.HourlyCommitmentToPurchase = &v
	return s
}

// SetSavingsPlansDetails sets the SavingsPlansDetails field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetSavingsPlansDetails(v *SavingsPlansDetails) *SavingsPlansPurchaseRecommendationDetail {
	s.SavingsPlansDetails = v
	return s
}

// SetUpfrontCost sets the UpfrontCost field's value.
func (s *SavingsPlansPurchaseRecommendationDetail) SetUpfrontCost(v string) *SavingsPlansPurchaseRecommendationDetail {
	s.UpfrontCost = &v
	return s
}

// Metadata about your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// Additional metadata that may be applicable to the recommendation.
	AdditionalMetadata *string `type:"string"`

	// The timestamp showing when the recommendations were generated.
	GenerationTimestamp *string `type:"string"`

	// The unique identifier for the recommendation set.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansPurchaseRecommendationMetadata) GoString() string {
	return s.String()
}

// SetAdditionalMetadata sets the AdditionalMetadata field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetAdditionalMetadata(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.AdditionalMetadata = &v
	return s
}

// SetGenerationTimestamp sets the GenerationTimestamp field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetGenerationTimestamp(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.GenerationTimestamp = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *SavingsPlansPurchaseRecommendationMetadata) SetRecommendationId(v string) *SavingsPlansPurchaseRecommendationMetadata {
	s.RecommendationId = &v
	return s
}

// Summary metrics for your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code AWS used to generate the recommendations and present potential
	// savings.
	CurrencyCode *string `type:"string"`

	// The current total on demand spend of the applicable usage types over the
	// lookback period.
	CurrentOnDemandSpend *string `type:"string"`

	// The recommended Savings Plans cost on a daily (24 hourly) basis.
	DailyCommitmentToPurchase *string `type:"string"`

	// The estimated monthly savings amount, based on the recommended Savings Plans
	// purchase.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The estimated On-Demand costs you would expect with no additional commitment,
	// based on your usage of the selected time period and the Savings Plans you
	// own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment based on the recommended Savings Plans
	// and estimated savings.
	EstimatedROI *string `type:"string"`

	// The estimated total savings over the lookback period, based on the purchase
	// of the recommended Savings Plans.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings relative to the total cost of On-Demand usage, over
	// the lookback period. This is calculated as estimatedSavingsAmount/ CurrentOnDemandSpend*100.
	EstimatedSavingsPercentage *string `type:"string"`

	// The estimated total cost of the usage after purchasing the recommended Savings
	// Plans. This is a sum of the cost of Savings Plans during this term, and the
	// remaining On-Demand usage.
	EstimatedTotalCost *string `type:"string"`

	// The recommended hourly commitment based on the recommendation parameters.
	HourlyCommitmentToPurchase *string `type:"string"`

	// The aggregate number of Savings Plans recommendations that exist for your
	// account.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansPurchaseRecommendationSummary) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetCurrencyCode(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.CurrencyCode = &v
	return s
}

// SetCurrentOnDemandSpend sets the CurrentOnDemandSpend field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetCurrentOnDemandSpend(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.CurrentOnDemandSpend = &v
	return s
}

// SetDailyCommitmentToPurchase sets the DailyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetDailyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.DailyCommitmentToPurchase = &v
	return s
}

// SetEstimatedMonthlySavingsAmount sets the EstimatedMonthlySavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedMonthlySavingsAmount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedMonthlySavingsAmount = &v
	return s
}

// SetEstimatedOnDemandCostWithCurrentCommitment sets the EstimatedOnDemandCostWithCurrentCommitment field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedOnDemandCostWithCurrentCommitment(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedOnDemandCostWithCurrentCommitment = &v
	return s
}

// SetEstimatedROI sets the EstimatedROI field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedROI(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedROI = &v
	return s
}

// SetEstimatedSavingsAmount sets the EstimatedSavingsAmount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedSavingsAmount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedSavingsAmount = &v
	return s
}

// SetEstimatedSavingsPercentage sets the EstimatedSavingsPercentage field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedSavingsPercentage(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedSavingsPercentage = &v
	return s
}

// SetEstimatedTotalCost sets the EstimatedTotalCost field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetEstimatedTotalCost(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.EstimatedTotalCost = &v
	return s
}

// SetHourlyCommitmentToPurchase sets the HourlyCommitmentToPurchase field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetHourlyCommitmentToPurchase(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.HourlyCommitmentToPurchase = &v
	return s
}

// SetTotalRecommendationCount sets the TotalRecommendationCount field's value.
func (s *SavingsPlansPurchaseRecommendationSummary) SetTotalRecommendationCount(v string) *SavingsPlansPurchaseRecommendationSummary {
	s.TotalRecommendationCount = &v
	return s
}

// The amount of savings you're accumulating, against the public On-Demand rate
// of the usage accrued in an account.
type SavingsPlansSavings struct {
	_ struct{} `type:"structure"`

	// The savings amount that you are accumulating for the usage that is covered
	// by a Savings Plans, when compared to the On-Demand equivalent of the same
	// usage.
	NetSavings *string `type:"string"`

	// How much the amount that the usage would have cost if it was accrued at the
	// On-Demand rate.
	OnDemandCostEquivalent *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansSavings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansSavings) GoString() string {
	return s.String()
}

// SetNetSavings sets the NetSavings field's value.
func (s *SavingsPlansSavings) SetNetSavings(v string) *SavingsPlansSavings {
	s.NetSavings = &v
	return s
}

// SetOnDemandCostEquivalent sets the OnDemandCostEquivalent field's value.
func (s *SavingsPlansSavings) SetOnDemandCostEquivalent(v string) *SavingsPlansSavings {
	s.OnDemandCostEquivalent = &v
	return s
}

// The measurement of how well you are using your existing Savings Plans.
type SavingsPlansUtilization struct {
	_ struct{} `type:"structure"`

	// The total amount of Savings Plans commitment that's been purchased in an
	// account (or set of accounts).
	TotalCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that was not consumed from Savings
	// Plans eligible usage in a specific period.
	UnusedCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that was consumed from Savings
	// Plans eligible usage in a specific period.
	UsedCommitment *string `type:"string"`

	// The amount of UsedCommitment divided by the TotalCommitment for your Savings
	// Plans.
	UtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansUtilization) GoString() string {
	return s.String()
}

// SetTotalCommitment sets the TotalCommitment field's value.
func (s *SavingsPlansUtilization) SetTotalCommitment(v string) *SavingsPlansUtilization {
	s.TotalCommitment = &v
	return s
}

// SetUnusedCommitment sets the UnusedCommitment field's value.
func (s *SavingsPlansUtilization) SetUnusedCommitment(v string) *SavingsPlansUtilization {
	s.UnusedCommitment = &v
	return s
}

// SetUsedCommitment sets the UsedCommitment field's value.
func (s *SavingsPlansUtilization) SetUsedCommitment(v string) *SavingsPlansUtilization {
	s.UsedCommitment = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *SavingsPlansUtilization) SetUtilizationPercentage(v string) *SavingsPlansUtilization {
	s.UtilizationPercentage = &v
	return s
}

// The aggregated utilization metrics for your Savings Plans usage.
type SavingsPlansUtilizationAggregates struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from Savings Plans, as well as the onDemandCostEquivalent of the
	// Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SavingsPlansUtilizationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansUtilizationAggregates) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationAggregates) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationAggregates {
	s.AmortizedCommitment = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationAggregates) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationAggregates {
	s.Savings = v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationAggregates) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationAggregates {
	s.Utilization = v
	return s
}

// The amount of Savings Plans utilization, in hours.
type SavingsPlansUtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from Savings Plans as well as the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The time period that you want the usage and costs for.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SavingsPlansUtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansUtilizationByTime) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationByTime) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationByTime {
	s.AmortizedCommitment = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationByTime) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationByTime {
	s.Savings = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *SavingsPlansUtilizationByTime) SetTimePeriod(v *DateInterval) *SavingsPlansUtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationByTime) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationByTime {
	s.Utilization = v
	return s
}

// A single daily or monthly Savings Plans utilization rate, and details for
// your account. A management account in an organization have access to member
// accounts. You can use GetDimensionValues to determine the possible dimension
// values.
type SavingsPlansUtilizationDetail struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. Includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from savings plans as well as the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The unique Amazon Resource Name (ARN) for a particular Savings Plan.
	SavingsPlanArn *string `type:"string"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	Utilization *SavingsPlansUtilization `type:"structure"`
}

// String returns the string representation
func (s SavingsPlansUtilizationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SavingsPlansUtilizationDetail) GoString() string {
	return s.String()
}

// SetAmortizedCommitment sets the AmortizedCommitment field's value.
func (s *SavingsPlansUtilizationDetail) SetAmortizedCommitment(v *SavingsPlansAmortizedCommitment) *SavingsPlansUtilizationDetail {
	s.AmortizedCommitment = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *SavingsPlansUtilizationDetail) SetAttributes(v map[string]*string) *SavingsPlansUtilizationDetail {
	s.Attributes = v
	return s
}

// SetSavings sets the Savings field's value.
func (s *SavingsPlansUtilizationDetail) SetSavings(v *SavingsPlansSavings) *SavingsPlansUtilizationDetail {
	s.Savings = v
	return s
}

// SetSavingsPlanArn sets the SavingsPlanArn field's value.
func (s *SavingsPlansUtilizationDetail) SetSavingsPlanArn(v string) *SavingsPlansUtilizationDetail {
	s.SavingsPlanArn = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *SavingsPlansUtilizationDetail) SetUtilization(v *SavingsPlansUtilization) *SavingsPlansUtilizationDetail {
	s.Utilization = v
	return s
}

// You've reached the limit on the number of resources you can create, or exceeded
// the size of an individual resource.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Hardware specifications for the service that you want recommendations for.
type ServiceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
	// for.
	EC2Specification *EC2Specification `type:"structure"`
}

// String returns the string representation
func (s ServiceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSpecification) GoString() string {
	return s.String()
}

// SetEC2Specification sets the EC2Specification field's value.
func (s *ServiceSpecification) SetEC2Specification(v *EC2Specification) *ServiceSpecification {
	s.EC2Specification = v
	return s
}

// The recipient of AnomalySubscription notifications.
type Subscriber struct {
	_ struct{} `type:"structure"`

	// The email address or SNS Amazon Resource Name (ARN), depending on the Type.
	Address *string `min:"6" type:"string"`

	// Indicates if the subscriber accepts the notifications.
	Status *string `type:"string" enum:"SubscriberStatus"`

	// The notification delivery channel.
	Type *string `type:"string" enum:"SubscriberType"`
}

// String returns the string representation
func (s Subscriber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscriber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Subscriber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Subscriber"}
	if s.Address != nil && len(*s.Address) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *Subscriber) SetAddress(v string) *Subscriber {
	s.Address = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Subscriber) SetStatus(v string) *Subscriber {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Subscriber) SetType(v string) *Subscriber {
	s.Type = &v
	return s
}

// The values that are available for a tag.
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	Key *string `type:"string"`

	// The match options that you can use to filter your results. MatchOptions is
	// only applicable for actions related to Cost Category. The default values
	// for MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []*string `type:"list"`

	// The specific value of the tag.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagValues) SetKey(v string) *TagValues {
	s.Key = &v
	return s
}

// SetMatchOptions sets the MatchOptions field's value.
func (s *TagValues) SetMatchOptions(v []*string) *TagValues {
	s.MatchOptions = v
	return s
}

// SetValues sets the Values field's value.
func (s *TagValues) SetValues(v []*string) *TagValues {
	s.Values = v
	return s
}

// Details on recommended instance.
type TargetInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// Indicates whether this recommendation is the defaulted AWS recommendation.
	DefaultTargetInstance *bool `type:"boolean"`

	// Expected cost to operate this instance type on a monthly basis.
	EstimatedMonthlyCost *string `type:"string"`

	// Estimated savings resulting from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`

	// Expected utilization metrics for target instance type.
	ExpectedResourceUtilization *ResourceUtilization `type:"structure"`

	// Details on the target instance type.
	ResourceDetails *ResourceDetails `type:"structure"`
}

// String returns the string representation
func (s TargetInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *TargetInstance) SetCurrencyCode(v string) *TargetInstance {
	s.CurrencyCode = &v
	return s
}

// SetDefaultTargetInstance sets the DefaultTargetInstance field's value.
func (s *TargetInstance) SetDefaultTargetInstance(v bool) *TargetInstance {
	s.DefaultTargetInstance = &v
	return s
}

// SetEstimatedMonthlyCost sets the EstimatedMonthlyCost field's value.
func (s *TargetInstance) SetEstimatedMonthlyCost(v string) *TargetInstance {
	s.EstimatedMonthlyCost = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *TargetInstance) SetEstimatedMonthlySavings(v string) *TargetInstance {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetExpectedResourceUtilization sets the ExpectedResourceUtilization field's value.
func (s *TargetInstance) SetExpectedResourceUtilization(v *ResourceUtilization) *TargetInstance {
	s.ExpectedResourceUtilization = v
	return s
}

// SetResourceDetails sets the ResourceDetails field's value.
func (s *TargetInstance) SetResourceDetails(v *ResourceDetails) *TargetInstance {
	s.ResourceDetails = v
	return s
}

// Details on termination recommendation.
type TerminateRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// Estimated savings resulting from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`
}

// String returns the string representation
func (s TerminateRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateRecommendationDetail) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *TerminateRecommendationDetail) SetCurrencyCode(v string) *TerminateRecommendationDetail {
	s.CurrencyCode = &v
	return s
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *TerminateRecommendationDetail) SetEstimatedMonthlySavings(v string) *TerminateRecommendationDetail {
	s.EstimatedMonthlySavings = &v
	return s
}

// Filters cost anomalies based on the total impact.
type TotalImpactFilter struct {
	_ struct{} `type:"structure"`

	// The upper bound dollar value used in the filter.
	EndValue *float64 `type:"double"`

	// The comparing value used in the filter.
	//
	// NumericOperator is a required field
	NumericOperator *string `type:"string" required:"true" enum:"NumericOperator"`

	// The lower bound dollar value used in the filter.
	//
	// StartValue is a required field
	StartValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TotalImpactFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TotalImpactFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TotalImpactFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TotalImpactFilter"}
	if s.NumericOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("NumericOperator"))
	}
	if s.StartValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StartValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndValue sets the EndValue field's value.
func (s *TotalImpactFilter) SetEndValue(v float64) *TotalImpactFilter {
	s.EndValue = &v
	return s
}

// SetNumericOperator sets the NumericOperator field's value.
func (s *TotalImpactFilter) SetNumericOperator(v string) *TotalImpactFilter {
	s.NumericOperator = &v
	return s
}

// SetStartValue sets the StartValue field's value.
func (s *TotalImpactFilter) SetStartValue(v float64) *TotalImpactFilter {
	s.StartValue = &v
	return s
}

// The cost anomaly monitor does not exist for the account.
type UnknownMonitorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnknownMonitorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnknownMonitorException) GoString() string {
	return s.String()
}

func newErrorUnknownMonitorException(v protocol.ResponseMetadata) error {
	return &UnknownMonitorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownMonitorException) Code() string {
	return "UnknownMonitorException"
}

// Message returns the exception's message.
func (s *UnknownMonitorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownMonitorException) OrigErr() error {
	return nil
}

func (s *UnknownMonitorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownMonitorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownMonitorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cost anomaly subscription does not exist for the account.
type UnknownSubscriptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnknownSubscriptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnknownSubscriptionException) GoString() string {
	return s.String()
}

func newErrorUnknownSubscriptionException(v protocol.ResponseMetadata) error {
	return &UnknownSubscriptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownSubscriptionException) Code() string {
	return "UnknownSubscriptionException"
}

// Message returns the exception's message.
func (s *UnknownSubscriptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownSubscriptionException) OrigErr() error {
	return nil
}

func (s *UnknownSubscriptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownSubscriptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownSubscriptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cost Explorer was unable to identify the usage unit. Provide UsageType/UsageTypeGroup
// filter selections that contain matching units, for example: hours.
type UnresolvableUsageUnitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnresolvableUsageUnitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnresolvableUsageUnitException) GoString() string {
	return s.String()
}

func newErrorUnresolvableUsageUnitException(v protocol.ResponseMetadata) error {
	return &UnresolvableUsageUnitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnresolvableUsageUnitException) Code() string {
	return "UnresolvableUsageUnitException"
}

// Message returns the exception's message.
func (s *UnresolvableUsageUnitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnresolvableUsageUnitException) OrigErr() error {
	return nil
}

func (s *UnresolvableUsageUnitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnresolvableUsageUnitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnresolvableUsageUnitException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateAnomalyMonitorInput struct {
	_ struct{} `type:"structure"`

	// Cost anomaly monitor Amazon Resource Names (ARNs).
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`

	// The new name for the cost anomaly monitor.
	MonitorName *string `type:"string"`
}

// String returns the string representation
func (s UpdateAnomalyMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAnomalyMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnomalyMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnomalyMonitorInput"}
	if s.MonitorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateAnomalyMonitorInput) SetMonitorArn(v string) *UpdateAnomalyMonitorInput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateAnomalyMonitorInput) SetMonitorName(v string) *UpdateAnomalyMonitorInput {
	s.MonitorName = &v
	return s
}

type UpdateAnomalyMonitorOutput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly monitor ARN.
	//
	// MonitorArn is a required field
	MonitorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAnomalyMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAnomalyMonitorOutput) GoString() string {
	return s.String()
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateAnomalyMonitorOutput) SetMonitorArn(v string) *UpdateAnomalyMonitorOutput {
	s.MonitorArn = &v
	return s
}

type UpdateAnomalySubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The update to the frequency value at which subscribers will receive notifications.
	Frequency *string `type:"string" enum:"AnomalySubscriptionFrequency"`

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []*string `type:"list"`

	// The update to the subscriber list.
	Subscribers []*Subscriber `type:"list"`

	// A cost anomaly subscription Amazon Resource Name (ARN).
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`

	// The subscription's new name.
	SubscriptionName *string `type:"string"`

	// The update to the threshold value for receiving notifications.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s UpdateAnomalySubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAnomalySubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnomalySubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnomalySubscriptionInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}
	if s.Subscribers != nil {
		for i, v := range s.Subscribers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscribers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrequency sets the Frequency field's value.
func (s *UpdateAnomalySubscriptionInput) SetFrequency(v string) *UpdateAnomalySubscriptionInput {
	s.Frequency = &v
	return s
}

// SetMonitorArnList sets the MonitorArnList field's value.
func (s *UpdateAnomalySubscriptionInput) SetMonitorArnList(v []*string) *UpdateAnomalySubscriptionInput {
	s.MonitorArnList = v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscribers(v []*Subscriber) *UpdateAnomalySubscriptionInput {
	s.Subscribers = v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscriptionArn(v string) *UpdateAnomalySubscriptionInput {
	s.SubscriptionArn = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *UpdateAnomalySubscriptionInput) SetSubscriptionName(v string) *UpdateAnomalySubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *UpdateAnomalySubscriptionInput) SetThreshold(v float64) *UpdateAnomalySubscriptionInput {
	s.Threshold = &v
	return s
}

type UpdateAnomalySubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// A cost anomaly subscription ARN.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAnomalySubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAnomalySubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *UpdateAnomalySubscriptionOutput) SetSubscriptionArn(v string) *UpdateAnomalySubscriptionOutput {
	s.SubscriptionArn = &v
	return s
}

type UpdateCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion *string `type:"string" required:"true" enum:"CostCategoryRuleVersion"`

	// The Expression object used to categorize costs. For more information, see
	// CostCategoryRule (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
	//
	// Rules is a required field
	Rules []*CostCategoryRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCostCategoryDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCostCategoryDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCostCategoryDefinitionInput"}
	if s.CostCategoryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CostCategoryArn", 20))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *UpdateCostCategoryDefinitionInput) SetCostCategoryArn(v string) *UpdateCostCategoryDefinitionInput {
	s.CostCategoryArn = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *UpdateCostCategoryDefinitionInput) SetRuleVersion(v string) *UpdateCostCategoryDefinitionInput {
	s.RuleVersion = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateCostCategoryDefinitionInput) SetRules(v []*CostCategoryRule) *UpdateCostCategoryDefinitionInput {
	s.Rules = v
	return s
}

type UpdateCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	EffectiveStart *string `min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCostCategoryDefinitionOutput) GoString() string {
	return s.String()
}

// SetCostCategoryArn sets the CostCategoryArn field's value.
func (s *UpdateCostCategoryDefinitionOutput) SetCostCategoryArn(v string) *UpdateCostCategoryDefinitionOutput {
	s.CostCategoryArn = &v
	return s
}

// SetEffectiveStart sets the EffectiveStart field's value.
func (s *UpdateCostCategoryDefinitionOutput) SetEffectiveStart(v string) *UpdateCostCategoryDefinitionOutput {
	s.EffectiveStart = &v
	return s
}

// The amount of utilization, in hours.
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that this utilization result uses.
	Groups []*ReservationUtilizationGroup `type:"list"`

	// The period of time that this utilization was used for.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of reservation hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtilizationByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *UtilizationByTime) SetGroups(v []*ReservationUtilizationGroup) *UtilizationByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *UtilizationByTime) SetTimePeriod(v *DateInterval) *UtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *UtilizationByTime) SetTotal(v *ReservationAggregates) *UtilizationByTime {
	s.Total = v
	return s
}

const (
	// AccountScopePayer is a AccountScope enum value
	AccountScopePayer = "PAYER"

	// AccountScopeLinked is a AccountScope enum value
	AccountScopeLinked = "LINKED"
)

// AccountScope_Values returns all elements of the AccountScope enum
func AccountScope_Values() []string {
	return []string{
		AccountScopePayer,
		AccountScopeLinked,
	}
}

const (
	// AnomalyFeedbackTypeYes is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypeYes = "YES"

	// AnomalyFeedbackTypeNo is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypeNo = "NO"

	// AnomalyFeedbackTypePlannedActivity is a AnomalyFeedbackType enum value
	AnomalyFeedbackTypePlannedActivity = "PLANNED_ACTIVITY"
)

// AnomalyFeedbackType_Values returns all elements of the AnomalyFeedbackType enum
func AnomalyFeedbackType_Values() []string {
	return []string{
		AnomalyFeedbackTypeYes,
		AnomalyFeedbackTypeNo,
		AnomalyFeedbackTypePlannedActivity,
	}
}

const (
	// AnomalySubscriptionFrequencyDaily is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyDaily = "DAILY"

	// AnomalySubscriptionFrequencyImmediate is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyImmediate = "IMMEDIATE"

	// AnomalySubscriptionFrequencyWeekly is a AnomalySubscriptionFrequency enum value
	AnomalySubscriptionFrequencyWeekly = "WEEKLY"
)

// AnomalySubscriptionFrequency_Values returns all elements of the AnomalySubscriptionFrequency enum
func AnomalySubscriptionFrequency_Values() []string {
	return []string{
		AnomalySubscriptionFrequencyDaily,
		AnomalySubscriptionFrequencyImmediate,
		AnomalySubscriptionFrequencyWeekly,
	}
}

const (
	// ContextCostAndUsage is a Context enum value
	ContextCostAndUsage = "COST_AND_USAGE"

	// ContextReservations is a Context enum value
	ContextReservations = "RESERVATIONS"

	// ContextSavingsPlans is a Context enum value
	ContextSavingsPlans = "SAVINGS_PLANS"
)

// Context_Values returns all elements of the Context enum
func Context_Values() []string {
	return []string{
		ContextCostAndUsage,
		ContextReservations,
		ContextSavingsPlans,
	}
}

// The rule schema version in this particular Cost Category.
const (
	// CostCategoryRuleVersionCostCategoryExpressionV1 is a CostCategoryRuleVersion enum value
	CostCategoryRuleVersionCostCategoryExpressionV1 = "CostCategoryExpression.v1"
)

// CostCategoryRuleVersion_Values returns all elements of the CostCategoryRuleVersion enum
func CostCategoryRuleVersion_Values() []string {
	return []string{
		CostCategoryRuleVersionCostCategoryExpressionV1,
	}
}

const (
	// CostCategoryStatusProcessing is a CostCategoryStatus enum value
	CostCategoryStatusProcessing = "PROCESSING"

	// CostCategoryStatusApplied is a CostCategoryStatus enum value
	CostCategoryStatusApplied = "APPLIED"
)

// CostCategoryStatus_Values returns all elements of the CostCategoryStatus enum
func CostCategoryStatus_Values() []string {
	return []string{
		CostCategoryStatusProcessing,
		CostCategoryStatusApplied,
	}
}

const (
	// CostCategoryStatusComponentCostExplorer is a CostCategoryStatusComponent enum value
	CostCategoryStatusComponentCostExplorer = "COST_EXPLORER"
)

// CostCategoryStatusComponent_Values returns all elements of the CostCategoryStatusComponent enum
func CostCategoryStatusComponent_Values() []string {
	return []string{
		CostCategoryStatusComponentCostExplorer,
	}
}

const (
	// DimensionAz is a Dimension enum value
	DimensionAz = "AZ"

	// DimensionInstanceType is a Dimension enum value
	DimensionInstanceType = "INSTANCE_TYPE"

	// DimensionLinkedAccount is a Dimension enum value
	DimensionLinkedAccount = "LINKED_ACCOUNT"

	// DimensionLinkedAccountName is a Dimension enum value
	DimensionLinkedAccountName = "LINKED_ACCOUNT_NAME"

	// DimensionOperation is a Dimension enum value
	DimensionOperation = "OPERATION"

	// DimensionPurchaseType is a Dimension enum value
	DimensionPurchaseType = "PURCHASE_TYPE"

	// DimensionRegion is a Dimension enum value
	DimensionRegion = "REGION"

	// DimensionService is a Dimension enum value
	DimensionService = "SERVICE"

	// DimensionServiceCode is a Dimension enum value
	DimensionServiceCode = "SERVICE_CODE"

	// DimensionUsageType is a Dimension enum value
	DimensionUsageType = "USAGE_TYPE"

	// DimensionUsageTypeGroup is a Dimension enum value
	DimensionUsageTypeGroup = "USAGE_TYPE_GROUP"

	// DimensionRecordType is a Dimension enum value
	DimensionRecordType = "RECORD_TYPE"

	// DimensionOperatingSystem is a Dimension enum value
	DimensionOperatingSystem = "OPERATING_SYSTEM"

	// DimensionTenancy is a Dimension enum value
	DimensionTenancy = "TENANCY"

	// DimensionScope is a Dimension enum value
	DimensionScope = "SCOPE"

	// DimensionPlatform is a Dimension enum value
	DimensionPlatform = "PLATFORM"

	// DimensionSubscriptionId is a Dimension enum value
	DimensionSubscriptionId = "SUBSCRIPTION_ID"

	// DimensionLegalEntityName is a Dimension enum value
	DimensionLegalEntityName = "LEGAL_ENTITY_NAME"

	// DimensionDeploymentOption is a Dimension enum value
	DimensionDeploymentOption = "DEPLOYMENT_OPTION"

	// DimensionDatabaseEngine is a Dimension enum value
	DimensionDatabaseEngine = "DATABASE_ENGINE"

	// DimensionCacheEngine is a Dimension enum value
	DimensionCacheEngine = "CACHE_ENGINE"

	// DimensionInstanceTypeFamily is a Dimension enum value
	DimensionInstanceTypeFamily = "INSTANCE_TYPE_FAMILY"

	// DimensionBillingEntity is a Dimension enum value
	DimensionBillingEntity = "BILLING_ENTITY"

	// DimensionReservationId is a Dimension enum value
	DimensionReservationId = "RESERVATION_ID"

	// DimensionResourceId is a Dimension enum value
	DimensionResourceId = "RESOURCE_ID"

	// DimensionRightsizingType is a Dimension enum value
	DimensionRightsizingType = "RIGHTSIZING_TYPE"

	// DimensionSavingsPlansType is a Dimension enum value
	DimensionSavingsPlansType = "SAVINGS_PLANS_TYPE"

	// DimensionSavingsPlanArn is a Dimension enum value
	DimensionSavingsPlanArn = "SAVINGS_PLAN_ARN"

	// DimensionPaymentOption is a Dimension enum value
	DimensionPaymentOption = "PAYMENT_OPTION"
)

// Dimension_Values returns all elements of the Dimension enum
func Dimension_Values() []string {
	return []string{
		DimensionAz,
		DimensionInstanceType,
		DimensionLinkedAccount,
		DimensionLinkedAccountName,
		DimensionOperation,
		DimensionPurchaseType,
		DimensionRegion,
		DimensionService,
		DimensionServiceCode,
		DimensionUsageType,
		DimensionUsageTypeGroup,
		DimensionRecordType,
		DimensionOperatingSystem,
		DimensionTenancy,
		DimensionScope,
		DimensionPlatform,
		DimensionSubscriptionId,
		DimensionLegalEntityName,
		DimensionDeploymentOption,
		DimensionDatabaseEngine,
		DimensionCacheEngine,
		DimensionInstanceTypeFamily,
		DimensionBillingEntity,
		DimensionReservationId,
		DimensionResourceId,
		DimensionRightsizingType,
		DimensionSavingsPlansType,
		DimensionSavingsPlanArn,
		DimensionPaymentOption,
	}
}

const (
	// GranularityDaily is a Granularity enum value
	GranularityDaily = "DAILY"

	// GranularityMonthly is a Granularity enum value
	GranularityMonthly = "MONTHLY"

	// GranularityHourly is a Granularity enum value
	GranularityHourly = "HOURLY"
)

// Granularity_Values returns all elements of the Granularity enum
func Granularity_Values() []string {
	return []string{
		GranularityDaily,
		GranularityMonthly,
		GranularityHourly,
	}
}

const (
	// GroupDefinitionTypeDimension is a GroupDefinitionType enum value
	GroupDefinitionTypeDimension = "DIMENSION"

	// GroupDefinitionTypeTag is a GroupDefinitionType enum value
	GroupDefinitionTypeTag = "TAG"

	// GroupDefinitionTypeCostCategory is a GroupDefinitionType enum value
	GroupDefinitionTypeCostCategory = "COST_CATEGORY"
)

// GroupDefinitionType_Values returns all elements of the GroupDefinitionType enum
func GroupDefinitionType_Values() []string {
	return []string{
		GroupDefinitionTypeDimension,
		GroupDefinitionTypeTag,
		GroupDefinitionTypeCostCategory,
	}
}

const (
	// LookbackPeriodInDaysSevenDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSevenDays = "SEVEN_DAYS"

	// LookbackPeriodInDaysThirtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysThirtyDays = "THIRTY_DAYS"

	// LookbackPeriodInDaysSixtyDays is a LookbackPeriodInDays enum value
	LookbackPeriodInDaysSixtyDays = "SIXTY_DAYS"
)

// LookbackPeriodInDays_Values returns all elements of the LookbackPeriodInDays enum
func LookbackPeriodInDays_Values() []string {
	return []string{
		LookbackPeriodInDaysSevenDays,
		LookbackPeriodInDaysThirtyDays,
		LookbackPeriodInDaysSixtyDays,
	}
}

const (
	// MatchOptionEquals is a MatchOption enum value
	MatchOptionEquals = "EQUALS"

	// MatchOptionStartsWith is a MatchOption enum value
	MatchOptionStartsWith = "STARTS_WITH"

	// MatchOptionEndsWith is a MatchOption enum value
	MatchOptionEndsWith = "ENDS_WITH"

	// MatchOptionContains is a MatchOption enum value
	MatchOptionContains = "CONTAINS"

	// MatchOptionCaseSensitive is a MatchOption enum value
	MatchOptionCaseSensitive = "CASE_SENSITIVE"

	// MatchOptionCaseInsensitive is a MatchOption enum value
	MatchOptionCaseInsensitive = "CASE_INSENSITIVE"
)

// MatchOption_Values returns all elements of the MatchOption enum
func MatchOption_Values() []string {
	return []string{
		MatchOptionEquals,
		MatchOptionStartsWith,
		MatchOptionEndsWith,
		MatchOptionContains,
		MatchOptionCaseSensitive,
		MatchOptionCaseInsensitive,
	}
}

const (
	// MetricBlendedCost is a Metric enum value
	MetricBlendedCost = "BLENDED_COST"

	// MetricUnblendedCost is a Metric enum value
	MetricUnblendedCost = "UNBLENDED_COST"

	// MetricAmortizedCost is a Metric enum value
	MetricAmortizedCost = "AMORTIZED_COST"

	// MetricNetUnblendedCost is a Metric enum value
	MetricNetUnblendedCost = "NET_UNBLENDED_COST"

	// MetricNetAmortizedCost is a Metric enum value
	MetricNetAmortizedCost = "NET_AMORTIZED_COST"

	// MetricUsageQuantity is a Metric enum value
	MetricUsageQuantity = "USAGE_QUANTITY"

	// MetricNormalizedUsageAmount is a Metric enum value
	MetricNormalizedUsageAmount = "NORMALIZED_USAGE_AMOUNT"
)

// Metric_Values returns all elements of the Metric enum
func Metric_Values() []string {
	return []string{
		MetricBlendedCost,
		MetricUnblendedCost,
		MetricAmortizedCost,
		MetricNetUnblendedCost,
		MetricNetAmortizedCost,
		MetricUsageQuantity,
		MetricNormalizedUsageAmount,
	}
}

const (
	// MonitorDimensionService is a MonitorDimension enum value
	MonitorDimensionService = "SERVICE"
)

// MonitorDimension_Values returns all elements of the MonitorDimension enum
func MonitorDimension_Values() []string {
	return []string{
		MonitorDimensionService,
	}
}

const (
	// MonitorTypeDimensional is a MonitorType enum value
	MonitorTypeDimensional = "DIMENSIONAL"

	// MonitorTypeCustom is a MonitorType enum value
	MonitorTypeCustom = "CUSTOM"
)

// MonitorType_Values returns all elements of the MonitorType enum
func MonitorType_Values() []string {
	return []string{
		MonitorTypeDimensional,
		MonitorTypeCustom,
	}
}

const (
	// NumericOperatorEqual is a NumericOperator enum value
	NumericOperatorEqual = "EQUAL"

	// NumericOperatorGreaterThanOrEqual is a NumericOperator enum value
	NumericOperatorGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"

	// NumericOperatorLessThanOrEqual is a NumericOperator enum value
	NumericOperatorLessThanOrEqual = "LESS_THAN_OR_EQUAL"

	// NumericOperatorGreaterThan is a NumericOperator enum value
	NumericOperatorGreaterThan = "GREATER_THAN"

	// NumericOperatorLessThan is a NumericOperator enum value
	NumericOperatorLessThan = "LESS_THAN"

	// NumericOperatorBetween is a NumericOperator enum value
	NumericOperatorBetween = "BETWEEN"
)

// NumericOperator_Values returns all elements of the NumericOperator enum
func NumericOperator_Values() []string {
	return []string{
		NumericOperatorEqual,
		NumericOperatorGreaterThanOrEqual,
		NumericOperatorLessThanOrEqual,
		NumericOperatorGreaterThan,
		NumericOperatorLessThan,
		NumericOperatorBetween,
	}
}

const (
	// OfferingClassStandard is a OfferingClass enum value
	OfferingClassStandard = "STANDARD"

	// OfferingClassConvertible is a OfferingClass enum value
	OfferingClassConvertible = "CONVERTIBLE"
)

// OfferingClass_Values returns all elements of the OfferingClass enum
func OfferingClass_Values() []string {
	return []string{
		OfferingClassStandard,
		OfferingClassConvertible,
	}
}

const (
	// PaymentOptionNoUpfront is a PaymentOption enum value
	PaymentOptionNoUpfront = "NO_UPFRONT"

	// PaymentOptionPartialUpfront is a PaymentOption enum value
	PaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// PaymentOptionAllUpfront is a PaymentOption enum value
	PaymentOptionAllUpfront = "ALL_UPFRONT"

	// PaymentOptionLightUtilization is a PaymentOption enum value
	PaymentOptionLightUtilization = "LIGHT_UTILIZATION"

	// PaymentOptionMediumUtilization is a PaymentOption enum value
	PaymentOptionMediumUtilization = "MEDIUM_UTILIZATION"

	// PaymentOptionHeavyUtilization is a PaymentOption enum value
	PaymentOptionHeavyUtilization = "HEAVY_UTILIZATION"
)

// PaymentOption_Values returns all elements of the PaymentOption enum
func PaymentOption_Values() []string {
	return []string{
		PaymentOptionNoUpfront,
		PaymentOptionPartialUpfront,
		PaymentOptionAllUpfront,
		PaymentOptionLightUtilization,
		PaymentOptionMediumUtilization,
		PaymentOptionHeavyUtilization,
	}
}

const (
	// RecommendationTargetSameInstanceFamily is a RecommendationTarget enum value
	RecommendationTargetSameInstanceFamily = "SAME_INSTANCE_FAMILY"

	// RecommendationTargetCrossInstanceFamily is a RecommendationTarget enum value
	RecommendationTargetCrossInstanceFamily = "CROSS_INSTANCE_FAMILY"
)

// RecommendationTarget_Values returns all elements of the RecommendationTarget enum
func RecommendationTarget_Values() []string {
	return []string{
		RecommendationTargetSameInstanceFamily,
		RecommendationTargetCrossInstanceFamily,
	}
}

const (
	// RightsizingTypeTerminate is a RightsizingType enum value
	RightsizingTypeTerminate = "TERMINATE"

	// RightsizingTypeModify is a RightsizingType enum value
	RightsizingTypeModify = "MODIFY"
)

// RightsizingType_Values returns all elements of the RightsizingType enum
func RightsizingType_Values() []string {
	return []string{
		RightsizingTypeTerminate,
		RightsizingTypeModify,
	}
}

const (
	// SubscriberStatusConfirmed is a SubscriberStatus enum value
	SubscriberStatusConfirmed = "CONFIRMED"

	// SubscriberStatusDeclined is a SubscriberStatus enum value
	SubscriberStatusDeclined = "DECLINED"
)

// SubscriberStatus_Values returns all elements of the SubscriberStatus enum
func SubscriberStatus_Values() []string {
	return []string{
		SubscriberStatusConfirmed,
		SubscriberStatusDeclined,
	}
}

const (
	// SubscriberTypeEmail is a SubscriberType enum value
	SubscriberTypeEmail = "EMAIL"

	// SubscriberTypeSns is a SubscriberType enum value
	SubscriberTypeSns = "SNS"
)

// SubscriberType_Values returns all elements of the SubscriberType enum
func SubscriberType_Values() []string {
	return []string{
		SubscriberTypeEmail,
		SubscriberTypeSns,
	}
}

const (
	// SupportedSavingsPlansTypeComputeSp is a SupportedSavingsPlansType enum value
	SupportedSavingsPlansTypeComputeSp = "COMPUTE_SP"

	// SupportedSavingsPlansTypeEc2InstanceSp is a SupportedSavingsPlansType enum value
	SupportedSavingsPlansTypeEc2InstanceSp = "EC2_INSTANCE_SP"
)

// SupportedSavingsPlansType_Values returns all elements of the SupportedSavingsPlansType enum
func SupportedSavingsPlansType_Values() []string {
	return []string{
		SupportedSavingsPlansTypeComputeSp,
		SupportedSavingsPlansTypeEc2InstanceSp,
	}
}

const (
	// TermInYearsOneYear is a TermInYears enum value
	TermInYearsOneYear = "ONE_YEAR"

	// TermInYearsThreeYears is a TermInYears enum value
	TermInYearsThreeYears = "THREE_YEARS"
)

// TermInYears_Values returns all elements of the TermInYears enum
func TermInYears_Values() []string {
	return []string{
		TermInYearsOneYear,
		TermInYearsThreeYears,
	}
}
