// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchUpdateSchedule = "BatchUpdateSchedule"

// BatchUpdateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateSchedule for more information on using the BatchUpdateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateScheduleRequest method.
//    req, resp := client.BatchUpdateScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule
func (c *MediaLive) BatchUpdateScheduleRequest(input *BatchUpdateScheduleInput) (req *request.Request, output *BatchUpdateScheduleOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
	}

	if input == nil {
		input = &BatchUpdateScheduleInput{}
	}

	output = &BatchUpdateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateSchedule API operation for AWS Elemental MediaLive.
//
// Update a channel schedule
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation BatchUpdateSchedule for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule
func (c *MediaLive) BatchUpdateSchedule(input *BatchUpdateScheduleInput) (*BatchUpdateScheduleOutput, error) {
	req, out := c.BatchUpdateScheduleRequest(input)
	return out, req.Send()
}

// BatchUpdateScheduleWithContext is the same as BatchUpdateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) BatchUpdateScheduleWithContext(ctx aws.Context, input *BatchUpdateScheduleInput, opts ...request.Option) (*BatchUpdateScheduleOutput, error) {
	req, out := c.BatchUpdateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS Elemental MediaLive.
//
// Creates a new channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInput = "CreateInput"

// CreateInputRequest generates a "aws/request.Request" representing the
// client's request for the CreateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInput for more information on using the CreateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInputRequest method.
//    req, resp := client.CreateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInputRequest(input *CreateInputInput) (req *request.Request, output *CreateInputOutput) {
	op := &request.Operation{
		Name:       opCreateInput,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputs",
	}

	if input == nil {
		input = &CreateInputInput{}
	}

	output = &CreateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInput API operation for AWS Elemental MediaLive.
//
// Create an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInput(input *CreateInputInput) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	return out, req.Send()
}

// CreateInputWithContext is the same as CreateInput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputWithContext(ctx aws.Context, input *CreateInputInput, opts ...request.Option) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInputSecurityGroup = "CreateInputSecurityGroup"

// CreateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInputSecurityGroup for more information on using the CreateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInputSecurityGroupRequest method.
//    req, resp := client.CreateInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroupRequest(input *CreateInputSecurityGroupInput) (req *request.Request, output *CreateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateInputSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputSecurityGroups",
	}

	if input == nil {
		input = &CreateInputSecurityGroupInput{}
	}

	output = &CreateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Creates a Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroup(input *CreateInputSecurityGroupInput) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateInputSecurityGroupWithContext is the same as CreateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputSecurityGroupWithContext(ctx aws.Context, input *CreateInputSecurityGroupInput, opts ...request.Option) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultiplex = "CreateMultiplex"

// CreateMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultiplex for more information on using the CreateMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMultiplexRequest method.
//    req, resp := client.CreateMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex
func (c *MediaLive) CreateMultiplexRequest(input *CreateMultiplexInput) (req *request.Request, output *CreateMultiplexOutput) {
	op := &request.Operation{
		Name:       opCreateMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes",
	}

	if input == nil {
		input = &CreateMultiplexInput{}
	}

	output = &CreateMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultiplex API operation for AWS Elemental MediaLive.
//
// Create a new multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex
func (c *MediaLive) CreateMultiplex(input *CreateMultiplexInput) (*CreateMultiplexOutput, error) {
	req, out := c.CreateMultiplexRequest(input)
	return out, req.Send()
}

// CreateMultiplexWithContext is the same as CreateMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateMultiplexWithContext(ctx aws.Context, input *CreateMultiplexInput, opts ...request.Option) (*CreateMultiplexOutput, error) {
	req, out := c.CreateMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultiplexProgram = "CreateMultiplexProgram"

// CreateMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultiplexProgram for more information on using the CreateMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMultiplexProgramRequest method.
//    req, resp := client.CreateMultiplexProgramRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram
func (c *MediaLive) CreateMultiplexProgramRequest(input *CreateMultiplexProgramInput) (req *request.Request, output *CreateMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opCreateMultiplexProgram,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs",
	}

	if input == nil {
		input = &CreateMultiplexProgramInput{}
	}

	output = &CreateMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Create a new program in the multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateMultiplexProgram for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram
func (c *MediaLive) CreateMultiplexProgram(input *CreateMultiplexProgramInput) (*CreateMultiplexProgramOutput, error) {
	req, out := c.CreateMultiplexProgramRequest(input)
	return out, req.Send()
}

// CreateMultiplexProgramWithContext is the same as CreateMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateMultiplexProgramWithContext(ctx aws.Context, input *CreateMultiplexProgramInput, opts ...request.Option) (*CreateMultiplexProgramOutput, error) {
	req, out := c.CreateMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags
func (c *MediaLive) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for AWS Elemental MediaLive.
//
// Create tags for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags
func (c *MediaLive) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChannel API operation for AWS Elemental MediaLive.
//
// Starts deletion of channel. The associated outputs are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInput = "DeleteInput"

// DeleteInputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInput for more information on using the DeleteInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInputRequest method.
//    req, resp := client.DeleteInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInputRequest(input *DeleteInputInput) (req *request.Request, output *DeleteInputOutput) {
	op := &request.Operation{
		Name:       opDeleteInput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DeleteInputInput{}
	}

	output = &DeleteInputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInput API operation for AWS Elemental MediaLive.
//
// Deletes the input end point
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInput(input *DeleteInputInput) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	return out, req.Send()
}

// DeleteInputWithContext is the same as DeleteInput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputWithContext(ctx aws.Context, input *DeleteInputInput, opts ...request.Option) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInputSecurityGroup = "DeleteInputSecurityGroup"

// DeleteInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInputSecurityGroup for more information on using the DeleteInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInputSecurityGroupRequest method.
//    req, resp := client.DeleteInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroupRequest(input *DeleteInputSecurityGroupInput) (req *request.Request, output *DeleteInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteInputSecurityGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DeleteInputSecurityGroupInput{}
	}

	output = &DeleteInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Deletes an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroup(input *DeleteInputSecurityGroupInput) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteInputSecurityGroupWithContext is the same as DeleteInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputSecurityGroupWithContext(ctx aws.Context, input *DeleteInputSecurityGroupInput, opts ...request.Option) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMultiplex = "DeleteMultiplex"

// DeleteMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMultiplex for more information on using the DeleteMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMultiplexRequest method.
//    req, resp := client.DeleteMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex
func (c *MediaLive) DeleteMultiplexRequest(input *DeleteMultiplexInput) (req *request.Request, output *DeleteMultiplexOutput) {
	op := &request.Operation{
		Name:       opDeleteMultiplex,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &DeleteMultiplexInput{}
	}

	output = &DeleteMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMultiplex API operation for AWS Elemental MediaLive.
//
// Delete a multiplex. The multiplex must be idle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex
func (c *MediaLive) DeleteMultiplex(input *DeleteMultiplexInput) (*DeleteMultiplexOutput, error) {
	req, out := c.DeleteMultiplexRequest(input)
	return out, req.Send()
}

// DeleteMultiplexWithContext is the same as DeleteMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteMultiplexWithContext(ctx aws.Context, input *DeleteMultiplexInput, opts ...request.Option) (*DeleteMultiplexOutput, error) {
	req, out := c.DeleteMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMultiplexProgram = "DeleteMultiplexProgram"

// DeleteMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMultiplexProgram for more information on using the DeleteMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMultiplexProgramRequest method.
//    req, resp := client.DeleteMultiplexProgramRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram
func (c *MediaLive) DeleteMultiplexProgramRequest(input *DeleteMultiplexProgramInput) (req *request.Request, output *DeleteMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opDeleteMultiplexProgram,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &DeleteMultiplexProgramInput{}
	}

	output = &DeleteMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Delete a program from a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteMultiplexProgram for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram
func (c *MediaLive) DeleteMultiplexProgram(input *DeleteMultiplexProgramInput) (*DeleteMultiplexProgramOutput, error) {
	req, out := c.DeleteMultiplexProgramRequest(input)
	return out, req.Send()
}

// DeleteMultiplexProgramWithContext is the same as DeleteMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteMultiplexProgramWithContext(ctx aws.Context, input *DeleteMultiplexProgramInput, opts ...request.Option) (*DeleteMultiplexProgramOutput, error) {
	req, out := c.DeleteMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReservation = "DeleteReservation"

// DeleteReservationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReservation for more information on using the DeleteReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReservationRequest method.
//    req, resp := client.DeleteReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation
func (c *MediaLive) DeleteReservationRequest(input *DeleteReservationInput) (req *request.Request, output *DeleteReservationOutput) {
	op := &request.Operation{
		Name:       opDeleteReservation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &DeleteReservationInput{}
	}

	output = &DeleteReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReservation API operation for AWS Elemental MediaLive.
//
// Delete an expired reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteReservation for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation
func (c *MediaLive) DeleteReservation(input *DeleteReservationInput) (*DeleteReservationOutput, error) {
	req, out := c.DeleteReservationRequest(input)
	return out, req.Send()
}

// DeleteReservationWithContext is the same as DeleteReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteReservationWithContext(ctx aws.Context, input *DeleteReservationInput, opts ...request.Option) (*DeleteReservationOutput, error) {
	req, out := c.DeleteReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchedule = "DeleteSchedule"

// DeleteScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchedule for more information on using the DeleteSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduleRequest method.
//    req, resp := client.DeleteScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule
func (c *MediaLive) DeleteScheduleRequest(input *DeleteScheduleInput) (req *request.Request, output *DeleteScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
	}

	if input == nil {
		input = &DeleteScheduleInput{}
	}

	output = &DeleteScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchedule API operation for AWS Elemental MediaLive.
//
// Delete all schedule actions on a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteSchedule for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule
func (c *MediaLive) DeleteSchedule(input *DeleteScheduleInput) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	return out, req.Send()
}

// DeleteScheduleWithContext is the same as DeleteSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteScheduleWithContext(ctx aws.Context, input *DeleteScheduleInput, opts ...request.Option) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags
func (c *MediaLive) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for AWS Elemental MediaLive.
//
// Removes tags for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags
func (c *MediaLive) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelRequest method.
//    req, resp := client.DescribeChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS Elemental MediaLive.
//
// Gets details about a channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInput = "DescribeInput"

// DescribeInputRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInput for more information on using the DescribeInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputRequest method.
//    req, resp := client.DescribeInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInputRequest(input *DescribeInputInput) (req *request.Request, output *DescribeInputOutput) {
	op := &request.Operation{
		Name:       opDescribeInput,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DescribeInputInput{}
	}

	output = &DescribeInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInput API operation for AWS Elemental MediaLive.
//
// Produces details about an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInput(input *DescribeInputInput) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	return out, req.Send()
}

// DescribeInputWithContext is the same as DescribeInput with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputWithContext(ctx aws.Context, input *DescribeInputInput, opts ...request.Option) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputDevice = "DescribeInputDevice"

// DescribeInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputDevice for more information on using the DescribeInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputDeviceRequest method.
//    req, resp := client.DescribeInputDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice
func (c *MediaLive) DescribeInputDeviceRequest(input *DescribeInputDeviceInput) (req *request.Request, output *DescribeInputDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeInputDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}",
	}

	if input == nil {
		input = &DescribeInputDeviceInput{}
	}

	output = &DescribeInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputDevice API operation for AWS Elemental MediaLive.
//
// Gets the details for the input device
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputDevice for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice
func (c *MediaLive) DescribeInputDevice(input *DescribeInputDeviceInput) (*DescribeInputDeviceOutput, error) {
	req, out := c.DescribeInputDeviceRequest(input)
	return out, req.Send()
}

// DescribeInputDeviceWithContext is the same as DescribeInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputDeviceWithContext(ctx aws.Context, input *DescribeInputDeviceInput, opts ...request.Option) (*DescribeInputDeviceOutput, error) {
	req, out := c.DescribeInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputDeviceThumbnail = "DescribeInputDeviceThumbnail"

// DescribeInputDeviceThumbnailRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputDeviceThumbnail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputDeviceThumbnail for more information on using the DescribeInputDeviceThumbnail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputDeviceThumbnailRequest method.
//    req, resp := client.DescribeInputDeviceThumbnailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail
func (c *MediaLive) DescribeInputDeviceThumbnailRequest(input *DescribeInputDeviceThumbnailInput) (req *request.Request, output *DescribeInputDeviceThumbnailOutput) {
	op := &request.Operation{
		Name:       opDescribeInputDeviceThumbnail,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/thumbnailData",
	}

	if input == nil {
		input = &DescribeInputDeviceThumbnailInput{}
	}

	output = &DescribeInputDeviceThumbnailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputDeviceThumbnail API operation for AWS Elemental MediaLive.
//
// Get the latest thumbnail data for the input device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputDeviceThumbnail for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail
func (c *MediaLive) DescribeInputDeviceThumbnail(input *DescribeInputDeviceThumbnailInput) (*DescribeInputDeviceThumbnailOutput, error) {
	req, out := c.DescribeInputDeviceThumbnailRequest(input)
	return out, req.Send()
}

// DescribeInputDeviceThumbnailWithContext is the same as DescribeInputDeviceThumbnail with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputDeviceThumbnail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputDeviceThumbnailWithContext(ctx aws.Context, input *DescribeInputDeviceThumbnailInput, opts ...request.Option) (*DescribeInputDeviceThumbnailOutput, error) {
	req, out := c.DescribeInputDeviceThumbnailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputSecurityGroup = "DescribeInputSecurityGroup"

// DescribeInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputSecurityGroup for more information on using the DescribeInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputSecurityGroupRequest method.
//    req, resp := client.DescribeInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroupRequest(input *DescribeInputSecurityGroupInput) (req *request.Request, output *DescribeInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeInputSecurityGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DescribeInputSecurityGroupInput{}
	}

	output = &DescribeInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Produces a summary of an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroup(input *DescribeInputSecurityGroupInput) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DescribeInputSecurityGroupWithContext is the same as DescribeInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputSecurityGroupWithContext(ctx aws.Context, input *DescribeInputSecurityGroupInput, opts ...request.Option) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMultiplex = "DescribeMultiplex"

// DescribeMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMultiplex for more information on using the DescribeMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMultiplexRequest method.
//    req, resp := client.DescribeMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex
func (c *MediaLive) DescribeMultiplexRequest(input *DescribeMultiplexInput) (req *request.Request, output *DescribeMultiplexOutput) {
	op := &request.Operation{
		Name:       opDescribeMultiplex,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &DescribeMultiplexInput{}
	}

	output = &DescribeMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMultiplex API operation for AWS Elemental MediaLive.
//
// Gets details about a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex
func (c *MediaLive) DescribeMultiplex(input *DescribeMultiplexInput) (*DescribeMultiplexOutput, error) {
	req, out := c.DescribeMultiplexRequest(input)
	return out, req.Send()
}

// DescribeMultiplexWithContext is the same as DescribeMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeMultiplexWithContext(ctx aws.Context, input *DescribeMultiplexInput, opts ...request.Option) (*DescribeMultiplexOutput, error) {
	req, out := c.DescribeMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMultiplexProgram = "DescribeMultiplexProgram"

// DescribeMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMultiplexProgram for more information on using the DescribeMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMultiplexProgramRequest method.
//    req, resp := client.DescribeMultiplexProgramRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram
func (c *MediaLive) DescribeMultiplexProgramRequest(input *DescribeMultiplexProgramInput) (req *request.Request, output *DescribeMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opDescribeMultiplexProgram,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &DescribeMultiplexProgramInput{}
	}

	output = &DescribeMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Get the details for a program in a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeMultiplexProgram for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram
func (c *MediaLive) DescribeMultiplexProgram(input *DescribeMultiplexProgramInput) (*DescribeMultiplexProgramOutput, error) {
	req, out := c.DescribeMultiplexProgramRequest(input)
	return out, req.Send()
}

// DescribeMultiplexProgramWithContext is the same as DescribeMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeMultiplexProgramWithContext(ctx aws.Context, input *DescribeMultiplexProgramInput, opts ...request.Option) (*DescribeMultiplexProgramOutput, error) {
	req, out := c.DescribeMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOffering = "DescribeOffering"

// DescribeOfferingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOffering for more information on using the DescribeOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOfferingRequest method.
//    req, resp := client.DescribeOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering
func (c *MediaLive) DescribeOfferingRequest(input *DescribeOfferingInput) (req *request.Request, output *DescribeOfferingOutput) {
	op := &request.Operation{
		Name:       opDescribeOffering,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/offerings/{offeringId}",
	}

	if input == nil {
		input = &DescribeOfferingInput{}
	}

	output = &DescribeOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOffering API operation for AWS Elemental MediaLive.
//
// Get details for an offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeOffering for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering
func (c *MediaLive) DescribeOffering(input *DescribeOfferingInput) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	return out, req.Send()
}

// DescribeOfferingWithContext is the same as DescribeOffering with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeOfferingWithContext(ctx aws.Context, input *DescribeOfferingInput, opts ...request.Option) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservation = "DescribeReservation"

// DescribeReservationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservation for more information on using the DescribeReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservationRequest method.
//    req, resp := client.DescribeReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation
func (c *MediaLive) DescribeReservationRequest(input *DescribeReservationInput) (req *request.Request, output *DescribeReservationOutput) {
	op := &request.Operation{
		Name:       opDescribeReservation,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &DescribeReservationInput{}
	}

	output = &DescribeReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservation API operation for AWS Elemental MediaLive.
//
// Get details for a reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeReservation for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation
func (c *MediaLive) DescribeReservation(input *DescribeReservationInput) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	return out, req.Send()
}

// DescribeReservationWithContext is the same as DescribeReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeReservationWithContext(ctx aws.Context, input *DescribeReservationInput, opts ...request.Option) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchedule = "DescribeSchedule"

// DescribeScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchedule for more information on using the DescribeSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduleRequest method.
//    req, resp := client.DescribeScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule
func (c *MediaLive) DescribeScheduleRequest(input *DescribeScheduleInput) (req *request.Request, output *DescribeScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduleInput{}
	}

	output = &DescribeScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchedule API operation for AWS Elemental MediaLive.
//
// Get a channel schedule
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeSchedule for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule
func (c *MediaLive) DescribeSchedule(input *DescribeScheduleInput) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	return out, req.Send()
}

// DescribeScheduleWithContext is the same as DescribeSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeScheduleWithContext(ctx aws.Context, input *DescribeScheduleInput, opts ...request.Option) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSchedulePages iterates over the pages of a DescribeSchedule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSchedule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSchedule operation.
//    pageNum := 0
//    err := client.DescribeSchedulePages(params,
//        func(page *medialive.DescribeScheduleOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) DescribeSchedulePages(input *DescribeScheduleInput, fn func(*DescribeScheduleOutput, bool) bool) error {
	return c.DescribeSchedulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSchedulePagesWithContext same as DescribeSchedulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeSchedulePagesWithContext(ctx aws.Context, input *DescribeScheduleInput, fn func(*DescribeScheduleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS Elemental MediaLive.
//
// Produces list of channels that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *medialive.ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputDevices = "ListInputDevices"

// ListInputDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListInputDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputDevices for more information on using the ListInputDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputDevicesRequest method.
//    req, resp := client.ListInputDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices
func (c *MediaLive) ListInputDevicesRequest(input *ListInputDevicesInput) (req *request.Request, output *ListInputDevicesOutput) {
	op := &request.Operation{
		Name:       opListInputDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputDevicesInput{}
	}

	output = &ListInputDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputDevices API operation for AWS Elemental MediaLive.
//
// List input devices
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputDevices for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices
func (c *MediaLive) ListInputDevices(input *ListInputDevicesInput) (*ListInputDevicesOutput, error) {
	req, out := c.ListInputDevicesRequest(input)
	return out, req.Send()
}

// ListInputDevicesWithContext is the same as ListInputDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDevicesWithContext(ctx aws.Context, input *ListInputDevicesInput, opts ...request.Option) (*ListInputDevicesOutput, error) {
	req, out := c.ListInputDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputDevicesPages iterates over the pages of a ListInputDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInputDevices operation.
//    pageNum := 0
//    err := client.ListInputDevicesPages(params,
//        func(page *medialive.ListInputDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListInputDevicesPages(input *ListInputDevicesInput, fn func(*ListInputDevicesOutput, bool) bool) error {
	return c.ListInputDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputDevicesPagesWithContext same as ListInputDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDevicesPagesWithContext(ctx aws.Context, input *ListInputDevicesInput, fn func(*ListInputDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputSecurityGroups = "ListInputSecurityGroups"

// ListInputSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputSecurityGroups for more information on using the ListInputSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputSecurityGroupsRequest method.
//    req, resp := client.ListInputSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroupsRequest(input *ListInputSecurityGroupsInput) (req *request.Request, output *ListInputSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opListInputSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputSecurityGroupsInput{}
	}

	output = &ListInputSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputSecurityGroups API operation for AWS Elemental MediaLive.
//
// Produces a list of Input Security Groups for an account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputSecurityGroups for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroups(input *ListInputSecurityGroupsInput) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	return out, req.Send()
}

// ListInputSecurityGroupsWithContext is the same as ListInputSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, opts ...request.Option) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputSecurityGroupsPages iterates over the pages of a ListInputSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInputSecurityGroups operation.
//    pageNum := 0
//    err := client.ListInputSecurityGroupsPages(params,
//        func(page *medialive.ListInputSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListInputSecurityGroupsPages(input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool) error {
	return c.ListInputSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputSecurityGroupsPagesWithContext same as ListInputSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsPagesWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputs = "ListInputs"

// ListInputsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputs for more information on using the ListInputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputsRequest method.
//    req, resp := client.ListInputsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputsRequest(input *ListInputsInput) (req *request.Request, output *ListInputsOutput) {
	op := &request.Operation{
		Name:       opListInputs,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputsInput{}
	}

	output = &ListInputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputs API operation for AWS Elemental MediaLive.
//
// Produces list of inputs that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputs(input *ListInputsInput) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	return out, req.Send()
}

// ListInputsWithContext is the same as ListInputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsWithContext(ctx aws.Context, input *ListInputsInput, opts ...request.Option) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputsPages iterates over the pages of a ListInputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInputs operation.
//    pageNum := 0
//    err := client.ListInputsPages(params,
//        func(page *medialive.ListInputsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListInputsPages(input *ListInputsInput, fn func(*ListInputsOutput, bool) bool) error {
	return c.ListInputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputsPagesWithContext same as ListInputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsPagesWithContext(ctx aws.Context, input *ListInputsInput, fn func(*ListInputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultiplexPrograms = "ListMultiplexPrograms"

// ListMultiplexProgramsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultiplexPrograms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultiplexPrograms for more information on using the ListMultiplexPrograms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMultiplexProgramsRequest method.
//    req, resp := client.ListMultiplexProgramsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms
func (c *MediaLive) ListMultiplexProgramsRequest(input *ListMultiplexProgramsInput) (req *request.Request, output *ListMultiplexProgramsOutput) {
	op := &request.Operation{
		Name:       opListMultiplexPrograms,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiplexProgramsInput{}
	}

	output = &ListMultiplexProgramsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultiplexPrograms API operation for AWS Elemental MediaLive.
//
// List the programs that currently exist for a specific multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListMultiplexPrograms for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms
func (c *MediaLive) ListMultiplexPrograms(input *ListMultiplexProgramsInput) (*ListMultiplexProgramsOutput, error) {
	req, out := c.ListMultiplexProgramsRequest(input)
	return out, req.Send()
}

// ListMultiplexProgramsWithContext is the same as ListMultiplexPrograms with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultiplexPrograms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexProgramsWithContext(ctx aws.Context, input *ListMultiplexProgramsInput, opts ...request.Option) (*ListMultiplexProgramsOutput, error) {
	req, out := c.ListMultiplexProgramsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultiplexProgramsPages iterates over the pages of a ListMultiplexPrograms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultiplexPrograms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultiplexPrograms operation.
//    pageNum := 0
//    err := client.ListMultiplexProgramsPages(params,
//        func(page *medialive.ListMultiplexProgramsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListMultiplexProgramsPages(input *ListMultiplexProgramsInput, fn func(*ListMultiplexProgramsOutput, bool) bool) error {
	return c.ListMultiplexProgramsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultiplexProgramsPagesWithContext same as ListMultiplexProgramsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexProgramsPagesWithContext(ctx aws.Context, input *ListMultiplexProgramsInput, fn func(*ListMultiplexProgramsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultiplexProgramsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultiplexProgramsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultiplexProgramsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultiplexes = "ListMultiplexes"

// ListMultiplexesRequest generates a "aws/request.Request" representing the
// client's request for the ListMultiplexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultiplexes for more information on using the ListMultiplexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMultiplexesRequest method.
//    req, resp := client.ListMultiplexesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes
func (c *MediaLive) ListMultiplexesRequest(input *ListMultiplexesInput) (req *request.Request, output *ListMultiplexesOutput) {
	op := &request.Operation{
		Name:       opListMultiplexes,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiplexesInput{}
	}

	output = &ListMultiplexesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultiplexes API operation for AWS Elemental MediaLive.
//
// Retrieve a list of the existing multiplexes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListMultiplexes for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes
func (c *MediaLive) ListMultiplexes(input *ListMultiplexesInput) (*ListMultiplexesOutput, error) {
	req, out := c.ListMultiplexesRequest(input)
	return out, req.Send()
}

// ListMultiplexesWithContext is the same as ListMultiplexes with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultiplexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexesWithContext(ctx aws.Context, input *ListMultiplexesInput, opts ...request.Option) (*ListMultiplexesOutput, error) {
	req, out := c.ListMultiplexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultiplexesPages iterates over the pages of a ListMultiplexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultiplexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultiplexes operation.
//    pageNum := 0
//    err := client.ListMultiplexesPages(params,
//        func(page *medialive.ListMultiplexesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListMultiplexesPages(input *ListMultiplexesInput, fn func(*ListMultiplexesOutput, bool) bool) error {
	return c.ListMultiplexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultiplexesPagesWithContext same as ListMultiplexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexesPagesWithContext(ctx aws.Context, input *ListMultiplexesInput, fn func(*ListMultiplexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultiplexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultiplexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultiplexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOfferings = "ListOfferings"

// ListOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferings for more information on using the ListOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOfferingsRequest method.
//    req, resp := client.ListOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings
func (c *MediaLive) ListOfferingsRequest(input *ListOfferingsInput) (req *request.Request, output *ListOfferingsOutput) {
	op := &request.Operation{
		Name:       opListOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/offerings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingsInput{}
	}

	output = &ListOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferings API operation for AWS Elemental MediaLive.
//
// List offerings available for purchase.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListOfferings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings
func (c *MediaLive) ListOfferings(input *ListOfferingsInput) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	return out, req.Send()
}

// ListOfferingsWithContext is the same as ListOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListOfferingsWithContext(ctx aws.Context, input *ListOfferingsInput, opts ...request.Option) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOfferingsPages iterates over the pages of a ListOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOfferings operation.
//    pageNum := 0
//    err := client.ListOfferingsPages(params,
//        func(page *medialive.ListOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListOfferingsPages(input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool) error {
	return c.ListOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOfferingsPagesWithContext same as ListOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListOfferingsPagesWithContext(ctx aws.Context, input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReservations = "ListReservations"

// ListReservationsRequest generates a "aws/request.Request" representing the
// client's request for the ListReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReservations for more information on using the ListReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReservationsRequest method.
//    req, resp := client.ListReservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations
func (c *MediaLive) ListReservationsRequest(input *ListReservationsInput) (req *request.Request, output *ListReservationsOutput) {
	op := &request.Operation{
		Name:       opListReservations,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/reservations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReservationsInput{}
	}

	output = &ListReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReservations API operation for AWS Elemental MediaLive.
//
// List purchased reservations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListReservations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations
func (c *MediaLive) ListReservations(input *ListReservationsInput) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	return out, req.Send()
}

// ListReservationsWithContext is the same as ListReservations with the addition of
// the ability to pass a context and additional request options.
//
// See ListReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListReservationsWithContext(ctx aws.Context, input *ListReservationsInput, opts ...request.Option) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReservationsPages iterates over the pages of a ListReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListReservations operation.
//    pageNum := 0
//    err := client.ListReservationsPages(params,
//        func(page *medialive.ListReservationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListReservationsPages(input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool) error {
	return c.ListReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReservationsPagesWithContext same as ListReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListReservationsPagesWithContext(ctx aws.Context, input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource
func (c *MediaLive) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaLive.
//
// Produces list of tags that have been created for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource
func (c *MediaLive) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseOffering for more information on using the PurchaseOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseOfferingRequest method.
//    req, resp := client.PurchaseOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering
func (c *MediaLive) PurchaseOfferingRequest(input *PurchaseOfferingInput) (req *request.Request, output *PurchaseOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/offerings/{offeringId}/purchase",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	output = &PurchaseOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseOffering API operation for AWS Elemental MediaLive.
//
// Purchase an offering and create a reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation PurchaseOffering for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering
func (c *MediaLive) PurchaseOffering(input *PurchaseOfferingInput) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	return out, req.Send()
}

// PurchaseOfferingWithContext is the same as PurchaseOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) PurchaseOfferingWithContext(ctx aws.Context, input *PurchaseOfferingInput, opts ...request.Option) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartChannel = "StartChannel"

// StartChannelRequest generates a "aws/request.Request" representing the
// client's request for the StartChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChannel for more information on using the StartChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartChannelRequest method.
//    req, resp := client.StartChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannelRequest(input *StartChannelInput) (req *request.Request, output *StartChannelOutput) {
	op := &request.Operation{
		Name:       opStartChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/start",
	}

	if input == nil {
		input = &StartChannelInput{}
	}

	output = &StartChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChannel API operation for AWS Elemental MediaLive.
//
// Starts an existing channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannel(input *StartChannelInput) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	return out, req.Send()
}

// StartChannelWithContext is the same as StartChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StartChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartChannelWithContext(ctx aws.Context, input *StartChannelInput, opts ...request.Option) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMultiplex = "StartMultiplex"

// StartMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the StartMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMultiplex for more information on using the StartMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMultiplexRequest method.
//    req, resp := client.StartMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex
func (c *MediaLive) StartMultiplexRequest(input *StartMultiplexInput) (req *request.Request, output *StartMultiplexOutput) {
	op := &request.Operation{
		Name:       opStartMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/start",
	}

	if input == nil {
		input = &StartMultiplexInput{}
	}

	output = &StartMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMultiplex API operation for AWS Elemental MediaLive.
//
// Start (run) the multiplex. Starting the multiplex does not start the channels.
// You must explicitly start each channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex
func (c *MediaLive) StartMultiplex(input *StartMultiplexInput) (*StartMultiplexOutput, error) {
	req, out := c.StartMultiplexRequest(input)
	return out, req.Send()
}

// StartMultiplexWithContext is the same as StartMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See StartMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartMultiplexWithContext(ctx aws.Context, input *StartMultiplexInput, opts ...request.Option) (*StartMultiplexOutput, error) {
	req, out := c.StartMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopChannel = "StopChannel"

// StopChannelRequest generates a "aws/request.Request" representing the
// client's request for the StopChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopChannel for more information on using the StopChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopChannelRequest method.
//    req, resp := client.StopChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannelRequest(input *StopChannelInput) (req *request.Request, output *StopChannelOutput) {
	op := &request.Operation{
		Name:       opStopChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/stop",
	}

	if input == nil {
		input = &StopChannelInput{}
	}

	output = &StopChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopChannel API operation for AWS Elemental MediaLive.
//
// Stops a running channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannel(input *StopChannelInput) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	return out, req.Send()
}

// StopChannelWithContext is the same as StopChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StopChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopChannelWithContext(ctx aws.Context, input *StopChannelInput, opts ...request.Option) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMultiplex = "StopMultiplex"

// StopMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the StopMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMultiplex for more information on using the StopMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMultiplexRequest method.
//    req, resp := client.StopMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex
func (c *MediaLive) StopMultiplexRequest(input *StopMultiplexInput) (req *request.Request, output *StopMultiplexOutput) {
	op := &request.Operation{
		Name:       opStopMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/stop",
	}

	if input == nil {
		input = &StopMultiplexInput{}
	}

	output = &StopMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopMultiplex API operation for AWS Elemental MediaLive.
//
// Stops a running multiplex. If the multiplex isn't running, this action has
// no effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex
func (c *MediaLive) StopMultiplex(input *StopMultiplexInput) (*StopMultiplexOutput, error) {
	req, out := c.StopMultiplexRequest(input)
	return out, req.Send()
}

// StopMultiplexWithContext is the same as StopMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See StopMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopMultiplexWithContext(ctx aws.Context, input *StopMultiplexInput, opts ...request.Option) (*StopMultiplexOutput, error) {
	req, out := c.StopMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS Elemental MediaLive.
//
// Updates a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * GatewayTimeoutException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelClass = "UpdateChannelClass"

// UpdateChannelClassRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelClass operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelClass for more information on using the UpdateChannelClass
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelClassRequest method.
//    req, resp := client.UpdateChannelClassRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass
func (c *MediaLive) UpdateChannelClassRequest(input *UpdateChannelClassInput) (req *request.Request, output *UpdateChannelClassOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelClass,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}/channelClass",
	}

	if input == nil {
		input = &UpdateChannelClassInput{}
	}

	output = &UpdateChannelClassOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelClass API operation for AWS Elemental MediaLive.
//
// Changes the class of the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateChannelClass for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass
func (c *MediaLive) UpdateChannelClass(input *UpdateChannelClassInput) (*UpdateChannelClassOutput, error) {
	req, out := c.UpdateChannelClassRequest(input)
	return out, req.Send()
}

// UpdateChannelClassWithContext is the same as UpdateChannelClass with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelClass for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateChannelClassWithContext(ctx aws.Context, input *UpdateChannelClassInput, opts ...request.Option) (*UpdateChannelClassOutput, error) {
	req, out := c.UpdateChannelClassRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInput = "UpdateInput"

// UpdateInputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInput for more information on using the UpdateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputRequest method.
//    req, resp := client.UpdateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInputRequest(input *UpdateInputInput) (req *request.Request, output *UpdateInputOutput) {
	op := &request.Operation{
		Name:       opUpdateInput,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &UpdateInputInput{}
	}

	output = &UpdateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInput API operation for AWS Elemental MediaLive.
//
// Updates an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInput(input *UpdateInputInput) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	return out, req.Send()
}

// UpdateInputWithContext is the same as UpdateInput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputWithContext(ctx aws.Context, input *UpdateInputInput, opts ...request.Option) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInputDevice = "UpdateInputDevice"

// UpdateInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInputDevice for more information on using the UpdateInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputDeviceRequest method.
//    req, resp := client.UpdateInputDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice
func (c *MediaLive) UpdateInputDeviceRequest(input *UpdateInputDeviceInput) (req *request.Request, output *UpdateInputDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateInputDevice,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}",
	}

	if input == nil {
		input = &UpdateInputDeviceInput{}
	}

	output = &UpdateInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInputDevice API operation for AWS Elemental MediaLive.
//
// Updates the parameters for the input device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInputDevice for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice
func (c *MediaLive) UpdateInputDevice(input *UpdateInputDeviceInput) (*UpdateInputDeviceOutput, error) {
	req, out := c.UpdateInputDeviceRequest(input)
	return out, req.Send()
}

// UpdateInputDeviceWithContext is the same as UpdateInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputDeviceWithContext(ctx aws.Context, input *UpdateInputDeviceInput, opts ...request.Option) (*UpdateInputDeviceOutput, error) {
	req, out := c.UpdateInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInputSecurityGroup = "UpdateInputSecurityGroup"

// UpdateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInputSecurityGroup for more information on using the UpdateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputSecurityGroupRequest method.
//    req, resp := client.UpdateInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroupRequest(input *UpdateInputSecurityGroupInput) (req *request.Request, output *UpdateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateInputSecurityGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &UpdateInputSecurityGroupInput{}
	}

	output = &UpdateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Update an Input Security Group's Whilelists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroup(input *UpdateInputSecurityGroupInput) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// UpdateInputSecurityGroupWithContext is the same as UpdateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputSecurityGroupWithContext(ctx aws.Context, input *UpdateInputSecurityGroupInput, opts ...request.Option) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMultiplex = "UpdateMultiplex"

// UpdateMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMultiplex for more information on using the UpdateMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMultiplexRequest method.
//    req, resp := client.UpdateMultiplexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex
func (c *MediaLive) UpdateMultiplexRequest(input *UpdateMultiplexInput) (req *request.Request, output *UpdateMultiplexOutput) {
	op := &request.Operation{
		Name:       opUpdateMultiplex,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &UpdateMultiplexInput{}
	}

	output = &UpdateMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMultiplex API operation for AWS Elemental MediaLive.
//
// Updates a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateMultiplex for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex
func (c *MediaLive) UpdateMultiplex(input *UpdateMultiplexInput) (*UpdateMultiplexOutput, error) {
	req, out := c.UpdateMultiplexRequest(input)
	return out, req.Send()
}

// UpdateMultiplexWithContext is the same as UpdateMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateMultiplexWithContext(ctx aws.Context, input *UpdateMultiplexInput, opts ...request.Option) (*UpdateMultiplexOutput, error) {
	req, out := c.UpdateMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMultiplexProgram = "UpdateMultiplexProgram"

// UpdateMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMultiplexProgram for more information on using the UpdateMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMultiplexProgramRequest method.
//    req, resp := client.UpdateMultiplexProgramRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram
func (c *MediaLive) UpdateMultiplexProgramRequest(input *UpdateMultiplexProgramInput) (req *request.Request, output *UpdateMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opUpdateMultiplexProgram,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &UpdateMultiplexProgramInput{}
	}

	output = &UpdateMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Update a program in a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateMultiplexProgram for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram
func (c *MediaLive) UpdateMultiplexProgram(input *UpdateMultiplexProgramInput) (*UpdateMultiplexProgramOutput, error) {
	req, out := c.UpdateMultiplexProgramRequest(input)
	return out, req.Send()
}

// UpdateMultiplexProgramWithContext is the same as UpdateMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateMultiplexProgramWithContext(ctx aws.Context, input *UpdateMultiplexProgramInput, opts ...request.Option) (*UpdateMultiplexProgramOutput, error) {
	req, out := c.UpdateMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReservation = "UpdateReservation"

// UpdateReservationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReservation for more information on using the UpdateReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReservationRequest method.
//    req, resp := client.UpdateReservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation
func (c *MediaLive) UpdateReservationRequest(input *UpdateReservationInput) (req *request.Request, output *UpdateReservationOutput) {
	op := &request.Operation{
		Name:       opUpdateReservation,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &UpdateReservationInput{}
	}

	output = &UpdateReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReservation API operation for AWS Elemental MediaLive.
//
// Update reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateReservation for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * BadGatewayException
//
//   * NotFoundException
//
//   * GatewayTimeoutException
//
//   * TooManyRequestsException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation
func (c *MediaLive) UpdateReservation(input *UpdateReservationInput) (*UpdateReservationOutput, error) {
	req, out := c.UpdateReservationRequest(input)
	return out, req.Send()
}

// UpdateReservationWithContext is the same as UpdateReservation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateReservationWithContext(ctx aws.Context, input *UpdateReservationInput, opts ...request.Option) (*UpdateReservationOutput, error) {
	req, out := c.UpdateReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Aac Settings
type AacSettings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid values depend on rate control mode
	// and profile.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
	// mode and profile. The adReceiverMix setting receives a stereo description
	// plus control track and emits a mono AAC encode of the description track,
	// with control data emitted in the PES header as per ETSI TS 101 154 Annex
	// E.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"AacCodingMode"`

	// Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD
	// (narration) as a stereo pair. The Audio Type field (audioType) will be set
	// to 3, which signals to downstream systems that this stream contains "broadcaster
	// mixed AD". Note that the input received by the encoder must contain pre-mixed
	// audio; the encoder does not perform the mixing. The values in audioTypeControl
	// and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.Leave
	// set to "normal" when input does not contain pre-mixed audio + AD.
	InputType *string `locationName:"inputType" type:"string" enum:"AacInputType"`

	// AAC Profile.
	Profile *string `locationName:"profile" type:"string" enum:"AacProfile"`

	// Rate Control Mode.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"AacRateControlMode"`

	// Sets LATM / LOAS AAC output for raw containers.
	RawFormat *string `locationName:"rawFormat" type:"string" enum:"AacRawFormat"`

	// Sample rate in Hz. Valid values depend on rate control mode and profile.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`

	// Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport
	// Stream containers.
	Spec *string `locationName:"spec" type:"string" enum:"AacSpec"`

	// VBR Quality Level - Only used if rateControlMode is VBR.
	VbrQuality *string `locationName:"vbrQuality" type:"string" enum:"AacVbrQuality"`
}

// String returns the string representation
func (s AacSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AacSettings) GoString() string {
	return s.String()
}

// SetBitrate sets the Bitrate field's value.
func (s *AacSettings) SetBitrate(v float64) *AacSettings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *AacSettings) SetCodingMode(v string) *AacSettings {
	s.CodingMode = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *AacSettings) SetInputType(v string) *AacSettings {
	s.InputType = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *AacSettings) SetProfile(v string) *AacSettings {
	s.Profile = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *AacSettings) SetRateControlMode(v string) *AacSettings {
	s.RateControlMode = &v
	return s
}

// SetRawFormat sets the RawFormat field's value.
func (s *AacSettings) SetRawFormat(v string) *AacSettings {
	s.RawFormat = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AacSettings) SetSampleRate(v float64) *AacSettings {
	s.SampleRate = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *AacSettings) SetSpec(v string) *AacSettings {
	s.Spec = &v
	return s
}

// SetVbrQuality sets the VbrQuality field's value.
func (s *AacSettings) SetVbrQuality(v string) *AacSettings {
	s.VbrQuality = &v
	return s
}

// Ac3 Settings
type Ac3Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC
	// A/52-2012 for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Ac3BitstreamMode"`

	// Dolby Digital coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Ac3CodingMode"`

	// Sets the dialnorm for the output. If excluded and input audio is Dolby Digital,
	// dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// If set to filmStandard, adds dynamic range compression signaling to the output
	// bitstream as defined in the Dolby Digital specification.
	DrcProfile *string `locationName:"drcProfile" type:"string" enum:"Ac3DrcProfile"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid in codingMode32Lfe mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Ac3LfeFilter"`

	// When set to "followInput", encoder metadata will be sourced from the DD,
	// DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Ac3MetadataControl"`
}

// String returns the string representation
func (s Ac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitrate sets the Bitrate field's value.
func (s *Ac3Settings) SetBitrate(v float64) *Ac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Ac3Settings) SetBitstreamMode(v string) *Ac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Ac3Settings) SetCodingMode(v string) *Ac3Settings {
	s.CodingMode = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Ac3Settings) SetDialnorm(v int64) *Ac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcProfile sets the DrcProfile field's value.
func (s *Ac3Settings) SetDrcProfile(v string) *Ac3Settings {
	s.DrcProfile = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Ac3Settings) SetLfeFilter(v string) *Ac3Settings {
	s.LfeFilter = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Ac3Settings) SetMetadataControl(v string) *Ac3Settings {
	s.MetadataControl = &v
	return s
}

// Archive Container Settings
type ArchiveContainerSettings struct {
	_ struct{} `type:"structure"`

	// M2ts Settings
	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s ArchiveContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveContainerSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveContainerSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetM2tsSettings sets the M2tsSettings field's value.
func (s *ArchiveContainerSettings) SetM2tsSettings(v *M2tsSettings) *ArchiveContainerSettings {
	s.M2tsSettings = v
	return s
}

// Archive Group Settings
type ArchiveGroupSettings struct {
	_ struct{} `type:"structure"`

	// A directory and base filename where archive files should be written.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of seconds to write to archive file before closing and starting a
	// new one.
	RolloverInterval *int64 `locationName:"rolloverInterval" min:"1" type:"integer"`
}

// String returns the string representation
func (s ArchiveGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.RolloverInterval != nil && *s.RolloverInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RolloverInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ArchiveGroupSettings) SetDestination(v *OutputLocationRef) *ArchiveGroupSettings {
	s.Destination = v
	return s
}

// SetRolloverInterval sets the RolloverInterval field's value.
func (s *ArchiveGroupSettings) SetRolloverInterval(v int64) *ArchiveGroupSettings {
	s.RolloverInterval = &v
	return s
}

// Archive Output Settings
type ArchiveOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings specific to the container type of the file.
	//
	// ContainerSettings is a required field
	ContainerSettings *ArchiveContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Output file extension. If excluded, this will be auto-selected from the container
	// type.
	Extension *string `locationName:"extension" type:"string"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s ArchiveOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveOutputSettings"}
	if s.ContainerSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerSettings"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerSettings sets the ContainerSettings field's value.
func (s *ArchiveOutputSettings) SetContainerSettings(v *ArchiveContainerSettings) *ArchiveOutputSettings {
	s.ContainerSettings = v
	return s
}

// SetExtension sets the Extension field's value.
func (s *ArchiveOutputSettings) SetExtension(v string) *ArchiveOutputSettings {
	s.Extension = &v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *ArchiveOutputSettings) SetNameModifier(v string) *ArchiveOutputSettings {
	s.NameModifier = &v
	return s
}

// Arib Destination Settings
type AribDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AribDestinationSettings) GoString() string {
	return s.String()
}

// Arib Source Settings
type AribSourceSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AribSourceSettings) GoString() string {
	return s.String()
}

// Audio Channel Mapping
type AudioChannelMapping struct {
	_ struct{} `type:"structure"`

	// Indices and gain values for each input channel that should be remixed into
	// this output channel.
	//
	// InputChannelLevels is a required field
	InputChannelLevels []*InputChannelLevel `locationName:"inputChannelLevels" type:"list" required:"true"`

	// The index of the output channel being produced.
	//
	// OutputChannel is a required field
	OutputChannel *int64 `locationName:"outputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioChannelMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioChannelMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioChannelMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioChannelMapping"}
	if s.InputChannelLevels == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannelLevels"))
	}
	if s.OutputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputChannel"))
	}
	if s.InputChannelLevels != nil {
		for i, v := range s.InputChannelLevels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputChannelLevels", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputChannelLevels sets the InputChannelLevels field's value.
func (s *AudioChannelMapping) SetInputChannelLevels(v []*InputChannelLevel) *AudioChannelMapping {
	s.InputChannelLevels = v
	return s
}

// SetOutputChannel sets the OutputChannel field's value.
func (s *AudioChannelMapping) SetOutputChannel(v int64) *AudioChannelMapping {
	s.OutputChannel = &v
	return s
}

// Audio Codec Settings
type AudioCodecSettings struct {
	_ struct{} `type:"structure"`

	// Aac Settings
	AacSettings *AacSettings `locationName:"aacSettings" type:"structure"`

	// Ac3 Settings
	Ac3Settings *Ac3Settings `locationName:"ac3Settings" type:"structure"`

	// Eac3 Settings
	Eac3Settings *Eac3Settings `locationName:"eac3Settings" type:"structure"`

	// Mp2 Settings
	Mp2Settings *Mp2Settings `locationName:"mp2Settings" type:"structure"`

	// Pass Through Settings
	PassThroughSettings *PassThroughSettings `locationName:"passThroughSettings" type:"structure"`
}

// String returns the string representation
func (s AudioCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioCodecSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioCodecSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioCodecSettings"}
	if s.Ac3Settings != nil {
		if err := s.Ac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Ac3Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Eac3Settings != nil {
		if err := s.Eac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Eac3Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAacSettings sets the AacSettings field's value.
func (s *AudioCodecSettings) SetAacSettings(v *AacSettings) *AudioCodecSettings {
	s.AacSettings = v
	return s
}

// SetAc3Settings sets the Ac3Settings field's value.
func (s *AudioCodecSettings) SetAc3Settings(v *Ac3Settings) *AudioCodecSettings {
	s.Ac3Settings = v
	return s
}

// SetEac3Settings sets the Eac3Settings field's value.
func (s *AudioCodecSettings) SetEac3Settings(v *Eac3Settings) *AudioCodecSettings {
	s.Eac3Settings = v
	return s
}

// SetMp2Settings sets the Mp2Settings field's value.
func (s *AudioCodecSettings) SetMp2Settings(v *Mp2Settings) *AudioCodecSettings {
	s.Mp2Settings = v
	return s
}

// SetPassThroughSettings sets the PassThroughSettings field's value.
func (s *AudioCodecSettings) SetPassThroughSettings(v *PassThroughSettings) *AudioCodecSettings {
	s.PassThroughSettings = v
	return s
}

// Audio Description
type AudioDescription struct {
	_ struct{} `type:"structure"`

	// Advanced audio normalization settings.
	AudioNormalizationSettings *AudioNormalizationSettings `locationName:"audioNormalizationSettings" type:"structure"`

	// The name of the AudioSelector used as the source for this AudioDescription.
	//
	// AudioSelectorName is a required field
	AudioSelectorName *string `locationName:"audioSelectorName" type:"string" required:"true"`

	// Applies only if audioTypeControl is useConfigured. The values for audioType
	// are defined in ISO-IEC 13818-1.
	AudioType *string `locationName:"audioType" type:"string" enum:"AudioType"`

	// Determines how audio type is determined. followInput: If the input contains
	// an ISO 639 audioType, then that value is passed through to the output. If
	// the input contains no ISO 639 audioType, the value in Audio Type is included
	// in the output. useConfigured: The value in Audio Type is included in the
	// output.Note that this field and audioType are both ignored if inputType is
	// broadcasterMixedAd.
	AudioTypeControl *string `locationName:"audioTypeControl" type:"string" enum:"AudioDescriptionAudioTypeControl"`

	// Audio codec settings.
	CodecSettings *AudioCodecSettings `locationName:"codecSettings" type:"structure"`

	// RFC 5646 language code representing the language of the audio output track.
	// Only used if languageControlMode is useConfigured, or there is no ISO 639
	// language code specified in the input.
	LanguageCode *string `locationName:"languageCode" min:"1" type:"string"`

	// Choosing followInput will cause the ISO 639 language code of the output to
	// follow the ISO 639 language code of the input. The languageCode will be used
	// when useConfigured is set, or when followInput is selected but there is no
	// ISO 639 language code specified by the input.
	LanguageCodeControl *string `locationName:"languageCodeControl" type:"string" enum:"AudioDescriptionLanguageCodeControl"`

	// The name of this AudioDescription. Outputs will use this name to uniquely
	// identify this AudioDescription. Description names should be unique within
	// this Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Settings that control how input audio channels are remixed into the output
	// audio channels.
	RemixSettings *RemixSettings `locationName:"remixSettings" type:"structure"`

	// Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by
	// the player (eg. English, or Director Commentary).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s AudioDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioDescription"}
	if s.AudioSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioSelectorName"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RemixSettings != nil {
		if err := s.RemixSettings.Validate(); err != nil {
			invalidParams.AddNested("RemixSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioNormalizationSettings sets the AudioNormalizationSettings field's value.
func (s *AudioDescription) SetAudioNormalizationSettings(v *AudioNormalizationSettings) *AudioDescription {
	s.AudioNormalizationSettings = v
	return s
}

// SetAudioSelectorName sets the AudioSelectorName field's value.
func (s *AudioDescription) SetAudioSelectorName(v string) *AudioDescription {
	s.AudioSelectorName = &v
	return s
}

// SetAudioType sets the AudioType field's value.
func (s *AudioDescription) SetAudioType(v string) *AudioDescription {
	s.AudioType = &v
	return s
}

// SetAudioTypeControl sets the AudioTypeControl field's value.
func (s *AudioDescription) SetAudioTypeControl(v string) *AudioDescription {
	s.AudioTypeControl = &v
	return s
}

// SetCodecSettings sets the CodecSettings field's value.
func (s *AudioDescription) SetCodecSettings(v *AudioCodecSettings) *AudioDescription {
	s.CodecSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioDescription) SetLanguageCode(v string) *AudioDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageCodeControl sets the LanguageCodeControl field's value.
func (s *AudioDescription) SetLanguageCodeControl(v string) *AudioDescription {
	s.LanguageCodeControl = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudioDescription) SetName(v string) *AudioDescription {
	s.Name = &v
	return s
}

// SetRemixSettings sets the RemixSettings field's value.
func (s *AudioDescription) SetRemixSettings(v *RemixSettings) *AudioDescription {
	s.RemixSettings = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AudioDescription) SetStreamName(v string) *AudioDescription {
	s.StreamName = &v
	return s
}

// Audio Language Selection
type AudioLanguageSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific three-letter language code from within an audio source.
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" type:"string" required:"true"`

	// When set to "strict", the transport stream demux strictly identifies audio
	// streams by their language descriptor. If a PMT update occurs such that an
	// audio stream matching the initially selected language is no longer present
	// then mute will be encoded until the language returns. If "loose", then on
	// a PMT update the demux will choose another audio stream in the program with
	// the same stream type if it can't find one with the same language.
	LanguageSelectionPolicy *string `locationName:"languageSelectionPolicy" type:"string" enum:"AudioLanguageSelectionPolicy"`
}

// String returns the string representation
func (s AudioLanguageSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioLanguageSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLanguageSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLanguageSelection"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioLanguageSelection) SetLanguageCode(v string) *AudioLanguageSelection {
	s.LanguageCode = &v
	return s
}

// SetLanguageSelectionPolicy sets the LanguageSelectionPolicy field's value.
func (s *AudioLanguageSelection) SetLanguageSelectionPolicy(v string) *AudioLanguageSelection {
	s.LanguageSelectionPolicy = &v
	return s
}

// Audio Normalization Settings
type AudioNormalizationSettings struct {
	_ struct{} `type:"structure"`

	// Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification,
	// itu17702 conforms to the EBU R-128 specification.
	Algorithm *string `locationName:"algorithm" type:"string" enum:"AudioNormalizationAlgorithm"`

	// When set to correctAudio the output audio is corrected using the chosen algorithm.
	// If set to measureOnly, the audio will be measured but not adjusted.
	AlgorithmControl *string `locationName:"algorithmControl" type:"string" enum:"AudioNormalizationAlgorithmControl"`

	// Target LKFS(loudness) to adjust volume to. If no value is entered, a default
	// value will be used according to the chosen algorithm. The CALM Act (1770-1)
	// recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends
	// a target of -23 LKFS.
	TargetLkfs *float64 `locationName:"targetLkfs" type:"double"`
}

// String returns the string representation
func (s AudioNormalizationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioNormalizationSettings) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AudioNormalizationSettings) SetAlgorithm(v string) *AudioNormalizationSettings {
	s.Algorithm = &v
	return s
}

// SetAlgorithmControl sets the AlgorithmControl field's value.
func (s *AudioNormalizationSettings) SetAlgorithmControl(v string) *AudioNormalizationSettings {
	s.AlgorithmControl = &v
	return s
}

// SetTargetLkfs sets the TargetLkfs field's value.
func (s *AudioNormalizationSettings) SetTargetLkfs(v float64) *AudioNormalizationSettings {
	s.TargetLkfs = &v
	return s
}

// Audio Only Hls Settings
type AudioOnlyHlsSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the group to which the audio Rendition belongs.
	AudioGroupId *string `locationName:"audioGroupId" type:"string"`

	// Optional. Specifies the .jpg or .png image to use as the cover art for an
	// audio-only output. We recommend a low bit-size file because the image increases
	// the output audio bandwidth.The image is attached to the audio as an ID3 tag,
	// frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native
	// Frames" standard.
	AudioOnlyImage *InputLocation `locationName:"audioOnlyImage" type:"structure"`

	// Four types of audio-only tracks are supported:Audio-Only Variant StreamThe
	// client can play back this audio-only stream instead of video in low-bandwidth
	// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.Alternate
	// Audio, Auto Select, DefaultAlternate rendition that the client should try
	// to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest
	// with DEFAULT=YES, AUTOSELECT=YESAlternate Audio, Auto Select, Not DefaultAlternate
	// rendition that the client may try to play back by default. Represented as
	// an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YESAlternate
	// Audio, not Auto SelectAlternate rendition that the client will not try to
	// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
	// DEFAULT=NO, AUTOSELECT=NO
	AudioTrackType *string `locationName:"audioTrackType" type:"string" enum:"AudioOnlyHlsTrackType"`

	// Specifies the segment type.
	SegmentType *string `locationName:"segmentType" type:"string" enum:"AudioOnlyHlsSegmentType"`
}

// String returns the string representation
func (s AudioOnlyHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioOnlyHlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioOnlyHlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioOnlyHlsSettings"}
	if s.AudioOnlyImage != nil {
		if err := s.AudioOnlyImage.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioGroupId sets the AudioGroupId field's value.
func (s *AudioOnlyHlsSettings) SetAudioGroupId(v string) *AudioOnlyHlsSettings {
	s.AudioGroupId = &v
	return s
}

// SetAudioOnlyImage sets the AudioOnlyImage field's value.
func (s *AudioOnlyHlsSettings) SetAudioOnlyImage(v *InputLocation) *AudioOnlyHlsSettings {
	s.AudioOnlyImage = v
	return s
}

// SetAudioTrackType sets the AudioTrackType field's value.
func (s *AudioOnlyHlsSettings) SetAudioTrackType(v string) *AudioOnlyHlsSettings {
	s.AudioTrackType = &v
	return s
}

// SetSegmentType sets the SegmentType field's value.
func (s *AudioOnlyHlsSettings) SetSegmentType(v string) *AudioOnlyHlsSettings {
	s.SegmentType = &v
	return s
}

// Audio Pid Selection
type AudioPidSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a source.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioPidSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioPidSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioPidSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioPidSelection"}
	if s.Pid == nil {
		invalidParams.Add(request.NewErrParamRequired("Pid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *AudioPidSelection) SetPid(v int64) *AudioPidSelection {
	s.Pid = &v
	return s
}

// Audio Selector
type AudioSelector struct {
	_ struct{} `type:"structure"`

	// The name of this AudioSelector. AudioDescriptions will use this name to uniquely
	// identify this Selector. Selector names should be unique per input.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The audio selector settings.
	SelectorSettings *AudioSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s AudioSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AudioSelector) SetName(v string) *AudioSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *AudioSelector) SetSelectorSettings(v *AudioSelectorSettings) *AudioSelector {
	s.SelectorSettings = v
	return s
}

// Audio Selector Settings
type AudioSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Audio Language Selection
	AudioLanguageSelection *AudioLanguageSelection `locationName:"audioLanguageSelection" type:"structure"`

	// Audio Pid Selection
	AudioPidSelection *AudioPidSelection `locationName:"audioPidSelection" type:"structure"`

	// Audio Track Selection
	AudioTrackSelection *AudioTrackSelection `locationName:"audioTrackSelection" type:"structure"`
}

// String returns the string representation
func (s AudioSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelectorSettings"}
	if s.AudioLanguageSelection != nil {
		if err := s.AudioLanguageSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioLanguageSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioPidSelection != nil {
		if err := s.AudioPidSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioPidSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioTrackSelection != nil {
		if err := s.AudioTrackSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioTrackSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioLanguageSelection sets the AudioLanguageSelection field's value.
func (s *AudioSelectorSettings) SetAudioLanguageSelection(v *AudioLanguageSelection) *AudioSelectorSettings {
	s.AudioLanguageSelection = v
	return s
}

// SetAudioPidSelection sets the AudioPidSelection field's value.
func (s *AudioSelectorSettings) SetAudioPidSelection(v *AudioPidSelection) *AudioSelectorSettings {
	s.AudioPidSelection = v
	return s
}

// SetAudioTrackSelection sets the AudioTrackSelection field's value.
func (s *AudioSelectorSettings) SetAudioTrackSelection(v *AudioTrackSelection) *AudioSelectorSettings {
	s.AudioTrackSelection = v
	return s
}

// Audio Track
type AudioTrack struct {
	_ struct{} `type:"structure"`

	// 1-based integer value that maps to a specific audio track
	//
	// Track is a required field
	Track *int64 `locationName:"track" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioTrack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioTrack) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioTrack) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioTrack"}
	if s.Track == nil {
		invalidParams.Add(request.NewErrParamRequired("Track"))
	}
	if s.Track != nil && *s.Track < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Track", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrack sets the Track field's value.
func (s *AudioTrack) SetTrack(v int64) *AudioTrack {
	s.Track = &v
	return s
}

// Audio Track Selection
type AudioTrackSelection struct {
	_ struct{} `type:"structure"`

	// Selects one or more unique audio tracks from within an mp4 source.
	//
	// Tracks is a required field
	Tracks []*AudioTrack `locationName:"tracks" type:"list" required:"true"`
}

// String returns the string representation
func (s AudioTrackSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioTrackSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioTrackSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioTrackSelection"}
	if s.Tracks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tracks"))
	}
	if s.Tracks != nil {
		for i, v := range s.Tracks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tracks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTracks sets the Tracks field's value.
func (s *AudioTrackSelection) SetTracks(v []*AudioTrack) *AudioTrackSelection {
	s.Tracks = v
	return s
}

// The settings for Automatic Input Failover.
type AutomaticInputFailoverSettings struct {
	_ struct{} `type:"structure"`

	// Input preference when deciding which input to make active when a previously
	// failed input has recovered.
	InputPreference *string `locationName:"inputPreference" type:"string" enum:"InputPreference"`

	// The input ID of the secondary input in the automatic input failover pair.
	//
	// SecondaryInputId is a required field
	SecondaryInputId *string `locationName:"secondaryInputId" type:"string" required:"true"`
}

// String returns the string representation
func (s AutomaticInputFailoverSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomaticInputFailoverSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomaticInputFailoverSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomaticInputFailoverSettings"}
	if s.SecondaryInputId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecondaryInputId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputPreference sets the InputPreference field's value.
func (s *AutomaticInputFailoverSettings) SetInputPreference(v string) *AutomaticInputFailoverSettings {
	s.InputPreference = &v
	return s
}

// SetSecondaryInputId sets the SecondaryInputId field's value.
func (s *AutomaticInputFailoverSettings) SetSecondaryInputId(v string) *AutomaticInputFailoverSettings {
	s.SecondaryInputId = &v
	return s
}

// Avail Blanking
type AvailBlanking struct {
	_ struct{} `type:"structure"`

	// Blanking image to be used. Leave empty for solid black. Only bmp and png
	// images are supported.
	AvailBlankingImage *InputLocation `locationName:"availBlankingImage" type:"structure"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// insertion metadata is added.
	State *string `locationName:"state" type:"string" enum:"AvailBlankingState"`
}

// String returns the string representation
func (s AvailBlanking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailBlanking) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailBlanking) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailBlanking"}
	if s.AvailBlankingImage != nil {
		if err := s.AvailBlankingImage.Validate(); err != nil {
			invalidParams.AddNested("AvailBlankingImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailBlankingImage sets the AvailBlankingImage field's value.
func (s *AvailBlanking) SetAvailBlankingImage(v *InputLocation) *AvailBlanking {
	s.AvailBlankingImage = v
	return s
}

// SetState sets the State field's value.
func (s *AvailBlanking) SetState(v string) *AvailBlanking {
	s.State = &v
	return s
}

// Avail Configuration
type AvailConfiguration struct {
	_ struct{} `type:"structure"`

	// Ad avail settings.
	AvailSettings *AvailSettings `locationName:"availSettings" type:"structure"`
}

// String returns the string representation
func (s AvailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailConfiguration"}
	if s.AvailSettings != nil {
		if err := s.AvailSettings.Validate(); err != nil {
			invalidParams.AddNested("AvailSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailSettings sets the AvailSettings field's value.
func (s *AvailConfiguration) SetAvailSettings(v *AvailSettings) *AvailConfiguration {
	s.AvailSettings = v
	return s
}

// Avail Settings
type AvailSettings struct {
	_ struct{} `type:"structure"`

	// Scte35 Splice Insert
	Scte35SpliceInsert *Scte35SpliceInsert `locationName:"scte35SpliceInsert" type:"structure"`

	// Scte35 Time Signal Apos
	Scte35TimeSignalApos *Scte35TimeSignalApos `locationName:"scte35TimeSignalApos" type:"structure"`
}

// String returns the string representation
func (s AvailSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailSettings"}
	if s.Scte35SpliceInsert != nil {
		if err := s.Scte35SpliceInsert.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsert", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalApos != nil {
		if err := s.Scte35TimeSignalApos.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalApos", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScte35SpliceInsert sets the Scte35SpliceInsert field's value.
func (s *AvailSettings) SetScte35SpliceInsert(v *Scte35SpliceInsert) *AvailSettings {
	s.Scte35SpliceInsert = v
	return s
}

// SetScte35TimeSignalApos sets the Scte35TimeSignalApos field's value.
func (s *AvailSettings) SetScte35TimeSignalApos(v *Scte35TimeSignalApos) *AvailSettings {
	s.Scte35TimeSignalApos = v
	return s
}

type BadGatewayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadGatewayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadGatewayException) GoString() string {
	return s.String()
}

func newErrorBadGatewayException(v protocol.ResponseMetadata) error {
	return &BadGatewayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadGatewayException) Code() string {
	return "BadGatewayException"
}

// Message returns the exception's message.
func (s *BadGatewayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadGatewayException) OrigErr() error {
	return nil
}

func (s *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadGatewayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadGatewayException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of schedule actions to create (in a request) or that have been created
// (in a response).
type BatchScheduleActionCreateRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to create.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionCreateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchScheduleActionCreateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionCreateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchScheduleActionCreateRequest"}
	if s.ScheduleActions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleActions"))
	}
	if s.ScheduleActions != nil {
		for i, v := range s.ScheduleActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduleActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionCreateRequest) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionCreateRequest {
	s.ScheduleActions = v
	return s
}

// List of actions that have been created in the schedule.
type BatchScheduleActionCreateResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been created in the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionCreateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchScheduleActionCreateResult) GoString() string {
	return s.String()
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionCreateResult) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionCreateResult {
	s.ScheduleActions = v
	return s
}

// A list of schedule actions to delete.
type BatchScheduleActionDeleteRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to delete.
	//
	// ActionNames is a required field
	ActionNames []*string `locationName:"actionNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionDeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchScheduleActionDeleteRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionDeleteRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchScheduleActionDeleteRequest"}
	if s.ActionNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionNames sets the ActionNames field's value.
func (s *BatchScheduleActionDeleteRequest) SetActionNames(v []*string) *BatchScheduleActionDeleteRequest {
	s.ActionNames = v
	return s
}

// List of actions that have been deleted from the schedule.
type BatchScheduleActionDeleteResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been deleted from the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionDeleteResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchScheduleActionDeleteResult) GoString() string {
	return s.String()
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionDeleteResult) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionDeleteResult {
	s.ScheduleActions = v
	return s
}

// A request to create actions (add actions to the schedule), delete actions
// (remove actions from the schedule), or both create and delete actions.
type BatchUpdateScheduleInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	// Schedule actions to create in the schedule.
	Creates *BatchScheduleActionCreateRequest `locationName:"creates" type:"structure"`

	// Schedule actions to delete from the schedule.
	Deletes *BatchScheduleActionDeleteRequest `locationName:"deletes" type:"structure"`
}

// String returns the string representation
func (s BatchUpdateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.Creates != nil {
		if err := s.Creates.Validate(); err != nil {
			invalidParams.AddNested("Creates", err.(request.ErrInvalidParams))
		}
	}
	if s.Deletes != nil {
		if err := s.Deletes.Validate(); err != nil {
			invalidParams.AddNested("Deletes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *BatchUpdateScheduleInput) SetChannelId(v string) *BatchUpdateScheduleInput {
	s.ChannelId = &v
	return s
}

// SetCreates sets the Creates field's value.
func (s *BatchUpdateScheduleInput) SetCreates(v *BatchScheduleActionCreateRequest) *BatchUpdateScheduleInput {
	s.Creates = v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *BatchUpdateScheduleInput) SetDeletes(v *BatchScheduleActionDeleteRequest) *BatchUpdateScheduleInput {
	s.Deletes = v
	return s
}

type BatchUpdateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// List of actions that have been created in the schedule.
	Creates *BatchScheduleActionCreateResult `locationName:"creates" type:"structure"`

	// List of actions that have been deleted from the schedule.
	Deletes *BatchScheduleActionDeleteResult `locationName:"deletes" type:"structure"`
}

// String returns the string representation
func (s BatchUpdateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateScheduleOutput) GoString() string {
	return s.String()
}

// SetCreates sets the Creates field's value.
func (s *BatchUpdateScheduleOutput) SetCreates(v *BatchScheduleActionCreateResult) *BatchUpdateScheduleOutput {
	s.Creates = v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *BatchUpdateScheduleOutput) SetDeletes(v *BatchScheduleActionDeleteResult) *BatchUpdateScheduleOutput {
	s.Deletes = v
	return s
}

// Blackout Slate
type BlackoutSlate struct {
	_ struct{} `type:"structure"`

	// Blackout slate image to be used. Leave empty for solid black. Only bmp and
	// png images are supported.
	BlackoutSlateImage *InputLocation `locationName:"blackoutSlateImage" type:"structure"`

	// Setting to enabled causes the encoder to blackout the video, audio, and captions,
	// and raise the "Network Blackout Image" slate when an SCTE104/35 Network End
	// Segmentation Descriptor is encountered. The blackout will be lifted when
	// the Network Start Segmentation Descriptor is encountered. The Network End
	// and Network Start descriptors must contain a network ID that matches the
	// value entered in "Network ID".
	NetworkEndBlackout *string `locationName:"networkEndBlackout" type:"string" enum:"BlackoutSlateNetworkEndBlackout"`

	// Path to local file to use as Network End Blackout image. Image will be scaled
	// to fill the entire output raster.
	NetworkEndBlackoutImage *InputLocation `locationName:"networkEndBlackoutImage" type:"structure"`

	// Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
	NetworkId *string `locationName:"networkId" min:"34" type:"string"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// indicated by program metadata.
	State *string `locationName:"state" type:"string" enum:"BlackoutSlateState"`
}

// String returns the string representation
func (s BlackoutSlate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlackoutSlate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlackoutSlate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlackoutSlate"}
	if s.NetworkId != nil && len(*s.NetworkId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 34))
	}
	if s.BlackoutSlateImage != nil {
		if err := s.BlackoutSlateImage.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlateImage", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkEndBlackoutImage != nil {
		if err := s.NetworkEndBlackoutImage.Validate(); err != nil {
			invalidParams.AddNested("NetworkEndBlackoutImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackoutSlateImage sets the BlackoutSlateImage field's value.
func (s *BlackoutSlate) SetBlackoutSlateImage(v *InputLocation) *BlackoutSlate {
	s.BlackoutSlateImage = v
	return s
}

// SetNetworkEndBlackout sets the NetworkEndBlackout field's value.
func (s *BlackoutSlate) SetNetworkEndBlackout(v string) *BlackoutSlate {
	s.NetworkEndBlackout = &v
	return s
}

// SetNetworkEndBlackoutImage sets the NetworkEndBlackoutImage field's value.
func (s *BlackoutSlate) SetNetworkEndBlackoutImage(v *InputLocation) *BlackoutSlate {
	s.NetworkEndBlackoutImage = v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *BlackoutSlate) SetNetworkId(v string) *BlackoutSlate {
	s.NetworkId = &v
	return s
}

// SetState sets the State field's value.
func (s *BlackoutSlate) SetState(v string) *BlackoutSlate {
	s.State = &v
	return s
}

// Burn In Destination Settings
type BurnInDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"BurnInAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"BurnInBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter out is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"BurnInFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to 'auto' fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"BurnInOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"BurnInShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter out is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"BurnInTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. All burn-in
	// and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s BurnInDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BurnInDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BurnInDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BurnInDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *BurnInDestinationSettings) SetAlignment(v string) *BurnInDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *BurnInDestinationSettings) SetBackgroundColor(v string) *BurnInDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *BurnInDestinationSettings) SetBackgroundOpacity(v int64) *BurnInDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *BurnInDestinationSettings) SetFont(v *InputLocation) *BurnInDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *BurnInDestinationSettings) SetFontColor(v string) *BurnInDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *BurnInDestinationSettings) SetFontOpacity(v int64) *BurnInDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *BurnInDestinationSettings) SetFontResolution(v int64) *BurnInDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *BurnInDestinationSettings) SetFontSize(v string) *BurnInDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *BurnInDestinationSettings) SetOutlineColor(v string) *BurnInDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *BurnInDestinationSettings) SetOutlineSize(v int64) *BurnInDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *BurnInDestinationSettings) SetShadowColor(v string) *BurnInDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *BurnInDestinationSettings) SetShadowOpacity(v int64) *BurnInDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *BurnInDestinationSettings) SetShadowXOffset(v int64) *BurnInDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *BurnInDestinationSettings) SetShadowYOffset(v int64) *BurnInDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *BurnInDestinationSettings) SetTeletextGridControl(v string) *BurnInDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *BurnInDestinationSettings) SetXPosition(v int64) *BurnInDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *BurnInDestinationSettings) SetYPosition(v int64) *BurnInDestinationSettings {
	s.YPosition = &v
	return s
}

// Caption Description
type CaptionDescription struct {
	_ struct{} `type:"structure"`

	// Specifies which input caption selector to use as a caption source when generating
	// output captions. This field should match a captionSelector name.
	//
	// CaptionSelectorName is a required field
	CaptionSelectorName *string `locationName:"captionSelectorName" type:"string" required:"true"`

	// Additional settings for captions destination that depend on the destination
	// type.
	DestinationSettings *CaptionDestinationSettings `locationName:"destinationSettings" type:"structure"`

	// ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Human readable information to indicate captions available for players (eg.
	// English, or Spanish).
	LanguageDescription *string `locationName:"languageDescription" type:"string"`

	// Name of the caption description. Used to associate a caption description
	// with an output. Names must be unique within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDescription"}
	if s.CaptionSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionSelectorName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DestinationSettings != nil {
		if err := s.DestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionSelectorName sets the CaptionSelectorName field's value.
func (s *CaptionDescription) SetCaptionSelectorName(v string) *CaptionDescription {
	s.CaptionSelectorName = &v
	return s
}

// SetDestinationSettings sets the DestinationSettings field's value.
func (s *CaptionDescription) SetDestinationSettings(v *CaptionDestinationSettings) *CaptionDescription {
	s.DestinationSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionDescription) SetLanguageCode(v string) *CaptionDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionDescription) SetLanguageDescription(v string) *CaptionDescription {
	s.LanguageDescription = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionDescription) SetName(v string) *CaptionDescription {
	s.Name = &v
	return s
}

// Caption Destination Settings
type CaptionDestinationSettings struct {
	_ struct{} `type:"structure"`

	// Arib Destination Settings
	AribDestinationSettings *AribDestinationSettings `locationName:"aribDestinationSettings" type:"structure"`

	// Burn In Destination Settings
	BurnInDestinationSettings *BurnInDestinationSettings `locationName:"burnInDestinationSettings" type:"structure"`

	// Dvb Sub Destination Settings
	DvbSubDestinationSettings *DvbSubDestinationSettings `locationName:"dvbSubDestinationSettings" type:"structure"`

	// Ebu Tt DDestination Settings
	EbuTtDDestinationSettings *EbuTtDDestinationSettings `locationName:"ebuTtDDestinationSettings" type:"structure"`

	// Embedded Destination Settings
	EmbeddedDestinationSettings *EmbeddedDestinationSettings `locationName:"embeddedDestinationSettings" type:"structure"`

	// Embedded Plus Scte20 Destination Settings
	EmbeddedPlusScte20DestinationSettings *EmbeddedPlusScte20DestinationSettings `locationName:"embeddedPlusScte20DestinationSettings" type:"structure"`

	// Rtmp Caption Info Destination Settings
	RtmpCaptionInfoDestinationSettings *RtmpCaptionInfoDestinationSettings `locationName:"rtmpCaptionInfoDestinationSettings" type:"structure"`

	// Scte20 Plus Embedded Destination Settings
	Scte20PlusEmbeddedDestinationSettings *Scte20PlusEmbeddedDestinationSettings `locationName:"scte20PlusEmbeddedDestinationSettings" type:"structure"`

	// Scte27 Destination Settings
	Scte27DestinationSettings *Scte27DestinationSettings `locationName:"scte27DestinationSettings" type:"structure"`

	// Smpte Tt Destination Settings
	SmpteTtDestinationSettings *SmpteTtDestinationSettings `locationName:"smpteTtDestinationSettings" type:"structure"`

	// Teletext Destination Settings
	TeletextDestinationSettings *TeletextDestinationSettings `locationName:"teletextDestinationSettings" type:"structure"`

	// Ttml Destination Settings
	TtmlDestinationSettings *TtmlDestinationSettings `locationName:"ttmlDestinationSettings" type:"structure"`

	// Webvtt Destination Settings
	WebvttDestinationSettings *WebvttDestinationSettings `locationName:"webvttDestinationSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDestinationSettings"}
	if s.BurnInDestinationSettings != nil {
		if err := s.BurnInDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("BurnInDestinationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSubDestinationSettings != nil {
		if err := s.DvbSubDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubDestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAribDestinationSettings sets the AribDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetAribDestinationSettings(v *AribDestinationSettings) *CaptionDestinationSettings {
	s.AribDestinationSettings = v
	return s
}

// SetBurnInDestinationSettings sets the BurnInDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetBurnInDestinationSettings(v *BurnInDestinationSettings) *CaptionDestinationSettings {
	s.BurnInDestinationSettings = v
	return s
}

// SetDvbSubDestinationSettings sets the DvbSubDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetDvbSubDestinationSettings(v *DvbSubDestinationSettings) *CaptionDestinationSettings {
	s.DvbSubDestinationSettings = v
	return s
}

// SetEbuTtDDestinationSettings sets the EbuTtDDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEbuTtDDestinationSettings(v *EbuTtDDestinationSettings) *CaptionDestinationSettings {
	s.EbuTtDDestinationSettings = v
	return s
}

// SetEmbeddedDestinationSettings sets the EmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedDestinationSettings(v *EmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedDestinationSettings = v
	return s
}

// SetEmbeddedPlusScte20DestinationSettings sets the EmbeddedPlusScte20DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedPlusScte20DestinationSettings(v *EmbeddedPlusScte20DestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedPlusScte20DestinationSettings = v
	return s
}

// SetRtmpCaptionInfoDestinationSettings sets the RtmpCaptionInfoDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetRtmpCaptionInfoDestinationSettings(v *RtmpCaptionInfoDestinationSettings) *CaptionDestinationSettings {
	s.RtmpCaptionInfoDestinationSettings = v
	return s
}

// SetScte20PlusEmbeddedDestinationSettings sets the Scte20PlusEmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte20PlusEmbeddedDestinationSettings(v *Scte20PlusEmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.Scte20PlusEmbeddedDestinationSettings = v
	return s
}

// SetScte27DestinationSettings sets the Scte27DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte27DestinationSettings(v *Scte27DestinationSettings) *CaptionDestinationSettings {
	s.Scte27DestinationSettings = v
	return s
}

// SetSmpteTtDestinationSettings sets the SmpteTtDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetSmpteTtDestinationSettings(v *SmpteTtDestinationSettings) *CaptionDestinationSettings {
	s.SmpteTtDestinationSettings = v
	return s
}

// SetTeletextDestinationSettings sets the TeletextDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTeletextDestinationSettings(v *TeletextDestinationSettings) *CaptionDestinationSettings {
	s.TeletextDestinationSettings = v
	return s
}

// SetTtmlDestinationSettings sets the TtmlDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTtmlDestinationSettings(v *TtmlDestinationSettings) *CaptionDestinationSettings {
	s.TtmlDestinationSettings = v
	return s
}

// SetWebvttDestinationSettings sets the WebvttDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetWebvttDestinationSettings(v *WebvttDestinationSettings) *CaptionDestinationSettings {
	s.WebvttDestinationSettings = v
	return s
}

// Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2),
// with an optional description.
type CaptionLanguageMapping struct {
	_ struct{} `type:"structure"`

	// The closed caption channel being described by this CaptionLanguageMapping.
	// Each channel mapping must have a unique channel number (maximum of 4)
	//
	// CaptionChannel is a required field
	CaptionChannel *int64 `locationName:"captionChannel" min:"1" type:"integer" required:"true"`

	// Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string" required:"true"`

	// Textual description of language
	//
	// LanguageDescription is a required field
	LanguageDescription *string `locationName:"languageDescription" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionLanguageMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionLanguageMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionLanguageMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionLanguageMapping"}
	if s.CaptionChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionChannel"))
	}
	if s.CaptionChannel != nil && *s.CaptionChannel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CaptionChannel", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 3))
	}
	if s.LanguageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageDescription"))
	}
	if s.LanguageDescription != nil && len(*s.LanguageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageDescription", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionChannel sets the CaptionChannel field's value.
func (s *CaptionLanguageMapping) SetCaptionChannel(v int64) *CaptionLanguageMapping {
	s.CaptionChannel = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionLanguageMapping) SetLanguageCode(v string) *CaptionLanguageMapping {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionLanguageMapping) SetLanguageDescription(v string) *CaptionLanguageMapping {
	s.LanguageDescription = &v
	return s
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
type CaptionSelector struct {
	_ struct{} `type:"structure"`

	// When specified this field indicates the three letter language code of the
	// caption track to extract from the source.
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Name identifier for a caption selector. This name is used to associate this
	// caption selector with one or more caption descriptions. Names must be unique
	// within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Caption selector settings.
	SelectorSettings *CaptionSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionSelector) SetLanguageCode(v string) *CaptionSelector {
	s.LanguageCode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionSelector) SetName(v string) *CaptionSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *CaptionSelector) SetSelectorSettings(v *CaptionSelectorSettings) *CaptionSelector {
	s.SelectorSettings = v
	return s
}

// Caption Selector Settings
type CaptionSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Arib Source Settings
	AribSourceSettings *AribSourceSettings `locationName:"aribSourceSettings" type:"structure"`

	// Dvb Sub Source Settings
	DvbSubSourceSettings *DvbSubSourceSettings `locationName:"dvbSubSourceSettings" type:"structure"`

	// Embedded Source Settings
	EmbeddedSourceSettings *EmbeddedSourceSettings `locationName:"embeddedSourceSettings" type:"structure"`

	// Scte20 Source Settings
	Scte20SourceSettings *Scte20SourceSettings `locationName:"scte20SourceSettings" type:"structure"`

	// Scte27 Source Settings
	Scte27SourceSettings *Scte27SourceSettings `locationName:"scte27SourceSettings" type:"structure"`

	// Teletext Source Settings
	TeletextSourceSettings *TeletextSourceSettings `locationName:"teletextSourceSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelectorSettings"}
	if s.DvbSubSourceSettings != nil {
		if err := s.DvbSubSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.EmbeddedSourceSettings != nil {
		if err := s.EmbeddedSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("EmbeddedSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte20SourceSettings != nil {
		if err := s.Scte20SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte20SourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte27SourceSettings != nil {
		if err := s.Scte27SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte27SourceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAribSourceSettings sets the AribSourceSettings field's value.
func (s *CaptionSelectorSettings) SetAribSourceSettings(v *AribSourceSettings) *CaptionSelectorSettings {
	s.AribSourceSettings = v
	return s
}

// SetDvbSubSourceSettings sets the DvbSubSourceSettings field's value.
func (s *CaptionSelectorSettings) SetDvbSubSourceSettings(v *DvbSubSourceSettings) *CaptionSelectorSettings {
	s.DvbSubSourceSettings = v
	return s
}

// SetEmbeddedSourceSettings sets the EmbeddedSourceSettings field's value.
func (s *CaptionSelectorSettings) SetEmbeddedSourceSettings(v *EmbeddedSourceSettings) *CaptionSelectorSettings {
	s.EmbeddedSourceSettings = v
	return s
}

// SetScte20SourceSettings sets the Scte20SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte20SourceSettings(v *Scte20SourceSettings) *CaptionSelectorSettings {
	s.Scte20SourceSettings = v
	return s
}

// SetScte27SourceSettings sets the Scte27SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte27SourceSettings(v *Scte27SourceSettings) *CaptionSelectorSettings {
	s.Scte27SourceSettings = v
	return s
}

// SetTeletextSourceSettings sets the TeletextSourceSettings field's value.
func (s *CaptionSelectorSettings) SetTeletextSourceSettings(v *TeletextSourceSettings) *CaptionSelectorSettings {
	s.TeletextSourceSettings = v
	return s
}

type Channel struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// Runtime details for the pipelines of a running channel.
	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *Channel) SetChannelClass(v string) *Channel {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Channel) SetDestinations(v []*OutputDestination) *Channel {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *Channel) SetEgressEndpoints(v []*ChannelEgressEndpoint) *Channel {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *Channel) SetEncoderSettings(v *EncoderSettings) *Channel {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *Channel) SetId(v string) *Channel {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *Channel) SetInputAttachments(v []*InputAttachment) *Channel {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *Channel) SetInputSpecification(v *InputSpecification) *Channel {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *Channel) SetLogLevel(v string) *Channel {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *Channel) SetPipelineDetails(v []*PipelineDetail) *Channel {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *Channel) SetPipelinesRunningCount(v int64) *Channel {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Channel) SetRoleArn(v string) *Channel {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *Channel) SetState(v string) *Channel {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

type ChannelEgressEndpoint struct {
	_ struct{} `type:"structure"`

	// Public IP of where a channel's output comes from
	SourceIp *string `locationName:"sourceIp" type:"string"`
}

// String returns the string representation
func (s ChannelEgressEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelEgressEndpoint) GoString() string {
	return s.String()
}

// SetSourceIp sets the SourceIp field's value.
func (s *ChannelEgressEndpoint) SetSourceIp(v string) *ChannelEgressEndpoint {
	s.SourceIp = &v
	return s
}

type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelSummary) SetArn(v string) *ChannelSummary {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *ChannelSummary) SetChannelClass(v string) *ChannelSummary {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *ChannelSummary) SetDestinations(v []*OutputDestination) *ChannelSummary {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *ChannelSummary) SetEgressEndpoints(v []*ChannelEgressEndpoint) *ChannelSummary {
	s.EgressEndpoints = v
	return s
}

// SetId sets the Id field's value.
func (s *ChannelSummary) SetId(v string) *ChannelSummary {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *ChannelSummary) SetInputAttachments(v []*InputAttachment) *ChannelSummary {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *ChannelSummary) SetInputSpecification(v *InputSpecification) *ChannelSummary {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *ChannelSummary) SetLogLevel(v string) *ChannelSummary {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *ChannelSummary) SetPipelinesRunningCount(v int64) *ChannelSummary {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ChannelSummary) SetRoleArn(v string) *ChannelSummary {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *ChannelSummary) SetState(v string) *ChannelSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ChannelSummary) SetTags(v map[string]*string) *ChannelSummary {
	s.Tags = v
	return s
}

// Passthrough applies no color space conversion to the output
type ColorSpacePassthroughSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ColorSpacePassthroughSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColorSpacePassthroughSettings) GoString() string {
	return s.String()
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Reserved *string `locationName:"reserved" deprecated:"true" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EncoderSettings != nil {
		if err := s.EncoderSettings.Validate(); err != nil {
			invalidParams.AddNested("EncoderSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputAttachments != nil {
		for i, v := range s.InputAttachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputAttachments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelClass sets the ChannelClass field's value.
func (s *CreateChannelInput) SetChannelClass(v string) *CreateChannelInput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *CreateChannelInput) SetDestinations(v []*OutputDestination) *CreateChannelInput {
	s.Destinations = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *CreateChannelInput) SetEncoderSettings(v *EncoderSettings) *CreateChannelInput {
	s.EncoderSettings = v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *CreateChannelInput) SetInputAttachments(v []*InputAttachment) *CreateChannelInput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *CreateChannelInput) SetInputSpecification(v *InputSpecification) *CreateChannelInput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *CreateChannelInput) SetLogLevel(v string) *CreateChannelInput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateChannelInput) SetRequestId(v string) *CreateChannelInput {
	s.RequestId = &v
	return s
}

// SetReserved sets the Reserved field's value.
func (s *CreateChannelInput) SetReserved(v string) *CreateChannelInput {
	s.Reserved = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateChannelInput) SetRoleArn(v string) *CreateChannelInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *CreateChannelOutput) SetChannel(v *Channel) *CreateChannelOutput {
	s.Channel = v
	return s
}

type CreateInputInput struct {
	_ struct{} `type:"structure"`

	Destinations []*InputDestinationRequest `locationName:"destinations" type:"list"`

	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	InputSecurityGroups []*string `locationName:"inputSecurityGroups" type:"list"`

	MediaConnectFlows []*MediaConnectFlowRequest `locationName:"mediaConnectFlows" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	Sources []*InputSourceRequest `locationName:"sources" type:"list"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`

	// Settings for a private VPC Input.When this property is specified, the input
	// destination addresses will be created in a VPC rather than with public Internet
	// addresses.This property requires setting the roleArn property on Input creation.Not
	// compatible with the inputSecurityGroups property.
	Vpc *InputVpcRequest `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s CreateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInputInput"}
	if s.Vpc != nil {
		if err := s.Vpc.Validate(); err != nil {
			invalidParams.AddNested("Vpc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateInputInput) SetDestinations(v []*InputDestinationRequest) *CreateInputInput {
	s.Destinations = v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *CreateInputInput) SetInputDevices(v []*InputDeviceSettings) *CreateInputInput {
	s.InputDevices = v
	return s
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *CreateInputInput) SetInputSecurityGroups(v []*string) *CreateInputInput {
	s.InputSecurityGroups = v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *CreateInputInput) SetMediaConnectFlows(v []*MediaConnectFlowRequest) *CreateInputInput {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInputInput) SetName(v string) *CreateInputInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateInputInput) SetRequestId(v string) *CreateInputInput {
	s.RequestId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateInputInput) SetRoleArn(v string) *CreateInputInput {
	s.RoleArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateInputInput) SetSources(v []*InputSourceRequest) *CreateInputInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInputInput) SetTags(v map[string]*string) *CreateInputInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateInputInput) SetType(v string) *CreateInputInput {
	s.Type = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *CreateInputInput) SetVpc(v *InputVpcRequest) *CreateInputInput {
	s.Vpc = v
	return s
}

type CreateInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s CreateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *CreateInputOutput) SetInput(v *Input) *CreateInputOutput {
	s.Input = v
	return s
}

type CreateInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	WhitelistRules []*InputWhitelistRuleCidr `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s CreateInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputSecurityGroupInput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *CreateInputSecurityGroupInput) SetTags(v map[string]*string) *CreateInputSecurityGroupInput {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *CreateInputSecurityGroupInput) SetWhitelistRules(v []*InputWhitelistRuleCidr) *CreateInputSecurityGroupInput {
	s.WhitelistRules = v
	return s
}

type CreateInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// An Input Security Group
	SecurityGroup *InputSecurityGroup `locationName:"securityGroup" type:"structure"`
}

// String returns the string representation
func (s CreateInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *CreateInputSecurityGroupOutput) SetSecurityGroup(v *InputSecurityGroup) *CreateInputSecurityGroupOutput {
	s.SecurityGroup = v
	return s
}

type CreateMultiplexInput struct {
	_ struct{} `type:"structure"`

	// AvailabilityZones is a required field
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list" required:"true"`

	// Contains configuration for a Multiplex event
	//
	// MultiplexSettings is a required field
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiplexInput"}
	if s.AvailabilityZones == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZones"))
	}
	if s.MultiplexSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexSettings"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.MultiplexSettings != nil {
		if err := s.MultiplexSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateMultiplexInput) SetAvailabilityZones(v []*string) *CreateMultiplexInput {
	s.AvailabilityZones = v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *CreateMultiplexInput) SetMultiplexSettings(v *MultiplexSettings) *CreateMultiplexInput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMultiplexInput) SetName(v string) *CreateMultiplexInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateMultiplexInput) SetRequestId(v string) *CreateMultiplexInput {
	s.RequestId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMultiplexInput) SetTags(v map[string]*string) *CreateMultiplexInput {
	s.Tags = v
	return s
}

type CreateMultiplexOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex object.
	Multiplex *Multiplex `locationName:"multiplex" type:"structure"`
}

// String returns the string representation
func (s CreateMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultiplexOutput) GoString() string {
	return s.String()
}

// SetMultiplex sets the Multiplex field's value.
func (s *CreateMultiplexOutput) SetMultiplex(v *Multiplex) *CreateMultiplexOutput {
	s.Multiplex = v
	return s
}

type CreateMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Multiplex Program settings configuration.
	//
	// MultiplexProgramSettings is a required field
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure" required:"true"`

	// ProgramName is a required field
	ProgramName *string `locationName:"programName" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s CreateMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.MultiplexProgramSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexProgramSettings"))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.MultiplexProgramSettings != nil {
		if err := s.MultiplexProgramSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexProgramSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *CreateMultiplexProgramInput) SetMultiplexId(v string) *CreateMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *CreateMultiplexProgramInput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *CreateMultiplexProgramInput {
	s.MultiplexProgramSettings = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *CreateMultiplexProgramInput) SetProgramName(v string) *CreateMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateMultiplexProgramInput) SetRequestId(v string) *CreateMultiplexProgramInput {
	s.RequestId = &v
	return s
}

type CreateMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex program object.
	MultiplexProgram *MultiplexProgram `locationName:"multiplexProgram" type:"structure"`
}

// String returns the string representation
func (s CreateMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetMultiplexProgram sets the MultiplexProgram field's value.
func (s *CreateMultiplexProgramOutput) SetMultiplexProgram(v *MultiplexProgram) *CreateMultiplexProgramOutput {
	s.MultiplexProgram = v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateTagsInput) SetResourceArn(v string) *CreateTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v map[string]*string) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteChannelInput) SetChannelId(v string) *DeleteChannelInput {
	s.ChannelId = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteChannelOutput) SetArn(v string) *DeleteChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *DeleteChannelOutput) SetChannelClass(v string) *DeleteChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeleteChannelOutput) SetDestinations(v []*OutputDestination) *DeleteChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DeleteChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DeleteChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DeleteChannelOutput) SetEncoderSettings(v *EncoderSettings) *DeleteChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteChannelOutput) SetId(v string) *DeleteChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DeleteChannelOutput) SetInputAttachments(v []*InputAttachment) *DeleteChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DeleteChannelOutput) SetInputSpecification(v *InputSpecification) *DeleteChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *DeleteChannelOutput) SetLogLevel(v string) *DeleteChannelOutput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteChannelOutput) SetName(v string) *DeleteChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DeleteChannelOutput) SetPipelineDetails(v []*PipelineDetail) *DeleteChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DeleteChannelOutput) SetPipelinesRunningCount(v int64) *DeleteChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeleteChannelOutput) SetRoleArn(v string) *DeleteChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteChannelOutput) SetState(v string) *DeleteChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteChannelOutput) SetTags(v map[string]*string) *DeleteChannelOutput {
	s.Tags = v
	return s
}

type DeleteInputInput struct {
	_ struct{} `type:"structure"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DeleteInputInput) SetInputId(v string) *DeleteInputInput {
	s.InputId = &v
	return s
}

type DeleteInputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputOutput) GoString() string {
	return s.String()
}

type DeleteInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}
	if s.InputSecurityGroupId != nil && len(*s.InputSecurityGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSecurityGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DeleteInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DeleteInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DeleteInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DeleteMultiplexInput) SetMultiplexId(v string) *DeleteMultiplexInput {
	s.MultiplexId = &v
	return s
}

type DeleteMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DeleteMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteMultiplexOutput) SetArn(v string) *DeleteMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DeleteMultiplexOutput) SetAvailabilityZones(v []*string) *DeleteMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeleteMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *DeleteMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteMultiplexOutput) SetId(v string) *DeleteMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *DeleteMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *DeleteMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteMultiplexOutput) SetName(v string) *DeleteMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DeleteMultiplexOutput) SetPipelinesRunningCount(v int64) *DeleteMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *DeleteMultiplexOutput) SetProgramCount(v int64) *DeleteMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteMultiplexOutput) SetState(v string) *DeleteMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteMultiplexOutput) SetTags(v map[string]*string) *DeleteMultiplexOutput {
	s.Tags = v
	return s
}

type DeleteMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DeleteMultiplexProgramInput) SetMultiplexId(v string) *DeleteMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DeleteMultiplexProgramInput) SetProgramName(v string) *DeleteMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

type DeleteMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// Packet identifiers map for a given Multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation
func (s DeleteMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteMultiplexProgramOutput) SetChannelId(v string) *DeleteMultiplexProgramOutput {
	s.ChannelId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *DeleteMultiplexProgramOutput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *DeleteMultiplexProgramOutput {
	s.MultiplexProgramSettings = v
	return s
}

// SetPacketIdentifiersMap sets the PacketIdentifiersMap field's value.
func (s *DeleteMultiplexProgramOutput) SetPacketIdentifiersMap(v *MultiplexProgramPacketIdentifiersMap) *DeleteMultiplexProgramOutput {
	s.PacketIdentifiersMap = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DeleteMultiplexProgramOutput) SetProgramName(v string) *DeleteMultiplexProgramOutput {
	s.ProgramName = &v
	return s
}

type DeleteReservationInput struct {
	_ struct{} `type:"structure"`

	// ReservationId is a required field
	ReservationId *string `location:"uri" locationName:"reservationId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReservationInput"}
	if s.ReservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationId"))
	}
	if s.ReservationId != nil && len(*s.ReservationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservationId sets the ReservationId field's value.
func (s *DeleteReservationInput) SetReservationId(v string) *DeleteReservationInput {
	s.ReservationId = &v
	return s
}

type DeleteReservationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"integer"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	End *string `locationName:"end" type:"string"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	Name *string `locationName:"name" type:"string"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	Start *string `locationName:"start" type:"string"`

	// Current reservation state
	State *string `locationName:"state" type:"string" enum:"ReservationState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s DeleteReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReservationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteReservationOutput) SetArn(v string) *DeleteReservationOutput {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *DeleteReservationOutput) SetCount(v int64) *DeleteReservationOutput {
	s.Count = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DeleteReservationOutput) SetCurrencyCode(v string) *DeleteReservationOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DeleteReservationOutput) SetDuration(v int64) *DeleteReservationOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DeleteReservationOutput) SetDurationUnits(v string) *DeleteReservationOutput {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *DeleteReservationOutput) SetEnd(v string) *DeleteReservationOutput {
	s.End = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DeleteReservationOutput) SetFixedPrice(v float64) *DeleteReservationOutput {
	s.FixedPrice = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteReservationOutput) SetName(v string) *DeleteReservationOutput {
	s.Name = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DeleteReservationOutput) SetOfferingDescription(v string) *DeleteReservationOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DeleteReservationOutput) SetOfferingId(v string) *DeleteReservationOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DeleteReservationOutput) SetOfferingType(v string) *DeleteReservationOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DeleteReservationOutput) SetRegion(v string) *DeleteReservationOutput {
	s.Region = &v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *DeleteReservationOutput) SetReservationId(v string) *DeleteReservationOutput {
	s.ReservationId = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DeleteReservationOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DeleteReservationOutput {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *DeleteReservationOutput) SetStart(v string) *DeleteReservationOutput {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteReservationOutput) SetState(v string) *DeleteReservationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteReservationOutput) SetTags(v map[string]*string) *DeleteReservationOutput {
	s.Tags = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DeleteReservationOutput) SetUsagePrice(v float64) *DeleteReservationOutput {
	s.UsagePrice = &v
	return s
}

type DeleteScheduleInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteScheduleInput) SetChannelId(v string) *DeleteScheduleInput {
	s.ChannelId = &v
	return s
}

type DeleteScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduleOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteTagsInput) SetResourceArn(v string) *DeleteTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeChannelInput) SetChannelId(v string) *DescribeChannelInput {
	s.ChannelId = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeChannelOutput) SetArn(v string) *DescribeChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *DescribeChannelOutput) SetChannelClass(v string) *DescribeChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeChannelOutput) SetDestinations(v []*OutputDestination) *DescribeChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DescribeChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DescribeChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DescribeChannelOutput) SetEncoderSettings(v *EncoderSettings) *DescribeChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeChannelOutput) SetId(v string) *DescribeChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DescribeChannelOutput) SetInputAttachments(v []*InputAttachment) *DescribeChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DescribeChannelOutput) SetInputSpecification(v *InputSpecification) *DescribeChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *DescribeChannelOutput) SetLogLevel(v string) *DescribeChannelOutput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeChannelOutput) SetName(v string) *DescribeChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DescribeChannelOutput) SetPipelineDetails(v []*PipelineDetail) *DescribeChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DescribeChannelOutput) SetPipelinesRunningCount(v int64) *DescribeChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeChannelOutput) SetRoleArn(v string) *DescribeChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeChannelOutput) SetState(v string) *DescribeChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChannelOutput) SetTags(v map[string]*string) *DescribeChannelOutput {
	s.Tags = v
	return s
}

type DescribeInputDeviceInput struct {
	_ struct{} `type:"structure"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputDeviceInput"}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *DescribeInputDeviceInput) SetInputDeviceId(v string) *DescribeInputDeviceInput {
	s.InputDeviceId = &v
	return s
}

type DescribeInputDeviceOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// The state of the connection between the input device and AWS.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"InputDeviceConnectionState"`

	// The status of the action to synchronize the device configuration. If you
	// change the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState *string `locationName:"deviceSettingsSyncState" type:"string" enum:"DeviceSettingsSyncState"`

	// Settings that describe the active source from the input device, and the video
	// characteristics of that source.
	HdDeviceSettings *InputDeviceHdSettings `locationName:"hdDeviceSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	MacAddress *string `locationName:"macAddress" type:"string"`

	Name *string `locationName:"name" type:"string"`

	// The network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings `locationName:"networkSettings" type:"structure"`

	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The type of the input device. For an AWS Elemental Link device that outputs
	// resolutions up to 1080, choose "HD".
	Type *string `locationName:"type" type:"string" enum:"InputDeviceType"`
}

// String returns the string representation
func (s DescribeInputDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputDeviceOutput) SetArn(v string) *DescribeInputDeviceOutput {
	s.Arn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *DescribeInputDeviceOutput) SetConnectionState(v string) *DescribeInputDeviceOutput {
	s.ConnectionState = &v
	return s
}

// SetDeviceSettingsSyncState sets the DeviceSettingsSyncState field's value.
func (s *DescribeInputDeviceOutput) SetDeviceSettingsSyncState(v string) *DescribeInputDeviceOutput {
	s.DeviceSettingsSyncState = &v
	return s
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *DescribeInputDeviceOutput) SetHdDeviceSettings(v *InputDeviceHdSettings) *DescribeInputDeviceOutput {
	s.HdDeviceSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputDeviceOutput) SetId(v string) *DescribeInputDeviceOutput {
	s.Id = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *DescribeInputDeviceOutput) SetMacAddress(v string) *DescribeInputDeviceOutput {
	s.MacAddress = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInputDeviceOutput) SetName(v string) *DescribeInputDeviceOutput {
	s.Name = &v
	return s
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *DescribeInputDeviceOutput) SetNetworkSettings(v *InputDeviceNetworkSettings) *DescribeInputDeviceOutput {
	s.NetworkSettings = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DescribeInputDeviceOutput) SetSerialNumber(v string) *DescribeInputDeviceOutput {
	s.SerialNumber = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeInputDeviceOutput) SetType(v string) *DescribeInputDeviceOutput {
	s.Type = &v
	return s
}

type DescribeInputDeviceThumbnailInput struct {
	_ struct{} `type:"structure"`

	// Accept Header
	//
	// Accept is a required field
	Accept *string `location:"header" locationName:"accept" type:"string" required:"true" enum:"AcceptHeader"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputDeviceThumbnailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputDeviceThumbnailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputDeviceThumbnailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputDeviceThumbnailInput"}
	if s.Accept == nil {
		invalidParams.Add(request.NewErrParamRequired("Accept"))
	}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *DescribeInputDeviceThumbnailInput) SetAccept(v string) *DescribeInputDeviceThumbnailInput {
	s.Accept = &v
	return s
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *DescribeInputDeviceThumbnailInput) SetInputDeviceId(v string) *DescribeInputDeviceThumbnailInput {
	s.InputDeviceId = &v
	return s
}

type DescribeInputDeviceThumbnailOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadCloser `locationName:"body" type:"blob"`

	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"ContentType"`

	ETag *string `location:"header" locationName:"ETag" type:"string"`

	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`
}

// String returns the string representation
func (s DescribeInputDeviceThumbnailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputDeviceThumbnailOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetBody(v io.ReadCloser) *DescribeInputDeviceThumbnailOutput {
	s.Body = v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetContentLength(v int64) *DescribeInputDeviceThumbnailOutput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetContentType(v string) *DescribeInputDeviceThumbnailOutput {
	s.ContentType = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetETag(v string) *DescribeInputDeviceThumbnailOutput {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetLastModified(v time.Time) *DescribeInputDeviceThumbnailOutput {
	s.LastModified = &v
	return s
}

type DescribeInputInput struct {
	_ struct{} `type:"structure"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DescribeInputInput) SetInputId(v string) *DescribeInputInput {
	s.InputId = &v
	return s
}

type DescribeInputOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// A standard input has two sources and a single pipeline input only has one.
	InputClass *string `locationName:"inputClass" type:"string" enum:"InputClass"`

	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	// There are two types of input sources, static and dynamic. If an input source
	// is dynamic you canchange the source url of the input dynamically using an
	// input switch action. However, the only input typeto support a dynamic url
	// at this time is MP4_FILE. By default all input sources are static.
	InputSourceType *string `locationName:"inputSourceType" type:"string" enum:"InputSourceType"`

	MediaConnectFlows []*MediaConnectFlow `locationName:"mediaConnectFlows" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation
func (s DescribeInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputOutput) SetArn(v string) *DescribeInputOutput {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *DescribeInputOutput) SetAttachedChannels(v []*string) *DescribeInputOutput {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeInputOutput) SetDestinations(v []*InputDestination) *DescribeInputOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputOutput) SetId(v string) *DescribeInputOutput {
	s.Id = &v
	return s
}

// SetInputClass sets the InputClass field's value.
func (s *DescribeInputOutput) SetInputClass(v string) *DescribeInputOutput {
	s.InputClass = &v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *DescribeInputOutput) SetInputDevices(v []*InputDeviceSettings) *DescribeInputOutput {
	s.InputDevices = v
	return s
}

// SetInputSourceType sets the InputSourceType field's value.
func (s *DescribeInputOutput) SetInputSourceType(v string) *DescribeInputOutput {
	s.InputSourceType = &v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *DescribeInputOutput) SetMediaConnectFlows(v []*MediaConnectFlow) *DescribeInputOutput {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInputOutput) SetName(v string) *DescribeInputOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeInputOutput) SetRoleArn(v string) *DescribeInputOutput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeInputOutput) SetSecurityGroups(v []*string) *DescribeInputOutput {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *DescribeInputOutput) SetSources(v []*InputSource) *DescribeInputOutput {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputOutput) SetState(v string) *DescribeInputOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeInputOutput) SetTags(v map[string]*string) *DescribeInputOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeInputOutput) SetType(v string) *DescribeInputOutput {
	s.Type = &v
	return s
}

type DescribeInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}
	if s.InputSecurityGroupId != nil && len(*s.InputSecurityGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSecurityGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DescribeInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DescribeInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DescribeInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Inputs []*string `locationName:"inputs" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s DescribeInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputSecurityGroupOutput) SetArn(v string) *DescribeInputSecurityGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputSecurityGroupOutput) SetId(v string) *DescribeInputSecurityGroupOutput {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *DescribeInputSecurityGroupOutput) SetInputs(v []*string) *DescribeInputSecurityGroupOutput {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputSecurityGroupOutput) SetState(v string) *DescribeInputSecurityGroupOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeInputSecurityGroupOutput) SetTags(v map[string]*string) *DescribeInputSecurityGroupOutput {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *DescribeInputSecurityGroupOutput) SetWhitelistRules(v []*InputWhitelistRule) *DescribeInputSecurityGroupOutput {
	s.WhitelistRules = v
	return s
}

type DescribeMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DescribeMultiplexInput) SetMultiplexId(v string) *DescribeMultiplexInput {
	s.MultiplexId = &v
	return s
}

type DescribeMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeMultiplexOutput) SetArn(v string) *DescribeMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DescribeMultiplexOutput) SetAvailabilityZones(v []*string) *DescribeMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *DescribeMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeMultiplexOutput) SetId(v string) *DescribeMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *DescribeMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *DescribeMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeMultiplexOutput) SetName(v string) *DescribeMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DescribeMultiplexOutput) SetPipelinesRunningCount(v int64) *DescribeMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *DescribeMultiplexOutput) SetProgramCount(v int64) *DescribeMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeMultiplexOutput) SetState(v string) *DescribeMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeMultiplexOutput) SetTags(v map[string]*string) *DescribeMultiplexOutput {
	s.Tags = v
	return s
}

type DescribeMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DescribeMultiplexProgramInput) SetMultiplexId(v string) *DescribeMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeMultiplexProgramInput) SetProgramName(v string) *DescribeMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

type DescribeMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// Packet identifiers map for a given Multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation
func (s DescribeMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeMultiplexProgramOutput) SetChannelId(v string) *DescribeMultiplexProgramOutput {
	s.ChannelId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *DescribeMultiplexProgramOutput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *DescribeMultiplexProgramOutput {
	s.MultiplexProgramSettings = v
	return s
}

// SetPacketIdentifiersMap sets the PacketIdentifiersMap field's value.
func (s *DescribeMultiplexProgramOutput) SetPacketIdentifiersMap(v *MultiplexProgramPacketIdentifiersMap) *DescribeMultiplexProgramOutput {
	s.PacketIdentifiersMap = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeMultiplexProgramOutput) SetProgramName(v string) *DescribeMultiplexProgramOutput {
	s.ProgramName = &v
	return s
}

type DescribeOfferingInput struct {
	_ struct{} `type:"structure"`

	// OfferingId is a required field
	OfferingId *string `location:"uri" locationName:"offeringId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOfferingInput"}
	if s.OfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingId"))
	}
	if s.OfferingId != nil && len(*s.OfferingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeOfferingInput) SetOfferingId(v string) *DescribeOfferingInput {
	s.OfferingId = &v
	return s
}

type DescribeOfferingOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s DescribeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOfferingOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeOfferingOutput) SetArn(v string) *DescribeOfferingOutput {
	s.Arn = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DescribeOfferingOutput) SetCurrencyCode(v string) *DescribeOfferingOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeOfferingOutput) SetDuration(v int64) *DescribeOfferingOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DescribeOfferingOutput) SetDurationUnits(v string) *DescribeOfferingOutput {
	s.DurationUnits = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DescribeOfferingOutput) SetFixedPrice(v float64) *DescribeOfferingOutput {
	s.FixedPrice = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DescribeOfferingOutput) SetOfferingDescription(v string) *DescribeOfferingOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeOfferingOutput) SetOfferingId(v string) *DescribeOfferingOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeOfferingOutput) SetOfferingType(v string) *DescribeOfferingOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DescribeOfferingOutput) SetRegion(v string) *DescribeOfferingOutput {
	s.Region = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeOfferingOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DescribeOfferingOutput {
	s.ResourceSpecification = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DescribeOfferingOutput) SetUsagePrice(v float64) *DescribeOfferingOutput {
	s.UsagePrice = &v
	return s
}

type DescribeReservationInput struct {
	_ struct{} `type:"structure"`

	// ReservationId is a required field
	ReservationId *string `location:"uri" locationName:"reservationId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservationInput"}
	if s.ReservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationId"))
	}
	if s.ReservationId != nil && len(*s.ReservationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservationId sets the ReservationId field's value.
func (s *DescribeReservationInput) SetReservationId(v string) *DescribeReservationInput {
	s.ReservationId = &v
	return s
}

type DescribeReservationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"integer"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	End *string `locationName:"end" type:"string"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	Name *string `locationName:"name" type:"string"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	Start *string `locationName:"start" type:"string"`

	// Current reservation state
	State *string `locationName:"state" type:"string" enum:"ReservationState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s DescribeReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeReservationOutput) SetArn(v string) *DescribeReservationOutput {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *DescribeReservationOutput) SetCount(v int64) *DescribeReservationOutput {
	s.Count = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DescribeReservationOutput) SetCurrencyCode(v string) *DescribeReservationOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservationOutput) SetDuration(v int64) *DescribeReservationOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DescribeReservationOutput) SetDurationUnits(v string) *DescribeReservationOutput {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *DescribeReservationOutput) SetEnd(v string) *DescribeReservationOutput {
	s.End = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DescribeReservationOutput) SetFixedPrice(v float64) *DescribeReservationOutput {
	s.FixedPrice = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeReservationOutput) SetName(v string) *DescribeReservationOutput {
	s.Name = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DescribeReservationOutput) SetOfferingDescription(v string) *DescribeReservationOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeReservationOutput) SetOfferingId(v string) *DescribeReservationOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservationOutput) SetOfferingType(v string) *DescribeReservationOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DescribeReservationOutput) SetRegion(v string) *DescribeReservationOutput {
	s.Region = &v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *DescribeReservationOutput) SetReservationId(v string) *DescribeReservationOutput {
	s.ReservationId = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeReservationOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DescribeReservationOutput {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *DescribeReservationOutput) SetStart(v string) *DescribeReservationOutput {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeReservationOutput) SetState(v string) *DescribeReservationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeReservationOutput) SetTags(v map[string]*string) *DescribeReservationOutput {
	s.Tags = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DescribeReservationOutput) SetUsagePrice(v float64) *DescribeReservationOutput {
	s.UsagePrice = &v
	return s
}

type DescribeScheduleInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeScheduleInput) SetChannelId(v string) *DescribeScheduleInput {
	s.ChannelId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScheduleInput) SetMaxResults(v int64) *DescribeScheduleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduleInput) SetNextToken(v string) *DescribeScheduleInput {
	s.NextToken = &v
	return s
}

type DescribeScheduleOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list"`
}

// String returns the string representation
func (s DescribeScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduleOutput) SetNextToken(v string) *DescribeScheduleOutput {
	s.NextToken = &v
	return s
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *DescribeScheduleOutput) SetScheduleActions(v []*ScheduleAction) *DescribeScheduleOutput {
	s.ScheduleActions = v
	return s
}

// DVB Network Information Table (NIT)
type DvbNitSettings struct {
	_ struct{} `type:"structure"`

	// The numeric value placed in the Network Information Table (NIT).
	//
	// NetworkId is a required field
	NetworkId *int64 `locationName:"networkId" type:"integer" required:"true"`

	// The network name text placed in the networkNameDescriptor inside the Network
	// Information Table. Maximum length is 256 characters.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`
}

// String returns the string representation
func (s DvbNitSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbNitSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbNitSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbNitSettings"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.NetworkName != nil && len(*s.NetworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkName", 1))
	}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *DvbNitSettings) SetNetworkId(v int64) *DvbNitSettings {
	s.NetworkId = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *DvbNitSettings) SetNetworkName(v string) *DvbNitSettings {
	s.NetworkName = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbNitSettings) SetRepInterval(v int64) *DvbNitSettings {
	s.RepInterval = &v
	return s
}

// DVB Service Description Table (SDT)
type DvbSdtSettings struct {
	_ struct{} `type:"structure"`

	// Selects method of inserting SDT information into output stream. The sdtFollow
	// setting copies SDT information from input stream to output stream. The sdtFollowIfPresent
	// setting copies SDT information from input stream to output stream if SDT
	// information is present in the input, otherwise it will fall back on the user-defined
	// values. The sdtManual setting means user will enter the SDT information.
	// The sdtNone setting means output stream will not contain SDT information.
	OutputSdt *string `locationName:"outputSdt" type:"string" enum:"DvbSdtOutputSdt"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`

	// The service name placed in the serviceDescriptor in the Service Description
	// Table. Maximum length is 256 characters.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service provider name placed in the serviceDescriptor in the Service
	// Description Table. Maximum length is 256 characters.
	ServiceProviderName *string `locationName:"serviceProviderName" min:"1" type:"string"`
}

// String returns the string representation
func (s DvbSdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.ServiceProviderName != nil && len(*s.ServiceProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputSdt sets the OutputSdt field's value.
func (s *DvbSdtSettings) SetOutputSdt(v string) *DvbSdtSettings {
	s.OutputSdt = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbSdtSettings) SetRepInterval(v int64) *DvbSdtSettings {
	s.RepInterval = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DvbSdtSettings) SetServiceName(v string) *DvbSdtSettings {
	s.ServiceName = &v
	return s
}

// SetServiceProviderName sets the ServiceProviderName field's value.
func (s *DvbSdtSettings) SetServiceProviderName(v string) *DvbSdtSettings {
	s.ServiceProviderName = &v
	return s
}

// Dvb Sub Destination Settings
type DvbSubDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. This option is not valid for source captions that
	// are STL or 608/embedded. These source settings are already pre-defined by
	// the caption stream. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"DvbSubDestinationAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"DvbSubDestinationBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter blank is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"DvbSubDestinationFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to auto fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"DvbSubDestinationOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"DvbSubDestinationShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter blank is equivalent to setting it to 0 (transparent). All
	// burn-in and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"DvbSubDestinationTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// This option is not valid for source captions that are STL, 608/embedded or
	// teletext. These source settings are already pre-defined by the caption stream.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. This option
	// is not valid for source captions that are STL, 608/embedded or teletext.
	// These source settings are already pre-defined by the caption stream. All
	// burn-in and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s DvbSubDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSubDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *DvbSubDestinationSettings) SetAlignment(v string) *DvbSubDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *DvbSubDestinationSettings) SetBackgroundColor(v string) *DvbSubDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *DvbSubDestinationSettings) SetBackgroundOpacity(v int64) *DvbSubDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *DvbSubDestinationSettings) SetFont(v *InputLocation) *DvbSubDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *DvbSubDestinationSettings) SetFontColor(v string) *DvbSubDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *DvbSubDestinationSettings) SetFontOpacity(v int64) *DvbSubDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *DvbSubDestinationSettings) SetFontResolution(v int64) *DvbSubDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *DvbSubDestinationSettings) SetFontSize(v string) *DvbSubDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *DvbSubDestinationSettings) SetOutlineColor(v string) *DvbSubDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *DvbSubDestinationSettings) SetOutlineSize(v int64) *DvbSubDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *DvbSubDestinationSettings) SetShadowColor(v string) *DvbSubDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *DvbSubDestinationSettings) SetShadowOpacity(v int64) *DvbSubDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowXOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowYOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *DvbSubDestinationSettings) SetTeletextGridControl(v string) *DvbSubDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *DvbSubDestinationSettings) SetXPosition(v int64) *DvbSubDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *DvbSubDestinationSettings) SetYPosition(v int64) *DvbSubDestinationSettings {
	s.YPosition = &v
	return s
}

// Dvb Sub Source Settings
type DvbSubSourceSettings struct {
	_ struct{} `type:"structure"`

	// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source
	// content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through,
	// regardless of selectors.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s DvbSubSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSubSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubSourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *DvbSubSourceSettings) SetPid(v int64) *DvbSubSourceSettings {
	s.Pid = &v
	return s
}

// DVB Time and Date Table (SDT)
type DvbTdtSettings struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"1000" type:"integer"`
}

// String returns the string representation
func (s DvbTdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbTdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbTdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbTdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbTdtSettings) SetRepInterval(v int64) *DvbTdtSettings {
	s.RepInterval = &v
	return s
}

// Eac3 Settings
type Eac3Settings struct {
	_ struct{} `type:"structure"`

	// When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
	// Only used for 3/2 coding mode.
	AttenuationControl *string `locationName:"attenuationControl" type:"string" enum:"Eac3AttenuationControl"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC
	// A/52-2012 (Annex E) for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Eac3BitstreamMode"`

	// Dolby Digital Plus coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Eac3CodingMode"`

	// When set to enabled, activates a DC highpass filter for all input channels.
	DcFilter *string `locationName:"dcFilter" type:"string" enum:"Eac3DcFilter"`

	// Sets the dialnorm for the output. If blank and input audio is Dolby Digital
	// Plus, dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// Sets the Dolby dynamic range compression profile.
	DrcLine *string `locationName:"drcLine" type:"string" enum:"Eac3DrcLine"`

	// Sets the profile for heavy Dolby dynamic range compression, ensures that
	// the instantaneous signal peaks do not exceed specified levels.
	DrcRf *string `locationName:"drcRf" type:"string" enum:"Eac3DrcRf"`

	// When encoding 3/2 audio, setting to lfe enables the LFE channel
	LfeControl *string `locationName:"lfeControl" type:"string" enum:"Eac3LfeControl"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid with codingMode32 coding mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Eac3LfeFilter"`

	// Left only/Right only center mix level. Only used for 3/2 coding mode.
	LoRoCenterMixLevel *float64 `locationName:"loRoCenterMixLevel" type:"double"`

	// Left only/Right only surround mix level. Only used for 3/2 coding mode.
	LoRoSurroundMixLevel *float64 `locationName:"loRoSurroundMixLevel" type:"double"`

	// Left total/Right total center mix level. Only used for 3/2 coding mode.
	LtRtCenterMixLevel *float64 `locationName:"ltRtCenterMixLevel" type:"double"`

	// Left total/Right total surround mix level. Only used for 3/2 coding mode.
	LtRtSurroundMixLevel *float64 `locationName:"ltRtSurroundMixLevel" type:"double"`

	// When set to followInput, encoder metadata will be sourced from the DD, DD+,
	// or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Eac3MetadataControl"`

	// When set to whenPossible, input DD+ audio will be passed through if it is
	// present on the input. This detection is dynamic over the life of the transcode.
	// Inputs that alternate between DD+ and non-DD+ content will have a consistent
	// DD+ output as the system alternates between passthrough and encoding.
	PassthroughControl *string `locationName:"passthroughControl" type:"string" enum:"Eac3PassthroughControl"`

	// When set to shift90Degrees, applies a 90-degree phase shift to the surround
	// channels. Only used for 3/2 coding mode.
	PhaseControl *string `locationName:"phaseControl" type:"string" enum:"Eac3PhaseControl"`

	// Stereo downmix preference. Only used for 3/2 coding mode.
	StereoDownmix *string `locationName:"stereoDownmix" type:"string" enum:"Eac3StereoDownmix"`

	// When encoding 3/2 audio, sets whether an extra center back surround channel
	// is matrix encoded into the left and right surround channels.
	SurroundExMode *string `locationName:"surroundExMode" type:"string" enum:"Eac3SurroundExMode"`

	// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into
	// the two channels.
	SurroundMode *string `locationName:"surroundMode" type:"string" enum:"Eac3SurroundMode"`
}

// String returns the string representation
func (s Eac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Eac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Eac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttenuationControl sets the AttenuationControl field's value.
func (s *Eac3Settings) SetAttenuationControl(v string) *Eac3Settings {
	s.AttenuationControl = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *Eac3Settings) SetBitrate(v float64) *Eac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Eac3Settings) SetBitstreamMode(v string) *Eac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Eac3Settings) SetCodingMode(v string) *Eac3Settings {
	s.CodingMode = &v
	return s
}

// SetDcFilter sets the DcFilter field's value.
func (s *Eac3Settings) SetDcFilter(v string) *Eac3Settings {
	s.DcFilter = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Eac3Settings) SetDialnorm(v int64) *Eac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcLine sets the DrcLine field's value.
func (s *Eac3Settings) SetDrcLine(v string) *Eac3Settings {
	s.DrcLine = &v
	return s
}

// SetDrcRf sets the DrcRf field's value.
func (s *Eac3Settings) SetDrcRf(v string) *Eac3Settings {
	s.DrcRf = &v
	return s
}

// SetLfeControl sets the LfeControl field's value.
func (s *Eac3Settings) SetLfeControl(v string) *Eac3Settings {
	s.LfeControl = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Eac3Settings) SetLfeFilter(v string) *Eac3Settings {
	s.LfeFilter = &v
	return s
}

// SetLoRoCenterMixLevel sets the LoRoCenterMixLevel field's value.
func (s *Eac3Settings) SetLoRoCenterMixLevel(v float64) *Eac3Settings {
	s.LoRoCenterMixLevel = &v
	return s
}

// SetLoRoSurroundMixLevel sets the LoRoSurroundMixLevel field's value.
func (s *Eac3Settings) SetLoRoSurroundMixLevel(v float64) *Eac3Settings {
	s.LoRoSurroundMixLevel = &v
	return s
}

// SetLtRtCenterMixLevel sets the LtRtCenterMixLevel field's value.
func (s *Eac3Settings) SetLtRtCenterMixLevel(v float64) *Eac3Settings {
	s.LtRtCenterMixLevel = &v
	return s
}

// SetLtRtSurroundMixLevel sets the LtRtSurroundMixLevel field's value.
func (s *Eac3Settings) SetLtRtSurroundMixLevel(v float64) *Eac3Settings {
	s.LtRtSurroundMixLevel = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Eac3Settings) SetMetadataControl(v string) *Eac3Settings {
	s.MetadataControl = &v
	return s
}

// SetPassthroughControl sets the PassthroughControl field's value.
func (s *Eac3Settings) SetPassthroughControl(v string) *Eac3Settings {
	s.PassthroughControl = &v
	return s
}

// SetPhaseControl sets the PhaseControl field's value.
func (s *Eac3Settings) SetPhaseControl(v string) *Eac3Settings {
	s.PhaseControl = &v
	return s
}

// SetStereoDownmix sets the StereoDownmix field's value.
func (s *Eac3Settings) SetStereoDownmix(v string) *Eac3Settings {
	s.StereoDownmix = &v
	return s
}

// SetSurroundExMode sets the SurroundExMode field's value.
func (s *Eac3Settings) SetSurroundExMode(v string) *Eac3Settings {
	s.SurroundExMode = &v
	return s
}

// SetSurroundMode sets the SurroundMode field's value.
func (s *Eac3Settings) SetSurroundMode(v string) *Eac3Settings {
	s.SurroundMode = &v
	return s
}

// Ebu Tt DDestination Settings
type EbuTtDDestinationSettings struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle the gap between the lines (in multi-line captions).-
	// enabled: Fill with the captions background color (as specified in the input
	// captions).- disabled: Leave the gap unfilled.
	FillLineGap *string `locationName:"fillLineGap" type:"string" enum:"EbuTtDFillLineGapControl"`

	// Specifies the font family to include in the font data attached to the EBU-TT
	// captions. Valid only if styleControl is set to include. If you leave this
	// field empty, the font family is set to "monospaced". (If styleControl is
	// set to exclude, the font family is always set to "monospaced".)You specify
	// only the font family. All other style information (color, bold, position
	// and so on) is copied from the input captions. The size is always set to 100%
	// to allow the downstream player to choose the size.- Enter a list of font
	// families, as a comma-separated list of font names, in order of preference.
	// The name can be a font family (such as “Arial”), or a generic font family
	// (such as “serif”), or “default” (to let the downstream player choose
	// the font).- Leave blank to set the family to “monospace”.
	FontFamily *string `locationName:"fontFamily" type:"string"`

	// Specifies the style information (font color, font position, and so on) to
	// include in the font data that is attached to the EBU-TT captions.- include:
	// Take the style information (font color, font position, and so on) from the
	// source captions and include that information in the font data attached to
	// the EBU-TT captions. This option is valid only if the source captions are
	// Embedded or Teletext.- exclude: In the font data attached to the EBU-TT captions,
	// set the font family to "monospaced". Do not include any other style information.
	StyleControl *string `locationName:"styleControl" type:"string" enum:"EbuTtDDestinationStyleControl"`
}

// String returns the string representation
func (s EbuTtDDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbuTtDDestinationSettings) GoString() string {
	return s.String()
}

// SetFillLineGap sets the FillLineGap field's value.
func (s *EbuTtDDestinationSettings) SetFillLineGap(v string) *EbuTtDDestinationSettings {
	s.FillLineGap = &v
	return s
}

// SetFontFamily sets the FontFamily field's value.
func (s *EbuTtDDestinationSettings) SetFontFamily(v string) *EbuTtDDestinationSettings {
	s.FontFamily = &v
	return s
}

// SetStyleControl sets the StyleControl field's value.
func (s *EbuTtDDestinationSettings) SetStyleControl(v string) *EbuTtDDestinationSettings {
	s.StyleControl = &v
	return s
}

// Embedded Destination Settings
type EmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedDestinationSettings) GoString() string {
	return s.String()
}

// Embedded Plus Scte20 Destination Settings
type EmbeddedPlusScte20DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedPlusScte20DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedPlusScte20DestinationSettings) GoString() string {
	return s.String()
}

// Embedded Source Settings
type EmbeddedSourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 *string `locationName:"convert608To708" type:"string" enum:"EmbeddedConvert608To708"`

	// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20
	// and Embedded captions.
	Scte20Detection *string `locationName:"scte20Detection" type:"string" enum:"EmbeddedScte20Detection"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`

	// This field is unused and deprecated.
	Source608TrackNumber *int64 `locationName:"source608TrackNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s EmbeddedSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmbeddedSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmbeddedSourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608ChannelNumber", 1))
	}
	if s.Source608TrackNumber != nil && *s.Source608TrackNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608TrackNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConvert608To708 sets the Convert608To708 field's value.
func (s *EmbeddedSourceSettings) SetConvert608To708(v string) *EmbeddedSourceSettings {
	s.Convert608To708 = &v
	return s
}

// SetScte20Detection sets the Scte20Detection field's value.
func (s *EmbeddedSourceSettings) SetScte20Detection(v string) *EmbeddedSourceSettings {
	s.Scte20Detection = &v
	return s
}

// SetSource608ChannelNumber sets the Source608ChannelNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608ChannelNumber(v int64) *EmbeddedSourceSettings {
	s.Source608ChannelNumber = &v
	return s
}

// SetSource608TrackNumber sets the Source608TrackNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608TrackNumber(v int64) *EmbeddedSourceSettings {
	s.Source608TrackNumber = &v
	return s
}

// Encoder Settings
type EncoderSettings struct {
	_ struct{} `type:"structure"`

	// AudioDescriptions is a required field
	AudioDescriptions []*AudioDescription `locationName:"audioDescriptions" type:"list" required:"true"`

	// Settings for ad avail blanking.
	AvailBlanking *AvailBlanking `locationName:"availBlanking" type:"structure"`

	// Event-wide configuration settings for ad avail insertion.
	AvailConfiguration *AvailConfiguration `locationName:"availConfiguration" type:"structure"`

	// Settings for blackout slate.
	BlackoutSlate *BlackoutSlate `locationName:"blackoutSlate" type:"structure"`

	// Settings for caption decriptions
	CaptionDescriptions []*CaptionDescription `locationName:"captionDescriptions" type:"list"`

	// Feature Activations
	FeatureActivations *FeatureActivations `locationName:"featureActivations" type:"structure"`

	// Configuration settings that apply to the event as a whole.
	GlobalConfiguration *GlobalConfiguration `locationName:"globalConfiguration" type:"structure"`

	// Nielsen configuration settings.
	NielsenConfiguration *NielsenConfiguration `locationName:"nielsenConfiguration" type:"structure"`

	// OutputGroups is a required field
	OutputGroups []*OutputGroup `locationName:"outputGroups" type:"list" required:"true"`

	// Contains settings used to acquire and adjust timecode information from inputs.
	//
	// TimecodeConfig is a required field
	TimecodeConfig *TimecodeConfig `locationName:"timecodeConfig" type:"structure" required:"true"`

	// VideoDescriptions is a required field
	VideoDescriptions []*VideoDescription `locationName:"videoDescriptions" type:"list" required:"true"`
}

// String returns the string representation
func (s EncoderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncoderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncoderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncoderSettings"}
	if s.AudioDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioDescriptions"))
	}
	if s.OutputGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputGroups"))
	}
	if s.TimecodeConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TimecodeConfig"))
	}
	if s.VideoDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("VideoDescriptions"))
	}
	if s.AudioDescriptions != nil {
		for i, v := range s.AudioDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AvailBlanking != nil {
		if err := s.AvailBlanking.Validate(); err != nil {
			invalidParams.AddNested("AvailBlanking", err.(request.ErrInvalidParams))
		}
	}
	if s.AvailConfiguration != nil {
		if err := s.AvailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AvailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.BlackoutSlate != nil {
		if err := s.BlackoutSlate.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlate", err.(request.ErrInvalidParams))
		}
	}
	if s.CaptionDescriptions != nil {
		for i, v := range s.CaptionDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalConfiguration != nil {
		if err := s.GlobalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlobalConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputGroups != nil {
		for i, v := range s.OutputGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimecodeConfig != nil {
		if err := s.TimecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("TimecodeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VideoDescriptions != nil {
		for i, v := range s.VideoDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VideoDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDescriptions sets the AudioDescriptions field's value.
func (s *EncoderSettings) SetAudioDescriptions(v []*AudioDescription) *EncoderSettings {
	s.AudioDescriptions = v
	return s
}

// SetAvailBlanking sets the AvailBlanking field's value.
func (s *EncoderSettings) SetAvailBlanking(v *AvailBlanking) *EncoderSettings {
	s.AvailBlanking = v
	return s
}

// SetAvailConfiguration sets the AvailConfiguration field's value.
func (s *EncoderSettings) SetAvailConfiguration(v *AvailConfiguration) *EncoderSettings {
	s.AvailConfiguration = v
	return s
}

// SetBlackoutSlate sets the BlackoutSlate field's value.
func (s *EncoderSettings) SetBlackoutSlate(v *BlackoutSlate) *EncoderSettings {
	s.BlackoutSlate = v
	return s
}

// SetCaptionDescriptions sets the CaptionDescriptions field's value.
func (s *EncoderSettings) SetCaptionDescriptions(v []*CaptionDescription) *EncoderSettings {
	s.CaptionDescriptions = v
	return s
}

// SetFeatureActivations sets the FeatureActivations field's value.
func (s *EncoderSettings) SetFeatureActivations(v *FeatureActivations) *EncoderSettings {
	s.FeatureActivations = v
	return s
}

// SetGlobalConfiguration sets the GlobalConfiguration field's value.
func (s *EncoderSettings) SetGlobalConfiguration(v *GlobalConfiguration) *EncoderSettings {
	s.GlobalConfiguration = v
	return s
}

// SetNielsenConfiguration sets the NielsenConfiguration field's value.
func (s *EncoderSettings) SetNielsenConfiguration(v *NielsenConfiguration) *EncoderSettings {
	s.NielsenConfiguration = v
	return s
}

// SetOutputGroups sets the OutputGroups field's value.
func (s *EncoderSettings) SetOutputGroups(v []*OutputGroup) *EncoderSettings {
	s.OutputGroups = v
	return s
}

// SetTimecodeConfig sets the TimecodeConfig field's value.
func (s *EncoderSettings) SetTimecodeConfig(v *TimecodeConfig) *EncoderSettings {
	s.TimecodeConfig = v
	return s
}

// SetVideoDescriptions sets the VideoDescriptions field's value.
func (s *EncoderSettings) SetVideoDescriptions(v []*VideoDescription) *EncoderSettings {
	s.VideoDescriptions = v
	return s
}

// Feature Activations
type FeatureActivations struct {
	_ struct{} `type:"structure"`

	// Enables the Input Prepare feature. You can create Input Prepare actions in
	// the schedule only if this feature is enabled.If you disable the feature on
	// an existing schedule, make sure that you first delete all input prepare actions
	// from the schedule.
	InputPrepareScheduleActions *string `locationName:"inputPrepareScheduleActions" type:"string" enum:"FeatureActivationsInputPrepareScheduleActions"`
}

// String returns the string representation
func (s FeatureActivations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureActivations) GoString() string {
	return s.String()
}

// SetInputPrepareScheduleActions sets the InputPrepareScheduleActions field's value.
func (s *FeatureActivations) SetInputPrepareScheduleActions(v string) *FeatureActivations {
	s.InputPrepareScheduleActions = &v
	return s
}

// Fec Output Settings
type FecOutputSettings struct {
	_ struct{} `type:"structure"`

	// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The
	// number of transport stream packets per column error correction packet. Must
	// be between 4 and 20, inclusive.
	ColumnDepth *int64 `locationName:"columnDepth" min:"4" type:"integer"`

	// Enables column only or column and row based FEC
	IncludeFec *string `locationName:"includeFec" type:"string" enum:"FecOutputIncludeFec"`

	// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must
	// be between 1 and 20, inclusive. If only Column FEC is used, then larger values
	// increase robustness. If Row FEC is used, then this is the number of transport
	// stream packets per row error correction packet, and the value must be between
	// 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column,
	// this value must be 1 to 20, inclusive.
	RowLength *int64 `locationName:"rowLength" min:"1" type:"integer"`
}

// String returns the string representation
func (s FecOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FecOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FecOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FecOutputSettings"}
	if s.ColumnDepth != nil && *s.ColumnDepth < 4 {
		invalidParams.Add(request.NewErrParamMinValue("ColumnDepth", 4))
	}
	if s.RowLength != nil && *s.RowLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RowLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnDepth sets the ColumnDepth field's value.
func (s *FecOutputSettings) SetColumnDepth(v int64) *FecOutputSettings {
	s.ColumnDepth = &v
	return s
}

// SetIncludeFec sets the IncludeFec field's value.
func (s *FecOutputSettings) SetIncludeFec(v string) *FecOutputSettings {
	s.IncludeFec = &v
	return s
}

// SetRowLength sets the RowLength field's value.
func (s *FecOutputSettings) SetRowLength(v int64) *FecOutputSettings {
	s.RowLength = &v
	return s
}

// Start time for the action.
type FixedModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Start time for the action to start in the channel. (Not the time for the
	// action to be added to the schedule: actions are always added to the schedule
	// immediately.) UTC format: yyyy-mm-ddThh:mm:ss.nnnZ. All the letters are digits
	// (for example, mm might be 01) except for the two constants "T" for time and
	// "Z" for "UTC format".
	//
	// Time is a required field
	Time *string `locationName:"time" type:"string" required:"true"`
}

// String returns the string representation
func (s FixedModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FixedModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedModeScheduleActionStartSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedModeScheduleActionStartSettings"}
	if s.Time == nil {
		invalidParams.Add(request.NewErrParamRequired("Time"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTime sets the Time field's value.
func (s *FixedModeScheduleActionStartSettings) SetTime(v string) *FixedModeScheduleActionStartSettings {
	s.Time = &v
	return s
}

// Fmp4 Hls Settings
type Fmp4HlsSettings struct {
	_ struct{} `type:"structure"`

	// List all the audio groups that are used with the video output stream. Input
	// all the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string `locationName:"audioRenditionSets" type:"string"`

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in
	// the output.
	NielsenId3Behavior *string `locationName:"nielsenId3Behavior" type:"string" enum:"Fmp4NielsenId3Behavior"`

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"Fmp4TimedMetadataBehavior"`
}

// String returns the string representation
func (s Fmp4HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fmp4HlsSettings) GoString() string {
	return s.String()
}

// SetAudioRenditionSets sets the AudioRenditionSets field's value.
func (s *Fmp4HlsSettings) SetAudioRenditionSets(v string) *Fmp4HlsSettings {
	s.AudioRenditionSets = &v
	return s
}

// SetNielsenId3Behavior sets the NielsenId3Behavior field's value.
func (s *Fmp4HlsSettings) SetNielsenId3Behavior(v string) *Fmp4HlsSettings {
	s.NielsenId3Behavior = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *Fmp4HlsSettings) SetTimedMetadataBehavior(v string) *Fmp4HlsSettings {
	s.TimedMetadataBehavior = &v
	return s
}

// Settings to specify if an action follows another.
type FollowModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Identifies whether this action starts relative to the start or relative to
	// the end of the reference action.
	//
	// FollowPoint is a required field
	FollowPoint *string `locationName:"followPoint" type:"string" required:"true" enum:"FollowPoint"`

	// The action name of another action that this one refers to.
	//
	// ReferenceActionName is a required field
	ReferenceActionName *string `locationName:"referenceActionName" type:"string" required:"true"`
}

// String returns the string representation
func (s FollowModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FollowModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FollowModeScheduleActionStartSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FollowModeScheduleActionStartSettings"}
	if s.FollowPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("FollowPoint"))
	}
	if s.ReferenceActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceActionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFollowPoint sets the FollowPoint field's value.
func (s *FollowModeScheduleActionStartSettings) SetFollowPoint(v string) *FollowModeScheduleActionStartSettings {
	s.FollowPoint = &v
	return s
}

// SetReferenceActionName sets the ReferenceActionName field's value.
func (s *FollowModeScheduleActionStartSettings) SetReferenceActionName(v string) *FollowModeScheduleActionStartSettings {
	s.ReferenceActionName = &v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Frame Capture Group Settings
type FrameCaptureGroupSettings struct {
	_ struct{} `type:"structure"`

	// The destination for the frame capture files. Either the URI for an Amazon
	// S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_)
	// or the URI for a MediaStore container, plus a file name prefix (for example,
	// mediastoressl://sportsDelivery/20180820/curling_). The final file names consist
	// of the prefix from the destination field (for example, "curling_") + name
	// modifier + the counter (5 digits, starting from 00001) + extension (which
	// is always .jpg). For example, curlingLow.00001.jpg
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation
func (s FrameCaptureGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FrameCaptureGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrameCaptureGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *FrameCaptureGroupSettings) SetDestination(v *OutputLocationRef) *FrameCaptureGroupSettings {
	s.Destination = v
	return s
}

// Frame Capture Output Settings
type FrameCaptureOutputSettings struct {
	_ struct{} `type:"structure"`

	// Required if the output group contains more than one output. This modifier
	// forms part of the output file name.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s FrameCaptureOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FrameCaptureOutputSettings) GoString() string {
	return s.String()
}

// SetNameModifier sets the NameModifier field's value.
func (s *FrameCaptureOutputSettings) SetNameModifier(v string) *FrameCaptureOutputSettings {
	s.NameModifier = &v
	return s
}

// Frame Capture Settings
type FrameCaptureSettings struct {
	_ struct{} `type:"structure"`

	// The frequency at which to capture frames for inclusion in the output. May
	// be specified in either seconds or milliseconds, as specified by captureIntervalUnits.
	//
	// CaptureInterval is a required field
	CaptureInterval *int64 `locationName:"captureInterval" min:"1" type:"integer" required:"true"`

	// Unit for the frame capture interval.
	CaptureIntervalUnits *string `locationName:"captureIntervalUnits" type:"string" enum:"FrameCaptureIntervalUnit"`
}

// String returns the string representation
func (s FrameCaptureSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FrameCaptureSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrameCaptureSettings"}
	if s.CaptureInterval == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureInterval"))
	}
	if s.CaptureInterval != nil && *s.CaptureInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CaptureInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureInterval sets the CaptureInterval field's value.
func (s *FrameCaptureSettings) SetCaptureInterval(v int64) *FrameCaptureSettings {
	s.CaptureInterval = &v
	return s
}

// SetCaptureIntervalUnits sets the CaptureIntervalUnits field's value.
func (s *FrameCaptureSettings) SetCaptureIntervalUnits(v string) *FrameCaptureSettings {
	s.CaptureIntervalUnits = &v
	return s
}

type GatewayTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s GatewayTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayTimeoutException) GoString() string {
	return s.String()
}

func newErrorGatewayTimeoutException(v protocol.ResponseMetadata) error {
	return &GatewayTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GatewayTimeoutException) Code() string {
	return "GatewayTimeoutException"
}

// Message returns the exception's message.
func (s *GatewayTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GatewayTimeoutException) OrigErr() error {
	return nil
}

func (s *GatewayTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GatewayTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GatewayTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Global Configuration
type GlobalConfiguration struct {
	_ struct{} `type:"structure"`

	// Value to set the initial audio gain for the Live Event.
	InitialAudioGain *int64 `locationName:"initialAudioGain" type:"integer"`

	// Indicates the action to take when the current input completes (e.g. end-of-file).
	// When switchAndLoopInputs is configured the encoder will restart at the beginning
	// of the first input. When "none" is configured the encoder will transcode
	// either black, a solid color, or a user specified slate images per the "Input
	// Loss Behavior" configuration until the next input switch occurs (which is
	// controlled through the Channel Schedule API).
	InputEndAction *string `locationName:"inputEndAction" type:"string" enum:"GlobalConfigurationInputEndAction"`

	// Settings for system actions when input is lost.
	InputLossBehavior *InputLossBehavior `locationName:"inputLossBehavior" type:"structure"`

	// Indicates how MediaLive pipelines are synchronized.PIPELINE_LOCKING - MediaLive
	// will attempt to synchronize the output of each pipeline to the other.EPOCH_LOCKING
	// - MediaLive will attempt to synchronize the output of each pipeline to the
	// Unix epoch.
	OutputLockingMode *string `locationName:"outputLockingMode" type:"string" enum:"GlobalConfigurationOutputLockingMode"`

	// Indicates whether the rate of frames emitted by the Live encoder should be
	// paced by its system clock (which optionally may be locked to another source
	// via NTP) or should be locked to the clock of the source that is providing
	// the input stream.
	OutputTimingSource *string `locationName:"outputTimingSource" type:"string" enum:"GlobalConfigurationOutputTimingSource"`

	// Adjusts video input buffer for streams with very low video framerates. This
	// is commonly set to enabled for music channels with less than one video frame
	// per second.
	SupportLowFramerateInputs *string `locationName:"supportLowFramerateInputs" type:"string" enum:"GlobalConfigurationLowFramerateInputs"`
}

// String returns the string representation
func (s GlobalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalConfiguration"}
	if s.InitialAudioGain != nil && *s.InitialAudioGain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("InitialAudioGain", -60))
	}
	if s.InputLossBehavior != nil {
		if err := s.InputLossBehavior.Validate(); err != nil {
			invalidParams.AddNested("InputLossBehavior", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialAudioGain sets the InitialAudioGain field's value.
func (s *GlobalConfiguration) SetInitialAudioGain(v int64) *GlobalConfiguration {
	s.InitialAudioGain = &v
	return s
}

// SetInputEndAction sets the InputEndAction field's value.
func (s *GlobalConfiguration) SetInputEndAction(v string) *GlobalConfiguration {
	s.InputEndAction = &v
	return s
}

// SetInputLossBehavior sets the InputLossBehavior field's value.
func (s *GlobalConfiguration) SetInputLossBehavior(v *InputLossBehavior) *GlobalConfiguration {
	s.InputLossBehavior = v
	return s
}

// SetOutputLockingMode sets the OutputLockingMode field's value.
func (s *GlobalConfiguration) SetOutputLockingMode(v string) *GlobalConfiguration {
	s.OutputLockingMode = &v
	return s
}

// SetOutputTimingSource sets the OutputTimingSource field's value.
func (s *GlobalConfiguration) SetOutputTimingSource(v string) *GlobalConfiguration {
	s.OutputTimingSource = &v
	return s
}

// SetSupportLowFramerateInputs sets the SupportLowFramerateInputs field's value.
func (s *GlobalConfiguration) SetSupportLowFramerateInputs(v string) *GlobalConfiguration {
	s.SupportLowFramerateInputs = &v
	return s
}

// H264 Color Space Settings
type H264ColorSpaceSettings struct {
	_ struct{} `type:"structure"`

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings `locationName:"colorSpacePassthroughSettings" type:"structure"`

	// Rec601 Settings
	Rec601Settings *Rec601Settings `locationName:"rec601Settings" type:"structure"`

	// Rec709 Settings
	Rec709Settings *Rec709Settings `locationName:"rec709Settings" type:"structure"`
}

// String returns the string representation
func (s H264ColorSpaceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H264ColorSpaceSettings) GoString() string {
	return s.String()
}

// SetColorSpacePassthroughSettings sets the ColorSpacePassthroughSettings field's value.
func (s *H264ColorSpaceSettings) SetColorSpacePassthroughSettings(v *ColorSpacePassthroughSettings) *H264ColorSpaceSettings {
	s.ColorSpacePassthroughSettings = v
	return s
}

// SetRec601Settings sets the Rec601Settings field's value.
func (s *H264ColorSpaceSettings) SetRec601Settings(v *Rec601Settings) *H264ColorSpaceSettings {
	s.Rec601Settings = v
	return s
}

// SetRec709Settings sets the Rec709Settings field's value.
func (s *H264ColorSpaceSettings) SetRec709Settings(v *Rec709Settings) *H264ColorSpaceSettings {
	s.Rec709Settings = v
	return s
}

// H264 Filter Settings
type H264FilterSettings struct {
	_ struct{} `type:"structure"`

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings `locationName:"temporalFilterSettings" type:"structure"`
}

// String returns the string representation
func (s H264FilterSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H264FilterSettings) GoString() string {
	return s.String()
}

// SetTemporalFilterSettings sets the TemporalFilterSettings field's value.
func (s *H264FilterSettings) SetTemporalFilterSettings(v *TemporalFilterSettings) *H264FilterSettings {
	s.TemporalFilterSettings = v
	return s
}

// H264 Settings
type H264Settings struct {
	_ struct{} `type:"structure"`

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization *string `locationName:"adaptiveQuantization" type:"string" enum:"H264AdaptiveQuantization"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling *string `locationName:"afdSignaling" type:"string" enum:"AfdSignaling"`

	// Average bitrate in bits/second. Required when the rate control mode is VBR
	// or CBR. Not used for QVBR. In an MS Smooth output group, each output must
	// have a unique value when its bitrate is rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"1000" type:"integer"`

	// Percentage of the buffer that should initially be filled (HRD buffer model).
	BufFillPct *int64 `locationName:"bufFillPct" type:"integer"`

	// Size of buffer (HRD buffer model) in bits.
	BufSize *int64 `locationName:"bufSize" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata *string `locationName:"colorMetadata" type:"string" enum:"H264ColorMetadata"`

	// Color Space settings
	ColorSpaceSettings *H264ColorSpaceSettings `locationName:"colorSpaceSettings" type:"structure"`

	// Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
	EntropyEncoding *string `locationName:"entropyEncoding" type:"string" enum:"H264EntropyEncoding"`

	// Optional filters that you can apply to an encode.
	FilterSettings *H264FilterSettings `locationName:"filterSettings" type:"structure"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd *string `locationName:"fixedAfd" type:"string" enum:"FixedAfd"`

	// If set to enabled, adjust quantization within each frame to reduce flicker
	// or 'pop' on I-frames.
	FlickerAq *string `locationName:"flickerAq" type:"string" enum:"H264FlickerAq"`

	// This setting applies only when scan type is "interlaced." It controls whether
	// coding is performed on a field basis or on a frame basis. (When the video
	// is progressive, the coding is always performed on a frame basis.)enabled:
	// Force MediaLive to code on a field basis, so that odd and even sets of fields
	// are coded separately.disabled: Code the two sets of fields separately (on
	// a field basis) or together (on a frame basis using PAFF), depending on what
	// is most appropriate for the content.
	ForceFieldPictures *string `locationName:"forceFieldPictures" type:"string" enum:"H264ForceFieldPictures"`

	// This field indicates how the output video frame rate is specified. If "specified"
	// is selected then the output video frame rate is determined by framerateNumerator
	// and framerateDenominator, else if "initializeFromSource" is selected then
	// the output video frame rate will be set equal to the input video frame rate
	// of the first input.
	FramerateControl *string `locationName:"framerateControl" type:"string" enum:"H264FramerateControl"`

	// Framerate denominator.
	FramerateDenominator *int64 `locationName:"framerateDenominator" min:"1" type:"integer"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	FramerateNumerator *int64 `locationName:"framerateNumerator" min:"1" type:"integer"`

	// If enabled, use reference B frames for GOP structures that have B frames
	// > 1.
	GopBReference *string `locationName:"gopBReference" type:"string" enum:"H264GopBReference"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// Number of B-frames between reference frames.
	GopNumBFrames *int64 `locationName:"gopNumBFrames" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If
	// gopSizeUnits is frames, gopSize must be an integer and must be greater than
	// or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0,
	// but need not be an integer.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits *string `locationName:"gopSizeUnits" type:"string" enum:"H264GopSizeUnits"`

	// H.264 Level.
	Level *string `locationName:"level" type:"string" enum:"H264Level"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl *string `locationName:"lookAheadRateControl" type:"string" enum:"H264LookAheadRateControl"`

	// For QVBR: See the tooltip for Quality levelFor VBR: Set the maximum bitrate
	// in order to accommodate expected spikes in the complexity of the video.
	MaxBitrate *int64 `locationName:"maxBitrate" min:"1000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the
	// next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// Number of reference frames to use. The encoder may use more than requested
	// if using B-frames and/or interlaced encoding.
	NumRefFrames *int64 `locationName:"numRefFrames" min:"1" type:"integer"`

	// This field indicates how the output pixel aspect ratio is specified. If "specified"
	// is selected then the output video pixel aspect ratio is determined by parNumerator
	// and parDenominator, else if "initializeFromSource" is selected then the output
	// pixsel aspect ratio will be set equal to the input video pixel aspect ratio
	// of the first input.
	ParControl *string `locationName:"parControl" type:"string" enum:"H264ParControl"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" min:"1" type:"integer"`

	// H.264 Profile.
	Profile *string `locationName:"profile" type:"string" enum:"H264Profile"`

	// Leave as STANDARD_QUALITY or choose a different value (which might result
	// in additional costs to run the channel).- ENHANCED_QUALITY: Produces a slightly
	// better video quality without an increase in the bitrate. Has an effect only
	// when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive
	// multiplex, the value must be ENHANCED_QUALITY.- STANDARD_QUALITY: Valid for
	// any Rate control mode.
	QualityLevel *string `locationName:"qualityLevel" type:"string" enum:"H264QualityLevel"`

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. Set values for the QVBR quality level field and Max
	// bitrate field that suit your most important viewing devices. Recommended
	// values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC
	// or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality
	// level: 6. Max bitrate: 1M to 1.5M
	QvbrQualityLevel *int64 `locationName:"qvbrQualityLevel" min:"1" type:"integer"`

	// Rate control mode.QVBR: Quality will match the specified quality level except
	// when it is constrained by themaximum bitrate. Recommended if you or your
	// viewers pay for bandwidth.VBR: Quality and bitrate vary, depending on the
	// video complexity. Recommended instead of QVBRif you want to maintain a specific
	// average bitrate over the duration of the channel.CBR: Quality varies, depending
	// on the video complexity. Recommended only if you distributeyour assets to
	// devices that cannot handle variable bitrates.Multiplex: This rate control
	// mode is only supported (and is required) when the video is beingdelivered
	// to a MediaLive Multiplex in which case the rate control configuration is
	// controlledby the properties within the Multiplex Program.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"H264RateControlMode"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType *string `locationName:"scanType" type:"string" enum:"H264ScanType"`

	// Scene change detection.- On: inserts I-frames when scene change is detected.-
	// Off: does not force an I-frame when scene change is detected.
	SceneChangeDetect *string `locationName:"sceneChangeDetect" type:"string" enum:"H264SceneChangeDetect"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// Softness. Selects quantizer matrix, larger values reduce high-frequency content
	// in the encoded image.
	Softness *int64 `locationName:"softness" type:"integer"`

	// If set to enabled, adjust quantization within each frame based on spatial
	// variation of content complexity.
	SpatialAq *string `locationName:"spatialAq" type:"string" enum:"H264SpatialAq"`

	// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic,
	// optimize the number of B-frames used for each sub-GOP to improve visual quality.
	SubgopLength *string `locationName:"subgopLength" type:"string" enum:"H264SubGopLength"`

	// Produces a bitstream compliant with SMPTE RP-2027.
	Syntax *string `locationName:"syntax" type:"string" enum:"H264Syntax"`

	// If set to enabled, adjust quantization within each frame based on temporal
	// variation of content complexity.
	TemporalAq *string `locationName:"temporalAq" type:"string" enum:"H264TemporalAq"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion *string `locationName:"timecodeInsertion" type:"string" enum:"H264TimecodeInsertionBehavior"`
}

// String returns the string representation
func (s H264Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H264Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H264Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "H264Settings"}
	if s.Bitrate != nil && *s.Bitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 1000))
	}
	if s.FramerateDenominator != nil && *s.FramerateDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateDenominator", 1))
	}
	if s.FramerateNumerator != nil && *s.FramerateNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateNumerator", 1))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBitrate", 1000))
	}
	if s.NumRefFrames != nil && *s.NumRefFrames < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumRefFrames", 1))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.ParNumerator != nil && *s.ParNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParNumerator", 1))
	}
	if s.QvbrQualityLevel != nil && *s.QvbrQualityLevel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("QvbrQualityLevel", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Slices", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdaptiveQuantization sets the AdaptiveQuantization field's value.
func (s *H264Settings) SetAdaptiveQuantization(v string) *H264Settings {
	s.AdaptiveQuantization = &v
	return s
}

// SetAfdSignaling sets the AfdSignaling field's value.
func (s *H264Settings) SetAfdSignaling(v string) *H264Settings {
	s.AfdSignaling = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *H264Settings) SetBitrate(v int64) *H264Settings {
	s.Bitrate = &v
	return s
}

// SetBufFillPct sets the BufFillPct field's value.
func (s *H264Settings) SetBufFillPct(v int64) *H264Settings {
	s.BufFillPct = &v
	return s
}

// SetBufSize sets the BufSize field's value.
func (s *H264Settings) SetBufSize(v int64) *H264Settings {
	s.BufSize = &v
	return s
}

// SetColorMetadata sets the ColorMetadata field's value.
func (s *H264Settings) SetColorMetadata(v string) *H264Settings {
	s.ColorMetadata = &v
	return s
}

// SetColorSpaceSettings sets the ColorSpaceSettings field's value.
func (s *H264Settings) SetColorSpaceSettings(v *H264ColorSpaceSettings) *H264Settings {
	s.ColorSpaceSettings = v
	return s
}

// SetEntropyEncoding sets the EntropyEncoding field's value.
func (s *H264Settings) SetEntropyEncoding(v string) *H264Settings {
	s.EntropyEncoding = &v
	return s
}

// SetFilterSettings sets the FilterSettings field's value.
func (s *H264Settings) SetFilterSettings(v *H264FilterSettings) *H264Settings {
	s.FilterSettings = v
	return s
}

// SetFixedAfd sets the FixedAfd field's value.
func (s *H264Settings) SetFixedAfd(v string) *H264Settings {
	s.FixedAfd = &v
	return s
}

// SetFlickerAq sets the FlickerAq field's value.
func (s *H264Settings) SetFlickerAq(v string) *H264Settings {
	s.FlickerAq = &v
	return s
}

// SetForceFieldPictures sets the ForceFieldPictures field's value.
func (s *H264Settings) SetForceFieldPictures(v string) *H264Settings {
	s.ForceFieldPictures = &v
	return s
}

// SetFramerateControl sets the FramerateControl field's value.
func (s *H264Settings) SetFramerateControl(v string) *H264Settings {
	s.FramerateControl = &v
	return s
}

// SetFramerateDenominator sets the FramerateDenominator field's value.
func (s *H264Settings) SetFramerateDenominator(v int64) *H264Settings {
	s.FramerateDenominator = &v
	return s
}

// SetFramerateNumerator sets the FramerateNumerator field's value.
func (s *H264Settings) SetFramerateNumerator(v int64) *H264Settings {
	s.FramerateNumerator = &v
	return s
}

// SetGopBReference sets the GopBReference field's value.
func (s *H264Settings) SetGopBReference(v string) *H264Settings {
	s.GopBReference = &v
	return s
}

// SetGopClosedCadence sets the GopClosedCadence field's value.
func (s *H264Settings) SetGopClosedCadence(v int64) *H264Settings {
	s.GopClosedCadence = &v
	return s
}

// SetGopNumBFrames sets the GopNumBFrames field's value.
func (s *H264Settings) SetGopNumBFrames(v int64) *H264Settings {
	s.GopNumBFrames = &v
	return s
}

// SetGopSize sets the GopSize field's value.
func (s *H264Settings) SetGopSize(v float64) *H264Settings {
	s.GopSize = &v
	return s
}

// SetGopSizeUnits sets the GopSizeUnits field's value.
func (s *H264Settings) SetGopSizeUnits(v string) *H264Settings {
	s.GopSizeUnits = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *H264Settings) SetLevel(v string) *H264Settings {
	s.Level = &v
	return s
}

// SetLookAheadRateControl sets the LookAheadRateControl field's value.
func (s *H264Settings) SetLookAheadRateControl(v string) *H264Settings {
	s.LookAheadRateControl = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *H264Settings) SetMaxBitrate(v int64) *H264Settings {
	s.MaxBitrate = &v
	return s
}

// SetMinIInterval sets the MinIInterval field's value.
func (s *H264Settings) SetMinIInterval(v int64) *H264Settings {
	s.MinIInterval = &v
	return s
}

// SetNumRefFrames sets the NumRefFrames field's value.
func (s *H264Settings) SetNumRefFrames(v int64) *H264Settings {
	s.NumRefFrames = &v
	return s
}

// SetParControl sets the ParControl field's value.
func (s *H264Settings) SetParControl(v string) *H264Settings {
	s.ParControl = &v
	return s
}

// SetParDenominator sets the ParDenominator field's value.
func (s *H264Settings) SetParDenominator(v int64) *H264Settings {
	s.ParDenominator = &v
	return s
}

// SetParNumerator sets the ParNumerator field's value.
func (s *H264Settings) SetParNumerator(v int64) *H264Settings {
	s.ParNumerator = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *H264Settings) SetProfile(v string) *H264Settings {
	s.Profile = &v
	return s
}

// SetQualityLevel sets the QualityLevel field's value.
func (s *H264Settings) SetQualityLevel(v string) *H264Settings {
	s.QualityLevel = &v
	return s
}

// SetQvbrQualityLevel sets the QvbrQualityLevel field's value.
func (s *H264Settings) SetQvbrQualityLevel(v int64) *H264Settings {
	s.QvbrQualityLevel = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *H264Settings) SetRateControlMode(v string) *H264Settings {
	s.RateControlMode = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *H264Settings) SetScanType(v string) *H264Settings {
	s.ScanType = &v
	return s
}

// SetSceneChangeDetect sets the SceneChangeDetect field's value.
func (s *H264Settings) SetSceneChangeDetect(v string) *H264Settings {
	s.SceneChangeDetect = &v
	return s
}

// SetSlices sets the Slices field's value.
func (s *H264Settings) SetSlices(v int64) *H264Settings {
	s.Slices = &v
	return s
}

// SetSoftness sets the Softness field's value.
func (s *H264Settings) SetSoftness(v int64) *H264Settings {
	s.Softness = &v
	return s
}

// SetSpatialAq sets the SpatialAq field's value.
func (s *H264Settings) SetSpatialAq(v string) *H264Settings {
	s.SpatialAq = &v
	return s
}

// SetSubgopLength sets the SubgopLength field's value.
func (s *H264Settings) SetSubgopLength(v string) *H264Settings {
	s.SubgopLength = &v
	return s
}

// SetSyntax sets the Syntax field's value.
func (s *H264Settings) SetSyntax(v string) *H264Settings {
	s.Syntax = &v
	return s
}

// SetTemporalAq sets the TemporalAq field's value.
func (s *H264Settings) SetTemporalAq(v string) *H264Settings {
	s.TemporalAq = &v
	return s
}

// SetTimecodeInsertion sets the TimecodeInsertion field's value.
func (s *H264Settings) SetTimecodeInsertion(v string) *H264Settings {
	s.TimecodeInsertion = &v
	return s
}

// H265 Color Space Settings
type H265ColorSpaceSettings struct {
	_ struct{} `type:"structure"`

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings `locationName:"colorSpacePassthroughSettings" type:"structure"`

	// Hdr10 Settings
	Hdr10Settings *Hdr10Settings `locationName:"hdr10Settings" type:"structure"`

	// Rec601 Settings
	Rec601Settings *Rec601Settings `locationName:"rec601Settings" type:"structure"`

	// Rec709 Settings
	Rec709Settings *Rec709Settings `locationName:"rec709Settings" type:"structure"`
}

// String returns the string representation
func (s H265ColorSpaceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H265ColorSpaceSettings) GoString() string {
	return s.String()
}

// SetColorSpacePassthroughSettings sets the ColorSpacePassthroughSettings field's value.
func (s *H265ColorSpaceSettings) SetColorSpacePassthroughSettings(v *ColorSpacePassthroughSettings) *H265ColorSpaceSettings {
	s.ColorSpacePassthroughSettings = v
	return s
}

// SetHdr10Settings sets the Hdr10Settings field's value.
func (s *H265ColorSpaceSettings) SetHdr10Settings(v *Hdr10Settings) *H265ColorSpaceSettings {
	s.Hdr10Settings = v
	return s
}

// SetRec601Settings sets the Rec601Settings field's value.
func (s *H265ColorSpaceSettings) SetRec601Settings(v *Rec601Settings) *H265ColorSpaceSettings {
	s.Rec601Settings = v
	return s
}

// SetRec709Settings sets the Rec709Settings field's value.
func (s *H265ColorSpaceSettings) SetRec709Settings(v *Rec709Settings) *H265ColorSpaceSettings {
	s.Rec709Settings = v
	return s
}

// H265 Filter Settings
type H265FilterSettings struct {
	_ struct{} `type:"structure"`

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings `locationName:"temporalFilterSettings" type:"structure"`
}

// String returns the string representation
func (s H265FilterSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H265FilterSettings) GoString() string {
	return s.String()
}

// SetTemporalFilterSettings sets the TemporalFilterSettings field's value.
func (s *H265FilterSettings) SetTemporalFilterSettings(v *TemporalFilterSettings) *H265FilterSettings {
	s.TemporalFilterSettings = v
	return s
}

// H265 Settings
type H265Settings struct {
	_ struct{} `type:"structure"`

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization *string `locationName:"adaptiveQuantization" type:"string" enum:"H265AdaptiveQuantization"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling *string `locationName:"afdSignaling" type:"string" enum:"AfdSignaling"`

	// Whether or not EML should insert an Alternative Transfer Function SEI message
	// to support backwards compatibility with non-HDR decoders and displays.
	AlternativeTransferFunction *string `locationName:"alternativeTransferFunction" type:"string" enum:"H265AlternativeTransferFunction"`

	// Average bitrate in bits/second. Required when the rate control mode is VBR
	// or CBR. Not used for QVBR. In an MS Smooth output group, each output must
	// have a unique value when its bitrate is rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"100000" type:"integer"`

	// Size of buffer (HRD buffer model) in bits.
	BufSize *int64 `locationName:"bufSize" min:"100000" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata *string `locationName:"colorMetadata" type:"string" enum:"H265ColorMetadata"`

	// Color Space settings
	ColorSpaceSettings *H265ColorSpaceSettings `locationName:"colorSpaceSettings" type:"structure"`

	// Optional filters that you can apply to an encode.
	FilterSettings *H265FilterSettings `locationName:"filterSettings" type:"structure"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd *string `locationName:"fixedAfd" type:"string" enum:"FixedAfd"`

	// If set to enabled, adjust quantization within each frame to reduce flicker
	// or 'pop' on I-frames.
	FlickerAq *string `locationName:"flickerAq" type:"string" enum:"H265FlickerAq"`

	// Framerate denominator.
	//
	// FramerateDenominator is a required field
	FramerateDenominator *int64 `locationName:"framerateDenominator" min:"1" type:"integer" required:"true"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	//
	// FramerateNumerator is a required field
	FramerateNumerator *int64 `locationName:"framerateNumerator" min:"1" type:"integer" required:"true"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If
	// gopSizeUnits is frames, gopSize must be an integer and must be greater than
	// or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0,
	// but need not be an integer.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits *string `locationName:"gopSizeUnits" type:"string" enum:"H265GopSizeUnits"`

	// H.265 Level.
	Level *string `locationName:"level" type:"string" enum:"H265Level"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl *string `locationName:"lookAheadRateControl" type:"string" enum:"H265LookAheadRateControl"`

	// For QVBR: See the tooltip for Quality level
	MaxBitrate *int64 `locationName:"maxBitrate" min:"100000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the
	// next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" min:"1" type:"integer"`

	// H.265 Profile.
	Profile *string `locationName:"profile" type:"string" enum:"H265Profile"`

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. Set values for the QVBR quality level field and Max
	// bitrate field that suit your most important viewing devices. Recommended
	// values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC
	// or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality
	// level: 6. Max bitrate: 1M to 1.5M
	QvbrQualityLevel *int64 `locationName:"qvbrQualityLevel" min:"1" type:"integer"`

	// Rate control mode.QVBR: Quality will match the specified quality level except
	// when it is constrained by themaximum bitrate. Recommended if you or your
	// viewers pay for bandwidth.CBR: Quality varies, depending on the video complexity.
	// Recommended only if you distributeyour assets to devices that cannot handle
	// variable bitrates.Multiplex: This rate control mode is only supported (and
	// is required) when the video is beingdelivered to a MediaLive Multiplex in
	// which case the rate control configuration is controlledby the properties
	// within the Multiplex Program.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"H265RateControlMode"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType *string `locationName:"scanType" type:"string" enum:"H265ScanType"`

	// Scene change detection.
	SceneChangeDetect *string `locationName:"sceneChangeDetect" type:"string" enum:"H265SceneChangeDetect"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// H.265 Tier.
	Tier *string `locationName:"tier" type:"string" enum:"H265Tier"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion *string `locationName:"timecodeInsertion" type:"string" enum:"H265TimecodeInsertionBehavior"`
}

// String returns the string representation
func (s H265Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H265Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H265Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "H265Settings"}
	if s.Bitrate != nil && *s.Bitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 100000))
	}
	if s.BufSize != nil && *s.BufSize < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("BufSize", 100000))
	}
	if s.FramerateDenominator == nil {
		invalidParams.Add(request.NewErrParamRequired("FramerateDenominator"))
	}
	if s.FramerateDenominator != nil && *s.FramerateDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateDenominator", 1))
	}
	if s.FramerateNumerator == nil {
		invalidParams.Add(request.NewErrParamRequired("FramerateNumerator"))
	}
	if s.FramerateNumerator != nil && *s.FramerateNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateNumerator", 1))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBitrate", 100000))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.ParNumerator != nil && *s.ParNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParNumerator", 1))
	}
	if s.QvbrQualityLevel != nil && *s.QvbrQualityLevel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("QvbrQualityLevel", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Slices", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdaptiveQuantization sets the AdaptiveQuantization field's value.
func (s *H265Settings) SetAdaptiveQuantization(v string) *H265Settings {
	s.AdaptiveQuantization = &v
	return s
}

// SetAfdSignaling sets the AfdSignaling field's value.
func (s *H265Settings) SetAfdSignaling(v string) *H265Settings {
	s.AfdSignaling = &v
	return s
}

// SetAlternativeTransferFunction sets the AlternativeTransferFunction field's value.
func (s *H265Settings) SetAlternativeTransferFunction(v string) *H265Settings {
	s.AlternativeTransferFunction = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *H265Settings) SetBitrate(v int64) *H265Settings {
	s.Bitrate = &v
	return s
}

// SetBufSize sets the BufSize field's value.
func (s *H265Settings) SetBufSize(v int64) *H265Settings {
	s.BufSize = &v
	return s
}

// SetColorMetadata sets the ColorMetadata field's value.
func (s *H265Settings) SetColorMetadata(v string) *H265Settings {
	s.ColorMetadata = &v
	return s
}

// SetColorSpaceSettings sets the ColorSpaceSettings field's value.
func (s *H265Settings) SetColorSpaceSettings(v *H265ColorSpaceSettings) *H265Settings {
	s.ColorSpaceSettings = v
	return s
}

// SetFilterSettings sets the FilterSettings field's value.
func (s *H265Settings) SetFilterSettings(v *H265FilterSettings) *H265Settings {
	s.FilterSettings = v
	return s
}

// SetFixedAfd sets the FixedAfd field's value.
func (s *H265Settings) SetFixedAfd(v string) *H265Settings {
	s.FixedAfd = &v
	return s
}

// SetFlickerAq sets the FlickerAq field's value.
func (s *H265Settings) SetFlickerAq(v string) *H265Settings {
	s.FlickerAq = &v
	return s
}

// SetFramerateDenominator sets the FramerateDenominator field's value.
func (s *H265Settings) SetFramerateDenominator(v int64) *H265Settings {
	s.FramerateDenominator = &v
	return s
}

// SetFramerateNumerator sets the FramerateNumerator field's value.
func (s *H265Settings) SetFramerateNumerator(v int64) *H265Settings {
	s.FramerateNumerator = &v
	return s
}

// SetGopClosedCadence sets the GopClosedCadence field's value.
func (s *H265Settings) SetGopClosedCadence(v int64) *H265Settings {
	s.GopClosedCadence = &v
	return s
}

// SetGopSize sets the GopSize field's value.
func (s *H265Settings) SetGopSize(v float64) *H265Settings {
	s.GopSize = &v
	return s
}

// SetGopSizeUnits sets the GopSizeUnits field's value.
func (s *H265Settings) SetGopSizeUnits(v string) *H265Settings {
	s.GopSizeUnits = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *H265Settings) SetLevel(v string) *H265Settings {
	s.Level = &v
	return s
}

// SetLookAheadRateControl sets the LookAheadRateControl field's value.
func (s *H265Settings) SetLookAheadRateControl(v string) *H265Settings {
	s.LookAheadRateControl = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *H265Settings) SetMaxBitrate(v int64) *H265Settings {
	s.MaxBitrate = &v
	return s
}

// SetMinIInterval sets the MinIInterval field's value.
func (s *H265Settings) SetMinIInterval(v int64) *H265Settings {
	s.MinIInterval = &v
	return s
}

// SetParDenominator sets the ParDenominator field's value.
func (s *H265Settings) SetParDenominator(v int64) *H265Settings {
	s.ParDenominator = &v
	return s
}

// SetParNumerator sets the ParNumerator field's value.
func (s *H265Settings) SetParNumerator(v int64) *H265Settings {
	s.ParNumerator = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *H265Settings) SetProfile(v string) *H265Settings {
	s.Profile = &v
	return s
}

// SetQvbrQualityLevel sets the QvbrQualityLevel field's value.
func (s *H265Settings) SetQvbrQualityLevel(v int64) *H265Settings {
	s.QvbrQualityLevel = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *H265Settings) SetRateControlMode(v string) *H265Settings {
	s.RateControlMode = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *H265Settings) SetScanType(v string) *H265Settings {
	s.ScanType = &v
	return s
}

// SetSceneChangeDetect sets the SceneChangeDetect field's value.
func (s *H265Settings) SetSceneChangeDetect(v string) *H265Settings {
	s.SceneChangeDetect = &v
	return s
}

// SetSlices sets the Slices field's value.
func (s *H265Settings) SetSlices(v int64) *H265Settings {
	s.Slices = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *H265Settings) SetTier(v string) *H265Settings {
	s.Tier = &v
	return s
}

// SetTimecodeInsertion sets the TimecodeInsertion field's value.
func (s *H265Settings) SetTimecodeInsertion(v string) *H265Settings {
	s.TimecodeInsertion = &v
	return s
}

// Hdr10 Settings
type Hdr10Settings struct {
	_ struct{} `type:"structure"`

	// Maximum Content Light LevelAn integer metadata value defining the maximum
	// light level, in nits,of any single pixel within an encoded HDR video stream
	// or file.
	MaxCll *int64 `locationName:"maxCll" type:"integer"`

	// Maximum Frame Average Light LevelAn integer metadata value defining the maximum
	// average light level, in nits,for any single frame within an encoded HDR video
	// stream or file.
	MaxFall *int64 `locationName:"maxFall" type:"integer"`
}

// String returns the string representation
func (s Hdr10Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Hdr10Settings) GoString() string {
	return s.String()
}

// SetMaxCll sets the MaxCll field's value.
func (s *Hdr10Settings) SetMaxCll(v int64) *Hdr10Settings {
	s.MaxCll = &v
	return s
}

// SetMaxFall sets the MaxFall field's value.
func (s *Hdr10Settings) SetMaxFall(v int64) *Hdr10Settings {
	s.MaxFall = &v
	return s
}

// Hls Akamai Settings
type HlsAkamaiSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to Akamai. User should
	// contact Akamai to enable this feature.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsAkamaiHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// Salt for authenticated Akamai.
	Salt *string `locationName:"salt" type:"string"`

	// Token parameter for authenticated akamai. If not specified, _gda_ is used.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation
func (s HlsAkamaiSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsAkamaiSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsAkamaiSettings) SetConnectionRetryInterval(v int64) *HlsAkamaiSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsAkamaiSettings) SetFilecacheDuration(v int64) *HlsAkamaiSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsAkamaiSettings) SetHttpTransferMode(v string) *HlsAkamaiSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsAkamaiSettings) SetNumRetries(v int64) *HlsAkamaiSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsAkamaiSettings) SetRestartDelay(v int64) *HlsAkamaiSettings {
	s.RestartDelay = &v
	return s
}

// SetSalt sets the Salt field's value.
func (s *HlsAkamaiSettings) SetSalt(v string) *HlsAkamaiSettings {
	s.Salt = &v
	return s
}

// SetToken sets the Token field's value.
func (s *HlsAkamaiSettings) SetToken(v string) *HlsAkamaiSettings {
	s.Token = &v
	return s
}

// Hls Basic Put Settings
type HlsBasicPutSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsBasicPutSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsBasicPutSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsBasicPutSettings) SetConnectionRetryInterval(v int64) *HlsBasicPutSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsBasicPutSettings) SetFilecacheDuration(v int64) *HlsBasicPutSettings {
	s.FilecacheDuration = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsBasicPutSettings) SetNumRetries(v int64) *HlsBasicPutSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsBasicPutSettings) SetRestartDelay(v int64) *HlsBasicPutSettings {
	s.RestartDelay = &v
	return s
}

// Hls Cdn Settings
type HlsCdnSettings struct {
	_ struct{} `type:"structure"`

	// Hls Akamai Settings
	HlsAkamaiSettings *HlsAkamaiSettings `locationName:"hlsAkamaiSettings" type:"structure"`

	// Hls Basic Put Settings
	HlsBasicPutSettings *HlsBasicPutSettings `locationName:"hlsBasicPutSettings" type:"structure"`

	// Hls Media Store Settings
	HlsMediaStoreSettings *HlsMediaStoreSettings `locationName:"hlsMediaStoreSettings" type:"structure"`

	// Hls Webdav Settings
	HlsWebdavSettings *HlsWebdavSettings `locationName:"hlsWebdavSettings" type:"structure"`
}

// String returns the string representation
func (s HlsCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsCdnSettings) GoString() string {
	return s.String()
}

// SetHlsAkamaiSettings sets the HlsAkamaiSettings field's value.
func (s *HlsCdnSettings) SetHlsAkamaiSettings(v *HlsAkamaiSettings) *HlsCdnSettings {
	s.HlsAkamaiSettings = v
	return s
}

// SetHlsBasicPutSettings sets the HlsBasicPutSettings field's value.
func (s *HlsCdnSettings) SetHlsBasicPutSettings(v *HlsBasicPutSettings) *HlsCdnSettings {
	s.HlsBasicPutSettings = v
	return s
}

// SetHlsMediaStoreSettings sets the HlsMediaStoreSettings field's value.
func (s *HlsCdnSettings) SetHlsMediaStoreSettings(v *HlsMediaStoreSettings) *HlsCdnSettings {
	s.HlsMediaStoreSettings = v
	return s
}

// SetHlsWebdavSettings sets the HlsWebdavSettings field's value.
func (s *HlsCdnSettings) SetHlsWebdavSettings(v *HlsWebdavSettings) *HlsCdnSettings {
	s.HlsWebdavSettings = v
	return s
}

// Hls Group Settings
type HlsGroupSettings struct {
	_ struct{} `type:"structure"`

	// Choose one or more ad marker types to pass SCTE35 signals through to this
	// group of Apple HLS outputs.
	AdMarkers []*string `locationName:"adMarkers" type:"list"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlContent *string `locationName:"baseUrlContent" type:"string"`

	// Optional. One value per output group.This field is required only if you are
	// completing Base URL content A, and the downstream system has notified you
	// that the media files for pipeline 1 of all outputs are in a location different
	// from the media files for pipeline 0.
	BaseUrlContent1 *string `locationName:"baseUrlContent1" type:"string"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlManifest *string `locationName:"baseUrlManifest" type:"string"`

	// Optional. One value per output group.Complete this field only if you are
	// completing Base URL manifest A, and the downstream system has notified you
	// that the child manifest files for pipeline 1 of all outputs are in a location
	// different from the child manifest files for pipeline 0.
	BaseUrlManifest1 *string `locationName:"baseUrlManifest1" type:"string"`

	// Mapping of up to 4 caption channels to caption languages. Is only meaningful
	// if captionLanguageSetting is set to "insert".
	CaptionLanguageMappings []*CaptionLanguageMapping `locationName:"captionLanguageMappings" type:"list"`

	// Applies only to 608 Embedded output captions.insert: Include CLOSED-CAPTIONS
	// lines in the manifest. Specify at least one language in the CC1 Language
	// Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
	// Make sure to specify the languages in the order in which they appear in the
	// original source (if the source is embedded format) or the order of the caption
	// selectors (if the source is other than embedded). Otherwise, languages in
	// the manifest will not match up properly with the output captions.none: Include
	// CLOSED-CAPTIONS=NONE line in the manifest.omit: Omit any CLOSED-CAPTIONS
	// line from the manifest.
	CaptionLanguageSetting *string `locationName:"captionLanguageSetting" type:"string" enum:"HlsCaptionLanguageSetting"`

	// When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest,
	// which prevents clients from saving media segments for later replay.
	ClientCache *string `locationName:"clientCache" type:"string" enum:"HlsClientCache"`

	// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
	// generation.
	CodecSpecification *string `locationName:"codecSpecification" type:"string" enum:"HlsCodecSpecification"`

	// For use with encryptionType. This is a 128-bit, 16-byte hex value represented
	// by a 32-character text string. If ivSource is set to "explicit" then this
	// parameter is required and is used as the IV for encryption.
	ConstantIv *string `locationName:"constantIv" min:"32" type:"string"`

	// A directory or HTTP destination for the HLS segments, manifest files, and
	// encryption keys (if enabled).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Place segments in subdirectories.
	DirectoryStructure *string `locationName:"directoryStructure" type:"string" enum:"HlsDirectoryStructure"`

	// Encrypts the segments with the given encryption scheme. Exclude this parameter
	// if no encryption is desired.
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"HlsEncryptionType"`

	// Parameters that control interactions with the CDN.
	HlsCdnSettings *HlsCdnSettings `locationName:"hlsCdnSettings" type:"structure"`

	// State of HLS ID3 Segment Tagging
	HlsId3SegmentTagging *string `locationName:"hlsId3SegmentTagging" type:"string" enum:"HlsId3SegmentTaggingState"`

	// DISABLED: Do not create an I-frame-only manifest, but do create the master
	// and media manifests (according to the Output Selection field).STANDARD: Create
	// an I-frame-only manifest for each output that contains video, as well as
	// the other manifests (according to the Output Selection field). The I-frame
	// manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only,
	// and one or more #EXT-X-BYTERANGE entries identifying the I-frame position.
	// For example, #EXT-X-BYTERANGE:160364@1461888"
	IFrameOnlyPlaylists *string `locationName:"iFrameOnlyPlaylists" type:"string" enum:"IFrameOnlyPlaylistType"`

	// Applies only if Mode field is LIVE. Specifies the maximum number of segments
	// in the media manifest file. After this maximum, older segments are removed
	// from the media manifest. This number must be less than or equal to the Keep
	// Segments field.
	IndexNSegments *int64 `locationName:"indexNSegments" min:"3" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForHlsOut"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If set to
	// "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
	IvInManifest *string `locationName:"ivInManifest" type:"string" enum:"HlsIvInManifest"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If this setting
	// is "followsSegmentNumber", it will cause the IV to change every segment (to
	// match the segment number). If this is set to "explicit", you must enter a
	// constantIv value.
	IvSource *string `locationName:"ivSource" type:"string" enum:"HlsIvSource"`

	// Applies only if Mode field is LIVE. Specifies the number of media segments
	// (.ts files) to retain in the destination directory.
	KeepSegments *int64 `locationName:"keepSegments" min:"1" type:"integer"`

	// The value specifies how the key is represented in the resource identified
	// by the URI. If parameter is absent, an implicit value of "identity" is used.
	// A reverse DNS string can also be given.
	KeyFormat *string `locationName:"keyFormat" type:"string"`

	// Either a single positive integer version value or a slash delimited list
	// of version values (1/2/3).
	KeyFormatVersions *string `locationName:"keyFormatVersions" type:"string"`

	// The key provider settings.
	KeyProviderSettings *KeyProviderSettings `locationName:"keyProviderSettings" type:"structure"`

	// When set to gzip, compresses HLS playlist.
	ManifestCompression *string `locationName:"manifestCompression" type:"string" enum:"HlsManifestCompression"`

	// Indicates whether the output manifest should use floating point or integer
	// values for segment duration.
	ManifestDurationFormat *string `locationName:"manifestDurationFormat" type:"string" enum:"HlsManifestDurationFormat"`

	// When set, minimumSegmentLength is enforced by looking ahead and back within
	// the specified range for a nearby avail and extending the segment size if
	// needed.
	MinSegmentLength *int64 `locationName:"minSegmentLength" type:"integer"`

	// If "vod", all segments are indexed and kept permanently in the destination
	// and manifest. If "live", only the number segments specified in keepSegments
	// and indexNSegments are kept; newer segments replace older segments, which
	// may prevent players from rewinding all the way to the beginning of the event.VOD
	// mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running,
	// converting it to a "VOD" type manifest on completion of the stream.
	Mode *string `locationName:"mode" type:"string" enum:"HlsMode"`

	// MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable,
	// and media manifests) for this output group.VARIANT_MANIFESTS_AND_SEGMENTS:
	// Generates media manifests for this output group, but not a master manifest.SEGMENTS_ONLY:
	// Does not generate any manifests for this output group.
	OutputSelection *string `locationName:"outputSelection" type:"string" enum:"HlsOutputSelection"`

	// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files.
	// The value is calculated as follows: either the program date and time are
	// initialized using the input timecode source, or the time is initialized using
	// the input timecode source and the date is initialized using the timestampOffset.
	ProgramDateTime *string `locationName:"programDateTime" type:"string" enum:"HlsProgramDateTime"`

	// Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
	ProgramDateTimePeriod *int64 `locationName:"programDateTimePeriod" type:"integer"`

	// ENABLED: The master manifest (.m3u8 file) for each pipeline includes information
	// about both pipelines: first its own media files, then the media files of
	// the other pipeline. This feature allows playout device that support stale
	// manifest detection to switch from one manifest to the other, when the current
	// manifest seems to be stale. There are still two destinations and two master
	// manifests, but both master manifests reference the media files from both
	// pipelines.DISABLED: The master manifest (.m3u8 file) for each pipeline includes
	// information about its own pipeline only.For an HLS output group with MediaPackage
	// as the destination, the DISABLED behavior is always followed. MediaPackage
	// regenerates the manifests it serves to players so a redundant manifest from
	// MediaLive is irrelevant.
	RedundantManifest *string `locationName:"redundantManifest" type:"string" enum:"HlsRedundantManifest"`

	// Length of MPEG-2 Transport Stream segments to create (in seconds). Note that
	// segments will end on the next keyframe after this number of seconds, so actual
	// segment length may be longer.
	SegmentLength *int64 `locationName:"segmentLength" min:"1" type:"integer"`

	// useInputSegmentation has been deprecated. The configured segment size is
	// always used.
	SegmentationMode *string `locationName:"segmentationMode" type:"string" enum:"HlsSegmentationMode"`

	// Number of segments to write to a subdirectory before starting a new one.
	// directoryStructure must be subdirectoryPerStream for this setting to have
	// an effect.
	SegmentsPerSubdirectory *int64 `locationName:"segmentsPerSubdirectory" min:"1" type:"integer"`

	// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
	// of variant manifest.
	StreamInfResolution *string `locationName:"streamInfResolution" type:"string" enum:"HlsStreamInfResolution"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame *string `locationName:"timedMetadataId3Frame" type:"string" enum:"HlsTimedMetadataId3Frame"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`

	// Provides an extra millisecond delta offset to fine tune the timestamps.
	TimestampDeltaMilliseconds *int64 `locationName:"timestampDeltaMilliseconds" type:"integer"`

	// SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.SINGLE_FILE:
	// Applies only if Mode field is VOD. Emit the program as a single .ts media
	// file. The media manifest includes #EXT-X-BYTERANGE tags to index segments
	// for playback. A typical use for this value is when sending the output to
	// AWS Elemental MediaConvert, which can accept only a single media file. Playback
	// while the channel is running is not guaranteed due to HTTP server caching.
	TsFileMode *string `locationName:"tsFileMode" type:"string" enum:"HlsTsFileMode"`
}

// String returns the string representation
func (s HlsGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsGroupSettings"}
	if s.ConstantIv != nil && len(*s.ConstantIv) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ConstantIv", 32))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.IndexNSegments != nil && *s.IndexNSegments < 3 {
		invalidParams.Add(request.NewErrParamMinValue("IndexNSegments", 3))
	}
	if s.KeepSegments != nil && *s.KeepSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KeepSegments", 1))
	}
	if s.SegmentLength != nil && *s.SegmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentLength", 1))
	}
	if s.SegmentsPerSubdirectory != nil && *s.SegmentsPerSubdirectory < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentsPerSubdirectory", 1))
	}
	if s.CaptionLanguageMappings != nil {
		for i, v := range s.CaptionLanguageMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionLanguageMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.KeyProviderSettings != nil {
		if err := s.KeyProviderSettings.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsGroupSettings) SetAdMarkers(v []*string) *HlsGroupSettings {
	s.AdMarkers = v
	return s
}

// SetBaseUrlContent sets the BaseUrlContent field's value.
func (s *HlsGroupSettings) SetBaseUrlContent(v string) *HlsGroupSettings {
	s.BaseUrlContent = &v
	return s
}

// SetBaseUrlContent1 sets the BaseUrlContent1 field's value.
func (s *HlsGroupSettings) SetBaseUrlContent1(v string) *HlsGroupSettings {
	s.BaseUrlContent1 = &v
	return s
}

// SetBaseUrlManifest sets the BaseUrlManifest field's value.
func (s *HlsGroupSettings) SetBaseUrlManifest(v string) *HlsGroupSettings {
	s.BaseUrlManifest = &v
	return s
}

// SetBaseUrlManifest1 sets the BaseUrlManifest1 field's value.
func (s *HlsGroupSettings) SetBaseUrlManifest1(v string) *HlsGroupSettings {
	s.BaseUrlManifest1 = &v
	return s
}

// SetCaptionLanguageMappings sets the CaptionLanguageMappings field's value.
func (s *HlsGroupSettings) SetCaptionLanguageMappings(v []*CaptionLanguageMapping) *HlsGroupSettings {
	s.CaptionLanguageMappings = v
	return s
}

// SetCaptionLanguageSetting sets the CaptionLanguageSetting field's value.
func (s *HlsGroupSettings) SetCaptionLanguageSetting(v string) *HlsGroupSettings {
	s.CaptionLanguageSetting = &v
	return s
}

// SetClientCache sets the ClientCache field's value.
func (s *HlsGroupSettings) SetClientCache(v string) *HlsGroupSettings {
	s.ClientCache = &v
	return s
}

// SetCodecSpecification sets the CodecSpecification field's value.
func (s *HlsGroupSettings) SetCodecSpecification(v string) *HlsGroupSettings {
	s.CodecSpecification = &v
	return s
}

// SetConstantIv sets the ConstantIv field's value.
func (s *HlsGroupSettings) SetConstantIv(v string) *HlsGroupSettings {
	s.ConstantIv = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *HlsGroupSettings) SetDestination(v *OutputLocationRef) *HlsGroupSettings {
	s.Destination = v
	return s
}

// SetDirectoryStructure sets the DirectoryStructure field's value.
func (s *HlsGroupSettings) SetDirectoryStructure(v string) *HlsGroupSettings {
	s.DirectoryStructure = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *HlsGroupSettings) SetEncryptionType(v string) *HlsGroupSettings {
	s.EncryptionType = &v
	return s
}

// SetHlsCdnSettings sets the HlsCdnSettings field's value.
func (s *HlsGroupSettings) SetHlsCdnSettings(v *HlsCdnSettings) *HlsGroupSettings {
	s.HlsCdnSettings = v
	return s
}

// SetHlsId3SegmentTagging sets the HlsId3SegmentTagging field's value.
func (s *HlsGroupSettings) SetHlsId3SegmentTagging(v string) *HlsGroupSettings {
	s.HlsId3SegmentTagging = &v
	return s
}

// SetIFrameOnlyPlaylists sets the IFrameOnlyPlaylists field's value.
func (s *HlsGroupSettings) SetIFrameOnlyPlaylists(v string) *HlsGroupSettings {
	s.IFrameOnlyPlaylists = &v
	return s
}

// SetIndexNSegments sets the IndexNSegments field's value.
func (s *HlsGroupSettings) SetIndexNSegments(v int64) *HlsGroupSettings {
	s.IndexNSegments = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *HlsGroupSettings) SetInputLossAction(v string) *HlsGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetIvInManifest sets the IvInManifest field's value.
func (s *HlsGroupSettings) SetIvInManifest(v string) *HlsGroupSettings {
	s.IvInManifest = &v
	return s
}

// SetIvSource sets the IvSource field's value.
func (s *HlsGroupSettings) SetIvSource(v string) *HlsGroupSettings {
	s.IvSource = &v
	return s
}

// SetKeepSegments sets the KeepSegments field's value.
func (s *HlsGroupSettings) SetKeepSegments(v int64) *HlsGroupSettings {
	s.KeepSegments = &v
	return s
}

// SetKeyFormat sets the KeyFormat field's value.
func (s *HlsGroupSettings) SetKeyFormat(v string) *HlsGroupSettings {
	s.KeyFormat = &v
	return s
}

// SetKeyFormatVersions sets the KeyFormatVersions field's value.
func (s *HlsGroupSettings) SetKeyFormatVersions(v string) *HlsGroupSettings {
	s.KeyFormatVersions = &v
	return s
}

// SetKeyProviderSettings sets the KeyProviderSettings field's value.
func (s *HlsGroupSettings) SetKeyProviderSettings(v *KeyProviderSettings) *HlsGroupSettings {
	s.KeyProviderSettings = v
	return s
}

// SetManifestCompression sets the ManifestCompression field's value.
func (s *HlsGroupSettings) SetManifestCompression(v string) *HlsGroupSettings {
	s.ManifestCompression = &v
	return s
}

// SetManifestDurationFormat sets the ManifestDurationFormat field's value.
func (s *HlsGroupSettings) SetManifestDurationFormat(v string) *HlsGroupSettings {
	s.ManifestDurationFormat = &v
	return s
}

// SetMinSegmentLength sets the MinSegmentLength field's value.
func (s *HlsGroupSettings) SetMinSegmentLength(v int64) *HlsGroupSettings {
	s.MinSegmentLength = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *HlsGroupSettings) SetMode(v string) *HlsGroupSettings {
	s.Mode = &v
	return s
}

// SetOutputSelection sets the OutputSelection field's value.
func (s *HlsGroupSettings) SetOutputSelection(v string) *HlsGroupSettings {
	s.OutputSelection = &v
	return s
}

// SetProgramDateTime sets the ProgramDateTime field's value.
func (s *HlsGroupSettings) SetProgramDateTime(v string) *HlsGroupSettings {
	s.ProgramDateTime = &v
	return s
}

// SetProgramDateTimePeriod sets the ProgramDateTimePeriod field's value.
func (s *HlsGroupSettings) SetProgramDateTimePeriod(v int64) *HlsGroupSettings {
	s.ProgramDateTimePeriod = &v
	return s
}

// SetRedundantManifest sets the RedundantManifest field's value.
func (s *HlsGroupSettings) SetRedundantManifest(v string) *HlsGroupSettings {
	s.RedundantManifest = &v
	return s
}

// SetSegmentLength sets the SegmentLength field's value.
func (s *HlsGroupSettings) SetSegmentLength(v int64) *HlsGroupSettings {
	s.SegmentLength = &v
	return s
}

// SetSegmentationMode sets the SegmentationMode field's value.
func (s *HlsGroupSettings) SetSegmentationMode(v string) *HlsGroupSettings {
	s.SegmentationMode = &v
	return s
}

// SetSegmentsPerSubdirectory sets the SegmentsPerSubdirectory field's value.
func (s *HlsGroupSettings) SetSegmentsPerSubdirectory(v int64) *HlsGroupSettings {
	s.SegmentsPerSubdirectory = &v
	return s
}

// SetStreamInfResolution sets the StreamInfResolution field's value.
func (s *HlsGroupSettings) SetStreamInfResolution(v string) *HlsGroupSettings {
	s.StreamInfResolution = &v
	return s
}

// SetTimedMetadataId3Frame sets the TimedMetadataId3Frame field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Frame(v string) *HlsGroupSettings {
	s.TimedMetadataId3Frame = &v
	return s
}

// SetTimedMetadataId3Period sets the TimedMetadataId3Period field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Period(v int64) *HlsGroupSettings {
	s.TimedMetadataId3Period = &v
	return s
}

// SetTimestampDeltaMilliseconds sets the TimestampDeltaMilliseconds field's value.
func (s *HlsGroupSettings) SetTimestampDeltaMilliseconds(v int64) *HlsGroupSettings {
	s.TimestampDeltaMilliseconds = &v
	return s
}

// SetTsFileMode sets the TsFileMode field's value.
func (s *HlsGroupSettings) SetTsFileMode(v string) *HlsGroupSettings {
	s.TsFileMode = &v
	return s
}

// Settings for the action to insert a user-defined ID3 tag in each HLS segment
type HlsId3SegmentTaggingScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// ID3 tag to insert into each segment. Supports special keyword identifiers
	// to substitute in segment-related values.\nSupported keyword identifiers:
	// https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
	//
	// Tag is a required field
	Tag *string `locationName:"tag" type:"string" required:"true"`
}

// String returns the string representation
func (s HlsId3SegmentTaggingScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsId3SegmentTaggingScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsId3SegmentTaggingScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsId3SegmentTaggingScheduleActionSettings"}
	if s.Tag == nil {
		invalidParams.Add(request.NewErrParamRequired("Tag"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTag sets the Tag field's value.
func (s *HlsId3SegmentTaggingScheduleActionSettings) SetTag(v string) *HlsId3SegmentTaggingScheduleActionSettings {
	s.Tag = &v
	return s
}

// Hls Input Settings
type HlsInputSettings struct {
	_ struct{} `type:"structure"`

	// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches
	// this value will be chosen, otherwise the highest bandwidth stream in the
	// m3u8 will be chosen. The bitrate is specified in bits per second, as in an
	// HLS manifest.
	Bandwidth *int64 `locationName:"bandwidth" type:"integer"`

	// When specified, reading of the HLS input will begin this many buffer segments
	// from the end (most recently written segment). When not specified, the HLS
	// input will begin with the first segment specified in the m3u8.
	BufferSegments *int64 `locationName:"bufferSegments" type:"integer"`

	// The number of consecutive times that attempts to read a manifest or segment
	// must fail before the input is considered unavailable.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The number of seconds between retries when an attempt to read a manifest
	// or segment fails.
	RetryInterval *int64 `locationName:"retryInterval" type:"integer"`
}

// String returns the string representation
func (s HlsInputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsInputSettings) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *HlsInputSettings) SetBandwidth(v int64) *HlsInputSettings {
	s.Bandwidth = &v
	return s
}

// SetBufferSegments sets the BufferSegments field's value.
func (s *HlsInputSettings) SetBufferSegments(v int64) *HlsInputSettings {
	s.BufferSegments = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *HlsInputSettings) SetRetries(v int64) *HlsInputSettings {
	s.Retries = &v
	return s
}

// SetRetryInterval sets the RetryInterval field's value.
func (s *HlsInputSettings) SetRetryInterval(v int64) *HlsInputSettings {
	s.RetryInterval = &v
	return s
}

// Hls Media Store Settings
type HlsMediaStoreSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// When set to temporal, output files are stored in non-persistent memory for
	// faster reading and writing.
	MediaStoreStorageClass *string `locationName:"mediaStoreStorageClass" type:"string" enum:"HlsMediaStoreStorageClass"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsMediaStoreSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsMediaStoreSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsMediaStoreSettings) SetConnectionRetryInterval(v int64) *HlsMediaStoreSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsMediaStoreSettings) SetFilecacheDuration(v int64) *HlsMediaStoreSettings {
	s.FilecacheDuration = &v
	return s
}

// SetMediaStoreStorageClass sets the MediaStoreStorageClass field's value.
func (s *HlsMediaStoreSettings) SetMediaStoreStorageClass(v string) *HlsMediaStoreSettings {
	s.MediaStoreStorageClass = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsMediaStoreSettings) SetNumRetries(v int64) *HlsMediaStoreSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsMediaStoreSettings) SetRestartDelay(v int64) *HlsMediaStoreSettings {
	s.RestartDelay = &v
	return s
}

// Hls Output Settings
type HlsOutputSettings struct {
	_ struct{} `type:"structure"`

	// Only applicable when this output is referencing an H.265 video description.Specifies
	// whether MP4 segments should be packaged as HEV1 or HVC1.
	H265PackagingType *string `locationName:"h265PackagingType" type:"string" enum:"HlsH265PackagingType"`

	// Settings regarding the underlying stream. These settings are different for
	// audio-only outputs.
	//
	// HlsSettings is a required field
	HlsSettings *HlsSettings `locationName:"hlsSettings" type:"structure" required:"true"`

	// String concatenated to the end of the destination filename. Accepts \"Format
	// Identifiers\":#formatIdentifierParameters.
	NameModifier *string `locationName:"nameModifier" min:"1" type:"string"`

	// String concatenated to end of segment filenames.
	SegmentModifier *string `locationName:"segmentModifier" type:"string"`
}

// String returns the string representation
func (s HlsOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsOutputSettings"}
	if s.HlsSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("HlsSettings"))
	}
	if s.NameModifier != nil && len(*s.NameModifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameModifier", 1))
	}
	if s.HlsSettings != nil {
		if err := s.HlsSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetH265PackagingType sets the H265PackagingType field's value.
func (s *HlsOutputSettings) SetH265PackagingType(v string) *HlsOutputSettings {
	s.H265PackagingType = &v
	return s
}

// SetHlsSettings sets the HlsSettings field's value.
func (s *HlsOutputSettings) SetHlsSettings(v *HlsSettings) *HlsOutputSettings {
	s.HlsSettings = v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *HlsOutputSettings) SetNameModifier(v string) *HlsOutputSettings {
	s.NameModifier = &v
	return s
}

// SetSegmentModifier sets the SegmentModifier field's value.
func (s *HlsOutputSettings) SetSegmentModifier(v string) *HlsOutputSettings {
	s.SegmentModifier = &v
	return s
}

// Hls Settings
type HlsSettings struct {
	_ struct{} `type:"structure"`

	// Audio Only Hls Settings
	AudioOnlyHlsSettings *AudioOnlyHlsSettings `locationName:"audioOnlyHlsSettings" type:"structure"`

	// Fmp4 Hls Settings
	Fmp4HlsSettings *Fmp4HlsSettings `locationName:"fmp4HlsSettings" type:"structure"`

	// Standard Hls Settings
	StandardHlsSettings *StandardHlsSettings `locationName:"standardHlsSettings" type:"structure"`
}

// String returns the string representation
func (s HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsSettings"}
	if s.AudioOnlyHlsSettings != nil {
		if err := s.AudioOnlyHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyHlsSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StandardHlsSettings != nil {
		if err := s.StandardHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("StandardHlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioOnlyHlsSettings sets the AudioOnlyHlsSettings field's value.
func (s *HlsSettings) SetAudioOnlyHlsSettings(v *AudioOnlyHlsSettings) *HlsSettings {
	s.AudioOnlyHlsSettings = v
	return s
}

// SetFmp4HlsSettings sets the Fmp4HlsSettings field's value.
func (s *HlsSettings) SetFmp4HlsSettings(v *Fmp4HlsSettings) *HlsSettings {
	s.Fmp4HlsSettings = v
	return s
}

// SetStandardHlsSettings sets the StandardHlsSettings field's value.
func (s *HlsSettings) SetStandardHlsSettings(v *StandardHlsSettings) *HlsSettings {
	s.StandardHlsSettings = v
	return s
}

// Settings for the action to emit HLS metadata
type HlsTimedMetadataScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
	//
	// Id3 is a required field
	Id3 *string `locationName:"id3" type:"string" required:"true"`
}

// String returns the string representation
func (s HlsTimedMetadataScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsTimedMetadataScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsTimedMetadataScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsTimedMetadataScheduleActionSettings"}
	if s.Id3 == nil {
		invalidParams.Add(request.NewErrParamRequired("Id3"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId3 sets the Id3 field's value.
func (s *HlsTimedMetadataScheduleActionSettings) SetId3(v string) *HlsTimedMetadataScheduleActionSettings {
	s.Id3 = &v
	return s
}

// Hls Webdav Settings
type HlsWebdavSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to WebDAV.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsWebdavHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsWebdavSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsWebdavSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsWebdavSettings) SetConnectionRetryInterval(v int64) *HlsWebdavSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsWebdavSettings) SetFilecacheDuration(v int64) *HlsWebdavSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsWebdavSettings) SetHttpTransferMode(v string) *HlsWebdavSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsWebdavSettings) SetNumRetries(v int64) *HlsWebdavSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsWebdavSettings) SetRestartDelay(v int64) *HlsWebdavSettings {
	s.RestartDelay = &v
	return s
}

// Settings to configure an action so that it occurs as soon as possible.
type ImmediateModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImmediateModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImmediateModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

type Input struct {
	_ struct{} `type:"structure"`

	// The Unique ARN of the input (generated, immutable).
	Arn *string `locationName:"arn" type:"string"`

	// A list of channel IDs that that input is attached to (currently an input
	// can only be attached to one channel).
	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	// A list of the destinations of the input (PUSH-type).
	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	// The generated ID of the input (unique for user account, immutable).
	Id *string `locationName:"id" type:"string"`

	// STANDARD - MediaLive expects two sources to be connected to this input. If
	// the channel is also STANDARD, both sources will be ingested. If the channel
	// is SINGLE_PIPELINE, only the first source will be ingested; the second source
	// will always be ignored, even if the first source fails.SINGLE_PIPELINE -
	// You can connect only one source to this input. If the ChannelClass is also
	// SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this
	// value is not valid because the channel requires two sources in the input.
	InputClass *string `locationName:"inputClass" type:"string" enum:"InputClass"`

	// Settings for the input devices.
	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	// Certain pull input sources can be dynamic, meaning that they can have their
	// URL's dynamically changesduring input switch actions. Presently, this functionality
	// only works with MP4_FILE inputs.
	InputSourceType *string `locationName:"inputSourceType" type:"string" enum:"InputSourceType"`

	// A list of MediaConnect Flows for this input.
	MediaConnectFlows []*MediaConnectFlow `locationName:"mediaConnectFlows" type:"list"`

	// The user-assigned name (This is a mutable value).
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the role this input assumes during and
	// after creation.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of IDs for all the Input Security Groups attached to the input.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// A list of the sources of the input (PULL-type).
	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Input) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Input) SetArn(v string) *Input {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *Input) SetAttachedChannels(v []*string) *Input {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Input) SetDestinations(v []*InputDestination) *Input {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *Input) SetId(v string) *Input {
	s.Id = &v
	return s
}

// SetInputClass sets the InputClass field's value.
func (s *Input) SetInputClass(v string) *Input {
	s.InputClass = &v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *Input) SetInputDevices(v []*InputDeviceSettings) *Input {
	s.InputDevices = v
	return s
}

// SetInputSourceType sets the InputSourceType field's value.
func (s *Input) SetInputSourceType(v string) *Input {
	s.InputSourceType = &v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *Input) SetMediaConnectFlows(v []*MediaConnectFlow) *Input {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *Input) SetName(v string) *Input {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Input) SetRoleArn(v string) *Input {
	s.RoleArn = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Input) SetSecurityGroups(v []*string) *Input {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Input) SetSources(v []*InputSource) *Input {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *Input) SetState(v string) *Input {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Input) SetTags(v map[string]*string) *Input {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Input) SetType(v string) *Input {
	s.Type = &v
	return s
}

type InputAttachment struct {
	_ struct{} `type:"structure"`

	// User-specified settings for defining what the conditions are for declaring
	// the input unhealthy and failing over to a different input.
	AutomaticInputFailoverSettings *AutomaticInputFailoverSettings `locationName:"automaticInputFailoverSettings" type:"structure"`

	// User-specified name for the attachment. This is required if the user wants
	// to use this input in an input switch action.
	InputAttachmentName *string `locationName:"inputAttachmentName" type:"string"`

	// The ID of the input
	InputId *string `locationName:"inputId" type:"string"`

	// Settings of an input (caption selector, etc.)
	InputSettings *InputSettings `locationName:"inputSettings" type:"structure"`
}

// String returns the string representation
func (s InputAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputAttachment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputAttachment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputAttachment"}
	if s.AutomaticInputFailoverSettings != nil {
		if err := s.AutomaticInputFailoverSettings.Validate(); err != nil {
			invalidParams.AddNested("AutomaticInputFailoverSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSettings != nil {
		if err := s.InputSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticInputFailoverSettings sets the AutomaticInputFailoverSettings field's value.
func (s *InputAttachment) SetAutomaticInputFailoverSettings(v *AutomaticInputFailoverSettings) *InputAttachment {
	s.AutomaticInputFailoverSettings = v
	return s
}

// SetInputAttachmentName sets the InputAttachmentName field's value.
func (s *InputAttachment) SetInputAttachmentName(v string) *InputAttachment {
	s.InputAttachmentName = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *InputAttachment) SetInputId(v string) *InputAttachment {
	s.InputId = &v
	return s
}

// SetInputSettings sets the InputSettings field's value.
func (s *InputAttachment) SetInputSettings(v *InputSettings) *InputAttachment {
	s.InputSettings = v
	return s
}

// Input Channel Level
type InputChannelLevel struct {
	_ struct{} `type:"structure"`

	// Remixing value. Units are in dB and acceptable values are within the range
	// from -60 (mute) and 6 dB.
	//
	// Gain is a required field
	Gain *int64 `locationName:"gain" type:"integer" required:"true"`

	// The index of the input channel used as a source.
	//
	// InputChannel is a required field
	InputChannel *int64 `locationName:"inputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s InputChannelLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputChannelLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputChannelLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputChannelLevel"}
	if s.Gain == nil {
		invalidParams.Add(request.NewErrParamRequired("Gain"))
	}
	if s.Gain != nil && *s.Gain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("Gain", -60))
	}
	if s.InputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGain sets the Gain field's value.
func (s *InputChannelLevel) SetGain(v int64) *InputChannelLevel {
	s.Gain = &v
	return s
}

// SetInputChannel sets the InputChannel field's value.
func (s *InputChannelLevel) SetInputChannel(v int64) *InputChannelLevel {
	s.InputChannel = &v
	return s
}

// Settings to let you create a clip of the file input, in order to set up the
// input to ingest only a portion of the file.
type InputClippingSettings struct {
	_ struct{} `type:"structure"`

	// The source of the timecodes in the source being clipped.
	//
	// InputTimecodeSource is a required field
	InputTimecodeSource *string `locationName:"inputTimecodeSource" type:"string" required:"true" enum:"InputTimecodeSource"`

	// Settings to identify the start of the clip.
	StartTimecode *StartTimecode `locationName:"startTimecode" type:"structure"`

	// Settings to identify the end of the clip.
	StopTimecode *StopTimecode `locationName:"stopTimecode" type:"structure"`
}

// String returns the string representation
func (s InputClippingSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputClippingSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputClippingSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputClippingSettings"}
	if s.InputTimecodeSource == nil {
		invalidParams.Add(request.NewErrParamRequired("InputTimecodeSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputTimecodeSource sets the InputTimecodeSource field's value.
func (s *InputClippingSettings) SetInputTimecodeSource(v string) *InputClippingSettings {
	s.InputTimecodeSource = &v
	return s
}

// SetStartTimecode sets the StartTimecode field's value.
func (s *InputClippingSettings) SetStartTimecode(v *StartTimecode) *InputClippingSettings {
	s.StartTimecode = v
	return s
}

// SetStopTimecode sets the StopTimecode field's value.
func (s *InputClippingSettings) SetStopTimecode(v *StopTimecode) *InputClippingSettings {
	s.StopTimecode = v
	return s
}

// The settings for a PUSH type input.
type InputDestination struct {
	_ struct{} `type:"structure"`

	// The system-generated static IP address of endpoint.It remains fixed for the
	// lifetime of the input.
	Ip *string `locationName:"ip" type:"string"`

	// The port number for the input.
	Port *string `locationName:"port" type:"string"`

	// This represents the endpoint that the customer stream will bepushed to.
	Url *string `locationName:"url" type:"string"`

	// The properties for a VPC type input destination.
	Vpc *InputDestinationVpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s InputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDestination) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *InputDestination) SetIp(v string) *InputDestination {
	s.Ip = &v
	return s
}

// SetPort sets the Port field's value.
func (s *InputDestination) SetPort(v string) *InputDestination {
	s.Port = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputDestination) SetUrl(v string) *InputDestination {
	s.Url = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *InputDestination) SetVpc(v *InputDestinationVpc) *InputDestination {
	s.Vpc = v
	return s
}

// Endpoint settings for a PUSH type input.
type InputDestinationRequest struct {
	_ struct{} `type:"structure"`

	// A unique name for the location the RTMP stream is being pushedto.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s InputDestinationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDestinationRequest) GoString() string {
	return s.String()
}

// SetStreamName sets the StreamName field's value.
func (s *InputDestinationRequest) SetStreamName(v string) *InputDestinationRequest {
	s.StreamName = &v
	return s
}

// The properties for a VPC type input destination.
type InputDestinationVpc struct {
	_ struct{} `type:"structure"`

	// The availability zone of the Input destination.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The network interface ID of the Input destination in the VPC.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`
}

// String returns the string representation
func (s InputDestinationVpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDestinationVpc) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InputDestinationVpc) SetAvailabilityZone(v string) *InputDestinationVpc {
	s.AvailabilityZone = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *InputDestinationVpc) SetNetworkInterfaceId(v string) *InputDestinationVpc {
	s.NetworkInterfaceId = &v
	return s
}

// Configurable settings for the input device.
type InputDeviceConfigurableSettings struct {
	_ struct{} `type:"structure"`

	// The input source that you want to use. If the device has a source connected
	// to only one of its input ports, or if you don't care which source the device
	// sends, specify Auto. If the device has sources connected to both its input
	// ports, and you want to use a specific source, specify the source.
	ConfiguredInput *string `locationName:"configuredInput" type:"string" enum:"InputDeviceConfiguredInput"`

	// The maximum bitrate in bits per second. Set a value here to throttle the
	// bitrate of the source video.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`
}

// String returns the string representation
func (s InputDeviceConfigurableSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceConfigurableSettings) GoString() string {
	return s.String()
}

// SetConfiguredInput sets the ConfiguredInput field's value.
func (s *InputDeviceConfigurableSettings) SetConfiguredInput(v string) *InputDeviceConfigurableSettings {
	s.ConfiguredInput = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *InputDeviceConfigurableSettings) SetMaxBitrate(v int64) *InputDeviceConfigurableSettings {
	s.MaxBitrate = &v
	return s
}

// Settings that describe the active source from the input device, and the video
// characteristics of that source.
type InputDeviceHdSettings struct {
	_ struct{} `type:"structure"`

	// If you specified Auto as the configured input, specifies which of the sources
	// is currently active (SDI or HDMI).
	ActiveInput *string `locationName:"activeInput" type:"string" enum:"InputDeviceActiveInput"`

	// The source at the input device that is currently active. You can specify
	// this source.
	ConfiguredInput *string `locationName:"configuredInput" type:"string" enum:"InputDeviceConfiguredInput"`

	// The state of the input device.
	DeviceState *string `locationName:"deviceState" type:"string" enum:"InputDeviceState"`

	// The frame rate of the video source.
	Framerate *float64 `locationName:"framerate" type:"double"`

	// The height of the video source, in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The current maximum bitrate for ingesting this source, in bits per second.
	// You can specify this maximum.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The scan type of the video source.
	ScanType *string `locationName:"scanType" type:"string" enum:"InputDeviceScanType"`

	// The width of the video source, in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s InputDeviceHdSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceHdSettings) GoString() string {
	return s.String()
}

// SetActiveInput sets the ActiveInput field's value.
func (s *InputDeviceHdSettings) SetActiveInput(v string) *InputDeviceHdSettings {
	s.ActiveInput = &v
	return s
}

// SetConfiguredInput sets the ConfiguredInput field's value.
func (s *InputDeviceHdSettings) SetConfiguredInput(v string) *InputDeviceHdSettings {
	s.ConfiguredInput = &v
	return s
}

// SetDeviceState sets the DeviceState field's value.
func (s *InputDeviceHdSettings) SetDeviceState(v string) *InputDeviceHdSettings {
	s.DeviceState = &v
	return s
}

// SetFramerate sets the Framerate field's value.
func (s *InputDeviceHdSettings) SetFramerate(v float64) *InputDeviceHdSettings {
	s.Framerate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *InputDeviceHdSettings) SetHeight(v int64) *InputDeviceHdSettings {
	s.Height = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *InputDeviceHdSettings) SetMaxBitrate(v int64) *InputDeviceHdSettings {
	s.MaxBitrate = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *InputDeviceHdSettings) SetScanType(v string) *InputDeviceHdSettings {
	s.ScanType = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *InputDeviceHdSettings) SetWidth(v int64) *InputDeviceHdSettings {
	s.Width = &v
	return s
}

// The network settings for the input device.
type InputDeviceNetworkSettings struct {
	_ struct{} `type:"structure"`

	// The DNS addresses of the input device.
	DnsAddresses []*string `locationName:"dnsAddresses" type:"list"`

	// The network gateway IP address.
	Gateway *string `locationName:"gateway" type:"string"`

	// The IP address of the input device.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// Specifies whether the input device has been configured (outside of MediaLive)
	// to use a dynamic IP address assignment (DHCP) or a static IP address.
	IpScheme *string `locationName:"ipScheme" type:"string" enum:"InputDeviceIpScheme"`

	// The subnet mask of the input device.
	SubnetMask *string `locationName:"subnetMask" type:"string"`
}

// String returns the string representation
func (s InputDeviceNetworkSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceNetworkSettings) GoString() string {
	return s.String()
}

// SetDnsAddresses sets the DnsAddresses field's value.
func (s *InputDeviceNetworkSettings) SetDnsAddresses(v []*string) *InputDeviceNetworkSettings {
	s.DnsAddresses = v
	return s
}

// SetGateway sets the Gateway field's value.
func (s *InputDeviceNetworkSettings) SetGateway(v string) *InputDeviceNetworkSettings {
	s.Gateway = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InputDeviceNetworkSettings) SetIpAddress(v string) *InputDeviceNetworkSettings {
	s.IpAddress = &v
	return s
}

// SetIpScheme sets the IpScheme field's value.
func (s *InputDeviceNetworkSettings) SetIpScheme(v string) *InputDeviceNetworkSettings {
	s.IpScheme = &v
	return s
}

// SetSubnetMask sets the SubnetMask field's value.
func (s *InputDeviceNetworkSettings) SetSubnetMask(v string) *InputDeviceNetworkSettings {
	s.SubnetMask = &v
	return s
}

// Settings for an input device.
type InputDeviceRequest struct {
	_ struct{} `type:"structure"`

	// The unique ID for the device.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s InputDeviceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceRequest) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceRequest) SetId(v string) *InputDeviceRequest {
	s.Id = &v
	return s
}

// Settings for an input device.
type InputDeviceSettings struct {
	_ struct{} `type:"structure"`

	// The unique ID for the device.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s InputDeviceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceSettings) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceSettings) SetId(v string) *InputDeviceSettings {
	s.Id = &v
	return s
}

// Details of the input device.
type InputDeviceSummary struct {
	_ struct{} `type:"structure"`

	// The unique ARN of the input device.
	Arn *string `locationName:"arn" type:"string"`

	// The state of the connection between the input device and AWS.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"InputDeviceConnectionState"`

	// The status of the action to synchronize the device configuration. If you
	// change the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState *string `locationName:"deviceSettingsSyncState" type:"string" enum:"DeviceSettingsSyncState"`

	// Settings that describe an input device that is type HD.
	HdDeviceSettings *InputDeviceHdSettings `locationName:"hdDeviceSettings" type:"structure"`

	// The unique ID of the input device.
	Id *string `locationName:"id" type:"string"`

	// The network MAC address of the input device.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// A name that you specify for the input device.
	Name *string `locationName:"name" type:"string"`

	// Network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings `locationName:"networkSettings" type:"structure"`

	// The unique serial number of the input device.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The type of the input device.
	Type *string `locationName:"type" type:"string" enum:"InputDeviceType"`
}

// String returns the string representation
func (s InputDeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDeviceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InputDeviceSummary) SetArn(v string) *InputDeviceSummary {
	s.Arn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *InputDeviceSummary) SetConnectionState(v string) *InputDeviceSummary {
	s.ConnectionState = &v
	return s
}

// SetDeviceSettingsSyncState sets the DeviceSettingsSyncState field's value.
func (s *InputDeviceSummary) SetDeviceSettingsSyncState(v string) *InputDeviceSummary {
	s.DeviceSettingsSyncState = &v
	return s
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *InputDeviceSummary) SetHdDeviceSettings(v *InputDeviceHdSettings) *InputDeviceSummary {
	s.HdDeviceSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *InputDeviceSummary) SetId(v string) *InputDeviceSummary {
	s.Id = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *InputDeviceSummary) SetMacAddress(v string) *InputDeviceSummary {
	s.MacAddress = &v
	return s
}

// SetName sets the Name field's value.
func (s *InputDeviceSummary) SetName(v string) *InputDeviceSummary {
	s.Name = &v
	return s
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *InputDeviceSummary) SetNetworkSettings(v *InputDeviceNetworkSettings) *InputDeviceSummary {
	s.NetworkSettings = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *InputDeviceSummary) SetSerialNumber(v string) *InputDeviceSummary {
	s.SerialNumber = &v
	return s
}

// SetType sets the Type field's value.
func (s *InputDeviceSummary) SetType(v string) *InputDeviceSummary {
	s.Type = &v
	return s
}

// Input Location
type InputLocation struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Uniform Resource Identifier - This should be a path to a file accessible
	// to the Live system (eg. a http:// URI) depending on the output type. For
	// example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`

	// Username if credentials are required to access a file or publishing point.
	// This can be either a plaintext username, or a reference to an AWS parameter
	// store name from which the username can be retrieved. AWS Parameter store
	// format: "ssm://"
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLocation"}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputLocation) SetPasswordParam(v string) *InputLocation {
	s.PasswordParam = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *InputLocation) SetUri(v string) *InputLocation {
	s.Uri = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputLocation) SetUsername(v string) *InputLocation {
	s.Username = &v
	return s
}

// Input Loss Behavior
type InputLossBehavior struct {
	_ struct{} `type:"structure"`

	// On input loss, the number of milliseconds to substitute black into the output
	// before switching to the frame specified by inputLossImageType. A value x,
	// where 0 <= x <= 1,000,000 and a value of 1,000,000 will be interpreted as
	// infinite.
	BlackFrameMsec *int64 `locationName:"blackFrameMsec" type:"integer"`

	// When input loss image type is "color" this field specifies the color to use.
	// Value: 6 hex characters representing the values of RGB.
	InputLossImageColor *string `locationName:"inputLossImageColor" min:"6" type:"string"`

	// When input loss image type is "slate" these fields specify the parameters
	// for accessing the slate.
	InputLossImageSlate *InputLocation `locationName:"inputLossImageSlate" type:"structure"`

	// Indicates whether to substitute a solid color or a slate into the output
	// after input loss exceeds blackFrameMsec.
	InputLossImageType *string `locationName:"inputLossImageType" type:"string" enum:"InputLossImageType"`

	// On input loss, the number of milliseconds to repeat the previous picture
	// before substituting black into the output. A value x, where 0 <= x <= 1,000,000
	// and a value of 1,000,000 will be interpreted as infinite.
	RepeatFrameMsec *int64 `locationName:"repeatFrameMsec" type:"integer"`
}

// String returns the string representation
func (s InputLossBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLossBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLossBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLossBehavior"}
	if s.InputLossImageColor != nil && len(*s.InputLossImageColor) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("InputLossImageColor", 6))
	}
	if s.InputLossImageSlate != nil {
		if err := s.InputLossImageSlate.Validate(); err != nil {
			invalidParams.AddNested("InputLossImageSlate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackFrameMsec sets the BlackFrameMsec field's value.
func (s *InputLossBehavior) SetBlackFrameMsec(v int64) *InputLossBehavior {
	s.BlackFrameMsec = &v
	return s
}

// SetInputLossImageColor sets the InputLossImageColor field's value.
func (s *InputLossBehavior) SetInputLossImageColor(v string) *InputLossBehavior {
	s.InputLossImageColor = &v
	return s
}

// SetInputLossImageSlate sets the InputLossImageSlate field's value.
func (s *InputLossBehavior) SetInputLossImageSlate(v *InputLocation) *InputLossBehavior {
	s.InputLossImageSlate = v
	return s
}

// SetInputLossImageType sets the InputLossImageType field's value.
func (s *InputLossBehavior) SetInputLossImageType(v string) *InputLossBehavior {
	s.InputLossImageType = &v
	return s
}

// SetRepeatFrameMsec sets the RepeatFrameMsec field's value.
func (s *InputLossBehavior) SetRepeatFrameMsec(v int64) *InputLossBehavior {
	s.RepeatFrameMsec = &v
	return s
}

// Action to prepare an input for a future immediate input switch.
type InputPrepareScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The name of the input attachment that should be prepared by this action.
	// If no name is provided, the action will stop the most recent prepare (if
	// any) when activated.
	InputAttachmentNameReference *string `locationName:"inputAttachmentNameReference" type:"string"`

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings `locationName:"inputClippingSettings" type:"structure"`

	// The value for the variable portion of the URL for the dynamic input, for
	// this instance of the input. Each time you use the same dynamic input in an
	// input switch action, you can provide a different value, in order to connect
	// the input to a different content source.
	UrlPath []*string `locationName:"urlPath" type:"list"`
}

// String returns the string representation
func (s InputPrepareScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputPrepareScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputPrepareScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputPrepareScheduleActionSettings"}
	if s.InputClippingSettings != nil {
		if err := s.InputClippingSettings.Validate(); err != nil {
			invalidParams.AddNested("InputClippingSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputAttachmentNameReference sets the InputAttachmentNameReference field's value.
func (s *InputPrepareScheduleActionSettings) SetInputAttachmentNameReference(v string) *InputPrepareScheduleActionSettings {
	s.InputAttachmentNameReference = &v
	return s
}

// SetInputClippingSettings sets the InputClippingSettings field's value.
func (s *InputPrepareScheduleActionSettings) SetInputClippingSettings(v *InputClippingSettings) *InputPrepareScheduleActionSettings {
	s.InputClippingSettings = v
	return s
}

// SetUrlPath sets the UrlPath field's value.
func (s *InputPrepareScheduleActionSettings) SetUrlPath(v []*string) *InputPrepareScheduleActionSettings {
	s.UrlPath = v
	return s
}

// An Input Security Group
type InputSecurityGroup struct {
	_ struct{} `type:"structure"`

	// Unique ARN of Input Security Group
	Arn *string `locationName:"arn" type:"string"`

	// The Id of the Input Security Group
	Id *string `locationName:"id" type:"string"`

	// The list of inputs currently using this Input Security Group.
	Inputs []*string `locationName:"inputs" type:"list"`

	// The current state of the Input Security Group.
	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Whitelist rules and their sync status
	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s InputSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSecurityGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InputSecurityGroup) SetArn(v string) *InputSecurityGroup {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *InputSecurityGroup) SetId(v string) *InputSecurityGroup {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *InputSecurityGroup) SetInputs(v []*string) *InputSecurityGroup {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *InputSecurityGroup) SetState(v string) *InputSecurityGroup {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InputSecurityGroup) SetTags(v map[string]*string) *InputSecurityGroup {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *InputSecurityGroup) SetWhitelistRules(v []*InputWhitelistRule) *InputSecurityGroup {
	s.WhitelistRules = v
	return s
}

// Live Event input parameters. There can be multiple inputs in a single Live
// Event.
type InputSettings struct {
	_ struct{} `type:"structure"`

	// Used to select the audio stream to decode for inputs that have multiple available.
	AudioSelectors []*AudioSelector `locationName:"audioSelectors" type:"list"`

	// Used to select the caption input to use for inputs that have multiple available.
	CaptionSelectors []*CaptionSelector `locationName:"captionSelectors" type:"list"`

	// Enable or disable the deblock filter when filtering.
	DeblockFilter *string `locationName:"deblockFilter" type:"string" enum:"InputDeblockFilter"`

	// Enable or disable the denoise filter when filtering.
	DenoiseFilter *string `locationName:"denoiseFilter" type:"string" enum:"InputDenoiseFilter"`

	// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
	FilterStrength *int64 `locationName:"filterStrength" min:"1" type:"integer"`

	// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter
	// enabled by default.1) auto - filtering will be applied depending on input
	// type/quality2) disabled - no filtering will be applied to the input3) forced
	// - filtering will be applied regardless of input type
	InputFilter *string `locationName:"inputFilter" type:"string" enum:"InputFilter"`

	// Input settings.
	NetworkInputSettings *NetworkInputSettings `locationName:"networkInputSettings" type:"structure"`

	// Specifies whether to extract applicable ancillary data from a SMPTE-2038
	// source in this input. Applicable data types are captions, timecode, AFD,
	// and SCTE-104 messages.- PREFER: Extract from SMPTE-2038 if present in this
	// input, otherwise extract from another source (if any).- IGNORE: Never extract
	// any ancillary data from SMPTE-2038.
	Smpte2038DataPreference *string `locationName:"smpte2038DataPreference" type:"string" enum:"Smpte2038DataPreference"`

	// Loop input if it is a file. This allows a file input to be streamed indefinitely.
	SourceEndBehavior *string `locationName:"sourceEndBehavior" type:"string" enum:"InputSourceEndBehavior"`

	// Informs which video elementary stream to decode for input types that have
	// multiple available.
	VideoSelector *VideoSelector `locationName:"videoSelector" type:"structure"`
}

// String returns the string representation
func (s InputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSettings"}
	if s.FilterStrength != nil && *s.FilterStrength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FilterStrength", 1))
	}
	if s.AudioSelectors != nil {
		for i, v := range s.AudioSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CaptionSelectors != nil {
		for i, v := range s.CaptionSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSelectors sets the AudioSelectors field's value.
func (s *InputSettings) SetAudioSelectors(v []*AudioSelector) *InputSettings {
	s.AudioSelectors = v
	return s
}

// SetCaptionSelectors sets the CaptionSelectors field's value.
func (s *InputSettings) SetCaptionSelectors(v []*CaptionSelector) *InputSettings {
	s.CaptionSelectors = v
	return s
}

// SetDeblockFilter sets the DeblockFilter field's value.
func (s *InputSettings) SetDeblockFilter(v string) *InputSettings {
	s.DeblockFilter = &v
	return s
}

// SetDenoiseFilter sets the DenoiseFilter field's value.
func (s *InputSettings) SetDenoiseFilter(v string) *InputSettings {
	s.DenoiseFilter = &v
	return s
}

// SetFilterStrength sets the FilterStrength field's value.
func (s *InputSettings) SetFilterStrength(v int64) *InputSettings {
	s.FilterStrength = &v
	return s
}

// SetInputFilter sets the InputFilter field's value.
func (s *InputSettings) SetInputFilter(v string) *InputSettings {
	s.InputFilter = &v
	return s
}

// SetNetworkInputSettings sets the NetworkInputSettings field's value.
func (s *InputSettings) SetNetworkInputSettings(v *NetworkInputSettings) *InputSettings {
	s.NetworkInputSettings = v
	return s
}

// SetSmpte2038DataPreference sets the Smpte2038DataPreference field's value.
func (s *InputSettings) SetSmpte2038DataPreference(v string) *InputSettings {
	s.Smpte2038DataPreference = &v
	return s
}

// SetSourceEndBehavior sets the SourceEndBehavior field's value.
func (s *InputSettings) SetSourceEndBehavior(v string) *InputSettings {
	s.SourceEndBehavior = &v
	return s
}

// SetVideoSelector sets the VideoSelector field's value.
func (s *InputSettings) SetVideoSelector(v *VideoSelector) *InputSettings {
	s.VideoSelector = v
	return s
}

// The settings for a PULL type input.
type InputSource struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSource) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSource) SetPasswordParam(v string) *InputSource {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSource) SetUrl(v string) *InputSource {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSource) SetUsername(v string) *InputSource {
	s.Username = &v
	return s
}

// Settings for for a PULL type input.
type InputSourceRequest struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSourceRequest) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSourceRequest) SetPasswordParam(v string) *InputSourceRequest {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSourceRequest) SetUrl(v string) *InputSourceRequest {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSourceRequest) SetUsername(v string) *InputSourceRequest {
	s.Username = &v
	return s
}

type InputSpecification struct {
	_ struct{} `type:"structure"`

	// Input codec
	Codec *string `locationName:"codec" type:"string" enum:"InputCodec"`

	// Maximum input bitrate, categorized coarsely
	MaximumBitrate *string `locationName:"maximumBitrate" type:"string" enum:"InputMaximumBitrate"`

	// Input resolution, categorized coarsely
	Resolution *string `locationName:"resolution" type:"string" enum:"InputResolution"`
}

// String returns the string representation
func (s InputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSpecification) GoString() string {
	return s.String()
}

// SetCodec sets the Codec field's value.
func (s *InputSpecification) SetCodec(v string) *InputSpecification {
	s.Codec = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *InputSpecification) SetMaximumBitrate(v string) *InputSpecification {
	s.MaximumBitrate = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *InputSpecification) SetResolution(v string) *InputSpecification {
	s.Resolution = &v
	return s
}

// Settings for the "switch input" action: to switch from ingesting one input
// to ingesting another input.
type InputSwitchScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The name of the input attachment (not the name of the input!) to switch to.
	// The name is specified in the channel configuration.
	//
	// InputAttachmentNameReference is a required field
	InputAttachmentNameReference *string `locationName:"inputAttachmentNameReference" type:"string" required:"true"`

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings `locationName:"inputClippingSettings" type:"structure"`

	// The value for the variable portion of the URL for the dynamic input, for
	// this instance of the input. Each time you use the same dynamic input in an
	// input switch action, you can provide a different value, in order to connect
	// the input to a different content source.
	UrlPath []*string `locationName:"urlPath" type:"list"`
}

// String returns the string representation
func (s InputSwitchScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSwitchScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSwitchScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSwitchScheduleActionSettings"}
	if s.InputAttachmentNameReference == nil {
		invalidParams.Add(request.NewErrParamRequired("InputAttachmentNameReference"))
	}
	if s.InputClippingSettings != nil {
		if err := s.InputClippingSettings.Validate(); err != nil {
			invalidParams.AddNested("InputClippingSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputAttachmentNameReference sets the InputAttachmentNameReference field's value.
func (s *InputSwitchScheduleActionSettings) SetInputAttachmentNameReference(v string) *InputSwitchScheduleActionSettings {
	s.InputAttachmentNameReference = &v
	return s
}

// SetInputClippingSettings sets the InputClippingSettings field's value.
func (s *InputSwitchScheduleActionSettings) SetInputClippingSettings(v *InputClippingSettings) *InputSwitchScheduleActionSettings {
	s.InputClippingSettings = v
	return s
}

// SetUrlPath sets the UrlPath field's value.
func (s *InputSwitchScheduleActionSettings) SetUrlPath(v []*string) *InputSwitchScheduleActionSettings {
	s.UrlPath = v
	return s
}

// Settings for a private VPC Input.When this property is specified, the input
// destination addresses will be created in a VPC rather than with public Internet
// addresses.This property requires setting the roleArn property on Input creation.Not
// compatible with the inputSecurityGroups property.
type InputVpcRequest struct {
	_ struct{} `type:"structure"`

	// A list of up to 5 EC2 VPC security group IDs to attach to the Input VPC network
	// interfaces.Requires subnetIds. If none are specified then the VPC default
	// security group will be used.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of 2 VPC subnet IDs from the same VPC.Subnet IDs must be mapped to
	// two unique availability zones (AZ).
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s InputVpcRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputVpcRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputVpcRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputVpcRequest"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *InputVpcRequest) SetSecurityGroupIds(v []*string) *InputVpcRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *InputVpcRequest) SetSubnetIds(v []*string) *InputVpcRequest {
	s.SubnetIds = v
	return s
}

// Whitelist rule
type InputWhitelistRule struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR that's whitelisted.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputWhitelistRule) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRule) SetCidr(v string) *InputWhitelistRule {
	s.Cidr = &v
	return s
}

// An IPv4 CIDR to whitelist.
type InputWhitelistRuleCidr struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR to whitelist.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRuleCidr) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputWhitelistRuleCidr) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRuleCidr) SetCidr(v string) *InputWhitelistRuleCidr {
	s.Cidr = &v
	return s
}

type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Key Provider Settings
type KeyProviderSettings struct {
	_ struct{} `type:"structure"`

	// Static Key Settings
	StaticKeySettings *StaticKeySettings `locationName:"staticKeySettings" type:"structure"`
}

// String returns the string representation
func (s KeyProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyProviderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyProviderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyProviderSettings"}
	if s.StaticKeySettings != nil {
		if err := s.StaticKeySettings.Validate(); err != nil {
			invalidParams.AddNested("StaticKeySettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticKeySettings sets the StaticKeySettings field's value.
func (s *KeyProviderSettings) SetStaticKeySettings(v *StaticKeySettings) *KeyProviderSettings {
	s.StaticKeySettings = v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	Channels []*ChannelSummary `locationName:"channels" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListInputDevicesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputDevicesInput) SetMaxResults(v int64) *ListInputDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputDevicesInput) SetNextToken(v string) *ListInputDevicesInput {
	s.NextToken = &v
	return s
}

type ListInputDevicesOutput struct {
	_ struct{} `type:"structure"`

	InputDevices []*InputDeviceSummary `locationName:"inputDevices" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputDevicesOutput) GoString() string {
	return s.String()
}

// SetInputDevices sets the InputDevices field's value.
func (s *ListInputDevicesOutput) SetInputDevices(v []*InputDeviceSummary) *ListInputDevicesOutput {
	s.InputDevices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputDevicesOutput) SetNextToken(v string) *ListInputDevicesOutput {
	s.NextToken = &v
	return s
}

type ListInputSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputSecurityGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputSecurityGroupsInput) SetMaxResults(v int64) *ListInputSecurityGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputSecurityGroupsInput) SetNextToken(v string) *ListInputSecurityGroupsInput {
	s.NextToken = &v
	return s
}

type ListInputSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	InputSecurityGroups []*InputSecurityGroup `locationName:"inputSecurityGroups" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *ListInputSecurityGroupsOutput) SetInputSecurityGroups(v []*InputSecurityGroup) *ListInputSecurityGroupsOutput {
	s.InputSecurityGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputSecurityGroupsOutput) SetNextToken(v string) *ListInputSecurityGroupsOutput {
	s.NextToken = &v
	return s
}

type ListInputsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputsInput) SetMaxResults(v int64) *ListInputsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsInput) SetNextToken(v string) *ListInputsInput {
	s.NextToken = &v
	return s
}

type ListInputsOutput struct {
	_ struct{} `type:"structure"`

	Inputs []*Input `locationName:"inputs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsOutput) GoString() string {
	return s.String()
}

// SetInputs sets the Inputs field's value.
func (s *ListInputsOutput) SetInputs(v []*Input) *ListInputsOutput {
	s.Inputs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsOutput) SetNextToken(v string) *ListInputsOutput {
	s.NextToken = &v
	return s
}

type ListMultiplexProgramsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexProgramsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultiplexProgramsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultiplexProgramsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultiplexProgramsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMultiplexProgramsInput) SetMaxResults(v int64) *ListMultiplexProgramsInput {
	s.MaxResults = &v
	return s
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *ListMultiplexProgramsInput) SetMultiplexId(v string) *ListMultiplexProgramsInput {
	s.MultiplexId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiplexProgramsInput) SetNextToken(v string) *ListMultiplexProgramsInput {
	s.NextToken = &v
	return s
}

type ListMultiplexProgramsOutput struct {
	_ struct{} `type:"structure"`

	MultiplexPrograms []*MultiplexProgramSummary `locationName:"multiplexPrograms" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexProgramsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultiplexProgramsOutput) GoString() string {
	return s.String()
}

// SetMultiplexPrograms sets the MultiplexPrograms field's value.
func (s *ListMultiplexProgramsOutput) SetMultiplexPrograms(v []*MultiplexProgramSummary) *ListMultiplexProgramsOutput {
	s.MultiplexPrograms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiplexProgramsOutput) SetNextToken(v string) *ListMultiplexProgramsOutput {
	s.NextToken = &v
	return s
}

type ListMultiplexesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultiplexesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultiplexesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultiplexesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMultiplexesInput) SetMaxResults(v int64) *ListMultiplexesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiplexesInput) SetNextToken(v string) *ListMultiplexesInput {
	s.NextToken = &v
	return s
}

type ListMultiplexesOutput struct {
	_ struct{} `type:"structure"`

	Multiplexes []*MultiplexSummary `locationName:"multiplexes" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultiplexesOutput) GoString() string {
	return s.String()
}

// SetMultiplexes sets the Multiplexes field's value.
func (s *ListMultiplexesOutput) SetMultiplexes(v []*MultiplexSummary) *ListMultiplexesOutput {
	s.Multiplexes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiplexesOutput) SetNextToken(v string) *ListMultiplexesOutput {
	s.NextToken = &v
	return s
}

type ListOfferingsInput struct {
	_ struct{} `type:"structure"`

	ChannelClass *string `location:"querystring" locationName:"channelClass" type:"string"`

	ChannelConfiguration *string `location:"querystring" locationName:"channelConfiguration" type:"string"`

	Codec *string `location:"querystring" locationName:"codec" type:"string"`

	Duration *string `location:"querystring" locationName:"duration" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	MaximumBitrate *string `location:"querystring" locationName:"maximumBitrate" type:"string"`

	MaximumFramerate *string `location:"querystring" locationName:"maximumFramerate" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	Resolution *string `location:"querystring" locationName:"resolution" type:"string"`

	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	SpecialFeature *string `location:"querystring" locationName:"specialFeature" type:"string"`

	VideoQuality *string `location:"querystring" locationName:"videoQuality" type:"string"`
}

// String returns the string representation
func (s ListOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelClass sets the ChannelClass field's value.
func (s *ListOfferingsInput) SetChannelClass(v string) *ListOfferingsInput {
	s.ChannelClass = &v
	return s
}

// SetChannelConfiguration sets the ChannelConfiguration field's value.
func (s *ListOfferingsInput) SetChannelConfiguration(v string) *ListOfferingsInput {
	s.ChannelConfiguration = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *ListOfferingsInput) SetCodec(v string) *ListOfferingsInput {
	s.Codec = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ListOfferingsInput) SetDuration(v string) *ListOfferingsInput {
	s.Duration = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOfferingsInput) SetMaxResults(v int64) *ListOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *ListOfferingsInput) SetMaximumBitrate(v string) *ListOfferingsInput {
	s.MaximumBitrate = &v
	return s
}

// SetMaximumFramerate sets the MaximumFramerate field's value.
func (s *ListOfferingsInput) SetMaximumFramerate(v string) *ListOfferingsInput {
	s.MaximumFramerate = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsInput) SetNextToken(v string) *ListOfferingsInput {
	s.NextToken = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *ListOfferingsInput) SetResolution(v string) *ListOfferingsInput {
	s.Resolution = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListOfferingsInput) SetResourceType(v string) *ListOfferingsInput {
	s.ResourceType = &v
	return s
}

// SetSpecialFeature sets the SpecialFeature field's value.
func (s *ListOfferingsInput) SetSpecialFeature(v string) *ListOfferingsInput {
	s.SpecialFeature = &v
	return s
}

// SetVideoQuality sets the VideoQuality field's value.
func (s *ListOfferingsInput) SetVideoQuality(v string) *ListOfferingsInput {
	s.VideoQuality = &v
	return s
}

type ListOfferingsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Offerings []*Offering `locationName:"offerings" type:"list"`
}

// String returns the string representation
func (s ListOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsOutput) SetNextToken(v string) *ListOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetOfferings sets the Offerings field's value.
func (s *ListOfferingsOutput) SetOfferings(v []*Offering) *ListOfferingsOutput {
	s.Offerings = v
	return s
}

type ListReservationsInput struct {
	_ struct{} `type:"structure"`

	ChannelClass *string `location:"querystring" locationName:"channelClass" type:"string"`

	Codec *string `location:"querystring" locationName:"codec" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	MaximumBitrate *string `location:"querystring" locationName:"maximumBitrate" type:"string"`

	MaximumFramerate *string `location:"querystring" locationName:"maximumFramerate" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	Resolution *string `location:"querystring" locationName:"resolution" type:"string"`

	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	SpecialFeature *string `location:"querystring" locationName:"specialFeature" type:"string"`

	VideoQuality *string `location:"querystring" locationName:"videoQuality" type:"string"`
}

// String returns the string representation
func (s ListReservationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReservationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReservationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReservationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelClass sets the ChannelClass field's value.
func (s *ListReservationsInput) SetChannelClass(v string) *ListReservationsInput {
	s.ChannelClass = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *ListReservationsInput) SetCodec(v string) *ListReservationsInput {
	s.Codec = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReservationsInput) SetMaxResults(v int64) *ListReservationsInput {
	s.MaxResults = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *ListReservationsInput) SetMaximumBitrate(v string) *ListReservationsInput {
	s.MaximumBitrate = &v
	return s
}

// SetMaximumFramerate sets the MaximumFramerate field's value.
func (s *ListReservationsInput) SetMaximumFramerate(v string) *ListReservationsInput {
	s.MaximumFramerate = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReservationsInput) SetNextToken(v string) *ListReservationsInput {
	s.NextToken = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *ListReservationsInput) SetResolution(v string) *ListReservationsInput {
	s.Resolution = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListReservationsInput) SetResourceType(v string) *ListReservationsInput {
	s.ResourceType = &v
	return s
}

// SetSpecialFeature sets the SpecialFeature field's value.
func (s *ListReservationsInput) SetSpecialFeature(v string) *ListReservationsInput {
	s.SpecialFeature = &v
	return s
}

// SetVideoQuality sets the VideoQuality field's value.
func (s *ListReservationsInput) SetVideoQuality(v string) *ListReservationsInput {
	s.VideoQuality = &v
	return s
}

type ListReservationsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Reservations []*Reservation `locationName:"reservations" type:"list"`
}

// String returns the string representation
func (s ListReservationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReservationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReservationsOutput) SetNextToken(v string) *ListReservationsOutput {
	s.NextToken = &v
	return s
}

// SetReservations sets the Reservations field's value.
func (s *ListReservationsOutput) SetReservations(v []*Reservation) *ListReservationsOutput {
	s.Reservations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// M2ts Settings
type M2tsSettings struct {
	_ struct{} `type:"structure"`

	// When set to drop, output audio streams will be removed from the program if
	// the selected input audio stream is removed from the input. This allows the
	// output audio configuration to dynamically change based on input configuration.
	// If this is set to encodeSilence, all output audio streams will output encoded
	// silence when not connected to an active input stream.
	AbsentInputAudioBehavior *string `locationName:"absentInputAudioBehavior" type:"string" enum:"M2tsAbsentInputAudioBehavior"`

	// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
	Arib *string `locationName:"arib" type:"string" enum:"M2tsArib"`

	// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	AribCaptionsPid *string `locationName:"aribCaptionsPid" type:"string"`

	// If set to auto, pid number used for ARIB Captions will be auto-selected from
	// unused pids. If set to useConfigured, ARIB Captions will be on the configured
	// pid number.
	AribCaptionsPidControl *string `locationName:"aribCaptionsPidControl" type:"string" enum:"M2tsAribCaptionsPidControl"`

	// When set to dvb, uses DVB buffer model for Dolby Digital audio. When set
	// to atsc, the ATSC model is used.
	AudioBufferModel *string `locationName:"audioBufferModel" type:"string" enum:"M2tsAudioBufferModel"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values. Each
	// PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	AudioPids *string `locationName:"audioPids" type:"string"`

	// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87
	// for EAC3. When set to dvb, uses stream type = 0x06.
	AudioStreamType *string `locationName:"audioStreamType" type:"string" enum:"M2tsAudioStreamType"`

	// The output bitrate of the transport stream in bits per second. Setting to
	// 0 lets the muxer automatically determine the appropriate bitrate.
	Bitrate *int64 `locationName:"bitrate" type:"integer"`

	// If set to multiplex, use multiplex buffer model for accurate interleaving.
	// Setting to bufferModel to none can lead to lower latency, but low-memory
	// devices may not be able to play back the stream without interruptions.
	BufferModel *string `locationName:"bufferModel" type:"string" enum:"M2tsBufferModel"`

	// When set to enabled, generates captionServiceDescriptor in PMT.
	CcDescriptor *string `locationName:"ccDescriptor" type:"string" enum:"M2tsCcDescriptor"`

	// Inserts DVB Network Information Table (NIT) at the specified table repetition
	// interval.
	DvbNitSettings *DvbNitSettings `locationName:"dvbNitSettings" type:"structure"`

	// Inserts DVB Service Description Table (SDT) at the specified table repetition
	// interval.
	DvbSdtSettings *DvbSdtSettings `locationName:"dvbSdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Subtitle data to this output.
	// Multiple values are accepted, and can be entered in ranges and/or by comma
	// separation. Can be entered as decimal or hexadecimal values. Each PID specified
	// must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	DvbSubPids *string `locationName:"dvbSubPids" type:"string"`

	// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
	DvbTdtSettings *DvbTdtSettings `locationName:"dvbTdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Teletext data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	DvbTeletextPid *string `locationName:"dvbTeletextPid" type:"string"`

	// If set to passthrough, passes any EBIF data from the input source to this
	// output.
	Ebif *string `locationName:"ebif" type:"string" enum:"M2tsEbifControl"`

	// When videoAndFixedIntervals is selected, audio EBP markers will be added
	// to partitions 3 and 4. The interval between these additional markers will
	// be fixed, and will be slightly shorter than the video EBP marker interval.
	// Only available when EBP Cablelabs segmentation markers are selected. Partitions
	// 1 and 2 will always follow the video interval.
	EbpAudioInterval *string `locationName:"ebpAudioInterval" type:"string" enum:"M2tsAudioInterval"`

	// When set, enforces that Encoder Boundary Points do not come within the specified
	// time interval of each other by looking ahead at input video. If another EBP
	// is going to come in within the specified time interval, the current EBP is
	// not emitted, and the segment is "stretched" to the next marker. The lookahead
	// value does not add latency to the system. The Live Event must be configured
	// elsewhere to create sufficient latency to make the lookahead accurate.
	EbpLookaheadMs *int64 `locationName:"ebpLookaheadMs" type:"integer"`

	// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP
	// markers will be placed on the video PID and all audio PIDs. If set to videoPid,
	// EBP markers will be placed on only the video PID.
	EbpPlacement *string `locationName:"ebpPlacement" type:"string" enum:"M2tsEbpPlacement"`

	// This field is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// Include or exclude the ES Rate field in the PES header.
	EsRateInPes *string `locationName:"esRateInPes" type:"string" enum:"M2tsEsRateInPes"`

	// Packet Identifier (PID) for input source ETV Platform data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvPlatformPid *string `locationName:"etvPlatformPid" type:"string"`

	// Packet Identifier (PID) for input source ETV Signal data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvSignalPid *string `locationName:"etvSignalPid" type:"string"`

	// The length in seconds of each fragment. Only used with EBP markers.
	FragmentTime *float64 `locationName:"fragmentTime" type:"double"`

	// If set to passthrough, passes any KLV data from the input source to this
	// output.
	Klv *string `locationName:"klv" type:"string" enum:"M2tsKlv"`

	// Packet Identifier (PID) for input source KLV data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	KlvDataPids *string `locationName:"klvDataPids" type:"string"`

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in
	// the output.
	NielsenId3Behavior *string `locationName:"nielsenId3Behavior" type:"string" enum:"M2tsNielsenId3Behavior"`

	// Value in bits per second of extra null packets to insert into the transport
	// stream. This can be used if a downstream encryption system requires periodic
	// null packets.
	NullPacketBitrate *float64 `locationName:"nullPacketBitrate" type:"double"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl *string `locationName:"pcrControl" type:"string" enum:"M2tsPcrControl"`

	// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value. Valid values
	// are 32 (or 0x20)..8182 (or 0x1ff6).
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value. Valid values are
	// 32 (or 0x20)..8182 (or 0x1ff6).
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// When vbr, does not insert null packets into transport stream to fill specified
	// bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
	RateMode *string `locationName:"rateMode" type:"string" enum:"M2tsRateMode"`

	// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	Scte27Pids *string `locationName:"scte27Pids" type:"string"`

	// Optionally pass SCTE-35 signals from the input source to this output.
	Scte35Control *string `locationName:"scte35Control" type:"string" enum:"M2tsScte35Control"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// Inserts segmentation markers at each segmentationTime period. raiSegstart
	// sets the Random Access Indicator bit in the adaptation field. raiAdapt sets
	// the RAI bit and adds the current timecode in the private data bytes. psiSegstart
	// inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary
	// Point information to the adaptation field as per OpenCable specification
	// OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to
	// the adaptation field using a legacy proprietary format.
	SegmentationMarkers *string `locationName:"segmentationMarkers" type:"string" enum:"M2tsSegmentationMarkers"`

	// The segmentation style parameter controls how segmentation markers are inserted
	// into the transport stream. With avails, it is possible that segments may
	// be truncated, which can influence where future segmentation markers are inserted.When
	// a segmentation style of "resetCadence" is selected and a segment is truncated
	// due to an avail, we will reset the segmentation cadence. This means the subsequent
	// segment will have a duration of $segmentationTime seconds.When a segmentation
	// style of "maintainCadence" is selected and a segment is truncated due to
	// an avail, we will not reset the segmentation cadence. This means the subsequent
	// segment will likely be truncated as well. However, all segments after that
	// will have a duration of $segmentationTime seconds. Note that EBP lookahead
	// is a slight exception to this rule.
	SegmentationStyle *string `locationName:"segmentationStyle" type:"string" enum:"M2tsSegmentationStyle"`

	// The length in seconds of each segment. Required unless markers is set to
	// _none_.
	SegmentationTime *float64 `locationName:"segmentationTime" type:"double"`

	// When set to passthrough, timed metadata will be passed through from input
	// to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"M2tsTimedMetadataBehavior"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M2tsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s M2tsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2tsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2tsSettings"}
	if s.DvbNitSettings != nil {
		if err := s.DvbNitSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbNitSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSdtSettings != nil {
		if err := s.DvbSdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSdtSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbTdtSettings != nil {
		if err := s.DvbTdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbTdtSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsentInputAudioBehavior sets the AbsentInputAudioBehavior field's value.
func (s *M2tsSettings) SetAbsentInputAudioBehavior(v string) *M2tsSettings {
	s.AbsentInputAudioBehavior = &v
	return s
}

// SetArib sets the Arib field's value.
func (s *M2tsSettings) SetArib(v string) *M2tsSettings {
	s.Arib = &v
	return s
}

// SetAribCaptionsPid sets the AribCaptionsPid field's value.
func (s *M2tsSettings) SetAribCaptionsPid(v string) *M2tsSettings {
	s.AribCaptionsPid = &v
	return s
}

// SetAribCaptionsPidControl sets the AribCaptionsPidControl field's value.
func (s *M2tsSettings) SetAribCaptionsPidControl(v string) *M2tsSettings {
	s.AribCaptionsPidControl = &v
	return s
}

// SetAudioBufferModel sets the AudioBufferModel field's value.
func (s *M2tsSettings) SetAudioBufferModel(v string) *M2tsSettings {
	s.AudioBufferModel = &v
	return s
}

// SetAudioFramesPerPes sets the AudioFramesPerPes field's value.
func (s *M2tsSettings) SetAudioFramesPerPes(v int64) *M2tsSettings {
	s.AudioFramesPerPes = &v
	return s
}

// SetAudioPids sets the AudioPids field's value.
func (s *M2tsSettings) SetAudioPids(v string) *M2tsSettings {
	s.AudioPids = &v
	return s
}

// SetAudioStreamType sets the AudioStreamType field's value.
func (s *M2tsSettings) SetAudioStreamType(v string) *M2tsSettings {
	s.AudioStreamType = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *M2tsSettings) SetBitrate(v int64) *M2tsSettings {
	s.Bitrate = &v
	return s
}

// SetBufferModel sets the BufferModel field's value.
func (s *M2tsSettings) SetBufferModel(v string) *M2tsSettings {
	s.BufferModel = &v
	return s
}

// SetCcDescriptor sets the CcDescriptor field's value.
func (s *M2tsSettings) SetCcDescriptor(v string) *M2tsSettings {
	s.CcDescriptor = &v
	return s
}

// SetDvbNitSettings sets the DvbNitSettings field's value.
func (s *M2tsSettings) SetDvbNitSettings(v *DvbNitSettings) *M2tsSettings {
	s.DvbNitSettings = v
	return s
}

// SetDvbSdtSettings sets the DvbSdtSettings field's value.
func (s *M2tsSettings) SetDvbSdtSettings(v *DvbSdtSettings) *M2tsSettings {
	s.DvbSdtSettings = v
	return s
}

// SetDvbSubPids sets the DvbSubPids field's value.
func (s *M2tsSettings) SetDvbSubPids(v string) *M2tsSettings {
	s.DvbSubPids = &v
	return s
}

// SetDvbTdtSettings sets the DvbTdtSettings field's value.
func (s *M2tsSettings) SetDvbTdtSettings(v *DvbTdtSettings) *M2tsSettings {
	s.DvbTdtSettings = v
	return s
}

// SetDvbTeletextPid sets the DvbTeletextPid field's value.
func (s *M2tsSettings) SetDvbTeletextPid(v string) *M2tsSettings {
	s.DvbTeletextPid = &v
	return s
}

// SetEbif sets the Ebif field's value.
func (s *M2tsSettings) SetEbif(v string) *M2tsSettings {
	s.Ebif = &v
	return s
}

// SetEbpAudioInterval sets the EbpAudioInterval field's value.
func (s *M2tsSettings) SetEbpAudioInterval(v string) *M2tsSettings {
	s.EbpAudioInterval = &v
	return s
}

// SetEbpLookaheadMs sets the EbpLookaheadMs field's value.
func (s *M2tsSettings) SetEbpLookaheadMs(v int64) *M2tsSettings {
	s.EbpLookaheadMs = &v
	return s
}

// SetEbpPlacement sets the EbpPlacement field's value.
func (s *M2tsSettings) SetEbpPlacement(v string) *M2tsSettings {
	s.EbpPlacement = &v
	return s
}

// SetEcmPid sets the EcmPid field's value.
func (s *M2tsSettings) SetEcmPid(v string) *M2tsSettings {
	s.EcmPid = &v
	return s
}

// SetEsRateInPes sets the EsRateInPes field's value.
func (s *M2tsSettings) SetEsRateInPes(v string) *M2tsSettings {
	s.EsRateInPes = &v
	return s
}

// SetEtvPlatformPid sets the EtvPlatformPid field's value.
func (s *M2tsSettings) SetEtvPlatformPid(v string) *M2tsSettings {
	s.EtvPlatformPid = &v
	return s
}

// SetEtvSignalPid sets the EtvSignalPid field's value.
func (s *M2tsSettings) SetEtvSignalPid(v string) *M2tsSettings {
	s.EtvSignalPid = &v
	return s
}

// SetFragmentTime sets the FragmentTime field's value.
func (s *M2tsSettings) SetFragmentTime(v float64) *M2tsSettings {
	s.FragmentTime = &v
	return s
}

// SetKlv sets the Klv field's value.
func (s *M2tsSettings) SetKlv(v string) *M2tsSettings {
	s.Klv = &v
	return s
}

// SetKlvDataPids sets the KlvDataPids field's value.
func (s *M2tsSettings) SetKlvDataPids(v string) *M2tsSettings {
	s.KlvDataPids = &v
	return s
}

// SetNielsenId3Behavior sets the NielsenId3Behavior field's value.
func (s *M2tsSettings) SetNielsenId3Behavior(v string) *M2tsSettings {
	s.NielsenId3Behavior = &v
	return s
}

// SetNullPacketBitrate sets the NullPacketBitrate field's value.
func (s *M2tsSettings) SetNullPacketBitrate(v float64) *M2tsSettings {
	s.NullPacketBitrate = &v
	return s
}

// SetPatInterval sets the PatInterval field's value.
func (s *M2tsSettings) SetPatInterval(v int64) *M2tsSettings {
	s.PatInterval = &v
	return s
}

// SetPcrControl sets the PcrControl field's value.
func (s *M2tsSettings) SetPcrControl(v string) *M2tsSettings {
	s.PcrControl = &v
	return s
}

// SetPcrPeriod sets the PcrPeriod field's value.
func (s *M2tsSettings) SetPcrPeriod(v int64) *M2tsSettings {
	s.PcrPeriod = &v
	return s
}

// SetPcrPid sets the PcrPid field's value.
func (s *M2tsSettings) SetPcrPid(v string) *M2tsSettings {
	s.PcrPid = &v
	return s
}

// SetPmtInterval sets the PmtInterval field's value.
func (s *M2tsSettings) SetPmtInterval(v int64) *M2tsSettings {
	s.PmtInterval = &v
	return s
}

// SetPmtPid sets the PmtPid field's value.
func (s *M2tsSettings) SetPmtPid(v string) *M2tsSettings {
	s.PmtPid = &v
	return s
}

// SetProgramNum sets the ProgramNum field's value.
func (s *M2tsSettings) SetProgramNum(v int64) *M2tsSettings {
	s.ProgramNum = &v
	return s
}

// SetRateMode sets the RateMode field's value.
func (s *M2tsSettings) SetRateMode(v string) *M2tsSettings {
	s.RateMode = &v
	return s
}

// SetScte27Pids sets the Scte27Pids field's value.
func (s *M2tsSettings) SetScte27Pids(v string) *M2tsSettings {
	s.Scte27Pids = &v
	return s
}

// SetScte35Control sets the Scte35Control field's value.
func (s *M2tsSettings) SetScte35Control(v string) *M2tsSettings {
	s.Scte35Control = &v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *M2tsSettings) SetScte35Pid(v string) *M2tsSettings {
	s.Scte35Pid = &v
	return s
}

// SetSegmentationMarkers sets the SegmentationMarkers field's value.
func (s *M2tsSettings) SetSegmentationMarkers(v string) *M2tsSettings {
	s.SegmentationMarkers = &v
	return s
}

// SetSegmentationStyle sets the SegmentationStyle field's value.
func (s *M2tsSettings) SetSegmentationStyle(v string) *M2tsSettings {
	s.SegmentationStyle = &v
	return s
}

// SetSegmentationTime sets the SegmentationTime field's value.
func (s *M2tsSettings) SetSegmentationTime(v float64) *M2tsSettings {
	s.SegmentationTime = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *M2tsSettings) SetTimedMetadataBehavior(v string) *M2tsSettings {
	s.TimedMetadataBehavior = &v
	return s
}

// SetTimedMetadataPid sets the TimedMetadataPid field's value.
func (s *M2tsSettings) SetTimedMetadataPid(v string) *M2tsSettings {
	s.TimedMetadataPid = &v
	return s
}

// SetTransportStreamId sets the TransportStreamId field's value.
func (s *M2tsSettings) SetTransportStreamId(v int64) *M2tsSettings {
	s.TransportStreamId = &v
	return s
}

// SetVideoPid sets the VideoPid field's value.
func (s *M2tsSettings) SetVideoPid(v string) *M2tsSettings {
	s.VideoPid = &v
	return s
}

// Settings information for the .m3u8 container
type M3u8Settings struct {
	_ struct{} `type:"structure"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values.
	AudioPids *string `locationName:"audioPids" type:"string"`

	// This parameter is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in
	// the output.
	NielsenId3Behavior *string `locationName:"nielsenId3Behavior" type:"string" enum:"M3u8NielsenId3Behavior"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl *string `locationName:"pcrControl" type:"string" enum:"M3u8PcrControl"`

	// Maximum time in milliseconds between Program Clock References (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value.
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value.
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// If set to passthrough, passes any SCTE-35 signals from the input source to
	// this output.
	Scte35Behavior *string `locationName:"scte35Behavior" type:"string" enum:"M3u8Scte35Behavior"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value.
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"M3u8TimedMetadataBehavior"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value.
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M3u8Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s M3u8Settings) GoString() string {
	return s.String()
}

// SetAudioFramesPerPes sets the AudioFramesPerPes field's value.
func (s *M3u8Settings) SetAudioFramesPerPes(v int64) *M3u8Settings {
	s.AudioFramesPerPes = &v
	return s
}

// SetAudioPids sets the AudioPids field's value.
func (s *M3u8Settings) SetAudioPids(v string) *M3u8Settings {
	s.AudioPids = &v
	return s
}

// SetEcmPid sets the EcmPid field's value.
func (s *M3u8Settings) SetEcmPid(v string) *M3u8Settings {
	s.EcmPid = &v
	return s
}

// SetNielsenId3Behavior sets the NielsenId3Behavior field's value.
func (s *M3u8Settings) SetNielsenId3Behavior(v string) *M3u8Settings {
	s.NielsenId3Behavior = &v
	return s
}

// SetPatInterval sets the PatInterval field's value.
func (s *M3u8Settings) SetPatInterval(v int64) *M3u8Settings {
	s.PatInterval = &v
	return s
}

// SetPcrControl sets the PcrControl field's value.
func (s *M3u8Settings) SetPcrControl(v string) *M3u8Settings {
	s.PcrControl = &v
	return s
}

// SetPcrPeriod sets the PcrPeriod field's value.
func (s *M3u8Settings) SetPcrPeriod(v int64) *M3u8Settings {
	s.PcrPeriod = &v
	return s
}

// SetPcrPid sets the PcrPid field's value.
func (s *M3u8Settings) SetPcrPid(v string) *M3u8Settings {
	s.PcrPid = &v
	return s
}

// SetPmtInterval sets the PmtInterval field's value.
func (s *M3u8Settings) SetPmtInterval(v int64) *M3u8Settings {
	s.PmtInterval = &v
	return s
}

// SetPmtPid sets the PmtPid field's value.
func (s *M3u8Settings) SetPmtPid(v string) *M3u8Settings {
	s.PmtPid = &v
	return s
}

// SetProgramNum sets the ProgramNum field's value.
func (s *M3u8Settings) SetProgramNum(v int64) *M3u8Settings {
	s.ProgramNum = &v
	return s
}

// SetScte35Behavior sets the Scte35Behavior field's value.
func (s *M3u8Settings) SetScte35Behavior(v string) *M3u8Settings {
	s.Scte35Behavior = &v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *M3u8Settings) SetScte35Pid(v string) *M3u8Settings {
	s.Scte35Pid = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *M3u8Settings) SetTimedMetadataBehavior(v string) *M3u8Settings {
	s.TimedMetadataBehavior = &v
	return s
}

// SetTimedMetadataPid sets the TimedMetadataPid field's value.
func (s *M3u8Settings) SetTimedMetadataPid(v string) *M3u8Settings {
	s.TimedMetadataPid = &v
	return s
}

// SetTransportStreamId sets the TransportStreamId field's value.
func (s *M3u8Settings) SetTransportStreamId(v int64) *M3u8Settings {
	s.TransportStreamId = &v
	return s
}

// SetVideoPid sets the VideoPid field's value.
func (s *M3u8Settings) SetVideoPid(v string) *M3u8Settings {
	s.VideoPid = &v
	return s
}

// The settings for a MediaConnect Flow.
type MediaConnectFlow struct {
	_ struct{} `type:"structure"`

	// The unique ARN of the MediaConnect Flow being used as a source.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s MediaConnectFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaConnectFlow) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *MediaConnectFlow) SetFlowArn(v string) *MediaConnectFlow {
	s.FlowArn = &v
	return s
}

// The settings for a MediaConnect Flow.
type MediaConnectFlowRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the MediaConnect Flow that you want to use as a source.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s MediaConnectFlowRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaConnectFlowRequest) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *MediaConnectFlowRequest) SetFlowArn(v string) *MediaConnectFlowRequest {
	s.FlowArn = &v
	return s
}

// Media Package Group Settings
type MediaPackageGroupSettings struct {
	_ struct{} `type:"structure"`

	// MediaPackage channel destination.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation
func (s MediaPackageGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaPackageGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaPackageGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MediaPackageGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *MediaPackageGroupSettings) SetDestination(v *OutputLocationRef) *MediaPackageGroupSettings {
	s.Destination = v
	return s
}

// MediaPackage Output Destination Settings
type MediaPackageOutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// ID of the channel in MediaPackage that is the destination for this output
	// group. You do not need to specify the individual inputs in MediaPackage;
	// MediaLive will handle the connection of the two MediaLive pipelines to the
	// two MediaPackage inputs. The MediaPackage channel and MediaLive channel must
	// be in the same region.
	ChannelId *string `locationName:"channelId" min:"1" type:"string"`
}

// String returns the string representation
func (s MediaPackageOutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaPackageOutputDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaPackageOutputDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MediaPackageOutputDestinationSettings"}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *MediaPackageOutputDestinationSettings) SetChannelId(v string) *MediaPackageOutputDestinationSettings {
	s.ChannelId = &v
	return s
}

// Media Package Output Settings
type MediaPackageOutputSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MediaPackageOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaPackageOutputSettings) GoString() string {
	return s.String()
}

// Mp2 Settings
type Mp2Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or
	// codingMode20 (for stereo).
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Mp2CodingMode"`

	// Sample rate in Hz.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`
}

// String returns the string representation
func (s Mp2Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Mp2Settings) GoString() string {
	return s.String()
}

// SetBitrate sets the Bitrate field's value.
func (s *Mp2Settings) SetBitrate(v float64) *Mp2Settings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Mp2Settings) SetCodingMode(v string) *Mp2Settings {
	s.CodingMode = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *Mp2Settings) SetSampleRate(v float64) *Mp2Settings {
	s.SampleRate = &v
	return s
}

// Ms Smooth Group Settings
type MsSmoothGroupSettings struct {
	_ struct{} `type:"structure"`

	// The ID to include in each message in the sparse track. Ignored if sparseTrackType
	// is NONE.
	AcquisitionPointId *string `locationName:"acquisitionPointId" type:"string"`

	// If set to passthrough for an audio-only MS Smooth output, the fragment absolute
	// time will be set to the current timecode. This option does not write timecodes
	// to the audio elementary stream.
	AudioOnlyTimecodeControl *string `locationName:"audioOnlyTimecodeControl" type:"string" enum:"SmoothGroupAudioOnlyTimecodeControl"`

	// If set to verifyAuthenticity, verify the https certificate chain to a trusted
	// Certificate Authority (CA). This will cause https outputs to self-signed
	// certificates to fail.
	CertificateMode *string `locationName:"certificateMode" type:"string" enum:"SmoothGroupCertificateMode"`

	// Number of seconds to wait before retrying connection to the IIS server if
	// the connection is lost. Content will be cached during this time and the cache
	// will be be delivered to the IIS server once the connection is re-established.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Smooth Streaming publish point on an IIS server. Elemental Live acts as a
	// "Push" encoder to IIS.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// MS Smooth event ID to be sent to the IIS server.Should only be specified
	// if eventIdMode is set to useConfigured.
	EventId *string `locationName:"eventId" type:"string"`

	// Specifies whether or not to send an event ID to the IIS server. If no event
	// ID is sent and the same Live Event is used without changing the publishing
	// point, clients might see cached video from the previous run.Options:- "useConfigured"
	// - use the value provided in eventId- "useTimestamp" - generate and send an
	// event ID based on the current timestamp- "noEventId" - do not send an event
	// ID to the IIS server.
	EventIdMode *string `locationName:"eventIdMode" type:"string" enum:"SmoothGroupEventIdMode"`

	// When set to sendEos, send EOS signal to IIS server when stopping the event
	EventStopBehavior *string `locationName:"eventStopBehavior" type:"string" enum:"SmoothGroupEventStopBehavior"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Length of mp4 fragments to generate (in seconds). Fragment length must be
	// compatible with GOP size and framerate.
	FragmentLength *int64 `locationName:"fragmentLength" min:"1" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForMsSmoothOut"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// Number of seconds before initiating a restart due to output failure, due
	// to exhausting the numRetries on one segment, or exceeding filecacheDuration.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// useInputSegmentation has been deprecated. The configured segment size is
	// always used.
	SegmentationMode *string `locationName:"segmentationMode" type:"string" enum:"SmoothGroupSegmentationMode"`

	// Number of milliseconds to delay the output from the second pipeline.
	SendDelayMs *int64 `locationName:"sendDelayMs" type:"integer"`

	// Identifies the type of data to place in the sparse track:- SCTE35: Insert
	// SCTE-35 messages from the source content. With each message, insert an IDR
	// frame to start a new segment.- SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35
	// messages from the source content. With each message, insert an IDR frame
	// but don't start a new segment.- NONE: Don't generate a sparse track for any
	// outputs in this output group.
	SparseTrackType *string `locationName:"sparseTrackType" type:"string" enum:"SmoothGroupSparseTrackType"`

	// When set to send, send stream manifest so publishing point doesn't start
	// until all streams start.
	StreamManifestBehavior *string `locationName:"streamManifestBehavior" type:"string" enum:"SmoothGroupStreamManifestBehavior"`

	// Timestamp offset for the event. Only used if timestampOffsetMode is set to
	// useConfiguredOffset.
	TimestampOffset *string `locationName:"timestampOffset" type:"string"`

	// Type of timestamp date offset to use.- useEventStartDate: Use the date the
	// event was started as the offset- useConfiguredOffset: Use an explicitly configured
	// date as the offset
	TimestampOffsetMode *string `locationName:"timestampOffsetMode" type:"string" enum:"SmoothGroupTimestampOffsetMode"`
}

// String returns the string representation
func (s MsSmoothGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MsSmoothGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MsSmoothGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MsSmoothGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.FragmentLength != nil && *s.FragmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FragmentLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcquisitionPointId sets the AcquisitionPointId field's value.
func (s *MsSmoothGroupSettings) SetAcquisitionPointId(v string) *MsSmoothGroupSettings {
	s.AcquisitionPointId = &v
	return s
}

// SetAudioOnlyTimecodeControl sets the AudioOnlyTimecodeControl field's value.
func (s *MsSmoothGroupSettings) SetAudioOnlyTimecodeControl(v string) *MsSmoothGroupSettings {
	s.AudioOnlyTimecodeControl = &v
	return s
}

// SetCertificateMode sets the CertificateMode field's value.
func (s *MsSmoothGroupSettings) SetCertificateMode(v string) *MsSmoothGroupSettings {
	s.CertificateMode = &v
	return s
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *MsSmoothGroupSettings) SetConnectionRetryInterval(v int64) *MsSmoothGroupSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *MsSmoothGroupSettings) SetDestination(v *OutputLocationRef) *MsSmoothGroupSettings {
	s.Destination = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *MsSmoothGroupSettings) SetEventId(v string) *MsSmoothGroupSettings {
	s.EventId = &v
	return s
}

// SetEventIdMode sets the EventIdMode field's value.
func (s *MsSmoothGroupSettings) SetEventIdMode(v string) *MsSmoothGroupSettings {
	s.EventIdMode = &v
	return s
}

// SetEventStopBehavior sets the EventStopBehavior field's value.
func (s *MsSmoothGroupSettings) SetEventStopBehavior(v string) *MsSmoothGroupSettings {
	s.EventStopBehavior = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *MsSmoothGroupSettings) SetFilecacheDuration(v int64) *MsSmoothGroupSettings {
	s.FilecacheDuration = &v
	return s
}

// SetFragmentLength sets the FragmentLength field's value.
func (s *MsSmoothGroupSettings) SetFragmentLength(v int64) *MsSmoothGroupSettings {
	s.FragmentLength = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *MsSmoothGroupSettings) SetInputLossAction(v string) *MsSmoothGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *MsSmoothGroupSettings) SetNumRetries(v int64) *MsSmoothGroupSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *MsSmoothGroupSettings) SetRestartDelay(v int64) *MsSmoothGroupSettings {
	s.RestartDelay = &v
	return s
}

// SetSegmentationMode sets the SegmentationMode field's value.
func (s *MsSmoothGroupSettings) SetSegmentationMode(v string) *MsSmoothGroupSettings {
	s.SegmentationMode = &v
	return s
}

// SetSendDelayMs sets the SendDelayMs field's value.
func (s *MsSmoothGroupSettings) SetSendDelayMs(v int64) *MsSmoothGroupSettings {
	s.SendDelayMs = &v
	return s
}

// SetSparseTrackType sets the SparseTrackType field's value.
func (s *MsSmoothGroupSettings) SetSparseTrackType(v string) *MsSmoothGroupSettings {
	s.SparseTrackType = &v
	return s
}

// SetStreamManifestBehavior sets the StreamManifestBehavior field's value.
func (s *MsSmoothGroupSettings) SetStreamManifestBehavior(v string) *MsSmoothGroupSettings {
	s.StreamManifestBehavior = &v
	return s
}

// SetTimestampOffset sets the TimestampOffset field's value.
func (s *MsSmoothGroupSettings) SetTimestampOffset(v string) *MsSmoothGroupSettings {
	s.TimestampOffset = &v
	return s
}

// SetTimestampOffsetMode sets the TimestampOffsetMode field's value.
func (s *MsSmoothGroupSettings) SetTimestampOffsetMode(v string) *MsSmoothGroupSettings {
	s.TimestampOffsetMode = &v
	return s
}

// Ms Smooth Output Settings
type MsSmoothOutputSettings struct {
	_ struct{} `type:"structure"`

	// Only applicable when this output is referencing an H.265 video description.Specifies
	// whether MP4 segments should be packaged as HEV1 or HVC1.
	H265PackagingType *string `locationName:"h265PackagingType" type:"string" enum:"MsSmoothH265PackagingType"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s MsSmoothOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MsSmoothOutputSettings) GoString() string {
	return s.String()
}

// SetH265PackagingType sets the H265PackagingType field's value.
func (s *MsSmoothOutputSettings) SetH265PackagingType(v string) *MsSmoothOutputSettings {
	s.H265PackagingType = &v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *MsSmoothOutputSettings) SetNameModifier(v string) *MsSmoothOutputSettings {
	s.NameModifier = &v
	return s
}

// The multiplex object.
type Multiplex struct {
	_ struct{} `type:"structure"`

	// The unique arn of the multiplex.
	Arn *string `locationName:"arn" type:"string"`

	// A list of availability zones for the multiplex.
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	// A list of the multiplex output destinations.
	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	// The unique id of the multiplex.
	Id *string `locationName:"id" type:"string"`

	// Configuration for a multiplex event.
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	// The name of the multiplex.
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The number of programs in the multiplex.
	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Multiplex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Multiplex) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Multiplex) SetArn(v string) *Multiplex {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *Multiplex) SetAvailabilityZones(v []*string) *Multiplex {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Multiplex) SetDestinations(v []*MultiplexOutputDestination) *Multiplex {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *Multiplex) SetId(v string) *Multiplex {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *Multiplex) SetMultiplexSettings(v *MultiplexSettings) *Multiplex {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *Multiplex) SetName(v string) *Multiplex {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *Multiplex) SetPipelinesRunningCount(v int64) *Multiplex {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *Multiplex) SetProgramCount(v int64) *Multiplex {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *Multiplex) SetState(v string) *Multiplex {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Multiplex) SetTags(v map[string]*string) *Multiplex {
	s.Tags = v
	return s
}

// Multiplex Group Settings
type MultiplexGroupSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MultiplexGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexGroupSettings) GoString() string {
	return s.String()
}

// Multiplex MediaConnect output destination settings.
type MultiplexMediaConnectOutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// The MediaConnect entitlement ARN available as a Flow source.
	EntitlementArn *string `locationName:"entitlementArn" min:"1" type:"string"`
}

// String returns the string representation
func (s MultiplexMediaConnectOutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexMediaConnectOutputDestinationSettings) GoString() string {
	return s.String()
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *MultiplexMediaConnectOutputDestinationSettings) SetEntitlementArn(v string) *MultiplexMediaConnectOutputDestinationSettings {
	s.EntitlementArn = &v
	return s
}

// Multiplex output destination settings
type MultiplexOutputDestination struct {
	_ struct{} `type:"structure"`

	// Multiplex MediaConnect output destination settings.
	MediaConnectSettings *MultiplexMediaConnectOutputDestinationSettings `locationName:"mediaConnectSettings" type:"structure"`
}

// String returns the string representation
func (s MultiplexOutputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexOutputDestination) GoString() string {
	return s.String()
}

// SetMediaConnectSettings sets the MediaConnectSettings field's value.
func (s *MultiplexOutputDestination) SetMediaConnectSettings(v *MultiplexMediaConnectOutputDestinationSettings) *MultiplexOutputDestination {
	s.MediaConnectSettings = v
	return s
}

// Multiplex Output Settings
type MultiplexOutputSettings struct {
	_ struct{} `type:"structure"`

	// Destination is a Multiplex.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation
func (s MultiplexOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexOutputSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *MultiplexOutputSettings) SetDestination(v *OutputLocationRef) *MultiplexOutputSettings {
	s.Destination = v
	return s
}

// The multiplex program object.
type MultiplexProgram struct {
	_ struct{} `type:"structure"`

	// The MediaLive channel associated with the program.
	ChannelId *string `locationName:"channelId" type:"string"`

	// The settings for this multiplex program.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// The packet identifier map for this multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	// The name of the multiplex program.
	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation
func (s MultiplexProgram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgram) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *MultiplexProgram) SetChannelId(v string) *MultiplexProgram {
	s.ChannelId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *MultiplexProgram) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *MultiplexProgram {
	s.MultiplexProgramSettings = v
	return s
}

// SetPacketIdentifiersMap sets the PacketIdentifiersMap field's value.
func (s *MultiplexProgram) SetPacketIdentifiersMap(v *MultiplexProgramPacketIdentifiersMap) *MultiplexProgram {
	s.PacketIdentifiersMap = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *MultiplexProgram) SetProgramName(v string) *MultiplexProgram {
	s.ProgramName = &v
	return s
}

// Multiplex Program Input Destination Settings for outputting a Channel to
// a Multiplex
type MultiplexProgramChannelDestinationSettings struct {
	_ struct{} `type:"structure"`

	// The ID of the Multiplex that the encoder is providing output to. You do not
	// need to specify the individual inputs to the Multiplex; MediaLive will handle
	// the connection of the two MediaLive pipelines to the two Multiplex instances.The
	// Multiplex must be in the same region as the Channel.
	MultiplexId *string `locationName:"multiplexId" min:"1" type:"string"`

	// The program name of the Multiplex program that the encoder is providing output
	// to.
	ProgramName *string `locationName:"programName" min:"1" type:"string"`
}

// String returns the string representation
func (s MultiplexProgramChannelDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgramChannelDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexProgramChannelDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexProgramChannelDestinationSettings"}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *MultiplexProgramChannelDestinationSettings) SetMultiplexId(v string) *MultiplexProgramChannelDestinationSettings {
	s.MultiplexId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *MultiplexProgramChannelDestinationSettings) SetProgramName(v string) *MultiplexProgramChannelDestinationSettings {
	s.ProgramName = &v
	return s
}

// Packet identifiers map for a given Multiplex program.
type MultiplexProgramPacketIdentifiersMap struct {
	_ struct{} `type:"structure"`

	AudioPids []*int64 `locationName:"audioPids" type:"list"`

	DvbSubPids []*int64 `locationName:"dvbSubPids" type:"list"`

	DvbTeletextPid *int64 `locationName:"dvbTeletextPid" type:"integer"`

	EtvPlatformPid *int64 `locationName:"etvPlatformPid" type:"integer"`

	EtvSignalPid *int64 `locationName:"etvSignalPid" type:"integer"`

	KlvDataPids []*int64 `locationName:"klvDataPids" type:"list"`

	PcrPid *int64 `locationName:"pcrPid" type:"integer"`

	PmtPid *int64 `locationName:"pmtPid" type:"integer"`

	PrivateMetadataPid *int64 `locationName:"privateMetadataPid" type:"integer"`

	Scte27Pids []*int64 `locationName:"scte27Pids" type:"list"`

	Scte35Pid *int64 `locationName:"scte35Pid" type:"integer"`

	TimedMetadataPid *int64 `locationName:"timedMetadataPid" type:"integer"`

	VideoPid *int64 `locationName:"videoPid" type:"integer"`
}

// String returns the string representation
func (s MultiplexProgramPacketIdentifiersMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgramPacketIdentifiersMap) GoString() string {
	return s.String()
}

// SetAudioPids sets the AudioPids field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetAudioPids(v []*int64) *MultiplexProgramPacketIdentifiersMap {
	s.AudioPids = v
	return s
}

// SetDvbSubPids sets the DvbSubPids field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetDvbSubPids(v []*int64) *MultiplexProgramPacketIdentifiersMap {
	s.DvbSubPids = v
	return s
}

// SetDvbTeletextPid sets the DvbTeletextPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetDvbTeletextPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.DvbTeletextPid = &v
	return s
}

// SetEtvPlatformPid sets the EtvPlatformPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetEtvPlatformPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.EtvPlatformPid = &v
	return s
}

// SetEtvSignalPid sets the EtvSignalPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetEtvSignalPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.EtvSignalPid = &v
	return s
}

// SetKlvDataPids sets the KlvDataPids field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetKlvDataPids(v []*int64) *MultiplexProgramPacketIdentifiersMap {
	s.KlvDataPids = v
	return s
}

// SetPcrPid sets the PcrPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetPcrPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.PcrPid = &v
	return s
}

// SetPmtPid sets the PmtPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetPmtPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.PmtPid = &v
	return s
}

// SetPrivateMetadataPid sets the PrivateMetadataPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetPrivateMetadataPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.PrivateMetadataPid = &v
	return s
}

// SetScte27Pids sets the Scte27Pids field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetScte27Pids(v []*int64) *MultiplexProgramPacketIdentifiersMap {
	s.Scte27Pids = v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetScte35Pid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.Scte35Pid = &v
	return s
}

// SetTimedMetadataPid sets the TimedMetadataPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetTimedMetadataPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.TimedMetadataPid = &v
	return s
}

// SetVideoPid sets the VideoPid field's value.
func (s *MultiplexProgramPacketIdentifiersMap) SetVideoPid(v int64) *MultiplexProgramPacketIdentifiersMap {
	s.VideoPid = &v
	return s
}

// Transport stream service descriptor configuration for the Multiplex program.
type MultiplexProgramServiceDescriptor struct {
	_ struct{} `type:"structure"`

	// Name of the provider.
	//
	// ProviderName is a required field
	ProviderName *string `locationName:"providerName" type:"string" required:"true"`

	// Name of the service.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true"`
}

// String returns the string representation
func (s MultiplexProgramServiceDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgramServiceDescriptor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexProgramServiceDescriptor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexProgramServiceDescriptor"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderName sets the ProviderName field's value.
func (s *MultiplexProgramServiceDescriptor) SetProviderName(v string) *MultiplexProgramServiceDescriptor {
	s.ProviderName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *MultiplexProgramServiceDescriptor) SetServiceName(v string) *MultiplexProgramServiceDescriptor {
	s.ServiceName = &v
	return s
}

// Multiplex Program settings configuration.
type MultiplexProgramSettings struct {
	_ struct{} `type:"structure"`

	// Indicates which pipeline is preferred by the multiplex for program ingest.
	PreferredChannelPipeline *string `locationName:"preferredChannelPipeline" type:"string" enum:"PreferredChannelPipeline"`

	// Unique program number.
	//
	// ProgramNumber is a required field
	ProgramNumber *int64 `locationName:"programNumber" type:"integer" required:"true"`

	// Transport stream service descriptor configuration for the Multiplex program.
	ServiceDescriptor *MultiplexProgramServiceDescriptor `locationName:"serviceDescriptor" type:"structure"`

	// Program video settings configuration.
	VideoSettings *MultiplexVideoSettings `locationName:"videoSettings" type:"structure"`
}

// String returns the string representation
func (s MultiplexProgramSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgramSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexProgramSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexProgramSettings"}
	if s.ProgramNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramNumber"))
	}
	if s.ServiceDescriptor != nil {
		if err := s.ServiceDescriptor.Validate(); err != nil {
			invalidParams.AddNested("ServiceDescriptor", err.(request.ErrInvalidParams))
		}
	}
	if s.VideoSettings != nil {
		if err := s.VideoSettings.Validate(); err != nil {
			invalidParams.AddNested("VideoSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPreferredChannelPipeline sets the PreferredChannelPipeline field's value.
func (s *MultiplexProgramSettings) SetPreferredChannelPipeline(v string) *MultiplexProgramSettings {
	s.PreferredChannelPipeline = &v
	return s
}

// SetProgramNumber sets the ProgramNumber field's value.
func (s *MultiplexProgramSettings) SetProgramNumber(v int64) *MultiplexProgramSettings {
	s.ProgramNumber = &v
	return s
}

// SetServiceDescriptor sets the ServiceDescriptor field's value.
func (s *MultiplexProgramSettings) SetServiceDescriptor(v *MultiplexProgramServiceDescriptor) *MultiplexProgramSettings {
	s.ServiceDescriptor = v
	return s
}

// SetVideoSettings sets the VideoSettings field's value.
func (s *MultiplexProgramSettings) SetVideoSettings(v *MultiplexVideoSettings) *MultiplexProgramSettings {
	s.VideoSettings = v
	return s
}

type MultiplexProgramSummary struct {
	_ struct{} `type:"structure"`

	// The MediaLive Channel associated with the program.
	ChannelId *string `locationName:"channelId" type:"string"`

	// The name of the multiplex program.
	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation
func (s MultiplexProgramSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexProgramSummary) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *MultiplexProgramSummary) SetChannelId(v string) *MultiplexProgramSummary {
	s.ChannelId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *MultiplexProgramSummary) SetProgramName(v string) *MultiplexProgramSummary {
	s.ProgramName = &v
	return s
}

// Contains configuration for a Multiplex event
type MultiplexSettings struct {
	_ struct{} `type:"structure"`

	// Maximum video buffer delay in milliseconds.
	MaximumVideoBufferDelayMilliseconds *int64 `locationName:"maximumVideoBufferDelayMilliseconds" min:"1000" type:"integer"`

	// Transport stream bit rate.
	//
	// TransportStreamBitrate is a required field
	TransportStreamBitrate *int64 `locationName:"transportStreamBitrate" min:"1e+06" type:"integer" required:"true"`

	// Transport stream ID.
	//
	// TransportStreamId is a required field
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer" required:"true"`

	// Transport stream reserved bit rate.
	TransportStreamReservedBitrate *int64 `locationName:"transportStreamReservedBitrate" type:"integer"`
}

// String returns the string representation
func (s MultiplexSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexSettings"}
	if s.MaximumVideoBufferDelayMilliseconds != nil && *s.MaximumVideoBufferDelayMilliseconds < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumVideoBufferDelayMilliseconds", 1000))
	}
	if s.TransportStreamBitrate == nil {
		invalidParams.Add(request.NewErrParamRequired("TransportStreamBitrate"))
	}
	if s.TransportStreamBitrate != nil && *s.TransportStreamBitrate < 1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("TransportStreamBitrate", 1e+06))
	}
	if s.TransportStreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransportStreamId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumVideoBufferDelayMilliseconds sets the MaximumVideoBufferDelayMilliseconds field's value.
func (s *MultiplexSettings) SetMaximumVideoBufferDelayMilliseconds(v int64) *MultiplexSettings {
	s.MaximumVideoBufferDelayMilliseconds = &v
	return s
}

// SetTransportStreamBitrate sets the TransportStreamBitrate field's value.
func (s *MultiplexSettings) SetTransportStreamBitrate(v int64) *MultiplexSettings {
	s.TransportStreamBitrate = &v
	return s
}

// SetTransportStreamId sets the TransportStreamId field's value.
func (s *MultiplexSettings) SetTransportStreamId(v int64) *MultiplexSettings {
	s.TransportStreamId = &v
	return s
}

// SetTransportStreamReservedBitrate sets the TransportStreamReservedBitrate field's value.
func (s *MultiplexSettings) SetTransportStreamReservedBitrate(v int64) *MultiplexSettings {
	s.TransportStreamReservedBitrate = &v
	return s
}

// Contains summary configuration for a Multiplex event.
type MultiplexSettingsSummary struct {
	_ struct{} `type:"structure"`

	// Transport stream bit rate.
	TransportStreamBitrate *int64 `locationName:"transportStreamBitrate" min:"1e+06" type:"integer"`
}

// String returns the string representation
func (s MultiplexSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexSettingsSummary) GoString() string {
	return s.String()
}

// SetTransportStreamBitrate sets the TransportStreamBitrate field's value.
func (s *MultiplexSettingsSummary) SetTransportStreamBitrate(v int64) *MultiplexSettingsSummary {
	s.TransportStreamBitrate = &v
	return s
}

// Statmux rate control settings
type MultiplexStatmuxVideoSettings struct {
	_ struct{} `type:"structure"`

	// Maximum statmux bitrate.
	MaximumBitrate *int64 `locationName:"maximumBitrate" min:"100000" type:"integer"`

	// Minimum statmux bitrate.
	MinimumBitrate *int64 `locationName:"minimumBitrate" min:"100000" type:"integer"`
}

// String returns the string representation
func (s MultiplexStatmuxVideoSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexStatmuxVideoSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexStatmuxVideoSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexStatmuxVideoSettings"}
	if s.MaximumBitrate != nil && *s.MaximumBitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumBitrate", 100000))
	}
	if s.MinimumBitrate != nil && *s.MinimumBitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumBitrate", 100000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *MultiplexStatmuxVideoSettings) SetMaximumBitrate(v int64) *MultiplexStatmuxVideoSettings {
	s.MaximumBitrate = &v
	return s
}

// SetMinimumBitrate sets the MinimumBitrate field's value.
func (s *MultiplexStatmuxVideoSettings) SetMinimumBitrate(v int64) *MultiplexStatmuxVideoSettings {
	s.MinimumBitrate = &v
	return s
}

type MultiplexSummary struct {
	_ struct{} `type:"structure"`

	// The unique arn of the multiplex.
	Arn *string `locationName:"arn" type:"string"`

	// A list of availability zones for the multiplex.
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	// The unique id of the multiplex.
	Id *string `locationName:"id" type:"string"`

	// Configuration for a multiplex event.
	MultiplexSettings *MultiplexSettingsSummary `locationName:"multiplexSettings" type:"structure"`

	// The name of the multiplex.
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The number of programs in the multiplex.
	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s MultiplexSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MultiplexSummary) SetArn(v string) *MultiplexSummary {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *MultiplexSummary) SetAvailabilityZones(v []*string) *MultiplexSummary {
	s.AvailabilityZones = v
	return s
}

// SetId sets the Id field's value.
func (s *MultiplexSummary) SetId(v string) *MultiplexSummary {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *MultiplexSummary) SetMultiplexSettings(v *MultiplexSettingsSummary) *MultiplexSummary {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *MultiplexSummary) SetName(v string) *MultiplexSummary {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *MultiplexSummary) SetPipelinesRunningCount(v int64) *MultiplexSummary {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *MultiplexSummary) SetProgramCount(v int64) *MultiplexSummary {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *MultiplexSummary) SetState(v string) *MultiplexSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MultiplexSummary) SetTags(v map[string]*string) *MultiplexSummary {
	s.Tags = v
	return s
}

// The video configuration for each program in a multiplex.
type MultiplexVideoSettings struct {
	_ struct{} `type:"structure"`

	// The constant bitrate configuration for the video encode.When this field is
	// defined, StatmuxSettings must be undefined.
	ConstantBitrate *int64 `locationName:"constantBitrate" min:"100000" type:"integer"`

	// Statmux rate control settings.When this field is defined, ConstantBitrate
	// must be undefined.
	StatmuxSettings *MultiplexStatmuxVideoSettings `locationName:"statmuxSettings" type:"structure"`
}

// String returns the string representation
func (s MultiplexVideoSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiplexVideoSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiplexVideoSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiplexVideoSettings"}
	if s.ConstantBitrate != nil && *s.ConstantBitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("ConstantBitrate", 100000))
	}
	if s.StatmuxSettings != nil {
		if err := s.StatmuxSettings.Validate(); err != nil {
			invalidParams.AddNested("StatmuxSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstantBitrate sets the ConstantBitrate field's value.
func (s *MultiplexVideoSettings) SetConstantBitrate(v int64) *MultiplexVideoSettings {
	s.ConstantBitrate = &v
	return s
}

// SetStatmuxSettings sets the StatmuxSettings field's value.
func (s *MultiplexVideoSettings) SetStatmuxSettings(v *MultiplexStatmuxVideoSettings) *MultiplexVideoSettings {
	s.StatmuxSettings = v
	return s
}

// Network source to transcode. Must be accessible to the Elemental Live node
// that is running the live event through a network connection.
type NetworkInputSettings struct {
	_ struct{} `type:"structure"`

	// Specifies HLS input settings when the uri is for a HLS manifest.
	HlsInputSettings *HlsInputSettings `locationName:"hlsInputSettings" type:"structure"`

	// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography
	// in the certificate will be checked, but not the server's name. Certain subdomains
	// (notably S3 buckets that use dots in the bucket name) do not strictly match
	// the corresponding certificate's wildcard pattern and would otherwise cause
	// the event to error. This setting is ignored for protocols that do not use
	// https.
	ServerValidation *string `locationName:"serverValidation" type:"string" enum:"NetworkInputServerValidation"`
}

// String returns the string representation
func (s NetworkInputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInputSettings) GoString() string {
	return s.String()
}

// SetHlsInputSettings sets the HlsInputSettings field's value.
func (s *NetworkInputSettings) SetHlsInputSettings(v *HlsInputSettings) *NetworkInputSettings {
	s.HlsInputSettings = v
	return s
}

// SetServerValidation sets the ServerValidation field's value.
func (s *NetworkInputSettings) SetServerValidation(v string) *NetworkInputSettings {
	s.ServerValidation = &v
	return s
}

// Nielsen Configuration
type NielsenConfiguration struct {
	_ struct{} `type:"structure"`

	// Enter the Distributor ID assigned to your organization by Nielsen.
	DistributorId *string `locationName:"distributorId" type:"string"`

	// Enables Nielsen PCM to ID3 tagging
	NielsenPcmToId3Tagging *string `locationName:"nielsenPcmToId3Tagging" type:"string" enum:"NielsenPcmToId3TaggingState"`
}

// String returns the string representation
func (s NielsenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NielsenConfiguration) GoString() string {
	return s.String()
}

// SetDistributorId sets the DistributorId field's value.
func (s *NielsenConfiguration) SetDistributorId(v string) *NielsenConfiguration {
	s.DistributorId = &v
	return s
}

// SetNielsenPcmToId3Tagging sets the NielsenPcmToId3Tagging field's value.
func (s *NielsenConfiguration) SetNielsenPcmToId3Tagging(v string) *NielsenConfiguration {
	s.NielsenPcmToId3Tagging = &v
	return s
}

type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Reserved resources available for purchase
type Offering struct {
	_ struct{} `type:"structure"`

	// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
	Arn *string `locationName:"arn" type:"string"`

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// Lease duration, e.g. '12'
	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard
	// VQ in US West (Oregon)'
	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	// Unique offering ID, e.g. '87654321'
	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	// AWS region, e.g. 'us-west-2'
	Region *string `locationName:"region" type:"string"`

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Offering) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Offering) SetArn(v string) *Offering {
	s.Arn = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *Offering) SetCurrencyCode(v string) *Offering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Offering) SetDuration(v int64) *Offering {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *Offering) SetDurationUnits(v string) *Offering {
	s.DurationUnits = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *Offering) SetFixedPrice(v float64) *Offering {
	s.FixedPrice = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *Offering) SetOfferingDescription(v string) *Offering {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *Offering) SetOfferingId(v string) *Offering {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *Offering) SetOfferingType(v string) *Offering {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Offering) SetRegion(v string) *Offering {
	s.Region = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *Offering) SetResourceSpecification(v *ReservationResourceSpecification) *Offering {
	s.ResourceSpecification = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *Offering) SetUsagePrice(v float64) *Offering {
	s.UsagePrice = &v
	return s
}

// Output settings. There can be multiple outputs within a group.
type Output struct {
	_ struct{} `type:"structure"`

	// The names of the AudioDescriptions used as audio sources for this output.
	AudioDescriptionNames []*string `locationName:"audioDescriptionNames" type:"list"`

	// The names of the CaptionDescriptions used as caption sources for this output.
	CaptionDescriptionNames []*string `locationName:"captionDescriptionNames" type:"list"`

	// The name used to identify an output.
	OutputName *string `locationName:"outputName" min:"1" type:"string"`

	// Output type-specific settings.
	//
	// OutputSettings is a required field
	OutputSettings *OutputSettings `locationName:"outputSettings" type:"structure" required:"true"`

	// The name of the VideoDescription used as the source for this output.
	VideoDescriptionName *string `locationName:"videoDescriptionName" type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output"}
	if s.OutputName != nil && len(*s.OutputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputName", 1))
	}
	if s.OutputSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSettings"))
	}
	if s.OutputSettings != nil {
		if err := s.OutputSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDescriptionNames sets the AudioDescriptionNames field's value.
func (s *Output) SetAudioDescriptionNames(v []*string) *Output {
	s.AudioDescriptionNames = v
	return s
}

// SetCaptionDescriptionNames sets the CaptionDescriptionNames field's value.
func (s *Output) SetCaptionDescriptionNames(v []*string) *Output {
	s.CaptionDescriptionNames = v
	return s
}

// SetOutputName sets the OutputName field's value.
func (s *Output) SetOutputName(v string) *Output {
	s.OutputName = &v
	return s
}

// SetOutputSettings sets the OutputSettings field's value.
func (s *Output) SetOutputSettings(v *OutputSettings) *Output {
	s.OutputSettings = v
	return s
}

// SetVideoDescriptionName sets the VideoDescriptionName field's value.
func (s *Output) SetVideoDescriptionName(v string) *Output {
	s.VideoDescriptionName = &v
	return s
}

type OutputDestination struct {
	_ struct{} `type:"structure"`

	// User-specified id. This is used in an output group or an output.
	Id *string `locationName:"id" type:"string"`

	// Destination settings for a MediaPackage output; one destination for both
	// encoders.
	MediaPackageSettings []*MediaPackageOutputDestinationSettings `locationName:"mediaPackageSettings" type:"list"`

	// Destination settings for a Multiplex output; one destination for both encoders.
	MultiplexSettings *MultiplexProgramChannelDestinationSettings `locationName:"multiplexSettings" type:"structure"`

	// Destination settings for a standard output; one destination for each redundant
	// encoder.
	Settings []*OutputDestinationSettings `locationName:"settings" type:"list"`
}

// String returns the string representation
func (s OutputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDestination"}
	if s.MediaPackageSettings != nil {
		for i, v := range s.MediaPackageSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaPackageSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MultiplexSettings != nil {
		if err := s.MultiplexSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *OutputDestination) SetId(v string) *OutputDestination {
	s.Id = &v
	return s
}

// SetMediaPackageSettings sets the MediaPackageSettings field's value.
func (s *OutputDestination) SetMediaPackageSettings(v []*MediaPackageOutputDestinationSettings) *OutputDestination {
	s.MediaPackageSettings = v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *OutputDestination) SetMultiplexSettings(v *MultiplexProgramChannelDestinationSettings) *OutputDestination {
	s.MultiplexSettings = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *OutputDestination) SetSettings(v []*OutputDestinationSettings) *OutputDestination {
	s.Settings = v
	return s
}

type OutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Stream name for RTMP destinations (URLs of type rtmp://)
	StreamName *string `locationName:"streamName" type:"string"`

	// A URL specifying a destination
	Url *string `locationName:"url" type:"string"`

	// username for destination
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s OutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDestinationSettings) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *OutputDestinationSettings) SetPasswordParam(v string) *OutputDestinationSettings {
	s.PasswordParam = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *OutputDestinationSettings) SetStreamName(v string) *OutputDestinationSettings {
	s.StreamName = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *OutputDestinationSettings) SetUrl(v string) *OutputDestinationSettings {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *OutputDestinationSettings) SetUsername(v string) *OutputDestinationSettings {
	s.Username = &v
	return s
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
type OutputGroup struct {
	_ struct{} `type:"structure"`

	// Custom output group name optionally defined by the user. Only letters, numbers,
	// and the underscore character allowed; only 32 characters allowed.
	Name *string `locationName:"name" type:"string"`

	// Settings associated with the output group.
	//
	// OutputGroupSettings is a required field
	OutputGroupSettings *OutputGroupSettings `locationName:"outputGroupSettings" type:"structure" required:"true"`

	// Outputs is a required field
	Outputs []*Output `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation
func (s OutputGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputGroup"}
	if s.OutputGroupSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputGroupSettings"))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.OutputGroupSettings != nil {
		if err := s.OutputGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OutputGroup) SetName(v string) *OutputGroup {
	s.Name = &v
	return s
}

// SetOutputGroupSettings sets the OutputGroupSettings field's value.
func (s *OutputGroup) SetOutputGroupSettings(v *OutputGroupSettings) *OutputGroup {
	s.OutputGroupSettings = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *OutputGroup) SetOutputs(v []*Output) *OutputGroup {
	s.Outputs = v
	return s
}

// Output Group Settings
type OutputGroupSettings struct {
	_ struct{} `type:"structure"`

	// Archive Group Settings
	ArchiveGroupSettings *ArchiveGroupSettings `locationName:"archiveGroupSettings" type:"structure"`

	// Frame Capture Group Settings
	FrameCaptureGroupSettings *FrameCaptureGroupSettings `locationName:"frameCaptureGroupSettings" type:"structure"`

	// Hls Group Settings
	HlsGroupSettings *HlsGroupSettings `locationName:"hlsGroupSettings" type:"structure"`

	// Media Package Group Settings
	MediaPackageGroupSettings *MediaPackageGroupSettings `locationName:"mediaPackageGroupSettings" type:"structure"`

	// Ms Smooth Group Settings
	MsSmoothGroupSettings *MsSmoothGroupSettings `locationName:"msSmoothGroupSettings" type:"structure"`

	// Multiplex Group Settings
	MultiplexGroupSettings *MultiplexGroupSettings `locationName:"multiplexGroupSettings" type:"structure"`

	// Rtmp Group Settings
	RtmpGroupSettings *RtmpGroupSettings `locationName:"rtmpGroupSettings" type:"structure"`

	// Udp Group Settings
	UdpGroupSettings *UdpGroupSettings `locationName:"udpGroupSettings" type:"structure"`
}

// String returns the string representation
func (s OutputGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputGroupSettings"}
	if s.ArchiveGroupSettings != nil {
		if err := s.ArchiveGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.FrameCaptureGroupSettings != nil {
		if err := s.FrameCaptureGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("FrameCaptureGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsGroupSettings != nil {
		if err := s.HlsGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.MediaPackageGroupSettings != nil {
		if err := s.MediaPackageGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("MediaPackageGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.MsSmoothGroupSettings != nil {
		if err := s.MsSmoothGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("MsSmoothGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RtmpGroupSettings != nil {
		if err := s.RtmpGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpGroupSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveGroupSettings sets the ArchiveGroupSettings field's value.
func (s *OutputGroupSettings) SetArchiveGroupSettings(v *ArchiveGroupSettings) *OutputGroupSettings {
	s.ArchiveGroupSettings = v
	return s
}

// SetFrameCaptureGroupSettings sets the FrameCaptureGroupSettings field's value.
func (s *OutputGroupSettings) SetFrameCaptureGroupSettings(v *FrameCaptureGroupSettings) *OutputGroupSettings {
	s.FrameCaptureGroupSettings = v
	return s
}

// SetHlsGroupSettings sets the HlsGroupSettings field's value.
func (s *OutputGroupSettings) SetHlsGroupSettings(v *HlsGroupSettings) *OutputGroupSettings {
	s.HlsGroupSettings = v
	return s
}

// SetMediaPackageGroupSettings sets the MediaPackageGroupSettings field's value.
func (s *OutputGroupSettings) SetMediaPackageGroupSettings(v *MediaPackageGroupSettings) *OutputGroupSettings {
	s.MediaPackageGroupSettings = v
	return s
}

// SetMsSmoothGroupSettings sets the MsSmoothGroupSettings field's value.
func (s *OutputGroupSettings) SetMsSmoothGroupSettings(v *MsSmoothGroupSettings) *OutputGroupSettings {
	s.MsSmoothGroupSettings = v
	return s
}

// SetMultiplexGroupSettings sets the MultiplexGroupSettings field's value.
func (s *OutputGroupSettings) SetMultiplexGroupSettings(v *MultiplexGroupSettings) *OutputGroupSettings {
	s.MultiplexGroupSettings = v
	return s
}

// SetRtmpGroupSettings sets the RtmpGroupSettings field's value.
func (s *OutputGroupSettings) SetRtmpGroupSettings(v *RtmpGroupSettings) *OutputGroupSettings {
	s.RtmpGroupSettings = v
	return s
}

// SetUdpGroupSettings sets the UdpGroupSettings field's value.
func (s *OutputGroupSettings) SetUdpGroupSettings(v *UdpGroupSettings) *OutputGroupSettings {
	s.UdpGroupSettings = v
	return s
}

// Reference to an OutputDestination ID defined in the channel
type OutputLocationRef struct {
	_ struct{} `type:"structure"`

	DestinationRefId *string `locationName:"destinationRefId" type:"string"`
}

// String returns the string representation
func (s OutputLocationRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocationRef) GoString() string {
	return s.String()
}

// SetDestinationRefId sets the DestinationRefId field's value.
func (s *OutputLocationRef) SetDestinationRefId(v string) *OutputLocationRef {
	s.DestinationRefId = &v
	return s
}

// Output Settings
type OutputSettings struct {
	_ struct{} `type:"structure"`

	// Archive Output Settings
	ArchiveOutputSettings *ArchiveOutputSettings `locationName:"archiveOutputSettings" type:"structure"`

	// Frame Capture Output Settings
	FrameCaptureOutputSettings *FrameCaptureOutputSettings `locationName:"frameCaptureOutputSettings" type:"structure"`

	// Hls Output Settings
	HlsOutputSettings *HlsOutputSettings `locationName:"hlsOutputSettings" type:"structure"`

	// Media Package Output Settings
	MediaPackageOutputSettings *MediaPackageOutputSettings `locationName:"mediaPackageOutputSettings" type:"structure"`

	// Ms Smooth Output Settings
	MsSmoothOutputSettings *MsSmoothOutputSettings `locationName:"msSmoothOutputSettings" type:"structure"`

	// Multiplex Output Settings
	MultiplexOutputSettings *MultiplexOutputSettings `locationName:"multiplexOutputSettings" type:"structure"`

	// Rtmp Output Settings
	RtmpOutputSettings *RtmpOutputSettings `locationName:"rtmpOutputSettings" type:"structure"`

	// Udp Output Settings
	UdpOutputSettings *UdpOutputSettings `locationName:"udpOutputSettings" type:"structure"`
}

// String returns the string representation
func (s OutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputSettings"}
	if s.ArchiveOutputSettings != nil {
		if err := s.ArchiveOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsOutputSettings != nil {
		if err := s.HlsOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.MultiplexOutputSettings != nil {
		if err := s.MultiplexOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RtmpOutputSettings != nil {
		if err := s.RtmpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.UdpOutputSettings != nil {
		if err := s.UdpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("UdpOutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveOutputSettings sets the ArchiveOutputSettings field's value.
func (s *OutputSettings) SetArchiveOutputSettings(v *ArchiveOutputSettings) *OutputSettings {
	s.ArchiveOutputSettings = v
	return s
}

// SetFrameCaptureOutputSettings sets the FrameCaptureOutputSettings field's value.
func (s *OutputSettings) SetFrameCaptureOutputSettings(v *FrameCaptureOutputSettings) *OutputSettings {
	s.FrameCaptureOutputSettings = v
	return s
}

// SetHlsOutputSettings sets the HlsOutputSettings field's value.
func (s *OutputSettings) SetHlsOutputSettings(v *HlsOutputSettings) *OutputSettings {
	s.HlsOutputSettings = v
	return s
}

// SetMediaPackageOutputSettings sets the MediaPackageOutputSettings field's value.
func (s *OutputSettings) SetMediaPackageOutputSettings(v *MediaPackageOutputSettings) *OutputSettings {
	s.MediaPackageOutputSettings = v
	return s
}

// SetMsSmoothOutputSettings sets the MsSmoothOutputSettings field's value.
func (s *OutputSettings) SetMsSmoothOutputSettings(v *MsSmoothOutputSettings) *OutputSettings {
	s.MsSmoothOutputSettings = v
	return s
}

// SetMultiplexOutputSettings sets the MultiplexOutputSettings field's value.
func (s *OutputSettings) SetMultiplexOutputSettings(v *MultiplexOutputSettings) *OutputSettings {
	s.MultiplexOutputSettings = v
	return s
}

// SetRtmpOutputSettings sets the RtmpOutputSettings field's value.
func (s *OutputSettings) SetRtmpOutputSettings(v *RtmpOutputSettings) *OutputSettings {
	s.RtmpOutputSettings = v
	return s
}

// SetUdpOutputSettings sets the UdpOutputSettings field's value.
func (s *OutputSettings) SetUdpOutputSettings(v *UdpOutputSettings) *OutputSettings {
	s.UdpOutputSettings = v
	return s
}

// Pass Through Settings
type PassThroughSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PassThroughSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PassThroughSettings) GoString() string {
	return s.String()
}

// Settings for the action to set pause state of a channel.
type PauseStateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	Pipelines []*PipelinePauseStateSettings `locationName:"pipelines" type:"list"`
}

// String returns the string representation
func (s PauseStateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PauseStateScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseStateScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PauseStateScheduleActionSettings"}
	if s.Pipelines != nil {
		for i, v := range s.Pipelines {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Pipelines", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelines sets the Pipelines field's value.
func (s *PauseStateScheduleActionSettings) SetPipelines(v []*PipelinePauseStateSettings) *PauseStateScheduleActionSettings {
	s.Pipelines = v
	return s
}

// Runtime details of a pipeline when a channel is running.
type PipelineDetail struct {
	_ struct{} `type:"structure"`

	// The name of the active input attachment currently being ingested by this
	// pipeline.
	ActiveInputAttachmentName *string `locationName:"activeInputAttachmentName" type:"string"`

	// The name of the input switch schedule action that occurred most recently
	// and that resulted in the switch to the current input attachment for this
	// pipeline.
	ActiveInputSwitchActionName *string `locationName:"activeInputSwitchActionName" type:"string"`

	// Pipeline ID
	PipelineId *string `locationName:"pipelineId" type:"string"`
}

// String returns the string representation
func (s PipelineDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineDetail) GoString() string {
	return s.String()
}

// SetActiveInputAttachmentName sets the ActiveInputAttachmentName field's value.
func (s *PipelineDetail) SetActiveInputAttachmentName(v string) *PipelineDetail {
	s.ActiveInputAttachmentName = &v
	return s
}

// SetActiveInputSwitchActionName sets the ActiveInputSwitchActionName field's value.
func (s *PipelineDetail) SetActiveInputSwitchActionName(v string) *PipelineDetail {
	s.ActiveInputSwitchActionName = &v
	return s
}

// SetPipelineId sets the PipelineId field's value.
func (s *PipelineDetail) SetPipelineId(v string) *PipelineDetail {
	s.PipelineId = &v
	return s
}

// Settings for pausing a pipeline.
type PipelinePauseStateSettings struct {
	_ struct{} `type:"structure"`

	// Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" type:"string" required:"true" enum:"PipelineId"`
}

// String returns the string representation
func (s PipelinePauseStateSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelinePauseStateSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelinePauseStateSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelinePauseStateSettings"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineId sets the PipelineId field's value.
func (s *PipelinePauseStateSettings) SetPipelineId(v string) *PipelinePauseStateSettings {
	s.PipelineId = &v
	return s
}

type PurchaseOfferingInput struct {
	_ struct{} `type:"structure"`

	// Count is a required field
	Count *int64 `locationName:"count" min:"1" type:"integer" required:"true"`

	Name *string `locationName:"name" type:"string"`

	// OfferingId is a required field
	OfferingId *string `location:"uri" locationName:"offeringId" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Start *string `locationName:"start" type:"string"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s PurchaseOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseOfferingInput"}
	if s.Count == nil {
		invalidParams.Add(request.NewErrParamRequired("Count"))
	}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}
	if s.OfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingId"))
	}
	if s.OfferingId != nil && len(*s.OfferingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *PurchaseOfferingInput) SetCount(v int64) *PurchaseOfferingInput {
	s.Count = &v
	return s
}

// SetName sets the Name field's value.
func (s *PurchaseOfferingInput) SetName(v string) *PurchaseOfferingInput {
	s.Name = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *PurchaseOfferingInput) SetOfferingId(v string) *PurchaseOfferingInput {
	s.OfferingId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PurchaseOfferingInput) SetRequestId(v string) *PurchaseOfferingInput {
	s.RequestId = &v
	return s
}

// SetStart sets the Start field's value.
func (s *PurchaseOfferingInput) SetStart(v string) *PurchaseOfferingInput {
	s.Start = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PurchaseOfferingInput) SetTags(v map[string]*string) *PurchaseOfferingInput {
	s.Tags = v
	return s
}

type PurchaseOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Reserved resources available to use
	Reservation *Reservation `locationName:"reservation" type:"structure"`
}

// String returns the string representation
func (s PurchaseOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseOfferingOutput) GoString() string {
	return s.String()
}

// SetReservation sets the Reservation field's value.
func (s *PurchaseOfferingOutput) SetReservation(v *Reservation) *PurchaseOfferingOutput {
	s.Reservation = v
	return s
}

// Rec601 Settings
type Rec601Settings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Rec601Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rec601Settings) GoString() string {
	return s.String()
}

// Rec709 Settings
type Rec709Settings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Rec709Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rec709Settings) GoString() string {
	return s.String()
}

// Remix Settings
type RemixSettings struct {
	_ struct{} `type:"structure"`

	// Mapping of input channels to output channels, with appropriate gain adjustments.
	//
	// ChannelMappings is a required field
	ChannelMappings []*AudioChannelMapping `locationName:"channelMappings" type:"list" required:"true"`

	// Number of input channels to be used.
	ChannelsIn *int64 `locationName:"channelsIn" min:"1" type:"integer"`

	// Number of output channels to be produced.Valid values: 1, 2, 4, 6, 8
	ChannelsOut *int64 `locationName:"channelsOut" min:"1" type:"integer"`
}

// String returns the string representation
func (s RemixSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemixSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemixSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemixSettings"}
	if s.ChannelMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelMappings"))
	}
	if s.ChannelsIn != nil && *s.ChannelsIn < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ChannelsIn", 1))
	}
	if s.ChannelsOut != nil && *s.ChannelsOut < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ChannelsOut", 1))
	}
	if s.ChannelMappings != nil {
		for i, v := range s.ChannelMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChannelMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelMappings sets the ChannelMappings field's value.
func (s *RemixSettings) SetChannelMappings(v []*AudioChannelMapping) *RemixSettings {
	s.ChannelMappings = v
	return s
}

// SetChannelsIn sets the ChannelsIn field's value.
func (s *RemixSettings) SetChannelsIn(v int64) *RemixSettings {
	s.ChannelsIn = &v
	return s
}

// SetChannelsOut sets the ChannelsOut field's value.
func (s *RemixSettings) SetChannelsOut(v int64) *RemixSettings {
	s.ChannelsOut = &v
	return s
}

// Reserved resources available to use
type Reservation struct {
	_ struct{} `type:"structure"`

	// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
	Arn *string `locationName:"arn" type:"string"`

	// Number of reserved resources
	Count *int64 `locationName:"count" type:"integer"`

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// Lease duration, e.g. '12'
	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
	End *string `locationName:"end" type:"string"`

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	// User specified reservation name
	Name *string `locationName:"name" type:"string"`

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard
	// VQ in US West (Oregon)'
	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	// Unique offering ID, e.g. '87654321'
	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	// AWS region, e.g. 'us-west-2'
	Region *string `locationName:"region" type:"string"`

	// Unique reservation ID, e.g. '1234567'
	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
	Start *string `locationName:"start" type:"string"`

	// Current state of reservation, e.g. 'ACTIVE'
	State *string `locationName:"state" type:"string" enum:"ReservationState"`

	// A collection of key-value pairs
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s Reservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Reservation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Reservation) SetArn(v string) *Reservation {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Reservation) SetCount(v int64) *Reservation {
	s.Count = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *Reservation) SetCurrencyCode(v string) *Reservation {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Reservation) SetDuration(v int64) *Reservation {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *Reservation) SetDurationUnits(v string) *Reservation {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *Reservation) SetEnd(v string) *Reservation {
	s.End = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *Reservation) SetFixedPrice(v float64) *Reservation {
	s.FixedPrice = &v
	return s
}

// SetName sets the Name field's value.
func (s *Reservation) SetName(v string) *Reservation {
	s.Name = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *Reservation) SetOfferingDescription(v string) *Reservation {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *Reservation) SetOfferingId(v string) *Reservation {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *Reservation) SetOfferingType(v string) *Reservation {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Reservation) SetRegion(v string) *Reservation {
	s.Region = &v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *Reservation) SetReservationId(v string) *Reservation {
	s.ReservationId = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *Reservation) SetResourceSpecification(v *ReservationResourceSpecification) *Reservation {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *Reservation) SetStart(v string) *Reservation {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *Reservation) SetState(v string) *Reservation {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Reservation) SetTags(v map[string]*string) *Reservation {
	s.Tags = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *Reservation) SetUsagePrice(v float64) *Reservation {
	s.UsagePrice = &v
	return s
}

// Resource configuration (codec, resolution, bitrate, ...)
type ReservationResourceSpecification struct {
	_ struct{} `type:"structure"`

	// Channel class, e.g. 'STANDARD'
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	// Codec, e.g. 'AVC'
	Codec *string `locationName:"codec" type:"string" enum:"ReservationCodec"`

	// Maximum bitrate, e.g. 'MAX_20_MBPS'
	MaximumBitrate *string `locationName:"maximumBitrate" type:"string" enum:"ReservationMaximumBitrate"`

	// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
	MaximumFramerate *string `locationName:"maximumFramerate" type:"string" enum:"ReservationMaximumFramerate"`

	// Resolution, e.g. 'HD'
	Resolution *string `locationName:"resolution" type:"string" enum:"ReservationResolution"`

	// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ReservationResourceType"`

	// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
	SpecialFeature *string `locationName:"specialFeature" type:"string" enum:"ReservationSpecialFeature"`

	// Video quality, e.g. 'STANDARD' (Outputs only)
	VideoQuality *string `locationName:"videoQuality" type:"string" enum:"ReservationVideoQuality"`
}

// String returns the string representation
func (s ReservationResourceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationResourceSpecification) GoString() string {
	return s.String()
}

// SetChannelClass sets the ChannelClass field's value.
func (s *ReservationResourceSpecification) SetChannelClass(v string) *ReservationResourceSpecification {
	s.ChannelClass = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *ReservationResourceSpecification) SetCodec(v string) *ReservationResourceSpecification {
	s.Codec = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *ReservationResourceSpecification) SetMaximumBitrate(v string) *ReservationResourceSpecification {
	s.MaximumBitrate = &v
	return s
}

// SetMaximumFramerate sets the MaximumFramerate field's value.
func (s *ReservationResourceSpecification) SetMaximumFramerate(v string) *ReservationResourceSpecification {
	s.MaximumFramerate = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *ReservationResourceSpecification) SetResolution(v string) *ReservationResourceSpecification {
	s.Resolution = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ReservationResourceSpecification) SetResourceType(v string) *ReservationResourceSpecification {
	s.ResourceType = &v
	return s
}

// SetSpecialFeature sets the SpecialFeature field's value.
func (s *ReservationResourceSpecification) SetSpecialFeature(v string) *ReservationResourceSpecification {
	s.SpecialFeature = &v
	return s
}

// SetVideoQuality sets the VideoQuality field's value.
func (s *ReservationResourceSpecification) SetVideoQuality(v string) *ReservationResourceSpecification {
	s.VideoQuality = &v
	return s
}

// Rtmp Caption Info Destination Settings
type RtmpCaptionInfoDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RtmpCaptionInfoDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpCaptionInfoDestinationSettings) GoString() string {
	return s.String()
}

// Rtmp Group Settings
type RtmpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Authentication scheme to use when connecting with CDN
	AuthenticationScheme *string `locationName:"authenticationScheme" type:"string" enum:"AuthenticationScheme"`

	// Controls behavior when content cache fills up. If remote origin server stalls
	// the RTMP connection and does not accept content fast enough the 'Media Cache'
	// will fill up. When the cache reaches the duration specified by cacheLength
	// the cache will stop accepting new content. If set to disconnectImmediately,
	// the RTMP output will force a disconnect. Clear the media cache, and reconnect
	// after restartDelay seconds. If set to waitForServer, the RTMP output will
	// wait up to 5 minutes to allow the origin server to begin accepting data again.
	CacheFullBehavior *string `locationName:"cacheFullBehavior" type:"string" enum:"RtmpCacheFullBehavior"`

	// Cache length, in seconds, is used to calculate buffer size.
	CacheLength *int64 `locationName:"cacheLength" min:"30" type:"integer"`

	// Controls the types of data that passes to onCaptionInfo outputs. If set to
	// 'all' then 608 and 708 carried DTVCC data will be passed. If set to 'field1AndField2608'
	// then DTVCC data will be stripped out, but 608 data from both fields will
	// be passed. If set to 'field1608' then only the data carried in 608 from field
	// 1 video will be passed.
	CaptionData *string `locationName:"captionData" type:"string" enum:"RtmpCaptionData"`

	// Controls the behavior of this RTMP group if input becomes unavailable.- emitOutput:
	// Emit a slate until input returns.- pauseOutput: Stop transmitting data until
	// input returns. This does not close the underlying RTMP connection.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForRtmpOut"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s RtmpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RtmpGroupSettings"}
	if s.CacheLength != nil && *s.CacheLength < 30 {
		invalidParams.Add(request.NewErrParamMinValue("CacheLength", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationScheme sets the AuthenticationScheme field's value.
func (s *RtmpGroupSettings) SetAuthenticationScheme(v string) *RtmpGroupSettings {
	s.AuthenticationScheme = &v
	return s
}

// SetCacheFullBehavior sets the CacheFullBehavior field's value.
func (s *RtmpGroupSettings) SetCacheFullBehavior(v string) *RtmpGroupSettings {
	s.CacheFullBehavior = &v
	return s
}

// SetCacheLength sets the CacheLength field's value.
func (s *RtmpGroupSettings) SetCacheLength(v int64) *RtmpGroupSettings {
	s.CacheLength = &v
	return s
}

// SetCaptionData sets the CaptionData field's value.
func (s *RtmpGroupSettings) SetCaptionData(v string) *RtmpGroupSettings {
	s.CaptionData = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *RtmpGroupSettings) SetInputLossAction(v string) *RtmpGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *RtmpGroupSettings) SetRestartDelay(v int64) *RtmpGroupSettings {
	s.RestartDelay = &v
	return s
}

// Rtmp Output Settings
type RtmpOutputSettings struct {
	_ struct{} `type:"structure"`

	// If set to verifyAuthenticity, verify the tls certificate chain to a trusted
	// Certificate Authority (CA). This will cause rtmps outputs with self-signed
	// certificates to fail.
	CertificateMode *string `locationName:"certificateMode" type:"string" enum:"RtmpOutputCertificateMode"`

	// Number of seconds to wait before retrying a connection to the Flash Media
	// server if the connection is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" min:"1" type:"integer"`

	// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For
	// connection to Akamai, a username and password must be supplied. URI fields
	// accept format identifiers.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`
}

// String returns the string representation
func (s RtmpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RtmpOutputSettings"}
	if s.ConnectionRetryInterval != nil && *s.ConnectionRetryInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConnectionRetryInterval", 1))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateMode sets the CertificateMode field's value.
func (s *RtmpOutputSettings) SetCertificateMode(v string) *RtmpOutputSettings {
	s.CertificateMode = &v
	return s
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *RtmpOutputSettings) SetConnectionRetryInterval(v int64) *RtmpOutputSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *RtmpOutputSettings) SetDestination(v *OutputLocationRef) *RtmpOutputSettings {
	s.Destination = v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *RtmpOutputSettings) SetNumRetries(v int64) *RtmpOutputSettings {
	s.NumRetries = &v
	return s
}

// Contains information on a single schedule action.
type ScheduleAction struct {
	_ struct{} `type:"structure"`

	// The name of the action, must be unique within the schedule. This name provides
	// the main reference to an action once it is added to the schedule. A name
	// is unique if it is no longer in the schedule. The schedule is automatically
	// cleaned up to remove actions with a start time of more than 1 hour ago (approximately)
	// so at that point a name can be reused.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" type:"string" required:"true"`

	// Settings for this schedule action.
	//
	// ScheduleActionSettings is a required field
	ScheduleActionSettings *ScheduleActionSettings `locationName:"scheduleActionSettings" type:"structure" required:"true"`

	// The time for the action to start in the channel.
	//
	// ScheduleActionStartSettings is a required field
	ScheduleActionStartSettings *ScheduleActionStartSettings `locationName:"scheduleActionStartSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s ScheduleAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleAction"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ScheduleActionSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleActionSettings"))
	}
	if s.ScheduleActionStartSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleActionStartSettings"))
	}
	if s.ScheduleActionSettings != nil {
		if err := s.ScheduleActionSettings.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActionSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.ScheduleActionStartSettings != nil {
		if err := s.ScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActionStartSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *ScheduleAction) SetActionName(v string) *ScheduleAction {
	s.ActionName = &v
	return s
}

// SetScheduleActionSettings sets the ScheduleActionSettings field's value.
func (s *ScheduleAction) SetScheduleActionSettings(v *ScheduleActionSettings) *ScheduleAction {
	s.ScheduleActionSettings = v
	return s
}

// SetScheduleActionStartSettings sets the ScheduleActionStartSettings field's value.
func (s *ScheduleAction) SetScheduleActionStartSettings(v *ScheduleActionStartSettings) *ScheduleAction {
	s.ScheduleActionStartSettings = v
	return s
}

// Holds the settings for a single schedule action.
type ScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Action to insert HLS ID3 segment tagging
	HlsId3SegmentTaggingSettings *HlsId3SegmentTaggingScheduleActionSettings `locationName:"hlsId3SegmentTaggingSettings" type:"structure"`

	// Action to insert HLS metadata
	HlsTimedMetadataSettings *HlsTimedMetadataScheduleActionSettings `locationName:"hlsTimedMetadataSettings" type:"structure"`

	// Action to prepare an input for a future immediate input switch
	InputPrepareSettings *InputPrepareScheduleActionSettings `locationName:"inputPrepareSettings" type:"structure"`

	// Action to switch the input
	InputSwitchSettings *InputSwitchScheduleActionSettings `locationName:"inputSwitchSettings" type:"structure"`

	// Action to pause or unpause one or both channel pipelines
	PauseStateSettings *PauseStateScheduleActionSettings `locationName:"pauseStateSettings" type:"structure"`

	// Action to insert SCTE-35 return_to_network message
	Scte35ReturnToNetworkSettings *Scte35ReturnToNetworkScheduleActionSettings `locationName:"scte35ReturnToNetworkSettings" type:"structure"`

	// Action to insert SCTE-35 splice_insert message
	Scte35SpliceInsertSettings *Scte35SpliceInsertScheduleActionSettings `locationName:"scte35SpliceInsertSettings" type:"structure"`

	// Action to insert SCTE-35 time_signal message
	Scte35TimeSignalSettings *Scte35TimeSignalScheduleActionSettings `locationName:"scte35TimeSignalSettings" type:"structure"`

	// Action to activate a static image overlay
	StaticImageActivateSettings *StaticImageActivateScheduleActionSettings `locationName:"staticImageActivateSettings" type:"structure"`

	// Action to deactivate a static image overlay
	StaticImageDeactivateSettings *StaticImageDeactivateScheduleActionSettings `locationName:"staticImageDeactivateSettings" type:"structure"`
}

// String returns the string representation
func (s ScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleActionSettings"}
	if s.HlsId3SegmentTaggingSettings != nil {
		if err := s.HlsId3SegmentTaggingSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsId3SegmentTaggingSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsTimedMetadataSettings != nil {
		if err := s.HlsTimedMetadataSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsTimedMetadataSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputPrepareSettings != nil {
		if err := s.InputPrepareSettings.Validate(); err != nil {
			invalidParams.AddNested("InputPrepareSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSwitchSettings != nil {
		if err := s.InputSwitchSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSwitchSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.PauseStateSettings != nil {
		if err := s.PauseStateSettings.Validate(); err != nil {
			invalidParams.AddNested("PauseStateSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35ReturnToNetworkSettings != nil {
		if err := s.Scte35ReturnToNetworkSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35ReturnToNetworkSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35SpliceInsertSettings != nil {
		if err := s.Scte35SpliceInsertSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsertSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalSettings != nil {
		if err := s.Scte35TimeSignalSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StaticImageActivateSettings != nil {
		if err := s.StaticImageActivateSettings.Validate(); err != nil {
			invalidParams.AddNested("StaticImageActivateSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHlsId3SegmentTaggingSettings sets the HlsId3SegmentTaggingSettings field's value.
func (s *ScheduleActionSettings) SetHlsId3SegmentTaggingSettings(v *HlsId3SegmentTaggingScheduleActionSettings) *ScheduleActionSettings {
	s.HlsId3SegmentTaggingSettings = v
	return s
}

// SetHlsTimedMetadataSettings sets the HlsTimedMetadataSettings field's value.
func (s *ScheduleActionSettings) SetHlsTimedMetadataSettings(v *HlsTimedMetadataScheduleActionSettings) *ScheduleActionSettings {
	s.HlsTimedMetadataSettings = v
	return s
}

// SetInputPrepareSettings sets the InputPrepareSettings field's value.
func (s *ScheduleActionSettings) SetInputPrepareSettings(v *InputPrepareScheduleActionSettings) *ScheduleActionSettings {
	s.InputPrepareSettings = v
	return s
}

// SetInputSwitchSettings sets the InputSwitchSettings field's value.
func (s *ScheduleActionSettings) SetInputSwitchSettings(v *InputSwitchScheduleActionSettings) *ScheduleActionSettings {
	s.InputSwitchSettings = v
	return s
}

// SetPauseStateSettings sets the PauseStateSettings field's value.
func (s *ScheduleActionSettings) SetPauseStateSettings(v *PauseStateScheduleActionSettings) *ScheduleActionSettings {
	s.PauseStateSettings = v
	return s
}

// SetScte35ReturnToNetworkSettings sets the Scte35ReturnToNetworkSettings field's value.
func (s *ScheduleActionSettings) SetScte35ReturnToNetworkSettings(v *Scte35ReturnToNetworkScheduleActionSettings) *ScheduleActionSettings {
	s.Scte35ReturnToNetworkSettings = v
	return s
}

// SetScte35SpliceInsertSettings sets the Scte35SpliceInsertSettings field's value.
func (s *ScheduleActionSettings) SetScte35SpliceInsertSettings(v *Scte35SpliceInsertScheduleActionSettings) *ScheduleActionSettings {
	s.Scte35SpliceInsertSettings = v
	return s
}

// SetScte35TimeSignalSettings sets the Scte35TimeSignalSettings field's value.
func (s *ScheduleActionSettings) SetScte35TimeSignalSettings(v *Scte35TimeSignalScheduleActionSettings) *ScheduleActionSettings {
	s.Scte35TimeSignalSettings = v
	return s
}

// SetStaticImageActivateSettings sets the StaticImageActivateSettings field's value.
func (s *ScheduleActionSettings) SetStaticImageActivateSettings(v *StaticImageActivateScheduleActionSettings) *ScheduleActionSettings {
	s.StaticImageActivateSettings = v
	return s
}

// SetStaticImageDeactivateSettings sets the StaticImageDeactivateSettings field's value.
func (s *ScheduleActionSettings) SetStaticImageDeactivateSettings(v *StaticImageDeactivateScheduleActionSettings) *ScheduleActionSettings {
	s.StaticImageDeactivateSettings = v
	return s
}

// Settings to specify when an action should occur. Only one of the options
// must be selected.
type ScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Option for specifying the start time for an action.
	FixedModeScheduleActionStartSettings *FixedModeScheduleActionStartSettings `locationName:"fixedModeScheduleActionStartSettings" type:"structure"`

	// Option for specifying an action as relative to another action.
	FollowModeScheduleActionStartSettings *FollowModeScheduleActionStartSettings `locationName:"followModeScheduleActionStartSettings" type:"structure"`

	// Option for specifying an action that should be applied immediately.
	ImmediateModeScheduleActionStartSettings *ImmediateModeScheduleActionStartSettings `locationName:"immediateModeScheduleActionStartSettings" type:"structure"`
}

// String returns the string representation
func (s ScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActionStartSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActionStartSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleActionStartSettings"}
	if s.FixedModeScheduleActionStartSettings != nil {
		if err := s.FixedModeScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("FixedModeScheduleActionStartSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.FollowModeScheduleActionStartSettings != nil {
		if err := s.FollowModeScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("FollowModeScheduleActionStartSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFixedModeScheduleActionStartSettings sets the FixedModeScheduleActionStartSettings field's value.
func (s *ScheduleActionStartSettings) SetFixedModeScheduleActionStartSettings(v *FixedModeScheduleActionStartSettings) *ScheduleActionStartSettings {
	s.FixedModeScheduleActionStartSettings = v
	return s
}

// SetFollowModeScheduleActionStartSettings sets the FollowModeScheduleActionStartSettings field's value.
func (s *ScheduleActionStartSettings) SetFollowModeScheduleActionStartSettings(v *FollowModeScheduleActionStartSettings) *ScheduleActionStartSettings {
	s.FollowModeScheduleActionStartSettings = v
	return s
}

// SetImmediateModeScheduleActionStartSettings sets the ImmediateModeScheduleActionStartSettings field's value.
func (s *ScheduleActionStartSettings) SetImmediateModeScheduleActionStartSettings(v *ImmediateModeScheduleActionStartSettings) *ScheduleActionStartSettings {
	s.ImmediateModeScheduleActionStartSettings = v
	return s
}

// Scte20 Plus Embedded Destination Settings
type Scte20PlusEmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte20PlusEmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte20PlusEmbeddedDestinationSettings) GoString() string {
	return s.String()
}

// Scte20 Source Settings
type Scte20SourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 *string `locationName:"convert608To708" type:"string" enum:"Scte20Convert608To708"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte20SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte20SourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte20SourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte20SourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608ChannelNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConvert608To708 sets the Convert608To708 field's value.
func (s *Scte20SourceSettings) SetConvert608To708(v string) *Scte20SourceSettings {
	s.Convert608To708 = &v
	return s
}

// SetSource608ChannelNumber sets the Source608ChannelNumber field's value.
func (s *Scte20SourceSettings) SetSource608ChannelNumber(v int64) *Scte20SourceSettings {
	s.Source608ChannelNumber = &v
	return s
}

// Scte27 Destination Settings
type Scte27DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte27DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte27DestinationSettings) GoString() string {
	return s.String()
}

// Scte27 Source Settings
type Scte27SourceSettings struct {
	_ struct{} `type:"structure"`

	// The pid field is used in conjunction with the caption selector languageCode
	// field as follows: - Specify PID and Language: Extracts captions from that
	// PID; the language is "informational". - Specify PID and omit Language: Extracts
	// the specified PID. - Omit PID and specify Language: Extracts the specified
	// language, whichever PID that happens to be. - Omit PID and omit Language:
	// Valid only if source is DVB-Sub that is being passed through; all languages
	// will be passed through.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte27SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte27SourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte27SourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte27SourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *Scte27SourceSettings) SetPid(v int64) *Scte27SourceSettings {
	s.Pid = &v
	return s
}

// Corresponds to SCTE-35 delivery_not_restricted_flag parameter. To declare
// delivery restrictions, include this element and its four "restriction" flags.
// To declare that there are no restrictions, omit this element.
type Scte35DeliveryRestrictions struct {
	_ struct{} `type:"structure"`

	// Corresponds to SCTE-35 archive_allowed_flag.
	//
	// ArchiveAllowedFlag is a required field
	ArchiveAllowedFlag *string `locationName:"archiveAllowedFlag" type:"string" required:"true" enum:"Scte35ArchiveAllowedFlag"`

	// Corresponds to SCTE-35 device_restrictions parameter.
	//
	// DeviceRestrictions is a required field
	DeviceRestrictions *string `locationName:"deviceRestrictions" type:"string" required:"true" enum:"Scte35DeviceRestrictions"`

	// Corresponds to SCTE-35 no_regional_blackout_flag parameter.
	//
	// NoRegionalBlackoutFlag is a required field
	NoRegionalBlackoutFlag *string `locationName:"noRegionalBlackoutFlag" type:"string" required:"true" enum:"Scte35NoRegionalBlackoutFlag"`

	// Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
	//
	// WebDeliveryAllowedFlag is a required field
	WebDeliveryAllowedFlag *string `locationName:"webDeliveryAllowedFlag" type:"string" required:"true" enum:"Scte35WebDeliveryAllowedFlag"`
}

// String returns the string representation
func (s Scte35DeliveryRestrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35DeliveryRestrictions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35DeliveryRestrictions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35DeliveryRestrictions"}
	if s.ArchiveAllowedFlag == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveAllowedFlag"))
	}
	if s.DeviceRestrictions == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceRestrictions"))
	}
	if s.NoRegionalBlackoutFlag == nil {
		invalidParams.Add(request.NewErrParamRequired("NoRegionalBlackoutFlag"))
	}
	if s.WebDeliveryAllowedFlag == nil {
		invalidParams.Add(request.NewErrParamRequired("WebDeliveryAllowedFlag"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveAllowedFlag sets the ArchiveAllowedFlag field's value.
func (s *Scte35DeliveryRestrictions) SetArchiveAllowedFlag(v string) *Scte35DeliveryRestrictions {
	s.ArchiveAllowedFlag = &v
	return s
}

// SetDeviceRestrictions sets the DeviceRestrictions field's value.
func (s *Scte35DeliveryRestrictions) SetDeviceRestrictions(v string) *Scte35DeliveryRestrictions {
	s.DeviceRestrictions = &v
	return s
}

// SetNoRegionalBlackoutFlag sets the NoRegionalBlackoutFlag field's value.
func (s *Scte35DeliveryRestrictions) SetNoRegionalBlackoutFlag(v string) *Scte35DeliveryRestrictions {
	s.NoRegionalBlackoutFlag = &v
	return s
}

// SetWebDeliveryAllowedFlag sets the WebDeliveryAllowedFlag field's value.
func (s *Scte35DeliveryRestrictions) SetWebDeliveryAllowedFlag(v string) *Scte35DeliveryRestrictions {
	s.WebDeliveryAllowedFlag = &v
	return s
}

// Holds one set of SCTE-35 Descriptor Settings.
type Scte35Descriptor struct {
	_ struct{} `type:"structure"`

	// SCTE-35 Descriptor Settings.
	//
	// Scte35DescriptorSettings is a required field
	Scte35DescriptorSettings *Scte35DescriptorSettings `locationName:"scte35DescriptorSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s Scte35Descriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35Descriptor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35Descriptor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35Descriptor"}
	if s.Scte35DescriptorSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("Scte35DescriptorSettings"))
	}
	if s.Scte35DescriptorSettings != nil {
		if err := s.Scte35DescriptorSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35DescriptorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScte35DescriptorSettings sets the Scte35DescriptorSettings field's value.
func (s *Scte35Descriptor) SetScte35DescriptorSettings(v *Scte35DescriptorSettings) *Scte35Descriptor {
	s.Scte35DescriptorSettings = v
	return s
}

// SCTE-35 Descriptor settings.
type Scte35DescriptorSettings struct {
	_ struct{} `type:"structure"`

	// SCTE-35 Segmentation Descriptor.
	//
	// SegmentationDescriptorScte35DescriptorSettings is a required field
	SegmentationDescriptorScte35DescriptorSettings *Scte35SegmentationDescriptor `locationName:"segmentationDescriptorScte35DescriptorSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s Scte35DescriptorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35DescriptorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35DescriptorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35DescriptorSettings"}
	if s.SegmentationDescriptorScte35DescriptorSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentationDescriptorScte35DescriptorSettings"))
	}
	if s.SegmentationDescriptorScte35DescriptorSettings != nil {
		if err := s.SegmentationDescriptorScte35DescriptorSettings.Validate(); err != nil {
			invalidParams.AddNested("SegmentationDescriptorScte35DescriptorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSegmentationDescriptorScte35DescriptorSettings sets the SegmentationDescriptorScte35DescriptorSettings field's value.
func (s *Scte35DescriptorSettings) SetSegmentationDescriptorScte35DescriptorSettings(v *Scte35SegmentationDescriptor) *Scte35DescriptorSettings {
	s.SegmentationDescriptorScte35DescriptorSettings = v
	return s
}

// Settings for a SCTE-35 return_to_network message.
type Scte35ReturnToNetworkScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// SpliceEventId is a required field
	SpliceEventId *int64 `locationName:"spliceEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s Scte35ReturnToNetworkScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35ReturnToNetworkScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35ReturnToNetworkScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35ReturnToNetworkScheduleActionSettings"}
	if s.SpliceEventId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpliceEventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpliceEventId sets the SpliceEventId field's value.
func (s *Scte35ReturnToNetworkScheduleActionSettings) SetSpliceEventId(v int64) *Scte35ReturnToNetworkScheduleActionSettings {
	s.SpliceEventId = &v
	return s
}

// Corresponds to SCTE-35 segmentation_descriptor.
type Scte35SegmentationDescriptor struct {
	_ struct{} `type:"structure"`

	// Holds the four SCTE-35 delivery restriction parameters.
	DeliveryRestrictions *Scte35DeliveryRestrictions `locationName:"deliveryRestrictions" type:"structure"`

	// Corresponds to SCTE-35 segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SegmentNum *int64 `locationName:"segmentNum" type:"integer"`

	// Corresponds to SCTE-35 segmentation_event_cancel_indicator.
	//
	// SegmentationCancelIndicator is a required field
	SegmentationCancelIndicator *string `locationName:"segmentationCancelIndicator" type:"string" required:"true" enum:"Scte35SegmentationCancelIndicator"`

	// Corresponds to SCTE-35 segmentation_duration. Optional. The duration for
	// the time_signal, in 90 KHz ticks. To convert seconds to ticks, multiple the
	// seconds by 90,000. Enter time in 90 KHz clock ticks. If you do not enter
	// a duration, the time_signal will continue until you insert a cancellation
	// message.
	SegmentationDuration *int64 `locationName:"segmentationDuration" type:"long"`

	// Corresponds to SCTE-35 segmentation_event_id.
	//
	// SegmentationEventId is a required field
	SegmentationEventId *int64 `locationName:"segmentationEventId" type:"long" required:"true"`

	// Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id
	// values listed in the SCTE-35 specification. On the console, enter the ID
	// in decimal (for example, "52"). In the CLI, API, or an SDK, enter the ID
	// in hex (for example, "0x34") or decimal (for example, "52").
	SegmentationTypeId *int64 `locationName:"segmentationTypeId" type:"integer"`

	// Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal
	// representation of the characters that make up the SCTE-35 segmentation_upid
	// value. Must contain an even number of hex characters. Do not include spaces
	// between each hex pair. For example, the ASCII "ADS Information" becomes hex
	// "41445320496e666f726d6174696f6e.
	SegmentationUpid *string `locationName:"segmentationUpid" type:"string"`

	// Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one
	// of the types listed in the SCTE-35 specification, converted to a decimal.
	// For example, "0x0C" hex from the specification is "12" in decimal. In the
	// CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification,
	// in either hex (for example, "0x0C" ) or in decimal (for example, "12").
	SegmentationUpidType *int64 `locationName:"segmentationUpidType" type:"integer"`

	// Corresponds to SCTE-35 segments_expected. A value that is valid for the specified
	// segmentation_type_id.
	SegmentsExpected *int64 `locationName:"segmentsExpected" type:"integer"`

	// Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SubSegmentNum *int64 `locationName:"subSegmentNum" type:"integer"`

	// Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the
	// specified segmentation_type_id.
	SubSegmentsExpected *int64 `locationName:"subSegmentsExpected" type:"integer"`
}

// String returns the string representation
func (s Scte35SegmentationDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35SegmentationDescriptor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SegmentationDescriptor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35SegmentationDescriptor"}
	if s.SegmentationCancelIndicator == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentationCancelIndicator"))
	}
	if s.SegmentationEventId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentationEventId"))
	}
	if s.DeliveryRestrictions != nil {
		if err := s.DeliveryRestrictions.Validate(); err != nil {
			invalidParams.AddNested("DeliveryRestrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryRestrictions sets the DeliveryRestrictions field's value.
func (s *Scte35SegmentationDescriptor) SetDeliveryRestrictions(v *Scte35DeliveryRestrictions) *Scte35SegmentationDescriptor {
	s.DeliveryRestrictions = v
	return s
}

// SetSegmentNum sets the SegmentNum field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentNum(v int64) *Scte35SegmentationDescriptor {
	s.SegmentNum = &v
	return s
}

// SetSegmentationCancelIndicator sets the SegmentationCancelIndicator field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationCancelIndicator(v string) *Scte35SegmentationDescriptor {
	s.SegmentationCancelIndicator = &v
	return s
}

// SetSegmentationDuration sets the SegmentationDuration field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationDuration(v int64) *Scte35SegmentationDescriptor {
	s.SegmentationDuration = &v
	return s
}

// SetSegmentationEventId sets the SegmentationEventId field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationEventId(v int64) *Scte35SegmentationDescriptor {
	s.SegmentationEventId = &v
	return s
}

// SetSegmentationTypeId sets the SegmentationTypeId field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationTypeId(v int64) *Scte35SegmentationDescriptor {
	s.SegmentationTypeId = &v
	return s
}

// SetSegmentationUpid sets the SegmentationUpid field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationUpid(v string) *Scte35SegmentationDescriptor {
	s.SegmentationUpid = &v
	return s
}

// SetSegmentationUpidType sets the SegmentationUpidType field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentationUpidType(v int64) *Scte35SegmentationDescriptor {
	s.SegmentationUpidType = &v
	return s
}

// SetSegmentsExpected sets the SegmentsExpected field's value.
func (s *Scte35SegmentationDescriptor) SetSegmentsExpected(v int64) *Scte35SegmentationDescriptor {
	s.SegmentsExpected = &v
	return s
}

// SetSubSegmentNum sets the SubSegmentNum field's value.
func (s *Scte35SegmentationDescriptor) SetSubSegmentNum(v int64) *Scte35SegmentationDescriptor {
	s.SubSegmentNum = &v
	return s
}

// SetSubSegmentsExpected sets the SubSegmentsExpected field's value.
func (s *Scte35SegmentationDescriptor) SetSubSegmentsExpected(v int64) *Scte35SegmentationDescriptor {
	s.SubSegmentsExpected = &v
	return s
}

// Scte35 Splice Insert
type Scte35SpliceInsert struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag *string `locationName:"noRegionalBlackoutFlag" type:"string" enum:"Scte35SpliceInsertNoRegionalBlackoutBehavior"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag *string `locationName:"webDeliveryAllowedFlag" type:"string" enum:"Scte35SpliceInsertWebDeliveryAllowedBehavior"`
}

// String returns the string representation
func (s Scte35SpliceInsert) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35SpliceInsert) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SpliceInsert) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35SpliceInsert"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(request.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdAvailOffset sets the AdAvailOffset field's value.
func (s *Scte35SpliceInsert) SetAdAvailOffset(v int64) *Scte35SpliceInsert {
	s.AdAvailOffset = &v
	return s
}

// SetNoRegionalBlackoutFlag sets the NoRegionalBlackoutFlag field's value.
func (s *Scte35SpliceInsert) SetNoRegionalBlackoutFlag(v string) *Scte35SpliceInsert {
	s.NoRegionalBlackoutFlag = &v
	return s
}

// SetWebDeliveryAllowedFlag sets the WebDeliveryAllowedFlag field's value.
func (s *Scte35SpliceInsert) SetWebDeliveryAllowedFlag(v string) *Scte35SpliceInsert {
	s.WebDeliveryAllowedFlag = &v
	return s
}

// Settings for a SCTE-35 splice_insert message.
type Scte35SpliceInsertScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Optional, the duration for the splice_insert, in 90 KHz ticks. To convert
	// seconds to ticks, multiple the seconds by 90,000. If you enter a duration,
	// there is an expectation that the downstream system can read the duration
	// and cue in at that time. If you do not enter a duration, the splice_insert
	// will continue indefinitely and there is an expectation that you will enter
	// a return_to_network to end the splice_insert at the appropriate time.
	Duration *int64 `locationName:"duration" type:"long"`

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// SpliceEventId is a required field
	SpliceEventId *int64 `locationName:"spliceEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s Scte35SpliceInsertScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35SpliceInsertScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SpliceInsertScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35SpliceInsertScheduleActionSettings"}
	if s.SpliceEventId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpliceEventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *Scte35SpliceInsertScheduleActionSettings) SetDuration(v int64) *Scte35SpliceInsertScheduleActionSettings {
	s.Duration = &v
	return s
}

// SetSpliceEventId sets the SpliceEventId field's value.
func (s *Scte35SpliceInsertScheduleActionSettings) SetSpliceEventId(v int64) *Scte35SpliceInsertScheduleActionSettings {
	s.SpliceEventId = &v
	return s
}

// Scte35 Time Signal Apos
type Scte35TimeSignalApos struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag *string `locationName:"noRegionalBlackoutFlag" type:"string" enum:"Scte35AposNoRegionalBlackoutBehavior"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag *string `locationName:"webDeliveryAllowedFlag" type:"string" enum:"Scte35AposWebDeliveryAllowedBehavior"`
}

// String returns the string representation
func (s Scte35TimeSignalApos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35TimeSignalApos) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35TimeSignalApos) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35TimeSignalApos"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(request.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdAvailOffset sets the AdAvailOffset field's value.
func (s *Scte35TimeSignalApos) SetAdAvailOffset(v int64) *Scte35TimeSignalApos {
	s.AdAvailOffset = &v
	return s
}

// SetNoRegionalBlackoutFlag sets the NoRegionalBlackoutFlag field's value.
func (s *Scte35TimeSignalApos) SetNoRegionalBlackoutFlag(v string) *Scte35TimeSignalApos {
	s.NoRegionalBlackoutFlag = &v
	return s
}

// SetWebDeliveryAllowedFlag sets the WebDeliveryAllowedFlag field's value.
func (s *Scte35TimeSignalApos) SetWebDeliveryAllowedFlag(v string) *Scte35TimeSignalApos {
	s.WebDeliveryAllowedFlag = &v
	return s
}

// Settings for a SCTE-35 time_signal.
type Scte35TimeSignalScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The list of SCTE-35 descriptors accompanying the SCTE-35 time_signal.
	//
	// Scte35Descriptors is a required field
	Scte35Descriptors []*Scte35Descriptor `locationName:"scte35Descriptors" type:"list" required:"true"`
}

// String returns the string representation
func (s Scte35TimeSignalScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35TimeSignalScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35TimeSignalScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35TimeSignalScheduleActionSettings"}
	if s.Scte35Descriptors == nil {
		invalidParams.Add(request.NewErrParamRequired("Scte35Descriptors"))
	}
	if s.Scte35Descriptors != nil {
		for i, v := range s.Scte35Descriptors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Scte35Descriptors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScte35Descriptors sets the Scte35Descriptors field's value.
func (s *Scte35TimeSignalScheduleActionSettings) SetScte35Descriptors(v []*Scte35Descriptor) *Scte35TimeSignalScheduleActionSettings {
	s.Scte35Descriptors = v
	return s
}

// Smpte Tt Destination Settings
type SmpteTtDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SmpteTtDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmpteTtDestinationSettings) GoString() string {
	return s.String()
}

// Standard Hls Settings
type StandardHlsSettings struct {
	_ struct{} `type:"structure"`

	// List all the audio groups that are used with the video output stream. Input
	// all the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string `locationName:"audioRenditionSets" type:"string"`

	// Settings information for the .m3u8 container
	//
	// M3u8Settings is a required field
	M3u8Settings *M3u8Settings `locationName:"m3u8Settings" type:"structure" required:"true"`
}

// String returns the string representation
func (s StandardHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardHlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardHlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandardHlsSettings"}
	if s.M3u8Settings == nil {
		invalidParams.Add(request.NewErrParamRequired("M3u8Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRenditionSets sets the AudioRenditionSets field's value.
func (s *StandardHlsSettings) SetAudioRenditionSets(v string) *StandardHlsSettings {
	s.AudioRenditionSets = &v
	return s
}

// SetM3u8Settings sets the M3u8Settings field's value.
func (s *StandardHlsSettings) SetM3u8Settings(v *M3u8Settings) *StandardHlsSettings {
	s.M3u8Settings = v
	return s
}

type StartChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *StartChannelInput) SetChannelId(v string) *StartChannelInput {
	s.ChannelId = &v
	return s
}

type StartChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartChannelOutput) SetArn(v string) *StartChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *StartChannelOutput) SetChannelClass(v string) *StartChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StartChannelOutput) SetDestinations(v []*OutputDestination) *StartChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *StartChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *StartChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *StartChannelOutput) SetEncoderSettings(v *EncoderSettings) *StartChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *StartChannelOutput) SetId(v string) *StartChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *StartChannelOutput) SetInputAttachments(v []*InputAttachment) *StartChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *StartChannelOutput) SetInputSpecification(v *InputSpecification) *StartChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *StartChannelOutput) SetLogLevel(v string) *StartChannelOutput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartChannelOutput) SetName(v string) *StartChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *StartChannelOutput) SetPipelineDetails(v []*PipelineDetail) *StartChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StartChannelOutput) SetPipelinesRunningCount(v int64) *StartChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartChannelOutput) SetRoleArn(v string) *StartChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *StartChannelOutput) SetState(v string) *StartChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartChannelOutput) SetTags(v map[string]*string) *StartChannelOutput {
	s.Tags = v
	return s
}

type StartMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *StartMultiplexInput) SetMultiplexId(v string) *StartMultiplexInput {
	s.MultiplexId = &v
	return s
}

type StartMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartMultiplexOutput) SetArn(v string) *StartMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *StartMultiplexOutput) SetAvailabilityZones(v []*string) *StartMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StartMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *StartMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *StartMultiplexOutput) SetId(v string) *StartMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *StartMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *StartMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *StartMultiplexOutput) SetName(v string) *StartMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StartMultiplexOutput) SetPipelinesRunningCount(v int64) *StartMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *StartMultiplexOutput) SetProgramCount(v int64) *StartMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *StartMultiplexOutput) SetState(v string) *StartMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartMultiplexOutput) SetTags(v map[string]*string) *StartMultiplexOutput {
	s.Tags = v
	return s
}

// Settings to identify the start of the clip.
type StartTimecode struct {
	_ struct{} `type:"structure"`

	// The timecode for the frame where you want to start the clip. Optional; if
	// not specified, the clip starts at first frame in the file. Enter the timecode
	// as HH:MM:SS:FF or HH:MM:SS;FF.
	Timecode *string `locationName:"timecode" type:"string"`
}

// String returns the string representation
func (s StartTimecode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimecode) GoString() string {
	return s.String()
}

// SetTimecode sets the Timecode field's value.
func (s *StartTimecode) SetTimecode(v string) *StartTimecode {
	s.Timecode = &v
	return s
}

// Settings for the action to activate a static image.
type StaticImageActivateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The duration in milliseconds for the image to remain on the video. If omitted
	// or set to 0 the duration is unlimited and the image will remain until it
	// is explicitly deactivated.
	Duration *int64 `locationName:"duration" type:"integer"`

	// The time in milliseconds for the image to fade in. The fade-in starts at
	// the start time of the overlay. Default is 0 (no fade-in).
	FadeIn *int64 `locationName:"fadeIn" type:"integer"`

	// Applies only if a duration is specified. The time in milliseconds for the
	// image to fade out. The fade-out starts when the duration time is hit, so
	// it effectively extends the duration. Default is 0 (no fade-out).
	FadeOut *int64 `locationName:"fadeOut" type:"integer"`

	// The height of the image when inserted into the video, in pixels. The overlay
	// will be scaled up or down to the specified height. Leave blank to use the
	// native height of the overlay.
	Height *int64 `locationName:"height" min:"1" type:"integer"`

	// The location and filename of the image file to overlay on the video. The
	// file must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels)
	// than the input video.
	//
	// Image is a required field
	Image *InputLocation `locationName:"image" type:"structure" required:"true"`

	// Placement of the left edge of the overlay relative to the left edge of the
	// video frame, in pixels. 0 (the default) is the left edge of the frame. If
	// the placement causes the overlay to extend beyond the right edge of the underlying
	// video, then the overlay is cropped on the right.
	ImageX *int64 `locationName:"imageX" type:"integer"`

	// Placement of the top edge of the overlay relative to the top edge of the
	// video frame, in pixels. 0 (the default) is the top edge of the frame. If
	// the placement causes the overlay to extend beyond the bottom edge of the
	// underlying video, then the overlay is cropped on the bottom.
	ImageY *int64 `locationName:"imageY" type:"integer"`

	// The number of the layer, 0 to 7. There are 8 layers that can be overlaid
	// on the video, each layer with a different image. The layers are in Z order,
	// which means that overlays with higher values of layer are inserted on top
	// of overlays with lower values of layer. Default is 0.
	Layer *int64 `locationName:"layer" type:"integer"`

	// Opacity of image where 0 is transparent and 100 is fully opaque. Default
	// is 100.
	Opacity *int64 `locationName:"opacity" type:"integer"`

	// The width of the image when inserted into the video, in pixels. The overlay
	// will be scaled up or down to the specified width. Leave blank to use the
	// native width of the overlay.
	Width *int64 `locationName:"width" min:"1" type:"integer"`
}

// String returns the string representation
func (s StaticImageActivateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticImageActivateScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticImageActivateScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticImageActivateScheduleActionSettings"}
	if s.Height != nil && *s.Height < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Height", 1))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Width != nil && *s.Width < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Width", 1))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *StaticImageActivateScheduleActionSettings) SetDuration(v int64) *StaticImageActivateScheduleActionSettings {
	s.Duration = &v
	return s
}

// SetFadeIn sets the FadeIn field's value.
func (s *StaticImageActivateScheduleActionSettings) SetFadeIn(v int64) *StaticImageActivateScheduleActionSettings {
	s.FadeIn = &v
	return s
}

// SetFadeOut sets the FadeOut field's value.
func (s *StaticImageActivateScheduleActionSettings) SetFadeOut(v int64) *StaticImageActivateScheduleActionSettings {
	s.FadeOut = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *StaticImageActivateScheduleActionSettings) SetHeight(v int64) *StaticImageActivateScheduleActionSettings {
	s.Height = &v
	return s
}

// SetImage sets the Image field's value.
func (s *StaticImageActivateScheduleActionSettings) SetImage(v *InputLocation) *StaticImageActivateScheduleActionSettings {
	s.Image = v
	return s
}

// SetImageX sets the ImageX field's value.
func (s *StaticImageActivateScheduleActionSettings) SetImageX(v int64) *StaticImageActivateScheduleActionSettings {
	s.ImageX = &v
	return s
}

// SetImageY sets the ImageY field's value.
func (s *StaticImageActivateScheduleActionSettings) SetImageY(v int64) *StaticImageActivateScheduleActionSettings {
	s.ImageY = &v
	return s
}

// SetLayer sets the Layer field's value.
func (s *StaticImageActivateScheduleActionSettings) SetLayer(v int64) *StaticImageActivateScheduleActionSettings {
	s.Layer = &v
	return s
}

// SetOpacity sets the Opacity field's value.
func (s *StaticImageActivateScheduleActionSettings) SetOpacity(v int64) *StaticImageActivateScheduleActionSettings {
	s.Opacity = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *StaticImageActivateScheduleActionSettings) SetWidth(v int64) *StaticImageActivateScheduleActionSettings {
	s.Width = &v
	return s
}

// Settings for the action to deactivate the image in a specific layer.
type StaticImageDeactivateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
	FadeOut *int64 `locationName:"fadeOut" type:"integer"`

	// The image overlay layer to deactivate, 0 to 7. Default is 0.
	Layer *int64 `locationName:"layer" type:"integer"`
}

// String returns the string representation
func (s StaticImageDeactivateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticImageDeactivateScheduleActionSettings) GoString() string {
	return s.String()
}

// SetFadeOut sets the FadeOut field's value.
func (s *StaticImageDeactivateScheduleActionSettings) SetFadeOut(v int64) *StaticImageDeactivateScheduleActionSettings {
	s.FadeOut = &v
	return s
}

// SetLayer sets the Layer field's value.
func (s *StaticImageDeactivateScheduleActionSettings) SetLayer(v int64) *StaticImageDeactivateScheduleActionSettings {
	s.Layer = &v
	return s
}

// Static Key Settings
type StaticKeySettings struct {
	_ struct{} `type:"structure"`

	// The URL of the license server used for protecting content.
	KeyProviderServer *InputLocation `locationName:"keyProviderServer" type:"structure"`

	// Static key value as a 32 character hexadecimal string.
	//
	// StaticKeyValue is a required field
	StaticKeyValue *string `locationName:"staticKeyValue" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StaticKeySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticKeySettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticKeySettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticKeySettings"}
	if s.StaticKeyValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticKeyValue"))
	}
	if s.StaticKeyValue != nil && len(*s.StaticKeyValue) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("StaticKeyValue", 32))
	}
	if s.KeyProviderServer != nil {
		if err := s.KeyProviderServer.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderServer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyProviderServer sets the KeyProviderServer field's value.
func (s *StaticKeySettings) SetKeyProviderServer(v *InputLocation) *StaticKeySettings {
	s.KeyProviderServer = v
	return s
}

// SetStaticKeyValue sets the StaticKeyValue field's value.
func (s *StaticKeySettings) SetStaticKeyValue(v string) *StaticKeySettings {
	s.StaticKeyValue = &v
	return s
}

type StopChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *StopChannelInput) SetChannelId(v string) *StopChannelInput {
	s.ChannelId = &v
	return s
}

type StopChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StopChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StopChannelOutput) SetArn(v string) *StopChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *StopChannelOutput) SetChannelClass(v string) *StopChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StopChannelOutput) SetDestinations(v []*OutputDestination) *StopChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *StopChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *StopChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *StopChannelOutput) SetEncoderSettings(v *EncoderSettings) *StopChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *StopChannelOutput) SetId(v string) *StopChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *StopChannelOutput) SetInputAttachments(v []*InputAttachment) *StopChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *StopChannelOutput) SetInputSpecification(v *InputSpecification) *StopChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *StopChannelOutput) SetLogLevel(v string) *StopChannelOutput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *StopChannelOutput) SetName(v string) *StopChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *StopChannelOutput) SetPipelineDetails(v []*PipelineDetail) *StopChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StopChannelOutput) SetPipelinesRunningCount(v int64) *StopChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StopChannelOutput) SetRoleArn(v string) *StopChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *StopChannelOutput) SetState(v string) *StopChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StopChannelOutput) SetTags(v map[string]*string) *StopChannelOutput {
	s.Tags = v
	return s
}

type StopMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *StopMultiplexInput) SetMultiplexId(v string) *StopMultiplexInput {
	s.MultiplexId = &v
	return s
}

type StopMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StopMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StopMultiplexOutput) SetArn(v string) *StopMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *StopMultiplexOutput) SetAvailabilityZones(v []*string) *StopMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StopMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *StopMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *StopMultiplexOutput) SetId(v string) *StopMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *StopMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *StopMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *StopMultiplexOutput) SetName(v string) *StopMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StopMultiplexOutput) SetPipelinesRunningCount(v int64) *StopMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *StopMultiplexOutput) SetProgramCount(v int64) *StopMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *StopMultiplexOutput) SetState(v string) *StopMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StopMultiplexOutput) SetTags(v map[string]*string) *StopMultiplexOutput {
	s.Tags = v
	return s
}

// Settings to identify the end of the clip.
type StopTimecode struct {
	_ struct{} `type:"structure"`

	// If you specify a StopTimecode in an input (in order to clip the file), you
	// can specify if you want the clip to exclude (the default) or include the
	// frame specified by the timecode.
	LastFrameClippingBehavior *string `locationName:"lastFrameClippingBehavior" type:"string" enum:"LastFrameClippingBehavior"`

	// The timecode for the frame where you want to stop the clip. Optional; if
	// not specified, the clip continues to the end of the file. Enter the timecode
	// as HH:MM:SS:FF or HH:MM:SS;FF.
	Timecode *string `locationName:"timecode" type:"string"`
}

// String returns the string representation
func (s StopTimecode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTimecode) GoString() string {
	return s.String()
}

// SetLastFrameClippingBehavior sets the LastFrameClippingBehavior field's value.
func (s *StopTimecode) SetLastFrameClippingBehavior(v string) *StopTimecode {
	s.LastFrameClippingBehavior = &v
	return s
}

// SetTimecode sets the Timecode field's value.
func (s *StopTimecode) SetTimecode(v string) *StopTimecode {
	s.Timecode = &v
	return s
}

// Teletext Destination Settings
type TeletextDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TeletextDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeletextDestinationSettings) GoString() string {
	return s.String()
}

// Teletext Source Settings
type TeletextSourceSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the teletext page number within the data stream from which to extract
	// captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should
	// be specified as a hexadecimal string with no "0x" prefix.
	PageNumber *string `locationName:"pageNumber" type:"string"`
}

// String returns the string representation
func (s TeletextSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeletextSourceSettings) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *TeletextSourceSettings) SetPageNumber(v string) *TeletextSourceSettings {
	s.PageNumber = &v
	return s
}

// Temporal Filter Settings
type TemporalFilterSettings struct {
	_ struct{} `type:"structure"`

	// If you enable this filter, the results are the following:- If the source
	// content is noisy (it contains excessive digital artifacts), the filter cleans
	// up the source.- If the source content is already clean, the filter tends
	// to decrease the bitrate, especially when the rate control mode is QVBR.
	PostFilterSharpening *string `locationName:"postFilterSharpening" type:"string" enum:"TemporalFilterPostFilterSharpening"`

	// Choose a filter strength. We recommend a strength of 1 or 2. A higher strength
	// might take out good information, resulting in an image that is overly soft.
	Strength *string `locationName:"strength" type:"string" enum:"TemporalFilterStrength"`
}

// String returns the string representation
func (s TemporalFilterSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporalFilterSettings) GoString() string {
	return s.String()
}

// SetPostFilterSharpening sets the PostFilterSharpening field's value.
func (s *TemporalFilterSettings) SetPostFilterSharpening(v string) *TemporalFilterSettings {
	s.PostFilterSharpening = &v
	return s
}

// SetStrength sets the Strength field's value.
func (s *TemporalFilterSettings) SetStrength(v string) *TemporalFilterSettings {
	s.Strength = &v
	return s
}

// Timecode Config
type TimecodeConfig struct {
	_ struct{} `type:"structure"`

	// Identifies the source for the timecode that will be associated with the events
	// outputs.-Embedded (embedded): Initialize the output timecode with timecode
	// from the the source. If no embedded timecode is detected in the source, the
	// system falls back to using "Start at 0" (zerobased).-System Clock (systemclock):
	// Use the UTC time.-Start at 0 (zerobased): The time of the first frame of
	// the event will be 00:00:00:00.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"TimecodeConfigSource"`

	// Threshold in frames beyond which output timecode is resynchronized to the
	// input timecode. Discrepancies below this threshold are permitted to avoid
	// unnecessary discontinuities in the output timecode. No timecode sync when
	// this is not specified.
	SyncThreshold *int64 `locationName:"syncThreshold" min:"1" type:"integer"`
}

// String returns the string representation
func (s TimecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimecodeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimecodeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimecodeConfig"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.SyncThreshold != nil && *s.SyncThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SyncThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *TimecodeConfig) SetSource(v string) *TimecodeConfig {
	s.Source = &v
	return s
}

// SetSyncThreshold sets the SyncThreshold field's value.
func (s *TimecodeConfig) SetSyncThreshold(v int64) *TimecodeConfig {
	s.SyncThreshold = &v
	return s
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Ttml Destination Settings
type TtmlDestinationSettings struct {
	_ struct{} `type:"structure"`

	// When set to passthrough, passes through style and position information from
	// a TTML-like input source (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or
	// TTML output.
	StyleControl *string `locationName:"styleControl" type:"string" enum:"TtmlDestinationStyleControl"`
}

// String returns the string representation
func (s TtmlDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TtmlDestinationSettings) GoString() string {
	return s.String()
}

// SetStyleControl sets the StyleControl field's value.
func (s *TtmlDestinationSettings) SetStyleControl(v string) *TtmlDestinationSettings {
	s.StyleControl = &v
	return s
}

// Udp Container Settings
type UdpContainerSettings struct {
	_ struct{} `type:"structure"`

	// M2ts Settings
	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s UdpContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpContainerSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpContainerSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UdpContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetM2tsSettings sets the M2tsSettings field's value.
func (s *UdpContainerSettings) SetM2tsSettings(v *M2tsSettings) *UdpContainerSettings {
	s.M2tsSettings = v
	return s
}

// Udp Group Settings
type UdpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Specifies behavior of last resort when input video is lost, and no more backup
	// inputs are available. When dropTs is selected the entire transport stream
	// will stop being emitted. When dropProgram is selected the program can be
	// dropped from the transport stream (and replaced with null packets to meet
	// the TS bitrate requirement). Or, when emitProgram is chosen the transport
	// stream will continue to be produced normally with repeat frames, black frames,
	// or slate frames substituted for the absent input video.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForUdpOut"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame *string `locationName:"timedMetadataId3Frame" type:"string" enum:"UdpTimedMetadataId3Frame"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`
}

// String returns the string representation
func (s UdpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpGroupSettings) GoString() string {
	return s.String()
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *UdpGroupSettings) SetInputLossAction(v string) *UdpGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetTimedMetadataId3Frame sets the TimedMetadataId3Frame field's value.
func (s *UdpGroupSettings) SetTimedMetadataId3Frame(v string) *UdpGroupSettings {
	s.TimedMetadataId3Frame = &v
	return s
}

// SetTimedMetadataId3Period sets the TimedMetadataId3Period field's value.
func (s *UdpGroupSettings) SetTimedMetadataId3Period(v int64) *UdpGroupSettings {
	s.TimedMetadataId3Period = &v
	return s
}

// Udp Output Settings
type UdpOutputSettings struct {
	_ struct{} `type:"structure"`

	// UDP output buffering in milliseconds. Larger values increase latency through
	// the transcoder but simultaneously assist the transcoder in maintaining a
	// constant, low-jitter UDP/RTP output while accommodating clock recovery, input
	// switching, input disruptions, picture reordering, etc.
	BufferMsec *int64 `locationName:"bufferMsec" type:"integer"`

	// Udp Container Settings
	//
	// ContainerSettings is a required field
	ContainerSettings *UdpContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Destination address and port number for RTP or UDP packets. Can be unicast
	// or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
	FecOutputSettings *FecOutputSettings `locationName:"fecOutputSettings" type:"structure"`
}

// String returns the string representation
func (s UdpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UdpOutputSettings"}
	if s.ContainerSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerSettings"))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.FecOutputSettings != nil {
		if err := s.FecOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("FecOutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferMsec sets the BufferMsec field's value.
func (s *UdpOutputSettings) SetBufferMsec(v int64) *UdpOutputSettings {
	s.BufferMsec = &v
	return s
}

// SetContainerSettings sets the ContainerSettings field's value.
func (s *UdpOutputSettings) SetContainerSettings(v *UdpContainerSettings) *UdpOutputSettings {
	s.ContainerSettings = v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UdpOutputSettings) SetDestination(v *OutputLocationRef) *UdpOutputSettings {
	s.Destination = v
	return s
}

// SetFecOutputSettings sets the FecOutputSettings field's value.
func (s *UdpOutputSettings) SetFecOutputSettings(v *FecOutputSettings) *UdpOutputSettings {
	s.FecOutputSettings = v
	return s
}

type UnprocessableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ValidationErrors []*ValidationError `locationName:"validationErrors" type:"list"`
}

// String returns the string representation
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s *UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s *UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnprocessableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnprocessableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateChannelClassInput struct {
	_ struct{} `type:"structure"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	//
	// ChannelClass is a required field
	ChannelClass *string `locationName:"channelClass" type:"string" required:"true" enum:"ChannelClass"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`
}

// String returns the string representation
func (s UpdateChannelClassInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelClassInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelClassInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelClassInput"}
	if s.ChannelClass == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelClass"))
	}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelClass sets the ChannelClass field's value.
func (s *UpdateChannelClassInput) SetChannelClass(v string) *UpdateChannelClassInput {
	s.ChannelClass = &v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateChannelClassInput) SetChannelId(v string) *UpdateChannelClassInput {
	s.ChannelId = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateChannelClassInput) SetDestinations(v []*OutputDestination) *UpdateChannelClassInput {
	s.Destinations = v
	return s
}

type UpdateChannelClassOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s UpdateChannelClassOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelClassOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *UpdateChannelClassOutput) SetChannel(v *Channel) *UpdateChannelClassOutput {
	s.Channel = v
	return s
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Name *string `locationName:"name" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EncoderSettings != nil {
		if err := s.EncoderSettings.Validate(); err != nil {
			invalidParams.AddNested("EncoderSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputAttachments != nil {
		for i, v := range s.InputAttachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputAttachments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateChannelInput) SetChannelId(v string) *UpdateChannelInput {
	s.ChannelId = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateChannelInput) SetDestinations(v []*OutputDestination) *UpdateChannelInput {
	s.Destinations = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *UpdateChannelInput) SetEncoderSettings(v *EncoderSettings) *UpdateChannelInput {
	s.EncoderSettings = v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *UpdateChannelInput) SetInputAttachments(v []*InputAttachment) *UpdateChannelInput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *UpdateChannelInput) SetInputSpecification(v *InputSpecification) *UpdateChannelInput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *UpdateChannelInput) SetLogLevel(v string) *UpdateChannelInput {
	s.LogLevel = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateChannelInput) SetRoleArn(v string) *UpdateChannelInput {
	s.RoleArn = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *UpdateChannelOutput) SetChannel(v *Channel) *UpdateChannelOutput {
	s.Channel = v
	return s
}

type UpdateInputDeviceInput struct {
	_ struct{} `type:"structure"`

	// Configurable settings for the input device.
	HdDeviceSettings *InputDeviceConfigurableSettings `locationName:"hdDeviceSettings" type:"structure"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateInputDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputDeviceInput"}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *UpdateInputDeviceInput) SetHdDeviceSettings(v *InputDeviceConfigurableSettings) *UpdateInputDeviceInput {
	s.HdDeviceSettings = v
	return s
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *UpdateInputDeviceInput) SetInputDeviceId(v string) *UpdateInputDeviceInput {
	s.InputDeviceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInputDeviceInput) SetName(v string) *UpdateInputDeviceInput {
	s.Name = &v
	return s
}

type UpdateInputDeviceOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// The state of the connection between the input device and AWS.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"InputDeviceConnectionState"`

	// The status of the action to synchronize the device configuration. If you
	// change the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState *string `locationName:"deviceSettingsSyncState" type:"string" enum:"DeviceSettingsSyncState"`

	// Settings that describe the active source from the input device, and the video
	// characteristics of that source.
	HdDeviceSettings *InputDeviceHdSettings `locationName:"hdDeviceSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	MacAddress *string `locationName:"macAddress" type:"string"`

	Name *string `locationName:"name" type:"string"`

	// The network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings `locationName:"networkSettings" type:"structure"`

	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The type of the input device. For an AWS Elemental Link device that outputs
	// resolutions up to 1080, choose "HD".
	Type *string `locationName:"type" type:"string" enum:"InputDeviceType"`
}

// String returns the string representation
func (s UpdateInputDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateInputDeviceOutput) SetArn(v string) *UpdateInputDeviceOutput {
	s.Arn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *UpdateInputDeviceOutput) SetConnectionState(v string) *UpdateInputDeviceOutput {
	s.ConnectionState = &v
	return s
}

// SetDeviceSettingsSyncState sets the DeviceSettingsSyncState field's value.
func (s *UpdateInputDeviceOutput) SetDeviceSettingsSyncState(v string) *UpdateInputDeviceOutput {
	s.DeviceSettingsSyncState = &v
	return s
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *UpdateInputDeviceOutput) SetHdDeviceSettings(v *InputDeviceHdSettings) *UpdateInputDeviceOutput {
	s.HdDeviceSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateInputDeviceOutput) SetId(v string) *UpdateInputDeviceOutput {
	s.Id = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *UpdateInputDeviceOutput) SetMacAddress(v string) *UpdateInputDeviceOutput {
	s.MacAddress = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInputDeviceOutput) SetName(v string) *UpdateInputDeviceOutput {
	s.Name = &v
	return s
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *UpdateInputDeviceOutput) SetNetworkSettings(v *InputDeviceNetworkSettings) *UpdateInputDeviceOutput {
	s.NetworkSettings = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *UpdateInputDeviceOutput) SetSerialNumber(v string) *UpdateInputDeviceOutput {
	s.SerialNumber = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateInputDeviceOutput) SetType(v string) *UpdateInputDeviceOutput {
	s.Type = &v
	return s
}

type UpdateInputInput struct {
	_ struct{} `type:"structure"`

	Destinations []*InputDestinationRequest `locationName:"destinations" type:"list"`

	InputDevices []*InputDeviceRequest `locationName:"inputDevices" type:"list"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`

	InputSecurityGroups []*string `locationName:"inputSecurityGroups" type:"list"`

	MediaConnectFlows []*MediaConnectFlowRequest `locationName:"mediaConnectFlows" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	Sources []*InputSourceRequest `locationName:"sources" type:"list"`
}

// String returns the string representation
func (s UpdateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateInputInput) SetDestinations(v []*InputDestinationRequest) *UpdateInputInput {
	s.Destinations = v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *UpdateInputInput) SetInputDevices(v []*InputDeviceRequest) *UpdateInputInput {
	s.InputDevices = v
	return s
}

// SetInputId sets the InputId field's value.
func (s *UpdateInputInput) SetInputId(v string) *UpdateInputInput {
	s.InputId = &v
	return s
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *UpdateInputInput) SetInputSecurityGroups(v []*string) *UpdateInputInput {
	s.InputSecurityGroups = v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *UpdateInputInput) SetMediaConnectFlows(v []*MediaConnectFlowRequest) *UpdateInputInput {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInputInput) SetName(v string) *UpdateInputInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateInputInput) SetRoleArn(v string) *UpdateInputInput {
	s.RoleArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateInputInput) SetSources(v []*InputSourceRequest) *UpdateInputInput {
	s.Sources = v
	return s
}

type UpdateInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s UpdateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *UpdateInputOutput) SetInput(v *Input) *UpdateInputOutput {
	s.Input = v
	return s
}

type UpdateInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	WhitelistRules []*InputWhitelistRuleCidr `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s UpdateInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}
	if s.InputSecurityGroupId != nil && len(*s.InputSecurityGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSecurityGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *UpdateInputSecurityGroupInput) SetInputSecurityGroupId(v string) *UpdateInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateInputSecurityGroupInput) SetTags(v map[string]*string) *UpdateInputSecurityGroupInput {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *UpdateInputSecurityGroupInput) SetWhitelistRules(v []*InputWhitelistRuleCidr) *UpdateInputSecurityGroupInput {
	s.WhitelistRules = v
	return s
}

type UpdateInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// An Input Security Group
	SecurityGroup *InputSecurityGroup `locationName:"securityGroup" type:"structure"`
}

// String returns the string representation
func (s UpdateInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *UpdateInputSecurityGroupOutput) SetSecurityGroup(v *InputSecurityGroup) *UpdateInputSecurityGroupOutput {
	s.SecurityGroup = v
	return s
}

type UpdateMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.MultiplexSettings != nil {
		if err := s.MultiplexSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *UpdateMultiplexInput) SetMultiplexId(v string) *UpdateMultiplexInput {
	s.MultiplexId = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *UpdateMultiplexInput) SetMultiplexSettings(v *MultiplexSettings) *UpdateMultiplexInput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateMultiplexInput) SetName(v string) *UpdateMultiplexInput {
	s.Name = &v
	return s
}

type UpdateMultiplexOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex object.
	Multiplex *Multiplex `locationName:"multiplex" type:"structure"`
}

// String returns the string representation
func (s UpdateMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMultiplexOutput) GoString() string {
	return s.String()
}

// SetMultiplex sets the Multiplex field's value.
func (s *UpdateMultiplexOutput) SetMultiplex(v *Multiplex) *UpdateMultiplexOutput {
	s.Multiplex = v
	return s
}

type UpdateMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}
	if s.MultiplexProgramSettings != nil {
		if err := s.MultiplexProgramSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexProgramSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *UpdateMultiplexProgramInput) SetMultiplexId(v string) *UpdateMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *UpdateMultiplexProgramInput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *UpdateMultiplexProgramInput {
	s.MultiplexProgramSettings = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *UpdateMultiplexProgramInput) SetProgramName(v string) *UpdateMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

type UpdateMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex program object.
	MultiplexProgram *MultiplexProgram `locationName:"multiplexProgram" type:"structure"`
}

// String returns the string representation
func (s UpdateMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetMultiplexProgram sets the MultiplexProgram field's value.
func (s *UpdateMultiplexProgramOutput) SetMultiplexProgram(v *MultiplexProgram) *UpdateMultiplexProgramOutput {
	s.MultiplexProgram = v
	return s
}

type UpdateReservationInput struct {
	_ struct{} `type:"structure"`

	Name *string `locationName:"name" type:"string"`

	// ReservationId is a required field
	ReservationId *string `location:"uri" locationName:"reservationId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReservationInput"}
	if s.ReservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationId"))
	}
	if s.ReservationId != nil && len(*s.ReservationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateReservationInput) SetName(v string) *UpdateReservationInput {
	s.Name = &v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *UpdateReservationInput) SetReservationId(v string) *UpdateReservationInput {
	s.ReservationId = &v
	return s
}

type UpdateReservationOutput struct {
	_ struct{} `type:"structure"`

	// Reserved resources available to use
	Reservation *Reservation `locationName:"reservation" type:"structure"`
}

// String returns the string representation
func (s UpdateReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReservationOutput) GoString() string {
	return s.String()
}

// SetReservation sets the Reservation field's value.
func (s *UpdateReservationOutput) SetReservation(v *Reservation) *UpdateReservationOutput {
	s.Reservation = v
	return s
}

type ValidationError struct {
	_ struct{} `type:"structure"`

	// Path to the source of the error.
	ElementPath *string `locationName:"elementPath" type:"string"`

	// The error message.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationError) GoString() string {
	return s.String()
}

// SetElementPath sets the ElementPath field's value.
func (s *ValidationError) SetElementPath(v string) *ValidationError {
	s.ElementPath = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ValidationError) SetErrorMessage(v string) *ValidationError {
	s.ErrorMessage = &v
	return s
}

// Video Codec Settings
type VideoCodecSettings struct {
	_ struct{} `type:"structure"`

	// Frame Capture Settings
	FrameCaptureSettings *FrameCaptureSettings `locationName:"frameCaptureSettings" type:"structure"`

	// H264 Settings
	H264Settings *H264Settings `locationName:"h264Settings" type:"structure"`

	// H265 Settings
	H265Settings *H265Settings `locationName:"h265Settings" type:"structure"`
}

// String returns the string representation
func (s VideoCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoCodecSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoCodecSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoCodecSettings"}
	if s.FrameCaptureSettings != nil {
		if err := s.FrameCaptureSettings.Validate(); err != nil {
			invalidParams.AddNested("FrameCaptureSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.H264Settings != nil {
		if err := s.H264Settings.Validate(); err != nil {
			invalidParams.AddNested("H264Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.H265Settings != nil {
		if err := s.H265Settings.Validate(); err != nil {
			invalidParams.AddNested("H265Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameCaptureSettings sets the FrameCaptureSettings field's value.
func (s *VideoCodecSettings) SetFrameCaptureSettings(v *FrameCaptureSettings) *VideoCodecSettings {
	s.FrameCaptureSettings = v
	return s
}

// SetH264Settings sets the H264Settings field's value.
func (s *VideoCodecSettings) SetH264Settings(v *H264Settings) *VideoCodecSettings {
	s.H264Settings = v
	return s
}

// SetH265Settings sets the H265Settings field's value.
func (s *VideoCodecSettings) SetH265Settings(v *H265Settings) *VideoCodecSettings {
	s.H265Settings = v
	return s
}

// Video settings for this stream.
type VideoDescription struct {
	_ struct{} `type:"structure"`

	// Video codec settings.
	CodecSettings *VideoCodecSettings `locationName:"codecSettings" type:"structure"`

	// Output video height, in pixels. Must be an even number. For most codecs,
	// you can leave this field and width blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not recommended.
	// For the Frame Capture codec, height and width are required.
	Height *int64 `locationName:"height" type:"integer"`

	// The name of this VideoDescription. Outputs will use this name to uniquely
	// identify this Description. Description names should be unique within this
	// Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Indicates how to respond to the AFD values in the input stream. RESPOND causes
	// input video to be clipped, depending on the AFD value, input display aspect
	// ratio, and output display aspect ratio, and (except for FRAME_CAPTURE codec)
	// includes the values in the output. PASSTHROUGH (does not apply to FRAME_CAPTURE
	// codec) ignores the AFD values and includes the values in the output, so input
	// video is not clipped. NONE ignores the AFD values and does not include the
	// values through to the output, so input video is not clipped.
	RespondToAfd *string `locationName:"respondToAfd" type:"string" enum:"VideoDescriptionRespondToAfd"`

	// STRETCH_TO_OUTPUT configures the output position to stretch the video to
	// the specified output resolution (height and width). This option will override
	// any position value. DEFAULT may insert black boxes (pillar boxes or letter
	// boxes) around the video to provide the specified output resolution.
	ScalingBehavior *string `locationName:"scalingBehavior" type:"string" enum:"VideoDescriptionScalingBehavior"`

	// Changes the strength of the anti-alias filter used for scaling. 0 is the
	// softest setting, 100 is the sharpest. A setting of 50 is recommended for
	// most content.
	Sharpness *int64 `locationName:"sharpness" type:"integer"`

	// Output video width, in pixels. Must be an even number. For most codecs, you
	// can leave this field and height blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not recommended.
	// For the Frame Capture codec, height and width are required.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s VideoDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoDescription"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodecSettings sets the CodecSettings field's value.
func (s *VideoDescription) SetCodecSettings(v *VideoCodecSettings) *VideoDescription {
	s.CodecSettings = v
	return s
}

// SetHeight sets the Height field's value.
func (s *VideoDescription) SetHeight(v int64) *VideoDescription {
	s.Height = &v
	return s
}

// SetName sets the Name field's value.
func (s *VideoDescription) SetName(v string) *VideoDescription {
	s.Name = &v
	return s
}

// SetRespondToAfd sets the RespondToAfd field's value.
func (s *VideoDescription) SetRespondToAfd(v string) *VideoDescription {
	s.RespondToAfd = &v
	return s
}

// SetScalingBehavior sets the ScalingBehavior field's value.
func (s *VideoDescription) SetScalingBehavior(v string) *VideoDescription {
	s.ScalingBehavior = &v
	return s
}

// SetSharpness sets the Sharpness field's value.
func (s *VideoDescription) SetSharpness(v int64) *VideoDescription {
	s.Sharpness = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *VideoDescription) SetWidth(v int64) *VideoDescription {
	s.Width = &v
	return s
}

// Specifies a particular video stream within an input source. An input may
// have only a single video selector.
type VideoSelector struct {
	_ struct{} `type:"structure"`

	// Specifies the color space of an input. This setting works in tandem with
	// colorSpaceUsage and a video description's colorSpaceSettingsChoice to determine
	// if any conversion will be performed.
	ColorSpace *string `locationName:"colorSpace" type:"string" enum:"VideoSelectorColorSpace"`

	// Applies only if colorSpace is a value other than follow. This field controls
	// how the value in the colorSpace field will be used. fallback means that when
	// the input does include color space data, that data will be used, but when
	// the input has no color space data, the value in colorSpace will be used.
	// Choose fallback if your input is sometimes missing color space data, but
	// when it does have color space data, that data is correct. force means to
	// always use the value in colorSpace. Choose force if your input usually has
	// no color space data or might have unreliable color space data.
	ColorSpaceUsage *string `locationName:"colorSpaceUsage" type:"string" enum:"VideoSelectorColorSpaceUsage"`

	// The video selector settings.
	SelectorSettings *VideoSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s VideoSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelector) GoString() string {
	return s.String()
}

// SetColorSpace sets the ColorSpace field's value.
func (s *VideoSelector) SetColorSpace(v string) *VideoSelector {
	s.ColorSpace = &v
	return s
}

// SetColorSpaceUsage sets the ColorSpaceUsage field's value.
func (s *VideoSelector) SetColorSpaceUsage(v string) *VideoSelector {
	s.ColorSpaceUsage = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *VideoSelector) SetSelectorSettings(v *VideoSelectorSettings) *VideoSelector {
	s.SelectorSettings = v
	return s
}

// Video Selector Pid
type VideoSelectorPid struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a video source.
	Pid *int64 `locationName:"pid" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorPid) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorPid) GoString() string {
	return s.String()
}

// SetPid sets the Pid field's value.
func (s *VideoSelectorPid) SetPid(v int64) *VideoSelectorPid {
	s.Pid = &v
	return s
}

// Video Selector Program Id
type VideoSelectorProgramId struct {
	_ struct{} `type:"structure"`

	// Selects a specific program from within a multi-program transport stream.
	// If the program doesn't exist, the first program within the transport stream
	// will be selected by default.
	ProgramId *int64 `locationName:"programId" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorProgramId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorProgramId) GoString() string {
	return s.String()
}

// SetProgramId sets the ProgramId field's value.
func (s *VideoSelectorProgramId) SetProgramId(v int64) *VideoSelectorProgramId {
	s.ProgramId = &v
	return s
}

// Video Selector Settings
type VideoSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Video Selector Pid
	VideoSelectorPid *VideoSelectorPid `locationName:"videoSelectorPid" type:"structure"`

	// Video Selector Program Id
	VideoSelectorProgramId *VideoSelectorProgramId `locationName:"videoSelectorProgramId" type:"structure"`
}

// String returns the string representation
func (s VideoSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorSettings) GoString() string {
	return s.String()
}

// SetVideoSelectorPid sets the VideoSelectorPid field's value.
func (s *VideoSelectorSettings) SetVideoSelectorPid(v *VideoSelectorPid) *VideoSelectorSettings {
	s.VideoSelectorPid = v
	return s
}

// SetVideoSelectorProgramId sets the VideoSelectorProgramId field's value.
func (s *VideoSelectorSettings) SetVideoSelectorProgramId(v *VideoSelectorProgramId) *VideoSelectorSettings {
	s.VideoSelectorProgramId = v
	return s
}

// Webvtt Destination Settings
type WebvttDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s WebvttDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebvttDestinationSettings) GoString() string {
	return s.String()
}

// Aac Coding Mode
const (
	// AacCodingModeAdReceiverMix is a AacCodingMode enum value
	AacCodingModeAdReceiverMix = "AD_RECEIVER_MIX"

	// AacCodingModeCodingMode10 is a AacCodingMode enum value
	AacCodingModeCodingMode10 = "CODING_MODE_1_0"

	// AacCodingModeCodingMode11 is a AacCodingMode enum value
	AacCodingModeCodingMode11 = "CODING_MODE_1_1"

	// AacCodingModeCodingMode20 is a AacCodingMode enum value
	AacCodingModeCodingMode20 = "CODING_MODE_2_0"

	// AacCodingModeCodingMode51 is a AacCodingMode enum value
	AacCodingModeCodingMode51 = "CODING_MODE_5_1"
)

// AacCodingMode_Values returns all elements of the AacCodingMode enum
func AacCodingMode_Values() []string {
	return []string{
		AacCodingModeAdReceiverMix,
		AacCodingModeCodingMode10,
		AacCodingModeCodingMode11,
		AacCodingModeCodingMode20,
		AacCodingModeCodingMode51,
	}
}

// Aac Input Type
const (
	// AacInputTypeBroadcasterMixedAd is a AacInputType enum value
	AacInputTypeBroadcasterMixedAd = "BROADCASTER_MIXED_AD"

	// AacInputTypeNormal is a AacInputType enum value
	AacInputTypeNormal = "NORMAL"
)

// AacInputType_Values returns all elements of the AacInputType enum
func AacInputType_Values() []string {
	return []string{
		AacInputTypeBroadcasterMixedAd,
		AacInputTypeNormal,
	}
}

// Aac Profile
const (
	// AacProfileHev1 is a AacProfile enum value
	AacProfileHev1 = "HEV1"

	// AacProfileHev2 is a AacProfile enum value
	AacProfileHev2 = "HEV2"

	// AacProfileLc is a AacProfile enum value
	AacProfileLc = "LC"
)

// AacProfile_Values returns all elements of the AacProfile enum
func AacProfile_Values() []string {
	return []string{
		AacProfileHev1,
		AacProfileHev2,
		AacProfileLc,
	}
}

// Aac Rate Control Mode
const (
	// AacRateControlModeCbr is a AacRateControlMode enum value
	AacRateControlModeCbr = "CBR"

	// AacRateControlModeVbr is a AacRateControlMode enum value
	AacRateControlModeVbr = "VBR"
)

// AacRateControlMode_Values returns all elements of the AacRateControlMode enum
func AacRateControlMode_Values() []string {
	return []string{
		AacRateControlModeCbr,
		AacRateControlModeVbr,
	}
}

// Aac Raw Format
const (
	// AacRawFormatLatmLoas is a AacRawFormat enum value
	AacRawFormatLatmLoas = "LATM_LOAS"

	// AacRawFormatNone is a AacRawFormat enum value
	AacRawFormatNone = "NONE"
)

// AacRawFormat_Values returns all elements of the AacRawFormat enum
func AacRawFormat_Values() []string {
	return []string{
		AacRawFormatLatmLoas,
		AacRawFormatNone,
	}
}

// Aac Spec
const (
	// AacSpecMpeg2 is a AacSpec enum value
	AacSpecMpeg2 = "MPEG2"

	// AacSpecMpeg4 is a AacSpec enum value
	AacSpecMpeg4 = "MPEG4"
)

// AacSpec_Values returns all elements of the AacSpec enum
func AacSpec_Values() []string {
	return []string{
		AacSpecMpeg2,
		AacSpecMpeg4,
	}
}

// Aac Vbr Quality
const (
	// AacVbrQualityHigh is a AacVbrQuality enum value
	AacVbrQualityHigh = "HIGH"

	// AacVbrQualityLow is a AacVbrQuality enum value
	AacVbrQualityLow = "LOW"

	// AacVbrQualityMediumHigh is a AacVbrQuality enum value
	AacVbrQualityMediumHigh = "MEDIUM_HIGH"

	// AacVbrQualityMediumLow is a AacVbrQuality enum value
	AacVbrQualityMediumLow = "MEDIUM_LOW"
)

// AacVbrQuality_Values returns all elements of the AacVbrQuality enum
func AacVbrQuality_Values() []string {
	return []string{
		AacVbrQualityHigh,
		AacVbrQualityLow,
		AacVbrQualityMediumHigh,
		AacVbrQualityMediumLow,
	}
}

// Ac3 Bitstream Mode
const (
	// Ac3BitstreamModeCommentary is a Ac3BitstreamMode enum value
	Ac3BitstreamModeCommentary = "COMMENTARY"

	// Ac3BitstreamModeCompleteMain is a Ac3BitstreamMode enum value
	Ac3BitstreamModeCompleteMain = "COMPLETE_MAIN"

	// Ac3BitstreamModeDialogue is a Ac3BitstreamMode enum value
	Ac3BitstreamModeDialogue = "DIALOGUE"

	// Ac3BitstreamModeEmergency is a Ac3BitstreamMode enum value
	Ac3BitstreamModeEmergency = "EMERGENCY"

	// Ac3BitstreamModeHearingImpaired is a Ac3BitstreamMode enum value
	Ac3BitstreamModeHearingImpaired = "HEARING_IMPAIRED"

	// Ac3BitstreamModeMusicAndEffects is a Ac3BitstreamMode enum value
	Ac3BitstreamModeMusicAndEffects = "MUSIC_AND_EFFECTS"

	// Ac3BitstreamModeVisuallyImpaired is a Ac3BitstreamMode enum value
	Ac3BitstreamModeVisuallyImpaired = "VISUALLY_IMPAIRED"

	// Ac3BitstreamModeVoiceOver is a Ac3BitstreamMode enum value
	Ac3BitstreamModeVoiceOver = "VOICE_OVER"
)

// Ac3BitstreamMode_Values returns all elements of the Ac3BitstreamMode enum
func Ac3BitstreamMode_Values() []string {
	return []string{
		Ac3BitstreamModeCommentary,
		Ac3BitstreamModeCompleteMain,
		Ac3BitstreamModeDialogue,
		Ac3BitstreamModeEmergency,
		Ac3BitstreamModeHearingImpaired,
		Ac3BitstreamModeMusicAndEffects,
		Ac3BitstreamModeVisuallyImpaired,
		Ac3BitstreamModeVoiceOver,
	}
}

// Ac3 Coding Mode
const (
	// Ac3CodingModeCodingMode10 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Ac3CodingModeCodingMode11 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode11 = "CODING_MODE_1_1"

	// Ac3CodingModeCodingMode20 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode20 = "CODING_MODE_2_0"

	// Ac3CodingModeCodingMode32Lfe is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode32Lfe = "CODING_MODE_3_2_LFE"
)

// Ac3CodingMode_Values returns all elements of the Ac3CodingMode enum
func Ac3CodingMode_Values() []string {
	return []string{
		Ac3CodingModeCodingMode10,
		Ac3CodingModeCodingMode11,
		Ac3CodingModeCodingMode20,
		Ac3CodingModeCodingMode32Lfe,
	}
}

// Ac3 Drc Profile
const (
	// Ac3DrcProfileFilmStandard is a Ac3DrcProfile enum value
	Ac3DrcProfileFilmStandard = "FILM_STANDARD"

	// Ac3DrcProfileNone is a Ac3DrcProfile enum value
	Ac3DrcProfileNone = "NONE"
)

// Ac3DrcProfile_Values returns all elements of the Ac3DrcProfile enum
func Ac3DrcProfile_Values() []string {
	return []string{
		Ac3DrcProfileFilmStandard,
		Ac3DrcProfileNone,
	}
}

// Ac3 Lfe Filter
const (
	// Ac3LfeFilterDisabled is a Ac3LfeFilter enum value
	Ac3LfeFilterDisabled = "DISABLED"

	// Ac3LfeFilterEnabled is a Ac3LfeFilter enum value
	Ac3LfeFilterEnabled = "ENABLED"
)

// Ac3LfeFilter_Values returns all elements of the Ac3LfeFilter enum
func Ac3LfeFilter_Values() []string {
	return []string{
		Ac3LfeFilterDisabled,
		Ac3LfeFilterEnabled,
	}
}

// Ac3 Metadata Control
const (
	// Ac3MetadataControlFollowInput is a Ac3MetadataControl enum value
	Ac3MetadataControlFollowInput = "FOLLOW_INPUT"

	// Ac3MetadataControlUseConfigured is a Ac3MetadataControl enum value
	Ac3MetadataControlUseConfigured = "USE_CONFIGURED"
)

// Ac3MetadataControl_Values returns all elements of the Ac3MetadataControl enum
func Ac3MetadataControl_Values() []string {
	return []string{
		Ac3MetadataControlFollowInput,
		Ac3MetadataControlUseConfigured,
	}
}

// Accept Header
const (
	// AcceptHeaderImageJpeg is a AcceptHeader enum value
	AcceptHeaderImageJpeg = "image/jpeg"
)

// AcceptHeader_Values returns all elements of the AcceptHeader enum
func AcceptHeader_Values() []string {
	return []string{
		AcceptHeaderImageJpeg,
	}
}

// Afd Signaling
const (
	// AfdSignalingAuto is a AfdSignaling enum value
	AfdSignalingAuto = "AUTO"

	// AfdSignalingFixed is a AfdSignaling enum value
	AfdSignalingFixed = "FIXED"

	// AfdSignalingNone is a AfdSignaling enum value
	AfdSignalingNone = "NONE"
)

// AfdSignaling_Values returns all elements of the AfdSignaling enum
func AfdSignaling_Values() []string {
	return []string{
		AfdSignalingAuto,
		AfdSignalingFixed,
		AfdSignalingNone,
	}
}

// Audio Description Audio Type Control
const (
	// AudioDescriptionAudioTypeControlFollowInput is a AudioDescriptionAudioTypeControl enum value
	AudioDescriptionAudioTypeControlFollowInput = "FOLLOW_INPUT"

	// AudioDescriptionAudioTypeControlUseConfigured is a AudioDescriptionAudioTypeControl enum value
	AudioDescriptionAudioTypeControlUseConfigured = "USE_CONFIGURED"
)

// AudioDescriptionAudioTypeControl_Values returns all elements of the AudioDescriptionAudioTypeControl enum
func AudioDescriptionAudioTypeControl_Values() []string {
	return []string{
		AudioDescriptionAudioTypeControlFollowInput,
		AudioDescriptionAudioTypeControlUseConfigured,
	}
}

// Audio Description Language Code Control
const (
	// AudioDescriptionLanguageCodeControlFollowInput is a AudioDescriptionLanguageCodeControl enum value
	AudioDescriptionLanguageCodeControlFollowInput = "FOLLOW_INPUT"

	// AudioDescriptionLanguageCodeControlUseConfigured is a AudioDescriptionLanguageCodeControl enum value
	AudioDescriptionLanguageCodeControlUseConfigured = "USE_CONFIGURED"
)

// AudioDescriptionLanguageCodeControl_Values returns all elements of the AudioDescriptionLanguageCodeControl enum
func AudioDescriptionLanguageCodeControl_Values() []string {
	return []string{
		AudioDescriptionLanguageCodeControlFollowInput,
		AudioDescriptionLanguageCodeControlUseConfigured,
	}
}

// Audio Language Selection Policy
const (
	// AudioLanguageSelectionPolicyLoose is a AudioLanguageSelectionPolicy enum value
	AudioLanguageSelectionPolicyLoose = "LOOSE"

	// AudioLanguageSelectionPolicyStrict is a AudioLanguageSelectionPolicy enum value
	AudioLanguageSelectionPolicyStrict = "STRICT"
)

// AudioLanguageSelectionPolicy_Values returns all elements of the AudioLanguageSelectionPolicy enum
func AudioLanguageSelectionPolicy_Values() []string {
	return []string{
		AudioLanguageSelectionPolicyLoose,
		AudioLanguageSelectionPolicyStrict,
	}
}

// Audio Normalization Algorithm
const (
	// AudioNormalizationAlgorithmItu17701 is a AudioNormalizationAlgorithm enum value
	AudioNormalizationAlgorithmItu17701 = "ITU_1770_1"

	// AudioNormalizationAlgorithmItu17702 is a AudioNormalizationAlgorithm enum value
	AudioNormalizationAlgorithmItu17702 = "ITU_1770_2"
)

// AudioNormalizationAlgorithm_Values returns all elements of the AudioNormalizationAlgorithm enum
func AudioNormalizationAlgorithm_Values() []string {
	return []string{
		AudioNormalizationAlgorithmItu17701,
		AudioNormalizationAlgorithmItu17702,
	}
}

// Audio Normalization Algorithm Control
const (
	// AudioNormalizationAlgorithmControlCorrectAudio is a AudioNormalizationAlgorithmControl enum value
	AudioNormalizationAlgorithmControlCorrectAudio = "CORRECT_AUDIO"
)

// AudioNormalizationAlgorithmControl_Values returns all elements of the AudioNormalizationAlgorithmControl enum
func AudioNormalizationAlgorithmControl_Values() []string {
	return []string{
		AudioNormalizationAlgorithmControlCorrectAudio,
	}
}

// Audio Only Hls Segment Type
const (
	// AudioOnlyHlsSegmentTypeAac is a AudioOnlyHlsSegmentType enum value
	AudioOnlyHlsSegmentTypeAac = "AAC"

	// AudioOnlyHlsSegmentTypeFmp4 is a AudioOnlyHlsSegmentType enum value
	AudioOnlyHlsSegmentTypeFmp4 = "FMP4"
)

// AudioOnlyHlsSegmentType_Values returns all elements of the AudioOnlyHlsSegmentType enum
func AudioOnlyHlsSegmentType_Values() []string {
	return []string{
		AudioOnlyHlsSegmentTypeAac,
		AudioOnlyHlsSegmentTypeFmp4,
	}
}

// Audio Only Hls Track Type
const (
	// AudioOnlyHlsTrackTypeAlternateAudioAutoSelect is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioAutoSelect = "ALTERNATE_AUDIO_AUTO_SELECT"

	// AudioOnlyHlsTrackTypeAlternateAudioAutoSelectDefault is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioAutoSelectDefault = "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"

	// AudioOnlyHlsTrackTypeAlternateAudioNotAutoSelect is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioNotAutoSelect = "ALTERNATE_AUDIO_NOT_AUTO_SELECT"

	// AudioOnlyHlsTrackTypeAudioOnlyVariantStream is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAudioOnlyVariantStream = "AUDIO_ONLY_VARIANT_STREAM"
)

// AudioOnlyHlsTrackType_Values returns all elements of the AudioOnlyHlsTrackType enum
func AudioOnlyHlsTrackType_Values() []string {
	return []string{
		AudioOnlyHlsTrackTypeAlternateAudioAutoSelect,
		AudioOnlyHlsTrackTypeAlternateAudioAutoSelectDefault,
		AudioOnlyHlsTrackTypeAlternateAudioNotAutoSelect,
		AudioOnlyHlsTrackTypeAudioOnlyVariantStream,
	}
}

// Audio Type
const (
	// AudioTypeCleanEffects is a AudioType enum value
	AudioTypeCleanEffects = "CLEAN_EFFECTS"

	// AudioTypeHearingImpaired is a AudioType enum value
	AudioTypeHearingImpaired = "HEARING_IMPAIRED"

	// AudioTypeUndefined is a AudioType enum value
	AudioTypeUndefined = "UNDEFINED"

	// AudioTypeVisualImpairedCommentary is a AudioType enum value
	AudioTypeVisualImpairedCommentary = "VISUAL_IMPAIRED_COMMENTARY"
)

// AudioType_Values returns all elements of the AudioType enum
func AudioType_Values() []string {
	return []string{
		AudioTypeCleanEffects,
		AudioTypeHearingImpaired,
		AudioTypeUndefined,
		AudioTypeVisualImpairedCommentary,
	}
}

// Authentication Scheme
const (
	// AuthenticationSchemeAkamai is a AuthenticationScheme enum value
	AuthenticationSchemeAkamai = "AKAMAI"

	// AuthenticationSchemeCommon is a AuthenticationScheme enum value
	AuthenticationSchemeCommon = "COMMON"
)

// AuthenticationScheme_Values returns all elements of the AuthenticationScheme enum
func AuthenticationScheme_Values() []string {
	return []string{
		AuthenticationSchemeAkamai,
		AuthenticationSchemeCommon,
	}
}

// Avail Blanking State
const (
	// AvailBlankingStateDisabled is a AvailBlankingState enum value
	AvailBlankingStateDisabled = "DISABLED"

	// AvailBlankingStateEnabled is a AvailBlankingState enum value
	AvailBlankingStateEnabled = "ENABLED"
)

// AvailBlankingState_Values returns all elements of the AvailBlankingState enum
func AvailBlankingState_Values() []string {
	return []string{
		AvailBlankingStateDisabled,
		AvailBlankingStateEnabled,
	}
}

// Blackout Slate Network End Blackout
const (
	// BlackoutSlateNetworkEndBlackoutDisabled is a BlackoutSlateNetworkEndBlackout enum value
	BlackoutSlateNetworkEndBlackoutDisabled = "DISABLED"

	// BlackoutSlateNetworkEndBlackoutEnabled is a BlackoutSlateNetworkEndBlackout enum value
	BlackoutSlateNetworkEndBlackoutEnabled = "ENABLED"
)

// BlackoutSlateNetworkEndBlackout_Values returns all elements of the BlackoutSlateNetworkEndBlackout enum
func BlackoutSlateNetworkEndBlackout_Values() []string {
	return []string{
		BlackoutSlateNetworkEndBlackoutDisabled,
		BlackoutSlateNetworkEndBlackoutEnabled,
	}
}

// Blackout Slate State
const (
	// BlackoutSlateStateDisabled is a BlackoutSlateState enum value
	BlackoutSlateStateDisabled = "DISABLED"

	// BlackoutSlateStateEnabled is a BlackoutSlateState enum value
	BlackoutSlateStateEnabled = "ENABLED"
)

// BlackoutSlateState_Values returns all elements of the BlackoutSlateState enum
func BlackoutSlateState_Values() []string {
	return []string{
		BlackoutSlateStateDisabled,
		BlackoutSlateStateEnabled,
	}
}

// Burn In Alignment
const (
	// BurnInAlignmentCentered is a BurnInAlignment enum value
	BurnInAlignmentCentered = "CENTERED"

	// BurnInAlignmentLeft is a BurnInAlignment enum value
	BurnInAlignmentLeft = "LEFT"

	// BurnInAlignmentSmart is a BurnInAlignment enum value
	BurnInAlignmentSmart = "SMART"
)

// BurnInAlignment_Values returns all elements of the BurnInAlignment enum
func BurnInAlignment_Values() []string {
	return []string{
		BurnInAlignmentCentered,
		BurnInAlignmentLeft,
		BurnInAlignmentSmart,
	}
}

// Burn In Background Color
const (
	// BurnInBackgroundColorBlack is a BurnInBackgroundColor enum value
	BurnInBackgroundColorBlack = "BLACK"

	// BurnInBackgroundColorNone is a BurnInBackgroundColor enum value
	BurnInBackgroundColorNone = "NONE"

	// BurnInBackgroundColorWhite is a BurnInBackgroundColor enum value
	BurnInBackgroundColorWhite = "WHITE"
)

// BurnInBackgroundColor_Values returns all elements of the BurnInBackgroundColor enum
func BurnInBackgroundColor_Values() []string {
	return []string{
		BurnInBackgroundColorBlack,
		BurnInBackgroundColorNone,
		BurnInBackgroundColorWhite,
	}
}

// Burn In Font Color
const (
	// BurnInFontColorBlack is a BurnInFontColor enum value
	BurnInFontColorBlack = "BLACK"

	// BurnInFontColorBlue is a BurnInFontColor enum value
	BurnInFontColorBlue = "BLUE"

	// BurnInFontColorGreen is a BurnInFontColor enum value
	BurnInFontColorGreen = "GREEN"

	// BurnInFontColorRed is a BurnInFontColor enum value
	BurnInFontColorRed = "RED"

	// BurnInFontColorWhite is a BurnInFontColor enum value
	BurnInFontColorWhite = "WHITE"

	// BurnInFontColorYellow is a BurnInFontColor enum value
	BurnInFontColorYellow = "YELLOW"
)

// BurnInFontColor_Values returns all elements of the BurnInFontColor enum
func BurnInFontColor_Values() []string {
	return []string{
		BurnInFontColorBlack,
		BurnInFontColorBlue,
		BurnInFontColorGreen,
		BurnInFontColorRed,
		BurnInFontColorWhite,
		BurnInFontColorYellow,
	}
}

// Burn In Outline Color
const (
	// BurnInOutlineColorBlack is a BurnInOutlineColor enum value
	BurnInOutlineColorBlack = "BLACK"

	// BurnInOutlineColorBlue is a BurnInOutlineColor enum value
	BurnInOutlineColorBlue = "BLUE"

	// BurnInOutlineColorGreen is a BurnInOutlineColor enum value
	BurnInOutlineColorGreen = "GREEN"

	// BurnInOutlineColorRed is a BurnInOutlineColor enum value
	BurnInOutlineColorRed = "RED"

	// BurnInOutlineColorWhite is a BurnInOutlineColor enum value
	BurnInOutlineColorWhite = "WHITE"

	// BurnInOutlineColorYellow is a BurnInOutlineColor enum value
	BurnInOutlineColorYellow = "YELLOW"
)

// BurnInOutlineColor_Values returns all elements of the BurnInOutlineColor enum
func BurnInOutlineColor_Values() []string {
	return []string{
		BurnInOutlineColorBlack,
		BurnInOutlineColorBlue,
		BurnInOutlineColorGreen,
		BurnInOutlineColorRed,
		BurnInOutlineColorWhite,
		BurnInOutlineColorYellow,
	}
}

// Burn In Shadow Color
const (
	// BurnInShadowColorBlack is a BurnInShadowColor enum value
	BurnInShadowColorBlack = "BLACK"

	// BurnInShadowColorNone is a BurnInShadowColor enum value
	BurnInShadowColorNone = "NONE"

	// BurnInShadowColorWhite is a BurnInShadowColor enum value
	BurnInShadowColorWhite = "WHITE"
)

// BurnInShadowColor_Values returns all elements of the BurnInShadowColor enum
func BurnInShadowColor_Values() []string {
	return []string{
		BurnInShadowColorBlack,
		BurnInShadowColorNone,
		BurnInShadowColorWhite,
	}
}

// Burn In Teletext Grid Control
const (
	// BurnInTeletextGridControlFixed is a BurnInTeletextGridControl enum value
	BurnInTeletextGridControlFixed = "FIXED"

	// BurnInTeletextGridControlScaled is a BurnInTeletextGridControl enum value
	BurnInTeletextGridControlScaled = "SCALED"
)

// BurnInTeletextGridControl_Values returns all elements of the BurnInTeletextGridControl enum
func BurnInTeletextGridControl_Values() []string {
	return []string{
		BurnInTeletextGridControlFixed,
		BurnInTeletextGridControlScaled,
	}
}

// A standard channel has two encoding pipelines and a single pipeline channel
// only has one.
const (
	// ChannelClassStandard is a ChannelClass enum value
	ChannelClassStandard = "STANDARD"

	// ChannelClassSinglePipeline is a ChannelClass enum value
	ChannelClassSinglePipeline = "SINGLE_PIPELINE"
)

// ChannelClass_Values returns all elements of the ChannelClass enum
func ChannelClass_Values() []string {
	return []string{
		ChannelClassStandard,
		ChannelClassSinglePipeline,
	}
}

const (
	// ChannelStateCreating is a ChannelState enum value
	ChannelStateCreating = "CREATING"

	// ChannelStateCreateFailed is a ChannelState enum value
	ChannelStateCreateFailed = "CREATE_FAILED"

	// ChannelStateIdle is a ChannelState enum value
	ChannelStateIdle = "IDLE"

	// ChannelStateStarting is a ChannelState enum value
	ChannelStateStarting = "STARTING"

	// ChannelStateRunning is a ChannelState enum value
	ChannelStateRunning = "RUNNING"

	// ChannelStateRecovering is a ChannelState enum value
	ChannelStateRecovering = "RECOVERING"

	// ChannelStateStopping is a ChannelState enum value
	ChannelStateStopping = "STOPPING"

	// ChannelStateDeleting is a ChannelState enum value
	ChannelStateDeleting = "DELETING"

	// ChannelStateDeleted is a ChannelState enum value
	ChannelStateDeleted = "DELETED"

	// ChannelStateUpdating is a ChannelState enum value
	ChannelStateUpdating = "UPDATING"

	// ChannelStateUpdateFailed is a ChannelState enum value
	ChannelStateUpdateFailed = "UPDATE_FAILED"
)

// ChannelState_Values returns all elements of the ChannelState enum
func ChannelState_Values() []string {
	return []string{
		ChannelStateCreating,
		ChannelStateCreateFailed,
		ChannelStateIdle,
		ChannelStateStarting,
		ChannelStateRunning,
		ChannelStateRecovering,
		ChannelStateStopping,
		ChannelStateDeleting,
		ChannelStateDeleted,
		ChannelStateUpdating,
		ChannelStateUpdateFailed,
	}
}

const (
	// ContentTypeImageJpeg is a ContentType enum value
	ContentTypeImageJpeg = "image/jpeg"
)

// ContentType_Values returns all elements of the ContentType enum
func ContentType_Values() []string {
	return []string{
		ContentTypeImageJpeg,
	}
}

// The status of the action to synchronize the device configuration. If you
// change the configuration of the input device (for example, the maximum bitrate),
// MediaLive sends the new data to the device. The device might not update itself
// immediately. SYNCED means the device has updated its configuration. SYNCING
// means that it has not updated its configuration.
const (
	// DeviceSettingsSyncStateSynced is a DeviceSettingsSyncState enum value
	DeviceSettingsSyncStateSynced = "SYNCED"

	// DeviceSettingsSyncStateSyncing is a DeviceSettingsSyncState enum value
	DeviceSettingsSyncStateSyncing = "SYNCING"
)

// DeviceSettingsSyncState_Values returns all elements of the DeviceSettingsSyncState enum
func DeviceSettingsSyncState_Values() []string {
	return []string{
		DeviceSettingsSyncStateSynced,
		DeviceSettingsSyncStateSyncing,
	}
}

// Dvb Sdt Output Sdt
const (
	// DvbSdtOutputSdtSdtFollow is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtFollow = "SDT_FOLLOW"

	// DvbSdtOutputSdtSdtFollowIfPresent is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtFollowIfPresent = "SDT_FOLLOW_IF_PRESENT"

	// DvbSdtOutputSdtSdtManual is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtManual = "SDT_MANUAL"

	// DvbSdtOutputSdtSdtNone is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtNone = "SDT_NONE"
)

// DvbSdtOutputSdt_Values returns all elements of the DvbSdtOutputSdt enum
func DvbSdtOutputSdt_Values() []string {
	return []string{
		DvbSdtOutputSdtSdtFollow,
		DvbSdtOutputSdtSdtFollowIfPresent,
		DvbSdtOutputSdtSdtManual,
		DvbSdtOutputSdtSdtNone,
	}
}

// Dvb Sub Destination Alignment
const (
	// DvbSubDestinationAlignmentCentered is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentCentered = "CENTERED"

	// DvbSubDestinationAlignmentLeft is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentLeft = "LEFT"

	// DvbSubDestinationAlignmentSmart is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentSmart = "SMART"
)

// DvbSubDestinationAlignment_Values returns all elements of the DvbSubDestinationAlignment enum
func DvbSubDestinationAlignment_Values() []string {
	return []string{
		DvbSubDestinationAlignmentCentered,
		DvbSubDestinationAlignmentLeft,
		DvbSubDestinationAlignmentSmart,
	}
}

// Dvb Sub Destination Background Color
const (
	// DvbSubDestinationBackgroundColorBlack is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorBlack = "BLACK"

	// DvbSubDestinationBackgroundColorNone is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorNone = "NONE"

	// DvbSubDestinationBackgroundColorWhite is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorWhite = "WHITE"
)

// DvbSubDestinationBackgroundColor_Values returns all elements of the DvbSubDestinationBackgroundColor enum
func DvbSubDestinationBackgroundColor_Values() []string {
	return []string{
		DvbSubDestinationBackgroundColorBlack,
		DvbSubDestinationBackgroundColorNone,
		DvbSubDestinationBackgroundColorWhite,
	}
}

// Dvb Sub Destination Font Color
const (
	// DvbSubDestinationFontColorBlack is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorBlack = "BLACK"

	// DvbSubDestinationFontColorBlue is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorBlue = "BLUE"

	// DvbSubDestinationFontColorGreen is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorGreen = "GREEN"

	// DvbSubDestinationFontColorRed is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorRed = "RED"

	// DvbSubDestinationFontColorWhite is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorWhite = "WHITE"

	// DvbSubDestinationFontColorYellow is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorYellow = "YELLOW"
)

// DvbSubDestinationFontColor_Values returns all elements of the DvbSubDestinationFontColor enum
func DvbSubDestinationFontColor_Values() []string {
	return []string{
		DvbSubDestinationFontColorBlack,
		DvbSubDestinationFontColorBlue,
		DvbSubDestinationFontColorGreen,
		DvbSubDestinationFontColorRed,
		DvbSubDestinationFontColorWhite,
		DvbSubDestinationFontColorYellow,
	}
}

// Dvb Sub Destination Outline Color
const (
	// DvbSubDestinationOutlineColorBlack is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorBlack = "BLACK"

	// DvbSubDestinationOutlineColorBlue is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorBlue = "BLUE"

	// DvbSubDestinationOutlineColorGreen is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorGreen = "GREEN"

	// DvbSubDestinationOutlineColorRed is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorRed = "RED"

	// DvbSubDestinationOutlineColorWhite is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorWhite = "WHITE"

	// DvbSubDestinationOutlineColorYellow is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorYellow = "YELLOW"
)

// DvbSubDestinationOutlineColor_Values returns all elements of the DvbSubDestinationOutlineColor enum
func DvbSubDestinationOutlineColor_Values() []string {
	return []string{
		DvbSubDestinationOutlineColorBlack,
		DvbSubDestinationOutlineColorBlue,
		DvbSubDestinationOutlineColorGreen,
		DvbSubDestinationOutlineColorRed,
		DvbSubDestinationOutlineColorWhite,
		DvbSubDestinationOutlineColorYellow,
	}
}

// Dvb Sub Destination Shadow Color
const (
	// DvbSubDestinationShadowColorBlack is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorBlack = "BLACK"

	// DvbSubDestinationShadowColorNone is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorNone = "NONE"

	// DvbSubDestinationShadowColorWhite is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorWhite = "WHITE"
)

// DvbSubDestinationShadowColor_Values returns all elements of the DvbSubDestinationShadowColor enum
func DvbSubDestinationShadowColor_Values() []string {
	return []string{
		DvbSubDestinationShadowColorBlack,
		DvbSubDestinationShadowColorNone,
		DvbSubDestinationShadowColorWhite,
	}
}

// Dvb Sub Destination Teletext Grid Control
const (
	// DvbSubDestinationTeletextGridControlFixed is a DvbSubDestinationTeletextGridControl enum value
	DvbSubDestinationTeletextGridControlFixed = "FIXED"

	// DvbSubDestinationTeletextGridControlScaled is a DvbSubDestinationTeletextGridControl enum value
	DvbSubDestinationTeletextGridControlScaled = "SCALED"
)

// DvbSubDestinationTeletextGridControl_Values returns all elements of the DvbSubDestinationTeletextGridControl enum
func DvbSubDestinationTeletextGridControl_Values() []string {
	return []string{
		DvbSubDestinationTeletextGridControlFixed,
		DvbSubDestinationTeletextGridControlScaled,
	}
}

// Eac3 Attenuation Control
const (
	// Eac3AttenuationControlAttenuate3Db is a Eac3AttenuationControl enum value
	Eac3AttenuationControlAttenuate3Db = "ATTENUATE_3_DB"

	// Eac3AttenuationControlNone is a Eac3AttenuationControl enum value
	Eac3AttenuationControlNone = "NONE"
)

// Eac3AttenuationControl_Values returns all elements of the Eac3AttenuationControl enum
func Eac3AttenuationControl_Values() []string {
	return []string{
		Eac3AttenuationControlAttenuate3Db,
		Eac3AttenuationControlNone,
	}
}

// Eac3 Bitstream Mode
const (
	// Eac3BitstreamModeCommentary is a Eac3BitstreamMode enum value
	Eac3BitstreamModeCommentary = "COMMENTARY"

	// Eac3BitstreamModeCompleteMain is a Eac3BitstreamMode enum value
	Eac3BitstreamModeCompleteMain = "COMPLETE_MAIN"

	// Eac3BitstreamModeEmergency is a Eac3BitstreamMode enum value
	Eac3BitstreamModeEmergency = "EMERGENCY"

	// Eac3BitstreamModeHearingImpaired is a Eac3BitstreamMode enum value
	Eac3BitstreamModeHearingImpaired = "HEARING_IMPAIRED"

	// Eac3BitstreamModeVisuallyImpaired is a Eac3BitstreamMode enum value
	Eac3BitstreamModeVisuallyImpaired = "VISUALLY_IMPAIRED"
)

// Eac3BitstreamMode_Values returns all elements of the Eac3BitstreamMode enum
func Eac3BitstreamMode_Values() []string {
	return []string{
		Eac3BitstreamModeCommentary,
		Eac3BitstreamModeCompleteMain,
		Eac3BitstreamModeEmergency,
		Eac3BitstreamModeHearingImpaired,
		Eac3BitstreamModeVisuallyImpaired,
	}
}

// Eac3 Coding Mode
const (
	// Eac3CodingModeCodingMode10 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Eac3CodingModeCodingMode20 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode20 = "CODING_MODE_2_0"

	// Eac3CodingModeCodingMode32 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode32 = "CODING_MODE_3_2"
)

// Eac3CodingMode_Values returns all elements of the Eac3CodingMode enum
func Eac3CodingMode_Values() []string {
	return []string{
		Eac3CodingModeCodingMode10,
		Eac3CodingModeCodingMode20,
		Eac3CodingModeCodingMode32,
	}
}

// Eac3 Dc Filter
const (
	// Eac3DcFilterDisabled is a Eac3DcFilter enum value
	Eac3DcFilterDisabled = "DISABLED"

	// Eac3DcFilterEnabled is a Eac3DcFilter enum value
	Eac3DcFilterEnabled = "ENABLED"
)

// Eac3DcFilter_Values returns all elements of the Eac3DcFilter enum
func Eac3DcFilter_Values() []string {
	return []string{
		Eac3DcFilterDisabled,
		Eac3DcFilterEnabled,
	}
}

// Eac3 Drc Line
const (
	// Eac3DrcLineFilmLight is a Eac3DrcLine enum value
	Eac3DrcLineFilmLight = "FILM_LIGHT"

	// Eac3DrcLineFilmStandard is a Eac3DrcLine enum value
	Eac3DrcLineFilmStandard = "FILM_STANDARD"

	// Eac3DrcLineMusicLight is a Eac3DrcLine enum value
	Eac3DrcLineMusicLight = "MUSIC_LIGHT"

	// Eac3DrcLineMusicStandard is a Eac3DrcLine enum value
	Eac3DrcLineMusicStandard = "MUSIC_STANDARD"

	// Eac3DrcLineNone is a Eac3DrcLine enum value
	Eac3DrcLineNone = "NONE"

	// Eac3DrcLineSpeech is a Eac3DrcLine enum value
	Eac3DrcLineSpeech = "SPEECH"
)

// Eac3DrcLine_Values returns all elements of the Eac3DrcLine enum
func Eac3DrcLine_Values() []string {
	return []string{
		Eac3DrcLineFilmLight,
		Eac3DrcLineFilmStandard,
		Eac3DrcLineMusicLight,
		Eac3DrcLineMusicStandard,
		Eac3DrcLineNone,
		Eac3DrcLineSpeech,
	}
}

// Eac3 Drc Rf
const (
	// Eac3DrcRfFilmLight is a Eac3DrcRf enum value
	Eac3DrcRfFilmLight = "FILM_LIGHT"

	// Eac3DrcRfFilmStandard is a Eac3DrcRf enum value
	Eac3DrcRfFilmStandard = "FILM_STANDARD"

	// Eac3DrcRfMusicLight is a Eac3DrcRf enum value
	Eac3DrcRfMusicLight = "MUSIC_LIGHT"

	// Eac3DrcRfMusicStandard is a Eac3DrcRf enum value
	Eac3DrcRfMusicStandard = "MUSIC_STANDARD"

	// Eac3DrcRfNone is a Eac3DrcRf enum value
	Eac3DrcRfNone = "NONE"

	// Eac3DrcRfSpeech is a Eac3DrcRf enum value
	Eac3DrcRfSpeech = "SPEECH"
)

// Eac3DrcRf_Values returns all elements of the Eac3DrcRf enum
func Eac3DrcRf_Values() []string {
	return []string{
		Eac3DrcRfFilmLight,
		Eac3DrcRfFilmStandard,
		Eac3DrcRfMusicLight,
		Eac3DrcRfMusicStandard,
		Eac3DrcRfNone,
		Eac3DrcRfSpeech,
	}
}

// Eac3 Lfe Control
const (
	// Eac3LfeControlLfe is a Eac3LfeControl enum value
	Eac3LfeControlLfe = "LFE"

	// Eac3LfeControlNoLfe is a Eac3LfeControl enum value
	Eac3LfeControlNoLfe = "NO_LFE"
)

// Eac3LfeControl_Values returns all elements of the Eac3LfeControl enum
func Eac3LfeControl_Values() []string {
	return []string{
		Eac3LfeControlLfe,
		Eac3LfeControlNoLfe,
	}
}

// Eac3 Lfe Filter
const (
	// Eac3LfeFilterDisabled is a Eac3LfeFilter enum value
	Eac3LfeFilterDisabled = "DISABLED"

	// Eac3LfeFilterEnabled is a Eac3LfeFilter enum value
	Eac3LfeFilterEnabled = "ENABLED"
)

// Eac3LfeFilter_Values returns all elements of the Eac3LfeFilter enum
func Eac3LfeFilter_Values() []string {
	return []string{
		Eac3LfeFilterDisabled,
		Eac3LfeFilterEnabled,
	}
}

// Eac3 Metadata Control
const (
	// Eac3MetadataControlFollowInput is a Eac3MetadataControl enum value
	Eac3MetadataControlFollowInput = "FOLLOW_INPUT"

	// Eac3MetadataControlUseConfigured is a Eac3MetadataControl enum value
	Eac3MetadataControlUseConfigured = "USE_CONFIGURED"
)

// Eac3MetadataControl_Values returns all elements of the Eac3MetadataControl enum
func Eac3MetadataControl_Values() []string {
	return []string{
		Eac3MetadataControlFollowInput,
		Eac3MetadataControlUseConfigured,
	}
}

// Eac3 Passthrough Control
const (
	// Eac3PassthroughControlNoPassthrough is a Eac3PassthroughControl enum value
	Eac3PassthroughControlNoPassthrough = "NO_PASSTHROUGH"

	// Eac3PassthroughControlWhenPossible is a Eac3PassthroughControl enum value
	Eac3PassthroughControlWhenPossible = "WHEN_POSSIBLE"
)

// Eac3PassthroughControl_Values returns all elements of the Eac3PassthroughControl enum
func Eac3PassthroughControl_Values() []string {
	return []string{
		Eac3PassthroughControlNoPassthrough,
		Eac3PassthroughControlWhenPossible,
	}
}

// Eac3 Phase Control
const (
	// Eac3PhaseControlNoShift is a Eac3PhaseControl enum value
	Eac3PhaseControlNoShift = "NO_SHIFT"

	// Eac3PhaseControlShift90Degrees is a Eac3PhaseControl enum value
	Eac3PhaseControlShift90Degrees = "SHIFT_90_DEGREES"
)

// Eac3PhaseControl_Values returns all elements of the Eac3PhaseControl enum
func Eac3PhaseControl_Values() []string {
	return []string{
		Eac3PhaseControlNoShift,
		Eac3PhaseControlShift90Degrees,
	}
}

// Eac3 Stereo Downmix
const (
	// Eac3StereoDownmixDpl2 is a Eac3StereoDownmix enum value
	Eac3StereoDownmixDpl2 = "DPL2"

	// Eac3StereoDownmixLoRo is a Eac3StereoDownmix enum value
	Eac3StereoDownmixLoRo = "LO_RO"

	// Eac3StereoDownmixLtRt is a Eac3StereoDownmix enum value
	Eac3StereoDownmixLtRt = "LT_RT"

	// Eac3StereoDownmixNotIndicated is a Eac3StereoDownmix enum value
	Eac3StereoDownmixNotIndicated = "NOT_INDICATED"
)

// Eac3StereoDownmix_Values returns all elements of the Eac3StereoDownmix enum
func Eac3StereoDownmix_Values() []string {
	return []string{
		Eac3StereoDownmixDpl2,
		Eac3StereoDownmixLoRo,
		Eac3StereoDownmixLtRt,
		Eac3StereoDownmixNotIndicated,
	}
}

// Eac3 Surround Ex Mode
const (
	// Eac3SurroundExModeDisabled is a Eac3SurroundExMode enum value
	Eac3SurroundExModeDisabled = "DISABLED"

	// Eac3SurroundExModeEnabled is a Eac3SurroundExMode enum value
	Eac3SurroundExModeEnabled = "ENABLED"

	// Eac3SurroundExModeNotIndicated is a Eac3SurroundExMode enum value
	Eac3SurroundExModeNotIndicated = "NOT_INDICATED"
)

// Eac3SurroundExMode_Values returns all elements of the Eac3SurroundExMode enum
func Eac3SurroundExMode_Values() []string {
	return []string{
		Eac3SurroundExModeDisabled,
		Eac3SurroundExModeEnabled,
		Eac3SurroundExModeNotIndicated,
	}
}

// Eac3 Surround Mode
const (
	// Eac3SurroundModeDisabled is a Eac3SurroundMode enum value
	Eac3SurroundModeDisabled = "DISABLED"

	// Eac3SurroundModeEnabled is a Eac3SurroundMode enum value
	Eac3SurroundModeEnabled = "ENABLED"

	// Eac3SurroundModeNotIndicated is a Eac3SurroundMode enum value
	Eac3SurroundModeNotIndicated = "NOT_INDICATED"
)

// Eac3SurroundMode_Values returns all elements of the Eac3SurroundMode enum
func Eac3SurroundMode_Values() []string {
	return []string{
		Eac3SurroundModeDisabled,
		Eac3SurroundModeEnabled,
		Eac3SurroundModeNotIndicated,
	}
}

// Ebu Tt DDestination Style Control
const (
	// EbuTtDDestinationStyleControlExclude is a EbuTtDDestinationStyleControl enum value
	EbuTtDDestinationStyleControlExclude = "EXCLUDE"

	// EbuTtDDestinationStyleControlInclude is a EbuTtDDestinationStyleControl enum value
	EbuTtDDestinationStyleControlInclude = "INCLUDE"
)

// EbuTtDDestinationStyleControl_Values returns all elements of the EbuTtDDestinationStyleControl enum
func EbuTtDDestinationStyleControl_Values() []string {
	return []string{
		EbuTtDDestinationStyleControlExclude,
		EbuTtDDestinationStyleControlInclude,
	}
}

// Ebu Tt DFill Line Gap Control
const (
	// EbuTtDFillLineGapControlDisabled is a EbuTtDFillLineGapControl enum value
	EbuTtDFillLineGapControlDisabled = "DISABLED"

	// EbuTtDFillLineGapControlEnabled is a EbuTtDFillLineGapControl enum value
	EbuTtDFillLineGapControlEnabled = "ENABLED"
)

// EbuTtDFillLineGapControl_Values returns all elements of the EbuTtDFillLineGapControl enum
func EbuTtDFillLineGapControl_Values() []string {
	return []string{
		EbuTtDFillLineGapControlDisabled,
		EbuTtDFillLineGapControlEnabled,
	}
}

// Embedded Convert608 To708
const (
	// EmbeddedConvert608To708Disabled is a EmbeddedConvert608To708 enum value
	EmbeddedConvert608To708Disabled = "DISABLED"

	// EmbeddedConvert608To708Upconvert is a EmbeddedConvert608To708 enum value
	EmbeddedConvert608To708Upconvert = "UPCONVERT"
)

// EmbeddedConvert608To708_Values returns all elements of the EmbeddedConvert608To708 enum
func EmbeddedConvert608To708_Values() []string {
	return []string{
		EmbeddedConvert608To708Disabled,
		EmbeddedConvert608To708Upconvert,
	}
}

// Embedded Scte20 Detection
const (
	// EmbeddedScte20DetectionAuto is a EmbeddedScte20Detection enum value
	EmbeddedScte20DetectionAuto = "AUTO"

	// EmbeddedScte20DetectionOff is a EmbeddedScte20Detection enum value
	EmbeddedScte20DetectionOff = "OFF"
)

// EmbeddedScte20Detection_Values returns all elements of the EmbeddedScte20Detection enum
func EmbeddedScte20Detection_Values() []string {
	return []string{
		EmbeddedScte20DetectionAuto,
		EmbeddedScte20DetectionOff,
	}
}

// Feature Activations Input Prepare Schedule Actions
const (
	// FeatureActivationsInputPrepareScheduleActionsDisabled is a FeatureActivationsInputPrepareScheduleActions enum value
	FeatureActivationsInputPrepareScheduleActionsDisabled = "DISABLED"

	// FeatureActivationsInputPrepareScheduleActionsEnabled is a FeatureActivationsInputPrepareScheduleActions enum value
	FeatureActivationsInputPrepareScheduleActionsEnabled = "ENABLED"
)

// FeatureActivationsInputPrepareScheduleActions_Values returns all elements of the FeatureActivationsInputPrepareScheduleActions enum
func FeatureActivationsInputPrepareScheduleActions_Values() []string {
	return []string{
		FeatureActivationsInputPrepareScheduleActionsDisabled,
		FeatureActivationsInputPrepareScheduleActionsEnabled,
	}
}

// Fec Output Include Fec
const (
	// FecOutputIncludeFecColumn is a FecOutputIncludeFec enum value
	FecOutputIncludeFecColumn = "COLUMN"

	// FecOutputIncludeFecColumnAndRow is a FecOutputIncludeFec enum value
	FecOutputIncludeFecColumnAndRow = "COLUMN_AND_ROW"
)

// FecOutputIncludeFec_Values returns all elements of the FecOutputIncludeFec enum
func FecOutputIncludeFec_Values() []string {
	return []string{
		FecOutputIncludeFecColumn,
		FecOutputIncludeFecColumnAndRow,
	}
}

// Fixed Afd
const (
	// FixedAfdAfd0000 is a FixedAfd enum value
	FixedAfdAfd0000 = "AFD_0000"

	// FixedAfdAfd0010 is a FixedAfd enum value
	FixedAfdAfd0010 = "AFD_0010"

	// FixedAfdAfd0011 is a FixedAfd enum value
	FixedAfdAfd0011 = "AFD_0011"

	// FixedAfdAfd0100 is a FixedAfd enum value
	FixedAfdAfd0100 = "AFD_0100"

	// FixedAfdAfd1000 is a FixedAfd enum value
	FixedAfdAfd1000 = "AFD_1000"

	// FixedAfdAfd1001 is a FixedAfd enum value
	FixedAfdAfd1001 = "AFD_1001"

	// FixedAfdAfd1010 is a FixedAfd enum value
	FixedAfdAfd1010 = "AFD_1010"

	// FixedAfdAfd1011 is a FixedAfd enum value
	FixedAfdAfd1011 = "AFD_1011"

	// FixedAfdAfd1101 is a FixedAfd enum value
	FixedAfdAfd1101 = "AFD_1101"

	// FixedAfdAfd1110 is a FixedAfd enum value
	FixedAfdAfd1110 = "AFD_1110"

	// FixedAfdAfd1111 is a FixedAfd enum value
	FixedAfdAfd1111 = "AFD_1111"
)

// FixedAfd_Values returns all elements of the FixedAfd enum
func FixedAfd_Values() []string {
	return []string{
		FixedAfdAfd0000,
		FixedAfdAfd0010,
		FixedAfdAfd0011,
		FixedAfdAfd0100,
		FixedAfdAfd1000,
		FixedAfdAfd1001,
		FixedAfdAfd1010,
		FixedAfdAfd1011,
		FixedAfdAfd1101,
		FixedAfdAfd1110,
		FixedAfdAfd1111,
	}
}

// Fmp4 Nielsen Id3 Behavior
const (
	// Fmp4NielsenId3BehaviorNoPassthrough is a Fmp4NielsenId3Behavior enum value
	Fmp4NielsenId3BehaviorNoPassthrough = "NO_PASSTHROUGH"

	// Fmp4NielsenId3BehaviorPassthrough is a Fmp4NielsenId3Behavior enum value
	Fmp4NielsenId3BehaviorPassthrough = "PASSTHROUGH"
)

// Fmp4NielsenId3Behavior_Values returns all elements of the Fmp4NielsenId3Behavior enum
func Fmp4NielsenId3Behavior_Values() []string {
	return []string{
		Fmp4NielsenId3BehaviorNoPassthrough,
		Fmp4NielsenId3BehaviorPassthrough,
	}
}

// Fmp4 Timed Metadata Behavior
const (
	// Fmp4TimedMetadataBehaviorNoPassthrough is a Fmp4TimedMetadataBehavior enum value
	Fmp4TimedMetadataBehaviorNoPassthrough = "NO_PASSTHROUGH"

	// Fmp4TimedMetadataBehaviorPassthrough is a Fmp4TimedMetadataBehavior enum value
	Fmp4TimedMetadataBehaviorPassthrough = "PASSTHROUGH"
)

// Fmp4TimedMetadataBehavior_Values returns all elements of the Fmp4TimedMetadataBehavior enum
func Fmp4TimedMetadataBehavior_Values() []string {
	return []string{
		Fmp4TimedMetadataBehaviorNoPassthrough,
		Fmp4TimedMetadataBehaviorPassthrough,
	}
}

// Follow reference point.
const (
	// FollowPointEnd is a FollowPoint enum value
	FollowPointEnd = "END"

	// FollowPointStart is a FollowPoint enum value
	FollowPointStart = "START"
)

// FollowPoint_Values returns all elements of the FollowPoint enum
func FollowPoint_Values() []string {
	return []string{
		FollowPointEnd,
		FollowPointStart,
	}
}

// Frame Capture Interval Unit
const (
	// FrameCaptureIntervalUnitMilliseconds is a FrameCaptureIntervalUnit enum value
	FrameCaptureIntervalUnitMilliseconds = "MILLISECONDS"

	// FrameCaptureIntervalUnitSeconds is a FrameCaptureIntervalUnit enum value
	FrameCaptureIntervalUnitSeconds = "SECONDS"
)

// FrameCaptureIntervalUnit_Values returns all elements of the FrameCaptureIntervalUnit enum
func FrameCaptureIntervalUnit_Values() []string {
	return []string{
		FrameCaptureIntervalUnitMilliseconds,
		FrameCaptureIntervalUnitSeconds,
	}
}

// Global Configuration Input End Action
const (
	// GlobalConfigurationInputEndActionNone is a GlobalConfigurationInputEndAction enum value
	GlobalConfigurationInputEndActionNone = "NONE"

	// GlobalConfigurationInputEndActionSwitchAndLoopInputs is a GlobalConfigurationInputEndAction enum value
	GlobalConfigurationInputEndActionSwitchAndLoopInputs = "SWITCH_AND_LOOP_INPUTS"
)

// GlobalConfigurationInputEndAction_Values returns all elements of the GlobalConfigurationInputEndAction enum
func GlobalConfigurationInputEndAction_Values() []string {
	return []string{
		GlobalConfigurationInputEndActionNone,
		GlobalConfigurationInputEndActionSwitchAndLoopInputs,
	}
}

// Global Configuration Low Framerate Inputs
const (
	// GlobalConfigurationLowFramerateInputsDisabled is a GlobalConfigurationLowFramerateInputs enum value
	GlobalConfigurationLowFramerateInputsDisabled = "DISABLED"

	// GlobalConfigurationLowFramerateInputsEnabled is a GlobalConfigurationLowFramerateInputs enum value
	GlobalConfigurationLowFramerateInputsEnabled = "ENABLED"
)

// GlobalConfigurationLowFramerateInputs_Values returns all elements of the GlobalConfigurationLowFramerateInputs enum
func GlobalConfigurationLowFramerateInputs_Values() []string {
	return []string{
		GlobalConfigurationLowFramerateInputsDisabled,
		GlobalConfigurationLowFramerateInputsEnabled,
	}
}

// Global Configuration Output Locking Mode
const (
	// GlobalConfigurationOutputLockingModeEpochLocking is a GlobalConfigurationOutputLockingMode enum value
	GlobalConfigurationOutputLockingModeEpochLocking = "EPOCH_LOCKING"

	// GlobalConfigurationOutputLockingModePipelineLocking is a GlobalConfigurationOutputLockingMode enum value
	GlobalConfigurationOutputLockingModePipelineLocking = "PIPELINE_LOCKING"
)

// GlobalConfigurationOutputLockingMode_Values returns all elements of the GlobalConfigurationOutputLockingMode enum
func GlobalConfigurationOutputLockingMode_Values() []string {
	return []string{
		GlobalConfigurationOutputLockingModeEpochLocking,
		GlobalConfigurationOutputLockingModePipelineLocking,
	}
}

// Global Configuration Output Timing Source
const (
	// GlobalConfigurationOutputTimingSourceInputClock is a GlobalConfigurationOutputTimingSource enum value
	GlobalConfigurationOutputTimingSourceInputClock = "INPUT_CLOCK"

	// GlobalConfigurationOutputTimingSourceSystemClock is a GlobalConfigurationOutputTimingSource enum value
	GlobalConfigurationOutputTimingSourceSystemClock = "SYSTEM_CLOCK"
)

// GlobalConfigurationOutputTimingSource_Values returns all elements of the GlobalConfigurationOutputTimingSource enum
func GlobalConfigurationOutputTimingSource_Values() []string {
	return []string{
		GlobalConfigurationOutputTimingSourceInputClock,
		GlobalConfigurationOutputTimingSourceSystemClock,
	}
}

// H264 Adaptive Quantization
const (
	// H264AdaptiveQuantizationHigh is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationHigh = "HIGH"

	// H264AdaptiveQuantizationHigher is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationHigher = "HIGHER"

	// H264AdaptiveQuantizationLow is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationLow = "LOW"

	// H264AdaptiveQuantizationMax is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationMax = "MAX"

	// H264AdaptiveQuantizationMedium is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationMedium = "MEDIUM"

	// H264AdaptiveQuantizationOff is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationOff = "OFF"
)

// H264AdaptiveQuantization_Values returns all elements of the H264AdaptiveQuantization enum
func H264AdaptiveQuantization_Values() []string {
	return []string{
		H264AdaptiveQuantizationHigh,
		H264AdaptiveQuantizationHigher,
		H264AdaptiveQuantizationLow,
		H264AdaptiveQuantizationMax,
		H264AdaptiveQuantizationMedium,
		H264AdaptiveQuantizationOff,
	}
}

// H264 Color Metadata
const (
	// H264ColorMetadataIgnore is a H264ColorMetadata enum value
	H264ColorMetadataIgnore = "IGNORE"

	// H264ColorMetadataInsert is a H264ColorMetadata enum value
	H264ColorMetadataInsert = "INSERT"
)

// H264ColorMetadata_Values returns all elements of the H264ColorMetadata enum
func H264ColorMetadata_Values() []string {
	return []string{
		H264ColorMetadataIgnore,
		H264ColorMetadataInsert,
	}
}

// H264 Entropy Encoding
const (
	// H264EntropyEncodingCabac is a H264EntropyEncoding enum value
	H264EntropyEncodingCabac = "CABAC"

	// H264EntropyEncodingCavlc is a H264EntropyEncoding enum value
	H264EntropyEncodingCavlc = "CAVLC"
)

// H264EntropyEncoding_Values returns all elements of the H264EntropyEncoding enum
func H264EntropyEncoding_Values() []string {
	return []string{
		H264EntropyEncodingCabac,
		H264EntropyEncodingCavlc,
	}
}

// H264 Flicker Aq
const (
	// H264FlickerAqDisabled is a H264FlickerAq enum value
	H264FlickerAqDisabled = "DISABLED"

	// H264FlickerAqEnabled is a H264FlickerAq enum value
	H264FlickerAqEnabled = "ENABLED"
)

// H264FlickerAq_Values returns all elements of the H264FlickerAq enum
func H264FlickerAq_Values() []string {
	return []string{
		H264FlickerAqDisabled,
		H264FlickerAqEnabled,
	}
}

// H264 Force Field Pictures
const (
	// H264ForceFieldPicturesDisabled is a H264ForceFieldPictures enum value
	H264ForceFieldPicturesDisabled = "DISABLED"

	// H264ForceFieldPicturesEnabled is a H264ForceFieldPictures enum value
	H264ForceFieldPicturesEnabled = "ENABLED"
)

// H264ForceFieldPictures_Values returns all elements of the H264ForceFieldPictures enum
func H264ForceFieldPictures_Values() []string {
	return []string{
		H264ForceFieldPicturesDisabled,
		H264ForceFieldPicturesEnabled,
	}
}

// H264 Framerate Control
const (
	// H264FramerateControlInitializeFromSource is a H264FramerateControl enum value
	H264FramerateControlInitializeFromSource = "INITIALIZE_FROM_SOURCE"

	// H264FramerateControlSpecified is a H264FramerateControl enum value
	H264FramerateControlSpecified = "SPECIFIED"
)

// H264FramerateControl_Values returns all elements of the H264FramerateControl enum
func H264FramerateControl_Values() []string {
	return []string{
		H264FramerateControlInitializeFromSource,
		H264FramerateControlSpecified,
	}
}

// H264 Gop BReference
const (
	// H264GopBReferenceDisabled is a H264GopBReference enum value
	H264GopBReferenceDisabled = "DISABLED"

	// H264GopBReferenceEnabled is a H264GopBReference enum value
	H264GopBReferenceEnabled = "ENABLED"
)

// H264GopBReference_Values returns all elements of the H264GopBReference enum
func H264GopBReference_Values() []string {
	return []string{
		H264GopBReferenceDisabled,
		H264GopBReferenceEnabled,
	}
}

// H264 Gop Size Units
const (
	// H264GopSizeUnitsFrames is a H264GopSizeUnits enum value
	H264GopSizeUnitsFrames = "FRAMES"

	// H264GopSizeUnitsSeconds is a H264GopSizeUnits enum value
	H264GopSizeUnitsSeconds = "SECONDS"
)

// H264GopSizeUnits_Values returns all elements of the H264GopSizeUnits enum
func H264GopSizeUnits_Values() []string {
	return []string{
		H264GopSizeUnitsFrames,
		H264GopSizeUnitsSeconds,
	}
}

// H264 Level
const (
	// H264LevelH264Level1 is a H264Level enum value
	H264LevelH264Level1 = "H264_LEVEL_1"

	// H264LevelH264Level11 is a H264Level enum value
	H264LevelH264Level11 = "H264_LEVEL_1_1"

	// H264LevelH264Level12 is a H264Level enum value
	H264LevelH264Level12 = "H264_LEVEL_1_2"

	// H264LevelH264Level13 is a H264Level enum value
	H264LevelH264Level13 = "H264_LEVEL_1_3"

	// H264LevelH264Level2 is a H264Level enum value
	H264LevelH264Level2 = "H264_LEVEL_2"

	// H264LevelH264Level21 is a H264Level enum value
	H264LevelH264Level21 = "H264_LEVEL_2_1"

	// H264LevelH264Level22 is a H264Level enum value
	H264LevelH264Level22 = "H264_LEVEL_2_2"

	// H264LevelH264Level3 is a H264Level enum value
	H264LevelH264Level3 = "H264_LEVEL_3"

	// H264LevelH264Level31 is a H264Level enum value
	H264LevelH264Level31 = "H264_LEVEL_3_1"

	// H264LevelH264Level32 is a H264Level enum value
	H264LevelH264Level32 = "H264_LEVEL_3_2"

	// H264LevelH264Level4 is a H264Level enum value
	H264LevelH264Level4 = "H264_LEVEL_4"

	// H264LevelH264Level41 is a H264Level enum value
	H264LevelH264Level41 = "H264_LEVEL_4_1"

	// H264LevelH264Level42 is a H264Level enum value
	H264LevelH264Level42 = "H264_LEVEL_4_2"

	// H264LevelH264Level5 is a H264Level enum value
	H264LevelH264Level5 = "H264_LEVEL_5"

	// H264LevelH264Level51 is a H264Level enum value
	H264LevelH264Level51 = "H264_LEVEL_5_1"

	// H264LevelH264Level52 is a H264Level enum value
	H264LevelH264Level52 = "H264_LEVEL_5_2"

	// H264LevelH264LevelAuto is a H264Level enum value
	H264LevelH264LevelAuto = "H264_LEVEL_AUTO"
)

// H264Level_Values returns all elements of the H264Level enum
func H264Level_Values() []string {
	return []string{
		H264LevelH264Level1,
		H264LevelH264Level11,
		H264LevelH264Level12,
		H264LevelH264Level13,
		H264LevelH264Level2,
		H264LevelH264Level21,
		H264LevelH264Level22,
		H264LevelH264Level3,
		H264LevelH264Level31,
		H264LevelH264Level32,
		H264LevelH264Level4,
		H264LevelH264Level41,
		H264LevelH264Level42,
		H264LevelH264Level5,
		H264LevelH264Level51,
		H264LevelH264Level52,
		H264LevelH264LevelAuto,
	}
}

// H264 Look Ahead Rate Control
const (
	// H264LookAheadRateControlHigh is a H264LookAheadRateControl enum value
	H264LookAheadRateControlHigh = "HIGH"

	// H264LookAheadRateControlLow is a H264LookAheadRateControl enum value
	H264LookAheadRateControlLow = "LOW"

	// H264LookAheadRateControlMedium is a H264LookAheadRateControl enum value
	H264LookAheadRateControlMedium = "MEDIUM"
)

// H264LookAheadRateControl_Values returns all elements of the H264LookAheadRateControl enum
func H264LookAheadRateControl_Values() []string {
	return []string{
		H264LookAheadRateControlHigh,
		H264LookAheadRateControlLow,
		H264LookAheadRateControlMedium,
	}
}

// H264 Par Control
const (
	// H264ParControlInitializeFromSource is a H264ParControl enum value
	H264ParControlInitializeFromSource = "INITIALIZE_FROM_SOURCE"

	// H264ParControlSpecified is a H264ParControl enum value
	H264ParControlSpecified = "SPECIFIED"
)

// H264ParControl_Values returns all elements of the H264ParControl enum
func H264ParControl_Values() []string {
	return []string{
		H264ParControlInitializeFromSource,
		H264ParControlSpecified,
	}
}

// H264 Profile
const (
	// H264ProfileBaseline is a H264Profile enum value
	H264ProfileBaseline = "BASELINE"

	// H264ProfileHigh is a H264Profile enum value
	H264ProfileHigh = "HIGH"

	// H264ProfileHigh10bit is a H264Profile enum value
	H264ProfileHigh10bit = "HIGH_10BIT"

	// H264ProfileHigh422 is a H264Profile enum value
	H264ProfileHigh422 = "HIGH_422"

	// H264ProfileHigh42210bit is a H264Profile enum value
	H264ProfileHigh42210bit = "HIGH_422_10BIT"

	// H264ProfileMain is a H264Profile enum value
	H264ProfileMain = "MAIN"
)

// H264Profile_Values returns all elements of the H264Profile enum
func H264Profile_Values() []string {
	return []string{
		H264ProfileBaseline,
		H264ProfileHigh,
		H264ProfileHigh10bit,
		H264ProfileHigh422,
		H264ProfileHigh42210bit,
		H264ProfileMain,
	}
}

// H264 Quality Level
const (
	// H264QualityLevelEnhancedQuality is a H264QualityLevel enum value
	H264QualityLevelEnhancedQuality = "ENHANCED_QUALITY"

	// H264QualityLevelStandardQuality is a H264QualityLevel enum value
	H264QualityLevelStandardQuality = "STANDARD_QUALITY"
)

// H264QualityLevel_Values returns all elements of the H264QualityLevel enum
func H264QualityLevel_Values() []string {
	return []string{
		H264QualityLevelEnhancedQuality,
		H264QualityLevelStandardQuality,
	}
}

// H264 Rate Control Mode
const (
	// H264RateControlModeCbr is a H264RateControlMode enum value
	H264RateControlModeCbr = "CBR"

	// H264RateControlModeMultiplex is a H264RateControlMode enum value
	H264RateControlModeMultiplex = "MULTIPLEX"

	// H264RateControlModeQvbr is a H264RateControlMode enum value
	H264RateControlModeQvbr = "QVBR"

	// H264RateControlModeVbr is a H264RateControlMode enum value
	H264RateControlModeVbr = "VBR"
)

// H264RateControlMode_Values returns all elements of the H264RateControlMode enum
func H264RateControlMode_Values() []string {
	return []string{
		H264RateControlModeCbr,
		H264RateControlModeMultiplex,
		H264RateControlModeQvbr,
		H264RateControlModeVbr,
	}
}

// H264 Scan Type
const (
	// H264ScanTypeInterlaced is a H264ScanType enum value
	H264ScanTypeInterlaced = "INTERLACED"

	// H264ScanTypeProgressive is a H264ScanType enum value
	H264ScanTypeProgressive = "PROGRESSIVE"
)

// H264ScanType_Values returns all elements of the H264ScanType enum
func H264ScanType_Values() []string {
	return []string{
		H264ScanTypeInterlaced,
		H264ScanTypeProgressive,
	}
}

// H264 Scene Change Detect
const (
	// H264SceneChangeDetectDisabled is a H264SceneChangeDetect enum value
	H264SceneChangeDetectDisabled = "DISABLED"

	// H264SceneChangeDetectEnabled is a H264SceneChangeDetect enum value
	H264SceneChangeDetectEnabled = "ENABLED"
)

// H264SceneChangeDetect_Values returns all elements of the H264SceneChangeDetect enum
func H264SceneChangeDetect_Values() []string {
	return []string{
		H264SceneChangeDetectDisabled,
		H264SceneChangeDetectEnabled,
	}
}

// H264 Spatial Aq
const (
	// H264SpatialAqDisabled is a H264SpatialAq enum value
	H264SpatialAqDisabled = "DISABLED"

	// H264SpatialAqEnabled is a H264SpatialAq enum value
	H264SpatialAqEnabled = "ENABLED"
)

// H264SpatialAq_Values returns all elements of the H264SpatialAq enum
func H264SpatialAq_Values() []string {
	return []string{
		H264SpatialAqDisabled,
		H264SpatialAqEnabled,
	}
}

// H264 Sub Gop Length
const (
	// H264SubGopLengthDynamic is a H264SubGopLength enum value
	H264SubGopLengthDynamic = "DYNAMIC"

	// H264SubGopLengthFixed is a H264SubGopLength enum value
	H264SubGopLengthFixed = "FIXED"
)

// H264SubGopLength_Values returns all elements of the H264SubGopLength enum
func H264SubGopLength_Values() []string {
	return []string{
		H264SubGopLengthDynamic,
		H264SubGopLengthFixed,
	}
}

// H264 Syntax
const (
	// H264SyntaxDefault is a H264Syntax enum value
	H264SyntaxDefault = "DEFAULT"

	// H264SyntaxRp2027 is a H264Syntax enum value
	H264SyntaxRp2027 = "RP2027"
)

// H264Syntax_Values returns all elements of the H264Syntax enum
func H264Syntax_Values() []string {
	return []string{
		H264SyntaxDefault,
		H264SyntaxRp2027,
	}
}

// H264 Temporal Aq
const (
	// H264TemporalAqDisabled is a H264TemporalAq enum value
	H264TemporalAqDisabled = "DISABLED"

	// H264TemporalAqEnabled is a H264TemporalAq enum value
	H264TemporalAqEnabled = "ENABLED"
)

// H264TemporalAq_Values returns all elements of the H264TemporalAq enum
func H264TemporalAq_Values() []string {
	return []string{
		H264TemporalAqDisabled,
		H264TemporalAqEnabled,
	}
}

// H264 Timecode Insertion Behavior
const (
	// H264TimecodeInsertionBehaviorDisabled is a H264TimecodeInsertionBehavior enum value
	H264TimecodeInsertionBehaviorDisabled = "DISABLED"

	// H264TimecodeInsertionBehaviorPicTimingSei is a H264TimecodeInsertionBehavior enum value
	H264TimecodeInsertionBehaviorPicTimingSei = "PIC_TIMING_SEI"
)

// H264TimecodeInsertionBehavior_Values returns all elements of the H264TimecodeInsertionBehavior enum
func H264TimecodeInsertionBehavior_Values() []string {
	return []string{
		H264TimecodeInsertionBehaviorDisabled,
		H264TimecodeInsertionBehaviorPicTimingSei,
	}
}

// H265 Adaptive Quantization
const (
	// H265AdaptiveQuantizationHigh is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationHigh = "HIGH"

	// H265AdaptiveQuantizationHigher is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationHigher = "HIGHER"

	// H265AdaptiveQuantizationLow is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationLow = "LOW"

	// H265AdaptiveQuantizationMax is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationMax = "MAX"

	// H265AdaptiveQuantizationMedium is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationMedium = "MEDIUM"

	// H265AdaptiveQuantizationOff is a H265AdaptiveQuantization enum value
	H265AdaptiveQuantizationOff = "OFF"
)

// H265AdaptiveQuantization_Values returns all elements of the H265AdaptiveQuantization enum
func H265AdaptiveQuantization_Values() []string {
	return []string{
		H265AdaptiveQuantizationHigh,
		H265AdaptiveQuantizationHigher,
		H265AdaptiveQuantizationLow,
		H265AdaptiveQuantizationMax,
		H265AdaptiveQuantizationMedium,
		H265AdaptiveQuantizationOff,
	}
}

// H265 Alternative Transfer Function
const (
	// H265AlternativeTransferFunctionInsert is a H265AlternativeTransferFunction enum value
	H265AlternativeTransferFunctionInsert = "INSERT"

	// H265AlternativeTransferFunctionOmit is a H265AlternativeTransferFunction enum value
	H265AlternativeTransferFunctionOmit = "OMIT"
)

// H265AlternativeTransferFunction_Values returns all elements of the H265AlternativeTransferFunction enum
func H265AlternativeTransferFunction_Values() []string {
	return []string{
		H265AlternativeTransferFunctionInsert,
		H265AlternativeTransferFunctionOmit,
	}
}

// H265 Color Metadata
const (
	// H265ColorMetadataIgnore is a H265ColorMetadata enum value
	H265ColorMetadataIgnore = "IGNORE"

	// H265ColorMetadataInsert is a H265ColorMetadata enum value
	H265ColorMetadataInsert = "INSERT"
)

// H265ColorMetadata_Values returns all elements of the H265ColorMetadata enum
func H265ColorMetadata_Values() []string {
	return []string{
		H265ColorMetadataIgnore,
		H265ColorMetadataInsert,
	}
}

// H265 Flicker Aq
const (
	// H265FlickerAqDisabled is a H265FlickerAq enum value
	H265FlickerAqDisabled = "DISABLED"

	// H265FlickerAqEnabled is a H265FlickerAq enum value
	H265FlickerAqEnabled = "ENABLED"
)

// H265FlickerAq_Values returns all elements of the H265FlickerAq enum
func H265FlickerAq_Values() []string {
	return []string{
		H265FlickerAqDisabled,
		H265FlickerAqEnabled,
	}
}

// H265 Gop Size Units
const (
	// H265GopSizeUnitsFrames is a H265GopSizeUnits enum value
	H265GopSizeUnitsFrames = "FRAMES"

	// H265GopSizeUnitsSeconds is a H265GopSizeUnits enum value
	H265GopSizeUnitsSeconds = "SECONDS"
)

// H265GopSizeUnits_Values returns all elements of the H265GopSizeUnits enum
func H265GopSizeUnits_Values() []string {
	return []string{
		H265GopSizeUnitsFrames,
		H265GopSizeUnitsSeconds,
	}
}

// H265 Level
const (
	// H265LevelH265Level1 is a H265Level enum value
	H265LevelH265Level1 = "H265_LEVEL_1"

	// H265LevelH265Level2 is a H265Level enum value
	H265LevelH265Level2 = "H265_LEVEL_2"

	// H265LevelH265Level21 is a H265Level enum value
	H265LevelH265Level21 = "H265_LEVEL_2_1"

	// H265LevelH265Level3 is a H265Level enum value
	H265LevelH265Level3 = "H265_LEVEL_3"

	// H265LevelH265Level31 is a H265Level enum value
	H265LevelH265Level31 = "H265_LEVEL_3_1"

	// H265LevelH265Level4 is a H265Level enum value
	H265LevelH265Level4 = "H265_LEVEL_4"

	// H265LevelH265Level41 is a H265Level enum value
	H265LevelH265Level41 = "H265_LEVEL_4_1"

	// H265LevelH265Level5 is a H265Level enum value
	H265LevelH265Level5 = "H265_LEVEL_5"

	// H265LevelH265Level51 is a H265Level enum value
	H265LevelH265Level51 = "H265_LEVEL_5_1"

	// H265LevelH265Level52 is a H265Level enum value
	H265LevelH265Level52 = "H265_LEVEL_5_2"

	// H265LevelH265Level6 is a H265Level enum value
	H265LevelH265Level6 = "H265_LEVEL_6"

	// H265LevelH265Level61 is a H265Level enum value
	H265LevelH265Level61 = "H265_LEVEL_6_1"

	// H265LevelH265Level62 is a H265Level enum value
	H265LevelH265Level62 = "H265_LEVEL_6_2"

	// H265LevelH265LevelAuto is a H265Level enum value
	H265LevelH265LevelAuto = "H265_LEVEL_AUTO"
)

// H265Level_Values returns all elements of the H265Level enum
func H265Level_Values() []string {
	return []string{
		H265LevelH265Level1,
		H265LevelH265Level2,
		H265LevelH265Level21,
		H265LevelH265Level3,
		H265LevelH265Level31,
		H265LevelH265Level4,
		H265LevelH265Level41,
		H265LevelH265Level5,
		H265LevelH265Level51,
		H265LevelH265Level52,
		H265LevelH265Level6,
		H265LevelH265Level61,
		H265LevelH265Level62,
		H265LevelH265LevelAuto,
	}
}

// H265 Look Ahead Rate Control
const (
	// H265LookAheadRateControlHigh is a H265LookAheadRateControl enum value
	H265LookAheadRateControlHigh = "HIGH"

	// H265LookAheadRateControlLow is a H265LookAheadRateControl enum value
	H265LookAheadRateControlLow = "LOW"

	// H265LookAheadRateControlMedium is a H265LookAheadRateControl enum value
	H265LookAheadRateControlMedium = "MEDIUM"
)

// H265LookAheadRateControl_Values returns all elements of the H265LookAheadRateControl enum
func H265LookAheadRateControl_Values() []string {
	return []string{
		H265LookAheadRateControlHigh,
		H265LookAheadRateControlLow,
		H265LookAheadRateControlMedium,
	}
}

// H265 Profile
const (
	// H265ProfileMain is a H265Profile enum value
	H265ProfileMain = "MAIN"

	// H265ProfileMain10bit is a H265Profile enum value
	H265ProfileMain10bit = "MAIN_10BIT"
)

// H265Profile_Values returns all elements of the H265Profile enum
func H265Profile_Values() []string {
	return []string{
		H265ProfileMain,
		H265ProfileMain10bit,
	}
}

// H265 Rate Control Mode
const (
	// H265RateControlModeCbr is a H265RateControlMode enum value
	H265RateControlModeCbr = "CBR"

	// H265RateControlModeMultiplex is a H265RateControlMode enum value
	H265RateControlModeMultiplex = "MULTIPLEX"

	// H265RateControlModeQvbr is a H265RateControlMode enum value
	H265RateControlModeQvbr = "QVBR"
)

// H265RateControlMode_Values returns all elements of the H265RateControlMode enum
func H265RateControlMode_Values() []string {
	return []string{
		H265RateControlModeCbr,
		H265RateControlModeMultiplex,
		H265RateControlModeQvbr,
	}
}

// H265 Scan Type
const (
	// H265ScanTypeInterlaced is a H265ScanType enum value
	H265ScanTypeInterlaced = "INTERLACED"

	// H265ScanTypeProgressive is a H265ScanType enum value
	H265ScanTypeProgressive = "PROGRESSIVE"
)

// H265ScanType_Values returns all elements of the H265ScanType enum
func H265ScanType_Values() []string {
	return []string{
		H265ScanTypeInterlaced,
		H265ScanTypeProgressive,
	}
}

// H265 Scene Change Detect
const (
	// H265SceneChangeDetectDisabled is a H265SceneChangeDetect enum value
	H265SceneChangeDetectDisabled = "DISABLED"

	// H265SceneChangeDetectEnabled is a H265SceneChangeDetect enum value
	H265SceneChangeDetectEnabled = "ENABLED"
)

// H265SceneChangeDetect_Values returns all elements of the H265SceneChangeDetect enum
func H265SceneChangeDetect_Values() []string {
	return []string{
		H265SceneChangeDetectDisabled,
		H265SceneChangeDetectEnabled,
	}
}

// H265 Tier
const (
	// H265TierHigh is a H265Tier enum value
	H265TierHigh = "HIGH"

	// H265TierMain is a H265Tier enum value
	H265TierMain = "MAIN"
)

// H265Tier_Values returns all elements of the H265Tier enum
func H265Tier_Values() []string {
	return []string{
		H265TierHigh,
		H265TierMain,
	}
}

// H265 Timecode Insertion Behavior
const (
	// H265TimecodeInsertionBehaviorDisabled is a H265TimecodeInsertionBehavior enum value
	H265TimecodeInsertionBehaviorDisabled = "DISABLED"

	// H265TimecodeInsertionBehaviorPicTimingSei is a H265TimecodeInsertionBehavior enum value
	H265TimecodeInsertionBehaviorPicTimingSei = "PIC_TIMING_SEI"
)

// H265TimecodeInsertionBehavior_Values returns all elements of the H265TimecodeInsertionBehavior enum
func H265TimecodeInsertionBehavior_Values() []string {
	return []string{
		H265TimecodeInsertionBehaviorDisabled,
		H265TimecodeInsertionBehaviorPicTimingSei,
	}
}

// Hls Ad Markers
const (
	// HlsAdMarkersAdobe is a HlsAdMarkers enum value
	HlsAdMarkersAdobe = "ADOBE"

	// HlsAdMarkersElemental is a HlsAdMarkers enum value
	HlsAdMarkersElemental = "ELEMENTAL"

	// HlsAdMarkersElementalScte35 is a HlsAdMarkers enum value
	HlsAdMarkersElementalScte35 = "ELEMENTAL_SCTE35"
)

// HlsAdMarkers_Values returns all elements of the HlsAdMarkers enum
func HlsAdMarkers_Values() []string {
	return []string{
		HlsAdMarkersAdobe,
		HlsAdMarkersElemental,
		HlsAdMarkersElementalScte35,
	}
}

// Hls Akamai Http Transfer Mode
const (
	// HlsAkamaiHttpTransferModeChunked is a HlsAkamaiHttpTransferMode enum value
	HlsAkamaiHttpTransferModeChunked = "CHUNKED"

	// HlsAkamaiHttpTransferModeNonChunked is a HlsAkamaiHttpTransferMode enum value
	HlsAkamaiHttpTransferModeNonChunked = "NON_CHUNKED"
)

// HlsAkamaiHttpTransferMode_Values returns all elements of the HlsAkamaiHttpTransferMode enum
func HlsAkamaiHttpTransferMode_Values() []string {
	return []string{
		HlsAkamaiHttpTransferModeChunked,
		HlsAkamaiHttpTransferModeNonChunked,
	}
}

// Hls Caption Language Setting
const (
	// HlsCaptionLanguageSettingInsert is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingInsert = "INSERT"

	// HlsCaptionLanguageSettingNone is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingNone = "NONE"

	// HlsCaptionLanguageSettingOmit is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingOmit = "OMIT"
)

// HlsCaptionLanguageSetting_Values returns all elements of the HlsCaptionLanguageSetting enum
func HlsCaptionLanguageSetting_Values() []string {
	return []string{
		HlsCaptionLanguageSettingInsert,
		HlsCaptionLanguageSettingNone,
		HlsCaptionLanguageSettingOmit,
	}
}

// Hls Client Cache
const (
	// HlsClientCacheDisabled is a HlsClientCache enum value
	HlsClientCacheDisabled = "DISABLED"

	// HlsClientCacheEnabled is a HlsClientCache enum value
	HlsClientCacheEnabled = "ENABLED"
)

// HlsClientCache_Values returns all elements of the HlsClientCache enum
func HlsClientCache_Values() []string {
	return []string{
		HlsClientCacheDisabled,
		HlsClientCacheEnabled,
	}
}

// Hls Codec Specification
const (
	// HlsCodecSpecificationRfc4281 is a HlsCodecSpecification enum value
	HlsCodecSpecificationRfc4281 = "RFC_4281"

	// HlsCodecSpecificationRfc6381 is a HlsCodecSpecification enum value
	HlsCodecSpecificationRfc6381 = "RFC_6381"
)

// HlsCodecSpecification_Values returns all elements of the HlsCodecSpecification enum
func HlsCodecSpecification_Values() []string {
	return []string{
		HlsCodecSpecificationRfc4281,
		HlsCodecSpecificationRfc6381,
	}
}

// Hls Directory Structure
const (
	// HlsDirectoryStructureSingleDirectory is a HlsDirectoryStructure enum value
	HlsDirectoryStructureSingleDirectory = "SINGLE_DIRECTORY"

	// HlsDirectoryStructureSubdirectoryPerStream is a HlsDirectoryStructure enum value
	HlsDirectoryStructureSubdirectoryPerStream = "SUBDIRECTORY_PER_STREAM"
)

// HlsDirectoryStructure_Values returns all elements of the HlsDirectoryStructure enum
func HlsDirectoryStructure_Values() []string {
	return []string{
		HlsDirectoryStructureSingleDirectory,
		HlsDirectoryStructureSubdirectoryPerStream,
	}
}

// Hls Encryption Type
const (
	// HlsEncryptionTypeAes128 is a HlsEncryptionType enum value
	HlsEncryptionTypeAes128 = "AES128"

	// HlsEncryptionTypeSampleAes is a HlsEncryptionType enum value
	HlsEncryptionTypeSampleAes = "SAMPLE_AES"
)

// HlsEncryptionType_Values returns all elements of the HlsEncryptionType enum
func HlsEncryptionType_Values() []string {
	return []string{
		HlsEncryptionTypeAes128,
		HlsEncryptionTypeSampleAes,
	}
}

// Hls H265 Packaging Type
const (
	// HlsH265PackagingTypeHev1 is a HlsH265PackagingType enum value
	HlsH265PackagingTypeHev1 = "HEV1"

	// HlsH265PackagingTypeHvc1 is a HlsH265PackagingType enum value
	HlsH265PackagingTypeHvc1 = "HVC1"
)

// HlsH265PackagingType_Values returns all elements of the HlsH265PackagingType enum
func HlsH265PackagingType_Values() []string {
	return []string{
		HlsH265PackagingTypeHev1,
		HlsH265PackagingTypeHvc1,
	}
}

// State of HLS ID3 Segment Tagging
const (
	// HlsId3SegmentTaggingStateDisabled is a HlsId3SegmentTaggingState enum value
	HlsId3SegmentTaggingStateDisabled = "DISABLED"

	// HlsId3SegmentTaggingStateEnabled is a HlsId3SegmentTaggingState enum value
	HlsId3SegmentTaggingStateEnabled = "ENABLED"
)

// HlsId3SegmentTaggingState_Values returns all elements of the HlsId3SegmentTaggingState enum
func HlsId3SegmentTaggingState_Values() []string {
	return []string{
		HlsId3SegmentTaggingStateDisabled,
		HlsId3SegmentTaggingStateEnabled,
	}
}

// Hls Iv In Manifest
const (
	// HlsIvInManifestExclude is a HlsIvInManifest enum value
	HlsIvInManifestExclude = "EXCLUDE"

	// HlsIvInManifestInclude is a HlsIvInManifest enum value
	HlsIvInManifestInclude = "INCLUDE"
)

// HlsIvInManifest_Values returns all elements of the HlsIvInManifest enum
func HlsIvInManifest_Values() []string {
	return []string{
		HlsIvInManifestExclude,
		HlsIvInManifestInclude,
	}
}

// Hls Iv Source
const (
	// HlsIvSourceExplicit is a HlsIvSource enum value
	HlsIvSourceExplicit = "EXPLICIT"

	// HlsIvSourceFollowsSegmentNumber is a HlsIvSource enum value
	HlsIvSourceFollowsSegmentNumber = "FOLLOWS_SEGMENT_NUMBER"
)

// HlsIvSource_Values returns all elements of the HlsIvSource enum
func HlsIvSource_Values() []string {
	return []string{
		HlsIvSourceExplicit,
		HlsIvSourceFollowsSegmentNumber,
	}
}

// Hls Manifest Compression
const (
	// HlsManifestCompressionGzip is a HlsManifestCompression enum value
	HlsManifestCompressionGzip = "GZIP"

	// HlsManifestCompressionNone is a HlsManifestCompression enum value
	HlsManifestCompressionNone = "NONE"
)

// HlsManifestCompression_Values returns all elements of the HlsManifestCompression enum
func HlsManifestCompression_Values() []string {
	return []string{
		HlsManifestCompressionGzip,
		HlsManifestCompressionNone,
	}
}

// Hls Manifest Duration Format
const (
	// HlsManifestDurationFormatFloatingPoint is a HlsManifestDurationFormat enum value
	HlsManifestDurationFormatFloatingPoint = "FLOATING_POINT"

	// HlsManifestDurationFormatInteger is a HlsManifestDurationFormat enum value
	HlsManifestDurationFormatInteger = "INTEGER"
)

// HlsManifestDurationFormat_Values returns all elements of the HlsManifestDurationFormat enum
func HlsManifestDurationFormat_Values() []string {
	return []string{
		HlsManifestDurationFormatFloatingPoint,
		HlsManifestDurationFormatInteger,
	}
}

// Hls Media Store Storage Class
const (
	// HlsMediaStoreStorageClassTemporal is a HlsMediaStoreStorageClass enum value
	HlsMediaStoreStorageClassTemporal = "TEMPORAL"
)

// HlsMediaStoreStorageClass_Values returns all elements of the HlsMediaStoreStorageClass enum
func HlsMediaStoreStorageClass_Values() []string {
	return []string{
		HlsMediaStoreStorageClassTemporal,
	}
}

// Hls Mode
const (
	// HlsModeLive is a HlsMode enum value
	HlsModeLive = "LIVE"

	// HlsModeVod is a HlsMode enum value
	HlsModeVod = "VOD"
)

// HlsMode_Values returns all elements of the HlsMode enum
func HlsMode_Values() []string {
	return []string{
		HlsModeLive,
		HlsModeVod,
	}
}

// Hls Output Selection
const (
	// HlsOutputSelectionManifestsAndSegments is a HlsOutputSelection enum value
	HlsOutputSelectionManifestsAndSegments = "MANIFESTS_AND_SEGMENTS"

	// HlsOutputSelectionSegmentsOnly is a HlsOutputSelection enum value
	HlsOutputSelectionSegmentsOnly = "SEGMENTS_ONLY"

	// HlsOutputSelectionVariantManifestsAndSegments is a HlsOutputSelection enum value
	HlsOutputSelectionVariantManifestsAndSegments = "VARIANT_MANIFESTS_AND_SEGMENTS"
)

// HlsOutputSelection_Values returns all elements of the HlsOutputSelection enum
func HlsOutputSelection_Values() []string {
	return []string{
		HlsOutputSelectionManifestsAndSegments,
		HlsOutputSelectionSegmentsOnly,
		HlsOutputSelectionVariantManifestsAndSegments,
	}
}

// Hls Program Date Time
const (
	// HlsProgramDateTimeExclude is a HlsProgramDateTime enum value
	HlsProgramDateTimeExclude = "EXCLUDE"

	// HlsProgramDateTimeInclude is a HlsProgramDateTime enum value
	HlsProgramDateTimeInclude = "INCLUDE"
)

// HlsProgramDateTime_Values returns all elements of the HlsProgramDateTime enum
func HlsProgramDateTime_Values() []string {
	return []string{
		HlsProgramDateTimeExclude,
		HlsProgramDateTimeInclude,
	}
}

// Hls Redundant Manifest
const (
	// HlsRedundantManifestDisabled is a HlsRedundantManifest enum value
	HlsRedundantManifestDisabled = "DISABLED"

	// HlsRedundantManifestEnabled is a HlsRedundantManifest enum value
	HlsRedundantManifestEnabled = "ENABLED"
)

// HlsRedundantManifest_Values returns all elements of the HlsRedundantManifest enum
func HlsRedundantManifest_Values() []string {
	return []string{
		HlsRedundantManifestDisabled,
		HlsRedundantManifestEnabled,
	}
}

// Hls Segmentation Mode
const (
	// HlsSegmentationModeUseInputSegmentation is a HlsSegmentationMode enum value
	HlsSegmentationModeUseInputSegmentation = "USE_INPUT_SEGMENTATION"

	// HlsSegmentationModeUseSegmentDuration is a HlsSegmentationMode enum value
	HlsSegmentationModeUseSegmentDuration = "USE_SEGMENT_DURATION"
)

// HlsSegmentationMode_Values returns all elements of the HlsSegmentationMode enum
func HlsSegmentationMode_Values() []string {
	return []string{
		HlsSegmentationModeUseInputSegmentation,
		HlsSegmentationModeUseSegmentDuration,
	}
}

// Hls Stream Inf Resolution
const (
	// HlsStreamInfResolutionExclude is a HlsStreamInfResolution enum value
	HlsStreamInfResolutionExclude = "EXCLUDE"

	// HlsStreamInfResolutionInclude is a HlsStreamInfResolution enum value
	HlsStreamInfResolutionInclude = "INCLUDE"
)

// HlsStreamInfResolution_Values returns all elements of the HlsStreamInfResolution enum
func HlsStreamInfResolution_Values() []string {
	return []string{
		HlsStreamInfResolutionExclude,
		HlsStreamInfResolutionInclude,
	}
}

// Hls Timed Metadata Id3 Frame
const (
	// HlsTimedMetadataId3FrameNone is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FrameNone = "NONE"

	// HlsTimedMetadataId3FramePriv is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FramePriv = "PRIV"

	// HlsTimedMetadataId3FrameTdrl is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FrameTdrl = "TDRL"
)

// HlsTimedMetadataId3Frame_Values returns all elements of the HlsTimedMetadataId3Frame enum
func HlsTimedMetadataId3Frame_Values() []string {
	return []string{
		HlsTimedMetadataId3FrameNone,
		HlsTimedMetadataId3FramePriv,
		HlsTimedMetadataId3FrameTdrl,
	}
}

// Hls Ts File Mode
const (
	// HlsTsFileModeSegmentedFiles is a HlsTsFileMode enum value
	HlsTsFileModeSegmentedFiles = "SEGMENTED_FILES"

	// HlsTsFileModeSingleFile is a HlsTsFileMode enum value
	HlsTsFileModeSingleFile = "SINGLE_FILE"
)

// HlsTsFileMode_Values returns all elements of the HlsTsFileMode enum
func HlsTsFileMode_Values() []string {
	return []string{
		HlsTsFileModeSegmentedFiles,
		HlsTsFileModeSingleFile,
	}
}

// Hls Webdav Http Transfer Mode
const (
	// HlsWebdavHttpTransferModeChunked is a HlsWebdavHttpTransferMode enum value
	HlsWebdavHttpTransferModeChunked = "CHUNKED"

	// HlsWebdavHttpTransferModeNonChunked is a HlsWebdavHttpTransferMode enum value
	HlsWebdavHttpTransferModeNonChunked = "NON_CHUNKED"
)

// HlsWebdavHttpTransferMode_Values returns all elements of the HlsWebdavHttpTransferMode enum
func HlsWebdavHttpTransferMode_Values() []string {
	return []string{
		HlsWebdavHttpTransferModeChunked,
		HlsWebdavHttpTransferModeNonChunked,
	}
}

// When set to "standard", an I-Frame only playlist will be written out for
// each video output in the output group. This I-Frame only playlist will contain
// byte range offsets pointing to the I-frame(s) in each segment.
const (
	// IFrameOnlyPlaylistTypeDisabled is a IFrameOnlyPlaylistType enum value
	IFrameOnlyPlaylistTypeDisabled = "DISABLED"

	// IFrameOnlyPlaylistTypeStandard is a IFrameOnlyPlaylistType enum value
	IFrameOnlyPlaylistTypeStandard = "STANDARD"
)

// IFrameOnlyPlaylistType_Values returns all elements of the IFrameOnlyPlaylistType enum
func IFrameOnlyPlaylistType_Values() []string {
	return []string{
		IFrameOnlyPlaylistTypeDisabled,
		IFrameOnlyPlaylistTypeStandard,
	}
}

// A standard input has two sources and a single pipeline input only has one.
const (
	// InputClassStandard is a InputClass enum value
	InputClassStandard = "STANDARD"

	// InputClassSinglePipeline is a InputClass enum value
	InputClassSinglePipeline = "SINGLE_PIPELINE"
)

// InputClass_Values returns all elements of the InputClass enum
func InputClass_Values() []string {
	return []string{
		InputClassStandard,
		InputClassSinglePipeline,
	}
}

// codec in increasing order of complexity
const (
	// InputCodecMpeg2 is a InputCodec enum value
	InputCodecMpeg2 = "MPEG2"

	// InputCodecAvc is a InputCodec enum value
	InputCodecAvc = "AVC"

	// InputCodecHevc is a InputCodec enum value
	InputCodecHevc = "HEVC"
)

// InputCodec_Values returns all elements of the InputCodec enum
func InputCodec_Values() []string {
	return []string{
		InputCodecMpeg2,
		InputCodecAvc,
		InputCodecHevc,
	}
}

// Input Deblock Filter
const (
	// InputDeblockFilterDisabled is a InputDeblockFilter enum value
	InputDeblockFilterDisabled = "DISABLED"

	// InputDeblockFilterEnabled is a InputDeblockFilter enum value
	InputDeblockFilterEnabled = "ENABLED"
)

// InputDeblockFilter_Values returns all elements of the InputDeblockFilter enum
func InputDeblockFilter_Values() []string {
	return []string{
		InputDeblockFilterDisabled,
		InputDeblockFilterEnabled,
	}
}

// Input Denoise Filter
const (
	// InputDenoiseFilterDisabled is a InputDenoiseFilter enum value
	InputDenoiseFilterDisabled = "DISABLED"

	// InputDenoiseFilterEnabled is a InputDenoiseFilter enum value
	InputDenoiseFilterEnabled = "ENABLED"
)

// InputDenoiseFilter_Values returns all elements of the InputDenoiseFilter enum
func InputDenoiseFilter_Values() []string {
	return []string{
		InputDenoiseFilterDisabled,
		InputDenoiseFilterEnabled,
	}
}

// The source at the input device that is currently active.
const (
	// InputDeviceActiveInputHdmi is a InputDeviceActiveInput enum value
	InputDeviceActiveInputHdmi = "HDMI"

	// InputDeviceActiveInputSdi is a InputDeviceActiveInput enum value
	InputDeviceActiveInputSdi = "SDI"
)

// InputDeviceActiveInput_Values returns all elements of the InputDeviceActiveInput enum
func InputDeviceActiveInput_Values() []string {
	return []string{
		InputDeviceActiveInputHdmi,
		InputDeviceActiveInputSdi,
	}
}

// The source to activate (use) from the input device.
const (
	// InputDeviceConfiguredInputAuto is a InputDeviceConfiguredInput enum value
	InputDeviceConfiguredInputAuto = "AUTO"

	// InputDeviceConfiguredInputHdmi is a InputDeviceConfiguredInput enum value
	InputDeviceConfiguredInputHdmi = "HDMI"

	// InputDeviceConfiguredInputSdi is a InputDeviceConfiguredInput enum value
	InputDeviceConfiguredInputSdi = "SDI"
)

// InputDeviceConfiguredInput_Values returns all elements of the InputDeviceConfiguredInput enum
func InputDeviceConfiguredInput_Values() []string {
	return []string{
		InputDeviceConfiguredInputAuto,
		InputDeviceConfiguredInputHdmi,
		InputDeviceConfiguredInputSdi,
	}
}

// The state of the connection between the input device and AWS.
const (
	// InputDeviceConnectionStateDisconnected is a InputDeviceConnectionState enum value
	InputDeviceConnectionStateDisconnected = "DISCONNECTED"

	// InputDeviceConnectionStateConnected is a InputDeviceConnectionState enum value
	InputDeviceConnectionStateConnected = "CONNECTED"
)

// InputDeviceConnectionState_Values returns all elements of the InputDeviceConnectionState enum
func InputDeviceConnectionState_Values() []string {
	return []string{
		InputDeviceConnectionStateDisconnected,
		InputDeviceConnectionStateConnected,
	}
}

// Specifies whether the input device has been configured (outside of MediaLive)
// to use a dynamic IP address assignment (DHCP) or a static IP address.
const (
	// InputDeviceIpSchemeStatic is a InputDeviceIpScheme enum value
	InputDeviceIpSchemeStatic = "STATIC"

	// InputDeviceIpSchemeDhcp is a InputDeviceIpScheme enum value
	InputDeviceIpSchemeDhcp = "DHCP"
)

// InputDeviceIpScheme_Values returns all elements of the InputDeviceIpScheme enum
func InputDeviceIpScheme_Values() []string {
	return []string{
		InputDeviceIpSchemeStatic,
		InputDeviceIpSchemeDhcp,
	}
}

// The scan type of the video source.
const (
	// InputDeviceScanTypeInterlaced is a InputDeviceScanType enum value
	InputDeviceScanTypeInterlaced = "INTERLACED"

	// InputDeviceScanTypeProgressive is a InputDeviceScanType enum value
	InputDeviceScanTypeProgressive = "PROGRESSIVE"
)

// InputDeviceScanType_Values returns all elements of the InputDeviceScanType enum
func InputDeviceScanType_Values() []string {
	return []string{
		InputDeviceScanTypeInterlaced,
		InputDeviceScanTypeProgressive,
	}
}

// The state of the input device.
const (
	// InputDeviceStateIdle is a InputDeviceState enum value
	InputDeviceStateIdle = "IDLE"

	// InputDeviceStateStreaming is a InputDeviceState enum value
	InputDeviceStateStreaming = "STREAMING"
)

// InputDeviceState_Values returns all elements of the InputDeviceState enum
func InputDeviceState_Values() []string {
	return []string{
		InputDeviceStateIdle,
		InputDeviceStateStreaming,
	}
}

// The type of the input device. For an AWS Elemental Link device that outputs
// resolutions up to 1080, choose "HD".
const (
	// InputDeviceTypeHd is a InputDeviceType enum value
	InputDeviceTypeHd = "HD"
)

// InputDeviceType_Values returns all elements of the InputDeviceType enum
func InputDeviceType_Values() []string {
	return []string{
		InputDeviceTypeHd,
	}
}

// Input Filter
const (
	// InputFilterAuto is a InputFilter enum value
	InputFilterAuto = "AUTO"

	// InputFilterDisabled is a InputFilter enum value
	InputFilterDisabled = "DISABLED"

	// InputFilterForced is a InputFilter enum value
	InputFilterForced = "FORCED"
)

// InputFilter_Values returns all elements of the InputFilter enum
func InputFilter_Values() []string {
	return []string{
		InputFilterAuto,
		InputFilterDisabled,
		InputFilterForced,
	}
}

// Input Loss Action For Hls Out
const (
	// InputLossActionForHlsOutEmitOutput is a InputLossActionForHlsOut enum value
	InputLossActionForHlsOutEmitOutput = "EMIT_OUTPUT"

	// InputLossActionForHlsOutPauseOutput is a InputLossActionForHlsOut enum value
	InputLossActionForHlsOutPauseOutput = "PAUSE_OUTPUT"
)

// InputLossActionForHlsOut_Values returns all elements of the InputLossActionForHlsOut enum
func InputLossActionForHlsOut_Values() []string {
	return []string{
		InputLossActionForHlsOutEmitOutput,
		InputLossActionForHlsOutPauseOutput,
	}
}

// Input Loss Action For Ms Smooth Out
const (
	// InputLossActionForMsSmoothOutEmitOutput is a InputLossActionForMsSmoothOut enum value
	InputLossActionForMsSmoothOutEmitOutput = "EMIT_OUTPUT"

	// InputLossActionForMsSmoothOutPauseOutput is a InputLossActionForMsSmoothOut enum value
	InputLossActionForMsSmoothOutPauseOutput = "PAUSE_OUTPUT"
)

// InputLossActionForMsSmoothOut_Values returns all elements of the InputLossActionForMsSmoothOut enum
func InputLossActionForMsSmoothOut_Values() []string {
	return []string{
		InputLossActionForMsSmoothOutEmitOutput,
		InputLossActionForMsSmoothOutPauseOutput,
	}
}

// Input Loss Action For Rtmp Out
const (
	// InputLossActionForRtmpOutEmitOutput is a InputLossActionForRtmpOut enum value
	InputLossActionForRtmpOutEmitOutput = "EMIT_OUTPUT"

	// InputLossActionForRtmpOutPauseOutput is a InputLossActionForRtmpOut enum value
	InputLossActionForRtmpOutPauseOutput = "PAUSE_OUTPUT"
)

// InputLossActionForRtmpOut_Values returns all elements of the InputLossActionForRtmpOut enum
func InputLossActionForRtmpOut_Values() []string {
	return []string{
		InputLossActionForRtmpOutEmitOutput,
		InputLossActionForRtmpOutPauseOutput,
	}
}

// Input Loss Action For Udp Out
const (
	// InputLossActionForUdpOutDropProgram is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutDropProgram = "DROP_PROGRAM"

	// InputLossActionForUdpOutDropTs is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutDropTs = "DROP_TS"

	// InputLossActionForUdpOutEmitProgram is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutEmitProgram = "EMIT_PROGRAM"
)

// InputLossActionForUdpOut_Values returns all elements of the InputLossActionForUdpOut enum
func InputLossActionForUdpOut_Values() []string {
	return []string{
		InputLossActionForUdpOutDropProgram,
		InputLossActionForUdpOutDropTs,
		InputLossActionForUdpOutEmitProgram,
	}
}

// Input Loss Image Type
const (
	// InputLossImageTypeColor is a InputLossImageType enum value
	InputLossImageTypeColor = "COLOR"

	// InputLossImageTypeSlate is a InputLossImageType enum value
	InputLossImageTypeSlate = "SLATE"
)

// InputLossImageType_Values returns all elements of the InputLossImageType enum
func InputLossImageType_Values() []string {
	return []string{
		InputLossImageTypeColor,
		InputLossImageTypeSlate,
	}
}

// Maximum input bitrate in megabits per second. Bitrates up to 50 Mbps are
// supported currently.
const (
	// InputMaximumBitrateMax10Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax10Mbps = "MAX_10_MBPS"

	// InputMaximumBitrateMax20Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax20Mbps = "MAX_20_MBPS"

	// InputMaximumBitrateMax50Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax50Mbps = "MAX_50_MBPS"
)

// InputMaximumBitrate_Values returns all elements of the InputMaximumBitrate enum
func InputMaximumBitrate_Values() []string {
	return []string{
		InputMaximumBitrateMax10Mbps,
		InputMaximumBitrateMax20Mbps,
		InputMaximumBitrateMax50Mbps,
	}
}

// Input preference when deciding which input to make active when a previously
// failed input has recovered.If \"EQUAL_INPUT_PREFERENCE\", then the active
// input will stay active as long as it is healthy.If \"PRIMARY_INPUT_PREFERRED\",
// then always switch back to the primary input when it is healthy.
const (
	// InputPreferenceEqualInputPreference is a InputPreference enum value
	InputPreferenceEqualInputPreference = "EQUAL_INPUT_PREFERENCE"

	// InputPreferencePrimaryInputPreferred is a InputPreference enum value
	InputPreferencePrimaryInputPreferred = "PRIMARY_INPUT_PREFERRED"
)

// InputPreference_Values returns all elements of the InputPreference enum
func InputPreference_Values() []string {
	return []string{
		InputPreferenceEqualInputPreference,
		InputPreferencePrimaryInputPreferred,
	}
}

// Input resolution based on lines of vertical resolution in the input; SD is
// less than 720 lines, HD is 720 to 1080 lines, UHD is greater than 1080 lines
const (
	// InputResolutionSd is a InputResolution enum value
	InputResolutionSd = "SD"

	// InputResolutionHd is a InputResolution enum value
	InputResolutionHd = "HD"

	// InputResolutionUhd is a InputResolution enum value
	InputResolutionUhd = "UHD"
)

// InputResolution_Values returns all elements of the InputResolution enum
func InputResolution_Values() []string {
	return []string{
		InputResolutionSd,
		InputResolutionHd,
		InputResolutionUhd,
	}
}

const (
	// InputSecurityGroupStateIdle is a InputSecurityGroupState enum value
	InputSecurityGroupStateIdle = "IDLE"

	// InputSecurityGroupStateInUse is a InputSecurityGroupState enum value
	InputSecurityGroupStateInUse = "IN_USE"

	// InputSecurityGroupStateUpdating is a InputSecurityGroupState enum value
	InputSecurityGroupStateUpdating = "UPDATING"

	// InputSecurityGroupStateDeleted is a InputSecurityGroupState enum value
	InputSecurityGroupStateDeleted = "DELETED"
)

// InputSecurityGroupState_Values returns all elements of the InputSecurityGroupState enum
func InputSecurityGroupState_Values() []string {
	return []string{
		InputSecurityGroupStateIdle,
		InputSecurityGroupStateInUse,
		InputSecurityGroupStateUpdating,
		InputSecurityGroupStateDeleted,
	}
}

// Input Source End Behavior
const (
	// InputSourceEndBehaviorContinue is a InputSourceEndBehavior enum value
	InputSourceEndBehaviorContinue = "CONTINUE"

	// InputSourceEndBehaviorLoop is a InputSourceEndBehavior enum value
	InputSourceEndBehaviorLoop = "LOOP"
)

// InputSourceEndBehavior_Values returns all elements of the InputSourceEndBehavior enum
func InputSourceEndBehavior_Values() []string {
	return []string{
		InputSourceEndBehaviorContinue,
		InputSourceEndBehaviorLoop,
	}
}

// There are two types of input sources, static and dynamic. If an input source
// is dynamic you canchange the source url of the input dynamically using an
// input switch action. However, the only input typeto support a dynamic url
// at this time is MP4_FILE. By default all input sources are static.
const (
	// InputSourceTypeStatic is a InputSourceType enum value
	InputSourceTypeStatic = "STATIC"

	// InputSourceTypeDynamic is a InputSourceType enum value
	InputSourceTypeDynamic = "DYNAMIC"
)

// InputSourceType_Values returns all elements of the InputSourceType enum
func InputSourceType_Values() []string {
	return []string{
		InputSourceTypeStatic,
		InputSourceTypeDynamic,
	}
}

const (
	// InputStateCreating is a InputState enum value
	InputStateCreating = "CREATING"

	// InputStateDetached is a InputState enum value
	InputStateDetached = "DETACHED"

	// InputStateAttached is a InputState enum value
	InputStateAttached = "ATTACHED"

	// InputStateDeleting is a InputState enum value
	InputStateDeleting = "DELETING"

	// InputStateDeleted is a InputState enum value
	InputStateDeleted = "DELETED"
)

// InputState_Values returns all elements of the InputState enum
func InputState_Values() []string {
	return []string{
		InputStateCreating,
		InputStateDetached,
		InputStateAttached,
		InputStateDeleting,
		InputStateDeleted,
	}
}

// To clip the file, you must specify the timecode for the start and end of
// the clip. Specify EMBEDDED to use the timecode embedded in the source content.
// The embedded timecode must exist in the source content, otherwise MediaLive
// will output black frames until it reaches the end of the source. Specify
// ZEROBASED to use a timecode that assumes that the first frame in the file
// has the timestamp 00:00:00.00. There is no default for this field, you must
// specify a value.
const (
	// InputTimecodeSourceZerobased is a InputTimecodeSource enum value
	InputTimecodeSourceZerobased = "ZEROBASED"

	// InputTimecodeSourceEmbedded is a InputTimecodeSource enum value
	InputTimecodeSourceEmbedded = "EMBEDDED"
)

// InputTimecodeSource_Values returns all elements of the InputTimecodeSource enum
func InputTimecodeSource_Values() []string {
	return []string{
		InputTimecodeSourceZerobased,
		InputTimecodeSourceEmbedded,
	}
}

const (
	// InputTypeUdpPush is a InputType enum value
	InputTypeUdpPush = "UDP_PUSH"

	// InputTypeRtpPush is a InputType enum value
	InputTypeRtpPush = "RTP_PUSH"

	// InputTypeRtmpPush is a InputType enum value
	InputTypeRtmpPush = "RTMP_PUSH"

	// InputTypeRtmpPull is a InputType enum value
	InputTypeRtmpPull = "RTMP_PULL"

	// InputTypeUrlPull is a InputType enum value
	InputTypeUrlPull = "URL_PULL"

	// InputTypeMp4File is a InputType enum value
	InputTypeMp4File = "MP4_FILE"

	// InputTypeMediaconnect is a InputType enum value
	InputTypeMediaconnect = "MEDIACONNECT"

	// InputTypeInputDevice is a InputType enum value
	InputTypeInputDevice = "INPUT_DEVICE"
)

// InputType_Values returns all elements of the InputType enum
func InputType_Values() []string {
	return []string{
		InputTypeUdpPush,
		InputTypeRtpPush,
		InputTypeRtmpPush,
		InputTypeRtmpPull,
		InputTypeUrlPull,
		InputTypeMp4File,
		InputTypeMediaconnect,
		InputTypeInputDevice,
	}
}

// If you specify a StopTimecode in an input (in order to clip the file), you
// can specify if you want the clip to exclude (the default) or include the
// frame specified by the timecode.
const (
	// LastFrameClippingBehaviorExcludeLastFrame is a LastFrameClippingBehavior enum value
	LastFrameClippingBehaviorExcludeLastFrame = "EXCLUDE_LAST_FRAME"

	// LastFrameClippingBehaviorIncludeLastFrame is a LastFrameClippingBehavior enum value
	LastFrameClippingBehaviorIncludeLastFrame = "INCLUDE_LAST_FRAME"
)

// LastFrameClippingBehavior_Values returns all elements of the LastFrameClippingBehavior enum
func LastFrameClippingBehavior_Values() []string {
	return []string{
		LastFrameClippingBehaviorExcludeLastFrame,
		LastFrameClippingBehaviorIncludeLastFrame,
	}
}

// The log level the user wants for their channel.
const (
	// LogLevelError is a LogLevel enum value
	LogLevelError = "ERROR"

	// LogLevelWarning is a LogLevel enum value
	LogLevelWarning = "WARNING"

	// LogLevelInfo is a LogLevel enum value
	LogLevelInfo = "INFO"

	// LogLevelDebug is a LogLevel enum value
	LogLevelDebug = "DEBUG"

	// LogLevelDisabled is a LogLevel enum value
	LogLevelDisabled = "DISABLED"
)

// LogLevel_Values returns all elements of the LogLevel enum
func LogLevel_Values() []string {
	return []string{
		LogLevelError,
		LogLevelWarning,
		LogLevelInfo,
		LogLevelDebug,
		LogLevelDisabled,
	}
}

// M2ts Absent Input Audio Behavior
const (
	// M2tsAbsentInputAudioBehaviorDrop is a M2tsAbsentInputAudioBehavior enum value
	M2tsAbsentInputAudioBehaviorDrop = "DROP"

	// M2tsAbsentInputAudioBehaviorEncodeSilence is a M2tsAbsentInputAudioBehavior enum value
	M2tsAbsentInputAudioBehaviorEncodeSilence = "ENCODE_SILENCE"
)

// M2tsAbsentInputAudioBehavior_Values returns all elements of the M2tsAbsentInputAudioBehavior enum
func M2tsAbsentInputAudioBehavior_Values() []string {
	return []string{
		M2tsAbsentInputAudioBehaviorDrop,
		M2tsAbsentInputAudioBehaviorEncodeSilence,
	}
}

// M2ts Arib
const (
	// M2tsAribDisabled is a M2tsArib enum value
	M2tsAribDisabled = "DISABLED"

	// M2tsAribEnabled is a M2tsArib enum value
	M2tsAribEnabled = "ENABLED"
)

// M2tsArib_Values returns all elements of the M2tsArib enum
func M2tsArib_Values() []string {
	return []string{
		M2tsAribDisabled,
		M2tsAribEnabled,
	}
}

// M2ts Arib Captions Pid Control
const (
	// M2tsAribCaptionsPidControlAuto is a M2tsAribCaptionsPidControl enum value
	M2tsAribCaptionsPidControlAuto = "AUTO"

	// M2tsAribCaptionsPidControlUseConfigured is a M2tsAribCaptionsPidControl enum value
	M2tsAribCaptionsPidControlUseConfigured = "USE_CONFIGURED"
)

// M2tsAribCaptionsPidControl_Values returns all elements of the M2tsAribCaptionsPidControl enum
func M2tsAribCaptionsPidControl_Values() []string {
	return []string{
		M2tsAribCaptionsPidControlAuto,
		M2tsAribCaptionsPidControlUseConfigured,
	}
}

// M2ts Audio Buffer Model
const (
	// M2tsAudioBufferModelAtsc is a M2tsAudioBufferModel enum value
	M2tsAudioBufferModelAtsc = "ATSC"

	// M2tsAudioBufferModelDvb is a M2tsAudioBufferModel enum value
	M2tsAudioBufferModelDvb = "DVB"
)

// M2tsAudioBufferModel_Values returns all elements of the M2tsAudioBufferModel enum
func M2tsAudioBufferModel_Values() []string {
	return []string{
		M2tsAudioBufferModelAtsc,
		M2tsAudioBufferModelDvb,
	}
}

// M2ts Audio Interval
const (
	// M2tsAudioIntervalVideoAndFixedIntervals is a M2tsAudioInterval enum value
	M2tsAudioIntervalVideoAndFixedIntervals = "VIDEO_AND_FIXED_INTERVALS"

	// M2tsAudioIntervalVideoInterval is a M2tsAudioInterval enum value
	M2tsAudioIntervalVideoInterval = "VIDEO_INTERVAL"
)

// M2tsAudioInterval_Values returns all elements of the M2tsAudioInterval enum
func M2tsAudioInterval_Values() []string {
	return []string{
		M2tsAudioIntervalVideoAndFixedIntervals,
		M2tsAudioIntervalVideoInterval,
	}
}

// M2ts Audio Stream Type
const (
	// M2tsAudioStreamTypeAtsc is a M2tsAudioStreamType enum value
	M2tsAudioStreamTypeAtsc = "ATSC"

	// M2tsAudioStreamTypeDvb is a M2tsAudioStreamType enum value
	M2tsAudioStreamTypeDvb = "DVB"
)

// M2tsAudioStreamType_Values returns all elements of the M2tsAudioStreamType enum
func M2tsAudioStreamType_Values() []string {
	return []string{
		M2tsAudioStreamTypeAtsc,
		M2tsAudioStreamTypeDvb,
	}
}

// M2ts Buffer Model
const (
	// M2tsBufferModelMultiplex is a M2tsBufferModel enum value
	M2tsBufferModelMultiplex = "MULTIPLEX"

	// M2tsBufferModelNone is a M2tsBufferModel enum value
	M2tsBufferModelNone = "NONE"
)

// M2tsBufferModel_Values returns all elements of the M2tsBufferModel enum
func M2tsBufferModel_Values() []string {
	return []string{
		M2tsBufferModelMultiplex,
		M2tsBufferModelNone,
	}
}

// M2ts Cc Descriptor
const (
	// M2tsCcDescriptorDisabled is a M2tsCcDescriptor enum value
	M2tsCcDescriptorDisabled = "DISABLED"

	// M2tsCcDescriptorEnabled is a M2tsCcDescriptor enum value
	M2tsCcDescriptorEnabled = "ENABLED"
)

// M2tsCcDescriptor_Values returns all elements of the M2tsCcDescriptor enum
func M2tsCcDescriptor_Values() []string {
	return []string{
		M2tsCcDescriptorDisabled,
		M2tsCcDescriptorEnabled,
	}
}

// M2ts Ebif Control
const (
	// M2tsEbifControlNone is a M2tsEbifControl enum value
	M2tsEbifControlNone = "NONE"

	// M2tsEbifControlPassthrough is a M2tsEbifControl enum value
	M2tsEbifControlPassthrough = "PASSTHROUGH"
)

// M2tsEbifControl_Values returns all elements of the M2tsEbifControl enum
func M2tsEbifControl_Values() []string {
	return []string{
		M2tsEbifControlNone,
		M2tsEbifControlPassthrough,
	}
}

// M2ts Ebp Placement
const (
	// M2tsEbpPlacementVideoAndAudioPids is a M2tsEbpPlacement enum value
	M2tsEbpPlacementVideoAndAudioPids = "VIDEO_AND_AUDIO_PIDS"

	// M2tsEbpPlacementVideoPid is a M2tsEbpPlacement enum value
	M2tsEbpPlacementVideoPid = "VIDEO_PID"
)

// M2tsEbpPlacement_Values returns all elements of the M2tsEbpPlacement enum
func M2tsEbpPlacement_Values() []string {
	return []string{
		M2tsEbpPlacementVideoAndAudioPids,
		M2tsEbpPlacementVideoPid,
	}
}

// M2ts Es Rate In Pes
const (
	// M2tsEsRateInPesExclude is a M2tsEsRateInPes enum value
	M2tsEsRateInPesExclude = "EXCLUDE"

	// M2tsEsRateInPesInclude is a M2tsEsRateInPes enum value
	M2tsEsRateInPesInclude = "INCLUDE"
)

// M2tsEsRateInPes_Values returns all elements of the M2tsEsRateInPes enum
func M2tsEsRateInPes_Values() []string {
	return []string{
		M2tsEsRateInPesExclude,
		M2tsEsRateInPesInclude,
	}
}

// M2ts Klv
const (
	// M2tsKlvNone is a M2tsKlv enum value
	M2tsKlvNone = "NONE"

	// M2tsKlvPassthrough is a M2tsKlv enum value
	M2tsKlvPassthrough = "PASSTHROUGH"
)

// M2tsKlv_Values returns all elements of the M2tsKlv enum
func M2tsKlv_Values() []string {
	return []string{
		M2tsKlvNone,
		M2tsKlvPassthrough,
	}
}

// M2ts Nielsen Id3 Behavior
const (
	// M2tsNielsenId3BehaviorNoPassthrough is a M2tsNielsenId3Behavior enum value
	M2tsNielsenId3BehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M2tsNielsenId3BehaviorPassthrough is a M2tsNielsenId3Behavior enum value
	M2tsNielsenId3BehaviorPassthrough = "PASSTHROUGH"
)

// M2tsNielsenId3Behavior_Values returns all elements of the M2tsNielsenId3Behavior enum
func M2tsNielsenId3Behavior_Values() []string {
	return []string{
		M2tsNielsenId3BehaviorNoPassthrough,
		M2tsNielsenId3BehaviorPassthrough,
	}
}

// M2ts Pcr Control
const (
	// M2tsPcrControlConfiguredPcrPeriod is a M2tsPcrControl enum value
	M2tsPcrControlConfiguredPcrPeriod = "CONFIGURED_PCR_PERIOD"

	// M2tsPcrControlPcrEveryPesPacket is a M2tsPcrControl enum value
	M2tsPcrControlPcrEveryPesPacket = "PCR_EVERY_PES_PACKET"
)

// M2tsPcrControl_Values returns all elements of the M2tsPcrControl enum
func M2tsPcrControl_Values() []string {
	return []string{
		M2tsPcrControlConfiguredPcrPeriod,
		M2tsPcrControlPcrEveryPesPacket,
	}
}

// M2ts Rate Mode
const (
	// M2tsRateModeCbr is a M2tsRateMode enum value
	M2tsRateModeCbr = "CBR"

	// M2tsRateModeVbr is a M2tsRateMode enum value
	M2tsRateModeVbr = "VBR"
)

// M2tsRateMode_Values returns all elements of the M2tsRateMode enum
func M2tsRateMode_Values() []string {
	return []string{
		M2tsRateModeCbr,
		M2tsRateModeVbr,
	}
}

// M2ts Scte35 Control
const (
	// M2tsScte35ControlNone is a M2tsScte35Control enum value
	M2tsScte35ControlNone = "NONE"

	// M2tsScte35ControlPassthrough is a M2tsScte35Control enum value
	M2tsScte35ControlPassthrough = "PASSTHROUGH"
)

// M2tsScte35Control_Values returns all elements of the M2tsScte35Control enum
func M2tsScte35Control_Values() []string {
	return []string{
		M2tsScte35ControlNone,
		M2tsScte35ControlPassthrough,
	}
}

// M2ts Segmentation Markers
const (
	// M2tsSegmentationMarkersEbp is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersEbp = "EBP"

	// M2tsSegmentationMarkersEbpLegacy is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersEbpLegacy = "EBP_LEGACY"

	// M2tsSegmentationMarkersNone is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersNone = "NONE"

	// M2tsSegmentationMarkersPsiSegstart is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersPsiSegstart = "PSI_SEGSTART"

	// M2tsSegmentationMarkersRaiAdapt is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersRaiAdapt = "RAI_ADAPT"

	// M2tsSegmentationMarkersRaiSegstart is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersRaiSegstart = "RAI_SEGSTART"
)

// M2tsSegmentationMarkers_Values returns all elements of the M2tsSegmentationMarkers enum
func M2tsSegmentationMarkers_Values() []string {
	return []string{
		M2tsSegmentationMarkersEbp,
		M2tsSegmentationMarkersEbpLegacy,
		M2tsSegmentationMarkersNone,
		M2tsSegmentationMarkersPsiSegstart,
		M2tsSegmentationMarkersRaiAdapt,
		M2tsSegmentationMarkersRaiSegstart,
	}
}

// M2ts Segmentation Style
const (
	// M2tsSegmentationStyleMaintainCadence is a M2tsSegmentationStyle enum value
	M2tsSegmentationStyleMaintainCadence = "MAINTAIN_CADENCE"

	// M2tsSegmentationStyleResetCadence is a M2tsSegmentationStyle enum value
	M2tsSegmentationStyleResetCadence = "RESET_CADENCE"
)

// M2tsSegmentationStyle_Values returns all elements of the M2tsSegmentationStyle enum
func M2tsSegmentationStyle_Values() []string {
	return []string{
		M2tsSegmentationStyleMaintainCadence,
		M2tsSegmentationStyleResetCadence,
	}
}

// M2ts Timed Metadata Behavior
const (
	// M2tsTimedMetadataBehaviorNoPassthrough is a M2tsTimedMetadataBehavior enum value
	M2tsTimedMetadataBehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M2tsTimedMetadataBehaviorPassthrough is a M2tsTimedMetadataBehavior enum value
	M2tsTimedMetadataBehaviorPassthrough = "PASSTHROUGH"
)

// M2tsTimedMetadataBehavior_Values returns all elements of the M2tsTimedMetadataBehavior enum
func M2tsTimedMetadataBehavior_Values() []string {
	return []string{
		M2tsTimedMetadataBehaviorNoPassthrough,
		M2tsTimedMetadataBehaviorPassthrough,
	}
}

// M3u8 Nielsen Id3 Behavior
const (
	// M3u8NielsenId3BehaviorNoPassthrough is a M3u8NielsenId3Behavior enum value
	M3u8NielsenId3BehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M3u8NielsenId3BehaviorPassthrough is a M3u8NielsenId3Behavior enum value
	M3u8NielsenId3BehaviorPassthrough = "PASSTHROUGH"
)

// M3u8NielsenId3Behavior_Values returns all elements of the M3u8NielsenId3Behavior enum
func M3u8NielsenId3Behavior_Values() []string {
	return []string{
		M3u8NielsenId3BehaviorNoPassthrough,
		M3u8NielsenId3BehaviorPassthrough,
	}
}

// M3u8 Pcr Control
const (
	// M3u8PcrControlConfiguredPcrPeriod is a M3u8PcrControl enum value
	M3u8PcrControlConfiguredPcrPeriod = "CONFIGURED_PCR_PERIOD"

	// M3u8PcrControlPcrEveryPesPacket is a M3u8PcrControl enum value
	M3u8PcrControlPcrEveryPesPacket = "PCR_EVERY_PES_PACKET"
)

// M3u8PcrControl_Values returns all elements of the M3u8PcrControl enum
func M3u8PcrControl_Values() []string {
	return []string{
		M3u8PcrControlConfiguredPcrPeriod,
		M3u8PcrControlPcrEveryPesPacket,
	}
}

// M3u8 Scte35 Behavior
const (
	// M3u8Scte35BehaviorNoPassthrough is a M3u8Scte35Behavior enum value
	M3u8Scte35BehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M3u8Scte35BehaviorPassthrough is a M3u8Scte35Behavior enum value
	M3u8Scte35BehaviorPassthrough = "PASSTHROUGH"
)

// M3u8Scte35Behavior_Values returns all elements of the M3u8Scte35Behavior enum
func M3u8Scte35Behavior_Values() []string {
	return []string{
		M3u8Scte35BehaviorNoPassthrough,
		M3u8Scte35BehaviorPassthrough,
	}
}

// M3u8 Timed Metadata Behavior
const (
	// M3u8TimedMetadataBehaviorNoPassthrough is a M3u8TimedMetadataBehavior enum value
	M3u8TimedMetadataBehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M3u8TimedMetadataBehaviorPassthrough is a M3u8TimedMetadataBehavior enum value
	M3u8TimedMetadataBehaviorPassthrough = "PASSTHROUGH"
)

// M3u8TimedMetadataBehavior_Values returns all elements of the M3u8TimedMetadataBehavior enum
func M3u8TimedMetadataBehavior_Values() []string {
	return []string{
		M3u8TimedMetadataBehaviorNoPassthrough,
		M3u8TimedMetadataBehaviorPassthrough,
	}
}

// Mp2 Coding Mode
const (
	// Mp2CodingModeCodingMode10 is a Mp2CodingMode enum value
	Mp2CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Mp2CodingModeCodingMode20 is a Mp2CodingMode enum value
	Mp2CodingModeCodingMode20 = "CODING_MODE_2_0"
)

// Mp2CodingMode_Values returns all elements of the Mp2CodingMode enum
func Mp2CodingMode_Values() []string {
	return []string{
		Mp2CodingModeCodingMode10,
		Mp2CodingModeCodingMode20,
	}
}

// Ms Smooth H265 Packaging Type
const (
	// MsSmoothH265PackagingTypeHev1 is a MsSmoothH265PackagingType enum value
	MsSmoothH265PackagingTypeHev1 = "HEV1"

	// MsSmoothH265PackagingTypeHvc1 is a MsSmoothH265PackagingType enum value
	MsSmoothH265PackagingTypeHvc1 = "HVC1"
)

// MsSmoothH265PackagingType_Values returns all elements of the MsSmoothH265PackagingType enum
func MsSmoothH265PackagingType_Values() []string {
	return []string{
		MsSmoothH265PackagingTypeHev1,
		MsSmoothH265PackagingTypeHvc1,
	}
}

// The current state of the multiplex.
const (
	// MultiplexStateCreating is a MultiplexState enum value
	MultiplexStateCreating = "CREATING"

	// MultiplexStateCreateFailed is a MultiplexState enum value
	MultiplexStateCreateFailed = "CREATE_FAILED"

	// MultiplexStateIdle is a MultiplexState enum value
	MultiplexStateIdle = "IDLE"

	// MultiplexStateStarting is a MultiplexState enum value
	MultiplexStateStarting = "STARTING"

	// MultiplexStateRunning is a MultiplexState enum value
	MultiplexStateRunning = "RUNNING"

	// MultiplexStateRecovering is a MultiplexState enum value
	MultiplexStateRecovering = "RECOVERING"

	// MultiplexStateStopping is a MultiplexState enum value
	MultiplexStateStopping = "STOPPING"

	// MultiplexStateDeleting is a MultiplexState enum value
	MultiplexStateDeleting = "DELETING"

	// MultiplexStateDeleted is a MultiplexState enum value
	MultiplexStateDeleted = "DELETED"
)

// MultiplexState_Values returns all elements of the MultiplexState enum
func MultiplexState_Values() []string {
	return []string{
		MultiplexStateCreating,
		MultiplexStateCreateFailed,
		MultiplexStateIdle,
		MultiplexStateStarting,
		MultiplexStateRunning,
		MultiplexStateRecovering,
		MultiplexStateStopping,
		MultiplexStateDeleting,
		MultiplexStateDeleted,
	}
}

// Network Input Server Validation
const (
	// NetworkInputServerValidationCheckCryptographyAndValidateName is a NetworkInputServerValidation enum value
	NetworkInputServerValidationCheckCryptographyAndValidateName = "CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME"

	// NetworkInputServerValidationCheckCryptographyOnly is a NetworkInputServerValidation enum value
	NetworkInputServerValidationCheckCryptographyOnly = "CHECK_CRYPTOGRAPHY_ONLY"
)

// NetworkInputServerValidation_Values returns all elements of the NetworkInputServerValidation enum
func NetworkInputServerValidation_Values() []string {
	return []string{
		NetworkInputServerValidationCheckCryptographyAndValidateName,
		NetworkInputServerValidationCheckCryptographyOnly,
	}
}

// State of Nielsen PCM to ID3 tagging
const (
	// NielsenPcmToId3TaggingStateDisabled is a NielsenPcmToId3TaggingState enum value
	NielsenPcmToId3TaggingStateDisabled = "DISABLED"

	// NielsenPcmToId3TaggingStateEnabled is a NielsenPcmToId3TaggingState enum value
	NielsenPcmToId3TaggingStateEnabled = "ENABLED"
)

// NielsenPcmToId3TaggingState_Values returns all elements of the NielsenPcmToId3TaggingState enum
func NielsenPcmToId3TaggingState_Values() []string {
	return []string{
		NielsenPcmToId3TaggingStateDisabled,
		NielsenPcmToId3TaggingStateEnabled,
	}
}

// Units for duration, e.g. 'MONTHS'
const (
	// OfferingDurationUnitsMonths is a OfferingDurationUnits enum value
	OfferingDurationUnitsMonths = "MONTHS"
)

// OfferingDurationUnits_Values returns all elements of the OfferingDurationUnits enum
func OfferingDurationUnits_Values() []string {
	return []string{
		OfferingDurationUnitsMonths,
	}
}

// Offering type, e.g. 'NO_UPFRONT'
const (
	// OfferingTypeNoUpfront is a OfferingType enum value
	OfferingTypeNoUpfront = "NO_UPFRONT"
)

// OfferingType_Values returns all elements of the OfferingType enum
func OfferingType_Values() []string {
	return []string{
		OfferingTypeNoUpfront,
	}
}

// Pipeline ID
const (
	// PipelineIdPipeline0 is a PipelineId enum value
	PipelineIdPipeline0 = "PIPELINE_0"

	// PipelineIdPipeline1 is a PipelineId enum value
	PipelineIdPipeline1 = "PIPELINE_1"
)

// PipelineId_Values returns all elements of the PipelineId enum
func PipelineId_Values() []string {
	return []string{
		PipelineIdPipeline0,
		PipelineIdPipeline1,
	}
}

// Indicates which pipeline is preferred by the multiplex for program ingest.If
// set to \"PIPELINE_0\" or \"PIPELINE_1\" and an unhealthy ingest causes the
// multiplex to switch to the non-preferred pipeline,it will switch back once
// that ingest is healthy again. If set to \"CURRENTLY_ACTIVE\",it will not
// switch back to the other pipeline based on it recovering to a healthy state,it
// will only switch if the active pipeline becomes unhealthy.
const (
	// PreferredChannelPipelineCurrentlyActive is a PreferredChannelPipeline enum value
	PreferredChannelPipelineCurrentlyActive = "CURRENTLY_ACTIVE"

	// PreferredChannelPipelinePipeline0 is a PreferredChannelPipeline enum value
	PreferredChannelPipelinePipeline0 = "PIPELINE_0"

	// PreferredChannelPipelinePipeline1 is a PreferredChannelPipeline enum value
	PreferredChannelPipelinePipeline1 = "PIPELINE_1"
)

// PreferredChannelPipeline_Values returns all elements of the PreferredChannelPipeline enum
func PreferredChannelPipeline_Values() []string {
	return []string{
		PreferredChannelPipelineCurrentlyActive,
		PreferredChannelPipelinePipeline0,
		PreferredChannelPipelinePipeline1,
	}
}

// Codec, 'MPEG2', 'AVC', 'HEVC', or 'AUDIO'
const (
	// ReservationCodecMpeg2 is a ReservationCodec enum value
	ReservationCodecMpeg2 = "MPEG2"

	// ReservationCodecAvc is a ReservationCodec enum value
	ReservationCodecAvc = "AVC"

	// ReservationCodecHevc is a ReservationCodec enum value
	ReservationCodecHevc = "HEVC"

	// ReservationCodecAudio is a ReservationCodec enum value
	ReservationCodecAudio = "AUDIO"
)

// ReservationCodec_Values returns all elements of the ReservationCodec enum
func ReservationCodec_Values() []string {
	return []string{
		ReservationCodecMpeg2,
		ReservationCodecAvc,
		ReservationCodecHevc,
		ReservationCodecAudio,
	}
}

// Maximum bitrate in megabits per second
const (
	// ReservationMaximumBitrateMax10Mbps is a ReservationMaximumBitrate enum value
	ReservationMaximumBitrateMax10Mbps = "MAX_10_MBPS"

	// ReservationMaximumBitrateMax20Mbps is a ReservationMaximumBitrate enum value
	ReservationMaximumBitrateMax20Mbps = "MAX_20_MBPS"

	// ReservationMaximumBitrateMax50Mbps is a ReservationMaximumBitrate enum value
	ReservationMaximumBitrateMax50Mbps = "MAX_50_MBPS"
)

// ReservationMaximumBitrate_Values returns all elements of the ReservationMaximumBitrate enum
func ReservationMaximumBitrate_Values() []string {
	return []string{
		ReservationMaximumBitrateMax10Mbps,
		ReservationMaximumBitrateMax20Mbps,
		ReservationMaximumBitrateMax50Mbps,
	}
}

// Maximum framerate in frames per second (Outputs only)
const (
	// ReservationMaximumFramerateMax30Fps is a ReservationMaximumFramerate enum value
	ReservationMaximumFramerateMax30Fps = "MAX_30_FPS"

	// ReservationMaximumFramerateMax60Fps is a ReservationMaximumFramerate enum value
	ReservationMaximumFramerateMax60Fps = "MAX_60_FPS"
)

// ReservationMaximumFramerate_Values returns all elements of the ReservationMaximumFramerate enum
func ReservationMaximumFramerate_Values() []string {
	return []string{
		ReservationMaximumFramerateMax30Fps,
		ReservationMaximumFramerateMax60Fps,
	}
}

// Resolution based on lines of vertical resolution; SD is less than 720 lines,
// HD is 720 to 1080 lines, FHD is 1080 lines, UHD is greater than 1080 lines
const (
	// ReservationResolutionSd is a ReservationResolution enum value
	ReservationResolutionSd = "SD"

	// ReservationResolutionHd is a ReservationResolution enum value
	ReservationResolutionHd = "HD"

	// ReservationResolutionFhd is a ReservationResolution enum value
	ReservationResolutionFhd = "FHD"

	// ReservationResolutionUhd is a ReservationResolution enum value
	ReservationResolutionUhd = "UHD"
)

// ReservationResolution_Values returns all elements of the ReservationResolution enum
func ReservationResolution_Values() []string {
	return []string{
		ReservationResolutionSd,
		ReservationResolutionHd,
		ReservationResolutionFhd,
		ReservationResolutionUhd,
	}
}

// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
const (
	// ReservationResourceTypeInput is a ReservationResourceType enum value
	ReservationResourceTypeInput = "INPUT"

	// ReservationResourceTypeOutput is a ReservationResourceType enum value
	ReservationResourceTypeOutput = "OUTPUT"

	// ReservationResourceTypeMultiplex is a ReservationResourceType enum value
	ReservationResourceTypeMultiplex = "MULTIPLEX"

	// ReservationResourceTypeChannel is a ReservationResourceType enum value
	ReservationResourceTypeChannel = "CHANNEL"
)

// ReservationResourceType_Values returns all elements of the ReservationResourceType enum
func ReservationResourceType_Values() []string {
	return []string{
		ReservationResourceTypeInput,
		ReservationResourceTypeOutput,
		ReservationResourceTypeMultiplex,
		ReservationResourceTypeChannel,
	}
}

// Special features, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
const (
	// ReservationSpecialFeatureAdvancedAudio is a ReservationSpecialFeature enum value
	ReservationSpecialFeatureAdvancedAudio = "ADVANCED_AUDIO"

	// ReservationSpecialFeatureAudioNormalization is a ReservationSpecialFeature enum value
	ReservationSpecialFeatureAudioNormalization = "AUDIO_NORMALIZATION"
)

// ReservationSpecialFeature_Values returns all elements of the ReservationSpecialFeature enum
func ReservationSpecialFeature_Values() []string {
	return []string{
		ReservationSpecialFeatureAdvancedAudio,
		ReservationSpecialFeatureAudioNormalization,
	}
}

// Current reservation state
const (
	// ReservationStateActive is a ReservationState enum value
	ReservationStateActive = "ACTIVE"

	// ReservationStateExpired is a ReservationState enum value
	ReservationStateExpired = "EXPIRED"

	// ReservationStateCanceled is a ReservationState enum value
	ReservationStateCanceled = "CANCELED"

	// ReservationStateDeleted is a ReservationState enum value
	ReservationStateDeleted = "DELETED"
)

// ReservationState_Values returns all elements of the ReservationState enum
func ReservationState_Values() []string {
	return []string{
		ReservationStateActive,
		ReservationStateExpired,
		ReservationStateCanceled,
		ReservationStateDeleted,
	}
}

// Video quality, e.g. 'STANDARD' (Outputs only)
const (
	// ReservationVideoQualityStandard is a ReservationVideoQuality enum value
	ReservationVideoQualityStandard = "STANDARD"

	// ReservationVideoQualityEnhanced is a ReservationVideoQuality enum value
	ReservationVideoQualityEnhanced = "ENHANCED"

	// ReservationVideoQualityPremium is a ReservationVideoQuality enum value
	ReservationVideoQualityPremium = "PREMIUM"
)

// ReservationVideoQuality_Values returns all elements of the ReservationVideoQuality enum
func ReservationVideoQuality_Values() []string {
	return []string{
		ReservationVideoQualityStandard,
		ReservationVideoQualityEnhanced,
		ReservationVideoQualityPremium,
	}
}

// Rtmp Cache Full Behavior
const (
	// RtmpCacheFullBehaviorDisconnectImmediately is a RtmpCacheFullBehavior enum value
	RtmpCacheFullBehaviorDisconnectImmediately = "DISCONNECT_IMMEDIATELY"

	// RtmpCacheFullBehaviorWaitForServer is a RtmpCacheFullBehavior enum value
	RtmpCacheFullBehaviorWaitForServer = "WAIT_FOR_SERVER"
)

// RtmpCacheFullBehavior_Values returns all elements of the RtmpCacheFullBehavior enum
func RtmpCacheFullBehavior_Values() []string {
	return []string{
		RtmpCacheFullBehaviorDisconnectImmediately,
		RtmpCacheFullBehaviorWaitForServer,
	}
}

// Rtmp Caption Data
const (
	// RtmpCaptionDataAll is a RtmpCaptionData enum value
	RtmpCaptionDataAll = "ALL"

	// RtmpCaptionDataField1608 is a RtmpCaptionData enum value
	RtmpCaptionDataField1608 = "FIELD1_608"

	// RtmpCaptionDataField1AndField2608 is a RtmpCaptionData enum value
	RtmpCaptionDataField1AndField2608 = "FIELD1_AND_FIELD2_608"
)

// RtmpCaptionData_Values returns all elements of the RtmpCaptionData enum
func RtmpCaptionData_Values() []string {
	return []string{
		RtmpCaptionDataAll,
		RtmpCaptionDataField1608,
		RtmpCaptionDataField1AndField2608,
	}
}

// Rtmp Output Certificate Mode
const (
	// RtmpOutputCertificateModeSelfSigned is a RtmpOutputCertificateMode enum value
	RtmpOutputCertificateModeSelfSigned = "SELF_SIGNED"

	// RtmpOutputCertificateModeVerifyAuthenticity is a RtmpOutputCertificateMode enum value
	RtmpOutputCertificateModeVerifyAuthenticity = "VERIFY_AUTHENTICITY"
)

// RtmpOutputCertificateMode_Values returns all elements of the RtmpOutputCertificateMode enum
func RtmpOutputCertificateMode_Values() []string {
	return []string{
		RtmpOutputCertificateModeSelfSigned,
		RtmpOutputCertificateModeVerifyAuthenticity,
	}
}

// Scte20 Convert608 To708
const (
	// Scte20Convert608To708Disabled is a Scte20Convert608To708 enum value
	Scte20Convert608To708Disabled = "DISABLED"

	// Scte20Convert608To708Upconvert is a Scte20Convert608To708 enum value
	Scte20Convert608To708Upconvert = "UPCONVERT"
)

// Scte20Convert608To708_Values returns all elements of the Scte20Convert608To708 enum
func Scte20Convert608To708_Values() []string {
	return []string{
		Scte20Convert608To708Disabled,
		Scte20Convert608To708Upconvert,
	}
}

// Scte35 Apos No Regional Blackout Behavior
const (
	// Scte35AposNoRegionalBlackoutBehaviorFollow is a Scte35AposNoRegionalBlackoutBehavior enum value
	Scte35AposNoRegionalBlackoutBehaviorFollow = "FOLLOW"

	// Scte35AposNoRegionalBlackoutBehaviorIgnore is a Scte35AposNoRegionalBlackoutBehavior enum value
	Scte35AposNoRegionalBlackoutBehaviorIgnore = "IGNORE"
)

// Scte35AposNoRegionalBlackoutBehavior_Values returns all elements of the Scte35AposNoRegionalBlackoutBehavior enum
func Scte35AposNoRegionalBlackoutBehavior_Values() []string {
	return []string{
		Scte35AposNoRegionalBlackoutBehaviorFollow,
		Scte35AposNoRegionalBlackoutBehaviorIgnore,
	}
}

// Scte35 Apos Web Delivery Allowed Behavior
const (
	// Scte35AposWebDeliveryAllowedBehaviorFollow is a Scte35AposWebDeliveryAllowedBehavior enum value
	Scte35AposWebDeliveryAllowedBehaviorFollow = "FOLLOW"

	// Scte35AposWebDeliveryAllowedBehaviorIgnore is a Scte35AposWebDeliveryAllowedBehavior enum value
	Scte35AposWebDeliveryAllowedBehaviorIgnore = "IGNORE"
)

// Scte35AposWebDeliveryAllowedBehavior_Values returns all elements of the Scte35AposWebDeliveryAllowedBehavior enum
func Scte35AposWebDeliveryAllowedBehavior_Values() []string {
	return []string{
		Scte35AposWebDeliveryAllowedBehaviorFollow,
		Scte35AposWebDeliveryAllowedBehaviorIgnore,
	}
}

// Corresponds to the archive_allowed parameter. A value of ARCHIVE_NOT_ALLOWED
// corresponds to 0 (false) in the SCTE-35 specification. If you include one
// of the "restriction" flags then you must include all four of them.
const (
	// Scte35ArchiveAllowedFlagArchiveNotAllowed is a Scte35ArchiveAllowedFlag enum value
	Scte35ArchiveAllowedFlagArchiveNotAllowed = "ARCHIVE_NOT_ALLOWED"

	// Scte35ArchiveAllowedFlagArchiveAllowed is a Scte35ArchiveAllowedFlag enum value
	Scte35ArchiveAllowedFlagArchiveAllowed = "ARCHIVE_ALLOWED"
)

// Scte35ArchiveAllowedFlag_Values returns all elements of the Scte35ArchiveAllowedFlag enum
func Scte35ArchiveAllowedFlag_Values() []string {
	return []string{
		Scte35ArchiveAllowedFlagArchiveNotAllowed,
		Scte35ArchiveAllowedFlagArchiveAllowed,
	}
}

// Corresponds to the device_restrictions parameter in a segmentation_descriptor.
// If you include one of the "restriction" flags then you must include all four
// of them.
const (
	// Scte35DeviceRestrictionsNone is a Scte35DeviceRestrictions enum value
	Scte35DeviceRestrictionsNone = "NONE"

	// Scte35DeviceRestrictionsRestrictGroup0 is a Scte35DeviceRestrictions enum value
	Scte35DeviceRestrictionsRestrictGroup0 = "RESTRICT_GROUP0"

	// Scte35DeviceRestrictionsRestrictGroup1 is a Scte35DeviceRestrictions enum value
	Scte35DeviceRestrictionsRestrictGroup1 = "RESTRICT_GROUP1"

	// Scte35DeviceRestrictionsRestrictGroup2 is a Scte35DeviceRestrictions enum value
	Scte35DeviceRestrictionsRestrictGroup2 = "RESTRICT_GROUP2"
)

// Scte35DeviceRestrictions_Values returns all elements of the Scte35DeviceRestrictions enum
func Scte35DeviceRestrictions_Values() []string {
	return []string{
		Scte35DeviceRestrictionsNone,
		Scte35DeviceRestrictionsRestrictGroup0,
		Scte35DeviceRestrictionsRestrictGroup1,
		Scte35DeviceRestrictionsRestrictGroup2,
	}
}

// Corresponds to the no_regional_blackout_flag parameter. A value of REGIONAL_BLACKOUT
// corresponds to 0 (false) in the SCTE-35 specification. If you include one
// of the "restriction" flags then you must include all four of them.
const (
	// Scte35NoRegionalBlackoutFlagRegionalBlackout is a Scte35NoRegionalBlackoutFlag enum value
	Scte35NoRegionalBlackoutFlagRegionalBlackout = "REGIONAL_BLACKOUT"

	// Scte35NoRegionalBlackoutFlagNoRegionalBlackout is a Scte35NoRegionalBlackoutFlag enum value
	Scte35NoRegionalBlackoutFlagNoRegionalBlackout = "NO_REGIONAL_BLACKOUT"
)

// Scte35NoRegionalBlackoutFlag_Values returns all elements of the Scte35NoRegionalBlackoutFlag enum
func Scte35NoRegionalBlackoutFlag_Values() []string {
	return []string{
		Scte35NoRegionalBlackoutFlagRegionalBlackout,
		Scte35NoRegionalBlackoutFlagNoRegionalBlackout,
	}
}

// Corresponds to SCTE-35 segmentation_event_cancel_indicator. SEGMENTATION_EVENT_NOT_CANCELED
// corresponds to 0 in the SCTE-35 specification and indicates that this is
// an insertion request. SEGMENTATION_EVENT_CANCELED corresponds to 1 in the
// SCTE-35 specification and indicates that this is a cancelation request, in
// which case complete this field and the existing event ID to cancel.
const (
	// Scte35SegmentationCancelIndicatorSegmentationEventNotCanceled is a Scte35SegmentationCancelIndicator enum value
	Scte35SegmentationCancelIndicatorSegmentationEventNotCanceled = "SEGMENTATION_EVENT_NOT_CANCELED"

	// Scte35SegmentationCancelIndicatorSegmentationEventCanceled is a Scte35SegmentationCancelIndicator enum value
	Scte35SegmentationCancelIndicatorSegmentationEventCanceled = "SEGMENTATION_EVENT_CANCELED"
)

// Scte35SegmentationCancelIndicator_Values returns all elements of the Scte35SegmentationCancelIndicator enum
func Scte35SegmentationCancelIndicator_Values() []string {
	return []string{
		Scte35SegmentationCancelIndicatorSegmentationEventNotCanceled,
		Scte35SegmentationCancelIndicatorSegmentationEventCanceled,
	}
}

// Scte35 Splice Insert No Regional Blackout Behavior
const (
	// Scte35SpliceInsertNoRegionalBlackoutBehaviorFollow is a Scte35SpliceInsertNoRegionalBlackoutBehavior enum value
	Scte35SpliceInsertNoRegionalBlackoutBehaviorFollow = "FOLLOW"

	// Scte35SpliceInsertNoRegionalBlackoutBehaviorIgnore is a Scte35SpliceInsertNoRegionalBlackoutBehavior enum value
	Scte35SpliceInsertNoRegionalBlackoutBehaviorIgnore = "IGNORE"
)

// Scte35SpliceInsertNoRegionalBlackoutBehavior_Values returns all elements of the Scte35SpliceInsertNoRegionalBlackoutBehavior enum
func Scte35SpliceInsertNoRegionalBlackoutBehavior_Values() []string {
	return []string{
		Scte35SpliceInsertNoRegionalBlackoutBehaviorFollow,
		Scte35SpliceInsertNoRegionalBlackoutBehaviorIgnore,
	}
}

// Scte35 Splice Insert Web Delivery Allowed Behavior
const (
	// Scte35SpliceInsertWebDeliveryAllowedBehaviorFollow is a Scte35SpliceInsertWebDeliveryAllowedBehavior enum value
	Scte35SpliceInsertWebDeliveryAllowedBehaviorFollow = "FOLLOW"

	// Scte35SpliceInsertWebDeliveryAllowedBehaviorIgnore is a Scte35SpliceInsertWebDeliveryAllowedBehavior enum value
	Scte35SpliceInsertWebDeliveryAllowedBehaviorIgnore = "IGNORE"
)

// Scte35SpliceInsertWebDeliveryAllowedBehavior_Values returns all elements of the Scte35SpliceInsertWebDeliveryAllowedBehavior enum
func Scte35SpliceInsertWebDeliveryAllowedBehavior_Values() []string {
	return []string{
		Scte35SpliceInsertWebDeliveryAllowedBehaviorFollow,
		Scte35SpliceInsertWebDeliveryAllowedBehaviorIgnore,
	}
}

// Corresponds to the web_delivery_allowed_flag parameter. A value of WEB_DELIVERY_NOT_ALLOWED
// corresponds to 0 (false) in the SCTE-35 specification. If you include one
// of the "restriction" flags then you must include all four of them.
const (
	// Scte35WebDeliveryAllowedFlagWebDeliveryNotAllowed is a Scte35WebDeliveryAllowedFlag enum value
	Scte35WebDeliveryAllowedFlagWebDeliveryNotAllowed = "WEB_DELIVERY_NOT_ALLOWED"

	// Scte35WebDeliveryAllowedFlagWebDeliveryAllowed is a Scte35WebDeliveryAllowedFlag enum value
	Scte35WebDeliveryAllowedFlagWebDeliveryAllowed = "WEB_DELIVERY_ALLOWED"
)

// Scte35WebDeliveryAllowedFlag_Values returns all elements of the Scte35WebDeliveryAllowedFlag enum
func Scte35WebDeliveryAllowedFlag_Values() []string {
	return []string{
		Scte35WebDeliveryAllowedFlagWebDeliveryNotAllowed,
		Scte35WebDeliveryAllowedFlagWebDeliveryAllowed,
	}
}

// Smooth Group Audio Only Timecode Control
const (
	// SmoothGroupAudioOnlyTimecodeControlPassthrough is a SmoothGroupAudioOnlyTimecodeControl enum value
	SmoothGroupAudioOnlyTimecodeControlPassthrough = "PASSTHROUGH"

	// SmoothGroupAudioOnlyTimecodeControlUseConfiguredClock is a SmoothGroupAudioOnlyTimecodeControl enum value
	SmoothGroupAudioOnlyTimecodeControlUseConfiguredClock = "USE_CONFIGURED_CLOCK"
)

// SmoothGroupAudioOnlyTimecodeControl_Values returns all elements of the SmoothGroupAudioOnlyTimecodeControl enum
func SmoothGroupAudioOnlyTimecodeControl_Values() []string {
	return []string{
		SmoothGroupAudioOnlyTimecodeControlPassthrough,
		SmoothGroupAudioOnlyTimecodeControlUseConfiguredClock,
	}
}

// Smooth Group Certificate Mode
const (
	// SmoothGroupCertificateModeSelfSigned is a SmoothGroupCertificateMode enum value
	SmoothGroupCertificateModeSelfSigned = "SELF_SIGNED"

	// SmoothGroupCertificateModeVerifyAuthenticity is a SmoothGroupCertificateMode enum value
	SmoothGroupCertificateModeVerifyAuthenticity = "VERIFY_AUTHENTICITY"
)

// SmoothGroupCertificateMode_Values returns all elements of the SmoothGroupCertificateMode enum
func SmoothGroupCertificateMode_Values() []string {
	return []string{
		SmoothGroupCertificateModeSelfSigned,
		SmoothGroupCertificateModeVerifyAuthenticity,
	}
}

// Smooth Group Event Id Mode
const (
	// SmoothGroupEventIdModeNoEventId is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeNoEventId = "NO_EVENT_ID"

	// SmoothGroupEventIdModeUseConfigured is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeUseConfigured = "USE_CONFIGURED"

	// SmoothGroupEventIdModeUseTimestamp is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeUseTimestamp = "USE_TIMESTAMP"
)

// SmoothGroupEventIdMode_Values returns all elements of the SmoothGroupEventIdMode enum
func SmoothGroupEventIdMode_Values() []string {
	return []string{
		SmoothGroupEventIdModeNoEventId,
		SmoothGroupEventIdModeUseConfigured,
		SmoothGroupEventIdModeUseTimestamp,
	}
}

// Smooth Group Event Stop Behavior
const (
	// SmoothGroupEventStopBehaviorNone is a SmoothGroupEventStopBehavior enum value
	SmoothGroupEventStopBehaviorNone = "NONE"

	// SmoothGroupEventStopBehaviorSendEos is a SmoothGroupEventStopBehavior enum value
	SmoothGroupEventStopBehaviorSendEos = "SEND_EOS"
)

// SmoothGroupEventStopBehavior_Values returns all elements of the SmoothGroupEventStopBehavior enum
func SmoothGroupEventStopBehavior_Values() []string {
	return []string{
		SmoothGroupEventStopBehaviorNone,
		SmoothGroupEventStopBehaviorSendEos,
	}
}

// Smooth Group Segmentation Mode
const (
	// SmoothGroupSegmentationModeUseInputSegmentation is a SmoothGroupSegmentationMode enum value
	SmoothGroupSegmentationModeUseInputSegmentation = "USE_INPUT_SEGMENTATION"

	// SmoothGroupSegmentationModeUseSegmentDuration is a SmoothGroupSegmentationMode enum value
	SmoothGroupSegmentationModeUseSegmentDuration = "USE_SEGMENT_DURATION"
)

// SmoothGroupSegmentationMode_Values returns all elements of the SmoothGroupSegmentationMode enum
func SmoothGroupSegmentationMode_Values() []string {
	return []string{
		SmoothGroupSegmentationModeUseInputSegmentation,
		SmoothGroupSegmentationModeUseSegmentDuration,
	}
}

// Smooth Group Sparse Track Type
const (
	// SmoothGroupSparseTrackTypeNone is a SmoothGroupSparseTrackType enum value
	SmoothGroupSparseTrackTypeNone = "NONE"

	// SmoothGroupSparseTrackTypeScte35 is a SmoothGroupSparseTrackType enum value
	SmoothGroupSparseTrackTypeScte35 = "SCTE_35"

	// SmoothGroupSparseTrackTypeScte35WithoutSegmentation is a SmoothGroupSparseTrackType enum value
	SmoothGroupSparseTrackTypeScte35WithoutSegmentation = "SCTE_35_WITHOUT_SEGMENTATION"
)

// SmoothGroupSparseTrackType_Values returns all elements of the SmoothGroupSparseTrackType enum
func SmoothGroupSparseTrackType_Values() []string {
	return []string{
		SmoothGroupSparseTrackTypeNone,
		SmoothGroupSparseTrackTypeScte35,
		SmoothGroupSparseTrackTypeScte35WithoutSegmentation,
	}
}

// Smooth Group Stream Manifest Behavior
const (
	// SmoothGroupStreamManifestBehaviorDoNotSend is a SmoothGroupStreamManifestBehavior enum value
	SmoothGroupStreamManifestBehaviorDoNotSend = "DO_NOT_SEND"

	// SmoothGroupStreamManifestBehaviorSend is a SmoothGroupStreamManifestBehavior enum value
	SmoothGroupStreamManifestBehaviorSend = "SEND"
)

// SmoothGroupStreamManifestBehavior_Values returns all elements of the SmoothGroupStreamManifestBehavior enum
func SmoothGroupStreamManifestBehavior_Values() []string {
	return []string{
		SmoothGroupStreamManifestBehaviorDoNotSend,
		SmoothGroupStreamManifestBehaviorSend,
	}
}

// Smooth Group Timestamp Offset Mode
const (
	// SmoothGroupTimestampOffsetModeUseConfiguredOffset is a SmoothGroupTimestampOffsetMode enum value
	SmoothGroupTimestampOffsetModeUseConfiguredOffset = "USE_CONFIGURED_OFFSET"

	// SmoothGroupTimestampOffsetModeUseEventStartDate is a SmoothGroupTimestampOffsetMode enum value
	SmoothGroupTimestampOffsetModeUseEventStartDate = "USE_EVENT_START_DATE"
)

// SmoothGroupTimestampOffsetMode_Values returns all elements of the SmoothGroupTimestampOffsetMode enum
func SmoothGroupTimestampOffsetMode_Values() []string {
	return []string{
		SmoothGroupTimestampOffsetModeUseConfiguredOffset,
		SmoothGroupTimestampOffsetModeUseEventStartDate,
	}
}

// Smpte2038 Data Preference
const (
	// Smpte2038DataPreferenceIgnore is a Smpte2038DataPreference enum value
	Smpte2038DataPreferenceIgnore = "IGNORE"

	// Smpte2038DataPreferencePrefer is a Smpte2038DataPreference enum value
	Smpte2038DataPreferencePrefer = "PREFER"
)

// Smpte2038DataPreference_Values returns all elements of the Smpte2038DataPreference enum
func Smpte2038DataPreference_Values() []string {
	return []string{
		Smpte2038DataPreferenceIgnore,
		Smpte2038DataPreferencePrefer,
	}
}

// Temporal Filter Post Filter Sharpening
const (
	// TemporalFilterPostFilterSharpeningAuto is a TemporalFilterPostFilterSharpening enum value
	TemporalFilterPostFilterSharpeningAuto = "AUTO"

	// TemporalFilterPostFilterSharpeningDisabled is a TemporalFilterPostFilterSharpening enum value
	TemporalFilterPostFilterSharpeningDisabled = "DISABLED"

	// TemporalFilterPostFilterSharpeningEnabled is a TemporalFilterPostFilterSharpening enum value
	TemporalFilterPostFilterSharpeningEnabled = "ENABLED"
)

// TemporalFilterPostFilterSharpening_Values returns all elements of the TemporalFilterPostFilterSharpening enum
func TemporalFilterPostFilterSharpening_Values() []string {
	return []string{
		TemporalFilterPostFilterSharpeningAuto,
		TemporalFilterPostFilterSharpeningDisabled,
		TemporalFilterPostFilterSharpeningEnabled,
	}
}

// Temporal Filter Strength
const (
	// TemporalFilterStrengthAuto is a TemporalFilterStrength enum value
	TemporalFilterStrengthAuto = "AUTO"

	// TemporalFilterStrengthStrength1 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength1 = "STRENGTH_1"

	// TemporalFilterStrengthStrength2 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength2 = "STRENGTH_2"

	// TemporalFilterStrengthStrength3 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength3 = "STRENGTH_3"

	// TemporalFilterStrengthStrength4 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength4 = "STRENGTH_4"

	// TemporalFilterStrengthStrength5 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength5 = "STRENGTH_5"

	// TemporalFilterStrengthStrength6 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength6 = "STRENGTH_6"

	// TemporalFilterStrengthStrength7 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength7 = "STRENGTH_7"

	// TemporalFilterStrengthStrength8 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength8 = "STRENGTH_8"

	// TemporalFilterStrengthStrength9 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength9 = "STRENGTH_9"

	// TemporalFilterStrengthStrength10 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength10 = "STRENGTH_10"

	// TemporalFilterStrengthStrength11 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength11 = "STRENGTH_11"

	// TemporalFilterStrengthStrength12 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength12 = "STRENGTH_12"

	// TemporalFilterStrengthStrength13 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength13 = "STRENGTH_13"

	// TemporalFilterStrengthStrength14 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength14 = "STRENGTH_14"

	// TemporalFilterStrengthStrength15 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength15 = "STRENGTH_15"

	// TemporalFilterStrengthStrength16 is a TemporalFilterStrength enum value
	TemporalFilterStrengthStrength16 = "STRENGTH_16"
)

// TemporalFilterStrength_Values returns all elements of the TemporalFilterStrength enum
func TemporalFilterStrength_Values() []string {
	return []string{
		TemporalFilterStrengthAuto,
		TemporalFilterStrengthStrength1,
		TemporalFilterStrengthStrength2,
		TemporalFilterStrengthStrength3,
		TemporalFilterStrengthStrength4,
		TemporalFilterStrengthStrength5,
		TemporalFilterStrengthStrength6,
		TemporalFilterStrengthStrength7,
		TemporalFilterStrengthStrength8,
		TemporalFilterStrengthStrength9,
		TemporalFilterStrengthStrength10,
		TemporalFilterStrengthStrength11,
		TemporalFilterStrengthStrength12,
		TemporalFilterStrengthStrength13,
		TemporalFilterStrengthStrength14,
		TemporalFilterStrengthStrength15,
		TemporalFilterStrengthStrength16,
	}
}

// Timecode Config Source
const (
	// TimecodeConfigSourceEmbedded is a TimecodeConfigSource enum value
	TimecodeConfigSourceEmbedded = "EMBEDDED"

	// TimecodeConfigSourceSystemclock is a TimecodeConfigSource enum value
	TimecodeConfigSourceSystemclock = "SYSTEMCLOCK"

	// TimecodeConfigSourceZerobased is a TimecodeConfigSource enum value
	TimecodeConfigSourceZerobased = "ZEROBASED"
)

// TimecodeConfigSource_Values returns all elements of the TimecodeConfigSource enum
func TimecodeConfigSource_Values() []string {
	return []string{
		TimecodeConfigSourceEmbedded,
		TimecodeConfigSourceSystemclock,
		TimecodeConfigSourceZerobased,
	}
}

// Ttml Destination Style Control
const (
	// TtmlDestinationStyleControlPassthrough is a TtmlDestinationStyleControl enum value
	TtmlDestinationStyleControlPassthrough = "PASSTHROUGH"

	// TtmlDestinationStyleControlUseConfigured is a TtmlDestinationStyleControl enum value
	TtmlDestinationStyleControlUseConfigured = "USE_CONFIGURED"
)

// TtmlDestinationStyleControl_Values returns all elements of the TtmlDestinationStyleControl enum
func TtmlDestinationStyleControl_Values() []string {
	return []string{
		TtmlDestinationStyleControlPassthrough,
		TtmlDestinationStyleControlUseConfigured,
	}
}

// Udp Timed Metadata Id3 Frame
const (
	// UdpTimedMetadataId3FrameNone is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FrameNone = "NONE"

	// UdpTimedMetadataId3FramePriv is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FramePriv = "PRIV"

	// UdpTimedMetadataId3FrameTdrl is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FrameTdrl = "TDRL"
)

// UdpTimedMetadataId3Frame_Values returns all elements of the UdpTimedMetadataId3Frame enum
func UdpTimedMetadataId3Frame_Values() []string {
	return []string{
		UdpTimedMetadataId3FrameNone,
		UdpTimedMetadataId3FramePriv,
		UdpTimedMetadataId3FrameTdrl,
	}
}

// Video Description Respond To Afd
const (
	// VideoDescriptionRespondToAfdNone is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdNone = "NONE"

	// VideoDescriptionRespondToAfdPassthrough is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdPassthrough = "PASSTHROUGH"

	// VideoDescriptionRespondToAfdRespond is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdRespond = "RESPOND"
)

// VideoDescriptionRespondToAfd_Values returns all elements of the VideoDescriptionRespondToAfd enum
func VideoDescriptionRespondToAfd_Values() []string {
	return []string{
		VideoDescriptionRespondToAfdNone,
		VideoDescriptionRespondToAfdPassthrough,
		VideoDescriptionRespondToAfdRespond,
	}
}

// Video Description Scaling Behavior
const (
	// VideoDescriptionScalingBehaviorDefault is a VideoDescriptionScalingBehavior enum value
	VideoDescriptionScalingBehaviorDefault = "DEFAULT"

	// VideoDescriptionScalingBehaviorStretchToOutput is a VideoDescriptionScalingBehavior enum value
	VideoDescriptionScalingBehaviorStretchToOutput = "STRETCH_TO_OUTPUT"
)

// VideoDescriptionScalingBehavior_Values returns all elements of the VideoDescriptionScalingBehavior enum
func VideoDescriptionScalingBehavior_Values() []string {
	return []string{
		VideoDescriptionScalingBehaviorDefault,
		VideoDescriptionScalingBehaviorStretchToOutput,
	}
}

// Video Selector Color Space
const (
	// VideoSelectorColorSpaceFollow is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceFollow = "FOLLOW"

	// VideoSelectorColorSpaceRec601 is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceRec601 = "REC_601"

	// VideoSelectorColorSpaceRec709 is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceRec709 = "REC_709"
)

// VideoSelectorColorSpace_Values returns all elements of the VideoSelectorColorSpace enum
func VideoSelectorColorSpace_Values() []string {
	return []string{
		VideoSelectorColorSpaceFollow,
		VideoSelectorColorSpaceRec601,
		VideoSelectorColorSpaceRec709,
	}
}

// Video Selector Color Space Usage
const (
	// VideoSelectorColorSpaceUsageFallback is a VideoSelectorColorSpaceUsage enum value
	VideoSelectorColorSpaceUsageFallback = "FALLBACK"

	// VideoSelectorColorSpaceUsageForce is a VideoSelectorColorSpaceUsage enum value
	VideoSelectorColorSpaceUsageForce = "FORCE"
)

// VideoSelectorColorSpaceUsage_Values returns all elements of the VideoSelectorColorSpaceUsage enum
func VideoSelectorColorSpaceUsage_Values() []string {
	return []string{
		VideoSelectorColorSpaceUsageFallback,
		VideoSelectorColorSpaceUsageForce,
	}
}
