// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddRoleToDBCluster = "AddRoleToDBCluster"

// AddRoleToDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the AddRoleToDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddRoleToDBCluster for more information on using the AddRoleToDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddRoleToDBClusterRequest method.
//    req, resp := client.AddRoleToDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster
func (c *RDS) AddRoleToDBClusterRequest(input *AddRoleToDBClusterInput) (req *request.Request, output *AddRoleToDBClusterOutput) {
	op := &request.Operation{
		Name:       opAddRoleToDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToDBClusterInput{}
	}

	output = &AddRoleToDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRoleToDBCluster API operation for Amazon Relational Database Service.
//
// Associates an Identity and Access Management (IAM) role from an Amazon Aurora
// DB cluster. For more information, see Authorizing Amazon Aurora MySQL to
// Access Other AWS Services on Your Behalf (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddRoleToDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleAlreadyExistsFault "DBClusterRoleAlreadyExists"
//   The specified IAM role Amazon Resource Name (ARN) is already associated with
//   the specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBClusterRoleQuotaExceededFault "DBClusterRoleQuotaExceeded"
//   You have exceeded the maximum number of IAM roles that can be associated
//   with the specified DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster
func (c *RDS) AddRoleToDBCluster(input *AddRoleToDBClusterInput) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	return out, req.Send()
}

// AddRoleToDBClusterWithContext is the same as AddRoleToDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See AddRoleToDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddRoleToDBClusterWithContext(ctx aws.Context, input *AddRoleToDBClusterInput, opts ...request.Option) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddRoleToDBInstance = "AddRoleToDBInstance"

// AddRoleToDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the AddRoleToDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddRoleToDBInstance for more information on using the AddRoleToDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddRoleToDBInstanceRequest method.
//    req, resp := client.AddRoleToDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance
func (c *RDS) AddRoleToDBInstanceRequest(input *AddRoleToDBInstanceInput) (req *request.Request, output *AddRoleToDBInstanceOutput) {
	op := &request.Operation{
		Name:       opAddRoleToDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToDBInstanceInput{}
	}

	output = &AddRoleToDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRoleToDBInstance API operation for Amazon Relational Database Service.
//
// Associates an AWS Identity and Access Management (IAM) role with a DB instance.
//
// To add a role to a DB instance, the status of the DB instance must be available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddRoleToDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBInstanceRoleAlreadyExistsFault "DBInstanceRoleAlreadyExists"
//   The specified RoleArn or FeatureName value is already associated with the
//   DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBInstanceRoleQuotaExceededFault "DBInstanceRoleQuotaExceeded"
//   You can't associate any more AWS Identity and Access Management (IAM) roles
//   with the DB instance because the quota has been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance
func (c *RDS) AddRoleToDBInstance(input *AddRoleToDBInstanceInput) (*AddRoleToDBInstanceOutput, error) {
	req, out := c.AddRoleToDBInstanceRequest(input)
	return out, req.Send()
}

// AddRoleToDBInstanceWithContext is the same as AddRoleToDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See AddRoleToDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddRoleToDBInstanceWithContext(ctx aws.Context, input *AddRoleToDBInstanceInput, opts ...request.Option) (*AddRoleToDBInstanceOutput, error) {
	req, out := c.AddRoleToDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddSourceIdentifierToSubscription = "AddSourceIdentifierToSubscription"

// AddSourceIdentifierToSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the AddSourceIdentifierToSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddSourceIdentifierToSubscription for more information on using the AddSourceIdentifierToSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddSourceIdentifierToSubscriptionRequest method.
//    req, resp := client.AddSourceIdentifierToSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription
func (c *RDS) AddSourceIdentifierToSubscriptionRequest(input *AddSourceIdentifierToSubscriptionInput) (req *request.Request, output *AddSourceIdentifierToSubscriptionOutput) {
	op := &request.Operation{
		Name:       opAddSourceIdentifierToSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddSourceIdentifierToSubscriptionInput{}
	}

	output = &AddSourceIdentifierToSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddSourceIdentifierToSubscription API operation for Amazon Relational Database Service.
//
// Adds a source identifier to an existing RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddSourceIdentifierToSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription
func (c *RDS) AddSourceIdentifierToSubscription(input *AddSourceIdentifierToSubscriptionInput) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	return out, req.Send()
}

// AddSourceIdentifierToSubscriptionWithContext is the same as AddSourceIdentifierToSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See AddSourceIdentifierToSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddSourceIdentifierToSubscriptionWithContext(ctx aws.Context, input *AddSourceIdentifierToSubscriptionInput, opts ...request.Option) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource
func (c *RDS) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon Relational Database Service.
//
// Adds metadata tags to an Amazon RDS resource. These tags can also be used
// with cost allocation reporting to track cost associated with Amazon RDS resources,
// or used in a Condition statement in an IAM policy for Amazon RDS.
//
// For an overview on tagging Amazon RDS resources, see Tagging Amazon RDS Resources
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource
func (c *RDS) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//    req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction
func (c *RDS) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for Amazon Relational Database Service.
//
// Applies a pending maintenance action to a resource (for example, to a DB
// instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction
func (c *RDS) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeDBSecurityGroupIngress = "AuthorizeDBSecurityGroupIngress"

// AuthorizeDBSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeDBSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeDBSecurityGroupIngress for more information on using the AuthorizeDBSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeDBSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeDBSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress
func (c *RDS) AuthorizeDBSecurityGroupIngressRequest(input *AuthorizeDBSecurityGroupIngressInput) (req *request.Request, output *AuthorizeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeDBSecurityGroupIngressInput{}
	}

	output = &AuthorizeDBSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeDBSecurityGroupIngress API operation for Amazon Relational Database Service.
//
// Enables ingress to a DBSecurityGroup using one of two forms of authorization.
// First, EC2 or VPC security groups can be added to the DBSecurityGroup if
// the application using the database is running on EC2 or VPC instances. Second,
// IP ranges are available if the application accessing your database is running
// on the Internet. Required parameters for this API are one of CIDR range,
// EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName
// or EC2SecurityGroupId for non-VPC).
//
// You can't authorize ingress from an EC2 security group in one AWS Region
// to an Amazon RDS DB instance in another. You can't authorize ingress from
// a VPC security group in one VPC to an Amazon RDS DB instance in another.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AuthorizeDBSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group doesn't allow deletion.
//
//   * ErrCodeAuthorizationAlreadyExistsFault "AuthorizationAlreadyExists"
//   The specified CIDR IP range or Amazon EC2 security group is already authorized
//   for the specified DB security group.
//
//   * ErrCodeAuthorizationQuotaExceededFault "AuthorizationQuotaExceeded"
//   The DB security group authorization quota has been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress
func (c *RDS) AuthorizeDBSecurityGroupIngress(input *AuthorizeDBSecurityGroupIngressInput) (*AuthorizeDBSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeDBSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeDBSecurityGroupIngressWithContext is the same as AuthorizeDBSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeDBSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AuthorizeDBSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeDBSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeDBSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeDBSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBacktrackDBCluster = "BacktrackDBCluster"

// BacktrackDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the BacktrackDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BacktrackDBCluster for more information on using the BacktrackDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BacktrackDBClusterRequest method.
//    req, resp := client.BacktrackDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster
func (c *RDS) BacktrackDBClusterRequest(input *BacktrackDBClusterInput) (req *request.Request, output *BacktrackDBClusterOutput) {
	op := &request.Operation{
		Name:       opBacktrackDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BacktrackDBClusterInput{}
	}

	output = &BacktrackDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BacktrackDBCluster API operation for Amazon Relational Database Service.
//
// Backtracks a DB cluster to a specific time, without creating a new DB cluster.
//
// For more information on backtracking, see Backtracking an Aurora DB Cluster
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation BacktrackDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster
func (c *RDS) BacktrackDBCluster(input *BacktrackDBClusterInput) (*BacktrackDBClusterOutput, error) {
	req, out := c.BacktrackDBClusterRequest(input)
	return out, req.Send()
}

// BacktrackDBClusterWithContext is the same as BacktrackDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See BacktrackDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) BacktrackDBClusterWithContext(ctx aws.Context, input *BacktrackDBClusterInput, opts ...request.Option) (*BacktrackDBClusterOutput, error) {
	req, out := c.BacktrackDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelExportTask for more information on using the CancelExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelExportTaskRequest method.
//    req, resp := client.CancelExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask
func (c *RDS) CancelExportTaskRequest(input *CancelExportTaskInput) (req *request.Request, output *CancelExportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	output = &CancelExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelExportTask API operation for Amazon Relational Database Service.
//
// Cancels an export task in progress that is exporting a snapshot to Amazon
// S3. Any data that has already been written to the S3 bucket isn't removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CancelExportTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExportTaskNotFoundFault "ExportTaskNotFound"
//   The export task doesn't exist.
//
//   * ErrCodeInvalidExportTaskStateFault "InvalidExportTaskStateFault"
//   You can't cancel an export task that has completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask
func (c *RDS) CancelExportTask(input *CancelExportTaskInput) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	return out, req.Send()
}

// CancelExportTaskWithContext is the same as CancelExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CancelExportTaskWithContext(ctx aws.Context, input *CancelExportTaskInput, opts ...request.Option) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterParameterGroup = "CopyDBClusterParameterGroup"

// CopyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterParameterGroup for more information on using the CopyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterParameterGroupRequest method.
//    req, resp := client.CopyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup
func (c *RDS) CopyDBClusterParameterGroupRequest(input *CopyDBClusterParameterGroupInput) (req *request.Request, output *CopyDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterParameterGroupInput{}
	}

	output = &CopyDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Copies the specified DB cluster parameter group.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup
func (c *RDS) CopyDBClusterParameterGroup(input *CopyDBClusterParameterGroupInput) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBClusterParameterGroupWithContext is the same as CopyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBClusterParameterGroupWithContext(ctx aws.Context, input *CopyDBClusterParameterGroupInput, opts ...request.Option) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterSnapshot for more information on using the CopyDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterSnapshotRequest method.
//    req, resp := client.CopyDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot
func (c *RDS) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) (req *request.Request, output *CopyDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	output = &CopyDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Copies a snapshot of a DB cluster.
//
// To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
// must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
//
// You can copy an encrypted DB cluster snapshot from another AWS Region. In
// that case, the AWS Region where you call the CopyDBClusterSnapshot action
// is the destination AWS Region for the encrypted DB cluster snapshot to be
// copied to. To copy an encrypted DB cluster snapshot from another AWS Region,
// you must provide the following values:
//
//    * KmsKeyId - The AWS Key Management System (AWS KMS) key identifier for
//    the key to use to encrypt the copy of the DB cluster snapshot in the destination
//    AWS Region.
//
//    * PreSignedUrl - A URL that contains a Signature Version 4 signed request
//    for the CopyDBClusterSnapshot action to be called in the source AWS Region
//    where the DB cluster snapshot is copied from. The pre-signed URL must
//    be a valid request for the CopyDBClusterSnapshot API action that can be
//    executed in the source AWS Region that contains the encrypted DB cluster
//    snapshot to be copied. The pre-signed URL request must contain the following
//    parameter values: KmsKeyId - The KMS key identifier for the key to use
//    to encrypt the copy of the DB cluster snapshot in the destination AWS
//    Region. This is the same identifier for both the CopyDBClusterSnapshot
//    action that is called in the destination AWS Region, and the action contained
//    in the pre-signed URL. DestinationRegion - The name of the AWS Region
//    that the DB cluster snapshot is to be created in. SourceDBClusterSnapshotIdentifier
//    - The DB cluster snapshot identifier for the encrypted DB cluster snapshot
//    to be copied. This identifier must be in the Amazon Resource Name (ARN)
//    format for the source AWS Region. For example, if you are copying an encrypted
//    DB cluster snapshot from the us-west-2 AWS Region, then your SourceDBClusterSnapshotIdentifier
//    looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
//    To learn how to generate a Signature Version 4 signed request, see Authenticating
//    Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
//    and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//    If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
//    (or --source-region for the AWS CLI) instead of specifying PreSignedUrl
//    manually. Specifying SourceRegion autogenerates a pre-signed URL that
//    is a valid request for the operation that can be executed in the source
//    AWS Region.
//
//    * TargetDBClusterSnapshotIdentifier - The identifier for the new copy
//    of the DB cluster snapshot in the destination AWS Region.
//
//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
//    for the encrypted DB cluster snapshot to be copied. This identifier must
//    be in the ARN format for the source AWS Region and is the same value as
//    the SourceDBClusterSnapshotIdentifier in the pre-signed URL.
//
// To cancel the copy operation once it is in progress, delete the target DB
// cluster snapshot identified by TargetDBClusterSnapshotIdentifier while that
// DB cluster snapshot is in "copying" status.
//
// For more information on copying encrypted DB cluster snapshots from one AWS
// Region to another, see Copying a Snapshot (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html)
// in the Amazon Aurora User Guide.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   The user already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot
func (c *RDS) CopyDBClusterSnapshot(input *CopyDBClusterSnapshotInput) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBClusterSnapshotWithContext is the same as CopyDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBClusterSnapshotWithContext(ctx aws.Context, input *CopyDBClusterSnapshotInput, opts ...request.Option) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBParameterGroup = "CopyDBParameterGroup"

// CopyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBParameterGroup for more information on using the CopyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBParameterGroupRequest method.
//    req, resp := client.CopyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup
func (c *RDS) CopyDBParameterGroupRequest(input *CopyDBParameterGroupInput) (req *request.Request, output *CopyDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBParameterGroupInput{}
	}

	output = &CopyDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBParameterGroup API operation for Amazon Relational Database Service.
//
// Copies the specified DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB parameter
//   groups.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup
func (c *RDS) CopyDBParameterGroup(input *CopyDBParameterGroupInput) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBParameterGroupWithContext is the same as CopyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBParameterGroupWithContext(ctx aws.Context, input *CopyDBParameterGroupInput, opts ...request.Option) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBSnapshot = "CopyDBSnapshot"

// CopyDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBSnapshot for more information on using the CopyDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBSnapshotRequest method.
//    req, resp := client.CopyDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot
func (c *RDS) CopyDBSnapshotRequest(input *CopyDBSnapshotInput) (req *request.Request, output *CopyDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBSnapshotInput{}
	}

	output = &CopyDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBSnapshot API operation for Amazon Relational Database Service.
//
// Copies the specified DB snapshot. The source DB snapshot must be in the "available"
// state.
//
// You can copy a snapshot from one AWS Region to another. In that case, the
// AWS Region where you call the CopyDBSnapshot action is the destination AWS
// Region for the DB snapshot copy.
//
// For more information about copying snapshots, see Copying a DB Snapshot (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot
func (c *RDS) CopyDBSnapshot(input *CopyDBSnapshotInput) (*CopyDBSnapshotOutput, error) {
	req, out := c.CopyDBSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBSnapshotWithContext is the same as CopyDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBSnapshotWithContext(ctx aws.Context, input *CopyDBSnapshotInput, opts ...request.Option) (*CopyDBSnapshotOutput, error) {
	req, out := c.CopyDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyOptionGroup = "CopyOptionGroup"

// CopyOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyOptionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyOptionGroup for more information on using the CopyOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyOptionGroupRequest method.
//    req, resp := client.CopyOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup
func (c *RDS) CopyOptionGroupRequest(input *CopyOptionGroupInput) (req *request.Request, output *CopyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCopyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyOptionGroupInput{}
	}

	output = &CopyOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyOptionGroup API operation for Amazon Relational Database Service.
//
// Copies the specified option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupAlreadyExistsFault "OptionGroupAlreadyExistsFault"
//   The option group you are trying to create already exists.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeOptionGroupQuotaExceededFault "OptionGroupQuotaExceededFault"
//   The quota of 20 option groups was exceeded for this AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup
func (c *RDS) CopyOptionGroup(input *CopyOptionGroupInput) (*CopyOptionGroupOutput, error) {
	req, out := c.CopyOptionGroupRequest(input)
	return out, req.Send()
}

// CopyOptionGroupWithContext is the same as CopyOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyOptionGroupWithContext(ctx aws.Context, input *CopyOptionGroupInput, opts ...request.Option) (*CopyOptionGroupOutput, error) {
	req, out := c.CopyOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomAvailabilityZone = "CreateCustomAvailabilityZone"

// CreateCustomAvailabilityZoneRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomAvailabilityZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomAvailabilityZone for more information on using the CreateCustomAvailabilityZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomAvailabilityZoneRequest method.
//    req, resp := client.CreateCustomAvailabilityZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomAvailabilityZone
func (c *RDS) CreateCustomAvailabilityZoneRequest(input *CreateCustomAvailabilityZoneInput) (req *request.Request, output *CreateCustomAvailabilityZoneOutput) {
	op := &request.Operation{
		Name:       opCreateCustomAvailabilityZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomAvailabilityZoneInput{}
	}

	output = &CreateCustomAvailabilityZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomAvailabilityZone API operation for Amazon Relational Database Service.
//
// Creates a custom Availability Zone (AZ).
//
// A custom AZ is an on-premises AZ that is integrated with a VMware vSphere
// cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateCustomAvailabilityZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCustomAvailabilityZoneAlreadyExistsFault "CustomAvailabilityZoneAlreadyExists"
//   CustomAvailabilityZoneName is already used by an existing custom Availability
//   Zone.
//
//   * ErrCodeCustomAvailabilityZoneQuotaExceededFault "CustomAvailabilityZoneQuotaExceeded"
//   You have exceeded the maximum number of custom Availability Zones.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomAvailabilityZone
func (c *RDS) CreateCustomAvailabilityZone(input *CreateCustomAvailabilityZoneInput) (*CreateCustomAvailabilityZoneOutput, error) {
	req, out := c.CreateCustomAvailabilityZoneRequest(input)
	return out, req.Send()
}

// CreateCustomAvailabilityZoneWithContext is the same as CreateCustomAvailabilityZone with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomAvailabilityZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateCustomAvailabilityZoneWithContext(ctx aws.Context, input *CreateCustomAvailabilityZoneInput, opts ...request.Option) (*CreateCustomAvailabilityZoneOutput, error) {
	req, out := c.CreateCustomAvailabilityZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBCluster = "CreateDBCluster"

// CreateDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBCluster for more information on using the CreateDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterRequest method.
//    req, resp := client.CreateDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster
func (c *RDS) CreateDBClusterRequest(input *CreateDBClusterInput) (req *request.Request, output *CreateDBClusterOutput) {
	op := &request.Operation{
		Name:       opCreateDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterInput{}
	}

	output = &CreateDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBCluster API operation for Amazon Relational Database Service.
//
// Creates a new Amazon Aurora DB cluster.
//
// You can use the ReplicationSourceIdentifier parameter to create the DB cluster
// as a read replica of another DB cluster or Amazon RDS MySQL DB instance.
// For cross-region replication where the DB cluster identified by ReplicationSourceIdentifier
// is encrypted, you must also specify the PreSignedUrl parameter.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   The user already has a DB cluster with the given identifier.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You might
//   be able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The user attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it's in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeGlobalClusterNotFoundFault "GlobalClusterNotFoundFault"
//
//   * ErrCodeInvalidGlobalClusterStateFault "InvalidGlobalClusterStateFault"
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster
func (c *RDS) CreateDBCluster(input *CreateDBClusterInput) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	return out, req.Send()
}

// CreateDBClusterWithContext is the same as CreateDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterWithContext(ctx aws.Context, input *CreateDBClusterInput, opts ...request.Option) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterEndpoint = "CreateDBClusterEndpoint"

// CreateDBClusterEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterEndpoint for more information on using the CreateDBClusterEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterEndpointRequest method.
//    req, resp := client.CreateDBClusterEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint
func (c *RDS) CreateDBClusterEndpointRequest(input *CreateDBClusterEndpointInput) (req *request.Request, output *CreateDBClusterEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterEndpointInput{}
	}

	output = &CreateDBClusterEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterEndpoint API operation for Amazon Relational Database Service.
//
// Creates a new custom endpoint and associates it with an Amazon Aurora DB
// cluster.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBClusterEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterEndpointQuotaExceededFault "DBClusterEndpointQuotaExceededFault"
//   The cluster already has the maximum number of custom endpoints.
//
//   * ErrCodeDBClusterEndpointAlreadyExistsFault "DBClusterEndpointAlreadyExistsFault"
//   The specified custom endpoint can't be created because it already exists.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint
func (c *RDS) CreateDBClusterEndpoint(input *CreateDBClusterEndpointInput) (*CreateDBClusterEndpointOutput, error) {
	req, out := c.CreateDBClusterEndpointRequest(input)
	return out, req.Send()
}

// CreateDBClusterEndpointWithContext is the same as CreateDBClusterEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterEndpointWithContext(ctx aws.Context, input *CreateDBClusterEndpointInput, opts ...request.Option) (*CreateDBClusterEndpointOutput, error) {
	req, out := c.CreateDBClusterEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterParameterGroup for more information on using the CreateDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterParameterGroupRequest method.
//    req, resp := client.CreateDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup
func (c *RDS) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) (req *request.Request, output *CreateDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	output = &CreateDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB cluster parameter group.
//
// Parameters in a DB cluster parameter group apply to all of the instances
// in a DB cluster.
//
// A DB cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the DB cluster. To provide custom
// values for any of the parameters, you must modify the group after creating
// it using ModifyDBClusterParameterGroup. Once you've created a DB cluster
// parameter group, you need to associate it with your DB cluster using ModifyDBCluster.
// When you associate a new DB cluster parameter group with a running DB cluster,
// you need to reboot the DB instances in the DB cluster without failover for
// the new DB cluster parameter group and associated settings to take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the DB cluster parameter group is used as the default
// for a new DB cluster. This is especially important for parameters that are
// critical when creating the default database for a DB cluster, such as the
// character set for the default database defined by the character_set_database
// parameter. You can use the Parameter Groups option of the Amazon RDS console
// (https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters
// action to verify that your DB cluster parameter group has been created or
// modified.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup
func (c *RDS) CreateDBClusterParameterGroup(input *CreateDBClusterParameterGroupInput) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBClusterParameterGroupWithContext is the same as CreateDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterParameterGroupWithContext(ctx aws.Context, input *CreateDBClusterParameterGroupInput, opts ...request.Option) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterSnapshot = "CreateDBClusterSnapshot"

// CreateDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterSnapshot for more information on using the CreateDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterSnapshotRequest method.
//    req, resp := client.CreateDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot
func (c *RDS) CreateDBClusterSnapshotRequest(input *CreateDBClusterSnapshotInput) (req *request.Request, output *CreateDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterSnapshotInput{}
	}

	output = &CreateDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Creates a snapshot of a DB cluster. For more information on Amazon Aurora,
// see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   The user already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot
func (c *RDS) CreateDBClusterSnapshot(input *CreateDBClusterSnapshotInput) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBClusterSnapshotWithContext is the same as CreateDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterSnapshotWithContext(ctx aws.Context, input *CreateDBClusterSnapshotInput, opts ...request.Option) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance
func (c *RDS) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstance API operation for Amazon Relational Database Service.
//
// Creates a new DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeBackupPolicyNotFoundFault "BackupPolicyNotFoundFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance
func (c *RDS) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBInstanceWithContext(ctx aws.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstanceReadReplica = "CreateDBInstanceReadReplica"

// CreateDBInstanceReadReplicaRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstanceReadReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstanceReadReplica for more information on using the CreateDBInstanceReadReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceReadReplicaRequest method.
//    req, resp := client.CreateDBInstanceReadReplicaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica
func (c *RDS) CreateDBInstanceReadReplicaRequest(input *CreateDBInstanceReadReplicaInput) (req *request.Request, output *CreateDBInstanceReadReplicaOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstanceReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceReadReplicaInput{}
	}

	output = &CreateDBInstanceReadReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstanceReadReplica API operation for Amazon Relational Database Service.
//
// Creates a new DB instance that acts as a read replica for an existing source
// DB instance. You can create a read replica for a DB instance running MySQL,
// MariaDB, Oracle, PostgreSQL, or SQL Server. For more information, see Working
// with Read Replicas (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html)
// in the Amazon RDS User Guide.
//
// Amazon Aurora doesn't support this action. Call the CreateDBInstance action
// to create a DB instance for an Aurora DB cluster.
//
// All read replica DB instances are created with backups disabled. All other
// DB instance attributes (including DB security groups and DB parameter groups)
// are inherited from the source DB instance, except as specified.
//
// Your source DB instance must have backup retention enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBInstanceReadReplica for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBSubnetGroupNotAllowedFault "DBSubnetGroupNotAllowedFault"
//   The DBSubnetGroup shouldn't be specified while creating read replicas that
//   lie in the same region as the source instance.
//
//   * ErrCodeInvalidDBSubnetGroupFault "InvalidDBSubnetGroupFault"
//   The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region
//   read replica of the same source instance.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica
func (c *RDS) CreateDBInstanceReadReplica(input *CreateDBInstanceReadReplicaInput) (*CreateDBInstanceReadReplicaOutput, error) {
	req, out := c.CreateDBInstanceReadReplicaRequest(input)
	return out, req.Send()
}

// CreateDBInstanceReadReplicaWithContext is the same as CreateDBInstanceReadReplica with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstanceReadReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBInstanceReadReplicaWithContext(ctx aws.Context, input *CreateDBInstanceReadReplicaInput, opts ...request.Option) (*CreateDBInstanceReadReplicaOutput, error) {
	req, out := c.CreateDBInstanceReadReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBParameterGroup = "CreateDBParameterGroup"

// CreateDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBParameterGroup for more information on using the CreateDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBParameterGroupRequest method.
//    req, resp := client.CreateDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup
func (c *RDS) CreateDBParameterGroupRequest(input *CreateDBParameterGroupInput) (req *request.Request, output *CreateDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBParameterGroupInput{}
	}

	output = &CreateDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBParameterGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB parameter group.
//
// A DB parameter group is initially created with the default parameters for
// the database engine used by the DB instance. To provide custom values for
// any of the parameters, you must modify the group after creating it using
// ModifyDBParameterGroup. Once you've created a DB parameter group, you need
// to associate it with your DB instance using ModifyDBInstance. When you associate
// a new DB parameter group with a running DB instance, you need to reboot the
// DB instance without failover for the new DB parameter group and associated
// settings to take effect.
//
// After you create a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup
func (c *RDS) CreateDBParameterGroup(input *CreateDBParameterGroupInput) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBParameterGroupWithContext is the same as CreateDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBParameterGroupWithContext(ctx aws.Context, input *CreateDBParameterGroupInput, opts ...request.Option) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBProxy = "CreateDBProxy"

// CreateDBProxyRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBProxy for more information on using the CreateDBProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBProxyRequest method.
//    req, resp := client.CreateDBProxyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy
func (c *RDS) CreateDBProxyRequest(input *CreateDBProxyInput) (req *request.Request, output *CreateDBProxyOutput) {
	op := &request.Operation{
		Name:       opCreateDBProxy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBProxyInput{}
	}

	output = &CreateDBProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBProxy API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Creates a new DB proxy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBProxy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeDBProxyAlreadyExistsFault "DBProxyTargetExistsFault"
//   The specified proxy name must be unique for all proxies owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeDBProxyQuotaExceededFault "DBProxyQuotaExceededFault"
//   Your AWS account already has the maximum number of proxies in the specified
//   AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy
func (c *RDS) CreateDBProxy(input *CreateDBProxyInput) (*CreateDBProxyOutput, error) {
	req, out := c.CreateDBProxyRequest(input)
	return out, req.Send()
}

// CreateDBProxyWithContext is the same as CreateDBProxy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBProxyWithContext(ctx aws.Context, input *CreateDBProxyInput, opts ...request.Option) (*CreateDBProxyOutput, error) {
	req, out := c.CreateDBProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSecurityGroup = "CreateDBSecurityGroup"

// CreateDBSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSecurityGroup for more information on using the CreateDBSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSecurityGroupRequest method.
//    req, resp := client.CreateDBSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup
func (c *RDS) CreateDBSecurityGroupRequest(input *CreateDBSecurityGroupInput) (req *request.Request, output *CreateDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSecurityGroupInput{}
	}

	output = &CreateDBSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSecurityGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB security group. DB security groups control access to a DB
// instance.
//
// A DB security group controls access to EC2-Classic DB instances that are
// not in a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupAlreadyExistsFault "DBSecurityGroupAlreadyExists"
//   A DB security group with the name specified in DBSecurityGroupName already
//   exists.
//
//   * ErrCodeDBSecurityGroupQuotaExceededFault "QuotaExceeded.DBSecurityGroup"
//   The request would result in the user exceeding the allowed number of DB security
//   groups.
//
//   * ErrCodeDBSecurityGroupNotSupportedFault "DBSecurityGroupNotSupported"
//   A DB security group isn't allowed for this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup
func (c *RDS) CreateDBSecurityGroup(input *CreateDBSecurityGroupInput) (*CreateDBSecurityGroupOutput, error) {
	req, out := c.CreateDBSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateDBSecurityGroupWithContext is the same as CreateDBSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSecurityGroupWithContext(ctx aws.Context, input *CreateDBSecurityGroupInput, opts ...request.Option) (*CreateDBSecurityGroupOutput, error) {
	req, out := c.CreateDBSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSnapshot = "CreateDBSnapshot"

// CreateDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSnapshot for more information on using the CreateDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSnapshotRequest method.
//    req, resp := client.CreateDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot
func (c *RDS) CreateDBSnapshotRequest(input *CreateDBSnapshotInput) (req *request.Request, output *CreateDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSnapshotInput{}
	}

	output = &CreateDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSnapshot API operation for Amazon Relational Database Service.
//
// Creates a DBSnapshot. The source DBInstance must be in "available" state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot
func (c *RDS) CreateDBSnapshot(input *CreateDBSnapshotInput) (*CreateDBSnapshotOutput, error) {
	req, out := c.CreateDBSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBSnapshotWithContext is the same as CreateDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSnapshotWithContext(ctx aws.Context, input *CreateDBSnapshotInput, opts ...request.Option) (*CreateDBSnapshotOutput, error) {
	req, out := c.CreateDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSubnetGroup = "CreateDBSubnetGroup"

// CreateDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSubnetGroup for more information on using the CreateDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSubnetGroupRequest method.
//    req, resp := client.CreateDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup
func (c *RDS) CreateDBSubnetGroupRequest(input *CreateDBSubnetGroupInput) (req *request.Request, output *CreateDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSubnetGroupInput{}
	}

	output = &CreateDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB subnet group. DB subnet groups must contain at least one
// subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupAlreadyExistsFault "DBSubnetGroupAlreadyExists"
//   DBSubnetGroupName is already used by an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupQuotaExceededFault "DBSubnetGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB subnet
//   groups.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   The request would result in the user exceeding the allowed number of subnets
//   in a DB subnet groups.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup
func (c *RDS) CreateDBSubnetGroup(input *CreateDBSubnetGroupInput) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateDBSubnetGroupWithContext is the same as CreateDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSubnetGroupWithContext(ctx aws.Context, input *CreateDBSubnetGroupInput, opts ...request.Option) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription
func (c *RDS) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for Amazon Relational Database Service.
//
// Creates an RDS event notification subscription. This action requires a topic
// Amazon Resource Name (ARN) created by either the RDS console, the SNS console,
// or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon
// SNS and subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of RDS sources (SourceIds) that triggers the events, and provide
// a list of event categories (EventCategories) for events you want to be notified
// of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
// mydbinstance2 and EventCategories = Availability, Backup.
//
// If you specify both the SourceType and SourceIds, such as SourceType = db-instance
// and SourceIdentifier = myDBInstance1, you are notified of all the db-instance
// events for the specified source. If you specify a SourceType but do not specify
// a SourceIdentifier, you receive notice of the events for that source type
// for all your RDS sources. If you don't specify either the SourceType or the
// SourceIdentifier, you are notified of events generated from all RDS sources
// belonging to your customer account.
//
// RDS event notification is only available for unencrypted SNS topics. If you
// specify an encrypted SNS topic, event notifications aren't sent for the topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have reached the maximum number of event subscriptions.
//
//   * ErrCodeSubscriptionAlreadyExistFault "SubscriptionAlreadyExist"
//   The supplied subscription name already exists.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   SNS has responded that there is a problem with the SND topic specified.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the SNS topic ARN.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The SNS topic ARN does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The supplied category does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription
func (c *RDS) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGlobalCluster = "CreateGlobalCluster"

// CreateGlobalClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateGlobalCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGlobalCluster for more information on using the CreateGlobalCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGlobalClusterRequest method.
//    req, resp := client.CreateGlobalClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster
func (c *RDS) CreateGlobalClusterRequest(input *CreateGlobalClusterInput) (req *request.Request, output *CreateGlobalClusterOutput) {
	op := &request.Operation{
		Name:       opCreateGlobalCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGlobalClusterInput{}
	}

	output = &CreateGlobalClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGlobalCluster API operation for Amazon Relational Database Service.
//
//
// Creates an Aurora global database spread across multiple regions. The global
// database contains a single primary cluster with read-write capability, and
// a read-only secondary cluster that receives data from the primary cluster
// through high-speed replication performed by the Aurora storage subsystem.
//
// You can create a global database that is initially empty, and then add a
// primary cluster and a secondary cluster to it. Or you can specify an existing
// Aurora cluster during the create operation, and this cluster becomes the
// primary cluster of the global database.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateGlobalCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalClusterAlreadyExistsFault "GlobalClusterAlreadyExistsFault"
//
//   * ErrCodeGlobalClusterQuotaExceededFault "GlobalClusterQuotaExceededFault"
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster
func (c *RDS) CreateGlobalCluster(input *CreateGlobalClusterInput) (*CreateGlobalClusterOutput, error) {
	req, out := c.CreateGlobalClusterRequest(input)
	return out, req.Send()
}

// CreateGlobalClusterWithContext is the same as CreateGlobalCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGlobalCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateGlobalClusterWithContext(ctx aws.Context, input *CreateGlobalClusterInput, opts ...request.Option) (*CreateGlobalClusterOutput, error) {
	req, out := c.CreateGlobalClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOptionGroup = "CreateOptionGroup"

// CreateOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateOptionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOptionGroup for more information on using the CreateOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOptionGroupRequest method.
//    req, resp := client.CreateOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup
func (c *RDS) CreateOptionGroupRequest(input *CreateOptionGroupInput) (req *request.Request, output *CreateOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOptionGroupInput{}
	}

	output = &CreateOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOptionGroup API operation for Amazon Relational Database Service.
//
// Creates a new option group. You can create up to 20 option groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupAlreadyExistsFault "OptionGroupAlreadyExistsFault"
//   The option group you are trying to create already exists.
//
//   * ErrCodeOptionGroupQuotaExceededFault "OptionGroupQuotaExceededFault"
//   The quota of 20 option groups was exceeded for this AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup
func (c *RDS) CreateOptionGroup(input *CreateOptionGroupInput) (*CreateOptionGroupOutput, error) {
	req, out := c.CreateOptionGroupRequest(input)
	return out, req.Send()
}

// CreateOptionGroupWithContext is the same as CreateOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateOptionGroupWithContext(ctx aws.Context, input *CreateOptionGroupInput, opts ...request.Option) (*CreateOptionGroupOutput, error) {
	req, out := c.CreateOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomAvailabilityZone = "DeleteCustomAvailabilityZone"

// DeleteCustomAvailabilityZoneRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomAvailabilityZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomAvailabilityZone for more information on using the DeleteCustomAvailabilityZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomAvailabilityZoneRequest method.
//    req, resp := client.DeleteCustomAvailabilityZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomAvailabilityZone
func (c *RDS) DeleteCustomAvailabilityZoneRequest(input *DeleteCustomAvailabilityZoneInput) (req *request.Request, output *DeleteCustomAvailabilityZoneOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomAvailabilityZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomAvailabilityZoneInput{}
	}

	output = &DeleteCustomAvailabilityZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCustomAvailabilityZone API operation for Amazon Relational Database Service.
//
// Deletes a custom Availability Zone (AZ).
//
// A custom AZ is an on-premises AZ that is integrated with a VMware vSphere
// cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteCustomAvailabilityZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCustomAvailabilityZoneNotFoundFault "CustomAvailabilityZoneNotFound"
//   CustomAvailabilityZoneId doesn't refer to an existing custom Availability
//   Zone identifier.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomAvailabilityZone
func (c *RDS) DeleteCustomAvailabilityZone(input *DeleteCustomAvailabilityZoneInput) (*DeleteCustomAvailabilityZoneOutput, error) {
	req, out := c.DeleteCustomAvailabilityZoneRequest(input)
	return out, req.Send()
}

// DeleteCustomAvailabilityZoneWithContext is the same as DeleteCustomAvailabilityZone with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomAvailabilityZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteCustomAvailabilityZoneWithContext(ctx aws.Context, input *DeleteCustomAvailabilityZoneInput, opts ...request.Option) (*DeleteCustomAvailabilityZoneOutput, error) {
	req, out := c.DeleteCustomAvailabilityZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBCluster = "DeleteDBCluster"

// DeleteDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBCluster for more information on using the DeleteDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterRequest method.
//    req, resp := client.DeleteDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster
func (c *RDS) DeleteDBClusterRequest(input *DeleteDBClusterInput) (req *request.Request, output *DeleteDBClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterInput{}
	}

	output = &DeleteDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBCluster API operation for Amazon Relational Database Service.
//
// The DeleteDBCluster action deletes a previously provisioned DB cluster. When
// you delete a DB cluster, all automated backups for that DB cluster are deleted
// and can't be recovered. Manual DB cluster snapshots of the specified DB cluster
// are not deleted.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   The user already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster
func (c *RDS) DeleteDBCluster(input *DeleteDBClusterInput) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	return out, req.Send()
}

// DeleteDBClusterWithContext is the same as DeleteDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterWithContext(ctx aws.Context, input *DeleteDBClusterInput, opts ...request.Option) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterEndpoint = "DeleteDBClusterEndpoint"

// DeleteDBClusterEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterEndpoint for more information on using the DeleteDBClusterEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterEndpointRequest method.
//    req, resp := client.DeleteDBClusterEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint
func (c *RDS) DeleteDBClusterEndpointRequest(input *DeleteDBClusterEndpointInput) (req *request.Request, output *DeleteDBClusterEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterEndpointInput{}
	}

	output = &DeleteDBClusterEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBClusterEndpoint API operation for Amazon Relational Database Service.
//
// Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBClusterEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterEndpointStateFault "InvalidDBClusterEndpointStateFault"
//   The requested operation can't be performed on the endpoint while the endpoint
//   is in this state.
//
//   * ErrCodeDBClusterEndpointNotFoundFault "DBClusterEndpointNotFoundFault"
//   The specified custom endpoint doesn't exist.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint
func (c *RDS) DeleteDBClusterEndpoint(input *DeleteDBClusterEndpointInput) (*DeleteDBClusterEndpointOutput, error) {
	req, out := c.DeleteDBClusterEndpointRequest(input)
	return out, req.Send()
}

// DeleteDBClusterEndpointWithContext is the same as DeleteDBClusterEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterEndpointWithContext(ctx aws.Context, input *DeleteDBClusterEndpointInput, opts ...request.Option) (*DeleteDBClusterEndpointOutput, error) {
	req, out := c.DeleteDBClusterEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterParameterGroup = "DeleteDBClusterParameterGroup"

// DeleteDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterParameterGroup for more information on using the DeleteDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterParameterGroupRequest method.
//    req, resp := client.DeleteDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup
func (c *RDS) DeleteDBClusterParameterGroupRequest(input *DeleteDBClusterParameterGroupInput) (req *request.Request, output *DeleteDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterParameterGroupInput{}
	}

	output = &DeleteDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Deletes a specified DB cluster parameter group. The DB cluster parameter
// group to be deleted can't be associated with any DB clusters.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup
func (c *RDS) DeleteDBClusterParameterGroup(input *DeleteDBClusterParameterGroupInput) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBClusterParameterGroupWithContext is the same as DeleteDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterParameterGroupWithContext(ctx aws.Context, input *DeleteDBClusterParameterGroupInput, opts ...request.Option) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterSnapshot = "DeleteDBClusterSnapshot"

// DeleteDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterSnapshot for more information on using the DeleteDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterSnapshotRequest method.
//    req, resp := client.DeleteDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot
func (c *RDS) DeleteDBClusterSnapshotRequest(input *DeleteDBClusterSnapshotInput) (req *request.Request, output *DeleteDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterSnapshotInput{}
	}

	output = &DeleteDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
// operation is terminated.
//
// The DB cluster snapshot must be in the available state to be deleted.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot
func (c *RDS) DeleteDBClusterSnapshot(input *DeleteDBClusterSnapshotInput) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBClusterSnapshotWithContext is the same as DeleteDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterSnapshotWithContext(ctx aws.Context, input *DeleteDBClusterSnapshotInput, opts ...request.Option) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBInstance = "DeleteDBInstance"

// DeleteDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBInstance for more information on using the DeleteDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBInstanceRequest method.
//    req, resp := client.DeleteDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance
func (c *RDS) DeleteDBInstanceRequest(input *DeleteDBInstanceInput) (req *request.Request, output *DeleteDBInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceInput{}
	}

	output = &DeleteDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBInstance API operation for Amazon Relational Database Service.
//
// The DeleteDBInstance action deletes a previously provisioned DB instance.
// When you delete a DB instance, all automated backups for that instance are
// deleted and can't be recovered. Manual DB snapshots of the DB instance to
// be deleted by DeleteDBInstance are not deleted.
//
// If you request a final DB snapshot the status of the Amazon RDS DB instance
// is deleting until the DB snapshot is created. The API action DescribeDBInstance
// is used to monitor the status of this operation. The action can't be canceled
// or reverted once submitted.
//
// When a DB instance is in a failure state and has a status of failed, incompatible-restore,
// or incompatible-network, you can only delete it when you skip creation of
// the final snapshot with the SkipFinalSnapshot parameter.
//
// If the specified DB instance is part of an Amazon Aurora DB cluster, you
// can't delete the DB instance if both of the following conditions are true:
//
//    * The DB cluster is a read replica of another Amazon Aurora DB cluster.
//
//    * The DB instance is the only instance in the DB cluster.
//
// To delete a DB instance in this case, first call the PromoteReadReplicaDBCluster
// API action to promote the DB cluster so it's no longer a read replica. After
// the promotion completes, then call the DeleteDBInstance API action to delete
// the final instance in the DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeDBInstanceAutomatedBackupQuotaExceededFault "DBInstanceAutomatedBackupQuotaExceeded"
//   The quota for retained automated backups was exceeded. This prevents you
//   from retaining any additional automated backups. The retained automated backups
//   quota is the same as your DB Instance quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance
func (c *RDS) DeleteDBInstance(input *DeleteDBInstanceInput) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	return out, req.Send()
}

// DeleteDBInstanceWithContext is the same as DeleteDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBInstanceWithContext(ctx aws.Context, input *DeleteDBInstanceInput, opts ...request.Option) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBInstanceAutomatedBackup = "DeleteDBInstanceAutomatedBackup"

// DeleteDBInstanceAutomatedBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBInstanceAutomatedBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBInstanceAutomatedBackup for more information on using the DeleteDBInstanceAutomatedBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBInstanceAutomatedBackupRequest method.
//    req, resp := client.DeleteDBInstanceAutomatedBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup
func (c *RDS) DeleteDBInstanceAutomatedBackupRequest(input *DeleteDBInstanceAutomatedBackupInput) (req *request.Request, output *DeleteDBInstanceAutomatedBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstanceAutomatedBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceAutomatedBackupInput{}
	}

	output = &DeleteDBInstanceAutomatedBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBInstanceAutomatedBackup API operation for Amazon Relational Database Service.
//
// Deletes automated backups based on the source instance's DbiResourceId value
// or the restorable instance's resource ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBInstanceAutomatedBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceAutomatedBackupStateFault "InvalidDBInstanceAutomatedBackupState"
//   The automated backup is in an invalid state. For example, this automated
//   backup is associated with an active instance.
//
//   * ErrCodeDBInstanceAutomatedBackupNotFoundFault "DBInstanceAutomatedBackupNotFound"
//   No automated backup for this DB instance was found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup
func (c *RDS) DeleteDBInstanceAutomatedBackup(input *DeleteDBInstanceAutomatedBackupInput) (*DeleteDBInstanceAutomatedBackupOutput, error) {
	req, out := c.DeleteDBInstanceAutomatedBackupRequest(input)
	return out, req.Send()
}

// DeleteDBInstanceAutomatedBackupWithContext is the same as DeleteDBInstanceAutomatedBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBInstanceAutomatedBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBInstanceAutomatedBackupWithContext(ctx aws.Context, input *DeleteDBInstanceAutomatedBackupInput, opts ...request.Option) (*DeleteDBInstanceAutomatedBackupOutput, error) {
	req, out := c.DeleteDBInstanceAutomatedBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBParameterGroup = "DeleteDBParameterGroup"

// DeleteDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBParameterGroup for more information on using the DeleteDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBParameterGroupRequest method.
//    req, resp := client.DeleteDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup
func (c *RDS) DeleteDBParameterGroupRequest(input *DeleteDBParameterGroupInput) (req *request.Request, output *DeleteDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBParameterGroupInput{}
	}

	output = &DeleteDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBParameterGroup API operation for Amazon Relational Database Service.
//
// Deletes a specified DB parameter group. The DB parameter group to be deleted
// can't be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup
func (c *RDS) DeleteDBParameterGroup(input *DeleteDBParameterGroupInput) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBParameterGroupWithContext is the same as DeleteDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBParameterGroupWithContext(ctx aws.Context, input *DeleteDBParameterGroupInput, opts ...request.Option) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBProxy = "DeleteDBProxy"

// DeleteDBProxyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBProxy for more information on using the DeleteDBProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBProxyRequest method.
//    req, resp := client.DeleteDBProxyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy
func (c *RDS) DeleteDBProxyRequest(input *DeleteDBProxyInput) (req *request.Request, output *DeleteDBProxyOutput) {
	op := &request.Operation{
		Name:       opDeleteDBProxy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBProxyInput{}
	}

	output = &DeleteDBProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBProxy API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Deletes an existing proxy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBProxy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy
func (c *RDS) DeleteDBProxy(input *DeleteDBProxyInput) (*DeleteDBProxyOutput, error) {
	req, out := c.DeleteDBProxyRequest(input)
	return out, req.Send()
}

// DeleteDBProxyWithContext is the same as DeleteDBProxy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBProxyWithContext(ctx aws.Context, input *DeleteDBProxyInput, opts ...request.Option) (*DeleteDBProxyOutput, error) {
	req, out := c.DeleteDBProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSecurityGroup = "DeleteDBSecurityGroup"

// DeleteDBSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSecurityGroup for more information on using the DeleteDBSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSecurityGroupRequest method.
//    req, resp := client.DeleteDBSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup
func (c *RDS) DeleteDBSecurityGroupRequest(input *DeleteDBSecurityGroupInput) (req *request.Request, output *DeleteDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSecurityGroupInput{}
	}

	output = &DeleteDBSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSecurityGroup API operation for Amazon Relational Database Service.
//
// Deletes a DB security group.
//
// The specified DB security group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group doesn't allow deletion.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup
func (c *RDS) DeleteDBSecurityGroup(input *DeleteDBSecurityGroupInput) (*DeleteDBSecurityGroupOutput, error) {
	req, out := c.DeleteDBSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSecurityGroupWithContext is the same as DeleteDBSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSecurityGroupWithContext(ctx aws.Context, input *DeleteDBSecurityGroupInput, opts ...request.Option) (*DeleteDBSecurityGroupOutput, error) {
	req, out := c.DeleteDBSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSnapshot = "DeleteDBSnapshot"

// DeleteDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSnapshot for more information on using the DeleteDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSnapshotRequest method.
//    req, resp := client.DeleteDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot
func (c *RDS) DeleteDBSnapshotRequest(input *DeleteDBSnapshotInput) (req *request.Request, output *DeleteDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSnapshotInput{}
	}

	output = &DeleteDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBSnapshot API operation for Amazon Relational Database Service.
//
// Deletes a DB snapshot. If the snapshot is being copied, the copy operation
// is terminated.
//
// The DB snapshot must be in the available state to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot
func (c *RDS) DeleteDBSnapshot(input *DeleteDBSnapshotInput) (*DeleteDBSnapshotOutput, error) {
	req, out := c.DeleteDBSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBSnapshotWithContext is the same as DeleteDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSnapshotWithContext(ctx aws.Context, input *DeleteDBSnapshotInput, opts ...request.Option) (*DeleteDBSnapshotOutput, error) {
	req, out := c.DeleteDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSubnetGroup for more information on using the DeleteDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSubnetGroupRequest method.
//    req, resp := client.DeleteDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup
func (c *RDS) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) (req *request.Request, output *DeleteDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	output = &DeleteDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Deletes a DB subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it's in use.
//
//   * ErrCodeInvalidDBSubnetStateFault "InvalidDBSubnetStateFault"
//   The DB subnet isn't in the available state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup
func (c *RDS) DeleteDBSubnetGroup(input *DeleteDBSubnetGroupInput) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSubnetGroupWithContext is the same as DeleteDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSubnetGroupWithContext(ctx aws.Context, input *DeleteDBSubnetGroupInput, opts ...request.Option) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription
func (c *RDS) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for Amazon Relational Database Service.
//
// Deletes an RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeInvalidEventSubscriptionStateFault "InvalidEventSubscriptionState"
//   This error can occur if someone else is modifying a subscription. You should
//   retry the action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription
func (c *RDS) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGlobalCluster = "DeleteGlobalCluster"

// DeleteGlobalClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGlobalCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGlobalCluster for more information on using the DeleteGlobalCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGlobalClusterRequest method.
//    req, resp := client.DeleteGlobalClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster
func (c *RDS) DeleteGlobalClusterRequest(input *DeleteGlobalClusterInput) (req *request.Request, output *DeleteGlobalClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteGlobalCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGlobalClusterInput{}
	}

	output = &DeleteGlobalClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGlobalCluster API operation for Amazon Relational Database Service.
//
// Deletes a global database cluster. The primary and secondary clusters must
// already be detached or destroyed first.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteGlobalCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalClusterNotFoundFault "GlobalClusterNotFoundFault"
//
//   * ErrCodeInvalidGlobalClusterStateFault "InvalidGlobalClusterStateFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster
func (c *RDS) DeleteGlobalCluster(input *DeleteGlobalClusterInput) (*DeleteGlobalClusterOutput, error) {
	req, out := c.DeleteGlobalClusterRequest(input)
	return out, req.Send()
}

// DeleteGlobalClusterWithContext is the same as DeleteGlobalCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGlobalCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteGlobalClusterWithContext(ctx aws.Context, input *DeleteGlobalClusterInput, opts ...request.Option) (*DeleteGlobalClusterOutput, error) {
	req, out := c.DeleteGlobalClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstallationMedia = "DeleteInstallationMedia"

// DeleteInstallationMediaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstallationMedia operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstallationMedia for more information on using the DeleteInstallationMedia
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstallationMediaRequest method.
//    req, resp := client.DeleteInstallationMediaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteInstallationMedia
func (c *RDS) DeleteInstallationMediaRequest(input *DeleteInstallationMediaInput) (req *request.Request, output *DeleteInstallationMediaOutput) {
	op := &request.Operation{
		Name:       opDeleteInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstallationMediaInput{}
	}

	output = &DeleteInstallationMediaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstallationMedia API operation for Amazon Relational Database Service.
//
// Deletes the installation medium for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteInstallationMedia for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstallationMediaNotFoundFault "InstallationMediaNotFound"
//   InstallationMediaID doesn't refer to an existing installation medium.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteInstallationMedia
func (c *RDS) DeleteInstallationMedia(input *DeleteInstallationMediaInput) (*DeleteInstallationMediaOutput, error) {
	req, out := c.DeleteInstallationMediaRequest(input)
	return out, req.Send()
}

// DeleteInstallationMediaWithContext is the same as DeleteInstallationMedia with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstallationMedia for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteInstallationMediaWithContext(ctx aws.Context, input *DeleteInstallationMediaInput, opts ...request.Option) (*DeleteInstallationMediaOutput, error) {
	req, out := c.DeleteInstallationMediaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOptionGroup = "DeleteOptionGroup"

// DeleteOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOptionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOptionGroup for more information on using the DeleteOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOptionGroupRequest method.
//    req, resp := client.DeleteOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup
func (c *RDS) DeleteOptionGroupRequest(input *DeleteOptionGroupInput) (req *request.Request, output *DeleteOptionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOptionGroupInput{}
	}

	output = &DeleteOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOptionGroup API operation for Amazon Relational Database Service.
//
// Deletes an existing option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeInvalidOptionGroupStateFault "InvalidOptionGroupStateFault"
//   The option group isn't in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup
func (c *RDS) DeleteOptionGroup(input *DeleteOptionGroupInput) (*DeleteOptionGroupOutput, error) {
	req, out := c.DeleteOptionGroupRequest(input)
	return out, req.Send()
}

// DeleteOptionGroupWithContext is the same as DeleteOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteOptionGroupWithContext(ctx aws.Context, input *DeleteOptionGroupInput, opts ...request.Option) (*DeleteOptionGroupOutput, error) {
	req, out := c.DeleteOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterDBProxyTargets = "DeregisterDBProxyTargets"

// DeregisterDBProxyTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterDBProxyTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterDBProxyTargets for more information on using the DeregisterDBProxyTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterDBProxyTargetsRequest method.
//    req, resp := client.DeregisterDBProxyTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets
func (c *RDS) DeregisterDBProxyTargetsRequest(input *DeregisterDBProxyTargetsInput) (req *request.Request, output *DeregisterDBProxyTargetsOutput) {
	op := &request.Operation{
		Name:       opDeregisterDBProxyTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterDBProxyTargetsInput{}
	}

	output = &DeregisterDBProxyTargetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterDBProxyTargets API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Remove the association between one or more DBProxyTarget data structures
// and a DBProxyTargetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeregisterDBProxyTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyTargetNotFoundFault "DBProxyTargetNotFoundFault"
//   The specified RDS DB instance or Aurora DB cluster isn't available for a
//   proxy owned by your AWS account in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets
func (c *RDS) DeregisterDBProxyTargets(input *DeregisterDBProxyTargetsInput) (*DeregisterDBProxyTargetsOutput, error) {
	req, out := c.DeregisterDBProxyTargetsRequest(input)
	return out, req.Send()
}

// DeregisterDBProxyTargetsWithContext is the same as DeregisterDBProxyTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterDBProxyTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeregisterDBProxyTargetsWithContext(ctx aws.Context, input *DeregisterDBProxyTargetsInput, opts ...request.Option) (*DeregisterDBProxyTargetsOutput, error) {
	req, out := c.DeregisterDBProxyTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes
func (c *RDS) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Relational Database Service.
//
// Lists all of the attributes for a customer account. The attributes include
// Amazon RDS quotas for the account, such as the number of DB instances allowed.
// The description for a quota includes the quota name, current usage toward
// that quota, and the quota's maximum value.
//
// This command doesn't take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes
func (c *RDS) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates
func (c *RDS) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for Amazon Relational Database Service.
//
// Lists the set of CA certificates provided by Amazon RDS for this AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier doesn't refer to an existing certificate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates
func (c *RDS) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomAvailabilityZones = "DescribeCustomAvailabilityZones"

// DescribeCustomAvailabilityZonesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomAvailabilityZones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomAvailabilityZones for more information on using the DescribeCustomAvailabilityZones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCustomAvailabilityZonesRequest method.
//    req, resp := client.DescribeCustomAvailabilityZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCustomAvailabilityZones
func (c *RDS) DescribeCustomAvailabilityZonesRequest(input *DescribeCustomAvailabilityZonesInput) (req *request.Request, output *DescribeCustomAvailabilityZonesOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCustomAvailabilityZonesInput{}
	}

	output = &DescribeCustomAvailabilityZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomAvailabilityZones API operation for Amazon Relational Database Service.
//
// Returns information about custom Availability Zones (AZs).
//
// A custom AZ is an on-premises AZ that is integrated with a VMware vSphere
// cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeCustomAvailabilityZones for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCustomAvailabilityZoneNotFoundFault "CustomAvailabilityZoneNotFound"
//   CustomAvailabilityZoneId doesn't refer to an existing custom Availability
//   Zone identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCustomAvailabilityZones
func (c *RDS) DescribeCustomAvailabilityZones(input *DescribeCustomAvailabilityZonesInput) (*DescribeCustomAvailabilityZonesOutput, error) {
	req, out := c.DescribeCustomAvailabilityZonesRequest(input)
	return out, req.Send()
}

// DescribeCustomAvailabilityZonesWithContext is the same as DescribeCustomAvailabilityZones with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomAvailabilityZones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeCustomAvailabilityZonesWithContext(ctx aws.Context, input *DescribeCustomAvailabilityZonesInput, opts ...request.Option) (*DescribeCustomAvailabilityZonesOutput, error) {
	req, out := c.DescribeCustomAvailabilityZonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCustomAvailabilityZonesPages iterates over the pages of a DescribeCustomAvailabilityZones operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCustomAvailabilityZones method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCustomAvailabilityZones operation.
//    pageNum := 0
//    err := client.DescribeCustomAvailabilityZonesPages(params,
//        func(page *rds.DescribeCustomAvailabilityZonesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeCustomAvailabilityZonesPages(input *DescribeCustomAvailabilityZonesInput, fn func(*DescribeCustomAvailabilityZonesOutput, bool) bool) error {
	return c.DescribeCustomAvailabilityZonesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCustomAvailabilityZonesPagesWithContext same as DescribeCustomAvailabilityZonesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeCustomAvailabilityZonesPagesWithContext(ctx aws.Context, input *DescribeCustomAvailabilityZonesInput, fn func(*DescribeCustomAvailabilityZonesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCustomAvailabilityZonesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCustomAvailabilityZonesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCustomAvailabilityZonesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBClusterBacktracks = "DescribeDBClusterBacktracks"

// DescribeDBClusterBacktracksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterBacktracks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterBacktracks for more information on using the DescribeDBClusterBacktracks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterBacktracksRequest method.
//    req, resp := client.DescribeDBClusterBacktracksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks
func (c *RDS) DescribeDBClusterBacktracksRequest(input *DescribeDBClusterBacktracksInput) (req *request.Request, output *DescribeDBClusterBacktracksOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterBacktracks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterBacktracksInput{}
	}

	output = &DescribeDBClusterBacktracksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterBacktracks API operation for Amazon Relational Database Service.
//
// Returns information about backtracks for a DB cluster.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterBacktracks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBClusterBacktrackNotFoundFault "DBClusterBacktrackNotFoundFault"
//   BacktrackIdentifier doesn't refer to an existing backtrack.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks
func (c *RDS) DescribeDBClusterBacktracks(input *DescribeDBClusterBacktracksInput) (*DescribeDBClusterBacktracksOutput, error) {
	req, out := c.DescribeDBClusterBacktracksRequest(input)
	return out, req.Send()
}

// DescribeDBClusterBacktracksWithContext is the same as DescribeDBClusterBacktracks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterBacktracks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterBacktracksWithContext(ctx aws.Context, input *DescribeDBClusterBacktracksInput, opts ...request.Option) (*DescribeDBClusterBacktracksOutput, error) {
	req, out := c.DescribeDBClusterBacktracksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterEndpoints = "DescribeDBClusterEndpoints"

// DescribeDBClusterEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterEndpoints for more information on using the DescribeDBClusterEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterEndpointsRequest method.
//    req, resp := client.DescribeDBClusterEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints
func (c *RDS) DescribeDBClusterEndpointsRequest(input *DescribeDBClusterEndpointsInput) (req *request.Request, output *DescribeDBClusterEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterEndpointsInput{}
	}

	output = &DescribeDBClusterEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterEndpoints API operation for Amazon Relational Database Service.
//
// Returns information about endpoints for an Amazon Aurora DB cluster.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints
func (c *RDS) DescribeDBClusterEndpoints(input *DescribeDBClusterEndpointsInput) (*DescribeDBClusterEndpointsOutput, error) {
	req, out := c.DescribeDBClusterEndpointsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterEndpointsWithContext is the same as DescribeDBClusterEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterEndpointsWithContext(ctx aws.Context, input *DescribeDBClusterEndpointsInput, opts ...request.Option) (*DescribeDBClusterEndpointsOutput, error) {
	req, out := c.DescribeDBClusterEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameterGroups = "DescribeDBClusterParameterGroups"

// DescribeDBClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameterGroups for more information on using the DescribeDBClusterParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParameterGroupsRequest method.
//    req, resp := client.DescribeDBClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups
func (c *RDS) DescribeDBClusterParameterGroupsRequest(input *DescribeDBClusterParameterGroupsInput) (req *request.Request, output *DescribeDBClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParameterGroupsInput{}
	}

	output = &DescribeDBClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameterGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
// parameter is specified, the list will contain only the description of the
// specified DB cluster parameter group.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups
func (c *RDS) DescribeDBClusterParameterGroups(input *DescribeDBClusterParameterGroupsInput) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParameterGroupsWithContext is the same as DescribeDBClusterParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterParameterGroupsWithContext(ctx aws.Context, input *DescribeDBClusterParameterGroupsInput, opts ...request.Option) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameters = "DescribeDBClusterParameters"

// DescribeDBClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameters for more information on using the DescribeDBClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParametersRequest method.
//    req, resp := client.DescribeDBClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters
func (c *RDS) DescribeDBClusterParametersRequest(input *DescribeDBClusterParametersInput) (req *request.Request, output *DescribeDBClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParametersInput{}
	}

	output = &DescribeDBClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameters API operation for Amazon Relational Database Service.
//
// Returns the detailed parameter list for a particular DB cluster parameter
// group.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters
func (c *RDS) DescribeDBClusterParameters(input *DescribeDBClusterParametersInput) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParametersWithContext is the same as DescribeDBClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterParametersWithContext(ctx aws.Context, input *DescribeDBClusterParametersInput, opts ...request.Option) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshotAttributes = "DescribeDBClusterSnapshotAttributes"

// DescribeDBClusterSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshotAttributes for more information on using the DescribeDBClusterSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBClusterSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *RDS) DescribeDBClusterSnapshotAttributesRequest(input *DescribeDBClusterSnapshotAttributesInput) (req *request.Request, output *DescribeDBClusterSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotAttributesInput{}
	}

	output = &DescribeDBClusterSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshotAttributes API operation for Amazon Relational Database Service.
//
// Returns a list of DB cluster snapshot attribute names and values for a manual
// DB cluster snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBClusterSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB cluster snapshot. If all
// is included in the list of values for the restore attribute, then the manual
// DB cluster snapshot is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// cluster snapshot, or to make the manual DB cluster snapshot public or private,
// use the ModifyDBClusterSnapshotAttribute API action.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *RDS) DescribeDBClusterSnapshotAttributes(input *DescribeDBClusterSnapshotAttributesInput) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotAttributesWithContext is the same as DescribeDBClusterSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotAttributesInput, opts ...request.Option) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshots = "DescribeDBClusterSnapshots"

// DescribeDBClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshots for more information on using the DescribeDBClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotsRequest method.
//    req, resp := client.DescribeDBClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots
func (c *RDS) DescribeDBClusterSnapshotsRequest(input *DescribeDBClusterSnapshotsInput) (req *request.Request, output *DescribeDBClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotsInput{}
	}

	output = &DescribeDBClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshots API operation for Amazon Relational Database Service.
//
// Returns information about DB cluster snapshots. This API action supports
// pagination.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots
func (c *RDS) DescribeDBClusterSnapshots(input *DescribeDBClusterSnapshotsInput) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotsWithContext is the same as DescribeDBClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterSnapshotsWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotsInput, opts ...request.Option) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusters = "DescribeDBClusters"

// DescribeDBClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusters for more information on using the DescribeDBClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClustersRequest method.
//    req, resp := client.DescribeDBClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters
func (c *RDS) DescribeDBClustersRequest(input *DescribeDBClustersInput) (req *request.Request, output *DescribeDBClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBClustersInput{}
	}

	output = &DescribeDBClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusters API operation for Amazon Relational Database Service.
//
// Returns information about provisioned Aurora DB clusters. This API supports
// pagination.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This operation can also return information for Amazon Neptune DB instances
// and Amazon DocumentDB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters
func (c *RDS) DescribeDBClusters(input *DescribeDBClustersInput) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	return out, req.Send()
}

// DescribeDBClustersWithContext is the same as DescribeDBClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClustersWithContext(ctx aws.Context, input *DescribeDBClustersInput, opts ...request.Option) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBClustersPages iterates over the pages of a DescribeDBClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBClusters operation.
//    pageNum := 0
//    err := client.DescribeDBClustersPages(params,
//        func(page *rds.DescribeDBClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBClustersPages(input *DescribeDBClustersInput, fn func(*DescribeDBClustersOutput, bool) bool) error {
	return c.DescribeDBClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBClustersPagesWithContext same as DescribeDBClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClustersPagesWithContext(ctx aws.Context, input *DescribeDBClustersInput, fn func(*DescribeDBClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBEngineVersions = "DescribeDBEngineVersions"

// DescribeDBEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBEngineVersions for more information on using the DescribeDBEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBEngineVersionsRequest method.
//    req, resp := client.DescribeDBEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions
func (c *RDS) DescribeDBEngineVersionsRequest(input *DescribeDBEngineVersionsInput) (req *request.Request, output *DescribeDBEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBEngineVersionsInput{}
	}

	output = &DescribeDBEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBEngineVersions API operation for Amazon Relational Database Service.
//
// Returns a list of the available DB engines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBEngineVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions
func (c *RDS) DescribeDBEngineVersions(input *DescribeDBEngineVersionsInput) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeDBEngineVersionsWithContext is the same as DescribeDBEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBEngineVersionsWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, opts ...request.Option) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBEngineVersionsPages iterates over the pages of a DescribeDBEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBEngineVersions operation.
//    pageNum := 0
//    err := client.DescribeDBEngineVersionsPages(params,
//        func(page *rds.DescribeDBEngineVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBEngineVersionsPages(input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool) error {
	return c.DescribeDBEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBEngineVersionsPagesWithContext same as DescribeDBEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBEngineVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBInstanceAutomatedBackups = "DescribeDBInstanceAutomatedBackups"

// DescribeDBInstanceAutomatedBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBInstanceAutomatedBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBInstanceAutomatedBackups for more information on using the DescribeDBInstanceAutomatedBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBInstanceAutomatedBackupsRequest method.
//    req, resp := client.DescribeDBInstanceAutomatedBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups
func (c *RDS) DescribeDBInstanceAutomatedBackupsRequest(input *DescribeDBInstanceAutomatedBackupsInput) (req *request.Request, output *DescribeDBInstanceAutomatedBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceAutomatedBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstanceAutomatedBackupsInput{}
	}

	output = &DescribeDBInstanceAutomatedBackupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBInstanceAutomatedBackups API operation for Amazon Relational Database Service.
//
// Displays backups for both current and deleted instances. For example, use
// this operation to find details about automated backups for previously deleted
// instances. Current instances with retention periods greater than zero (0)
// are returned for both the DescribeDBInstanceAutomatedBackups and DescribeDBInstances
// operations.
//
// All parameters are optional.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBInstanceAutomatedBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAutomatedBackupNotFoundFault "DBInstanceAutomatedBackupNotFound"
//   No automated backup for this DB instance was found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups
func (c *RDS) DescribeDBInstanceAutomatedBackups(input *DescribeDBInstanceAutomatedBackupsInput) (*DescribeDBInstanceAutomatedBackupsOutput, error) {
	req, out := c.DescribeDBInstanceAutomatedBackupsRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceAutomatedBackupsWithContext is the same as DescribeDBInstanceAutomatedBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceAutomatedBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstanceAutomatedBackupsWithContext(ctx aws.Context, input *DescribeDBInstanceAutomatedBackupsInput, opts ...request.Option) (*DescribeDBInstanceAutomatedBackupsOutput, error) {
	req, out := c.DescribeDBInstanceAutomatedBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBInstanceAutomatedBackupsPages iterates over the pages of a DescribeDBInstanceAutomatedBackups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBInstanceAutomatedBackups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBInstanceAutomatedBackups operation.
//    pageNum := 0
//    err := client.DescribeDBInstanceAutomatedBackupsPages(params,
//        func(page *rds.DescribeDBInstanceAutomatedBackupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBInstanceAutomatedBackupsPages(input *DescribeDBInstanceAutomatedBackupsInput, fn func(*DescribeDBInstanceAutomatedBackupsOutput, bool) bool) error {
	return c.DescribeDBInstanceAutomatedBackupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBInstanceAutomatedBackupsPagesWithContext same as DescribeDBInstanceAutomatedBackupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstanceAutomatedBackupsPagesWithContext(ctx aws.Context, input *DescribeDBInstanceAutomatedBackupsInput, fn func(*DescribeDBInstanceAutomatedBackupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBInstanceAutomatedBackupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBInstanceAutomatedBackupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBInstanceAutomatedBackupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances
func (c *RDS) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBInstances API operation for Amazon Relational Database Service.
//
// Returns information about provisioned RDS instances. This API supports pagination.
//
// This operation can also return information for Amazon Neptune DB instances
// and Amazon DocumentDB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances
func (c *RDS) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstancesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBInstancesPages iterates over the pages of a DescribeDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBInstances operation.
//    pageNum := 0
//    err := client.DescribeDBInstancesPages(params,
//        func(page *rds.DescribeDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBInstancesPages(input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool) error {
	return c.DescribeDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBInstancesPagesWithContext same as DescribeDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstancesPagesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBLogFiles = "DescribeDBLogFiles"

// DescribeDBLogFilesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBLogFiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBLogFiles for more information on using the DescribeDBLogFiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBLogFilesRequest method.
//    req, resp := client.DescribeDBLogFilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles
func (c *RDS) DescribeDBLogFilesRequest(input *DescribeDBLogFilesInput) (req *request.Request, output *DescribeDBLogFilesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBLogFiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBLogFilesInput{}
	}

	output = &DescribeDBLogFilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBLogFiles API operation for Amazon Relational Database Service.
//
// Returns a list of DB log files for the DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBLogFiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles
func (c *RDS) DescribeDBLogFiles(input *DescribeDBLogFilesInput) (*DescribeDBLogFilesOutput, error) {
	req, out := c.DescribeDBLogFilesRequest(input)
	return out, req.Send()
}

// DescribeDBLogFilesWithContext is the same as DescribeDBLogFiles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBLogFiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBLogFilesWithContext(ctx aws.Context, input *DescribeDBLogFilesInput, opts ...request.Option) (*DescribeDBLogFilesOutput, error) {
	req, out := c.DescribeDBLogFilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBLogFilesPages iterates over the pages of a DescribeDBLogFiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBLogFiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBLogFiles operation.
//    pageNum := 0
//    err := client.DescribeDBLogFilesPages(params,
//        func(page *rds.DescribeDBLogFilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBLogFilesPages(input *DescribeDBLogFilesInput, fn func(*DescribeDBLogFilesOutput, bool) bool) error {
	return c.DescribeDBLogFilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBLogFilesPagesWithContext same as DescribeDBLogFilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBLogFilesPagesWithContext(ctx aws.Context, input *DescribeDBLogFilesInput, fn func(*DescribeDBLogFilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBLogFilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBLogFilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBLogFilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBParameterGroups = "DescribeDBParameterGroups"

// DescribeDBParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameterGroups for more information on using the DescribeDBParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParameterGroupsRequest method.
//    req, resp := client.DescribeDBParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups
func (c *RDS) DescribeDBParameterGroupsRequest(input *DescribeDBParameterGroupsInput) (req *request.Request, output *DescribeDBParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParameterGroupsInput{}
	}

	output = &DescribeDBParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameterGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName
// is specified, the list will contain only the description of the specified
// DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups
func (c *RDS) DescribeDBParameterGroups(input *DescribeDBParameterGroupsInput) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBParameterGroupsWithContext is the same as DescribeDBParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParameterGroupsWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, opts ...request.Option) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParameterGroupsPages iterates over the pages of a DescribeDBParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeDBParameterGroupsPages(params,
//        func(page *rds.DescribeDBParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBParameterGroupsPages(input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool) error {
	return c.DescribeDBParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParameterGroupsPagesWithContext same as DescribeDBParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBParameterGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBParameters = "DescribeDBParameters"

// DescribeDBParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameters for more information on using the DescribeDBParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParametersRequest method.
//    req, resp := client.DescribeDBParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters
func (c *RDS) DescribeDBParametersRequest(input *DescribeDBParametersInput) (req *request.Request, output *DescribeDBParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParametersInput{}
	}

	output = &DescribeDBParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameters API operation for Amazon Relational Database Service.
//
// Returns the detailed parameter list for a particular DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters
func (c *RDS) DescribeDBParameters(input *DescribeDBParametersInput) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	return out, req.Send()
}

// DescribeDBParametersWithContext is the same as DescribeDBParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParametersWithContext(ctx aws.Context, input *DescribeDBParametersInput, opts ...request.Option) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParametersPages iterates over the pages of a DescribeDBParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameters operation.
//    pageNum := 0
//    err := client.DescribeDBParametersPages(params,
//        func(page *rds.DescribeDBParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBParametersPages(input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool) error {
	return c.DescribeDBParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParametersPagesWithContext same as DescribeDBParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParametersPagesWithContext(ctx aws.Context, input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBProxies = "DescribeDBProxies"

// DescribeDBProxiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBProxies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBProxies for more information on using the DescribeDBProxies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBProxiesRequest method.
//    req, resp := client.DescribeDBProxiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies
func (c *RDS) DescribeDBProxiesRequest(input *DescribeDBProxiesInput) (req *request.Request, output *DescribeDBProxiesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBProxies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBProxiesInput{}
	}

	output = &DescribeDBProxiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBProxies API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Returns information about DB proxies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBProxies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies
func (c *RDS) DescribeDBProxies(input *DescribeDBProxiesInput) (*DescribeDBProxiesOutput, error) {
	req, out := c.DescribeDBProxiesRequest(input)
	return out, req.Send()
}

// DescribeDBProxiesWithContext is the same as DescribeDBProxies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBProxies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxiesWithContext(ctx aws.Context, input *DescribeDBProxiesInput, opts ...request.Option) (*DescribeDBProxiesOutput, error) {
	req, out := c.DescribeDBProxiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBProxiesPages iterates over the pages of a DescribeDBProxies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBProxies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBProxies operation.
//    pageNum := 0
//    err := client.DescribeDBProxiesPages(params,
//        func(page *rds.DescribeDBProxiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBProxiesPages(input *DescribeDBProxiesInput, fn func(*DescribeDBProxiesOutput, bool) bool) error {
	return c.DescribeDBProxiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBProxiesPagesWithContext same as DescribeDBProxiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxiesPagesWithContext(ctx aws.Context, input *DescribeDBProxiesInput, fn func(*DescribeDBProxiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBProxiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBProxiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBProxiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBProxyTargetGroups = "DescribeDBProxyTargetGroups"

// DescribeDBProxyTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBProxyTargetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBProxyTargetGroups for more information on using the DescribeDBProxyTargetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBProxyTargetGroupsRequest method.
//    req, resp := client.DescribeDBProxyTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups
func (c *RDS) DescribeDBProxyTargetGroupsRequest(input *DescribeDBProxyTargetGroupsInput) (req *request.Request, output *DescribeDBProxyTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBProxyTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBProxyTargetGroupsInput{}
	}

	output = &DescribeDBProxyTargetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBProxyTargetGroups API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Returns information about DB proxy target groups, represented by DBProxyTargetGroup
// data structures.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBProxyTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups
func (c *RDS) DescribeDBProxyTargetGroups(input *DescribeDBProxyTargetGroupsInput) (*DescribeDBProxyTargetGroupsOutput, error) {
	req, out := c.DescribeDBProxyTargetGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBProxyTargetGroupsWithContext is the same as DescribeDBProxyTargetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBProxyTargetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxyTargetGroupsWithContext(ctx aws.Context, input *DescribeDBProxyTargetGroupsInput, opts ...request.Option) (*DescribeDBProxyTargetGroupsOutput, error) {
	req, out := c.DescribeDBProxyTargetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBProxyTargetGroupsPages iterates over the pages of a DescribeDBProxyTargetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBProxyTargetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBProxyTargetGroups operation.
//    pageNum := 0
//    err := client.DescribeDBProxyTargetGroupsPages(params,
//        func(page *rds.DescribeDBProxyTargetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBProxyTargetGroupsPages(input *DescribeDBProxyTargetGroupsInput, fn func(*DescribeDBProxyTargetGroupsOutput, bool) bool) error {
	return c.DescribeDBProxyTargetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBProxyTargetGroupsPagesWithContext same as DescribeDBProxyTargetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxyTargetGroupsPagesWithContext(ctx aws.Context, input *DescribeDBProxyTargetGroupsInput, fn func(*DescribeDBProxyTargetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBProxyTargetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBProxyTargetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBProxyTargetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBProxyTargets = "DescribeDBProxyTargets"

// DescribeDBProxyTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBProxyTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBProxyTargets for more information on using the DescribeDBProxyTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBProxyTargetsRequest method.
//    req, resp := client.DescribeDBProxyTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets
func (c *RDS) DescribeDBProxyTargetsRequest(input *DescribeDBProxyTargetsInput) (req *request.Request, output *DescribeDBProxyTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBProxyTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBProxyTargetsInput{}
	}

	output = &DescribeDBProxyTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBProxyTargets API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Returns information about DBProxyTarget objects. This API supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBProxyTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetNotFoundFault "DBProxyTargetNotFoundFault"
//   The specified RDS DB instance or Aurora DB cluster isn't available for a
//   proxy owned by your AWS account in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets
func (c *RDS) DescribeDBProxyTargets(input *DescribeDBProxyTargetsInput) (*DescribeDBProxyTargetsOutput, error) {
	req, out := c.DescribeDBProxyTargetsRequest(input)
	return out, req.Send()
}

// DescribeDBProxyTargetsWithContext is the same as DescribeDBProxyTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBProxyTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxyTargetsWithContext(ctx aws.Context, input *DescribeDBProxyTargetsInput, opts ...request.Option) (*DescribeDBProxyTargetsOutput, error) {
	req, out := c.DescribeDBProxyTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBProxyTargetsPages iterates over the pages of a DescribeDBProxyTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBProxyTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBProxyTargets operation.
//    pageNum := 0
//    err := client.DescribeDBProxyTargetsPages(params,
//        func(page *rds.DescribeDBProxyTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBProxyTargetsPages(input *DescribeDBProxyTargetsInput, fn func(*DescribeDBProxyTargetsOutput, bool) bool) error {
	return c.DescribeDBProxyTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBProxyTargetsPagesWithContext same as DescribeDBProxyTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBProxyTargetsPagesWithContext(ctx aws.Context, input *DescribeDBProxyTargetsInput, fn func(*DescribeDBProxyTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBProxyTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBProxyTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBProxyTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBSecurityGroups = "DescribeDBSecurityGroups"

// DescribeDBSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSecurityGroups for more information on using the DescribeDBSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSecurityGroupsRequest method.
//    req, resp := client.DescribeDBSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups
func (c *RDS) DescribeDBSecurityGroupsRequest(input *DescribeDBSecurityGroupsInput) (req *request.Request, output *DescribeDBSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSecurityGroupsInput{}
	}

	output = &DescribeDBSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSecurityGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName
// is specified, the list will contain only the descriptions of the specified
// DB security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups
func (c *RDS) DescribeDBSecurityGroups(input *DescribeDBSecurityGroupsInput) (*DescribeDBSecurityGroupsOutput, error) {
	req, out := c.DescribeDBSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSecurityGroupsWithContext is the same as DescribeDBSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSecurityGroupsWithContext(ctx aws.Context, input *DescribeDBSecurityGroupsInput, opts ...request.Option) (*DescribeDBSecurityGroupsOutput, error) {
	req, out := c.DescribeDBSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSecurityGroupsPages iterates over the pages of a DescribeDBSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSecurityGroupsPages(params,
//        func(page *rds.DescribeDBSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSecurityGroupsPages(input *DescribeDBSecurityGroupsInput, fn func(*DescribeDBSecurityGroupsOutput, bool) bool) error {
	return c.DescribeDBSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSecurityGroupsPagesWithContext same as DescribeDBSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSecurityGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSecurityGroupsInput, fn func(*DescribeDBSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBSnapshotAttributes = "DescribeDBSnapshotAttributes"

// DescribeDBSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSnapshotAttributes for more information on using the DescribeDBSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes
func (c *RDS) DescribeDBSnapshotAttributesRequest(input *DescribeDBSnapshotAttributesInput) (req *request.Request, output *DescribeDBSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBSnapshotAttributesInput{}
	}

	output = &DescribeDBSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSnapshotAttributes API operation for Amazon Relational Database Service.
//
// Returns a list of DB snapshot attribute names and values for a manual DB
// snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB snapshot. If all is included
// in the list of values for the restore attribute, then the manual DB snapshot
// is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// snapshot, or to make the manual DB snapshot public or private, use the ModifyDBSnapshotAttribute
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes
func (c *RDS) DescribeDBSnapshotAttributes(input *DescribeDBSnapshotAttributesInput) (*DescribeDBSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBSnapshotAttributesWithContext is the same as DescribeDBSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBSnapshotAttributesInput, opts ...request.Option) (*DescribeDBSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBSnapshots = "DescribeDBSnapshots"

// DescribeDBSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSnapshots for more information on using the DescribeDBSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSnapshotsRequest method.
//    req, resp := client.DescribeDBSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots
func (c *RDS) DescribeDBSnapshotsRequest(input *DescribeDBSnapshotsInput) (req *request.Request, output *DescribeDBSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSnapshotsInput{}
	}

	output = &DescribeDBSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSnapshots API operation for Amazon Relational Database Service.
//
// Returns information about DB snapshots. This API action supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots
func (c *RDS) DescribeDBSnapshots(input *DescribeDBSnapshotsInput) (*DescribeDBSnapshotsOutput, error) {
	req, out := c.DescribeDBSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBSnapshotsWithContext is the same as DescribeDBSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotsWithContext(ctx aws.Context, input *DescribeDBSnapshotsInput, opts ...request.Option) (*DescribeDBSnapshotsOutput, error) {
	req, out := c.DescribeDBSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSnapshotsPages iterates over the pages of a DescribeDBSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSnapshots operation.
//    pageNum := 0
//    err := client.DescribeDBSnapshotsPages(params,
//        func(page *rds.DescribeDBSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSnapshotsPages(input *DescribeDBSnapshotsInput, fn func(*DescribeDBSnapshotsOutput, bool) bool) error {
	return c.DescribeDBSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSnapshotsPagesWithContext same as DescribeDBSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotsPagesWithContext(ctx aws.Context, input *DescribeDBSnapshotsInput, fn func(*DescribeDBSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBSubnetGroups = "DescribeDBSubnetGroups"

// DescribeDBSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSubnetGroups for more information on using the DescribeDBSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSubnetGroupsRequest method.
//    req, resp := client.DescribeDBSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups
func (c *RDS) DescribeDBSubnetGroupsRequest(input *DescribeDBSubnetGroupsInput) (req *request.Request, output *DescribeDBSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSubnetGroupsInput{}
	}

	output = &DescribeDBSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSubnetGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified,
// the list will contain only the descriptions of the specified DBSubnetGroup.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups
func (c *RDS) DescribeDBSubnetGroups(input *DescribeDBSubnetGroupsInput) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSubnetGroupsWithContext is the same as DescribeDBSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSubnetGroupsWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, opts ...request.Option) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSubnetGroupsPages iterates over the pages of a DescribeDBSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSubnetGroupsPages(params,
//        func(page *rds.DescribeDBSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSubnetGroupsPages(input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool) error {
	return c.DescribeDBSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSubnetGroupsPagesWithContext same as DescribeDBSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEngineDefaultClusterParameters = "DescribeEngineDefaultClusterParameters"

// DescribeEngineDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultClusterParameters for more information on using the DescribeEngineDefaultClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultClusterParametersRequest method.
//    req, resp := client.DescribeEngineDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *RDS) DescribeEngineDefaultClusterParametersRequest(input *DescribeEngineDefaultClusterParametersInput) (req *request.Request, output *DescribeEngineDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineDefaultClusterParametersInput{}
	}

	output = &DescribeEngineDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultClusterParameters API operation for Amazon Relational Database Service.
//
// Returns the default engine and system parameter information for the cluster
// database engine.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEngineDefaultClusterParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *RDS) DescribeEngineDefaultClusterParameters(input *DescribeEngineDefaultClusterParametersInput) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultClusterParametersWithContext is the same as DescribeEngineDefaultClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultClusterParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultClusterParametersInput, opts ...request.Option) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultParameters for more information on using the DescribeEngineDefaultParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultParametersRequest method.
//    req, resp := client.DescribeEngineDefaultParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters
func (c *RDS) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *request.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	output = &DescribeEngineDefaultParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultParameters API operation for Amazon Relational Database Service.
//
// Returns the default engine and system parameter information for the specified
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEngineDefaultParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters
func (c *RDS) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultParametersWithContext is the same as DescribeEngineDefaultParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, opts ...request.Option) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEngineDefaultParametersPages iterates over the pages of a DescribeEngineDefaultParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEngineDefaultParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEngineDefaultParameters operation.
//    pageNum := 0
//    err := client.DescribeEngineDefaultParametersPages(params,
//        func(page *rds.DescribeEngineDefaultParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool) error {
	return c.DescribeEngineDefaultParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEngineDefaultParametersPagesWithContext same as DescribeEngineDefaultParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultParametersPagesWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEngineDefaultParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEngineDefaultParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEngineDefaultParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories
func (c *RDS) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon Relational Database Service.
//
// Displays a list of categories for all event source types, or, if specified,
// for a specified source type. You can see a list of the event categories and
// source types in the Events (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories
func (c *RDS) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions
func (c *RDS) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for Amazon Relational Database Service.
//
// Lists all the subscription descriptions for a customer account. The description
// for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify a SubscriptionName, lists the description for that subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions
func (c *RDS) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *rds.DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents
func (c *RDS) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon Relational Database Service.
//
// Returns events related to DB instances, DB security groups, DB snapshots,
// and DB parameter groups for the past 14 days. Events specific to a particular
// DB instance, DB security group, database snapshot, or DB parameter group
// can be obtained by providing the name as a parameter. By default, the past
// hour of events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents
func (c *RDS) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *rds.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportTasks for more information on using the DescribeExportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req, resp := client.DescribeExportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks
func (c *RDS) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for Amazon Relational Database Service.
//
// Returns information about a snapshot export to Amazon S3. This API operation
// supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeExportTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExportTaskNotFoundFault "ExportTaskNotFound"
//   The export task doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks
func (c *RDS) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	return out, req.Send()
}

// DescribeExportTasksWithContext is the same as DescribeExportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeExportTasksWithContext(ctx aws.Context, input *DescribeExportTasksInput, opts ...request.Option) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeExportTasksPages iterates over the pages of a DescribeExportTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeExportTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeExportTasks operation.
//    pageNum := 0
//    err := client.DescribeExportTasksPages(params,
//        func(page *rds.DescribeExportTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeExportTasksPages(input *DescribeExportTasksInput, fn func(*DescribeExportTasksOutput, bool) bool) error {
	return c.DescribeExportTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeExportTasksPagesWithContext same as DescribeExportTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeExportTasksPagesWithContext(ctx aws.Context, input *DescribeExportTasksInput, fn func(*DescribeExportTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeExportTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeExportTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeExportTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGlobalClusters = "DescribeGlobalClusters"

// DescribeGlobalClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGlobalClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGlobalClusters for more information on using the DescribeGlobalClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGlobalClustersRequest method.
//    req, resp := client.DescribeGlobalClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters
func (c *RDS) DescribeGlobalClustersRequest(input *DescribeGlobalClustersInput) (req *request.Request, output *DescribeGlobalClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeGlobalClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGlobalClustersInput{}
	}

	output = &DescribeGlobalClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGlobalClusters API operation for Amazon Relational Database Service.
//
// Returns information about Aurora global database clusters. This API supports
// pagination.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeGlobalClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalClusterNotFoundFault "GlobalClusterNotFoundFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters
func (c *RDS) DescribeGlobalClusters(input *DescribeGlobalClustersInput) (*DescribeGlobalClustersOutput, error) {
	req, out := c.DescribeGlobalClustersRequest(input)
	return out, req.Send()
}

// DescribeGlobalClustersWithContext is the same as DescribeGlobalClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGlobalClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeGlobalClustersWithContext(ctx aws.Context, input *DescribeGlobalClustersInput, opts ...request.Option) (*DescribeGlobalClustersOutput, error) {
	req, out := c.DescribeGlobalClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGlobalClustersPages iterates over the pages of a DescribeGlobalClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGlobalClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeGlobalClusters operation.
//    pageNum := 0
//    err := client.DescribeGlobalClustersPages(params,
//        func(page *rds.DescribeGlobalClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeGlobalClustersPages(input *DescribeGlobalClustersInput, fn func(*DescribeGlobalClustersOutput, bool) bool) error {
	return c.DescribeGlobalClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGlobalClustersPagesWithContext same as DescribeGlobalClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeGlobalClustersPagesWithContext(ctx aws.Context, input *DescribeGlobalClustersInput, fn func(*DescribeGlobalClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGlobalClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGlobalClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGlobalClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstallationMedia = "DescribeInstallationMedia"

// DescribeInstallationMediaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstallationMedia operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstallationMedia for more information on using the DescribeInstallationMedia
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstallationMediaRequest method.
//    req, resp := client.DescribeInstallationMediaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeInstallationMedia
func (c *RDS) DescribeInstallationMediaRequest(input *DescribeInstallationMediaInput) (req *request.Request, output *DescribeInstallationMediaOutput) {
	op := &request.Operation{
		Name:       opDescribeInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstallationMediaInput{}
	}

	output = &DescribeInstallationMediaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstallationMedia API operation for Amazon Relational Database Service.
//
// Describes the available installation media for a DB engine that requires
// an on-premises customer provided license, such as Microsoft SQL Server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeInstallationMedia for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstallationMediaNotFoundFault "InstallationMediaNotFound"
//   InstallationMediaID doesn't refer to an existing installation medium.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeInstallationMedia
func (c *RDS) DescribeInstallationMedia(input *DescribeInstallationMediaInput) (*DescribeInstallationMediaOutput, error) {
	req, out := c.DescribeInstallationMediaRequest(input)
	return out, req.Send()
}

// DescribeInstallationMediaWithContext is the same as DescribeInstallationMedia with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstallationMedia for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeInstallationMediaWithContext(ctx aws.Context, input *DescribeInstallationMediaInput, opts ...request.Option) (*DescribeInstallationMediaOutput, error) {
	req, out := c.DescribeInstallationMediaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstallationMediaPages iterates over the pages of a DescribeInstallationMedia operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstallationMedia method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstallationMedia operation.
//    pageNum := 0
//    err := client.DescribeInstallationMediaPages(params,
//        func(page *rds.DescribeInstallationMediaOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeInstallationMediaPages(input *DescribeInstallationMediaInput, fn func(*DescribeInstallationMediaOutput, bool) bool) error {
	return c.DescribeInstallationMediaPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstallationMediaPagesWithContext same as DescribeInstallationMediaPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeInstallationMediaPagesWithContext(ctx aws.Context, input *DescribeInstallationMediaInput, fn func(*DescribeInstallationMediaOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstallationMediaInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstallationMediaRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstallationMediaOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOptionGroupOptions = "DescribeOptionGroupOptions"

// DescribeOptionGroupOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptionGroupOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptionGroupOptions for more information on using the DescribeOptionGroupOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptionGroupOptionsRequest method.
//    req, resp := client.DescribeOptionGroupOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions
func (c *RDS) DescribeOptionGroupOptionsRequest(input *DescribeOptionGroupOptionsInput) (req *request.Request, output *DescribeOptionGroupOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroupOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupOptionsInput{}
	}

	output = &DescribeOptionGroupOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptionGroupOptions API operation for Amazon Relational Database Service.
//
// Describes all available options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOptionGroupOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions
func (c *RDS) DescribeOptionGroupOptions(input *DescribeOptionGroupOptionsInput) (*DescribeOptionGroupOptionsOutput, error) {
	req, out := c.DescribeOptionGroupOptionsRequest(input)
	return out, req.Send()
}

// DescribeOptionGroupOptionsWithContext is the same as DescribeOptionGroupOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptionGroupOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupOptionsWithContext(ctx aws.Context, input *DescribeOptionGroupOptionsInput, opts ...request.Option) (*DescribeOptionGroupOptionsOutput, error) {
	req, out := c.DescribeOptionGroupOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptionGroupOptionsPages iterates over the pages of a DescribeOptionGroupOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptionGroupOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptionGroupOptions operation.
//    pageNum := 0
//    err := client.DescribeOptionGroupOptionsPages(params,
//        func(page *rds.DescribeOptionGroupOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOptionGroupOptionsPages(input *DescribeOptionGroupOptionsInput, fn func(*DescribeOptionGroupOptionsOutput, bool) bool) error {
	return c.DescribeOptionGroupOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptionGroupOptionsPagesWithContext same as DescribeOptionGroupOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupOptionsPagesWithContext(ctx aws.Context, input *DescribeOptionGroupOptionsInput, fn func(*DescribeOptionGroupOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptionGroupOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptionGroupOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOptionGroupOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOptionGroups = "DescribeOptionGroups"

// DescribeOptionGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptionGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptionGroups for more information on using the DescribeOptionGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptionGroupsRequest method.
//    req, resp := client.DescribeOptionGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups
func (c *RDS) DescribeOptionGroupsRequest(input *DescribeOptionGroupsInput) (req *request.Request, output *DescribeOptionGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupsInput{}
	}

	output = &DescribeOptionGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptionGroups API operation for Amazon Relational Database Service.
//
// Describes the available option groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOptionGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups
func (c *RDS) DescribeOptionGroups(input *DescribeOptionGroupsInput) (*DescribeOptionGroupsOutput, error) {
	req, out := c.DescribeOptionGroupsRequest(input)
	return out, req.Send()
}

// DescribeOptionGroupsWithContext is the same as DescribeOptionGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptionGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupsWithContext(ctx aws.Context, input *DescribeOptionGroupsInput, opts ...request.Option) (*DescribeOptionGroupsOutput, error) {
	req, out := c.DescribeOptionGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptionGroupsPages iterates over the pages of a DescribeOptionGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptionGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptionGroups operation.
//    pageNum := 0
//    err := client.DescribeOptionGroupsPages(params,
//        func(page *rds.DescribeOptionGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOptionGroupsPages(input *DescribeOptionGroupsInput, fn func(*DescribeOptionGroupsOutput, bool) bool) error {
	return c.DescribeOptionGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptionGroupsPagesWithContext same as DescribeOptionGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupsPagesWithContext(ctx aws.Context, input *DescribeOptionGroupsInput, fn func(*DescribeOptionGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptionGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptionGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOptionGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrderableDBInstanceOptions = "DescribeOrderableDBInstanceOptions"

// DescribeOrderableDBInstanceOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableDBInstanceOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableDBInstanceOptions for more information on using the DescribeOrderableDBInstanceOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableDBInstanceOptionsRequest method.
//    req, resp := client.DescribeOrderableDBInstanceOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *RDS) DescribeOrderableDBInstanceOptionsRequest(input *DescribeOrderableDBInstanceOptionsInput) (req *request.Request, output *DescribeOrderableDBInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableDBInstanceOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableDBInstanceOptionsInput{}
	}

	output = &DescribeOrderableDBInstanceOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableDBInstanceOptions API operation for Amazon Relational Database Service.
//
// Returns a list of orderable DB instance options for the specified engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOrderableDBInstanceOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *RDS) DescribeOrderableDBInstanceOptions(input *DescribeOrderableDBInstanceOptionsInput) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsWithContext is the same as DescribeOrderableDBInstanceOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableDBInstanceOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOrderableDBInstanceOptionsWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, opts ...request.Option) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsPages iterates over the pages of a DescribeOrderableDBInstanceOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableDBInstanceOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableDBInstanceOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableDBInstanceOptionsPages(params,
//        func(page *rds.DescribeOrderableDBInstanceOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOrderableDBInstanceOptionsPages(input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool) error {
	return c.DescribeOrderableDBInstanceOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableDBInstanceOptionsPagesWithContext same as DescribeOrderableDBInstanceOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOrderableDBInstanceOptionsPagesWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableDBInstanceOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableDBInstanceOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrderableDBInstanceOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//    req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions
func (c *RDS) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for Amazon Relational Database Service.
//
// Returns a list of resources (for example, DB instances) that have at least
// one pending maintenance action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions
func (c *RDS) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedDBInstances = "DescribeReservedDBInstances"

// DescribeReservedDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedDBInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedDBInstances for more information on using the DescribeReservedDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedDBInstancesRequest method.
//    req, resp := client.DescribeReservedDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances
func (c *RDS) DescribeReservedDBInstancesRequest(input *DescribeReservedDBInstancesInput) (req *request.Request, output *DescribeReservedDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesInput{}
	}

	output = &DescribeReservedDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedDBInstances API operation for Amazon Relational Database Service.
//
// Returns information about reserved DB instances for this account, or about
// a specified reserved DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeReservedDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstanceNotFoundFault "ReservedDBInstanceNotFound"
//   The specified reserved DB Instance not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances
func (c *RDS) DescribeReservedDBInstances(input *DescribeReservedDBInstancesInput) (*DescribeReservedDBInstancesOutput, error) {
	req, out := c.DescribeReservedDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedDBInstancesWithContext is the same as DescribeReservedDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesInput, opts ...request.Option) (*DescribeReservedDBInstancesOutput, error) {
	req, out := c.DescribeReservedDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedDBInstancesPages iterates over the pages of a DescribeReservedDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedDBInstances operation.
//    pageNum := 0
//    err := client.DescribeReservedDBInstancesPages(params,
//        func(page *rds.DescribeReservedDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeReservedDBInstancesPages(input *DescribeReservedDBInstancesInput, fn func(*DescribeReservedDBInstancesOutput, bool) bool) error {
	return c.DescribeReservedDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedDBInstancesPagesWithContext same as DescribeReservedDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesInput, fn func(*DescribeReservedDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedDBInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedDBInstancesOfferings = "DescribeReservedDBInstancesOfferings"

// DescribeReservedDBInstancesOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedDBInstancesOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedDBInstancesOfferings for more information on using the DescribeReservedDBInstancesOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedDBInstancesOfferingsRequest method.
//    req, resp := client.DescribeReservedDBInstancesOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings
func (c *RDS) DescribeReservedDBInstancesOfferingsRequest(input *DescribeReservedDBInstancesOfferingsInput) (req *request.Request, output *DescribeReservedDBInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesOfferingsInput{}
	}

	output = &DescribeReservedDBInstancesOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedDBInstancesOfferings API operation for Amazon Relational Database Service.
//
// Lists available reserved DB instance offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeReservedDBInstancesOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstancesOfferingNotFoundFault "ReservedDBInstancesOfferingNotFound"
//   Specified offering does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings
func (c *RDS) DescribeReservedDBInstancesOfferings(input *DescribeReservedDBInstancesOfferingsInput) (*DescribeReservedDBInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedDBInstancesOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedDBInstancesOfferingsWithContext is the same as DescribeReservedDBInstancesOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedDBInstancesOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesOfferingsWithContext(ctx aws.Context, input *DescribeReservedDBInstancesOfferingsInput, opts ...request.Option) (*DescribeReservedDBInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedDBInstancesOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedDBInstancesOfferingsPages iterates over the pages of a DescribeReservedDBInstancesOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedDBInstancesOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedDBInstancesOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedDBInstancesOfferingsPages(params,
//        func(page *rds.DescribeReservedDBInstancesOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeReservedDBInstancesOfferingsPages(input *DescribeReservedDBInstancesOfferingsInput, fn func(*DescribeReservedDBInstancesOfferingsOutput, bool) bool) error {
	return c.DescribeReservedDBInstancesOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedDBInstancesOfferingsPagesWithContext same as DescribeReservedDBInstancesOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesOfferingsInput, fn func(*DescribeReservedDBInstancesOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedDBInstancesOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedDBInstancesOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedDBInstancesOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSourceRegions = "DescribeSourceRegions"

// DescribeSourceRegionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceRegions for more information on using the DescribeSourceRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSourceRegionsRequest method.
//    req, resp := client.DescribeSourceRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions
func (c *RDS) DescribeSourceRegionsRequest(input *DescribeSourceRegionsInput) (req *request.Request, output *DescribeSourceRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSourceRegionsInput{}
	}

	output = &DescribeSourceRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceRegions API operation for Amazon Relational Database Service.
//
// Returns a list of the source AWS Regions where the current AWS Region can
// create a read replica or copy a DB snapshot from. This API action supports
// pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeSourceRegions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions
func (c *RDS) DescribeSourceRegions(input *DescribeSourceRegionsInput) (*DescribeSourceRegionsOutput, error) {
	req, out := c.DescribeSourceRegionsRequest(input)
	return out, req.Send()
}

// DescribeSourceRegionsWithContext is the same as DescribeSourceRegions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeSourceRegionsWithContext(ctx aws.Context, input *DescribeSourceRegionsInput, opts ...request.Option) (*DescribeSourceRegionsOutput, error) {
	req, out := c.DescribeSourceRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeValidDBInstanceModifications = "DescribeValidDBInstanceModifications"

// DescribeValidDBInstanceModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeValidDBInstanceModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeValidDBInstanceModifications for more information on using the DescribeValidDBInstanceModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeValidDBInstanceModificationsRequest method.
//    req, resp := client.DescribeValidDBInstanceModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications
func (c *RDS) DescribeValidDBInstanceModificationsRequest(input *DescribeValidDBInstanceModificationsInput) (req *request.Request, output *DescribeValidDBInstanceModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeValidDBInstanceModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeValidDBInstanceModificationsInput{}
	}

	output = &DescribeValidDBInstanceModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeValidDBInstanceModifications API operation for Amazon Relational Database Service.
//
// You can call DescribeValidDBInstanceModifications to learn what modifications
// you can make to your DB instance. You can use this information when you call
// ModifyDBInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeValidDBInstanceModifications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications
func (c *RDS) DescribeValidDBInstanceModifications(input *DescribeValidDBInstanceModificationsInput) (*DescribeValidDBInstanceModificationsOutput, error) {
	req, out := c.DescribeValidDBInstanceModificationsRequest(input)
	return out, req.Send()
}

// DescribeValidDBInstanceModificationsWithContext is the same as DescribeValidDBInstanceModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeValidDBInstanceModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeValidDBInstanceModificationsWithContext(ctx aws.Context, input *DescribeValidDBInstanceModificationsInput, opts ...request.Option) (*DescribeValidDBInstanceModificationsOutput, error) {
	req, out := c.DescribeValidDBInstanceModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDownloadDBLogFilePortion = "DownloadDBLogFilePortion"

// DownloadDBLogFilePortionRequest generates a "aws/request.Request" representing the
// client's request for the DownloadDBLogFilePortion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DownloadDBLogFilePortion for more information on using the DownloadDBLogFilePortion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DownloadDBLogFilePortionRequest method.
//    req, resp := client.DownloadDBLogFilePortionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion
func (c *RDS) DownloadDBLogFilePortionRequest(input *DownloadDBLogFilePortionInput) (req *request.Request, output *DownloadDBLogFilePortionOutput) {
	op := &request.Operation{
		Name:       opDownloadDBLogFilePortion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "NumberOfLines",
			TruncationToken: "AdditionalDataPending",
		},
	}

	if input == nil {
		input = &DownloadDBLogFilePortionInput{}
	}

	output = &DownloadDBLogFilePortionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DownloadDBLogFilePortion API operation for Amazon Relational Database Service.
//
// Downloads all or a portion of the specified log file, up to 1 MB in size.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DownloadDBLogFilePortion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBLogFileNotFoundFault "DBLogFileNotFoundFault"
//   LogFileName doesn't refer to an existing DB log file.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion
func (c *RDS) DownloadDBLogFilePortion(input *DownloadDBLogFilePortionInput) (*DownloadDBLogFilePortionOutput, error) {
	req, out := c.DownloadDBLogFilePortionRequest(input)
	return out, req.Send()
}

// DownloadDBLogFilePortionWithContext is the same as DownloadDBLogFilePortion with the addition of
// the ability to pass a context and additional request options.
//
// See DownloadDBLogFilePortion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DownloadDBLogFilePortionWithContext(ctx aws.Context, input *DownloadDBLogFilePortionInput, opts ...request.Option) (*DownloadDBLogFilePortionOutput, error) {
	req, out := c.DownloadDBLogFilePortionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DownloadDBLogFilePortionPages iterates over the pages of a DownloadDBLogFilePortion operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DownloadDBLogFilePortion method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DownloadDBLogFilePortion operation.
//    pageNum := 0
//    err := client.DownloadDBLogFilePortionPages(params,
//        func(page *rds.DownloadDBLogFilePortionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DownloadDBLogFilePortionPages(input *DownloadDBLogFilePortionInput, fn func(*DownloadDBLogFilePortionOutput, bool) bool) error {
	return c.DownloadDBLogFilePortionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DownloadDBLogFilePortionPagesWithContext same as DownloadDBLogFilePortionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DownloadDBLogFilePortionPagesWithContext(ctx aws.Context, input *DownloadDBLogFilePortionInput, fn func(*DownloadDBLogFilePortionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DownloadDBLogFilePortionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DownloadDBLogFilePortionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DownloadDBLogFilePortionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opFailoverDBCluster = "FailoverDBCluster"

// FailoverDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the FailoverDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverDBCluster for more information on using the FailoverDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailoverDBClusterRequest method.
//    req, resp := client.FailoverDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster
func (c *RDS) FailoverDBClusterRequest(input *FailoverDBClusterInput) (req *request.Request, output *FailoverDBClusterOutput) {
	op := &request.Operation{
		Name:       opFailoverDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverDBClusterInput{}
	}

	output = &FailoverDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverDBCluster API operation for Amazon Relational Database Service.
//
// Forces a failover for a DB cluster.
//
// A failover for a DB cluster promotes one of the Aurora Replicas (read-only
// instances) in the DB cluster to be the primary instance (the cluster writer).
//
// Amazon Aurora will automatically fail over to an Aurora Replica, if one exists,
// when the primary instance fails. You can force a failover when you want to
// simulate a failure of a primary instance for testing. Because each instance
// in a DB cluster has its own endpoint address, you will need to clean up and
// re-establish any existing connections that use those endpoint addresses when
// the failover is complete.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation FailoverDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster
func (c *RDS) FailoverDBCluster(input *FailoverDBClusterInput) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	return out, req.Send()
}

// FailoverDBClusterWithContext is the same as FailoverDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) FailoverDBClusterWithContext(ctx aws.Context, input *FailoverDBClusterInput, opts ...request.Option) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportInstallationMedia = "ImportInstallationMedia"

// ImportInstallationMediaRequest generates a "aws/request.Request" representing the
// client's request for the ImportInstallationMedia operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportInstallationMedia for more information on using the ImportInstallationMedia
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportInstallationMediaRequest method.
//    req, resp := client.ImportInstallationMediaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ImportInstallationMedia
func (c *RDS) ImportInstallationMediaRequest(input *ImportInstallationMediaInput) (req *request.Request, output *ImportInstallationMediaOutput) {
	op := &request.Operation{
		Name:       opImportInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportInstallationMediaInput{}
	}

	output = &ImportInstallationMediaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportInstallationMedia API operation for Amazon Relational Database Service.
//
// Imports the installation media for a DB engine that requires an on-premises
// customer provided license, such as SQL Server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ImportInstallationMedia for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCustomAvailabilityZoneNotFoundFault "CustomAvailabilityZoneNotFound"
//   CustomAvailabilityZoneId doesn't refer to an existing custom Availability
//   Zone identifier.
//
//   * ErrCodeInstallationMediaAlreadyExistsFault "InstallationMediaAlreadyExists"
//   The specified installation medium has already been imported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ImportInstallationMedia
func (c *RDS) ImportInstallationMedia(input *ImportInstallationMediaInput) (*ImportInstallationMediaOutput, error) {
	req, out := c.ImportInstallationMediaRequest(input)
	return out, req.Send()
}

// ImportInstallationMediaWithContext is the same as ImportInstallationMedia with the addition of
// the ability to pass a context and additional request options.
//
// See ImportInstallationMedia for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ImportInstallationMediaWithContext(ctx aws.Context, input *ImportInstallationMediaInput, opts ...request.Option) (*ImportInstallationMediaOutput, error) {
	req, out := c.ImportInstallationMediaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource
func (c *RDS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Relational Database Service.
//
// Lists all tags on an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource
func (c *RDS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCertificates = "ModifyCertificates"

// ModifyCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCertificates for more information on using the ModifyCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyCertificatesRequest method.
//    req, resp := client.ModifyCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates
func (c *RDS) ModifyCertificatesRequest(input *ModifyCertificatesInput) (req *request.Request, output *ModifyCertificatesOutput) {
	op := &request.Operation{
		Name:       opModifyCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCertificatesInput{}
	}

	output = &ModifyCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCertificates API operation for Amazon Relational Database Service.
//
// Override the system-default Secure Sockets Layer/Transport Layer Security
// (SSL/TLS) certificate for Amazon RDS for new DB instances temporarily, or
// remove the override.
//
// By using this operation, you can specify an RDS-approved SSL/TLS certificate
// for new DB instances that is different from the default certificate provided
// by RDS. You can also use this operation to remove the override, so that new
// DB instances use the default certificate provided by RDS.
//
// You might need to override the default certificate in the following situations:
//
//    * You already migrated your applications to support the latest certificate
//    authority (CA) certificate, but the new CA certificate is not yet the
//    RDS default CA certificate for the specified AWS Region.
//
//    * RDS has already moved to a new default CA certificate for the specified
//    AWS Region, but you are still in the process of supporting the new CA
//    certificate. In this case, you temporarily need additional time to finish
//    your application changes.
//
// For more information about rotating your SSL/TLS certificate for RDS DB engines,
// see Rotating Your SSL/TLS Certificate (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html)
// in the Amazon RDS User Guide.
//
// For more information about rotating your SSL/TLS certificate for Aurora DB
// engines, see Rotating Your SSL/TLS Certificate (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html)
// in the Amazon Aurora User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier doesn't refer to an existing certificate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates
func (c *RDS) ModifyCertificates(input *ModifyCertificatesInput) (*ModifyCertificatesOutput, error) {
	req, out := c.ModifyCertificatesRequest(input)
	return out, req.Send()
}

// ModifyCertificatesWithContext is the same as ModifyCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyCertificatesWithContext(ctx aws.Context, input *ModifyCertificatesInput, opts ...request.Option) (*ModifyCertificatesOutput, error) {
	req, out := c.ModifyCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCurrentDBClusterCapacity = "ModifyCurrentDBClusterCapacity"

// ModifyCurrentDBClusterCapacityRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCurrentDBClusterCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCurrentDBClusterCapacity for more information on using the ModifyCurrentDBClusterCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyCurrentDBClusterCapacityRequest method.
//    req, resp := client.ModifyCurrentDBClusterCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity
func (c *RDS) ModifyCurrentDBClusterCapacityRequest(input *ModifyCurrentDBClusterCapacityInput) (req *request.Request, output *ModifyCurrentDBClusterCapacityOutput) {
	op := &request.Operation{
		Name:       opModifyCurrentDBClusterCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCurrentDBClusterCapacityInput{}
	}

	output = &ModifyCurrentDBClusterCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCurrentDBClusterCapacity API operation for Amazon Relational Database Service.
//
// Set the capacity of an Aurora Serverless DB cluster to a specific value.
//
// Aurora Serverless scales seamlessly based on the workload on the DB cluster.
// In some cases, the capacity might not scale fast enough to meet a sudden
// change in workload, such as a large number of new transactions. Call ModifyCurrentDBClusterCapacity
// to set the capacity explicitly.
//
// After this call sets the DB cluster capacity, Aurora Serverless can automatically
// scale the DB cluster based on the cooldown period for scaling up and the
// cooldown period for scaling down.
//
// For more information about Aurora Serverless, see Using Amazon Aurora Serverless
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
// in the Amazon Aurora User Guide.
//
// If you call ModifyCurrentDBClusterCapacity with the default TimeoutAction,
// connections that prevent Aurora Serverless from finding a scaling point might
// be dropped. For more information about scaling points, see Autoscaling for
// Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyCurrentDBClusterCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBClusterCapacityFault "InvalidDBClusterCapacityFault"
//   Capacity isn't a valid Aurora Serverless DB cluster capacity. Valid capacity
//   values are 2, 4, 8, 16, 32, 64, 128, and 256.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity
func (c *RDS) ModifyCurrentDBClusterCapacity(input *ModifyCurrentDBClusterCapacityInput) (*ModifyCurrentDBClusterCapacityOutput, error) {
	req, out := c.ModifyCurrentDBClusterCapacityRequest(input)
	return out, req.Send()
}

// ModifyCurrentDBClusterCapacityWithContext is the same as ModifyCurrentDBClusterCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCurrentDBClusterCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyCurrentDBClusterCapacityWithContext(ctx aws.Context, input *ModifyCurrentDBClusterCapacityInput, opts ...request.Option) (*ModifyCurrentDBClusterCapacityOutput, error) {
	req, out := c.ModifyCurrentDBClusterCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBCluster = "ModifyDBCluster"

// ModifyDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBCluster for more information on using the ModifyDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterRequest method.
//    req, resp := client.ModifyDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster
func (c *RDS) ModifyDBClusterRequest(input *ModifyDBClusterInput) (req *request.Request, output *ModifyDBClusterOutput) {
	op := &request.Operation{
		Name:       opModifyDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterInput{}
	}

	output = &ModifyDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBCluster API operation for Amazon Relational Database Service.
//
// Modify a setting for an Amazon Aurora DB cluster. You can change one or more
// database configuration parameters by specifying these parameters and the
// new values in the request. For more information on Amazon Aurora, see What
// Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it's in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
//   group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group doesn't allow deletion.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   The user already has a DB cluster with the given identifier.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster
func (c *RDS) ModifyDBCluster(input *ModifyDBClusterInput) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	return out, req.Send()
}

// ModifyDBClusterWithContext is the same as ModifyDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterWithContext(ctx aws.Context, input *ModifyDBClusterInput, opts ...request.Option) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterEndpoint = "ModifyDBClusterEndpoint"

// ModifyDBClusterEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterEndpoint for more information on using the ModifyDBClusterEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterEndpointRequest method.
//    req, resp := client.ModifyDBClusterEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint
func (c *RDS) ModifyDBClusterEndpointRequest(input *ModifyDBClusterEndpointInput) (req *request.Request, output *ModifyDBClusterEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterEndpointInput{}
	}

	output = &ModifyDBClusterEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterEndpoint API operation for Amazon Relational Database Service.
//
// Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBClusterEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBClusterEndpointStateFault "InvalidDBClusterEndpointStateFault"
//   The requested operation can't be performed on the endpoint while the endpoint
//   is in this state.
//
//   * ErrCodeDBClusterEndpointNotFoundFault "DBClusterEndpointNotFoundFault"
//   The specified custom endpoint doesn't exist.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint
func (c *RDS) ModifyDBClusterEndpoint(input *ModifyDBClusterEndpointInput) (*ModifyDBClusterEndpointOutput, error) {
	req, out := c.ModifyDBClusterEndpointRequest(input)
	return out, req.Send()
}

// ModifyDBClusterEndpointWithContext is the same as ModifyDBClusterEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterEndpointWithContext(ctx aws.Context, input *ModifyDBClusterEndpointInput, opts ...request.Option) (*ModifyDBClusterEndpointOutput, error) {
	req, out := c.ModifyDBClusterEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterParameterGroup = "ModifyDBClusterParameterGroup"

// ModifyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterParameterGroup for more information on using the ModifyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterParameterGroupRequest method.
//    req, resp := client.ModifyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup
func (c *RDS) ModifyDBClusterParameterGroupRequest(input *ModifyDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterParameterGroupInput{}
	}

	output = &DBClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB cluster parameter group. To modify more than
// one parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB cluster associated
// with the parameter group before the change can take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the parameter group is used as the default for a
// new DB cluster. This is especially important for parameters that are critical
// when creating the default database for a DB cluster, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBClusterParameters action to verify that your DB cluster
// parameter group has been created or modified.
//
// If the modified DB cluster parameter group is used by an Aurora Serverless
// cluster, Aurora applies the update immediately. The cluster restart might
// interrupt your workload. In that case, your application must reopen any connections
// and retry any transactions that were active when the parameter changes took
// effect.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup
func (c *RDS) ModifyDBClusterParameterGroup(input *ModifyDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBClusterParameterGroupWithContext is the same as ModifyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterParameterGroupWithContext(ctx aws.Context, input *ModifyDBClusterParameterGroupInput, opts ...request.Option) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterSnapshotAttribute = "ModifyDBClusterSnapshotAttribute"

// ModifyDBClusterSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterSnapshotAttribute for more information on using the ModifyDBClusterSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBClusterSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *RDS) ModifyDBClusterSnapshotAttributeRequest(input *ModifyDBClusterSnapshotAttributeInput) (req *request.Request, output *ModifyDBClusterSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterSnapshotAttributeInput{}
	}

	output = &ModifyDBClusterSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterSnapshotAttribute API operation for Amazon Relational Database Service.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB cluster snapshot.
//
// To share a manual DB cluster snapshot with other AWS accounts, specify restore
// as the AttributeName and use the ValuesToAdd parameter to add a list of IDs
// of the AWS accounts that are authorized to restore the manual DB cluster
// snapshot. Use the value all to make the manual DB cluster snapshot public,
// which means that it can be copied or restored by all AWS accounts. Do not
// add the all value for any manual DB cluster snapshots that contain private
// information that you don't want available to all AWS accounts. If a manual
// DB cluster snapshot is encrypted, it can be shared, but only by specifying
// a list of authorized AWS account IDs for the ValuesToAdd parameter. You can't
// use all as a value for that parameter in this case.
//
// To view which AWS accounts have access to copy or restore a manual DB cluster
// snapshot, or whether a manual DB cluster snapshot public or private, use
// the DescribeDBClusterSnapshotAttributes API action.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBClusterSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *RDS) ModifyDBClusterSnapshotAttribute(input *ModifyDBClusterSnapshotAttributeInput) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBClusterSnapshotAttributeWithContext is the same as ModifyDBClusterSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBClusterSnapshotAttributeInput, opts ...request.Option) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBInstance = "ModifyDBInstance"

// ModifyDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBInstance for more information on using the ModifyDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBInstanceRequest method.
//    req, resp := client.ModifyDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance
func (c *RDS) ModifyDBInstanceRequest(input *ModifyDBInstanceInput) (req *request.Request, output *ModifyDBInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBInstanceInput{}
	}

	output = &ModifyDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBInstance API operation for Amazon Relational Database Service.
//
// Modifies settings for a DB instance. You can change one or more database
// configuration parameters by specifying these parameters and the new values
// in the request. To learn what modifications you can make to your DB instance,
// call DescribeValidDBInstanceModifications before you call ModifyDBInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group doesn't allow deletion.
//
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBUpgradeDependencyFailureFault "DBUpgradeDependencyFailure"
//   The DB upgrade failed because a resource the DB depends on can't be modified.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier doesn't refer to an existing certificate.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeBackupPolicyNotFoundFault "BackupPolicyNotFoundFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance
func (c *RDS) ModifyDBInstance(input *ModifyDBInstanceInput) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	return out, req.Send()
}

// ModifyDBInstanceWithContext is the same as ModifyDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBInstanceWithContext(ctx aws.Context, input *ModifyDBInstanceInput, opts ...request.Option) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBParameterGroup = "ModifyDBParameterGroup"

// ModifyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBParameterGroup for more information on using the ModifyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBParameterGroupRequest method.
//    req, resp := client.ModifyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup
func (c *RDS) ModifyDBParameterGroupRequest(input *ModifyDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBParameterGroupInput{}
	}

	output = &DBParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB parameter group. To modify more than one
// parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB instance associated
// with the parameter group before the change can take effect.
//
// After you modify a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the modify action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup
func (c *RDS) ModifyDBParameterGroup(input *ModifyDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBParameterGroupWithContext is the same as ModifyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBParameterGroupWithContext(ctx aws.Context, input *ModifyDBParameterGroupInput, opts ...request.Option) (*DBParameterGroupNameMessage, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBProxy = "ModifyDBProxy"

// ModifyDBProxyRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBProxy for more information on using the ModifyDBProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBProxyRequest method.
//    req, resp := client.ModifyDBProxyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy
func (c *RDS) ModifyDBProxyRequest(input *ModifyDBProxyInput) (req *request.Request, output *ModifyDBProxyOutput) {
	op := &request.Operation{
		Name:       opModifyDBProxy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBProxyInput{}
	}

	output = &ModifyDBProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBProxy API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Changes the settings for an existing DB proxy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBProxy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyAlreadyExistsFault "DBProxyTargetExistsFault"
//   The specified proxy name must be unique for all proxies owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy
func (c *RDS) ModifyDBProxy(input *ModifyDBProxyInput) (*ModifyDBProxyOutput, error) {
	req, out := c.ModifyDBProxyRequest(input)
	return out, req.Send()
}

// ModifyDBProxyWithContext is the same as ModifyDBProxy with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBProxyWithContext(ctx aws.Context, input *ModifyDBProxyInput, opts ...request.Option) (*ModifyDBProxyOutput, error) {
	req, out := c.ModifyDBProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBProxyTargetGroup = "ModifyDBProxyTargetGroup"

// ModifyDBProxyTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBProxyTargetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBProxyTargetGroup for more information on using the ModifyDBProxyTargetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBProxyTargetGroupRequest method.
//    req, resp := client.ModifyDBProxyTargetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup
func (c *RDS) ModifyDBProxyTargetGroupRequest(input *ModifyDBProxyTargetGroupInput) (req *request.Request, output *ModifyDBProxyTargetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBProxyTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBProxyTargetGroupInput{}
	}

	output = &ModifyDBProxyTargetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBProxyTargetGroup API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Modifies the properties of a DBProxyTargetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBProxyTargetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup
func (c *RDS) ModifyDBProxyTargetGroup(input *ModifyDBProxyTargetGroupInput) (*ModifyDBProxyTargetGroupOutput, error) {
	req, out := c.ModifyDBProxyTargetGroupRequest(input)
	return out, req.Send()
}

// ModifyDBProxyTargetGroupWithContext is the same as ModifyDBProxyTargetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBProxyTargetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBProxyTargetGroupWithContext(ctx aws.Context, input *ModifyDBProxyTargetGroupInput, opts ...request.Option) (*ModifyDBProxyTargetGroupOutput, error) {
	req, out := c.ModifyDBProxyTargetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSnapshot = "ModifyDBSnapshot"

// ModifyDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSnapshot for more information on using the ModifyDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSnapshotRequest method.
//    req, resp := client.ModifyDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot
func (c *RDS) ModifyDBSnapshotRequest(input *ModifyDBSnapshotInput) (req *request.Request, output *ModifyDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opModifyDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSnapshotInput{}
	}

	output = &ModifyDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSnapshot API operation for Amazon Relational Database Service.
//
// Updates a manual DB snapshot with a new engine version. The snapshot can
// be encrypted or unencrypted, but not shared or public.
//
// Amazon RDS supports upgrading DB snapshots for MySQL, Oracle, and PostgreSQL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot
func (c *RDS) ModifyDBSnapshot(input *ModifyDBSnapshotInput) (*ModifyDBSnapshotOutput, error) {
	req, out := c.ModifyDBSnapshotRequest(input)
	return out, req.Send()
}

// ModifyDBSnapshotWithContext is the same as ModifyDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSnapshotWithContext(ctx aws.Context, input *ModifyDBSnapshotInput, opts ...request.Option) (*ModifyDBSnapshotOutput, error) {
	req, out := c.ModifyDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSnapshotAttribute = "ModifyDBSnapshotAttribute"

// ModifyDBSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSnapshotAttribute for more information on using the ModifyDBSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute
func (c *RDS) ModifyDBSnapshotAttributeRequest(input *ModifyDBSnapshotAttributeInput) (req *request.Request, output *ModifyDBSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSnapshotAttributeInput{}
	}

	output = &ModifyDBSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSnapshotAttribute API operation for Amazon Relational Database Service.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB snapshot.
//
// To share a manual DB snapshot with other AWS accounts, specify restore as
// the AttributeName and use the ValuesToAdd parameter to add a list of IDs
// of the AWS accounts that are authorized to restore the manual DB snapshot.
// Uses the value all to make the manual DB snapshot public, which means it
// can be copied or restored by all AWS accounts. Do not add the all value for
// any manual DB snapshots that contain private information that you don't want
// available to all AWS accounts. If the manual DB snapshot is encrypted, it
// can be shared, but only by specifying a list of authorized AWS account IDs
// for the ValuesToAdd parameter. You can't use all as a value for that parameter
// in this case.
//
// To view which AWS accounts have access to copy or restore a manual DB snapshot,
// or whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute
func (c *RDS) ModifyDBSnapshotAttribute(input *ModifyDBSnapshotAttributeInput) (*ModifyDBSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBSnapshotAttributeWithContext is the same as ModifyDBSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBSnapshotAttributeInput, opts ...request.Option) (*ModifyDBSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSubnetGroup for more information on using the ModifyDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSubnetGroupRequest method.
//    req, resp := client.ModifyDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup
func (c *RDS) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) (req *request.Request, output *ModifyDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	output = &ModifyDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Modifies an existing DB subnet group. DB subnet groups must contain at least
// one subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   The request would result in the user exceeding the allowed number of subnets
//   in a DB subnet groups.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   The DB subnet is already in use in the Availability Zone.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup
func (c *RDS) ModifyDBSubnetGroup(input *ModifyDBSubnetGroupInput) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyDBSubnetGroupWithContext is the same as ModifyDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSubnetGroupWithContext(ctx aws.Context, input *ModifyDBSubnetGroupInput, opts ...request.Option) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription
func (c *RDS) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for Amazon Relational Database Service.
//
// Modifies an existing RDS event notification subscription. You can't modify
// the source identifiers using this call. To change source identifiers for
// a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription
// calls.
//
// You can see a list of the event categories for a given SourceType in the
// Events (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have reached the maximum number of event subscriptions.
//
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   SNS has responded that there is a problem with the SND topic specified.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the SNS topic ARN.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The SNS topic ARN does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The supplied category does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription
func (c *RDS) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyGlobalCluster = "ModifyGlobalCluster"

// ModifyGlobalClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyGlobalCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyGlobalCluster for more information on using the ModifyGlobalCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyGlobalClusterRequest method.
//    req, resp := client.ModifyGlobalClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyGlobalCluster
func (c *RDS) ModifyGlobalClusterRequest(input *ModifyGlobalClusterInput) (req *request.Request, output *ModifyGlobalClusterOutput) {
	op := &request.Operation{
		Name:       opModifyGlobalCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyGlobalClusterInput{}
	}

	output = &ModifyGlobalClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyGlobalCluster API operation for Amazon Relational Database Service.
//
// Modify a setting for an Amazon Aurora global cluster. You can change one
// or more database configuration parameters by specifying these parameters
// and the new values in the request. For more information on Amazon Aurora,
// see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyGlobalCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalClusterNotFoundFault "GlobalClusterNotFoundFault"
//
//   * ErrCodeInvalidGlobalClusterStateFault "InvalidGlobalClusterStateFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyGlobalCluster
func (c *RDS) ModifyGlobalCluster(input *ModifyGlobalClusterInput) (*ModifyGlobalClusterOutput, error) {
	req, out := c.ModifyGlobalClusterRequest(input)
	return out, req.Send()
}

// ModifyGlobalClusterWithContext is the same as ModifyGlobalCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyGlobalCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyGlobalClusterWithContext(ctx aws.Context, input *ModifyGlobalClusterInput, opts ...request.Option) (*ModifyGlobalClusterOutput, error) {
	req, out := c.ModifyGlobalClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyOptionGroup = "ModifyOptionGroup"

// ModifyOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyOptionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyOptionGroup for more information on using the ModifyOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyOptionGroupRequest method.
//    req, resp := client.ModifyOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup
func (c *RDS) ModifyOptionGroupRequest(input *ModifyOptionGroupInput) (req *request.Request, output *ModifyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opModifyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyOptionGroupInput{}
	}

	output = &ModifyOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyOptionGroup API operation for Amazon Relational Database Service.
//
// Modifies an existing option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidOptionGroupStateFault "InvalidOptionGroupStateFault"
//   The option group isn't in the available state.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup
func (c *RDS) ModifyOptionGroup(input *ModifyOptionGroupInput) (*ModifyOptionGroupOutput, error) {
	req, out := c.ModifyOptionGroupRequest(input)
	return out, req.Send()
}

// ModifyOptionGroupWithContext is the same as ModifyOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyOptionGroupWithContext(ctx aws.Context, input *ModifyOptionGroupInput, opts ...request.Option) (*ModifyOptionGroupOutput, error) {
	req, out := c.ModifyOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteReadReplica = "PromoteReadReplica"

// PromoteReadReplicaRequest generates a "aws/request.Request" representing the
// client's request for the PromoteReadReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteReadReplica for more information on using the PromoteReadReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteReadReplicaRequest method.
//    req, resp := client.PromoteReadReplicaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica
func (c *RDS) PromoteReadReplicaRequest(input *PromoteReadReplicaInput) (req *request.Request, output *PromoteReadReplicaOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaInput{}
	}

	output = &PromoteReadReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteReadReplica API operation for Amazon Relational Database Service.
//
// Promotes a read replica DB instance to a standalone DB instance.
//
//    * Backup duration is a function of the amount of changes to the database
//    since the previous backup. If you plan to promote a read replica to a
//    standalone instance, we recommend that you enable backups and complete
//    at least one backup prior to promotion. In addition, a read replica cannot
//    be promoted to a standalone instance when it is in the backing-up status.
//    If you have enabled backups on your read replica, configure the automated
//    backup window so that daily backups do not interfere with read replica
//    promotion.
//
//    * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PromoteReadReplica for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica
func (c *RDS) PromoteReadReplica(input *PromoteReadReplicaInput) (*PromoteReadReplicaOutput, error) {
	req, out := c.PromoteReadReplicaRequest(input)
	return out, req.Send()
}

// PromoteReadReplicaWithContext is the same as PromoteReadReplica with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteReadReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PromoteReadReplicaWithContext(ctx aws.Context, input *PromoteReadReplicaInput, opts ...request.Option) (*PromoteReadReplicaOutput, error) {
	req, out := c.PromoteReadReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteReadReplicaDBCluster = "PromoteReadReplicaDBCluster"

// PromoteReadReplicaDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the PromoteReadReplicaDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteReadReplicaDBCluster for more information on using the PromoteReadReplicaDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteReadReplicaDBClusterRequest method.
//    req, resp := client.PromoteReadReplicaDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster
func (c *RDS) PromoteReadReplicaDBClusterRequest(input *PromoteReadReplicaDBClusterInput) (req *request.Request, output *PromoteReadReplicaDBClusterOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplicaDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaDBClusterInput{}
	}

	output = &PromoteReadReplicaDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteReadReplicaDBCluster API operation for Amazon Relational Database Service.
//
// Promotes a read replica DB cluster to a standalone DB cluster.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PromoteReadReplicaDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster
func (c *RDS) PromoteReadReplicaDBCluster(input *PromoteReadReplicaDBClusterInput) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	return out, req.Send()
}

// PromoteReadReplicaDBClusterWithContext is the same as PromoteReadReplicaDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteReadReplicaDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PromoteReadReplicaDBClusterWithContext(ctx aws.Context, input *PromoteReadReplicaDBClusterInput, opts ...request.Option) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedDBInstancesOffering = "PurchaseReservedDBInstancesOffering"

// PurchaseReservedDBInstancesOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedDBInstancesOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedDBInstancesOffering for more information on using the PurchaseReservedDBInstancesOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedDBInstancesOfferingRequest method.
//    req, resp := client.PurchaseReservedDBInstancesOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering
func (c *RDS) PurchaseReservedDBInstancesOfferingRequest(input *PurchaseReservedDBInstancesOfferingInput) (req *request.Request, output *PurchaseReservedDBInstancesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedDBInstancesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedDBInstancesOfferingInput{}
	}

	output = &PurchaseReservedDBInstancesOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedDBInstancesOffering API operation for Amazon Relational Database Service.
//
// Purchases a reserved DB instance offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PurchaseReservedDBInstancesOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstancesOfferingNotFoundFault "ReservedDBInstancesOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeReservedDBInstanceAlreadyExistsFault "ReservedDBInstanceAlreadyExists"
//   User already has a reservation with the given identifier.
//
//   * ErrCodeReservedDBInstanceQuotaExceededFault "ReservedDBInstanceQuotaExceeded"
//   Request would exceed the user's DB Instance quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering
func (c *RDS) PurchaseReservedDBInstancesOffering(input *PurchaseReservedDBInstancesOfferingInput) (*PurchaseReservedDBInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedDBInstancesOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedDBInstancesOfferingWithContext is the same as PurchaseReservedDBInstancesOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedDBInstancesOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PurchaseReservedDBInstancesOfferingWithContext(ctx aws.Context, input *PurchaseReservedDBInstancesOfferingInput, opts ...request.Option) (*PurchaseReservedDBInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedDBInstancesOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootDBInstance = "RebootDBInstance"

// RebootDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootDBInstance for more information on using the RebootDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootDBInstanceRequest method.
//    req, resp := client.RebootDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance
func (c *RDS) RebootDBInstanceRequest(input *RebootDBInstanceInput) (req *request.Request, output *RebootDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootDBInstanceInput{}
	}

	output = &RebootDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootDBInstance API operation for Amazon Relational Database Service.
//
// You might need to reboot your DB instance, usually for maintenance reasons.
// For example, if you make certain modifications, or if you change the DB parameter
// group associated with the DB instance, you must reboot the instance for the
// changes to take effect.
//
// Rebooting a DB instance restarts the database engine service. Rebooting a
// DB instance results in a momentary outage, during which the DB instance status
// is set to rebooting.
//
// For more information about rebooting, see Rebooting a DB Instance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RebootDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance
func (c *RDS) RebootDBInstance(input *RebootDBInstanceInput) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	return out, req.Send()
}

// RebootDBInstanceWithContext is the same as RebootDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RebootDBInstanceWithContext(ctx aws.Context, input *RebootDBInstanceInput, opts ...request.Option) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDBProxyTargets = "RegisterDBProxyTargets"

// RegisterDBProxyTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDBProxyTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDBProxyTargets for more information on using the RegisterDBProxyTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterDBProxyTargetsRequest method.
//    req, resp := client.RegisterDBProxyTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RegisterDBProxyTargets
func (c *RDS) RegisterDBProxyTargetsRequest(input *RegisterDBProxyTargetsInput) (req *request.Request, output *RegisterDBProxyTargetsOutput) {
	op := &request.Operation{
		Name:       opRegisterDBProxyTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDBProxyTargetsInput{}
	}

	output = &RegisterDBProxyTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterDBProxyTargets API operation for Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RegisterDBProxyTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBProxyTargetAlreadyRegisteredFault "DBProxyTargetAlreadyRegisteredFault"
//   The proxy is already associated with the specified RDS DB instance or Aurora
//   DB cluster.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBProxyStateFault "InvalidDBProxyStateFault"
//   The requested operation can't be performed while the proxy is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RegisterDBProxyTargets
func (c *RDS) RegisterDBProxyTargets(input *RegisterDBProxyTargetsInput) (*RegisterDBProxyTargetsOutput, error) {
	req, out := c.RegisterDBProxyTargetsRequest(input)
	return out, req.Send()
}

// RegisterDBProxyTargetsWithContext is the same as RegisterDBProxyTargets with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDBProxyTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RegisterDBProxyTargetsWithContext(ctx aws.Context, input *RegisterDBProxyTargetsInput, opts ...request.Option) (*RegisterDBProxyTargetsOutput, error) {
	req, out := c.RegisterDBProxyTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFromGlobalCluster = "RemoveFromGlobalCluster"

// RemoveFromGlobalClusterRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFromGlobalCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFromGlobalCluster for more information on using the RemoveFromGlobalCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFromGlobalClusterRequest method.
//    req, resp := client.RemoveFromGlobalClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveFromGlobalCluster
func (c *RDS) RemoveFromGlobalClusterRequest(input *RemoveFromGlobalClusterInput) (req *request.Request, output *RemoveFromGlobalClusterOutput) {
	op := &request.Operation{
		Name:       opRemoveFromGlobalCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveFromGlobalClusterInput{}
	}

	output = &RemoveFromGlobalClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFromGlobalCluster API operation for Amazon Relational Database Service.
//
// Detaches an Aurora secondary cluster from an Aurora global database cluster.
// The cluster becomes a standalone cluster with read-write capability instead
// of being read-only and receiving data from a primary cluster in a different
// region.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveFromGlobalCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalClusterNotFoundFault "GlobalClusterNotFoundFault"
//
//   * ErrCodeInvalidGlobalClusterStateFault "InvalidGlobalClusterStateFault"
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveFromGlobalCluster
func (c *RDS) RemoveFromGlobalCluster(input *RemoveFromGlobalClusterInput) (*RemoveFromGlobalClusterOutput, error) {
	req, out := c.RemoveFromGlobalClusterRequest(input)
	return out, req.Send()
}

// RemoveFromGlobalClusterWithContext is the same as RemoveFromGlobalCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFromGlobalCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveFromGlobalClusterWithContext(ctx aws.Context, input *RemoveFromGlobalClusterInput, opts ...request.Option) (*RemoveFromGlobalClusterOutput, error) {
	req, out := c.RemoveFromGlobalClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRoleFromDBCluster = "RemoveRoleFromDBCluster"

// RemoveRoleFromDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRoleFromDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRoleFromDBCluster for more information on using the RemoveRoleFromDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRoleFromDBClusterRequest method.
//    req, resp := client.RemoveRoleFromDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster
func (c *RDS) RemoveRoleFromDBClusterRequest(input *RemoveRoleFromDBClusterInput) (req *request.Request, output *RemoveRoleFromDBClusterOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromDBClusterInput{}
	}

	output = &RemoveRoleFromDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRoleFromDBCluster API operation for Amazon Relational Database Service.
//
// Disassociates an AWS Identity and Access Management (IAM) role from an Amazon
// Aurora DB cluster. For more information, see Authorizing Amazon Aurora MySQL
// to Access Other AWS Services on Your Behalf (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveRoleFromDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleNotFoundFault "DBClusterRoleNotFound"
//   The specified IAM role Amazon Resource Name (ARN) isn't associated with the
//   specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster
func (c *RDS) RemoveRoleFromDBCluster(input *RemoveRoleFromDBClusterInput) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	return out, req.Send()
}

// RemoveRoleFromDBClusterWithContext is the same as RemoveRoleFromDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRoleFromDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveRoleFromDBClusterWithContext(ctx aws.Context, input *RemoveRoleFromDBClusterInput, opts ...request.Option) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRoleFromDBInstance = "RemoveRoleFromDBInstance"

// RemoveRoleFromDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRoleFromDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRoleFromDBInstance for more information on using the RemoveRoleFromDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRoleFromDBInstanceRequest method.
//    req, resp := client.RemoveRoleFromDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBInstance
func (c *RDS) RemoveRoleFromDBInstanceRequest(input *RemoveRoleFromDBInstanceInput) (req *request.Request, output *RemoveRoleFromDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromDBInstanceInput{}
	}

	output = &RemoveRoleFromDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRoleFromDBInstance API operation for Amazon Relational Database Service.
//
// Disassociates an AWS Identity and Access Management (IAM) role from a DB
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveRoleFromDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBInstanceRoleNotFoundFault "DBInstanceRoleNotFound"
//   The specified RoleArn value doesn't match the specified feature for the DB
//   instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBInstance
func (c *RDS) RemoveRoleFromDBInstance(input *RemoveRoleFromDBInstanceInput) (*RemoveRoleFromDBInstanceOutput, error) {
	req, out := c.RemoveRoleFromDBInstanceRequest(input)
	return out, req.Send()
}

// RemoveRoleFromDBInstanceWithContext is the same as RemoveRoleFromDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRoleFromDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveRoleFromDBInstanceWithContext(ctx aws.Context, input *RemoveRoleFromDBInstanceInput, opts ...request.Option) (*RemoveRoleFromDBInstanceOutput, error) {
	req, out := c.RemoveRoleFromDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveSourceIdentifierFromSubscription = "RemoveSourceIdentifierFromSubscription"

// RemoveSourceIdentifierFromSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveSourceIdentifierFromSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveSourceIdentifierFromSubscription for more information on using the RemoveSourceIdentifierFromSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveSourceIdentifierFromSubscriptionRequest method.
//    req, resp := client.RemoveSourceIdentifierFromSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *RDS) RemoveSourceIdentifierFromSubscriptionRequest(input *RemoveSourceIdentifierFromSubscriptionInput) (req *request.Request, output *RemoveSourceIdentifierFromSubscriptionOutput) {
	op := &request.Operation{
		Name:       opRemoveSourceIdentifierFromSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveSourceIdentifierFromSubscriptionInput{}
	}

	output = &RemoveSourceIdentifierFromSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveSourceIdentifierFromSubscription API operation for Amazon Relational Database Service.
//
// Removes a source identifier from an existing RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveSourceIdentifierFromSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *RDS) RemoveSourceIdentifierFromSubscription(input *RemoveSourceIdentifierFromSubscriptionInput) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	return out, req.Send()
}

// RemoveSourceIdentifierFromSubscriptionWithContext is the same as RemoveSourceIdentifierFromSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveSourceIdentifierFromSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveSourceIdentifierFromSubscriptionWithContext(ctx aws.Context, input *RemoveSourceIdentifierFromSubscriptionInput, opts ...request.Option) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource
func (c *RDS) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon Relational Database Service.
//
// Removes metadata tags from an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBProxyNotFoundFault "DBProxyNotFoundFault"
//   The specified proxy name doesn't correspond to a proxy owned by your AWS
//   accoutn in the specified AWS Region.
//
//   * ErrCodeDBProxyTargetGroupNotFoundFault "DBProxyTargetGroupNotFoundFault"
//   The specified target group isn't available for a proxy owned by your AWS
//   account in the specified AWS Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource
func (c *RDS) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBClusterParameterGroup = "ResetDBClusterParameterGroup"

// ResetDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBClusterParameterGroup for more information on using the ResetDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBClusterParameterGroupRequest method.
//    req, resp := client.ResetDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup
func (c *RDS) ResetDBClusterParameterGroupRequest(input *ResetDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBClusterParameterGroupInput{}
	}

	output = &DBClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB cluster parameter group to the default value.
// To reset specific parameters submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB cluster parameter group, specify
// the DBClusterParameterGroupName and ResetAllParameters parameters.
//
// When resetting the entire group, dynamic parameters are updated immediately
// and static parameters are set to pending-reboot to take effect on the next
// DB instance restart or RebootDBInstance request. You must call RebootDBInstance
// for every DB instance in your DB cluster that you want the updated static
// parameter to apply to.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ResetDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup
func (c *RDS) ResetDBClusterParameterGroup(input *ResetDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBClusterParameterGroupWithContext is the same as ResetDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ResetDBClusterParameterGroupWithContext(ctx aws.Context, input *ResetDBClusterParameterGroupInput, opts ...request.Option) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBParameterGroup = "ResetDBParameterGroup"

// ResetDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBParameterGroup for more information on using the ResetDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBParameterGroupRequest method.
//    req, resp := client.ResetDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup
func (c *RDS) ResetDBParameterGroupRequest(input *ResetDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBParameterGroupInput{}
	}

	output = &DBParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB parameter group to the engine/system default
// value. To reset specific parameters, provide a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB parameter group, specify the DBParameterGroup
// name and ResetAllParameters parameters. When resetting the entire group,
// dynamic parameters are updated immediately and static parameters are set
// to pending-reboot to take effect on the next DB instance restart or RebootDBInstance
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ResetDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you can't delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup
func (c *RDS) ResetDBParameterGroup(input *ResetDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBParameterGroupWithContext is the same as ResetDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ResetDBParameterGroupWithContext(ctx aws.Context, input *ResetDBParameterGroupInput, opts ...request.Option) (*DBParameterGroupNameMessage, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromS3 = "RestoreDBClusterFromS3"

// RestoreDBClusterFromS3Request generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromS3 for more information on using the RestoreDBClusterFromS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromS3Request method.
//    req, resp := client.RestoreDBClusterFromS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3
func (c *RDS) RestoreDBClusterFromS3Request(input *RestoreDBClusterFromS3Input) (req *request.Request, output *RestoreDBClusterFromS3Output) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromS3Input{}
	}

	output = &RestoreDBClusterFromS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromS3 API operation for Amazon Relational Database Service.
//
// Creates an Amazon Aurora DB cluster from data stored in an Amazon S3 bucket.
// Amazon RDS must be authorized to access the Amazon S3 bucket and the data
// must be created using the Percona XtraBackup utility as described in Migrating
// Data to an Amazon Aurora MySQL DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.html)
// in the Amazon Aurora User Guide.
//
// This action only restores the DB cluster, not the DB instances for that DB
// cluster. You must invoke the CreateDBInstance action to create DB instances
// for the restored DB cluster, specifying the identifier of the restored DB
// cluster in DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterFromS3 action has completed and the DB cluster is available.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterFromS3 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   The user already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The user attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it's in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidS3BucketFault "InvalidS3BucketFault"
//   The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized
//   to access the specified Amazon S3 bucket. Verify the SourceS3BucketName and
//   S3IngestionRoleArn values and try again.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You might
//   be able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3
func (c *RDS) RestoreDBClusterFromS3(input *RestoreDBClusterFromS3Input) (*RestoreDBClusterFromS3Output, error) {
	req, out := c.RestoreDBClusterFromS3Request(input)
	return out, req.Send()
}

// RestoreDBClusterFromS3WithContext is the same as RestoreDBClusterFromS3 with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterFromS3WithContext(ctx aws.Context, input *RestoreDBClusterFromS3Input, opts ...request.Option) (*RestoreDBClusterFromS3Output, error) {
	req, out := c.RestoreDBClusterFromS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromSnapshot = "RestoreDBClusterFromSnapshot"

// RestoreDBClusterFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromSnapshot for more information on using the RestoreDBClusterFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromSnapshotRequest method.
//    req, resp := client.RestoreDBClusterFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot
func (c *RDS) RestoreDBClusterFromSnapshotRequest(input *RestoreDBClusterFromSnapshotInput) (req *request.Request, output *RestoreDBClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromSnapshotInput{}
	}

	output = &RestoreDBClusterFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromSnapshot API operation for Amazon Relational Database Service.
//
// Creates a new DB cluster from a DB snapshot or DB cluster snapshot. This
// action only applies to Aurora DB clusters.
//
// The target DB cluster is created from the source snapshot with a default
// configuration. If you don't specify a security group, the new DB cluster
// is associated with the default security group.
//
// This action only restores the DB cluster, not the DB instances for that DB
// cluster. You must invoke the CreateDBInstance action to create DB instances
// for the restored DB cluster, specifying the identifier of the restored DB
// cluster in DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterFromSnapshot action has completed and the DB cluster is available.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   The user already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The user attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster doesn't have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You might
//   be able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from VPC backup to non-VPC DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot
func (c *RDS) RestoreDBClusterFromSnapshot(input *RestoreDBClusterFromSnapshotInput) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBClusterFromSnapshotWithContext is the same as RestoreDBClusterFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterFromSnapshotWithContext(ctx aws.Context, input *RestoreDBClusterFromSnapshotInput, opts ...request.Option) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterToPointInTime = "RestoreDBClusterToPointInTime"

// RestoreDBClusterToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterToPointInTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterToPointInTime for more information on using the RestoreDBClusterToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterToPointInTimeRequest method.
//    req, resp := client.RestoreDBClusterToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime
func (c *RDS) RestoreDBClusterToPointInTimeRequest(input *RestoreDBClusterToPointInTimeInput) (req *request.Request, output *RestoreDBClusterToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterToPointInTimeInput{}
	}

	output = &RestoreDBClusterToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterToPointInTime API operation for Amazon Relational Database Service.
//
// Restores a DB cluster to an arbitrary point in time. Users can restore to
// any point in time before LatestRestorableTime for up to BackupRetentionPeriod
// days. The target DB cluster is created from the source DB cluster with the
// same configuration as the original DB cluster, except that the new DB cluster
// is created with the default DB security group.
//
// This action only restores the DB cluster, not the DB instances for that DB
// cluster. You must invoke the CreateDBInstance action to create DB instances
// for the restored DB cluster, specifying the identifier of the restored DB
// cluster in DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterToPointInTime action has completed and the DB cluster is
// available.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   The user already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The user attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster doesn't have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You might
//   be able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value isn't a valid DB cluster snapshot state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from VPC backup to non-VPC DB instance.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime
func (c *RDS) RestoreDBClusterToPointInTime(input *RestoreDBClusterToPointInTimeInput) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBClusterToPointInTimeWithContext is the same as RestoreDBClusterToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterToPointInTimeWithContext(ctx aws.Context, input *RestoreDBClusterToPointInTimeInput, opts ...request.Option) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBInstanceFromDBSnapshot = "RestoreDBInstanceFromDBSnapshot"

// RestoreDBInstanceFromDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBInstanceFromDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBInstanceFromDBSnapshot for more information on using the RestoreDBInstanceFromDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBInstanceFromDBSnapshotRequest method.
//    req, resp := client.RestoreDBInstanceFromDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot
func (c *RDS) RestoreDBInstanceFromDBSnapshotRequest(input *RestoreDBInstanceFromDBSnapshotInput) (req *request.Request, output *RestoreDBInstanceFromDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceFromDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceFromDBSnapshotInput{}
	}

	output = &RestoreDBInstanceFromDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBInstanceFromDBSnapshot API operation for Amazon Relational Database Service.
//
// Creates a new DB instance from a DB snapshot. The target database is created
// from the source database restore point with the most of original configuration
// with the default security group and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored AZ deployment
// and not a single-AZ deployment.
//
// If your intent is to replace your original DB instance with the new, restored
// DB instance, then rename your original DB instance before you call the RestoreDBInstanceFromDBSnapshot
// action. RDS doesn't allow two DB instances with the same name. Once you have
// renamed your original DB instance with a different identifier, then you can
// pass the original name of the DB instance as the DBInstanceIdentifier in
// the call to the RestoreDBInstanceFromDBSnapshot action. The result is that
// you will replace the original DB instance with the DB instance created from
// the snapshot.
//
// If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
// must be the ARN of the shared DB snapshot.
//
// This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora,
// use RestoreDBClusterFromSnapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBInstanceFromDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB instances.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot doesn't allow deletion.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from VPC backup to non-VPC DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeBackupPolicyNotFoundFault "BackupPolicyNotFoundFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot
func (c *RDS) RestoreDBInstanceFromDBSnapshot(input *RestoreDBInstanceFromDBSnapshotInput) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	req, out := c.RestoreDBInstanceFromDBSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBInstanceFromDBSnapshotWithContext is the same as RestoreDBInstanceFromDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBInstanceFromDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBInstanceFromDBSnapshotWithContext(ctx aws.Context, input *RestoreDBInstanceFromDBSnapshotInput, opts ...request.Option) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	req, out := c.RestoreDBInstanceFromDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBInstanceFromS3 = "RestoreDBInstanceFromS3"

// RestoreDBInstanceFromS3Request generates a "aws/request.Request" representing the
// client's request for the RestoreDBInstanceFromS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBInstanceFromS3 for more information on using the RestoreDBInstanceFromS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBInstanceFromS3Request method.
//    req, resp := client.RestoreDBInstanceFromS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromS3
func (c *RDS) RestoreDBInstanceFromS3Request(input *RestoreDBInstanceFromS3Input) (req *request.Request, output *RestoreDBInstanceFromS3Output) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceFromS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceFromS3Input{}
	}

	output = &RestoreDBInstanceFromS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBInstanceFromS3 API operation for Amazon Relational Database Service.
//
// Amazon Relational Database Service (Amazon RDS) supports importing MySQL
// databases by using backup files. You can create a backup of your on-premises
// database, store it on Amazon Simple Storage Service (Amazon S3), and then
// restore the backup file onto a new Amazon RDS DB instance running MySQL.
// For more information, see Importing Data into an Amazon RDS MySQL DB Instance
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBInstanceFromS3 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidS3BucketFault "InvalidS3BucketFault"
//   The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized
//   to access the specified Amazon S3 bucket. Verify the SourceS3BucketName and
//   S3IngestionRoleArn values and try again.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeBackupPolicyNotFoundFault "BackupPolicyNotFoundFault"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromS3
func (c *RDS) RestoreDBInstanceFromS3(input *RestoreDBInstanceFromS3Input) (*RestoreDBInstanceFromS3Output, error) {
	req, out := c.RestoreDBInstanceFromS3Request(input)
	return out, req.Send()
}

// RestoreDBInstanceFromS3WithContext is the same as RestoreDBInstanceFromS3 with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBInstanceFromS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBInstanceFromS3WithContext(ctx aws.Context, input *RestoreDBInstanceFromS3Input, opts ...request.Option) (*RestoreDBInstanceFromS3Output, error) {
	req, out := c.RestoreDBInstanceFromS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBInstanceToPointInTime = "RestoreDBInstanceToPointInTime"

// RestoreDBInstanceToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBInstanceToPointInTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBInstanceToPointInTime for more information on using the RestoreDBInstanceToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBInstanceToPointInTimeRequest method.
//    req, resp := client.RestoreDBInstanceToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime
func (c *RDS) RestoreDBInstanceToPointInTimeRequest(input *RestoreDBInstanceToPointInTimeInput) (req *request.Request, output *RestoreDBInstanceToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceToPointInTimeInput{}
	}

	output = &RestoreDBInstanceToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBInstanceToPointInTime API operation for Amazon Relational Database Service.
//
// Restores a DB instance to an arbitrary point in time. You can restore to
// any point in time before the time identified by the LatestRestorableTime
// property. You can restore to a point up to the number of days specified by
// the BackupRetentionPeriod property.
//
// The target database is created with most of the original configuration, but
// in a system-selected Availability Zone, with the default security group,
// the default subnet group, and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored deployment
// and not a single-AZ deployment.
//
// This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora,
// use RestoreDBClusterToPointInTime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBInstanceToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   The user already has a DB instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB instances.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodePointInTimeRestoreNotEnabledFault "PointInTimeRestoreNotEnabled"
//   SourceDBInstanceIdentifier refers to a DB instance with BackupRetentionPeriod
//   equal to 0.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would result in the user exceeding the allowed amount of storage
//   available across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from VPC backup to non-VPC DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the StorageType specified can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain doesn't refer to an existing Active Directory domain.
//
//   * ErrCodeBackupPolicyNotFoundFault "BackupPolicyNotFoundFault"
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing DB parameter group.
//
//   * ErrCodeDBInstanceAutomatedBackupNotFoundFault "DBInstanceAutomatedBackupNotFound"
//   No automated backup for this DB instance was found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime
func (c *RDS) RestoreDBInstanceToPointInTime(input *RestoreDBInstanceToPointInTimeInput) (*RestoreDBInstanceToPointInTimeOutput, error) {
	req, out := c.RestoreDBInstanceToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBInstanceToPointInTimeWithContext is the same as RestoreDBInstanceToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBInstanceToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBInstanceToPointInTimeWithContext(ctx aws.Context, input *RestoreDBInstanceToPointInTimeInput, opts ...request.Option) (*RestoreDBInstanceToPointInTimeOutput, error) {
	req, out := c.RestoreDBInstanceToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeDBSecurityGroupIngress = "RevokeDBSecurityGroupIngress"

// RevokeDBSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeDBSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeDBSecurityGroupIngress for more information on using the RevokeDBSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeDBSecurityGroupIngressRequest method.
//    req, resp := client.RevokeDBSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress
func (c *RDS) RevokeDBSecurityGroupIngressRequest(input *RevokeDBSecurityGroupIngressInput) (req *request.Request, output *RevokeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeDBSecurityGroupIngressInput{}
	}

	output = &RevokeDBSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeDBSecurityGroupIngress API operation for Amazon Relational Database Service.
//
// Revokes ingress from a DBSecurityGroup for previously authorized IP ranges
// or EC2 or VPC Security Groups. Required parameters for this API are one of
// CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
// EC2SecurityGroupName or EC2SecurityGroupId).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RevokeDBSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing DB security group.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group doesn't allow deletion.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress
func (c *RDS) RevokeDBSecurityGroupIngress(input *RevokeDBSecurityGroupIngressInput) (*RevokeDBSecurityGroupIngressOutput, error) {
	req, out := c.RevokeDBSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// RevokeDBSecurityGroupIngressWithContext is the same as RevokeDBSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeDBSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RevokeDBSecurityGroupIngressWithContext(ctx aws.Context, input *RevokeDBSecurityGroupIngressInput, opts ...request.Option) (*RevokeDBSecurityGroupIngressOutput, error) {
	req, out := c.RevokeDBSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartActivityStream = "StartActivityStream"

// StartActivityStreamRequest generates a "aws/request.Request" representing the
// client's request for the StartActivityStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartActivityStream for more information on using the StartActivityStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartActivityStreamRequest method.
//    req, resp := client.StartActivityStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartActivityStream
func (c *RDS) StartActivityStreamRequest(input *StartActivityStreamInput) (req *request.Request, output *StartActivityStreamOutput) {
	op := &request.Operation{
		Name:       opStartActivityStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartActivityStreamInput{}
	}

	output = &StartActivityStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartActivityStream API operation for Amazon Relational Database Service.
//
// Starts a database activity stream to monitor activity on the database. For
// more information, see Database Activity Streams (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html)
// in the Amazon Aurora User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StartActivityStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartActivityStream
func (c *RDS) StartActivityStream(input *StartActivityStreamInput) (*StartActivityStreamOutput, error) {
	req, out := c.StartActivityStreamRequest(input)
	return out, req.Send()
}

// StartActivityStreamWithContext is the same as StartActivityStream with the addition of
// the ability to pass a context and additional request options.
//
// See StartActivityStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StartActivityStreamWithContext(ctx aws.Context, input *StartActivityStreamInput, opts ...request.Option) (*StartActivityStreamOutput, error) {
	req, out := c.StartActivityStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDBCluster = "StartDBCluster"

// StartDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the StartDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDBCluster for more information on using the StartDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDBClusterRequest method.
//    req, resp := client.StartDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBCluster
func (c *RDS) StartDBClusterRequest(input *StartDBClusterInput) (req *request.Request, output *StartDBClusterOutput) {
	op := &request.Operation{
		Name:       opStartDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDBClusterInput{}
	}

	output = &StartDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDBCluster API operation for Amazon Relational Database Service.
//
// Starts an Amazon Aurora DB cluster that was stopped using the AWS console,
// the stop-db-cluster AWS CLI command, or the StopDBCluster action.
//
// For more information, see Stopping and Starting an Aurora Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StartDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBCluster
func (c *RDS) StartDBCluster(input *StartDBClusterInput) (*StartDBClusterOutput, error) {
	req, out := c.StartDBClusterRequest(input)
	return out, req.Send()
}

// StartDBClusterWithContext is the same as StartDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See StartDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StartDBClusterWithContext(ctx aws.Context, input *StartDBClusterInput, opts ...request.Option) (*StartDBClusterOutput, error) {
	req, out := c.StartDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDBInstance = "StartDBInstance"

// StartDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDBInstance for more information on using the StartDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDBInstanceRequest method.
//    req, resp := client.StartDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance
func (c *RDS) StartDBInstanceRequest(input *StartDBInstanceInput) (req *request.Request, output *StartDBInstanceOutput) {
	op := &request.Operation{
		Name:       opStartDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDBInstanceInput{}
	}

	output = &StartDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDBInstance API operation for Amazon Relational Database Service.
//
// Starts an Amazon RDS DB instance that was stopped using the AWS console,
// the stop-db-instance AWS CLI command, or the StopDBInstance action.
//
// For more information, see Starting an Amazon RDS DB instance That Was Previously
// Stopped (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html)
// in the Amazon RDS User Guide.
//
// This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora
// DB clusters, use StartDBCluster instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StartDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified DB instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The DB subnet group doesn't cover all Availability Zones after it's created
//   because of users' change.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or Amazon EC2 security group might not be authorized
//   for the specified DB security group.
//
//   Or, RDS might not be authorized to perform necessary actions using IAM on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance
func (c *RDS) StartDBInstance(input *StartDBInstanceInput) (*StartDBInstanceOutput, error) {
	req, out := c.StartDBInstanceRequest(input)
	return out, req.Send()
}

// StartDBInstanceWithContext is the same as StartDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StartDBInstanceWithContext(ctx aws.Context, input *StartDBInstanceInput, opts ...request.Option) (*StartDBInstanceOutput, error) {
	req, out := c.StartDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExportTask = "StartExportTask"

// StartExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExportTask for more information on using the StartExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExportTaskRequest method.
//    req, resp := client.StartExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartExportTask
func (c *RDS) StartExportTaskRequest(input *StartExportTaskInput) (req *request.Request, output *StartExportTaskOutput) {
	op := &request.Operation{
		Name:       opStartExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExportTaskInput{}
	}

	output = &StartExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExportTask API operation for Amazon Relational Database Service.
//
// Starts an export of a snapshot to Amazon S3. The provided IAM role must have
// access to the S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StartExportTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
//
//   * ErrCodeExportTaskAlreadyExistsFault "ExportTaskAlreadyExists"
//   You can't start an export task that's already running.
//
//   * ErrCodeInvalidS3BucketFault "InvalidS3BucketFault"
//   The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized
//   to access the specified Amazon S3 bucket. Verify the SourceS3BucketName and
//   S3IngestionRoleArn values and try again.
//
//   * ErrCodeIamRoleNotFoundFault "IamRoleNotFound"
//   The IAM role is missing for exporting to an Amazon S3 bucket.
//
//   * ErrCodeIamRoleMissingPermissionsFault "IamRoleMissingPermissions"
//   The IAM role requires additional permissions to export to an Amazon S3 bucket.
//
//   * ErrCodeInvalidExportOnlyFault "InvalidExportOnly"
//   The export is invalid for exporting to an Amazon S3 bucket.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred accessing an AWS KMS key.
//
//   * ErrCodeInvalidExportSourceStateFault "InvalidExportSourceState"
//   The state of the export snapshot is invalid for exporting to an Amazon S3
//   bucket.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartExportTask
func (c *RDS) StartExportTask(input *StartExportTaskInput) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	return out, req.Send()
}

// StartExportTaskWithContext is the same as StartExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StartExportTaskWithContext(ctx aws.Context, input *StartExportTaskInput, opts ...request.Option) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopActivityStream = "StopActivityStream"

// StopActivityStreamRequest generates a "aws/request.Request" representing the
// client's request for the StopActivityStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopActivityStream for more information on using the StopActivityStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopActivityStreamRequest method.
//    req, resp := client.StopActivityStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopActivityStream
func (c *RDS) StopActivityStreamRequest(input *StopActivityStreamInput) (req *request.Request, output *StopActivityStreamOutput) {
	op := &request.Operation{
		Name:       opStopActivityStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopActivityStreamInput{}
	}

	output = &StopActivityStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopActivityStream API operation for Amazon Relational Database Service.
//
// Stops a database activity stream that was started using the AWS console,
// the start-activity-stream AWS CLI command, or the StartActivityStream action.
//
// For more information, see Database Activity Streams (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html)
// in the Amazon Aurora User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StopActivityStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopActivityStream
func (c *RDS) StopActivityStream(input *StopActivityStreamInput) (*StopActivityStreamOutput, error) {
	req, out := c.StopActivityStreamRequest(input)
	return out, req.Send()
}

// StopActivityStreamWithContext is the same as StopActivityStream with the addition of
// the ability to pass a context and additional request options.
//
// See StopActivityStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StopActivityStreamWithContext(ctx aws.Context, input *StopActivityStreamInput, opts ...request.Option) (*StopActivityStreamOutput, error) {
	req, out := c.StopActivityStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDBCluster = "StopDBCluster"

// StopDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the StopDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDBCluster for more information on using the StopDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDBClusterRequest method.
//    req, resp := client.StopDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBCluster
func (c *RDS) StopDBClusterRequest(input *StopDBClusterInput) (req *request.Request, output *StopDBClusterOutput) {
	op := &request.Operation{
		Name:       opStopDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDBClusterInput{}
	}

	output = &StopDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDBCluster API operation for Amazon Relational Database Service.
//
// Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains
// the DB cluster's metadata, including its endpoints and DB parameter groups.
// Aurora also retains the transaction logs so you can do a point-in-time restore
// if necessary.
//
// For more information, see Stopping and Starting an Aurora Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StopDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBCluster
func (c *RDS) StopDBCluster(input *StopDBClusterInput) (*StopDBClusterOutput, error) {
	req, out := c.StopDBClusterRequest(input)
	return out, req.Send()
}

// StopDBClusterWithContext is the same as StopDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See StopDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StopDBClusterWithContext(ctx aws.Context, input *StopDBClusterInput, opts ...request.Option) (*StopDBClusterOutput, error) {
	req, out := c.StopDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDBInstance = "StopDBInstance"

// StopDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDBInstance for more information on using the StopDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDBInstanceRequest method.
//    req, resp := client.StopDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance
func (c *RDS) StopDBInstanceRequest(input *StopDBInstanceInput) (req *request.Request, output *StopDBInstanceOutput) {
	op := &request.Operation{
		Name:       opStopDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDBInstanceInput{}
	}

	output = &StopDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDBInstance API operation for Amazon Relational Database Service.
//
// Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS
// retains the DB instance's metadata, including its endpoint, DB parameter
// group, and option group membership. Amazon RDS also retains the transaction
// logs so you can do a point-in-time restore if necessary.
//
// For more information, see Stopping an Amazon RDS DB Instance Temporarily
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html)
// in the Amazon RDS User Guide.
//
// This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora
// clusters, use StopDBCluster instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StopDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The DB instance isn't in a valid state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The requested operation can't be performed while the cluster is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance
func (c *RDS) StopDBInstance(input *StopDBInstanceInput) (*StopDBInstanceOutput, error) {
	req, out := c.StopDBInstanceRequest(input)
	return out, req.Send()
}

// StopDBInstanceWithContext is the same as StopDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StopDBInstanceWithContext(ctx aws.Context, input *StopDBInstanceInput, opts ...request.Option) (*StopDBInstanceOutput, error) {
	req, out := c.StopDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a quota for an AWS account.
//
// The following are account quotas:
//
//    * AllocatedStorage - The total allocated storage per account, in GiB.
//    The used value is the total allocated storage in the account, in GiB.
//
//    * AuthorizationsPerDBSecurityGroup - The number of ingress rules per DB
//    security group. The used value is the highest number of ingress rules
//    in a DB security group in the account. Other DB security groups in the
//    account might have a lower number of ingress rules.
//
//    * CustomEndpointsPerDBCluster - The number of custom endpoints per DB
//    cluster. The used value is the highest number of custom endpoints in a
//    DB clusters in the account. Other DB clusters in the account might have
//    a lower number of custom endpoints.
//
//    * DBClusterParameterGroups - The number of DB cluster parameter groups
//    per account, excluding default parameter groups. The used value is the
//    count of nondefault DB cluster parameter groups in the account.
//
//    * DBClusterRoles - The number of associated AWS Identity and Access Management
//    (IAM) roles per DB cluster. The used value is the highest number of associated
//    IAM roles for a DB cluster in the account. Other DB clusters in the account
//    might have a lower number of associated IAM roles.
//
//    * DBClusters - The number of DB clusters per account. The used value is
//    the count of DB clusters in the account.
//
//    * DBInstanceRoles - The number of associated IAM roles per DB instance.
//    The used value is the highest number of associated IAM roles for a DB
//    instance in the account. Other DB instances in the account might have
//    a lower number of associated IAM roles.
//
//    * DBInstances - The number of DB instances per account. The used value
//    is the count of the DB instances in the account. Amazon RDS DB instances,
//    Amazon Aurora DB instances, Amazon Neptune instances, and Amazon DocumentDB
//    instances apply to this quota.
//
//    * DBParameterGroups - The number of DB parameter groups per account, excluding
//    default parameter groups. The used value is the count of nondefault DB
//    parameter groups in the account.
//
//    * DBSecurityGroups - The number of DB security groups (not VPC security
//    groups) per account, excluding the default security group. The used value
//    is the count of nondefault DB security groups in the account.
//
//    * DBSubnetGroups - The number of DB subnet groups per account. The used
//    value is the count of the DB subnet groups in the account.
//
//    * EventSubscriptions - The number of event subscriptions per account.
//    The used value is the count of the event subscriptions in the account.
//
//    * ManualSnapshots - The number of manual DB snapshots per account. The
//    used value is the count of the manual DB snapshots in the account.
//
//    * OptionGroups - The number of DB option groups per account, excluding
//    default option groups. The used value is the count of nondefault DB option
//    groups in the account.
//
//    * ReadReplicasPerMaster - The number of read replicas per DB instance.
//    The used value is the highest number of read replicas for a DB instance
//    in the account. Other DB instances in the account might have a lower number
//    of read replicas.
//
//    * ReservedDBInstances - The number of reserved DB instances per account.
//    The used value is the count of the active reserved DB instances in the
//    account.
//
//    * SubnetsPerDBSubnetGroup - The number of subnets per DB subnet group.
//    The used value is highest number of subnets for a DB subnet group in the
//    account. Other DB subnet groups in the account might have a lower number
//    of subnets.
//
// For more information, see Quotas for Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html)
// in the Amazon RDS User Guide and Quotas for Amazon Aurora (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html)
// in the Amazon Aurora User Guide.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon RDS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

// SetAccountQuotaName sets the AccountQuotaName field's value.
func (s *AccountQuota) SetAccountQuotaName(v string) *AccountQuota {
	s.AccountQuotaName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *AccountQuota) SetMax(v int64) *AccountQuota {
	s.Max = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountQuota) SetUsed(v int64) *AccountQuota {
	s.Used = &v
	return s
}

type AddRoleToDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to associate the IAM role with.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the feature for the DB cluster that the IAM role is to be associated
	// with. For the list of supported feature names, see DBEngineVersion.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora
	// DB cluster, for example arn:aws:iam::123456789012:role/AuroraAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRoleToDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AddRoleToDBClusterInput) SetDBClusterIdentifier(v string) *AddRoleToDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFeatureName sets the FeatureName field's value.
func (s *AddRoleToDBClusterInput) SetFeatureName(v string) *AddRoleToDBClusterInput {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AddRoleToDBClusterInput) SetRoleArn(v string) *AddRoleToDBClusterInput {
	s.RoleArn = &v
	return s
}

type AddRoleToDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterOutput) GoString() string {
	return s.String()
}

type AddRoleToDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB instance to associate the IAM role with.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the feature for the DB instance that the IAM role is to be associated
	// with. For the list of supported feature names, see DBEngineVersion.
	//
	// FeatureName is a required field
	FeatureName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance,
	// for example arn:aws:iam::123456789012:role/AccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRoleToDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.FeatureName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *AddRoleToDBInstanceInput) SetDBInstanceIdentifier(v string) *AddRoleToDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFeatureName sets the FeatureName field's value.
func (s *AddRoleToDBInstanceInput) SetFeatureName(v string) *AddRoleToDBInstanceInput {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AddRoleToDBInstanceInput) SetRoleArn(v string) *AddRoleToDBInstanceInput {
	s.RoleArn = &v
	return s
}

type AddRoleToDBInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBInstanceOutput) GoString() string {
	return s.String()
}

type AddSourceIdentifierToSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source to be added.
	//
	// Constraints:
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the RDS event notification subscription you want to add a source
	// identifier to.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddSourceIdentifierToSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddSourceIdentifierToSubscriptionInput"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSourceIdentifier(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SourceIdentifier = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSubscriptionName(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type AddSourceIdentifierToSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *AddSourceIdentifierToSubscriptionOutput) SetEventSubscription(v *EventSubscription) *AddSourceIdentifierToSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS resource that the tags are added to. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see Constructing
	// an RDS Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon RDS resource.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *AddTagsToResourceInput) SetResourceName(v string) *AddTagsToResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// Valid values: system-update, db-upgrade, hardware-maintenance, ca-certificate-rotation
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// An opt-in request of type immediate can't be undone.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to. For information about creating an ARN, see Constructing
	// an RDS Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ApplyPendingMaintenanceActionInput) SetResourceIdentifier(v string) *ApplyPendingMaintenanceActionInput {
	s.ResourceIdentifier = &v
	return s
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// Describes the pending maintenance actions for a resource.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

type AuthorizeDBSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to authorize.
	CIDRIP *string `type:"string"`

	// The name of the DB security group to add authorization to.
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`

	// Id of the EC2 security group to authorize. For VPC DB security groups, EC2SecurityGroupId
	// must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName
	// or EC2SecurityGroupId must be provided.
	EC2SecurityGroupId *string `type:"string"`

	// Name of the EC2 security group to authorize. For VPC DB security groups,
	// EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and
	// either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	EC2SecurityGroupName *string `type:"string"`

	// AWS account number of the owner of the EC2 security group specified in the
	// EC2SecurityGroupName parameter. The AWS access key ID isn't an acceptable
	// value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise,
	// EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId
	// must be provided.
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeDBSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeDBSecurityGroupIngressInput"}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetCIDRIP(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetDBSecurityGroupName(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.DBSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupId sets the EC2SecurityGroupId field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupId(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupId = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

type AuthorizeDBSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB security group.
	//
	// This data type is used as a response element in the DescribeDBSecurityGroups
	// action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetDBSecurityGroup sets the DBSecurityGroup field's value.
func (s *AuthorizeDBSecurityGroupIngressOutput) SetDBSecurityGroup(v *DBSecurityGroup) *AuthorizeDBSecurityGroupIngressOutput {
	s.DBSecurityGroup = v
	return s
}

// Contains Availability Zone information.
//
// This data type is used as an element in the OrderableDBInstanceOption data
// type.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// Contains the available processor feature information for the DB instance
// class of a DB instance.
//
// For more information, see Configuring the Processor of the DB Instance Class
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor)
// in the Amazon RDS User Guide.
type AvailableProcessorFeature struct {
	_ struct{} `type:"structure"`

	// The allowed values for the processor feature of the DB instance class.
	AllowedValues *string `type:"string"`

	// The default value for the processor feature of the DB instance class.
	DefaultValue *string `type:"string"`

	// The name of the processor feature. Valid names are coreCount and threadsPerCore.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailableProcessorFeature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailableProcessorFeature) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *AvailableProcessorFeature) SetAllowedValues(v string) *AvailableProcessorFeature {
	s.AllowedValues = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *AvailableProcessorFeature) SetDefaultValue(v string) *AvailableProcessorFeature {
	s.DefaultValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *AvailableProcessorFeature) SetName(v string) *AvailableProcessorFeature {
	s.Name = &v
	return s
}

type BacktrackDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The timestamp of the time to backtrack the DB cluster to, specified in ISO
	// 8601 format. For more information about ISO 8601, see the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// If the specified time isn't a consistent time for the DB cluster, Aurora
	// automatically chooses the nearest possible consistent time for the DB cluster.
	//
	// Constraints:
	//
	//    * Must contain a valid ISO 8601 timestamp.
	//
	//    * Can't contain a timestamp set in the future.
	//
	// Example: 2017-07-08T18:00Z
	//
	// BacktrackTo is a required field
	BacktrackTo *time.Time `type:"timestamp" required:"true"`

	// The DB cluster identifier of the DB cluster to be backtracked. This parameter
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// A value that indicates whether to force the DB cluster to backtrack when
	// binary logging is enabled. Otherwise, an error occurs when binary logging
	// is enabled.
	Force *bool `type:"boolean"`

	// A value that indicates whether to backtrack the DB cluster to the earliest
	// possible backtrack time when BacktrackTo is set to a timestamp earlier than
	// the earliest backtrack time. When this parameter is disabled and BacktrackTo
	// is set to a timestamp earlier than the earliest backtrack time, an error
	// occurs.
	UseEarliestTimeOnPointInTimeUnavailable *bool `type:"boolean"`
}

// String returns the string representation
func (s BacktrackDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BacktrackDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BacktrackDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BacktrackDBClusterInput"}
	if s.BacktrackTo == nil {
		invalidParams.Add(request.NewErrParamRequired("BacktrackTo"))
	}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBacktrackTo sets the BacktrackTo field's value.
func (s *BacktrackDBClusterInput) SetBacktrackTo(v time.Time) *BacktrackDBClusterInput {
	s.BacktrackTo = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *BacktrackDBClusterInput) SetDBClusterIdentifier(v string) *BacktrackDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetForce sets the Force field's value.
func (s *BacktrackDBClusterInput) SetForce(v bool) *BacktrackDBClusterInput {
	s.Force = &v
	return s
}

// SetUseEarliestTimeOnPointInTimeUnavailable sets the UseEarliestTimeOnPointInTimeUnavailable field's value.
func (s *BacktrackDBClusterInput) SetUseEarliestTimeOnPointInTimeUnavailable(v bool) *BacktrackDBClusterInput {
	s.UseEarliestTimeOnPointInTimeUnavailable = &v
	return s
}

// This data type is used as a response element in the DescribeDBClusterBacktracks
// action.
type BacktrackDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the backtrack identifier.
	BacktrackIdentifier *string `type:"string"`

	// The timestamp of the time at which the backtrack was requested.
	BacktrackRequestCreationTime *time.Time `type:"timestamp"`

	// The timestamp of the time to which the DB cluster was backtracked.
	BacktrackTo *time.Time `type:"timestamp"`

	// The timestamp of the time from which the DB cluster was backtracked.
	BacktrackedFrom *time.Time `type:"timestamp"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// The status of the backtrack. This property returns one of the following values:
	//
	//    * applying - The backtrack is currently being applied to or rolled back
	//    from the DB cluster.
	//
	//    * completed - The backtrack has successfully been applied to or rolled
	//    back from the DB cluster.
	//
	//    * failed - An error occurred while the backtrack was applied to or rolled
	//    back from the DB cluster.
	//
	//    * pending - The backtrack is currently pending application to or rollback
	//    from the DB cluster.
	Status *string `type:"string"`
}

// String returns the string representation
func (s BacktrackDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BacktrackDBClusterOutput) GoString() string {
	return s.String()
}

// SetBacktrackIdentifier sets the BacktrackIdentifier field's value.
func (s *BacktrackDBClusterOutput) SetBacktrackIdentifier(v string) *BacktrackDBClusterOutput {
	s.BacktrackIdentifier = &v
	return s
}

// SetBacktrackRequestCreationTime sets the BacktrackRequestCreationTime field's value.
func (s *BacktrackDBClusterOutput) SetBacktrackRequestCreationTime(v time.Time) *BacktrackDBClusterOutput {
	s.BacktrackRequestCreationTime = &v
	return s
}

// SetBacktrackTo sets the BacktrackTo field's value.
func (s *BacktrackDBClusterOutput) SetBacktrackTo(v time.Time) *BacktrackDBClusterOutput {
	s.BacktrackTo = &v
	return s
}

// SetBacktrackedFrom sets the BacktrackedFrom field's value.
func (s *BacktrackDBClusterOutput) SetBacktrackedFrom(v time.Time) *BacktrackDBClusterOutput {
	s.BacktrackedFrom = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *BacktrackDBClusterOutput) SetDBClusterIdentifier(v string) *BacktrackDBClusterOutput {
	s.DBClusterIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BacktrackDBClusterOutput) SetStatus(v string) *BacktrackDBClusterOutput {
	s.Status = &v
	return s
}

type CancelExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot export task to cancel.
	//
	// ExportTaskIdentifier is a required field
	ExportTaskIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelExportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelExportTaskInput"}
	if s.ExportTaskIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportTaskIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportTaskIdentifier sets the ExportTaskIdentifier field's value.
func (s *CancelExportTaskInput) SetExportTaskIdentifier(v string) *CancelExportTaskInput {
	s.ExportTaskIdentifier = &v
	return s
}

// Contains the details of a snapshot export to Amazon S3.
//
// This data type is used as a response element in the DescribeExportTasks action.
type CancelExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The data exported from the snapshot. Valid values are the following:
	//
	//    * database - Export all the data from a specified database.
	//
	//    * database.table table-name - Export a table of the snapshot. This format
	//    is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
	//
	//    * database.schema schema-name - Export a database schema of the snapshot.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	//
	//    * database.schema.table table-name - Export a table of the database schema.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	ExportOnly []*string `type:"list"`

	// A unique identifier for the snapshot export task. This ID isn't an identifier
	// for the Amazon S3 bucket where the snapshot is exported to.
	ExportTaskIdentifier *string `type:"string"`

	// The reason the export failed, if it failed.
	FailureCause *string `type:"string"`

	// The name of the IAM role that is used to write to Amazon S3 when exporting
	// a snapshot.
	IamRoleArn *string `type:"string"`

	// The ID of the AWS KMS key that is used to encrypt the snapshot when it's
	// exported to Amazon S3. The KMS key ID is the Amazon Resource Name (ARN),
	// the KMS key identifier, or the KMS key alias for the KMS encryption key.
	// The IAM role used for the snapshot export must have encryption and decryption
	// permissions to use this KMS key.
	KmsKeyId *string `type:"string"`

	// The progress of the snapshot export task as a percentage.
	PercentProgress *int64 `type:"integer"`

	// The Amazon S3 bucket that the snapshot is exported to.
	S3Bucket *string `type:"string"`

	// The Amazon S3 bucket prefix that is the file name and path of the exported
	// snapshot.
	S3Prefix *string `type:"string"`

	// The time that the snapshot was created.
	SnapshotTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
	SourceArn *string `type:"string"`

	// The progress status of the export task.
	Status *string `type:"string"`

	// The time that the snapshot export task completed.
	TaskEndTime *time.Time `type:"timestamp"`

	// The time that the snapshot export task started.
	TaskStartTime *time.Time `type:"timestamp"`

	// The total amount of data exported, in gigabytes.
	TotalExtractedDataInGB *int64 `type:"integer"`

	// A warning about the snapshot export task.
	WarningMessage *string `type:"string"`
}

// String returns the string representation
func (s CancelExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskOutput) GoString() string {
	return s.String()
}

// SetExportOnly sets the ExportOnly field's value.
func (s *CancelExportTaskOutput) SetExportOnly(v []*string) *CancelExportTaskOutput {
	s.ExportOnly = v
	return s
}

// SetExportTaskIdentifier sets the ExportTaskIdentifier field's value.
func (s *CancelExportTaskOutput) SetExportTaskIdentifier(v string) *CancelExportTaskOutput {
	s.ExportTaskIdentifier = &v
	return s
}

// SetFailureCause sets the FailureCause field's value.
func (s *CancelExportTaskOutput) SetFailureCause(v string) *CancelExportTaskOutput {
	s.FailureCause = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CancelExportTaskOutput) SetIamRoleArn(v string) *CancelExportTaskOutput {
	s.IamRoleArn = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CancelExportTaskOutput) SetKmsKeyId(v string) *CancelExportTaskOutput {
	s.KmsKeyId = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *CancelExportTaskOutput) SetPercentProgress(v int64) *CancelExportTaskOutput {
	s.PercentProgress = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *CancelExportTaskOutput) SetS3Bucket(v string) *CancelExportTaskOutput {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *CancelExportTaskOutput) SetS3Prefix(v string) *CancelExportTaskOutput {
	s.S3Prefix = &v
	return s
}

// SetSnapshotTime sets the SnapshotTime field's value.
func (s *CancelExportTaskOutput) SetSnapshotTime(v time.Time) *CancelExportTaskOutput {
	s.SnapshotTime = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CancelExportTaskOutput) SetSourceArn(v string) *CancelExportTaskOutput {
	s.SourceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelExportTaskOutput) SetStatus(v string) *CancelExportTaskOutput {
	s.Status = &v
	return s
}

// SetTaskEndTime sets the TaskEndTime field's value.
func (s *CancelExportTaskOutput) SetTaskEndTime(v time.Time) *CancelExportTaskOutput {
	s.TaskEndTime = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *CancelExportTaskOutput) SetTaskStartTime(v time.Time) *CancelExportTaskOutput {
	s.TaskStartTime = &v
	return s
}

// SetTotalExtractedDataInGB sets the TotalExtractedDataInGB field's value.
func (s *CancelExportTaskOutput) SetTotalExtractedDataInGB(v int64) *CancelExportTaskOutput {
	s.TotalExtractedDataInGB = &v
	return s
}

// SetWarningMessage sets the WarningMessage field's value.
func (s *CancelExportTaskOutput) SetWarningMessage(v string) *CancelExportTaskOutput {
	s.WarningMessage = &v
	return s
}

// A CA certificate for an AWS account.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The unique key that identifies a certificate.
	CertificateIdentifier *string `type:"string"`

	// The type of the certificate.
	CertificateType *string `type:"string"`

	// Whether there is an override for the default certificate identifier.
	CustomerOverride *bool `type:"boolean"`

	// If there is an override for the default certificate identifier, when the
	// override expires.
	CustomerOverrideValidTill *time.Time `type:"timestamp"`

	// The thumbprint of the certificate.
	Thumbprint *string `type:"string"`

	// The starting date from which the certificate is valid.
	ValidFrom *time.Time `type:"timestamp"`

	// The final date that the certificate continues to be valid.
	ValidTill *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateType sets the CertificateType field's value.
func (s *Certificate) SetCertificateType(v string) *Certificate {
	s.CertificateType = &v
	return s
}

// SetCustomerOverride sets the CustomerOverride field's value.
func (s *Certificate) SetCustomerOverride(v bool) *Certificate {
	s.CustomerOverride = &v
	return s
}

// SetCustomerOverrideValidTill sets the CustomerOverrideValidTill field's value.
func (s *Certificate) SetCustomerOverrideValidTill(v time.Time) *Certificate {
	s.CustomerOverrideValidTill = &v
	return s
}

// SetThumbprint sets the Thumbprint field's value.
func (s *Certificate) SetThumbprint(v string) *Certificate {
	s.Thumbprint = &v
	return s
}

// SetValidFrom sets the ValidFrom field's value.
func (s *Certificate) SetValidFrom(v time.Time) *Certificate {
	s.ValidFrom = &v
	return s
}

// SetValidTill sets the ValidTill field's value.
func (s *Certificate) SetValidTill(v time.Time) *Certificate {
	s.ValidTill = &v
	return s
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CharacterSet) GoString() string {
	return s.String()
}

// SetCharacterSetDescription sets the CharacterSetDescription field's value.
func (s *CharacterSet) SetCharacterSetDescription(v string) *CharacterSet {
	s.CharacterSetDescription = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CharacterSet) SetCharacterSetName(v string) *CharacterSet {
	s.CharacterSetName = &v
	return s
}

// The configuration setting for the log types to be enabled for export to CloudWatch
// Logs for a specific DB instance or DB cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs will be
// exported (or not exported) to CloudWatch Logs. The values within these arrays
// depend on the DB engine being used. For more information, see Publishing
// Database Logs to Amazon CloudWatch Logs (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
// in the Amazon RDS User Guide.
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []*string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []*string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchLogsExportConfiguration) GoString() string {
	return s.String()
}

// SetDisableLogTypes sets the DisableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetDisableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.DisableLogTypes = v
	return s
}

// SetEnableLogTypes sets the EnableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetEnableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.EnableLogTypes = v
	return s
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Specifies the settings that control the size and behavior of the connection
// pool associated with a DBProxyTargetGroup.
type ConnectionPoolConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	//
	// Default: 120
	//
	// Constraints: between 1 and 3600, or 0 representing unlimited
	ConnectionBorrowTimeout *int64 `type:"integer"`

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. For multiple
	// statements, use semicolons as the separator. You can also include multiple
	// variables in a single SET statement, such as SET x=1, y=2.
	//
	// InitQuery is not currently supported for PostgreSQL.
	//
	// Default: no initialization query
	InitQuery *string `type:"string"`

	// The maximum size of the connection pool for each target in a target group.
	// For Aurora MySQL, it is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	//
	// Default: 100
	//
	// Constraints: between 1 and 100
	MaxConnectionsPercent *int64 `type:"integer"`

	// Controls how actively the proxy closes idle database connections in the connection
	// pool. A high value enables the proxy to leave a high percentage of idle connections
	// open. A low value causes the proxy to close idle client connections and return
	// the underlying database connections to the connection pool. For Aurora MySQL,
	// it is expressed as a percentage of the max_connections setting for the RDS
	// DB instance or Aurora DB cluster used by the target group.
	//
	// Default: 50
	//
	// Constraints: between 0 and MaxConnectionsPercent
	MaxIdleConnectionsPercent *int64 `type:"integer"`

	// Each item in the list represents a class of SQL operations that normally
	// cause all later statements in a session using a proxy to be pinned to the
	// same underlying database connection. Including an item in the list exempts
	// that class of SQL operations from the pinning behavior.
	//
	// Default: no session pinning filters
	SessionPinningFilters []*string `type:"list"`
}

// String returns the string representation
func (s ConnectionPoolConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionPoolConfiguration) GoString() string {
	return s.String()
}

// SetConnectionBorrowTimeout sets the ConnectionBorrowTimeout field's value.
func (s *ConnectionPoolConfiguration) SetConnectionBorrowTimeout(v int64) *ConnectionPoolConfiguration {
	s.ConnectionBorrowTimeout = &v
	return s
}

// SetInitQuery sets the InitQuery field's value.
func (s *ConnectionPoolConfiguration) SetInitQuery(v string) *ConnectionPoolConfiguration {
	s.InitQuery = &v
	return s
}

// SetMaxConnectionsPercent sets the MaxConnectionsPercent field's value.
func (s *ConnectionPoolConfiguration) SetMaxConnectionsPercent(v int64) *ConnectionPoolConfiguration {
	s.MaxConnectionsPercent = &v
	return s
}

// SetMaxIdleConnectionsPercent sets the MaxIdleConnectionsPercent field's value.
func (s *ConnectionPoolConfiguration) SetMaxIdleConnectionsPercent(v int64) *ConnectionPoolConfiguration {
	s.MaxIdleConnectionsPercent = &v
	return s
}

// SetSessionPinningFilters sets the SessionPinningFilters field's value.
func (s *ConnectionPoolConfiguration) SetSessionPinningFilters(v []*string) *ConnectionPoolConfiguration {
	s.SessionPinningFilters = v
	return s
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Displays the settings that control the size and behavior of the connection
// pool associated with a DBProxyTarget.
type ConnectionPoolConfigurationInfo struct {
	_ struct{} `type:"structure"`

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	ConnectionBorrowTimeout *int64 `type:"integer"`

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. This setting
	// is empty by default. For multiple statements, use semicolons as the separator.
	// You can also include multiple variables in a single SET statement, such as
	// SET x=1, y=2.
	//
	// InitQuery is not currently supported for PostgreSQL.
	InitQuery *string `type:"string"`

	// The maximum size of the connection pool for each target in a target group.
	// For Aurora MySQL, it is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	MaxConnectionsPercent *int64 `type:"integer"`

	// Controls how actively the proxy closes idle database connections in the connection
	// pool. A high value enables the proxy to leave a high percentage of idle connections
	// open. A low value causes the proxy to close idle client connections and return
	// the underlying database connections to the connection pool. For Aurora MySQL,
	// it is expressed as a percentage of the max_connections setting for the RDS
	// DB instance or Aurora DB cluster used by the target group.
	MaxIdleConnectionsPercent *int64 `type:"integer"`

	// Each item in the list represents a class of SQL operations that normally
	// cause all later statements in a session using a proxy to be pinned to the
	// same underlying database connection. Including an item in the list exempts
	// that class of SQL operations from the pinning behavior. Currently, the only
	// allowed value is EXCLUDE_VARIABLE_SETS.
	SessionPinningFilters []*string `type:"list"`
}

// String returns the string representation
func (s ConnectionPoolConfigurationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionPoolConfigurationInfo) GoString() string {
	return s.String()
}

// SetConnectionBorrowTimeout sets the ConnectionBorrowTimeout field's value.
func (s *ConnectionPoolConfigurationInfo) SetConnectionBorrowTimeout(v int64) *ConnectionPoolConfigurationInfo {
	s.ConnectionBorrowTimeout = &v
	return s
}

// SetInitQuery sets the InitQuery field's value.
func (s *ConnectionPoolConfigurationInfo) SetInitQuery(v string) *ConnectionPoolConfigurationInfo {
	s.InitQuery = &v
	return s
}

// SetMaxConnectionsPercent sets the MaxConnectionsPercent field's value.
func (s *ConnectionPoolConfigurationInfo) SetMaxConnectionsPercent(v int64) *ConnectionPoolConfigurationInfo {
	s.MaxConnectionsPercent = &v
	return s
}

// SetMaxIdleConnectionsPercent sets the MaxIdleConnectionsPercent field's value.
func (s *ConnectionPoolConfigurationInfo) SetMaxIdleConnectionsPercent(v int64) *ConnectionPoolConfigurationInfo {
	s.MaxIdleConnectionsPercent = &v
	return s
}

// SetSessionPinningFilters sets the SessionPinningFilters field's value.
func (s *ConnectionPoolConfigurationInfo) SetSessionPinningFilters(v []*string) *ConnectionPoolConfigurationInfo {
	s.SessionPinningFilters = v
	return s
}

type CopyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter
	// group. For information about creating an ARN, see Constructing an ARN for
	// Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
	// in the Amazon Aurora User Guide.
	//
	// Constraints:
	//
	//    * Must specify a valid DB cluster parameter group.
	//
	//    * If the source DB cluster parameter group is in the same AWS Region as
	//    the copy, specify a valid DB parameter group identifier, for example my-db-cluster-param-group,
	//    or a valid ARN.
	//
	//    * If the source DB parameter group is in a different AWS Region than the
	//    copy, specify a valid DB cluster parameter group ARN, for example arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1.
	//
	// SourceDBClusterParameterGroupIdentifier is a required field
	SourceDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB cluster parameter group.
	//
	// TargetDBClusterParameterGroupDescription is a required field
	TargetDBClusterParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster-param-group1
	//
	// TargetDBClusterParameterGroupIdentifier is a required field
	TargetDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterParameterGroupInput"}
	if s.SourceDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterParameterGroupIdentifier"))
	}
	if s.TargetDBClusterParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupDescription"))
	}
	if s.TargetDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBClusterParameterGroupIdentifier sets the SourceDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetSourceDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.SourceDBClusterParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterParameterGroupInput) SetTags(v []*Tag) *CopyDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterParameterGroupDescription sets the TargetDBClusterParameterGroupDescription field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupDescription(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupDescription = &v
	return s
}

// SetTargetDBClusterParameterGroupIdentifier sets the TargetDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupIdentifier = &v
	return s
}

type CopyDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB cluster parameter group.
	//
	// This data type is used as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CopyDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CopyDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to copy all tags from the source DB cluster
	// snapshot to the target DB cluster snapshot. By default, tags are not copied.
	CopyTags *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is
	// the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias
	// for the KMS encryption key.
	//
	// If you copy an encrypted DB cluster snapshot from your AWS account, you can
	// specify a value for KmsKeyId to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for KmsKeyId, then the copy of the DB cluster
	// snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
	//
	// If you copy an encrypted DB cluster snapshot that is shared from another
	// AWS account, then you must specify a value for KmsKeyId.
	//
	// To copy an encrypted DB cluster snapshot to another AWS Region, you must
	// set KmsKeyId to the KMS key ID you want to use to encrypt the copy of the
	// DB cluster snapshot in the destination AWS Region. KMS encryption keys are
	// specific to the AWS Region that they are created in, and you can't use encryption
	// keys from one AWS Region in another AWS Region.
	//
	// If you copy an unencrypted DB cluster snapshot and specify a value for the
	// KmsKeyId parameter, an error is returned.
	KmsKeyId *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBClusterSnapshot
	// API action in the AWS Region that contains the source DB cluster snapshot
	// to copy. The PreSignedUrl parameter must be used when copying an encrypted
	// DB cluster snapshot from another AWS Region. Don't specify PreSignedUrl when
	// you are copying an encrypted DB cluster snapshot in the same AWS Region.
	//
	// The pre-signed URL must be a valid request for the CopyDBClusterSnapshot
	// API action that can be executed in the source AWS Region that contains the
	// encrypted DB cluster snapshot to be copied. The pre-signed URL request must
	// contain the following parameter values:
	//
	//    * KmsKeyId - The AWS KMS key identifier for the key to use to encrypt
	//    the copy of the DB cluster snapshot in the destination AWS Region. This
	//    is the same identifier for both the CopyDBClusterSnapshot action that
	//    is called in the destination AWS Region, and the action contained in the
	//    pre-signed URL.
	//
	//    * DestinationRegion - The name of the AWS Region that the DB cluster snapshot
	//    is to be created in.
	//
	//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
	//    for the encrypted DB cluster snapshot to be copied. This identifier must
	//    be in the Amazon Resource Name (ARN) format for the source AWS Region.
	//    For example, if you are copying an encrypted DB cluster snapshot from
	//    the us-west-2 AWS Region, then your SourceDBClusterSnapshotIdentifier
	//    looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a pre-signed URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	PreSignedUrl *string `type:"string"`

	// The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.
	//
	// You can't copy an encrypted, shared DB cluster snapshot from one AWS Region
	// to another.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	//    * If the source snapshot is in the same AWS Region as the copy, specify
	//    a valid DB snapshot identifier.
	//
	//    * If the source snapshot is in a different AWS Region than the copy, specify
	//    a valid DB cluster snapshot ARN. For more information, go to Copying Snapshots
	//    Across AWS Regions (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions)
	//    in the Amazon Aurora User Guide.
	//
	// Example: my-cluster-snapshot1
	//
	// SourceDBClusterSnapshotIdentifier is a required field
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new DB cluster snapshot to create from the source DB
	// cluster snapshot. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot2
	//
	// TargetDBClusterSnapshotIdentifier is a required field
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterSnapshotInput"}
	if s.SourceDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterSnapshotIdentifier"))
	}
	if s.TargetDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBClusterSnapshotInput) SetCopyTags(v bool) *CopyDBClusterSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyDBClusterSnapshotInput) SetDestinationRegion(v string) *CopyDBClusterSnapshotInput {
	s.DestinationRegion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBClusterSnapshotInput) SetKmsKeyId(v string) *CopyDBClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBClusterSnapshotInput) SetPreSignedUrl(v string) *CopyDBClusterSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBClusterSnapshotIdentifier sets the SourceDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.SourceDBClusterSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceRegion(v string) *CopyDBClusterSnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterSnapshotInput) SetTags(v []*Tag) *CopyDBClusterSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterSnapshotIdentifier sets the TargetDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetTargetDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.TargetDBClusterSnapshotIdentifier = &v
	return s
}

type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CopyDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CopyDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

type CopyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source DB parameter group. For information
	// about creating an ARN, see Constructing an ARN for Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must specify a valid DB parameter group.
	//
	//    * Must specify a valid DB parameter group identifier, for example my-db-param-group,
	//    or a valid ARN.
	//
	// SourceDBParameterGroupIdentifier is a required field
	SourceDBParameterGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB parameter group.
	//
	// TargetDBParameterGroupDescription is a required field
	TargetDBParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB parameter group.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-db-parameter-group
	//
	// TargetDBParameterGroupIdentifier is a required field
	TargetDBParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBParameterGroupInput"}
	if s.SourceDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBParameterGroupIdentifier"))
	}
	if s.TargetDBParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupDescription"))
	}
	if s.TargetDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBParameterGroupIdentifier sets the SourceDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetSourceDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.SourceDBParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBParameterGroupInput) SetTags(v []*Tag) *CopyDBParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBParameterGroupDescription sets the TargetDBParameterGroupDescription field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupDescription(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupDescription = &v
	return s
}

// SetTargetDBParameterGroupIdentifier sets the TargetDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupIdentifier = &v
	return s
}

type CopyDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB parameter group.
	//
	// This data type is used as a response element in the DescribeDBParameterGroups
	// action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CopyDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CopyDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

type CopyDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to copy all tags from the source DB snapshot
	// to the target DB snapshot. By default, tags are not copied.
	CopyTags *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The AWS KMS key ID for an encrypted DB snapshot. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	//
	// If you copy an encrypted DB snapshot from your AWS account, you can specify
	// a value for this parameter to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for this parameter, then the copy of the
	// DB snapshot is encrypted with the same KMS key as the source DB snapshot.
	//
	// If you copy an encrypted DB snapshot that is shared from another AWS account,
	// then you must specify a value for this parameter.
	//
	// If you specify this parameter when you copy an unencrypted snapshot, the
	// copy is encrypted.
	//
	// If you copy an encrypted snapshot to a different AWS Region, then you must
	// specify a KMS key for the destination AWS Region. KMS encryption keys are
	// specific to the AWS Region that they are created in, and you can't use encryption
	// keys from one AWS Region in another AWS Region.
	KmsKeyId *string `type:"string"`

	// The name of an option group to associate with the copy of the snapshot.
	//
	// Specify this option if you are copying a snapshot from one AWS Region to
	// another, and your DB instance uses a nondefault option group. If your source
	// DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL
	// Server, you must specify this option when copying across AWS Regions. For
	// more information, see Option Group Considerations (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options)
	// in the Amazon RDS User Guide.
	OptionGroupName *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBSnapshot
	// API action in the source AWS Region that contains the source DB snapshot
	// to copy.
	//
	// You must specify this parameter when you copy an encrypted DB snapshot from
	// another AWS Region by using the Amazon RDS API. Don't specify PreSignedUrl
	// when you are copying an encrypted DB snapshot in the same AWS Region.
	//
	// The presigned URL must be a valid request for the CopyDBSnapshot API action
	// that can be executed in the source AWS Region that contains the encrypted
	// DB snapshot to be copied. The presigned URL request must contain the following
	// parameter values:
	//
	//    * DestinationRegion - The AWS Region that the encrypted DB snapshot is
	//    copied to. This AWS Region is the same one where the CopyDBSnapshot action
	//    is called that contains this presigned URL. For example, if you copy an
	//    encrypted DB snapshot from the us-west-2 AWS Region to the us-east-1 AWS
	//    Region, then you call the CopyDBSnapshot action in the us-east-1 AWS Region
	//    and provide a presigned URL that contains a call to the CopyDBSnapshot
	//    action in the us-west-2 AWS Region. For this example, the DestinationRegion
	//    in the presigned URL must be set to the us-east-1 AWS Region.
	//
	//    * KmsKeyId - The AWS KMS key identifier for the key to use to encrypt
	//    the copy of the DB snapshot in the destination AWS Region. This is the
	//    same identifier for both the CopyDBSnapshot action that is called in the
	//    destination AWS Region, and the action contained in the presigned URL.
	//
	//    * SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted
	//    snapshot to be copied. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are copying
	//    an encrypted DB snapshot from the us-west-2 AWS Region, then your SourceDBSnapshotIdentifier
	//    looks like the following example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a pre-signed URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	PreSignedUrl *string `type:"string"`

	// The identifier for the source DB snapshot.
	//
	// If the source snapshot is in the same AWS Region as the copy, specify a valid
	// DB snapshot identifier. For example, you might specify rds:mysql-instance1-snapshot-20130805.
	//
	// If the source snapshot is in a different AWS Region than the copy, specify
	// a valid DB snapshot ARN. For example, you might specify arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805.
	//
	// If you are copying from a shared manual DB snapshot, this parameter must
	// be the Amazon Resource Name (ARN) of the shared DB snapshot.
	//
	// If you are copying an encrypted snapshot this parameter must be in the ARN
	// format for the source AWS Region, and must match the SourceDBSnapshotIdentifier
	// in the PreSignedUrl parameter.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	// Example: rds:mydb-2012-04-02-00-01
	//
	// Example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805
	//
	// SourceDBSnapshotIdentifier is a required field
	SourceDBSnapshotIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier for the copy of the snapshot.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-db-snapshot
	//
	// TargetDBSnapshotIdentifier is a required field
	TargetDBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBSnapshotInput"}
	if s.SourceDBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBSnapshotIdentifier"))
	}
	if s.TargetDBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBSnapshotInput) SetCopyTags(v bool) *CopyDBSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyDBSnapshotInput) SetDestinationRegion(v string) *CopyDBSnapshotInput {
	s.DestinationRegion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBSnapshotInput) SetKmsKeyId(v string) *CopyDBSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CopyDBSnapshotInput) SetOptionGroupName(v string) *CopyDBSnapshotInput {
	s.OptionGroupName = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBSnapshotInput) SetPreSignedUrl(v string) *CopyDBSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBSnapshotIdentifier sets the SourceDBSnapshotIdentifier field's value.
func (s *CopyDBSnapshotInput) SetSourceDBSnapshotIdentifier(v string) *CopyDBSnapshotInput {
	s.SourceDBSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyDBSnapshotInput) SetSourceRegion(v string) *CopyDBSnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBSnapshotInput) SetTags(v []*Tag) *CopyDBSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBSnapshotIdentifier sets the TargetDBSnapshotIdentifier field's value.
func (s *CopyDBSnapshotInput) SetTargetDBSnapshotIdentifier(v string) *CopyDBSnapshotInput {
	s.TargetDBSnapshotIdentifier = &v
	return s
}

type CopyDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB snapshot.
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *CopyDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *CopyDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

type CopyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source option group. For information about
	// creating an ARN, see Constructing an ARN for Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must specify a valid option group.
	//
	//    * If the source option group is in the same AWS Region as the copy, specify
	//    a valid option group identifier, for example my-option-group, or a valid
	//    ARN.
	//
	//    * If the source option group is in a different AWS Region than the copy,
	//    specify a valid option group ARN, for example arn:aws:rds:us-west-2:123456789012:og:special-options.
	//
	// SourceOptionGroupIdentifier is a required field
	SourceOptionGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The description for the copied option group.
	//
	// TargetOptionGroupDescription is a required field
	TargetOptionGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied option group.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-option-group
	//
	// TargetOptionGroupIdentifier is a required field
	TargetOptionGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyOptionGroupInput"}
	if s.SourceOptionGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceOptionGroupIdentifier"))
	}
	if s.TargetOptionGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOptionGroupDescription"))
	}
	if s.TargetOptionGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOptionGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceOptionGroupIdentifier sets the SourceOptionGroupIdentifier field's value.
func (s *CopyOptionGroupInput) SetSourceOptionGroupIdentifier(v string) *CopyOptionGroupInput {
	s.SourceOptionGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyOptionGroupInput) SetTags(v []*Tag) *CopyOptionGroupInput {
	s.Tags = v
	return s
}

// SetTargetOptionGroupDescription sets the TargetOptionGroupDescription field's value.
func (s *CopyOptionGroupInput) SetTargetOptionGroupDescription(v string) *CopyOptionGroupInput {
	s.TargetOptionGroupDescription = &v
	return s
}

// SetTargetOptionGroupIdentifier sets the TargetOptionGroupIdentifier field's value.
func (s *CopyOptionGroupInput) SetTargetOptionGroupIdentifier(v string) *CopyOptionGroupInput {
	s.TargetOptionGroupIdentifier = &v
	return s
}

type CopyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CopyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupOutput) GoString() string {
	return s.String()
}

// SetOptionGroup sets the OptionGroup field's value.
func (s *CopyOptionGroupOutput) SetOptionGroup(v *OptionGroup) *CopyOptionGroupOutput {
	s.OptionGroup = v
	return s
}

type CreateCustomAvailabilityZoneInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom Availability Zone (AZ).
	//
	// CustomAvailabilityZoneName is a required field
	CustomAvailabilityZoneName *string `type:"string" required:"true"`

	// The ID of an existing virtual private network (VPN) between the Amazon RDS
	// website and the VMware vSphere cluster.
	ExistingVpnId *string `type:"string"`

	// The name of a new VPN tunnel between the Amazon RDS website and the VMware
	// vSphere cluster.
	//
	// Specify this parameter only if ExistingVpnId isn't specified.
	NewVpnTunnelName *string `type:"string"`

	// The IP address of network traffic from your on-premises data center. A custom
	// AZ receives the network traffic.
	//
	// Specify this parameter only if ExistingVpnId isn't specified.
	VpnTunnelOriginatorIP *string `type:"string"`
}

// String returns the string representation
func (s CreateCustomAvailabilityZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomAvailabilityZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomAvailabilityZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomAvailabilityZoneInput"}
	if s.CustomAvailabilityZoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomAvailabilityZoneName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomAvailabilityZoneName sets the CustomAvailabilityZoneName field's value.
func (s *CreateCustomAvailabilityZoneInput) SetCustomAvailabilityZoneName(v string) *CreateCustomAvailabilityZoneInput {
	s.CustomAvailabilityZoneName = &v
	return s
}

// SetExistingVpnId sets the ExistingVpnId field's value.
func (s *CreateCustomAvailabilityZoneInput) SetExistingVpnId(v string) *CreateCustomAvailabilityZoneInput {
	s.ExistingVpnId = &v
	return s
}

// SetNewVpnTunnelName sets the NewVpnTunnelName field's value.
func (s *CreateCustomAvailabilityZoneInput) SetNewVpnTunnelName(v string) *CreateCustomAvailabilityZoneInput {
	s.NewVpnTunnelName = &v
	return s
}

// SetVpnTunnelOriginatorIP sets the VpnTunnelOriginatorIP field's value.
func (s *CreateCustomAvailabilityZoneInput) SetVpnTunnelOriginatorIP(v string) *CreateCustomAvailabilityZoneInput {
	s.VpnTunnelOriginatorIP = &v
	return s
}

type CreateCustomAvailabilityZoneOutput struct {
	_ struct{} `type:"structure"`

	// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with
	// a VMware vSphere cluster.
	//
	// For more information about RDS on VMware, see the RDS on VMware User Guide.
	// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
	CustomAvailabilityZone *CustomAvailabilityZone `type:"structure"`
}

// String returns the string representation
func (s CreateCustomAvailabilityZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomAvailabilityZoneOutput) GoString() string {
	return s.String()
}

// SetCustomAvailabilityZone sets the CustomAvailabilityZone field's value.
func (s *CreateCustomAvailabilityZoneOutput) SetCustomAvailabilityZone(v *CustomAvailabilityZone) *CreateCustomAvailabilityZoneOutput {
	s.CustomAvailabilityZone = v
	return s
}

type CreateDBClusterEndpointInput struct {
	_ struct{} `type:"structure"`

	// The identifier to use for the new endpoint. This parameter is stored as a
	// lowercase string.
	//
	// DBClusterEndpointIdentifier is a required field
	DBClusterEndpointIdentifier *string `type:"string" required:"true"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The type of the endpoint. One of: READER, WRITER, ANY.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []*string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []*string `type:"list"`

	// The tags to be assigned to the Amazon RDS resource.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterEndpointInput"}
	if s.DBClusterEndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterEndpointIdentifier"))
	}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *CreateDBClusterEndpointInput) SetDBClusterEndpointIdentifier(v string) *CreateDBClusterEndpointInput {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterEndpointInput) SetDBClusterIdentifier(v string) *CreateDBClusterEndpointInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateDBClusterEndpointInput) SetEndpointType(v string) *CreateDBClusterEndpointInput {
	s.EndpointType = &v
	return s
}

// SetExcludedMembers sets the ExcludedMembers field's value.
func (s *CreateDBClusterEndpointInput) SetExcludedMembers(v []*string) *CreateDBClusterEndpointInput {
	s.ExcludedMembers = v
	return s
}

// SetStaticMembers sets the StaticMembers field's value.
func (s *CreateDBClusterEndpointInput) SetStaticMembers(v []*string) *CreateDBClusterEndpointInput {
	s.StaticMembers = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterEndpointInput) SetTags(v []*Tag) *CreateDBClusterEndpointInput {
	s.Tags = v
	return s
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
//    * CreateDBClusterEndpoint
//
//    * DescribeDBClusterEndpoints
//
//    * ModifyDBClusterEndpoint
//
//    * DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon RDS DB instance endpoints,
// see Endpoint.
type CreateDBClusterEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string `type:"string"`

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string `type:"string"`

	// The identifier associated with the endpoint. This parameter is stored as
	// a lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// A unique system-generated identifier for an endpoint. It remains the same
	// for the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// The DNS address of the endpoint.
	Endpoint *string `type:"string"`

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []*string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []*string `type:"list"`

	// The current status of the endpoint. One of: creating, available, deleting,
	// modifying.
	Status *string `type:"string"`
}

// String returns the string representation
func (s CreateDBClusterEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterEndpointOutput) GoString() string {
	return s.String()
}

// SetCustomEndpointType sets the CustomEndpointType field's value.
func (s *CreateDBClusterEndpointOutput) SetCustomEndpointType(v string) *CreateDBClusterEndpointOutput {
	s.CustomEndpointType = &v
	return s
}

// SetDBClusterEndpointArn sets the DBClusterEndpointArn field's value.
func (s *CreateDBClusterEndpointOutput) SetDBClusterEndpointArn(v string) *CreateDBClusterEndpointOutput {
	s.DBClusterEndpointArn = &v
	return s
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *CreateDBClusterEndpointOutput) SetDBClusterEndpointIdentifier(v string) *CreateDBClusterEndpointOutput {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// SetDBClusterEndpointResourceIdentifier sets the DBClusterEndpointResourceIdentifier field's value.
func (s *CreateDBClusterEndpointOutput) SetDBClusterEndpointResourceIdentifier(v string) *CreateDBClusterEndpointOutput {
	s.DBClusterEndpointResourceIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterEndpointOutput) SetDBClusterIdentifier(v string) *CreateDBClusterEndpointOutput {
	s.DBClusterIdentifier = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateDBClusterEndpointOutput) SetEndpoint(v string) *CreateDBClusterEndpointOutput {
	s.Endpoint = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateDBClusterEndpointOutput) SetEndpointType(v string) *CreateDBClusterEndpointOutput {
	s.EndpointType = &v
	return s
}

// SetExcludedMembers sets the ExcludedMembers field's value.
func (s *CreateDBClusterEndpointOutput) SetExcludedMembers(v []*string) *CreateDBClusterEndpointOutput {
	s.ExcludedMembers = v
	return s
}

// SetStaticMembers sets the StaticMembers field's value.
func (s *CreateDBClusterEndpointOutput) SetStaticMembers(v []*string) *CreateDBClusterEndpointOutput {
	s.StaticMembers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDBClusterEndpointOutput) SetStatus(v string) *CreateDBClusterEndpointOutput {
	s.Status = &v
	return s
}

type CreateDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones (AZs) where instances in the DB cluster can
	// be created. For information on AWS Regions and Availability Zones, see Choosing
	// the Regions and Availability Zones (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html)
	// in the Amazon Aurora User Guide.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The target backtrack window, in seconds. To disable backtracking, set this
	// value to 0.
	//
	// Default: 0
	//
	// Constraints:
	//
	//    * If specified, this value must be set to a number from 0 to 259,200 (72
	//    hours).
	BacktrackWindow *int64 `type:"long"`

	// The number of days for which automated backups are retained.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// A value that indicates that the DB cluster should be associated with the
	// specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// A value that indicates whether to copy all tags from the DB cluster to snapshots
	// of the DB cluster. The default is not to copy them.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The DB cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with this DB cluster.
	// If you do not specify a value, then the default DB cluster parameter group
	// for the specified DB engine and version is used.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DB cluster parameter
	//    group.
	DBClusterParameterGroupName *string `type:"string"`

	// A DB subnet group to associate with this DB cluster.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// The name for your database of up to 64 alphanumeric characters. If you do
	// not provide a name, Amazon RDS doesn't create a database in the DB cluster
	// you are creating.
	DatabaseName *string `type:"string"`

	// A value that indicates whether the DB cluster has deletion protection enabled.
	// The database can't be deleted when deletion protection is enabled. By default,
	// deletion protection is disabled.
	DeletionProtection *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The Active Directory directory ID to create the DB cluster in.
	//
	// For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication
	// to authenticate users that connect to the DB cluster. For more information,
	// see Kerberos Authentication (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html)
	// in the Amazon Aurora User Guide.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// The list of log types that need to be enabled for exporting to CloudWatch
	// Logs. The values in the list depend on the DB engine being used. For more
	// information, see Publishing Database Logs to Amazon CloudWatch Logs (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
	// in the Amazon Aurora User Guide.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// A value that indicates whether to enable the HTTP endpoint for an Aurora
	// Serverless DB cluster. By default, the HTTP endpoint is disabled.
	//
	// When enabled, the HTTP endpoint provides a connectionless web service API
	// for running SQL queries on the Aurora Serverless DB cluster. You can also
	// query your database from inside the RDS console with the query editor.
	//
	// For more information, see Using the Data API for Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
	// in the Amazon Aurora User Guide.
	EnableHttpEndpoint *bool `type:"boolean"`

	// A value that indicates whether to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts. By default, mapping is disabled.
	//
	// For more information, see IAM Database Authentication (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
	// in the Amazon Aurora User Guide.
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The name of the database engine to be used for this DB cluster.
	//
	// Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for
	// MySQL 5.7-compatible Aurora), and aurora-postgresql
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery,
	// global, or multimaster.
	//
	// global engine mode only applies for global database clusters created with
	// Aurora MySQL version 5.6.10a. For higher Aurora MySQL versions, the clusters
	// in a global database use provisioned engine mode.
	//
	// Limitations and requirements apply to some DB engine modes. For more information,
	// see the following sections in the Amazon Aurora User Guide:
	//
	//    * Limitations of Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations)
	//
	//    * Limitations of Parallel Query (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations)
	//
	//    * Requirements for Aurora Global Databases (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations)
	//
	//    * Limitations of Multi-Master Clusters (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations)
	EngineMode *string `type:"string"`

	// The version number of the database engine to use.
	//
	// To list all of the available engine versions for aurora (for MySQL 5.6-compatible
	// Aurora), use the following command:
	//
	// aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"
	//
	// To list all of the available engine versions for aurora-mysql (for MySQL
	// 5.7-compatible Aurora), use the following command:
	//
	// aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"
	//
	// To list all of the available engine versions for aurora-postgresql, use the
	// following command:
	//
	// aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"
	//
	// Aurora MySQL
	//
	// Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5
	//
	// Aurora PostgreSQL
	//
	// Example: 9.6.3, 10.7
	EngineVersion *string `type:"string"`

	// The global cluster ID of an Aurora cluster that becomes the primary cluster
	// in the new global database cluster.
	GlobalClusterIdentifier *string `type:"string"`

	// The AWS KMS key identifier for an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If an encryption key isn't specified in KmsKeyId:
	//
	//    * If ReplicationSourceIdentifier identifies an encrypted source, then
	//    Amazon RDS will use the encryption key used to encrypt the source. Otherwise,
	//    Amazon RDS will use your default encryption key.
	//
	//    * If the StorageEncrypted parameter is enabled and ReplicationSourceIdentifier
	//    isn't specified, then Amazon RDS will use your default encryption key.
	//
	// AWS KMS creates the default encryption key for your AWS account. Your AWS
	// account has a different default encryption key for each AWS Region.
	//
	// If you create a read replica of an encrypted DB cluster in another AWS Region,
	// you must set KmsKeyId to a KMS key ID that is valid in the destination AWS
	// Region. This key is used to encrypt the read replica in that AWS Region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The name of the master user for the DB cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 16 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group.
	//
	// Permanent options can't be removed from an option group. The option group
	// can't be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the instances in the DB cluster accept connections.
	//
	// Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql.
	Port *int64 `type:"integer"`

	// A URL that contains a Signature Version 4 signed request for the CreateDBCluster
	// action to be called in the source AWS Region where the DB cluster is replicated
	// from. You only need to specify PreSignedUrl when you are performing cross-region
	// replication from an encrypted DB cluster.
	//
	// The pre-signed URL must be a valid request for the CreateDBCluster API action
	// that can be executed in the source AWS Region that contains the encrypted
	// DB cluster to be copied.
	//
	// The pre-signed URL request must contain the following parameter values:
	//
	//    * KmsKeyId - The AWS KMS key identifier for the key to use to encrypt
	//    the copy of the DB cluster in the destination AWS Region. This should
	//    refer to the same KMS key for both the CreateDBCluster action that is
	//    called in the destination AWS Region, and the action contained in the
	//    pre-signed URL.
	//
	//    * DestinationRegion - The name of the AWS Region that Aurora read replica
	//    will be created in.
	//
	//    * ReplicationSourceIdentifier - The DB cluster identifier for the encrypted
	//    DB cluster to be copied. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are copying
	//    an encrypted DB cluster from the us-west-2 AWS Region, then your ReplicationSourceIdentifier
	//    would look like Example: arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a pre-signed URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	PreSignedUrl *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region. To see the time blocks available, see Adjusting
	// the Preferred DB Cluster Maintenance Window (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
	// in the Amazon Aurora User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week. To see
	// the time blocks available, see Adjusting the Preferred DB Cluster Maintenance
	// Window (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
	// in the Amazon Aurora User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the source DB instance or DB cluster if
	// this DB cluster is created as a read replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// For DB clusters in serverless DB engine mode, the scaling properties of the
	// DB cluster.
	ScalingConfiguration *ScalingConfiguration `type:"structure"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A value that indicates whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Tags to assign to the DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with this DB cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateDBClusterInput) SetAvailabilityZones(v []*string) *CreateDBClusterInput {
	s.AvailabilityZones = v
	return s
}

// SetBacktrackWindow sets the BacktrackWindow field's value.
func (s *CreateDBClusterInput) SetBacktrackWindow(v int64) *CreateDBClusterInput {
	s.BacktrackWindow = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBClusterInput) SetBackupRetentionPeriod(v int64) *CreateDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBClusterInput) SetCharacterSetName(v string) *CreateDBClusterInput {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBClusterInput) SetCopyTagsToSnapshot(v bool) *CreateDBClusterInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterInput) SetDBClusterIdentifier(v string) *CreateDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBClusterInput) SetDBSubnetGroupName(v string) *CreateDBClusterInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateDBClusterInput) SetDatabaseName(v string) *CreateDBClusterInput {
	s.DatabaseName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateDBClusterInput) SetDeletionProtection(v bool) *CreateDBClusterInput {
	s.DeletionProtection = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateDBClusterInput) SetDestinationRegion(v string) *CreateDBClusterInput {
	s.DestinationRegion = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDBClusterInput) SetDomain(v string) *CreateDBClusterInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *CreateDBClusterInput) SetDomainIAMRoleName(v string) *CreateDBClusterInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *CreateDBClusterInput) SetEnableCloudwatchLogsExports(v []*string) *CreateDBClusterInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEnableHttpEndpoint sets the EnableHttpEndpoint field's value.
func (s *CreateDBClusterInput) SetEnableHttpEndpoint(v bool) *CreateDBClusterInput {
	s.EnableHttpEndpoint = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBClusterInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBClusterInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBClusterInput) SetEngine(v string) *CreateDBClusterInput {
	s.Engine = &v
	return s
}

// SetEngineMode sets the EngineMode field's value.
func (s *CreateDBClusterInput) SetEngineMode(v string) *CreateDBClusterInput {
	s.EngineMode = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBClusterInput) SetEngineVersion(v string) *CreateDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetGlobalClusterIdentifier sets the GlobalClusterIdentifier field's value.
func (s *CreateDBClusterInput) SetGlobalClusterIdentifier(v string) *CreateDBClusterInput {
	s.GlobalClusterIdentifier = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBClusterInput) SetKmsKeyId(v string) *CreateDBClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBClusterInput) SetMasterUserPassword(v string) *CreateDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBClusterInput) SetMasterUsername(v string) *CreateDBClusterInput {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBClusterInput) SetOptionGroupName(v string) *CreateDBClusterInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBClusterInput) SetPort(v int64) *CreateDBClusterInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBClusterInput) SetPreSignedUrl(v string) *CreateDBClusterInput {
	s.PreSignedUrl = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBClusterInput) SetPreferredBackupWindow(v string) *CreateDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBClusterInput) SetPreferredMaintenanceWindow(v string) *CreateDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *CreateDBClusterInput) SetReplicationSourceIdentifier(v string) *CreateDBClusterInput {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetScalingConfiguration sets the ScalingConfiguration field's value.
func (s *CreateDBClusterInput) SetScalingConfiguration(v *ScalingConfiguration) *CreateDBClusterInput {
	s.ScalingConfiguration = v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CreateDBClusterInput) SetSourceRegion(v string) *CreateDBClusterInput {
	s.SourceRegion = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBClusterInput) SetStorageEncrypted(v bool) *CreateDBClusterInput {
	s.StorageEncrypted = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterInput) SetTags(v []*Tag) *CreateDBClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Aurora DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters, StopDBCluster,
	// and StartDBCluster actions.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *CreateDBClusterOutput) SetDBCluster(v *DBCluster) *CreateDBClusterOutput {
	s.DBCluster = v
	return s
}

type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must match the name of an existing DB cluster parameter group.
	//
	// This value is stored as a lowercase string.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The DB cluster parameter group family name. A DB cluster parameter group
	// can be associated with one and only one DB cluster parameter group family,
	// and can be applied only to a DB cluster running a database engine and engine
	// version compatible with that DB cluster parameter group family.
	//
	// Aurora MySQL
	//
	// Example: aurora5.6, aurora-mysql5.7
	//
	// Aurora PostgreSQL
	//
	// Example: aurora-postgresql9.6
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the DB cluster parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Tags to assign to the DB cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBClusterParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBClusterParameterGroupInput) SetDescription(v string) *CreateDBClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterParameterGroupInput) SetTags(v []*Tag) *CreateDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB cluster parameter group.
	//
	// This data type is used as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CreateDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CreateDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

type CreateDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster to create a snapshot for. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the DB cluster snapshot. This parameter is stored as a
	// lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1-snapshot1
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the DB cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterSnapshotInput) SetTags(v []*Tag) *CreateDBClusterSnapshotInput {
	s.Tags = v
	return s
}

type CreateDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CreateDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CreateDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gibibytes) to allocate for the DB instance.
	//
	// Type: Integer
	//
	// Amazon Aurora
	//
	// Not applicable. Aurora cluster volumes automatically grow as the amount of
	// data in your database increases, though you are only charged for the space
	// that you use in an Aurora cluster volume.
	//
	// MySQL
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// MariaDB
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// PostgreSQL
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// Oracle
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
	//
	//    * Magnetic storage (standard): Must be an integer from 10 to 3072.
	//
	// SQL Server
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Enterprise and Standard editions:
	//    Must be an integer from 200 to 16384. Web and Express editions: Must be
	//    an integer from 20 to 16384.
	//
	//    * Provisioned IOPS storage (io1): Enterprise and Standard editions: Must
	//    be an integer from 200 to 16384. Web and Express editions: Must be an
	//    integer from 100 to 16384.
	//
	//    * Magnetic storage (standard): Enterprise and Standard editions: Must
	//    be an integer from 200 to 1024. Web and Express editions: Must be an integer
	//    from 20 to 1024.
	AllocatedStorage *int64 `type:"integer"`

	// A value that indicates whether minor engine upgrades are applied automatically
	// to the DB instance during the maintenance window. By default, minor engine
	// upgrades are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone (AZ) where the database will be created. For information
	// on AWS Regions and Availability Zones, see Regions and Availability Zones
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	//
	// Constraint: The AvailabilityZone parameter can't be specified if the DB instance
	// is a Multi-AZ deployment. The specified Availability Zone must be in the
	// same AWS Region as the current endpoint.
	//
	// If you're creating a DB instance in an RDS on VMware environment, specify
	// the identifier of the custom Availability Zone to create the DB instance
	// in.
	//
	// For more information about RDS on VMware, see the RDS on VMware User Guide.
	// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
	AvailabilityZone *string `type:"string"`

	// The number of days for which automated backups are retained. Setting this
	// parameter to a positive number enables backups. Setting this parameter to
	// 0 disables automated backups.
	//
	// Amazon Aurora
	//
	// Not applicable. The retention period for automated backups is managed by
	// the DB cluster.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 0 to 35
	//
	//    * Can't be set to 0 if the DB instance is a source to read replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// For supported engines, indicates that the DB instance should be associated
	// with the specified CharacterSet.
	//
	// Amazon Aurora
	//
	// Not applicable. The character set is managed by the DB cluster. For more
	// information, see CreateDBCluster.
	CharacterSetName *string `type:"string"`

	// A value that indicates whether to copy tags from the DB instance to snapshots
	// of the DB instance. By default, tags are not copied.
	//
	// Amazon Aurora
	//
	// Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting
	// this value for an Aurora DB instance has no effect on the DB cluster setting.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The identifier of the DB cluster that the instance will belong to.
	DBClusterIdentifier *string `type:"string"`

	// The compute and memory capacity of the DB instance, for example, db.m4.large.
	// Not all DB instance classes are available in all AWS Regions, or for all
	// database engines. For the full list of DB instance classes, and availability
	// for your engine, see DB Instance Class (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
	// in the Amazon RDS User Guide.
	//
	// DBInstanceClass is a required field
	DBInstanceClass *string `type:"string" required:"true"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter isn't specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 letters or numbers.
	//
	//    * Can't be a word reserved by the specified database engine
	//
	// MariaDB
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter isn't specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 letters or numbers.
	//
	//    * Can't be a word reserved by the specified database engine
	//
	// PostgreSQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter isn't specified, the default "postgres" database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 63 letters, numbers, or underscores.
	//
	//    * Must begin with a letter or an underscore. Subsequent characters can
	//    be letters, underscores, or digits (0-9).
	//
	//    * Can't be a word reserved by the specified database engine
	//
	// Oracle
	//
	// The Oracle System ID (SID) of the created DB instance. If you specify null,
	// the default value ORCL is used. You can't specify the string NULL, or any
	// other reserved word, for DBName.
	//
	// Default: ORCL
	//
	// Constraints:
	//
	//    * Can't be longer than 8 characters
	//
	// SQL Server
	//
	// Not applicable. Must be null.
	//
	// Amazon Aurora
	//
	// The name of the database to create when the primary instance of the DB cluster
	// is created. If this parameter isn't specified, no database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 letters or numbers.
	//
	//    * Can't be a word reserved by the specified database engine
	DBName *string `type:"string"`

	// The name of the DB parameter group to associate with this DB instance. If
	// you do not specify a value, then the default DB parameter group for the specified
	// DB engine and version is used.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// A list of DB security groups to associate with this DB instance.
	//
	// Default: The default DB security group for the database engine.
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// A DB subnet group to associate with this DB instance.
	//
	// If there is no DB subnet group, then it is a non-VPC DB instance.
	DBSubnetGroupName *string `type:"string"`

	// A value that indicates whether the DB instance has deletion protection enabled.
	// The database can't be deleted when deletion protection is enabled. By default,
	// deletion protection is disabled. For more information, see Deleting a DB
	// Instance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
	//
	// Amazon Aurora
	//
	// Not applicable. You can enable or disable deletion protection for the DB
	// cluster. For more information, see CreateDBCluster. DB instances in a DB
	// cluster can be deleted even when deletion protection is enabled for the DB
	// cluster.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory directory ID to create the DB instance in. Currently,
	// only Microsoft SQL Server and Oracle DB instances can be created in an Active
	// Directory Domain.
	//
	// For Microsoft SQL Server DB instances, Amazon RDS can use Windows Authentication
	// to authenticate users that connect to the DB instance. For more information,
	// see Using Windows Authentication with an Amazon RDS DB Instance Running Microsoft
	// SQL Server (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_SQLServerWinAuth.html)
	// in the Amazon RDS User Guide.
	//
	// For Oracle DB instances, Amazon RDS can use Kerberos Authentication to authenticate
	// users that connect to the DB instance. For more information, see Using Kerberos
	// Authentication with Amazon RDS for Oracle (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html)
	// in the Amazon RDS User Guide.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// The list of log types that need to be enabled for exporting to CloudWatch
	// Logs. The values in the list depend on the DB engine being used. For more
	// information, see Publishing Database Logs to Amazon CloudWatch Logs (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
	// in the Amazon Relational Database Service User Guide.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// A value that indicates whether to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts. By default, mapping is disabled.
	//
	// You can enable IAM database authentication for the following database engines:
	//
	// Amazon Aurora
	//
	// Not applicable. Mapping AWS IAM accounts to database accounts is managed
	// by the DB cluster.
	//
	// MySQL
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * For MySQL 8.0, minor version 8.0.16 or higher
	//
	// PostgreSQL
	//
	//    * For PostgreSQL 9.5, minor version 9.5.15 or higher
	//
	//    * For PostgreSQL 9.6, minor version 9.6.11 or higher
	//
	//    * PostgreSQL 10.6, 10.7, and 10.9
	//
	// For more information, see IAM Database Authentication for MySQL and PostgreSQL
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
	// in the Amazon RDS User Guide.
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// A value that indicates whether to enable Performance Insights for the DB
	// instance.
	//
	// For more information, see Using Amazon Performance Insights (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
	// in the Amazon Relational Database Service User Guide.
	EnablePerformanceInsights *bool `type:"boolean"`

	// The name of the database engine to be used for this instance.
	//
	// Not every database engine is available for every AWS Region.
	//
	// Valid Values:
	//
	//    * aurora (for MySQL 5.6-compatible Aurora)
	//
	//    * aurora-mysql (for MySQL 5.7-compatible Aurora)
	//
	//    * aurora-postgresql
	//
	//    * mariadb
	//
	//    * mysql
	//
	//    * oracle-ee
	//
	//    * oracle-se2
	//
	//    * oracle-se1
	//
	//    * oracle-se
	//
	//    * postgres
	//
	//    * sqlserver-ee
	//
	//    * sqlserver-se
	//
	//    * sqlserver-ex
	//
	//    * sqlserver-web
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// For a list of valid engine versions, use the DescribeDBEngineVersions action.
	//
	// The following are the database engines and links to information about the
	// major and minor versions that are available with Amazon RDS. Not every database
	// engine is available for every AWS Region.
	//
	// Amazon Aurora
	//
	// Not applicable. The version number of the database engine to be used by the
	// DB instance is managed by the DB cluster.
	//
	// MariaDB
	//
	// See MariaDB on Amazon RDS Versions (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt)
	// in the Amazon RDS User Guide.
	//
	// Microsoft SQL Server
	//
	// See Version and Feature Support on Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport)
	// in the Amazon RDS User Guide.
	//
	// MySQL
	//
	// See MySQL on Amazon RDS Versions (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt)
	// in the Amazon RDS User Guide.
	//
	// Oracle
	//
	// See Oracle Database Engine Release Notes (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html)
	// in the Amazon RDS User Guide.
	//
	// PostgreSQL
	//
	// See Supported PostgreSQL Database Versions (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions)
	// in the Amazon RDS User Guide.
	EngineVersion *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance. For information about valid Iops
	// values, see Amazon RDS Provisioned IOPS Storage to Improve Performance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
	// in the Amazon RDS User Guide.
	//
	// Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must
	// be a multiple between .5 and 50 of the storage amount for the DB instance.
	// For SQL Server DB instances, must be a multiple between 1 and 50 of the storage
	// amount for the DB instance.
	Iops *int64 `type:"integer"`

	// The AWS KMS key identifier for an encrypted DB instance.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB instance with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB instance, then you can
	// use the KMS key alias instead of the ARN for the KM encryption key.
	//
	// Amazon Aurora
	//
	// Not applicable. The KMS key identifier is managed by the DB cluster. For
	// more information, see CreateDBCluster.
	//
	// If StorageEncrypted is enabled, and you do not specify a value for the KmsKeyId
	// parameter, then Amazon RDS will use your default encryption key. AWS KMS
	// creates the default encryption key for your AWS account. Your AWS account
	// has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// License model information for this DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// The password for the master user. The password can include any printable
	// ASCII character except "/", """, or "@".
	//
	// Amazon Aurora
	//
	// Not applicable. The password for the master user is managed by the DB cluster.
	//
	// MariaDB
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// Microsoft SQL Server
	//
	// Constraints: Must contain from 8 to 128 characters.
	//
	// MySQL
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// Oracle
	//
	// Constraints: Must contain from 8 to 30 characters.
	//
	// PostgreSQL
	//
	// Constraints: Must contain from 8 to 128 characters.
	MasterUserPassword *string `type:"string"`

	// The name for the master user.
	//
	// Amazon Aurora
	//
	// Not applicable. The name for the master user is managed by the DB cluster.
	//
	// MariaDB
	//
	// Constraints:
	//
	//    * Required for MariaDB.
	//
	//    * Must be 1 to 16 letters or numbers.
	//
	//    * Can't be a reserved word for the chosen database engine.
	//
	// Microsoft SQL Server
	//
	// Constraints:
	//
	//    * Required for SQL Server.
	//
	//    * Must be 1 to 128 letters or numbers.
	//
	//    * The first character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine.
	//
	// MySQL
	//
	// Constraints:
	//
	//    * Required for MySQL.
	//
	//    * Must be 1 to 16 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine.
	//
	// Oracle
	//
	// Constraints:
	//
	//    * Required for Oracle.
	//
	//    * Must be 1 to 30 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine.
	//
	// PostgreSQL
	//
	// Constraints:
	//
	//    * Required for PostgreSQL.
	//
	//    * Must be 1 to 63 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// The upper limit to which Amazon RDS can automatically scale the storage of
	// the DB instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to Setting Up and Enabling
	// Enhanced Monitoring (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
	// in the Amazon RDS User Guide.
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// A value that indicates whether the DB instance is a Multi-AZ deployment.
	// You can't set the AvailabilityZone parameter if the DB instance is a Multi-AZ
	// deployment.
	MultiAZ *bool `type:"boolean"`

	// Indicates that the DB instance should be associated with the specified option
	// group.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// can't be removed from an option group. Also, that option group can't be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	//
	// If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon
	// RDS uses your default encryption key. AWS KMS creates the default encryption
	// key for your AWS account. Your AWS account has a different default encryption
	// key for each AWS Region.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The amount of time, in days, to retain Performance Insights data. Valid values
	// are 7 or 731 (2 years).
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// The port number on which the database accepts connections.
	//
	// MySQL
	//
	// Default: 3306
	//
	// Valid values: 1150-65535
	//
	// Type: Integer
	//
	// MariaDB
	//
	// Default: 3306
	//
	// Valid values: 1150-65535
	//
	// Type: Integer
	//
	// PostgreSQL
	//
	// Default: 5432
	//
	// Valid values: 1150-65535
	//
	// Type: Integer
	//
	// Oracle
	//
	// Default: 1521
	//
	// Valid values: 1150-65535
	//
	// SQL Server
	//
	// Default: 1433
	//
	// Valid values: 1150-65535 except 1234, 1434, 3260, 3343, 3389, 47001, and
	// 49152-49156.
	//
	// Amazon Aurora
	//
	// Default: 3306
	//
	// Valid values: 1150-65535
	//
	// Type: Integer
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter. For more
	// information, see The Backup Window (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
	// in the Amazon RDS User Guide.
	//
	// Amazon Aurora
	//
	// Not applicable. The daily time range for creating automated backups is managed
	// by the DB cluster.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region. To see the time blocks available, see Adjusting
	// the Preferred DB Instance Maintenance Window (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The time range each week during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). For more information, see Amazon RDS Maintenance
	// Window (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see Fault Tolerance for an Aurora DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	PromotionTier *int64 `type:"integer"`

	// A value that indicates whether the DB instance is publicly accessible. When
	// the DB instance is publicly accessible, it is an Internet-facing instance
	// with a publicly resolvable DNS name, which resolves to a public IP address.
	// When the DB instance isn't publicly accessible, it is an internal instance
	// with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether DBSubnetGroupName
	// is specified.
	//
	// If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified,
	// the following applies:
	//
	//    * If the default VPC in the target region doesn’t have an Internet gateway
	//    attached to it, the DB instance is private.
	//
	//    * If the default VPC in the target region has an Internet gateway attached
	//    to it, the DB instance is public.
	//
	// If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified,
	// the following applies:
	//
	//    * If the subnets are part of a VPC that doesn’t have an Internet gateway
	//    attached to it, the DB instance is private.
	//
	//    * If the subnets are part of a VPC that has an Internet gateway attached
	//    to it, the DB instance is public.
	PubliclyAccessible *bool `type:"boolean"`

	// A value that indicates whether the DB instance is encrypted. By default,
	// it isn't encrypted.
	//
	// Amazon Aurora
	//
	// Not applicable. The encryption for DB instances is managed by the DB cluster.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified, otherwise gp2
	StorageType *string `type:"string"`

	// Tags to assign to the DB instance.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the key store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// The time zone of the DB instance. The time zone parameter is currently supported
	// only by Microsoft SQL Server (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
	Timezone *string `type:"string"`

	// A list of Amazon EC2 VPC security groups to associate with this DB instance.
	//
	// Amazon Aurora
	//
	// Not applicable. The associated list of EC2 VPC security groups is managed
	// by the DB cluster.
	//
	// Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.DBInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceClass"))
	}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateDBInstanceInput) SetAllocatedStorage(v int64) *CreateDBInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceInput) SetAvailabilityZone(v string) *CreateDBInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBInstanceInput) SetBackupRetentionPeriod(v int64) *CreateDBInstanceInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBInstanceInput) SetCharacterSetName(v string) *CreateDBInstanceInput {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBInstanceInput) SetCopyTagsToSnapshot(v bool) *CreateDBInstanceInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBClusterIdentifier(v string) *CreateDBInstanceInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceInput) SetDBInstanceClass(v string) *CreateDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *CreateDBInstanceInput) SetDBName(v string) *CreateDBInstanceInput {
	s.DBName = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBInstanceInput) SetDBParameterGroupName(v string) *CreateDBInstanceInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *CreateDBInstanceInput) SetDBSecurityGroups(v []*string) *CreateDBInstanceInput {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBInstanceInput) SetDBSubnetGroupName(v string) *CreateDBInstanceInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateDBInstanceInput) SetDeletionProtection(v bool) *CreateDBInstanceInput {
	s.DeletionProtection = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDBInstanceInput) SetDomain(v string) *CreateDBInstanceInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *CreateDBInstanceInput) SetDomainIAMRoleName(v string) *CreateDBInstanceInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *CreateDBInstanceInput) SetEnableCloudwatchLogsExports(v []*string) *CreateDBInstanceInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBInstanceInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBInstanceInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEnablePerformanceInsights sets the EnablePerformanceInsights field's value.
func (s *CreateDBInstanceInput) SetEnablePerformanceInsights(v bool) *CreateDBInstanceInput {
	s.EnablePerformanceInsights = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBInstanceInput) SetEngine(v string) *CreateDBInstanceInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBInstanceInput) SetEngineVersion(v string) *CreateDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateDBInstanceInput) SetIops(v int64) *CreateDBInstanceInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBInstanceInput) SetKmsKeyId(v string) *CreateDBInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *CreateDBInstanceInput) SetLicenseModel(v string) *CreateDBInstanceInput {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBInstanceInput) SetMasterUserPassword(v string) *CreateDBInstanceInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBInstanceInput) SetMasterUsername(v string) *CreateDBInstanceInput {
	s.MasterUsername = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *CreateDBInstanceInput) SetMaxAllocatedStorage(v int64) *CreateDBInstanceInput {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *CreateDBInstanceInput) SetMonitoringInterval(v int64) *CreateDBInstanceInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *CreateDBInstanceInput) SetMonitoringRoleArn(v string) *CreateDBInstanceInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateDBInstanceInput) SetMultiAZ(v bool) *CreateDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBInstanceInput) SetOptionGroupName(v string) *CreateDBInstanceInput {
	s.OptionGroupName = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *CreateDBInstanceInput) SetPerformanceInsightsKMSKeyId(v string) *CreateDBInstanceInput {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPerformanceInsightsRetentionPeriod sets the PerformanceInsightsRetentionPeriod field's value.
func (s *CreateDBInstanceInput) SetPerformanceInsightsRetentionPeriod(v int64) *CreateDBInstanceInput {
	s.PerformanceInsightsRetentionPeriod = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBInstanceInput) SetPort(v int64) *CreateDBInstanceInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredBackupWindow(v string) *CreateDBInstanceInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *CreateDBInstanceInput) SetProcessorFeatures(v []*ProcessorFeature) *CreateDBInstanceInput {
	s.ProcessorFeatures = v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *CreateDBInstanceInput) SetPromotionTier(v int64) *CreateDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDBInstanceInput) SetPubliclyAccessible(v bool) *CreateDBInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBInstanceInput) SetStorageEncrypted(v bool) *CreateDBInstanceInput {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceInput) SetStorageType(v string) *CreateDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*Tag) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialArn(v string) *CreateDBInstanceInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialPassword(v string) *CreateDBInstanceInput {
	s.TdeCredentialPassword = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateDBInstanceInput) SetTimezone(v string) *CreateDBInstanceInput {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateDBInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceOutput {
	s.DBInstance = v
	return s
}

type CreateDBInstanceReadReplicaInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether minor engine upgrades are applied automatically
	// to the read replica during the maintenance window.
	//
	// Default: Inherits from the source DB instance
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone (AZ) where the read replica will be created.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// A value that indicates whether to copy all tags from the read replica to
	// snapshots of the read replica. By default, tags are not copied.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the read replica, for example, db.m4.large.
	// Not all DB instance classes are available in all AWS Regions, or for all
	// database engines. For the full list of DB instance classes, and availability
	// for your engine, see DB Instance Class (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
	// in the Amazon RDS User Guide.
	//
	// Default: Inherits from the source DB instance.
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier of the read replica. This identifier is the unique
	// key that identifies a DB instance. This parameter is stored as a lowercase
	// string.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the DB parameter group to associate with this DB instance.
	//
	// If you do not specify a value for DBParameterGroupName, then Amazon RDS uses
	// the DBParameterGroup of source DB instance for a same region read replica,
	// or the default DBParameterGroup for the specified DB engine for a cross region
	// read replica.
	//
	// Currently, specifying a parameter group for this operation is only supported
	// for Oracle DB instances.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// Specifies a DB subnet group for the DB instance. The new DB instance is created
	// in the VPC associated with the DB subnet group. If no DB subnet group is
	// specified, then the new DB instance isn't created in a VPC.
	//
	// Constraints:
	//
	//    * Can only be specified if the source DB instance identifier specifies
	//    a DB instance in another AWS Region.
	//
	//    * If supplied, must match the name of an existing DBSubnetGroup.
	//
	//    * The specified DB subnet group must be in the same AWS Region in which
	//    the operation is running.
	//
	//    * All read replicas in one AWS Region that are created from the same source
	//    DB instance must either:> Specify DB subnet groups from the same VPC.
	//    All these read replicas are created in the same VPC. Not specify a DB
	//    subnet group. All these read replicas are created outside of any VPC.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// A value that indicates whether the DB instance has deletion protection enabled.
	// The database can't be deleted when deletion protection is enabled. By default,
	// deletion protection is disabled. For more information, see Deleting a DB
	// Instance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
	DeletionProtection *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The Active Directory directory ID to create the DB instance in.
	//
	// For Oracle DB instances, Amazon RDS can use Kerberos Authentication to authenticate
	// users that connect to the DB instance. For more information, see Using Kerberos
	// Authentication with Amazon RDS for Oracle (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html)
	// in the Amazon RDS User Guide.
	//
	// For Microsoft SQL Server DB instances, Amazon RDS can use Windows Authentication
	// to authenticate users that connect to the DB instance. For more information,
	// see Using Windows Authentication with an Amazon RDS DB Instance Running Microsoft
	// SQL Server (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_SQLServerWinAuth.html)
	// in the Amazon RDS User Guide.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// The list of logs that the new DB instance is to export to CloudWatch Logs.
	// The values in the list depend on the DB engine being used. For more information,
	// see Publishing Database Logs to Amazon CloudWatch Logs (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
	// in the Amazon RDS User Guide.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// A value that indicates whether to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts. By default, mapping is disabled.
	// For information about the supported DB engines, see CreateDBInstance.
	//
	// For more information about IAM database authentication, see IAM Database
	// Authentication for MySQL and PostgreSQL (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
	// in the Amazon RDS User Guide.
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// A value that indicates whether to enable Performance Insights for the read
	// replica.
	//
	// For more information, see Using Amazon Performance Insights (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
	// in the Amazon RDS User Guide.
	EnablePerformanceInsights *bool `type:"boolean"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	Iops *int64 `type:"integer"`

	// The AWS KMS key ID for an encrypted read replica. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	//
	// If you create an encrypted read replica in the same AWS Region as the source
	// DB instance, then you do not have to specify a value for this parameter.
	// The read replica is encrypted with the same KMS key as the source DB instance.
	//
	// If you create an encrypted read replica in a different AWS Region, then you
	// must specify a KMS key for the destination AWS Region. KMS encryption keys
	// are specific to the AWS Region that they are created in, and you can't use
	// encryption keys from one AWS Region in another AWS Region.
	//
	// You can't create an encrypted read replica from an unencrypted DB instance.
	KmsKeyId *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the read replica. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
	// in the Amazon RDS User Guide.
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// A value that indicates whether the read replica is in a Multi-AZ deployment.
	//
	// You can create a read replica as a Multi-AZ DB instance. RDS creates a standby
	// of your replica in another Availability Zone for failover support for the
	// replica. Creating your read replica as a Multi-AZ DB instance is independent
	// of whether the source database is a Multi-AZ DB instance.
	MultiAZ *bool `type:"boolean"`

	// The option group the DB instance is associated with. If omitted, the option
	// group associated with the source instance is used.
	//
	// For SQL Server, you must use the option group associated with the source
	// instance.
	OptionGroupName *string `type:"string"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	//
	// If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon
	// RDS uses your default encryption key. AWS KMS creates the default encryption
	// key for your AWS account. Your AWS account has a different default encryption
	// key for each AWS Region.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The amount of time, in days, to retain Performance Insights data. Valid values
	// are 7 or 731 (2 years).
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// The port number that the DB instance uses for connections.
	//
	// Default: Inherits from the source DB instance
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The URL that contains a Signature Version 4 signed request for the CreateDBInstanceReadReplica
	// API action in the source AWS Region that contains the source DB instance.
	//
	// You must specify this parameter when you create an encrypted read replica
	// from another AWS Region by using the Amazon RDS API. Don't specify PreSignedUrl
	// when you are creating an encrypted read replica in the same AWS Region.
	//
	// The presigned URL must be a valid request for the CreateDBInstanceReadReplica
	// API action that can be executed in the source AWS Region that contains the
	// encrypted source DB instance. The presigned URL request must contain the
	// following parameter values:
	//
	//    * DestinationRegion - The AWS Region that the encrypted read replica is
	//    created in. This AWS Region is the same one where the CreateDBInstanceReadReplica
	//    action is called that contains this presigned URL. For example, if you
	//    create an encrypted DB instance in the us-west-1 AWS Region, from a source
	//    DB instance in the us-east-2 AWS Region, then you call the CreateDBInstanceReadReplica
	//    action in the us-east-1 AWS Region and provide a presigned URL that contains
	//    a call to the CreateDBInstanceReadReplica action in the us-west-2 AWS
	//    Region. For this example, the DestinationRegion in the presigned URL must
	//    be set to the us-east-1 AWS Region.
	//
	//    * KmsKeyId - The AWS KMS key identifier for the key to use to encrypt
	//    the read replica in the destination AWS Region. This is the same identifier
	//    for both the CreateDBInstanceReadReplica action that is called in the
	//    destination AWS Region, and the action contained in the presigned URL.
	//
	//    * SourceDBInstanceIdentifier - The DB instance identifier for the encrypted
	//    DB instance to be replicated. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are creating
	//    an encrypted read replica from a DB instance in the us-west-2 AWS Region,
	//    then your SourceDBInstanceIdentifier looks like the following example:
	//    arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115.
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a presigned URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	//
	// SourceRegion isn't supported for SQL Server, because SQL Server on Amazon
	// RDS doesn't support cross-region read replicas.
	PreSignedUrl *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// A value that indicates whether the DB instance is publicly accessible. When
	// the DB instance is publicly accessible, it is an Internet-facing instance
	// with a publicly resolvable DNS name, which resolves to a public IP address.
	// When the DB instance isn't publicly accessible, it is an internal instance
	// with a DNS name that resolves to a private IP address. For more information,
	// see CreateDBInstance.
	PubliclyAccessible *bool `type:"boolean"`

	// The identifier of the DB instance that will act as the source for the read
	// replica. Each DB instance can have up to five read replicas.
	//
	// Constraints:
	//
	//    * Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL,
	//    or SQL Server DB instance.
	//
	//    * Can specify a DB instance that is a MySQL read replica only if the source
	//    is running MySQL 5.6 or later.
	//
	//    * For the limitations of Oracle read replicas, see Read Replica Limitations
	//    with Oracle (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html)
	//    in the Amazon RDS User Guide.
	//
	//    * For the limitations of SQL Server read replicas, see Read Replica Limitations
	//    with Microsoft SQL Server (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html)
	//    in the Amazon RDS User Guide.
	//
	//    * Can specify a PostgreSQL DB instance only if the source is running PostgreSQL
	//    9.3.5 or later (9.4.7 and higher for cross-region replication).
	//
	//    * The specified DB instance must have automatic backups enabled, that
	//    is, its backup retention period must be greater than 0.
	//
	//    * If the source DB instance is in the same AWS Region as the read replica,
	//    specify a valid DB instance identifier.
	//
	//    * If the source DB instance is in a different AWS Region from the read
	//    replica, specify a valid DB instance ARN. For more information, see Constructing
	//    an ARN for Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
	//    in the Amazon RDS User Guide. This doesn't apply to SQL Server, which
	//    doesn't support cross-region replicas.
	//
	// SourceDBInstanceIdentifier is a required field
	SourceDBInstanceIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// Specifies the storage type to be associated with the read replica.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified, otherwise gp2
	StorageType *string `type:"string"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A value that indicates whether the DB instance class of the DB instance uses
	// its default processor features.
	UseDefaultProcessorFeatures *bool `type:"boolean"`

	// A list of EC2 VPC security groups to associate with the read replica.
	//
	// Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceReadReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceReadReplicaInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.SourceDBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceReadReplicaInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceReadReplicaInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceReadReplicaInput) SetAvailabilityZone(v string) *CreateDBInstanceReadReplicaInput {
	s.AvailabilityZone = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBInstanceReadReplicaInput) SetCopyTagsToSnapshot(v bool) *CreateDBInstanceReadReplicaInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBInstanceClass(v string) *CreateDBInstanceReadReplicaInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceReadReplicaInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBParameterGroupName(v string) *CreateDBInstanceReadReplicaInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBSubnetGroupName(v string) *CreateDBInstanceReadReplicaInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDeletionProtection(v bool) *CreateDBInstanceReadReplicaInput {
	s.DeletionProtection = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDestinationRegion(v string) *CreateDBInstanceReadReplicaInput {
	s.DestinationRegion = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDomain(v string) *CreateDBInstanceReadReplicaInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDomainIAMRoleName(v string) *CreateDBInstanceReadReplicaInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *CreateDBInstanceReadReplicaInput) SetEnableCloudwatchLogsExports(v []*string) *CreateDBInstanceReadReplicaInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBInstanceReadReplicaInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBInstanceReadReplicaInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEnablePerformanceInsights sets the EnablePerformanceInsights field's value.
func (s *CreateDBInstanceReadReplicaInput) SetEnablePerformanceInsights(v bool) *CreateDBInstanceReadReplicaInput {
	s.EnablePerformanceInsights = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateDBInstanceReadReplicaInput) SetIops(v int64) *CreateDBInstanceReadReplicaInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBInstanceReadReplicaInput) SetKmsKeyId(v string) *CreateDBInstanceReadReplicaInput {
	s.KmsKeyId = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *CreateDBInstanceReadReplicaInput) SetMonitoringInterval(v int64) *CreateDBInstanceReadReplicaInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *CreateDBInstanceReadReplicaInput) SetMonitoringRoleArn(v string) *CreateDBInstanceReadReplicaInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateDBInstanceReadReplicaInput) SetMultiAZ(v bool) *CreateDBInstanceReadReplicaInput {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetOptionGroupName(v string) *CreateDBInstanceReadReplicaInput {
	s.OptionGroupName = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPerformanceInsightsKMSKeyId(v string) *CreateDBInstanceReadReplicaInput {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPerformanceInsightsRetentionPeriod sets the PerformanceInsightsRetentionPeriod field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPerformanceInsightsRetentionPeriod(v int64) *CreateDBInstanceReadReplicaInput {
	s.PerformanceInsightsRetentionPeriod = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPort(v int64) *CreateDBInstanceReadReplicaInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPreSignedUrl(v string) *CreateDBInstanceReadReplicaInput {
	s.PreSignedUrl = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *CreateDBInstanceReadReplicaInput) SetProcessorFeatures(v []*ProcessorFeature) *CreateDBInstanceReadReplicaInput {
	s.ProcessorFeatures = v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPubliclyAccessible(v bool) *CreateDBInstanceReadReplicaInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSourceDBInstanceIdentifier sets the SourceDBInstanceIdentifier field's value.
func (s *CreateDBInstanceReadReplicaInput) SetSourceDBInstanceIdentifier(v string) *CreateDBInstanceReadReplicaInput {
	s.SourceDBInstanceIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CreateDBInstanceReadReplicaInput) SetSourceRegion(v string) *CreateDBInstanceReadReplicaInput {
	s.SourceRegion = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceReadReplicaInput) SetStorageType(v string) *CreateDBInstanceReadReplicaInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceReadReplicaInput) SetTags(v []*Tag) *CreateDBInstanceReadReplicaInput {
	s.Tags = v
	return s
}

// SetUseDefaultProcessorFeatures sets the UseDefaultProcessorFeatures field's value.
func (s *CreateDBInstanceReadReplicaInput) SetUseDefaultProcessorFeatures(v bool) *CreateDBInstanceReadReplicaInput {
	s.UseDefaultProcessorFeatures = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBInstanceReadReplicaInput) SetVpcSecurityGroupIds(v []*string) *CreateDBInstanceReadReplicaInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBInstanceReadReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceReadReplicaOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceReadReplicaOutput {
	s.DBInstance = v
	return s
}

type CreateDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The DB parameter group family name. A DB parameter group can be associated
	// with one and only one DB parameter group family, and can be applied only
	// to a DB instance running a database engine and engine version compatible
	// with that DB parameter group family.
	//
	// To list all of the available parameter group families, use the following
	// command:
	//
	// aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily"
	//
	// The output contains duplicates.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// The description for the DB parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Tags to assign to the DB parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBParameterGroupInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupName(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBParameterGroupInput) SetDescription(v string) *CreateDBParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBParameterGroupInput) SetTags(v []*Tag) *CreateDBParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB parameter group.
	//
	// This data type is used as a response element in the DescribeDBParameterGroups
	// action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CreateDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CreateDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

type CreateDBProxyInput struct {
	_ struct{} `type:"structure"`

	// The authorization mechanism that the proxy uses.
	//
	// Auth is a required field
	Auth []*UserAuthConfig `type:"list" required:"true"`

	// The identifier for the proxy. This name must be unique for all proxies owned
	// by your AWS account in the specified AWS Region. An identifier must begin
	// with a letter and must contain only ASCII letters, digits, and hyphens; it
	// can't end with a hyphen or contain two consecutive hyphens.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`

	// Whether the proxy includes detailed information about SQL statements in its
	// logs. This information helps you to debug issues involving SQL behavior or
	// the performance and scalability of the proxy connections. The debug information
	// includes the text of SQL statements that you submit through the proxy. Thus,
	// only enable this setting when needed for debugging, and only when you have
	// security measures in place to safeguard any sensitive information that appears
	// in the logs.
	DebugLogging *bool `type:"boolean"`

	// The kinds of databases that the proxy can connect to. This value determines
	// which database network protocol the proxy recognizes when it interprets network
	// traffic to and from the database. The engine family applies to MySQL and
	// PostgreSQL for both RDS and Aurora.
	//
	// EngineFamily is a required field
	EngineFamily *string `type:"string" required:"true" enum:"EngineFamily"`

	// The number of seconds that a connection to the proxy can be inactive before
	// the proxy disconnects it. You can set this value higher or lower than the
	// connection timeout limit for the associated database.
	IdleClientTimeout *int64 `type:"integer"`

	// A Boolean parameter that specifies whether Transport Layer Security (TLS)
	// encryption is required for connections to the proxy. By enabling this setting,
	// you can enforce encrypted TLS connections to the proxy.
	RequireTLS *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access
	// secrets in AWS Secrets Manager.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// An optional set of key-value pairs to associate arbitrary data of your choosing
	// with the proxy.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// One or more VPC security group IDs to associate with the new proxy.
	VpcSecurityGroupIds []*string `type:"list"`

	// One or more VPC subnet IDs to associate with the new proxy.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateDBProxyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBProxyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBProxyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBProxyInput"}
	if s.Auth == nil {
		invalidParams.Add(request.NewErrParamRequired("Auth"))
	}
	if s.DBProxyName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBProxyName"))
	}
	if s.EngineFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineFamily"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.VpcSubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcSubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuth sets the Auth field's value.
func (s *CreateDBProxyInput) SetAuth(v []*UserAuthConfig) *CreateDBProxyInput {
	s.Auth = v
	return s
}

// SetDBProxyName sets the DBProxyName field's value.
func (s *CreateDBProxyInput) SetDBProxyName(v string) *CreateDBProxyInput {
	s.DBProxyName = &v
	return s
}

// SetDebugLogging sets the DebugLogging field's value.
func (s *CreateDBProxyInput) SetDebugLogging(v bool) *CreateDBProxyInput {
	s.DebugLogging = &v
	return s
}

// SetEngineFamily sets the EngineFamily field's value.
func (s *CreateDBProxyInput) SetEngineFamily(v string) *CreateDBProxyInput {
	s.EngineFamily = &v
	return s
}

// SetIdleClientTimeout sets the IdleClientTimeout field's value.
func (s *CreateDBProxyInput) SetIdleClientTimeout(v int64) *CreateDBProxyInput {
	s.IdleClientTimeout = &v
	return s
}

// SetRequireTLS sets the RequireTLS field's value.
func (s *CreateDBProxyInput) SetRequireTLS(v bool) *CreateDBProxyInput {
	s.RequireTLS = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDBProxyInput) SetRoleArn(v string) *CreateDBProxyInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBProxyInput) SetTags(v []*Tag) *CreateDBProxyInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBProxyInput) SetVpcSecurityGroupIds(v []*string) *CreateDBProxyInput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *CreateDBProxyInput) SetVpcSubnetIds(v []*string) *CreateDBProxyInput {
	s.VpcSubnetIds = v
	return s
}

type CreateDBProxyOutput struct {
	_ struct{} `type:"structure"`

	// The DBProxy structure corresponding to the new proxy.
	DBProxy *DBProxy `type:"structure"`
}

// String returns the string representation
func (s CreateDBProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBProxyOutput) GoString() string {
	return s.String()
}

// SetDBProxy sets the DBProxy field's value.
func (s *CreateDBProxyOutput) SetDBProxy(v *DBProxy) *CreateDBProxyOutput {
	s.DBProxy = v
	return s
}

type CreateDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB security group.
	//
	// DBSecurityGroupDescription is a required field
	DBSecurityGroupDescription *string `type:"string" required:"true"`

	// The name for the DB security group. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// Example: mysecuritygroup
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`

	// Tags to assign to the DB security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSecurityGroupInput"}
	if s.DBSecurityGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupDescription"))
	}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupDescription sets the DBSecurityGroupDescription field's value.
func (s *CreateDBSecurityGroupInput) SetDBSecurityGroupDescription(v string) *CreateDBSecurityGroupInput {
	s.DBSecurityGroupDescription = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *CreateDBSecurityGroupInput) SetDBSecurityGroupName(v string) *CreateDBSecurityGroupInput {
	s.DBSecurityGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSecurityGroupInput) SetTags(v []*Tag) *CreateDBSecurityGroupInput {
	s.Tags = v
	return s
}

type CreateDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB security group.
	//
	// This data type is used as a response element in the DescribeDBSecurityGroups
	// action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetDBSecurityGroup sets the DBSecurityGroup field's value.
func (s *CreateDBSecurityGroupOutput) SetDBSecurityGroup(v *DBSecurityGroup) *CreateDBSecurityGroupOutput {
	s.DBSecurityGroup = v
	return s
}

type CreateDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB instance that you want to create the snapshot of.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBInstance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The identifier for the DB snapshot.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSnapshotInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBSnapshotInput) SetDBInstanceIdentifier(v string) *CreateDBSnapshotInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *CreateDBSnapshotInput) SetDBSnapshotIdentifier(v string) *CreateDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSnapshotInput) SetTags(v []*Tag) *CreateDBSnapshotInput {
	s.Tags = v
	return s
}

type CreateDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB snapshot.
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *CreateDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *CreateDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

type CreateDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	//
	// DBSubnetGroupDescription is a required field
	DBSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
	// spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 Subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// Tags to assign to the DB subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSubnetGroupInput"}
	if s.DBSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupDescription"))
	}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupName(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateDBSubnetGroupInput) SetSubnetIds(v []*string) *CreateDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSubnetGroupInput) SetTags(v []*Tag) *CreateDBSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB subnet group.
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *CreateDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *CreateDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to activate the subscription. If the event
	// notification subscription isn't activated, the subscription is created but
	// not active.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType in the Events
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
	// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
	// action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// The list of identifiers of the event sources for which events are returned.
	// If not specified, then all sources are included in the response. An identifier
	// must begin with a letter and must contain only ASCII letters, digits, and
	// hyphens. It can't end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//    * If SourceIds are supplied, SourceType must also be provided.
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that is generating the events. For example, if you want
	// to be notified of events generated by a DB instance, you would set this parameter
	// to db-instance. if this value isn't specified, all events are returned.
	//
	// Valid values: db-instance | db-cluster | db-parameter-group | db-security-group
	// | db-snapshot | db-cluster-snapshot
	SourceType *string `type:"string"`

	// The name of the subscription.
	//
	// Constraints: The name must be less than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type CreateGlobalClusterInput struct {
	_ struct{} `type:"structure"`

	// The name for your database of up to 64 alpha-numeric characters. If you do
	// not provide a name, Amazon Aurora will not create a database in the global
	// database cluster you are creating.
	DatabaseName *string `type:"string"`

	// The deletion protection setting for the new global database. The global database
	// can't be deleted when deletion protection is enabled.
	DeletionProtection *bool `type:"boolean"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// The engine version of the Aurora global database.
	EngineVersion *string `type:"string"`

	// The cluster identifier of the new global database cluster.
	GlobalClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) to use as the primary cluster of the global
	// database. This parameter is optional.
	SourceDBClusterIdentifier *string `type:"string"`

	// The storage encryption setting for the new global database cluster.
	StorageEncrypted *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateGlobalClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalClusterInput) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateGlobalClusterInput) SetDatabaseName(v string) *CreateGlobalClusterInput {
	s.DatabaseName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateGlobalClusterInput) SetDeletionProtection(v bool) *CreateGlobalClusterInput {
	s.DeletionProtection = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateGlobalClusterInput) SetEngine(v string) *CreateGlobalClusterInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateGlobalClusterInput) SetEngineVersion(v string) *CreateGlobalClusterInput {
	s.EngineVersion = &v
	return s
}

// SetGlobalClusterIdentifier sets the GlobalClusterIdentifier field's value.
func (s *CreateGlobalClusterInput) SetGlobalClusterIdentifier(v string) *CreateGlobalClusterInput {
	s.GlobalClusterIdentifier = &v
	return s
}

// SetSourceDBClusterIdentifier sets the SourceDBClusterIdentifier field's value.
func (s *CreateGlobalClusterInput) SetSourceDBClusterIdentifier(v string) *CreateGlobalClusterInput {
	s.SourceDBClusterIdentifier = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateGlobalClusterInput) SetStorageEncrypted(v bool) *CreateGlobalClusterInput {
	s.StorageEncrypted = &v
	return s
}

type CreateGlobalClusterOutput struct {
	_ struct{} `type:"structure"`

	// A data type representing an Aurora global database.
	GlobalCluster *GlobalCluster `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalClusterOutput) GoString() string {
	return s.String()
}

// SetGlobalCluster sets the GlobalCluster field's value.
func (s *CreateGlobalClusterOutput) SetGlobalCluster(v *GlobalCluster) *CreateGlobalClusterOutput {
	s.GlobalCluster = v
	return s
}

type CreateOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the engine that this option group should be associated
	// with.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// Specifies the major version of the engine that this option group should be
	// associated with.
	//
	// MajorEngineVersion is a required field
	MajorEngineVersion *string `type:"string" required:"true"`

	// The description of the option group.
	//
	// OptionGroupDescription is a required field
	OptionGroupDescription *string `type:"string" required:"true"`

	// Specifies the name of the option group to be created.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: myoptiongroup
	//
	// OptionGroupName is a required field
	OptionGroupName *string `type:"string" required:"true"`

	// Tags to assign to the option group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOptionGroupInput"}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.MajorEngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorEngineVersion"))
	}
	if s.OptionGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupDescription"))
	}
	if s.OptionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *CreateOptionGroupInput) SetEngineName(v string) *CreateOptionGroupInput {
	s.EngineName = &v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *CreateOptionGroupInput) SetMajorEngineVersion(v string) *CreateOptionGroupInput {
	s.MajorEngineVersion = &v
	return s
}

// SetOptionGroupDescription sets the OptionGroupDescription field's value.
func (s *CreateOptionGroupInput) SetOptionGroupDescription(v string) *CreateOptionGroupInput {
	s.OptionGroupDescription = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateOptionGroupInput) SetOptionGroupName(v string) *CreateOptionGroupInput {
	s.OptionGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOptionGroupInput) SetTags(v []*Tag) *CreateOptionGroupInput {
	s.Tags = v
	return s
}

type CreateOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CreateOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupOutput) GoString() string {
	return s.String()
}

// SetOptionGroup sets the OptionGroup field's value.
func (s *CreateOptionGroupOutput) SetOptionGroup(v *OptionGroup) *CreateOptionGroupOutput {
	s.OptionGroup = v
	return s
}

// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with
// a VMware vSphere cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
type CustomAvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The identifier of the custom AZ.
	//
	// Amazon RDS generates a unique identifier when a custom AZ is created.
	CustomAvailabilityZoneId *string `type:"string"`

	// The name of the custom AZ.
	CustomAvailabilityZoneName *string `type:"string"`

	// The status of the custom AZ.
	CustomAvailabilityZoneStatus *string `type:"string"`

	// Information about the virtual private network (VPN) between the VMware vSphere
	// cluster and the AWS website.
	VpnDetails *VpnDetails `type:"structure"`
}

// String returns the string representation
func (s CustomAvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomAvailabilityZone) GoString() string {
	return s.String()
}

// SetCustomAvailabilityZoneId sets the CustomAvailabilityZoneId field's value.
func (s *CustomAvailabilityZone) SetCustomAvailabilityZoneId(v string) *CustomAvailabilityZone {
	s.CustomAvailabilityZoneId = &v
	return s
}

// SetCustomAvailabilityZoneName sets the CustomAvailabilityZoneName field's value.
func (s *CustomAvailabilityZone) SetCustomAvailabilityZoneName(v string) *CustomAvailabilityZone {
	s.CustomAvailabilityZoneName = &v
	return s
}

// SetCustomAvailabilityZoneStatus sets the CustomAvailabilityZoneStatus field's value.
func (s *CustomAvailabilityZone) SetCustomAvailabilityZoneStatus(v string) *CustomAvailabilityZone {
	s.CustomAvailabilityZoneStatus = &v
	return s
}

// SetVpnDetails sets the VpnDetails field's value.
func (s *CustomAvailabilityZone) SetVpnDetails(v *VpnDetails) *CustomAvailabilityZone {
	s.VpnDetails = v
	return s
}

// Contains the details of an Amazon Aurora DB cluster.
//
// This data type is used as a response element in the DescribeDBClusters, StopDBCluster,
// and StartDBCluster actions.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Kinesis data stream used for the database activity
	// stream.
	ActivityStreamKinesisStreamName *string `type:"string"`

	// The AWS KMS key identifier used for encrypting messages in the database activity
	// stream.
	ActivityStreamKmsKeyId *string `type:"string"`

	// The mode of the database activity stream. Database events such as a change
	// or access generate an activity stream event. The database session can handle
	// these events either synchronously or asynchronously.
	ActivityStreamMode *string `type:"string" enum:"ActivityStreamMode"`

	// The status of the database activity stream.
	ActivityStreamStatus *string `type:"string" enum:"ActivityStreamStatus"`

	// For all database engines except Amazon Aurora, AllocatedStorage specifies
	// the allocated storage size in gibibytes (GiB). For Aurora, AllocatedStorage
	// always returns 1, because Aurora DB cluster storage size isn't fixed, but
	// instead automatically adjusts as needed.
	AllocatedStorage *int64 `type:"integer"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []*DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// can be created.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of change records stored for Backtrack.
	BacktrackConsumedChangeRecords *int64 `type:"long"`

	// The target backtrack window, in seconds. If this value is set to 0, backtracking
	// is disabled for the DB cluster. Otherwise, backtracking is enabled.
	BacktrackWindow *int64 `type:"long"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The current capacity of an Aurora Serverless DB cluster. The capacity is
	// 0 (zero) when the cluster is paused.
	//
	// For more information about Aurora Serverless, see Using Amazon Aurora Serverless
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	Capacity *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string `type:"string"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies whether tags are copied from the DB cluster to snapshots of the
	// DB cluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// Specifies whether the DB cluster is a clone of a DB cluster owned by a different
	// AWS account.
	CrossAccountClone *bool `type:"boolean"`

	// Identifies all custom endpoints associated with the cluster.
	CustomEndpoints []*string `type:"list"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []*DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []*DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// Indicates if the DB cluster has deletion protection enabled. The database
	// can't be deleted when deletion protection is enabled.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory Domain membership records associated with the DB cluster.
	DomainMemberships []*DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// The earliest time to which a DB cluster can be backtracked.
	EarliestBacktrackTime *time.Time `type:"timestamp"`

	// The earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp"`

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	//
	// Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html)
	// in the Amazon Aurora User Guide.
	EnabledCloudwatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery,
	// global, or multimaster.
	//
	// global engine mode only applies for global database clusters created with
	// Aurora MySQL version 5.6.10a. For higher Aurora MySQL versions, the clusters
	// in a global database use provisioned engine mode. To check if a DB cluster
	// is part of a global database, use DescribeGlobalClusters instead of checking
	// the EngineMode return value from DescribeDBClusters.
	EngineMode *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// A value that indicates whether the HTTP endpoint for an Aurora Serverless
	// DB cluster is enabled.
	//
	// When enabled, the HTTP endpoint provides a connectionless web service API
	// for running SQL queries on the Aurora Serverless DB cluster. You can also
	// query your database from inside the RDS console with the query editor.
	//
	// For more information, see Using the Data API for Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
	// in the Amazon Aurora User Guide.
	HttpEndpointEnabled *bool `type:"boolean"`

	// A value that indicates whether the mapping of AWS Identity and Access Management
	// (IAM) accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is enabled, the AWS KMS key identifier for the encrypted
	// DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Contains one or more identifiers of the read replicas associated with this
	// DB cluster.
	ReadReplicaIdentifiers []*string `locationNameList:"ReadReplicaIdentifier" type:"list"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Aurora Replicas that are available in
	// a DB cluster. As clients request new connections to the reader endpoint,
	// Aurora distributes the connection requests among the Aurora Replicas in the
	// DB cluster. This functionality can help balance your read workload across
	// multiple Aurora Replicas in your DB cluster.
	//
	// If a failover occurs, and the Aurora Replica that you are connected to is
	// promoted to be the primary instance, your connection is dropped. To continue
	// sending your read workload to other Aurora Replicas in the cluster, you can
	// then reconnect to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Contains the identifier of the source DB cluster if this DB cluster is a
	// read replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// Shows the scaling configuration for an Aurora DB cluster in serverless DB
	// engine mode.
	//
	// For more information, see Using Amazon Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	ScalingConfigurationInfo *ScalingConfigurationInfo `type:"structure"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBCluster) GoString() string {
	return s.String()
}

// SetActivityStreamKinesisStreamName sets the ActivityStreamKinesisStreamName field's value.
func (s *DBCluster) SetActivityStreamKinesisStreamName(v string) *DBCluster {
	s.ActivityStreamKinesisStreamName = &v
	return s
}

// SetActivityStreamKmsKeyId sets the ActivityStreamKmsKeyId field's value.
func (s *DBCluster) SetActivityStreamKmsKeyId(v string) *DBCluster {
	s.ActivityStreamKmsKeyId = &v
	return s
}

// SetActivityStreamMode sets the ActivityStreamMode field's value.
func (s *DBCluster) SetActivityStreamMode(v string) *DBCluster {
	s.ActivityStreamMode = &v
	return s
}

// SetActivityStreamStatus sets the ActivityStreamStatus field's value.
func (s *DBCluster) SetActivityStreamStatus(v string) *DBCluster {
	s.ActivityStreamStatus = &v
	return s
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBCluster) SetAllocatedStorage(v int64) *DBCluster {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *DBCluster) SetAssociatedRoles(v []*DBClusterRole) *DBCluster {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBCluster) SetAvailabilityZones(v []*string) *DBCluster {
	s.AvailabilityZones = v
	return s
}

// SetBacktrackConsumedChangeRecords sets the BacktrackConsumedChangeRecords field's value.
func (s *DBCluster) SetBacktrackConsumedChangeRecords(v int64) *DBCluster {
	s.BacktrackConsumedChangeRecords = &v
	return s
}

// SetBacktrackWindow sets the BacktrackWindow field's value.
func (s *DBCluster) SetBacktrackWindow(v int64) *DBCluster {
	s.BacktrackWindow = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBCluster) SetBackupRetentionPeriod(v int64) *DBCluster {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *DBCluster) SetCapacity(v int64) *DBCluster {
	s.Capacity = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBCluster) SetCharacterSetName(v string) *DBCluster {
	s.CharacterSetName = &v
	return s
}

// SetCloneGroupId sets the CloneGroupId field's value.
func (s *DBCluster) SetCloneGroupId(v string) *DBCluster {
	s.CloneGroupId = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBCluster) SetClusterCreateTime(v time.Time) *DBCluster {
	s.ClusterCreateTime = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *DBCluster) SetCopyTagsToSnapshot(v bool) *DBCluster {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetCrossAccountClone sets the CrossAccountClone field's value.
func (s *DBCluster) SetCrossAccountClone(v bool) *DBCluster {
	s.CrossAccountClone = &v
	return s
}

// SetCustomEndpoints sets the CustomEndpoints field's value.
func (s *DBCluster) SetCustomEndpoints(v []*string) *DBCluster {
	s.CustomEndpoints = v
	return s
}

// SetDBClusterArn sets the DBClusterArn field's value.
func (s *DBCluster) SetDBClusterArn(v string) *DBCluster {
	s.DBClusterArn = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBCluster) SetDBClusterIdentifier(v string) *DBCluster {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterMembers sets the DBClusterMembers field's value.
func (s *DBCluster) SetDBClusterMembers(v []*DBClusterMember) *DBCluster {
	s.DBClusterMembers = v
	return s
}

// SetDBClusterOptionGroupMemberships sets the DBClusterOptionGroupMemberships field's value.
func (s *DBCluster) SetDBClusterOptionGroupMemberships(v []*DBClusterOptionGroupStatus) *DBCluster {
	s.DBClusterOptionGroupMemberships = v
	return s
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *DBCluster) SetDBClusterParameterGroup(v string) *DBCluster {
	s.DBClusterParameterGroup = &v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBCluster) SetDBSubnetGroup(v string) *DBCluster {
	s.DBSubnetGroup = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DBCluster) SetDatabaseName(v string) *DBCluster {
	s.DatabaseName = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *DBCluster) SetDbClusterResourceId(v string) *DBCluster {
	s.DbClusterResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *DBCluster) SetDeletionProtection(v bool) *DBCluster {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *DBCluster) SetDomainMemberships(v []*DomainMembership) *DBCluster {
	s.DomainMemberships = v
	return s
}

// SetEarliestBacktrackTime sets the EarliestBacktrackTime field's value.
func (s *DBCluster) SetEarliestBacktrackTime(v time.Time) *DBCluster {
	s.EarliestBacktrackTime = &v
	return s
}

// SetEarliestRestorableTime sets the EarliestRestorableTime field's value.
func (s *DBCluster) SetEarliestRestorableTime(v time.Time) *DBCluster {
	s.EarliestRestorableTime = &v
	return s
}

// SetEnabledCloudwatchLogsExports sets the EnabledCloudwatchLogsExports field's value.
func (s *DBCluster) SetEnabledCloudwatchLogsExports(v []*string) *DBCluster {
	s.EnabledCloudwatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBCluster) SetEndpoint(v string) *DBCluster {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBCluster) SetEngine(v string) *DBCluster {
	s.Engine = &v
	return s
}

// SetEngineMode sets the EngineMode field's value.
func (s *DBCluster) SetEngineMode(v string) *DBCluster {
	s.EngineMode = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBCluster) SetEngineVersion(v string) *DBCluster {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DBCluster) SetHostedZoneId(v string) *DBCluster {
	s.HostedZoneId = &v
	return s
}

// SetHttpEndpointEnabled sets the HttpEndpointEnabled field's value.
func (s *DBCluster) SetHttpEndpointEnabled(v bool) *DBCluster {
	s.HttpEndpointEnabled = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBCluster) SetIAMDatabaseAuthenticationEnabled(v bool) *DBCluster {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBCluster) SetKmsKeyId(v string) *DBCluster {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBCluster) SetLatestRestorableTime(v time.Time) *DBCluster {
	s.LatestRestorableTime = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBCluster) SetMasterUsername(v string) *DBCluster {
	s.MasterUsername = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBCluster) SetMultiAZ(v bool) *DBCluster {
	s.MultiAZ = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBCluster) SetPercentProgress(v string) *DBCluster {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBCluster) SetPort(v int64) *DBCluster {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBCluster) SetPreferredBackupWindow(v string) *DBCluster {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBCluster) SetPreferredMaintenanceWindow(v string) *DBCluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReadReplicaIdentifiers sets the ReadReplicaIdentifiers field's value.
func (s *DBCluster) SetReadReplicaIdentifiers(v []*string) *DBCluster {
	s.ReadReplicaIdentifiers = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *DBCluster) SetReaderEndpoint(v string) *DBCluster {
	s.ReaderEndpoint = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *DBCluster) SetReplicationSourceIdentifier(v string) *DBCluster {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetScalingConfigurationInfo sets the ScalingConfigurationInfo field's value.
func (s *DBCluster) SetScalingConfigurationInfo(v *ScalingConfigurationInfo) *DBCluster {
	s.ScalingConfigurationInfo = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBCluster) SetStatus(v string) *DBCluster {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBCluster) SetStorageEncrypted(v bool) *DBCluster {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBCluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBCluster {
	s.VpcSecurityGroups = v
	return s
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
//    * CreateDBClusterEndpoint
//
//    * DescribeDBClusterEndpoints
//
//    * ModifyDBClusterEndpoint
//
//    * DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon RDS DB instance endpoints,
// see Endpoint.
type DBClusterEndpoint struct {
	_ struct{} `type:"structure"`

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string `type:"string"`

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string `type:"string"`

	// The identifier associated with the endpoint. This parameter is stored as
	// a lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// A unique system-generated identifier for an endpoint. It remains the same
	// for the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// The DNS address of the endpoint.
	Endpoint *string `type:"string"`

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []*string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []*string `type:"list"`

	// The current status of the endpoint. One of: creating, available, deleting,
	// modifying.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterEndpoint) GoString() string {
	return s.String()
}

// SetCustomEndpointType sets the CustomEndpointType field's value.
func (s *DBClusterEndpoint) SetCustomEndpointType(v string) *DBClusterEndpoint {
	s.CustomEndpointType = &v
	return s
}

// SetDBClusterEndpointArn sets the DBClusterEndpointArn field's value.
func (s *DBClusterEndpoint) SetDBClusterEndpointArn(v string) *DBClusterEndpoint {
	s.DBClusterEndpointArn = &v
	return s
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *DBClusterEndpoint) SetDBClusterEndpointIdentifier(v string) *DBClusterEndpoint {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// SetDBClusterEndpointResourceIdentifier sets the DBClusterEndpointResourceIdentifier field's value.
func (s *DBClusterEndpoint) SetDBClusterEndpointResourceIdentifier(v string) *DBClusterEndpoint {
	s.DBClusterEndpointResourceIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBClusterEndpoint) SetDBClusterIdentifier(v string) *DBClusterEndpoint {
	s.DBClusterIdentifier = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBClusterEndpoint) SetEndpoint(v string) *DBClusterEndpoint {
	s.Endpoint = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DBClusterEndpoint) SetEndpointType(v string) *DBClusterEndpoint {
	s.EndpointType = &v
	return s
}

// SetExcludedMembers sets the ExcludedMembers field's value.
func (s *DBClusterEndpoint) SetExcludedMembers(v []*string) *DBClusterEndpoint {
	s.ExcludedMembers = v
	return s
}

// SetStaticMembers sets the StaticMembers field's value.
func (s *DBClusterEndpoint) SetStaticMembers(v []*string) *DBClusterEndpoint {
	s.StaticMembers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterEndpoint) SetStatus(v string) *DBClusterEndpoint {
	s.Status = &v
	return s
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see Fault Tolerance for an Aurora DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterMember) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupStatus sets the DBClusterParameterGroupStatus field's value.
func (s *DBClusterMember) SetDBClusterParameterGroupStatus(v string) *DBClusterMember {
	s.DBClusterParameterGroupStatus = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBClusterMember) SetDBInstanceIdentifier(v string) *DBClusterMember {
	s.DBInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *DBClusterMember) SetIsClusterWriter(v bool) *DBClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBClusterMember) SetPromotionTier(v int64) *DBClusterMember {
	s.PromotionTier = &v
	return s
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterOptionGroupStatus) GoString() string {
	return s.String()
}

// SetDBClusterOptionGroupName sets the DBClusterOptionGroupName field's value.
func (s *DBClusterOptionGroupStatus) SetDBClusterOptionGroupName(v string) *DBClusterOptionGroupStatus {
	s.DBClusterOptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterOptionGroupStatus) SetStatus(v string) *DBClusterOptionGroupStatus {
	s.Status = &v
	return s
}

// Contains the details of an Amazon RDS DB cluster parameter group.
//
// This data type is used as a response element in the DescribeDBClusterParameterGroups
// action.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupArn sets the DBClusterParameterGroupArn field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupArn(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupArn = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBClusterParameterGroup) SetDBParameterGroupFamily(v string) *DBClusterParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBClusterParameterGroup) SetDescription(v string) *DBClusterParameterGroup {
	s.Description = &v
	return s
}

type DBClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters or numbers.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroupNameMessage) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroupNameMessage {
	s.DBClusterParameterGroupName = &v
	return s
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the AWS Identity and Access Management
	// (IAM) role. For the list of supported feature names, see DBEngineVersion.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - the IAM role ARN is associated with the DB cluster, but the
	//    DB cluster is unable to assume the IAM role in order to access other AWS
	//    services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterRole) GoString() string {
	return s.String()
}

// SetFeatureName sets the FeatureName field's value.
func (s *DBClusterRole) SetFeatureName(v string) *DBClusterRole {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBClusterRole) SetRoleArn(v string) *DBClusterRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterRole) SetStatus(v string) *DBClusterRole {
	s.Status = &v
	return s
}

// Contains the details for an Amazon RDS DB cluster snapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots
// action.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// snapshot can be restored.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise,
	// a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshot) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBClusterSnapshot) SetAllocatedStorage(v int64) *DBClusterSnapshot {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBClusterSnapshot) SetAvailabilityZones(v []*string) *DBClusterSnapshot {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBClusterSnapshot) SetClusterCreateTime(v time.Time) *DBClusterSnapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotArn sets the DBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotArn = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBClusterSnapshot) SetEngine(v string) *DBClusterSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBClusterSnapshot) SetEngineVersion(v string) *DBClusterSnapshot {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBClusterSnapshot) SetIAMDatabaseAuthenticationEnabled(v bool) *DBClusterSnapshot {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBClusterSnapshot) SetKmsKeyId(v string) *DBClusterSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBClusterSnapshot) SetLicenseModel(v string) *DBClusterSnapshot {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBClusterSnapshot) SetMasterUsername(v string) *DBClusterSnapshot {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBClusterSnapshot) SetPercentProgress(v int64) *DBClusterSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBClusterSnapshot) SetPort(v int64) *DBClusterSnapshot {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBClusterSnapshot) SetSnapshotCreateTime(v time.Time) *DBClusterSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBClusterSnapshot) SetSnapshotType(v string) *DBClusterSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBClusterSnapshotArn sets the SourceDBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetSourceDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.SourceDBClusterSnapshotArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterSnapshot) SetStatus(v string) *DBClusterSnapshot {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBClusterSnapshot) SetStorageEncrypted(v bool) *DBClusterSnapshot {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBClusterSnapshot) SetVpcId(v string) *DBClusterSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeName(v string) *DBClusterSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeValues(v []*string) *DBClusterSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
// API action.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to copy or restore a manual DB cluster snapshot. For more information, see
// the ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []*DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the manual DB cluster snapshot that the attributes apply
	// to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributes sets the DBClusterSnapshotAttributes field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotAttributes(v []*DBClusterSnapshotAttribute) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotAttributes = v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API isn't specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to CloudWatch
	// Logs.
	ExportableLogTypes []*string `type:"list"`

	// The status of the DB engine version, either available or deprecated.
	Status *string `type:"string"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance action.
	SupportedCharacterSets []*CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of the supported DB engine modes.
	//
	// global engine mode only applies for global database clusters created with
	// Aurora MySQL version 5.6.10a. For higher Aurora MySQL versions, the clusters
	// in a global database use provisioned engine mode.
	SupportedEngineModes []*string `type:"list"`

	// A list of features supported by the DB engine. Supported feature names include
	// the following.
	//
	//    * s3Import
	SupportedFeatureNames []*string `type:"list"`

	// A list of the time zones supported by this engine for the Timezone parameter
	// of the CreateDBInstance action.
	SupportedTimezones []*Timezone `locationNameList:"Timezone" type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// Indicates whether the database engine version supports read replicas.
	SupportsReadReplica *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []*UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBEngineVersion) GoString() string {
	return s.String()
}

// SetDBEngineDescription sets the DBEngineDescription field's value.
func (s *DBEngineVersion) SetDBEngineDescription(v string) *DBEngineVersion {
	s.DBEngineDescription = &v
	return s
}

// SetDBEngineVersionDescription sets the DBEngineVersionDescription field's value.
func (s *DBEngineVersion) SetDBEngineVersionDescription(v string) *DBEngineVersion {
	s.DBEngineVersionDescription = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBEngineVersion) SetDBParameterGroupFamily(v string) *DBEngineVersion {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultCharacterSet sets the DefaultCharacterSet field's value.
func (s *DBEngineVersion) SetDefaultCharacterSet(v *CharacterSet) *DBEngineVersion {
	s.DefaultCharacterSet = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBEngineVersion) SetEngine(v string) *DBEngineVersion {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBEngineVersion) SetEngineVersion(v string) *DBEngineVersion {
	s.EngineVersion = &v
	return s
}

// SetExportableLogTypes sets the ExportableLogTypes field's value.
func (s *DBEngineVersion) SetExportableLogTypes(v []*string) *DBEngineVersion {
	s.ExportableLogTypes = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBEngineVersion) SetStatus(v string) *DBEngineVersion {
	s.Status = &v
	return s
}

// SetSupportedCharacterSets sets the SupportedCharacterSets field's value.
func (s *DBEngineVersion) SetSupportedCharacterSets(v []*CharacterSet) *DBEngineVersion {
	s.SupportedCharacterSets = v
	return s
}

// SetSupportedEngineModes sets the SupportedEngineModes field's value.
func (s *DBEngineVersion) SetSupportedEngineModes(v []*string) *DBEngineVersion {
	s.SupportedEngineModes = v
	return s
}

// SetSupportedFeatureNames sets the SupportedFeatureNames field's value.
func (s *DBEngineVersion) SetSupportedFeatureNames(v []*string) *DBEngineVersion {
	s.SupportedFeatureNames = v
	return s
}

// SetSupportedTimezones sets the SupportedTimezones field's value.
func (s *DBEngineVersion) SetSupportedTimezones(v []*Timezone) *DBEngineVersion {
	s.SupportedTimezones = v
	return s
}

// SetSupportsLogExportsToCloudwatchLogs sets the SupportsLogExportsToCloudwatchLogs field's value.
func (s *DBEngineVersion) SetSupportsLogExportsToCloudwatchLogs(v bool) *DBEngineVersion {
	s.SupportsLogExportsToCloudwatchLogs = &v
	return s
}

// SetSupportsReadReplica sets the SupportsReadReplica field's value.
func (s *DBEngineVersion) SetSupportsReadReplica(v bool) *DBEngineVersion {
	s.SupportsReadReplica = &v
	return s
}

// SetValidUpgradeTarget sets the ValidUpgradeTarget field's value.
func (s *DBEngineVersion) SetValidUpgradeTarget(v []*UpgradeTarget) *DBEngineVersion {
	s.ValidUpgradeTarget = v
	return s
}

// Contains the details of an Amazon RDS DB instance.
//
// This data type is used as a response element in the DescribeDBInstances action.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gibibytes.
	AllocatedStorage *int64 `type:"integer"`

	// The AWS Identity and Access Management (IAM) roles associated with the DB
	// instance.
	AssociatedRoles []*DBInstanceRole `locationNameList:"DBInstanceRole" type:"list"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	//
	// Amazon Aurora
	//
	// Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting
	// this value for an Aurora DB instance has no effect on the DB cluster setting.
	// For more information, see DBCluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	//
	// For information about DB instance statuses, see DB Instance Status (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Status.html)
	// in the Amazon RDS User Guide.
	DBInstanceStatus *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Type: String
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []*DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// A list of DB security group elements containing DBSecurityGroup.Name and
	// DBSecurityGroup.Status subelements.
	DBSecurityGroups []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates if the DB instance has deletion protection enabled. The database
	// can't be deleted when deletion protection is enabled. For more information,
	// see Deleting a DB Instance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory Domain membership records associated with the DB instance.
	DomainMemberships []*DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	//
	// Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html)
	// in the Amazon RDS User Guide.
	EnabledCloudwatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher. To enable IAM database authentication for Aurora,
	//    see DBCluster Type.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Specifies the listener connection endpoint for SQL Server Always On.
	ListenerEndpoint *Endpoint `type:"structure"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The upper limit to which Amazon RDS can automatically scale the storage of
	// the DB instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics
	// to Amazon CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []*OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// True if Performance Insights is enabled for the DB instance, and otherwise
	// false.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The amount of time, in days, to retain Performance Insights data. Valid values
	// are 7 or 731 (2 years).
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see Fault Tolerance for an Aurora DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// Contains one or more identifiers of Aurora DB clusters to which the RDS DB
	// instance is replicated as a read replica. For example, when you create an
	// Aurora read replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster
	// for the Aurora read replica is shown. This output does not contain information
	// about cross region Aurora read replicas.
	//
	// Currently, each RDS DB instance can have only one Aurora read replica.
	ReadReplicaDBClusterIdentifiers []*string `locationNameList:"ReadReplicaDBClusterIdentifier" type:"list"`

	// Contains one or more identifiers of the read replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a read replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a read replica. If the instance isn't a read replica, this
	// is blank.
	StatusInfos []*DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB instance. In most cases, the Timezone element is
	// empty. Timezone content appears only for Microsoft SQL Server DB instances
	// that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstance) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBInstance) SetAllocatedStorage(v int64) *DBInstance {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *DBInstance) SetAssociatedRoles(v []*DBInstanceRole) *DBInstance {
	s.AssociatedRoles = v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *DBInstance) SetAutoMinorVersionUpgrade(v bool) *DBInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBInstance) SetAvailabilityZone(v string) *DBInstance {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBInstance) SetBackupRetentionPeriod(v int64) *DBInstance {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *DBInstance) SetCACertificateIdentifier(v string) *DBInstance {
	s.CACertificateIdentifier = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBInstance) SetCharacterSetName(v string) *DBInstance {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *DBInstance) SetCopyTagsToSnapshot(v bool) *DBInstance {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBInstance) SetDBClusterIdentifier(v string) *DBInstance {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceArn sets the DBInstanceArn field's value.
func (s *DBInstance) SetDBInstanceArn(v string) *DBInstance {
	s.DBInstanceArn = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DBInstance) SetDBInstanceClass(v string) *DBInstance {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBInstance) SetDBInstanceIdentifier(v string) *DBInstance {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBInstanceStatus sets the DBInstanceStatus field's value.
func (s *DBInstance) SetDBInstanceStatus(v string) *DBInstance {
	s.DBInstanceStatus = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *DBInstance) SetDBName(v string) *DBInstance {
	s.DBName = &v
	return s
}

// SetDBParameterGroups sets the DBParameterGroups field's value.
func (s *DBInstance) SetDBParameterGroups(v []*DBParameterGroupStatus) *DBInstance {
	s.DBParameterGroups = v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *DBInstance) SetDBSecurityGroups(v []*DBSecurityGroupMembership) *DBInstance {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBInstance) SetDBSubnetGroup(v *DBSubnetGroup) *DBInstance {
	s.DBSubnetGroup = v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *DBInstance) SetDbInstancePort(v int64) *DBInstance {
	s.DbInstancePort = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBInstance) SetDbiResourceId(v string) *DBInstance {
	s.DbiResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *DBInstance) SetDeletionProtection(v bool) *DBInstance {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *DBInstance) SetDomainMemberships(v []*DomainMembership) *DBInstance {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudwatchLogsExports sets the EnabledCloudwatchLogsExports field's value.
func (s *DBInstance) SetEnabledCloudwatchLogsExports(v []*string) *DBInstance {
	s.EnabledCloudwatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBInstance) SetEndpoint(v *Endpoint) *DBInstance {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBInstance) SetEngine(v string) *DBInstance {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBInstance) SetEngineVersion(v string) *DBInstance {
	s.EngineVersion = &v
	return s
}

// SetEnhancedMonitoringResourceArn sets the EnhancedMonitoringResourceArn field's value.
func (s *DBInstance) SetEnhancedMonitoringResourceArn(v string) *DBInstance {
	s.EnhancedMonitoringResourceArn = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBInstance) SetIAMDatabaseAuthenticationEnabled(v bool) *DBInstance {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBInstance) SetInstanceCreateTime(v time.Time) *DBInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBInstance) SetIops(v int64) *DBInstance {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBInstance) SetKmsKeyId(v string) *DBInstance {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBInstance) SetLatestRestorableTime(v time.Time) *DBInstance {
	s.LatestRestorableTime = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBInstance) SetLicenseModel(v string) *DBInstance {
	s.LicenseModel = &v
	return s
}

// SetListenerEndpoint sets the ListenerEndpoint field's value.
func (s *DBInstance) SetListenerEndpoint(v *Endpoint) *DBInstance {
	s.ListenerEndpoint = v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBInstance) SetMasterUsername(v string) *DBInstance {
	s.MasterUsername = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *DBInstance) SetMaxAllocatedStorage(v int64) *DBInstance {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *DBInstance) SetMonitoringInterval(v int64) *DBInstance {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *DBInstance) SetMonitoringRoleArn(v string) *DBInstance {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBInstance) SetMultiAZ(v bool) *DBInstance {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupMemberships sets the OptionGroupMemberships field's value.
func (s *DBInstance) SetOptionGroupMemberships(v []*OptionGroupMembership) *DBInstance {
	s.OptionGroupMemberships = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *DBInstance) SetPendingModifiedValues(v *PendingModifiedValues) *DBInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPerformanceInsightsEnabled sets the PerformanceInsightsEnabled field's value.
func (s *DBInstance) SetPerformanceInsightsEnabled(v bool) *DBInstance {
	s.PerformanceInsightsEnabled = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *DBInstance) SetPerformanceInsightsKMSKeyId(v string) *DBInstance {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPerformanceInsightsRetentionPeriod sets the PerformanceInsightsRetentionPeriod field's value.
func (s *DBInstance) SetPerformanceInsightsRetentionPeriod(v int64) *DBInstance {
	s.PerformanceInsightsRetentionPeriod = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBInstance) SetPreferredBackupWindow(v string) *DBInstance {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBInstance) SetPreferredMaintenanceWindow(v string) *DBInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *DBInstance) SetProcessorFeatures(v []*ProcessorFeature) *DBInstance {
	s.ProcessorFeatures = v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBInstance) SetPromotionTier(v int64) *DBInstance {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DBInstance) SetPubliclyAccessible(v bool) *DBInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetReadReplicaDBClusterIdentifiers sets the ReadReplicaDBClusterIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBClusterIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBClusterIdentifiers = v
	return s
}

// SetReadReplicaDBInstanceIdentifiers sets the ReadReplicaDBInstanceIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBInstanceIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBInstanceIdentifiers = v
	return s
}

// SetReadReplicaSourceDBInstanceIdentifier sets the ReadReplicaSourceDBInstanceIdentifier field's value.
func (s *DBInstance) SetReadReplicaSourceDBInstanceIdentifier(v string) *DBInstance {
	s.ReadReplicaSourceDBInstanceIdentifier = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *DBInstance) SetSecondaryAvailabilityZone(v string) *DBInstance {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *DBInstance) SetStatusInfos(v []*DBInstanceStatusInfo) *DBInstance {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBInstance) SetStorageEncrypted(v bool) *DBInstance {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstance) SetStorageType(v string) *DBInstance {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBInstance) SetTdeCredentialArn(v string) *DBInstance {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBInstance) SetTimezone(v string) *DBInstance {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBInstance {
	s.VpcSecurityGroups = v
	return s
}

// An automated backup of a DB instance. It it consists of system backups, transaction
// logs, and the database instance properties that existed at the time you deleted
// the source instance.
type DBInstanceAutomatedBackup struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// The Availability Zone that the automated backup was created in. For information
	// on AWS Regions and Availability Zones, see Regions and Availability Zones
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	AvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) for the automated backup.
	DBInstanceArn *string `type:"string"`

	// The customer id of the instance that is/was associated with the automated
	// backup.
	DBInstanceIdentifier *string `type:"string"`

	// The identifier for the source DB instance, which can't be changed and which
	// is unique to an AWS Region.
	DbiResourceId *string `type:"string"`

	// Specifies whether the automated backup is encrypted.
	Encrypted *bool `type:"boolean"`

	// The name of the database engine for this automated backup.
	Engine *string `type:"string"`

	// The version of the database engine for the automated backup.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time that the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// The IOPS (I/O operations per second) value for the automated backup.
	Iops *int64 `type:"integer"`

	// The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	KmsKeyId *string `type:"string"`

	// License model information for the automated backup.
	LicenseModel *string `type:"string"`

	// The license model of an automated backup.
	MasterUsername *string `type:"string"`

	// The option group the automated backup is associated with. If omitted, the
	// default option group for the engine specified is used.
	OptionGroupName *string `type:"string"`

	// The port number that the automated backup used for connections.
	//
	// Default: Inherits from the source DB instance
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The AWS Region associated with the automated backup.
	Region *string `type:"string"`

	// Earliest and latest time an instance can be restored to.
	RestoreWindow *RestoreWindow `type:"structure"`

	// Provides a list of status information for an automated backup:
	//
	//    * active - automated backups for current instances
	//
	//    * retained - automated backups for deleted instances
	//
	//    * creating - automated backups that are waiting for the first automated
	//    snapshot to be available.
	Status *string `type:"string"`

	// Specifies the storage type associated with the automated backup.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the automated backup is associated
	// for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the automated backup. In most cases, the Timezone element
	// is empty. Timezone content appears only for Microsoft SQL Server DB instances
	// that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides the VPC ID associated with the DB instance
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceAutomatedBackup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceAutomatedBackup) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBInstanceAutomatedBackup) SetAllocatedStorage(v int64) *DBInstanceAutomatedBackup {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBInstanceAutomatedBackup) SetAvailabilityZone(v string) *DBInstanceAutomatedBackup {
	s.AvailabilityZone = &v
	return s
}

// SetDBInstanceArn sets the DBInstanceArn field's value.
func (s *DBInstanceAutomatedBackup) SetDBInstanceArn(v string) *DBInstanceAutomatedBackup {
	s.DBInstanceArn = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBInstanceAutomatedBackup) SetDBInstanceIdentifier(v string) *DBInstanceAutomatedBackup {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBInstanceAutomatedBackup) SetDbiResourceId(v string) *DBInstanceAutomatedBackup {
	s.DbiResourceId = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *DBInstanceAutomatedBackup) SetEncrypted(v bool) *DBInstanceAutomatedBackup {
	s.Encrypted = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBInstanceAutomatedBackup) SetEngine(v string) *DBInstanceAutomatedBackup {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBInstanceAutomatedBackup) SetEngineVersion(v string) *DBInstanceAutomatedBackup {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBInstanceAutomatedBackup) SetIAMDatabaseAuthenticationEnabled(v bool) *DBInstanceAutomatedBackup {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBInstanceAutomatedBackup) SetInstanceCreateTime(v time.Time) *DBInstanceAutomatedBackup {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBInstanceAutomatedBackup) SetIops(v int64) *DBInstanceAutomatedBackup {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBInstanceAutomatedBackup) SetKmsKeyId(v string) *DBInstanceAutomatedBackup {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBInstanceAutomatedBackup) SetLicenseModel(v string) *DBInstanceAutomatedBackup {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBInstanceAutomatedBackup) SetMasterUsername(v string) *DBInstanceAutomatedBackup {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DBInstanceAutomatedBackup) SetOptionGroupName(v string) *DBInstanceAutomatedBackup {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBInstanceAutomatedBackup) SetPort(v int64) *DBInstanceAutomatedBackup {
	s.Port = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DBInstanceAutomatedBackup) SetRegion(v string) *DBInstanceAutomatedBackup {
	s.Region = &v
	return s
}

// SetRestoreWindow sets the RestoreWindow field's value.
func (s *DBInstanceAutomatedBackup) SetRestoreWindow(v *RestoreWindow) *DBInstanceAutomatedBackup {
	s.RestoreWindow = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceAutomatedBackup) SetStatus(v string) *DBInstanceAutomatedBackup {
	s.Status = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstanceAutomatedBackup) SetStorageType(v string) *DBInstanceAutomatedBackup {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBInstanceAutomatedBackup) SetTdeCredentialArn(v string) *DBInstanceAutomatedBackup {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBInstanceAutomatedBackup) SetTimezone(v string) *DBInstanceAutomatedBackup {
	s.Timezone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBInstanceAutomatedBackup) SetVpcId(v string) *DBInstanceAutomatedBackup {
	s.VpcId = &v
	return s
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB instance.
type DBInstanceRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the AWS Identity and Access Management
	// (IAM) role. For the list of supported feature names, see DBEngineVersion.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB instance and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - the IAM role ARN is associated with the DB instance, but the
	//    DB instance is unable to assume the IAM role in order to access other
	//    AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceRole) GoString() string {
	return s.String()
}

// SetFeatureName sets the FeatureName field's value.
func (s *DBInstanceRole) SetFeatureName(v string) *DBInstanceRole {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBInstanceRole) SetRoleArn(v string) *DBInstanceRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceRole) SetStatus(v string) *DBInstanceRole {
	s.Status = &v
	return s
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// isn't in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, replication stop point set, replication stop point reached,
	// error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DBInstanceStatusInfo) SetMessage(v string) *DBInstanceStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *DBInstanceStatusInfo) SetNormal(v bool) *DBInstanceStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceStatusInfo) SetStatus(v string) *DBInstanceStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *DBInstanceStatusInfo) SetStatusType(v string) *DBInstanceStatusInfo {
	s.StatusType = &v
	return s
}

// Contains the details of an Amazon RDS DB parameter group.
//
// This data type is used as a response element in the DescribeDBParameterGroups
// action.
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroup) GoString() string {
	return s.String()
}

// SetDBParameterGroupArn sets the DBParameterGroupArn field's value.
func (s *DBParameterGroup) SetDBParameterGroupArn(v string) *DBParameterGroup {
	s.DBParameterGroupArn = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBParameterGroup) SetDBParameterGroupFamily(v string) *DBParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroup) SetDBParameterGroupName(v string) *DBParameterGroup {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBParameterGroup) SetDescription(v string) *DBParameterGroup {
	s.Description = &v
	return s
}

// Contains the result of a successful invocation of the ModifyDBParameterGroup
// or ResetDBParameterGroup action.
type DBParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroupNameMessage) SetDBParameterGroupName(v string) *DBParameterGroupNameMessage {
	s.DBParameterGroupName = &v
	return s
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * CreateDBInstanceReadReplica
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupStatus) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroupStatus) SetDBParameterGroupName(v string) *DBParameterGroupStatus {
	s.DBParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *DBParameterGroupStatus) SetParameterApplyStatus(v string) *DBParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// The data structure representing a proxy managed by the RDS Proxy.
//
// This data type is used as a response element in the DescribeDBProxies action.
type DBProxy struct {
	_ struct{} `type:"structure"`

	// One or more data structures specifying the authorization mechanism to connect
	// to the associated RDS DB instance or Aurora DB cluster.
	Auth []*UserAuthConfigInfo `type:"list"`

	// The date and time when the proxy was first created.
	CreatedDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the proxy.
	DBProxyArn *string `type:"string"`

	// The identifier for the proxy. This name must be unique for all proxies owned
	// by your AWS account in the specified AWS Region.
	DBProxyName *string `type:"string"`

	// Whether the proxy includes detailed information about SQL statements in its
	// logs. This information helps you to debug issues involving SQL behavior or
	// the performance and scalability of the proxy connections. The debug information
	// includes the text of SQL statements that you submit through the proxy. Thus,
	// only enable this setting when needed for debugging, and only when you have
	// security measures in place to safeguard any sensitive information that appears
	// in the logs.
	DebugLogging *bool `type:"boolean"`

	// The endpoint that you can use to connect to the proxy. You include the endpoint
	// value in the connection string for a database client application.
	Endpoint *string `type:"string"`

	// The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
	EngineFamily *string `type:"string"`

	// The number of seconds a connection to the proxy can have no activity before
	// the proxy drops the client connection. The proxy keeps the underlying database
	// connection open and puts it back into the connection pool for reuse by later
	// connection requests.
	//
	// Default: 1800 (30 minutes)
	//
	// Constraints: 1 to 28,800
	IdleClientTimeout *int64 `type:"integer"`

	// Indicates whether Transport Layer Security (TLS) encryption is required for
	// connections to the proxy.
	RequireTLS *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access
	// Amazon Secrets Manager.
	RoleArn *string `type:"string"`

	// The current status of this proxy. A status of available means the proxy is
	// ready to handle requests. Other values indicate that you must wait for the
	// proxy to be ready, or take some action to resolve an issue.
	Status *string `type:"string" enum:"DBProxyStatus"`

	// The date and time when the proxy was last updated.
	UpdatedDate *time.Time `type:"timestamp"`

	// Provides a list of VPC security groups that the proxy belongs to.
	VpcSecurityGroupIds []*string `type:"list"`

	// The EC2 subnet IDs for the proxy.
	VpcSubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s DBProxy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBProxy) GoString() string {
	return s.String()
}

// SetAuth sets the Auth field's value.
func (s *DBProxy) SetAuth(v []*UserAuthConfigInfo) *DBProxy {
	s.Auth = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DBProxy) SetCreatedDate(v time.Time) *DBProxy {
	s.CreatedDate = &v
	return s
}

// SetDBProxyArn sets the DBProxyArn field's value.
func (s *DBProxy) SetDBProxyArn(v string) *DBProxy {
	s.DBProxyArn = &v
	return s
}

// SetDBProxyName sets the DBProxyName field's value.
func (s *DBProxy) SetDBProxyName(v string) *DBProxy {
	s.DBProxyName = &v
	return s
}

// SetDebugLogging sets the DebugLogging field's value.
func (s *DBProxy) SetDebugLogging(v bool) *DBProxy {
	s.DebugLogging = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBProxy) SetEndpoint(v string) *DBProxy {
	s.Endpoint = &v
	return s
}

// SetEngineFamily sets the EngineFamily field's value.
func (s *DBProxy) SetEngineFamily(v string) *DBProxy {
	s.EngineFamily = &v
	return s
}

// SetIdleClientTimeout sets the IdleClientTimeout field's value.
func (s *DBProxy) SetIdleClientTimeout(v int64) *DBProxy {
	s.IdleClientTimeout = &v
	return s
}

// SetRequireTLS sets the RequireTLS field's value.
func (s *DBProxy) SetRequireTLS(v bool) *DBProxy {
	s.RequireTLS = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBProxy) SetRoleArn(v string) *DBProxy {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBProxy) SetStatus(v string) *DBProxy {
	s.Status = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *DBProxy) SetUpdatedDate(v time.Time) *DBProxy {
	s.UpdatedDate = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *DBProxy) SetVpcSecurityGroupIds(v []*string) *DBProxy {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *DBProxy) SetVpcSubnetIds(v []*string) *DBProxy {
	s.VpcSubnetIds = v
	return s
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Contains the details for an RDS Proxy target. It represents an RDS DB instance
// or Aurora DB cluster that the proxy can connect to. One or more targets are
// associated with an RDS Proxy target group.
//
// This data type is used as a response element in the DescribeDBProxyTargets
// action.
type DBProxyTarget struct {
	_ struct{} `type:"structure"`

	// The writer endpoint for the RDS DB instance or Aurora DB cluster.
	Endpoint *string `type:"string"`

	// The port that the RDS Proxy uses to connect to the target RDS DB instance
	// or Aurora DB cluster.
	Port *int64 `type:"integer"`

	// The identifier representing the target. It can be the instance identifier
	// for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.
	RdsResourceId *string `type:"string"`

	// The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
	TargetArn *string `type:"string"`

	// Information about the connection health of the RDS Proxy target.
	TargetHealth *TargetHealth `type:"structure"`

	// The DB cluster identifier when the target represents an Aurora DB cluster.
	// This field is blank when the target represents an RDS DB instance.
	TrackedClusterId *string `type:"string"`

	// Specifies the kind of database, such as an RDS DB instance or an Aurora DB
	// cluster, that the target represents.
	Type *string `type:"string" enum:"TargetType"`
}

// String returns the string representation
func (s DBProxyTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBProxyTarget) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBProxyTarget) SetEndpoint(v string) *DBProxyTarget {
	s.Endpoint = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBProxyTarget) SetPort(v int64) *DBProxyTarget {
	s.Port = &v
	return s
}

// SetRdsResourceId sets the RdsResourceId field's value.
func (s *DBProxyTarget) SetRdsResourceId(v string) *DBProxyTarget {
	s.RdsResourceId = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *DBProxyTarget) SetTargetArn(v string) *DBProxyTarget {
	s.TargetArn = &v
	return s
}

// SetTargetHealth sets the TargetHealth field's value.
func (s *DBProxyTarget) SetTargetHealth(v *TargetHealth) *DBProxyTarget {
	s.TargetHealth = v
	return s
}

// SetTrackedClusterId sets the TrackedClusterId field's value.
func (s *DBProxyTarget) SetTrackedClusterId(v string) *DBProxyTarget {
	s.TrackedClusterId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DBProxyTarget) SetType(v string) *DBProxyTarget {
	s.Type = &v
	return s
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Represents a set of RDS DB instances, Aurora DB clusters, or both that a
// proxy can connect to. Currently, each target group is associated with exactly
// one RDS DB instance or Aurora DB cluster.
//
// This data type is used as a response element in the DescribeDBProxyTargetGroups
// action.
type DBProxyTargetGroup struct {
	_ struct{} `type:"structure"`

	// The settings that determine the size and behavior of the connection pool
	// for the target group.
	ConnectionPoolConfig *ConnectionPoolConfigurationInfo `type:"structure"`

	// The date and time when the target group was first created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for the RDS proxy associated with this target group.
	DBProxyName *string `type:"string"`

	// Whether this target group is the first one used for connection requests by
	// the associated proxy. Because each proxy is currently associated with a single
	// target group, currently this setting is always true.
	IsDefault *bool `type:"boolean"`

	// The current status of this target group. A status of available means the
	// target group is correctly associated with a database. Other values indicate
	// that you must wait for the target group to be ready, or take some action
	// to resolve an issue.
	Status *string `type:"string"`

	// The Amazon Resource Name (ARN) representing the target group.
	TargetGroupArn *string `type:"string"`

	// The identifier for the target group. This name must be unique for all target
	// groups owned by your AWS account in the specified AWS Region.
	TargetGroupName *string `type:"string"`

	// The date and time when the target group was last updated.
	UpdatedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DBProxyTargetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBProxyTargetGroup) GoString() string {
	return s.String()
}

// SetConnectionPoolConfig sets the ConnectionPoolConfig field's value.
func (s *DBProxyTargetGroup) SetConnectionPoolConfig(v *ConnectionPoolConfigurationInfo) *DBProxyTargetGroup {
	s.ConnectionPoolConfig = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DBProxyTargetGroup) SetCreatedDate(v time.Time) *DBProxyTargetGroup {
	s.CreatedDate = &v
	return s
}

// SetDBProxyName sets the DBProxyName field's value.
func (s *DBProxyTargetGroup) SetDBProxyName(v string) *DBProxyTargetGroup {
	s.DBProxyName = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *DBProxyTargetGroup) SetIsDefault(v bool) *DBProxyTargetGroup {
	s.IsDefault = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBProxyTargetGroup) SetStatus(v string) *DBProxyTargetGroup {
	s.Status = &v
	return s
}

// SetTargetGroupArn sets the TargetGroupArn field's value.
func (s *DBProxyTargetGroup) SetTargetGroupArn(v string) *DBProxyTargetGroup {
	s.TargetGroupArn = &v
	return s
}

// SetTargetGroupName sets the TargetGroupName field's value.
func (s *DBProxyTargetGroup) SetTargetGroupName(v string) *DBProxyTargetGroup {
	s.TargetGroupName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *DBProxyTargetGroup) SetUpdatedDate(v time.Time) *DBProxyTargetGroup {
	s.UpdatedDate = &v
	return s
}

// Contains the details for an Amazon RDS DB security group.
//
// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
type DBSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB security group.
	DBSecurityGroupArn *string `type:"string"`

	// Provides the description of the DB security group.
	DBSecurityGroupDescription *string `type:"string"`

	// Specifies the name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// Contains a list of EC2SecurityGroup elements.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// Contains a list of IPRange elements.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// Provides the AWS ID of the owner of a specific DB security group.
	OwnerId *string `type:"string"`

	// Provides the VpcId of the DB security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroup) GoString() string {
	return s.String()
}

// SetDBSecurityGroupArn sets the DBSecurityGroupArn field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupArn(v string) *DBSecurityGroup {
	s.DBSecurityGroupArn = &v
	return s
}

// SetDBSecurityGroupDescription sets the DBSecurityGroupDescription field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupDescription(v string) *DBSecurityGroup {
	s.DBSecurityGroupDescription = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupName(v string) *DBSecurityGroup {
	s.DBSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroups sets the EC2SecurityGroups field's value.
func (s *DBSecurityGroup) SetEC2SecurityGroups(v []*EC2SecurityGroup) *DBSecurityGroup {
	s.EC2SecurityGroups = v
	return s
}

// SetIPRanges sets the IPRanges field's value.
func (s *DBSecurityGroup) SetIPRanges(v []*IPRange) *DBSecurityGroup {
	s.IPRanges = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *DBSecurityGroup) SetOwnerId(v string) *DBSecurityGroup {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSecurityGroup) SetVpcId(v string) *DBSecurityGroup {
	s.VpcId = &v
	return s
}

// This data type is used as a response element in the following actions:
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
//
//    * RestoreDBInstanceToPointInTime
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DBSecurityGroupMembership) SetDBSecurityGroupName(v string) *DBSecurityGroupMembership {
	s.DBSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBSecurityGroupMembership) SetStatus(v string) *DBSecurityGroupMembership {
	s.Status = &v
	return s
}

// Contains the details of an Amazon RDS DB snapshot.
//
// This data type is used as a response element in the DescribeDBSnapshots action.
type DBSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the name of the Availability Zone the DB instance was located in
	// at the time of the DB snapshot.
	AvailabilityZone *string `type:"string"`

	// Specifies the DB instance identifier of the DB instance this DB snapshot
	// was created from.
	DBInstanceIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB snapshot.
	DBSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB snapshot.
	DBSnapshotIdentifier *string `type:"string"`

	// The identifier for the source DB instance, which can't be changed and which
	// is unique to an AWS Region.
	DbiResourceId *string `type:"string"`

	// Specifies whether the DB snapshot is encrypted.
	Encrypted *bool `type:"boolean"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Specifies the version of the database engine.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Specifies the time when the snapshot was taken, in Universal Coordinated
	// Time (UTC).
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value of the DB
	// instance at the time of the snapshot.
	Iops *int64 `type:"integer"`

	// If Encrypted is true, the AWS KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string `type:"string"`

	// License model information for the restored DB instance.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB snapshot.
	MasterUsername *string `type:"string"`

	// Provides the option group name for the DB snapshot.
	OptionGroupName *string `type:"string"`

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the database engine was listening on at the time
	// of the snapshot.
	Port *int64 `type:"integer"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance when the DB snapshot was created.
	ProcessorFeatures []*ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB snapshot.
	SnapshotType *string `type:"string"`

	// The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied
	// from. It only has value in case of cross-customer or cross-region copy.
	SourceDBSnapshotIdentifier *string `type:"string"`

	// The AWS Region that the DB snapshot was created in or copied from.
	SourceRegion *string `type:"string"`

	// Specifies the status of this DB snapshot.
	Status *string `type:"string"`

	// Specifies the storage type associated with DB snapshot.
	StorageType *string `type:"string"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB snapshot. In most cases, the Timezone element is
	// empty. Timezone content appears only for snapshots taken from Microsoft SQL
	// Server DB instances that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides the VPC ID associated with the DB snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshot) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBSnapshot) SetAllocatedStorage(v int64) *DBSnapshot {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBSnapshot) SetAvailabilityZone(v string) *DBSnapshot {
	s.AvailabilityZone = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBSnapshot) SetDBInstanceIdentifier(v string) *DBSnapshot {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSnapshotArn sets the DBSnapshotArn field's value.
func (s *DBSnapshot) SetDBSnapshotArn(v string) *DBSnapshot {
	s.DBSnapshotArn = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DBSnapshot) SetDBSnapshotIdentifier(v string) *DBSnapshot {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBSnapshot) SetDbiResourceId(v string) *DBSnapshot {
	s.DbiResourceId = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *DBSnapshot) SetEncrypted(v bool) *DBSnapshot {
	s.Encrypted = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBSnapshot) SetEngine(v string) *DBSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBSnapshot) SetEngineVersion(v string) *DBSnapshot {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBSnapshot) SetIAMDatabaseAuthenticationEnabled(v bool) *DBSnapshot {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBSnapshot) SetInstanceCreateTime(v time.Time) *DBSnapshot {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBSnapshot) SetIops(v int64) *DBSnapshot {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBSnapshot) SetKmsKeyId(v string) *DBSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBSnapshot) SetLicenseModel(v string) *DBSnapshot {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBSnapshot) SetMasterUsername(v string) *DBSnapshot {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DBSnapshot) SetOptionGroupName(v string) *DBSnapshot {
	s.OptionGroupName = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBSnapshot) SetPercentProgress(v int64) *DBSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBSnapshot) SetPort(v int64) *DBSnapshot {
	s.Port = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *DBSnapshot) SetProcessorFeatures(v []*ProcessorFeature) *DBSnapshot {
	s.ProcessorFeatures = v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBSnapshot) SetSnapshotCreateTime(v time.Time) *DBSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBSnapshot) SetSnapshotType(v string) *DBSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBSnapshotIdentifier sets the SourceDBSnapshotIdentifier field's value.
func (s *DBSnapshot) SetSourceDBSnapshotIdentifier(v string) *DBSnapshot {
	s.SourceDBSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *DBSnapshot) SetSourceRegion(v string) *DBSnapshot {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBSnapshot) SetStatus(v string) *DBSnapshot {
	s.Status = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBSnapshot) SetStorageType(v string) *DBSnapshot {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBSnapshot) SetTdeCredentialArn(v string) *DBSnapshot {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBSnapshot) SetTimezone(v string) *DBSnapshot {
	s.Timezone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSnapshot) SetVpcId(v string) *DBSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual DB snapshot attribute
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API.
type DBSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value or values for the manual DB snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB snapshot. If a value of all is in the list, then the manual DB
	// snapshot is public and available for any AWS account to copy or restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBSnapshotAttribute) SetAttributeName(v string) *DBSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBSnapshotAttribute) SetAttributeValues(v []*string) *DBSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Contains the results of a successful call to the DescribeDBSnapshotAttributes
// API action.
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API action.
type DBSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB snapshot.
	DBSnapshotAttributes []*DBSnapshotAttribute `locationNameList:"DBSnapshotAttribute" type:"list"`

	// The identifier of the manual DB snapshot that the attributes apply to.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBSnapshotAttributes sets the DBSnapshotAttributes field's value.
func (s *DBSnapshotAttributesResult) SetDBSnapshotAttributes(v []*DBSnapshotAttribute) *DBSnapshotAttributesResult {
	s.DBSnapshotAttributes = v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DBSnapshotAttributesResult) SetDBSnapshotIdentifier(v string) *DBSnapshotAttributesResult {
	s.DBSnapshotIdentifier = &v
	return s
}

// Contains the details of an Amazon RDS DB subnet group.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSubnetGroup) GoString() string {
	return s.String()
}

// SetDBSubnetGroupArn sets the DBSubnetGroupArn field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupArn(v string) *DBSubnetGroup {
	s.DBSubnetGroupArn = &v
	return s
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupDescription(v string) *DBSubnetGroup {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupName(v string) *DBSubnetGroup {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *DBSubnetGroup) SetSubnetGroupStatus(v string) *DBSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *DBSubnetGroup) SetSubnets(v []*Subnet) *DBSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSubnetGroup) SetVpcId(v string) *DBSubnetGroup {
	s.VpcId = &v
	return s
}

type DeleteCustomAvailabilityZoneInput struct {
	_ struct{} `type:"structure"`

	// The custom AZ identifier.
	//
	// CustomAvailabilityZoneId is a required field
	CustomAvailabilityZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCustomAvailabilityZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomAvailabilityZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomAvailabilityZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomAvailabilityZoneInput"}
	if s.CustomAvailabilityZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomAvailabilityZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomAvailabilityZoneId sets the CustomAvailabilityZoneId field's value.
func (s *DeleteCustomAvailabilityZoneInput) SetCustomAvailabilityZoneId(v string) *DeleteCustomAvailabilityZoneInput {
	s.CustomAvailabilityZoneId = &v
	return s
}

type DeleteCustomAvailabilityZoneOutput struct {
	_ struct{} `type:"structure"`

	// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with
	// a VMware vSphere cluster.
	//
	// For more information about RDS on VMware, see the RDS on VMware User Guide.
	// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
	CustomAvailabilityZone *CustomAvailabilityZone `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomAvailabilityZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomAvailabilityZoneOutput) GoString() string {
	return s.String()
}

// SetCustomAvailabilityZone sets the CustomAvailabilityZone field's value.
func (s *DeleteCustomAvailabilityZoneOutput) SetCustomAvailabilityZone(v *CustomAvailabilityZone) *DeleteCustomAvailabilityZoneOutput {
	s.CustomAvailabilityZone = v
	return s
}

type DeleteDBClusterEndpointInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the custom endpoint. This parameter is stored
	// as a lowercase string.
	//
	// DBClusterEndpointIdentifier is a required field
	DBClusterEndpointIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterEndpointInput"}
	if s.DBClusterEndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterEndpointIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *DeleteDBClusterEndpointInput) SetDBClusterEndpointIdentifier(v string) *DeleteDBClusterEndpointInput {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
//    * CreateDBClusterEndpoint
//
//    * DescribeDBClusterEndpoints
//
//    * ModifyDBClusterEndpoint
//
//    * DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon RDS DB instance endpoints,
// see Endpoint.
type DeleteDBClusterEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string `type:"string"`

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string `type:"string"`

	// The identifier associated with the endpoint. This parameter is stored as
	// a lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// A unique system-generated identifier for an endpoint. It remains the same
	// for the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// The DNS address of the endpoint.
	Endpoint *string `type:"string"`

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []*string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []*string `type:"list"`

	// The current status of the endpoint. One of: creating, available, deleting,
	// modifying.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DeleteDBClusterEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterEndpointOutput) GoString() string {
	return s.String()
}

// SetCustomEndpointType sets the CustomEndpointType field's value.
func (s *DeleteDBClusterEndpointOutput) SetCustomEndpointType(v string) *DeleteDBClusterEndpointOutput {
	s.CustomEndpointType = &v
	return s
}

// SetDBClusterEndpointArn sets the DBClusterEndpointArn field's value.
func (s *DeleteDBClusterEndpointOutput) SetDBClusterEndpointArn(v string) *DeleteDBClusterEndpointOutput {
	s.DBClusterEndpointArn = &v
	return s
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *DeleteDBClusterEndpointOutput) SetDBClusterEndpointIdentifier(v string) *DeleteDBClusterEndpointOutput {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// SetDBClusterEndpointResourceIdentifier sets the DBClusterEndpointResourceIdentifier field's value.
func (s *DeleteDBClusterEndpointOutput) SetDBClusterEndpointResourceIdentifier(v string) *DeleteDBClusterEndpointOutput {
	s.DBClusterEndpointResourceIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DeleteDBClusterEndpointOutput) SetDBClusterIdentifier(v string) *DeleteDBClusterEndpointOutput {
	s.DBClusterIdentifier = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteDBClusterEndpointOutput) SetEndpoint(v string) *DeleteDBClusterEndpointOutput {
	s.Endpoint = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DeleteDBClusterEndpointOutput) SetEndpointType(v string) *DeleteDBClusterEndpointOutput {
	s.EndpointType = &v
	return s
}

// SetExcludedMembers sets the ExcludedMembers field's value.
func (s *DeleteDBClusterEndpointOutput) SetExcludedMembers(v []*string) *DeleteDBClusterEndpointOutput {
	s.ExcludedMembers = v
	return s
}

// SetStaticMembers sets the StaticMembers field's value.
func (s *DeleteDBClusterEndpointOutput) SetStaticMembers(v []*string) *DeleteDBClusterEndpointOutput {
	s.StaticMembers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDBClusterEndpointOutput) SetStatus(v string) *DeleteDBClusterEndpointOutput {
	s.Status = &v
	return s
}

type DeleteDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The DB cluster identifier for the DB cluster to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match an existing DBClusterIdentifier.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB cluster snapshot identifier of the new DB cluster snapshot created
	// when SkipFinalSnapshot is disabled.
	//
	// Specifying this parameter and also skipping the creation of a final DB cluster
	// snapshot with the SkipFinalShapshot parameter results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	FinalDBSnapshotIdentifier *string `type:"string"`

	// A value that indicates whether to skip the creation of a final DB cluster
	// snapshot before the DB cluster is deleted. If skip is specified, no DB cluster
	// snapshot is created. If skip isn't specified, a DB cluster snapshot is created
	// before the DB cluster is deleted. By default, skip isn't specified, and the
	// DB cluster snapshot is created. By default, this parameter is disabled.
	//
	// You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot
	// is disabled.
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DeleteDBClusterInput) SetDBClusterIdentifier(v string) *DeleteDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBClusterInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBClusterInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBClusterInput) SetSkipFinalSnapshot(v bool) *DeleteDBClusterInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Aurora DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters, StopDBCluster,
	// and StartDBCluster actions.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *DeleteDBClusterOutput) SetDBCluster(v *DBCluster) *DeleteDBClusterOutput {
	s.DBCluster = v
	return s
}

type DeleteDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB cluster parameter group.
	//
	//    * You can't delete a default DB cluster parameter group.
	//
	//    * Can't be associated with any DB clusters.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DeleteDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *DeleteDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

type DeleteDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster snapshot to delete.
	//
	// Constraints: Must be the name of an existing DB cluster snapshot in the available
	// state.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterSnapshotInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DeleteDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *DeleteDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DeleteDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *DeleteDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *DeleteDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Parameter input for the DeleteDBInstanceAutomatedBackup operation.
type DeleteDBInstanceAutomatedBackupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the source DB instance, which can't be changed and which
	// is unique to an AWS Region.
	//
	// DbiResourceId is a required field
	DbiResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBInstanceAutomatedBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceAutomatedBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBInstanceAutomatedBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBInstanceAutomatedBackupInput"}
	if s.DbiResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DbiResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DeleteDBInstanceAutomatedBackupInput) SetDbiResourceId(v string) *DeleteDBInstanceAutomatedBackupInput {
	s.DbiResourceId = &v
	return s
}

type DeleteDBInstanceAutomatedBackupOutput struct {
	_ struct{} `type:"structure"`

	// An automated backup of a DB instance. It it consists of system backups, transaction
	// logs, and the database instance properties that existed at the time you deleted
	// the source instance.
	DBInstanceAutomatedBackup *DBInstanceAutomatedBackup `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceAutomatedBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceAutomatedBackupOutput) GoString() string {
	return s.String()
}

// SetDBInstanceAutomatedBackup sets the DBInstanceAutomatedBackup field's value.
func (s *DeleteDBInstanceAutomatedBackupOutput) SetDBInstanceAutomatedBackup(v *DBInstanceAutomatedBackup) *DeleteDBInstanceAutomatedBackupOutput {
	s.DBInstanceAutomatedBackup = v
	return s
}

type DeleteDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier for the DB instance to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the name of an existing DB instance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// A value that indicates whether to remove automated backups immediately after
	// the DB instance is deleted. This parameter isn't case-sensitive. The default
	// is to remove automated backups immediately after the DB instance is deleted.
	DeleteAutomatedBackups *bool `type:"boolean"`

	// The DBSnapshotIdentifier of the new DBSnapshot created when the SkipFinalSnapshot
	// parameter is disabled.
	//
	// Specifying this parameter and also specifying to skip final DB snapshot creation
	// in SkipFinalShapshot results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	//    * Can't be specified when deleting a read replica.
	FinalDBSnapshotIdentifier *string `type:"string"`

	// A value that indicates whether to skip the creation of a final DB snapshot
	// before the DB instance is deleted. If skip is specified, no DB snapshot is
	// created. If skip isn't specified, a DB snapshot is created before the DB
	// instance is deleted. By default, skip isn't specified, and the DB snapshot
	// is created.
	//
	// When a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore',
	// or 'incompatible-network', it can only be deleted when skip is specified.
	//
	// Specify skip when deleting a read replica.
	//
	// The FinalDBSnapshotIdentifier parameter must be specified if skip isn't specified.
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DeleteDBInstanceInput) SetDBInstanceIdentifier(v string) *DeleteDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDeleteAutomatedBackups sets the DeleteAutomatedBackups field's value.
func (s *DeleteDBInstanceInput) SetDeleteAutomatedBackups(v bool) *DeleteDBInstanceInput {
	s.DeleteAutomatedBackups = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBInstanceInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBInstanceInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBInstanceInput) SetSkipFinalSnapshot(v bool) *DeleteDBInstanceInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *DeleteDBInstanceOutput) SetDBInstance(v *DBInstance) *DeleteDBInstanceOutput {
	s.DBInstance = v
	return s
}

type DeleteDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB parameter group
	//
	//    * You can't delete a default DB parameter group
	//
	//    * Can't be associated with any DB instances
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DeleteDBParameterGroupInput) SetDBParameterGroupName(v string) *DeleteDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

type DeleteDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBProxyInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB proxy to delete.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBProxyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBProxyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBProxyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBProxyInput"}
	if s.DBProxyName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBProxyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBProxyName sets the DBProxyName field's value.
func (s *DeleteDBProxyInput) SetDBProxyName(v string) *DeleteDBProxyInput {
	s.DBProxyName = &v
	return s
}

type DeleteDBProxyOutput struct {
	_ struct{} `type:"structure"`

	// The data structure representing the details of the DB proxy that you delete.
	DBProxy *DBProxy `type:"structure"`
}

// String returns the string representation
func (s DeleteDBProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBProxyOutput) GoString() string {
	return s.String()
}

// SetDBProxy sets the DBProxy field's value.
func (s *DeleteDBProxyOutput) SetDBProxy(v *DBProxy) *DeleteDBProxyOutput {
	s.DBProxy = v
	return s
}

type DeleteDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to delete.
	//
	// You can't delete the default DB security group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSecurityGroupInput"}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DeleteDBSecurityGroupInput) SetDBSecurityGroupName(v string) *DeleteDBSecurityGroupInput {
	s.DBSecurityGroupName = &v
	return s
}

type DeleteDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The DB snapshot identifier.
	//
	// Constraints: Must be the name of an existing DB snapshot in the available
	// state.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSnapshotInput"}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DeleteDBSnapshotInput) SetDBSnapshotIdentifier(v string) *DeleteDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

type DeleteDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB snapshot.
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *DeleteDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *DeleteDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You can't delete the default subnet group.
	//
	// Constraints:
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DeleteDBSubnetGroupInput) SetDBSubnetGroupName(v string) *DeleteDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the RDS event notification subscription you want to delete.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type DeleteGlobalClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier of the global database cluster being deleted.
	//
	// GlobalClusterIdentifier is a required field
	GlobalClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlobalClusterInput"}
	if s.GlobalClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalClusterIdentifier sets the GlobalClusterIdentifier field's value.
func (s *DeleteGlobalClusterInput) SetGlobalClusterIdentifier(v string) *DeleteGlobalClusterInput {
	s.GlobalClusterIdentifier = &v
	return s
}

type DeleteGlobalClusterOutput struct {
	_ struct{} `type:"structure"`

	// A data type representing an Aurora global database.
	GlobalCluster *GlobalCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteGlobalClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalClusterOutput) GoString() string {
	return s.String()
}

// SetGlobalCluster sets the GlobalCluster field's value.
func (s *DeleteGlobalClusterOutput) SetGlobalCluster(v *GlobalCluster) *DeleteGlobalClusterOutput {
	s.GlobalCluster = v
	return s
}

type DeleteInstallationMediaInput struct {
	_ struct{} `type:"structure"`

	// The installation medium ID.
	//
	// InstallationMediaId is a required field
	InstallationMediaId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstallationMediaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstallationMediaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstallationMediaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstallationMediaInput"}
	if s.InstallationMediaId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstallationMediaId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstallationMediaId sets the InstallationMediaId field's value.
func (s *DeleteInstallationMediaInput) SetInstallationMediaId(v string) *DeleteInstallationMediaInput {
	s.InstallationMediaId = &v
	return s
}

// Contains the installation media for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
type DeleteInstallationMediaOutput struct {
	_ struct{} `type:"structure"`

	// The custom Availability Zone (AZ) that contains the installation media.
	CustomAvailabilityZoneId *string `type:"string"`

	// The DB engine.
	Engine *string `type:"string"`

	// The path to the installation medium for the DB engine.
	EngineInstallationMediaPath *string `type:"string"`

	// The engine version of the DB engine.
	EngineVersion *string `type:"string"`

	// If an installation media failure occurred, the cause of the failure.
	FailureCause *InstallationMediaFailureCause `type:"structure"`

	// The installation medium ID.
	InstallationMediaId *string `type:"string"`

	// The path to the installation medium for the operating system associated with
	// the DB engine.
	OSInstallationMediaPath *string `type:"string"`

	// The status of the installation medium.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DeleteInstallationMediaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstallationMediaOutput) GoString() string {
	return s.String()
}

// SetCustomAvailabilityZoneId sets the CustomAvailabilityZoneId field's value.
func (s *DeleteInstallationMediaOutput) SetCustomAvailabilityZoneId(v string) *DeleteInstallationMediaOutput {
	s.CustomAvailabilityZoneId = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DeleteInstallationMediaOutput) SetEngine(v string) *DeleteInstallationMediaOutput {
	s.Engine = &v
	return s
}

// SetEngineInstallationMediaPath sets the EngineInstallationMediaPath field's value.
func (s *DeleteInstallationMediaOutput) SetEngineInstallationMediaPath(v string) *DeleteInstallationMediaOutput {
	s.EngineInstallationMediaPath = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DeleteInstallationMediaOutput) SetEngineVersion(v string) *DeleteInstallationMediaOutput {
	s.EngineVersion = &v
	return s
}

// SetFailureCause sets the FailureCause field's value.
func (s *DeleteInstallationMediaOutput) SetFailureCause(v *InstallationMediaFailureCause) *DeleteInstallationMediaOutput {
	s.FailureCause = v
	return s
}

// SetInstallationMediaId sets the InstallationMediaId field's value.
func (s *DeleteInstallationMediaOutput) SetInstallationMediaId(v string) *DeleteInstallationMediaOutput {
	s.InstallationMediaId = &v
	return s
}

// SetOSInstallationMediaPath sets the OSInstallationMediaPath field's value.
func (s *DeleteInstallationMediaOutput) SetOSInstallationMediaPath(v string) *DeleteInstallationMediaOutput {
	s.OSInstallationMediaPath = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteInstallationMediaOutput) SetStatus(v string) *DeleteInstallationMediaOutput {
	s.Status = &v
	return s
}

type DeleteOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the option group to be deleted.
	//
	// You can't delete default option groups.
	//
	// OptionGroupName is a required field
	OptionGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOptionGroupInput"}
	if s.OptionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DeleteOptionGroupInput) SetOptionGroupName(v string) *DeleteOptionGroupInput {
	s.OptionGroupName = &v
	return s
}

type DeleteOptionGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupOutput) GoString() string {
	return s.String()
}

type DeregisterDBProxyTargetsInput struct {
	_ struct{} `type:"structure"`

	// One or more DB cluster identifiers.
	DBClusterIdentifiers []*string `type:"list"`

	// One or more DB instance identifiers.
	DBInstanceIdentifiers []*string `type:"list"`

	// The identifier of the DBProxy that is associated with the DBProxyTargetGroup.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`

	// The identifier of the DBProxyTargetGroup.
	TargetGroupName *string `type:"string"`
}

// String returns the string representation
func (s DeregisterDBProxyTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterDBProxyTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterDBProxyTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterDBProxyTargetsInput"}
	if s.DBProxyName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBProxyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifiers sets the DBClusterIdentifiers field's value.
func (s *DeregisterDBProxyTargetsInput) SetDBClusterIdentifiers(v []*string) *DeregisterDBProxyTargetsInput {
	s.DBClusterIdentifiers = v
	return s
}

// SetDBInstanceIdentifiers sets the DBInstanceIdentifiers field's value.
func (s *DeregisterDBProxyTargetsInput) SetDBInstanceIdentifiers(v []*string) *DeregisterDBProxyTargetsInput {
	s.DBInstanceIdentifiers = v
	return s
}

// SetDBProxyName sets the DBProxyName field's value.
func (s *DeregisterDBProxyTargetsInput) SetDBProxyName(v string) *DeregisterDBProxyTargetsInput {
	s.DBProxyName = &v
	return s
}

// SetTargetGroupName sets the TargetGroupName field's value.
func (s *DeregisterDBProxyTargetsInput) SetTargetGroupName(v string) *DeregisterDBProxyTargetsInput {
	s.TargetGroupName = &v
	return s
}

type DeregisterDBProxyTargetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterDBProxyTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterDBProxyTargetsOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// Data returned by the DescribeAccountAttributes action.
type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of AccountQuota objects. Within this list, each quota has a name,
	// a count of usage toward the quota maximum, and a maximum value for the quota.
	AccountQuotas []*AccountQuota `locationNameList:"AccountQuota" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountQuotas sets the AccountQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetAccountQuotas(v []*AccountQuota) *DescribeAccountAttributesOutput {
	s.AccountQuotas = v
	return s
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied certificate identifier. If this parameter is specified,
	// information for only the identified certificate is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match an existing CertificateIdentifier.
	CertificateIdentifier *string `type:"string"`

	// This parameter isn't currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *DescribeCertificatesInput) SetCertificateIdentifier(v string) *DescribeCertificatesInput {
	s.CertificateIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

// Data returned by the DescribeCertificates action.
type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Certificate objects for the AWS account.
	Certificates []*Certificate `locationNameList:"Certificate" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

type DescribeCustomAvailabilityZonesInput struct {
	_ struct{} `type:"structure"`

	// The custom AZ identifier. If this parameter is specified, information from
	// only the specific custom AZ is returned.
	CustomAvailabilityZoneId *string `type:"string"`

	// A filter that specifies one or more custom AZs to describe.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCustomAvailabilityZones
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCustomAvailabilityZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomAvailabilityZonesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomAvailabilityZonesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomAvailabilityZonesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomAvailabilityZoneId sets the CustomAvailabilityZoneId field's value.
func (s *DescribeCustomAvailabilityZonesInput) SetCustomAvailabilityZoneId(v string) *DescribeCustomAvailabilityZonesInput {
	s.CustomAvailabilityZoneId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeCustomAvailabilityZonesInput) SetFilters(v []*Filter) *DescribeCustomAvailabilityZonesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCustomAvailabilityZonesInput) SetMarker(v string) *DescribeCustomAvailabilityZonesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCustomAvailabilityZonesInput) SetMaxRecords(v int64) *DescribeCustomAvailabilityZonesInput {
	s.MaxRecords = &v
	return s
}

type DescribeCustomAvailabilityZonesOutput struct {
	_ struct{} `type:"structure"`

	// The list of CustomAvailabilityZone objects for the AWS account.
	CustomAvailabilityZones []*CustomAvailabilityZone `locationNameList:"CustomAvailabilityZone" type:"list"`

	// An optional pagination token provided by a previous DescribeCustomAvailabilityZones
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCustomAvailabilityZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomAvailabilityZonesOutput) GoString() string {
	return s.String()
}

// SetCustomAvailabilityZones sets the CustomAvailabilityZones field's value.
func (s *DescribeCustomAvailabilityZonesOutput) SetCustomAvailabilityZones(v []*CustomAvailabilityZone) *DescribeCustomAvailabilityZonesOutput {
	s.CustomAvailabilityZones = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCustomAvailabilityZonesOutput) SetMarker(v string) *DescribeCustomAvailabilityZonesOutput {
	s.Marker = &v
	return s
}

type DescribeDBClusterBacktracksInput struct {
	_ struct{} `type:"structure"`

	// If specified, this value is the backtrack identifier of the backtrack to
	// be described.
	//
	// Constraints:
	//
	//    * Must contain a valid universally unique identifier (UUID). For more
	//    information about UUIDs, see A Universally Unique Identifier (UUID) URN
	//    Namespace (http://www.ietf.org/rfc/rfc4122.txt).
	//
	// Example: 123e4567-e89b-12d3-a456-426655440000
	BacktrackIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster to be described. This parameter
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// A filter that specifies one or more DB clusters to describe. Supported filters
	// include the following:
	//
	//    * db-cluster-backtrack-id - Accepts backtrack identifiers. The results
	//    list includes information about only the backtracks identified by these
	//    identifiers.
	//
	//    * db-cluster-backtrack-status - Accepts any of the following backtrack
	//    status values: applying completed failed pending The results list includes
	//    information about only the backtracks identified by these values.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterBacktracks
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterBacktracksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterBacktracksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterBacktracksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterBacktracksInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBacktrackIdentifier sets the BacktrackIdentifier field's value.
func (s *DescribeDBClusterBacktracksInput) SetBacktrackIdentifier(v string) *DescribeDBClusterBacktracksInput {
	s.BacktrackIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterBacktracksInput) SetDBClusterIdentifier(v string) *DescribeDBClusterBacktracksInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterBacktracksInput) SetFilters(v []*Filter) *DescribeDBClusterBacktracksInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterBacktracksInput) SetMarker(v string) *DescribeDBClusterBacktracksInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterBacktracksInput) SetMaxRecords(v int64) *DescribeDBClusterBacktracksInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBClusterBacktracks
// action.
type DescribeDBClusterBacktracksOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of backtracks for the user.
	DBClusterBacktracks []*BacktrackDBClusterOutput `locationNameList:"DBClusterBacktrack" type:"list"`

	// A pagination token that can be used in a later DescribeDBClusterBacktracks
	// request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterBacktracksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterBacktracksOutput) GoString() string {
	return s.String()
}

// SetDBClusterBacktracks sets the DBClusterBacktracks field's value.
func (s *DescribeDBClusterBacktracksOutput) SetDBClusterBacktracks(v []*BacktrackDBClusterOutput) *DescribeDBClusterBacktracksOutput {
	s.DBClusterBacktracks = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterBacktracksOutput) SetMarker(v string) *DescribeDBClusterBacktracksOutput {
	s.Marker = &v
	return s
}

type DescribeDBClusterEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the endpoint to describe. This parameter is stored as a
	// lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// A set of name-value pairs that define which endpoints to include in the output.
	// The filters are specified as name-value pairs, in the format Name=endpoint_type,Values=endpoint_type1,endpoint_type2,....
	// Name can be one of: db-cluster-endpoint-type, db-cluster-endpoint-custom-type,
	// db-cluster-endpoint-id, db-cluster-endpoint-status. Values for the db-cluster-endpoint-type
	// filter can be one or more of: reader, writer, custom. Values for the db-cluster-endpoint-custom-type
	// filter can be one or more of: reader, any. Values for the db-cluster-endpoint-status
	// filter can be one or more of: available, creating, deleting, modifying.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterEndpoints
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterEndpointsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterEndpointIdentifier sets the DBClusterEndpointIdentifier field's value.
func (s *DescribeDBClusterEndpointsInput) SetDBClusterEndpointIdentifier(v string) *DescribeDBClusterEndpointsInput {
	s.DBClusterEndpointIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterEndpointsInput) SetDBClusterIdentifier(v string) *DescribeDBClusterEndpointsInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterEndpointsInput) SetFilters(v []*Filter) *DescribeDBClusterEndpointsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterEndpointsInput) SetMarker(v string) *DescribeDBClusterEndpointsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterEndpointsInput) SetMaxRecords(v int64) *DescribeDBClusterEndpointsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBClusterEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the endpoints associated with the cluster and matching
	// any filter conditions.
	DBClusterEndpoints []*DBClusterEndpoint `locationNameList:"DBClusterEndpointList" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterEndpoints
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterEndpointsOutput) GoString() string {
	return s.String()
}

// SetDBClusterEndpoints sets the DBClusterEndpoints field's value.
func (s *DescribeDBClusterEndpointsOutput) SetDBClusterEndpoints(v []*DBClusterEndpoint) *DescribeDBClusterEndpointsOutput {
	s.DBClusterEndpoints = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterEndpointsOutput) SetMarker(v string) *DescribeDBClusterEndpointsOutput {
	s.Marker = &v
	return s
}

type DescribeDBClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return details for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// This parameter isn't currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParameterGroupsInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBClusterParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMarker(v string) *DescribeDBClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DB cluster parameter groups.
	DBClusterParameterGroups []*DBClusterParameterGroup `locationNameList:"DBClusterParameterGroup" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroups sets the DBClusterParameterGroups field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetDBClusterParameterGroups(v []*DBClusterParameterGroup) *DescribeDBClusterParameterGroupsOutput {
	s.DBClusterParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetMarker(v string) *DescribeDBClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeDBClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return parameter details
	// for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// This parameter isn't currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A value that indicates to return only parameters for a specific source. Parameter
	// sources can be engine, service, or customer.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParametersInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParametersInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParametersInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParametersInput) SetFilters(v []*Filter) *DescribeDBClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersInput) SetMarker(v string) *DescribeDBClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParametersInput) SetMaxRecords(v int64) *DescribeDBClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBClusterParametersInput) SetSource(v string) *DescribeDBClusterParametersInput {
	s.Source = &v
	return s
}

// Provides details about a DB cluster parameter group including the parameters
// in the DB cluster parameter group.
type DescribeDBClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Provides a list of parameters for the DB cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersOutput) SetMarker(v string) *DescribeDBClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBClusterParametersOutput) SetParameters(v []*Parameter) *DescribeDBClusterParametersOutput {
	s.Parameters = v
	return s
}

type DescribeDBClusterSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB cluster snapshot to describe the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotAttributesInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotAttributesInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotAttributesInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DescribeDBClusterSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *DescribeDBClusterSnapshotAttributesOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *DescribeDBClusterSnapshotAttributesOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

type DescribeDBClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DB cluster to retrieve the list of DB cluster snapshots for.
	// This parameter can't be used in conjunction with the DBClusterSnapshotIdentifier
	// parameter. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * If supplied, must match the identifier of an existing DBCluster.
	DBClusterIdentifier *string `type:"string"`

	// A specific DB cluster snapshot identifier to describe. This parameter can't
	// be used in conjunction with the DBClusterIdentifier parameter. This value
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * If supplied, must match the identifier of an existing DBClusterSnapshot.
	//
	//    * If this identifier is for an automated snapshot, the SnapshotType parameter
	//    must also be specified.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// A filter that specifies one or more DB cluster snapshots to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs).
	//
	//    * db-cluster-snapshot-id - Accepts DB cluster snapshot identifiers.
	//
	//    * snapshot-type - Accepts types of DB cluster snapshots.
	//
	//    * engine - Accepts names of database engines.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// A value that indicates whether to include manual DB cluster snapshots that
	// are public and can be copied or restored by any AWS account. By default,
	// the public snapshots are not included.
	//
	// You can share a manual DB cluster snapshot as public by using the ModifyDBClusterSnapshotAttribute
	// API action.
	IncludePublic *bool `type:"boolean"`

	// A value that indicates whether to include shared manual DB cluster snapshots
	// from other AWS accounts that this AWS account has been given permission to
	// copy or restore. By default, these snapshots are not included.
	//
	// You can give an AWS account permission to restore a manual DB cluster snapshot
	// from another AWS account by the ModifyDBClusterSnapshotAttribute API action.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of DB cluster snapshots to be returned. You can specify one of the
	// following values:
	//
	//    * automated - Return all DB cluster snapshots that have been automatically
	//    taken by Amazon RDS for my AWS account.
	//
	//    * manual - Return all DB cluster snapshots that have been taken by my
	//    AWS account.
	//
	//    * shared - Return all manual DB cluster snapshots that have been shared
	//    to my AWS account.
	//
	//    * public - Return all DB cluster snapshots that have been marked as public.
	//
	// If you don't specify a SnapshotType value, then both automated and manual
	// DB cluster snapshots are returned. You can include shared DB cluster snapshots
	// with these results by enabling the IncludeShared parameter. You can include
	// public DB cluster snapshots with these results by enabling the IncludePublic
	// parameter.
	//
	// The IncludeShared and IncludePublic parameters don't apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter doesn't apply
	// when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
	// when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterSnapshotsInput) SetFilters(v []*Filter) *DescribeDBClusterSnapshotsInput {
	s.Filters = v
	return s
}

// SetIncludePublic sets the IncludePublic field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludePublic(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludePublic = &v
	return s
}

// SetIncludeShared sets the IncludeShared field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludeShared(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludeShared = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMarker(v string) *DescribeDBClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeDBClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeDBClusterSnapshotsInput) SetSnapshotType(v string) *DescribeDBClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// Provides a list of DB cluster snapshots for the user as the result of a call
// to the DescribeDBClusterSnapshots action.
type DescribeDBClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a list of DB cluster snapshots for the user.
	DBClusterSnapshots []*DBClusterSnapshot `locationNameList:"DBClusterSnapshot" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshots sets the DBClusterSnapshots field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetDBClusterSnapshots(v []*DBClusterSnapshot) *DescribeDBClusterSnapshotsOutput {
	s.DBClusterSnapshots = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetMarker(v string) *DescribeDBClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

type DescribeDBClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied DB cluster identifier. If this parameter is specified,
	// information from only the specific DB cluster is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * If supplied, must match an existing DBClusterIdentifier.
	DBClusterIdentifier *string `type:"string"`

	// A filter that specifies one or more DB clusters to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB clusters identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Optional Boolean parameter that specifies whether the output includes information
	// about clusters shared from other AWS accounts.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBClusters request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"stri