// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexruntimeservice

import (
	"io"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
)

const opPostContent = "PostContent"

// PostContentRequest generates a "aws/request.Request" representing the
// client's request for the PostContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostContent for more information on using the PostContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostContentRequest method.
//    req, resp := client.PostContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/PostContent
func (c *LexRuntimeService) PostContentRequest(input *PostContentInput) (req *request.Request, output *PostContentOutput) {
	op := &request.Operation{
		Name:       opPostContent,
		HTTPMethod: "POST",
		HTTPPath:   "/bot/{botName}/alias/{botAlias}/user/{userId}/content",
	}

	if input == nil {
		input = &PostContentInput{}
	}

	output = &PostContentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// PostContent API operation for Amazon Lex Runtime Service.
//
// Sends user input (text or speech) to Amazon Lex. Clients use this API to
// send text and audio requests to Amazon Lex at runtime. Amazon Lex interprets
// the user input using the machine learning model that it built for the bot.
//
// The PostContent operation supports audio input at 8kHz and 16kHz. You can
// use 8kHz audio to achieve higher speech recognition accuracy in telephone
// audio applications.
//
// In response, Amazon Lex returns the next message to convey to the user. Consider
// the following example messages:
//
//    *  For a user input "I would like a pizza," Amazon Lex might return a
//    response with a message eliciting slot data (for example, PizzaSize):
//    "What size pizza would you like?".
//
//    *  After the user provides all of the pizza order information, Amazon
//    Lex might return a response with a message to get user confirmation: "Order
//    the pizza?".
//
//    *  After the user replies "Yes" to the confirmation prompt, Amazon Lex
//    might return a conclusion statement: "Thank you, your cheese pizza has
//    been ordered.".
//
// Not all Amazon Lex messages require a response from the user. For example,
// conclusion statements do not require a response. Some messages require only
// a yes or no response. In addition to the message, Amazon Lex provides additional
// context about the message in the response that you can use to enhance client
// behavior, such as displaying the appropriate client user interface. Consider
// the following examples:
//
//    *  If the message is to elicit slot data, Amazon Lex returns the following
//    context information:
//
// x-amz-lex-dialog-state header set to ElicitSlot
//
// x-amz-lex-intent-name header set to the intent name in the current context
//
//
// x-amz-lex-slot-to-elicit header set to the slot name for which the message
//    is eliciting information
//
// x-amz-lex-slots header set to a map of slots configured for the intent with
//    their current values
//
//    *  If the message is a confirmation prompt, the x-amz-lex-dialog-state
//    header is set to Confirmation and the x-amz-lex-slot-to-elicit header
//    is omitted.
//
//    *  If the message is a clarification prompt configured for the intent,
//    indicating that the user intent is not understood, the x-amz-dialog-state
//    header is set to ElicitIntent and the x-amz-slot-to-elicit header is omitted.
//
//
// In addition, Amazon Lex also returns your application-specific sessionAttributes.
// For more information, see Managing Conversation Context (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime Service's
// API operation PostContent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (such as the Amazon Lex bot or an alias) that is referred to
//   is not found.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Request validation failed, there is no usable message in the context, or
//   the bot build failed, is still in progress, or contains unbuilt changes.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exceeded a limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Internal service error. Retry the call.
//
//   * ErrCodeConflictException "ConflictException"
//   Two clients are using the same AWS account, Amazon Lex bot, and user ID.
//
//   * ErrCodeUnsupportedMediaTypeException "UnsupportedMediaTypeException"
//   The Content-Type header (PostContent API) has an invalid value.
//
//   * ErrCodeNotAcceptableException "NotAcceptableException"
//   The accept header in the request does not have a valid value.
//
//   * ErrCodeRequestTimeoutException "RequestTimeoutException"
//   The input speech is too long.
//
//   * ErrCodeDependencyFailedException "DependencyFailedException"
//   One of the dependencies, such as AWS Lambda or Amazon Polly, threw an exception.
//   For example,
//
//      * If Amazon Lex does not have sufficient permissions to call a Lambda
//      function.
//
//      * If a Lambda function takes longer than 30 seconds to execute.
//
//      * If a fulfillment Lambda function returns a Delegate dialog action without
//      removing any slot values.
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//   Either the Amazon Lex bot is still building, or one of the dependent services
//   (Amazon Polly, AWS Lambda) failed with an internal service error.
//
//   * ErrCodeLoopDetectedException "LoopDetectedException"
//   This exception is not used.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/PostContent
func (c *LexRuntimeService) PostContent(input *PostContentInput) (*PostContentOutput, error) {
	req, out := c.PostContentRequest(input)
	return out, req.Send()
}

// PostContentWithContext is the same as PostContent with the addition of
// the ability to pass a context and additional request options.
//
// See PostContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeService) PostContentWithContext(ctx aws.Context, input *PostContentInput, opts ...request.Option) (*PostContentOutput, error) {
	req, out := c.PostContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPostText = "PostText"

// PostTextRequest generates a "aws/request.Request" representing the
// client's request for the PostText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostText for more information on using the PostText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostTextRequest method.
//    req, resp := client.PostTextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/PostText
func (c *LexRuntimeService) PostTextRequest(input *PostTextInput) (req *request.Request, output *PostTextOutput) {
	op := &request.Operation{
		Name:       opPostText,
		HTTPMethod: "POST",
		HTTPPath:   "/bot/{botName}/alias/{botAlias}/user/{userId}/text",
	}

	if input == nil {
		input = &PostTextInput{}
	}

	output = &PostTextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PostText API operation for Amazon Lex Runtime Service.
//
// Sends user input (text-only) to Amazon Lex. Client applications can use this
// API to send requests to Amazon Lex at runtime. Amazon Lex then interprets
// the user input using the machine learning model it built for the bot.
//
// In response, Amazon Lex returns the next message to convey to the user an
// optional responseCard to display. Consider the following example messages:
//
//    *  For a user input "I would like a pizza", Amazon Lex might return a
//    response with a message eliciting slot data (for example, PizzaSize):
//    "What size pizza would you like?"
//
//    *  After the user provides all of the pizza order information, Amazon
//    Lex might return a response with a message to obtain user confirmation
//    "Proceed with the pizza order?".
//
//    *  After the user replies to a confirmation prompt with a "yes", Amazon
//    Lex might return a conclusion statement: "Thank you, your cheese pizza
//    has been ordered.".
//
// Not all Amazon Lex messages require a user response. For example, a conclusion
// statement does not require a response. Some messages require only a "yes"
// or "no" user response. In addition to the message, Amazon Lex provides additional
// context about the message in the response that you might use to enhance client
// behavior, for example, to display the appropriate client user interface.
// These are the slotToElicit, dialogState, intentName, and slots fields in
// the response. Consider the following examples:
//
//    * If the message is to elicit slot data, Amazon Lex returns the following
//    context information:
//
// dialogState set to ElicitSlot
//
// intentName set to the intent name in the current context
//
// slotToElicit set to the slot name for which the message is eliciting information
//
//
// slots set to a map of slots, configured for the intent, with currently known
//    values
//
//    *  If the message is a confirmation prompt, the dialogState is set to
//    ConfirmIntent and SlotToElicit is set to null.
//
//    * If the message is a clarification prompt (configured for the intent)
//    that indicates that user intent is not understood, the dialogState is
//    set to ElicitIntent and slotToElicit is set to null.
//
// In addition, Amazon Lex also returns your application-specific sessionAttributes.
// For more information, see Managing Conversation Context (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime Service's
// API operation PostText for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (such as the Amazon Lex bot or an alias) that is referred to
//   is not found.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Request validation failed, there is no usable message in the context, or
//   the bot build failed, is still in progress, or contains unbuilt changes.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exceeded a limit.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Internal service error. Retry the call.
//
//   * ErrCodeConflictException "ConflictException"
//   Two clients are using the same AWS account, Amazon Lex bot, and user ID.
//
//   * ErrCodeDependencyFailedException "DependencyFailedException"
//   One of the dependencies, such as AWS Lambda or Amazon Polly, threw an exception.
//   For example,
//
//      * If Amazon Lex does not have sufficient permissions to call a Lambda
//      function.
//
//      * If a Lambda function takes longer than 30 seconds to execute.
//
//      * If a fulfillment Lambda function returns a Delegate dialog action without
//      removing any slot values.
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//   Either the Amazon Lex bot is still building, or one of the dependent services
//   (Amazon Polly, AWS Lambda) failed with an internal service error.
//
//   * ErrCodeLoopDetectedException "LoopDetectedException"
//   This exception is not used.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/PostText
func (c *LexRuntimeService) PostText(input *PostTextInput) (*PostTextOutput, error) {
	req, out := c.PostTextRequest(input)
	return out, req.Send()
}

// PostTextWithContext is the same as PostText with the addition of
// the ability to pass a context and additional request options.
//
// See PostText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeService) PostTextWithContext(ctx aws.Context, input *PostTextInput, opts ...request.Option) (*PostTextOutput, error) {
	req, out := c.PostTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an option to be shown on the client platform (Facebook, Slack,
// etc.)
type Button struct {
	_ struct{} `type:"structure"`

	// Text that is visible to the user on the button.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`

	// The value sent to Amazon Lex when a user chooses the button. For example,
	// consider button text "NYC." When the user chooses the button, the value sent
	// can be "New York City."
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Button) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Button) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Button) SetText(v string) *Button {
	s.Text = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Button) SetValue(v string) *Button {
	s.Value = &v
	return s
}

// Represents an option rendered to the user when a prompt is shown. It could
// be an image, a button, a link, or text.
type GenericAttachment struct {
	_ struct{} `type:"structure"`

	// The URL of an attachment to the response card.
	AttachmentLinkUrl *string `locationName:"attachmentLinkUrl" min:"1" type:"string"`

	// The list of options to show to the user.
	Buttons []*Button `locationName:"buttons" type:"list"`

	// The URL of an image that is displayed to the user.
	ImageUrl *string `locationName:"imageUrl" min:"1" type:"string"`

	// The subtitle shown below the title.
	SubTitle *string `locationName:"subTitle" min:"1" type:"string"`

	// The title of the option.
	Title *string `locationName:"title" min:"1" type:"string"`
}

// String returns the string representation
func (s GenericAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenericAttachment) GoString() string {
	return s.String()
}

// SetAttachmentLinkUrl sets the AttachmentLinkUrl field's value.
func (s *GenericAttachment) SetAttachmentLinkUrl(v string) *GenericAttachment {
	s.AttachmentLinkUrl = &v
	return s
}

// SetButtons sets the Buttons field's value.
func (s *GenericAttachment) SetButtons(v []*Button) *GenericAttachment {
	s.Buttons = v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *GenericAttachment) SetImageUrl(v string) *GenericAttachment {
	s.ImageUrl = &v
	return s
}

// SetSubTitle sets the SubTitle field's value.
func (s *GenericAttachment) SetSubTitle(v string) *GenericAttachment {
	s.SubTitle = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GenericAttachment) SetTitle(v string) *GenericAttachment {
	s.Title = &v
	return s
}

type PostContentInput struct {
	_ struct{} `type:"structure" payload:"InputStream"`

	// You pass this value as the Accept HTTP header.
	//
	// The message Amazon Lex returns in the response can be either text or speech
	// based on the Accept HTTP header value in the request.
	//
	//    *  If the value is text/plain; charset=utf-8, Amazon Lex returns text
	//    in the response.
	//
	//    *  If the value begins with audio/, Amazon Lex returns speech in the response.
	//    Amazon Lex uses Amazon Polly to generate the speech (using the configuration
	//    you specified in the Accept header). For example, if you specify audio/mpeg
	//    as the value, Amazon Lex returns speech in the MPEG format.
	//
	// The following are the accepted values:
	//
	// audio/mpeg
	//
	// audio/ogg
	//
	// audio/pcm
	//
	// text/plain; charset=utf-8
	//
	// audio/* (defaults to mpeg)
	Accept *string `location:"header" locationName:"Accept" type:"string"`

	// Alias of the Amazon Lex bot.
	//
	// BotAlias is a required field
	BotAlias *string `location:"uri" locationName:"botAlias" type:"string" required:"true"`

	// Name of the Amazon Lex bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" type:"string" required:"true"`

	// You pass this value as the Content-Type HTTP header.
	//
	// Indicates the audio format or text. The header value must start with one
	// of the following prefixes:
	//
	//    * PCM format, audio data must be in little-endian byte order.
	//
	// audio/l16; rate=16000; channels=1
	//
	// audio/x-l16; sample-rate=16000; channel-count=1
	//
	// audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
	//
	//
	//    * Opus format
	//
	// audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4
	//
	//    * Text format
	//
	// text/plain; charset=utf-8
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" required:"true"`

	// User input in PCM or Opus audio format or text format as described in the
	// Content-Type HTTP header.
	//
	// You can stream audio data to Amazon Lex or you can create a local buffer
	// that captures all of the audio data before sending. In general, you get better
	// performance if you stream audio data rather than buffering the data locally.
	//
	// InputStream is a required field
	InputStream io.ReadSeeker `locationName:"inputStream" type:"blob" required:"true"`

	// You pass this value as the x-amz-lex-request-attributes HTTP header.
	//
	// Request-specific information passed between Amazon Lex and a client application.
	// The value must be a JSON serialized and base64 encoded map with string keys
	// and values. The total size of the requestAttributes and sessionAttributes
	// headers is limited to 12 KB.
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes with the prefix x-amz-lex:.
	//
	// For more information, see Setting Request Attributes (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
	RequestAttributes aws.JSONValue `location:"header" locationName:"x-amz-lex-request-attributes" type:"jsonvalue"`

	// You pass this value as the x-amz-lex-session-attributes HTTP header.
	//
	// Application-specific information passed between Amazon Lex and a client application.
	// The value must be a JSON serialized and base64 encoded map with string keys
	// and values. The total size of the sessionAttributes and requestAttributes
	// headers is limited to 12 KB.
	//
	// For more information, see Setting Session Attributes (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
	SessionAttributes aws.JSONValue `location:"header" locationName:"x-amz-lex-session-attributes" type:"jsonvalue"`

	// The ID of the client application user. Amazon Lex uses this to identify a
	// user's conversation with your bot. At runtime, each request must contain
	// the userID field.
	//
	// To decide the user ID to use for your application, consider the following
	// factors.
	//
	//    * The userID field must not contain any personally identifiable information
	//    of the user, for example, name, personal identification numbers, or other
	//    end user personal information.
	//
	//    * If you want a user to start a conversation on one device and continue
	//    on another device, use a user-specific identifier.
	//
	//    * If you want the same user to be able to have two independent conversations
	//    on two different devices, choose a device-specific identifier.
	//
	//    * A user can't have two independent conversations with two different versions
	//    of the same bot. For example, a user can't have a conversation with the
	//    PROD and BETA versions of the same bot. If you anticipate that a user
	//    will need to have conversation with two different versions, for example,
	//    while testing, include the bot alias in the user ID to separate the two
	//    conversations.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s PostContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostContentInput"}
	if s.BotAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAlias"))
	}
	if s.BotAlias != nil && len(*s.BotAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAlias", 1))
	}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.InputStream == nil {
		invalidParams.Add(request.NewErrParamRequired("InputStream"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *PostContentInput) SetAccept(v string) *PostContentInput {
	s.Accept = &v
	return s
}

// SetBotAlias sets the BotAlias field's value.
func (s *PostContentInput) SetBotAlias(v string) *PostContentInput {
	s.BotAlias = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *PostContentInput) SetBotName(v string) *PostContentInput {
	s.BotName = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PostContentInput) SetContentType(v string) *PostContentInput {
	s.ContentType = &v
	return s
}

// SetInputStream sets the InputStream field's value.
func (s *PostContentInput) SetInputStream(v io.ReadSeeker) *PostContentInput {
	s.InputStream = v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *PostContentInput) SetRequestAttributes(v aws.JSONValue) *PostContentInput {
	s.RequestAttributes = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *PostContentInput) SetSessionAttributes(v aws.JSONValue) *PostContentInput {
	s.SessionAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *PostContentInput) SetUserId(v string) *PostContentInput {
	s.UserId = &v
	return s
}

type PostContentOutput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// The prompt (or statement) to convey to the user. This is based on the bot
	// configuration and context. For example, if Amazon Lex did not understand
	// the user intent, it sends the clarificationPrompt configured for the bot.
	// If the intent requires confirmation before taking the fulfillment action,
	// it sends the confirmationPrompt. Another example: Suppose that the Lambda
	// function successfully fulfilled the intent, and sent a message to convey
	// to the user. Then Amazon Lex sends that message in the response.
	AudioStream io.ReadCloser `locationName:"audioStream" type:"blob"`

	// Content type as specified in the Accept HTTP header in the request.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Identifies the current state of the user interaction. Amazon Lex returns
	// one of the following values as dialogState. The client can optionally use
	// this information to customize the user interface.
	//
	//    * ElicitIntent - Amazon Lex wants to elicit the user's intent. Consider
	//    the following examples:
	//
	//  For example, a user might utter an intent ("I want to order a pizza"). If
	//    Amazon Lex cannot infer the user intent from this utterance, it will return
	//    this dialog state.
	//
	//    * ConfirmIntent - Amazon Lex is expecting a "yes" or "no" response.
	//
	// For example, Amazon Lex wants user confirmation before fulfilling an intent.
	//    Instead of a simple "yes" or "no" response, a user might respond with
	//    additional information. For example, "yes, but make it a thick crust pizza"
	//    or "no, I want to order a drink." Amazon Lex can process such additional
	//    information (in these examples, update the crust type slot or change the
	//    intent from OrderPizza to OrderDrink).
	//
	//    * ElicitSlot - Amazon Lex is expecting the value of a slot for the current
	//    intent.
	//
	//  For example, suppose that in the response Amazon Lex sends this message:
	//    "What size pizza would you like?". A user might reply with the slot value
	//    (e.g., "medium"). The user might also provide additional information in
	//    the response (e.g., "medium thick crust pizza"). Amazon Lex can process
	//    such additional information appropriately.
	//
	//    * Fulfilled - Conveys that the Lambda function has successfully fulfilled
	//    the intent.
	//
	//    * ReadyForFulfillment - Conveys that the client has to fulfill the request.
	//
	//
	//    * Failed - Conveys that the conversation with the user failed.
	//
	//  This can happen for various reasons, including that the user does not provide
	//    an appropriate response to prompts from the service (you can configure
	//    how many times Amazon Lex can prompt a user for specific information),
	//    or if the Lambda function fails to fulfill the intent.
	DialogState *string `location:"header" locationName:"x-amz-lex-dialog-state" type:"string" enum:"DialogState"`

	// The text used to process the request.
	//
	// If the input was an audio stream, the inputTranscript field contains the
	// text extracted from the audio stream. This is the text that is actually processed
	// to recognize intents and slot values. You can use this information to determine
	// if Amazon Lex is correctly processing the audio that you send.
	InputTranscript *string `location:"header" locationName:"x-amz-lex-input-transcript" type:"string"`

	// Current user intent that Amazon Lex is aware of.
	IntentName *string `location:"header" locationName:"x-amz-lex-intent-name" type:"string"`

	// The message to convey to the user. The message can come from the bot's configuration
	// or from a Lambda function.
	//
	// If the intent is not configured with a Lambda function, or if the Lambda
	// function returned Delegate as the dialogAction.type its response, Amazon
	// Lex decides on the next course of action and selects an appropriate message
	// from the bot's configuration based on the current interaction context. For
	// example, if Amazon Lex isn't able to understand user input, it uses a clarification
	// prompt message.
	//
	// When you create an intent you can assign messages to groups. When messages
	// are assigned to groups Amazon Lex returns one message from each group in
	// the response. The message field is an escaped JSON string containing the
	// messages. For more information about the structure of the JSON string returned,
	// see msg-prompts-formats.
	//
	// If the Lambda function returns a message, Amazon Lex passes it to the client
	// in its response.
	Message *string `location:"header" locationName:"x-amz-lex-message" min:"1" type:"string" sensitive:"true"`

	// The format of the response message. One of the following values:
	//
	//    * PlainText - The message contains plain UTF-8 text.
	//
	//    * CustomPayload - The message is a custom format for the client.
	//
	//    * SSML - The message contains text formatted for voice output.
	//
	//    * Composite - The message contains an escaped JSON object containing one
	//    or more messages from the groups that messages were assigned to when the
	//    intent was created.
	MessageFormat *string `location:"header" locationName:"x-amz-lex-message-format" type:"string" enum:"MessageFormatType"`

	// Map of key/value pairs representing the session-specific context information.
	SessionAttributes aws.JSONValue `location:"header" locationName:"x-amz-lex-session-attributes" type:"jsonvalue"`

	// If the dialogState value is ElicitSlot, returns the name of the slot for
	// which Amazon Lex is eliciting a value.
	SlotToElicit *string `location:"header" locationName:"x-amz-lex-slot-to-elicit" type:"string"`

	// Map of zero or more intent slots (name/value pairs) Amazon Lex detected from
	// the user input during the conversation.
	//
	// Amazon Lex creates a resolution list containing likely values for a slot.
	// The value that it returns is determined by the valueSelectionStrategy selected
	// when the slot type was created or updated. If valueSelectionStrategy is set
	// to ORIGINAL_VALUE, the value provided by the user is returned, if the user
	// value is similar to the slot values. If valueSelectionStrategy is set to
	// TOP_RESOLUTION Amazon Lex returns the first value in the resolution list
	// or, if there is no resolution list, null. If you don't specify a valueSelectionStrategy,
	// the default is ORIGINAL_VALUE.
	Slots aws.JSONValue `location:"header" locationName:"x-amz-lex-slots" type:"jsonvalue"`
}

// String returns the string representation
func (s PostContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostContentOutput) GoString() string {
	return s.String()
}

// SetAudioStream sets the AudioStream field's value.
func (s *PostContentOutput) SetAudioStream(v io.ReadCloser) *PostContentOutput {
	s.AudioStream = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PostContentOutput) SetContentType(v string) *PostContentOutput {
	s.ContentType = &v
	return s
}

// SetDialogState sets the DialogState field's value.
func (s *PostContentOutput) SetDialogState(v string) *PostContentOutput {
	s.DialogState = &v
	return s
}

// SetInputTranscript sets the InputTranscript field's value.
func (s *PostContentOutput) SetInputTranscript(v string) *PostContentOutput {
	s.InputTranscript = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *PostContentOutput) SetIntentName(v string) *PostContentOutput {
	s.IntentName = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PostContentOutput) SetMessage(v string) *PostContentOutput {
	s.Message = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *PostContentOutput) SetMessageFormat(v string) *PostContentOutput {
	s.MessageFormat = &v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *PostContentOutput) SetSessionAttributes(v aws.JSONValue) *PostContentOutput {
	s.SessionAttributes = v
	return s
}

// SetSlotToElicit sets the SlotToElicit field's value.
func (s *PostContentOutput) SetSlotToElicit(v string) *PostContentOutput {
	s.SlotToElicit = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *PostContentOutput) SetSlots(v aws.JSONValue) *PostContentOutput {
	s.Slots = v
	return s
}

type PostTextInput struct {
	_ struct{} `type:"structure"`

	// The alias of the Amazon Lex bot.
	//
	// BotAlias is a required field
	BotAlias *string `location:"uri" locationName:"botAlias" type:"string" required:"true"`

	// The name of the Amazon Lex bot.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" type:"string" required:"true"`

	// The text that the user entered (Amazon Lex interprets this text).
	//
	// InputText is a required field
	InputText *string `locationName:"inputText" min:"1" type:"string" required:"true" sensitive:"true"`

	// Request-specific information passed between Amazon Lex and a client application.
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes with the prefix x-amz-lex:.
	//
	// For more information, see Setting Request Attributes (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map" sensitive:"true"`

	// Application-specific information passed between Amazon Lex and a client application.
	//
	// For more information, see Setting Session Attributes (http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map" sensitive:"true"`

	// The ID of the client application user. Amazon Lex uses this to identify a
	// user's conversation with your bot. At runtime, each request must contain
	// the userID field.
	//
	// To decide the user ID to use for your application, consider the following
	// factors.
	//
	//    * The userID field must not contain any personally identifiable information
	//    of the user, for example, name, personal identification numbers, or other
	//    end user personal information.
	//
	//    * If you want a user to start a conversation on one device and continue
	//    on another device, use a user-specific identifier.
	//
	//    * If you want the same user to be able to have two independent conversations
	//    on two different devices, choose a device-specific identifier.
	//
	//    * A user can't have two independent conversations with two different versions
	//    of the same bot. For example, a user can't have a conversation with the
	//    PROD and BETA versions of the same bot. If you anticipate that a user
	//    will need to have conversation with two different versions, for example,
	//    while testing, include the bot alias in the user ID to separate the two
	//    conversations.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s PostTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostTextInput"}
	if s.BotAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAlias"))
	}
	if s.BotAlias != nil && len(*s.BotAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAlias", 1))
	}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.InputText == nil {
		invalidParams.Add(request.NewErrParamRequired("InputText"))
	}
	if s.InputText != nil && len(*s.InputText) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputText", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAlias sets the BotAlias field's value.
func (s *PostTextInput) SetBotAlias(v string) *PostTextInput {
	s.BotAlias = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *PostTextInput) SetBotName(v string) *PostTextInput {
	s.BotName = &v
	return s
}

// SetInputText sets the InputText field's value.
func (s *PostTextInput) SetInputText(v string) *PostTextInput {
	s.InputText = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *PostTextInput) SetRequestAttributes(v map[string]*string) *PostTextInput {
	s.RequestAttributes = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *PostTextInput) SetSessionAttributes(v map[string]*string) *PostTextInput {
	s.SessionAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *PostTextInput) SetUserId(v string) *PostTextInput {
	s.UserId = &v
	return s
}

type PostTextOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the current state of the user interaction. Amazon Lex returns
	// one of the following values as dialogState. The client can optionally use
	// this information to customize the user interface.
	//
	//    * ElicitIntent - Amazon Lex wants to elicit user intent.
	//
	// For example, a user might utter an intent ("I want to order a pizza"). If
	//    Amazon Lex cannot infer the user intent from this utterance, it will return
	//    this dialogState.
	//
	//    * ConfirmIntent - Amazon Lex is expecting a "yes" or "no" response.
	//
	//  For example, Amazon Lex wants user confirmation before fulfilling an intent.
	//
	//
	// Instead of a simple "yes" or "no," a user might respond with additional information.
	//    For example, "yes, but make it thick crust pizza" or "no, I want to order
	//    a drink". Amazon Lex can process such additional information (in these
	//    examples, update the crust type slot value, or change intent from OrderPizza
	//    to OrderDrink).
	//
	//    * ElicitSlot - Amazon Lex is expecting a slot value for the current intent.
	//
	//
	// For example, suppose that in the response Amazon Lex sends this message:
	//    "What size pizza would you like?". A user might reply with the slot value
	//    (e.g., "medium"). The user might also provide additional information in
	//    the response (e.g., "medium thick crust pizza"). Amazon Lex can process
	//    such additional information appropriately.
	//
	//    * Fulfilled - Conveys that the Lambda function configured for the intent
	//    has successfully fulfilled the intent.
	//
	//    * ReadyForFulfillment - Conveys that the client has to fulfill the intent.
	//
	//
	//    * Failed - Conveys that the conversation with the user failed.
	//
	//  This can happen for various reasons including that the user did not provide
	//    an appropriate response to prompts from the service (you can configure
	//    how many times Amazon Lex can prompt a user for specific information),
	//    or the Lambda function failed to fulfill the intent.
	DialogState *string `locationName:"dialogState" type:"string" enum:"DialogState"`

	// The current user intent that Amazon Lex is aware of.
	IntentName *string `locationName:"intentName" type:"string"`

	// The message to convey to the user. The message can come from the bot's configuration
	// or from a Lambda function.
	//
	// If the intent is not configured with a Lambda function, or if the Lambda
	// function returned Delegate as the dialogAction.type its response, Amazon
	// Lex decides on the next course of action and selects an appropriate message
	// from the bot's configuration based on the current interaction context. For
	// example, if Amazon Lex isn't able to understand user input, it uses a clarification
	// prompt message.
	//
	// When you create an intent you can assign messages to groups. When messages
	// are assigned to groups Amazon Lex returns one message from each group in
	// the response. The message field is an escaped JSON string containing the
	// messages. For more information about the structure of the JSON string returned,
	// see msg-prompts-formats.
	//
	// If the Lambda function returns a message, Amazon Lex passes it to the client
	// in its response.
	Message *string `locationName:"message" min:"1" type:"string" sensitive:"true"`

	// The format of the response message. One of the following values:
	//
	//    * PlainText - The message contains plain UTF-8 text.
	//
	//    * CustomPayload - The message is a custom format defined by the Lambda
	//    function.
	//
	//    * SSML - The message contains text formatted for voice output.
	//
	//    * Composite - The message contains an escaped JSON object containing one
	//    or more messages from the groups that messages were assigned to when the
	//    intent was created.
	MessageFormat *string `locationName:"messageFormat" type:"string" enum:"MessageFormatType"`

	// Represents the options that the user has to respond to the current prompt.
	// Response Card can come from the bot configuration (in the Amazon Lex console,
	// choose the settings button next to a slot) or from a code hook (Lambda function).
	ResponseCard *ResponseCard `locationName:"responseCard" type:"structure"`

	// A map of key-value pairs representing the session-specific context information.
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map" sensitive:"true"`

	// If the dialogState value is ElicitSlot, returns the name of the slot for
	// which Amazon Lex is eliciting a value.
	SlotToElicit *string `locationName:"slotToElicit" type:"string"`

	// The intent slots that Amazon Lex detected from the user input in the conversation.
	//
	// Amazon Lex creates a resolution list containing likely values for a slot.
	// The value that it returns is determined by the valueSelectionStrategy selected
	// when the slot type was created or updated. If valueSelectionStrategy is set
	// to ORIGINAL_VALUE, the value provided by the user is returned, if the user
	// value is similar to the slot values. If valueSelectionStrategy is set to
	// TOP_RESOLUTION Amazon Lex returns the first value in the resolution list
	// or, if there is no resolution list, null. If you don't specify a valueSelectionStrategy,
	// the default is ORIGINAL_VALUE.
	Slots map[string]*string `locationName:"slots" type:"map" sensitive:"true"`
}

// String returns the string representation
func (s PostTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostTextOutput) GoString() string {
	return s.String()
}

// SetDialogState sets the DialogState field's value.
func (s *PostTextOutput) SetDialogState(v string) *PostTextOutput {
	s.DialogState = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *PostTextOutput) SetIntentName(v string) *PostTextOutput {
	s.IntentName = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PostTextOutput) SetMessage(v string) *PostTextOutput {
	s.Message = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *PostTextOutput) SetMessageFormat(v string) *PostTextOutput {
	s.MessageFormat = &v
	return s
}

// SetResponseCard sets the ResponseCard field's value.
func (s *PostTextOutput) SetResponseCard(v *ResponseCard) *PostTextOutput {
	s.ResponseCard = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *PostTextOutput) SetSessionAttributes(v map[string]*string) *PostTextOutput {
	s.SessionAttributes = v
	return s
}

// SetSlotToElicit sets the SlotToElicit field's value.
func (s *PostTextOutput) SetSlotToElicit(v string) *PostTextOutput {
	s.SlotToElicit = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *PostTextOutput) SetSlots(v map[string]*string) *PostTextOutput {
	s.Slots = v
	return s
}

// If you configure a response card when creating your bots, Amazon Lex substitutes
// the session attributes and slot values that are available, and then returns
// it. The response card can also come from a Lambda function ( dialogCodeHook
// and fulfillmentActivity on an intent).
type ResponseCard struct {
	_ struct{} `type:"structure"`

	// The content type of the response.
	ContentType *string `locationName:"contentType" type:"string" enum:"ContentType"`

	// An array of attachment objects representing options.
	GenericAttachments []*GenericAttachment `locationName:"genericAttachments" type:"list"`

	// The version of the response card format.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ResponseCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseCard) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *ResponseCard) SetContentType(v string) *ResponseCard {
	s.ContentType = &v
	return s
}

// SetGenericAttachments sets the GenericAttachments field's value.
func (s *ResponseCard) SetGenericAttachments(v []*GenericAttachment) *ResponseCard {
	s.GenericAttachments = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResponseCard) SetVersion(v string) *ResponseCard {
	s.Version = &v
	return s
}

const (
	// ContentTypeApplicationVndAmazonawsCardGeneric is a ContentType enum value
	ContentTypeApplicationVndAmazonawsCardGeneric = "application/vnd.amazonaws.card.generic"
)

const (
	// DialogStateElicitIntent is a DialogState enum value
	DialogStateElicitIntent = "ElicitIntent"

	// DialogStateConfirmIntent is a DialogState enum value
	DialogStateConfirmIntent = "ConfirmIntent"

	// DialogStateElicitSlot is a DialogState enum value
	DialogStateElicitSlot = "ElicitSlot"

	// DialogStateFulfilled is a DialogState enum value
	DialogStateFulfilled = "Fulfilled"

	// DialogStateReadyForFulfillment is a DialogState enum value
	DialogStateReadyForFulfillment = "ReadyForFulfillment"

	// DialogStateFailed is a DialogState enum value
	DialogStateFailed = "Failed"
)

const (
	// MessageFormatTypePlainText is a MessageFormatType enum value
	MessageFormatTypePlainText = "PlainText"

	// MessageFormatTypeCustomPayload is a MessageFormatType enum value
	MessageFormatTypeCustomPayload = "CustomPayload"

	// MessageFormatTypeSsml is a MessageFormatType enum value
	MessageFormatTypeSsml = "SSML"

	// MessageFormatTypeComposite is a MessageFormatType enum value
	MessageFormatTypeComposite = "Composite"
)
