// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreatePrivateDnsNamespace = "CreatePrivateDnsNamespace"

// CreatePrivateDnsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivateDnsNamespace operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrivateDnsNamespace for more information on using the CreatePrivateDnsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePrivateDnsNamespaceRequest method.
//    req, resp := client.CreatePrivateDnsNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace
func (c *ServiceDiscovery) CreatePrivateDnsNamespaceRequest(input *CreatePrivateDnsNamespaceInput) (req *request.Request, output *CreatePrivateDnsNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreatePrivateDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateDnsNamespaceInput{}
	}

	output = &CreatePrivateDnsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivateDnsNamespace API operation for Amazon Route 53 Auto Naming.
//
// Creates a private namespace based on DNS, which will be visible only inside
// a specified Amazon VPC. The namespace defines your service naming scheme.
// For example, if you name your namespace example.com and name your service
// backend, the resulting DNS name for the service will be backend.example.com.
// You can associate more than one service with the same namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation CreatePrivateDnsNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeNamespaceAlreadyExists "NamespaceAlreadyExists"
//   The namespace that you're trying to create already exists.
//
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   The resource can't be created because you've reached the limit on the number
//   of resources.
//
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace
func (c *ServiceDiscovery) CreatePrivateDnsNamespace(input *CreatePrivateDnsNamespaceInput) (*CreatePrivateDnsNamespaceOutput, error) {
	req, out := c.CreatePrivateDnsNamespaceRequest(input)
	return out, req.Send()
}

// CreatePrivateDnsNamespaceWithContext is the same as CreatePrivateDnsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateDnsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreatePrivateDnsNamespaceWithContext(ctx aws.Context, input *CreatePrivateDnsNamespaceInput, opts ...request.Option) (*CreatePrivateDnsNamespaceOutput, error) {
	req, out := c.CreatePrivateDnsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicDnsNamespace = "CreatePublicDnsNamespace"

// CreatePublicDnsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicDnsNamespace operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicDnsNamespace for more information on using the CreatePublicDnsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicDnsNamespaceRequest method.
//    req, resp := client.CreatePublicDnsNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace
func (c *ServiceDiscovery) CreatePublicDnsNamespaceRequest(input *CreatePublicDnsNamespaceInput) (req *request.Request, output *CreatePublicDnsNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreatePublicDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicDnsNamespaceInput{}
	}

	output = &CreatePublicDnsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicDnsNamespace API operation for Amazon Route 53 Auto Naming.
//
// Creates a public namespace based on DNS, which will be visible on the internet.
// The namespace defines your service naming scheme. For example, if you name
// your namespace example.com and name your service backend, the resulting DNS
// name for the service will be backend.example.com. You can associate more
// than one service with the same namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation CreatePublicDnsNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeNamespaceAlreadyExists "NamespaceAlreadyExists"
//   The namespace that you're trying to create already exists.
//
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   The resource can't be created because you've reached the limit on the number
//   of resources.
//
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace
func (c *ServiceDiscovery) CreatePublicDnsNamespace(input *CreatePublicDnsNamespaceInput) (*CreatePublicDnsNamespaceOutput, error) {
	req, out := c.CreatePublicDnsNamespaceRequest(input)
	return out, req.Send()
}

// CreatePublicDnsNamespaceWithContext is the same as CreatePublicDnsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicDnsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreatePublicDnsNamespaceWithContext(ctx aws.Context, input *CreatePublicDnsNamespaceInput, opts ...request.Option) (*CreatePublicDnsNamespaceOutput, error) {
	req, out := c.CreatePublicDnsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServiceRequest method.
//    req, resp := client.CreateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService
func (c *ServiceDiscovery) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for Amazon Route 53 Auto Naming.
//
// Creates a service, which defines a template for the following entities:
//
//    * One to five resource record sets
//
//    * Optionally, a health check
//
// After you create the service, you can submit a RegisterInstance request,
// and Amazon Route 53 uses the values in the template to create the specified
// entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation CreateService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   The resource can't be created because you've reached the limit on the number
//   of resources.
//
//   * ErrCodeNamespaceNotFound "NamespaceNotFound"
//   No namespace exists with the specified ID.
//
//   * ErrCodeServiceAlreadyExists "ServiceAlreadyExists"
//   The service can't be created because a service with the same name already
//   exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService
func (c *ServiceDiscovery) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamespaceRequest method.
//    req, resp := client.DeleteNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace
func (c *ServiceDiscovery) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for Amazon Route 53 Auto Naming.
//
// Deletes a namespace from the current account. If the namespace still contains
// one or more services, the request fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeNamespaceNotFound "NamespaceNotFound"
//   No namespace exists with the specified ID.
//
//   * ErrCodeResourceInUse "ResourceInUse"
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace
func (c *ServiceDiscovery) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceRequest method.
//    req, resp := client.DeleteServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService
func (c *ServiceDiscovery) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for Amazon Route 53 Auto Naming.
//
// Deletes a specified service. If the service still contains one or more registered
// instances, the request fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation DeleteService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
//   * ErrCodeResourceInUse "ResourceInUse"
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService
func (c *ServiceDiscovery) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterInstance = "DeregisterInstance"

// DeregisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterInstance for more information on using the DeregisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterInstanceRequest method.
//    req, resp := client.DeregisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance
func (c *ServiceDiscovery) DeregisterInstanceRequest(input *DeregisterInstanceInput) (req *request.Request, output *DeregisterInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceInput{}
	}

	output = &DeregisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterInstance API operation for Amazon Route 53 Auto Naming.
//
// Deletes the resource record sets and the health check, if any, that Amazon
// Route 53 created for the specified instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation DeregisterInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeInstanceNotFound "InstanceNotFound"
//   No instance exists with the specified ID.
//
//   * ErrCodeResourceInUse "ResourceInUse"
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance
func (c *ServiceDiscovery) DeregisterInstance(input *DeregisterInstanceInput) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	return out, req.Send()
}

// DeregisterInstanceWithContext is the same as DeregisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeregisterInstanceWithContext(ctx aws.Context, input *DeregisterInstanceInput, opts ...request.Option) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstance = "GetInstance"

// GetInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstance for more information on using the GetInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceRequest method.
//    req, resp := client.GetInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance
func (c *ServiceDiscovery) GetInstanceRequest(input *GetInstanceInput) (req *request.Request, output *GetInstanceOutput) {
	op := &request.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	output = &GetInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstance API operation for Amazon Route 53 Auto Naming.
//
// Gets information about a specified instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation GetInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNotFound "InstanceNotFound"
//   No instance exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance
func (c *ServiceDiscovery) GetInstance(input *GetInstanceInput) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	return out, req.Send()
}

// GetInstanceWithContext is the same as GetInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstanceWithContext(ctx aws.Context, input *GetInstanceInput, opts ...request.Option) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstancesHealthStatus = "GetInstancesHealthStatus"

// GetInstancesHealthStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetInstancesHealthStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstancesHealthStatus for more information on using the GetInstancesHealthStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancesHealthStatusRequest method.
//    req, resp := client.GetInstancesHealthStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus
func (c *ServiceDiscovery) GetInstancesHealthStatusRequest(input *GetInstancesHealthStatusInput) (req *request.Request, output *GetInstancesHealthStatusOutput) {
	op := &request.Operation{
		Name:       opGetInstancesHealthStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInstancesHealthStatusInput{}
	}

	output = &GetInstancesHealthStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstancesHealthStatus API operation for Amazon Route 53 Auto Naming.
//
// Gets the current health status (Healthy, Unhealthy, or Unknown) of one or
// more instances that are associated with a specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation GetInstancesHealthStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNotFound "InstanceNotFound"
//   No instance exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus
func (c *ServiceDiscovery) GetInstancesHealthStatus(input *GetInstancesHealthStatusInput) (*GetInstancesHealthStatusOutput, error) {
	req, out := c.GetInstancesHealthStatusRequest(input)
	return out, req.Send()
}

// GetInstancesHealthStatusWithContext is the same as GetInstancesHealthStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstancesHealthStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstancesHealthStatusWithContext(ctx aws.Context, input *GetInstancesHealthStatusInput, opts ...request.Option) (*GetInstancesHealthStatusOutput, error) {
	req, out := c.GetInstancesHealthStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInstancesHealthStatusPages iterates over the pages of a GetInstancesHealthStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInstancesHealthStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInstancesHealthStatus operation.
//    pageNum := 0
//    err := client.GetInstancesHealthStatusPages(params,
//        func(page *GetInstancesHealthStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) GetInstancesHealthStatusPages(input *GetInstancesHealthStatusInput, fn func(*GetInstancesHealthStatusOutput, bool) bool) error {
	return c.GetInstancesHealthStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInstancesHealthStatusPagesWithContext same as GetInstancesHealthStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstancesHealthStatusPagesWithContext(ctx aws.Context, input *GetInstancesHealthStatusInput, fn func(*GetInstancesHealthStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInstancesHealthStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInstancesHealthStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetInstancesHealthStatusOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetNamespace = "GetNamespace"

// GetNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the GetNamespace operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamespace for more information on using the GetNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamespaceRequest method.
//    req, resp := client.GetNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace
func (c *ServiceDiscovery) GetNamespaceRequest(input *GetNamespaceInput) (req *request.Request, output *GetNamespaceOutput) {
	op := &request.Operation{
		Name:       opGetNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamespaceInput{}
	}

	output = &GetNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamespace API operation for Amazon Route 53 Auto Naming.
//
// Gets information about a namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation GetNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeNamespaceNotFound "NamespaceNotFound"
//   No namespace exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace
func (c *ServiceDiscovery) GetNamespace(input *GetNamespaceInput) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	return out, req.Send()
}

// GetNamespaceWithContext is the same as GetNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetNamespaceWithContext(ctx aws.Context, input *GetNamespaceInput, opts ...request.Option) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationRequest method.
//    req, resp := client.GetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation
func (c *ServiceDiscovery) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for Amazon Route 53 Auto Naming.
//
// Gets information about any operation that returns an operation ID in the
// response, such as a CreateService request. To get a list of operations that
// match specified criteria, see ListOperations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation GetOperation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationNotFound "OperationNotFound"
//   No operation exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation
func (c *ServiceDiscovery) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRequest method.
//    req, resp := client.GetServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService
func (c *ServiceDiscovery) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for Amazon Route 53 Auto Naming.
//
// Gets the settings for a specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation GetService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService
func (c *ServiceDiscovery) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstancesRequest method.
//    req, resp := client.ListInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances
func (c *ServiceDiscovery) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for Amazon Route 53 Auto Naming.
//
// Gets summary information about the instances that you created by using a
// specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation ListInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances
func (c *ServiceDiscovery) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstances operation.
//    pageNum := 0
//    err := client.ListInstancesPages(params,
//        func(page *ListInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamespacesRequest method.
//    req, resp := client.ListNamespacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces
func (c *ServiceDiscovery) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for Amazon Route 53 Auto Naming.
//
// Gets information about the namespaces that were created by the current AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces
func (c *ServiceDiscovery) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamespaces operation.
//    pageNum := 0
//    err := client.ListNamespacesPages(params,
//        func(page *ListNamespacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListOperations = "ListOperations"

// ListOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOperations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOperations for more information on using the ListOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOperationsRequest method.
//    req, resp := client.ListOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations
func (c *ServiceDiscovery) ListOperationsRequest(input *ListOperationsInput) (req *request.Request, output *ListOperationsOutput) {
	op := &request.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	output = &ListOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOperations API operation for Amazon Route 53 Auto Naming.
//
// Lists operations that match the criteria that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation ListOperations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations
func (c *ServiceDiscovery) ListOperations(input *ListOperationsInput) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	return out, req.Send()
}

// ListOperationsWithContext is the same as ListOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListOperationsWithContext(ctx aws.Context, input *ListOperationsInput, opts ...request.Option) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOperationsPages iterates over the pages of a ListOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOperations operation.
//    pageNum := 0
//    err := client.ListOperationsPages(params,
//        func(page *ListOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListOperationsPages(input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool) error {
	return c.ListOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOperationsPagesWithContext same as ListOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListOperationsPagesWithContext(ctx aws.Context, input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListOperationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices
func (c *ServiceDiscovery) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Amazon Route 53 Auto Naming.
//
// Gets settings for all the services that are associated with one or more specified
// namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation ListServices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices
func (c *ServiceDiscovery) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListServicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opRegisterInstance = "RegisterInstance"

// RegisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterInstance for more information on using the RegisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterInstanceRequest method.
//    req, resp := client.RegisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance
func (c *ServiceDiscovery) RegisterInstanceRequest(input *RegisterInstanceInput) (req *request.Request, output *RegisterInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstanceInput{}
	}

	output = &RegisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterInstance API operation for Amazon Route 53 Auto Naming.
//
// Creates one or more resource record sets and optionally a health check based
// on the settings in a specified service. When you submit a RegisterInstance
// request, Amazon Route 53 does the following:
//
//    * Creates a resource record set for each resource record set template
//    in the service
//
//    * Creates a health check based on the settings in the health check template
//    in the service, if any
//
//    * Associates the health check, if any, with each of the resource record
//    sets
//
// One RegisterInstance request must complete before you can submit another
// request and specify the same service and instance ID.
//
// For more information, see CreateService.
//
// When Amazon Route 53 receives a DNS query for the specified DNS name, it
// returns the applicable value:
//
//    * If the health check is healthy: returns all the resource record sets
//
//    * If the health check is unhealthy: returns the IP address of the last
//    healthy instance
//
//    * If you didn't specify a health check template: returns all the resource
//    record sets
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation RegisterInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeResourceInUse "ResourceInUse"
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   The resource can't be created because you've reached the limit on the number
//   of resources.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance
func (c *ServiceDiscovery) RegisterInstance(input *RegisterInstanceInput) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	return out, req.Send()
}

// RegisterInstanceWithContext is the same as RegisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) RegisterInstanceWithContext(ctx aws.Context, input *RegisterInstanceInput, opts ...request.Option) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceRequest method.
//    req, resp := client.UpdateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService
func (c *ServiceDiscovery) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for Amazon Route 53 Auto Naming.
//
// Updates the TTL setting for a specified service. You must specify all the
// resource record set templates (and, optionally, a health check template)
// that you want to appear in the updated service. Any current resource record
// set templates (or health check template) that don't appear in an UpdateService
// request are deleted.
//
// When you update the TTL setting for a service, Amazon Route 53 also updates
// the corresponding settings in all the resource record sets and health checks
// that were created by using the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Auto Naming's
// API operation UpdateService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateRequest "DuplicateRequest"
//   This request tried to create an object that already exists.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   One or more specified values aren't valid. For example, when you're creating
//   a namespace, the value of Name might not be a valid DNS name.
//
//   * ErrCodeServiceNotFound "ServiceNotFound"
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService
func (c *ServiceDiscovery) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespaceRequest
type CreatePrivateDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace. When you create a namespace,
	// Amazon Route 53 automatically creates a hosted zone that has the same name
	// as the namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The ID of the Amazon VPC that you want to associate the namespace with.
	//
	// Vpc is a required field
	Vpc *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateDnsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateDnsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateDnsNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Vpc == nil {
		invalidParams.Add(request.NewErrParamRequired("Vpc"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreatePrivateDnsNamespaceInput) SetCreatorRequestId(v string) *CreatePrivateDnsNamespaceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePrivateDnsNamespaceInput) SetDescription(v string) *CreatePrivateDnsNamespaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePrivateDnsNamespaceInput) SetName(v string) *CreatePrivateDnsNamespaceInput {
	s.Name = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *CreatePrivateDnsNamespaceInput) SetVpc(v string) *CreatePrivateDnsNamespaceInput {
	s.Vpc = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespaceResponse
type CreatePrivateDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateDnsNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreatePrivateDnsNamespaceOutput) SetOperationId(v string) *CreatePrivateDnsNamespaceOutput {
	s.OperationId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespaceRequest
type CreatePublicDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicDnsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicDnsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicDnsNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreatePublicDnsNamespaceInput) SetCreatorRequestId(v string) *CreatePublicDnsNamespaceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePublicDnsNamespaceInput) SetDescription(v string) *CreatePublicDnsNamespaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePublicDnsNamespaceInput) SetName(v string) *CreatePublicDnsNamespaceInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespaceResponse
type CreatePublicDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicDnsNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreatePublicDnsNamespaceOutput) SetOperationId(v string) *CreatePublicDnsNamespaceOutput {
	s.OperationId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateServiceRequest
type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the service.
	Description *string `type:"string"`

	// A complex type that contains information about the resource record sets that
	// you want Amazon Route 53 to create when you register an instance.
	//
	// DnsConfig is a required field
	DnsConfig *DnsConfig `type:"structure" required:"true"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, Amazon
	// Route 53 associates the health check with all the resource record sets that
	// you specify in DnsConfig.
	//
	// The health check uses 30 seconds as the request interval. This is the number
	// of seconds between the time that each Amazon Route 53 health checker gets
	// a response from your endpoint and the time that it sends the next health
	// check request. A health checker in each data center around the world sends
	// your endpoint a health check request every 30 seconds. On average, your endpoint
	// receives a health check request about every two seconds. Health checkers
	// in different data centers don't coordinate with one another, so you'll sometimes
	// see several requests per second followed by a few seconds with no health
	// checks at all.
	//
	// For information about the charges for health checks, see Amazon Route 53
	// Pricing (http://aws.amazon.com/route53/pricing).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// The name that you want to assign to the service.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.DnsConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DnsConfig != nil {
		if err := s.DnsConfig.Validate(); err != nil {
			invalidParams.AddNested("DnsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateServiceInput) SetCreatorRequestId(v string) *CreateServiceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceInput) SetDescription(v string) *CreateServiceInput {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *CreateServiceInput) SetDnsConfig(v *DnsConfig) *CreateServiceInput {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *CreateServiceInput) SetHealthCheckConfig(v *HealthCheckConfig) *CreateServiceInput {
	s.HealthCheckConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInput) SetName(v string) *CreateServiceInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateServiceResponse
type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the new service.
	Service *Service `type:"structure"`
}

// String returns the string representation
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *CreateServiceOutput) SetService(v *Service) *CreateServiceOutput {
	s.Service = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespaceRequest
type DeleteNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the namespace that you want to delete.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNamespaceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteNamespaceInput) SetId(v string) *DeleteNamespaceInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespaceResponse
type DeleteNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s DeleteNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteNamespaceOutput) SetOperationId(v string) *DeleteNamespaceOutput {
	s.OperationId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteServiceRequest
type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to delete.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteServiceInput) SetId(v string) *DeleteServiceInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteServiceResponse
type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstanceRequest
type DeregisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for Id in the RegisterInstance request.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeregisterInstanceInput) SetInstanceId(v string) *DeregisterInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *DeregisterInstanceInput) SetServiceId(v string) *DeregisterInstanceInput {
	s.ServiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstanceResponse
type DeregisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// For more information, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s DeregisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeregisterInstanceOutput) SetOperationId(v string) *DeregisterInstanceOutput {
	s.OperationId = &v
	return s
}

// A complex type that contains information about the resource record sets that
// you want Amazon Route 53 to create when you register an instance.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsConfig
type DnsConfig struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each resource record set
	// that you want Amazon Route 53 to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []*DnsRecord `type:"list" required:"true"`

	// The ID of the namespace to use for DNS configuration.
	//
	// NamespaceId is a required field
	NamespaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DnsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsConfig"}
	if s.DnsRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsRecords"))
	}
	if s.NamespaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceId"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsRecords sets the DnsRecords field's value.
func (s *DnsConfig) SetDnsRecords(v []*DnsRecord) *DnsConfig {
	s.DnsRecords = v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *DnsConfig) SetNamespaceId(v string) *DnsConfig {
	s.NamespaceId = &v
	return s
}

// A complex type that contains information about changes to the resource record
// sets that Amazon Route 53 creates when you register an instance.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsConfigChange
type DnsConfigChange struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each resource record set
	// that you want Amazon Route 53 to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []*DnsRecord `type:"list" required:"true"`
}

// String returns the string representation
func (s DnsConfigChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsConfigChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfigChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsConfigChange"}
	if s.DnsRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsRecords"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsRecords sets the DnsRecords field's value.
func (s *DnsConfigChange) SetDnsRecords(v []*DnsRecord) *DnsConfigChange {
	s.DnsRecords = v
	return s
}

// A complex type that contains the ID for the hosted zone that Amazon Route
// 53 creates when you create a namespace.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsProperties
type DnsProperties struct {
	_ struct{} `type:"structure"`

	// The ID for the hosted zone that Amazon Route 53 creates when you create a
	// namespace.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s DnsProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsProperties) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DnsProperties) SetHostedZoneId(v string) *DnsProperties {
	s.HostedZoneId = &v
	return s
}

// A complex type that contains information about the resource record sets that
// you want Amazon Route 53 to create when you register an instance.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsRecord
type DnsRecord struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that you want DNS resolvers to cache the
	// settings for this resource record set.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The type of the resource, which indicates the value that Amazon Route 53
	// returns in response to DNS queries. The following values are supported:
	//
	//    * A: Amazon Route 53 returns the IP address of the resource in IPv4 format,
	//    such as 192.0.2.44.
	//
	//    * AAAA: Amazon Route 53 returns the IP address of the resource in IPv6
	//    format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	//    * SRV: Amazon Route 53 returns the value for an SRV record. The value
	//    for an SRV record uses the following template, which can't be changed:
	//
	// priority weight port resource-record-set-name
	//
	// The values of priority and weight are both set to 1. The value of port comes
	//    from the value that you specify for Port when you submit a RegisterInstance
	//    request.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RecordType"`
}

// String returns the string representation
func (s DnsRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsRecord"}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTTL sets the TTL field's value.
func (s *DnsRecord) SetTTL(v int64) *DnsRecord {
	s.TTL = &v
	return s
}

// SetType sets the Type field's value.
func (s *DnsRecord) SetType(v string) *DnsRecord {
	s.Type = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstanceRequest
type GetInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance that you want to get information about.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInstanceInput) SetInstanceId(v string) *GetInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetInstanceInput) SetServiceId(v string) *GetInstanceInput {
	s.ServiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstanceResponse
type GetInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about a specified instance.
	Instance *Instance `type:"structure"`
}

// String returns the string representation
func (s GetInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceOutput) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *GetInstanceOutput) SetInstance(v *Instance) *GetInstanceOutput {
	s.Instance = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatusRequest
type GetInstancesHealthStatusInput struct {
	_ struct{} `type:"structure"`

	// An array that contains the IDs of all the instances that you want to get
	// the health status for. To get the IDs for the instances that you've created
	// by using a specified service, submit a ListInstances request.
	//
	// If you omit Instances, Amazon Route 53 returns the health status for all
	// the instances that are associated with the specified service.
	Instances []*string `min:"1" type:"list"`

	// The maximum number of instances that you want Amazon Route 53 to return in
	// the response to a GetInstancesHealthStatus request. If you don't specify
	// a value for MaxResults, Amazon Route 53 returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first GetInstancesHealthStatus request, omit this value.
	//
	// If more than MaxResults instances match the specified criteria, you can submit
	// another GetInstancesHealthStatus request to get the next group of results.
	// Specify the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstancesHealthStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesHealthStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstancesHealthStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstancesHealthStatusInput"}
	if s.Instances != nil && len(s.Instances) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Instances", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstances sets the Instances field's value.
func (s *GetInstancesHealthStatusInput) SetInstances(v []*string) *GetInstancesHealthStatusInput {
	s.Instances = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInstancesHealthStatusInput) SetMaxResults(v int64) *GetInstancesHealthStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInstancesHealthStatusInput) SetNextToken(v string) *GetInstancesHealthStatusInput {
	s.NextToken = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetInstancesHealthStatusInput) SetServiceId(v string) *GetInstancesHealthStatusInput {
	s.ServiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatusResponse
type GetInstancesHealthStatusOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults instances match the specified criteria, you can submit
	// another GetInstancesHealthStatus request to get the next group of results.
	// Specify the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// A complex type that contains the IDs and the health status of the instances
	// that you specified in the GetInstancesHealthStatus request.
	Status map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetInstancesHealthStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesHealthStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetInstancesHealthStatusOutput) SetNextToken(v string) *GetInstancesHealthStatusOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetInstancesHealthStatusOutput) SetStatus(v map[string]*string) *GetInstancesHealthStatusOutput {
	s.Status = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespaceRequest
type GetNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the namespace that you want to get information about.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamespaceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetNamespaceInput) SetId(v string) *GetNamespaceInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespaceResponse
type GetNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified namespace.
	Namespace *Namespace `type:"structure"`
}

// String returns the string representation
func (s GetNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *GetNamespaceOutput) SetNamespace(v *Namespace) *GetNamespaceOutput {
	s.Namespace = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperationRequest
type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the operation that you want to get more information about.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *GetOperationInput) SetOperationId(v string) *GetOperationInput {
	s.OperationId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperationResponse
type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the operation.
	Operation *Operation `type:"structure"`
}

// String returns the string representation
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *GetOperationOutput) SetOperation(v *Operation) *GetOperationOutput {
	s.Operation = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetServiceRequest
type GetServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to get settings for.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetServiceInput) SetId(v string) *GetServiceInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetServiceResponse
type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the service.
	Service *Service `type:"structure"`
}

// String returns the string representation
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *GetServiceOutput) SetService(v *Service) *GetServiceOutput {
	s.Service = v
	return s
}

// Public DNS namespaces only. A complex type that contains settings for an
// optional health check. If you specify settings for a health check, Amazon
// Route 53 associates the health check with all the resource record sets that
// you specify in DnsConfig.
//
// The health check uses 30 seconds as the request interval. This is the number
// of seconds between the time that each Amazon Route 53 health checker gets
// a response from your endpoint and the time that it sends the next health
// check request. A health checker in each data center around the world sends
// your endpoint a health check request every 30 seconds. On average, your endpoint
// receives a health check request about every two seconds. Health checkers
// in different data centers don't coordinate with one another, so you'll sometimes
// see several requests per second followed by a few seconds with no health
// checks at all.
//
// For information about the charges for health checks, see Amazon Route 53
// Pricing (http://aws.amazon.com/route53/pricing).
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/HealthCheckConfig
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// The path that you want Amazon Route 53 to request when performing health
	// checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, such as the
	// file /docs/route53-health-check.html. Amazon Route 53 automatically adds
	// the DNS name for the service and a leading forward slash (/) character.
	ResourcePath *string `type:"string"`

	// The type of health check that you want to create, which indicates how Amazon
	// Route 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Amazon Route 53 tries to establish a TCP connection. If successful,
	//    Amazon Route 53 submits an HTTP request and waits for an HTTP status code
	//    of 200 or greater and less than 400.
	//
	//    * HTTPS: Amazon Route 53 tries to establish a TCP connection. If successful,
	//    Amazon Route 53 submits an HTTPS request and waits for an HTTP status
	//    code of 200 or greater and less than 400.
	//
	// If you specify HTTPS for the value of Type, the endpoint must support TLS
	//    v1.0 or later.
	//
	//    * TCP: Amazon Route 53 tries to establish a TCP connection.
	//
	// For more information, see How Amazon Route 53 Determines Whether an Endpoint
	// Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	Type *string `type:"string" enum:"HealthCheckType"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *HealthCheckConfig) SetFailureThreshold(v int64) *HealthCheckConfig {
	s.FailureThreshold = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *HealthCheckConfig) SetResourcePath(v string) *HealthCheckConfig {
	s.ResourcePath = &v
	return s
}

// SetType sets the Type field's value.
func (s *HealthCheckConfig) SetType(v string) *HealthCheckConfig {
	s.Type = &v
	return s
}

// A complex type that contains information about an instance that Amazon Route
// 53 creates when you submit a RegisterInstance request.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// A string map that contains attribute keys and values. Supported attribute
	// keys include the following:
	//
	//    * AWS_INSTANCE_PORT: The port on the endpoint that you want Amazon Route
	//    53 to perform health checks on. This value is also used for the port value
	//    in an SRV record if the service that you specify includes an SRV record.
	//    For more information, see CreateService.
	//
	//    * AWS_INSTANCE_IP: If the service that you specify contains a resource
	//    record set template for an A or AAAA record, the IP address that you want
	//    Amazon Route 53 to use for the value of the A record.
	//
	//    * AWS_INSTANCE_WEIGHT: The weight value in an SRV record if the service
	//    that you specify includes an SRV record. You can also specify a default
	//    weight that is applied to all instances in the Service configuration.
	//    For more information, see CreateService.
	//
	//    * AWS_INSTANCE_PRIORITY: The priority value in an SRV record if the service
	//    that you specify includes an SRV record.
	Attributes map[string]*string `type:"map"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To associate a new instance, you must specify a value that is unique
	//    among instances that you associate by using the same service.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Instance) SetAttributes(v map[string]*string) *Instance {
	s.Attributes = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Instance) SetCreatorRequestId(v string) *Instance {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Instance) SetId(v string) *Instance {
	s.Id = &v
	return s
}

// A complex type that contains information about the instances that you created
// by using a specified service.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/InstanceSummary
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// A string map that contain attribute keys and values for an instance. Supported
	// attribute keys include the following:
	//
	//    * AWS_INSTANCE_PORT: The port on the endpoint that you want Amazon Route
	//    53 to perform health checks on. This value is also used for the port value
	//    in an SRV record if the service that you specify includes an SRV record.
	//    For more information, see CreateService.
	//
	//    * AWS_INSTANCE_IP: If the service that you specify contains a resource
	//    record set template for an A or AAAA record, the IP address that you want
	//    Amazon Route 53 to use for the value of the A record.
	Attributes map[string]*string `type:"map"`

	// The ID for an instance that you created by using a specified service.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSummary) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *InstanceSummary) SetAttributes(v map[string]*string) *InstanceSummary {
	s.Attributes = v
	return s
}

// SetId sets the Id field's value.
func (s *InstanceSummary) SetId(v string) *InstanceSummary {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstancesRequest
type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances that you want Amazon Route 53 to return in
	// the response to a ListInstances request. If you don't specify a value for
	// MaxResults, Amazon Route 53 returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListInstances request, omit this value.
	//
	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// The ID of the service that you want to list instances for.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstancesInput) SetMaxResults(v int64) *ListInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesInput) SetNextToken(v string) *ListInstancesInput {
	s.NextToken = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *ListInstancesInput) SetServiceId(v string) *ListInstancesInput {
	s.ServiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstancesResponse
type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the instances that are associated with the specified
	// service.
	Instances []*InstanceSummary `type:"list"`

	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListInstancesOutput) SetInstances(v []*InstanceSummary) *ListInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesOutput) SetNextToken(v string) *ListInstancesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespacesRequest
type ListNamespacesInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the namespaces that you want
	// to list.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListNamespaces.
	Filters []*NamespaceFilter `type:"list"`

	// The maximum number of namespaces that you want Amazon Route 53 to return
	// in the response to a ListNamespaces request. If you don't specify a value
	// for MaxResults, Amazon Route 53 returns up to 100 namespaces.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListNamespaces request, omit this value.
	//
	// If more than MaxResults namespaces match the specified criteria, you can
	// submit another ListNamespaces request to get the next group of results. Specify
	// the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamespacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamespacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNamespacesInput) SetFilters(v []*NamespaceFilter) *ListNamespacesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamespacesInput) SetMaxResults(v int64) *ListNamespacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesInput) SetNextToken(v string) *ListNamespacesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespacesResponse
type ListNamespacesOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains one NamespaceSummary object for each namespace that
	// matches the specified filter criteria.
	Namespaces []*NamespaceSummary `type:"list"`

	// If more than MaxResults namespaces match the specified criteria, you can
	// submit another ListNamespaces request to get the next group of results. Specify
	// the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamespacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesOutput) GoString() string {
	return s.String()
}

// SetNamespaces sets the Namespaces field's value.
func (s *ListNamespacesOutput) SetNamespaces(v []*NamespaceSummary) *ListNamespacesOutput {
	s.Namespaces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesOutput) SetNextToken(v string) *ListNamespacesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperationsRequest
type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the operations that you want
	// to list, for example, operations that you started between a specified start
	// date and end date.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListOperations.
	Filters []*OperationFilter `type:"list"`

	// The maximum number of items that you want Amazon Route 53 to return in the
	// response to a ListOperations request. If you don't specify a value for MaxResults,
	// Amazon Route 53 returns up to 100 operations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListOperations request, omit this value.
	//
	// If more than MaxResults operations match the specified criteria, you can
	// submit another ListOperations request to get the next group of results. Specify
	// the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListOperationsInput) SetFilters(v []*OperationFilter) *ListOperationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOperationsInput) SetMaxResults(v int64) *ListOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsInput) SetNextToken(v string) *ListOperationsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperationsResponse
type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults operations match the specified criteria, you can
	// submit another ListOperations request to get the next group of results. Specify
	// the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// Summary information about the operations that match the specified criteria.
	Operations []*OperationSummary `type:"list"`
}

// String returns the string representation
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsOutput) SetNextToken(v string) *ListOperationsOutput {
	s.NextToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *ListOperationsOutput) SetOperations(v []*OperationSummary) *ListOperationsOutput {
	s.Operations = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServicesRequest
type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the namespaces that you want
	// to list services for.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListServices.
	Filters []*ServiceFilter `type:"list"`

	// The maximum number of services that you want Amazon Route 53 to return in
	// the response to a ListServices request. If you don't specify a value for
	// MaxResults, Amazon Route 53 returns up to 100 services.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListServices request, omit this value.
	//
	// If more than MaxResults services match the specified criteria, you can submit
	// another ListServices request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListServicesInput) SetFilters(v []*ServiceFilter) *ListServicesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServicesResponse
type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults operations match the specified criteria, the value
	// of NextToken is the first service in the next group of services that were
	// created by the current AWS account. To get the next group, specify the value
	// of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// An array that contains one ServiceSummary object for each service that matches
	// the specified filter criteria.
	Services []*ServiceSummary `type:"list"`
}

// String returns the string representation
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ListServicesOutput) SetServices(v []*ServiceSummary) *ListServicesOutput {
	s.Services = v
	return s
}

// A complex type that contains information about a specified namespace.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Namespace
type Namespace struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The date that the namespace was created, in Unix date/time format and Coordinated
	// Universal Time (UTC).
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string"`

	// The description that you specify for the namespace when you create it.
	Description *string `type:"string"`

	// The ID of a namespace.
	Id *string `type:"string"`

	// The name of the namespace, such as example.com.
	Name *string `type:"string"`

	// A complex type that contains information that's specific to the type of the
	// namespace.
	Properties *NamespaceProperties `type:"structure"`

	// The number of services that are associated with the namespace.
	ServiceCount *int64 `type:"integer"`

	// The type of the namespace. Valid values are DNS_PUBLIC and DNS_PRIVATE.
	Type *string `type:"string" enum:"NamespaceType"`
}

// String returns the string representation
func (s Namespace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Namespace) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Namespace) SetArn(v string) *Namespace {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Namespace) SetCreateDate(v time.Time) *Namespace {
	s.CreateDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Namespace) SetCreatorRequestId(v string) *Namespace {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Namespace) SetDescription(v string) *Namespace {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Namespace) SetId(v string) *Namespace {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Namespace) SetName(v string) *Namespace {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Namespace) SetProperties(v *NamespaceProperties) *Namespace {
	s.Properties = v
	return s
}

// SetServiceCount sets the ServiceCount field's value.
func (s *Namespace) SetServiceCount(v int64) *Namespace {
	s.ServiceCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *Namespace) SetType(v string) *Namespace {
	s.Type = &v
	return s
}

// A complex type that identifies the namespaces that you want to list. You
// can choose to list public or private namespaces.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceFilter
type NamespaceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether ListNamespaces returns
	// a namespace. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can choose to list only
	//    public namespaces or private namespaces, but not both. EQ is the default
	//    condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can choose to list public
	//    namespaces, private namespaces, or both.
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify TYPE.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"NamespaceFilterName"`

	// If you specify EQ for Condition, specify either DNS_PUBLIC or DNS_PRIVATE.
	//
	// If you specify IN for Condition, you can specify DNS_PUBLIC, DNS_PRIVATE,
	// or both.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s NamespaceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NamespaceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NamespaceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *NamespaceFilter) SetCondition(v string) *NamespaceFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamespaceFilter) SetName(v string) *NamespaceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *NamespaceFilter) SetValues(v []*string) *NamespaceFilter {
	s.Values = v
	return s
}

// A complex type that contains information that is specific to the namespace
// type.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceProperties
type NamespaceProperties struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID for the hosted zone that Amazon Route
	// 53 creates when you create a namespace.
	DnsProperties *DnsProperties `type:"structure"`
}

// String returns the string representation
func (s NamespaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceProperties) GoString() string {
	return s.String()
}

// SetDnsProperties sets the DnsProperties field's value.
func (s *NamespaceProperties) SetDnsProperties(v *DnsProperties) *NamespaceProperties {
	s.DnsProperties = v
	return s
}

// A complex type that contains information about a namespace.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceSummary
type NamespaceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The ID of the namespace.
	Id *string `type:"string"`

	// The name of the namespace. When you create a namespace, Amazon Route 53 automatically
	// creates a hosted zone that has the same name as the namespace.
	Name *string `type:"string"`

	// The type of the namespace, either public or private.
	Type *string `type:"string" enum:"NamespaceType"`
}

// String returns the string representation
func (s NamespaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NamespaceSummary) SetArn(v string) *NamespaceSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *NamespaceSummary) SetId(v string) *NamespaceSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamespaceSummary) SetName(v string) *NamespaceSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *NamespaceSummary) SetType(v string) *NamespaceSummary {
	s.Type = &v
	return s
}

// A complex type that contains information about a specified operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Operation
type Operation struct {
	_ struct{} `type:"structure"`

	// The date and time that the request was submitted, in Unix date/time format
	// and Coordinated Universal Time (UTC).
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The code associated with ErrorMessage.
	ErrorCode *string `type:"string"`

	// If the value of Status is FAIL, the reason that the operation failed.
	ErrorMessage *string `type:"string"`

	// The ID of the operation that you want to get information about.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: Amazon Route 53 is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status *string `type:"string" enum:"OperationStatus"`

	// The name of the target entity that is associated with the operation:
	//
	//    * NAMESPACE: The namespace ID is returned in the ResourceId property.
	//
	//    * SERVICE: The service ID is returned in the ResourceId property.
	//
	//    * INSTANCE: The instance ID is returned in the ResourceId property.
	Targets map[string]*string `type:"map"`

	// The name of the operation that is associated with the specified ID.
	Type *string `type:"string" enum:"OperationType"`

	// The date and time that the value of Status changed to the current value,
	// in Unix date/time format and Coordinated Universal Time (UTC).
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Operation) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *Operation) SetCreateDate(v time.Time) *Operation {
	s.CreateDate = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Operation) SetErrorCode(v string) *Operation {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Operation) SetErrorMessage(v string) *Operation {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *Operation) SetId(v string) *Operation {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Operation) SetStatus(v string) *Operation {
	s.Status = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Operation) SetTargets(v map[string]*string) *Operation {
	s.Targets = v
	return s
}

// SetType sets the Type field's value.
func (s *Operation) SetType(v string) *Operation {
	s.Type = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *Operation) SetUpdateDate(v time.Time) *Operation {
	s.UpdateDate = &v
	return s
}

// A complex type that lets you select the operations that you want to list.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/OperationFilter
type OperationFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether an operation matches
	// the specified value. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can specify only one
	//    value. EQ is supported for NAMESPACE_ID, SERVICE_ID, STATUS, and TYPE.
	//    EQ is the default condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can specify a list of
	//    one or more values. IN is supported for STATUS and TYPE. An operation
	//    must match one of the specified values to be returned in the response.
	//
	//    * BETWEEN: Specify two values, a start date and an end date. The start
	//    date must be the first value. BETWEEN is supported for U.
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify the operations that you want to get:
	//
	//    * NAMESPACE_ID: Gets operations related to specified namespaces.
	//
	//    * SERVICE_ID: Gets operations related to specified services.
	//
	//    * STATUS: Gets operations based on the status of the operations: SUBMITTED,
	//    PENDING, SUCCEED, or FAIL.
	//
	//    * TYPE: Gets specified types of operation.
	//
	//    * UPDATE_DATE: Gets operations that changed status during a specified
	//    date/time range.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"OperationFilterName"`

	// Specify values that are applicable to the value that you specify for Name:
	//
	//    * NAMESPACE_ID: Specify one namespace ID.
	//
	//    * SERVICE_ID: Specify one service ID.
	//
	//    * STATUS: Specify one or more statuses: SUBMITTED, PENDING, SUCCEED, or
	//    FAIL.
	//
	//    * TYPE: Specify one or more of the following types: CREATE_NAMESPACE,
	//    DELETE_NAMESPACE, UPDATE_SERVICE, REGISTER_INSTANCE, or DEREGISTER_INSTANCE.
	//
	//    * UPDATE_DATE: Specify a start date and an end date in Unix date/time
	//    format and Coordinated Universal Time (UTC). The start date must be the
	//    first value.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s OperationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OperationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OperationFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *OperationFilter) SetCondition(v string) *OperationFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *OperationFilter) SetName(v string) *OperationFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *OperationFilter) SetValues(v []*string) *OperationFilter {
	s.Values = v
	return s
}

// A complex type that contains information about an operation that matches
// the criteria that you specified in a ListOperations request.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/OperationSummary
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// The ID for an operation.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: Amazon Route 53 is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status *string `type:"string" enum:"OperationStatus"`
}

// String returns the string representation
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *OperationSummary) SetId(v string) *OperationSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OperationSummary) SetStatus(v string) *OperationSummary {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstanceRequest
type RegisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// A string map that contain attribute keys and values. Supported attribute
	// keys include the following:
	//
	//    * AWS_INSTANCE_PORT: The port on the endpoint that you want Amazon Route
	//    53 to perform health checks on. This value is also used for the port value
	//    in an SRV record if the service that you specify includes an SRV record.
	//    For more information, see CreateService.
	//
	//    * AWS_INSTANCE_IPV4: If the service that you specify contains a resource
	//    record set template for an A record, the IPv4 address that you want Amazon
	//    Route 53 to use for the value of the A record.
	//
	//    * AWS_INSTANCE_IPV6: If the service that you specify contains a resource
	//    record set template for an AAAA record, the IPv6 address that you want
	//    Amazon Route 53 to use for the value of the AAAA record.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To register a new instance, you must specify a value that is unique
	//    among instances that you register by using the same service.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that you want to use for settings for the resource
	// record sets and health check that Amazon Route 53 will create.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterInstanceInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *RegisterInstanceInput) SetAttributes(v map[string]*string) *RegisterInstanceInput {
	s.Attributes = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *RegisterInstanceInput) SetCreatorRequestId(v string) *RegisterInstanceInput {
	s.CreatorRequestId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RegisterInstanceInput) SetInstanceId(v string) *RegisterInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *RegisterInstanceInput) SetServiceId(v string) *RegisterInstanceInput {
	s.ServiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstanceResponse
type RegisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s RegisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *RegisterInstanceOutput) SetOperationId(v string) *RegisterInstanceOutput {
	s.OperationId = &v
	return s
}

// A complex type that contains information about the specified service.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Service
type Service struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the service was created, in Unix format and Coordinated
	// Universal Time (UTC).
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An optional parameter that you can use to resolve concurrent creation requests.
	// CreatorRequestId helps to determine if a specific client owns the namespace.
	CreatorRequestId *string `type:"string"`

	// The description of the service.
	Description *string `type:"string"`

	// A complex type that contains information about the resource record sets that
	// you want Amazon Route 53 to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, Amazon
	// Route 53 associates the health check with all the resource record sets that
	// you specify in DnsConfig.
	//
	// The health check uses 30 seconds as the request interval. This is the number
	// of seconds between the time that each Amazon Route 53 health checker gets
	// a response from your endpoint and the time that it sends the next health
	// check request. A health checker in each data center around the world sends
	// your endpoint a health check request every 30 seconds. On average, your endpoint
	// receives a health check request about every two seconds. Health checkers
	// in different data centers don't coordinate with one another, so you'll sometimes
	// see several requests per second followed by a few seconds with no health
	// checks at all.
	//
	// For information about the charges for health checks, see Amazon Route 53
	// Pricing (http://aws.amazon.com/route53/pricing).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// The ID that Amazon Route 53 assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Service) SetArn(v string) *Service {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Service) SetCreateDate(v time.Time) *Service {
	s.CreateDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Service) SetCreatorRequestId(v string) *Service {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Service) SetDescription(v string) *Service {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *Service) SetDnsConfig(v *DnsConfig) *Service {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *Service) SetHealthCheckConfig(v *HealthCheckConfig) *Service {
	s.HealthCheckConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *Service) SetId(v string) *Service {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *Service) SetInstanceCount(v int64) *Service {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// A complex type that contains changes to an existing service.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceChange
type ServiceChange struct {
	_ struct{} `type:"structure"`

	// A description for the service.
	Description *string `type:"string"`

	// A complex type that contains information about the resource record sets that
	// you want Amazon Route 53 to create when you register an instance.
	//
	// DnsConfig is a required field
	DnsConfig *DnsConfigChange `type:"structure" required:"true"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, Amazon
	// Route 53 associates the health check with all the resource record sets that
	// you specify in DnsConfig.
	//
	// The health check uses 30 seconds as the request interval. This is the number
	// of seconds between the time that each Amazon Route 53 health checker gets
	// a response from your endpoint and the time that it sends the next health
	// check request. A health checker in each data center around the world sends
	// your endpoint a health check request every 30 seconds. On average, your endpoint
	// receives a health check request about every two seconds. Health checkers
	// in different data centers don't coordinate with one another, so you'll sometimes
	// see several requests per second followed by a few seconds with no health
	// checks at all.
	//
	// For information about the charges for health checks, see Amazon Route 53
	// Pricing (http://aws.amazon.com/route53/pricing).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`
}

// String returns the string representation
func (s ServiceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceChange"}
	if s.DnsConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsConfig"))
	}
	if s.DnsConfig != nil {
		if err := s.DnsConfig.Validate(); err != nil {
			invalidParams.AddNested("DnsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ServiceChange) SetDescription(v string) *ServiceChange {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *ServiceChange) SetDnsConfig(v *DnsConfigChange) *ServiceChange {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *ServiceChange) SetHealthCheckConfig(v *HealthCheckConfig) *ServiceChange {
	s.HealthCheckConfig = v
	return s
}

// A complex type that lets you specify the namespaces that you want to list
// services for.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceFilter
type ServiceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether a service is returned
	// by ListServices. Valid values for Condition include the following:
	//
	//    * EQ: When you specify EQ, specify one namespace ID for Values. EQ is
	//    the default condition and can be omitted.
	//
	//    * IN: When you specify IN, specify a list of the IDs for the namespaces
	//    that you want ListServices to return a list of services for.
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify NAMESPACE_ID.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ServiceFilterName"`

	// The values that are applicable to the value that you specify for Condition
	// to filter the list of services.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ServiceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ServiceFilter) SetCondition(v string) *ServiceFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceFilter) SetName(v string) *ServiceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ServiceFilter) SetValues(v []*string) *ServiceFilter {
	s.Values = v
	return s
}

// A complex type that contains information about a specified service.
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceSummary
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The description that you specify when you create the service.
	Description *string `type:"string"`

	// The ID that Amazon Route 53 assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceSummary) SetArn(v string) *ServiceSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSummary) SetDescription(v string) *ServiceSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceSummary) SetId(v string) *ServiceSummary {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ServiceSummary) SetInstanceCount(v int64) *ServiceSummary {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceSummary) SetName(v string) *ServiceSummary {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateServiceRequest
type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to update.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex type that contains the new settings for the service.
	//
	// Service is a required field
	Service *ServiceChange `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.Service != nil {
		if err := s.Service.Validate(); err != nil {
			invalidParams.AddNested("Service", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateServiceInput) SetId(v string) *UpdateServiceInput {
	s.Id = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateServiceInput) SetService(v *ServiceChange) *UpdateServiceInput {
	s.Service = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateServiceResponse
type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateServiceOutput) SetOperationId(v string) *UpdateServiceOutput {
	s.OperationId = &v
	return s
}

const (
	// FilterConditionEq is a FilterCondition enum value
	FilterConditionEq = "EQ"

	// FilterConditionIn is a FilterCondition enum value
	FilterConditionIn = "IN"

	// FilterConditionBetween is a FilterCondition enum value
	FilterConditionBetween = "BETWEEN"
)

const (
	// HealthCheckTypeHttp is a HealthCheckType enum value
	HealthCheckTypeHttp = "HTTP"

	// HealthCheckTypeHttps is a HealthCheckType enum value
	HealthCheckTypeHttps = "HTTPS"

	// HealthCheckTypeTcp is a HealthCheckType enum value
	HealthCheckTypeTcp = "TCP"
)

const (
	// HealthStatusHealthy is a HealthStatus enum value
	HealthStatusHealthy = "HEALTHY"

	// HealthStatusUnhealthy is a HealthStatus enum value
	HealthStatusUnhealthy = "UNHEALTHY"

	// HealthStatusUnknown is a HealthStatus enum value
	HealthStatusUnknown = "UNKNOWN"
)

const (
	// NamespaceFilterNameType is a NamespaceFilterName enum value
	NamespaceFilterNameType = "TYPE"
)

const (
	// NamespaceTypeDnsPublic is a NamespaceType enum value
	NamespaceTypeDnsPublic = "DNS_PUBLIC"

	// NamespaceTypeDnsPrivate is a NamespaceType enum value
	NamespaceTypeDnsPrivate = "DNS_PRIVATE"
)

const (
	// OperationFilterNameNamespaceId is a OperationFilterName enum value
	OperationFilterNameNamespaceId = "NAMESPACE_ID"

	// OperationFilterNameServiceId is a OperationFilterName enum value
	OperationFilterNameServiceId = "SERVICE_ID"

	// OperationFilterNameStatus is a OperationFilterName enum value
	OperationFilterNameStatus = "STATUS"

	// OperationFilterNameType is a OperationFilterName enum value
	OperationFilterNameType = "TYPE"

	// OperationFilterNameUpdateDate is a OperationFilterName enum value
	OperationFilterNameUpdateDate = "UPDATE_DATE"
)

const (
	// OperationStatusSubmitted is a OperationStatus enum value
	OperationStatusSubmitted = "SUBMITTED"

	// OperationStatusPending is a OperationStatus enum value
	OperationStatusPending = "PENDING"

	// OperationStatusSuccess is a OperationStatus enum value
	OperationStatusSuccess = "SUCCESS"

	// OperationStatusFail is a OperationStatus enum value
	OperationStatusFail = "FAIL"
)

const (
	// OperationTargetTypeNamespace is a OperationTargetType enum value
	OperationTargetTypeNamespace = "NAMESPACE"

	// OperationTargetTypeService is a OperationTargetType enum value
	OperationTargetTypeService = "SERVICE"

	// OperationTargetTypeInstance is a OperationTargetType enum value
	OperationTargetTypeInstance = "INSTANCE"
)

const (
	// OperationTypeCreateNamespace is a OperationType enum value
	OperationTypeCreateNamespace = "CREATE_NAMESPACE"

	// OperationTypeDeleteNamespace is a OperationType enum value
	OperationTypeDeleteNamespace = "DELETE_NAMESPACE"

	// OperationTypeUpdateService is a OperationType enum value
	OperationTypeUpdateService = "UPDATE_SERVICE"

	// OperationTypeRegisterInstance is a OperationType enum value
	OperationTypeRegisterInstance = "REGISTER_INSTANCE"

	// OperationTypeDeregisterInstance is a OperationType enum value
	OperationTypeDeregisterInstance = "DEREGISTER_INSTANCE"
)

const (
	// RecordTypeSrv is a RecordType enum value
	RecordTypeSrv = "SRV"

	// RecordTypeA is a RecordType enum value
	RecordTypeA = "A"

	// RecordTypeAaaa is a RecordType enum value
	RecordTypeAaaa = "AAAA"
)

const (
	// ServiceFilterNameNamespaceId is a ServiceFilterName enum value
	ServiceFilterNameNamespaceId = "NAMESPACE_ID"
)
