// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opDescribeAffectedEntities = "DescribeAffectedEntities"

// DescribeAffectedEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAffectedEntities operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAffectedEntities for more information on using the DescribeAffectedEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAffectedEntitiesRequest method.
//    req, resp := client.DescribeAffectedEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities
func (c *Health) DescribeAffectedEntitiesRequest(input *DescribeAffectedEntitiesInput) (req *request.Request, output *DescribeAffectedEntitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeAffectedEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAffectedEntitiesInput{}
	}

	output = &DescribeAffectedEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAffectedEntities API operation for AWS Health APIs and Notifications.
//
// Returns a list of entities that have been affected by the specified events,
// based on the specified filter criteria. Entities can refer to individual
// customer resources, groups of customer resources, or any other construct,
// depending on the AWS service. Events that have impact beyond that of the
// affected entities, or where the extent of impact is unknown, include at least
// one entity indicating this.
//
// At least one event ARN is required. Results are sorted by the lastUpdatedTime
// of the entity, starting with the most recent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeAffectedEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The specified pagination token (nextToken) is not valid.
//
//   * ErrCodeUnsupportedLocale "UnsupportedLocale"
//   The specified locale is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities
func (c *Health) DescribeAffectedEntities(input *DescribeAffectedEntitiesInput) (*DescribeAffectedEntitiesOutput, error) {
	req, out := c.DescribeAffectedEntitiesRequest(input)
	return out, req.Send()
}

// DescribeAffectedEntitiesWithContext is the same as DescribeAffectedEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAffectedEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeAffectedEntitiesWithContext(ctx aws.Context, input *DescribeAffectedEntitiesInput, opts ...request.Option) (*DescribeAffectedEntitiesOutput, error) {
	req, out := c.DescribeAffectedEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAffectedEntitiesPages iterates over the pages of a DescribeAffectedEntities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAffectedEntities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAffectedEntities operation.
//    pageNum := 0
//    err := client.DescribeAffectedEntitiesPages(params,
//        func(page *DescribeAffectedEntitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Health) DescribeAffectedEntitiesPages(input *DescribeAffectedEntitiesInput, fn func(*DescribeAffectedEntitiesOutput, bool) bool) error {
	return c.DescribeAffectedEntitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAffectedEntitiesPagesWithContext same as DescribeAffectedEntitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeAffectedEntitiesPagesWithContext(ctx aws.Context, input *DescribeAffectedEntitiesInput, fn func(*DescribeAffectedEntitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAffectedEntitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAffectedEntitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeAffectedEntitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEntityAggregates = "DescribeEntityAggregates"

// DescribeEntityAggregatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntityAggregates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntityAggregates for more information on using the DescribeEntityAggregates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntityAggregatesRequest method.
//    req, resp := client.DescribeEntityAggregatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregates
func (c *Health) DescribeEntityAggregatesRequest(input *DescribeEntityAggregatesInput) (req *request.Request, output *DescribeEntityAggregatesOutput) {
	op := &request.Operation{
		Name:       opDescribeEntityAggregates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntityAggregatesInput{}
	}

	output = &DescribeEntityAggregatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntityAggregates API operation for AWS Health APIs and Notifications.
//
// Returns the number of entities that are affected by each of the specified
// events. If no events are specified, the counts of all affected entities are
// returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeEntityAggregates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregates
func (c *Health) DescribeEntityAggregates(input *DescribeEntityAggregatesInput) (*DescribeEntityAggregatesOutput, error) {
	req, out := c.DescribeEntityAggregatesRequest(input)
	return out, req.Send()
}

// DescribeEntityAggregatesWithContext is the same as DescribeEntityAggregates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntityAggregates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEntityAggregatesWithContext(ctx aws.Context, input *DescribeEntityAggregatesInput, opts ...request.Option) (*DescribeEntityAggregatesOutput, error) {
	req, out := c.DescribeEntityAggregatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventAggregates = "DescribeEventAggregates"

// DescribeEventAggregatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventAggregates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventAggregates for more information on using the DescribeEventAggregates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventAggregatesRequest method.
//    req, resp := client.DescribeEventAggregatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates
func (c *Health) DescribeEventAggregatesRequest(input *DescribeEventAggregatesInput) (req *request.Request, output *DescribeEventAggregatesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventAggregates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventAggregatesInput{}
	}

	output = &DescribeEventAggregatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventAggregates API operation for AWS Health APIs and Notifications.
//
// Returns the number of events of each event type (issue, scheduled change,
// and account notification). If no filter is specified, the counts of all events
// in each category are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeEventAggregates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The specified pagination token (nextToken) is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates
func (c *Health) DescribeEventAggregates(input *DescribeEventAggregatesInput) (*DescribeEventAggregatesOutput, error) {
	req, out := c.DescribeEventAggregatesRequest(input)
	return out, req.Send()
}

// DescribeEventAggregatesWithContext is the same as DescribeEventAggregates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventAggregates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventAggregatesWithContext(ctx aws.Context, input *DescribeEventAggregatesInput, opts ...request.Option) (*DescribeEventAggregatesOutput, error) {
	req, out := c.DescribeEventAggregatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventAggregatesPages iterates over the pages of a DescribeEventAggregates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventAggregates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventAggregates operation.
//    pageNum := 0
//    err := client.DescribeEventAggregatesPages(params,
//        func(page *DescribeEventAggregatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Health) DescribeEventAggregatesPages(input *DescribeEventAggregatesInput, fn func(*DescribeEventAggregatesOutput, bool) bool) error {
	return c.DescribeEventAggregatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventAggregatesPagesWithContext same as DescribeEventAggregatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventAggregatesPagesWithContext(ctx aws.Context, input *DescribeEventAggregatesInput, fn func(*DescribeEventAggregatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventAggregatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventAggregatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventAggregatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEventDetails = "DescribeEventDetails"

// DescribeEventDetailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventDetails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventDetails for more information on using the DescribeEventDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventDetailsRequest method.
//    req, resp := client.DescribeEventDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetails
func (c *Health) DescribeEventDetailsRequest(input *DescribeEventDetailsInput) (req *request.Request, output *DescribeEventDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventDetailsInput{}
	}

	output = &DescribeEventDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventDetails API operation for AWS Health APIs and Notifications.
//
// Returns detailed information about one or more specified events. Information
// includes standard event data (region, service, etc., as returned by DescribeEvents),
// a detailed event description, and possible additional metadata that depends
// upon the nature of the event. Affected entities are not included; to retrieve
// those, use the DescribeAffectedEntities operation.
//
// If a specified event cannot be retrieved, an error message is returned for
// that event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeEventDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnsupportedLocale "UnsupportedLocale"
//   The specified locale is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetails
func (c *Health) DescribeEventDetails(input *DescribeEventDetailsInput) (*DescribeEventDetailsOutput, error) {
	req, out := c.DescribeEventDetailsRequest(input)
	return out, req.Send()
}

// DescribeEventDetailsWithContext is the same as DescribeEventDetails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventDetailsWithContext(ctx aws.Context, input *DescribeEventDetailsInput, opts ...request.Option) (*DescribeEventDetailsOutput, error) {
	req, out := c.DescribeEventDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventTypes = "DescribeEventTypes"

// DescribeEventTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventTypes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventTypes for more information on using the DescribeEventTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventTypesRequest method.
//    req, resp := client.DescribeEventTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes
func (c *Health) DescribeEventTypesRequest(input *DescribeEventTypesInput) (req *request.Request, output *DescribeEventTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventTypesInput{}
	}

	output = &DescribeEventTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventTypes API operation for AWS Health APIs and Notifications.
//
// Returns the event types that meet the specified filter criteria. If no filter
// criteria are specified, all event types are returned, in no particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeEventTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The specified pagination token (nextToken) is not valid.
//
//   * ErrCodeUnsupportedLocale "UnsupportedLocale"
//   The specified locale is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes
func (c *Health) DescribeEventTypes(input *DescribeEventTypesInput) (*DescribeEventTypesOutput, error) {
	req, out := c.DescribeEventTypesRequest(input)
	return out, req.Send()
}

// DescribeEventTypesWithContext is the same as DescribeEventTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventTypesWithContext(ctx aws.Context, input *DescribeEventTypesInput, opts ...request.Option) (*DescribeEventTypesOutput, error) {
	req, out := c.DescribeEventTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventTypesPages iterates over the pages of a DescribeEventTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventTypes operation.
//    pageNum := 0
//    err := client.DescribeEventTypesPages(params,
//        func(page *DescribeEventTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Health) DescribeEventTypesPages(input *DescribeEventTypesInput, fn func(*DescribeEventTypesOutput, bool) bool) error {
	return c.DescribeEventTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventTypesPagesWithContext same as DescribeEventTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventTypesPagesWithContext(ctx aws.Context, input *DescribeEventTypesInput, fn func(*DescribeEventTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents
func (c *Health) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS Health APIs and Notifications.
//
// Returns information about events that meet the specified filter criteria.
// Events are returned in a summary form and do not include the detailed description,
// any additional metadata that depends on the event type, or any affected resources.
// To retrieve that information, use the DescribeEventDetails and DescribeAffectedEntities
// operations.
//
// If no filter criteria are specified, all events are returned. Results are
// sorted by lastModifiedTime, starting with the most recent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health APIs and Notifications's
// API operation DescribeEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The specified pagination token (nextToken) is not valid.
//
//   * ErrCodeUnsupportedLocale "UnsupportedLocale"
//   The specified locale is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents
func (c *Health) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Health) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Health) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

// Information about an entity that is affected by a Health event.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/AffectedEntity
type AffectedEntity struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account number that contains the affected entity.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The unique identifier for the entity. Format: arn:aws:health:entity-region:aws-account:entity/entity-id.
	// Example: arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K
	EntityArn *string `locationName:"entityArn" type:"string"`

	// The ID of the affected entity.
	EntityValue *string `locationName:"entityValue" type:"string"`

	// The unique identifier for the event. Format: arn:aws:health:event-region::event/EVENT_TYPE_PLUS_ID.
	// Example: arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331
	EventArn *string `locationName:"eventArn" type:"string"`

	// The most recent time that the entity was updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" timestampFormat:"unix"`

	// The most recent status of the entity affected by the event. The possible
	// values are IMPAIRED, UNIMPAIRED, and UNKNOWN.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"entityStatusCode"`

	// A map of entity tags attached to the affected entity.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s AffectedEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AffectedEntity) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AffectedEntity) SetAwsAccountId(v string) *AffectedEntity {
	s.AwsAccountId = &v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *AffectedEntity) SetEntityArn(v string) *AffectedEntity {
	s.EntityArn = &v
	return s
}

// SetEntityValue sets the EntityValue field's value.
func (s *AffectedEntity) SetEntityValue(v string) *AffectedEntity {
	s.EntityValue = &v
	return s
}

// SetEventArn sets the EventArn field's value.
func (s *AffectedEntity) SetEventArn(v string) *AffectedEntity {
	s.EventArn = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AffectedEntity) SetLastUpdatedTime(v time.Time) *AffectedEntity {
	s.LastUpdatedTime = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *AffectedEntity) SetStatusCode(v string) *AffectedEntity {
	s.StatusCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AffectedEntity) SetTags(v map[string]*string) *AffectedEntity {
	s.Tags = v
	return s
}

// A range of dates and times that is used by the EventFilter and EntityFilter
// objects. If from is set and to is set: match items where the timestamp (startTime,
// endTime, or lastUpdatedTime) is between from and to inclusive. If from is
// set and to is not set: match items where the timestamp value is equal to
// or after from. If from is not set and to is set: match items where the timestamp
// value is equal to or before to.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DateTimeRange
type DateTimeRange struct {
	_ struct{} `type:"structure"`

	// The starting date and time of a time range.
	From *time.Time `locationName:"from" type:"timestamp" timestampFormat:"unix"`

	// The ending date and time of a time range.
	To *time.Time `locationName:"to" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DateTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateTimeRange) GoString() string {
	return s.String()
}

// SetFrom sets the From field's value.
func (s *DateTimeRange) SetFrom(v time.Time) *DateTimeRange {
	s.From = &v
	return s
}

// SetTo sets the To field's value.
func (s *DateTimeRange) SetTo(v time.Time) *DateTimeRange {
	s.To = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesRequest
type DescribeAffectedEntitiesInput struct {
	_ struct{} `type:"structure"`

	// Values to narrow the results returned. At least one event ARN is required.
	//
	// Filter is a required field
	Filter *EntityFilter `locationName:"filter" type:"structure" required:"true"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAffectedEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAffectedEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAffectedEntitiesInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *DescribeAffectedEntitiesInput) SetFilter(v *EntityFilter) *DescribeAffectedEntitiesInput {
	s.Filter = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeAffectedEntitiesInput) SetLocale(v string) *DescribeAffectedEntitiesInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAffectedEntitiesInput) SetMaxResults(v int64) *DescribeAffectedEntitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAffectedEntitiesInput) SetNextToken(v string) *DescribeAffectedEntitiesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesResponse
type DescribeAffectedEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The entities that match the filter criteria.
	Entities []*AffectedEntity `locationName:"entities" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAffectedEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAffectedEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DescribeAffectedEntitiesOutput) SetEntities(v []*AffectedEntity) *DescribeAffectedEntitiesOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAffectedEntitiesOutput) SetNextToken(v string) *DescribeAffectedEntitiesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregatesRequest
type DescribeEntityAggregatesInput struct {
	_ struct{} `type:"structure"`

	// A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331",
	// "arn:aws:health:us-west-1::event/AWS_EBS_LOST_VOLUME_xyz"
	EventArns []*string `locationName:"eventArns" min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeEntityAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityAggregatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntityAggregatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntityAggregatesInput"}
	if s.EventArns != nil && len(s.EventArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventArns sets the EventArns field's value.
func (s *DescribeEntityAggregatesInput) SetEventArns(v []*string) *DescribeEntityAggregatesInput {
	s.EventArns = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregatesResponse
type DescribeEntityAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The number of entities that are affected by each of the specified events.
	EntityAggregates []*EntityAggregate `locationName:"entityAggregates" type:"list"`
}

// String returns the string representation
func (s DescribeEntityAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityAggregatesOutput) GoString() string {
	return s.String()
}

// SetEntityAggregates sets the EntityAggregates field's value.
func (s *DescribeEntityAggregatesOutput) SetEntityAggregates(v []*EntityAggregate) *DescribeEntityAggregatesOutput {
	s.EntityAggregates = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregatesRequest
type DescribeEventAggregatesInput struct {
	_ struct{} `type:"structure"`

	// The only currently supported value is eventTypeCategory.
	//
	// AggregateField is a required field
	AggregateField *string `locationName:"aggregateField" type:"string" required:"true" enum:"eventAggregateField"`

	// Values to narrow the results returned.
	Filter *EventFilter `locationName:"filter" type:"structure"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventAggregatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventAggregatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventAggregatesInput"}
	if s.AggregateField == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateField"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateField sets the AggregateField field's value.
func (s *DescribeEventAggregatesInput) SetAggregateField(v string) *DescribeEventAggregatesInput {
	s.AggregateField = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *DescribeEventAggregatesInput) SetFilter(v *EventFilter) *DescribeEventAggregatesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventAggregatesInput) SetMaxResults(v int64) *DescribeEventAggregatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventAggregatesInput) SetNextToken(v string) *DescribeEventAggregatesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregatesResponse
type DescribeEventAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The number of events in each category that meet the optional filter criteria.
	EventAggregates []*EventAggregate `locationName:"eventAggregates" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventAggregatesOutput) GoString() string {
	return s.String()
}

// SetEventAggregates sets the EventAggregates field's value.
func (s *DescribeEventAggregatesOutput) SetEventAggregates(v []*EventAggregate) *DescribeEventAggregatesOutput {
	s.EventAggregates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventAggregatesOutput) SetNextToken(v string) *DescribeEventAggregatesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsRequest
type DescribeEventDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331",
	// "arn:aws:health:us-west-1::event/AWS_EBS_LOST_VOLUME_xyz"
	//
	// EventArns is a required field
	EventArns []*string `locationName:"eventArns" min:"1" type:"list" required:"true"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeEventDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventDetailsInput"}
	if s.EventArns == nil {
		invalidParams.Add(request.NewErrParamRequired("EventArns"))
	}
	if s.EventArns != nil && len(s.EventArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventArns", 1))
	}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventArns sets the EventArns field's value.
func (s *DescribeEventDetailsInput) SetEventArns(v []*string) *DescribeEventDetailsInput {
	s.EventArns = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeEventDetailsInput) SetLocale(v string) *DescribeEventDetailsInput {
	s.Locale = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsResponse
type DescribeEventDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Error messages for any events that could not be retrieved.
	FailedSet []*EventDetailsErrorItem `locationName:"failedSet" type:"list"`

	// Information about the events that could be retrieved.
	SuccessfulSet []*EventDetails `locationName:"successfulSet" type:"list"`
}

// String returns the string representation
func (s DescribeEventDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventDetailsOutput) GoString() string {
	return s.String()
}

// SetFailedSet sets the FailedSet field's value.
func (s *DescribeEventDetailsOutput) SetFailedSet(v []*EventDetailsErrorItem) *DescribeEventDetailsOutput {
	s.FailedSet = v
	return s
}

// SetSuccessfulSet sets the SuccessfulSet field's value.
func (s *DescribeEventDetailsOutput) SetSuccessfulSet(v []*EventDetails) *DescribeEventDetailsOutput {
	s.SuccessfulSet = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypesRequest
type DescribeEventTypesInput struct {
	_ struct{} `type:"structure"`

	// Values to narrow the results returned.
	Filter *EventTypeFilter `locationName:"filter" type:"structure"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventTypesInput"}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *DescribeEventTypesInput) SetFilter(v *EventTypeFilter) *DescribeEventTypesInput {
	s.Filter = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeEventTypesInput) SetLocale(v string) *DescribeEventTypesInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventTypesInput) SetMaxResults(v int64) *DescribeEventTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventTypesInput) SetNextToken(v string) *DescribeEventTypesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypesResponse
type DescribeEventTypesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event types that match the filter criteria. Event types have a
	// category (issue, accountNotification, or scheduledChange), a service (for
	// example, EC2, RDS, DATAPIPELINE, BILLING), and a code (in the format AWS_SERVICE_DESCRIPTION;
	// for example, AWS_EC2_SYSTEM_MAINTENANCE_EVENT).
	EventTypes []*EventType `locationName:"eventTypes" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTypesOutput) GoString() string {
	return s.String()
}

// SetEventTypes sets the EventTypes field's value.
func (s *DescribeEventTypesOutput) SetEventTypes(v []*EventType) *DescribeEventTypesOutput {
	s.EventTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventTypesOutput) SetNextToken(v string) *DescribeEventTypesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsRequest
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// Values to narrow the results returned.
	Filter *EventFilter `locationName:"filter" type:"structure"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *DescribeEventsInput) SetFilter(v *EventFilter) *DescribeEventsInput {
	s.Filter = v
	return s
}

// SetLocale sets the Locale field's value.
func (s *DescribeEventsInput) SetLocale(v string) *DescribeEventsInput {
	s.Locale = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventsInput) SetMaxResults(v int64) *DescribeEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsInput) SetNextToken(v string) *DescribeEventsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsResponse
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// The events that match the specified filter criteria.
	Events []*Event `locationName:"events" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsOutput) SetNextToken(v string) *DescribeEventsOutput {
	s.NextToken = &v
	return s
}

// The number of entities that are affected by one or more events. Returned
// by the DescribeEntityAggregates operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EntityAggregate
type EntityAggregate struct {
	_ struct{} `type:"structure"`

	// The number entities that match the criteria for the specified events.
	Count *int64 `locationName:"count" type:"integer"`

	// The unique identifier for the event. Format: arn:aws:health:event-region::event/EVENT_TYPE_PLUS_ID.
	// Example: arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331
	EventArn *string `locationName:"eventArn" type:"string"`
}

// String returns the string representation
func (s EntityAggregate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityAggregate) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *EntityAggregate) SetCount(v int64) *EntityAggregate {
	s.Count = &v
	return s
}

// SetEventArn sets the EventArn field's value.
func (s *EntityAggregate) SetEventArn(v string) *EntityAggregate {
	s.EventArn = &v
	return s
}

// The values to use to filter results from the DescribeAffectedEntities operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EntityFilter
type EntityFilter struct {
	_ struct{} `type:"structure"`

	// A list of entity ARNs (unique identifiers).
	EntityArns []*string `locationName:"entityArns" min:"1" type:"list"`

	// A list of IDs for affected entities.
	EntityValues []*string `locationName:"entityValues" min:"1" type:"list"`

	// A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331",
	// "arn:aws:health:us-west-1::event/AWS_EBS_LOST_VOLUME_xyz"
	//
	// EventArns is a required field
	EventArns []*string `locationName:"eventArns" min:"1" type:"list" required:"true"`

	// A list of the most recent dates and times that the entity was updated.
	LastUpdatedTimes []*DateTimeRange `locationName:"lastUpdatedTimes" min:"1" type:"list"`

	// A list of entity status codes (IMPAIRED, UNIMPAIRED, or UNKNOWN).
	StatusCodes []*string `locationName:"statusCodes" min:"1" type:"list"`

	// A map of entity tags attached to the affected entity.
	Tags []map[string]*string `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s EntityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityFilter"}
	if s.EntityArns != nil && len(s.EntityArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityArns", 1))
	}
	if s.EntityValues != nil && len(s.EntityValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityValues", 1))
	}
	if s.EventArns == nil {
		invalidParams.Add(request.NewErrParamRequired("EventArns"))
	}
	if s.EventArns != nil && len(s.EventArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventArns", 1))
	}
	if s.LastUpdatedTimes != nil && len(s.LastUpdatedTimes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastUpdatedTimes", 1))
	}
	if s.StatusCodes != nil && len(s.StatusCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCodes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityArns sets the EntityArns field's value.
func (s *EntityFilter) SetEntityArns(v []*string) *EntityFilter {
	s.EntityArns = v
	return s
}

// SetEntityValues sets the EntityValues field's value.
func (s *EntityFilter) SetEntityValues(v []*string) *EntityFilter {
	s.EntityValues = v
	return s
}

// SetEventArns sets the EventArns field's value.
func (s *EntityFilter) SetEventArns(v []*string) *EntityFilter {
	s.EventArns = v
	return s
}

// SetLastUpdatedTimes sets the LastUpdatedTimes field's value.
func (s *EntityFilter) SetLastUpdatedTimes(v []*DateTimeRange) *EntityFilter {
	s.LastUpdatedTimes = v
	return s
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *EntityFilter) SetStatusCodes(v []*string) *EntityFilter {
	s.StatusCodes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *EntityFilter) SetTags(v []map[string]*string) *EntityFilter {
	s.Tags = v
	return s
}

// Summary information about an event, returned by the DescribeEvents operation.
// The DescribeEventDetails operation also returns this information, as well
// as the EventDescription and additional event metadata.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/Event
type Event struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the event. Format: arn:aws:health:event-region::event/EVENT_TYPE_PLUS_ID.
	// Example: arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331
	Arn *string `locationName:"arn" type:"string"`

	// The AWS Availability Zone of the event. For example, us-east-1a.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The date and time that the event ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The
	EventTypeCategory *string `locationName:"eventTypeCategory" min:"3" type:"string" enum:"eventTypeCategory"`

	// The unique identifier for the event type. The format is AWS_SERVICE_DESCRIPTION;
	// for example, AWS_EC2_SYSTEM_MAINTENANCE_EVENT.
	EventTypeCode *string `locationName:"eventTypeCode" min:"3" type:"string"`

	// The most recent date and time that the event was updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" timestampFormat:"unix"`

	// The AWS region name of the event.
	Region *string `locationName:"region" type:"string"`

	// The AWS service that is affected by the event. For example, EC2, RDS.
	Service *string `locationName:"service" min:"2" type:"string"`

	// The date and time that the event began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The most recent status of the event. Possible values are open, closed, and
	// upcoming.
	StatusCode *string `locationName:"statusCode" type:"string" enum:"eventStatusCode"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Event) SetArn(v string) *Event {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Event) SetAvailabilityZone(v string) *Event {
	s.AvailabilityZone = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Event) SetEndTime(v time.Time) *Event {
	s.EndTime = &v
	return s
}

// SetEventTypeCategory sets the EventTypeCategory field's value.
func (s *Event) SetEventTypeCategory(v string) *Event {
	s.EventTypeCategory = &v
	return s
}

// SetEventTypeCode sets the EventTypeCode field's value.
func (s *Event) SetEventTypeCode(v string) *Event {
	s.EventTypeCode = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Event) SetLastUpdatedTime(v time.Time) *Event {
	s.LastUpdatedTime = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Event) SetRegion(v string) *Event {
	s.Region = &v
	return s
}

// SetService sets the Service field's value.
func (s *Event) SetService(v string) *Event {
	s.Service = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Event) SetStartTime(v time.Time) *Event {
	s.StartTime = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *Event) SetStatusCode(v string) *Event {
	s.StatusCode = &v
	return s
}

// The number of events of each issue type. Returned by the DescribeEventAggregates
// operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventAggregate
type EventAggregate struct {
	_ struct{} `type:"structure"`

	// The issue type for the associated count.
	AggregateValue *string `locationName:"aggregateValue" type:"string"`

	// The number of events of the associated issue type.
	Count *int64 `locationName:"count" type:"integer"`
}

// String returns the string representation
func (s EventAggregate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventAggregate) GoString() string {
	return s.String()
}

// SetAggregateValue sets the AggregateValue field's value.
func (s *EventAggregate) SetAggregateValue(v string) *EventAggregate {
	s.AggregateValue = &v
	return s
}

// SetCount sets the Count field's value.
func (s *EventAggregate) SetCount(v int64) *EventAggregate {
	s.Count = &v
	return s
}

// The detailed description of the event. Included in the information returned
// by the DescribeEventDetails operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventDescription
type EventDescription struct {
	_ struct{} `type:"structure"`

	// The most recent description of the event.
	LatestDescription *string `locationName:"latestDescription" type:"string"`
}

// String returns the string representation
func (s EventDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDescription) GoString() string {
	return s.String()
}

// SetLatestDescription sets the LatestDescription field's value.
func (s *EventDescription) SetLatestDescription(v string) *EventDescription {
	s.LatestDescription = &v
	return s
}

// Detailed information about an event. A combination of an Event object, an
// EventDescription object, and additional metadata about the event. Returned
// by the DescribeEventDetails operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventDetails
type EventDetails struct {
	_ struct{} `type:"structure"`

	// Summary information about the event.
	Event *Event `locationName:"event" type:"structure"`

	// The most recent description of the event.
	EventDescription *EventDescription `locationName:"eventDescription" type:"structure"`

	// Additional metadata about the event.
	EventMetadata map[string]*string `locationName:"eventMetadata" type:"map"`
}

// String returns the string representation
func (s EventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDetails) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *EventDetails) SetEvent(v *Event) *EventDetails {
	s.Event = v
	return s
}

// SetEventDescription sets the EventDescription field's value.
func (s *EventDetails) SetEventDescription(v *EventDescription) *EventDetails {
	s.EventDescription = v
	return s
}

// SetEventMetadata sets the EventMetadata field's value.
func (s *EventDetails) SetEventMetadata(v map[string]*string) *EventDetails {
	s.EventMetadata = v
	return s
}

// Error information returned when a DescribeEventDetails operation cannot find
// a specified event.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventDetailsErrorItem
type EventDetailsErrorItem struct {
	_ struct{} `type:"structure"`

	// A message that describes the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The name of the error.
	ErrorName *string `locationName:"errorName" type:"string"`

	// The unique identifier for the event. Format: arn:aws:health:event-region::event/EVENT_TYPE_PLUS_ID.
	// Example: arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331
	EventArn *string `locationName:"eventArn" type:"string"`
}

// String returns the string representation
func (s EventDetailsErrorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDetailsErrorItem) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *EventDetailsErrorItem) SetErrorMessage(v string) *EventDetailsErrorItem {
	s.ErrorMessage = &v
	return s
}

// SetErrorName sets the ErrorName field's value.
func (s *EventDetailsErrorItem) SetErrorName(v string) *EventDetailsErrorItem {
	s.ErrorName = &v
	return s
}

// SetEventArn sets the EventArn field's value.
func (s *EventDetailsErrorItem) SetEventArn(v string) *EventDetailsErrorItem {
	s.EventArn = &v
	return s
}

// The values to use to filter results from the DescribeEvents and DescribeEventAggregates
// operations.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventFilter
type EventFilter struct {
	_ struct{} `type:"structure"`

	// A list of AWS availability zones.
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	// A list of dates and times that the event ended.
	EndTimes []*DateTimeRange `locationName:"endTimes" min:"1" type:"list"`

	// A list of entity ARNs (unique identifiers).
	EntityArns []*string `locationName:"entityArns" min:"1" type:"list"`

	// A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS
	// volumes (vol-426ab23e).
	EntityValues []*string `locationName:"entityValues" min:"1" type:"list"`

	// A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/AWS_EC2_MAINTENANCE_5331",
	// "arn:aws:health:us-west-1::event/AWS_EBS_LOST_VOLUME_xyz"
	EventArns []*string `locationName:"eventArns" min:"1" type:"list"`

	// A list of event status codes.
	EventStatusCodes []*string `locationName:"eventStatusCodes" min:"1" type:"list"`

	// A list of event type category codes (issue, scheduledChange, or accountNotification).
	EventTypeCategories []*string `locationName:"eventTypeCategories" min:"1" type:"list"`

	// A list of unique identifiers for event types. For example, "AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED"
	EventTypeCodes []*string `locationName:"eventTypeCodes" min:"1" type:"list"`

	// A list of dates and times that the event was last updated.
	LastUpdatedTimes []*DateTimeRange `locationName:"lastUpdatedTimes" min:"1" type:"list"`

	// A list of AWS regions.
	Regions []*string `locationName:"regions" min:"1" type:"list"`

	// The AWS services associated with the event. For example, EC2, RDS.
	Services []*string `locationName:"services" min:"1" type:"list"`

	// A list of dates and times that the event began.
	StartTimes []*DateTimeRange `locationName:"startTimes" min:"1" type:"list"`

	// A map of entity tags attached to the affected entity.
	Tags []map[string]*string `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s EventFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventFilter"}
	if s.EndTimes != nil && len(s.EndTimes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndTimes", 1))
	}
	if s.EntityArns != nil && len(s.EntityArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityArns", 1))
	}
	if s.EntityValues != nil && len(s.EntityValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityValues", 1))
	}
	if s.EventArns != nil && len(s.EventArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventArns", 1))
	}
	if s.EventStatusCodes != nil && len(s.EventStatusCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventStatusCodes", 1))
	}
	if s.EventTypeCategories != nil && len(s.EventTypeCategories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeCategories", 1))
	}
	if s.EventTypeCodes != nil && len(s.EventTypeCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeCodes", 1))
	}
	if s.LastUpdatedTimes != nil && len(s.LastUpdatedTimes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastUpdatedTimes", 1))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 1))
	}
	if s.Services != nil && len(s.Services) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Services", 1))
	}
	if s.StartTimes != nil && len(s.StartTimes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartTimes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *EventFilter) SetAvailabilityZones(v []*string) *EventFilter {
	s.AvailabilityZones = v
	return s
}

// SetEndTimes sets the EndTimes field's value.
func (s *EventFilter) SetEndTimes(v []*DateTimeRange) *EventFilter {
	s.EndTimes = v
	return s
}

// SetEntityArns sets the EntityArns field's value.
func (s *EventFilter) SetEntityArns(v []*string) *EventFilter {
	s.EntityArns = v
	return s
}

// SetEntityValues sets the EntityValues field's value.
func (s *EventFilter) SetEntityValues(v []*string) *EventFilter {
	s.EntityValues = v
	return s
}

// SetEventArns sets the EventArns field's value.
func (s *EventFilter) SetEventArns(v []*string) *EventFilter {
	s.EventArns = v
	return s
}

// SetEventStatusCodes sets the EventStatusCodes field's value.
func (s *EventFilter) SetEventStatusCodes(v []*string) *EventFilter {
	s.EventStatusCodes = v
	return s
}

// SetEventTypeCategories sets the EventTypeCategories field's value.
func (s *EventFilter) SetEventTypeCategories(v []*string) *EventFilter {
	s.EventTypeCategories = v
	return s
}

// SetEventTypeCodes sets the EventTypeCodes field's value.
func (s *EventFilter) SetEventTypeCodes(v []*string) *EventFilter {
	s.EventTypeCodes = v
	return s
}

// SetLastUpdatedTimes sets the LastUpdatedTimes field's value.
func (s *EventFilter) SetLastUpdatedTimes(v []*DateTimeRange) *EventFilter {
	s.LastUpdatedTimes = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *EventFilter) SetRegions(v []*string) *EventFilter {
	s.Regions = v
	return s
}

// SetServices sets the Services field's value.
func (s *EventFilter) SetServices(v []*string) *EventFilter {
	s.Services = v
	return s
}

// SetStartTimes sets the StartTimes field's value.
func (s *EventFilter) SetStartTimes(v []*DateTimeRange) *EventFilter {
	s.StartTimes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventFilter) SetTags(v []map[string]*string) *EventFilter {
	s.Tags = v
	return s
}

// Metadata about a type of event that is reported by AWS Health. Data consists
// of the category (for example, issue), the service (for example, EC2), and
// the event type code (for example, AWS_EC2_SYSTEM_MAINTENANCE_EVENT).
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventType
type EventType struct {
	_ struct{} `type:"structure"`

	// A list of event type category codes (issue, scheduledChange, or accountNotification).
	Category *string `locationName:"category" min:"3" type:"string" enum:"eventTypeCategory"`

	// The unique identifier for the event type. The format is AWS_SERVICE_DESCRIPTION;
	// for example, AWS_EC2_SYSTEM_MAINTENANCE_EVENT.
	Code *string `locationName:"code" min:"3" type:"string"`

	// The AWS service that is affected by the event. For example, EC2, RDS.
	Service *string `locationName:"service" min:"2" type:"string"`
}

// String returns the string representation
func (s EventType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventType) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *EventType) SetCategory(v string) *EventType {
	s.Category = &v
	return s
}

// SetCode sets the Code field's value.
func (s *EventType) SetCode(v string) *EventType {
	s.Code = &v
	return s
}

// SetService sets the Service field's value.
func (s *EventType) SetService(v string) *EventType {
	s.Service = &v
	return s
}

// The values to use to filter results from the DescribeEventTypes operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EventTypeFilter
type EventTypeFilter struct {
	_ struct{} `type:"structure"`

	// A list of event type category codes (issue, scheduledChange, or accountNotification).
	EventTypeCategories []*string `locationName:"eventTypeCategories" min:"1" type:"list"`

	// A list of event type codes.
	EventTypeCodes []*string `locationName:"eventTypeCodes" min:"1" type:"list"`

	// The AWS services associated with the event. For example, EC2, RDS.
	Services []*string `locationName:"services" min:"1" type:"list"`
}

// String returns the string representation
func (s EventTypeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTypeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventTypeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventTypeFilter"}
	if s.EventTypeCategories != nil && len(s.EventTypeCategories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeCategories", 1))
	}
	if s.EventTypeCodes != nil && len(s.EventTypeCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeCodes", 1))
	}
	if s.Services != nil && len(s.Services) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Services", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTypeCategories sets the EventTypeCategories field's value.
func (s *EventTypeFilter) SetEventTypeCategories(v []*string) *EventTypeFilter {
	s.EventTypeCategories = v
	return s
}

// SetEventTypeCodes sets the EventTypeCodes field's value.
func (s *EventTypeFilter) SetEventTypeCodes(v []*string) *EventTypeFilter {
	s.EventTypeCodes = v
	return s
}

// SetServices sets the Services field's value.
func (s *EventTypeFilter) SetServices(v []*string) *EventTypeFilter {
	s.Services = v
	return s
}

const (
	// EntityStatusCodeImpaired is a entityStatusCode enum value
	EntityStatusCodeImpaired = "IMPAIRED"

	// EntityStatusCodeUnimpaired is a entityStatusCode enum value
	EntityStatusCodeUnimpaired = "UNIMPAIRED"

	// EntityStatusCodeUnknown is a entityStatusCode enum value
	EntityStatusCodeUnknown = "UNKNOWN"
)

const (
	// EventAggregateFieldEventTypeCategory is a eventAggregateField enum value
	EventAggregateFieldEventTypeCategory = "eventTypeCategory"
)

const (
	// EventStatusCodeOpen is a eventStatusCode enum value
	EventStatusCodeOpen = "open"

	// EventStatusCodeClosed is a eventStatusCode enum value
	EventStatusCodeClosed = "closed"

	// EventStatusCodeUpcoming is a eventStatusCode enum value
	EventStatusCodeUpcoming = "upcoming"
)

const (
	// EventTypeCategoryIssue is a eventTypeCategory enum value
	EventTypeCategoryIssue = "issue"

	// EventTypeCategoryAccountNotification is a eventTypeCategory enum value
	EventTypeCategoryAccountNotification = "accountNotification"

	// EventTypeCategoryScheduledChange is a eventTypeCategory enum value
	EventTypeCategoryScheduledChange = "scheduledChange"
)
