// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTagsToResource API operation for AWS Database Migration Service.
//
// Adds metadata tags to a DMS resource, including replication instance, endpoint,
// security group, and migration task. These tags can also be used with cost
// allocation reporting to track cost associated with DMS resources, or used
// in a Condition statement in an IAM policy for DMS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for AWS Database Migration Service.
//
// Creates an endpoint using the provided settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for AWS Database Migration Service.
//
// Creates an AWS DMS event notification subscription.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of AWS DMS source IDs (SourceIds) that triggers the events,
// and provide a list of event categories (EventCategories) for events you want
// to be notified of. If you specify both the SourceType and SourceIds, such
// as SourceType = replication-instance and SourceIdentifier = my-replinstance,
// you will be notified of all the replication instance events for the specified
// source. If you specify a SourceType but don't specify a SourceIdentifier,
// you receive notice of the events for that source type for all your AWS DMS
// sources. If you don't specify either SourceType nor SourceIdentifier, you
// will be notified of events generated from all AWS DMS sources belonging to
// your customer account.
//
// For more information about AWS DMS events, see  Working with Events and Notifications
//  (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the
// AWS Database MIgration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopicFault"
//   The SNS topic is invalid.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorizationFault"
//   You are not authorized for the SNS subscription.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationInstance = "CreateReplicationInstance"

// CreateReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationInstance for more information on using the CreateReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationInstanceRequest method.
//    req, resp := client.CreateReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstanceRequest(input *CreateReplicationInstanceInput) (req *request.Request, output *CreateReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationInstanceInput{}
	}

	output = &CreateReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationInstance API operation for AWS Database Migration Service.
//
// Creates the replication instance using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeInsufficientResourceCapacityFault "InsufficientResourceCapacityFault"
//   There are not enough resources allocated to the database migration.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceededFault"
//   The storage quota has been exceeded.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs "ReplicationSubnetGroupDoesNotCoverEnoughAZs"
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The subnet provided is invalid.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstance(input *CreateReplicationInstanceInput) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	return out, req.Send()
}

// CreateReplicationInstanceWithContext is the same as CreateReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationInstanceWithContext(ctx aws.Context, input *CreateReplicationInstanceInput, opts ...request.Option) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationSubnetGroup = "CreateReplicationSubnetGroup"

// CreateReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationSubnetGroup for more information on using the CreateReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationSubnetGroupRequest method.
//    req, resp := client.CreateReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupRequest(input *CreateReplicationSubnetGroupInput) (req *request.Request, output *CreateReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationSubnetGroupInput{}
	}

	output = &CreateReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs "ReplicationSubnetGroupDoesNotCoverEnoughAZs"
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The subnet provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroup(input *CreateReplicationSubnetGroupInput) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateReplicationSubnetGroupWithContext is the same as CreateReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupWithContext(ctx aws.Context, input *CreateReplicationSubnetGroupInput, opts ...request.Option) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationTask = "CreateReplicationTask"

// CreateReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationTask for more information on using the CreateReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationTaskRequest method.
//    req, resp := client.CreateReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTaskRequest(input *CreateReplicationTaskInput) (req *request.Request, output *CreateReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationTaskInput{}
	}

	output = &CreateReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationTask API operation for AWS Database Migration Service.
//
// Creates a replication task using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTask(input *CreateReplicationTaskInput) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	return out, req.Send()
}

// CreateReplicationTaskWithContext is the same as CreateReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationTaskWithContext(ctx aws.Context, input *CreateReplicationTaskInput, opts ...request.Option) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCertificate API operation for AWS Database Migration Service.
//
// Deletes the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for AWS Database Migration Service.
//
// Deletes the specified endpoint.
//
// All tasks associated with the endpoint must be deleted before you can delete
// the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for AWS Database Migration Service.
//
// Deletes an AWS DMS event subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationInstance = "DeleteReplicationInstance"

// DeleteReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationInstance for more information on using the DeleteReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationInstanceRequest method.
//    req, resp := client.DeleteReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstanceRequest(input *DeleteReplicationInstanceInput) (req *request.Request, output *DeleteReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationInstanceInput{}
	}

	output = &DeleteReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationInstance API operation for AWS Database Migration Service.
//
// Deletes the specified replication instance.
//
// You must delete any migration tasks that are associated with the replication
// instance before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstance(input *DeleteReplicationInstanceInput) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	return out, req.Send()
}

// DeleteReplicationInstanceWithContext is the same as DeleteReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationInstanceWithContext(ctx aws.Context, input *DeleteReplicationInstanceInput, opts ...request.Option) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationSubnetGroup = "DeleteReplicationSubnetGroup"

// DeleteReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationSubnetGroup for more information on using the DeleteReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationSubnetGroupRequest method.
//    req, resp := client.DeleteReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupRequest(input *DeleteReplicationSubnetGroupInput) (req *request.Request, output *DeleteReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationSubnetGroupInput{}
	}

	output = &DeleteReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Deletes a subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroup(input *DeleteReplicationSubnetGroupInput) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteReplicationSubnetGroupWithContext is the same as DeleteReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupWithContext(ctx aws.Context, input *DeleteReplicationSubnetGroupInput, opts ...request.Option) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationTask = "DeleteReplicationTask"

// DeleteReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationTask for more information on using the DeleteReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationTaskRequest method.
//    req, resp := client.DeleteReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTaskRequest(input *DeleteReplicationTaskInput) (req *request.Request, output *DeleteReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskInput{}
	}

	output = &DeleteReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationTask API operation for AWS Database Migration Service.
//
// Deletes the specified replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTask(input *DeleteReplicationTaskInput) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	return out, req.Send()
}

// DeleteReplicationTaskWithContext is the same as DeleteReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationTaskWithContext(ctx aws.Context, input *DeleteReplicationTaskInput, opts ...request.Option) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for AWS Database Migration Service.
//
// Lists all of the AWS DMS attributes for a customer account. The attributes
// include AWS DMS quotas for the account, such as the number of replication
// instances allowed. The description for a quota includes the quota name, current
// usage toward that quota, and the quota's maximum value.
//
// This command does not take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for AWS Database Migration Service.
//
// Provides a description of the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCertificatesPages iterates over the pages of a DescribeCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCertificates operation.
//    pageNum := 0
//    err := client.DescribeCertificatesPages(params,
//        func(page *DescribeCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeCertificatesPages(input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool) error {
	return c.DescribeCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCertificatesPagesWithContext same as DescribeCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesPagesWithContext(ctx aws.Context, input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeCertificatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnections for more information on using the DescribeConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *DescribeConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &DescribeConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Database Migration Service.
//
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnections(input *DescribeConnectionsInput) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionsWithContext is the same as DescribeConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsWithContext(ctx aws.Context, input *DescribeConnectionsInput, opts ...request.Option) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConnectionsPages iterates over the pages of a DescribeConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConnections operation.
//    pageNum := 0
//    err := client.DescribeConnectionsPages(params,
//        func(page *DescribeConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeConnectionsPages(input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool) error {
	return c.DescribeConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConnectionsPagesWithContext same as DescribeConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsPagesWithContext(ctx aws.Context, input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeConnectionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEndpointTypes = "DescribeEndpointTypes"

// DescribeEndpointTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointTypes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointTypes for more information on using the DescribeEndpointTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointTypesRequest method.
//    req, resp := client.DescribeEndpointTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypesRequest(input *DescribeEndpointTypesInput) (req *request.Request, output *DescribeEndpointTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointTypesInput{}
	}

	output = &DescribeEndpointTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointTypes API operation for AWS Database Migration Service.
//
// Returns information about the type of endpoints available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointTypes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypes(input *DescribeEndpointTypesInput) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	return out, req.Send()
}

// DescribeEndpointTypesWithContext is the same as DescribeEndpointTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, opts ...request.Option) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointTypesPages iterates over the pages of a DescribeEndpointTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpointTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEndpointTypes operation.
//    pageNum := 0
//    err := client.DescribeEndpointTypesPages(params,
//        func(page *DescribeEndpointTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEndpointTypesPages(input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool) error {
	return c.DescribeEndpointTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointTypesPagesWithContext same as DescribeEndpointTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesPagesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEndpointTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for AWS Database Migration Service.
//
// Returns information about the endpoints for your account in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointsPages iterates over the pages of a DescribeEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEndpoints operation.
//    pageNum := 0
//    err := client.DescribeEndpointsPages(params,
//        func(page *DescribeEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEndpointsPages(input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool) error {
	return c.DescribeEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointsPagesWithContext same as DescribeEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsPagesWithContext(ctx aws.Context, input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEndpointsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for AWS Database Migration Service.
//
// Lists categories for all event source types, or, if specified, for a specified
// source type. You can see a list of the event categories and source types
// in  Working with Events and Notifications  (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
// in the AWS Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for AWS Database Migration Service.
//
// Lists all the event subscriptions for a customer account. The description
// of a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify SubscriptionName, this action lists the description for that
// subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS Database Migration Service.
//
// Lists events for a given source identifier and source type. You can also
// specify a start and end time. For more information on AWS DMS events, see
//  Working with Events and Notifications  (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeOrderableReplicationInstances = "DescribeOrderableReplicationInstances"

// DescribeOrderableReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableReplicationInstances for more information on using the DescribeOrderableReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableReplicationInstancesRequest method.
//    req, resp := client.DescribeOrderableReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesRequest(input *DescribeOrderableReplicationInstancesInput) (req *request.Request, output *DescribeOrderableReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableReplicationInstancesInput{}
	}

	output = &DescribeOrderableReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about the replication instance types that can be created
// in the specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeOrderableReplicationInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstances(input *DescribeOrderableReplicationInstancesInput) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesWithContext is the same as DescribeOrderableReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, opts ...request.Option) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesPages iterates over the pages of a DescribeOrderableReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableReplicationInstances operation.
//    pageNum := 0
//    err := client.DescribeOrderableReplicationInstancesPages(params,
//        func(page *DescribeOrderableReplicationInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPages(input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool) error {
	return c.DescribeOrderableReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableReplicationInstancesPagesWithContext same as DescribeOrderableReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeOrderableReplicationInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeRefreshSchemasStatus = "DescribeRefreshSchemasStatus"

// DescribeRefreshSchemasStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchemasStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRefreshSchemasStatus for more information on using the DescribeRefreshSchemasStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRefreshSchemasStatusRequest method.
//    req, resp := client.DescribeRefreshSchemasStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusRequest(input *DescribeRefreshSchemasStatusInput) (req *request.Request, output *DescribeRefreshSchemasStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchemasStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRefreshSchemasStatusInput{}
	}

	output = &DescribeRefreshSchemasStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRefreshSchemasStatus API operation for AWS Database Migration Service.
//
// Returns the status of the RefreshSchemas operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRefreshSchemasStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatus(input *DescribeRefreshSchemasStatusInput) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	return out, req.Send()
}

// DescribeRefreshSchemasStatusWithContext is the same as DescribeRefreshSchemasStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRefreshSchemasStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusWithContext(ctx aws.Context, input *DescribeRefreshSchemasStatusInput, opts ...request.Option) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReplicationInstances = "DescribeReplicationInstances"

// DescribeReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationInstances for more information on using the DescribeReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationInstancesRequest method.
//    req, resp := client.DescribeReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstancesRequest(input *DescribeReplicationInstancesInput) (req *request.Request, output *DescribeReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstancesInput{}
	}

	output = &DescribeReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about replication instances for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstances(input *DescribeReplicationInstancesInput) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeReplicationInstancesWithContext is the same as DescribeReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, opts ...request.Option) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationInstancesPages iterates over the pages of a DescribeReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationInstances operation.
//    pageNum := 0
//    err := client.DescribeReplicationInstancesPages(params,
//        func(page *DescribeReplicationInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationInstancesPages(input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool) error {
	return c.DescribeReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationInstancesPagesWithContext same as DescribeReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReplicationInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeReplicationSubnetGroups = "DescribeReplicationSubnetGroups"

// DescribeReplicationSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationSubnetGroups for more information on using the DescribeReplicationSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationSubnetGroupsRequest method.
//    req, resp := client.DescribeReplicationSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsRequest(input *DescribeReplicationSubnetGroupsInput) (req *request.Request, output *DescribeReplicationSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationSubnetGroupsInput{}
	}

	output = &DescribeReplicationSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationSubnetGroups API operation for AWS Database Migration Service.
//
// Returns information about the replication subnet groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroups(input *DescribeReplicationSubnetGroupsInput) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsWithContext is the same as DescribeReplicationSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, opts ...request.Option) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsPages iterates over the pages of a DescribeReplicationSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeReplicationSubnetGroupsPages(params,
//        func(page *DescribeReplicationSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPages(input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool) error {
	return c.DescribeReplicationSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationSubnetGroupsPagesWithContext same as DescribeReplicationSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReplicationSubnetGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeReplicationTaskAssessmentResults = "DescribeReplicationTaskAssessmentResults"

// DescribeReplicationTaskAssessmentResultsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskAssessmentResults operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskAssessmentResults for more information on using the DescribeReplicationTaskAssessmentResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTaskAssessmentResultsRequest method.
//    req, resp := client.DescribeReplicationTaskAssessmentResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsRequest(input *DescribeReplicationTaskAssessmentResultsInput) (req *request.Request, output *DescribeReplicationTaskAssessmentResultsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskAssessmentResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskAssessmentResultsInput{}
	}

	output = &DescribeReplicationTaskAssessmentResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskAssessmentResults API operation for AWS Database Migration Service.
//
// Returns the task assessment results from Amazon S3. This action always returns
// the latest results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskAssessmentResults for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResults(input *DescribeReplicationTaskAssessmentResultsInput) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsWithContext is the same as DescribeReplicationTaskAssessmentResults with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskAssessmentResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, opts ...request.Option) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsPages iterates over the pages of a DescribeReplicationTaskAssessmentResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskAssessmentResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTaskAssessmentResults operation.
//    pageNum := 0
//    err := client.DescribeReplicationTaskAssessmentResultsPages(params,
//        func(page *DescribeReplicationTaskAssessmentResultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPages(input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool) error {
	return c.DescribeReplicationTaskAssessmentResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskAssessmentResultsPagesWithContext same as DescribeReplicationTaskAssessmentResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskAssessmentResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskAssessmentResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReplicationTaskAssessmentResultsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeReplicationTasks = "DescribeReplicationTasks"

// DescribeReplicationTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTasks operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTasks for more information on using the DescribeReplicationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTasksRequest method.
//    req, resp := client.DescribeReplicationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasksRequest(input *DescribeReplicationTasksInput) (req *request.Request, output *DescribeReplicationTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTasksInput{}
	}

	output = &DescribeReplicationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTasks API operation for AWS Database Migration Service.
//
// Returns information about replication tasks for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasks(input *DescribeReplicationTasksInput) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	return out, req.Send()
}

// DescribeReplicationTasksWithContext is the same as DescribeReplicationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, opts ...request.Option) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTasksPages iterates over the pages of a DescribeReplicationTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTasks operation.
//    pageNum := 0
//    err := client.DescribeReplicationTasksPages(params,
//        func(page *DescribeReplicationTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTasksPages(input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool) error {
	return c.DescribeReplicationTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTasksPagesWithContext same as DescribeReplicationTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksPagesWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReplicationTasksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeSchemas = "DescribeSchemas"

// DescribeSchemasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchemas operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchemas for more information on using the DescribeSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSchemasRequest method.
//    req, resp := client.DescribeSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemasRequest(input *DescribeSchemasInput) (req *request.Request, output *DescribeSchemasOutput) {
	op := &request.Operation{
		Name:       opDescribeSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSchemasInput{}
	}

	output = &DescribeSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchemas API operation for AWS Database Migration Service.
//
// Returns information about the schema for the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeSchemas for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemas(input *DescribeSchemasInput) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	return out, req.Send()
}

// DescribeSchemasWithContext is the same as DescribeSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasWithContext(ctx aws.Context, input *DescribeSchemasInput, opts ...request.Option) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSchemasPages iterates over the pages of a DescribeSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSchemas operation.
//    pageNum := 0
//    err := client.DescribeSchemasPages(params,
//        func(page *DescribeSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeSchemasPages(input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool) error {
	return c.DescribeSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSchemasPagesWithContext same as DescribeSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasPagesWithContext(ctx aws.Context, input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeSchemasOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeTableStatistics = "DescribeTableStatistics"

// DescribeTableStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableStatistics operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableStatistics for more information on using the DescribeTableStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableStatisticsRequest method.
//    req, resp := client.DescribeTableStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatisticsRequest(input *DescribeTableStatisticsInput) (req *request.Request, output *DescribeTableStatisticsOutput) {
	op := &request.Operation{
		Name:       opDescribeTableStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTableStatisticsInput{}
	}

	output = &DescribeTableStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableStatistics API operation for AWS Database Migration Service.
//
// Returns table statistics on the database migration task, including table
// name, rows inserted, rows updated, and rows deleted.
//
// Note that the "last updated" column the DMS console only indicates the time
// that AWS DMS last updated the table statistics record for a table. It does
// not indicate the time of the last update to the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeTableStatistics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatistics(input *DescribeTableStatisticsInput) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	return out, req.Send()
}

// DescribeTableStatisticsWithContext is the same as DescribeTableStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, opts ...request.Option) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTableStatisticsPages iterates over the pages of a DescribeTableStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTableStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTableStatistics operation.
//    pageNum := 0
//    err := client.DescribeTableStatisticsPages(params,
//        func(page *DescribeTableStatisticsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeTableStatisticsPages(input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool) error {
	return c.DescribeTableStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTableStatisticsPagesWithContext same as DescribeTableStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsPagesWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTableStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTableStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeTableStatisticsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificate for more information on using the ImportCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCertificateRequest method.
//    req, resp := client.ImportCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	output = &ImportCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCertificate API operation for AWS Database Migration Service.
//
// Uploads the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeInvalidCertificateFault "InvalidCertificateFault"
//   The certificate was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateWithContext is the same as ImportCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ImportCertificateWithContext(ctx aws.Context, input *ImportCertificateInput, opts ...request.Option) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Database Migration Service.
//
// Lists all tags for an AWS DMS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEndpoint = "ModifyEndpoint"

// ModifyEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEndpoint for more information on using the ModifyEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEndpointRequest method.
//    req, resp := client.ModifyEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpointRequest(input *ModifyEndpointInput) (req *request.Request, output *ModifyEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEndpointInput{}
	}

	output = &ModifyEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEndpoint API operation for AWS Database Migration Service.
//
// Modifies the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpoint(input *ModifyEndpointInput) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	return out, req.Send()
}

// ModifyEndpointWithContext is the same as ModifyEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEndpointWithContext(ctx aws.Context, input *ModifyEndpointInput, opts ...request.Option) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for AWS Database Migration Service.
//
// Modifies an existing AWS DMS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopicFault"
//   The SNS topic is invalid.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorizationFault"
//   You are not authorized for the SNS subscription.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationInstance = "ModifyReplicationInstance"

// ModifyReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationInstance for more information on using the ModifyReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationInstanceRequest method.
//    req, resp := client.ModifyReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstanceRequest(input *ModifyReplicationInstanceInput) (req *request.Request, output *ModifyReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationInstanceInput{}
	}

	output = &ModifyReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationInstance API operation for AWS Database Migration Service.
//
// Modifies the replication instance to apply new settings. You can change one
// or more parameters by specifying these parameters and the new values in the
// request.
//
// Some settings are applied during the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInsufficientResourceCapacityFault "InsufficientResourceCapacityFault"
//   There are not enough resources allocated to the database migration.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceededFault"
//   The storage quota has been exceeded.
//
//   * ErrCodeUpgradeDependencyFailureFault "UpgradeDependencyFailureFault"
//   An upgrade dependency is preventing the database migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstance(input *ModifyReplicationInstanceInput) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	return out, req.Send()
}

// ModifyReplicationInstanceWithContext is the same as ModifyReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationInstanceWithContext(ctx aws.Context, input *ModifyReplicationInstanceInput, opts ...request.Option) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationSubnetGroup = "ModifyReplicationSubnetGroup"

// ModifyReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationSubnetGroup for more information on using the ModifyReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationSubnetGroupRequest method.
//    req, resp := client.ModifyReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupRequest(input *ModifyReplicationSubnetGroupInput) (req *request.Request, output *ModifyReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationSubnetGroupInput{}
	}

	output = &ModifyReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Modifies the settings for the specified replication subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedFault "AccessDeniedFault"
//   AWS DMS was denied access to the endpoint.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   The specified subnet is already in use.
//
//   * ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs "ReplicationSubnetGroupDoesNotCoverEnoughAZs"
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The subnet provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroup(input *ModifyReplicationSubnetGroupInput) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyReplicationSubnetGroupWithContext is the same as ModifyReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupWithContext(ctx aws.Context, input *ModifyReplicationSubnetGroupInput, opts ...request.Option) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationTask = "ModifyReplicationTask"

// ModifyReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationTask for more information on using the ModifyReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationTaskRequest method.
//    req, resp := client.ModifyReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTaskRequest(input *ModifyReplicationTaskInput) (req *request.Request, output *ModifyReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationTaskInput{}
	}

	output = &ModifyReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationTask API operation for AWS Database Migration Service.
//
// Modifies the specified replication task.
//
// You can't modify the task endpoints. The task must be stopped before you
// can modify it.
//
// For more information about AWS DMS tasks, see the AWS DMS user guide at
// Working with Migration Tasks  (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeResourceAlreadyExistsFault "ResourceAlreadyExistsFault"
//   The resource you are attempting to create already exists.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTask(input *ModifyReplicationTaskInput) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	return out, req.Send()
}

// ModifyReplicationTaskWithContext is the same as ModifyReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationTaskWithContext(ctx aws.Context, input *ModifyReplicationTaskInput, opts ...request.Option) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRefreshSchemas = "RefreshSchemas"

// RefreshSchemasRequest generates a "aws/request.Request" representing the
// client's request for the RefreshSchemas operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshSchemas for more information on using the RefreshSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RefreshSchemasRequest method.
//    req, resp := client.RefreshSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemasRequest(input *RefreshSchemasInput) (req *request.Request, output *RefreshSchemasOutput) {
	op := &request.Operation{
		Name:       opRefreshSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshSchemasInput{}
	}

	output = &RefreshSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshSchemas API operation for AWS Database Migration Service.
//
// Populates the schema for the specified endpoint. This is an asynchronous
// operation and can take several minutes. You can check the status of this
// operation by calling the DescribeRefreshSchemasStatus operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RefreshSchemas for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemas(input *RefreshSchemasInput) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	return out, req.Send()
}

// RefreshSchemasWithContext is the same as RefreshSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RefreshSchemasWithContext(ctx aws.Context, input *RefreshSchemasInput, opts ...request.Option) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReloadTables = "ReloadTables"

// ReloadTablesRequest generates a "aws/request.Request" representing the
// client's request for the ReloadTables operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReloadTables for more information on using the ReloadTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReloadTablesRequest method.
//    req, resp := client.ReloadTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTablesRequest(input *ReloadTablesInput) (req *request.Request, output *ReloadTablesOutput) {
	op := &request.Operation{
		Name:       opReloadTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReloadTablesInput{}
	}

	output = &ReloadTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReloadTables API operation for AWS Database Migration Service.
//
// Reloads the target database table with the source data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ReloadTables for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTables(input *ReloadTablesInput) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	return out, req.Send()
}

// ReloadTablesWithContext is the same as ReloadTables with the addition of
// the ability to pass a context and additional request options.
//
// See ReloadTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ReloadTablesWithContext(ctx aws.Context, input *ReloadTablesInput, opts ...request.Option) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTagsFromResource API operation for AWS Database Migration Service.
//
// Removes metadata tags from a DMS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTask = "StartReplicationTask"

// StartReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTask for more information on using the StartReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationTaskRequest method.
//    req, resp := client.StartReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTaskRequest(input *StartReplicationTaskInput) (req *request.Request, output *StartReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskInput{}
	}

	output = &StartReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTask API operation for AWS Database Migration Service.
//
// Starts the replication task.
//
// For more information about AWS DMS tasks, see the AWS DMS user guide at
// Working with Migration Tasks  (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTask(input *StartReplicationTaskInput) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	return out, req.Send()
}

// StartReplicationTaskWithContext is the same as StartReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskWithContext(ctx aws.Context, input *StartReplicationTaskInput, opts ...request.Option) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTaskAssessment = "StartReplicationTaskAssessment"

// StartReplicationTaskAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTaskAssessment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTaskAssessment for more information on using the StartReplicationTaskAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationTaskAssessmentRequest method.
//    req, resp := client.StartReplicationTaskAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRequest(input *StartReplicationTaskAssessmentInput) (req *request.Request, output *StartReplicationTaskAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTaskAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskAssessmentInput{}
	}

	output = &StartReplicationTaskAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTaskAssessment API operation for AWS Database Migration Service.
//
// Starts the replication task assessment for unsupported data types in the
// source database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTaskAssessment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessment(input *StartReplicationTaskAssessmentInput) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	return out, req.Send()
}

// StartReplicationTaskAssessmentWithContext is the same as StartReplicationTaskAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTaskAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentWithContext(ctx aws.Context, input *StartReplicationTaskAssessmentInput, opts ...request.Option) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplicationTask = "StopReplicationTask"

// StopReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplicationTask for more information on using the StopReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopReplicationTaskRequest method.
//    req, resp := client.StopReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTaskRequest(input *StopReplicationTaskInput) (req *request.Request, output *StopReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStopReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationTaskInput{}
	}

	output = &StopReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplicationTask API operation for AWS Database Migration Service.
//
// Stops the replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StopReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTask(input *StopReplicationTaskInput) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	return out, req.Send()
}

// StopReplicationTaskWithContext is the same as StopReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StopReplicationTaskWithContext(ctx aws.Context, input *StopReplicationTaskInput, opts ...request.Option) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestConnection = "TestConnection"

// TestConnectionRequest generates a "aws/request.Request" representing the
// client's request for the TestConnection operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestConnection for more information on using the TestConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestConnectionRequest method.
//    req, resp := client.TestConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnectionRequest(input *TestConnectionInput) (req *request.Request, output *TestConnectionOutput) {
	op := &request.Operation{
		Name:       opTestConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestConnectionInput{}
	}

	output = &TestConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestConnection API operation for AWS Database Migration Service.
//
// Tests the connection between the replication instance and the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation TestConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateFault "InvalidResourceStateFault"
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   AWS DMS cannot access the KMS key.
//
//   * ErrCodeResourceQuotaExceededFault "ResourceQuotaExceededFault"
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnection(input *TestConnectionInput) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	return out, req.Send()
}

// TestConnectionWithContext is the same as TestConnection with the addition of
// the ability to pass a context and additional request options.
//
// See TestConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) TestConnectionWithContext(ctx aws.Context, input *TestConnectionInput, opts ...request.Option) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a quota for an AWS account, for example, the number of replication
// instances allowed.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AccountQuota
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the AWS DMS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

// SetAccountQuotaName sets the AccountQuotaName field's value.
func (s *AccountQuota) SetAccountQuotaName(v string) *AccountQuota {
	s.AccountQuotaName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *AccountQuota) SetMax(v int64) *AccountQuota {
	s.Max = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountQuota) SetUsed(v int64) *AccountQuota {
	s.Used = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResourceMessage
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS DMS resource the tag is to be added
	// to. AWS DMS resources include a replication instance, endpoint, and a replication
	// task.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag to be assigned to the DMS resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsToResourceInput) SetResourceArn(v string) *AddTagsToResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResourceResponse
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// The SSL certificate that can be used to encrypt connections between the endpoints
// and the replication instance.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Certificate
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The date that the certificate was created.
	CertificateCreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The customer-assigned name of the certificate. Valid characters are A-z and
	// 0-9.
	CertificateIdentifier *string `type:"string"`

	// The owner of the certificate.
	CertificateOwner *string `type:"string"`

	// The contents of the .pem X.509 certificate file for the certificate.
	CertificatePem *string `type:"string"`

	// The location of the imported Oracle Wallet certificate for use with SSL.
	//
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The key length of the cryptographic algorithm being used.
	KeyLength *int64 `type:"integer"`

	// The signing algorithm for the certificate.
	SigningAlgorithm *string `type:"string"`

	// The beginning date that the certificate is valid.
	ValidFromDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The final date that the certificate is valid.
	ValidToDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateCreationDate sets the CertificateCreationDate field's value.
func (s *Certificate) SetCertificateCreationDate(v time.Time) *Certificate {
	s.CertificateCreationDate = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateOwner sets the CertificateOwner field's value.
func (s *Certificate) SetCertificateOwner(v string) *Certificate {
	s.CertificateOwner = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *Certificate) SetCertificatePem(v string) *Certificate {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *Certificate) SetCertificateWallet(v []byte) *Certificate {
	s.CertificateWallet = v
	return s
}

// SetKeyLength sets the KeyLength field's value.
func (s *Certificate) SetKeyLength(v int64) *Certificate {
	s.KeyLength = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *Certificate) SetSigningAlgorithm(v string) *Certificate {
	s.SigningAlgorithm = &v
	return s
}

// SetValidFromDate sets the ValidFromDate field's value.
func (s *Certificate) SetValidFromDate(v time.Time) *Certificate {
	s.ValidFromDate = &v
	return s
}

// SetValidToDate sets the ValidToDate field's value.
func (s *Certificate) SetValidToDate(v time.Time) *Certificate {
	s.ValidToDate = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Connection
type Connection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The identifier of the endpoint. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The error message when the connection last failed.
	LastFailureMessage *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// The connection status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Connection) SetEndpointArn(v string) *Connection {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Connection) SetEndpointIdentifier(v string) *Connection {
	s.EndpointIdentifier = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *Connection) SetLastFailureMessage(v string) *Connection {
	s.LastFailureMessage = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *Connection) SetReplicationInstanceArn(v string) *Connection {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *Connection) SetReplicationInstanceIdentifier(v string) *Connection {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connection) SetStatus(v string) *Connection {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpointMessage
type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database.
	DatabaseName *string `type:"string"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For more
	// information about the available settings, see the Using Object Mapping to
	// Migrate Data to DynamoDB section at  Using an Amazon DynamoDB Database as
	// a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html).
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	//
	// EndpointIdentifier is a required field
	EndpointIdentifier *string `type:"string" required:"true"`

	// The type of endpoint.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values, depending on the EndPointType,
	// include MYSQL, ORACLE, POSTGRES, MARIADB, AURORA, REDSHIFT, S3, SYBASE, DYNAMODB,
	// MONGODB, and SQLSERVER.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// Additional attributes associated with the connection.
	ExtraConnectionAttributes *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the connection parameters.
	// If you do not specify a value for the KmsKeyId parameter, then AWS DMS will
	// use your default encryption key. AWS KMS creates the default encryption key
	// for your AWS account. Your AWS account has a different default encryption
	// key for each AWS region.
	KmsKeyId *string `type:"string"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see the Configuration Properties When Using
	// MongoDB as a Source for AWS Database Migration Service section at  Using
	// Amazon S3 as a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html).
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The password to be used to login to the endpoint database.
	Password *string `type:"string"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the target S3 endpoint. For more information
	// about the available settings, see the Extra Connection Attributes section
	// at  Using Amazon S3 as a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html).
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The SSL mode to use for the SSL connection.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// Tags to be added to the endpoint.
	Tags []*Tag `type:"list"`

	// The user name to be used to login to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIdentifier"))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateEndpointInput) SetCertificateArn(v string) *CreateEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateEndpointInput) SetDatabaseName(v string) *CreateEndpointInput {
	s.DatabaseName = &v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *CreateEndpointInput) SetDynamoDbSettings(v *DynamoDbSettings) *CreateEndpointInput {
	s.DynamoDbSettings = v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *CreateEndpointInput) SetEndpointIdentifier(v string) *CreateEndpointInput {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateEndpointInput) SetEndpointType(v string) *CreateEndpointInput {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *CreateEndpointInput) SetEngineName(v string) *CreateEndpointInput {
	s.EngineName = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *CreateEndpointInput) SetExtraConnectionAttributes(v string) *CreateEndpointInput {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEndpointInput) SetKmsKeyId(v string) *CreateEndpointInput {
	s.KmsKeyId = &v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *CreateEndpointInput) SetMongoDbSettings(v *MongoDbSettings) *CreateEndpointInput {
	s.MongoDbSettings = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateEndpointInput) SetPassword(v string) *CreateEndpointInput {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateEndpointInput) SetPort(v int64) *CreateEndpointInput {
	s.Port = &v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *CreateEndpointInput) SetS3Settings(v *S3Settings) *CreateEndpointInput {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateEndpointInput) SetServerName(v string) *CreateEndpointInput {
	s.ServerName = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *CreateEndpointInput) SetSslMode(v string) *CreateEndpointInput {
	s.SslMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateEndpointInput) SetUsername(v string) *CreateEndpointInput {
	s.Username = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpointResponse
type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was created.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateEndpointOutput) SetEndpoint(v *Endpoint) *CreateEndpointOutput {
	s.Endpoint = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscriptionMessage
type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, or set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// You can see a list of the categories for a given source type by calling the
	// DescribeEventCategories action or in the topic  Working with Events and Notifications
	// (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the
	// AWS Database Migration Service User Guide.
	EventCategories []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// The list of identifiers of the event sources for which events will be returned.
	// If not specified, then all sources are included in the response. An identifier
	// must begin with a letter and must contain only ASCII letters, digits, and
	// hyphens; it cannot end with a hyphen or contain two consecutive hyphens.
	SourceIds []*string `type:"list"`

	// The type of AWS DMS resource that generates the events. For example, if you
	// want to be notified of events generated by a replication instance, you set
	// this parameter to replication-instance. If this value is not specified, all
	// events are returned.
	//
	// Valid values: replication-instance | migration-task
	SourceType *string `type:"string"`

	// The name of the DMS event notification subscription.
	//
	// Constraints: The name must be less than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A tag to be attached to the event subscription.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscriptionResponse
type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was created.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstanceMessage
type CreateReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// replication instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the replication instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's region.
	//
	// Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the content on the replication
	// instance. If you do not specify a value for the KmsKeyId parameter, then
	// AWS DMS will use your default encryption key. AWS KMS creates the default
	// encryption key for your AWS account. Your AWS account has a different default
	// encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance as specified
	// by the replication instance class.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	//
	// ReplicationInstanceClass is a required field
	ReplicationInstanceClass *string `type:"string" required:"true"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	//
	// ReplicationInstanceIdentifier is a required field
	ReplicationInstanceIdentifier *string `type:"string" required:"true"`

	// A subnet group to associate with the replication instance.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// Tags to be associated with the replication instance.
	Tags []*Tag `type:"list"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s CreateReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationInstanceInput"}
	if s.ReplicationInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceClass"))
	}
	if s.ReplicationInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateReplicationInstanceInput) SetAllocatedStorage(v int64) *CreateReplicationInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateReplicationInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateReplicationInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateReplicationInstanceInput) SetAvailabilityZone(v string) *CreateReplicationInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateReplicationInstanceInput) SetEngineVersion(v string) *CreateReplicationInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateReplicationInstanceInput) SetKmsKeyId(v string) *CreateReplicationInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateReplicationInstanceInput) SetMultiAZ(v bool) *CreateReplicationInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateReplicationInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateReplicationInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateReplicationInstanceInput) SetPubliclyAccessible(v bool) *CreateReplicationInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceClass(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationInstanceInput) SetTags(v []*Tag) *CreateReplicationInstanceInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateReplicationInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateReplicationInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstanceResponse
type CreateReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was created.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *CreateReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *CreateReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroupMessage
type CreateReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	//
	// ReplicationSubnetGroupDescription is a required field
	ReplicationSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the replication subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// spaces, underscores, or hyphens. Must not be "default".
	//
	// Example: mySubnetgroup
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The tag to be assigned to the subnet group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupDescription"))
	}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupDescription(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateReplicationSubnetGroupInput) SetSubnetIds(v []*string) *CreateReplicationSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationSubnetGroupInput) SetTags(v []*Tag) *CreateReplicationSubnetGroupInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroupResponse
type CreateReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The replication subnet group that was created.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *CreateReplicationSubnetGroupOutput) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *CreateReplicationSubnetGroupOutput {
	s.ReplicationSubnetGroup = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTaskMessage
type CreateReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The start time for the Change Data Capture (CDC) operation.
	CdcStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The migration type.
	//
	// MigrationType is a required field
	MigrationType *string `type:"string" required:"true" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ReplicationTaskIdentifier is a required field
	ReplicationTaskIdentifier *string `type:"string" required:"true"`

	// Settings for the task, such as target metadata settings. For a complete list
	// of task settings, see Task Settings for AWS Database Migration Service Tasks
	// (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
	ReplicationTaskSettings *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// SourceEndpointArn is a required field
	SourceEndpointArn *string `type:"string" required:"true"`

	// When using the AWS CLI or boto3, provide the path of the JSON file that contains
	// the table mappings. Precede the path with "file://". When working with the
	// DMS API, provide the JSON as the parameter value.
	//
	// For example, --table-mappings file://mappingfile.json
	//
	// TableMappings is a required field
	TableMappings *string `type:"string" required:"true"`

	// Tags to be added to the replication instance.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// TargetEndpointArn is a required field
	TargetEndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationTaskInput"}
	if s.MigrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}
	if s.ReplicationTaskIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskIdentifier"))
	}
	if s.SourceEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEndpointArn"))
	}
	if s.TableMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("TableMappings"))
	}
	if s.TargetEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *CreateReplicationTaskInput) SetCdcStartTime(v time.Time) *CreateReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *CreateReplicationTaskInput) SetMigrationType(v string) *CreateReplicationTaskInput {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *CreateReplicationTaskInput) SetReplicationInstanceArn(v string) *CreateReplicationTaskInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskIdentifier(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskSettings(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskSettings = &v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetSourceEndpointArn(v string) *CreateReplicationTaskInput {
	s.SourceEndpointArn = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *CreateReplicationTaskInput) SetTableMappings(v string) *CreateReplicationTaskInput {
	s.TableMappings = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationTaskInput) SetTags(v []*Tag) *CreateReplicationTaskInput {
	s.Tags = v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetTargetEndpointArn(v string) *CreateReplicationTaskInput {
	s.TargetEndpointArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTaskResponse
type CreateReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was created.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *CreateReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *CreateReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificateMessage
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted certificate.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeleteCertificateInput) SetCertificateArn(v string) *DeleteCertificateInput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificateResponse
type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificate.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DeleteCertificateOutput) SetCertificate(v *Certificate) *DeleteCertificateOutput {
	s.Certificate = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpointMessage
type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpointResponse
type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was deleted.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteEndpointOutput) SetEndpoint(v *Endpoint) *DeleteEndpointOutput {
	s.Endpoint = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscriptionMessage
type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the DMS event notification subscription to be deleted.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscriptionResponse
type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was deleted.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstanceMessage
type DeleteReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication instance to be deleted.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DeleteReplicationInstanceInput) SetReplicationInstanceArn(v string) *DeleteReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstanceResponse
type DeleteReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was deleted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *DeleteReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *DeleteReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroupMessage
type DeleteReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The subnet group name of the replication instance.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *DeleteReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *DeleteReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroupResponse
type DeleteReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskMessage
type DeleteReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task to be deleted.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DeleteReplicationTaskInput) SetReplicationTaskArn(v string) *DeleteReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskResponse
type DeleteReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The deleted replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *DeleteReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *DeleteReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributesMessage
type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributesResponse
type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Account quota information.
	AccountQuotas []*AccountQuota `type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountQuotas sets the AccountQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetAccountQuotas(v []*AccountQuota) *DescribeAccountAttributesOutput {
	s.AccountQuotas = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificatesMessage
type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the certificate described in the form of key-value pairs.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 10
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificatesResponse
type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificates associated with the replication
	// instance.
	Certificates []*Certificate `type:"list"`

	// The pagination token.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnectionsMessage
type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The filters applied to the connection.
	//
	// Valid filter names: endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeConnectionsInput) SetFilters(v []*Filter) *DescribeConnectionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsInput) SetMarker(v string) *DescribeConnectionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeConnectionsInput) SetMaxRecords(v int64) *DescribeConnectionsInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnectionsResponse
type DescribeConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A description of the connections.
	Connections []*Connection `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeConnectionsOutput) SetConnections(v []*Connection) *DescribeConnectionsOutput {
	s.Connections = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsOutput) SetMarker(v string) *DescribeConnectionsOutput {
	s.Marker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypesMessage
type DescribeEndpointTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: engine-name | endpoint-type
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointTypesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointTypesInput) SetFilters(v []*Filter) *DescribeEndpointTypesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesInput) SetMarker(v string) *DescribeEndpointTypesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointTypesInput) SetMaxRecords(v int64) *DescribeEndpointTypesInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypesResponse
type DescribeEndpointTypesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The type of endpoints that are supported.
	SupportedEndpointTypes []*SupportedEndpointType `type:"list"`
}

// String returns the string representation
func (s DescribeEndpointTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesOutput) SetMarker(v string) *DescribeEndpointTypesOutput {
	s.Marker = &v
	return s
}

// SetSupportedEndpointTypes sets the SupportedEndpointTypes field's value.
func (s *DescribeEndpointTypesOutput) SetSupportedEndpointTypes(v []*SupportedEndpointType) *DescribeEndpointTypesOutput {
	s.SupportedEndpointTypes = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointsMessage
type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointsInput) SetFilters(v []*Filter) *DescribeEndpointsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsInput) SetMarker(v string) *DescribeEndpointsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointsInput) SetMaxRecords(v int64) *DescribeEndpointsInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointsResponse
type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Endpoint description.
	Endpoints []*Endpoint `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsOutput) SetMarker(v string) *DescribeEndpointsOutput {
	s.Marker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategoriesMessage
type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the action.
	Filters []*Filter `type:"list"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | migration-task
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategoriesResponse
type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories.
	EventCategoryGroupList []*EventCategoryGroup `type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoryGroupList sets the EventCategoryGroupList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoryGroupList(v []*EventCategoryGroup) *DescribeEventCategoriesOutput {
	s.EventCategoryGroupList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptionsMessage
type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the action.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the AWS DMS event subscription to be described.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSubscriptionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventSubscriptionsInput) SetFilters(v []*Filter) *DescribeEventSubscriptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptionsResponse
type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventsMessage
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The duration of the events to be listed.
	Duration *int64 `type:"integer"`

	// The end time for the events to be listed.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of event categories for a source type that you want to subscribe to.
	EventCategories []*string `type:"list"`

	// Filters applied to the action.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source. An identifier must begin with a letter
	// and must contain only ASCII letters, digits, and hyphens. It cannot end with
	// a hyphen or contain two consecutive hyphens.
	SourceIdentifier *string `type:"string"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | migration-task
	SourceType *string `type:"string" enum:"SourceType"`

	// The start time for the events to be listed.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventsResponse
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// The events described.
	Events []*Event `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstancesMessage
type DescribeOrderableReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMarker(v string) *DescribeOrderableReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMaxRecords(v int64) *DescribeOrderableReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstancesResponse
type DescribeOrderableReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The order-able replication instances available.
	OrderableReplicationInstances []*OrderableReplicationInstance `type:"list"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetMarker(v string) *DescribeOrderableReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetOrderableReplicationInstances sets the OrderableReplicationInstances field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetOrderableReplicationInstances(v []*OrderableReplicationInstance) *DescribeOrderableReplicationInstancesOutput {
	s.OrderableReplicationInstances = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatusMessage
type DescribeRefreshSchemasStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRefreshSchemasStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRefreshSchemasStatusInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeRefreshSchemasStatusInput) SetEndpointArn(v string) *DescribeRefreshSchemasStatusInput {
	s.EndpointArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatusResponse
type DescribeRefreshSchemasStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusOutput) GoString() string {
	return s.String()
}

// SetRefreshSchemasStatus sets the RefreshSchemasStatus field's value.
func (s *DescribeRefreshSchemasStatusOutput) SetRefreshSchemasStatus(v *RefreshSchemasStatus) *DescribeRefreshSchemasStatusOutput {
	s.RefreshSchemasStatus = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstancesMessage
type DescribeReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-instance-arn | replication-instance-id |
	// replication-instance-class | engine-version
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationInstancesInput) SetFilters(v []*Filter) *DescribeReplicationInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesInput) SetMarker(v string) *DescribeReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationInstancesInput) SetMaxRecords(v int64) *DescribeReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstancesResponse
type DescribeReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication instances described.
	ReplicationInstances []*ReplicationInstance `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesOutput) SetMarker(v string) *DescribeReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetReplicationInstances sets the ReplicationInstances field's value.
func (s *DescribeReplicationInstancesOutput) SetReplicationInstances(v []*ReplicationInstance) *DescribeReplicationInstancesOutput {
	s.ReplicationInstances = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroupsMessage
type DescribeReplicationSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetFilters(v []*Filter) *DescribeReplicationSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMarker(v string) *DescribeReplicationSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMaxRecords(v int64) *DescribeReplicationSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroupsResponse
type DescribeReplicationSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication subnet groups.
	ReplicationSubnetGroups []*ReplicationSubnetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetMarker(v string) *DescribeReplicationSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// SetReplicationSubnetGroups sets the ReplicationSubnetGroups field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetReplicationSubnetGroups(v []*ReplicationSubnetGroup) *DescribeReplicationSubnetGroupsOutput {
	s.ReplicationSubnetGroups = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResultsMessage
type DescribeReplicationTaskAssessmentResultsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// - The Amazon Resource Name (ARN) string that uniquely identifies the task.
	// When this input parameter is specified the API will return only one result
	// and ignore the values of the max-records and marker parameters.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentResultsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMaxRecords(v int64) *DescribeReplicationTaskAssessmentResultsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetReplicationTaskArn(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResultsResponse
type DescribeReplicationTaskAssessmentResultsOutput struct {
	_ struct{} `type:"structure"`

	// - The Amazon S3 bucket where the task assessment report is located.
	BucketName *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The task assessment report.
	ReplicationTaskAssessmentResults []*ReplicationTaskAssessmentResult `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentResultsOutput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetBucketName(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.BucketName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskAssessmentResults sets the ReplicationTaskAssessmentResults field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetReplicationTaskAssessmentResults(v []*ReplicationTaskAssessmentResult) *DescribeReplicationTaskAssessmentResultsOutput {
	s.ReplicationTaskAssessmentResults = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasksMessage
type DescribeReplicationTasksInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-task-arn | replication-task-id | migration-type
	// | endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTasksInput) SetFilters(v []*Filter) *DescribeReplicationTasksInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksInput) SetMarker(v string) *DescribeReplicationTasksInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTasksInput) SetMaxRecords(v int64) *DescribeReplicationTasksInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasksResponse
type DescribeReplicationTasksOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication tasks.
	ReplicationTasks []*ReplicationTask `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksOutput) SetMarker(v string) *DescribeReplicationTasksOutput {
	s.Marker = &v
	return s
}

// SetReplicationTasks sets the ReplicationTasks field's value.
func (s *DescribeReplicationTasksOutput) SetReplicationTasks(v []*ReplicationTask) *DescribeReplicationTasksOutput {
	s.ReplicationTasks = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemasMessage
type DescribeSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeSchemasInput) SetEndpointArn(v string) *DescribeSchemasInput {
	s.EndpointArn = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasInput) SetMarker(v string) *DescribeSchemasInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSchemasInput) SetMaxRecords(v int64) *DescribeSchemasInput {
	s.MaxRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemasResponse
type DescribeSchemasOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The described schema.
	Schemas []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasOutput) SetMarker(v string) *DescribeSchemasOutput {
	s.Marker = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *DescribeSchemasOutput) SetSchemas(v []*string) *DescribeSchemasOutput {
	s.Schemas = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatisticsMessage
type DescribeTableStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe table statistics action.
	//
	// Valid filter names: schema-name | table-name | table-state
	//
	// A combination of filters creates an AND condition where each record matches
	// all specified filters.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 500.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableStatisticsInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeTableStatisticsInput) SetFilters(v []*Filter) *DescribeTableStatisticsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsInput) SetMarker(v string) *DescribeTableStatisticsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTableStatisticsInput) SetMaxRecords(v int64) *DescribeTableStatisticsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsInput) SetReplicationTaskArn(v string) *DescribeTableStatisticsInput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatisticsResponse
type DescribeTableStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The table statistics.
	TableStatistics []*TableStatistics `type:"list"`
}

// String returns the string representation
func (s DescribeTableStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsOutput) SetMarker(v string) *DescribeTableStatisticsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsOutput) SetReplicationTaskArn(v string) *DescribeTableStatisticsOutput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTableStatistics sets the TableStatistics field's value.
func (s *DescribeTableStatisticsOutput) SetTableStatistics(v []*TableStatistics) *DescribeTableStatisticsOutput {
	s.TableStatistics = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DynamoDbSettings
type DynamoDbSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used by the service access IAM role.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDbSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDbSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDbSettings"}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *DynamoDbSettings) SetServiceAccessRoleArn(v string) *DynamoDbSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
	CertificateArn *string `type:"string"`

	// The name of the database at the endpoint.
	DatabaseName *string `type:"string"`

	// The settings for the target DynamoDB database. For more information, see
	// the DynamoDBSettings structure.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The database engine name. Valid values, depending on the EndPointType, include
	// MYSQL, ORACLE, POSTGRES, MARIADB, AURORA, REDSHIFT, S3, SYBASE, DYNAMODB,
	// MONGODB, and SQLSERVER.
	EngineName *string `type:"string"`

	// Value returned by a call to CreateEndpoint that can be used for cross-account
	// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint
	// with a cross-account.
	ExternalId *string `type:"string"`

	// Additional connection attributes used to connect to the endpoint.
	ExtraConnectionAttributes *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the connection parameters.
	// If you do not specify a value for the KmsKeyId parameter, then AWS DMS will
	// use your default encryption key. AWS KMS creates the default encryption key
	// for your AWS account. Your AWS account has a different default encryption
	// key for each AWS region.
	KmsKeyId *string `type:"string"`

	// The settings for the MongoDB source endpoint. For more information, see the
	// MongoDbSettings structure.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The port value used to access the endpoint.
	Port *int64 `type:"integer"`

	// The settings for the S3 target endpoint. For more information, see the S3Settings
	// structure.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server at the endpoint.
	ServerName *string `type:"string"`

	// The SSL mode used to connect to the endpoint.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The status of the endpoint.
	Status *string `type:"string"`

	// The user name used to connect to the endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Endpoint) SetCertificateArn(v string) *Endpoint {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Endpoint) SetDatabaseName(v string) *Endpoint {
	s.DatabaseName = &v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *Endpoint) SetDynamoDbSettings(v *DynamoDbSettings) *Endpoint {
	s.DynamoDbSettings = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Endpoint) SetEndpointIdentifier(v string) *Endpoint {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *Endpoint) SetEndpointType(v string) *Endpoint {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *Endpoint) SetEngineName(v string) *Endpoint {
	s.EngineName = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *Endpoint) SetExternalId(v string) *Endpoint {
	s.ExternalId = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *Endpoint) SetExtraConnectionAttributes(v string) *Endpoint {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Endpoint) SetKmsKeyId(v string) *Endpoint {
	s.KmsKeyId = &v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *Endpoint) SetMongoDbSettings(v *MongoDbSettings) *Endpoint {
	s.MongoDbSettings = v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *Endpoint) SetS3Settings(v *S3Settings) *Endpoint {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *Endpoint) SetServerName(v string) *Endpoint {
	s.ServerName = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *Endpoint) SetSslMode(v string) *Endpoint {
	s.SslMode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Endpoint) SetStatus(v string) *Endpoint {
	s.Status = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Endpoint) SetUsername(v string) *Endpoint {
	s.Username = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// The date of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The event categories available for the specified source type.
	EventCategories []*string `type:"list"`

	// The event message.
	Message *string `type:"string"`

	// The identifier of the event source. An identifier must begin with a letter
	// and must contain only ASCII letters, digits, and hyphens; it cannot end with
	// a hyphen or contain two consecutive hyphens.
	//
	// Constraints:replication instance, endpoint, migration task
	SourceIdentifier *string `type:"string"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | endpoint | migration-task
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/EventCategoryGroup
type EventCategoryGroup struct {
	_ struct{} `type:"structure"`

	// A list of event categories for a SourceType that you want to subscribe to.
	EventCategories []*string `type:"list"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | migration-task
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoryGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoryGroup) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoryGroup) SetEventCategories(v []*string) *EventCategoryGroup {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoryGroup) SetSourceType(v string) *EventCategoryGroup {
	s.SourceType = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/EventSubscription
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The AWS DMS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the AWS DMS event notification subscription.
	CustomerAwsId *string `type:"string"`

	// Boolean value that indicates if the event subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A lists of event categories.
	EventCategoriesList []*string `type:"list"`

	// The topic ARN of the AWS DMS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source Ids for the event subscription.
	SourceIdsList []*string `type:"list"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | migration-task
	SourceType *string `type:"string"`

	// The status of the AWS DMS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that AWS DMS no longer has permission
	// to post to the SNS topic. The status "topic-not-exist" indicates that the
	// topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v string) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filter value.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificateMessage
type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the certificate. Valid characters are A-z and
	// 0-9.
	//
	// CertificateIdentifier is a required field
	CertificateIdentifier *string `type:"string" required:"true"`

	// The contents of the .pem X.509 certificate file for the certificate.
	CertificatePem *string `type:"string"`

	// The location of the imported Oracle Wallet certificate for use with SSL.
	//
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The tags associated with the certificate.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.CertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *ImportCertificateInput) SetCertificateIdentifier(v string) *ImportCertificateInput {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *ImportCertificateInput) SetCertificatePem(v string) *ImportCertificateInput {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *ImportCertificateInput) SetCertificateWallet(v []byte) *ImportCertificateInput {
	s.CertificateWallet = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportCertificateInput) SetTags(v []*Tag) *ImportCertificateInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificateResponse
type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate to be uploaded.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateOutput) SetCertificate(v *Certificate) *ImportCertificateOutput {
	s.Certificate = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResourceMessage
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the AWS DMS
	// resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResourceResponse
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags for the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpointMessage
type ModifyEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate used for SSL connection.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database.
	DatabaseName *string `type:"string"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For more
	// information about the available settings, see the Using Object Mapping to
	// Migrate Data to DynamoDB section at  Using an Amazon DynamoDB Database as
	// a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html).
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values, depending on the EndPointType,
	// include MYSQL, ORACLE, POSTGRES, MARIADB, AURORA, REDSHIFT, S3, DYNAMODB,
	// MONGODB, SYBASE, and SQLSERVER.
	EngineName *string `type:"string"`

	// Additional attributes associated with the connection. To reset this parameter,
	// pass the empty string ("") as an argument.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see the Configuration Properties When Using
	// MongoDB as a Source for AWS Database Migration Service section at  Using
	// Amazon S3 as a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html).
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The password to be used to login to the endpoint database.
	Password *string `type:"string"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the target S3 endpoint. For more information
	// about the available settings, see the Extra Connection Attributes section
	// at  Using Amazon S3 as a Target for AWS Database Migration Service (http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html).
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The SSL mode to be used.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The user name to be used to login to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s ModifyEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ModifyEndpointInput) SetCertificateArn(v string) *ModifyEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ModifyEndpointInput) SetDatabaseName(v string) *ModifyEndpointInput {
	s.DatabaseName = &v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *ModifyEndpointInput) SetDynamoDbSettings(v *DynamoDbSettings) *ModifyEndpointInput {
	s.DynamoDbSettings = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *ModifyEndpointInput) SetEndpointArn(v string) *ModifyEndpointInput {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *ModifyEndpointInput) SetEndpointIdentifier(v string) *ModifyEndpointInput {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ModifyEndpointInput) SetEndpointType(v string) *ModifyEndpointInput {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *ModifyEndpointInput) SetEngineName(v string) *ModifyEndpointInput {
	s.EngineName = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *ModifyEndpointInput) SetExtraConnectionAttributes(v string) *ModifyEndpointInput {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *ModifyEndpointInput) SetMongoDbSettings(v *MongoDbSettings) *ModifyEndpointInput {
	s.MongoDbSettings = v
	return s
}

// SetPassword sets the Password field's value.
func (s *ModifyEndpointInput) SetPassword(v string) *ModifyEndpointInput {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ModifyEndpointInput) SetPort(v int64) *ModifyEndpointInput {
	s.Port = &v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *ModifyEndpointInput) SetS3Settings(v *S3Settings) *ModifyEndpointInput {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ModifyEndpointInput) SetServerName(v string) *ModifyEndpointInput {
	s.ServerName = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *ModifyEndpointInput) SetSslMode(v string) *ModifyEndpointInput {
	s.SslMode = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *ModifyEndpointInput) SetUsername(v string) *ModifyEndpointInput {
	s.Username = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpointResponse
type ModifyEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The modified endpoint.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s ModifyEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *ModifyEndpointOutput) SetEndpoint(v *Endpoint) *ModifyEndpointOutput {
	s.Endpoint = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscriptionMessage
type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// Use the DescribeEventCategories action to see a list of event categories.
	EventCategories []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	SnsTopicArn *string `type:"string"`

	// The type of AWS DMS resource that generates the events you want to subscribe
	// to.
	//
	// Valid values: replication-instance | migration-task
	SourceType *string `type:"string"`

	// The name of the AWS DMS event notification subscription to be modified.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscriptionResponse
type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The modified event subscription.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstanceMessage
type ModifyReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage and the change is asynchronously applied as
	// soon as possible.
	//
	// Constraints: This parameter must be set to true when specifying a value for
	// the EngineVersion parameter that is a different major version than the replication
	// instance's current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Indicates whether the changes should be applied immediately or during the
	// next maintenance window.
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades will be applied automatically to the
	// replication instance during the maintenance window. Changing this parameter
	// does not result in an outage except in the following case and the change
	// is asynchronously applied as soon as possible. An outage will result if this
	// parameter is set to true during the maintenance window, and a newer minor
	// version is available, and AWS DMS has enabled auto patching for that engine
	// version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If moving this window to the current time, there
	// must be at least 30 minutes between the current time and end of the window
	// to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s ModifyReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ModifyReplicationInstanceInput) SetAllocatedStorage(v int64) *ModifyReplicationInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAllowMajorVersionUpgrade sets the AllowMajorVersionUpgrade field's value.
func (s *ModifyReplicationInstanceInput) SetAllowMajorVersionUpgrade(v bool) *ModifyReplicationInstanceInput {
	s.AllowMajorVersionUpgrade = &v
	return s
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyReplicationInstanceInput) SetApplyImmediately(v bool) *ModifyReplicationInstanceInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyReplicationInstanceInput) SetAutoMinorVersionUpgrade(v bool) *ModifyReplicationInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyReplicationInstanceInput) SetEngineVersion(v string) *ModifyReplicationInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ModifyReplicationInstanceInput) SetMultiAZ(v bool) *ModifyReplicationInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyReplicationInstanceInput) SetPreferredMaintenanceWindow(v string) *ModifyReplicationInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceArn(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceClass(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceIdentifier(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyReplicationInstanceInput) SetVpcSecurityGroupIds(v []*string) *ModifyReplicationInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstanceResponse
type ModifyReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication instance.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *ModifyReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *ModifyReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroupMessage
type ModifyReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the replication instance subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The name of the replication instance subnet group.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// A list of subnet IDs.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *ModifyReplicationSubnetGroupInput) SetReplicationSubnetGroupDescription(v string) *ModifyReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *ModifyReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *ModifyReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyReplicationSubnetGroupInput) SetSubnetIds(v []*string) *ModifyReplicationSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroupResponse
type ModifyReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication subnet group.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *ModifyReplicationSubnetGroupOutput) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *ModifyReplicationSubnetGroupOutput {
	s.ReplicationSubnetGroup = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTaskMessage
type ModifyReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The start time for the Change Data Capture (CDC) operation.
	CdcStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The migration type.
	//
	// Valid values: full-load | cdc | full-load-and-cdc
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// JSON file that contains settings for the task, such as target metadata settings.
	ReplicationTaskSettings *string `type:"string"`

	// When using the AWS CLI or boto3, provide the path of the JSON file that contains
	// the table mappings. Precede the path with "file://". When working with the
	// DMS API, provide the JSON as the parameter value.
	//
	// For example, --table-mappings file://mappingfile.json
	TableMappings *string `type:"string"`
}

// String returns the string representation
func (s ModifyReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *ModifyReplicationTaskInput) SetCdcStartTime(v time.Time) *ModifyReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *ModifyReplicationTaskInput) SetMigrationType(v string) *ModifyReplicationTaskInput {
	s.MigrationType = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskArn(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskIdentifier(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskSettings(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskSettings = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *ModifyReplicationTaskInput) SetTableMappings(v string) *ModifyReplicationTaskInput {
	s.TableMappings = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTaskResponse
type ModifyReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was modified.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *ModifyReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *ModifyReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MongoDbSettings
type MongoDbSettings struct {
	_ struct{} `type:"structure"`

	// The authentication mechanism you use to access the MongoDB source endpoint.
	//
	// Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
	//
	// DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x,
	// use SCRAM_SHA_1. This attribute is not used when authType=No.
	AuthMechanism *string `type:"string" enum:"AuthMechanismValue"`

	// The MongoDB database name. This attribute is not used when authType=NO.
	//
	// The default is admin.
	AuthSource *string `type:"string"`

	// The authentication type you use to access the MongoDB source endpoint.
	//
	// Valid values: NO, PASSWORD
	//
	// When NO is selected, user name and password parameters are not used and can
	// be empty.
	AuthType *string `type:"string" enum:"AuthTypeValue"`

	// The database name on the MongoDB source endpoint.
	DatabaseName *string `type:"string"`

	// Indicates the number of documents to preview to determine the document organization.
	// Use this attribute when NestingLevel is set to ONE.
	//
	// Must be a positive value greater than 0. Default value is 1000.
	DocsToInvestigate *string `type:"string"`

	// Specifies the document ID. Use this attribute when NestingLevel is set to
	// NONE.
	//
	// Default value is false.
	ExtractDocId *string `type:"string"`

	// Specifies either document or table mode.
	//
	// Valid values: NONE, ONE
	//
	// Default value is NONE. Specify NONE to use document mode. Specify ONE to
	// use table mode.
	NestingLevel *string `type:"string" enum:"NestingLevelValue"`

	// The password for the user account you use to access the MongoDB source endpoint.
	Password *string `type:"string"`

	// The port value for the MongoDB source endpoint.
	Port *int64 `type:"integer"`

	// The name of the server on the MongoDB source endpoint.
	ServerName *string `type:"string"`

	// The user name you use to access the MongoDB source endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s MongoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MongoDbSettings) GoString() string {
	return s.String()
}

// SetAuthMechanism sets the AuthMechanism field's value.
func (s *MongoDbSettings) SetAuthMechanism(v string) *MongoDbSettings {
	s.AuthMechanism = &v
	return s
}

// SetAuthSource sets the AuthSource field's value.
func (s *MongoDbSettings) SetAuthSource(v string) *MongoDbSettings {
	s.AuthSource = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *MongoDbSettings) SetAuthType(v string) *MongoDbSettings {
	s.AuthType = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MongoDbSettings) SetDatabaseName(v string) *MongoDbSettings {
	s.DatabaseName = &v
	return s
}

// SetDocsToInvestigate sets the DocsToInvestigate field's value.
func (s *MongoDbSettings) SetDocsToInvestigate(v string) *MongoDbSettings {
	s.DocsToInvestigate = &v
	return s
}

// SetExtractDocId sets the ExtractDocId field's value.
func (s *MongoDbSettings) SetExtractDocId(v string) *MongoDbSettings {
	s.ExtractDocId = &v
	return s
}

// SetNestingLevel sets the NestingLevel field's value.
func (s *MongoDbSettings) SetNestingLevel(v string) *MongoDbSettings {
	s.NestingLevel = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MongoDbSettings) SetPassword(v string) *MongoDbSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MongoDbSettings) SetPort(v int64) *MongoDbSettings {
	s.Port = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MongoDbSettings) SetServerName(v string) *MongoDbSettings {
	s.ServerName = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MongoDbSettings) SetUsername(v string) *MongoDbSettings {
	s.Username = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/OrderableReplicationInstance
type OrderableReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The default amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	DefaultAllocatedStorage *int64 `type:"integer"`

	// The version of the replication engine.
	EngineVersion *string `type:"string"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	IncludedAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MinAllocatedStorage *int64 `type:"integer"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The type of storage used by the replication instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s OrderableReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableReplicationInstance) GoString() string {
	return s.String()
}

// SetDefaultAllocatedStorage sets the DefaultAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetDefaultAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.DefaultAllocatedStorage = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *OrderableReplicationInstance) SetEngineVersion(v string) *OrderableReplicationInstance {
	s.EngineVersion = &v
	return s
}

// SetIncludedAllocatedStorage sets the IncludedAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetIncludedAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.IncludedAllocatedStorage = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetMaxAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMinAllocatedStorage sets the MinAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetMinAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.MinAllocatedStorage = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *OrderableReplicationInstance) SetReplicationInstanceClass(v string) *OrderableReplicationInstance {
	s.ReplicationInstanceClass = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *OrderableReplicationInstance) SetStorageType(v string) *OrderableReplicationInstance {
	s.StorageType = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemasMessage
type RefreshSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RefreshSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *RefreshSchemasInput) SetEndpointArn(v string) *RefreshSchemasInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *RefreshSchemasInput) SetReplicationInstanceArn(v string) *RefreshSchemasInput {
	s.ReplicationInstanceArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemasResponse
type RefreshSchemasOutput struct {
	_ struct{} `type:"structure"`

	// The status of the refreshed schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s RefreshSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasOutput) GoString() string {
	return s.String()
}

// SetRefreshSchemasStatus sets the RefreshSchemasStatus field's value.
func (s *RefreshSchemasOutput) SetRefreshSchemasStatus(v *RefreshSchemasStatus) *RefreshSchemasOutput {
	s.RefreshSchemasStatus = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemasStatus
type RefreshSchemasStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The last failure message for the schema.
	LastFailureMessage *string `type:"string"`

	// The date the schema was last refreshed.
	LastRefreshDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The status of the schema.
	Status *string `type:"string" enum:"RefreshSchemasStatusTypeValue"`
}

// String returns the string representation
func (s RefreshSchemasStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasStatus) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *RefreshSchemasStatus) SetEndpointArn(v string) *RefreshSchemasStatus {
	s.EndpointArn = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *RefreshSchemasStatus) SetLastFailureMessage(v string) *RefreshSchemasStatus {
	s.LastFailureMessage = &v
	return s
}

// SetLastRefreshDate sets the LastRefreshDate field's value.
func (s *RefreshSchemasStatus) SetLastRefreshDate(v time.Time) *RefreshSchemasStatus {
	s.LastRefreshDate = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *RefreshSchemasStatus) SetReplicationInstanceArn(v string) *RefreshSchemasStatus {
	s.ReplicationInstanceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RefreshSchemasStatus) SetStatus(v string) *RefreshSchemasStatus {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTablesMessage
type ReloadTablesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The name and schema of the table to be reloaded.
	//
	// TablesToReload is a required field
	TablesToReload []*TableToReload `type:"list" required:"true"`
}

// String returns the string representation
func (s ReloadTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReloadTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReloadTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReloadTablesInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.TablesToReload == nil {
		invalidParams.Add(request.NewErrParamRequired("TablesToReload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReloadTablesInput) SetReplicationTaskArn(v string) *ReloadTablesInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTablesToReload sets the TablesToReload field's value.
func (s *ReloadTablesInput) SetTablesToReload(v []*TableToReload) *ReloadTablesInput {
	s.TablesToReload = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTablesResponse
type ReloadTablesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation
func (s ReloadTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReloadTablesOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReloadTablesOutput) SetReplicationTaskArn(v string) *ReloadTablesOutput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResourceMessage
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// >The Amazon Resource Name (ARN) of the AWS DMS resource the tag is to be
	// removed from.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RemoveTagsFromResourceInput) SetResourceArn(v string) *RemoveTagsFromResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResourceResponse
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationInstance
type ReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Boolean value indicating if minor version upgrades will be automatically
	// applied to the instance.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// The time the replication instance was created.
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The KMS key identifier that is used to encrypt the content on the replication
	// instance. If you do not specify a value for the KmsKeyId parameter, then
	// AWS DMS will use your default encryption key. AWS KMS creates the default
	// encryption key for your AWS account. Your AWS account has a different default
	// encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The pending modification values.
	PendingModifiedValues *ReplicationPendingModifiedValues `type:"structure"`

	// The maintenance window times for the replication instance.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	ReplicationInstanceIdentifier *string `type:"string"`

	// The private IP address of the replication instance.
	ReplicationInstancePrivateIpAddress *string `deprecated:"true" type:"string"`

	// The private IP address of the replication instance.
	ReplicationInstancePrivateIpAddresses []*string `type:"list"`

	// The public IP address of the replication instance.
	ReplicationInstancePublicIpAddress *string `deprecated:"true" type:"string"`

	// The public IP address of the replication instance.
	ReplicationInstancePublicIpAddresses []*string `type:"list"`

	// The status of the replication instance.
	ReplicationInstanceStatus *string `type:"string"`

	// The subnet group for the replication instance.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`

	// The availability zone of the standby replication instance in a Multi-AZ deployment.
	SecondaryAvailabilityZone *string `type:"string"`

	// The VPC security group for the instance.
	VpcSecurityGroups []*VpcSecurityGroupMembership `type:"list"`
}

// String returns the string representation
func (s ReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationInstance) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ReplicationInstance) SetAllocatedStorage(v int64) *ReplicationInstance {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ReplicationInstance) SetAutoMinorVersionUpgrade(v bool) *ReplicationInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ReplicationInstance) SetAvailabilityZone(v string) *ReplicationInstance {
	s.AvailabilityZone = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ReplicationInstance) SetEngineVersion(v string) *ReplicationInstance {
	s.EngineVersion = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *ReplicationInstance) SetInstanceCreateTime(v time.Time) *ReplicationInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationInstance) SetKmsKeyId(v string) *ReplicationInstance {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReplicationInstance) SetMultiAZ(v bool) *ReplicationInstance {
	s.MultiAZ = &v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *ReplicationInstance) SetPendingModifiedValues(v *ReplicationPendingModifiedValues) *ReplicationInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ReplicationInstance) SetPreferredMaintenanceWindow(v string) *ReplicationInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ReplicationInstance) SetPubliclyAccessible(v bool) *ReplicationInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ReplicationInstance) SetReplicationInstanceArn(v string) *ReplicationInstance {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ReplicationInstance) SetReplicationInstanceClass(v string) *ReplicationInstance {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *ReplicationInstance) SetReplicationInstanceIdentifier(v string) *ReplicationInstance {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetReplicationInstancePrivateIpAddress sets the ReplicationInstancePrivateIpAddress field's value.
func (s *ReplicationInstance) SetReplicationInstancePrivateIpAddress(v string) *ReplicationInstance {
	s.ReplicationInstancePrivateIpAddress = &v
	return s
}

// SetReplicationInstancePrivateIpAddresses sets the ReplicationInstancePrivateIpAddresses field's value.
func (s *ReplicationInstance) SetReplicationInstancePrivateIpAddresses(v []*string) *ReplicationInstance {
	s.ReplicationInstancePrivateIpAddresses = v
	return s
}

// SetReplicationInstancePublicIpAddress sets the ReplicationInstancePublicIpAddress field's value.
func (s *ReplicationInstance) SetReplicationInstancePublicIpAddress(v string) *ReplicationInstance {
	s.ReplicationInstancePublicIpAddress = &v
	return s
}

// SetReplicationInstancePublicIpAddresses sets the ReplicationInstancePublicIpAddresses field's value.
func (s *ReplicationInstance) SetReplicationInstancePublicIpAddresses(v []*string) *ReplicationInstance {
	s.ReplicationInstancePublicIpAddresses = v
	return s
}

// SetReplicationInstanceStatus sets the ReplicationInstanceStatus field's value.
func (s *ReplicationInstance) SetReplicationInstanceStatus(v string) *ReplicationInstance {
	s.ReplicationInstanceStatus = &v
	return s
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *ReplicationInstance) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *ReplicationInstance {
	s.ReplicationSubnetGroup = v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *ReplicationInstance) SetSecondaryAvailabilityZone(v string) *ReplicationInstance {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *ReplicationInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *ReplicationInstance {
	s.VpcSecurityGroups = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationPendingModifiedValues
type ReplicationPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`
}

// String returns the string representation
func (s ReplicationPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ReplicationPendingModifiedValues) SetAllocatedStorage(v int64) *ReplicationPendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ReplicationPendingModifiedValues) SetEngineVersion(v string) *ReplicationPendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReplicationPendingModifiedValues) SetMultiAZ(v bool) *ReplicationPendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ReplicationPendingModifiedValues) SetReplicationInstanceClass(v string) *ReplicationPendingModifiedValues {
	s.ReplicationInstanceClass = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationSubnetGroup
type ReplicationSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The description of the replication subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The identifier of the replication instance subnet group.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// The subnets that are in the subnet group.
	Subnets []*Subnet `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ReplicationSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationSubnetGroup) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *ReplicationSubnetGroup) SetReplicationSubnetGroupDescription(v string) *ReplicationSubnetGroup {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *ReplicationSubnetGroup) SetReplicationSubnetGroupIdentifier(v string) *ReplicationSubnetGroup {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *ReplicationSubnetGroup) SetSubnetGroupStatus(v string) *ReplicationSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ReplicationSubnetGroup) SetSubnets(v []*Subnet) *ReplicationSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ReplicationSubnetGroup) SetVpcId(v string) *ReplicationSubnetGroup {
	s.VpcId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationTask
type ReplicationTask struct {
	_ struct{} `type:"structure"`

	// The last error (failure) message generated for the replication instance.
	LastFailureMessage *string `type:"string"`

	// The type of migration.
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The date the replication task was created.
	ReplicationTaskCreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// The settings for the replication task.
	ReplicationTaskSettings *string `type:"string"`

	// The date the replication task is scheduled to start.
	ReplicationTaskStartDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The statistics for the task, including elapsed time, tables loaded, and table
	// errors.
	ReplicationTaskStats *ReplicationTaskStats `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	SourceEndpointArn *string `type:"string"`

	// The status of the replication task.
	Status *string `type:"string"`

	// The reason the replication task was stopped.
	StopReason *string `type:"string"`

	// Table mappings specified in the task.
	TableMappings *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	TargetEndpointArn *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTask) GoString() string {
	return s.String()
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *ReplicationTask) SetLastFailureMessage(v string) *ReplicationTask {
	s.LastFailureMessage = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *ReplicationTask) SetMigrationType(v string) *ReplicationTask {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ReplicationTask) SetReplicationInstanceArn(v string) *ReplicationTask {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationTask) SetReplicationTaskArn(v string) *ReplicationTask {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskCreationDate sets the ReplicationTaskCreationDate field's value.
func (s *ReplicationTask) SetReplicationTaskCreationDate(v time.Time) *ReplicationTask {
	s.ReplicationTaskCreationDate = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ReplicationTask) SetReplicationTaskIdentifier(v string) *ReplicationTask {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *ReplicationTask) SetReplicationTaskSettings(v string) *ReplicationTask {
	s.ReplicationTaskSettings = &v
	return s
}

// SetReplicationTaskStartDate sets the ReplicationTaskStartDate field's value.
func (s *ReplicationTask) SetReplicationTaskStartDate(v time.Time) *ReplicationTask {
	s.ReplicationTaskStartDate = &v
	return s
}

// SetReplicationTaskStats sets the ReplicationTaskStats field's value.
func (s *ReplicationTask) SetReplicationTaskStats(v *ReplicationTaskStats) *ReplicationTask {
	s.ReplicationTaskStats = v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *ReplicationTask) SetSourceEndpointArn(v string) *ReplicationTask {
	s.SourceEndpointArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationTask) SetStatus(v string) *ReplicationTask {
	s.Status = &v
	return s
}

// SetStopReason sets the StopReason field's value.
func (s *ReplicationTask) SetStopReason(v string) *ReplicationTask {
	s.StopReason = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *ReplicationTask) SetTableMappings(v string) *ReplicationTask {
	s.TableMappings = &v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *ReplicationTask) SetTargetEndpointArn(v string) *ReplicationTask {
	s.TargetEndpointArn = &v
	return s
}

// The task assessment report in JSON format.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationTaskAssessmentResult
type ReplicationTaskAssessmentResult struct {
	_ struct{} `type:"structure"`

	// The task assessment results in JSON format.
	AssessmentResults *string `type:"string"`

	// The file containing the results of the task assessment.
	AssessmentResultsFile *string `type:"string"`

	// The status of the task assessment.
	AssessmentStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The replication task identifier of the task on which the task assessment
	// was run.
	ReplicationTaskIdentifier *string `type:"string"`

	// The date the task assessment was completed.
	ReplicationTaskLastAssessmentDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The URL of the S3 object containing the task assessment results.
	S3ObjectUrl *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTaskAssessmentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskAssessmentResult) GoString() string {
	return s.String()
}

// SetAssessmentResults sets the AssessmentResults field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentResults(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentResults = &v
	return s
}

// SetAssessmentResultsFile sets the AssessmentResultsFile field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentResultsFile(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentResultsFile = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentStatus(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentStatus = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskArn(v string) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskIdentifier(v string) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskLastAssessmentDate sets the ReplicationTaskLastAssessmentDate field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskLastAssessmentDate(v time.Time) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskLastAssessmentDate = &v
	return s
}

// SetS3ObjectUrl sets the S3ObjectUrl field's value.
func (s *ReplicationTaskAssessmentResult) SetS3ObjectUrl(v string) *ReplicationTaskAssessmentResult {
	s.S3ObjectUrl = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReplicationTaskStats
type ReplicationTaskStats struct {
	_ struct{} `type:"structure"`

	// The elapsed time of the task, in milliseconds.
	ElapsedTimeMillis *int64 `type:"long"`

	// The percent complete for the full load migration task.
	FullLoadProgressPercent *int64 `type:"integer"`

	// The number of errors that have occurred during this task.
	TablesErrored *int64 `type:"integer"`

	// The number of tables loaded for this task.
	TablesLoaded *int64 `type:"integer"`

	// The number of tables currently loading for this task.
	TablesLoading *int64 `type:"integer"`

	// The number of tables queued for this task.
	TablesQueued *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTaskStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskStats) GoString() string {
	return s.String()
}

// SetElapsedTimeMillis sets the ElapsedTimeMillis field's value.
func (s *ReplicationTaskStats) SetElapsedTimeMillis(v int64) *ReplicationTaskStats {
	s.ElapsedTimeMillis = &v
	return s
}

// SetFullLoadProgressPercent sets the FullLoadProgressPercent field's value.
func (s *ReplicationTaskStats) SetFullLoadProgressPercent(v int64) *ReplicationTaskStats {
	s.FullLoadProgressPercent = &v
	return s
}

// SetTablesErrored sets the TablesErrored field's value.
func (s *ReplicationTaskStats) SetTablesErrored(v int64) *ReplicationTaskStats {
	s.TablesErrored = &v
	return s
}

// SetTablesLoaded sets the TablesLoaded field's value.
func (s *ReplicationTaskStats) SetTablesLoaded(v int64) *ReplicationTaskStats {
	s.TablesLoaded = &v
	return s
}

// SetTablesLoading sets the TablesLoading field's value.
func (s *ReplicationTaskStats) SetTablesLoading(v int64) *ReplicationTaskStats {
	s.TablesLoading = &v
	return s
}

// SetTablesQueued sets the TablesQueued field's value.
func (s *ReplicationTaskStats) SetTablesQueued(v int64) *ReplicationTaskStats {
	s.TablesQueued = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/S3Settings
type S3Settings struct {
	_ struct{} `type:"structure"`

	// An optional parameter to set a folder name in the S3 bucket. If provided,
	// tables are created in the path <bucketFolder>/<schema_name>/<table_name>/.
	// If this parameter is not specified, then the path used is <schema_name>/<table_name>/.
	BucketFolder *string `type:"string"`

	// The name of the S3 bucket.
	BucketName *string `type:"string"`

	// An optional parameter to use GZIP to compress the target files. Set to GZIP
	// to compress the target files. Set to NONE (the default) or do not use to
	// leave the files uncompressed.
	CompressionType *string `type:"string" enum:"CompressionTypeValue"`

	// The delimiter used to separate columns in the source files. The default is
	// a comma.
	CsvDelimiter *string `type:"string"`

	// The delimiter used to separate rows in the source files. The default is a
	// carriage return (\n).
	CsvRowDelimiter *string `type:"string"`

	ExternalTableDefinition *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service access IAM role.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation
func (s S3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Settings) GoString() string {
	return s.String()
}

// SetBucketFolder sets the BucketFolder field's value.
func (s *S3Settings) SetBucketFolder(v string) *S3Settings {
	s.BucketFolder = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3Settings) SetBucketName(v string) *S3Settings {
	s.BucketName = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *S3Settings) SetCompressionType(v string) *S3Settings {
	s.CompressionType = &v
	return s
}

// SetCsvDelimiter sets the CsvDelimiter field's value.
func (s *S3Settings) SetCsvDelimiter(v string) *S3Settings {
	s.CsvDelimiter = &v
	return s
}

// SetCsvRowDelimiter sets the CsvRowDelimiter field's value.
func (s *S3Settings) SetCsvRowDelimiter(v string) *S3Settings {
	s.CsvRowDelimiter = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *S3Settings) SetExternalTableDefinition(v string) *S3Settings {
	s.ExternalTableDefinition = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *S3Settings) SetServiceAccessRoleArn(v string) *S3Settings {
	s.ServiceAccessRoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentMessage
type StartReplicationTaskAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskAssessmentInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StartReplicationTaskAssessmentInput) SetReplicationTaskArn(v string) *StartReplicationTaskAssessmentInput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentResponse
type StartReplicationTaskAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The assessed replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StartReplicationTaskAssessmentOutput) SetReplicationTask(v *ReplicationTask) *StartReplicationTaskAssessmentOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskMessage
type StartReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The start time for the Change Data Capture (CDC) operation.
	CdcStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the replication task to be started.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The type of replication task.
	//
	// StartReplicationTaskType is a required field
	StartReplicationTaskType *string `type:"string" required:"true" enum:"StartReplicationTaskTypeValue"`
}

// String returns the string representation
func (s StartReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.StartReplicationTaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("StartReplicationTaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *StartReplicationTaskInput) SetCdcStartTime(v time.Time) *StartReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StartReplicationTaskInput) SetReplicationTaskArn(v string) *StartReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetStartReplicationTaskType sets the StartReplicationTaskType field's value.
func (s *StartReplicationTaskInput) SetStartReplicationTaskType(v string) *StartReplicationTaskInput {
	s.StartReplicationTaskType = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskResponse
type StartReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task started.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StartReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *StartReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTaskMessage
type StopReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name(ARN) of the replication task to be stopped.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StopReplicationTaskInput) SetReplicationTaskArn(v string) *StopReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTaskResponse
type StopReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task stopped.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StopReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StopReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *StopReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Subnet
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The subnet identifier.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/SupportedEndpointType
type SupportedEndpointType struct {
	_ struct{} `type:"structure"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The database engine name. Valid values, depending on the EndPointType, include
	// MYSQL, ORACLE, POSTGRES, MARIADB, AURORA, REDSHIFT, S3, SYBASE, DYNAMODB,
	// MONGODB, and SQLSERVER.
	EngineName *string `type:"string"`

	// Indicates if Change Data Capture (CDC) is supported.
	SupportsCDC *bool `type:"boolean"`
}

// String returns the string representation
func (s SupportedEndpointType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedEndpointType) GoString() string {
	return s.String()
}

// SetEndpointType sets the EndpointType field's value.
func (s *SupportedEndpointType) SetEndpointType(v string) *SupportedEndpointType {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *SupportedEndpointType) SetEngineName(v string) *SupportedEndpointType {
	s.EngineName = &v
	return s
}

// SetSupportsCDC sets the SupportsCDC field's value.
func (s *SupportedEndpointType) SetSupportsCDC(v bool) *SupportedEndpointType {
	s.SupportsCDC = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TableStatistics
type TableStatistics struct {
	_ struct{} `type:"structure"`

	// The Data Definition Language (DDL) used to build and modify the structure
	// of your tables.
	Ddls *int64 `type:"long"`

	// The number of delete actions performed on a table.
	Deletes *int64 `type:"long"`

	// The number of rows that failed conditional checks during the Full Load operation
	// (valid only for DynamoDB as a target migrations).
	FullLoadCondtnlChkFailedRows *int64 `type:"long"`

	// The number of rows that failed to load during the Full Load operation (valid
	// only for DynamoDB as a target migrations).
	FullLoadErrorRows *int64 `type:"long"`

	// The number of rows added during the Full Load operation.
	FullLoadRows *int64 `type:"long"`

	// The number of insert actions performed on a table.
	Inserts *int64 `type:"long"`

	// The last time the table was updated.
	LastUpdateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The schema name.
	SchemaName *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The state of the tables described.
	//
	// Valid states: Table does not exist | Before load | Full load | Table completed
	// | Table cancelled | Table error | Table all | Table updates | Table is being
	// reloaded
	TableState *string `type:"string"`

	// The number of update actions performed on a table.
	Updates *int64 `type:"long"`

	// The number of records that failed validation.
	ValidationFailedRecords *int64 `type:"long"`

	// The number of records that have yet to be validated.
	ValidationPendingRecords *int64 `type:"long"`

	// The validation state of the table.
	//
	// The parameter can have the following values
	//
	//    * Not enabled—Validation is not enabled for the table in the migration
	//    task.
	//
	//    * Pending records—Some records in the table are waiting for validation.
	//
	//    * Mismatched records—Some records in the table do not match between the
	//    source and target.
	//
	//    * Suspended records—Some records in the table could not be validated.
	//
	//    * No primary key—The table could not be validated because it had no primary
	//    key.
	//
	//    * Table error—The table was not validated because it was in an error state
	//    and some data was not migrated.
	//
	//    * Validated—All rows in the table were validated. If the table is updated,
	//    the status can change from Validated.
	//
	//    * Error—The table could not be validated because of an unexpected error.
	ValidationState *string `type:"string"`

	// The number of records that could not be validated.
	ValidationSuspendedRecords *int64 `type:"long"`
}

// String returns the string representation
func (s TableStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableStatistics) GoString() string {
	return s.String()
}

// SetDdls sets the Ddls field's value.
func (s *TableStatistics) SetDdls(v int64) *TableStatistics {
	s.Ddls = &v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *TableStatistics) SetDeletes(v int64) *TableStatistics {
	s.Deletes = &v
	return s
}

// SetFullLoadCondtnlChkFailedRows sets the FullLoadCondtnlChkFailedRows field's value.
func (s *TableStatistics) SetFullLoadCondtnlChkFailedRows(v int64) *TableStatistics {
	s.FullLoadCondtnlChkFailedRows = &v
	return s
}

// SetFullLoadErrorRows sets the FullLoadErrorRows field's value.
func (s *TableStatistics) SetFullLoadErrorRows(v int64) *TableStatistics {
	s.FullLoadErrorRows = &v
	return s
}

// SetFullLoadRows sets the FullLoadRows field's value.
func (s *TableStatistics) SetFullLoadRows(v int64) *TableStatistics {
	s.FullLoadRows = &v
	return s
}

// SetInserts sets the Inserts field's value.
func (s *TableStatistics) SetInserts(v int64) *TableStatistics {
	s.Inserts = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *TableStatistics) SetLastUpdateTime(v time.Time) *TableStatistics {
	s.LastUpdateTime = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *TableStatistics) SetSchemaName(v string) *TableStatistics {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableStatistics) SetTableName(v string) *TableStatistics {
	s.TableName = &v
	return s
}

// SetTableState sets the TableState field's value.
func (s *TableStatistics) SetTableState(v string) *TableStatistics {
	s.TableState = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *TableStatistics) SetUpdates(v int64) *TableStatistics {
	s.Updates = &v
	return s
}

// SetValidationFailedRecords sets the ValidationFailedRecords field's value.
func (s *TableStatistics) SetValidationFailedRecords(v int64) *TableStatistics {
	s.ValidationFailedRecords = &v
	return s
}

// SetValidationPendingRecords sets the ValidationPendingRecords field's value.
func (s *TableStatistics) SetValidationPendingRecords(v int64) *TableStatistics {
	s.ValidationPendingRecords = &v
	return s
}

// SetValidationState sets the ValidationState field's value.
func (s *TableStatistics) SetValidationState(v string) *TableStatistics {
	s.ValidationState = &v
	return s
}

// SetValidationSuspendedRecords sets the ValidationSuspendedRecords field's value.
func (s *TableStatistics) SetValidationSuspendedRecords(v int64) *TableStatistics {
	s.ValidationSuspendedRecords = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TableToReload
type TableToReload struct {
	_ struct{} `type:"structure"`

	// The schema name of the table to be reloaded.
	SchemaName *string `type:"string"`

	// The table name of the table to be reloaded.
	TableName *string `type:"string"`
}

// String returns the string representation
func (s TableToReload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableToReload) GoString() string {
	return s.String()
}

// SetSchemaName sets the SchemaName field's value.
func (s *TableToReload) SetSchemaName(v string) *TableToReload {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableToReload) SetTableName(v string) *TableToReload {
	s.TableName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and cannot be prefixed with "aws:" or "dms:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and cannot be prefixed with "aws:" or
	// "dms:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnectionMessage
type TestConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestConnectionInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *TestConnectionInput) SetEndpointArn(v string) *TestConnectionInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *TestConnectionInput) SetReplicationInstanceArn(v string) *TestConnectionInput {
	s.ReplicationInstanceArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnectionResponse
type TestConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection tested.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s TestConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *TestConnectionOutput) SetConnection(v *Connection) *TestConnectionOutput {
	s.Connection = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/VpcSecurityGroupMembership
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The VPC security group Id.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// AuthMechanismValueDefault is a AuthMechanismValue enum value
	AuthMechanismValueDefault = "default"

	// AuthMechanismValueMongodbCr is a AuthMechanismValue enum value
	AuthMechanismValueMongodbCr = "mongodb_cr"

	// AuthMechanismValueScramSha1 is a AuthMechanismValue enum value
	AuthMechanismValueScramSha1 = "scram_sha_1"
)

const (
	// AuthTypeValueNo is a AuthTypeValue enum value
	AuthTypeValueNo = "no"

	// AuthTypeValuePassword is a AuthTypeValue enum value
	AuthTypeValuePassword = "password"
)

const (
	// CompressionTypeValueNone is a CompressionTypeValue enum value
	CompressionTypeValueNone = "none"

	// CompressionTypeValueGzip is a CompressionTypeValue enum value
	CompressionTypeValueGzip = "gzip"
)

const (
	// DmsSslModeValueNone is a DmsSslModeValue enum value
	DmsSslModeValueNone = "none"

	// DmsSslModeValueRequire is a DmsSslModeValue enum value
	DmsSslModeValueRequire = "require"

	// DmsSslModeValueVerifyCa is a DmsSslModeValue enum value
	DmsSslModeValueVerifyCa = "verify-ca"

	// DmsSslModeValueVerifyFull is a DmsSslModeValue enum value
	DmsSslModeValueVerifyFull = "verify-full"
)

const (
	// MigrationTypeValueFullLoad is a MigrationTypeValue enum value
	MigrationTypeValueFullLoad = "full-load"

	// MigrationTypeValueCdc is a MigrationTypeValue enum value
	MigrationTypeValueCdc = "cdc"

	// MigrationTypeValueFullLoadAndCdc is a MigrationTypeValue enum value
	MigrationTypeValueFullLoadAndCdc = "full-load-and-cdc"
)

const (
	// NestingLevelValueNone is a NestingLevelValue enum value
	NestingLevelValueNone = "none"

	// NestingLevelValueOne is a NestingLevelValue enum value
	NestingLevelValueOne = "one"
)

const (
	// RefreshSchemasStatusTypeValueSuccessful is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueSuccessful = "successful"

	// RefreshSchemasStatusTypeValueFailed is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueFailed = "failed"

	// RefreshSchemasStatusTypeValueRefreshing is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueRefreshing = "refreshing"
)

const (
	// ReplicationEndpointTypeValueSource is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueSource = "source"

	// ReplicationEndpointTypeValueTarget is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueTarget = "target"
)

const (
	// SourceTypeReplicationInstance is a SourceType enum value
	SourceTypeReplicationInstance = "replication-instance"
)

const (
	// StartReplicationTaskTypeValueStartReplication is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueStartReplication = "start-replication"

	// StartReplicationTaskTypeValueResumeProcessing is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueResumeProcessing = "resume-processing"

	// StartReplicationTaskTypeValueReloadTarget is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueReloadTarget = "reload-target"
)
