// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateIpGroups = "AssociateIpGroups"

// AssociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpGroups for more information on using the AssociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateIpGroupsRequest method.
//    req, resp := client.AssociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroupsRequest(input *AssociateIpGroupsInput) (req *request.Request, output *AssociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opAssociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpGroupsInput{}
	}

	output = &AssociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIpGroups API operation for Amazon WorkSpaces.
//
// Associates the specified IP access control group with the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroups(input *AssociateIpGroupsInput) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	return out, req.Send()
}

// AssociateIpGroupsWithContext is the same as AssociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateIpGroupsWithContext(ctx aws.Context, input *AssociateIpGroupsInput, opts ...request.Option) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeIpRules = "AuthorizeIpRules"

// AuthorizeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeIpRules for more information on using the AuthorizeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeIpRulesRequest method.
//    req, resp := client.AuthorizeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRulesRequest(input *AuthorizeIpRulesInput) (req *request.Request, output *AuthorizeIpRulesOutput) {
	op := &request.Operation{
		Name:       opAuthorizeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeIpRulesInput{}
	}

	output = &AuthorizeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeIpRules API operation for Amazon WorkSpaces.
//
// Adds one or more rules to the specified IP access control group.
//
// This action gives users permission to access their WorkSpaces from the CIDR
// address ranges specified in the rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AuthorizeIpRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRules(input *AuthorizeIpRulesInput) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	return out, req.Send()
}

// AuthorizeIpRulesWithContext is the same as AuthorizeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AuthorizeIpRulesWithContext(ctx aws.Context, input *AuthorizeIpRulesInput, opts ...request.Option) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpGroup = "CreateIpGroup"

// CreateIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpGroup for more information on using the CreateIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIpGroupRequest method.
//    req, resp := client.CreateIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroupRequest(input *CreateIpGroupInput) (req *request.Request, output *CreateIpGroupOutput) {
	op := &request.Operation{
		Name:       opCreateIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpGroupInput{}
	}

	output = &CreateIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpGroup API operation for Amazon WorkSpaces.
//
// Creates an IP access control group.
//
// An IP access control group provides you with the ability to control the IP
// addresses from which users are allowed to access their WorkSpaces. To specify
// the CIDR address ranges, add rules to your IP access control group and then
// associate the group with your directory. You can add rules when you create
// the group or at any time using AuthorizeIpRules.
//
// There is a default IP access control group associated with your directory.
// If you don't associate an IP access control group with your directory, the
// default group is used. The default group includes a default rule that allows
// users to access their WorkSpaces from anywhere. You cannot modify the default
// IP access control group for your directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceCreationFailedException "ResourceCreationFailedException"
//   The resource could not be created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroup(input *CreateIpGroupInput) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	return out, req.Send()
}

// CreateIpGroupWithContext is the same as CreateIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateIpGroupWithContext(ctx aws.Context, input *CreateIpGroupInput, opts ...request.Option) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTags API operation for Amazon WorkSpaces.
//
// Creates the specified tags for the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaces for more information on using the CreateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkspacesRequest method.
//    req, resp := client.CreateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspacesRequest(input *CreateWorkspacesInput) (req *request.Request, output *CreateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	output = &CreateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaces API operation for Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspaces(input *CreateWorkspacesInput) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	return out, req.Send()
}

// CreateWorkspacesWithContext is the same as CreateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspacesWithContext(ctx aws.Context, input *CreateWorkspacesInput, opts ...request.Option) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpGroup = "DeleteIpGroup"

// DeleteIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpGroup for more information on using the DeleteIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIpGroupRequest method.
//    req, resp := client.DeleteIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroupRequest(input *DeleteIpGroupInput) (req *request.Request, output *DeleteIpGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpGroupInput{}
	}

	output = &DeleteIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIpGroup API operation for Amazon WorkSpaces.
//
// Deletes the specified IP access control group.
//
// You cannot delete an IP access control group that is associated with a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceAssociatedException "ResourceAssociatedException"
//   The resource is associated with a directory.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroup(input *DeleteIpGroupInput) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	return out, req.Send()
}

// DeleteIpGroupWithContext is the same as DeleteIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteIpGroupWithContext(ctx aws.Context, input *DeleteIpGroupInput, opts ...request.Option) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTags API operation for Amazon WorkSpaces.
//
// Deletes the specified tags from the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpGroups = "DescribeIpGroups"

// DescribeIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpGroups for more information on using the DescribeIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIpGroupsRequest method.
//    req, resp := client.DescribeIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroupsRequest(input *DescribeIpGroupsInput) (req *request.Request, output *DescribeIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIpGroupsInput{}
	}

	output = &DescribeIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpGroups API operation for Amazon WorkSpaces.
//
// Describes one or more of your IP access control groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroups(input *DescribeIpGroupsInput) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	return out, req.Send()
}

// DescribeIpGroupsWithContext is the same as DescribeIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeIpGroupsWithContext(ctx aws.Context, input *DescribeIpGroupsInput, opts ...request.Option) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon WorkSpaces.
//
// Describes the specified tags for the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceBundles = "DescribeWorkspaceBundles"

// DescribeWorkspaceBundlesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceBundles for more information on using the DescribeWorkspaceBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceBundlesRequest method.
//    req, resp := client.DescribeWorkspaceBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundlesRequest(input *DescribeWorkspaceBundlesInput) (req *request.Request, output *DescribeWorkspaceBundlesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceBundlesInput{}
	}

	output = &DescribeWorkspaceBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceBundles API operation for Amazon WorkSpaces.
//
// Describes the available WorkSpace bundles.
//
// You can filter the results using either bundle ID or owner, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundles(input *DescribeWorkspaceBundlesInput) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceBundlesWithContext is the same as DescribeWorkspaceBundles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, opts ...request.Option) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceBundlesPages iterates over the pages of a DescribeWorkspaceBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceBundles operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceBundlesPages(params,
//        func(page *DescribeWorkspaceBundlesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceBundlesPages(input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool) error {
	return c.DescribeWorkspaceBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceBundlesPagesWithContext same as DescribeWorkspaceBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspaceBundlesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceDirectories for more information on using the DescribeWorkspaceDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceDirectoriesRequest method.
//    req, resp := client.DescribeWorkspaceDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) (req *request.Request, output *DescribeWorkspaceDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	output = &DescribeWorkspaceDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceDirectories API operation for Amazon WorkSpaces.
//
// Describes the available AWS Directory Service directories that are registered
// with Amazon WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceDirectories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectories(input *DescribeWorkspaceDirectoriesInput) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesWithContext is the same as DescribeWorkspaceDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, opts ...request.Option) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesPages iterates over the pages of a DescribeWorkspaceDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceDirectories operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceDirectoriesPages(params,
//        func(page *DescribeWorkspaceDirectoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPages(input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool) error {
	return c.DescribeWorkspaceDirectoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceDirectoriesPagesWithContext same as DescribeWorkspaceDirectoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceDirectoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceDirectoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspaceDirectoriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspaces = "DescribeWorkspaces"

// DescribeWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaces for more information on using the DescribeWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesRequest method.
//    req, resp := client.DescribeWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspacesRequest(input *DescribeWorkspacesInput) (req *request.Request, output *DescribeWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspacesInput{}
	}

	output = &DescribeWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaces API operation for Amazon WorkSpaces.
//
// Describes the specified WorkSpaces.
//
// You can filter the results using bundle ID, directory ID, or owner, but you
// can specify only one filter at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspaces(input *DescribeWorkspacesInput) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesWithContext is the same as DescribeWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, opts ...request.Option) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspacesPages iterates over the pages of a DescribeWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaces operation.
//    pageNum := 0
//    err := client.DescribeWorkspacesPages(params,
//        func(page *DescribeWorkspacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspacesPages(input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool) error {
	return c.DescribeWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspacesPagesWithContext same as DescribeWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPagesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspacesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspacesConnectionStatus = "DescribeWorkspacesConnectionStatus"

// DescribeWorkspacesConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesConnectionStatus for more information on using the DescribeWorkspacesConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesConnectionStatusRequest method.
//    req, resp := client.DescribeWorkspacesConnectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusRequest(input *DescribeWorkspacesConnectionStatusInput) (req *request.Request, output *DescribeWorkspacesConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesConnectionStatusInput{}
	}

	output = &DescribeWorkspacesConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesConnectionStatus API operation for Amazon WorkSpaces.
//
// Describes the connection status of the specified WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesConnectionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatus(input *DescribeWorkspacesConnectionStatusInput) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesConnectionStatusWithContext is the same as DescribeWorkspacesConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusWithContext(ctx aws.Context, input *DescribeWorkspacesConnectionStatusInput, opts ...request.Option) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIpGroups = "DisassociateIpGroups"

// DisassociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIpGroups for more information on using the DisassociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateIpGroupsRequest method.
//    req, resp := client.DisassociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroupsRequest(input *DisassociateIpGroupsInput) (req *request.Request, output *DisassociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDisassociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateIpGroupsInput{}
	}

	output = &DisassociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateIpGroups API operation for Amazon WorkSpaces.
//
// Disassociates the specified IP access control group from the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroups(input *DisassociateIpGroupsInput) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	return out, req.Send()
}

// DisassociateIpGroupsWithContext is the same as DisassociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateIpGroupsWithContext(ctx aws.Context, input *DisassociateIpGroupsInput, opts ...request.Option) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceProperties = "ModifyWorkspaceProperties"

// ModifyWorkspacePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceProperties for more information on using the ModifyWorkspaceProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspacePropertiesRequest method.
//    req, resp := client.ModifyWorkspacePropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspacePropertiesRequest(input *ModifyWorkspacePropertiesInput) (req *request.Request, output *ModifyWorkspacePropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspacePropertiesInput{}
	}

	output = &ModifyWorkspacePropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyWorkspaceProperties API operation for Amazon WorkSpaces.
//
// Modifies the specified WorkSpace properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceProperties for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   The properties of this WorkSpace are currently being modified. Try again
//   in a moment.
//
//   * ErrCodeUnsupportedWorkspaceConfigurationException "UnsupportedWorkspaceConfigurationException"
//   The configuration of this WorkSpace is not supported for this operation.
//   For more information, see the Amazon WorkSpaces Administration Guide (http://docs.aws.amazon.com/workspaces/latest/adminguide/).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspaceProperties(input *ModifyWorkspacePropertiesInput) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspacePropertiesWithContext is the same as ModifyWorkspaceProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspacePropertiesWithContext(ctx aws.Context, input *ModifyWorkspacePropertiesInput, opts ...request.Option) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceState = "ModifyWorkspaceState"

// ModifyWorkspaceStateRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceState for more information on using the ModifyWorkspaceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspaceStateRequest method.
//    req, resp := client.ModifyWorkspaceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceStateRequest(input *ModifyWorkspaceStateInput) (req *request.Request, output *ModifyWorkspaceStateOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceStateInput{}
	}

	output = &ModifyWorkspaceStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyWorkspaceState API operation for Amazon WorkSpaces.
//
// Sets the state of the specified WorkSpace.
//
// To maintain a WorkSpace without being interrupted, set the WorkSpace state
// to ADMIN_MAINTENANCE. WorkSpaces in this state do not respond to requests
// to reboot, stop, start, or rebuild. An AutoStop WorkSpace in this state is
// not stopped. Users can log into a WorkSpace in the ADMIN_MAINTENANCE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceState(input *ModifyWorkspaceStateInput) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceStateWithContext is the same as ModifyWorkspaceState with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceStateWithContext(ctx aws.Context, input *ModifyWorkspaceStateInput, opts ...request.Option) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootWorkspaces = "RebootWorkspaces"

// RebootWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebootWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootWorkspaces for more information on using the RebootWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootWorkspacesRequest method.
//    req, resp := client.RebootWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspacesRequest(input *RebootWorkspacesInput) (req *request.Request, output *RebootWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebootWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootWorkspacesInput{}
	}

	output = &RebootWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootWorkspaces API operation for Amazon WorkSpaces.
//
// Reboots the specified WorkSpaces.
//
// You cannot reboot a WorkSpace unless its state is AVAILABLE or UNHEALTHY.
//
// This operation is asynchronous and returns before the WorkSpaces have rebooted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebootWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspaces(input *RebootWorkspacesInput) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	return out, req.Send()
}

// RebootWorkspacesWithContext is the same as RebootWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebootWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebootWorkspacesWithContext(ctx aws.Context, input *RebootWorkspacesInput, opts ...request.Option) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebuildWorkspaces = "RebuildWorkspaces"

// RebuildWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebuildWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebuildWorkspaces for more information on using the RebuildWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebuildWorkspacesRequest method.
//    req, resp := client.RebuildWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspacesRequest(input *RebuildWorkspacesInput) (req *request.Request, output *RebuildWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebuildWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildWorkspacesInput{}
	}

	output = &RebuildWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebuildWorkspaces API operation for Amazon WorkSpaces.
//
// Rebuilds the specified WorkSpace.
//
// You cannot rebuild a WorkSpace unless its state is AVAILABLE, ERROR, or UNHEALTHY.
//
// Rebuilding a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Rebuild a WorkSpace (http://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely rebuilt.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebuildWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspaces(input *RebuildWorkspacesInput) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	return out, req.Send()
}

// RebuildWorkspacesWithContext is the same as RebuildWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebuildWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebuildWorkspacesWithContext(ctx aws.Context, input *RebuildWorkspacesInput, opts ...request.Option) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeIpRules = "RevokeIpRules"

// RevokeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the RevokeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeIpRules for more information on using the RevokeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeIpRulesRequest method.
//    req, resp := client.RevokeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRulesRequest(input *RevokeIpRulesInput) (req *request.Request, output *RevokeIpRulesOutput) {
	op := &request.Operation{
		Name:       opRevokeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeIpRulesInput{}
	}

	output = &RevokeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeIpRules API operation for Amazon WorkSpaces.
//
// Removes one or more rules from the specified IP access control group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RevokeIpRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRules(input *RevokeIpRulesInput) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	return out, req.Send()
}

// RevokeIpRulesWithContext is the same as RevokeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RevokeIpRulesWithContext(ctx aws.Context, input *RevokeIpRulesInput, opts ...request.Option) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkspaces = "StartWorkspaces"

// StartWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkspaces for more information on using the StartWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartWorkspacesRequest method.
//    req, resp := client.StartWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspacesRequest(input *StartWorkspacesInput) (req *request.Request, output *StartWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStartWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesInput{}
	}

	output = &StartWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkspaces API operation for Amazon WorkSpaces.
//
// Starts the specified WorkSpaces.
//
// You cannot start a WorkSpace unless it has a running mode of AutoStop and
// a state of STOPPED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspaces(input *StartWorkspacesInput) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	return out, req.Send()
}

// StartWorkspacesWithContext is the same as StartWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StartWorkspacesWithContext(ctx aws.Context, input *StartWorkspacesInput, opts ...request.Option) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkspaces for more information on using the StopWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopWorkspacesRequest method.
//    req, resp := client.StopWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspacesRequest(input *StopWorkspacesInput) (req *request.Request, output *StopWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	output = &StopWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkspaces API operation for Amazon WorkSpaces.
//
// Stops the specified WorkSpaces.
//
// You cannot stop a WorkSpace unless it has a running mode of AutoStop and
// a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspaces(input *StopWorkspacesInput) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	return out, req.Send()
}

// StopWorkspacesWithContext is the same as StopWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StopWorkspacesWithContext(ctx aws.Context, input *StopWorkspacesInput, opts ...request.Option) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspaces for more information on using the TerminateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateWorkspacesRequest method.
//    req, resp := client.TerminateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) (req *request.Request, output *TerminateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	output = &TerminateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateWorkspaces API operation for Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspaces(input *TerminateWorkspacesInput) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesWithContext is the same as TerminateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesWithContext(ctx aws.Context, input *TerminateWorkspacesInput, opts ...request.Option) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRulesOfIpGroup = "UpdateRulesOfIpGroup"

// UpdateRulesOfIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRulesOfIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRulesOfIpGroup for more information on using the UpdateRulesOfIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRulesOfIpGroupRequest method.
//    req, resp := client.UpdateRulesOfIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroupRequest(input *UpdateRulesOfIpGroupInput) (req *request.Request, output *UpdateRulesOfIpGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRulesOfIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRulesOfIpGroupInput{}
	}

	output = &UpdateRulesOfIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRulesOfIpGroup API operation for Amazon WorkSpaces.
//
// Replaces the current rules of the specified IP access control group with
// the specified rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateRulesOfIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroup(input *UpdateRulesOfIpGroupInput) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	return out, req.Send()
}

// UpdateRulesOfIpGroupWithContext is the same as UpdateRulesOfIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRulesOfIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateRulesOfIpGroupWithContext(ctx aws.Context, input *UpdateRulesOfIpGroupInput, opts ...request.Option) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The IDs of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AssociateIpGroupsInput) SetDirectoryId(v string) *AssociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *AssociateIpGroupsInput) SetGroupIds(v []*string) *AssociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type AssociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateIpGroupsOutput) GoString() string {
	return s.String()
}

type AuthorizeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to add to the group.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation
func (s AuthorizeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeIpRulesInput) SetGroupId(v string) *AuthorizeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *AuthorizeIpRulesInput) SetUserRules(v []*IpRuleItem) *AuthorizeIpRulesInput {
	s.UserRules = v
	return s
}

type AuthorizeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeIpRulesOutput) GoString() string {
	return s.String()
}

// Information about the compute type.
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The compute type.
	Name *string `type:"string" enum:"Compute"`
}

// String returns the string representation
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeType) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ComputeType) SetName(v string) *ComputeType {
	s.Name = &v
	return s
}

type CreateIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// The rules to add to the group.
	UserRules []*IpRuleItem `type:"list"`
}

// String returns the string representation
func (s CreateIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIpGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *CreateIpGroupInput) SetGroupDesc(v string) *CreateIpGroupInput {
	s.GroupDesc = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateIpGroupInput) SetGroupName(v string) *CreateIpGroupInput {
	s.GroupName = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *CreateIpGroupInput) SetUserRules(v []*IpRuleItem) *CreateIpGroupInput {
	s.UserRules = v
	return s
}

type CreateIpGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the group.
	GroupId *string `type:"string"`
}

// String returns the string representation
func (s CreateIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIpGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateIpGroupOutput) SetGroupId(v string) *CreateIpGroupOutput {
	s.GroupId = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace. To find this ID, use DescribeWorkspaces.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tags. Each WorkSpace can have a maximum of 50 tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateTagsInput) SetResourceId(v string) *CreateTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to create. You can specify up to 25 WorkSpaces.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesInput"}
	if s.Workspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaces sets the Workspaces field's value.
func (s *CreateWorkspacesInput) SetWorkspaces(v []*WorkspaceRequest) *CreateWorkspacesInput {
	s.Workspaces = v
	return s
}

type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be created.
	FailedRequests []*FailedCreateWorkspaceRequest `type:"list"`

	// Information about the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// before the WorkSpace is created, the information returned can be incomplete.
	PendingRequests []*Workspace `type:"list"`
}

// String returns the string representation
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *CreateWorkspacesOutput) SetFailedRequests(v []*FailedCreateWorkspaceRequest) *CreateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *CreateWorkspacesOutput) SetPendingRequests(v []*Workspace) *CreateWorkspacesOutput {
	s.PendingRequests = v
	return s
}

// Information about defaults used to create a WorkSpace.
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of any security groups to apply to WorkSpaces when they are
	// created.
	CustomSecurityGroupId *string `type:"string"`

	// The organizational unit (OU) in the directory for the WorkSpace machine accounts.
	DefaultOu *string `type:"string"`

	// The public IP address to attach to all WorkSpaces that are created or rebuilt.
	EnableInternetAccess *bool `type:"boolean"`

	// Indicates whether the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// Indicates whether the WorkSpace user is an administrator on the WorkSpace.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultWorkspaceCreationProperties) GoString() string {
	return s.String()
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *DefaultWorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *DefaultWorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *DefaultWorkspaceCreationProperties) SetDefaultOu(v string) *DefaultWorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableInternetAccess(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableWorkDocs(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *DefaultWorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *DefaultWorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

type DeleteIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the IP access control group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteIpGroupInput) SetGroupId(v string) *DeleteIpGroupInput {
	s.GroupId = &v
	return s
}

type DeleteIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIpGroupOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace. To find this ID, use DescribeWorkspaces.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of one or more IP access control groups.
	GroupIds []*string `type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIpGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *DescribeIpGroupsInput) SetGroupIds(v []*string) *DescribeIpGroupsInput {
	s.GroupIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeIpGroupsInput) SetMaxResults(v int64) *DescribeIpGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsInput) SetNextToken(v string) *DescribeIpGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeIpGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available. This token is valid for one day and must be used
	// within that time frame.
	NextToken *string `min:"1" type:"string"`

	// Information about the IP access control groups.
	Result []*IpGroup `type:"list"`
}

// String returns the string representation
func (s DescribeIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIpGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsOutput) SetNextToken(v string) *DescribeIpGroupsOutput {
	s.NextToken = &v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeIpGroupsOutput) SetResult(v []*IpGroup) *DescribeIpGroupsOutput {
	s.Result = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace. To find this ID, use DescribeWorkspaces.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *DescribeTagsOutput) SetTagList(v []*Tag) *DescribeTagsOutput {
	s.TagList = v
	return s
}

type DescribeWorkspaceBundlesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the bundles. This parameter cannot be combined with any other
	// filter.
	BundleIds []*string `min:"1" type:"list"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The owner of the bundles. This parameter cannot be combined with any other
	// filter.
	//
	// Specify AMAZON to describe the bundles provided by AWS or null to describe
	// the bundles that belong to your account.
	Owner *string `type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceBundlesInput"}
	if s.BundleIds != nil && len(s.BundleIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeWorkspaceBundlesInput) SetBundleIds(v []*string) *DescribeWorkspaceBundlesInput {
	s.BundleIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesInput) SetNextToken(v string) *DescribeWorkspaceBundlesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeWorkspaceBundlesInput) SetOwner(v string) *DescribeWorkspaceBundlesInput {
	s.Owner = &v
	return s
}

type DescribeWorkspaceBundlesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundles.
	Bundles []*WorkspaceBundle `type:"list"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available. This token is valid for one day and must be used
	// within that time frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *DescribeWorkspaceBundlesOutput) SetBundles(v []*WorkspaceBundle) *DescribeWorkspaceBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesOutput) SetNextToken(v string) *DescribeWorkspaceBundlesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the directories. If the value is null, all directories
	// are retrieved.
	DirectoryIds []*string `min:"1" type:"list"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetDirectoryIds(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetNextToken(v string) *DescribeWorkspaceDirectoriesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directories.
	Directories []*WorkspaceDirectory `type:"list"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available. This token is valid for one day and must be used
	// within that time frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetDirectories(v []*WorkspaceDirectory) *DescribeWorkspaceDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetNextToken(v string) *DescribeWorkspaceDirectoriesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspacesConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesConnectionStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesConnectionStatusInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available.
	NextToken *string `min:"1" type:"string"`

	// Information about the connection status of the WorkSpace.
	WorkspacesConnectionStatus []*WorkspaceConnectionStatus `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesConnectionStatus sets the WorkspacesConnectionStatus field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetWorkspacesConnectionStatus(v []*WorkspaceConnectionStatus) *DescribeWorkspacesConnectionStatusOutput {
	s.WorkspacesConnectionStatus = v
	return s
}

type DescribeWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle. All WorkSpaces that are created from this bundle are
	// retrieved. This parameter cannot be combined with any other filter.
	BundleId *string `type:"string"`

	// The ID of the directory. In addition, you can optionally specify a specific
	// directory user (see UserName). This parameter cannot be combined with any
	// other filter.
	DirectoryId *string `type:"string"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The name of the directory user. You must specify this parameter with DirectoryId.
	UserName *string `min:"1" type:"string"`

	// The IDs of the WorkSpaces. This parameter cannot be combined with any other
	// filter.
	//
	// Because the CreateWorkspaces operation is asynchronous, the identifier it
	// returns is not immediately available. If you immediately call DescribeWorkspaces
	// with this identifier, no information is returned.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeWorkspacesInput) SetBundleId(v string) *DescribeWorkspacesInput {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeWorkspacesInput) SetDirectoryId(v string) *DescribeWorkspacesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesInput) SetLimit(v int64) *DescribeWorkspacesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesInput) SetNextToken(v string) *DescribeWorkspacesInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeWorkspacesInput) SetUserName(v string) *DescribeWorkspacesInput {
	s.UserName = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available. This token is valid for one day and must be used
	// within that time frame.
	NextToken *string `min:"1" type:"string"`

	// Information about the WorkSpaces.
	//
	// Because CreateWorkspaces is an asynchronous operation, some of the returned
	// information could be incomplete.
	Workspaces []*Workspace `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesOutput) SetNextToken(v string) *DescribeWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *DescribeWorkspacesOutput) SetWorkspaces(v []*Workspace) *DescribeWorkspacesOutput {
	s.Workspaces = v
	return s
}

type DisassociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The IDs of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisassociateIpGroupsInput) SetDirectoryId(v string) *DisassociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *DisassociateIpGroupsInput) SetGroupIds(v []*string) *DisassociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type DisassociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateIpGroupsOutput) GoString() string {
	return s.String()
}

// Information about a WorkSpace that could not be created.
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The textual error message.
	ErrorMessage *string `type:"string"`

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateWorkspaceRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorCode(v string) *FailedCreateWorkspaceRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorMessage(v string) *FailedCreateWorkspaceRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceRequest sets the WorkspaceRequest field's value.
func (s *FailedCreateWorkspaceRequest) SetWorkspaceRequest(v *WorkspaceRequest) *FailedCreateWorkspaceRequest {
	s.WorkspaceRequest = v
	return s
}

// Information about a WorkSpace that could not be rebooted (RebootWorkspaces),
// rebuilt (RebuildWorkspaces), terminated (TerminateWorkspaces), started (StartWorkspaces),
// or stopped (StopWorkspaces).
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The textual error message.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedWorkspaceChangeRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorCode(v string) *FailedWorkspaceChangeRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorMessage(v string) *FailedWorkspaceChangeRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *FailedWorkspaceChangeRequest) SetWorkspaceId(v string) *FailedWorkspaceChangeRequest {
	s.WorkspaceId = &v
	return s
}

// Information about an IP access control group.
type IpGroup struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `locationName:"groupDesc" type:"string"`

	// The ID of the group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The rules.
	UserRules []*IpRuleItem `locationName:"userRules" type:"list"`
}

// String returns the string representation
func (s IpGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpGroup) GoString() string {
	return s.String()
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *IpGroup) SetGroupDesc(v string) *IpGroup {
	s.GroupDesc = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *IpGroup) SetGroupId(v string) *IpGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *IpGroup) SetGroupName(v string) *IpGroup {
	s.GroupName = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *IpGroup) SetUserRules(v []*IpRuleItem) *IpGroup {
	s.UserRules = v
	return s
}

// Information about a rule for an IP access control group.
type IpRuleItem struct {
	_ struct{} `type:"structure"`

	// The IP address range, in CIDR notation.
	IpRule *string `locationName:"ipRule" type:"string"`

	// The description.
	RuleDesc *string `locationName:"ruleDesc" type:"string"`
}

// String returns the string representation
func (s IpRuleItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRuleItem) GoString() string {
	return s.String()
}

// SetIpRule sets the IpRule field's value.
func (s *IpRuleItem) SetIpRule(v string) *IpRuleItem {
	s.IpRule = &v
	return s
}

// SetRuleDesc sets the RuleDesc field's value.
func (s *IpRuleItem) SetRuleDesc(v string) *IpRuleItem {
	s.RuleDesc = &v
	return s
}

// Information about a WorkSpace modification.
type ModificationState struct {
	_ struct{} `type:"structure"`

	// The resource.
	Resource *string `type:"string" enum:"ModificationResourceEnum"`

	// The modification state.
	State *string `type:"string" enum:"ModificationStateEnum"`
}

// String returns the string representation
func (s ModificationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModificationState) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *ModificationState) SetResource(v string) *ModificationState {
	s.Resource = &v
	return s
}

// SetState sets the State field's value.
func (s *ModificationState) SetState(v string) *ModificationState {
	s.State = &v
	return s
}

type ModifyWorkspacePropertiesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The properties of the WorkSpace.
	//
	// WorkspaceProperties is a required field
	WorkspaceProperties *WorkspaceProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspacePropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspacePropertiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceId(v string) *ModifyWorkspacePropertiesInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceProperties(v *WorkspaceProperties) *ModifyWorkspacePropertiesInput {
	s.WorkspaceProperties = v
	return s
}

type ModifyWorkspacePropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceStateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The WorkSpace state.
	//
	// WorkspaceState is a required field
	WorkspaceState *string `type:"string" required:"true" enum:"TargetWorkspaceState"`
}

// String returns the string representation
func (s ModifyWorkspaceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspaceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceStateInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceState == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceId(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceState sets the WorkspaceState field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceState(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceState = &v
	return s
}

type ModifyWorkspaceStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspaceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspaceStateOutput) GoString() string {
	return s.String()
}

// Information used to reboot a WorkSpace.
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebootRequest) SetWorkspaceId(v string) *RebootRequest {
	s.WorkspaceId = &v
	return s
}

type RebootWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
	//
	// RebootWorkspaceRequests is a required field
	RebootWorkspaceRequests []*RebootRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootWorkspacesInput"}
	if s.RebootWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebootWorkspaceRequests"))
	}
	if s.RebootWorkspaceRequests != nil && len(s.RebootWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebootWorkspaceRequests", 1))
	}
	if s.RebootWorkspaceRequests != nil {
		for i, v := range s.RebootWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebootWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebootWorkspaceRequests sets the RebootWorkspaceRequests field's value.
func (s *RebootWorkspacesInput) SetRebootWorkspaceRequests(v []*RebootRequest) *RebootWorkspacesInput {
	s.RebootWorkspaceRequests = v
	return s
}

type RebootWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be rebooted.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebootWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebootWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebootWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Information used to rebuild a WorkSpace.
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebuildRequest) SetWorkspaceId(v string) *RebuildRequest {
	s.WorkspaceId = &v
	return s
}

type RebuildWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpace to rebuild. You can specify a single WorkSpace.
	//
	// RebuildWorkspaceRequests is a required field
	RebuildWorkspaceRequests []*RebuildRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebuildWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildWorkspacesInput"}
	if s.RebuildWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebuildWorkspaceRequests"))
	}
	if s.RebuildWorkspaceRequests != nil && len(s.RebuildWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebuildWorkspaceRequests", 1))
	}
	if s.RebuildWorkspaceRequests != nil {
		for i, v := range s.RebuildWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebuildWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebuildWorkspaceRequests sets the RebuildWorkspaceRequests field's value.
func (s *RebuildWorkspacesInput) SetRebuildWorkspaceRequests(v []*RebuildRequest) *RebuildWorkspacesInput {
	s.RebuildWorkspaceRequests = v
	return s
}

type RebuildWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpace if it could not be rebuilt.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebuildWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebuildWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebuildWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type RevokeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to remove from the group.
	//
	// UserRules is a required field
	UserRules []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RevokeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *RevokeIpRulesInput) SetGroupId(v string) *RevokeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *RevokeIpRulesInput) SetUserRules(v []*string) *RevokeIpRulesInput {
	s.UserRules = v
	return s
}

type RevokeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeIpRulesOutput) GoString() string {
	return s.String()
}

// Information about the root volume for a WorkSpace bundle.
type RootStorage struct {
	_ struct{} `type:"structure"`

	// The size of the root volume.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RootStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RootStorage) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *RootStorage) SetCapacity(v string) *RootStorage {
	s.Capacity = &v
	return s
}

// Information used to start a WorkSpace.
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StartRequest) SetWorkspaceId(v string) *StartRequest {
	s.WorkspaceId = &v
	return s
}

type StartWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to start. You can specify up to 25 WorkSpaces.
	//
	// StartWorkspaceRequests is a required field
	StartWorkspaceRequests []*StartRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StartWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesInput"}
	if s.StartWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StartWorkspaceRequests"))
	}
	if s.StartWorkspaceRequests != nil && len(s.StartWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartWorkspaceRequests sets the StartWorkspaceRequests field's value.
func (s *StartWorkspacesInput) SetStartWorkspaceRequests(v []*StartRequest) *StartWorkspacesInput {
	s.StartWorkspaceRequests = v
	return s
}

type StartWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be started.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StartWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StartWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Information used to stop a WorkSpace.
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StopRequest) SetWorkspaceId(v string) *StopRequest {
	s.WorkspaceId = &v
	return s
}

type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []*StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesInput"}
	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStopWorkspaceRequests sets the StopWorkspaceRequests field's value.
func (s *StopWorkspacesInput) SetStopWorkspaceRequests(v []*StopRequest) *StopWorkspacesInput {
	s.StopWorkspaceRequests = v
	return s
}

type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be stopped.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StopWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StopWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Information used to terminate a WorkSpace.
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *TerminateRequest) SetWorkspaceId(v string) *TerminateRequest {
	s.WorkspaceId = &v
	return s
}

type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []*TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesInput"}
	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTerminateWorkspaceRequests sets the TerminateWorkspaceRequests field's value.
func (s *TerminateWorkspacesInput) SetTerminateWorkspaceRequests(v []*TerminateRequest) *TerminateWorkspacesInput {
	s.TerminateWorkspaceRequests = v
	return s
}

type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *TerminateWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *TerminateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type UpdateRulesOfIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// One or more rules.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRulesOfIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRulesOfIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRulesOfIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRulesOfIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateRulesOfIpGroupInput) SetGroupId(v string) *UpdateRulesOfIpGroupInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *UpdateRulesOfIpGroupInput) SetUserRules(v []*IpRuleItem) *UpdateRulesOfIpGroupInput {
	s.UserRules = v
	return s
}

type UpdateRulesOfIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRulesOfIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRulesOfIpGroupOutput) GoString() string {
	return s.String()
}

// Information about the user storage for a WorkSpace bundle.
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The size of the user storage.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStorage) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *UserStorage) SetCapacity(v string) *UserStorage {
	s.Capacity = &v
	return s
}

// Information about a WorkSpace.
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string `type:"string"`

	// The name of the WorkSpace, as seen by the operating system.
	ComputerName *string `type:"string"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	DirectoryId *string `type:"string"`

	// If the WorkSpace could not be created, contains the error code.
	ErrorCode *string `type:"string"`

	// If the WorkSpace could not be created, contains a textual error message that
	// describes the failure.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// The modification states of the WorkSpace.
	ModificationStates []*ModificationState `type:"list"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The operational state of the WorkSpace.
	State *string `type:"string" enum:"WorkspaceState"`

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string `type:"string"`

	// The user for the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Workspace) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Workspace) SetBundleId(v string) *Workspace {
	s.BundleId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Workspace) SetComputerName(v string) *Workspace {
	s.ComputerName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Workspace) SetDirectoryId(v string) *Workspace {
	s.DirectoryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Workspace) SetErrorCode(v string) *Workspace {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Workspace) SetErrorMessage(v string) *Workspace {
	s.ErrorMessage = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Workspace) SetIpAddress(v string) *Workspace {
	s.IpAddress = &v
	return s
}

// SetModificationStates sets the ModificationStates field's value.
func (s *Workspace) SetModificationStates(v []*ModificationState) *Workspace {
	s.ModificationStates = v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *Workspace) SetRootVolumeEncryptionEnabled(v bool) *Workspace {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetState sets the State field's value.
func (s *Workspace) SetState(v string) *Workspace {
	s.State = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Workspace) SetSubnetId(v string) *Workspace {
	s.SubnetId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *Workspace) SetUserName(v string) *Workspace {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *Workspace) SetUserVolumeEncryptionEnabled(v bool) *Workspace {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *Workspace) SetVolumeEncryptionKey(v string) *Workspace {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *Workspace) SetWorkspaceId(v string) *Workspace {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *Workspace) SetWorkspaceProperties(v *WorkspaceProperties) *Workspace {
	s.WorkspaceProperties = v
	return s
}

// Information about a WorkSpace bundle.
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The bundle identifier.
	BundleId *string `type:"string"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeType *ComputeType `type:"structure"`

	// A description.
	Description *string `type:"string"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This is the account identifier of the owner, or
	// AMAZON if the bundle is provided by AWS.
	Owner *string `type:"string"`

	// The size of the root volume.
	RootStorage *RootStorage `type:"structure"`

	// The size of the user storage.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceBundle) SetBundleId(v string) *WorkspaceBundle {
	s.BundleId = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *WorkspaceBundle) SetComputeType(v *ComputeType) *WorkspaceBundle {
	s.ComputeType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceBundle) SetDescription(v string) *WorkspaceBundle {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceBundle) SetName(v string) *WorkspaceBundle {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkspaceBundle) SetOwner(v string) *WorkspaceBundle {
	s.Owner = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *WorkspaceBundle) SetRootStorage(v *RootStorage) *WorkspaceBundle {
	s.RootStorage = v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *WorkspaceBundle) SetUserStorage(v *UserStorage) *WorkspaceBundle {
	s.UserStorage = v
	return s
}

// Describes the connection status of a WorkSpace.
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. The connection state is unknown if
	// the WorkSpace is stopped.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The timestamp of the connection state check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceConnectionStatus) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspaceConnectionStatus) SetConnectionState(v string) *WorkspaceConnectionStatus {
	s.ConnectionState = &v
	return s
}

// SetConnectionStateCheckTimestamp sets the ConnectionStateCheckTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetConnectionStateCheckTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.ConnectionStateCheckTimestamp = &v
	return s
}

// SetLastKnownUserConnectionTimestamp sets the LastKnownUserConnectionTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetLastKnownUserConnectionTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.LastKnownUserConnectionTimestamp = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceConnectionStatus) SetWorkspaceId(v string) *WorkspaceConnectionStatus {
	s.WorkspaceId = &v
	return s
}

// Information about an AWS Directory Service directory for use with Amazon
// WorkSpaces.
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType *string `type:"string" enum:"WorkspaceDirectoryType"`

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []*string `type:"list"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []*string `locationName:"ipGroupIds" type:"list"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// The state of the directory's registration with Amazon WorkSpaces
	State *string `type:"string" enum:"WorkspaceDirectoryState"`

	// The identifiers of the subnets used with the directory.
	SubnetIds []*string `type:"list"`

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceDirectory) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDirectory) SetAlias(v string) *WorkspaceDirectory {
	s.Alias = &v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *WorkspaceDirectory) SetCustomerUserName(v string) *WorkspaceDirectory {
	s.CustomerUserName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceDirectory) SetDirectoryId(v string) *WorkspaceDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *WorkspaceDirectory) SetDirectoryName(v string) *WorkspaceDirectory {
	s.DirectoryName = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *WorkspaceDirectory) SetDirectoryType(v string) *WorkspaceDirectory {
	s.DirectoryType = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *WorkspaceDirectory) SetDnsIpAddresses(v []*string) *WorkspaceDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetIamRoleId sets the IamRoleId field's value.
func (s *WorkspaceDirectory) SetIamRoleId(v string) *WorkspaceDirectory {
	s.IamRoleId = &v
	return s
}

// SetIpGroupIds sets the IpGroupIds field's value.
func (s *WorkspaceDirectory) SetIpGroupIds(v []*string) *WorkspaceDirectory {
	s.IpGroupIds = v
	return s
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *WorkspaceDirectory) SetRegistrationCode(v string) *WorkspaceDirectory {
	s.RegistrationCode = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceDirectory) SetState(v string) *WorkspaceDirectory {
	s.State = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkspaceDirectory) SetSubnetIds(v []*string) *WorkspaceDirectory {
	s.SubnetIds = v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceCreationProperties(v *DefaultWorkspaceCreationProperties) *WorkspaceDirectory {
	s.WorkspaceCreationProperties = v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *WorkspaceDirectory) SetWorkspaceSecurityGroupId(v string) *WorkspaceDirectory {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// Information about a WorkSpace.
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeTypeName *string `type:"string" enum:"Compute"`

	// The size of the root volume.
	RootVolumeSizeGib *int64 `type:"integer"`

	// The running mode. For more information, see Manage the WorkSpace Running
	// Mode (http://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
	RunningMode *string `type:"string" enum:"RunningMode"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60 minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`

	// The size of the user storage.
	UserVolumeSizeGib *int64 `type:"integer"`
}

// String returns the string representation
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceProperties) GoString() string {
	return s.String()
}

// SetComputeTypeName sets the ComputeTypeName field's value.
func (s *WorkspaceProperties) SetComputeTypeName(v string) *WorkspaceProperties {
	s.ComputeTypeName = &v
	return s
}

// SetRootVolumeSizeGib sets the RootVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetRootVolumeSizeGib(v int64) *WorkspaceProperties {
	s.RootVolumeSizeGib = &v
	return s
}

// SetRunningMode sets the RunningMode field's value.
func (s *WorkspaceProperties) SetRunningMode(v string) *WorkspaceProperties {
	s.RunningMode = &v
	return s
}

// SetRunningModeAutoStopTimeoutInMinutes sets the RunningModeAutoStopTimeoutInMinutes field's value.
func (s *WorkspaceProperties) SetRunningModeAutoStopTimeoutInMinutes(v int64) *WorkspaceProperties {
	s.RunningModeAutoStopTimeoutInMinutes = &v
	return s
}

// SetUserVolumeSizeGib sets the UserVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetUserVolumeSizeGib(v int64) *WorkspaceProperties {
	s.UserVolumeSizeGib = &v
	return s
}

// Information used to create a WorkSpace.
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles
	// to list the available bundles.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	// You can use DescribeWorkspaceDirectories to list the available directories.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags for the WorkSpace.
	Tags []*Tag `type:"list"`

	// The username of the user for the WorkSpace. This username must exist in the
	// AWS Directory Service directory for the WorkSpace.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceRequest"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceRequest) SetBundleId(v string) *WorkspaceRequest {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceRequest) SetDirectoryId(v string) *WorkspaceRequest {
	s.DirectoryId = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetRootVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceRequest) SetTags(v []*Tag) *WorkspaceRequest {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *WorkspaceRequest) SetUserName(v string) *WorkspaceRequest {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetUserVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *WorkspaceRequest) SetVolumeEncryptionKey(v string) *WorkspaceRequest {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *WorkspaceRequest) SetWorkspaceProperties(v *WorkspaceProperties) *WorkspaceRequest {
	s.WorkspaceProperties = v
	return s
}

const (
	// ComputeValue is a Compute enum value
	ComputeValue = "VALUE"

	// ComputeStandard is a Compute enum value
	ComputeStandard = "STANDARD"

	// ComputePerformance is a Compute enum value
	ComputePerformance = "PERFORMANCE"

	// ComputePower is a Compute enum value
	ComputePower = "POWER"

	// ComputeGraphics is a Compute enum value
	ComputeGraphics = "GRAPHICS"
)

const (
	// ConnectionStateConnected is a ConnectionState enum value
	ConnectionStateConnected = "CONNECTED"

	// ConnectionStateDisconnected is a ConnectionState enum value
	ConnectionStateDisconnected = "DISCONNECTED"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "UNKNOWN"
)

const (
	// ModificationResourceEnumRootVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumRootVolume = "ROOT_VOLUME"

	// ModificationResourceEnumUserVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumUserVolume = "USER_VOLUME"

	// ModificationResourceEnumComputeType is a ModificationResourceEnum enum value
	ModificationResourceEnumComputeType = "COMPUTE_TYPE"
)

const (
	// ModificationStateEnumUpdateInitiated is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInitiated = "UPDATE_INITIATED"

	// ModificationStateEnumUpdateInProgress is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInProgress = "UPDATE_IN_PROGRESS"
)

const (
	// RunningModeAutoStop is a RunningMode enum value
	RunningModeAutoStop = "AUTO_STOP"

	// RunningModeAlwaysOn is a RunningMode enum value
	RunningModeAlwaysOn = "ALWAYS_ON"
)

const (
	// TargetWorkspaceStateAvailable is a TargetWorkspaceState enum value
	TargetWorkspaceStateAvailable = "AVAILABLE"

	// TargetWorkspaceStateAdminMaintenance is a TargetWorkspaceState enum value
	TargetWorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"
)

const (
	// WorkspaceDirectoryStateRegistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistering = "REGISTERING"

	// WorkspaceDirectoryStateRegistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistered = "REGISTERED"

	// WorkspaceDirectoryStateDeregistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistering = "DEREGISTERING"

	// WorkspaceDirectoryStateDeregistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistered = "DEREGISTERED"

	// WorkspaceDirectoryStateError is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateError = "ERROR"
)

const (
	// WorkspaceDirectoryTypeSimpleAd is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeSimpleAd = "SIMPLE_AD"

	// WorkspaceDirectoryTypeAdConnector is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeAdConnector = "AD_CONNECTOR"
)

const (
	// WorkspaceStatePending is a WorkspaceState enum value
	WorkspaceStatePending = "PENDING"

	// WorkspaceStateAvailable is a WorkspaceState enum value
	WorkspaceStateAvailable = "AVAILABLE"

	// WorkspaceStateImpaired is a WorkspaceState enum value
	WorkspaceStateImpaired = "IMPAIRED"

	// WorkspaceStateUnhealthy is a WorkspaceState enum value
	WorkspaceStateUnhealthy = "UNHEALTHY"

	// WorkspaceStateRebooting is a WorkspaceState enum value
	WorkspaceStateRebooting = "REBOOTING"

	// WorkspaceStateStarting is a WorkspaceState enum value
	WorkspaceStateStarting = "STARTING"

	// WorkspaceStateRebuilding is a WorkspaceState enum value
	WorkspaceStateRebuilding = "REBUILDING"

	// WorkspaceStateMaintenance is a WorkspaceState enum value
	WorkspaceStateMaintenance = "MAINTENANCE"

	// WorkspaceStateAdminMaintenance is a WorkspaceState enum value
	WorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"

	// WorkspaceStateTerminating is a WorkspaceState enum value
	WorkspaceStateTerminating = "TERMINATING"

	// WorkspaceStateTerminated is a WorkspaceState enum value
	WorkspaceStateTerminated = "TERMINATED"

	// WorkspaceStateSuspended is a WorkspaceState enum value
	WorkspaceStateSuspended = "SUSPENDED"

	// WorkspaceStateUpdating is a WorkspaceState enum value
	WorkspaceStateUpdating = "UPDATING"

	// WorkspaceStateStopping is a WorkspaceState enum value
	WorkspaceStateStopping = "STOPPING"

	// WorkspaceStateStopped is a WorkspaceState enum value
	WorkspaceStateStopped = "STOPPED"

	// WorkspaceStateError is a WorkspaceState enum value
	WorkspaceStateError = "ERROR"
)
