// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v5.26.1
// source: cc/arduino/cli/commands/v1/settings.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Configuration to apply to the given instance.
// Any missing field will be kept at the default value.
type Configuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Directories  *Configuration_Directories  `protobuf:"bytes,1,opt,name=directories,proto3" json:"directories,omitempty"`
	Network      *Configuration_Network      `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	Sketch       *Configuration_Sketch       `protobuf:"bytes,3,opt,name=sketch,proto3" json:"sketch,omitempty"`
	BuildCache   *Configuration_BuildCache   `protobuf:"bytes,4,opt,name=build_cache,json=buildCache,proto3" json:"build_cache,omitempty"`
	BoardManager *Configuration_BoardManager `protobuf:"bytes,5,opt,name=board_manager,json=boardManager,proto3" json:"board_manager,omitempty"`
	Daemon       *Configuration_Daemon       `protobuf:"bytes,6,opt,name=daemon,proto3" json:"daemon,omitempty"`
	Output       *Configuration_Output       `protobuf:"bytes,7,opt,name=output,proto3" json:"output,omitempty"`
	Logging      *Configuration_Logging      `protobuf:"bytes,8,opt,name=logging,proto3" json:"logging,omitempty"`
	Library      *Configuration_Library      `protobuf:"bytes,9,opt,name=library,proto3" json:"library,omitempty"`
	Updater      *Configuration_Updater      `protobuf:"bytes,10,opt,name=updater,proto3" json:"updater,omitempty"`
	Locale       *string                     `protobuf:"bytes,100,opt,name=locale,proto3,oneof" json:"locale,omitempty"`
}

func (x *Configuration) Reset() {
	*x = Configuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration) ProtoMessage() {}

func (x *Configuration) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration.ProtoReflect.Descriptor instead.
func (*Configuration) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0}
}

func (x *Configuration) GetDirectories() *Configuration_Directories {
	if x != nil {
		return x.Directories
	}
	return nil
}

func (x *Configuration) GetNetwork() *Configuration_Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Configuration) GetSketch() *Configuration_Sketch {
	if x != nil {
		return x.Sketch
	}
	return nil
}

func (x *Configuration) GetBuildCache() *Configuration_BuildCache {
	if x != nil {
		return x.BuildCache
	}
	return nil
}

func (x *Configuration) GetBoardManager() *Configuration_BoardManager {
	if x != nil {
		return x.BoardManager
	}
	return nil
}

func (x *Configuration) GetDaemon() *Configuration_Daemon {
	if x != nil {
		return x.Daemon
	}
	return nil
}

func (x *Configuration) GetOutput() *Configuration_Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *Configuration) GetLogging() *Configuration_Logging {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Configuration) GetLibrary() *Configuration_Library {
	if x != nil {
		return x.Library
	}
	return nil
}

func (x *Configuration) GetUpdater() *Configuration_Updater {
	if x != nil {
		return x.Updater
	}
	return nil
}

func (x *Configuration) GetLocale() string {
	if x != nil && x.Locale != nil {
		return *x.Locale
	}
	return ""
}

type ConfigurationGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ConfigurationGetRequest) Reset() {
	*x = ConfigurationGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationGetRequest) ProtoMessage() {}

func (x *ConfigurationGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationGetRequest.ProtoReflect.Descriptor instead.
func (*ConfigurationGetRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{1}
}

type ConfigurationGetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current configuration
	Configuration *Configuration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *ConfigurationGetResponse) Reset() {
	*x = ConfigurationGetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationGetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationGetResponse) ProtoMessage() {}

func (x *ConfigurationGetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationGetResponse.ProtoReflect.Descriptor instead.
func (*ConfigurationGetResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{2}
}

func (x *ConfigurationGetResponse) GetConfiguration() *Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type ConfigurationSaveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The format of the encoded settings, allowed values are "json" and "yaml"
	SettingsFormat string `protobuf:"bytes,1,opt,name=settings_format,json=settingsFormat,proto3" json:"settings_format,omitempty"`
}

func (x *ConfigurationSaveRequest) Reset() {
	*x = ConfigurationSaveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationSaveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationSaveRequest) ProtoMessage() {}

func (x *ConfigurationSaveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationSaveRequest.ProtoReflect.Descriptor instead.
func (*ConfigurationSaveRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{3}
}

func (x *ConfigurationSaveRequest) GetSettingsFormat() string {
	if x != nil {
		return x.SettingsFormat
	}
	return ""
}

type ConfigurationSaveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoded settings
	EncodedSettings string `protobuf:"bytes,1,opt,name=encoded_settings,json=encodedSettings,proto3" json:"encoded_settings,omitempty"`
}

func (x *ConfigurationSaveResponse) Reset() {
	*x = ConfigurationSaveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationSaveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationSaveResponse) ProtoMessage() {}

func (x *ConfigurationSaveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationSaveResponse.ProtoReflect.Descriptor instead.
func (*ConfigurationSaveResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{4}
}

func (x *ConfigurationSaveResponse) GetEncodedSettings() string {
	if x != nil {
		return x.EncodedSettings
	}
	return ""
}

type ConfigurationOpenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoded settings
	EncodedSettings string `protobuf:"bytes,1,opt,name=encoded_settings,json=encodedSettings,proto3" json:"encoded_settings,omitempty"`
	// The format of the encoded settings, allowed values are "json" and "yaml"
	SettingsFormat string `protobuf:"bytes,2,opt,name=settings_format,json=settingsFormat,proto3" json:"settings_format,omitempty"`
}

func (x *ConfigurationOpenRequest) Reset() {
	*x = ConfigurationOpenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationOpenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationOpenRequest) ProtoMessage() {}

func (x *ConfigurationOpenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationOpenRequest.ProtoReflect.Descriptor instead.
func (*ConfigurationOpenRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{5}
}

func (x *ConfigurationOpenRequest) GetEncodedSettings() string {
	if x != nil {
		return x.EncodedSettings
	}
	return ""
}

func (x *ConfigurationOpenRequest) GetSettingsFormat() string {
	if x != nil {
		return x.SettingsFormat
	}
	return ""
}

type ConfigurationOpenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Warnings that occurred while opening the configuration (e.g. unknown keys,
	// or invalid values)
	Warnings []string `protobuf:"bytes,1,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *ConfigurationOpenResponse) Reset() {
	*x = ConfigurationOpenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigurationOpenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurationOpenResponse) ProtoMessage() {}

func (x *ConfigurationOpenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurationOpenResponse.ProtoReflect.Descriptor instead.
func (*ConfigurationOpenResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{6}
}

func (x *ConfigurationOpenResponse) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

type SettingsGetValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key to get
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The format of the encoded_value (default is "json", allowed values are
	// "json" and "yaml)
	ValueFormat string `protobuf:"bytes,2,opt,name=value_format,json=valueFormat,proto3" json:"value_format,omitempty"`
}

func (x *SettingsGetValueRequest) Reset() {
	*x = SettingsGetValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsGetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsGetValueRequest) ProtoMessage() {}

func (x *SettingsGetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsGetValueRequest.ProtoReflect.Descriptor instead.
func (*SettingsGetValueRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{7}
}

func (x *SettingsGetValueRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SettingsGetValueRequest) GetValueFormat() string {
	if x != nil {
		return x.ValueFormat
	}
	return ""
}

type SettingsGetValueResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the key (encoded)
	EncodedValue string `protobuf:"bytes,1,opt,name=encoded_value,json=encodedValue,proto3" json:"encoded_value,omitempty"`
}

func (x *SettingsGetValueResponse) Reset() {
	*x = SettingsGetValueResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsGetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsGetValueResponse) ProtoMessage() {}

func (x *SettingsGetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsGetValueResponse.ProtoReflect.Descriptor instead.
func (*SettingsGetValueResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{8}
}

func (x *SettingsGetValueResponse) GetEncodedValue() string {
	if x != nil {
		return x.EncodedValue
	}
	return ""
}

type SettingsSetValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key to change
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The new value (encoded), no objects, only scalar or array of scalars are
	// allowed.
	EncodedValue string `protobuf:"bytes,2,opt,name=encoded_value,json=encodedValue,proto3" json:"encoded_value,omitempty"`
	// The format of the encoded_value (default is "json", allowed values are
	// "json", "yaml" and "cli")
	ValueFormat string `protobuf:"bytes,3,opt,name=value_format,json=valueFormat,proto3" json:"value_format,omitempty"`
}

func (x *SettingsSetValueRequest) Reset() {
	*x = SettingsSetValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsSetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsSetValueRequest) ProtoMessage() {}

func (x *SettingsSetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsSetValueRequest.ProtoReflect.Descriptor instead.
func (*SettingsSetValueRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{9}
}

func (x *SettingsSetValueRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SettingsSetValueRequest) GetEncodedValue() string {
	if x != nil {
		return x.EncodedValue
	}
	return ""
}

func (x *SettingsSetValueRequest) GetValueFormat() string {
	if x != nil {
		return x.ValueFormat
	}
	return ""
}

type SettingsSetValueResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SettingsSetValueResponse) Reset() {
	*x = SettingsSetValueResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsSetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsSetValueResponse) ProtoMessage() {}

func (x *SettingsSetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsSetValueResponse.ProtoReflect.Descriptor instead.
func (*SettingsSetValueResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{10}
}

type SettingsEnumerateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SettingsEnumerateRequest) Reset() {
	*x = SettingsEnumerateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsEnumerateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsEnumerateRequest) ProtoMessage() {}

func (x *SettingsEnumerateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsEnumerateRequest.ProtoReflect.Descriptor instead.
func (*SettingsEnumerateRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{11}
}

type SettingsEnumerateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of key/value pairs
	Entries []*SettingsEnumerateResponse_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *SettingsEnumerateResponse) Reset() {
	*x = SettingsEnumerateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsEnumerateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsEnumerateResponse) ProtoMessage() {}

func (x *SettingsEnumerateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsEnumerateResponse.ProtoReflect.Descriptor instead.
func (*SettingsEnumerateResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{12}
}

func (x *SettingsEnumerateResponse) GetEntries() []*SettingsEnumerateResponse_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type Configuration_Directories struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data directory
	Data string `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// User directory
	User string `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	// Downloads directory
	Downloads string `protobuf:"bytes,3,opt,name=downloads,proto3" json:"downloads,omitempty"`
	// The directory where the built-in resources are installed
	Builtin *Configuration_Directories_Builtin `protobuf:"bytes,4,opt,name=builtin,proto3,oneof" json:"builtin,omitempty"`
}

func (x *Configuration_Directories) Reset() {
	*x = Configuration_Directories{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Directories) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Directories) ProtoMessage() {}

func (x *Configuration_Directories) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Directories.ProtoReflect.Descriptor instead.
func (*Configuration_Directories) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Configuration_Directories) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *Configuration_Directories) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *Configuration_Directories) GetDownloads() string {
	if x != nil {
		return x.Downloads
	}
	return ""
}

func (x *Configuration_Directories) GetBuiltin() *Configuration_Directories_Builtin {
	if x != nil {
		return x.Builtin
	}
	return nil
}

type Configuration_Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Extra user-agent information to be appended in network requests
	ExtraUserAgent *string `protobuf:"bytes,1,opt,name=extra_user_agent,json=extraUserAgent,proto3,oneof" json:"extra_user_agent,omitempty"`
	// The proxy to use for network requests
	Proxy *string `protobuf:"bytes,2,opt,name=proxy,proto3,oneof" json:"proxy,omitempty"`
}

func (x *Configuration_Network) Reset() {
	*x = Configuration_Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Network) ProtoMessage() {}

func (x *Configuration_Network) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Network.ProtoReflect.Descriptor instead.
func (*Configuration_Network) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Configuration_Network) GetExtraUserAgent() string {
	if x != nil && x.ExtraUserAgent != nil {
		return *x.ExtraUserAgent
	}
	return ""
}

func (x *Configuration_Network) GetProxy() string {
	if x != nil && x.Proxy != nil {
		return *x.Proxy
	}
	return ""
}

type Configuration_Sketch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set to true to always export binaries to the sketch directory
	AlwaysExportBinaries bool `protobuf:"varint,1,opt,name=always_export_binaries,json=alwaysExportBinaries,proto3" json:"always_export_binaries,omitempty"`
}

func (x *Configuration_Sketch) Reset() {
	*x = Configuration_Sketch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Sketch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Sketch) ProtoMessage() {}

func (x *Configuration_Sketch) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Sketch.ProtoReflect.Descriptor instead.
func (*Configuration_Sketch) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Configuration_Sketch) GetAlwaysExportBinaries() bool {
	if x != nil {
		return x.AlwaysExportBinaries
	}
	return false
}

type Configuration_BuildCache struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of compilations before the cache is purged
	CompilationsBeforePurge uint64 `protobuf:"varint,1,opt,name=compilations_before_purge,json=compilationsBeforePurge,proto3" json:"compilations_before_purge,omitempty"`
	// Time to live of the cache in seconds
	TtlSecs uint64 `protobuf:"varint,2,opt,name=ttl_secs,json=ttlSecs,proto3" json:"ttl_secs,omitempty"`
}

func (x *Configuration_BuildCache) Reset() {
	*x = Configuration_BuildCache{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_BuildCache) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_BuildCache) ProtoMessage() {}

func (x *Configuration_BuildCache) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_BuildCache.ProtoReflect.Descriptor instead.
func (*Configuration_BuildCache) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Configuration_BuildCache) GetCompilationsBeforePurge() uint64 {
	if x != nil {
		return x.CompilationsBeforePurge
	}
	return 0
}

func (x *Configuration_BuildCache) GetTtlSecs() uint64 {
	if x != nil {
		return x.TtlSecs
	}
	return 0
}

type Configuration_BoardManager struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional URLs to be used for the board manager
	AdditionalUrls []string `protobuf:"bytes,1,rep,name=additional_urls,json=additionalUrls,proto3" json:"additional_urls,omitempty"`
}

func (x *Configuration_BoardManager) Reset() {
	*x = Configuration_BoardManager{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_BoardManager) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_BoardManager) ProtoMessage() {}

func (x *Configuration_BoardManager) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_BoardManager.ProtoReflect.Descriptor instead.
func (*Configuration_BoardManager) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Configuration_BoardManager) GetAdditionalUrls() []string {
	if x != nil {
		return x.AdditionalUrls
	}
	return nil
}

type Configuration_Daemon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TCP port of the daemon
	Port string `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *Configuration_Daemon) Reset() {
	*x = Configuration_Daemon{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Daemon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Daemon) ProtoMessage() {}

func (x *Configuration_Daemon) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Daemon.ProtoReflect.Descriptor instead.
func (*Configuration_Daemon) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Configuration_Daemon) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

type Configuration_Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set to true to disable coloring of the output
	NoColor bool `protobuf:"varint,1,opt,name=no_color,json=noColor,proto3" json:"no_color,omitempty"`
}

func (x *Configuration_Output) Reset() {
	*x = Configuration_Output{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Output) ProtoMessage() {}

func (x *Configuration_Output) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Output.ProtoReflect.Descriptor instead.
func (*Configuration_Output) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Configuration_Output) GetNoColor() bool {
	if x != nil {
		return x.NoColor
	}
	return false
}

type Configuration_Logging struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The logging level
	Level string `protobuf:"bytes,1,opt,name=level,proto3" json:"level,omitempty"`
	// The logging format
	Format string `protobuf:"bytes,2,opt,name=format,proto3" json:"format,omitempty"`
	// The logging file
	File *string `protobuf:"bytes,3,opt,name=file,proto3,oneof" json:"file,omitempty"`
}

func (x *Configuration_Logging) Reset() {
	*x = Configuration_Logging{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Logging) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Logging) ProtoMessage() {}

func (x *Configuration_Logging) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Logging.ProtoReflect.Descriptor instead.
func (*Configuration_Logging) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Configuration_Logging) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

func (x *Configuration_Logging) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *Configuration_Logging) GetFile() string {
	if x != nil && x.File != nil {
		return *x.File
	}
	return ""
}

type Configuration_Library struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set to true to enable library installation from zip archives or git
	// repositories
	EnableUnsafeInstall bool `protobuf:"varint,1,opt,name=enable_unsafe_install,json=enableUnsafeInstall,proto3" json:"enable_unsafe_install,omitempty"`
}

func (x *Configuration_Library) Reset() {
	*x = Configuration_Library{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Library) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Library) ProtoMessage() {}

func (x *Configuration_Library) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Library.ProtoReflect.Descriptor instead.
func (*Configuration_Library) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Configuration_Library) GetEnableUnsafeInstall() bool {
	if x != nil {
		return x.EnableUnsafeInstall
	}
	return false
}

type Configuration_Updater struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set to true to enable notifications for updates
	EnableNotification bool `protobuf:"varint,1,opt,name=enable_notification,json=enableNotification,proto3" json:"enable_notification,omitempty"`
}

func (x *Configuration_Updater) Reset() {
	*x = Configuration_Updater{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Updater) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Updater) ProtoMessage() {}

func (x *Configuration_Updater) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Updater.ProtoReflect.Descriptor instead.
func (*Configuration_Updater) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Configuration_Updater) GetEnableNotification() bool {
	if x != nil {
		return x.EnableNotification
	}
	return false
}

type Configuration_Directories_Builtin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directory where the built-in libraries are installed
	Libraries *string `protobuf:"bytes,1,opt,name=libraries,proto3,oneof" json:"libraries,omitempty"`
}

func (x *Configuration_Directories_Builtin) Reset() {
	*x = Configuration_Directories_Builtin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Configuration_Directories_Builtin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configuration_Directories_Builtin) ProtoMessage() {}

func (x *Configuration_Directories_Builtin) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configuration_Directories_Builtin.ProtoReflect.Descriptor instead.
func (*Configuration_Directories_Builtin) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Configuration_Directories_Builtin) GetLibraries() string {
	if x != nil && x.Libraries != nil {
		return *x.Libraries
	}
	return ""
}

type SettingsEnumerateResponse_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The key type
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *SettingsEnumerateResponse_Entry) Reset() {
	*x = SettingsEnumerateResponse_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingsEnumerateResponse_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingsEnumerateResponse_Entry) ProtoMessage() {}

func (x *SettingsEnumerateResponse_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingsEnumerateResponse_Entry.ProtoReflect.Descriptor instead.
func (*SettingsEnumerateResponse_Entry) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP(), []int{12, 0}
}

func (x *SettingsEnumerateResponse_Entry) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SettingsEnumerateResponse_Entry) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

var File_cc_arduino_cli_commands_v1_settings_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_settings_proto_rawDesc = []byte{
	0x0a, 0x29, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x22, 0xbd, 0x0d, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0b, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x4b, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x48, 0x0a, 0x06, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6b, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x06, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x12, 0x55, 0x0a, 0x0b, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x52, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x61, 0x63, 0x68, 0x65,
	0x12, 0x5b, 0x0a, 0x0d, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x52,
	0x0c, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0x48, 0x0a,
	0x06, 0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x52,
	0x06, 0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x12, 0x4b, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x4b,
	0x0a, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x4b, 0x0a, 0x07, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x52,
	0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x88, 0x01, 0x01, 0x1a, 0xf9, 0x01, 0x0a, 0x0b, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x0a,
	0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x5c, 0x0a, 0x07, 0x62,
	0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x62,
	0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x3a, 0x0a, 0x07, 0x42, 0x75, 0x69,
	0x6c, 0x74, 0x69, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69,
	0x6e, 0x1a, 0x72, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2d, 0x0a, 0x10,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x55,
	0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x1a, 0x3e, 0x0a, 0x06, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x12,
	0x34, 0x0a, 0x16, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x69, 0x6e,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x63, 0x0a, 0x0a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x75, 0x72, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x50, 0x75, 0x72, 0x67, 0x65, 0x12,
	0x19, 0x0a, 0x08, 0x74, 0x74, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x07, 0x74, 0x74, 0x6c, 0x53, 0x65, 0x63, 0x73, 0x1a, 0x37, 0x0a, 0x0c, 0x42, 0x6f,
	0x61, 0x72, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55,
	0x72, 0x6c, 0x73, 0x1a, 0x1c, 0x0a, 0x06, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x1a, 0x23, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x6e,
	0x6f, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e,
	0x6f, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x1a, 0x59, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x1a, 0x3d, 0x0a, 0x07, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x15,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x6e, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x55, 0x6e, 0x73, 0x61, 0x66, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x1a, 0x3a, 0x0a, 0x07, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x13, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x22, 0x19, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x6b, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x43, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x61, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x22, 0x46, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x61, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x6e, 0x0a, 0x18,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x37, 0x0a, 0x19,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x77, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x4e, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x3f, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x73, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x1a, 0x0a, 0x18, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x55, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x2d, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63,
	0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_settings_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_settings_proto_rawDescData = file_cc_arduino_cli_commands_v1_settings_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_settings_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_settings_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_settings_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_settings_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_cc_arduino_cli_commands_v1_settings_proto_goTypes = []any{
	(*Configuration)(nil),                     // 0: cc.arduino.cli.commands.v1.Configuration
	(*ConfigurationGetRequest)(nil),           // 1: cc.arduino.cli.commands.v1.ConfigurationGetRequest
	(*ConfigurationGetResponse)(nil),          // 2: cc.arduino.cli.commands.v1.ConfigurationGetResponse
	(*ConfigurationSaveRequest)(nil),          // 3: cc.arduino.cli.commands.v1.ConfigurationSaveRequest
	(*ConfigurationSaveResponse)(nil),         // 4: cc.arduino.cli.commands.v1.ConfigurationSaveResponse
	(*ConfigurationOpenRequest)(nil),          // 5: cc.arduino.cli.commands.v1.ConfigurationOpenRequest
	(*ConfigurationOpenResponse)(nil),         // 6: cc.arduino.cli.commands.v1.ConfigurationOpenResponse
	(*SettingsGetValueRequest)(nil),           // 7: cc.arduino.cli.commands.v1.SettingsGetValueRequest
	(*SettingsGetValueResponse)(nil),          // 8: cc.arduino.cli.commands.v1.SettingsGetValueResponse
	(*SettingsSetValueRequest)(nil),           // 9: cc.arduino.cli.commands.v1.SettingsSetValueRequest
	(*SettingsSetValueResponse)(nil),          // 10: cc.arduino.cli.commands.v1.SettingsSetValueResponse
	(*SettingsEnumerateRequest)(nil),          // 11: cc.arduino.cli.commands.v1.SettingsEnumerateRequest
	(*SettingsEnumerateResponse)(nil),         // 12: cc.arduino.cli.commands.v1.SettingsEnumerateResponse
	(*Configuration_Directories)(nil),         // 13: cc.arduino.cli.commands.v1.Configuration.Directories
	(*Configuration_Network)(nil),             // 14: cc.arduino.cli.commands.v1.Configuration.Network
	(*Configuration_Sketch)(nil),              // 15: cc.arduino.cli.commands.v1.Configuration.Sketch
	(*Configuration_BuildCache)(nil),          // 16: cc.arduino.cli.commands.v1.Configuration.BuildCache
	(*Configuration_BoardManager)(nil),        // 17: cc.arduino.cli.commands.v1.Configuration.BoardManager
	(*Configuration_Daemon)(nil),              // 18: cc.arduino.cli.commands.v1.Configuration.Daemon
	(*Configuration_Output)(nil),              // 19: cc.arduino.cli.commands.v1.Configuration.Output
	(*Configuration_Logging)(nil),             // 20: cc.arduino.cli.commands.v1.Configuration.Logging
	(*Configuration_Library)(nil),             // 21: cc.arduino.cli.commands.v1.Configuration.Library
	(*Configuration_Updater)(nil),             // 22: cc.arduino.cli.commands.v1.Configuration.Updater
	(*Configuration_Directories_Builtin)(nil), // 23: cc.arduino.cli.commands.v1.Configuration.Directories.Builtin
	(*SettingsEnumerateResponse_Entry)(nil),   // 24: cc.arduino.cli.commands.v1.SettingsEnumerateResponse.Entry
}
var file_cc_arduino_cli_commands_v1_settings_proto_depIdxs = []int32{
	13, // 0: cc.arduino.cli.commands.v1.Configuration.directories:type_name -> cc.arduino.cli.commands.v1.Configuration.Directories
	14, // 1: cc.arduino.cli.commands.v1.Configuration.network:type_name -> cc.arduino.cli.commands.v1.Configuration.Network
	15, // 2: cc.arduino.cli.commands.v1.Configuration.sketch:type_name -> cc.arduino.cli.commands.v1.Configuration.Sketch
	16, // 3: cc.arduino.cli.commands.v1.Configuration.build_cache:type_name -> cc.arduino.cli.commands.v1.Configuration.BuildCache
	17, // 4: cc.arduino.cli.commands.v1.Configuration.board_manager:type_name -> cc.arduino.cli.commands.v1.Configuration.BoardManager
	18, // 5: cc.arduino.cli.commands.v1.Configuration.daemon:type_name -> cc.arduino.cli.commands.v1.Configuration.Daemon
	19, // 6: cc.arduino.cli.commands.v1.Configuration.output:type_name -> cc.arduino.cli.commands.v1.Configuration.Output
	20, // 7: cc.arduino.cli.commands.v1.Configuration.logging:type_name -> cc.arduino.cli.commands.v1.Configuration.Logging
	21, // 8: cc.arduino.cli.commands.v1.Configuration.library:type_name -> cc.arduino.cli.commands.v1.Configuration.Library
	22, // 9: cc.arduino.cli.commands.v1.Configuration.updater:type_name -> cc.arduino.cli.commands.v1.Configuration.Updater
	0,  // 10: cc.arduino.cli.commands.v1.ConfigurationGetResponse.configuration:type_name -> cc.arduino.cli.commands.v1.Configuration
	24, // 11: cc.arduino.cli.commands.v1.SettingsEnumerateResponse.entries:type_name -> cc.arduino.cli.commands.v1.SettingsEnumerateResponse.Entry
	23, // 12: cc.arduino.cli.commands.v1.Configuration.Directories.builtin:type_name -> cc.arduino.cli.commands.v1.Configuration.Directories.Builtin
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_settings_proto_init() }
func file_cc_arduino_cli_commands_v1_settings_proto_init() {
	if File_cc_arduino_cli_commands_v1_settings_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationGetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationSaveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationSaveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationOpenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigurationOpenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsGetValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsGetValueResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsSetValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsSetValueResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsEnumerateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsEnumerateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Directories); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Sketch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_BuildCache); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_BoardManager); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Daemon); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Output); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Logging); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Library); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Updater); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*Configuration_Directories_Builtin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*SettingsEnumerateResponse_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[0].OneofWrappers = []any{}
	file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[13].OneofWrappers = []any{}
	file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[14].OneofWrappers = []any{}
	file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[20].OneofWrappers = []any{}
	file_cc_arduino_cli_commands_v1_settings_proto_msgTypes[23].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_settings_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_settings_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_settings_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_settings_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_settings_proto = out.File
	file_cc_arduino_cli_commands_v1_settings_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_settings_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_settings_proto_depIdxs = nil
}
