# References [![NYC OWASP Chapter 2022](https://img.shields.io/badge/owasp%202022-nyc%20chapter-blue)](https://www.youtube.com/watch?v=tGitZO8EkMI) [![InfoSec Campus SecTool Podcast](https://img.shields.io/badge/infosec%20campus-sectools%20podcast-red)](https://infoseccampus.com/podcast/sectools-e44-jeff-foley/) [![DEF CON 30 Recon Village](https://img.shields.io/badge/defcon%2030-recon%20village-lightgrey.svg)](https://twitter.com/jeff_foley/status/1562246069278445568/photo/1) [![ESW 2021](https://img.shields.io/badge/security%20weekly-esw%20219-blue.svg)](https://www.youtube.com/watch?v=fDlKQXRaGl0) [![BSides København 2020](https://img.shields.io/badge/bsides%202020-københavn-red.svg)](https://vimeo.com/481985359) [![BeNeLux 2020](https://img.shields.io/badge/owasp%202020-benelux%20days-blue.svg)](https://www.youtube.com/watch?v=fDlKQXRaGl0) [![Grayhat 2020](https://img.shields.io/badge/grayhat%202020-bootcamp-lightgrey.svg)](https://www.youtube.com/watch?v=J33JmuQ79tE) [![Bugcrowd LevelUp 0x07](https://img.shields.io/badge/bugcrowd-levelup%200x07-orange.svg)](https://www.twitch.tv/videos/723418873) [![DEF CON 28 Red Team Village](https://img.shields.io/badge/defcon%2028-red%20team%20village-red.svg)](https://www.youtube.com/c/RedTeamVillage/featured) [![DEF CON 27 Recon Village](https://img.shields.io/badge/defcon%2027-recon%20village-lightgrey.svg)](https://reconvillage.org/) [![DEF CON 27 Demo Labs](https://img.shields.io/badge/defcon%2027-demo%20labs-purple.svg)](https://www.defcon.org/html/defcon-27/dc-27-demolabs.html) [![Bugcrowd LevelUp 0x04](https://img.shields.io/badge/bugcrowd-levelup%200x04-orange.svg)](https://www.youtube.com/watch?v=C-GabM2db9A)

Did you write a blog post, magazine article or do a podcast about or mentioning OWASP Amass? Add it to this file and open a PR! The same goes for conference or meetup talks, workshops or trainings you did where this project was mentioned or used!

## Web Links

### Pod- & Webcasts
* [Paul's Security Weekly](https://securityweekly.com/):
  * Enterprise Security Weekly #219:
    [Attack Surface Management, Monitoring, & Mapping - Jeff Foley](https://www.youtube.com/watch?v=z4GT3xH-zo4)
  * Episode 564:
    [Technical Segment - Bug Bounty Hunting](https://securityweekly.com/shows/keith-hoodlet-bug-bounty-hunting-pauls-security-weekly-564/)
* [Hacking Simplified](https://www.youtube.com/channel/UCARsgS1stRbRgh99E63Q3ng):
  * [Amass Setup and Tutorial](https://www.youtube.com/watch?v=Pv4fGBZWyqY)
* [Josh Amishav-Zlatin's Channel](https://www.youtube.com/channel/UCajDbRGYBtgITfEbNUbWdsw):
  * [Advanced Passive Recon with the Amass Scripting Engine](https://www.youtube.com/watch?v=twVZLZxTAX4)
  * [Domain and Network Recon using Amass - Mapping the Attack Surface](https://www.youtube.com/watch?v=bsUeTyFoEtU)
* [Musab Khan's Channel](https://www.youtube.com/channel/UCX3LuFyGjuVTyfpte63L6KQ):
  * [OWASP Amass - In-depth Asset Discovery tool](https://www.youtube.com/watch?v=wxhW1fTjLNw)
* [Nahamsec's Streams](https://www.twitch.tv/nahamsec):
  * [04/26/2020 - Mayonaise Talks About His Recon Workflow, How to Learn Different Topics, and How to Bug Bounty!](https://www.youtube.com/watch?v=SGLdv_4Iy44)
  * [09/08/2019 - Live Bug Bounty Recon Session on Yahoo (censys, altdns, amass) w/ @infosec_au](https://www.youtube.com/watch?v=m-eZfbgdl9I)
  * [09/01/2019 - Live Bug Bounty Recon Session on Yahoo (Amass, crts.sh, dirsearch) w/ @TheDawgyg](https://www.youtube.com/watch?v=u4dUnJ1U0T4)
* [The Hackers Arsenal](https://www.youtube.com/channel/UC0z2vxoKkT4_VV5DHCEETgA):
  * [04/24/2020 - AMASS: Automated SubDomain Enumeration and Reconnaissance (Full walk-though)](https://www.youtube.com/watch?v=8PaVBe0cbIU)
* [Jason Haddix's Recon Streams](https://www.youtube.com/channel/UCk0f0svao7AKeK3RfiWxXEA/featured):
  * Stream #2:
    [ASNs, Xmind, Amass Intel, SSLscrape, ASNLookup ++](https://www.youtube.com/watch?v=5N7k0g7arYE)
  * Stream #4:
    [ASNLookup, Github Dorks, Amass, ffuf, Dirsearch, Turbo Intruder](https://www.youtube.com/watch?v=00xVyT0k-_E)
* [Ghostlulz's YouTube Channel](https://www.youtube.com/channel/UCqjjGl7VrAW_yLZK3DoMZXw):
  * [Bug Bounty Tips: Amass Recon Tool](https://www.youtube.com/watch?v=QRkKzYH4efI)
* [ToolWar's YouTube Channel](https://www.youtube.com/channel/UCCByzSfyNwrvJ5TX6cyJPlA):
  * [Extreme Subdomain Enumeration/Scanning on Windows : OWASP Amass](https://www.youtube.com/watch?v=mEQnVkSG19M)
* [Cyber Security & Information Systems - Information Analysis Center](https://www.csiac.org/series/csiac-webinar/):
  * [OWASP Amass: Discovering Your Exposure on the Internet](https://www.csiac.org/podcast/owasp-amass-discovering-your-exposure-on-the-internet/)
* [Hackdoor India's YouTube Channel](https://www.youtube.com/channel/UCKxHWvYXIfHRN_C2nUoGEjA):
  * [Amass Installation and Usage - Bug Bounty](https://www.youtube.com/watch?v=MNHJldgk3hQ)

### Blogs & Articles

* Blog post on [SecurityTrail's Blog](https://securitytrails.com/blog/):
  * [What is DNS Intelligence?](https://securitytrails.com/blog/dns-intelligence)
  * [What is OWASP? Top 10 Web Application Security Risks](https://securitytrails.com/blog/owasp-top-10)
  * [OWASP Amass: A Solid Information Gathering Tool](https://securitytrails.com/blog/owasp-amass)
  * [Top Linux Distros for Ethical Hacking and Penetration Testing](https://securitytrails.com/blog/top-linux-distributions-ethical-hacking-pentesting)
  * [5 Subdomain Takeover #ProTips](https://securitytrails.com/blog/subdomain-takeover-tips)
  * [Where You’ll Find Us: An Overview of SecurityTrails Integrations](https://securitytrails.com/blog/integrations-overview)
  * [Top 7 Subdomain Scanner Tools: Find Subdomains in Seconds](https://securitytrails.com/blog/subdomain-scanner-find-subdomains)
* Blog post on [WhoisXML API's Blog](https://www.whoisxmlapi.com/blog):
  * [OWASP Amass and WhoisXML API Are Now Integration Partners](https://main.whoisxmlapi.com/success-stories/cyber-security-solutions/owasp-amass-and-whoisxml-api-are-now-integration-partners)
* Blog post on [Intigriti's Blog](https://blog.intigriti.com):
  * [Hacker tools: Amass – Hunting for Subdomains](https://blog.intigriti.com/2021/06/08/hacker-tools-amass-hunting-for-subdomains)
* Article on [ThreadFix](threadfix.it):
  * [Applied ThreadFix: Seeding Your Application Portfolio with OWASP Amass](https://threadfix.it/resources/applied-threadfix-seeding-your-application-portfolio-with-owasp-amass/)
* Blog post on [Luke Stephens' (@hakluke)](https://medium.com/@hakluke):
  * [Hakluke’s Guide to Amass — How to Use Amass More Effectively for Bug Bounties](https://medium.com/@hakluke/haklukes-guide-to-amass-how-to-use-amass-more-effectively-for-bug-bounties-7c37570b83f7)
* Blog post on [WW Tech Blog](https://medium.com/ww-tech-blog):
  * [Reducing Our Attack Surface with AppSec Platform](https://medium.com/ww-tech-blog/reducing-our-attack-surface-with-appsec-platform-4b6717a16709)
* Blog post on [HackerOne's Blog](https://www.hackerone.com/blog):
  * [100 Hacking Tools and Resources](https://www.hackerone.com/blog/100-hacking-tools-and-resources)
* Blog post on [Synk's Blog](https://snyk.io/blog/):
  * [Mitigating clickJacking—the DevSecOps way!](https://snyk.io/blog/mitigating-clickjacking-the-devsecops-way/)
* Blog post on [Syed Abuthahir's Blog](https://medium.com/@syedabuthahir):
  * [How was I able to download customer data dump](https://medium.com/@syedabuthahir/how-was-i-able-to-download-customer-data-dump-9cd645146a3c)
* Blog post on [ncpd's Blog](https://medium.com/@_ncpd):
  * [Subdomain enumeration made easy](https://medium.com/@_ncpd/subdomain-enumeration-made-easy-ba843037ab76)
* Blog post on [Gökhan Güzelkokar's Blog](https://medium.com/@gguzelkokar.mdbf15):
  * [Bug bounty resources & advices](https://medium.com/@gguzelkokar.mdbf15/bug-bounty-resources-advices-2cc9cfb69f6)
* Blog post on [xploitprotocol's Blog](https://medium.com/@xploitprotocol):
  * [How to approach a target|bug bounty tips](https://medium.com/@xploitprotocol/how-to-approach-a-target-bug-bounty-tips-f371c7ec7985)
* Blog post on [TrustedSec's Blog](https://www.trustedsec.com/blog):
  * [Upgrade Your Workflow, Part 1: Building OSINT Checklists](https://www.trustedsec.com/blog/upgrade-your-workflow-part-1-building-osint-checklists/)
  by [Hans Lakhan](https://www.trustedsec.com/team/hans-lakhan/)
* Forum post on [SANS Internet Storm Center InfoSec Forums](https://isc.sans.edu/forums/):
  * [Offensive Tools Are For Blue Teams Too](https://isc.sans.edu/forums/diary/Offensive+Tools+Are+For+Blue+Teams+Too/25842/)
  by [Xavier Mertens](https://twitter.com/xme)
* Tutorial on [Dionach's Blog](https://www.dionach.com/blog/):
  * [How to Use OWASP Amass: An Extensive Tutorial](https://www.dionach.com/blog/how-to-use-owasp-amass-an-extensive-tutorial/)
  by Nick Gkogkos
* Blog post on [epi052's Blog](https://epi052.gitlab.io/notes-to-self/blog/):
  * [How to Build an Automated Recon Pipeline with Python and Luigi - Part IV (Subdomain Enumeration)](https://epi052.gitlab.io/notes-to-self/blog/2019-09-17-how-to-build-an-automated-recon-pipeline-with-python-and-luigi-part-four/)
* Blog post on [Aditya Soni's Blog](https://medium.com/@hetroublemakr):
  * [Bug Bounty with Bash](https://medium.com/cyberverse/bug-bounty-with-bash-438596ff72f5)
* Blog post on [Anshuman Pattnaik's Blog](https://medium.com/@hackbotone):
  * [10 Recon Tools For Bug Bounty](https://medium.com/@hackbotone/10-recon-tools-for-bug-bounty-bafa8a5961bd)
* Blog post on [Hahwul's Blog](https://www.hahwul.com):
  * [Find Subdomain Takeover with Amass + SubJack](https://www.hahwul.com/2019/10/find-subdomain-takeover-with-amass-and-subjack.html)
* Blog post on [Felipe Caon's Blog](https://medium.com/@caon):
  * [Recon done right](https://medium.com/@caon/recon-done-right-2210f5e426cb)
* Article on [Hacker Toolbelt](https://medium.com/hacker-toolbelt):
  * [OWASP Amass OSINT Reconnaissance](https://medium.com/hacker-toolbelt/owasp-amass-osint-reconnaissance-9b57d81fb958)
  by [Miguel Sampaio da Veiga](https://medium.com/@sampaio.veiga)
* Blog post on [Capt. Meelo's Blog](https://captmeelo.com):
  * [Asset Enumeration: Expanding a Target's Attack Surface](https://captmeelo.com/bugbounty/2019/09/02/asset-enumeration.html)
* Blog post on [FireEye's Threat Research Blog](https://www.fireeye.com/blog/threat-research.html):
  * [Commando VM 2.0: Customization, Containers, and Kali, Oh My!](https://www.fireeye.com/blog/threat-research/2019/08/commando-vm-customization-containers-kali.html)
  by [Jacob Barteaux](https://www.fireeye.com/blog/threat-research.html/category/etc/tags/fireeye-blog-authors/jacob-barteaux),
  [Blaine Stancill](https://www.fireeye.com/blog/threat-research.html/category/etc/tags/fireeye-blog-authors/blaine-stancill),
  [Nhan Huynh](https://www.fireeye.com/blog/threat-research.html/category/etc/tags/fireeye-blog-authors/nhan-huynh)
* Article on [Dark Reading Application Security](https://www.darkreading.com/application-security/):
  * [8 Free Tools to Be Showcased at Black Hat and DEF CON](https://www.darkreading.com/application-security/8-free-tools-to-be-showcased-at-black-hat-and-def-con/d/d-id/1335356?image_number=5)
  by [Ericka Checkowski](https://www.darkreading.com/author-bio.asp?author_id=962)
* Tutorial on [Daniel Miessler's Tutorials](https://danielmiessler.com/study/):
  * [amass — Automated Attack Surface Mapping](https://danielmiessler.com/study/amass/)
* Blog post on [Agent_Maximus' Blog](https://medium.com/@agent_maximus):
  * [Passive intelligence gathering techniques: uncover domains, subdomains & IP addresses](https://medium.com/@agent_maximus/passive-intelligence-gathering-techniques-uncover-domains-subdomains-ip-addresses-a40f51ee0eb0)
* Blog posts on [Patrik Hudak's Blog](https://0xpatrik.com):
  * [Subdomain Enumeration: 2019 Workflow](https://0xpatrik.com/subdomain-enumeration-2019/)
  * [Subdomain Takeover: Finding Candidates](https://0xpatrik.com/subdomain-takeover-candidates/)
  * [Asset Discovery: Doing Reconnaissance the Hard Way](https://0xpatrik.com/asset-discovery/)
  * [Project Sonar: An Underrated Source of Internet-wide Data](https://0xpatrik.com/project-sonar-guide/)
* Blog post on [vishnuraj's Blog](https://medium.com/@vishnu0002):
  * [REMOTE CODE EXECUTION ! 😜 Recon Wins](https://medium.com/@vishnu0002/remote-code-execution-recon-wins-e9c1db79f3da)
* Blog post on [Tutorgeeks' Blog](https://tutorgeeks.blogspot.com):
  * [Security assessment on staging domains](https://tutorgeeks.blogspot.com/2019/05/security-assessment-on-staging-domains.html)
* Blog post on [Habr's Digital Security Blog](https://habr.com/en/company/dsec/blog/):
  * [Web tools, or where to start a pentester?](https://habr.com/en/company/dsec/blog/452836/)
* Blog post on [Digital Shadow's Blog](https://www.digitalshadows.com/blog-and-research/):
  * [Cyber Talent Gap: How to Do More With Less](https://www.digitalshadows.com/blog-and-research/cyber-talent-gap-how-to-do-more-with-less/)
* Blog post on [Noobhax's Blog](https://medium.com/@noobhax):
  * [My Recon Process — DNS Enumeration](https://medium.com/@noobhax/my-recon-process-dns-enumeration-d0e288f81a8a)
* Article on [Week in OSINT](https://medium.com/week-in-osint):
  * [Week in OSINT #2019–16: From OSINT for pentesting, to OCR and OWASP](https://medium.com/week-in-osint/week-in-osint-2019-16-8ccfe0da1a70)
  * [Week in OSINT #2019–11: This time a collection of mostly tools and sites](https://medium.com/week-in-osint/week-in-osint-2019-11-62774ffe7a2)
* Blog post on [Alex Flor's Blog](https://sec.alexflor.es/posts/):
  * [Stop Using Python for Subdomain Enumeration](http://sec.alexflor.es/post/subdomain_enum/)
* Article on [0x00SEC](https://0x00sec.org):
  * [My Personal OSINT Techniques, Part 1 of 2: Key & Layer, Contingency Seeding](https://0x00sec.org/t/my-personal-osint-techniques-part-1-of-2-key-layer-contingency-seeding/)
  by [maderas](https://twitter.com/hackermaderas)
* Article on [Yeah Hub](https://www.yeahhub.com):
  * [Subdomain Enumeration Tools – 2019 Update](https://www.yeahhub.com/subdomain-enumeration-tools-2019-update/)
* Blog post on [Jonathan Bouman's Blog](https://medium.com/@jonathanbouman):
  * [Leaked Salesforce API access token at IDEA.com](https://medium.com/@jonathanbouman/leaked-salesforce-api-access-token-at-ikea-com-132eea3844e0)
* Blog post on [Drafting my Thoughts](https://foremandrafts.github.io/):
  * [Initial Reconaissance for Bug-Bounty](https://foremandrafts.github.io/posts/2019-3-30-hackerrecon)
* Blog post on [Shankar R's Blog](https://blog.usejournal.com/@trapp3rhat):
  * [Bug Hunting Methodology (part-1)](https://blog.usejournal.com/bug-hunting-methodology-part-1-91295b2d2066)
* Blog post on [bit3code's Blog](https://sylarsec.com/author/bit3code):
  * [100 ways to discover (part 1)](https://sylarsec.com/2019/01/11/100-ways-to-discover-part-1/)
* Blog post on [Appsecco's Blog](https://blog.appsecco.com):
  * [A penetration tester’s guide to subdomain enumeration](https://blog.appsecco.com/a-penetration-testers-guide-to-sub-domain-enumeration-7d842d5570f6)
* Blog post on [Frans Hendrik Botes' Blog](https://medium.com/@fbotes2):
  * [Abusing access control on a large online e-commerce site to register as supplier](https://medium.com/@fbotes2/governit-754becf85cbc)
* Article on [Pentester Land - Offensive InfoSec](https://pentester.land):
  * [Subdomains Enumeration Cheat Sheet](https://pentester.land/cheatsheets/2018/11/14/subdomains-enumeration-cheatsheet.html)
* Article on [miloserdov.org](https://miloserdov.org):
  * [Search subdomains and build graphs of network structure with Amass](https://miloserdov.org/?p=2309)
* Blog post on [Sahil Ahamad's Blog](https://medium.com/@ehsahil):
  * [Getting started in Bug Bounty](https://medium.com/@ehsahil/getting-started-in-bug-bounty-7052da28445a)
* Article on [H1RD](https://www.h1rd.com):
  * [Amass, the best application to search for subdomains](https://www.h1rd.com/hacking/amass-para-buscar-subdominios)
* Blog post on [Enciphers Blog](https://enciphers.com/blog/):
  * [Doing Recon the Correct Way](https://enciphers.com/doing-recon-the-correct-way/)
* Blog post on [Sjoerd Langkemper's - Web application security](https://www.sjoerdlangkemper.nl):
  * [Discovering subdomains](https://www.sjoerdlangkemper.nl/2018/06/20/discovering-subdomains/)
* Blog post on [Adam Toscher's Blog](https://medium.com/@adam.toscher):
  [Top Five Ways the Red Team breached the External Perimeter](https://medium.com/@adam.toscher/top-five-ways-the-red-team-breached-the-external-perimeter-262f99dc9d17)

## Lectures and Trainings

* [OWASP Amass Boot Camp Training](https://www.youtube.com/c/RedTeamVillage/featured)
  by Jeff Foley,
  [DEF CON 28 Red Team Village](https://redteamvillage.io/),
  07.08.2020
* [OWASP Portland Training Day](https://wiki.owasp.org/index.php/OWASP_Portland_2019_Training_Day):
  * [OWASP Amass: Discovering Your Exposure on the Internet](https://wiki.owasp.org/index.php/OWASP_Portland_2019_Training_Day)
* [Blackhat Trainings](https://www.blackhat.com/trainings/):
  * [Black Hat Training, Making the Cloud Rain Shells!: Discovery and Recon](https://www.blackhat.com/eu-18/training/schedule/index.html#aws--azure-exploitation-making-the-cloud-rain-shells-11060)

## Summits & Open Source Events

* [OWASP Amass Boot Camp](https://www.youtube.com/watch?v=J33JmuQ79tE&t=4s)
  by Jeff Foley,
  GrayHat 2020,
  30.10.2020
* [OWASP Amass Boot Camp](https://www.youtube.com/watch?v=OOurkCPf2-I&list=PLruly0ngXhPGvyl-gOp4d_TvIiedloX1l)
  by Jeff Foley,
  Cyber June'Gle Virtual Summit,
  28.06.2020
* Lightning Talk at [OWASP Sendai Day 2020](https://owaspsendai.connpass.com/event/162247/)
  by Akitsugu Ito,
  on [OWASP Amass](https://speakerdeck.com/springmoon6/lt-owasp-amass),
  08.02.2020

## Conference and Meetup Appearances

### 2020

* [Organizational Asset Discovery & Recon with OWASP Amass](https://vimeo.com/481985359)
  by Nick Gkogkos,
  BSides København 2020,
  19.09.2020
* [How to Use Amass Efficiently](https://www.youtube.com/watch?v=H1wdBgY1rtg)
  by Jeff Foley,
  NahamCom 2020,
  14.06.2020
* [The Bug Hunter's Methodology v4.0 - Recon Edition](https://www.youtube.com/watch?v=p4JgIu1mceI)
  by Jason Haddix,
  NahamCom 2020,
  14.06.2020
  ([Slides](https://drive.google.com/file/d/1aG_qqRvNW-s5_8vvPk5rJiMSMeNL2uY9/view))

### 2019

* [Red Team Methodology - A Naked Look](http://www.irongeek.com/i.php?page=videos/derbycon9/2-12-red-team-methodology-a-naked-look-jason-lang),
  by Jason Lang,
  [DerbyCon 2019](https://twitter.com/derbycon),
  07.09.2019
  [YouTube](https://www.youtube.com/watch?v=kf829-tm0VM)
  [Slides](https://www.slideshare.net/JasonLang1/red-team-methodology-a-naked-look-169879355)
* [OWASP Amass](https://www.defcon.org/html/defcon-27/dc-27-demolabs.html#OWASP%20Amass)
  by Jeff Foley and Anthony Rhodes,
  [DEF CON 27 Demo Labs](https://www.defcon.org/html/defcon-27/dc-27-demolabs.html)
  09.08.2019
* [Advanced Recon with OWASP Amass](https://www.youtube.com/watch?v=ES6OKjgW36w)
  by Jeff Foley and Anthony Rhodes,
  [DEF CON 27 Recon Village](https://reconvillage.org/),
  09.08.2019
* [Asset Discovery Making Sense of the Ocean of OSINT](https://www.youtube.com/watch?v=Srbl8AvN5Wo)
  by Richard Gold,
  [DEF CON 27 Recon Village](https://reconvillage.org/),
  09.08.2019
* [Let's get technical and hunt harder!](https://www.youtube.com/watch?v=zj50_lMV-pI)
  by Bugcrowd Discussion Panel,
  [DEF CON 27 Recon Village](https://reconvillage.org/),
  09.08.2019
* [OWASP Amass - Discovering Internet Exposure](https://www.bugcrowd.com/resources/webinars/owasp-amass-discovering-internet-exposure/)
  by Jeff Foley and Anthony Rhodes,
  [Bugcrowd LevelUp 0x04](https://www.bugcrowd.com/blog/recapping_levelup_0x04/),
  11.06.2019
* [OWASP Amass Beyond Subdomain Enumeration](https://www.youtube.com/watch?v=ngOmkZ3U2e4)
  by Jeff Foley and Anthony Rhodes,
  [BSidesROC 2019](https://bsidesroc.com/assets/archive/2019/),
  23.03.2019
* [Pose a Threat: How Perceptual Analysis Helps Bug Hunters](https://appseccalifornia2019.sched.com/event/GS3q/pose-a-threat-how-perceptual-analysis-helps-bug-hunters)
  by Rob Ragan and Oscar Salazar,
  [AppSec California 2019](https://2019.appseccalifornia.org/),
  24.01.2019
  [YouTube](https://www.youtube.com/watch?v=Gwv29depW9o)
  [Slides](https://drive.google.com/file/d/1n-MWffLlnnWXeC1650gzM11VnR4k_iR4/view)

### 2018

* [Project Showcase: Amass](https://www.youtube.com/watch?v=HaVEH1vFiN0)
  by Jeff Foley,
  [OWASP AppSec USA 2018](https://2018.appsecusa.org/),
  12.10.2018
* [The OWASP Amass Project: DNS Enumeration written in Go](https://www.youtube.com/watch?v=8cOCaPwbr60),
  by Jeff Foley,
  [OWASP London Chapter](https://owasp.org/www-chapter-london/),
  29.09.2018
* [The Bug Hunter's Methodology v3](https://www.youtube.com/watch?v=Qw1nNPiH_Go)
  by Jason Haddix,
  Bugcrowd LevelUp 0x02,
  28.05.2018
  ([Slides](https://docs.google.com/presentation/d/1R-3eqlt31sL7_rj2f1_vGEqqb7hcx4vxX_L7E23lJVo/))
