// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestExtractExtraOptions(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.ExtraOptionsOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.ExtraOptions(map[string]interface{}{}),
		},
		{
			opts:     []interface{}{opt.ExtraOptions(map[string]interface{}{})},
			expected: opt.ExtraOptions(map[string]interface{}{}),
		},
		{
			opts:     []interface{}{opt.ExtraOptions(map[string]interface{}{"k1": 1, "k2": []string{"2", "3"}})},
			expected: opt.ExtraOptions(map[string]interface{}{"k1": 1.0, "k2": []interface{}{"2", "3"}}),
		},
	} {
		var (
			in  = ExtractExtraOptions(c.opts...)
			out opt.ExtraOptionsOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
