# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.7.5"
  license "MIT"

  on_macos do
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.5/actionlint_1.7.5_darwin_amd64.tar.gz"
      sha256 "6b765da53b4c0f9b8f63dbdcdc12d800a8fec36b21336940e166eae329a210dc"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.5/actionlint_1.7.5_darwin_arm64.tar.gz"
      sha256 "397119f9baa3fd9fe195db340b30acdaea532826e19a047a9cc9d96add7c267d"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.intel?
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.5/actionlint_1.7.5_linux_amd64.tar.gz"
        sha256 "3e6e0a832dfa0b5f027e6b8956aad2632d69b7cb778b1cff847b40279950a856"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    if Hardware::CPU.arm?
      if !Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.5/actionlint_1.7.5_linux_armv6.tar.gz"
        sha256 "6d803c1e5b0d4ec36169f090be73596f8dfb370e76aec205917641b9699e254d"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    if Hardware::CPU.arm?
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.5/actionlint_1.7.5_linux_arm64.tar.gz"
        sha256 "cb992426d176cf5c2f9cd0ecd36722eace064282dde7125f2b6813f2a299ab36"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
