# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.7.4"
  license "MIT"

  on_macos do
    on_intel do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.4/actionlint_1.7.4_darwin_amd64.tar.gz"
      sha256 "63a3ba90ee2325afad3ff2e64a4d80688c261e6c68be8e6ab91214637bf936b8"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    on_arm do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.4/actionlint_1.7.4_darwin_arm64.tar.gz"
      sha256 "cbd193bb490f598d77e179261d7b76dfebd049dddede5803ba21cbf6a469aeee"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    on_intel do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.4/actionlint_1.7.4_linux_amd64.tar.gz"
        sha256 "fc0a6886bbb9a23a39eeec4b176193cadb54ddbe77cdbb19b637933919545395"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if !Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.4/actionlint_1.7.4_linux_armv6.tar.gz"
        sha256 "05ab9ea3ff51ca0617323fd3480abf757a0f440683a7c3e2d997634d0d141c9b"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.4/actionlint_1.7.4_linux_arm64.tar.gz"
        sha256 "ede03682dc955381d057dde95bb85ce9ca418122209a8a313b617d4adec56416"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
