# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.16"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.16/actionlint_1.6.16_darwin_arm64.tar.gz"
      sha256 "0b7f5faaf4e8255192777520689c2bf6c1b9d4ea43ab1a90b82220cb55168460"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.16/actionlint_1.6.16_darwin_amd64.tar.gz"
      sha256 "7397670a6f05c446809b2f3e117a45f7e5e185cb66816037f8c009aa040a28c7"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.16/actionlint_1.6.16_linux_armv6.tar.gz"
      sha256 "b04c4d21667baf15cbba5575924e346098bb44d1c78862a3ba32a7d5d294c189"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.16/actionlint_1.6.16_linux_arm64.tar.gz"
      sha256 "e05b464e8f113d051054a7183fb904238efc3af6862a844db1cbdba7ca4f0461"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.16/actionlint_1.6.16_linux_amd64.tar.gz"
      sha256 "7713e891f77e072bec99ef76c7908cbfd8d833d96c7438b1c38772b99bc37faf"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
