# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.10"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.10/actionlint_1.6.10_darwin_arm64.tar.gz"
      sha256 "cd304bb7d77daef223c40aa54196c76cfb4f1d26befbf626fd73c5cb8a343fdd"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.10/actionlint_1.6.10_darwin_amd64.tar.gz"
      sha256 "a571dd6fe4351fa5262943f6c4a431be10bf48ab33236baa352fdd1df40a414a"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.10/actionlint_1.6.10_linux_arm64.tar.gz"
      sha256 "5b0fdabc942a7976999560346841ff2ef2d8e99a6ddae8bbbc09f7ac5b0249b3"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.10/actionlint_1.6.10_linux_armv6.tar.gz"
      sha256 "a9ea6b1d088514976d23a84dfa24c35bfd1a6b6b3de7df42bd1483ffb60eb5d2"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.10/actionlint_1.6.10_linux_amd64.tar.gz"
      sha256 "b653303ea708e5c53056bd67541dab781a62200e9338f5568cc7b66851d6e56a"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
