# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.9"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.9/actionlint_1.6.9_darwin_arm64.tar.gz"
      sha256 "a1a11548f80311525a39618f181a0274218d2f75da39f5df6bd0cba1fd246035"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.9/actionlint_1.6.9_darwin_amd64.tar.gz"
      sha256 "f182fa117254fce18bd165e031a9452692fd3c216c5743cb18153f452c6b2b69"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.9/actionlint_1.6.9_linux_arm64.tar.gz"
      sha256 "d034948422bdbbce95285a0a0b37344a2361ad62bf45f9ceba236a6fbcddbebf"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.9/actionlint_1.6.9_linux_armv6.tar.gz"
      sha256 "e601b3ee076cc1a97e54d339493fc86fedf6cec594e578ab2339a30d1d89c3bd"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.9/actionlint_1.6.9_linux_amd64.tar.gz"
      sha256 "ff1ff2ca3f331886e5d9b08e5128d927e7fa46a8c0bf71f544fa03d1e43a33ac"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
