package v1

type AppImage struct {
	// ID is the "image ID" that Name resolves to, which might be the same as Name or a string matching
	// ImageInstance.Name
	ID string `json:"id,omitempty"`
	// Name is the image name requested by the user of any format
	Name         string           `json:"name,omitempty"`
	Digest       string           `json:"digest,omitempty"`
	Acornfile    string           `json:"acornfile,omitempty"`
	ImageData    ImagesData       `json:"imageData,omitempty"`
	BuildArgs    *GenericMap      `json:"buildArgs,omitempty"`
	BuildContext BuildContext     `json:"buildContext,omitempty"`
	Profiles     []string         `json:"profiles,omitempty"`
	VCS          VCS              `json:"vcs,omitempty"`
	Version      *AppImageVersion `json:"version,omitempty"`
}

type BuildContext struct {
	Cwd           string `json:"cwd,omitempty"`
	AcornfilePath string `json:"acornfilePath,omitempty"`
}

type AppImageVersion struct {
	RuntimeVersion  string `json:"runtimeVersion,omitempty"`
	AcornfileSchema string `json:"acornfileSchema,omitempty"`
}

type VCS struct {
	Remotes  []string `json:"remotes,omitempty"`
	Revision string   `json:"revision,omitempty"`
	// Clean a true value indicates the build contained no modified or untracked files according to git
	Clean bool `json:"clean,omitempty"`
	// Modified a true value indicates the build contained modified files according to git
	Modified bool `json:"modified,omitempty"`
	// Untracked a true value indicates the build contained untracked files according to git
	Untracked bool `json:"untracked,omitempty"`
	// Acornfile the path and filename within the vcs repository that was used to build the running app
	Acornfile string `json:"acornfile,omitempty"`
	// BuildContext the context within the vcs repository that was used when building the running app
	BuildContext string `json:"buildContext,omitempty"`
}

type Platform struct {
	Architecture string   `json:"architecture"`
	OS           string   `json:"os"`
	OSVersion    string   `json:"os.version,omitempty"`
	OSFeatures   []string `json:"os.features,omitempty"`
	Variant      string   `json:"variant,omitempty"`
}
