// +build !noasm
// Generated by PeachPy 0.2.0 from aez_amd64.py


// func cpuidAMD64(cpuidParams *uint32)
TEXT ·cpuidAMD64(SB),4,$0-8
	MOVQ cpuidParams+0(FP), R15
	MOVL 0(R15), AX
	MOVL 8(R15), CX
	CPUID
	MOVL AX, 0(R15)
	MOVL BX, 4(R15)
	MOVL CX, 8(R15)
	MOVL DX, 12(R15)
	RET

// func resetAMD64SSE2()
TEXT ·resetAMD64SSE2(SB),4,$0
	PXOR X0, X0
	PXOR X1, X1
	PXOR X2, X2
	PXOR X3, X3
	PXOR X4, X4
	PXOR X5, X5
	PXOR X6, X6
	PXOR X7, X7
	PXOR X8, X8
	PXOR X9, X9
	PXOR X10, X10
	PXOR X10, X11
	PXOR X12, X12
	PXOR X13, X13
	PXOR X14, X14
	PXOR X15, X15
	RET

// func xorBytes1x16AMD64SSE2(a *uint8, b *uint8, dst *uint8)
TEXT ·xorBytes1x16AMD64SSE2(SB),4,$0-24
	MOVQ a+0(FP), AX
	MOVQ b+8(FP), BX
	MOVQ dst+16(FP), CX
	MOVOU 0(AX), X0
	MOVOU 0(BX), X1
	PXOR X1, X0
	MOVOU X0, 0(CX)
	RET

// func xorBytes4x16AMD64SSE2(a *uint8, b *uint8, c *uint8, d *uint8, dst *uint8)
TEXT ·xorBytes4x16AMD64SSE2(SB),4,$0-40
	MOVQ a+0(FP), AX
	MOVQ b+8(FP), BX
	MOVQ c+16(FP), CX
	MOVQ d+24(FP), DX
	MOVQ dst+32(FP), DI
	MOVOU 0(AX), X0
	MOVOU 0(BX), X1
	MOVOU 0(CX), X2
	MOVOU 0(DX), X3
	PXOR X1, X0
	PXOR X3, X2
	PXOR X2, X0
	MOVOU X0, 0(DI)
	RET

// func aezAES4AMD64AESNI(j *uint8, i *uint8, l *uint8, k *uint8, src *uint8, dst *uint8)
TEXT ·aezAES4AMD64AESNI(SB),4,$0-48
	MOVQ j+0(FP), AX
	MOVQ i+8(FP), BX
	MOVQ l+16(FP), CX
	MOVQ k+24(FP), DX
	MOVQ src+32(FP), DI
	MOVQ dst+40(FP), SI
	MOVOU 0(DI), X0
	MOVO 0(AX), X1
	MOVO 0(BX), X2
	MOVO 0(CX), X3
	PXOR X1, X0
	PXOR X3, X2
	PXOR X2, X0
	PXOR X4, X4
	MOVO 0(DX), X2
	MOVO 16(DX), X1
	MOVO 32(DX), X3
	AESENC X1, X0
	AESENC X2, X0
	AESENC X3, X0
	AESENC X4, X0
	MOVOU X0, 0(SI)
	RET

// func aezAES10AMD64AESNI(l *uint8, k *uint8, src *uint8, dst *uint8)
TEXT ·aezAES10AMD64AESNI(SB),4,$0-32
	MOVQ l+0(FP), AX
	MOVQ k+8(FP), BX
	MOVQ src+16(FP), CX
	MOVQ dst+24(FP), DX
	MOVOU 0(CX), X0
	MOVOU 0(AX), X1
	PXOR X1, X0
	MOVO 0(BX), X2
	MOVO 16(BX), X3
	MOVO 32(BX), X1
	AESENC X2, X0
	AESENC X3, X0
	AESENC X1, X0
	AESENC X2, X0
	AESENC X3, X0
	AESENC X1, X0
	AESENC X2, X0
	AESENC X3, X0
	AESENC X1, X0
	AESENC X2, X0
	MOVOU X0, 0(DX)
	RET

// func aezCorePass1AMD64AESNI(src *uint8, dst *uint8, x *uint8, i *uint8, l *uint8, k *uint8, consts *uint8, sz *uint)
TEXT ·aezCorePass1AMD64AESNI(SB),4,$0-64
	MOVQ src+0(FP), AX
	MOVQ dst+8(FP), BX
	MOVQ x+16(FP), CX
	MOVQ l+32(FP), DX
	MOVQ sz+56(FP), DI
	MOVQ $1, SI
	MOVOU 0(CX), X0
	MOVQ i+24(FP), BP
	MOVOU 0(BP), X1
	MOVQ k+40(FP), BP
	MOVOU 0(BP), X2
	MOVOU 16(BP), X3
	MOVOU 32(BP), X4
	MOVQ consts+48(FP), BP
	PXOR X5, X5
	SUBQ $256, DI
	JCS vector_loop256_end
vector_loop256_begin:
		MOVOU 16(AX), X6
		MOVOU 48(AX), X7
		MOVOU 80(AX), X8
		MOVOU 112(AX), X9
		MOVOU 144(AX), X10
		MOVOU 176(AX), X11
		MOVOU 208(AX), X12
		MOVOU 240(AX), X13
		MOVO X3, X14
		PXOR X1, X14
		PXOR X14, X6
		PXOR X14, X7
		PXOR X14, X8
		PXOR X14, X9
		PXOR X14, X10
		PXOR X14, X11
		PXOR X14, X12
		PXOR X14, X13
		PXOR 16(DX), X6
		PXOR 32(DX), X7
		PXOR 48(DX), X8
		PXOR 64(DX), X9
		PXOR 80(DX), X10
		PXOR 96(DX), X11
		PXOR 112(DX), X12
		PXOR 0(DX), X13
		AESENC X3, X6
		AESENC X3, X7
		AESENC X3, X8
		AESENC X3, X9
		AESENC X3, X10
		AESENC X3, X11
		AESENC X3, X12
		AESENC X3, X13
		AESENC X2, X6
		AESENC X2, X7
		AESENC X2, X8
		AESENC X2, X9
		AESENC X2, X10
		AESENC X2, X11
		AESENC X2, X12
		AESENC X2, X13
		AESENC X4, X6
		AESENC X4, X7
		AESENC X4, X8
		AESENC X4, X9
		AESENC X4, X10
		AESENC X4, X11
		AESENC X4, X12
		AESENC X4, X13
		AESENC X5, X6
		AESENC X5, X7
		AESENC X5, X8
		AESENC X5, X9
		AESENC X5, X10
		AESENC X5, X11
		AESENC X5, X12
		AESENC X5, X13
		MOVOU 0(AX), X14
		MOVOU 32(AX), X15
		PXOR X14, X6
		PXOR X15, X7
		MOVOU 64(AX), X14
		MOVOU 96(AX), X15
		PXOR X14, X8
		PXOR X15, X9
		MOVOU 128(AX), X14
		MOVOU 160(AX), X15
		PXOR X14, X10
		PXOR X15, X11
		MOVOU 192(AX), X14
		MOVOU 224(AX), X15
		PXOR X14, X12
		PXOR X15, X13
		MOVOU X6, 0(BX)
		MOVOU X7, 32(BX)
		MOVOU X8, 64(BX)
		MOVOU X9, 96(BX)
		MOVOU X10, 128(BX)
		MOVOU X11, 160(BX)
		MOVOU X12, 192(BX)
		MOVOU X13, 224(BX)
		PXOR X2, X6
		PXOR X2, X7
		PXOR X2, X8
		PXOR X2, X9
		PXOR X2, X10
		PXOR X2, X11
		PXOR X2, X12
		PXOR X2, X13
		AESENC X3, X6
		AESENC X3, X7
		AESENC X3, X8
		AESENC X3, X9
		AESENC X3, X10
		AESENC X3, X11
		AESENC X3, X12
		AESENC X3, X13
		AESENC X2, X6
		AESENC X2, X7
		AESENC X2, X8
		AESENC X2, X9
		AESENC X2, X10
		AESENC X2, X11
		AESENC X2, X12
		AESENC X2, X13
		AESENC X4, X6
		AESENC X4, X7
		AESENC X4, X8
		AESENC X4, X9
		AESENC X4, X10
		AESENC X4, X11
		AESENC X4, X12
		AESENC X4, X13
		AESENC X5, X6
		AESENC X5, X7
		AESENC X5, X8
		AESENC X5, X9
		AESENC X5, X10
		AESENC X5, X11
		AESENC X5, X12
		AESENC X5, X13
		MOVOU 16(AX), X14
		MOVOU 48(AX), X15
		PXOR X14, X6
		PXOR X15, X7
		MOVOU 80(AX), X14
		MOVOU 112(AX), X15
		PXOR X14, X8
		PXOR X15, X9
		MOVOU 144(AX), X14
		MOVOU 176(AX), X15
		PXOR X14, X10
		PXOR X15, X11
		MOVOU 208(AX), X14
		MOVOU 240(AX), X15
		PXOR X14, X12
		PXOR X15, X13
		MOVOU X6, 16(BX)
		MOVOU X7, 48(BX)
		MOVOU X8, 80(BX)
		MOVOU X9, 112(BX)
		MOVOU X10, 144(BX)
		MOVOU X11, 176(BX)
		MOVOU X12, 208(BX)
		MOVOU X13, 240(BX)
		PXOR X6, X0
		PXOR X7, X0
		PXOR X8, X0
		PXOR X9, X0
		PXOR X10, X0
		PXOR X11, X0
		PXOR X12, X0
		PXOR X13, X0
		MOVO 0(BP), X14
		PSHUFB X14, X1
		MOVO X1, X15
		PSRAL $31, X15
		PAND 16(BP), X15
		PSHUFL $147, X15, X15
		PSLLL $1, X1
		PXOR X15, X1
		PSHUFB X14, X1
		ADDQ $256, AX
		ADDQ $256, BX
		SUBQ $256, DI
		JCC vector_loop256_begin
vector_loop256_end:
	ADDQ $256, DI
	SUBQ $128, DI
	JCS process_64bytes
	MOVOU 16(AX), X10
	MOVOU 48(AX), X11
	MOVOU 80(AX), X12
	MOVOU 112(AX), X13
	MOVO X10, X6
	MOVO X11, X7
	MOVOU X12, X8
	MOVOU X13, X9
	MOVO X3, X14
	PXOR X1, X14
	PXOR X14, X6
	PXOR X14, X7
	PXOR X14, X8
	PXOR X14, X9
	PXOR 16(DX), X6
	PXOR 32(DX), X7
	PXOR 48(DX), X8
	PXOR 64(DX), X9
	AESENC X3, X6
	AESENC X3, X7
	AESENC X3, X8
	AESENC X3, X9
	AESENC X2, X6
	AESENC X2, X7
	AESENC X2, X8
	AESENC X2, X9
	AESENC X4, X6
	AESENC X4, X7
	AESENC X4, X8
	AESENC X4, X9
	AESENC X5, X6
	AESENC X5, X7
	AESENC X5, X8
	AESENC X5, X9
	MOVOU 0(AX), X14
	MOVOU 32(AX), X15
	PXOR X14, X6
	PXOR X15, X7
	MOVOU 64(AX), X14
	MOVOU 96(AX), X15
	PXOR X14, X8
	PXOR X15, X9
	MOVOU X6, 0(BX)
	MOVOU X7, 32(BX)
	MOVOU X8, 64(BX)
	MOVOU X9, 96(BX)
	PXOR X2, X6
	PXOR X2, X7
	PXOR X2, X8
	PXOR X2, X9
	AESENC X3, X6
	AESENC X3, X7
	AESENC X3, X8
	AESENC X3, X9
	AESENC X2, X6
	AESENC X2, X7
	AESENC X2, X8
	AESENC X2, X9
	AESENC X4, X6
	AESENC X4, X7
	AESENC X4, X8
	AESENC X4, X9
	AESENC X5, X6
	AESENC X5, X7
	AESENC X5, X8
	AESENC X5, X9
	PXOR X10, X6
	PXOR X11, X7
	PXOR X12, X8
	PXOR X13, X9
	MOVOU X6, 16(BX)
	MOVOU X7, 48(BX)
	MOVOU X8, 80(BX)
	MOVOU X9, 112(BX)
	PXOR X6, X0
	PXOR X7, X0
	PXOR X8, X0
	PXOR X9, X0
	ADDQ $128, AX
	ADDQ $128, BX
	ADDQ $4, SI
	SUBQ $128, DI
process_64bytes:
	ADDQ $128, DI
	SUBQ $64, DI
	JCS process_32bytes
	MOVQ SI, BP
	SHLQ $4, BP
	ADDQ DX, BP
	MOVOU 16(AX), X10
	MOVOU 48(AX), X11
	MOVO X10, X6
	MOVO X11, X7
	PXOR X3, X6
	PXOR X3, X7
	PXOR X1, X6
	PXOR X1, X7
	PXOR 0(BP), X6
	PXOR 16(BP), X7
	AESENC X3, X6
	AESENC X3, X7
	AESENC X2, X6
	AESENC X2, X7
	AESENC X4, X6
	AESENC X4, X7
	AESENC X5, X6
	AESENC X5, X7
	MOVOU 0(AX), X14
	MOVOU 32(AX), X15
	PXOR X14, X6
	PXOR X15, X7
	MOVOU X6, 0(BX)
	MOVOU X7, 32(BX)
	PXOR X2, X6
	PXOR X2, X7
	AESENC X3, X6
	AESENC X3, X7
	AESENC X2, X6
	AESENC X2, X7
	AESENC X4, X6
	AESENC X4, X7
	AESENC X5, X6
	AESENC X5, X7
	PXOR X10, X6
	PXOR X11, X7
	MOVOU X6, 16(BX)
	MOVOU X7, 48(BX)
	PXOR X6, X0
	PXOR X7, X0
	ADDQ $64, AX
	ADDQ $64, BX
	ADDQ $2, SI
	SUBQ $64, DI
process_32bytes:
	ADDQ $64, DI
	SUBQ $32, DI
	JCS out
	ANDQ $7, SI
	SHLQ $4, SI
	ADDQ SI, DX
	MOVOU 16(AX), X10
	MOVO X10, X6
	PXOR X3, X6
	PXOR X1, X6
	PXOR 0(DX), X6
	AESENC X3, X6
	AESENC X2, X6
	AESENC X4, X6
	AESENC X5, X6
	MOVOU 0(AX), X14
	PXOR X14, X6
	MOVOU X6, 0(BX)
	PXOR X2, X6
	AESENC X3, X6
	AESENC X2, X6
	AESENC X4, X6
	AESENC X5, X6
	PXOR X10, X6
	MOVOU X6, 16(BX)
	PXOR X6, X0
out:
	MOVOU X0, 0(CX)
	RET

// func aezCorePass2AMD64AESNI(dst *uint8, y *uint8, s *uint8, j *uint8, i *uint8, l *uint8, k *uint8, consts *uint8, sz *uint)
TEXT ·aezCorePass2AMD64AESNI(SB),4,$0-72
	MOVQ dst+0(FP), AX
	MOVQ y+8(FP), BX
	MOVQ j+24(FP), CX
	MOVQ l+40(FP), DX
	MOVQ sz+64(FP), DI
	MOVQ $1, SI
	MOVQ k+48(FP), BP
	MOVOU 0(BP), X0
	MOVOU 16(BP), X1
	MOVOU 32(BP), X2
	MOVOU 0(BX), X3
	MOVQ i+32(FP), BP
	MOVOU 0(BP), X4
	MOVQ consts+56(FP), BP
	PXOR X5, X5
	MOVQ s+16(FP), R8
	MOVOU 0(R8), X6
	PXOR 16(CX), X6
	MOVQ SP, R9
	ANDQ $18446744073709551584, SP
	SUBQ $256, SP
	SUBQ $256, DI
	JCS vector_loop256_end
vector_loop256_begin:
		MOVO X6, X7
		PXOR X4, X7
		MOVO X7, X8
		MOVO X7, X9
		MOVO X7, X10
		MOVO X7, X11
		MOVO X7, X12
		MOVO X7, X13
		MOVO X7, X14
		PXOR 16(DX), X7
		PXOR 32(DX), X8
		PXOR 48(DX), X9
		PXOR 64(DX), X10
		PXOR 80(DX), X11
		PXOR 96(DX), X12
		PXOR 112(DX), X13
		PXOR 0(DX), X14
		AESENC X1, X7
		AESENC X1, X8
		AESENC X1, X9
		AESENC X1, X10
		AESENC X1, X11
		AESENC X1, X12
		AESENC X1, X13
		AESENC X1, X14
		AESENC X0, X7
		AESENC X0, X8
		AESENC X0, X9
		AESENC X0, X10
		AESENC X0, X11
		AESENC X0, X12
		AESENC X0, X13
		AESENC X0, X14
		AESENC X2, X7
		AESENC X2, X8
		AESENC X2, X9
		AESENC X2, X10
		AESENC X2, X11
		AESENC X2, X12
		AESENC X2, X13
		AESENC X2, X14
		AESENC X5, X7
		AESENC X5, X8
		AESENC X5, X9
		AESENC X5, X10
		AESENC X5, X11
		AESENC X5, X12
		AESENC X5, X13
		AESENC X5, X14
		MOVOU 0(AX), X15
		MOVOU 32(AX), X6
		PXOR X7, X15
		PXOR X8, X6
		PXOR X15, X3
		PXOR X6, X3
		MOVO X15, 0(SP)
		MOVO X6, 32(SP)
		MOVOU 64(AX), X15
		MOVOU 96(AX), X6
		PXOR X9, X15
		PXOR X10, X6
		PXOR X15, X3
		PXOR X6, X3
		MOVO X15, 64(SP)
		MOVO X6, 96(SP)
		MOVOU 128(AX), X15
		MOVOU 160(AX), X6
		PXOR X11, X15
		PXOR X12, X6
		PXOR X15, X3
		PXOR X6, X3
		MOVO X15, 128(SP)
		MOVO X6, 160(SP)
		MOVOU 192(AX), X15
		MOVOU 224(AX), X6
		PXOR X13, X15
		PXOR X14, X6
		PXOR X15, X3
		PXOR X6, X3
		MOVO X15, 192(SP)
		MOVO X6, 224(SP)
		MOVOU 16(AX), X15
		MOVOU 48(AX), X6
		PXOR X15, X7
		PXOR X6, X8
		MOVO X7, 16(SP)
		MOVO X8, 48(SP)
		MOVOU 80(AX), X15
		MOVOU 112(AX), X6
		PXOR X15, X9
		PXOR X6, X10
		MOVO X9, 80(SP)
		MOVO X10, 112(SP)
		MOVOU 144(AX), X15
		MOVOU 176(AX), X6
		PXOR X15, X11
		PXOR X6, X12
		MOVO X11, 144(SP)
		MOVO X12, 176(SP)
		MOVOU 208(AX), X15
		MOVOU 240(AX), X6
		PXOR X15, X13
		PXOR X6, X14
		MOVO X13, 208(SP)
		MOVO X14, 240(SP)
		PXOR X0, X7
		PXOR X0, X8
		PXOR X0, X9
		PXOR X0, X10
		PXOR X0, X11
		PXOR X0, X12
		PXOR X0, X13
		PXOR X0, X14
		AESENC X1, X7
		AESENC X1, X8
		AESENC X1, X9
		AESENC X1, X10
		AESENC X1, X11
		AESENC X1, X12
		AESENC X1, X13
		AESENC X1, X14
		AESENC X0, X7
		AESENC X0, X8
		AESENC X0, X9
		AESENC X0, X10
		AESENC X0, X11
		AESENC X0, X12
		AESENC X0, X13
		AESENC X0, X14
		AESENC X2, X7
		AESENC X2, X8
		AESENC X2, X9
		AESENC X2, X10
		AESENC X2, X11
		AESENC X2, X12
		AESENC X2, X13
		AESENC X2, X14
		AESENC X5, X7
		AESENC X5, X8
		AESENC X5, X9
		AESENC X5, X10
		AESENC X5, X11
		AESENC X5, X12
		AESENC X5, X13
		AESENC X5, X14
		PXOR 0(SP), X7
		PXOR 32(SP), X8
		PXOR 64(SP), X9
		PXOR 96(SP), X10
		PXOR 128(SP), X11
		PXOR 160(SP), X12
		PXOR 192(SP), X13
		PXOR 224(SP), X14
		MOVOU X7, 16(AX)
		MOVOU X8, 48(AX)
		MOVOU X9, 80(AX)
		MOVOU X10, 112(AX)
		MOVOU X11, 144(AX)
		MOVOU X12, 176(AX)
		MOVOU X13, 208(AX)
		MOVOU X14, 240(AX)
		MOVO 0(CX), X15
		PXOR X4, X15
		PXOR X15, X7
		PXOR X15, X8
		PXOR X15, X9
		PXOR X15, X10
		PXOR X15, X11
		PXOR X15, X12
		PXOR X15, X13
		PXOR X15, X14
		PXOR 16(DX), X7
		PXOR 32(DX), X8
		PXOR 48(DX), X9
		PXOR 64(DX), X10
		PXOR 80(DX), X11
		PXOR 96(DX), X12
		PXOR 112(DX), X13
		PXOR 0(DX), X14
		AESENC X1, X7
		AESENC X1, X8
		AESENC X1, X9
		AESENC X1, X10
		AESENC X1, X11
		AESENC X1, X12
		AESENC X1, X13
		AESENC X1, X14
		AESENC X0, X7
		AESENC X0, X8
		AESENC X0, X9
		AESENC X0, X10
		AESENC X0, X11
		AESENC X0, X12
		AESENC X0, X13
		AESENC X0, X14
		AESENC X2, X7
		AESENC X2, X8
		AESENC X2, X9
		AESENC X2, X10
		AESENC X2, X11
		AESENC X2, X12
		AESENC X2, X13
		AESENC X2, X14
		AESENC X5, X7
		AESENC X5, X8
		AESENC X5, X9
		AESENC X5, X10
		AESENC X5, X11
		AESENC X5, X12
		AESENC X5, X13
		AESENC X5, X14
		PXOR 16(SP), X7
		PXOR 48(SP), X8
		PXOR 80(SP), X9
		PXOR 112(SP), X10
		PXOR 144(SP), X11
		PXOR 176(SP), X12
		PXOR 208(SP), X13
		PXOR 240(SP), X14
		MOVOU X7, 0(AX)
		MOVOU X8, 32(AX)
		MOVOU X9, 64(AX)
		MOVOU X10, 96(AX)
		MOVOU X11, 128(AX)
		MOVOU X12, 160(AX)
		MOVOU X13, 192(AX)
		MOVOU X14, 224(AX)
		MOVO 0(BP), X15
		PSHUFB X15, X4
		MOVO X4, X6
		PSRAL $31, X6
		PAND 16(BP), X6
		PSHUFL $147, X6, X6
		PSLLL $1, X4
		PXOR X6, X4
		PSHUFB X15, X4
		MOVOU 0(R8), X6
		PXOR 16(CX), X6
		ADDQ $256, AX
		SUBQ $256, DI
		JCC vector_loop256_begin
		MOVO X5, 16(SP)
		MOVO X5, 48(SP)
		MOVO X5, 80(SP)
		MOVO X5, 112(SP)
		MOVO X5, 128(SP)
		MOVO X5, 144(SP)
		MOVO X5, 160(SP)
		MOVO X5, 176(SP)
		MOVO X5, 192(SP)
		MOVO X5, 208(SP)
		MOVO X5, 224(SP)
		MOVO X5, 240(SP)
vector_loop256_end:
	ADDQ $256, DI
	SUBQ $128, DI
	JCS process_64bytes
	MOVO X6, X7
	PXOR X4, X7
	MOVO X7, X8
	MOVO X7, X9
	MOVO X7, X10
	PXOR 16(DX), X7
	PXOR 32(DX), X8
	PXOR 48(DX), X9
	PXOR 64(DX), X10
	AESENC X1, X7
	AESENC X1, X8
	AESENC X1, X9
	AESENC X1, X10
	AESENC X0, X7
	AESENC X0, X8
	AESENC X0, X9
	AESENC X0, X10
	AESENC X2, X7
	AESENC X2, X8
	AESENC X2, X9
	AESENC X2, X10
	AESENC X5, X7
	AESENC X5, X8
	AESENC X5, X9
	AESENC X5, X10
	MOVOU 0(AX), X11
	MOVOU 32(AX), X13
	MOVOU 64(AX), X12
	MOVOU 96(AX), X14
	PXOR X7, X11
	PXOR X8, X13
	PXOR X9, X12
	PXOR X10, X14
	PXOR X11, X3
	PXOR X13, X3
	PXOR X12, X3
	PXOR X14, X3
	MOVO X11, 0(SP)
	MOVO X13, 32(SP)
	MOVO X12, 64(SP)
	MOVO X14, 96(SP)
	MOVOU 16(AX), X12
	MOVOU 48(AX), X14
	MOVOU 80(AX), X11
	MOVOU 112(AX), X13
	PXOR X12, X7
	PXOR X14, X8
	PXOR X11, X9
	PXOR X13, X10
	MOVOU X7, 16(AX)
	MOVOU X8, 48(AX)
	MOVOU X9, 80(AX)
	MOVOU X10, 112(AX)
	MOVO X7, X12
	MOVO X8, X14
	MOVO X9, X11
	MOVO X10, X13
	PXOR X0, X7
	PXOR X0, X8
	PXOR X0, X9
	PXOR X0, X10
	AESENC X1, X7
	AESENC X1, X8
	AESENC X1, X9
	AESENC X1, X10
	AESENC X0, X7
	AESENC X0, X8
	AESENC X0, X9
	AESENC X0, X10
	AESENC X2, X7
	AESENC X2, X8
	AESENC X2, X9
	AESENC X2, X10
	AESENC X5, X7
	AESENC X5, X8
	AESENC X5, X9
	AESENC X5, X10
	PXOR 0(SP), X7
	PXOR 32(SP), X8
	PXOR 64(SP), X9
	PXOR 96(SP), X10
	MOVOU X7, 16(AX)
	MOVOU X8, 48(AX)
	MOVOU X9, 80(AX)
	MOVOU X10, 112(AX)
	PXOR 0(CX), X7
	PXOR 0(CX), X8
	PXOR 0(CX), X9
	PXOR 0(CX), X10
	PXOR X4, X7
	PXOR X4, X8
	PXOR X4, X9
	PXOR X4, X10
	PXOR 16(DX), X7
	PXOR 32(DX), X8
	PXOR 48(DX), X9
	PXOR 64(DX), X10
	AESENC X1, X7
	AESENC X1, X8
	AESENC X1, X9
	AESENC X1, X10
	AESENC X0, X7
	AESENC X0, X8
	AESENC X0, X9
	AESENC X0, X10
	AESENC X2, X7
	AESENC X2, X8
	AESENC X2, X9
	AESENC X2, X10
	AESENC X5, X7
	AESENC X5, X8
	AESENC X5, X9
	AESENC X5, X10
	PXOR X12, X7
	PXOR X14, X8
	PXOR X11, X9
	PXOR X13, X10
	MOVOU X7, 0(AX)
	MOVOU X8, 32(AX)
	MOVOU X9, 64(AX)
	MOVOU X10, 96(AX)
	ADDQ $128, AX
	ADDQ $4, SI
	SUBQ $128, DI
process_64bytes:
	ADDQ $128, DI
	SUBQ $64, DI
	JCS process_32bytes
	MOVQ SI, BP
	SHLQ $4, BP
	ADDQ DX, BP
	MOVO X6, X7
	PXOR X4, X7
	MOVO X7, X8
	PXOR 0(BP), X7
	PXOR 16(BP), X8
	AESENC X1, X7
	AESENC X1, X8
	AESENC X0, X7
	AESENC X0, X8
	AESENC X2, X7
	AESENC X2, X8
	AESENC X5, X7
	AESENC X5, X8
	MOVOU 0(AX), X11
	MOVOU 16(AX), X12
	MOVOU 32(AX), X13
	MOVOU 48(AX), X14
	PXOR X7, X11
	PXOR X8, X13
	PXOR X11, X3
	PXOR X13, X3
	PXOR X12, X7
	PXOR X14, X8
	MOVO X7, X12
	MOVO X8, X14
	PXOR X0, X7
	PXOR X0, X8
	AESENC X1, X7
	AESENC X1, X8
	AESENC X0, X7
	AESENC X0, X8
	AESENC X2, X7
	AESENC X2, X8
	AESENC X5, X7
	AESENC X5, X8
	PXOR X11, X7
	PXOR X13, X8
	MOVO X7, X11
	MOVO X8, X13
	PXOR 0(CX), X7
	PXOR 0(CX), X8
	PXOR X4, X7
	PXOR X4, X8
	PXOR 0(BP), X7
	PXOR 16(BP), X8
	AESENC X1, X7
	AESENC X1, X8
	AESENC X0, X7
	AESENC X0, X8
	AESENC X2, X7
	AESENC X2, X8
	AESENC X5, X7
	AESENC X5, X8
	PXOR X7, X12
	PXOR X8, X14
	MOVOU X12, 0(AX)
	MOVOU X11, 16(AX)
	MOVOU X14, 32(AX)
	MOVOU X13, 48(AX)
	ADDQ $64, AX
	ADDQ $2, SI
	SUBQ $64, DI
process_32bytes:
	ADDQ $64, DI
	SUBQ $32, DI
	JCS out
	ANDQ $7, SI
	SHLQ $4, SI
	ADDQ SI, DX
	MOVO X6, X7
	PXOR X4, X7
	PXOR 0(DX), X7
	AESENC X1, X7
	AESENC X0, X7
	AESENC X2, X7
	AESENC X5, X7
	MOVOU 0(AX), X11
	MOVOU 16(AX), X12
	PXOR X7, X11
	PXOR X11, X3
	PXOR X12, X7
	MOVO X7, X12
	PXOR X0, X7
	AESENC X1, X7
	AESENC X0, X7
	AESENC X2, X7
	AESENC X5, X7
	PXOR X11, X7
	MOVO X7, X11
	PXOR 0(CX), X7
	PXOR X4, X7
	PXOR 0(DX), X7
	AESENC X1, X7
	AESENC X0, X7
	AESENC X2, X7
	AESENC X5, X7
	PXOR X7, X12
	MOVOU X12, 0(AX)
	MOVOU X11, 16(AX)
out:
	MOVOU X3, 0(BX)
	MOVO X5, 0(SP)
	MOVO X5, 32(SP)
	MOVO X5, 64(SP)
	MOVO X5, 96(SP)
	MOVQ R9, SP
	RET
