package lea

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_LEA256_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases256, false) }
func Test_LEA256_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases256, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// LEA256(ECB)KAT.txt
var testCases256 = []BlockTestCase{
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `BA91D622BAF683D7BFCF1785FBE32A44`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `1188E33909A1B2E7126B2BF946407A4F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `73C499FDA4E73451C3780B055A476944`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `2E87166FC6AA9A5072618F76F1461844`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `7F2020641A5F54240092CC609788236F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `EEA64EEB642DC676C4BD391153A60F83`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `868FCD6C143F17907E3D89FD7C389CB6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `DC8D3C465B3698D9AA08C17292B6CFF0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `02CDC6DE003E03668349858612C386F8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `8B170ABCB312D65611A7D72DFB9B4813`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `4657633536B5554E352C829C63525E73`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `F567D59CAE48267DEDF38F4DF83611C0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `8FFF6798E342F60CD4D1F4978EC7D9C4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `1A936F1E13239B458A7DCCF46A081508`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `FF6462E0601FF0F7792DEA9F34C82100`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `ACC6720A70116B5F69FEBE7E7A04F5F9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `DE4EEFE33E83E05D9CBE8288B72528FA`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `4C8E9A2AA03C0846CEB0642B89E61F9D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `F053AD468C8873A2128912FF6B270D66`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `92C380636779C3CCB2D4127359CBD5EB`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `B02BC028F85ABB5258134CEB4BA61B92`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `7E2000FA22DD9E66DA3A09BC176F0482`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `D1F16B01AC483DFF6C583AA4689644B3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `67E3572DB7B2582321AA23011945F0D4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `B7C3A0CC6C0CBCB7113D2237DFF64F38`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `CC9A874674F123F989D3A823B075B51E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `D8E1AB02935F48FDB59837D4ED49316E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `A786AE37038B22710D0763254065E2AC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `BEE1B4472B6E05612DD7F1070518F6DD`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `EB5C23495816B86BC78469A742289DD7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `2297A4498623CE3E79D33DBF20E65B15`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `EACB1E8C4880D3C8BC17A8D317239BD8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `48E62454573C50D9B2905D9B1FD87477`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `9D7918126DF4EEAFBCC93F763DADE978`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `CC5D7757C2C9C5B66A763704EC37B3D7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `7FA21697A52DB4FED827E72838C33EA2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `9F1168F5397A211DFA11694992B2B62A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `CB091EE826CBCC194D4135ACFD704843`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `99404EE45109887275992FE7001B833E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `91F5AB02DA55D8CA36779CD7D4F39192`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `3C79F9A7DE84896CB7B57DE36A86394C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `017CEF127C2469AFA284056A0E596BCE`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `5CAF60DA31930745E529BB27A83F4918`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `2E972F0639427C2BDADC4DDFC17FFEC7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `1BEF2A4E128EBAC356CFECB7A54B5CD5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `4B46FA94D90D3CD64B65D9F88BA897FF`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `598F4C38D26E85F52B7E917B32EDE630`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `7E37FE60F6EEBFFB8D305A4FA31483CB`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `E1EF89DFD7E16716B2A5FEF8EE4BDCA9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `4BAAB55C5C1F1456AC68ACD63BFAA9B9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `08ABFB144243ED65338A47F70F1ED613`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `42D3EACCAB18BDEF07D74BC6272A57BA`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `D2FDC67C4051F804FA266E3077194CE5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `D1AB321C569512597E71CB44D6C9EF7E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `C51757971F4644DA71C417D78AA89F21`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `B2E01B370FC16A7277A37ABEF663146F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `EB6D742DF5097C284D15083FAAFFD04C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `B15D971C90BB5F1C0AEAB700F8A1CC93`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `EB79E675108CB84B4EBECE366F747B83`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `65E2D2D722FB2C3B2948AC5CB50D667E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `29941C8C2AF551C89E86FF264D6B509E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `A364D30659B39AD01CF89FDDA1D8FFF0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `3D95B065E5ACF3856A8A892F4EB68D3B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `99A5FE08C04C2DB694AB30C3AF73F24E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `68CFD4B779331014ECD1E9FAE8426AB3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `8AD9D29B6515113E3844EB1D35249DD5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `1B5B9DAE8C1C2BEC4ADFC8741F74BA85`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `306C4001CC6A45E395C7CD5990E64CB6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `E72A11FF0B267228718701597E6F7006`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `199B3A7679E8E6F65F766C348DA634D9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `7F73D44A2199919DF9151CA1E64DA50D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `F669D5524DDEE9893CF79590389B9108`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `0FD11973414F71023A6AE02CC9A13FC1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `DB65769AEF6CDE2CF337ED4394F8A3C1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `83E13D14F819DB930EDC81ECEC573A85`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `3D76B53CAC7BB9B9306384A05AA18DC5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `B9414171010BEE41738367E0B7138636`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `75D959A6069578ABF3913C515064474D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `CF44AFA34162F794483F9E73DAA88FCB`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `3416D6D98EDA20C16246CB0E78C6D7B4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `3A14CAE92FC0C667107173686E93AD9F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `249166C657A59D7A452ED8ABCB1D4DC5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `AC806390D3C7C686272EA2914B39A0ED`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `41645154B73B405B802B37213209E738`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `927B5B86236AC10917FCF6D0B63C60CC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `5F4D0852B5C9B5025BB9117F1879DCF2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `0162D5A9FBE8C672809A98EC59AB0EBC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `4C52A1FE5D772A9659C136A89DD1F13A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `E4B26A5C57FC3C1866C826B54A1DD12A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `89A3B88CAD5B754D2D3F2961D5FD41C5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `DEA8B3E42BED1DEBE8BBACE0C279E893`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `5615B2C30D8FFCB71A58C91EEFCBE3E3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `32AFA76C48389FBE66B84E8E97EED55A`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `69EC159015E34ACE0FA8923F9B448FBF`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `C0019B676805509AACC2249675736FE3`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `272FD1AFC5C7A245E75DDB0DE2823D98`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `0162F86FCB8C295618AB9075A9C00C81`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `EFA8F38FD2333023F8EF8C0C952443D1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `104BD34553F814EDF97E3BA53A29B0F0`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `FE4B76A7955C7B20C7E330C5D3F61D81`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `B7ED80065BA75647753393F58B79043F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `A8C49C60A0E36FD71ECFD8371ADE1C05`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `41CE06D79CA89CA84AEFB9240257B866`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `20CA6F22E865D86C8F02464934337AEC`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `010D0A8ECE06E7B6B7BE009EC636BC11`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `AB4FA5365D75AA6C1D841007E217A356`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `1890ED875FBD84C4F88AACED252DC64C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `DAAAEAA5527716EC72F4CF1762FF5DC9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `328F102DAC99AA4E56F4B623512CDF6F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `82C73B8C2665E338D08912C39EC5CB69`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `564432423F7BA37EF629888E1BFBAC09`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `1897B99FD4E3D5F7C1CBD6B6AF0395C2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `BC56513F12A319CD3BDC8D343F869C8D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `39391205B3BA58E528DE928597C71339`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `C04D693C7FD2BC3E168EEF771498B839`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `8E6FFA251A50CCBAE3CD6A68D90E314E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `546CDEB9DC6197E4D0C36825E10EA54D`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `93D0356D6A99EA745D6F87A303645C08`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `276037392F08316C8161CDA1726A424C`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `E44DB3945FE34AAABE33EF2CA5994769`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `CB1F19682B569CF399840219D8030FE1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `FC9868EDEC129AD0DEDB85A8EDFCA10E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `0D45AEE9F1D799A2E17480A20EE2D7BD`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `0D2961638629AC60FABA9310BF982CC7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `85AC42527A1E8E24E65160DCA1832CA9`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `B9DBDFAB2CC3F3C8C6B8ED666B3687D1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `271ABFE8C9ACC3C1E0434B905A2900A5`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `B1E765F6262FE1FB5615B91A7322EABB`,
	},
	{
		Key:    `8000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4F6156C0C35F9DDFD2A1774814EA76A2`,
	},
	{
		Key:    `C000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D84D646949066DC7373981C75F76432F`,
	},
	{
		Key:    `E000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B2A01A3C22BC7DA4C6D512F72CC4D667`,
	},
	{
		Key:    `F000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `65615453112852D192175BB6F90E30CB`,
	},
	{
		Key:    `F800000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5B636762E5AA34DA8D0FDAA02A55B6A1`,
	},
	{
		Key:    `FC00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `248D296E14638E6C6650D0FE2886D6FF`,
	},
	{
		Key:    `FE00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `52F429916C39D4782186620B7ADE0B10`,
	},
	{
		Key:    `FF00000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8D40911D94097ACF5F703440C0A8801D`,
	},
	{
		Key:    `FF80000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `74D979E82BEF808C17D7241BACEAECBD`,
	},
	{
		Key:    `FFC0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E6E3446A502EB07EED446F369019D0F9`,
	},
	{
		Key:    `FFE0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7F8B24086750B8AB17D09143B0D88E04`,
	},
	{
		Key:    `FFF0000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E7D2EBC4D5CF3B29E3E8B6DD428BD114`,
	},
	{
		Key:    `FFF8000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9C5F838D7F731762FF09011CFC79652C`,
	},
	{
		Key:    `FFFC000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4FE49AD0DCD7052D3434F5A95FA25DE9`,
	},
	{
		Key:    `FFFE000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9782E400792CF09158064A5C61E4F65F`,
	},
	{
		Key:    `FFFF000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E5985D75DA6BCF3BE429DC90A527EC2C`,
	},
	{
		Key:    `FFFF800000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F9C1C2EDF76B0D1846D8B55F0BB0CC92`,
	},
	{
		Key:    `FFFFC00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FDC902D86C40BDF49B476BFA85229C1A`,
	},
	{
		Key:    `FFFFE00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4DEBDE4E56331B3103E8B5493A725094`,
	},
	{
		Key:    `FFFFF00000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E4B35956A36B5BF2FF27CC415AF49450`,
	},
	{
		Key:    `FFFFF80000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8CC388C74BA0298F1D3D2483EE4B7AC3`,
	},
	{
		Key:    `FFFFFC0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E7F2A11EFD17ED5ED2EAAC9F722D5C39`,
	},
	{
		Key:    `FFFFFE0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CBC1B52ECDB2EE4C683EC7B9A57354E1`,
	},
	{
		Key:    `FFFFFF0000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DF0839DADB2C1D47826743E8F0E949A5`,
	},
	{
		Key:    `FFFFFF8000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5BE21C051F899BFD534FEEC42D9DFDEB`,
	},
	{
		Key:    `FFFFFFC000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9DE664074529B180FC2F2C89E875BB52`,
	},
	{
		Key:    `FFFFFFE000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E52DBB7E42A3F15B45FB0B2014D11E40`,
	},
	{
		Key:    `FFFFFFF000000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C27D6D0E771A3FC91551CB03D2E82883`,
	},
	{
		Key:    `FFFFFFF800000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BC280171A1FF41458576FDD3152C458C`,
	},
	{
		Key:    `FFFFFFFC00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `401D9DC736681BB495222BFA8901D718`,
	},
	{
		Key:    `FFFFFFFE00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D0B85882472FD8BEEA0C7AFD19C2C55C`,
	},
	{
		Key:    `FFFFFFFF00000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B1789CEE9C088317289BFBA662F29513`,
	},
	{
		Key:    `FFFFFFFF80000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9689E9D4152B4CF54F74454A612354BA`,
	},
	{
		Key:    `FFFFFFFFC0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `47656B3594317973255E5251CECF013E`,
	},
	{
		Key:    `FFFFFFFFE0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `177B3F86D675A401A463DEA03BC581A1`,
	},
	{
		Key:    `FFFFFFFFF0000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4FCB4112D728D77BC0901A0228A4CF9A`,
	},
	{
		Key:    `FFFFFFFFF8000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD1D31F5969F6F85F9D592FC5606EE88`,
	},
	{
		Key:    `FFFFFFFFFC000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0B4D50619A0F3949C3260320EEBDAB3`,
	},
	{
		Key:    `FFFFFFFFFE000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9F2AEE0B0FE882FE561D70336623A2C7`,
	},
	{
		Key:    `FFFFFFFFFF000000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0D52223A8300E52C200D4198FBBEE8A6`,
	},
	{
		Key:    `FFFFFFFFFF800000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `545FED5D42058BE770DF96F4FBF060CF`,
	},
	{
		Key:    `FFFFFFFFFFC00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5D69D89B61D39BF38BEE756D6C81D800`,
	},
	{
		Key:    `FFFFFFFFFFE00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FBCA4546E5841F16F78A27B705852504`,
	},
	{
		Key:    `FFFFFFFFFFF00000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `598A5A2F5D921852EB2E475F24F91553`,
	},
	{
		Key:    `FFFFFFFFFFF80000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8FAF7419939F8B0525FC0CFDB83BAB2D`,
	},
	{
		Key:    `FFFFFFFFFFFC0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3B9409CD165AEF26B2C27E146081CE78`,
	},
	{
		Key:    `FFFFFFFFFFFE0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `37B1FA6B91AA71891293D156DDB369EC`,
	},
	{
		Key:    `FFFFFFFFFFFF0000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E48B1AAE44B2D5989E2610908CE30B4C`,
	},
	{
		Key:    `FFFFFFFFFFFF8000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0E602102D7CF681698BD34412243B2F5`,
	},
	{
		Key:    `FFFFFFFFFFFFC000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1C3F1E1BCF062B136F47C44016BA5870`,
	},
	{
		Key:    `FFFFFFFFFFFFE000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B65E1CC0D1A04C0E8658BFF07EB6E01`,
	},
	{
		Key:    `FFFFFFFFFFFFF000000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `547F85A8CE4F710264BD5B7842BB8FDD`,
	},
	{
		Key:    `FFFFFFFFFFFFF800000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0BD692342D1CF78840D74F1CB18222C2`,
	},
	{
		Key:    `FFFFFFFFFFFFFC00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E592C5C8BFF1CF13DD26179EDBEF702`,
	},
	{
		Key:    `FFFFFFFFFFFFFE00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BC85FBDC1B3498EB35D5F70675CA5104`,
	},
	{
		Key:    `FFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `852494F17FE6006AAF50394011B8350C`,
	},
	{
		Key:    `FFFFFFFFFFFFFF80000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5958F59B978B27DFA6BC54243391262F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D6E6C0D8487C89710BC94417ABF3D8D2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF1864BB18F7B1B277F0566CB4664628`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12D1B848B363ED043FDCE4499C10BACE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF8000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0C5FF86A034FFD76891196C4CD0B3950`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `72FE9737308570DB6A700C6214AAF461`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `385CE44BAF2DE8D02967B575DA9DE3F2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C808B5300EE251383156E600D1D3C79D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF800000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5963CA33B2A5FFF08AB587A21AE23816`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4ED028E70E9B853A25C2A1A6DBC855EB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF081CFC536350E76C9EB866BA4DA577`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C6F74062E25FB7C88D15C0A17F80F360`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4C64C5520131D6F0B14061E9222FE429`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `136B9F36B39D6949CBDA4ABDCBF6CE93`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `57D284BC736C8AEA5391197FA499B50D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2857B1D03635A70BF54B3E8CF008E8F9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3CC35D8BDBCE2C87750C1AAE7E22B0A4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `518311DB824933E7BC5DFEAE75916B3E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `126AF2488E4B794813BEF0BB3D2084CD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `528847F9C3762CD08EA0011863A59C1D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `88678A37C4348786EEAE5CFB2BC77FA0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6B14DFDDB29516BAC5074140045BC238`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0A69CAF0BB94B2285E443BAD93A15921`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6E547FBF5FEBF8A3408C670BCA635375`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `13B0D33F4FB91403E922EFA5C0B27FA2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DAFE39DA81A71B5D004250538BC31905`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `47A7236D545EECF9928511B99BA8C0FE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `40E39AB300243D8BF228342A19E5D225`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `91C51F571927E15762DE6BFAB48EA6E4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `191BA2750AD47890D81B6D62B49C8DBC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D1AFF03B8BC302C876429705A986A3AD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8AD539E4B08261F8D26B4AC187142D62`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1CC9BAC5EE162962F36D96DF042D48F5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0C5D09CEDC5FD0D249234C9D13DE63D3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F282189437F9634DAE698D18D175C6BD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `673A6567C6CB4365F53B040FB62AE1CB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B114985301A10FA288813F812FFB1CF8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `14EEF7DB97BD1E23179947227BD3C4DC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A5B77A130E29E274508CC49EB3601048`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `385E216B9263D2115C62C7ECFFEEFDE5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E89E804637FA562B100F0FE4E5046EB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0751238533472E5072E940532A505EF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B9895D1B757B62E271443D1BC6794BF1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C92007728F8C28DE355DA446664D90A4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EFAEF1C834CC10E9380D93CAF238357A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2BA099734BF7213D0D3CDE27FD3A800`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C7DE8B77A201D60D764F8E0B90EE6B88`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `99D573F37C1B83D1EAC9E3A2D74CED0A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F9301518E9C59037F290FD9AB9C6FA1D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8626537344871A211E51484F7C983428`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `84BFF850FC936FB025FCC82576A43B6E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `00445C51BAF286BDE755D56792FEE350`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2BFEEB8EEB21FB50CB6EADD53931609B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6419A207FCB3E2453F9F6823820E3561`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12FF0368070589A64D657BB5202DB15F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2FFF74EEA2CBCDDC53B1E064B287C1EC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D8D429D4DA8C0E7B5FE8A4817472607C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8094E2CAF6E63063E1E641564403FE63`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0DAE535FDED14F86DD000EFAE5BC7D53`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6909941A44264149BB999EA758522DC6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0BABEC62CB291BB2AF4EFD14FC77F678`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D72154F887AE2EC3AE8B7EAB7BED8038`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0A4D93A83FDBEE660072F1933E229E4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD289239CA5393958C5CC98E3A210BE6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8010DF157B24E0C2108A0E7E78FDFD5D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C59C6958E9034A3EF02639EB802A6B00`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D1D6F88D86F039B2CB65687C236D6939`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `378755B8D4C186E12C732E91EC78AD84`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `305BD6FE1CCA72909344D468907C8024`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `24B75C760517817DE76469F4172A6E37`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `84F2B5AC03859B294006A5655F856C35`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DF01D06D86487E84FEBC8DD586F82A04`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EA4A14DDCE4416FAAD5D3651F62FBB96`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8E6CF2F50623AF8F8824FBA878A994BF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `64513490C1AC16D5C9308DF426DCD8CB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5583CB0BF8911E0A866398DE0A9C5BE3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6E567733D07C56618DA03A3F3A4B26E3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DF6C491968707B4FE4D4D297DC882A17`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2A61694686F2BFFC9C44E93F1C0616B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5CB6982A37EB2976867E209D183D31B2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `18EB3CAF205BCF7765AA63ADAAFE2329`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `491CCA596778B012F18F2022DA7A79B9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `59270A22664216C2E2C2F2F23AF8B4E1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0D3AEA0B656E27E5353BFCA2C0006149`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `272B65FA85D69ADFCDB7900922174650`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BE8DB54AF523C1A844A663612A43E0F2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `21FA3DCE43D07F2C24D04FD0189A9F24`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5730786C0D09F446C76714341EA4F6E6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DBE9AB935841B241216A4781FA27AC05`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9E30FE93E2C91B833B8E2C11FEC37F73`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D09D85DD274FCFF4FD908469C23FE425`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C2120BC04C393975D7FDB62B81690880`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `04D570B5E8751F3B4185824DFC4235A0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `03F15A13608A4BD625B6AF15BC3D781B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B8C72EF07B0D526950548F6C93D4936`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AAE3D8B6BE779438D9998FFC1CF0ED0B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6CD25FBE615DD7653F99395811DCC714`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C5E807D40D15A76EACE71CFA0B334DDA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4FBCE23CD3E6D2A44B63E0612A998197`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `40B7BB3B091308348F9DECF47C5958D3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B423659FDDEBFBA87FA2D58E01B784BE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0950F290E440EF4A60EC24B2C40553C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2ACAC7C01E5A2CC3C0EC0B36A5C11786`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `377FCA3335712941ABB8E2E22A902E8A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `23EEC00F100475BAB1FC65DD45540B85`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB5DAF14B5E0E816A8EDA7D98E853A38`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6165FDF91C689E4EED2834EC2083DD56`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `697F19DB9A51DFF1EC22C02AE76FE3F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `65934379969C935D29F6D81264E14E00`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8791D1DA13239DE5561308DEB1FCFDDF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5EFE997FEEBBE375F2BC415F9C21DFC5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FAC712CD540588EFA30768A0AAB98695`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `767006BFFB8CD62CE77CC27462D6C37E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `08D1275CBFE815BB8780CA219076A128`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `98D2FCC7B316862AA692A5111DC48025`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `060AA14388E14DCD13030C91B877B483`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7A4DE6FA3DC807AABC4EC3AD63BB9F61`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `49058FBA1A006E7E8B639028AF4C9DEA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `07EF425D8060E826043A8584403DD78E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F8E9929D4DE00283CE20E904D0166BBD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8E18526D6148135344D294044BEE9DAF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AEA7C93F71DF1261B8362588F266A3EA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8EC7837D6D297481BA161FDF4862F74F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `99CA71181CB481AC08F9AA0C52D60E0B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `97DFADF8CFC7EA3A138B7916E3230093`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A6F75145BEADBF0C727142E22859CEE9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2640C3F4E4321E541C77F3774C60C2C0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D4CA1FE9CA636423C372013BE7EFFD3B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A9CC2919E5B7ED1ABED00D9D9D0E2CE5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CCB918B4C1D6783EBC6CFD3385C5B6A9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2A876C8CBB42B06180A8872D7BB3623`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AFD07BF8D4530CC9B28A44DC269150FB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EB6B44C3BD44ACBB58F5D533EB19AE32`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E10AED3AF11F23DB6DDBE3A2AEF9F949`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `67F64C87133FDDB72C830A922BF5504C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A7CBD3C2C0DD8768C29FF8BF4108F46A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6DD03C265D078D75AF00EB8C8E6B23B1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B333AAAC83CE5553E21F5B0EEDE3CDB9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `54725C78DEF4A6D8CD2958A87B260906`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E74F4B1FB62B3E6B0F8540FA8D0362BB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D394048E36A3A29194E6B5606F371612`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CBB58BA57CBAFA548EB3B72BDECF31E3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `29408CEBECDED43176422D8335B667AB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F3F27D8AF796D5F9536B160BFCBD8D35`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AE5B902B8C42222F117DDFE687D6BD11`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B7450A309C325740F8BB5C79E406C423`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2DC94CDC8EEC086A265EEFDC31E9637C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2EB10D262C46DD46E7E81175EBF4426C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BE83F9308A33141E05B704C9D22EC736`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E735E953A76A051AC54EABE11FF5A7B4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6DA6F84DBA1E29CDB43A073C84E4927D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6A7F1F6F58D9EED133E22BD0457B59B5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `103FE2CC0A115CF8C9204DD70F94B01E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B317602E2ABC641ECBB85077EEC1FF85`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1DDDB6B29B1BF1C772338CAB3E3D702D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6478FEF1F20C7BFBFC1FEE833C31F485`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3F32203A856CAF0F5982108F0825BE40`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9239169C8913C2482F4379AE0D2013D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D69B3DC743FD7A529BEC0DC1CB2AB7DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB83FD98575F8459FEC854F2E5B7047E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4DDB4B5BE5621B407A16968F733B6FFC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `16743A1E4F837C6EE41A344558C7DA8E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `52478C52D0041B548BF9F6FE60B43F5C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1374891BA8ED474B969198D74F4B6307`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4004CCFC3143632A326A875D663D4E5F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BAF24812738FFA78BCC451FC2F93E913`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `013F513244F31E2CD1438E2DD4799E5B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF439FB550691308DAE9DF88B2436319`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4C674DC7F101BCD70FDAF0CE6D1FA39E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `88905E7E03E0B53CD528737B3C499862`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DBD324B14E54A18B99F43BFF4CAC513A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AA5EA53923537E66951806BFFD3DEEBD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C37FAF7E19EF040B79025C6C47D832EB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9D481B123943036072F2716FFB0C7229`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1E098D950DD91028448C1B6029F0A81E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1CAF5F47A308965A8072126458BAC504`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2F46A5D52F7A07B437850AF813B49101`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `17D164E4A56A4CD2017C30C6EAAA80F3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `48AAE10D7E005571ADF9001CD07FE020`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9A08E2792B159748F3BE67CB94A67B65`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `72305D78B04FE41AA0A48ED0877E5786`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B3434830C1CB8501AB295981802E37D2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `49C5711BF4A547F7A32BDEF83419A7CF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD1ED7B728B36850A6A3B6CD7C6F2321`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A6A3A5FF58093E862931485E7D3BF33F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `180B9F4986BDFE6D4F137B79C48F4F38`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0AAB6F8900A64ABA840D71444505AD70`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F981303AFA88D38F4789A38001F28DB2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `82C294A40E93669721154125059F7201`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4455BE8910499D820D76526721D02AC8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F36B09E375CA6DFEA69438F23B09FDFB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8A7748B554DD259E63C756F1A04FA823`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2549A3E3BF977C2F62753758D3394B4C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `66DC423AB8FD900D1D2AC7F7962B9D2C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B097A678F708B00B2E57A329F1330CB7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2C6A8B7D962CBF78047784F75C040872`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `69C1F12348842D32513A0B073953B433`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BF60F1421B50AAAA52A64559C44A1817`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CE83D3288BEE81A94AFEBF2BA6FE151E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `611E921AF6DFECD184C940E604BE93D4`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `754B4A785D91BB98E5867CBD7CE81ACF`,
		Secure: `B334F52E0C9F49F205A415277B47B00E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `C0F2BCED9EE960A7BBF2676E13265448`,
		Secure: `80A267E8955407D52264C83F56C3D4AD`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `E1E8D1C9BE76F33E0CBFBE2B9575ECF8`,
		Secure: `190518F60B7F12684B51C4D698F0D810`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `7062EAE725FF2449104382F20BB932EA`,
		Secure: `F8D36452C1D68B34189E9BFCA7A1242E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `47D5A9657B88E4F54112F4FFBC18B96C`,
		Secure: `CD13E1C95DFC6D855BF9DEF80884917B`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `7FF6EEA0AA5665B0560294CF34F6510A`,
		Secure: `5F872327B9767D84914C6297FDFCC9ED`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `70BADA36DCEE18264A26252139F90B92`,
		Secure: `7F3CA8DB95880E48D857103AAF7613A1`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `B555CF027815AE4455D6A6EFD7063812`,
		Secure: `5669D23026B71B1FA57FE715DC22E593`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `253D6D2228D11737F0A55978544169D4`,
		Secure: `457062CE83A896BAD771CFE1D2AAAE7E`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `D92895F4D665846DD568BF393B106F68`,
		Secure: `4CA25976E50593661C68586B2724D585`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `2C096913A9586792FB3498EE55185C99`,
		Secure: `B981B21B71CFC7368937E4EAA65A0602`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `B516485D0B6E71939D5FE795AA3D7F76`,
		Secure: `A675A75827B59FF887A8E4805CD465FE`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `4DC4D6F0A5AC929D337DEB6A83A56B4A`,
		Secure: `D96284CA739A524BABA568AA24ADB436`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `0FC8F1276057FC1E766426EB6AB5EFA2`,
		Secure: `698244354C41A63DBFBD6ABCC252EB7F`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `5217BCA165F420C2602859D528111E4D`,
		Secure: `9145BAB3DDC1347F5498AF6AF444A2D8`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `B0E598391D49AE76281F8523C49F4756`,
		Secure: `9792BB52CEB674038BDF3C66C63539F6`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `01A9240D3159976849DDEB158A83FD0B`,
		Secure: `014562B934797C950589B29B38CFDC63`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `6016437B8A6B0D037B370B26002310F9`,
		Secure: `8E5E7050923B1BAEE5E1A7817544BED2`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `2423151E510381F6B743A813F12491EC`,
		Secure: `7CD9B60A15C7468BA57108742141B6B7`,
	},
	{
		Key:    `0000000000000000000000000000000000000000000000000000000000000000`,
		Plain:  `E603FCD5EEE6A32E3755C1DA666BD1F3`,
		Secure: `BC2637D1B2B3785A039E343E12484789`,
	},
}
