package hight

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_HIGHT_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases, false) }
func Test_HIGHT_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases, false) }

var testCases = []BlockTestCase{
	// TTAK.KO-12.0040_R1
	// p. 21
	// Ⅰ.1. 참조구현값 1
	{
		Reverse: true,
		Key:     `00 11 22 33 44 55 66 77 88 99 aa bb cc dd ee ff`,
		Plain:   `00 00 00 00 00 00 00 00`,
		Secure:  `00 f4 18 ae d9 4f 03 f2`,
	},
	// p. 22
	// Ⅰ.2. 참조구현값 2
	{
		Reverse: true,
		Key:     `ff ee dd cc bb aa 99 88 77 66 55 44 33 22 11 00`,
		Plain:   `00 11 22 33 44 55 66 77`,
		Secure:  `23 ce 9f 72 e5 43 e6 d8`,
	},
	// p. 23
	// Ⅰ.3. 참조구현값 3
	{
		Reverse: true,
		Key:     `00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f`,
		Plain:   `01 23 45 67 89 ab cd ef`,
		Secure:  `7a 6f b2 a2 8d 23 f4 66`,
	},
	// p. 24
	// Ⅰ.4. 참조구현값 4
	{
		Reverse: true,
		Key:     `28 db c3 bc 49 ff d8 7d cf a5 09 b1 1d 42 2b e7`,
		Plain:   `b4 1e 6b e2 eb a8 4a 14`,
		Secure:  `cc 04 7a 75 20 9c 1f c6`,
	},
	//////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// HIGHT(ECB)KAT.txt
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `8000000000000000`,
		Secure: `D2B366EE33648CCE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C000000000000000`,
		Secure: `C6FB1015230CC831`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `E000000000000000`,
		Secure: `4996F36EFA10A200`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F000000000000000`,
		Secure: `5A32EF79EF37F039`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F800000000000000`,
		Secure: `C27C45DB4826B081`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FC00000000000000`,
		Secure: `407DC4E6E2665373`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FE00000000000000`,
		Secure: `C943005CB54AC89A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF00000000000000`,
		Secure: `B240870B46532CCC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF80000000000000`,
		Secure: `274EB5A1E6C51720`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFC0000000000000`,
		Secure: `79C27255AB7525BA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFE0000000000000`,
		Secure: `23626A73A12D9837`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF0000000000000`,
		Secure: `BA8291096591F1B5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF8000000000000`,
		Secure: `F2375F5348192814`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFC000000000000`,
		Secure: `3B7430404A635B43`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFE000000000000`,
		Secure: `3AA1A277D46CE103`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF000000000000`,
		Secure: `B59B79BEF5780981`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF800000000000`,
		Secure: `E501F77D7F3A02E2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFC00000000000`,
		Secure: `EDEE202D0DF9FC2D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFE00000000000`,
		Secure: `98FA099FA226A026`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF00000000000`,
		Secure: `DAD7E68A5D93780E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF80000000000`,
		Secure: `F4B615C18C65F1FB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFC0000000000`,
		Secure: `77A915ADB6B9B87B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFE0000000000`,
		Secure: `D0184F72DDBABE5E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF0000000000`,
		Secure: `43C504F4A4206A4D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF8000000000`,
		Secure: `66CCEB19928DF1DA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFC000000000`,
		Secure: `106D1188E8019698`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFE000000000`,
		Secure: `A16B66FB2592AAB7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF000000000`,
		Secure: `95FCF3F11621DF7F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF800000000`,
		Secure: `AEE21298344AA294`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFC00000000`,
		Secure: `E5D6317B1F6F9CC2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFE00000000`,
		Secure: `E37441CDC14ACC83`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF00000000`,
		Secure: `7E56698097CC82CD`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF80000000`,
		Secure: `EDC413DA94D2E9AF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFC0000000`,
		Secure: `59FB312B17848FC9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFE0000000`,
		Secure: `0EFE10D71BBB1028`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF0000000`,
		Secure: `CD5F1F5EE6E77855`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF8000000`,
		Secure: `4D53398F007A2189`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC000000`,
		Secure: `7F842438056A6669`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE000000`,
		Secure: `D12A323909B676DA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF000000`,
		Secure: `FBDC729AEDC6752F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF800000`,
		Secure: `9D15343AA1D0E4F6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC00000`,
		Secure: `5367E70AF3A05574`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE00000`,
		Secure: `B6A198540C60481C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF00000`,
		Secure: `BE196FA98F01A1E2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF80000`,
		Secure: `2E5EAFADEA9A7BBE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC0000`,
		Secure: `5DBBF5B44271384C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE0000`,
		Secure: `BA6DCE6D958D5FA6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF0000`,
		Secure: `7660DC3193941B36`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF8000`,
		Secure: `9184BC7B9A9F33B3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC000`,
		Secure: `AB660E01B7789D6F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE000`,
		Secure: `B00446094A5300F4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF000`,
		Secure: `5AE010C0B545C7C9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF800`,
		Secure: `DBD573FC610D614F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC00`,
		Secure: `41A75FAF0651C5E8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE00`,
		Secure: `1C3DB400B8C1D163`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF00`,
		Secure: `7681D3FEDC95C0F8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF80`,
		Secure: `2E5F875423A6D155`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC0`,
		Secure: `E4BB3D7BEB1FC86B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE0`,
		Secure: `D5C348E79F3508BC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF0`,
		Secure: `A630D1CF46CB999B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF8`,
		Secure: `87220E6D3BABECC3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC`,
		Secure: `A2FF263EF5DA956A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE`,
		Secure: `C682008189164C13`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF`,
		Secure: `2CFFE4FF7938F7C0`,
	},
	{
		Key:    `80000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `689DB471543EA251`,
	},
	{
		Key:    `C0000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `FFC04D151996D7AE`,
	},
	{
		Key:    `E0000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `FE5BA236C62BD3D3`,
	},
	{
		Key:    `F0000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `6F5015A86E539A69`,
	},
	{
		Key:    `F8000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `618D8E99D1D994FD`,
	},
	{
		Key:    `FC000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `0014C6AF72089C84`,
	},
	{
		Key:    `FE000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `31D234588FA1DD75`,
	},
	{
		Key:    `FF000000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `FB938357E2E3C5C8`,
	},
	{
		Key:    `FF800000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `FA0B03AB02062385`,
	},
	{
		Key:    `FFC00000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `AD582459CE145C06`,
	},
	{
		Key:    `FFE00000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `7180278EA10D1F39`,
	},
	{
		Key:    `FFF00000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `759294264B00B60B`,
	},
	{
		Key:    `FFF80000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2B40B9330BDFD431`,
	},
	{
		Key:    `FFFC0000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `B523D37C7700F80A`,
	},
	{
		Key:    `FFFE0000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `E6634E05204AFC8B`,
	},
	{
		Key:    `FFFF0000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `00B852841E52A500`,
	},
	{
		Key:    `FFFF8000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `38F0CBE653586A1D`,
	},
	{
		Key:    `FFFFC000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `7957599D06476489`,
	},
	{
		Key:    `FFFFE000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `F366E7EE806DD8E2`,
	},
	{
		Key:    `FFFFF000000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `EF466A630C4EA3CA`,
	},
	{
		Key:    `FFFFF800000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `6D68D425FE466983`,
	},
	{
		Key:    `FFFFFC00000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2BBA62781718967F`,
	},
	{
		Key:    `FFFFFE00000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `9A48E7348ACA78F2`,
	},
	{
		Key:    `FFFFFF00000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `CCA8B7CF972FEEA8`,
	},
	{
		Key:    `FFFFFF80000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `0BC7F645E439CBFE`,
	},
	{
		Key:    `FFFFFFC0000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `6B17CC2F07D50CE4`,
	},
	{
		Key:    `FFFFFFE0000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `F41C1F8D1990D156`,
	},
	{
		Key:    `FFFFFFF0000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `27B1D169B572D1FF`,
	},
	{
		Key:    `FFFFFFF8000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `5116DB6D3A5D386A`,
	},
	{
		Key:    `FFFFFFFC000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `52493EB7A4223D67`,
	},
	{
		Key:    `FFFFFFFE000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `157C173910462B8A`,
	},
	{
		Key:    `FFFFFFFF000000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `DF5FD74E4CD15050`,
	},
	{
		Key:    `FFFFFFFF800000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `7352CDAA640943CF`,
	},
	{
		Key:    `FFFFFFFFC00000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `C35DF749D46882A9`,
	},
	{
		Key:    `FFFFFFFFE00000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3DD2DF5F888A0345`,
	},
	{
		Key:    `FFFFFFFFF00000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `DF25C0B6EFDACE1D`,
	},
	{
		Key:    `FFFFFFFFF80000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `C966B212515F14E5`,
	},
	{
		Key:    `FFFFFFFFFC0000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2F063EF30D59EB46`,
	},
	{
		Key:    `FFFFFFFFFE0000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `994A1FB7A18A030D`,
	},
	{
		Key:    `FFFFFFFFFF0000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `78895B803253450A`,
	},
	{
		Key:    `FFFFFFFFFF8000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `1BA2A3E73797D6DE`,
	},
	{
		Key:    `FFFFFFFFFFC000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `CF00447566123EFC`,
	},
	{
		Key:    `FFFFFFFFFFE000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `4721F81D045A219E`,
	},
	{
		Key:    `FFFFFFFFFFF000000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `8E436F001945A175`,
	},
	{
		Key:    `FFFFFFFFFFF800000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2B5EA8B643C03271`,
	},
	{
		Key:    `FFFFFFFFFFFC00000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `859DD60FAFC06CBC`,
	},
	{
		Key:    `FFFFFFFFFFFE00000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `7C815A6F59CA30D9`,
	},
	{
		Key:    `FFFFFFFFFFFF00000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `FABD5F00B205917E`,
	},
	{
		Key:    `FFFFFFFFFFFF80000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `0F096D670CA5844B`,
	},
	{
		Key:    `FFFFFFFFFFFFC0000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `BBAEAC969FE8469C`,
	},
	{
		Key:    `FFFFFFFFFFFFE0000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `0044A84CB41960BD`,
	},
	{
		Key:    `FFFFFFFFFFFFF0000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3D65FBAAA4E0845A`,
	},
	{
		Key:    `FFFFFFFFFFFFF8000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3000A49FDC7548F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFC000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3B34B9FEE6DB12C4`,
	},
	{
		Key:    `FFFFFFFFFFFFFE000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3F2471D143F60AC1`,
	},
	{
		Key:    `FFFFFFFFFFFFFF000000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `B97A37B5660C52FE`,
	},
	{
		Key:    `FFFFFFFFFFFFFF800000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `50AD1E59F990FD57`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `31694AB026FAA3B3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `447730C6421C39C5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `B1EDFFCEA8F5DBEF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `4DEEDAB4BA76E952`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `499D672BEB6AF09C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `25644529D67AD993`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `C5CFFB53D711799E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2939DB3DAEE5E09A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `45E1E8A6E038BBFC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `0C7A1363F45F0503`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `0000000000000000`,
		Secure: `22BB26CC7D2F0198`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `0000000000000000`,
		Secure: `E2071CA91D33976B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `0000000000000000`,
		Secure: `AAC1EC29B3CB9157`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `0000000000000000`,
		Secure: `2B8A686D43B73C7F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `0000000000000000`,
		Secure: `5817E151C33574A0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `0000000000000000`,
		Secure: `4EFBD547328D0884`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `0000000000000000`,
		Secure: `14AE645F897334D6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `0000000000000000`,
		Secure: `10EB53CC021F6979`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `0000000000000000`,
		Secure: `825CAD8451D365EA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `0000000000000000`,
		Secure: `3DA0138BD57125DF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `0000000000000000`,
		Secure: `8840F61B69F2AD37`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `0000000000000000`,
		Secure: `20BF64B55B401BC9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `0000000000000000`,
		Secure: `BC01D24BC626D6BA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `0000000000000000`,
		Secure: `2AC8FA8B5EAFECF4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `0000000000000000`,
		Secure: `A4259D5A2EDEE313`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `0000000000000000`,
		Secure: `5D4005ADAEE7DF04`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `0000000000000000`,
		Secure: `D28853BE7AF74B90`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `0000000000000000`,
		Secure: `3134F0F1A10448C7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `0000000000000000`,
		Secure: `4E05A0308156F8F0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `0000000000000000`,
		Secure: `325698888AC48513`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `0000000000000000`,
		Secure: `48B2B9422A13BE17`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `0000000000000000`,
		Secure: `E08ED667CDD9041C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `0000000000000000`,
		Secure: `A355C73358CA251C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `0000000000000000`,
		Secure: `98E2E9848D8C0144`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `0000000000000000`,
		Secure: `7F6B6F466D2DD369`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `0000000000000000`,
		Secure: `415E4101E78AE3B6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `0000000000000000`,
		Secure: `4FC53722C90B9AD9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `0000000000000000`,
		Secure: `94BE38F099EF7E49`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `0000000000000000`,
		Secure: `880BB83ED9B403BB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `0000000000000000`,
		Secure: `97604D34A836176E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `0000000000000000`,
		Secure: `53BB0964CBBE73D0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `0000000000000000`,
		Secure: `E1E4042B6879E957`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `0000000000000000`,
		Secure: `F3AECC6016435BB8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `0000000000000000`,
		Secure: `4AED3D640549D7FE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `0000000000000000`,
		Secure: `0483DB5A0DF14016`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `0000000000000000`,
		Secure: `769B70A80F0F679E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `0000000000000000`,
		Secure: `1BBCEF870305DF38`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `0000000000000000`,
		Secure: `6F0AD1CBDD56F2FB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `0000000000000000`,
		Secure: `39E83DF7DA20C5DD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `0000000000000000`,
		Secure: `4CB8E03FE4336E14`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `0000000000000000`,
		Secure: `36EC87377CDC5493`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `0000000000000000`,
		Secure: `EF032FB652A0D7D0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `0000000000000000`,
		Secure: `08F9D570A0AA9EA7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `0000000000000000`,
		Secure: `847D8692AB8AC657`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `0000000000000000`,
		Secure: `AED4D3318F2D8608`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `0000000000000000`,
		Secure: `1ED7AA3BC301F87A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `0000000000000000`,
		Secure: `E773080EA5AB4919`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `0000000000000000`,
		Secure: `BDDCF059D3B84322`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `0000000000000000`,
		Secure: `3C6ED713176FD619`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `0000000000000000`,
		Secure: `CF153E8D2BC7E64A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `0000000000000000`,
		Secure: `66138F4DB448F4C2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `0000000000000000`,
		Secure: `7302DC25904F93D1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `0000000000000000`,
		Secure: `438E45925E710EEE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `0000000000000000`,
		Secure: `85DDA75AA7C1BF7A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `0000000000000000`,
		Secure: `0695F224F29DA9DE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `0000000000000000`,
		Secure: `DB2A64467C5EBC2F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `0000000000000000`,
		Secure: `E8790E2442E6B224`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `0000000000000000`,
		Secure: `2DF03D95E29441DD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `0000000000000000`,
		Secure: `F3A9353685BCEE6F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `0000000000000000`,
		Secure: `5311B20593300E76`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `0000000000000000`,
		Secure: `802395603C089EBA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `78471277A7E8E428`,
		Secure: `49B584704B58387D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `6482E8E9F78BCB89`,
		Secure: `075C538007884EC8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `82EBE2D23662070E`,
		Secure: `8362EDDCB792A66C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C624A4CA1CC70DD9`,
		Secure: `7B9C23C66A8FBC97`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `4C5F139CC6E8D681`,
		Secure: `72E64419D3F33CE1`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `CFE4DACA32445D90`,
		Secure: `392ADDB05E85EA6B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `328CE807C4332503`,
		Secure: `4B4E3881B3DC4B9A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FB48F0BBC45CB0CD`,
		Secure: `1DE2F9A7F3D4BDDB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `D39BE883DD3C0955`,
		Secure: `0D40068770A7132E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `081C8BAFA0A53BF4`,
		Secure: `835BDF5486520C78`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `0BF5D7C2FF3CD878`,
		Secure: `F8BDEC208B42DED5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F2668FF5D2FB73A3`,
		Secure: `DF46E61C749EF745`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F743BAB556AD26AC`,
		Secure: `6CAD68280131ABEB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F7712220A9750DBD`,
		Secure: `19178991061FAA0A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F46ED68C4F47C973`,
		Secure: `D7C56CCC3CB291FC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `93C6A800B06DFE62`,
		Secure: `D456A893BCE8286D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `9E9EB0B89703D58F`,
		Secure: `5357126F7EB9F286`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `842DC7A5B57B7AF3`,
		Secure: `6E950F179E145921`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `D43E0DEB1C1A9FFF`,
		Secure: `4B3FEFE2FE66F72D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C6B06462C479F812`,
		Secure: `2207624A6B6A54CF`,
	},
}
